/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.security.InvalidParameterException;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassItem;

public class InstructionBuilder
extends InstructionFactory {
    public InstructionBuilder(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        super(classGen, constantPoolGen);
    }

    public ConstantPoolGen getConstantPoolGen() {
        return this.cp;
    }

    public CompoundInstruction createLoadConstant(int n) {
        return new PUSH(this.cp, n);
    }

    public CompoundInstruction createLoadConstant(String string) {
        return new PUSH(this.cp, string);
    }

    public CompoundInstruction createLoadConstant(Object object) {
        if (object instanceof Boolean) {
            return new PUSH(this.cp, (Boolean)object);
        }
        if (object instanceof Character) {
            return new PUSH(this.cp, (Character)object);
        }
        if (object instanceof Number) {
            return new PUSH(this.cp, (Number)object);
        }
        throw new InvalidParameterException("Internal code generation error!");
    }

    public FieldInstruction createGetField(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        return new GETFIELD(this.cp.addFieldref(string, string2, classItem.getSignature()));
    }

    public FieldInstruction createPutField(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        return new PUTFIELD(this.cp.addFieldref(string, string2, classItem.getSignature()));
    }

    public FieldInstruction createGetStatic(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        return new GETSTATIC(this.cp.addFieldref(string, string2, classItem.getSignature()));
    }

    public FieldInstruction createPutStatic(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        return new PUTSTATIC(this.cp.addFieldref(string, string2, classItem.getSignature()));
    }

    public InvokeInstruction createCallStatic(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        int n = this.cp.addMethodref(string, string2, classItem.getSignature());
        return new INVOKESTATIC(n);
    }

    public InvokeInstruction createCallVirtual(ClassItem classItem) {
        String string = classItem.getClassFile().getName();
        String string2 = classItem.getName();
        int n = this.cp.addMethodref(string, string2, classItem.getSignature());
        return new INVOKEVIRTUAL(n);
    }

    public InvokeInstruction createCallStatic(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        int n2 = this.cp.addMethodref(string3, string4, string2);
        return new INVOKESTATIC(n2);
    }

    public InvokeInstruction createCallVirtual(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        int n2 = this.cp.addMethodref(string3, string4, string2);
        return new INVOKEVIRTUAL(n2);
    }

    public InvokeInstruction createCallInterface(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        return this.createInvoke(string3, string4, Type.getReturnType((String)string2), Type.getArgumentTypes((String)string2), (short)185);
    }

    public InvokeInstruction createCallInit(String string, String string2) {
        int n = this.cp.addMethodref(string, "<init>", string2);
        return new INVOKESPECIAL(n);
    }
}

