/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.HashMap;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassItem {
    protected static HashMap s_signatureMap = new HashMap();
    protected ClassFile m_classFile;
    protected String m_name;
    protected String m_signature;
    protected String m_typeName;
    protected String[] m_argTypes;
    protected FieldOrMethod m_item;

    public ClassItem(String string, ClassFile classFile, FieldOrMethod fieldOrMethod) {
        this.m_classFile = classFile;
        this.m_name = string;
        this.m_item = fieldOrMethod;
        String string2 = this.m_signature = fieldOrMethod.getSignature();
        if (fieldOrMethod instanceof Method) {
            this.m_typeName = Utility.methodSignatureReturnType((String)this.m_signature, (boolean)false);
            this.m_argTypes = Utility.methodSignatureArgumentTypes((String)this.m_signature, (boolean)false);
        } else {
            this.m_typeName = Utility.signatureToString((String)this.m_signature, (boolean)false);
        }
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getArgumentType(int n) {
        if (this.m_item instanceof Method) {
            return this.m_argTypes[n];
        }
        return null;
    }

    public int getAccessFlags() {
        return this.m_item.getAccessFlags();
    }

    public void setAccessFlags(int n) {
        this.m_item.setAccessFlags(n);
        this.m_classFile.setModified();
    }

    public String getSignature() {
        return this.m_signature;
    }

    public boolean isMethod() {
        return this.m_item == null || this.m_item instanceof Method;
    }

    public String[] getExceptions() {
        ExceptionTable exceptionTable;
        if (this.m_item instanceof Method && (exceptionTable = ((Method)this.m_item).getExceptionTable()) != null) {
            return exceptionTable.getExceptionNames();
        }
        return null;
    }

    public static boolean isPrimitive(String string) {
        return s_signatureMap.get(string) != null;
    }

    public static ClassItem findVirtualMethod(String string, String[] stringArray) throws JiBXException {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ClassFile classFile = ClassCache.getInstance().getClass(string2, false);
        int n2 = 0;
        while (n2 < stringArray.length) {
            ClassItem classItem = classFile.getMethod(string3, stringArray[n2]);
            if (classItem != null) {
                return classItem;
            }
            ++n2;
        }
        return null;
    }

    public static ClassItem findStaticMethod(String string, String[] stringArray) throws JiBXException {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ClassFile classFile = ClassCache.getInstance().getClass(string2, false);
        int n2 = 0;
        while (n2 < stringArray.length) {
            ClassItem classItem = classFile.getStaticMethod(string3, stringArray[n2]);
            if (classItem != null) {
                return classItem;
            }
            ++n2;
        }
        return null;
    }

    public static String[] getSignatureVariants(String string) throws JiBXException {
        Object v = s_signatureMap.get(string);
        if (v == null) {
            ClassFile classFile = ClassCache.getInstance().getClass(string, false);
            return classFile.getInstanceSigs();
        }
        return (String[])v;
    }

    public static boolean isAssignable(String string, String string2) throws JiBXException {
        if (string.equals(string2)) {
            return true;
        }
        Object v = s_signatureMap.get(string);
        Object v2 = s_signatureMap.get(string2);
        if (v == null && v2 == null) {
            ClassFile classFile = ClassCache.getInstance().getClass(string, false);
            String[] stringArray = classFile.getInstanceSigs();
            String string3 = Utility.getSignature((String)string2);
            int n = 0;
            while (n < stringArray.length) {
                if (string3.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (v != null && v2 != null) {
            String[] stringArray = (String[])v;
            String[] stringArray2 = (String[])v2;
            if (stringArray2.length == 1) {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] == stringArray2[0]) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
        return false;
    }

    static {
        s_signatureMap.put("boolean", new String[]{"Z"});
        s_signatureMap.put("byte", new String[]{"B", "S", "I"});
        s_signatureMap.put("char", new String[]{"C", "I"});
        s_signatureMap.put("double", new String[]{"D"});
        s_signatureMap.put("float", new String[]{"F"});
        s_signatureMap.put("int", new String[]{"I"});
        s_signatureMap.put("long", new String[]{"J"});
        s_signatureMap.put("short", new String[]{"S", "I"});
        s_signatureMap.put("void", new String[]{"V"});
    }
}

