/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Method;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;

public abstract class BindingMethod {
    protected ClassFile m_classFile;

    protected BindingMethod(ClassFile classFile) {
        this.m_classFile = classFile;
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public abstract String getName();

    public abstract String getSignature();

    public abstract int getAccessFlags();

    public abstract void setAccessFlags(int var1);

    public abstract Method getMethod();

    public abstract ClassItem getItem();

    public void makeAccessible(ClassFile classFile) {
        int n = this.getAccessFlags();
        if ((n & 1) == 0) {
            ClassFile classFile2 = this.getClassFile();
            if (classFile2.getPackage().equals(classFile.getPackage())) {
                if ((n & 2) != 0) {
                    n -= 2;
                }
            } else {
                ClassFile classFile3 = classFile;
                while ((classFile3 = classFile3.getSuperFile()) != null) {
                    if (classFile3 == classFile2) break;
                }
                if (classFile3 == null) {
                    int n2 = 6;
                    n = n & ~n2 | 1;
                } else if ((n & 4) == 0) {
                    n = n & 0xFFFFFFFD | 4;
                }
            }
            if (n != this.getAccessFlags()) {
                this.setAccessFlags(n);
            }
        }
    }

    public static int computeMethodHash(Method method) {
        int n;
        Object[] objectArray;
        int n2 = method.getSignature().hashCode();
        ExceptionTable exceptionTable = method.getExceptionTable();
        if (exceptionTable != null) {
            objectArray = exceptionTable.getExceptionNames();
            n = 0;
            while (n < objectArray.length) {
                n2 += objectArray[n].hashCode();
                ++n;
            }
        }
        objectArray = method.getCode().getCode();
        n = 0;
        while (n < objectArray.length) {
            n2 = n2 * 49 + objectArray[n];
            ++n;
        }
        return n2;
    }

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (object instanceof BindingMethod) {
            BindingMethod bindingMethod = (BindingMethod)object;
            if (this.hashCode() == bindingMethod.hashCode() && this.getSignature().equals(bindingMethod.getSignature())) {
                return ClassFile.equalMethods(this.getMethod(), bindingMethod.getMethod());
            }
        }
        return false;
    }
}

