/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ProblemUnmarshalable;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public class Board
extends Canvas
implements BoardView,
ProblemUnmarshalable {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private static final Point NO_CLICKED;
    private Model mModel = NullModel.getInstance();
    private SolverHandler mHandler;
    private DefaultRenderer mRenderer;
    private BoardView mParent;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand;

    public void loadProblem(File inFile, ProblemInfo inInfo) {
        this.load(inInfo);
    }

    public void initialize() {
        System.out.println("init");
        this.mModel = NullModel.getInstance();
        this.mRenderer = RendererFactory.create(9, 9);
        this.setBackground(AppColors.BACK_COLOR);
        this.createBoard(9, 9);
        PieceSizeCommand aCommand = new PieceSizeCommand(this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    public void processCommand(Command inCommand) {
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed() && inCommand instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(inCommand);
        }
    }

    protected void processCommandImpl(Command inCommand) {
        Class<?> aClass = inCommand.getClass();
        if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand)) {
            int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
            int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
            this.setComponentSize(aWidth, aHeight);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand)) {
            this.mHandler.nextSolute();
            inCommand.consume();
            if (this.mModel.isModified()) {
                Rectangle aBounds = this.getClipBounds();
                this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand)) {
            try {
                this.mHandler.nextSoluteAll();
                inCommand.consume();
            }
            catch (SolveDiscompleteException e) {
                System.out.println(e);
            }
            if (this.mModel.isModified()) {
                Rectangle aBounds = this.getClipBounds();
                this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }
    }

    public void setParent(BoardView inBoard) {
        this.mParent = inBoard;
    }

    public void load(ProblemInfo inInfo) {
        System.out.println("set problem");
        if (null == inInfo) {
            throw new IllegalArgumentException("pass null object to inInfo");
        }
        if (this.mModel instanceof NullModel) {
            this.mModel = new BoardModel(this.mModel);
            this.mHandler = new HashikakeSolverHandler(this.mModel);
        }
        this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        this.mModel.setProblem(inInfo);
        this.mHandler.reset();
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    public void createBoard(int inWidth, int inHeight) {
        this.mRenderer.setSize(inWidth, inHeight);
        this.mModel.createBoard(inWidth, inHeight);
        Dimension aSize = this.mRenderer.getBoardSize();
        BoardSizeCommand aCommand = new BoardSizeCommand(this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    public int getBoardWidth() {
        return this.mModel.getWidth();
    }

    public int getBoardHeight() {
        return this.mModel.getHeight();
    }

    public void save(File inFile) {
        throw new UnsupportedOperationException("This view isnot supported save method.");
    }

    public boolean check() {
        return this.mModel.check();
    }

    public boolean isModified() {
        return false;
    }

    public Component getComponent() {
        return this;
    }

    public void setTitle(String inTitle) {
        this.mParent.setTitle(inTitle);
    }

    public int getPieceSize() {
        return this.mRenderer.getPieceSize().width;
    }

    public void setComponentSize(int inWidth, int inHeight) {
        this.setSize(inWidth, inHeight);
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    public void clear() {
        this.mModel.reset();
        this.mHandler.reset();
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    private Point calcPortToBoardPos(int inX, int inY) {
        return this.mRenderer.calcPortToBoardPos(inX, inY);
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    public void paint(Graphics inGra) {
        Rectangle aBounds = inGra.getClipBounds();
        if (this.mModel.isModified()) {
            aBounds = new Rectangle();
            Point[] aPos = this.mModel.lastModified();
            int i = 0;
            while (i < aPos.length) {
                this.mRenderer.render(aPos[i].x, aPos[i].y, this.mModel.getCurStateAt(aPos[i].x, aPos[i].y));
                ++i;
            }
            aBounds = this.getClipBounds();
        }
        inGra.drawImage(this.mRenderer.getImage(), aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, this);
        this.mModel.flush();
    }

    private Rectangle getClipBounds() {
        return this.mRenderer.getClipBounds(this.mModel.lastModified());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_BOARD_WIDTH = 9;
        DEFAULT_BOARD_HEIGHT = 9;
        NO_CLICKED = ModelConstants.ILLEGAL_POS;
    }
}

