/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverRI_2
implements SolverHandler {
    private static final State sStartState = new StartState();
    private static final State sProcessingState = new ProcessState();
    private static final State sBuildDisable = new DisableState();
    private static final State sFinishedState = new FinishState();
    private static final int NUM_PER_DIRECTION = 2;
    private Map mRecords;
    private List mQueue;
    private Model mModel;
    private static final Direction[] DIRECTIONS;

    public SolverRI_2(Model inModel) {
        this.mModel = inModel;
    }

    public void reset() {
        this.mQueue = new LinkedList();
        this.mRecords = new HashMap();
        int y = 0;
        while (y < this.mModel.getHeight()) {
            int x = 0;
            while (x < this.mModel.getWidth()) {
                Point aPos = new Point(x, y);
                if (this.mModel.isNumberAt(x, y)) {
                    this.mQueue.add(aPos);
                    int aCount = 0;
                    try {
                        aCount = Integer.parseInt(StateManager.getInstance().findIdentityOf(this.mModel.getCurStateAt(aPos.x, aPos.y)));
                        SolverRecord aRec = new SolverRecord(aPos, aCount);
                        this.initSolverRecord(aRec);
                        this.mRecords.put(aPos, aRec);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean isSolute() {
        return this.mQueue.isEmpty();
    }

    public void nextSolute() {
        if (this.isSolute()) {
            return;
        }
        Point aPos = (Point)this.mQueue.remove(0);
        this.attemptBuild(aPos.x, aPos.y);
    }

    public void nextSoluteAll() throws SolveDiscompleteException {
        if (this.mQueue.isEmpty()) {
            return;
        }
        int aCount = 0;
        do {
            Point aPos = (Point)this.mQueue.remove(0);
            if (!this.attemptBuild(aPos.x, aPos.y)) {
                if (this.mQueue.size() != ++aCount) continue;
                throw new SolveDiscompleteException(this.mQueue.size());
            }
            aCount = 0;
        } while (!this.isSolute());
    }

    private boolean attemptBuild(int inX, int inY) {
        Point aPos = new Point(inX, inY);
        SolverRecord aRec = this.getSolverRecord(aPos);
        boolean aRet = false;
        do {
            int i;
            this.updateSolverRecord(aRec);
            if (this.isFinishedState(aRec.mState)) {
                return true;
            }
            aRet = false;
            if (this.available_1(aRec)) {
                int aNumPerDir = 2 - (aRec.mOppositeCount * 2 - aRec.mResidue);
                i = 0;
                while (i < aRec.mMaxOppositeCount) {
                    aRet |= this.buildBridge(aRec, aNumPerDir, i);
                    ++i;
                }
            } else {
                if (!this.available_2(aRec)) continue;
                int aSum = this.accumulateAroundMax(aRec);
                i = 0;
                while (i < aRec.mMaxOppositeCount) {
                    if (!this.isFinishedState(aRec.mOpposite[i].mState)) {
                        SolverRecord aAgainstRec = this.getSolverRecord(aRec.mOpposite[i].mPos);
                        int aCount = aAgainstRec.mMaxBuildCount;
                        if (aSum - aCount <= aRec.mResidue) {
                            aRet |= this.buildBridge(aRec, 1, i);
                        }
                    }
                    ++i;
                }
            }
        } while (aRet);
        if (!this.isFinishedState(aRec.mState)) {
            this.mQueue.add(aPos);
        }
        return aRet;
    }

    private SolverRecord getSolverRecord(Point inPos) {
        SolverRecord aSolverRec = this.getSolverRecordSub(inPos);
        this.initSolverRecord(aSolverRec);
        return aSolverRec;
    }

    private void initSolverRecord(SolverRecord ioRec) {
        if (this.isStartState(ioRec.mState)) {
            int i = 0;
            while (i < DIRECTIONS.length) {
                Point aOpposite = new Point();
                if (this.isBuild(ioRec.mPos, DIRECTIONS[i], aOpposite)) {
                    OppositeRecord aOppRec;
                    ioRec.mOpposite[ioRec.mMaxOppositeCount] = aOppRec = new OppositeRecord(aOpposite, DIRECTIONS[i]);
                    ++ioRec.mMaxOppositeCount;
                }
                ++i;
            }
            ioRec.mOppositeCount = ioRec.mMaxOppositeCount;
            ioRec.mState = sProcessingState;
        }
    }

    private SolverRecord getSolverRecordSub(Point inPos) {
        if (!this.mRecords.containsKey(inPos)) {
            throw new IllegalArgumentException("The state of specified position isnot NumberState (pos : x = " + inPos.x + ", y = " + inPos.y + ")");
        }
        return (SolverRecord)this.mRecords.get(inPos);
    }

    private boolean available_1(SolverRecord inRec) {
        int aOpposite = inRec.mOppositeCount;
        int aResidue = inRec.mResidue;
        return 2 > aOpposite * 2 - aResidue;
    }

    private boolean available_2(SolverRecord inRec) {
        return 2 >= inRec.mOppositeCount;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
        aPos = new Point(inStart);
        aDiff = inDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        if (this.mModel.contains(aPos.x, aPos.y)) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.mModel.isNumberAt(aPos.x, aPos.y)) {
                outOpposite.setLocation(aPos.x, aPos.y);
                return true;
            }
            aCode = HashikakeStateEventCode.createParallelCode(inDir);
            if (!this.mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
                return false;
            }
            aPos.translate(aDiff.x, aDiff.y);
lbl13:
            // 2 sources

            ** while (this.mModel.contains((int)aPos.x, (int)aPos.y))
        }
lbl14:
        // 1 sources

        return false;
    }

    private boolean isStartState(State inState) {
        return inState == sStartState;
    }

    private boolean isFinishedState(State inState) {
        return inState == sFinishedState;
    }

    private boolean isDisableState(State inState) {
        return inState == sBuildDisable;
    }

    private boolean buildBridge(SolverRecord inRec, int inCount, int inIndex) {
        Point aPos = new Point(inRec.mPos);
        Direction aDir = inRec.mOpposite[inIndex].mDir;
        Point aDiff = aDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        OppositeRecord aOppRec = this.getOppositeRecord(inRec, aDir);
        if (this.isFinishedState(aOppRec.mState)) {
            return false;
        }
        if (this.isDisableState(aOppRec.mState)) {
            return false;
        }
        if (inCount == aOppRec.mCount) {
            return false;
        }
        StateEventCode aCode = HashikakeStateEventCode.createParallelCode(aDir);
        while (!aPos.equals(aOppRec.mPos)) {
            int aCount = aOppRec.mCount;
            while (aCount < inCount) {
                this.mModel.nextStateAt(aPos.x, aPos.y, aCode);
                ++aCount;
            }
            aPos.translate(aDiff.x, aDiff.y);
        }
        aOppRec.mCount = inCount;
        SolverRecord aAgainstRec = this.getSolverRecord(aOppRec.mPos);
        this.updateSolverRecord(aAgainstRec);
        if (2 == inCount || 0 == aAgainstRec.mResidue || inCount == inRec.mResidue) {
            aOppRec.mState = sFinishedState;
            inRec.mResidue -= inCount;
            --inRec.mOppositeCount;
            if (inRec.mResidue == 0) {
                inRec.mState = sFinishedState;
            }
        }
        return true;
    }

    private void updateSolverRecord(SolverRecord inRecord) {
        Point aDummy = new Point();
        int aSum = 0;
        int i = 0;
        while (i < inRecord.mMaxOppositeCount) {
            OppositeRecord aOppRec = inRecord.mOpposite[i];
            if (!this.isFinishedState(aOppRec.mState) && !this.isDisableState(aOppRec.mState)) {
                if (!this.isBuild(inRecord.mPos, aOppRec.mDir, aDummy)) {
                    aOppRec.mState = sBuildDisable;
                    --inRecord.mOppositeCount;
                } else {
                    SolverRecord aAgainstRec = this.getSolverRecord(aOppRec.mPos);
                    if (!this.isDisableState(aAgainstRec.mState) && !this.isStartState(aAgainstRec.mState)) {
                        Direction aInverse = UtilityFuncs.inverseDirection(aOppRec.mDir);
                        OppositeRecord aAgainstOppRec = this.getOppositeRecord(aAgainstRec, aInverse);
                        if (this.isFinishedState(aAgainstOppRec.mState)) {
                            aOppRec.mState = sFinishedState;
                            aOppRec.mCount = aAgainstOppRec.mCount;
                            inRecord.mResidue -= aOppRec.mCount;
                            --inRecord.mOppositeCount;
                            if (0 == inRecord.mResidue) {
                                inRecord.mState = sFinishedState;
                            }
                        } else if (this.isFinishedState(aAgainstRec.mState)) {
                            aOppRec.mState = sFinishedState;
                            --inRecord.mOppositeCount;
                            inRecord.mResidue -= aOppRec.mCount;
                        } else {
                            aOppRec.mCount = aAgainstOppRec.mCount;
                            aOppRec.mState = this.isFinishedState(inRecord.mState) ? sBuildDisable : sProcessingState;
                            aSum += aOppRec.mCount;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private OppositeRecord getOppositeRecord(SolverRecord inRec, Direction inDir) {
        int i = 0;
        while (i < inRec.mMaxOppositeCount) {
            if (inRec.mOpposite[i].mDir == inDir) {
                return inRec.mOpposite[i];
            }
            ++i;
        }
        return null;
    }

    private int accumulateAroundMax(SolverRecord inRec) {
        int aSum = 0;
        int i = 0;
        while (i < inRec.mMaxOppositeCount) {
            if (!this.isFinishedState(inRec.mOpposite[i].mState) && !this.isDisableState(inRec.mOpposite[i].mState)) {
                SolverRecord aAgainstRec = this.getSolverRecord(inRec.mOpposite[i].mPos);
                this.updateSolverRecord(aAgainstRec);
                aSum += aAgainstRec.mMaxBuildCount;
            }
            ++i;
        }
        return aSum;
    }

    static /* synthetic */ State access$000() {
        return sStartState;
    }

    static /* synthetic */ Direction[] access$100() {
        return DIRECTIONS;
    }

    static {
        NUM_PER_DIRECTION = 2;
        DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }

    private static class FinishState
    implements State {
        private FinishState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class DisableState
    implements State {
        private DisableState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class StartState
    implements State {
        private StartState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class ProcessState
    implements State {
        private ProcessState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    class SolverRecord {
        Point mPos;
        final int mMaxBuildCount;
        int mResidue;
        int mMaxOppositeCount;
        int mOppositeCount;
        OppositeRecord[] mOpposite = new OppositeRecord[SolverRI_2.access$100().length];
        State mState = SolverRI_2.access$000();

        SolverRecord(Point inPos, int inCount) {
            this.mPos = inPos;
            this.mMaxBuildCount = this.mResidue = inCount;
        }
    }

    class OppositeRecord {
        int mCount;
        Point mPos;
        Direction mDir;
        State mState = SolverRI_2.access$000();

        OppositeRecord(Point inPos, Direction inDir) {
            this.mPos = inPos;
            this.mDir = inDir;
        }
    }
}

