/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SearchListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class SolverRI_1
implements SolverHandler {
    private static final int NUM_PER_DIRECTION = 2;
    private Model mModel;
    private Map mCheckedMap = new HashMap();
    private List mQueue;
    private static State sStartState;
    private static State sProcessingState;
    private static State sFinishState;
    private static final Direction[] DIRECTIONS;

    public SolverRI_1(Model inModel) {
        this.mModel = inModel;
    }

    private int toIndex(int inX, int inY) {
        return inY * this.mModel.getWidth() + inX;
    }

    public void reset() {
        this.mQueue = new LinkedList();
        int y = 0;
        while (y < this.mModel.getWidth()) {
            int x = 0;
            while (x < this.mModel.getHeight()) {
                Point aPos = new Point(x, y);
                if (this.mModel.isNumberAt(x, y)) {
                    this.mQueue.add(aPos);
                    int aCount = 0;
                    try {
                        aCount = Integer.parseInt(StateManager.getInstance().findIdentityOf(this.mModel.getCurStateAt(aPos.x, aPos.y)));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
                    }
                    this.mCheckedMap.put(aPos, CheckRecord.createIslandRecord(aCount, aPos));
                } else if (this.mModel.isSpaceAt(x, y)) {
                    this.mCheckedMap.put(aPos, CheckRecord.createBridgeRecord(aPos));
                }
                ++x;
            }
            ++y;
        }
    }

    public void nextSolute() {
        if (this.isSolute()) {
            return;
        }
        Point aPos = (Point)this.mQueue.remove(0);
        this.attemptBuild(aPos.x, aPos.y);
    }

    private boolean isFinished(Point inPos) {
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(inPos);
        return this.isFinishedState(aRec.mState);
    }

    private boolean isProcessingState(State inState) {
        return inState instanceof ProcessState;
    }

    private boolean isFinishedState(State inState) {
        return inState instanceof FinishState;
    }

    private boolean isStartState(State inState) {
        return inState instanceof StartState;
    }

    private boolean attemptBuild(int inX, int inY) {
        Point aPos = new Point(inX, inY);
        int aOppositeCount = 0;
        int[] aIndicies = new int[DIRECTIONS.length];
        int i = 0;
        while (i < DIRECTIONS.length) {
            if (this.isBuild(aPos, DIRECTIONS[i], i)) {
                aIndicies[aOppositeCount++] = i;
            }
            ++i;
        }
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(aPos);
        int aResNum = aRec.mResidueBridgeCount;
        boolean aRet = false;
        if (2 > aOppositeCount * 2 - aResNum) {
            int aNumPerDir = 2 - (aOppositeCount * 2 - aResNum);
            boolean aFilled = aResNum == aOppositeCount * aNumPerDir;
            int i2 = 0;
            while (i2 < aOppositeCount) {
                int aIndex = aIndicies[i2];
                this.buildBridge(aPos, DIRECTIONS[aIndex], aIndex, aNumPerDir, aFilled);
                ++i2;
            }
            aRet = true;
        }
        if (!this.isFinished(aPos)) {
            this.mQueue.add(aPos);
        }
        return aRet;
    }

    private boolean isBuild(Point inPos, Direction inDir, int inIndex) {
        Point aPos = new Point(inPos);
        Point aDiff = inDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        if (!this.mModel.contains(aPos.x, aPos.y)) {
            return false;
        }
        State aState = this.mModel.getCurStateAt(aPos.x, aPos.y);
        int aCount = HashikakeStateManagerImpl.countBridge(aState);
        while (this.mModel.contains(aPos.x, aPos.y)) {
            if (this.mModel.isNumberAt(aPos.x, aPos.y)) {
                boolean aRet = this.isFinished(aPos);
                CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(aPos);
                if (aRet && this.isFinishedState(aRec.mState) && 0 < aCount) {
                    this.updateRecordLatter(inPos, aCount, inIndex);
                }
                return !aRet;
            }
            StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);
            if (!this.mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
                return false;
            }
            aPos.translate(aDiff.x, aDiff.y);
        }
        return false;
    }

    private void buildBridge(Point inPos, Direction inDir, int inDirIndex, int inCount, boolean inFilled) {
        Point aPos = new Point(inPos);
        Point aDiff = inDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(aPos);
        int aCount = inCount - (aRec.mMaxBridgeCount - aRec.mResidueBridgeCount);
        if (0 == aCount) {
            return;
        }
        StateEventCode aCode = HashikakeStateEventCode.createParallelCode(inDir);
        while (this.mModel.contains(aPos.x, aPos.y) && !this.mModel.isNumberAt(aPos.x, aPos.y)) {
            int i = aCount;
            while (i > 0) {
                this.mModel.nextStateAt(aPos.x, aPos.y, aCode);
                --i;
            }
            this.updateBridgeRecord(aPos, aCount);
            aPos.translate(aDiff.x, aDiff.y);
        }
        this.updateOppositeRecord(aPos, inCount, aCount, inDirIndex, inFilled);
        this.updateRecord(inPos, inCount, aCount, inDirIndex, inFilled);
    }

    private boolean updateRecordSub(CheckRecord inRec, int inCount, int inDiffCount, boolean inFilled, boolean inUpdateLatter) {
        boolean aRet = inFilled;
        CheckRecord aRec = inRec;
        if (!inUpdateLatter) {
            aRec.mCurBridgeCount += inDiffCount;
        }
        if (aRec.mCurBridgeCount != aRec.mMaxBridgeCount) {
            aRec.mState = sProcessingState;
        } else {
            aRec.mState = sFinishState;
            int aIndex = this.mQueue.indexOf(aRec.mPos);
            if (0 <= aIndex) {
                this.mQueue.remove(aIndex);
            }
        }
        return aRet;
    }

    private boolean updateRecord(Point inPos, int inCount, int inDiffCount, int inDirIndex, boolean inFilled) {
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(inPos);
        if (inFilled) {
            int aOldCount = aRec.mEachCount[inDirIndex];
            if (aOldCount != inCount) {
                aRec.mEachCount[inDirIndex] = inCount;
                aRec.mResidueBridgeCount -= inCount;
            }
            if (0 > aRec.mResidueBridgeCount) {
                throw new IllegalStateException("negative error at : " + inPos);
            }
        }
        return this.updateRecordSub(aRec, inCount, inDiffCount, inFilled, false);
    }

    private boolean updateBridgeRecord(Point inPos, int inDiffCount) {
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(inPos);
        aRec.mResidueBridgeCount -= inDiffCount;
        if (0 > aRec.mResidueBridgeCount) {
            throw new IllegalStateException("negative error at : " + inPos);
        }
        return this.updateRecordSub(aRec, inDiffCount, inDiffCount, true, false);
    }

    private boolean updateRecordLatter(Point inPos, int inCount, int inDirIndex) {
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(inPos);
        int aOldCount = aRec.mEachCount[inDirIndex];
        if (aOldCount != inCount) {
            aRec.mEachCount[inDirIndex] = inCount;
            aRec.mResidueBridgeCount -= inCount;
        }
        if (0 > aRec.mResidueBridgeCount) {
            throw new IllegalStateException("negative error at : " + inPos);
        }
        return this.updateRecordSub(aRec, inCount, inCount, true, true);
    }

    private boolean updateOppositeRecord(Point inPos, int inCount, int inDiffCount, int inDirIndex, boolean inFilled) {
        CheckRecord aRec = (CheckRecord)this.mCheckedMap.get(inPos);
        boolean aFilled = inFilled;
        if (!inFilled && inCount == aRec.mCurBridgeCount - aRec.mMaxBridgeCount) {
            aRec.mResidueBridgeCount -= inCount;
            if (0 > aRec.mResidueBridgeCount) {
                throw new IllegalStateException("negative error at : " + inPos);
            }
            aFilled = true;
        }
        return this.updateRecordSub(aRec, inCount, inDiffCount, aFilled, false);
    }

    public void nextSoluteAll() throws SolveDiscompleteException {
        if (this.mQueue.isEmpty()) {
            return;
        }
        int aCount = 0;
        do {
            Point aPos = (Point)this.mQueue.remove(0);
            if (!this.attemptBuild(aPos.x, aPos.y)) {
                if (this.mQueue.size() != ++aCount) continue;
                throw new SolveDiscompleteException(this.mQueue.size());
            }
            aCount = 0;
        } while (!this.isSolute());
    }

    public boolean isSolute() {
        return this.mQueue.isEmpty();
    }

    public void addSearchListener(SearchListener inListener) {
    }

    static /* synthetic */ State access$000() {
        return sStartState;
    }

    static {
        NUM_PER_DIRECTION = 2;
        sStartState = new StartState();
        sProcessingState = new ProcessState();
        sFinishState = new FinishState();
        DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    }

    private static class FinishState
    implements State {
        private FinishState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class ProcessState
    implements State {
        private ProcessState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class StartState
    implements State {
        private StartState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class CheckRecord {
        State mState = SolverRI_1.access$000();
        int mResidueBridgeCount;
        int mCurBridgeCount;
        final int mMaxBridgeCount;
        Point mPos;
        int[] mEachCount;

        private CheckRecord(int inCount, Point inPos) {
            this.mMaxBridgeCount = inCount;
            this.mResidueBridgeCount = inCount;
            this.mPos = inPos;
        }

        static CheckRecord createIslandRecord(int inCount, Point inPos) {
            CheckRecord aRec = new CheckRecord(inCount, inPos);
            aRec.mEachCount = new int[DIRECTIONS.length];
            return aRec;
        }

        static CheckRecord createBridgeRecord(Point inPos) {
            return new CheckRecord(2, inPos);
        }
    }
}

