#include "main.h"

void window_alloc(struct sheet *sht, unsigned char *title, char m)
{
	graphic_box(sht, COLOR_C6C6C6,           0,           0, sht->sx - 1,           0);
	graphic_box(sht, COLOR_FFFFFF,           1,           1, sht->sx - 2,           1);
	graphic_box(sht, COLOR_C6C6C6,           0,           0,           0, sht->sy - 1);
	graphic_box(sht, COLOR_FFFFFF,           1,           1,           1, sht->sy - 2);
	graphic_box(sht, COLOR_848484, sht->sx - 2,           1, sht->sx - 2, sht->sy - 2);
	graphic_box(sht, COLOR_000000, sht->sx - 1,           0, sht->sx - 1, sht->sy - 1);
	graphic_box(sht, COLOR_C6C6C6,           2,           2, sht->sx - 3, sht->sy - 3);
	graphic_box(sht, COLOR_848484,           1, sht->sy - 2, sht->sx - 2, sht->sy - 2);
	graphic_box(sht, COLOR_000000,           0, sht->sy - 1, sht->sx - 1, sht->sy - 1);
	window_alloc0(sht, title, m);
	tbar_add(sht, title);
	return;
}

void window_alloc0(struct sheet *sht, unsigned char *title, char m)
{
	static unsigned char bcls[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQQQ@@QQQQQ$@",
		"OQQQQQ@@@@QQQQ$@",
		"OQQQQ@@QQ@@QQQ$@",
		"OQQQ@@QQQQ@@QQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	static unsigned char mcls[14][16] = {
		"OOOOOOOOOOOOOOO@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQ@@@@@@@QQQ$@",
		"OQQQ@@@@@@@QQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"OQQQQQQQQQQQQQ$@",
		"O$$$$$$$$$$$$$$@",
		"@@@@@@@@@@@@@@@@"
	};
	int x, y;
	unsigned char tc, tbc, c;

	if (m != 0) {
		tc = COLOR_FFFFFF;
		tbc = COLOR_000084;
	} else {
		tc = COLOR_C6C6C6;
		tbc = COLOR_848484;
	}
	graphic_box(sht, tbc, 3, 3, sht->sx - 4, 20);
	graphic_puts(sht, tc, 24, 4, title);

	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = bcls[y][x];
			if (c == '@') { c = COLOR_000000; }
			else if (c == '$') { c = COLOR_848484; }
			else if (c == 'Q') { c = COLOR_C6C6C6; }
			else { c = COLOR_FFFFFF; }
			sht->buf[(5 + y) * sht->sx + (sht->sx - 21 + x)] = c;
		}
	}
	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = mcls[y][x];
			if (c == '@') { c = COLOR_000000; }
			else if (c == '$') { c = COLOR_848484; }
			else if (c == 'Q') { c = COLOR_C6C6C6; }
			else { c = COLOR_FFFFFF; }
			sht->buf[(5 + y) * sht->sx + (sht->sx - 39 + x)] = c;
		}
	}
	return;
}

void window_chtitle(struct sheet *sht, char m)
{
	int x, y;
	unsigned char ntb, ntc, otb, otc, c;

	if (m != 0) {
		ntc = COLOR_FFFFFF;
		ntb = COLOR_000084;
		otc = COLOR_C6C6C6;
		otb = COLOR_848484;
	} else {
		ntc = COLOR_C6C6C6;
		ntb = COLOR_848484;
		otc = COLOR_FFFFFF;
		otb = COLOR_000084;
	}

	for (y = 3; y <= 20; y++) {
		for (x = 3; x <= sht->sx - 4; x++) {
			c = sht->buf[y * sht->sx + x];	/* IEŏ{^悤ɕύXĂ */
			if (c == otc && x <= sht->sx - 39) {
				c = ntc;
			} else if (c == otb) {
				if (y < 5 || 18 < y) {
					c = ntb;
				} else {
					if ((x < sht->sx - 39 || sht->sx - 24 < x) && (x < sht->sx - 21 || sht->sx - 6 < x)) {
						c = ntb;
					}
				}
			}
			sht->buf[y * sht->sx + x] = c;
		}
	}
	sheet_refresh(sht, 3, 3, sht->sx, 21);
	return;
}

void window_textbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	graphic_box(sht, COLOR_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	graphic_box(sht, COLOR_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	graphic_box(sht, COLOR_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	graphic_box(sht, COLOR_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	graphic_box(sht, COLOR_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	graphic_box(sht, COLOR_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	graphic_box(sht, COLOR_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	graphic_box(sht, COLOR_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	graphic_box(sht,            c, x0 - 1, y0 - 1, x1 + 0, y1 + 0);
	return;
}

void window_on(struct sheet *skey)
{
	window_chtitle(skey, 1);
	if ((skey->flag & SHEET_CUR) != 0) {
		fifo_put(&skey->task->fifo, 2);
	}
	tbar_select(skey);
	return;
}

void window_off(struct sheet *skey)
{
	window_chtitle(skey, 0);
	if ((skey->flag & SHEET_CUR) != 0) {
		fifo_put(&skey->task->fifo, 3);
	}
	tbar_unselect();
	return;
}
