/* EBhEǗ */
#include "main.h"

struct sheets *shts;	/* main.c  extern */

void sheet_init(void)
{
	struct binfo *binfo = (struct binfo *) BINFO_ADDR;
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	int i;

	shts = (struct sheets *) memory_alloc(mem, sizeof (struct sheets));
	shts->map = (unsigned char *) memory_alloc(mem, binfo->scrnx * binfo->scrny);
	shts->vram = binfo->vram;
	shts->scrnx = binfo->scrnx;
	shts->scrny = binfo->scrny;
	shts->top = -1;	/* ꖇȂ */
	for (i = 0; i < SHEETS; i++) {
		shts->sht[i].flag = 0;
		shts->sht[i].menu = 0;
	}
	return;
}

struct sheet *sheet_alloc(void)
{
	struct sheet *sht;
	int i;

	for (i = 0; i < SHEETS; i++) {
		if (shts->sht[i].flag == 0) {
			sht = &shts->sht[i];
			sht->flag = SHEET_USING;
			sht->height = -1;	/* \ */
			sht->task = 0;
			return sht;
		}
	}
	return 0;
}

void sheet_free(struct sheet *sht)
{
	tbar_remove(sht);
	if (sht->height >= 0) {
		sheet_updown(sht, -1);
	}
	sht->flag = 0;
	return;
}

void sheet_set(struct sheet *sht, unsigned char *buf, int sx, int sy, int cinv)
{
	sht->buf = buf;
	sht->sx = sx;
	sht->sy = sy;
	sht->cinv = cinv;
	return;
}

void sheet_updown(struct sheet *sht, int height)
{
	int h, old = sht->height;

	if (height > shts->top + 1) {
		height = shts->top + 1;
	}
	if (height < -1) {
		height = -1;
	}
	sht->height = height;

	if (old > height) {	/* ႭȂ */
		if (height >= 0) {
			for (h = old; h > height; h++) {
				shts->s[h] = shts->s[h - 1];
				shts->s[h]->height = h;
			}
			shts->s[h] = sht;
			sheet_map(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height + 1);
			sheet_refresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height + 1, old);
		} else {	/* \ */
			if (shts->top > old) {
				for (h = old; h < shts->top; h++) {
					shts->s[h] = shts->s[h + 1];
					shts->s[h]->height = h;
				}
			}
			shts->top--;
			sheet_map(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, 0);
			sheet_refresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, 0, old - 1);
		}
	} else if (old < height) {
		if (old >= 0) {
			for (h = old; h < height; h++) {
					shts->s[h] = shts->s[h + 1];
					shts->s[h]->height = h;
			}
			shts->s[height] = sht;
		} else {	/* \ */
			for (h = shts->top; h >= height; h--) {
					shts->s[h + 1] = shts->s[h];
					shts->s[h + 1]->height = h + 1;
			}
			shts->s[height] = sht;
			shts->top++;
		}
		sheet_map(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height);
		sheet_refresh0(sht->x, sht->y, sht->x + sht->sx, sht->y + sht->sy, height, height);
	}
	return;
}

void sheet_slide(struct sheet *sht, int x, int y)
{
	int ox = sht->x, oy = sht->y;

	sht->x = x;
	sht->y = y;
	if (sht->height >= 0) {
		sheet_map(ox, oy, ox + sht->sx, oy + sht->sy, 0);
		sheet_map(x, y, x + sht->sx, y + sht->sy, sht->height);
		sheet_refresh0(ox, oy, ox + sht->sx, oy + sht->sy, 0, sht->height - 1);
		sheet_refresh0(x, y, x + sht->sx, y + sht->sy, sht->height, sht->height);
	}
	return;
}

void sheet_refresh(struct sheet *sht, int x0, int y0, int x1, int y1)
{
	if (sht->height >= 0) {
		sheet_map(sht->x + x0, sht->y + y0, sht->x + x1, sht->y + y1, sht->height);
		sheet_refresh0(sht->x + x0, sht->y + y0, sht->x + x1, sht->y + y1, 0, sht->height);
	}
	return;
}

void sheet_refresh0(int x0, int y0, int x1, int y1, int h0, int h1)
{
	struct sheet *sht;
	unsigned char *vram = shts->vram, *map = shts->map, *buf, sid;
	int bx, by, vx, vy, bx0, by0, bx1, by1, bx2, h, sid4, i, i1, *p, *q, *r;

	if (x0 < 0) { x0 = 0; }
	if (y0 < 0) { y0 = 0; }
	if (x1 > shts->scrnx) { x1 = shts->scrnx; }
	if (y1 > shts->scrny) { y1 = shts->scrny; }

	for (h = h0; h <= h1; h++) {
		sht = shts->s[h];
		buf = sht->buf;
		sid = sht - shts->sht;
		bx0 = x0 - sht->x;
		by0 = y0 - sht->y;
		bx1 = x1 - sht->x;
		by1 = y1 - sht->y;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->sx) { bx1 = sht->sx; }
		if (by1 > sht->sy) { by1 = sht->sy; }
		if ((sht->x & 3) == 0) {
			i = (bx0 + 3) / 4;
			i1 = bx1 / 4;
			i1 -= i;
			sid4 = sid | sid << 8 | sid << 16 | sid << 24;
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1 && (bx & 3) != 0; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
				vx = sht->x + bx;
				p = (int *) &map[vy * shts->scrnx + vx];
				q = (int *) &vram[vy * shts->scrnx + vx];
				r = (int *) &buf[by * sht->sx + bx];
				for (i = 0; i < i1; i++) {
					if (p[i] == sid4) {
						q[i] = r[i];
					} else {
						bx2 = bx + i * 4;
						vx = sht->x + bx2;
						if (map[vy * shts->scrnx + vx] == sid) {
							vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx2];
						}
						if (map[vy * shts->scrnx + vx + 1] == sid) {
							vram[vy * shts->scrnx + vx + 1] = buf[by * sht->sx + bx2 + 1];
						}
						if (map[vy * shts->scrnx + vx + 2] == sid) {
							vram[vy * shts->scrnx + vx + 2] = buf[by * sht->sx + bx2 + 2];
						}
						if (map[vy * shts->scrnx + vx + 3] == sid) {
							vram[vy * shts->scrnx + vx + 3] = buf[by * sht->sx + bx2 + 3];
						}
					}
				}
				for (bx += i1 * 4; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
			}
		} else {
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (map[vy * shts->scrnx + vx] == sid) {
						vram[vy * shts->scrnx + vx] = buf[by * sht->sx + bx];
					}
				}
			}
		}
	}
	return;
}

void sheet_map(int x0, int y0, int x1, int y1, int h0)
{
	struct sheet *sht;
	unsigned char *map = shts->map, *buf, sid;
	int bx, by, vx, vy, bx0, by0, bx1, by1, h, sid4, *p;

	if (x0 < 0) { x0 = 0; }
	if (y0 < 0) { y0 = 0; }
	if (x1 > shts->scrnx) { x1 = shts->scrnx; }
	if (y1 > shts->scrny) { y1 = shts->scrny; }

	for (h = h0; h <= shts->top; h++) {
		sht = shts->s[h];
		sid = sht - shts->sht;	/* ԒnvZāAIDɂ */
		buf = sht->buf;
		bx0 = x0 - sht->x;
		by0 = y0 - sht->y;
		bx1 = x1 - sht->x;
		by1 = y1 - sht->y;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->sx) { bx1 = sht->sx; }
		if (by1 > sht->sy) { by1 = sht->sy; }
 		if (sht->cinv == -1) {
			if ((sht->x & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
				bx1 = (bx1 - bx0) / 4;
				sid4 = sid | sid << 8 | sid << 16 | sid << 24;
				for (by = by0; by < by1; by++) {
					vy = sht->y + by;
					vx = sht->x + bx0;
					p = (int *) &map[vy * shts->scrnx + vx];
					for (bx = 0; bx < bx1; bx++) {
						p[bx] = sid4;
					}
				}
			} else {
				for (by = by0; by < by1; by++) {
					vy = sht->y + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sht->x + bx;
						map[vy * shts->scrnx + vx] = sid;
					}
				}
			}
		} else {
			for (by = by0; by < by1; by++) {
				vy = sht->y + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->x + bx;
					if (buf[by * sht->sx + bx] != sht->cinv) {
						map[vy * shts->scrnx + vx] = sid;
					}
				}
			}
		}
	}
	return;
}

void sheet_clean(struct task *task)
{
	struct sheet *sht;
	int i;

	for (i = 0; i < SHEETS; i++) {
		sht = &(shts->sht[i]);
		if (((sht->flag & SHEET_APP) != 0 || (sht->flag & SHEET_DIALOGUE) != 0) && sht->task == task) {
			sheet_free(sht);
		}
	}
	return;
}

void sheet_app(struct sheet *sht)
{
	sheet_slide(sht, (shts->scrnx - sht->sx) / 2, (shts->scrny - sht->sy) / 2);
	sheet_updown(sht, shts->top);
	return;
}

void sheet_mclose(void)
{
	struct sheet *sht;
	int i;

	for (i = 0; i < SHEETS; i++) {
		sht = &(shts->sht[i]);
		if ((sht->flag & SHEET_MENU) != 0) {
			sht->menu->mode = 0;
			sheet_updown(sht, -1);
		}
	}
	return;
}

struct menu *sheet_mchk(int h)
{
	struct sheet *sht = shts->s[h];
	if ((sht->flag & SHEET_MENU) != 0) {
		return sht->menu;
	}
	return 0;
}

void sheet_mupdown(struct sheet *sht)
{
	sheet_updown(sht, shts->top);
	return;
}

void sheet_tupdown(struct sheet *sht)
{
	if (shts->top > 1 && sht->height != -1) {
		sheet_updown(sht, shts->top - 1);
	} else {
		sheet_updown(sht, shts->top);
	}
	return;
}
