#include "main.h"

struct fifo *fmouse;

void mouse_enable(struct mouse *m, struct fifo *f)
{
	fmouse = f;
	keyboard_ready();
	io_out8(0x0064, 0xd4);	/* }EXւ̃f[^ */
	keyboard_ready();
	io_out8(0x0060, 0xf4);	/* }EX̗L */
	m->phase = 0;			/* L0xfaM */
	return;
}

void int_2c(int *esp)
{
	unsigned char data;

	io_out8(0x00a0, 0x64);	/* 0x00a00x60+(IRQ-8)Ŋ荞݊ʒm */
	io_out8(0x0020, 0x62);
	data = io_in8(0x0060);
	fifo_put(fmouse, 512 + (int) data);
	return;
}

int mouse_decode(struct mouse *m, unsigned char d)
{
	if (m->phase == 0) {
		if (d == 0xfa) {
			m->phase = 1;
		}
		return 0;
	} else if (m->phase == 1) {
		if ((d & 0xc8) == 0x08) {
			m->buf[0] = d;
			m->phase = 2;
		}
		return 0;
	} else if (m->phase == 2) {
		m->buf[1] = d;
		m->phase = 3;
		return 0;
	} else if (m->phase == 3) {
		m->buf[2] = d;
		m->phase = 1;
		m->btn = m->buf[0] & 0x07;
		m->x = m->buf[1];
		m->y = m->buf[2];
		if ((m->buf[0] & 0x10) != 0) {
			m->x |= 0xffffff00;
		}
		if ((m->buf[0] & 0x20) != 0) {
			m->y |= 0xffffff00;
		}
		m->y = - m->y;
		if (m->x == 0 && m->y == 0) {
			if (m->btn == 0) {
				m->stat = MOUSE_RELEASED;
			} else {
				m->stat = MOUSE_PRESSED;
			}
		} else {
			if (m->btn == 0) {
				m->stat = MOUSE_MOVED;
			} else {
				m->stat = MOUSE_DRAGGED;
			}
		}
		return 1;
	}
	return -1;	/* s */
}
