#include "main.h"
#include <string.h>
extern int *fat;

void menu_init(struct menu *m, unsigned char *title)
{
	int i;

	m->title = title;
	m->mode = 0;
	for (i = 0; i < SELECTS; i++) {
		m->sel[i].mode = 0;
	}
	return;
}

void menu_add(struct menu *menu, unsigned char *name, unsigned char *line, struct menu *m)
{
	struct select *s;
	int i;

	for (i = 0; i < SELECTS; i++) {
		if (menu->sel[i].mode == 0) {
			s = &menu->sel[i];
			if (m == 0) {
				s->name = name;
				s->line = line;
				s->mode = SEL_SELECT;
			} else {
				s->name = name;
				s->menu = m;
				s->mode = SEL_SUBMENU;
			}
			return;
		}
	}
	return;
}

void menu_run(struct sheet *sht, struct menu *m, int mx, int my, int h)
{
	struct menu *msub;
	struct sheet *ms;
	int i;

	if (h == 0 && 2 <= mx && mx <= 60 && sht->sy - 24 <= my && my <= sht->sy - 3) {
		if (m->mode == 0) {
			m->mode = MENU_ACCTIVE;
			menu_bon(sht);
			if (m->sht == 0) {
				m->sht = menu_sheet(m);
			}
			ms = m->sht;
			sheet_mupdown(ms);
			sheet_slide(ms, 0, sht->sy - ms->sy - 28);
		} else {
			goto off;
		}
	} else {
		msub = sheet_mchk(h);
		if (msub != 0) {
			i = menu_check(msub, mx - msub->sht->x, my - msub->sht->y);
			if (i != 0) {	/* Ȃɂs */
				goto off;
			}
		} else if (m->mode == MENU_ACCTIVE) {
off:
			m->mode = 0;
			menu_boff(sht);
			sheet_mclose();
		}
	}
	return;
}

void menu_bon(struct sheet *sht)
{
	graphic_button(sht, 2, sht->sy - 24, 58, 21, "TeaseOS", 1);
	sheet_refresh(sht, 2, sht->sy - 24, 61, sht->sy - 2);
	return;
}

void menu_boff(struct sheet *sht)
{
	graphic_button(sht, 2, sht->sy - 24, 58, 21, "TeaseOS", 0);
	sheet_refresh(sht, 2, sht->sy - 24, 61, sht->sy - 2);
	return;
}

struct sheet *menu_sheet(struct menu *m)
{
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	struct sheet *sht = sheet_alloc();
	unsigned char *sbuf, c;
	int sx = 4, sy = 4, i, j;

	sht->flag |= SHEET_MENU;
	/* j[̃TCY */
	if (m->title != 0) {
		sy += 20;
		sx = 8 + 8 * strlen(m->title);
	}
	for (i = 0; m->sel[i].mode != 0 && i < SELECTS; i++) {
		j = 8 + 8 * strlen(m->sel[i].name);
		if (m->sel[i].menu != 0) {
			j += 16;
		}
		if (sx < j) {
			sx = j;
		}
		sy += 20;
	}

	sbuf = (unsigned char *) memory_alloc(mem, sx * sy);
	sheet_set(sht, sbuf, sx, sy, -1);
	sht->menu = m;

	graphic_box(sht, COLOR_C6C6C6,      0,      0, sx - 1,      0);
	graphic_box(sht, COLOR_FFFFFF,      1,      1, sx - 2,      1);
	graphic_box(sht, COLOR_C6C6C6,      0,      0,      0, sy - 1);
	graphic_box(sht, COLOR_FFFFFF,      1,      1,      1, sy - 2);
	graphic_box(sht, COLOR_848484, sx - 2,      1, sx - 2, sy - 2);
	graphic_box(sht, COLOR_000000, sx - 1,      0, sx - 1, sy - 1);
	graphic_box(sht, COLOR_C6C6C6,      2,      2, sx - 3, sy - 3);
	graphic_box(sht, COLOR_848484,      1, sy - 2, sx - 2, sy - 2);
	graphic_box(sht, COLOR_000000,      0, sy - 1, sx - 1, sy - 1);

	if (m->title != 0) {
		graphic_box(sht, COLOR_000084, 2, 2, sx - 4, 20);
		graphic_puts(sht, COLOR_FFFFFF, 3, 3, m->title);
	}
	for (i = 0; m->sel[i].mode != 0 && i < SELECTS; i++) {
		sy -= 20;
		if (m->sel[i].line == 0 && m->sel[i].menu == 0) {
			c = COLOR_848484;
		} else {
			c = COLOR_000000;
			if (m->sel[i].menu != 0) {
				graphic_puts(sht, c, sx - 12, sy, "\20");
			}
		}
		graphic_puts(sht, c, 3, sy, m->sel[i].name);
	}
	return sht;
}

int menu_check(struct menu *m, int x, int y)
{
	struct sheet *s = m->sht;
	int i = 0, j;

	if (2 <= x && x <= s->sx - 2) {
		if (m->title != 0) {
			i = (y - 20) / 20 + 1;
		} else {
			i = (y - 2) / 20 + 1;
		}
		for (j = 0; m->sel[j].mode != 0 && i < SELECTS; j++) { }
		i = j - i;
		i = menu_selrun(&m->sel[i], i, m);
	}
	return i;
}

int menu_selrun(struct select *s, int i, struct menu *cm)
{
	struct menu *menu = s->menu;
	struct sheet *ms, *cms = cm->sht, *sht;
	unsigned char *line = s->line;

	if (menu != 0) {
		if (menu->mode == 0) {
			menu->mode = MENU_ACCTIVE;
			if (menu->sht == 0) {
				menu->sht = menu_sheet(menu);
			}
			ms = menu->sht;
			sheet_mupdown(ms);
			if (cm->title != 0) {
				sheet_slide(ms, cms->x + cms->sx, cms->y + 20 + i * 20 - ms->sy);
			} else {
				sheet_slide(ms, cms->x + cms->sx, cms->y + i * 20 - ms->sy);
			}
		}
	} else {
		if (line[0] == '\1') {
			sht = console_open(fat);
			sheet_app(sht);
			window_refresh();
		} else if (line[0] == '\2') {
			reset();
		} else {
			console_ncst(line, fat);
		}
		sheet_mclose();
		return 1;
	}
	return 0;
}
