#include "main.h"

void fat_read(int *fat, unsigned char *img)
{
	int i, j = 0;

	for (i = 0; i < 2880; i += 2) {
		fat[i] = (img[j] | img[j + 1] << 8) & 0x0fff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0x0fff;
		j += 3;
	}
	return;
}

struct file *file_search(unsigned char *name)
{
	struct file *file = (struct file *) (DISK_ADDR + 0x00002600);
	int i, j;
	unsigned char s[12];

	for (i = 0; i < 11; i++) {
		s[i] = ' ';
	}
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) {
			return 0;
		}
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') {
				s[i] -= 0x20;
			}
			i++;
		}
	}
	for (i = 0; i < 224;) {
		if (file[i].name[0] == 0x00) {
			break;
		}
		if ((file[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (file[i].name[j] != s[j]) {
					goto next;
				}
			}
			return file + i;
		}
next:
		i++;
	}
	return 0;
}

void file_setbuf(struct fhandle *fh, int addr)
{
	struct task *task = task_now();
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i, j, a0 = 0;

	file_flushbuf(fh);
	for (i = fh->file->caddr; ;) {
		if (fh->size < addr) {
			i = file_addbuf(fh);
			break;
		}
		if (addr < 512) {
			break;
		}
		addr -= 512;
		a0 += 512;
		i = task->fat[i];
	}
	for (j = 0; j < 512; j++) {
		fh->buf[j] = img[i * 512 + j];
	}
	fh->bcaddr = i;
	fh->baddr = a0;
	return;
}

int file_addbuf(struct fhandle *fh)
{
	struct task *task = task_now();
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i, j;

	for (i = fh->file->caddr; ;) {
		if (i <= 0x0ff8) {	/* [ */
			task->fat[i] = file_getfat(task->fat);
			i = task->fat[i];
			task->fat[i] = 0x0ff8;
			for (j = 0; j < 512; j++) {
				img[i * 512 + j] = 0;
			}
			fh->bcaddr = i;
			return i;
		}
		i = task->fat[i];
	}
	return 0;
}

void file_flushbuf(struct fhandle *fh)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	int i;

	if (fh->mode != FILE_CHANGED) {
		return;
	}
	for (i = 0; i < 512; i++) {
		img[fh->bcaddr * 512 + i] = fh->buf[i];
	}
	fh->mode = 0;
	return;
}

struct file *file_create(int *fat, unsigned char *name)
{
	struct file *file = file_getlist(), *t;

	if (file != 0) {
		t = file_search(name);
		if (t == 0) {
			file_setname(file, name);
			file_setdate(file);
			file->size = 0;
			file->type = 0x20;
			file->caddr = file_getfat(fat);
			return file;
		}
	}
	return 0;
}

void file_delete(int *fat, struct file *file)
{
	int i, j;

	file->name[0] = 0xe5;
	file->size = 0;
	file->type = 0;
	for (i = file->caddr; fat[i] < 0x0ff8;) {
		j = fat[i];
		fat[i] = 0;
		i = j;
	}
	fat[i] = 0;
	return;
}

int file_rename(struct file *file, unsigned char *name)
{
	struct file *t = file_search(name);

	if (t == 0) {
		file_setname(file, name);
		file_setdate(file);
		return 1;
	}
	return 0;
}

unsigned char *file_read(int *fat, int caddr, int size)
{
	unsigned char *img = (unsigned char *) (DISK_ADDR + 0x003e00);
	struct memory *mem = (struct memory *) MEMORY_ADDR;
	unsigned char *buf, *buf2;
	int i;

	buf = (unsigned char *) memory_alloc(mem, size);
	buf2 = buf;
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[caddr * 512 + i];
			}
			return buf2;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[caddr * 512 + i];
		}
		size -= 512;
		buf += 512;
		caddr = fat[caddr];
	}
}

unsigned short file_getfat(int *fat)
{
	int i;

	for (i = 0; i < 2880; i++) {
		if (fat[i] == 0) {
			return i;
		}
	}
	return 0;
}

struct file *file_getlist(void)
{
	struct file *ip = (struct file *) (DISK_ADDR + 0x00002600);
	int i;

	for (i = 0; i < 224; i++) {
		if (ip[i].type == 0x00 || ip[i].name[0] == 0xe5) {
			return &ip[i];
		}
	}
	return 0;
}

void file_setname(struct file *file, unsigned char *name)
{
	int i, j;
	unsigned char s[12];

	for (i = 0; i < 11; i++) {
		s[i] = ' ';
	}
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) {
			return;
		}
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') {
				s[i] -= 0x20;
			}
			i++;
		}
	}

	for (i = 0; i < 11; i++) {
		file->name[i] = s[i];
	}
	return;
}

void file_setdate(struct file *file)
{
	struct clock t;
	unsigned short time, date;

	clock_get(&t);
	time = 2048 * t.hour + 32 * t.min + t.sec / 2;
	date = 512 * (t.year - 1980) + 32 * t.month + t.day;

	file->time = time;
	file->date = date;
	return;
}
