#include "main.h"

void fifo_init(struct fifo *f, int *buf, int size, struct task *t)
{
	f->size = size;
	f->buf = buf;
	f->free = size;
	f->flag = 0;
	f->w_next = 0;
	f->r_next = 0;
	f->t = t;
	return;
}

int fifo_put(struct fifo *f, int data)
{
	if (f->free == 0) {
		f->flag |= FIFO_OVERRUN;
		return -1;
	}
	f->buf[f->w_next] = data;
	f->w_next++;
	if(f->w_next == f->size) {
		f->w_next = 0;
	}
	f->free--;
	if (f->t != 0) {
		if (f->t->flag != TASK_RUNNING) {
			task_run(f->t, -1, 0);
		}
	}
	return 0;
}

int fifo_get(struct fifo *f)
{
	int data;

	if (f->free == f->size) {
		return -1;
	}
	data = f->buf[f->r_next];
	f->r_next++;
	if(f->r_next == f->size) {
		f->r_next = 0;
	}
	f->free++;
	return data;
}

int fifo_stat(struct fifo *f)
{
	return f->size - f->free;
}
