#ifndef _HARDMETER_H_
#define _HARDMETER_H_ 1
#include <sys/types.h>
#include <linux/perfctr.h>

#define HARDMETER_DEFAULT_INTERVAL 10000
#define HARDMETER_DEFAULT_COUNT 2000

typedef struct hardmeter_t hardmeter_t; /* opaque data type */

struct hardmeter_event_mask_t {
	const char *name;
	const char *description;
	int position;
	unsigned int val;
	int is_default;
};
typedef struct hardmeter_event_mask_t hardmeter_event_mask_t;

struct hardmeter_template_t {
	const char *name;
	const char *description;
	const struct vperfctr_control *control;
	const hardmeter_event_mask_t *eventmask;
	int is_pebs;
};
typedef struct hardmeter_template_t hardmeter_template_t;

struct hardmeter_option_t {
	const hardmeter_template_t *template;
	int user;
	int kernel;
	int interval;
	int count;
};
typedef struct hardmeter_option_t hardmeter_option_t;

/* hardmeter.c */

int hardmeter_init(const char **err);
const hardmeter_template_t *hardmeter_get_templates(const char **err);
const hardmeter_template_t *hardmeter_search_template(const char *name, const char **err);

hardmeter_t *hardmeter_open(const hardmeter_option_t *opt, const char **err);
hardmeter_t *hardmeter_attach_process(const hardmeter_option_t *opt, pid_t pid, const char **err);
hardmeter_t *hardmeter_start_process(const hardmeter_option_t *opt, const char *file, char *const argv[], const char **err);
int hardmeter_dump(hardmeter_t *h, const char *filename, int non_blocking, const char **err);
int hardmeter_terminate(hardmeter_t *h, const char **err);
int hardmeter_close(hardmeter_t *h, const char **err);

/* p4_template.c */
extern hardmeter_template_t hardmeter_p4_template[];
int hardmeter_p4_fill_control(struct vperfctr_control *dest, const hardmeter_option_t *opt);

/* rc.c */
extern int hardmeter_parse_rc(struct hardmeter_option_t *opt, char **filenamep, const char *name, const char **err);

/* self.c */
int hardmeter_start(const char *name);
int hardmeter_stop(void);

#endif
