#include <spcf/core.hpp>
#include <spcf/engine-factory/EngineFactory.hpp>
#include <spcf/grammar/GrammarCommonImpl.hpp>
#include <spcf/processor/DefaultProcessor.hpp>
#include <spcf/view/DefaultView.hpp>

#include <iostream>

using namespace spcf;
using namespace std;

class HelloWorldGrammar : public GrammarCommonImpl {
public:
	HelloWorldGrammar() : GrammarCommonImpl("helloWorld") {
		addGrammarTransition("n[[h", Grammar::START_STATE_NAME, Grammar::FINISH_STATE_NAME);
	}
};

class HelloWorldProcessor : public DefaultProcessor {
public:
	void start(Context& context) {
		getController().getEngine()->addGrammar(GrammarPtr(new HelloWorldGrammar()));
	}

	void recognized(Context& context, Recognition& recognition) {
		getController().stop();
	}
};

class HelloWorldView : public DefaultView {
public:
	void recognized(Context& context, Recognition& recognition) {
		cout << recognition.getText() << endl;
	}
};

int main() {
	Controller controller;
	controller.setEngine(EngineFactory::getEngine(EngineFactory::SAPI_ENGINE));
	controller.setProcessor(ProcessorPtr(new HelloWorldProcessor()));
	controller.setView(ViewPtr(new HelloWorldView()));
	controller.start();

	return 0;
}
