/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Recognition.hpp 26 2011-05-10 12:09:48Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_RECOGNITION_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_RECOGNITION_HPP_

#include <deque>
#include <string>

#include <boost/shared_ptr.hpp>

namespace spcf {

	class RecognitionProperty;
	typedef boost::shared_ptr<RecognitionProperty> RecognitionPropertyPtr;
	typedef std::deque<RecognitionPropertyPtr> RecognitionPropertyContainer;
	typedef RecognitionPropertyContainer::iterator RecognitionPropertyIterator;
	typedef RecognitionPropertyContainer::const_iterator RecognitionPropertyConstIterator;

	class Recognition {
	public:
		Recognition();
		virtual ~Recognition();

	private:
		Recognition(const Recognition& recognition);
		Recognition& operator=(const Recognition& recognition);

	public:
		virtual std::string getText() = 0;
		virtual std::string getGrammarName() = 0;

	public:
		virtual size_t sizeOfProperties() const = 0;
		virtual RecognitionPropertyIterator beginProperty() = 0;
		virtual RecognitionPropertyConstIterator beginProperty() const = 0;
		virtual RecognitionPropertyIterator endProperty() = 0;
		virtual RecognitionPropertyConstIterator endProperty() const = 0;

	public:
		virtual size_t sizeOfProperties(const std::string& name) const = 0;
		virtual RecognitionPropertyPtr getProperty(size_t index) const = 0;
		virtual RecognitionPropertyPtr getProperty(const std::string& name) const = 0;
		virtual RecognitionPropertyPtr getProperty(const std::string& name, size_t n) const = 0;
	};

}  // namespace spcf

#endif
