/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Controller.hpp 19 2011-05-09 14:08:18Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_CONTROLLER_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_CONTROLLER_HPP_

#include <boost/shared_ptr.hpp>

namespace spcf {

	class Engine;
	typedef boost::shared_ptr<Engine> EnginePtr;

	class Grammar;
	typedef boost::shared_ptr<Grammar> GrammarPtr;

	class Processor;
	typedef boost::shared_ptr<Processor> ProcessorPtr;

	class View;
	typedef boost::shared_ptr<View> ViewPtr;

	class Recognition;

	class Controller_i;

	class Controller {
	private:
		Controller_i* impl;

	public:
		Controller();
		virtual ~Controller();

	private:
		Controller(const Controller& controller);
		Controller& operator=(const Controller& controller);

	public:
		const EnginePtr& getEngine() const;
		void setEngine(const EnginePtr& engine);

		const ProcessorPtr& getProcessor() const;
		void setProcessor(const ProcessorPtr& processor);

		const ViewPtr& getView() const;
		void setView(const ViewPtr& view);

	public:
		void start();
		void soundStarted();
		void soundStoped();
		void recognized(Recognition& recognition);
		void stop();
	};

}  // namespace spcf

#endif
