//  exception_storage.hpp: a storage object for exception's infomation

//  Copyright Takeshi Mouri 2006.
//  Use, modification, and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef HAMIGAKI_THREAD_EXCEPTION_STORAGE_HPP
#define HAMIGAKI_THREAD_EXCEPTION_STORAGE_HPP

#include <exception>
#include <string>

namespace hamigaki { namespace thread {

struct null_exception_storage
{
    void reset() const {}
    void store() const {}
};

class exception_storage
{
public:
    void reset()
    {
        what_.clear();
    }

    void store()
    {
        try
        {
            throw;
        }
        catch (const std::exception& e)
        {
            try
            {
                what_ = e.what();
            }
            catch (...)
            {
            }
        }
        catch (...)
        {
        }
    }

    const std::string& what() const { return what_; }

private:
    std::string what_;
};

} } // End namespaces thread, hamigaki.

#endif // HAMIGAKI_THREAD_EXCEPTION_STORAGE_HPP
