// Don't edit this file. This has been generated by Functions.cpp.gura.
#include "stdafx.h"

#if defined(GURA_ON_MSWIN)
typedef char GLchar;
#endif

Gura_BeginModuleScope(opengl)

// opengl.glewInit
Gura_DeclareFunctionAlias(__glewInit, "glewInit")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"Initializes the extension entry points.\n");
}

Gura_ImplementFunction(__glewInit)
{
#if defined(__GLEW_H__)
	SetupGLEW(env);
#endif
	return Value::Nil;
}

// opengl.glAccum
Gura_DeclareFunctionAlias(__glAccum, "glAccum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "op", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"operate on the accumulation buffer\n");
}

Gura_ImplementFunction(__glAccum)
{
	GLenum op = static_cast<GLenum>(arg.GetInt(0));
	GLfloat value = arg.GetFloat(1);
	glAccum(op, value);
	return Value::Nil;
}

// opengl.glAlphaFunc
Gura_DeclareFunctionAlias(__glAlphaFunc, "glAlphaFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ref", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"specify the alpha test function\n");
}

Gura_ImplementFunction(__glAlphaFunc)
{
	GLenum func = static_cast<GLenum>(arg.GetInt(0));
	GLclampf ref = arg.GetFloat(1);
	glAlphaFunc(func, ref);
	return Value::Nil;
}

// opengl.glAreTexturesResident
Gura_DeclareFunctionAlias(__glAreTexturesResident, "glAreTexturesResident")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "textures", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"determine if textures are loaded in texture memory\n");
}

Gura_ImplementFunction(__glAreTexturesResident)
{
	ArrayT<UInt> *_textures = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	GLsizei n = _textures->GetElemNum();
	AutoPtr<ArrayT<GLboolean> > _residences(new ArrayT<GLboolean>(n));
	GLboolean *residences = _residences->GetPointer();
	GLboolean _rtn = glAreTexturesResident(n, textures, residences);
	if (_rtn == 0) return Value::Nil;
	Value _rtnVal;
	Object_list *pObjList = _rtnVal.InitAsList(env, n);
	for (GLsizei i = 0; i < n; i++) {
		pObjList->Add(residences[i] != 0);
	}
	return ReturnValue(env, arg, _rtnVal);
}

// opengl.glArrayElement
Gura_DeclareFunctionAlias(__glArrayElement, "glArrayElement")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"render a vertex using the specified vertex array element\n");
}

Gura_ImplementFunction(__glArrayElement)
{
	GLint i = arg.GetInt(0);
	glArrayElement(i);
	return Value::Nil;
}

// opengl.glBegin
Gura_DeclareFunctionAlias(__glBegin, "glBegin")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"delimit the vertices of a primitive or a group of like primitives\n");
}

Gura_ImplementFunction(__glBegin)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glBegin(mode);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glEnd();
	}
	return Value::Nil;
}

// opengl.glBindTexture
Gura_DeclareFunctionAlias(__glBindTexture, "glBindTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBindTexture)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLuint texture = arg.GetUInt(1);
	glBindTexture(target, texture);
	return Value::Nil;
}

// opengl.glBitmap
Gura_DeclareFunctionAlias(__glBitmap, "glBitmap")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xorig", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yorig", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xmove", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ymove", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bitmap", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBitmap)
{
	GLsizei width = arg.GetInt(0);
	GLsizei height = arg.GetInt(1);
	GLfloat xorig = arg.GetFloat(2);
	GLfloat yorig = arg.GetFloat(3);
	GLfloat xmove = arg.GetFloat(4);
	GLfloat ymove = arg.GetFloat(5);
	ArrayT<UInt8> *_bitmap = arg.IsValid(6)? Object_arrayT<UInt8>::GetObject(arg, 6)->GetArrayT() : nullptr;
	GLubyte *bitmap = (_bitmap == nullptr)? nullptr : reinterpret_cast<GLubyte *>(_bitmap->GetPointer());
	if (_bitmap != nullptr) {
		size_t bytesReq = ((width + 7) / 8) * height;
		if (_bitmap->GetElemNum() < bytesReq) {
			env.SetError(ERR_ValueError, "array doesn\'t contain enough data");
			return Value::Nil;
		}
	}
	glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
	return Value::Nil;
}

// opengl.glBlendColor
Gura_DeclareFunctionAlias(__glBlendColor, "glBlendColor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBlendColor)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLclampf red = arg.GetFloat(0);
	GLclampf green = arg.GetFloat(1);
	GLclampf blue = arg.GetFloat(2);
	GLclampf alpha = arg.GetFloat(3);
	glBlendColor(red, green, blue, alpha);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glBlendEquation
Gura_DeclareFunctionAlias(__glBlendEquation, "glBlendEquation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBlendEquation)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glBlendEquation(mode);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glBlendEquationSeparate
Gura_DeclareFunctionAlias(__glBlendEquationSeparate, "glBlendEquationSeparate")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "modeRGB", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "modeAlpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBlendEquationSeparate)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLenum modeRGB = static_cast<GLenum>(arg.GetInt(0));
	GLenum modeAlpha = static_cast<GLenum>(arg.GetInt(1));
	glBlendEquationSeparate(modeRGB, modeAlpha);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glBlendFunc
Gura_DeclareFunctionAlias(__glBlendFunc, "glBlendFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "sfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "dfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBlendFunc)
{
	GLenum sfactor = static_cast<GLenum>(arg.GetInt(0));
	GLenum dfactor = static_cast<GLenum>(arg.GetInt(1));
	glBlendFunc(sfactor, dfactor);
	return Value::Nil;
}

// opengl.glCallList
Gura_DeclareFunctionAlias(__glCallList, "glCallList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCallList)
{
	GLuint list = arg.GetUInt(0);
	glCallList(list);
	return Value::Nil;
}

// opengl.glCallLists
Gura_DeclareFunctionAlias(__glCallLists, "glCallLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "lists", VTYPE_number, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCallLists)
{
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	const ValueList & lists = arg.GetList(1);
	const ValueList &lists_in = arg.GetList(1);
	GLsizei n = static_cast<GLsizei>(lists.size());
	AutoPtr<Memory> pListsBuff;
	if (type == GL_BYTE) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLbyte) * n));
		GLbyte *p = reinterpret_cast<GLbyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetChar(); }
	} else if (type == GL_UNSIGNED_BYTE) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUChar(); }
	} else if (type == GL_SHORT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLshort) * n));
		GLshort *p = reinterpret_cast<GLshort *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetShort(); }
	} else if (type == GL_UNSIGNED_SHORT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLushort) * n));
		GLushort *p = reinterpret_cast<GLushort *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUShort(); }
	} else if (type == GL_INT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLint) * n));
		GLint *p = reinterpret_cast<GLint *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetInt(); }
	} else if (type == GL_UNSIGNED_INT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLuint) * n));
		GLuint *p = reinterpret_cast<GLuint *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUInt(); }
	} else if (type == GL_FLOAT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLfloat) * n));
		GLfloat *p = reinterpret_cast<GLfloat *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetFloat(); }
	} else if (type == GL_2_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 2 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			UShort num = pValue->GetUShort();
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_3_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 3 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			ULong num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_4_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 4 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			ULong num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 24);
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else {
		env.SetError(ERR_ValueError, "invalid type specification");
		return Value::Nil;
	}
	// GLsizei n, GLenum type, const GLvoid *lists
	glCallLists(n, type, pListsBuff->GetPointer());
	return Value::Nil;
}

// opengl.glClear
Gura_DeclareFunctionAlias(__glClear, "glClear")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClear)
{
	GLbitfield mask = arg.GetUInt(0);
	glClear(mask);
	return Value::Nil;
}

// opengl.glClearAccum
Gura_DeclareFunctionAlias(__glClearAccum, "glClearAccum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClearAccum)
{
	GLfloat red = arg.GetFloat(0);
	GLfloat green = arg.GetFloat(1);
	GLfloat blue = arg.GetFloat(2);
	GLfloat alpha = arg.GetFloat(3);
	glClearAccum(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glClearColor
Gura_DeclareFunctionAlias(__glClearColor, "glClearColor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClearColor)
{
	GLclampf red = arg.GetFloat(0);
	GLclampf green = arg.GetFloat(1);
	GLclampf blue = arg.GetFloat(2);
	GLclampf alpha = arg.GetFloat(3);
	glClearColor(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glClearDepth
Gura_DeclareFunctionAlias(__glClearDepth, "glClearDepth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "depth", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClearDepth)
{
	GLclampd depth = arg.GetDouble(0);
	glClearDepth(depth);
	return Value::Nil;
}

// opengl.glClearIndex
Gura_DeclareFunctionAlias(__glClearIndex, "glClearIndex")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClearIndex)
{
	GLfloat c = arg.GetFloat(0);
	glClearIndex(c);
	return Value::Nil;
}

// opengl.glClearStencil
Gura_DeclareFunctionAlias(__glClearStencil, "glClearStencil")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClearStencil)
{
	GLint s = arg.GetInt(0);
	glClearStencil(s);
	return Value::Nil;
}

// opengl.glClipPlane
Gura_DeclareFunctionAlias(__glClipPlane, "glClipPlane")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "plane", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "equation", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClipPlane)
{
	GLenum plane = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<double> *_equation = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *equation = reinterpret_cast<GLdouble *>(_equation->GetPointer());
	if (!_equation->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glClipPlane(plane, equation);
	return Value::Nil;
}

// opengl.glColor3b
Gura_DeclareFunctionAlias(__glColor3b, "glColor3b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3b)
{
	GLbyte red = arg.GetChar(0);
	GLbyte green = arg.GetChar(1);
	GLbyte blue = arg.GetChar(2);
	glColor3b(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3bv
Gura_DeclareFunctionAlias(__glColor3bv, "glColor3bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3bv)
{
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 0)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3bv(v);
	return Value::Nil;
}

// opengl.glColor3d
Gura_DeclareFunctionAlias(__glColor3d, "glColor3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3d)
{
	GLdouble red = arg.GetDouble(0);
	GLdouble green = arg.GetDouble(1);
	GLdouble blue = arg.GetDouble(2);
	glColor3d(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3dv
Gura_DeclareFunctionAlias(__glColor3dv, "glColor3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3dv(v);
	return Value::Nil;
}

// opengl.glColor3f
Gura_DeclareFunctionAlias(__glColor3f, "glColor3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3f)
{
	GLfloat red = arg.GetFloat(0);
	GLfloat green = arg.GetFloat(1);
	GLfloat blue = arg.GetFloat(2);
	glColor3f(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3fv
Gura_DeclareFunctionAlias(__glColor3fv, "glColor3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3fv(v);
	return Value::Nil;
}

// opengl.glColor3i
Gura_DeclareFunctionAlias(__glColor3i, "glColor3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3i)
{
	GLint red = arg.GetInt(0);
	GLint green = arg.GetInt(1);
	GLint blue = arg.GetInt(2);
	glColor3i(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3iv
Gura_DeclareFunctionAlias(__glColor3iv, "glColor3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3iv(v);
	return Value::Nil;
}

// opengl.glColor3s
Gura_DeclareFunctionAlias(__glColor3s, "glColor3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3s)
{
	GLshort red = arg.GetShort(0);
	GLshort green = arg.GetShort(1);
	GLshort blue = arg.GetShort(2);
	glColor3s(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3sv
Gura_DeclareFunctionAlias(__glColor3sv, "glColor3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3sv(v);
	return Value::Nil;
}

// opengl.glColor3ub
Gura_DeclareFunctionAlias(__glColor3ub, "glColor3ub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3ub)
{
	GLubyte red = arg.GetUChar(0);
	GLubyte green = arg.GetUChar(1);
	GLubyte blue = arg.GetUChar(2);
	glColor3ub(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3ubv
Gura_DeclareFunctionAlias(__glColor3ubv, "glColor3ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3ubv)
{
	ArrayT<UInt8> *_v = Object_arrayT<UInt8>::GetObject(arg, 0)->GetArrayT();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3ubv(v);
	return Value::Nil;
}

// opengl.glColor3ui
Gura_DeclareFunctionAlias(__glColor3ui, "glColor3ui")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3ui)
{
	GLuint red = arg.GetUInt(0);
	GLuint green = arg.GetUInt(1);
	GLuint blue = arg.GetUInt(2);
	glColor3ui(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3uiv
Gura_DeclareFunctionAlias(__glColor3uiv, "glColor3uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3uiv)
{
	ArrayT<UInt> *_v = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3uiv(v);
	return Value::Nil;
}

// opengl.glColor3us
Gura_DeclareFunctionAlias(__glColor3us, "glColor3us")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3us)
{
	GLushort red = arg.GetUShort(0);
	GLushort green = arg.GetUShort(1);
	GLushort blue = arg.GetUShort(2);
	glColor3us(red, green, blue);
	return Value::Nil;
}

// opengl.glColor3usv
Gura_DeclareFunctionAlias(__glColor3usv, "glColor3usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor3usv)
{
	ArrayT<UInt16> *_v = Object_arrayT<UInt16>::GetObject(arg, 0)->GetArrayT();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor3usv(v);
	return Value::Nil;
}

// opengl.glColor4b
Gura_DeclareFunctionAlias(__glColor4b, "glColor4b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4b)
{
	GLbyte red = arg.GetChar(0);
	GLbyte green = arg.GetChar(1);
	GLbyte blue = arg.GetChar(2);
	GLbyte alpha = arg.GetChar(3);
	glColor4b(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4bv
Gura_DeclareFunctionAlias(__glColor4bv, "glColor4bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4bv)
{
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 0)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4bv(v);
	return Value::Nil;
}

// opengl.glColor4d
Gura_DeclareFunctionAlias(__glColor4d, "glColor4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4d)
{
	GLdouble red = arg.GetDouble(0);
	GLdouble green = arg.GetDouble(1);
	GLdouble blue = arg.GetDouble(2);
	GLdouble alpha = arg.GetDouble(3);
	glColor4d(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4dv
Gura_DeclareFunctionAlias(__glColor4dv, "glColor4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glColor4dv(v);
	return Value::Nil;
}

// opengl.glColor4f
Gura_DeclareFunctionAlias(__glColor4f, "glColor4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4f)
{
	GLfloat red = arg.GetFloat(0);
	GLfloat green = arg.GetFloat(1);
	GLfloat blue = arg.GetFloat(2);
	GLfloat alpha = arg.GetFloat(3);
	glColor4f(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4fv
Gura_DeclareFunctionAlias(__glColor4fv, "glColor4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glColor4fv(v);
	return Value::Nil;
}

// opengl.glColor4i
Gura_DeclareFunctionAlias(__glColor4i, "glColor4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4i)
{
	GLint red = arg.GetInt(0);
	GLint green = arg.GetInt(1);
	GLint blue = arg.GetInt(2);
	GLint alpha = arg.GetInt(3);
	glColor4i(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4iv
Gura_DeclareFunctionAlias(__glColor4iv, "glColor4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4iv(v);
	return Value::Nil;
}

// opengl.glColor4s
Gura_DeclareFunctionAlias(__glColor4s, "glColor4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4s)
{
	GLshort red = arg.GetShort(0);
	GLshort green = arg.GetShort(1);
	GLshort blue = arg.GetShort(2);
	GLshort alpha = arg.GetShort(3);
	glColor4s(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4sv
Gura_DeclareFunctionAlias(__glColor4sv, "glColor4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4sv(v);
	return Value::Nil;
}

// opengl.glColor4ub
Gura_DeclareFunctionAlias(__glColor4ub, "glColor4ub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4ub)
{
	GLubyte red = arg.GetUChar(0);
	GLubyte green = arg.GetUChar(1);
	GLubyte blue = arg.GetUChar(2);
	GLubyte alpha = arg.GetUChar(3);
	glColor4ub(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4ubv
Gura_DeclareFunctionAlias(__glColor4ubv, "glColor4ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4ubv)
{
	ArrayT<UInt8> *_v = Object_arrayT<UInt8>::GetObject(arg, 0)->GetArrayT();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4ubv(v);
	return Value::Nil;
}

// opengl.glColor4ui
Gura_DeclareFunctionAlias(__glColor4ui, "glColor4ui")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4ui)
{
	GLuint red = arg.GetUInt(0);
	GLuint green = arg.GetUInt(1);
	GLuint blue = arg.GetUInt(2);
	GLuint alpha = arg.GetUInt(3);
	glColor4ui(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4uiv
Gura_DeclareFunctionAlias(__glColor4uiv, "glColor4uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4uiv)
{
	ArrayT<UInt> *_v = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4uiv(v);
	return Value::Nil;
}

// opengl.glColor4us
Gura_DeclareFunctionAlias(__glColor4us, "glColor4us")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4us)
{
	GLushort red = arg.GetUShort(0);
	GLushort green = arg.GetUShort(1);
	GLushort blue = arg.GetUShort(2);
	GLushort alpha = arg.GetUShort(3);
	glColor4us(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColor4usv
Gura_DeclareFunctionAlias(__glColor4usv, "glColor4usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColor4usv)
{
	ArrayT<UInt16> *_v = Object_arrayT<UInt16>::GetObject(arg, 0)->GetArrayT();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glColor4usv(v);
	return Value::Nil;
}

// opengl.glColorMask
Gura_DeclareFunctionAlias(__glColorMask, "glColorMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColorMask)
{
	GLboolean red = (arg.GetBoolean(0)? GL_TRUE : GL_FALSE);
	GLboolean green = (arg.GetBoolean(1)? GL_TRUE : GL_FALSE);
	GLboolean blue = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	GLboolean alpha = (arg.GetBoolean(3)? GL_TRUE : GL_FALSE);
	glColorMask(red, green, blue, alpha);
	return Value::Nil;
}

// opengl.glColorMaterial
Gura_DeclareFunctionAlias(__glColorMaterial, "glColorMaterial")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColorMaterial)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum mode = static_cast<GLenum>(arg.GetInt(1));
	glColorMaterial(face, mode);
	return Value::Nil;
}

// opengl.glColorTableParameterfv
Gura_DeclareFunctionAlias(__glColorTableParameterfv, "glColorTableParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColorTableParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glColorTableParameterfv(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glColorTableParameteriv
Gura_DeclareFunctionAlias(__glColorTableParameteriv, "glColorTableParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glColorTableParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glColorTableParameteriv(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glConvolutionParameterf
Gura_DeclareFunctionAlias(__glConvolutionParameterf, "glConvolutionParameterf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glConvolutionParameterf)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat params = arg.GetFloat(2);
	glConvolutionParameterf(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glConvolutionParameterfv
Gura_DeclareFunctionAlias(__glConvolutionParameterfv, "glConvolutionParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glConvolutionParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glConvolutionParameterfv(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glConvolutionParameteri
Gura_DeclareFunctionAlias(__glConvolutionParameteri, "glConvolutionParameteri")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glConvolutionParameteri)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint params = arg.GetInt(2);
	glConvolutionParameteri(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glConvolutionParameteriv
Gura_DeclareFunctionAlias(__glConvolutionParameteriv, "glConvolutionParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glConvolutionParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glConvolutionParameteriv(target, pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCopyColorSubTable
Gura_DeclareFunctionAlias(__glCopyColorSubTable, "glCopyColorSubTable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "start", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyColorSubTable)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLsizei start = arg.GetInt(1);
	GLint x = arg.GetInt(2);
	GLint y = arg.GetInt(3);
	GLsizei width = arg.GetInt(4);
	glCopyColorSubTable(target, start, x, y, width);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCopyColorTable
Gura_DeclareFunctionAlias(__glCopyColorTable, "glCopyColorTable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyColorTable)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(1));
	GLint x = arg.GetInt(2);
	GLint y = arg.GetInt(3);
	GLsizei width = arg.GetInt(4);
	glCopyColorTable(target, internalformat, x, y, width);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCopyConvolutionFilter1D
Gura_DeclareFunctionAlias(__glCopyConvolutionFilter1D, "glCopyConvolutionFilter1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyConvolutionFilter1D)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(1));
	GLint x = arg.GetInt(2);
	GLint y = arg.GetInt(3);
	GLsizei width = arg.GetInt(4);
	glCopyConvolutionFilter1D(target, internalformat, x, y, width);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCopyConvolutionFilter2D
Gura_DeclareFunctionAlias(__glCopyConvolutionFilter2D, "glCopyConvolutionFilter2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyConvolutionFilter2D)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(1));
	GLint x = arg.GetInt(2);
	GLint y = arg.GetInt(3);
	GLsizei width = arg.GetInt(4);
	GLsizei height = arg.GetInt(5);
	glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCopyPixels
Gura_DeclareFunctionAlias(__glCopyPixels, "glCopyPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyPixels)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLsizei width = arg.GetInt(2);
	GLsizei height = arg.GetInt(3);
	GLenum type = static_cast<GLenum>(arg.GetInt(4));
	glCopyPixels(x, y, width, height, type);
	return Value::Nil;
}

// opengl.glCopyTexImage1D
Gura_DeclareFunctionAlias(__glCopyTexImage1D, "glCopyTexImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyTexImage1D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(2));
	GLint x = arg.GetInt(3);
	GLint y = arg.GetInt(4);
	GLsizei width = arg.GetInt(5);
	GLint border = arg.GetInt(6);
	glCopyTexImage1D(target, level, internalformat, x, y, width, border);
	return Value::Nil;
}

// opengl.glCopyTexImage2D
Gura_DeclareFunctionAlias(__glCopyTexImage2D, "glCopyTexImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyTexImage2D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(2));
	GLint x = arg.GetInt(3);
	GLint y = arg.GetInt(4);
	GLsizei width = arg.GetInt(5);
	GLsizei height = arg.GetInt(6);
	GLint border = arg.GetInt(7);
	glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
	return Value::Nil;
}

// opengl.glCopyTexSubImage1D
Gura_DeclareFunctionAlias(__glCopyTexSubImage1D, "glCopyTexSubImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyTexSubImage1D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLint x = arg.GetInt(3);
	GLint y = arg.GetInt(4);
	GLsizei width = arg.GetInt(5);
	glCopyTexSubImage1D(target, level, xoffset, x, y, width);
	return Value::Nil;
}

// opengl.glCopyTexSubImage2D
Gura_DeclareFunctionAlias(__glCopyTexSubImage2D, "glCopyTexSubImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyTexSubImage2D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLint yoffset = arg.GetInt(3);
	GLint x = arg.GetInt(4);
	GLint y = arg.GetInt(5);
	GLsizei width = arg.GetInt(6);
	GLsizei height = arg.GetInt(7);
	glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
	return Value::Nil;
}

// opengl.glCopyTexSubImage3D
Gura_DeclareFunctionAlias(__glCopyTexSubImage3D, "glCopyTexSubImage3D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCopyTexSubImage3D)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLint yoffset = arg.GetInt(3);
	GLint zoffset = arg.GetInt(4);
	GLint x = arg.GetInt(5);
	GLint y = arg.GetInt(6);
	GLsizei width = arg.GetInt(7);
	GLsizei height = arg.GetInt(8);
	glCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glCullFace
Gura_DeclareFunctionAlias(__glCullFace, "glCullFace")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCullFace)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glCullFace(mode);
	return Value::Nil;
}

// opengl.glDeleteLists
Gura_DeclareFunctionAlias(__glDeleteLists, "glDeleteLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "range", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteLists)
{
	GLuint list = arg.GetUInt(0);
	GLsizei range = arg.GetInt(1);
	glDeleteLists(list, range);
	return Value::Nil;
}

// opengl.glDeleteTextures
Gura_DeclareFunctionAlias(__glDeleteTextures, "glDeleteTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "textures", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteTextures)
{
	ArrayT<UInt> *_textures = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	GLsizei n = _textures->GetElemNum();
	glDeleteTextures(n, textures);
	return Value::Nil;
}

// opengl.glDepthFunc
Gura_DeclareFunctionAlias(__glDepthFunc, "glDepthFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDepthFunc)
{
	GLenum func = static_cast<GLenum>(arg.GetInt(0));
	glDepthFunc(func);
	return Value::Nil;
}

// opengl.glDepthMask
Gura_DeclareFunctionAlias(__glDepthMask, "glDepthMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDepthMask)
{
	GLboolean flag = (arg.GetBoolean(0)? GL_TRUE : GL_FALSE);
	glDepthMask(flag);
	return Value::Nil;
}

// opengl.glDepthRange
Gura_DeclareFunctionAlias(__glDepthRange, "glDepthRange")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDepthRange)
{
	GLclampd zNear = arg.GetDouble(0);
	GLclampd zFar = arg.GetDouble(1);
	glDepthRange(zNear, zFar);
	return Value::Nil;
}

// opengl.glDisable
Gura_DeclareFunctionAlias(__glDisable, "glDisable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDisable)
{
	GLenum cap = static_cast<GLenum>(arg.GetInt(0));
	glDisable(cap);
	return Value::Nil;
}

// opengl.glDisableClientState
Gura_DeclareFunctionAlias(__glDisableClientState, "glDisableClientState")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "array", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDisableClientState)
{
	GLenum array = static_cast<GLenum>(arg.GetInt(0));
	glDisableClientState(array);
	return Value::Nil;
}

// opengl.glDrawArrays
Gura_DeclareFunctionAlias(__glDrawArrays, "glDrawArrays")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "first", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDrawArrays)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	GLint first = arg.GetInt(1);
	GLsizei count = arg.GetInt(2);
	glDrawArrays(mode, first, count);
	return Value::Nil;
}

// opengl.glDrawBuffer
Gura_DeclareFunctionAlias(__glDrawBuffer, "glDrawBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDrawBuffer)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glDrawBuffer(mode);
	return Value::Nil;
}

// opengl.glDrawPixels
Gura_DeclareFunctionAlias(__glDrawPixels, "glDrawPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_array, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDrawPixels)
{
	GLsizei width = arg.GetInt(0);
	GLsizei height = arg.GetInt(1);
	GLenum format = static_cast<GLenum>(arg.GetInt(2));
	GLenum type = static_cast<GLenum>(arg.GetInt(3));
	Array *pixels = Object_array::GetObject(arg, 4)->GetArray();
	
	const void *p = GetArrayTPointer(env, type, pixels);
	if (p == nullptr) return Value::Nil;
	glDrawPixels(width, height, format, type, p);
	return Value::Nil;
}

// opengl.glDrawPixelsFromImage
Gura_DeclareFunctionAlias(__glDrawPixelsFromImage, "glDrawPixelsFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDrawPixelsFromImage)
{
	Image *image = Object_image::GetObject(arg, 0)->GetImage();
	
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLsizei height = static_cast<GLsizei>(image->GetHeight());
	GLenum format = GetImageFormat(env, image);
	if (env.IsSignalled()) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = image->GetBuffer();
	// GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels
	glDrawPixels(width, height, format, type, pixels);
	return Value::Nil;
}

// opengl.glEdgeFlag
Gura_DeclareFunctionAlias(__glEdgeFlag, "glEdgeFlag")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEdgeFlag)
{
	GLboolean flag = (arg.GetBoolean(0)? GL_TRUE : GL_FALSE);
	glEdgeFlag(flag);
	return Value::Nil;
}

// opengl.glEdgeFlagv
Gura_DeclareFunctionAlias(__glEdgeFlagv, "glEdgeFlagv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEdgeFlagv)
{
	AutoPtr<ArrayT<GLboolean> > _flag(ArrayT<GLboolean>::CreateFromList(arg.GetList(0)));
	GLboolean *flag = _flag->GetPointer();
	if (!_flag->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glEdgeFlagv(flag);
	return Value::Nil;
}

// opengl.glEnable
Gura_DeclareFunctionAlias(__glEnable, "glEnable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEnable)
{
	GLenum cap = static_cast<GLenum>(arg.GetInt(0));
	glEnable(cap);
	return Value::Nil;
}

// opengl.glEnableClientState
Gura_DeclareFunctionAlias(__glEnableClientState, "glEnableClientState")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "array", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEnableClientState)
{
	GLenum array = static_cast<GLenum>(arg.GetInt(0));
	glEnableClientState(array);
	return Value::Nil;
}

// opengl.glEnd
Gura_DeclareFunctionAlias(__glEnd, "glEnd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEnd)
{
	glEnd();
	return Value::Nil;
}

// opengl.glEndList
Gura_DeclareFunctionAlias(__glEndList, "glEndList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEndList)
{
	glEndList();
	return Value::Nil;
}

// opengl.glEvalCoord1d
Gura_DeclareFunctionAlias(__glEvalCoord1d, "glEvalCoord1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord1d)
{
	GLdouble u = arg.GetDouble(0);
	glEvalCoord1d(u);
	return Value::Nil;
}

// opengl.glEvalCoord1dv
Gura_DeclareFunctionAlias(__glEvalCoord1dv, "glEvalCoord1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord1dv)
{
	ArrayT<double> *_u = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *u = reinterpret_cast<GLdouble *>(_u->GetPointer());
	if (!_u->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glEvalCoord1dv(u);
	return Value::Nil;
}

// opengl.glEvalCoord1f
Gura_DeclareFunctionAlias(__glEvalCoord1f, "glEvalCoord1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord1f)
{
	GLfloat u = arg.GetFloat(0);
	glEvalCoord1f(u);
	return Value::Nil;
}

// opengl.glEvalCoord1fv
Gura_DeclareFunctionAlias(__glEvalCoord1fv, "glEvalCoord1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord1fv)
{
	ArrayT<float> *_u = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *u = reinterpret_cast<GLfloat *>(_u->GetPointer());
	if (!_u->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glEvalCoord1fv(u);
	return Value::Nil;
}

// opengl.glEvalCoord2d
Gura_DeclareFunctionAlias(__glEvalCoord2d, "glEvalCoord2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord2d)
{
	GLdouble u = arg.GetDouble(0);
	GLdouble v = arg.GetDouble(1);
	glEvalCoord2d(u, v);
	return Value::Nil;
}

// opengl.glEvalCoord2dv
Gura_DeclareFunctionAlias(__glEvalCoord2dv, "glEvalCoord2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord2dv)
{
	ArrayT<double> *_u = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *u = reinterpret_cast<GLdouble *>(_u->GetPointer());
	if (!_u->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glEvalCoord2dv(u);
	return Value::Nil;
}

// opengl.glEvalCoord2f
Gura_DeclareFunctionAlias(__glEvalCoord2f, "glEvalCoord2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord2f)
{
	GLfloat u = arg.GetFloat(0);
	GLfloat v = arg.GetFloat(1);
	glEvalCoord2f(u, v);
	return Value::Nil;
}

// opengl.glEvalCoord2fv
Gura_DeclareFunctionAlias(__glEvalCoord2fv, "glEvalCoord2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalCoord2fv)
{
	ArrayT<float> *_u = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *u = reinterpret_cast<GLfloat *>(_u->GetPointer());
	if (!_u->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glEvalCoord2fv(u);
	return Value::Nil;
}

// opengl.glEvalMesh1
Gura_DeclareFunctionAlias(__glEvalMesh1, "glEvalMesh1")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalMesh1)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	GLint i1 = arg.GetInt(1);
	GLint i2 = arg.GetInt(2);
	glEvalMesh1(mode, i1, i2);
	return Value::Nil;
}

// opengl.glEvalMesh2
Gura_DeclareFunctionAlias(__glEvalMesh2, "glEvalMesh2")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalMesh2)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	GLint i1 = arg.GetInt(1);
	GLint i2 = arg.GetInt(2);
	GLint j1 = arg.GetInt(3);
	GLint j2 = arg.GetInt(4);
	glEvalMesh2(mode, i1, i2, j1, j2);
	return Value::Nil;
}

// opengl.glEvalPoint1
Gura_DeclareFunctionAlias(__glEvalPoint1, "glEvalPoint1")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalPoint1)
{
	GLint i = arg.GetInt(0);
	glEvalPoint1(i);
	return Value::Nil;
}

// opengl.glEvalPoint2
Gura_DeclareFunctionAlias(__glEvalPoint2, "glEvalPoint2")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEvalPoint2)
{
	GLint i = arg.GetInt(0);
	GLint j = arg.GetInt(1);
	glEvalPoint2(i, j);
	return Value::Nil;
}

// opengl.glFeedbackBuffer
Gura_DeclareFunctionAlias(__glFeedbackBuffer, "glFeedbackBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "buffer", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFeedbackBuffer)
{
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *buffer = arg.IsValid(1)? Object_arrayT<float>::GetObject(arg, 1)->GetArrayT() : nullptr;
	if (buffer == nullptr) {
		glFeedbackBuffer(0, type, nullptr);
	} else {
		glFeedbackBuffer(buffer->GetElemNum(), type, buffer->GetPointer());
	}
	return Value::Nil;
}

// opengl.glFinish
Gura_DeclareFunctionAlias(__glFinish, "glFinish")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFinish)
{
	glFinish();
	return Value::Nil;
}

// opengl.glFlush
Gura_DeclareFunctionAlias(__glFlush, "glFlush")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFlush)
{
	glFlush();
	return Value::Nil;
}

// opengl.glFogf
Gura_DeclareFunctionAlias(__glFogf, "glFogf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogf)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLfloat param = arg.GetFloat(1);
	glFogf(pname, param);
	return Value::Nil;
}

// opengl.glFogfv
Gura_DeclareFunctionAlias(__glFogfv, "glFogfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogfv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glFogfv(pname, params);
	return Value::Nil;
}

// opengl.glFogi
Gura_DeclareFunctionAlias(__glFogi, "glFogi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogi)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLint param = arg.GetInt(1);
	glFogi(pname, param);
	return Value::Nil;
}

// opengl.glFogiv
Gura_DeclareFunctionAlias(__glFogiv, "glFogiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogiv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glFogiv(pname, params);
	return Value::Nil;
}

// opengl.glFrontFace
Gura_DeclareFunctionAlias(__glFrontFace, "glFrontFace")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFrontFace)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glFrontFace(mode);
	return Value::Nil;
}

// opengl.glFrustum
Gura_DeclareFunctionAlias(__glFrustum, "glFrustum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "left", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "right", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bottom", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "top", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFrustum)
{
	GLdouble left = arg.GetDouble(0);
	GLdouble right = arg.GetDouble(1);
	GLdouble bottom = arg.GetDouble(2);
	GLdouble top = arg.GetDouble(3);
	GLdouble zNear = arg.GetDouble(4);
	GLdouble zFar = arg.GetDouble(5);
	glFrustum(left, right, bottom, top, zNear, zFar);
	return Value::Nil;
}

// opengl.glGenLists
Gura_DeclareFunctionAlias(__glGenLists, "glGenLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "range", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGenLists)
{
	GLsizei range = arg.GetInt(0);
	GLuint _rtn = glGenLists(range);
	return ReturnValue(env, arg, Value(_rtn));
}

// opengl.glGenTextures
Gura_DeclareFunctionAlias(__glGenTextures, "glGenTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGenTextures)
{
	GLsizei n = arg.GetInt(0);
	AutoPtr<ArrayT<GLuint> > _textures(new ArrayT<GLuint>(n));
	GLuint *textures = _textures->GetPointer();
	glGenTextures(n, textures);
	return Value::CreateList(env, textures, n);
}

// opengl.glGetBooleanv
Gura_DeclareFunctionAlias(__glGetBooleanv, "glGetBooleanv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetBooleanv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLboolean> > _params(new ArrayT<GLboolean>(n));
	GLboolean *params = _params->GetPointer();
	glGetBooleanv(pname, params);
	Value _rtnVal;
	if (n == 1) {
		_rtnVal = Value(params[0]);
	} else {
		Object_list *pObjList = _rtnVal.InitAsList(env, n);
		for (GLsizei i = 0; i < n; i++) {
			pObjList->Add(params[i] != 0);
		}
	}
	return ReturnValue(env, arg, _rtnVal);
}

// opengl.glGetClipPlane
Gura_DeclareFunctionAlias(__glGetClipPlane, "glGetClipPlane")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareArg(env, "plane", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetClipPlane)
{
	GLenum plane = static_cast<GLenum>(arg.GetInt(0));
	GLdouble equation[4];
	glGetClipPlane(plane, equation);
	return ReturnValue(env, arg, Value::CreateList(env, equation, ArraySizeOf(equation)));
}

// opengl.glGetColorTableParameterfv
Gura_DeclareFunctionAlias(__glGetColorTableParameterfv, "glGetColorTableParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetColorTableParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetColorTableParameterfv(target, pname, params);
	return ReturnValue(env, arg, Value::CreateList(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetColorTableParameteriv
Gura_DeclareFunctionAlias(__glGetColorTableParameteriv, "glGetColorTableParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetColorTableParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetColorTableParameteriv(target, pname, params);
	return ReturnValue(env, arg, Value::CreateList(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetConvolutionParameterfv
Gura_DeclareFunctionAlias(__glGetConvolutionParameterfv, "glGetConvolutionParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetConvolutionParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetColorTableParameterfv(target, pname, params);
	return ReturnValue(env, arg, Value::CreateList(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetConvolutionParameteriv
Gura_DeclareFunctionAlias(__glGetConvolutionParameteriv, "glGetConvolutionParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetConvolutionParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetColorTableParameteriv(target, pname, params);
	return ReturnValue(env, arg, Value::CreateList(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetDoublev
Gura_DeclareFunctionAlias(__glGetDoublev, "glGetDoublev")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetDoublev)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLdouble> > _params(new ArrayT<GLdouble>(n));
	GLdouble *params = _params->GetPointer();
	glGetDoublev(pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetError
Gura_DeclareFunctionAlias(__glGetError, "glGetError")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetError)
{
	GLenum _rtn = glGetError();
	return ReturnValue(env, arg, Value(_rtn));
}

// opengl.glGetFloatv
Gura_DeclareFunctionAlias(__glGetFloatv, "glGetFloatv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetFloatv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetFloatv(pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetHistogramParameterfv
Gura_DeclareFunctionAlias(__glGetHistogramParameterfv, "glGetHistogramParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetHistogramParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetHistogramParameterfv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetHistogramParameteriv
Gura_DeclareFunctionAlias(__glGetHistogramParameteriv, "glGetHistogramParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetHistogramParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetHistogramParameteriv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetIntegerv
Gura_DeclareFunctionAlias(__glGetIntegerv, "glGetIntegerv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetIntegerv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetIntegerv(pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetLightfv
Gura_DeclareFunctionAlias(__glGetLightfv, "glGetLightfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetLightfv)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetLightfv(light, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetLightiv
Gura_DeclareFunctionAlias(__glGetLightiv, "glGetLightiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetLightiv)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetLightiv(light, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetMapdv
Gura_DeclareFunctionAlias(__glGetMapdv, "glGetMapdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMapdv)
{
#if 0
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum query = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 2)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	glGetMapdv(target, query, v);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetMapdv");
	return Value::Nil;
}

// opengl.glGetMapfv
Gura_DeclareFunctionAlias(__glGetMapfv, "glGetMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMapfv)
{
#if 0
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum query = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	glGetMapfv(target, query, v);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetMapfv");
	return Value::Nil;
}

// opengl.glGetMapiv
Gura_DeclareFunctionAlias(__glGetMapiv, "glGetMapiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMapiv)
{
#if 0
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum query = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	glGetMapiv(target, query, v);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetMapiv");
	return Value::Nil;
}

// opengl.glGetMaterialfv
Gura_DeclareFunctionAlias(__glGetMaterialfv, "glGetMaterialfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMaterialfv)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetMaterialfv(face, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetMaterialiv
Gura_DeclareFunctionAlias(__glGetMaterialiv, "glGetMaterialiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMaterialiv)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetMaterialiv(face, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetMinmaxParameterfv
Gura_DeclareFunctionAlias(__glGetMinmaxParameterfv, "glGetMinmaxParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMinmaxParameterfv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetMinmaxParameterfv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetMinmaxParameteriv
Gura_DeclareFunctionAlias(__glGetMinmaxParameteriv, "glGetMinmaxParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetMinmaxParameteriv)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetMinmaxParameteriv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glGetPixelMapfv
Gura_DeclareFunctionAlias(__glGetPixelMapfv, "glGetPixelMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetPixelMapfv)
{
#if 0
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_values = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *values = reinterpret_cast<GLfloat *>(_values->GetPointer());
	glGetPixelMapfv(map, values);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetPixelMapfv");
	return Value::Nil;
}

// opengl.glGetPixelMapuiv
Gura_DeclareFunctionAlias(__glGetPixelMapuiv, "glGetPixelMapuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetPixelMapuiv)
{
#if 0
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<UInt> *_values = Object_arrayT<UInt>::GetObject(arg, 1)->GetArrayT();
	GLuint *values = reinterpret_cast<GLuint *>(_values->GetPointer());
	glGetPixelMapuiv(map, values);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetPixelMapuiv");
	return Value::Nil;
}

// opengl.glGetPixelMapusv
Gura_DeclareFunctionAlias(__glGetPixelMapusv, "glGetPixelMapusv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetPixelMapusv)
{
#if 0
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<UInt16> *_values = Object_arrayT<UInt16>::GetObject(arg, 1)->GetArrayT();
	GLushort *values = reinterpret_cast<GLushort *>(_values->GetPointer());
	glGetPixelMapusv(map, values);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetPixelMapusv");
	return Value::Nil;
}

// opengl.glGetPolygonStipple
Gura_DeclareFunctionAlias(__glGetPolygonStipple, "glGetPolygonStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetPolygonStipple)
{
	AutoPtr<ArrayT<UInt8> > pArrayT(new ArrayT<UInt8>(32 * 4));
	glGetPolygonStipple(pArrayT->GetPointer());
	return Value(new Object_arrayT<UInt8>(env, VTYPE_array_at_uint8, pArrayT.release()));
}

// opengl.glGetString
Gura_DeclareFunctionAlias(__glGetString, "glGetString")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetString)
{
	GLenum name = static_cast<GLenum>(arg.GetInt(0));
	const GLubyte *_rtn = glGetString(name);
	if (_rtn == nullptr) {
		env.SetError(ERR_ValueError, "invalid name");
		return Value::Nil;
	}
	return ReturnValue(env, arg, Value(reinterpret_cast<const char *>(_rtn)));
}

// opengl.glGetTexEnvfv
Gura_DeclareFunctionAlias(__glGetTexEnvfv, "glGetTexEnvfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexEnvfv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexEnvfv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexEnviv
Gura_DeclareFunctionAlias(__glGetTexEnviv, "glGetTexEnviv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexEnviv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexEnviv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexGendv
Gura_DeclareFunctionAlias(__glGetTexGendv, "glGetTexGendv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexGendv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLdouble> > _params(new ArrayT<GLdouble>(n));
	GLdouble *params = _params->GetPointer();
	glGetTexGendv(coord, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexGenfv
Gura_DeclareFunctionAlias(__glGetTexGenfv, "glGetTexGenfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexGenfv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexGenfv(coord, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexGeniv
Gura_DeclareFunctionAlias(__glGetTexGeniv, "glGetTexGeniv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexGeniv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexGeniv(coord, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexLevelParameterfv
Gura_DeclareFunctionAlias(__glGetTexLevelParameterfv, "glGetTexLevelParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexLevelParameterfv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLenum pname = static_cast<GLenum>(arg.GetInt(2));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexLevelParameterfv(target, level, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexLevelParameteriv
Gura_DeclareFunctionAlias(__glGetTexLevelParameteriv, "glGetTexLevelParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexLevelParameteriv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLenum pname = static_cast<GLenum>(arg.GetInt(2));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexLevelParameteriv(target, level, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexParameterfv
Gura_DeclareFunctionAlias(__glGetTexParameterfv, "glGetTexParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexParameterfv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexParameterfv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glGetTexParameteriv
Gura_DeclareFunctionAlias(__glGetTexParameteriv, "glGetTexParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetTexParameteriv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexParameteriv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
}

// opengl.glHint
Gura_DeclareFunctionAlias(__glHint, "glHint")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glHint)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum mode = static_cast<GLenum>(arg.GetInt(1));
	glHint(target, mode);
	return Value::Nil;
}

// opengl.glHistogram
Gura_DeclareFunctionAlias(__glHistogram, "glHistogram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "sink", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glHistogram)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLsizei width = arg.GetInt(1);
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(2));
	GLboolean sink = (arg.GetBoolean(3)? GL_TRUE : GL_FALSE);
	glHistogram(target, width, internalformat, sink);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glIndexMask
Gura_DeclareFunctionAlias(__glIndexMask, "glIndexMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexMask)
{
	GLuint mask = arg.GetUInt(0);
	glIndexMask(mask);
	return Value::Nil;
}

// opengl.glIndexd
Gura_DeclareFunctionAlias(__glIndexd, "glIndexd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexd)
{
	GLdouble c = arg.GetDouble(0);
	glIndexd(c);
	return Value::Nil;
}

// opengl.glIndexdv
Gura_DeclareFunctionAlias(__glIndexdv, "glIndexdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexdv)
{
	ArrayT<double> *_c = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *c = reinterpret_cast<GLdouble *>(_c->GetPointer());
	glIndexdv(c);
	return Value::Nil;
}

// opengl.glIndexf
Gura_DeclareFunctionAlias(__glIndexf, "glIndexf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexf)
{
	GLfloat c = arg.GetFloat(0);
	glIndexf(c);
	return Value::Nil;
}

// opengl.glIndexfv
Gura_DeclareFunctionAlias(__glIndexfv, "glIndexfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexfv)
{
	ArrayT<float> *_c = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *c = reinterpret_cast<GLfloat *>(_c->GetPointer());
	glIndexfv(c);
	return Value::Nil;
}

// opengl.glIndexi
Gura_DeclareFunctionAlias(__glIndexi, "glIndexi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexi)
{
	GLint c = arg.GetInt(0);
	glIndexi(c);
	return Value::Nil;
}

// opengl.glIndexiv
Gura_DeclareFunctionAlias(__glIndexiv, "glIndexiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexiv)
{
	ArrayT<int> *_c = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *c = reinterpret_cast<GLint *>(_c->GetPointer());
	glIndexiv(c);
	return Value::Nil;
}

// opengl.glIndexs
Gura_DeclareFunctionAlias(__glIndexs, "glIndexs")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexs)
{
	GLshort c = arg.GetShort(0);
	glIndexs(c);
	return Value::Nil;
}

// opengl.glIndexsv
Gura_DeclareFunctionAlias(__glIndexsv, "glIndexsv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexsv)
{
	ArrayT<Int16> *_c = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *c = reinterpret_cast<GLshort *>(_c->GetPointer());
	glIndexsv(c);
	return Value::Nil;
}

// opengl.glIndexub
Gura_DeclareFunctionAlias(__glIndexub, "glIndexub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexub)
{
	GLubyte c = arg.GetUChar(0);
	glIndexub(c);
	return Value::Nil;
}

// opengl.glIndexubv
Gura_DeclareFunctionAlias(__glIndexubv, "glIndexubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIndexubv)
{
	ArrayT<UInt8> *_c = Object_arrayT<UInt8>::GetObject(arg, 0)->GetArrayT();
	GLubyte *c = reinterpret_cast<GLubyte *>(_c->GetPointer());
	glIndexubv(c);
	return Value::Nil;
}

// opengl.glInitNames
Gura_DeclareFunctionAlias(__glInitNames, "glInitNames")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glInitNames)
{
	glInitNames();
	return Value::Nil;
}

// opengl.glIsEnabled
Gura_DeclareFunctionAlias(__glIsEnabled, "glIsEnabled")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsEnabled)
{
	GLenum cap = static_cast<GLenum>(arg.GetInt(0));
	GLboolean _rtn = glIsEnabled(cap);
	return ReturnValue(env, arg, Value(_rtn != GL_FALSE));
}

// opengl.glIsList
Gura_DeclareFunctionAlias(__glIsList, "glIsList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsList)
{
	GLuint list = arg.GetUInt(0);
	GLboolean _rtn = glIsList(list);
	return ReturnValue(env, arg, Value(_rtn != GL_FALSE));
}

// opengl.glIsTexture
Gura_DeclareFunctionAlias(__glIsTexture, "glIsTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsTexture)
{
	GLuint texture = arg.GetUInt(0);
	GLboolean _rtn = glIsTexture(texture);
	return ReturnValue(env, arg, Value(_rtn != GL_FALSE));
}

// opengl.glLightModelf
Gura_DeclareFunctionAlias(__glLightModelf, "glLightModelf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightModelf)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLfloat param = arg.GetFloat(1);
	glLightModelf(pname, param);
	return Value::Nil;
}

// opengl.glLightModelfv
Gura_DeclareFunctionAlias(__glLightModelfv, "glLightModelfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightModelfv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glLightModelfv(pname, params);
	return Value::Nil;
}

// opengl.glLightModeli
Gura_DeclareFunctionAlias(__glLightModeli, "glLightModeli")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightModeli)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLint param = arg.GetInt(1);
	glLightModeli(pname, param);
	return Value::Nil;
}

// opengl.glLightModeliv
Gura_DeclareFunctionAlias(__glLightModeliv, "glLightModeliv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightModeliv)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glLightModeliv(pname, params);
	return Value::Nil;
}

// opengl.glLightf
Gura_DeclareFunctionAlias(__glLightf, "glLightf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightf)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat param = arg.GetFloat(2);
	glLightf(light, pname, param);
	return Value::Nil;
}

// opengl.glLightfv
Gura_DeclareFunctionAlias(__glLightfv, "glLightfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightfv)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glLightfv(light, pname, params);
	return Value::Nil;
}

// opengl.glLighti
Gura_DeclareFunctionAlias(__glLighti, "glLighti")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLighti)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint param = arg.GetInt(2);
	glLighti(light, pname, param);
	return Value::Nil;
}

// opengl.glLightiv
Gura_DeclareFunctionAlias(__glLightiv, "glLightiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLightiv)
{
	GLenum light = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glLightiv(light, pname, params);
	return Value::Nil;
}

// opengl.glLineStipple
Gura_DeclareFunctionAlias(__glLineStipple, "glLineStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "factor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pattern", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLineStipple)
{
	GLint factor = arg.GetInt(0);
	GLushort pattern = arg.GetUShort(1);
	glLineStipple(factor, pattern);
	return Value::Nil;
}

// opengl.glLineWidth
Gura_DeclareFunctionAlias(__glLineWidth, "glLineWidth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLineWidth)
{
	GLfloat width = arg.GetFloat(0);
	glLineWidth(width);
	return Value::Nil;
}

// opengl.glListBase
Gura_DeclareFunctionAlias(__glListBase, "glListBase")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "base", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glListBase)
{
	GLuint base = arg.GetUInt(0);
	glListBase(base);
	return Value::Nil;
}

// opengl.glLoadIdentity
Gura_DeclareFunctionAlias(__glLoadIdentity, "glLoadIdentity")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLoadIdentity)
{
	glLoadIdentity();
	return Value::Nil;
}

// opengl.glLoadMatrixd
Gura_DeclareFunctionAlias(__glLoadMatrixd, "glLoadMatrixd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLoadMatrixd)
{
	AutoPtr<ArrayT<GLdouble> > _m(MakeMatrix<GLdouble>(env, arg.GetValue(0)));
	if (env.IsSignalled()) return Value::Nil;
	GLdouble *m = _m->GetPointer();
	glLoadMatrixd(m);
	return Value::Nil;
}

// opengl.glLoadMatrixf
Gura_DeclareFunctionAlias(__glLoadMatrixf, "glLoadMatrixf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLoadMatrixf)
{
	AutoPtr<ArrayT<GLfloat> > _m(MakeMatrix<GLfloat>(env, arg.GetValue(0)));
	if (env.IsSignalled()) return Value::Nil;
	GLfloat *m = _m->GetPointer();
	glLoadMatrixf(m);
	return Value::Nil;
}

// opengl.glLoadName
Gura_DeclareFunctionAlias(__glLoadName, "glLoadName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLoadName)
{
	GLuint name = arg.GetUInt(0);
	glLoadName(name);
	return Value::Nil;
}

// opengl.glLogicOp
Gura_DeclareFunctionAlias(__glLogicOp, "glLogicOp")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "opcode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLogicOp)
{
	GLenum opcode = static_cast<GLenum>(arg.GetInt(0));
	glLogicOp(opcode);
	return Value::Nil;
}

// opengl.glMap1d
Gura_DeclareFunctionAlias(__glMap1d, "glMap1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "order", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMap1d)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble u1 = arg.GetDouble(1);
	GLdouble u2 = arg.GetDouble(2);
	GLint stride = arg.GetInt(3);
	GLint order = arg.GetInt(4);
	ArrayT<double> *points = Object_arrayT<double>::GetObject(arg, 5)->GetArrayT();
	glMap1d(target, u1, u2, stride, order, points->GetPointer());
	return Value::Nil;
}

// opengl.glMap1f
Gura_DeclareFunctionAlias(__glMap1f, "glMap1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "order", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMap1f)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat u1 = arg.GetFloat(1);
	GLfloat u2 = arg.GetFloat(2);
	GLint stride = arg.GetInt(3);
	GLint order = arg.GetInt(4);
	ArrayT<float> *points = Object_arrayT<float>::GetObject(arg, 5)->GetArrayT();
	glMap1f(target, u1, u2, stride, order, points->GetPointer());
	return Value::Nil;
}

// opengl.glMap2d
Gura_DeclareFunctionAlias(__glMap2d, "glMap2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ustride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "uorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vstride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMap2d)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble u1 = arg.GetDouble(1);
	GLdouble u2 = arg.GetDouble(2);
	GLint ustride = arg.GetInt(3);
	GLint uorder = arg.GetInt(4);
	GLdouble v1 = arg.GetDouble(5);
	GLdouble v2 = arg.GetDouble(6);
	GLint vstride = arg.GetInt(7);
	GLint vorder = arg.GetInt(8);
	ArrayT<double> *points = Object_arrayT<double>::GetObject(arg, 9)->GetArrayT();
	glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points->GetPointer());
	return Value::Nil;
}

// opengl.glMap2f
Gura_DeclareFunctionAlias(__glMap2f, "glMap2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ustride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "uorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vstride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMap2f)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat u1 = arg.GetFloat(1);
	GLfloat u2 = arg.GetFloat(2);
	GLint ustride = arg.GetInt(3);
	GLint uorder = arg.GetInt(4);
	GLfloat v1 = arg.GetFloat(5);
	GLfloat v2 = arg.GetFloat(6);
	GLint vstride = arg.GetInt(7);
	GLint vorder = arg.GetInt(8);
	ArrayT<float> *points = Object_arrayT<float>::GetObject(arg, 9)->GetArrayT();
	glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points->GetPointer());
	return Value::Nil;
}

// opengl.glMapGrid1d
Gura_DeclareFunctionAlias(__glMapGrid1d, "glMapGrid1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMapGrid1d)
{
	GLint un = arg.GetInt(0);
	GLdouble u1 = arg.GetDouble(1);
	GLdouble u2 = arg.GetDouble(2);
	glMapGrid1d(un, u1, u2);
	return Value::Nil;
}

// opengl.glMapGrid1f
Gura_DeclareFunctionAlias(__glMapGrid1f, "glMapGrid1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMapGrid1f)
{
	GLint un = arg.GetInt(0);
	GLfloat u1 = arg.GetFloat(1);
	GLfloat u2 = arg.GetFloat(2);
	glMapGrid1f(un, u1, u2);
	return Value::Nil;
}

// opengl.glMapGrid2d
Gura_DeclareFunctionAlias(__glMapGrid2d, "glMapGrid2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vn", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMapGrid2d)
{
	GLint un = arg.GetInt(0);
	GLdouble u1 = arg.GetDouble(1);
	GLdouble u2 = arg.GetDouble(2);
	GLint vn = arg.GetInt(3);
	GLdouble v1 = arg.GetDouble(4);
	GLdouble v2 = arg.GetDouble(5);
	glMapGrid2d(un, u1, u2, vn, v1, v2);
	return Value::Nil;
}

// opengl.glMapGrid2f
Gura_DeclareFunctionAlias(__glMapGrid2f, "glMapGrid2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vn", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMapGrid2f)
{
	GLint un = arg.GetInt(0);
	GLfloat u1 = arg.GetFloat(1);
	GLfloat u2 = arg.GetFloat(2);
	GLint vn = arg.GetInt(3);
	GLfloat v1 = arg.GetFloat(4);
	GLfloat v2 = arg.GetFloat(5);
	glMapGrid2f(un, u1, u2, vn, v1, v2);
	return Value::Nil;
}

// opengl.glMaterialf
Gura_DeclareFunctionAlias(__glMaterialf, "glMaterialf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMaterialf)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat param = arg.GetFloat(2);
	glMaterialf(face, pname, param);
	return Value::Nil;
}

// opengl.glMaterialfv
Gura_DeclareFunctionAlias(__glMaterialfv, "glMaterialfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMaterialfv)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glMaterialfv(face, pname, params);
	return Value::Nil;
}

// opengl.glMateriali
Gura_DeclareFunctionAlias(__glMateriali, "glMateriali")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMateriali)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint param = arg.GetInt(2);
	glMateriali(face, pname, param);
	return Value::Nil;
}

// opengl.glMaterialiv
Gura_DeclareFunctionAlias(__glMaterialiv, "glMaterialiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMaterialiv)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glMaterialiv(face, pname, params);
	return Value::Nil;
}

// opengl.glMatrixMode
Gura_DeclareFunctionAlias(__glMatrixMode, "glMatrixMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMatrixMode)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glMatrixMode(mode);
	return Value::Nil;
}

// opengl.glMinmax
Gura_DeclareFunctionAlias(__glMinmax, "glMinmax")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "sink", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMinmax)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum internalformat = static_cast<GLenum>(arg.GetInt(1));
	GLboolean sink = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	glMinmax(target, internalformat, sink);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glMultMatrixd
Gura_DeclareFunctionAlias(__glMultMatrixd, "glMultMatrixd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultMatrixd)
{
	AutoPtr<ArrayT<GLdouble> > _m(MakeMatrix<GLdouble>(env, arg.GetValue(0)));
	if (env.IsSignalled()) return Value::Nil;
	GLdouble *m = _m->GetPointer();
	glMultMatrixd(m);
	return Value::Nil;
}

// opengl.glMultMatrixf
Gura_DeclareFunctionAlias(__glMultMatrixf, "glMultMatrixf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultMatrixf)
{
	AutoPtr<ArrayT<GLfloat> > _m(MakeMatrix<GLfloat>(env, arg.GetValue(0)));
	if (env.IsSignalled()) return Value::Nil;
	GLfloat *m = _m->GetPointer();
	glMultMatrixf(m);
	return Value::Nil;
}

// opengl.glNewList
Gura_DeclareFunctionAlias(__glNewList, "glNewList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNewList)
{
	GLuint list = arg.GetUInt(0);
	GLenum mode = static_cast<GLenum>(arg.GetInt(1));
	glNewList(list, mode);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glEndList();
	}
	return Value::Nil;
}

// opengl.glNormal3
Gura_DeclareFunctionAlias(__glNormal3, "glNormal3")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_vertex, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3)
{
	const Vertex *v = &Object_vertex::GetObject(arg, 0)->GetVertex();
	glNormal3d(v->x, v->y, v->z);
	return Value::Nil;
}

// opengl.glNormal3b
Gura_DeclareFunctionAlias(__glNormal3b, "glNormal3b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3b)
{
	GLbyte nx = arg.GetChar(0);
	GLbyte ny = arg.GetChar(1);
	GLbyte nz = arg.GetChar(2);
	glNormal3b(nx, ny, nz);
	return Value::Nil;
}

// opengl.glNormal3bv
Gura_DeclareFunctionAlias(__glNormal3bv, "glNormal3bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3bv)
{
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 0)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glNormal3bv(v);
	return Value::Nil;
}

// opengl.glNormal3d
Gura_DeclareFunctionAlias(__glNormal3d, "glNormal3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3d)
{
	GLdouble nx = arg.GetDouble(0);
	GLdouble ny = arg.GetDouble(1);
	GLdouble nz = arg.GetDouble(2);
	glNormal3d(nx, ny, nz);
	return Value::Nil;
}

// opengl.glNormal3dv
Gura_DeclareFunctionAlias(__glNormal3dv, "glNormal3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glNormal3dv(v);
	return Value::Nil;
}

// opengl.glNormal3f
Gura_DeclareFunctionAlias(__glNormal3f, "glNormal3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3f)
{
	GLfloat nx = arg.GetFloat(0);
	GLfloat ny = arg.GetFloat(1);
	GLfloat nz = arg.GetFloat(2);
	glNormal3f(nx, ny, nz);
	return Value::Nil;
}

// opengl.glNormal3fv
Gura_DeclareFunctionAlias(__glNormal3fv, "glNormal3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glNormal3fv(v);
	return Value::Nil;
}

// opengl.glNormal3i
Gura_DeclareFunctionAlias(__glNormal3i, "glNormal3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3i)
{
	GLint nx = arg.GetInt(0);
	GLint ny = arg.GetInt(1);
	GLint nz = arg.GetInt(2);
	glNormal3i(nx, ny, nz);
	return Value::Nil;
}

// opengl.glNormal3iv
Gura_DeclareFunctionAlias(__glNormal3iv, "glNormal3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glNormal3iv(v);
	return Value::Nil;
}

// opengl.glNormal3s
Gura_DeclareFunctionAlias(__glNormal3s, "glNormal3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3s)
{
	GLshort nx = arg.GetShort(0);
	GLshort ny = arg.GetShort(1);
	GLshort nz = arg.GetShort(2);
	glNormal3s(nx, ny, nz);
	return Value::Nil;
}

// opengl.glNormal3sv
Gura_DeclareFunctionAlias(__glNormal3sv, "glNormal3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glNormal3sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glNormal3sv(v);
	return Value::Nil;
}

// opengl.glOrtho
Gura_DeclareFunctionAlias(__glOrtho, "glOrtho")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "left", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "right", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bottom", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "top", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glOrtho)
{
	GLdouble left = arg.GetDouble(0);
	GLdouble right = arg.GetDouble(1);
	GLdouble bottom = arg.GetDouble(2);
	GLdouble top = arg.GetDouble(3);
	GLdouble zNear = arg.GetDouble(4);
	GLdouble zFar = arg.GetDouble(5);
	glOrtho(left, right, bottom, top, zNear, zFar);
	return Value::Nil;
}

// opengl.glPassThrough
Gura_DeclareFunctionAlias(__glPassThrough, "glPassThrough")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "token", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPassThrough)
{
	GLfloat token = arg.GetFloat(0);
	glPassThrough(token);
	return Value::Nil;
}

// opengl.glPixelMapfv
Gura_DeclareFunctionAlias(__glPixelMapfv, "glPixelMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelMapfv)
{
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	GLint mapsize = arg.GetInt(1);
	ArrayT<float> *_values = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *values = reinterpret_cast<GLfloat *>(_values->GetPointer());
	glPixelMapfv(map, mapsize, values);
	return Value::Nil;
}

// opengl.glPixelMapuiv
Gura_DeclareFunctionAlias(__glPixelMapuiv, "glPixelMapuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelMapuiv)
{
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	GLint mapsize = arg.GetInt(1);
	ArrayT<UInt> *_values = Object_arrayT<UInt>::GetObject(arg, 2)->GetArrayT();
	GLuint *values = reinterpret_cast<GLuint *>(_values->GetPointer());
	glPixelMapuiv(map, mapsize, values);
	return Value::Nil;
}

// opengl.glPixelMapusv
Gura_DeclareFunctionAlias(__glPixelMapusv, "glPixelMapusv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelMapusv)
{
	GLenum map = static_cast<GLenum>(arg.GetInt(0));
	GLint mapsize = arg.GetInt(1);
	ArrayT<UInt16> *_values = Object_arrayT<UInt16>::GetObject(arg, 2)->GetArrayT();
	GLushort *values = reinterpret_cast<GLushort *>(_values->GetPointer());
	glPixelMapusv(map, mapsize, values);
	return Value::Nil;
}

// opengl.glPixelStoref
Gura_DeclareFunctionAlias(__glPixelStoref, "glPixelStoref")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelStoref)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLfloat param = arg.GetFloat(1);
	glPixelStoref(pname, param);
	return Value::Nil;
}

// opengl.glPixelStorei
Gura_DeclareFunctionAlias(__glPixelStorei, "glPixelStorei")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelStorei)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLint param = arg.GetInt(1);
	glPixelStorei(pname, param);
	return Value::Nil;
}

// opengl.glPixelTransferf
Gura_DeclareFunctionAlias(__glPixelTransferf, "glPixelTransferf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelTransferf)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLfloat param = arg.GetFloat(1);
	glPixelTransferf(pname, param);
	return Value::Nil;
}

// opengl.glPixelTransferi
Gura_DeclareFunctionAlias(__glPixelTransferi, "glPixelTransferi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelTransferi)
{
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLint param = arg.GetInt(1);
	glPixelTransferi(pname, param);
	return Value::Nil;
}

// opengl.glPixelZoom
Gura_DeclareFunctionAlias(__glPixelZoom, "glPixelZoom")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "xfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPixelZoom)
{
	GLfloat xfactor = arg.GetFloat(0);
	GLfloat yfactor = arg.GetFloat(1);
	glPixelZoom(xfactor, yfactor);
	return Value::Nil;
}

// opengl.glPointSize
Gura_DeclareFunctionAlias(__glPointSize, "glPointSize")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPointSize)
{
	GLfloat size = arg.GetFloat(0);
	glPointSize(size);
	return Value::Nil;
}

// opengl.glPolygonMode
Gura_DeclareFunctionAlias(__glPolygonMode, "glPolygonMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPolygonMode)
{
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum mode = static_cast<GLenum>(arg.GetInt(1));
	glPolygonMode(face, mode);
	return Value::Nil;
}

// opengl.glPolygonOffset
Gura_DeclareFunctionAlias(__glPolygonOffset, "glPolygonOffset")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "factor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "units", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPolygonOffset)
{
	GLfloat factor = arg.GetFloat(0);
	GLfloat units = arg.GetFloat(1);
	glPolygonOffset(factor, units);
	return Value::Nil;
}

// opengl.glPolygonStipple
Gura_DeclareFunctionAlias(__glPolygonStipple, "glPolygonStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPolygonStipple)
{
	ArrayT<UInt8> *mask = Object_arrayT<UInt8>::GetObject(arg, 0)->GetArrayT();
	if (mask->GetElemNum() != 32 * 4) {
		env.SetError(ERR_ValueError, "mask must contain 32 * 4 elements");
		return Value::Nil;
	}
	glPolygonStipple(mask->GetPointer());
	return Value::Nil;
}

// opengl.glPopAttrib
Gura_DeclareFunctionAlias(__glPopAttrib, "glPopAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPopAttrib)
{
	glPopAttrib();
	return Value::Nil;
}

// opengl.glPopClientAttrib
Gura_DeclareFunctionAlias(__glPopClientAttrib, "glPopClientAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPopClientAttrib)
{
	glPopClientAttrib();
	return Value::Nil;
}

// opengl.glPopMatrix
Gura_DeclareFunctionAlias(__glPopMatrix, "glPopMatrix")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPopMatrix)
{
	glPopMatrix();
	return Value::Nil;
}

// opengl.glPopName
Gura_DeclareFunctionAlias(__glPopName, "glPopName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPopName)
{
	glPopName();
	return Value::Nil;
}

// opengl.glPrioritizeTextures
Gura_DeclareFunctionAlias(__glPrioritizeTextures, "glPrioritizeTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "textures", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "priorities", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPrioritizeTextures)
{
	ArrayT<UInt> *_textures = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	ArrayT<float> *_priorities = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLclampf *priorities = reinterpret_cast<GLclampf *>(_priorities->GetPointer());
	GLsizei n = _textures->GetElemNum();
	if (n != _priorities->GetElemNum()) {
		env.SetError(ERR_ValueError, "textures and priorities must have the same number of elements");
		return Value::Nil;
	}
	glPrioritizeTextures(n, textures, priorities);
	return Value::Nil;
}

// opengl.glPushAttrib
Gura_DeclareFunctionAlias(__glPushAttrib, "glPushAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPushAttrib)
{
	GLbitfield mask = arg.GetUInt(0);
	glPushAttrib(mask);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glPopAttrib();
	}
	return Value::Nil;
}

// opengl.glPushClientAttrib
Gura_DeclareFunctionAlias(__glPushClientAttrib, "glPushClientAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPushClientAttrib)
{
	GLbitfield mask = arg.GetUInt(0);
	glPushClientAttrib(mask);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glPopClientAttrib();
	}
	return Value::Nil;
}

// opengl.glPushMatrix
Gura_DeclareFunctionAlias(__glPushMatrix, "glPushMatrix")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPushMatrix)
{
	glPushMatrix();
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glPopMatrix();
	}
	return Value::Nil;
}

// opengl.glPushName
Gura_DeclareFunctionAlias(__glPushName, "glPushName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPushName)
{
	GLuint name = arg.GetUInt(0);
	glPushName(name);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glPopName();
	}
	return Value::Nil;
}

// opengl.glRasterPos2d
Gura_DeclareFunctionAlias(__glRasterPos2d, "glRasterPos2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	glRasterPos2d(x, y);
	return Value::Nil;
}

// opengl.glRasterPos2dv
Gura_DeclareFunctionAlias(__glRasterPos2dv, "glRasterPos2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRasterPos2dv(v);
	return Value::Nil;
}

// opengl.glRasterPos2f
Gura_DeclareFunctionAlias(__glRasterPos2f, "glRasterPos2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	glRasterPos2f(x, y);
	return Value::Nil;
}

// opengl.glRasterPos2fv
Gura_DeclareFunctionAlias(__glRasterPos2fv, "glRasterPos2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRasterPos2fv(v);
	return Value::Nil;
}

// opengl.glRasterPos2i
Gura_DeclareFunctionAlias(__glRasterPos2i, "glRasterPos2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	glRasterPos2i(x, y);
	return Value::Nil;
}

// opengl.glRasterPos2iv
Gura_DeclareFunctionAlias(__glRasterPos2iv, "glRasterPos2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRasterPos2iv(v);
	return Value::Nil;
}

// opengl.glRasterPos2s
Gura_DeclareFunctionAlias(__glRasterPos2s, "glRasterPos2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	glRasterPos2s(x, y);
	return Value::Nil;
}

// opengl.glRasterPos2sv
Gura_DeclareFunctionAlias(__glRasterPos2sv, "glRasterPos2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos2sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRasterPos2sv(v);
	return Value::Nil;
}

// opengl.glRasterPos3d
Gura_DeclareFunctionAlias(__glRasterPos3d, "glRasterPos3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	glRasterPos3d(x, y, z);
	return Value::Nil;
}

// opengl.glRasterPos3dv
Gura_DeclareFunctionAlias(__glRasterPos3dv, "glRasterPos3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos3dv(v);
	return Value::Nil;
}

// opengl.glRasterPos3f
Gura_DeclareFunctionAlias(__glRasterPos3f, "glRasterPos3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	glRasterPos3f(x, y, z);
	return Value::Nil;
}

// opengl.glRasterPos3fv
Gura_DeclareFunctionAlias(__glRasterPos3fv, "glRasterPos3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos3fv(v);
	return Value::Nil;
}

// opengl.glRasterPos3i
Gura_DeclareFunctionAlias(__glRasterPos3i, "glRasterPos3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLint z = arg.GetInt(2);
	glRasterPos3i(x, y, z);
	return Value::Nil;
}

// opengl.glRasterPos3iv
Gura_DeclareFunctionAlias(__glRasterPos3iv, "glRasterPos3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos3iv(v);
	return Value::Nil;
}

// opengl.glRasterPos3s
Gura_DeclareFunctionAlias(__glRasterPos3s, "glRasterPos3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	GLshort z = arg.GetShort(2);
	glRasterPos3s(x, y, z);
	return Value::Nil;
}

// opengl.glRasterPos3sv
Gura_DeclareFunctionAlias(__glRasterPos3sv, "glRasterPos3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos3sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos3sv(v);
	return Value::Nil;
}

// opengl.glRasterPos4d
Gura_DeclareFunctionAlias(__glRasterPos4d, "glRasterPos4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	GLdouble w = arg.GetDouble(3);
	glRasterPos4d(x, y, z, w);
	return Value::Nil;
}

// opengl.glRasterPos4dv
Gura_DeclareFunctionAlias(__glRasterPos4dv, "glRasterPos4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glRasterPos4dv(v);
	return Value::Nil;
}

// opengl.glRasterPos4f
Gura_DeclareFunctionAlias(__glRasterPos4f, "glRasterPos4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	GLfloat w = arg.GetFloat(3);
	glRasterPos4f(x, y, z, w);
	return Value::Nil;
}

// opengl.glRasterPos4fv
Gura_DeclareFunctionAlias(__glRasterPos4fv, "glRasterPos4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glRasterPos4fv(v);
	return Value::Nil;
}

// opengl.glRasterPos4i
Gura_DeclareFunctionAlias(__glRasterPos4i, "glRasterPos4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLint z = arg.GetInt(2);
	GLint w = arg.GetInt(3);
	glRasterPos4i(x, y, z, w);
	return Value::Nil;
}

// opengl.glRasterPos4iv
Gura_DeclareFunctionAlias(__glRasterPos4iv, "glRasterPos4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos4iv(v);
	return Value::Nil;
}

// opengl.glRasterPos4s
Gura_DeclareFunctionAlias(__glRasterPos4s, "glRasterPos4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	GLshort z = arg.GetShort(2);
	GLshort w = arg.GetShort(3);
	glRasterPos4s(x, y, z, w);
	return Value::Nil;
}

// opengl.glRasterPos4sv
Gura_DeclareFunctionAlias(__glRasterPos4sv, "glRasterPos4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRasterPos4sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glRasterPos4sv(v);
	return Value::Nil;
}

// opengl.glReadBuffer
Gura_DeclareFunctionAlias(__glReadBuffer, "glReadBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glReadBuffer)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glReadBuffer(mode);
	return Value::Nil;
}

// opengl.glReadPixels
Gura_DeclareFunctionAlias(__glReadPixels, "glReadPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_symbol, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glReadPixels)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLsizei width = arg.GetInt(2);
	GLsizei height = arg.GetInt(3);
	const Symbol *format = arg.GetSymbol(4);
	Signal &sig = env.GetSignal();
	Image::Format fmt = Image::SymbolToFormat(sig, format);
	if (env.IsSignalled()) return Value::Nil;
	AutoPtr<Image> pImage(new Image(fmt));
	GLenum _format = GetImageFormat(env, pImage.get());
	if (env.IsSignalled()) return Value::Nil;
	if (!pImage->AllocBuffer(sig, width, height, 0xff)) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	glReadPixels(x, y, width, height, _format, type, pImage->GetBuffer());
	return ReturnValue(env, arg, Value(new Object_image(env, pImage.release())));
}

// opengl.glRectd
Gura_DeclareFunctionAlias(__glRectd, "glRectd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectd)
{
	GLdouble x1 = arg.GetDouble(0);
	GLdouble y1 = arg.GetDouble(1);
	GLdouble x2 = arg.GetDouble(2);
	GLdouble y2 = arg.GetDouble(3);
	glRectd(x1, y1, x2, y2);
	return Value::Nil;
}

// opengl.glRectdv
Gura_DeclareFunctionAlias(__glRectdv, "glRectdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectdv)
{
	ArrayT<double> *_v1 = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v1 = reinterpret_cast<GLdouble *>(_v1->GetPointer());
	if (!_v1->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	ArrayT<double> *_v2 = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v2 = reinterpret_cast<GLdouble *>(_v2->GetPointer());
	if (!_v2->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRectdv(v1, v2);
	return Value::Nil;
}

// opengl.glRectf
Gura_DeclareFunctionAlias(__glRectf, "glRectf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectf)
{
	GLfloat x1 = arg.GetFloat(0);
	GLfloat y1 = arg.GetFloat(1);
	GLfloat x2 = arg.GetFloat(2);
	GLfloat y2 = arg.GetFloat(3);
	glRectf(x1, y1, x2, y2);
	return Value::Nil;
}

// opengl.glRectfv
Gura_DeclareFunctionAlias(__glRectfv, "glRectfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectfv)
{
	ArrayT<float> *_v1 = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v1 = reinterpret_cast<GLfloat *>(_v1->GetPointer());
	if (!_v1->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	ArrayT<float> *_v2 = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v2 = reinterpret_cast<GLfloat *>(_v2->GetPointer());
	if (!_v2->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRectfv(v1, v2);
	return Value::Nil;
}

// opengl.glRecti
Gura_DeclareFunctionAlias(__glRecti, "glRecti")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRecti)
{
	GLint x1 = arg.GetInt(0);
	GLint y1 = arg.GetInt(1);
	GLint x2 = arg.GetInt(2);
	GLint y2 = arg.GetInt(3);
	glRecti(x1, y1, x2, y2);
	return Value::Nil;
}

// opengl.glRectiv
Gura_DeclareFunctionAlias(__glRectiv, "glRectiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectiv)
{
	ArrayT<int> *_v1 = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v1 = reinterpret_cast<GLint *>(_v1->GetPointer());
	if (!_v1->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	ArrayT<int> *_v2 = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v2 = reinterpret_cast<GLint *>(_v2->GetPointer());
	if (!_v2->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRectiv(v1, v2);
	return Value::Nil;
}

// opengl.glRects
Gura_DeclareFunctionAlias(__glRects, "glRects")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRects)
{
	GLshort x1 = arg.GetShort(0);
	GLshort y1 = arg.GetShort(1);
	GLshort x2 = arg.GetShort(2);
	GLshort y2 = arg.GetShort(3);
	glRects(x1, y1, x2, y2);
	return Value::Nil;
}

// opengl.glRectsv
Gura_DeclareFunctionAlias(__glRectsv, "glRectsv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRectsv)
{
	ArrayT<Int16> *_v1 = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v1 = reinterpret_cast<GLshort *>(_v1->GetPointer());
	if (!_v1->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	ArrayT<Int16> *_v2 = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v2 = reinterpret_cast<GLshort *>(_v2->GetPointer());
	if (!_v2->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glRectsv(v1, v2);
	return Value::Nil;
}

// opengl.glRenderMode
Gura_DeclareFunctionAlias(__glRenderMode, "glRenderMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRenderMode)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	GLint _rtn = glRenderMode(mode);
	return ReturnValue(env, arg, Value(_rtn));
}

// opengl.glResetHistogram
Gura_DeclareFunctionAlias(__glResetHistogram, "glResetHistogram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glResetHistogram)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	glResetHistogram(target);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glResetMinmax
Gura_DeclareFunctionAlias(__glResetMinmax, "glResetMinmax")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glResetMinmax)
{
#if defined(GL_VERSION_1_2)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	glResetMinmax(target);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.2");
	return Value::Nil;
#endif
}

// opengl.glRotated
Gura_DeclareFunctionAlias(__glRotated, "glRotated")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "angle", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRotated)
{
	GLdouble angle = arg.GetDouble(0);
	GLdouble x = arg.GetDouble(1);
	GLdouble y = arg.GetDouble(2);
	GLdouble z = arg.GetDouble(3);
	glRotated(angle, x, y, z);
	return Value::Nil;
}

// opengl.glRotatef
Gura_DeclareFunctionAlias(__glRotatef, "glRotatef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "angle", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glRotatef)
{
	GLfloat angle = arg.GetFloat(0);
	GLfloat x = arg.GetFloat(1);
	GLfloat y = arg.GetFloat(2);
	GLfloat z = arg.GetFloat(3);
	glRotatef(angle, x, y, z);
	return Value::Nil;
}

// opengl.glScaled
Gura_DeclareFunctionAlias(__glScaled, "glScaled")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glScaled)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	glScaled(x, y, z);
	return Value::Nil;
}

// opengl.glScalef
Gura_DeclareFunctionAlias(__glScalef, "glScalef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glScalef)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	glScalef(x, y, z);
	return Value::Nil;
}

// opengl.glScissor
Gura_DeclareFunctionAlias(__glScissor, "glScissor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glScissor)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLsizei width = arg.GetInt(2);
	GLsizei height = arg.GetInt(3);
	glScissor(x, y, width, height);
	return Value::Nil;
}

// opengl.glSelectBuffer
Gura_DeclareFunctionAlias(__glSelectBuffer, "glSelectBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "buffer", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSelectBuffer)
{
	ArrayT<UInt32> *buffer = arg.IsValid(0)? Object_arrayT<UInt32>::GetObject(arg, 0)->GetArrayT() : nullptr;
	if (buffer == nullptr) {
		glSelectBuffer(0, nullptr);
	} else {
		glSelectBuffer(buffer->GetElemNum(), buffer->GetPointer());
	}
	return Value::Nil;
}

// opengl.glShadeModel
Gura_DeclareFunctionAlias(__glShadeModel, "glShadeModel")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glShadeModel)
{
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	glShadeModel(mode);
	return Value::Nil;
}

// opengl.glStencilFunc
Gura_DeclareFunctionAlias(__glStencilFunc, "glStencilFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ref", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilFunc)
{
	GLenum func = static_cast<GLenum>(arg.GetInt(0));
	GLint ref = arg.GetInt(1);
	GLuint mask = arg.GetUInt(2);
	glStencilFunc(func, ref, mask);
	return Value::Nil;
}

// opengl.glStencilMask
Gura_DeclareFunctionAlias(__glStencilMask, "glStencilMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilMask)
{
	GLuint mask = arg.GetUInt(0);
	glStencilMask(mask);
	return Value::Nil;
}

// opengl.glStencilOp
Gura_DeclareFunctionAlias(__glStencilOp, "glStencilOp")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "fail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zfail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zpass", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilOp)
{
	GLenum fail = static_cast<GLenum>(arg.GetInt(0));
	GLenum zfail = static_cast<GLenum>(arg.GetInt(1));
	GLenum zpass = static_cast<GLenum>(arg.GetInt(2));
	glStencilOp(fail, zfail, zpass);
	return Value::Nil;
}

// opengl.glTexCoord1d
Gura_DeclareFunctionAlias(__glTexCoord1d, "glTexCoord1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1d)
{
	GLdouble s = arg.GetDouble(0);
	glTexCoord1d(s);
	return Value::Nil;
}

// opengl.glTexCoord1dv
Gura_DeclareFunctionAlias(__glTexCoord1dv, "glTexCoord1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glTexCoord1dv(v);
	return Value::Nil;
}

// opengl.glTexCoord1f
Gura_DeclareFunctionAlias(__glTexCoord1f, "glTexCoord1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1f)
{
	GLfloat s = arg.GetFloat(0);
	glTexCoord1f(s);
	return Value::Nil;
}

// opengl.glTexCoord1fv
Gura_DeclareFunctionAlias(__glTexCoord1fv, "glTexCoord1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glTexCoord1fv(v);
	return Value::Nil;
}

// opengl.glTexCoord1i
Gura_DeclareFunctionAlias(__glTexCoord1i, "glTexCoord1i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1i)
{
	GLint s = arg.GetInt(0);
	glTexCoord1i(s);
	return Value::Nil;
}

// opengl.glTexCoord1iv
Gura_DeclareFunctionAlias(__glTexCoord1iv, "glTexCoord1iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glTexCoord1iv(v);
	return Value::Nil;
}

// opengl.glTexCoord1s
Gura_DeclareFunctionAlias(__glTexCoord1s, "glTexCoord1s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1s)
{
	GLshort s = arg.GetShort(0);
	glTexCoord1s(s);
	return Value::Nil;
}

// opengl.glTexCoord1sv
Gura_DeclareFunctionAlias(__glTexCoord1sv, "glTexCoord1sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord1sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glTexCoord1sv(v);
	return Value::Nil;
}

// opengl.glTexCoord2d
Gura_DeclareFunctionAlias(__glTexCoord2d, "glTexCoord2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2d)
{
	GLdouble s = arg.GetDouble(0);
	GLdouble t = arg.GetDouble(1);
	glTexCoord2d(s, t);
	return Value::Nil;
}

// opengl.glTexCoord2dv
Gura_DeclareFunctionAlias(__glTexCoord2dv, "glTexCoord2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glTexCoord2dv(v);
	return Value::Nil;
}

// opengl.glTexCoord2f
Gura_DeclareFunctionAlias(__glTexCoord2f, "glTexCoord2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2f)
{
	GLfloat s = arg.GetFloat(0);
	GLfloat t = arg.GetFloat(1);
	glTexCoord2f(s, t);
	return Value::Nil;
}

// opengl.glTexCoord2fv
Gura_DeclareFunctionAlias(__glTexCoord2fv, "glTexCoord2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glTexCoord2fv(v);
	return Value::Nil;
}

// opengl.glTexCoord2i
Gura_DeclareFunctionAlias(__glTexCoord2i, "glTexCoord2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2i)
{
	GLint s = arg.GetInt(0);
	GLint t = arg.GetInt(1);
	glTexCoord2i(s, t);
	return Value::Nil;
}

// opengl.glTexCoord2iv
Gura_DeclareFunctionAlias(__glTexCoord2iv, "glTexCoord2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glTexCoord2iv(v);
	return Value::Nil;
}

// opengl.glTexCoord2s
Gura_DeclareFunctionAlias(__glTexCoord2s, "glTexCoord2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2s)
{
	GLshort s = arg.GetShort(0);
	GLshort t = arg.GetShort(1);
	glTexCoord2s(s, t);
	return Value::Nil;
}

// opengl.glTexCoord2sv
Gura_DeclareFunctionAlias(__glTexCoord2sv, "glTexCoord2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord2sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glTexCoord2sv(v);
	return Value::Nil;
}

// opengl.glTexCoord3d
Gura_DeclareFunctionAlias(__glTexCoord3d, "glTexCoord3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3d)
{
	GLdouble s = arg.GetDouble(0);
	GLdouble t = arg.GetDouble(1);
	GLdouble r = arg.GetDouble(2);
	glTexCoord3d(s, t, r);
	return Value::Nil;
}

// opengl.glTexCoord3dv
Gura_DeclareFunctionAlias(__glTexCoord3dv, "glTexCoord3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord3dv(v);
	return Value::Nil;
}

// opengl.glTexCoord3f
Gura_DeclareFunctionAlias(__glTexCoord3f, "glTexCoord3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3f)
{
	GLfloat s = arg.GetFloat(0);
	GLfloat t = arg.GetFloat(1);
	GLfloat r = arg.GetFloat(2);
	glTexCoord3f(s, t, r);
	return Value::Nil;
}

// opengl.glTexCoord3fv
Gura_DeclareFunctionAlias(__glTexCoord3fv, "glTexCoord3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord3fv(v);
	return Value::Nil;
}

// opengl.glTexCoord3i
Gura_DeclareFunctionAlias(__glTexCoord3i, "glTexCoord3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3i)
{
	GLint s = arg.GetInt(0);
	GLint t = arg.GetInt(1);
	GLint r = arg.GetInt(2);
	glTexCoord3i(s, t, r);
	return Value::Nil;
}

// opengl.glTexCoord3iv
Gura_DeclareFunctionAlias(__glTexCoord3iv, "glTexCoord3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord3iv(v);
	return Value::Nil;
}

// opengl.glTexCoord3s
Gura_DeclareFunctionAlias(__glTexCoord3s, "glTexCoord3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3s)
{
	GLshort s = arg.GetShort(0);
	GLshort t = arg.GetShort(1);
	GLshort r = arg.GetShort(2);
	glTexCoord3s(s, t, r);
	return Value::Nil;
}

// opengl.glTexCoord3sv
Gura_DeclareFunctionAlias(__glTexCoord3sv, "glTexCoord3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord3sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord3sv(v);
	return Value::Nil;
}

// opengl.glTexCoord4d
Gura_DeclareFunctionAlias(__glTexCoord4d, "glTexCoord4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4d)
{
	GLdouble s = arg.GetDouble(0);
	GLdouble t = arg.GetDouble(1);
	GLdouble r = arg.GetDouble(2);
	GLdouble q = arg.GetDouble(3);
	glTexCoord4d(s, t, r, q);
	return Value::Nil;
}

// opengl.glTexCoord4dv
Gura_DeclareFunctionAlias(__glTexCoord4dv, "glTexCoord4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glTexCoord4dv(v);
	return Value::Nil;
}

// opengl.glTexCoord4f
Gura_DeclareFunctionAlias(__glTexCoord4f, "glTexCoord4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4f)
{
	GLfloat s = arg.GetFloat(0);
	GLfloat t = arg.GetFloat(1);
	GLfloat r = arg.GetFloat(2);
	GLfloat q = arg.GetFloat(3);
	glTexCoord4f(s, t, r, q);
	return Value::Nil;
}

// opengl.glTexCoord4fv
Gura_DeclareFunctionAlias(__glTexCoord4fv, "glTexCoord4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glTexCoord4fv(v);
	return Value::Nil;
}

// opengl.glTexCoord4i
Gura_DeclareFunctionAlias(__glTexCoord4i, "glTexCoord4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4i)
{
	GLint s = arg.GetInt(0);
	GLint t = arg.GetInt(1);
	GLint r = arg.GetInt(2);
	GLint q = arg.GetInt(3);
	glTexCoord4i(s, t, r, q);
	return Value::Nil;
}

// opengl.glTexCoord4iv
Gura_DeclareFunctionAlias(__glTexCoord4iv, "glTexCoord4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord4iv(v);
	return Value::Nil;
}

// opengl.glTexCoord4s
Gura_DeclareFunctionAlias(__glTexCoord4s, "glTexCoord4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4s)
{
	GLshort s = arg.GetShort(0);
	GLshort t = arg.GetShort(1);
	GLshort r = arg.GetShort(2);
	GLshort q = arg.GetShort(3);
	glTexCoord4s(s, t, r, q);
	return Value::Nil;
}

// opengl.glTexCoord4sv
Gura_DeclareFunctionAlias(__glTexCoord4sv, "glTexCoord4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexCoord4sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glTexCoord4sv(v);
	return Value::Nil;
}

// opengl.glTexEnvf
Gura_DeclareFunctionAlias(__glTexEnvf, "glTexEnvf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexEnvf)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat param = arg.GetFloat(2);
	glTexEnvf(target, pname, param);
	return Value::Nil;
}

// opengl.glTexEnvfv
Gura_DeclareFunctionAlias(__glTexEnvfv, "glTexEnvfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexEnvfv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexEnvfv(target, pname, params);
	return Value::Nil;
}

// opengl.glTexEnvi
Gura_DeclareFunctionAlias(__glTexEnvi, "glTexEnvi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexEnvi)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint param = arg.GetInt(2);
	glTexEnvi(target, pname, param);
	return Value::Nil;
}

// opengl.glTexEnviv
Gura_DeclareFunctionAlias(__glTexEnviv, "glTexEnviv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexEnviv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexEnviv(target, pname, params);
	return Value::Nil;
}

// opengl.glTexGend
Gura_DeclareFunctionAlias(__glTexGend, "glTexGend")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGend)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLdouble param = arg.GetDouble(2);
	glTexGend(coord, pname, param);
	return Value::Nil;
}

// opengl.glTexGendv
Gura_DeclareFunctionAlias(__glTexGendv, "glTexGendv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGendv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<double> *_params = Object_arrayT<double>::GetObject(arg, 2)->GetArrayT();
	GLdouble *params = reinterpret_cast<GLdouble *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexGendv(coord, pname, params);
	return Value::Nil;
}

// opengl.glTexGenf
Gura_DeclareFunctionAlias(__glTexGenf, "glTexGenf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGenf)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat param = arg.GetFloat(2);
	glTexGenf(coord, pname, param);
	return Value::Nil;
}

// opengl.glTexGenfv
Gura_DeclareFunctionAlias(__glTexGenfv, "glTexGenfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGenfv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexGenfv(coord, pname, params);
	return Value::Nil;
}

// opengl.glTexGeni
Gura_DeclareFunctionAlias(__glTexGeni, "glTexGeni")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGeni)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint param = arg.GetInt(2);
	glTexGeni(coord, pname, param);
	return Value::Nil;
}

// opengl.glTexGeniv
Gura_DeclareFunctionAlias(__glTexGeniv, "glTexGeniv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexGeniv)
{
	GLenum coord = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexGeniv(coord, pname, params);
	return Value::Nil;
}

// opengl.glTexImage1D
Gura_DeclareFunctionAlias(__glTexImage1D, "glTexImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_array, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexImage1D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint internalformat = arg.GetInt(2);
	GLsizei width = arg.GetInt(3);
	GLint border = arg.GetInt(4);
	GLenum format = static_cast<GLenum>(arg.GetInt(5));
	GLenum type = static_cast<GLenum>(arg.GetInt(6));
	Array *pixels = Object_array::GetObject(arg, 7)->GetArray();
	// check pixels->size()
	const void *p = GetArrayTPointer(env, type, pixels);
	if (p == nullptr) return Value::Nil;
	glTexImage1D(target, level, internalformat, width, border, format, type, p);
	return Value::Nil;
}

// opengl.glTexImage1DFromImage
Gura_DeclareFunctionAlias(__glTexImage1DFromImage, "glTexImage1DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexImage1DFromImage)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint internalformat = arg.GetInt(2);
	GLint border = arg.GetInt(3);
	Image *image = Object_image::GetObject(arg, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth()) + border * 2;
	GLenum format = GetImageFormat(env, image);
	if (env.IsSignalled()) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
	return Value::Nil;
}

// opengl.glTexImage2D
Gura_DeclareFunctionAlias(__glTexImage2D, "glTexImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_array, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexImage2D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint internalformat = arg.GetInt(2);
	GLsizei width = arg.GetInt(3);
	GLsizei height = arg.GetInt(4);
	GLint border = arg.GetInt(5);
	GLenum format = static_cast<GLenum>(arg.GetInt(6));
	GLenum type = static_cast<GLenum>(arg.GetInt(7));
	Array *pixels = Object_array::GetObject(arg, 8)->GetArray();
	// check pixels->size()
	const void *p = GetArrayTPointer(env, type, pixels);
	if (p == nullptr) return Value::Nil;
	glTexImage2D(target, level, internalformat, width, height, border, format, type, p);
	return Value::Nil;
}

// opengl.glTexImage2DFromImage
Gura_DeclareFunctionAlias(__glTexImage2DFromImage, "glTexImage2DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexImage2DFromImage)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint internalformat = arg.GetInt(2);
	GLint border = arg.GetInt(3);
	Image *image = Object_image::GetObject(arg, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth()) + border * 2;
	GLsizei height = static_cast<GLsizei>(image->GetHeight()) + border * 2;
	GLenum format = GetImageFormat(env, image);
	if (env.IsSignalled()) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
	return Value::Nil;
}

// opengl.glTexParameterf
Gura_DeclareFunctionAlias(__glTexParameterf, "glTexParameterf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexParameterf)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLfloat param = arg.GetFloat(2);
	glTexParameterf(target, pname, param);
	return Value::Nil;
}

// opengl.glTexParameterfv
Gura_DeclareFunctionAlias(__glTexParameterfv, "glTexParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexParameterfv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexParameterfv(target, pname, params);
	return Value::Nil;
}

// opengl.glTexParameteri
Gura_DeclareFunctionAlias(__glTexParameteri, "glTexParameteri")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexParameteri)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	GLint param = arg.GetInt(2);
	glTexParameteri(target, pname, param);
	return Value::Nil;
}

// opengl.glTexParameteriv
Gura_DeclareFunctionAlias(__glTexParameteriv, "glTexParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexParameteriv)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glTexParameteriv(target, pname, params);
	return Value::Nil;
}

// opengl.glTexSubImage1D
Gura_DeclareFunctionAlias(__glTexSubImage1D, "glTexSubImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_array, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexSubImage1D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLsizei width = arg.GetInt(3);
	GLenum format = static_cast<GLenum>(arg.GetInt(4));
	GLenum type = static_cast<GLenum>(arg.GetInt(5));
	Array *pixels = Object_array::GetObject(arg, 6)->GetArray();
	// check pixels->size()
	const void *p = GetArrayTPointer(env, type, pixels);
	if (p == nullptr) return Value::Nil;
	glTexSubImage1D(target, level, xoffset, width, format, type, p);
	return Value::Nil;
}

// opengl.glTexSubImage1DFromImage
Gura_DeclareFunctionAlias(__glTexSubImage1DFromImage, "glTexSubImage1DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexSubImage1DFromImage)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	Image *image = Object_image::GetObject(arg, 3)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLenum format = GetImageFormat(env, image);
	if (env.IsSignalled()) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
	return Value::Nil;
}

// opengl.glTexSubImage2D
Gura_DeclareFunctionAlias(__glTexSubImage2D, "glTexSubImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_array, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexSubImage2D)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLint yoffset = arg.GetInt(3);
	GLsizei width = arg.GetInt(4);
	GLsizei height = arg.GetInt(5);
	GLenum format = static_cast<GLenum>(arg.GetInt(6));
	GLenum type = static_cast<GLenum>(arg.GetInt(7));
	Array *pixels = Object_array::GetObject(arg, 8)->GetArray();
	// check pixels->size()
	const void *p = GetArrayTPointer(env, type, pixels);
	if (p == nullptr) return Value::Nil;
	glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, p);
	return Value::Nil;
}

// opengl.glTexSubImage2DFromImage
Gura_DeclareFunctionAlias(__glTexSubImage2DFromImage, "glTexSubImage2DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTexSubImage2DFromImage)
{
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint level = arg.GetInt(1);
	GLint xoffset = arg.GetInt(2);
	GLint yoffset = arg.GetInt(3);
	Image *image = Object_image::GetObject(arg, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLsizei height = static_cast<GLsizei>(image->GetHeight());
	GLenum format = GetImageFormat(env, image);
	if (env.IsSignalled()) return Value::Nil;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
	return Value::Nil;
}

// opengl.glTranslated
Gura_DeclareFunctionAlias(__glTranslated, "glTranslated")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTranslated)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	glTranslated(x, y, z);
	return Value::Nil;
}

// opengl.glTranslatef
Gura_DeclareFunctionAlias(__glTranslatef, "glTranslatef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glTranslatef)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	glTranslatef(x, y, z);
	return Value::Nil;
}

// opengl.glVertex3
Gura_DeclareFunctionAlias(__glVertex3, "glVertex3")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_vertex, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3)
{
	const Vertex *v = &Object_vertex::GetObject(arg, 0)->GetVertex();
	glVertex3d(v->x, v->y, v->z);
	return Value::Nil;
}

// opengl.glVertex4
Gura_DeclareFunctionAlias(__glVertex4, "glVertex4")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_vertex, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4)
{
	const Vertex *v = &Object_vertex::GetObject(arg, 0)->GetVertex();
	GLdouble w = arg.GetDouble(1);
	glVertex4d(v->x, v->y, v->z, w);
	return Value::Nil;
}

// opengl.glVertex2d
Gura_DeclareFunctionAlias(__glVertex2d, "glVertex2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	glVertex2d(x, y);
	return Value::Nil;
}

// opengl.glVertex2dv
Gura_DeclareFunctionAlias(__glVertex2dv, "glVertex2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertex2dv(v);
	return Value::Nil;
}

// opengl.glVertex2f
Gura_DeclareFunctionAlias(__glVertex2f, "glVertex2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	glVertex2f(x, y);
	return Value::Nil;
}

// opengl.glVertex2fv
Gura_DeclareFunctionAlias(__glVertex2fv, "glVertex2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertex2fv(v);
	return Value::Nil;
}

// opengl.glVertex2i
Gura_DeclareFunctionAlias(__glVertex2i, "glVertex2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	glVertex2i(x, y);
	return Value::Nil;
}

// opengl.glVertex2iv
Gura_DeclareFunctionAlias(__glVertex2iv, "glVertex2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertex2iv(v);
	return Value::Nil;
}

// opengl.glVertex2s
Gura_DeclareFunctionAlias(__glVertex2s, "glVertex2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	glVertex2s(x, y);
	return Value::Nil;
}

// opengl.glVertex2sv
Gura_DeclareFunctionAlias(__glVertex2sv, "glVertex2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex2sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertex2sv(v);
	return Value::Nil;
}

// opengl.glVertex3d
Gura_DeclareFunctionAlias(__glVertex3d, "glVertex3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	glVertex3d(x, y, z);
	return Value::Nil;
}

// opengl.glVertex3dv
Gura_DeclareFunctionAlias(__glVertex3dv, "glVertex3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex3dv(v);
	return Value::Nil;
}

// opengl.glVertex3f
Gura_DeclareFunctionAlias(__glVertex3f, "glVertex3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	glVertex3f(x, y, z);
	return Value::Nil;
}

// opengl.glVertex3fv
Gura_DeclareFunctionAlias(__glVertex3fv, "glVertex3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex3fv(v);
	return Value::Nil;
}

// opengl.glVertex3i
Gura_DeclareFunctionAlias(__glVertex3i, "glVertex3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLint z = arg.GetInt(2);
	glVertex3i(x, y, z);
	return Value::Nil;
}

// opengl.glVertex3iv
Gura_DeclareFunctionAlias(__glVertex3iv, "glVertex3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex3iv(v);
	return Value::Nil;
}

// opengl.glVertex3s
Gura_DeclareFunctionAlias(__glVertex3s, "glVertex3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	GLshort z = arg.GetShort(2);
	glVertex3s(x, y, z);
	return Value::Nil;
}

// opengl.glVertex3sv
Gura_DeclareFunctionAlias(__glVertex3sv, "glVertex3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex3sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex3sv(v);
	return Value::Nil;
}

// opengl.glVertex4d
Gura_DeclareFunctionAlias(__glVertex4d, "glVertex4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4d)
{
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	GLdouble w = arg.GetDouble(3);
	glVertex4d(x, y, z, w);
	return Value::Nil;
}

// opengl.glVertex4dv
Gura_DeclareFunctionAlias(__glVertex4dv, "glVertex4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4dv)
{
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glVertex4dv(v);
	return Value::Nil;
}

// opengl.glVertex4f
Gura_DeclareFunctionAlias(__glVertex4f, "glVertex4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4f)
{
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	GLfloat w = arg.GetFloat(3);
	glVertex4f(x, y, z, w);
	return Value::Nil;
}

// opengl.glVertex4fv
Gura_DeclareFunctionAlias(__glVertex4fv, "glVertex4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4fv)
{
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glVertex4fv(v);
	return Value::Nil;
}

// opengl.glVertex4i
Gura_DeclareFunctionAlias(__glVertex4i, "glVertex4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4i)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLint z = arg.GetInt(2);
	GLint w = arg.GetInt(3);
	glVertex4i(x, y, z, w);
	return Value::Nil;
}

// opengl.glVertex4iv
Gura_DeclareFunctionAlias(__glVertex4iv, "glVertex4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4iv)
{
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex4iv(v);
	return Value::Nil;
}

// opengl.glVertex4s
Gura_DeclareFunctionAlias(__glVertex4s, "glVertex4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4s)
{
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	GLshort z = arg.GetShort(2);
	GLshort w = arg.GetShort(3);
	glVertex4s(x, y, z, w);
	return Value::Nil;
}

// opengl.glVertex4sv
Gura_DeclareFunctionAlias(__glVertex4sv, "glVertex4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertex4sv)
{
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertex4sv(v);
	return Value::Nil;
}

// opengl.glViewport
Gura_DeclareFunctionAlias(__glViewport, "glViewport")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glViewport)
{
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLsizei width = arg.GetInt(2);
	GLsizei height = arg.GetInt(3);
	glViewport(x, y, width, height);
	return Value::Nil;
}

// opengl.glActiveTexture
Gura_DeclareFunctionAlias(__glActiveTexture, "glActiveTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glActiveTexture)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum texture = static_cast<GLenum>(arg.GetInt(0));
	glActiveTexture(texture);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glClientActiveTexture
Gura_DeclareFunctionAlias(__glClientActiveTexture, "glClientActiveTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glClientActiveTexture)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum texture = static_cast<GLenum>(arg.GetInt(0));
	glClientActiveTexture(texture);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1d
Gura_DeclareFunctionAlias(__glMultiTexCoord1d, "glMultiTexCoord1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1d)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble s = arg.GetDouble(1);
	glMultiTexCoord1d(target, s);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1dv
Gura_DeclareFunctionAlias(__glMultiTexCoord1dv, "glMultiTexCoord1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1dv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glMultiTexCoord1dv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1f
Gura_DeclareFunctionAlias(__glMultiTexCoord1f, "glMultiTexCoord1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1f)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat s = arg.GetFloat(1);
	glMultiTexCoord1f(target, s);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1fv
Gura_DeclareFunctionAlias(__glMultiTexCoord1fv, "glMultiTexCoord1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1fv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glMultiTexCoord1fv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1i
Gura_DeclareFunctionAlias(__glMultiTexCoord1i, "glMultiTexCoord1i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1i)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint s = arg.GetInt(1);
	glMultiTexCoord1i(target, s);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1iv
Gura_DeclareFunctionAlias(__glMultiTexCoord1iv, "glMultiTexCoord1iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1iv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glMultiTexCoord1iv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1s
Gura_DeclareFunctionAlias(__glMultiTexCoord1s, "glMultiTexCoord1s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1s)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLshort s = arg.GetShort(1);
	glMultiTexCoord1s(target, s);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord1sv
Gura_DeclareFunctionAlias(__glMultiTexCoord1sv, "glMultiTexCoord1sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord1sv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glMultiTexCoord1sv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2d
Gura_DeclareFunctionAlias(__glMultiTexCoord2d, "glMultiTexCoord2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2d)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble s = arg.GetDouble(1);
	GLdouble t = arg.GetDouble(2);
	glMultiTexCoord2d(target, s, t);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2dv
Gura_DeclareFunctionAlias(__glMultiTexCoord2dv, "glMultiTexCoord2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2dv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glMultiTexCoord2dv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2f
Gura_DeclareFunctionAlias(__glMultiTexCoord2f, "glMultiTexCoord2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2f)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat s = arg.GetFloat(1);
	GLfloat t = arg.GetFloat(2);
	glMultiTexCoord2f(target, s, t);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2fv
Gura_DeclareFunctionAlias(__glMultiTexCoord2fv, "glMultiTexCoord2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2fv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glMultiTexCoord2fv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2i
Gura_DeclareFunctionAlias(__glMultiTexCoord2i, "glMultiTexCoord2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2i)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint s = arg.GetInt(1);
	GLint t = arg.GetInt(2);
	glMultiTexCoord2i(target, s, t);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2iv
Gura_DeclareFunctionAlias(__glMultiTexCoord2iv, "glMultiTexCoord2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2iv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glMultiTexCoord2iv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2s
Gura_DeclareFunctionAlias(__glMultiTexCoord2s, "glMultiTexCoord2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2s)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLshort s = arg.GetShort(1);
	GLshort t = arg.GetShort(2);
	glMultiTexCoord2s(target, s, t);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord2sv
Gura_DeclareFunctionAlias(__glMultiTexCoord2sv, "glMultiTexCoord2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord2sv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glMultiTexCoord2sv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3d
Gura_DeclareFunctionAlias(__glMultiTexCoord3d, "glMultiTexCoord3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3d)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble s = arg.GetDouble(1);
	GLdouble t = arg.GetDouble(2);
	GLdouble r = arg.GetDouble(3);
	glMultiTexCoord3d(target, s, t, r);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3dv
Gura_DeclareFunctionAlias(__glMultiTexCoord3dv, "glMultiTexCoord3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3dv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord3dv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3f
Gura_DeclareFunctionAlias(__glMultiTexCoord3f, "glMultiTexCoord3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3f)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat s = arg.GetFloat(1);
	GLfloat t = arg.GetFloat(2);
	GLfloat r = arg.GetFloat(3);
	glMultiTexCoord3f(target, s, t, r);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3fv
Gura_DeclareFunctionAlias(__glMultiTexCoord3fv, "glMultiTexCoord3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3fv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord3fv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3i
Gura_DeclareFunctionAlias(__glMultiTexCoord3i, "glMultiTexCoord3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3i)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint s = arg.GetInt(1);
	GLint t = arg.GetInt(2);
	GLint r = arg.GetInt(3);
	glMultiTexCoord3i(target, s, t, r);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3iv
Gura_DeclareFunctionAlias(__glMultiTexCoord3iv, "glMultiTexCoord3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3iv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord3iv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3s
Gura_DeclareFunctionAlias(__glMultiTexCoord3s, "glMultiTexCoord3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3s)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLshort s = arg.GetShort(1);
	GLshort t = arg.GetShort(2);
	GLshort r = arg.GetShort(3);
	glMultiTexCoord3s(target, s, t, r);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord3sv
Gura_DeclareFunctionAlias(__glMultiTexCoord3sv, "glMultiTexCoord3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord3sv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord3sv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4d
Gura_DeclareFunctionAlias(__glMultiTexCoord4d, "glMultiTexCoord4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4d)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLdouble s = arg.GetDouble(1);
	GLdouble t = arg.GetDouble(2);
	GLdouble r = arg.GetDouble(3);
	GLdouble q = arg.GetDouble(4);
	glMultiTexCoord4d(target, s, t, r, q);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4dv
Gura_DeclareFunctionAlias(__glMultiTexCoord4dv, "glMultiTexCoord4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4dv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glMultiTexCoord4dv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4f
Gura_DeclareFunctionAlias(__glMultiTexCoord4f, "glMultiTexCoord4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4f)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLfloat s = arg.GetFloat(1);
	GLfloat t = arg.GetFloat(2);
	GLfloat r = arg.GetFloat(3);
	GLfloat q = arg.GetFloat(4);
	glMultiTexCoord4f(target, s, t, r, q);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4fv
Gura_DeclareFunctionAlias(__glMultiTexCoord4fv, "glMultiTexCoord4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4fv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glMultiTexCoord4fv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4i
Gura_DeclareFunctionAlias(__glMultiTexCoord4i, "glMultiTexCoord4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4i)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLint s = arg.GetInt(1);
	GLint t = arg.GetInt(2);
	GLint r = arg.GetInt(3);
	GLint q = arg.GetInt(4);
	glMultiTexCoord4i(target, s, t, r, q);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4iv
Gura_DeclareFunctionAlias(__glMultiTexCoord4iv, "glMultiTexCoord4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4iv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord4iv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4s
Gura_DeclareFunctionAlias(__glMultiTexCoord4s, "glMultiTexCoord4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4s)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLshort s = arg.GetShort(1);
	GLshort t = arg.GetShort(2);
	GLshort r = arg.GetShort(3);
	GLshort q = arg.GetShort(4);
	glMultiTexCoord4s(target, s, t, r, q);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glMultiTexCoord4sv
Gura_DeclareFunctionAlias(__glMultiTexCoord4sv, "glMultiTexCoord4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiTexCoord4sv)
{
#if defined(GL_VERSION_1_3)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glMultiTexCoord4sv(target, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.3");
	return Value::Nil;
#endif
}

// opengl.glFogCoordf
Gura_DeclareFunctionAlias(__glFogCoordf, "glFogCoordf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogCoordf)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLfloat coord = arg.GetFloat(0);
	glFogCoordf(coord);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glFogCoordfv
Gura_DeclareFunctionAlias(__glFogCoordfv, "glFogCoordfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogCoordfv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<float> *_coord = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *coord = reinterpret_cast<GLfloat *>(_coord->GetPointer());
	if (!_coord->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glFogCoordfv(coord);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glFogCoordd
Gura_DeclareFunctionAlias(__glFogCoordd, "glFogCoordd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogCoordd)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLdouble coord = arg.GetDouble(0);
	glFogCoordd(coord);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glFogCoorddv
Gura_DeclareFunctionAlias(__glFogCoorddv, "glFogCoorddv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glFogCoorddv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<double> *_coord = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *coord = reinterpret_cast<GLdouble *>(_coord->GetPointer());
	if (!_coord->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glFogCoorddv(coord);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3b
Gura_DeclareFunctionAlias(__glSecondaryColor3b, "glSecondaryColor3b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3b)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLbyte red = arg.GetChar(0);
	GLbyte green = arg.GetChar(1);
	GLbyte blue = arg.GetChar(2);
	glSecondaryColor3b(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3bv
Gura_DeclareFunctionAlias(__glSecondaryColor3bv, "glSecondaryColor3bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3bv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 0)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3bv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3d
Gura_DeclareFunctionAlias(__glSecondaryColor3d, "glSecondaryColor3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3d)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLdouble red = arg.GetDouble(0);
	GLdouble green = arg.GetDouble(1);
	GLdouble blue = arg.GetDouble(2);
	glSecondaryColor3d(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3dv
Gura_DeclareFunctionAlias(__glSecondaryColor3dv, "glSecondaryColor3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3dv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3dv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3f
Gura_DeclareFunctionAlias(__glSecondaryColor3f, "glSecondaryColor3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3f)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLfloat red = arg.GetFloat(0);
	GLfloat green = arg.GetFloat(1);
	GLfloat blue = arg.GetFloat(2);
	glSecondaryColor3f(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3fv
Gura_DeclareFunctionAlias(__glSecondaryColor3fv, "glSecondaryColor3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3fv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3fv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3i
Gura_DeclareFunctionAlias(__glSecondaryColor3i, "glSecondaryColor3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3i)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLint red = arg.GetInt(0);
	GLint green = arg.GetInt(1);
	GLint blue = arg.GetInt(2);
	glSecondaryColor3i(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3iv
Gura_DeclareFunctionAlias(__glSecondaryColor3iv, "glSecondaryColor3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3iv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3iv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3s
Gura_DeclareFunctionAlias(__glSecondaryColor3s, "glSecondaryColor3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3s)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLshort red = arg.GetShort(0);
	GLshort green = arg.GetShort(1);
	GLshort blue = arg.GetShort(2);
	glSecondaryColor3s(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3sv
Gura_DeclareFunctionAlias(__glSecondaryColor3sv, "glSecondaryColor3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3sv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3sv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3ub
Gura_DeclareFunctionAlias(__glSecondaryColor3ub, "glSecondaryColor3ub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3ub)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLubyte red = arg.GetUChar(0);
	GLubyte green = arg.GetUChar(1);
	GLubyte blue = arg.GetUChar(2);
	glSecondaryColor3ub(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3ubv
Gura_DeclareFunctionAlias(__glSecondaryColor3ubv, "glSecondaryColor3ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3ubv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<UInt8> *_v = Object_arrayT<UInt8>::GetObject(arg, 0)->GetArrayT();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3ubv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3ui
Gura_DeclareFunctionAlias(__glSecondaryColor3ui, "glSecondaryColor3ui")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3ui)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLuint red = arg.GetUInt(0);
	GLuint green = arg.GetUInt(1);
	GLuint blue = arg.GetUInt(2);
	glSecondaryColor3ui(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3uiv
Gura_DeclareFunctionAlias(__glSecondaryColor3uiv, "glSecondaryColor3uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3uiv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<UInt> *_v = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3uiv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3us
Gura_DeclareFunctionAlias(__glSecondaryColor3us, "glSecondaryColor3us")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3us)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLushort red = arg.GetUShort(0);
	GLushort green = arg.GetUShort(1);
	GLushort blue = arg.GetUShort(2);
	glSecondaryColor3us(red, green, blue);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glSecondaryColor3usv
Gura_DeclareFunctionAlias(__glSecondaryColor3usv, "glSecondaryColor3usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glSecondaryColor3usv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<UInt16> *_v = Object_arrayT<UInt16>::GetObject(arg, 0)->GetArrayT();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glSecondaryColor3usv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glPointParameterf
Gura_DeclareFunctionAlias(__glPointParameterf, "glPointParameterf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPointParameterf)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLfloat param = arg.GetFloat(1);
	glPointParameterf(pname, param);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glPointParameterfv
Gura_DeclareFunctionAlias(__glPointParameterfv, "glPointParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPointParameterfv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glPointParameterfv(pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glPointParameteri
Gura_DeclareFunctionAlias(__glPointParameteri, "glPointParameteri")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPointParameteri)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	GLint param = arg.GetInt(1);
	glPointParameteri(pname, param);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glPointParameteriv
Gura_DeclareFunctionAlias(__glPointParameteriv, "glPointParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glPointParameteriv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum pname = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckArray(env.GetSignal(), pname, _params)) {
		return Value::Nil;
	}
	glPointParameteriv(pname, params);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glBlendFuncSeparate
Gura_DeclareFunctionAlias(__glBlendFuncSeparate, "glBlendFuncSeparate")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "srcRGB", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "dstRGB", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "srcAlpha", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "dstAlpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBlendFuncSeparate)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum srcRGB = static_cast<GLenum>(arg.GetInt(0));
	GLenum dstRGB = static_cast<GLenum>(arg.GetInt(1));
	GLenum srcAlpha = static_cast<GLenum>(arg.GetInt(2));
	GLenum dstAlpha = static_cast<GLenum>(arg.GetInt(3));
	glBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glMultiDrawArrays
Gura_DeclareFunctionAlias(__glMultiDrawArrays, "glMultiDrawArrays")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "first", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMultiDrawArrays)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLenum mode = static_cast<GLenum>(arg.GetInt(0));
	ArrayT<int> *_first = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *first = reinterpret_cast<GLint *>(_first->GetPointer());
	AutoPtr<ArrayT<GLsizei> > _count(ArrayT<GLsizei>::CreateFromList(arg.GetList(2)));
	GLsizei *count = _count->GetPointer();
	GLsizei primcount = _first->GetElemNum();
	if (primcount != _count->GetElemNum()) {
		env.SetError(ERR_ValueError, "first and count must have the same number of elements");
		return Value::Nil;
	}
	glMultiDrawArrays(mode, first, count, primcount);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2d
Gura_DeclareFunctionAlias(__glWindowPos2d, "glWindowPos2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2d)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	glWindowPos2d(x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2dv
Gura_DeclareFunctionAlias(__glWindowPos2dv, "glWindowPos2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2dv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glWindowPos2dv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2f
Gura_DeclareFunctionAlias(__glWindowPos2f, "glWindowPos2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2f)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	glWindowPos2f(x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2fv
Gura_DeclareFunctionAlias(__glWindowPos2fv, "glWindowPos2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2fv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glWindowPos2fv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2i
Gura_DeclareFunctionAlias(__glWindowPos2i, "glWindowPos2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2i)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	glWindowPos2i(x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2iv
Gura_DeclareFunctionAlias(__glWindowPos2iv, "glWindowPos2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2iv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glWindowPos2iv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2s
Gura_DeclareFunctionAlias(__glWindowPos2s, "glWindowPos2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2s)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	glWindowPos2s(x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos2sv
Gura_DeclareFunctionAlias(__glWindowPos2sv, "glWindowPos2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos2sv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glWindowPos2sv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3d
Gura_DeclareFunctionAlias(__glWindowPos3d, "glWindowPos3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3d)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLdouble x = arg.GetDouble(0);
	GLdouble y = arg.GetDouble(1);
	GLdouble z = arg.GetDouble(2);
	glWindowPos3d(x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3dv
Gura_DeclareFunctionAlias(__glWindowPos3dv, "glWindowPos3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3dv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 0)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glWindowPos3dv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3f
Gura_DeclareFunctionAlias(__glWindowPos3f, "glWindowPos3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3f)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLfloat x = arg.GetFloat(0);
	GLfloat y = arg.GetFloat(1);
	GLfloat z = arg.GetFloat(2);
	glWindowPos3f(x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3fv
Gura_DeclareFunctionAlias(__glWindowPos3fv, "glWindowPos3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3fv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 0)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glWindowPos3fv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3i
Gura_DeclareFunctionAlias(__glWindowPos3i, "glWindowPos3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3i)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLint x = arg.GetInt(0);
	GLint y = arg.GetInt(1);
	GLint z = arg.GetInt(2);
	glWindowPos3i(x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3iv
Gura_DeclareFunctionAlias(__glWindowPos3iv, "glWindowPos3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3iv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 0)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glWindowPos3iv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3s
Gura_DeclareFunctionAlias(__glWindowPos3s, "glWindowPos3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3s)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	GLshort x = arg.GetShort(0);
	GLshort y = arg.GetShort(1);
	GLshort z = arg.GetShort(2);
	glWindowPos3s(x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glWindowPos3sv
Gura_DeclareFunctionAlias(__glWindowPos3sv, "glWindowPos3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glWindowPos3sv)
{
#if defined(GL_VERSION_1_4)
	ImplementGLExtension();
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 0)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glWindowPos3sv(v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.4");
	return Value::Nil;
#endif
}

// opengl.glGenQueries
Gura_DeclareFunctionAlias(__glGenQueries, "glGenQueries")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGenQueries)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLsizei n = arg.GetInt(0);
	AutoPtr<ArrayT<GLuint> > _ids(new ArrayT<GLuint>(n));
	GLuint *ids = _ids->GetPointer();
	glGenQueries(n, ids);
	return ReturnValue(env, arg, Value::CreateList(env, ids, n));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glDeleteQueries
Gura_DeclareFunctionAlias(__glDeleteQueries, "glDeleteQueries")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "ids", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteQueries)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	ArrayT<UInt> *_ids = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *ids = reinterpret_cast<GLuint *>(_ids->GetPointer());
	GLsizei n = _ids->GetElemNum();
	glDeleteQueries(n, ids);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glIsQuery
Gura_DeclareFunctionAlias(__glIsQuery, "glIsQuery")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "id", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsQuery)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLuint id = arg.GetUInt(0);
	GLboolean _rtn = glIsQuery(id);
	return ReturnValue(env, arg, Value(_rtn == GL_TRUE));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glBeginQuery
Gura_DeclareFunctionAlias(__glBeginQuery, "glBeginQuery")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "id", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBeginQuery)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLuint id = arg.GetUInt(1);
	glBeginQuery(target, id);
	if (arg.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = arg.GetBlockCooked(env);
		if (env.IsSignalled()) return Value::Nil;
		pExprBlock->Exec(env);
		glEndQuery(target);
	}
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glEndQuery
Gura_DeclareFunctionAlias(__glEndQuery, "glEndQuery")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEndQuery)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	glEndQuery(target);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glGetQueryiv
Gura_DeclareFunctionAlias(__glGetQueryiv, "glGetQueryiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetQueryiv)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetQueryiv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glGetQueryObjectiv
Gura_DeclareFunctionAlias(__glGetQueryObjectiv, "glGetQueryObjectiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "id", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetQueryObjectiv)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLuint id = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetQueryObjectiv(id, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glGetQueryObjectuiv
Gura_DeclareFunctionAlias(__glGetQueryObjectuiv, "glGetQueryObjectuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "id", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetQueryObjectuiv)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLuint id = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLuint> > _params(new ArrayT<GLuint>(n));
	GLuint *params = _params->GetPointer();
	glGetQueryObjectuiv(id, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glBindBuffer
Gura_DeclareFunctionAlias(__glBindBuffer, "glBindBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "buffer", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBindBuffer)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLuint buffer = arg.GetUInt(1);
	glBindBuffer(target, buffer);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glDeleteBuffers
Gura_DeclareFunctionAlias(__glDeleteBuffers, "glDeleteBuffers")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "buffers", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteBuffers)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	ArrayT<UInt> *_buffers = Object_arrayT<UInt>::GetObject(arg, 0)->GetArrayT();
	GLuint *buffers = reinterpret_cast<GLuint *>(_buffers->GetPointer());
	GLsizei n = _buffers->GetElemNum();
	glDeleteBuffers(n, buffers);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glGenBuffers
Gura_DeclareFunctionAlias(__glGenBuffers, "glGenBuffers")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGenBuffers)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLsizei n = arg.GetInt(0);
	AutoPtr<ArrayT<GLuint> > _buffers(new ArrayT<GLuint>(n));
	GLuint *buffers = _buffers->GetPointer();
	glGenBuffers(n, buffers);
	return Value::CreateList(env, buffers, n);
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glIsBuffer
Gura_DeclareFunctionAlias(__glIsBuffer, "glIsBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "buffer", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsBuffer)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLuint buffer = arg.GetUInt(0);
	GLboolean _rtn = glIsBuffer(buffer);
	return ReturnValue(env, arg, Value(_rtn == GL_TRUE));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glBufferData
Gura_DeclareFunctionAlias(__glBufferData, "glBufferData")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "data", VTYPE_memory, OCCUR_Once, FLAG_Nil);
	DeclareArg(env, "usage", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBufferData)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLsizei size = arg.GetLong(1);
	Memory *data = arg.IsValid(2)? &Object_memory::GetObject(arg, 2)->GetMemory() : nullptr;
	GLenum usage = static_cast<GLenum>(arg.GetInt(3));
	if (data != nullptr && data->GetSize() < size) {
		env.SetError(ERR_ValueError, "allocated memory for data is smaller than the specified size");
		return Value::Nil;
	}
	glBufferData(target, size, (data == nullptr)? nullptr : data->GetPointer(), usage);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glMapBuffer
Gura_DeclareFunctionAlias(__glMapBuffer, "glMapBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "access", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glMapBuffer)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum access = static_cast<GLenum>(arg.GetInt(1));
	GLsizei bufSize = 0;
	glGetBufferParameteriv(target, GL_BUFFER_SIZE, &bufSize);
	void *_rtn = glMapBuffer(target, access);
	return ReturnValue(env, arg, Value(new Object_memory(env, new Memory(bufSize, _rtn))));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glUnmapBuffer
Gura_DeclareFunctionAlias(__glUnmapBuffer, "glUnmapBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUnmapBuffer)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLboolean _rtn = glUnmapBuffer(target);
	return ReturnValue(env, arg, Value(_rtn == GL_TRUE));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glGetBufferParameteriv
Gura_DeclareFunctionAlias(__glGetBufferParameteriv, "glGetBufferParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetBufferParameteriv)
{
#if defined(GL_VERSION_1_5)
	ImplementGLExtension();
	GLenum target = static_cast<GLenum>(arg.GetInt(0));
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetBufferParameteriv(target, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glDrawBuffers
Gura_DeclareFunctionAlias(__glDrawBuffers, "glDrawBuffers")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "bufs", VTYPE_number, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDrawBuffers)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	AutoPtr<ArrayT<GLenum> > _bufs(ArrayT<GLenum>::CreateFromList(arg.GetList(0)));
	GLenum *bufs = _bufs->GetPointer();
	GLsizei n = _bufs->GetElemNum();
	glDrawBuffers(n, bufs);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "1.5");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1d
Gura_DeclareFunctionAlias(__glVertexAttrib1d, "glVertexAttrib1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1d)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLdouble x = arg.GetDouble(1);
	glVertexAttrib1d(index, x);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1dv
Gura_DeclareFunctionAlias(__glVertexAttrib1dv, "glVertexAttrib1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1dv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glVertexAttrib1dv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1f
Gura_DeclareFunctionAlias(__glVertexAttrib1f, "glVertexAttrib1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLfloat x = arg.GetFloat(1);
	glVertexAttrib1f(index, x);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1fv
Gura_DeclareFunctionAlias(__glVertexAttrib1fv, "glVertexAttrib1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glVertexAttrib1fv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1s
Gura_DeclareFunctionAlias(__glVertexAttrib1s, "glVertexAttrib1s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1s)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLshort x = arg.GetShort(1);
	glVertexAttrib1s(index, x);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib1sv
Gura_DeclareFunctionAlias(__glVertexAttrib1sv, "glVertexAttrib1sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib1sv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(1)) {
		env.SetError(ERR_ValueError, "the list must have one element");
		return Value::Nil;
	}
	glVertexAttrib1sv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2d
Gura_DeclareFunctionAlias(__glVertexAttrib2d, "glVertexAttrib2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2d)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLdouble x = arg.GetDouble(1);
	GLdouble y = arg.GetDouble(2);
	glVertexAttrib2d(index, x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2dv
Gura_DeclareFunctionAlias(__glVertexAttrib2dv, "glVertexAttrib2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2dv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertexAttrib2dv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2f
Gura_DeclareFunctionAlias(__glVertexAttrib2f, "glVertexAttrib2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLfloat x = arg.GetFloat(1);
	GLfloat y = arg.GetFloat(2);
	glVertexAttrib2f(index, x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2fv
Gura_DeclareFunctionAlias(__glVertexAttrib2fv, "glVertexAttrib2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertexAttrib2fv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2s
Gura_DeclareFunctionAlias(__glVertexAttrib2s, "glVertexAttrib2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2s)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLshort x = arg.GetShort(1);
	GLshort y = arg.GetShort(2);
	glVertexAttrib2s(index, x, y);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib2sv
Gura_DeclareFunctionAlias(__glVertexAttrib2sv, "glVertexAttrib2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib2sv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(2)) {
		env.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Nil;
	}
	glVertexAttrib2sv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3d
Gura_DeclareFunctionAlias(__glVertexAttrib3d, "glVertexAttrib3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3d)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLdouble x = arg.GetDouble(1);
	GLdouble y = arg.GetDouble(2);
	GLdouble z = arg.GetDouble(3);
	glVertexAttrib3d(index, x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3dv
Gura_DeclareFunctionAlias(__glVertexAttrib3dv, "glVertexAttrib3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3dv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib3dv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3f
Gura_DeclareFunctionAlias(__glVertexAttrib3f, "glVertexAttrib3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLfloat x = arg.GetFloat(1);
	GLfloat y = arg.GetFloat(2);
	GLfloat z = arg.GetFloat(3);
	glVertexAttrib3f(index, x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3fv
Gura_DeclareFunctionAlias(__glVertexAttrib3fv, "glVertexAttrib3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib3fv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3s
Gura_DeclareFunctionAlias(__glVertexAttrib3s, "glVertexAttrib3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3s)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLshort x = arg.GetShort(1);
	GLshort y = arg.GetShort(2);
	GLshort z = arg.GetShort(3);
	glVertexAttrib3s(index, x, y, z);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib3sv
Gura_DeclareFunctionAlias(__glVertexAttrib3sv, "glVertexAttrib3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib3sv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(3)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib3sv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nbv
Gura_DeclareFunctionAlias(__glVertexAttrib4Nbv, "glVertexAttrib4Nbv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nbv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 1)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Nbv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Niv
Gura_DeclareFunctionAlias(__glVertexAttrib4Niv, "glVertexAttrib4Niv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Niv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Niv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nsv
Gura_DeclareFunctionAlias(__glVertexAttrib4Nsv, "glVertexAttrib4Nsv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nsv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Nsv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nub
Gura_DeclareFunctionAlias(__glVertexAttrib4Nub, "glVertexAttrib4Nub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nub)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLubyte x = arg.GetUChar(1);
	GLubyte y = arg.GetUChar(2);
	GLubyte z = arg.GetUChar(3);
	GLubyte w = arg.GetUChar(4);
	glVertexAttrib4Nub(index, x, y, z, w);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nubv
Gura_DeclareFunctionAlias(__glVertexAttrib4Nubv, "glVertexAttrib4Nubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nubv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt8> *_v = Object_arrayT<UInt8>::GetObject(arg, 1)->GetArrayT();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Nubv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nuiv
Gura_DeclareFunctionAlias(__glVertexAttrib4Nuiv, "glVertexAttrib4Nuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nuiv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt> *_v = Object_arrayT<UInt>::GetObject(arg, 1)->GetArrayT();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Nuiv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4Nusv
Gura_DeclareFunctionAlias(__glVertexAttrib4Nusv, "glVertexAttrib4Nusv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4Nusv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt16> *_v = Object_arrayT<UInt16>::GetObject(arg, 1)->GetArrayT();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4Nusv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4bv
Gura_DeclareFunctionAlias(__glVertexAttrib4bv, "glVertexAttrib4bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4bv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int8> *_v = Object_arrayT<Int8>::GetObject(arg, 1)->GetArrayT();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4bv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4d
Gura_DeclareFunctionAlias(__glVertexAttrib4d, "glVertexAttrib4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4d)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLdouble x = arg.GetDouble(1);
	GLdouble y = arg.GetDouble(2);
	GLdouble z = arg.GetDouble(3);
	GLdouble w = arg.GetDouble(4);
	glVertexAttrib4d(index, x, y, z, w);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4dv
Gura_DeclareFunctionAlias(__glVertexAttrib4dv, "glVertexAttrib4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4dv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<double> *_v = Object_arrayT<double>::GetObject(arg, 1)->GetArrayT();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glVertexAttrib4dv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4f
Gura_DeclareFunctionAlias(__glVertexAttrib4f, "glVertexAttrib4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLfloat x = arg.GetFloat(1);
	GLfloat y = arg.GetFloat(2);
	GLfloat z = arg.GetFloat(3);
	GLfloat w = arg.GetFloat(4);
	glVertexAttrib4f(index, x, y, z, w);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4fv
Gura_DeclareFunctionAlias(__glVertexAttrib4fv, "glVertexAttrib4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<float> *_v = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Nil;
	}
	glVertexAttrib4fv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4iv
Gura_DeclareFunctionAlias(__glVertexAttrib4iv, "glVertexAttrib4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4iv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<int> *_v = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4iv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4s
Gura_DeclareFunctionAlias(__glVertexAttrib4s, "glVertexAttrib4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4s)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLshort x = arg.GetShort(1);
	GLshort y = arg.GetShort(2);
	GLshort z = arg.GetShort(3);
	GLshort w = arg.GetShort(4);
	glVertexAttrib4s(index, x, y, z, w);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4sv
Gura_DeclareFunctionAlias(__glVertexAttrib4sv, "glVertexAttrib4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_int16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4sv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<Int16> *_v = Object_arrayT<Int16>::GetObject(arg, 1)->GetArrayT();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4sv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4ubv
Gura_DeclareFunctionAlias(__glVertexAttrib4ubv, "glVertexAttrib4ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint8, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4ubv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt8> *_v = Object_arrayT<UInt8>::GetObject(arg, 1)->GetArrayT();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4ubv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4uiv
Gura_DeclareFunctionAlias(__glVertexAttrib4uiv, "glVertexAttrib4uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4uiv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt> *_v = Object_arrayT<UInt>::GetObject(arg, 1)->GetArrayT();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4uiv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttrib4usv
Gura_DeclareFunctionAlias(__glVertexAttrib4usv, "glVertexAttrib4usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_at_uint16, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttrib4usv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	ArrayT<UInt16> *_v = Object_arrayT<UInt16>::GetObject(arg, 1)->GetArrayT();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (!_v->HasShape(4)) {
		env.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Nil;
	}
	glVertexAttrib4usv(index, v);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glVertexAttribPointer
Gura_DeclareFunctionAlias(__glVertexAttribPointer, "glVertexAttribPointer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "normalized", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pointer", VTYPE_memory, OCCUR_Once, FLAG_Nil);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glVertexAttribPointer)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLint size = arg.GetInt(1);
	GLenum type = static_cast<GLenum>(arg.GetInt(2));
	GLboolean normalized = (arg.GetBoolean(3)? GL_TRUE : GL_FALSE);
	GLsizei stride = arg.GetInt(4);
	Memory *pointer = arg.IsValid(5)? &Object_memory::GetObject(arg, 5)->GetMemory() : nullptr;
	glVertexAttribPointer(index, size, type, normalized, stride,
						(pointer == nullptr)? nullptr : pointer->GetPointer());
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glEnableVertexAttribArray
Gura_DeclareFunctionAlias(__glEnableVertexAttribArray, "glEnableVertexAttribArray")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glEnableVertexAttribArray)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	glEnableVertexAttribArray(index);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glDisableVertexAttribArray
Gura_DeclareFunctionAlias(__glDisableVertexAttribArray, "glDisableVertexAttribArray")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDisableVertexAttribArray)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	glDisableVertexAttribArray(index);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetVertexAttribdv
Gura_DeclareFunctionAlias(__glGetVertexAttribdv, "glGetVertexAttribdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetVertexAttribdv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLdouble> > _params(new ArrayT<GLdouble>(n));
	GLdouble *params = _params->GetPointer();
	glGetVertexAttribdv(index, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetVertexAttribfv
Gura_DeclareFunctionAlias(__glGetVertexAttribfv, "glGetVertexAttribfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetVertexAttribfv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLfloat> > _params(new ArrayT<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetVertexAttribfv(index, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetVertexAttribiv
Gura_DeclareFunctionAlias(__glGetVertexAttribiv, "glGetVertexAttribiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetVertexAttribiv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint index = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetVertexAttribiv(index, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glDeleteShader
Gura_DeclareFunctionAlias(__glDeleteShader, "glDeleteShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	glDeleteShader(shader);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glDetachShader
Gura_DeclareFunctionAlias(__glDetachShader, "glDetachShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDetachShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLuint shader = arg.GetUInt(1);
	glDetachShader(program, shader);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glCreateShader
Gura_DeclareFunctionAlias(__glCreateShader, "glCreateShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCreateShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLenum type = static_cast<GLenum>(arg.GetInt(0));
	GLuint _rtn = glCreateShader(type);
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glShaderSource
Gura_DeclareFunctionAlias(__glShaderSource, "glShaderSource")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "string", VTYPE_string, OCCUR_Once, FLAG_ListVar);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glShaderSource)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	const ValueList &string = arg.GetList(1);
	GLsizei count = static_cast<GLsizei>(string.size());
	const GLchar **_string = new const GLchar *[count];
	//GLint *length = new GLint[count];
	GLint *length = nullptr;
	for (GLint i = 0; i < count; i++) {
		_string[i] = reinterpret_cast<const GLchar *>(string[i].GetString());
		//length[i] = static_cast<GLint>(string[i].GetStringSTL().size());
	}
	glShaderSource(shader, count, _string, length);
	delete[] _string;
	delete[] length;
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glCompileShader
Gura_DeclareFunctionAlias(__glCompileShader, "glCompileShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCompileShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	glCompileShader(shader);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glCreateProgram
Gura_DeclareFunctionAlias(__glCreateProgram, "glCreateProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glCreateProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint _rtn = glCreateProgram();
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glAttachShader
Gura_DeclareFunctionAlias(__glAttachShader, "glAttachShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glAttachShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLuint shader = arg.GetUInt(1);
	glAttachShader(program, shader);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glLinkProgram
Gura_DeclareFunctionAlias(__glLinkProgram, "glLinkProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glLinkProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	glLinkProgram(program);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUseProgram
Gura_DeclareFunctionAlias(__glUseProgram, "glUseProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUseProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	glUseProgram(program);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glDeleteProgram
Gura_DeclareFunctionAlias(__glDeleteProgram, "glDeleteProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glDeleteProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	glDeleteProgram(program);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glValidateProgram
Gura_DeclareFunctionAlias(__glValidateProgram, "glValidateProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glValidateProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	glValidateProgram(program);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform1f
Gura_DeclareFunctionAlias(__glUniform1f, "glUniform1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform1f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLfloat v0 = arg.GetFloat(1);
	glUniform1f(location, v0);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform2f
Gura_DeclareFunctionAlias(__glUniform2f, "glUniform2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform2f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLfloat v0 = arg.GetFloat(1);
	GLfloat v1 = arg.GetFloat(2);
	glUniform2f(location, v0, v1);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform3f
Gura_DeclareFunctionAlias(__glUniform3f, "glUniform3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform3f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLfloat v0 = arg.GetFloat(1);
	GLfloat v1 = arg.GetFloat(2);
	GLfloat v2 = arg.GetFloat(3);
	glUniform3f(location, v0, v1, v2);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform4f
Gura_DeclareFunctionAlias(__glUniform4f, "glUniform4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v3", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform4f)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLfloat v0 = arg.GetFloat(1);
	GLfloat v1 = arg.GetFloat(2);
	GLfloat v2 = arg.GetFloat(3);
	GLfloat v3 = arg.GetFloat(4);
	glUniform4f(location, v0, v1, v2, v3);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform1i
Gura_DeclareFunctionAlias(__glUniform1i, "glUniform1i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform1i)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLint v0 = arg.GetInt(1);
	glUniform1i(location, v0);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform2i
Gura_DeclareFunctionAlias(__glUniform2i, "glUniform2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform2i)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLint v0 = arg.GetInt(1);
	GLint v1 = arg.GetInt(2);
	glUniform2i(location, v0, v1);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform3i
Gura_DeclareFunctionAlias(__glUniform3i, "glUniform3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform3i)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLint v0 = arg.GetInt(1);
	GLint v1 = arg.GetInt(2);
	GLint v2 = arg.GetInt(3);
	glUniform3i(location, v0, v1, v2);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform4i
Gura_DeclareFunctionAlias(__glUniform4i, "glUniform4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v0", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v3", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform4i)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLint v0 = arg.GetInt(1);
	GLint v1 = arg.GetInt(2);
	GLint v2 = arg.GetInt(3);
	GLint v3 = arg.GetInt(4);
	glUniform4i(location, v0, v1, v2, v3);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform1fv
Gura_DeclareFunctionAlias(__glUniform1fv, "glUniform1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform1fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum();
	glUniform1fv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform2fv
Gura_DeclareFunctionAlias(__glUniform2fv, "glUniform2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform2fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 2;
	glUniform2fv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform3fv
Gura_DeclareFunctionAlias(__glUniform3fv, "glUniform3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform3fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 3;
	glUniform3fv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform4fv
Gura_DeclareFunctionAlias(__glUniform4fv, "glUniform4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform4fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 1)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 4;
	glUniform4fv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform1iv
Gura_DeclareFunctionAlias(__glUniform1iv, "glUniform1iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform1iv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<int> *_value = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *value = reinterpret_cast<GLint *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum();
	glUniform1iv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform2iv
Gura_DeclareFunctionAlias(__glUniform2iv, "glUniform2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform2iv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<int> *_value = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *value = reinterpret_cast<GLint *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 2;
	glUniform2iv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform3iv
Gura_DeclareFunctionAlias(__glUniform3iv, "glUniform3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform3iv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<int> *_value = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *value = reinterpret_cast<GLint *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 3;
	glUniform3iv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniform4iv
Gura_DeclareFunctionAlias(__glUniform4iv, "glUniform4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniform4iv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	ArrayT<int> *_value = Object_arrayT<int>::GetObject(arg, 1)->GetArrayT();
	GLint *value = reinterpret_cast<GLint *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / 4;
	glUniform4iv(location, count, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniformMatrix2fv
Gura_DeclareFunctionAlias(__glUniformMatrix2fv, "glUniformMatrix2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix2fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLboolean transpose = (arg.GetBoolean(1)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / (2 * 2);
	glUniformMatrix2fv(location, count, transpose, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniformMatrix3fv
Gura_DeclareFunctionAlias(__glUniformMatrix3fv, "glUniformMatrix3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix3fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLboolean transpose = (arg.GetBoolean(1)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / (3 * 3);
	glUniformMatrix3fv(location, count, transpose, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniformMatrix4fv
Gura_DeclareFunctionAlias(__glUniformMatrix4fv, "glUniformMatrix4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix4fv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLint location = arg.GetInt(0);
	GLboolean transpose = (arg.GetBoolean(1)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	GLsizei count = _value->GetElemNum() / (4 * 4);
	glUniformMatrix4fv(location, count, transpose, value);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glIsShader
Gura_DeclareFunctionAlias(__glIsShader, "glIsShader")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsShader)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	bool _rtn = glIsShader(shader);
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glIsProgram
Gura_DeclareFunctionAlias(__glIsProgram, "glIsProgram")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glIsProgram)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	bool _rtn = glIsProgram(program);
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetShaderiv
Gura_DeclareFunctionAlias(__glGetShaderiv, "glGetShaderiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetShaderiv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetShaderiv(shader, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetProgramiv
Gura_DeclareFunctionAlias(__glGetProgramiv, "glGetProgramiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetProgramiv)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLenum pname = static_cast<GLenum>(arg.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<ArrayT<GLint> > _params(new ArrayT<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetProgramiv(program, pname, params);
	return ReturnValue(env, arg, CreateValueFromParams(env, params, n));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetAttachedShaders
Gura_DeclareFunctionAlias(__glGetAttachedShaders, "glGetAttachedShaders")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "maxCount", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_ListVar);
	DeclareArg(env, "shaders", VTYPE_array_at_uint32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetAttachedShaders)
{
#if 0
	GLuint program = arg.GetUInt(0);
	GLsizei maxCount = arg.GetInt(1);
	AutoPtr<ArrayT<GLsizei> > _count(ArrayT<GLsizei>::CreateFromList(arg.GetList(2)));
	GLsizei *count = _count->GetPointer();
	ArrayT<UInt> *_shaders = Object_arrayT<UInt>::GetObject(arg, 3)->GetArrayT();
	GLuint *shaders = reinterpret_cast<GLuint *>(_shaders->GetPointer());
	glGetAttachedShaders(program, maxCount, count, shaders);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetAttachedShaders");
	return Value::Nil;
}

// opengl.glGetShaderInfoLog
Gura_DeclareFunctionAlias(__glGetShaderInfoLog, "glGetShaderInfoLog")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetShaderInfoLog)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);

	String _rtn;	
	GLsizei bufSize = 0;
	glGetShaderiv(shader, GL_INFO_LOG_LENGTH, &bufSize);
	if (bufSize > 0) {
		GLsizei length = 0;
		GLchar *infoLog = new GLchar[bufSize];
		glGetShaderInfoLog(shader, bufSize, &length, infoLog);
		_rtn = infoLog;
		delete[] infoLog;
	}
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetProgramInfoLog
Gura_DeclareFunctionAlias(__glGetProgramInfoLog, "glGetProgramInfoLog")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetProgramInfoLog)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);

	String _rtn;	
	GLsizei bufSize = 0;
	glGetProgramiv(program, GL_INFO_LOG_LENGTH, &bufSize);
	if (bufSize > 0) {
		GLsizei length = 0;
		GLchar *infoLog = new GLchar[bufSize];
		glGetProgramInfoLog(program, bufSize, &length, infoLog);
		_rtn = infoLog;
		delete[] infoLog;
	}
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetUniformLocation
Gura_DeclareFunctionAlias(__glGetUniformLocation, "glGetUniformLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetUniformLocation)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	const char *name = arg.GetString(1);
	GLint _rtn = glGetUniformLocation(program, name);
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetActiveUniform
Gura_DeclareFunctionAlias(__glGetActiveUniform, "glGetActiveUniform")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetActiveUniform)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLuint index = arg.GetUInt(1);
	GLsizei bufSize = GL_ACTIVE_UNIFORM_MAX_LENGTH;
	GLsizei length;
	GLint size;
	GLenum type;
	GLchar name[GL_ACTIVE_UNIFORM_MAX_LENGTH];
	glGetActiveUniform(program, index, bufSize, &length, &size, &type, name);
	return ReturnValue(env, arg, Value::CreateList(env, Value(size), Value(type), Value(name)));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetUniformfv
Gura_DeclareFunctionAlias(__glGetUniformfv, "glGetUniformfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetUniformfv)
{
#if 0
	GLuint program = arg.GetUInt(0);
	GLint location = arg.GetInt(1);
	ArrayT<float> *_params = Object_arrayT<float>::GetObject(arg, 2)->GetArrayT();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	glGetUniformfv(program, location, params);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetUniformfv");
	return Value::Nil;
}

// opengl.glGetUniformiv
Gura_DeclareFunctionAlias(__glGetUniformiv, "glGetUniformiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_at_int32, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetUniformiv)
{
#if 0
	GLuint program = arg.GetUInt(0);
	GLint location = arg.GetInt(1);
	ArrayT<int> *_params = Object_arrayT<int>::GetObject(arg, 2)->GetArrayT();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	glGetUniformiv(program, location, params);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glGetUniformiv");
	return Value::Nil;
}

// opengl.glGetShaderSource
Gura_DeclareFunctionAlias(__glGetShaderSource, "glGetShaderSource")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetShaderSource)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint shader = arg.GetUInt(0);
	String _rtn;
	GLsizei bufSize = 0;
	glGetShaderiv(shader, GL_SHADER_SOURCE_LENGTH, &bufSize);
	if (bufSize > 0) {
		GLchar *source = new GLchar[bufSize];
		glGetShaderSource(shader, bufSize, nullptr, source);
		_rtn = source;
		delete[] source;
	}
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glBindAttribLocation
Gura_DeclareFunctionAlias(__glBindAttribLocation, "glBindAttribLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glBindAttribLocation)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLuint index = arg.GetUInt(1);
	const char *name = arg.GetString(2);
	glBindAttribLocation(program, index, name);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetActiveAttrib
Gura_DeclareFunctionAlias(__glGetActiveAttrib, "glGetActiveAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetActiveAttrib)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	GLuint index = arg.GetUInt(1);
	GLint size = 0;
	GLenum type;
	String _name;
	GLsizei bufSize = 0;
	glGetProgramiv(program, GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, &bufSize);
	if (bufSize > 0) {
		GLchar *name = new GLchar[bufSize];
		glGetActiveAttrib(program, index, bufSize, nullptr, &size, &type, name);
		_name = name;
		delete[] name;
	}
	return ReturnValue(env, arg, Value::CreateList(env, Value(size), Value(type), Value(_name)));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glGetAttribLocation
Gura_DeclareFunctionAlias(__glGetAttribLocation, "glGetAttribLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_string, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glGetAttribLocation)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLuint program = arg.GetUInt(0);
	const char *name = arg.GetString(1);
	GLint _rtn = glGetAttribLocation(program, name);
	return ReturnValue(env, arg, Value(_rtn));
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glStencilFuncSeparate
Gura_DeclareFunctionAlias(__glStencilFuncSeparate, "glStencilFuncSeparate")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ref", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilFuncSeparate)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum func = static_cast<GLenum>(arg.GetInt(1));
	GLint ref = arg.GetInt(2);
	GLuint mask = arg.GetUInt(3);
	glStencilFuncSeparate(face, func, ref, mask);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glStencilOpSeparate
Gura_DeclareFunctionAlias(__glStencilOpSeparate, "glStencilOpSeparate")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "fail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zfail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zpass", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilOpSeparate)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLenum fail = static_cast<GLenum>(arg.GetInt(1));
	GLenum zfail = static_cast<GLenum>(arg.GetInt(2));
	GLenum zpass = static_cast<GLenum>(arg.GetInt(3));
	glStencilOpSeparate(face, fail, zfail, zpass);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glStencilMaskSeparate
Gura_DeclareFunctionAlias(__glStencilMaskSeparate, "glStencilMaskSeparate")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glStencilMaskSeparate)
{
#if defined(GL_VERSION_2_0)
	ImplementGLExtension();
	GLenum face = static_cast<GLenum>(arg.GetInt(0));
	GLuint mask = arg.GetUInt(1);
	glStencilMaskSeparate(face, mask);
	return Value::Nil;
#else
	SetError_RequiredGLVersion(env, "2.0");
	return Value::Nil;
#endif
}

// opengl.glUniformMatrix2x3fv
Gura_DeclareFunctionAlias(__glUniformMatrix2x3fv, "glUniformMatrix2x3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix2x3fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix2x3fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix2x3fv");
	return Value::Nil;
}

// opengl.glUniformMatrix3x2fv
Gura_DeclareFunctionAlias(__glUniformMatrix3x2fv, "glUniformMatrix3x2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix3x2fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix3x2fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix3x2fv");
	return Value::Nil;
}

// opengl.glUniformMatrix2x4fv
Gura_DeclareFunctionAlias(__glUniformMatrix2x4fv, "glUniformMatrix2x4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix2x4fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix2x4fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix2x4fv");
	return Value::Nil;
}

// opengl.glUniformMatrix4x2fv
Gura_DeclareFunctionAlias(__glUniformMatrix4x2fv, "glUniformMatrix4x2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix4x2fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix4x2fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix4x2fv");
	return Value::Nil;
}

// opengl.glUniformMatrix3x4fv
Gura_DeclareFunctionAlias(__glUniformMatrix3x4fv, "glUniformMatrix3x4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix3x4fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix3x4fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix3x4fv");
	return Value::Nil;
}

// opengl.glUniformMatrix4x3fv
Gura_DeclareFunctionAlias(__glUniformMatrix4x3fv, "glUniformMatrix4x3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_at_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en),
		"");
}

Gura_ImplementFunction(__glUniformMatrix4x3fv)
{
#if 0
	GLint location = arg.GetInt(0);
	GLsizei count = arg.GetInt(1);
	GLboolean transpose = (arg.GetBoolean(2)? GL_TRUE : GL_FALSE);
	ArrayT<float> *_value = Object_arrayT<float>::GetObject(arg, 3)->GetArrayT();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix4x3fv(location, count, transpose, value);
	return Value::Nil;
#endif
	env.SetError(ERR_NotImplementedError, "not implemented function glUniformMatrix4x3fv");
	return Value::Nil;
}


void AssignFunctions(Environment &env)
{
	Gura_AssignFunction(__glewInit);
	Gura_AssignFunction(__glAccum);
	Gura_AssignFunction(__glAlphaFunc);
	Gura_AssignFunction(__glAreTexturesResident);
	Gura_AssignFunction(__glArrayElement);
	Gura_AssignFunction(__glBegin);
	Gura_AssignFunction(__glBindTexture);
	Gura_AssignFunction(__glBitmap);
	Gura_AssignFunction(__glBlendColor);
	Gura_AssignFunction(__glBlendEquation);
	Gura_AssignFunction(__glBlendEquationSeparate);
	Gura_AssignFunction(__glBlendFunc);
	Gura_AssignFunction(__glCallList);
	Gura_AssignFunction(__glCallLists);
	Gura_AssignFunction(__glClear);
	Gura_AssignFunction(__glClearAccum);
	Gura_AssignFunction(__glClearColor);
	Gura_AssignFunction(__glClearDepth);
	Gura_AssignFunction(__glClearIndex);
	Gura_AssignFunction(__glClearStencil);
	Gura_AssignFunction(__glClipPlane);
	Gura_AssignFunction(__glColor3b);
	Gura_AssignFunction(__glColor3bv);
	Gura_AssignFunction(__glColor3d);
	Gura_AssignFunction(__glColor3dv);
	Gura_AssignFunction(__glColor3f);
	Gura_AssignFunction(__glColor3fv);
	Gura_AssignFunction(__glColor3i);
	Gura_AssignFunction(__glColor3iv);
	Gura_AssignFunction(__glColor3s);
	Gura_AssignFunction(__glColor3sv);
	Gura_AssignFunction(__glColor3ub);
	Gura_AssignFunction(__glColor3ubv);
	Gura_AssignFunction(__glColor3ui);
	Gura_AssignFunction(__glColor3uiv);
	Gura_AssignFunction(__glColor3us);
	Gura_AssignFunction(__glColor3usv);
	Gura_AssignFunction(__glColor4b);
	Gura_AssignFunction(__glColor4bv);
	Gura_AssignFunction(__glColor4d);
	Gura_AssignFunction(__glColor4dv);
	Gura_AssignFunction(__glColor4f);
	Gura_AssignFunction(__glColor4fv);
	Gura_AssignFunction(__glColor4i);
	Gura_AssignFunction(__glColor4iv);
	Gura_AssignFunction(__glColor4s);
	Gura_AssignFunction(__glColor4sv);
	Gura_AssignFunction(__glColor4ub);
	Gura_AssignFunction(__glColor4ubv);
	Gura_AssignFunction(__glColor4ui);
	Gura_AssignFunction(__glColor4uiv);
	Gura_AssignFunction(__glColor4us);
	Gura_AssignFunction(__glColor4usv);
	Gura_AssignFunction(__glColorMask);
	Gura_AssignFunction(__glColorMaterial);
	Gura_AssignFunction(__glColorTableParameterfv);
	Gura_AssignFunction(__glColorTableParameteriv);
	Gura_AssignFunction(__glConvolutionParameterf);
	Gura_AssignFunction(__glConvolutionParameterfv);
	Gura_AssignFunction(__glConvolutionParameteri);
	Gura_AssignFunction(__glConvolutionParameteriv);
	Gura_AssignFunction(__glCopyColorSubTable);
	Gura_AssignFunction(__glCopyColorTable);
	Gura_AssignFunction(__glCopyConvolutionFilter1D);
	Gura_AssignFunction(__glCopyConvolutionFilter2D);
	Gura_AssignFunction(__glCopyPixels);
	Gura_AssignFunction(__glCopyTexImage1D);
	Gura_AssignFunction(__glCopyTexImage2D);
	Gura_AssignFunction(__glCopyTexSubImage1D);
	Gura_AssignFunction(__glCopyTexSubImage2D);
	Gura_AssignFunction(__glCopyTexSubImage3D);
	Gura_AssignFunction(__glCullFace);
	Gura_AssignFunction(__glDeleteLists);
	Gura_AssignFunction(__glDeleteTextures);
	Gura_AssignFunction(__glDepthFunc);
	Gura_AssignFunction(__glDepthMask);
	Gura_AssignFunction(__glDepthRange);
	Gura_AssignFunction(__glDisable);
	Gura_AssignFunction(__glDisableClientState);
	Gura_AssignFunction(__glDrawArrays);
	Gura_AssignFunction(__glDrawBuffer);
	Gura_AssignFunction(__glDrawPixels);
	Gura_AssignFunction(__glDrawPixelsFromImage);
	Gura_AssignFunction(__glEdgeFlag);
	Gura_AssignFunction(__glEdgeFlagv);
	Gura_AssignFunction(__glEnable);
	Gura_AssignFunction(__glEnableClientState);
	Gura_AssignFunction(__glEnd);
	Gura_AssignFunction(__glEndList);
	Gura_AssignFunction(__glEvalCoord1d);
	Gura_AssignFunction(__glEvalCoord1dv);
	Gura_AssignFunction(__glEvalCoord1f);
	Gura_AssignFunction(__glEvalCoord1fv);
	Gura_AssignFunction(__glEvalCoord2d);
	Gura_AssignFunction(__glEvalCoord2dv);
	Gura_AssignFunction(__glEvalCoord2f);
	Gura_AssignFunction(__glEvalCoord2fv);
	Gura_AssignFunction(__glEvalMesh1);
	Gura_AssignFunction(__glEvalMesh2);
	Gura_AssignFunction(__glEvalPoint1);
	Gura_AssignFunction(__glEvalPoint2);
	Gura_AssignFunction(__glFeedbackBuffer);
	Gura_AssignFunction(__glFinish);
	Gura_AssignFunction(__glFlush);
	Gura_AssignFunction(__glFogf);
	Gura_AssignFunction(__glFogfv);
	Gura_AssignFunction(__glFogi);
	Gura_AssignFunction(__glFogiv);
	Gura_AssignFunction(__glFrontFace);
	Gura_AssignFunction(__glFrustum);
	Gura_AssignFunction(__glGenLists);
	Gura_AssignFunction(__glGenTextures);
	Gura_AssignFunction(__glGetBooleanv);
	Gura_AssignFunction(__glGetClipPlane);
	Gura_AssignFunction(__glGetColorTableParameterfv);
	Gura_AssignFunction(__glGetColorTableParameteriv);
	Gura_AssignFunction(__glGetConvolutionParameterfv);
	Gura_AssignFunction(__glGetConvolutionParameteriv);
	Gura_AssignFunction(__glGetDoublev);
	Gura_AssignFunction(__glGetError);
	Gura_AssignFunction(__glGetFloatv);
	Gura_AssignFunction(__glGetHistogramParameterfv);
	Gura_AssignFunction(__glGetHistogramParameteriv);
	Gura_AssignFunction(__glGetIntegerv);
	Gura_AssignFunction(__glGetLightfv);
	Gura_AssignFunction(__glGetLightiv);
	Gura_AssignFunction(__glGetMapdv);
	Gura_AssignFunction(__glGetMapfv);
	Gura_AssignFunction(__glGetMapiv);
	Gura_AssignFunction(__glGetMaterialfv);
	Gura_AssignFunction(__glGetMaterialiv);
	Gura_AssignFunction(__glGetMinmaxParameterfv);
	Gura_AssignFunction(__glGetMinmaxParameteriv);
	Gura_AssignFunction(__glGetPixelMapfv);
	Gura_AssignFunction(__glGetPixelMapuiv);
	Gura_AssignFunction(__glGetPixelMapusv);
	Gura_AssignFunction(__glGetPolygonStipple);
	Gura_AssignFunction(__glGetString);
	Gura_AssignFunction(__glGetTexEnvfv);
	Gura_AssignFunction(__glGetTexEnviv);
	Gura_AssignFunction(__glGetTexGendv);
	Gura_AssignFunction(__glGetTexGenfv);
	Gura_AssignFunction(__glGetTexGeniv);
	Gura_AssignFunction(__glGetTexLevelParameterfv);
	Gura_AssignFunction(__glGetTexLevelParameteriv);
	Gura_AssignFunction(__glGetTexParameterfv);
	Gura_AssignFunction(__glGetTexParameteriv);
	Gura_AssignFunction(__glHint);
	Gura_AssignFunction(__glHistogram);
	Gura_AssignFunction(__glIndexMask);
	Gura_AssignFunction(__glIndexd);
	Gura_AssignFunction(__glIndexdv);
	Gura_AssignFunction(__glIndexf);
	Gura_AssignFunction(__glIndexfv);
	Gura_AssignFunction(__glIndexi);
	Gura_AssignFunction(__glIndexiv);
	Gura_AssignFunction(__glIndexs);
	Gura_AssignFunction(__glIndexsv);
	Gura_AssignFunction(__glIndexub);
	Gura_AssignFunction(__glIndexubv);
	Gura_AssignFunction(__glInitNames);
	Gura_AssignFunction(__glIsEnabled);
	Gura_AssignFunction(__glIsList);
	Gura_AssignFunction(__glIsTexture);
	Gura_AssignFunction(__glLightModelf);
	Gura_AssignFunction(__glLightModelfv);
	Gura_AssignFunction(__glLightModeli);
	Gura_AssignFunction(__glLightModeliv);
	Gura_AssignFunction(__glLightf);
	Gura_AssignFunction(__glLightfv);
	Gura_AssignFunction(__glLighti);
	Gura_AssignFunction(__glLightiv);
	Gura_AssignFunction(__glLineStipple);
	Gura_AssignFunction(__glLineWidth);
	Gura_AssignFunction(__glListBase);
	Gura_AssignFunction(__glLoadIdentity);
	Gura_AssignFunction(__glLoadMatrixd);
	Gura_AssignFunction(__glLoadMatrixf);
	Gura_AssignFunction(__glLoadName);
	Gura_AssignFunction(__glLogicOp);
	Gura_AssignFunction(__glMap1d);
	Gura_AssignFunction(__glMap1f);
	Gura_AssignFunction(__glMap2d);
	Gura_AssignFunction(__glMap2f);
	Gura_AssignFunction(__glMapGrid1d);
	Gura_AssignFunction(__glMapGrid1f);
	Gura_AssignFunction(__glMapGrid2d);
	Gura_AssignFunction(__glMapGrid2f);
	Gura_AssignFunction(__glMaterialf);
	Gura_AssignFunction(__glMaterialfv);
	Gura_AssignFunction(__glMateriali);
	Gura_AssignFunction(__glMaterialiv);
	Gura_AssignFunction(__glMatrixMode);
	Gura_AssignFunction(__glMinmax);
	Gura_AssignFunction(__glMultMatrixd);
	Gura_AssignFunction(__glMultMatrixf);
	Gura_AssignFunction(__glNewList);
	Gura_AssignFunction(__glNormal3);
	Gura_AssignFunction(__glNormal3b);
	Gura_AssignFunction(__glNormal3bv);
	Gura_AssignFunction(__glNormal3d);
	Gura_AssignFunction(__glNormal3dv);
	Gura_AssignFunction(__glNormal3f);
	Gura_AssignFunction(__glNormal3fv);
	Gura_AssignFunction(__glNormal3i);
	Gura_AssignFunction(__glNormal3iv);
	Gura_AssignFunction(__glNormal3s);
	Gura_AssignFunction(__glNormal3sv);
	Gura_AssignFunction(__glOrtho);
	Gura_AssignFunction(__glPassThrough);
	Gura_AssignFunction(__glPixelMapfv);
	Gura_AssignFunction(__glPixelMapuiv);
	Gura_AssignFunction(__glPixelMapusv);
	Gura_AssignFunction(__glPixelStoref);
	Gura_AssignFunction(__glPixelStorei);
	Gura_AssignFunction(__glPixelTransferf);
	Gura_AssignFunction(__glPixelTransferi);
	Gura_AssignFunction(__glPixelZoom);
	Gura_AssignFunction(__glPointSize);
	Gura_AssignFunction(__glPolygonMode);
	Gura_AssignFunction(__glPolygonOffset);
	Gura_AssignFunction(__glPolygonStipple);
	Gura_AssignFunction(__glPopAttrib);
	Gura_AssignFunction(__glPopClientAttrib);
	Gura_AssignFunction(__glPopMatrix);
	Gura_AssignFunction(__glPopName);
	Gura_AssignFunction(__glPrioritizeTextures);
	Gura_AssignFunction(__glPushAttrib);
	Gura_AssignFunction(__glPushClientAttrib);
	Gura_AssignFunction(__glPushMatrix);
	Gura_AssignFunction(__glPushName);
	Gura_AssignFunction(__glRasterPos2d);
	Gura_AssignFunction(__glRasterPos2dv);
	Gura_AssignFunction(__glRasterPos2f);
	Gura_AssignFunction(__glRasterPos2fv);
	Gura_AssignFunction(__glRasterPos2i);
	Gura_AssignFunction(__glRasterPos2iv);
	Gura_AssignFunction(__glRasterPos2s);
	Gura_AssignFunction(__glRasterPos2sv);
	Gura_AssignFunction(__glRasterPos3d);
	Gura_AssignFunction(__glRasterPos3dv);
	Gura_AssignFunction(__glRasterPos3f);
	Gura_AssignFunction(__glRasterPos3fv);
	Gura_AssignFunction(__glRasterPos3i);
	Gura_AssignFunction(__glRasterPos3iv);
	Gura_AssignFunction(__glRasterPos3s);
	Gura_AssignFunction(__glRasterPos3sv);
	Gura_AssignFunction(__glRasterPos4d);
	Gura_AssignFunction(__glRasterPos4dv);
	Gura_AssignFunction(__glRasterPos4f);
	Gura_AssignFunction(__glRasterPos4fv);
	Gura_AssignFunction(__glRasterPos4i);
	Gura_AssignFunction(__glRasterPos4iv);
	Gura_AssignFunction(__glRasterPos4s);
	Gura_AssignFunction(__glRasterPos4sv);
	Gura_AssignFunction(__glReadBuffer);
	Gura_AssignFunction(__glReadPixels);
	Gura_AssignFunction(__glRectd);
	Gura_AssignFunction(__glRectdv);
	Gura_AssignFunction(__glRectf);
	Gura_AssignFunction(__glRectfv);
	Gura_AssignFunction(__glRecti);
	Gura_AssignFunction(__glRectiv);
	Gura_AssignFunction(__glRects);
	Gura_AssignFunction(__glRectsv);
	Gura_AssignFunction(__glRenderMode);
	Gura_AssignFunction(__glResetHistogram);
	Gura_AssignFunction(__glResetMinmax);
	Gura_AssignFunction(__glRotated);
	Gura_AssignFunction(__glRotatef);
	Gura_AssignFunction(__glScaled);
	Gura_AssignFunction(__glScalef);
	Gura_AssignFunction(__glScissor);
	Gura_AssignFunction(__glSelectBuffer);
	Gura_AssignFunction(__glShadeModel);
	Gura_AssignFunction(__glStencilFunc);
	Gura_AssignFunction(__glStencilMask);
	Gura_AssignFunction(__glStencilOp);
	Gura_AssignFunction(__glTexCoord1d);
	Gura_AssignFunction(__glTexCoord1dv);
	Gura_AssignFunction(__glTexCoord1f);
	Gura_AssignFunction(__glTexCoord1fv);
	Gura_AssignFunction(__glTexCoord1i);
	Gura_AssignFunction(__glTexCoord1iv);
	Gura_AssignFunction(__glTexCoord1s);
	Gura_AssignFunction(__glTexCoord1sv);
	Gura_AssignFunction(__glTexCoord2d);
	Gura_AssignFunction(__glTexCoord2dv);
	Gura_AssignFunction(__glTexCoord2f);
	Gura_AssignFunction(__glTexCoord2fv);
	Gura_AssignFunction(__glTexCoord2i);
	Gura_AssignFunction(__glTexCoord2iv);
	Gura_AssignFunction(__glTexCoord2s);
	Gura_AssignFunction(__glTexCoord2sv);
	Gura_AssignFunction(__glTexCoord3d);
	Gura_AssignFunction(__glTexCoord3dv);
	Gura_AssignFunction(__glTexCoord3f);
	Gura_AssignFunction(__glTexCoord3fv);
	Gura_AssignFunction(__glTexCoord3i);
	Gura_AssignFunction(__glTexCoord3iv);
	Gura_AssignFunction(__glTexCoord3s);
	Gura_AssignFunction(__glTexCoord3sv);
	Gura_AssignFunction(__glTexCoord4d);
	Gura_AssignFunction(__glTexCoord4dv);
	Gura_AssignFunction(__glTexCoord4f);
	Gura_AssignFunction(__glTexCoord4fv);
	Gura_AssignFunction(__glTexCoord4i);
	Gura_AssignFunction(__glTexCoord4iv);
	Gura_AssignFunction(__glTexCoord4s);
	Gura_AssignFunction(__glTexCoord4sv);
	Gura_AssignFunction(__glTexEnvf);
	Gura_AssignFunction(__glTexEnvfv);
	Gura_AssignFunction(__glTexEnvi);
	Gura_AssignFunction(__glTexEnviv);
	Gura_AssignFunction(__glTexGend);
	Gura_AssignFunction(__glTexGendv);
	Gura_AssignFunction(__glTexGenf);
	Gura_AssignFunction(__glTexGenfv);
	Gura_AssignFunction(__glTexGeni);
	Gura_AssignFunction(__glTexGeniv);
	Gura_AssignFunction(__glTexImage1D);
	Gura_AssignFunction(__glTexImage1DFromImage);
	Gura_AssignFunction(__glTexImage2D);
	Gura_AssignFunction(__glTexImage2DFromImage);
	Gura_AssignFunction(__glTexParameterf);
	Gura_AssignFunction(__glTexParameterfv);
	Gura_AssignFunction(__glTexParameteri);
	Gura_AssignFunction(__glTexParameteriv);
	Gura_AssignFunction(__glTexSubImage1D);
	Gura_AssignFunction(__glTexSubImage1DFromImage);
	Gura_AssignFunction(__glTexSubImage2D);
	Gura_AssignFunction(__glTexSubImage2DFromImage);
	Gura_AssignFunction(__glTranslated);
	Gura_AssignFunction(__glTranslatef);
	Gura_AssignFunction(__glVertex3);
	Gura_AssignFunction(__glVertex4);
	Gura_AssignFunction(__glVertex2d);
	Gura_AssignFunction(__glVertex2dv);
	Gura_AssignFunction(__glVertex2f);
	Gura_AssignFunction(__glVertex2fv);
	Gura_AssignFunction(__glVertex2i);
	Gura_AssignFunction(__glVertex2iv);
	Gura_AssignFunction(__glVertex2s);
	Gura_AssignFunction(__glVertex2sv);
	Gura_AssignFunction(__glVertex3d);
	Gura_AssignFunction(__glVertex3dv);
	Gura_AssignFunction(__glVertex3f);
	Gura_AssignFunction(__glVertex3fv);
	Gura_AssignFunction(__glVertex3i);
	Gura_AssignFunction(__glVertex3iv);
	Gura_AssignFunction(__glVertex3s);
	Gura_AssignFunction(__glVertex3sv);
	Gura_AssignFunction(__glVertex4d);
	Gura_AssignFunction(__glVertex4dv);
	Gura_AssignFunction(__glVertex4f);
	Gura_AssignFunction(__glVertex4fv);
	Gura_AssignFunction(__glVertex4i);
	Gura_AssignFunction(__glVertex4iv);
	Gura_AssignFunction(__glVertex4s);
	Gura_AssignFunction(__glVertex4sv);
	Gura_AssignFunction(__glViewport);
	Gura_AssignFunction(__glActiveTexture);
	Gura_AssignFunction(__glClientActiveTexture);
	Gura_AssignFunction(__glMultiTexCoord1d);
	Gura_AssignFunction(__glMultiTexCoord1dv);
	Gura_AssignFunction(__glMultiTexCoord1f);
	Gura_AssignFunction(__glMultiTexCoord1fv);
	Gura_AssignFunction(__glMultiTexCoord1i);
	Gura_AssignFunction(__glMultiTexCoord1iv);
	Gura_AssignFunction(__glMultiTexCoord1s);
	Gura_AssignFunction(__glMultiTexCoord1sv);
	Gura_AssignFunction(__glMultiTexCoord2d);
	Gura_AssignFunction(__glMultiTexCoord2dv);
	Gura_AssignFunction(__glMultiTexCoord2f);
	Gura_AssignFunction(__glMultiTexCoord2fv);
	Gura_AssignFunction(__glMultiTexCoord2i);
	Gura_AssignFunction(__glMultiTexCoord2iv);
	Gura_AssignFunction(__glMultiTexCoord2s);
	Gura_AssignFunction(__glMultiTexCoord2sv);
	Gura_AssignFunction(__glMultiTexCoord3d);
	Gura_AssignFunction(__glMultiTexCoord3dv);
	Gura_AssignFunction(__glMultiTexCoord3f);
	Gura_AssignFunction(__glMultiTexCoord3fv);
	Gura_AssignFunction(__glMultiTexCoord3i);
	Gura_AssignFunction(__glMultiTexCoord3iv);
	Gura_AssignFunction(__glMultiTexCoord3s);
	Gura_AssignFunction(__glMultiTexCoord3sv);
	Gura_AssignFunction(__glMultiTexCoord4d);
	Gura_AssignFunction(__glMultiTexCoord4dv);
	Gura_AssignFunction(__glMultiTexCoord4f);
	Gura_AssignFunction(__glMultiTexCoord4fv);
	Gura_AssignFunction(__glMultiTexCoord4i);
	Gura_AssignFunction(__glMultiTexCoord4iv);
	Gura_AssignFunction(__glMultiTexCoord4s);
	Gura_AssignFunction(__glMultiTexCoord4sv);
	Gura_AssignFunction(__glFogCoordf);
	Gura_AssignFunction(__glFogCoordfv);
	Gura_AssignFunction(__glFogCoordd);
	Gura_AssignFunction(__glFogCoorddv);
	Gura_AssignFunction(__glSecondaryColor3b);
	Gura_AssignFunction(__glSecondaryColor3bv);
	Gura_AssignFunction(__glSecondaryColor3d);
	Gura_AssignFunction(__glSecondaryColor3dv);
	Gura_AssignFunction(__glSecondaryColor3f);
	Gura_AssignFunction(__glSecondaryColor3fv);
	Gura_AssignFunction(__glSecondaryColor3i);
	Gura_AssignFunction(__glSecondaryColor3iv);
	Gura_AssignFunction(__glSecondaryColor3s);
	Gura_AssignFunction(__glSecondaryColor3sv);
	Gura_AssignFunction(__glSecondaryColor3ub);
	Gura_AssignFunction(__glSecondaryColor3ubv);
	Gura_AssignFunction(__glSecondaryColor3ui);
	Gura_AssignFunction(__glSecondaryColor3uiv);
	Gura_AssignFunction(__glSecondaryColor3us);
	Gura_AssignFunction(__glSecondaryColor3usv);
	Gura_AssignFunction(__glPointParameterf);
	Gura_AssignFunction(__glPointParameterfv);
	Gura_AssignFunction(__glPointParameteri);
	Gura_AssignFunction(__glPointParameteriv);
	Gura_AssignFunction(__glBlendFuncSeparate);
	Gura_AssignFunction(__glMultiDrawArrays);
	Gura_AssignFunction(__glWindowPos2d);
	Gura_AssignFunction(__glWindowPos2dv);
	Gura_AssignFunction(__glWindowPos2f);
	Gura_AssignFunction(__glWindowPos2fv);
	Gura_AssignFunction(__glWindowPos2i);
	Gura_AssignFunction(__glWindowPos2iv);
	Gura_AssignFunction(__glWindowPos2s);
	Gura_AssignFunction(__glWindowPos2sv);
	Gura_AssignFunction(__glWindowPos3d);
	Gura_AssignFunction(__glWindowPos3dv);
	Gura_AssignFunction(__glWindowPos3f);
	Gura_AssignFunction(__glWindowPos3fv);
	Gura_AssignFunction(__glWindowPos3i);
	Gura_AssignFunction(__glWindowPos3iv);
	Gura_AssignFunction(__glWindowPos3s);
	Gura_AssignFunction(__glWindowPos3sv);
	Gura_AssignFunction(__glGenQueries);
	Gura_AssignFunction(__glDeleteQueries);
	Gura_AssignFunction(__glIsQuery);
	Gura_AssignFunction(__glBeginQuery);
	Gura_AssignFunction(__glEndQuery);
	Gura_AssignFunction(__glGetQueryiv);
	Gura_AssignFunction(__glGetQueryObjectiv);
	Gura_AssignFunction(__glGetQueryObjectuiv);
	Gura_AssignFunction(__glBindBuffer);
	Gura_AssignFunction(__glDeleteBuffers);
	Gura_AssignFunction(__glGenBuffers);
	Gura_AssignFunction(__glIsBuffer);
	Gura_AssignFunction(__glBufferData);
	Gura_AssignFunction(__glMapBuffer);
	Gura_AssignFunction(__glUnmapBuffer);
	Gura_AssignFunction(__glGetBufferParameteriv);
	Gura_AssignFunction(__glDrawBuffers);
	Gura_AssignFunction(__glVertexAttrib1d);
	Gura_AssignFunction(__glVertexAttrib1dv);
	Gura_AssignFunction(__glVertexAttrib1f);
	Gura_AssignFunction(__glVertexAttrib1fv);
	Gura_AssignFunction(__glVertexAttrib1s);
	Gura_AssignFunction(__glVertexAttrib1sv);
	Gura_AssignFunction(__glVertexAttrib2d);
	Gura_AssignFunction(__glVertexAttrib2dv);
	Gura_AssignFunction(__glVertexAttrib2f);
	Gura_AssignFunction(__glVertexAttrib2fv);
	Gura_AssignFunction(__glVertexAttrib2s);
	Gura_AssignFunction(__glVertexAttrib2sv);
	Gura_AssignFunction(__glVertexAttrib3d);
	Gura_AssignFunction(__glVertexAttrib3dv);
	Gura_AssignFunction(__glVertexAttrib3f);
	Gura_AssignFunction(__glVertexAttrib3fv);
	Gura_AssignFunction(__glVertexAttrib3s);
	Gura_AssignFunction(__glVertexAttrib3sv);
	Gura_AssignFunction(__glVertexAttrib4Nbv);
	Gura_AssignFunction(__glVertexAttrib4Niv);
	Gura_AssignFunction(__glVertexAttrib4Nsv);
	Gura_AssignFunction(__glVertexAttrib4Nub);
	Gura_AssignFunction(__glVertexAttrib4Nubv);
	Gura_AssignFunction(__glVertexAttrib4Nuiv);
	Gura_AssignFunction(__glVertexAttrib4Nusv);
	Gura_AssignFunction(__glVertexAttrib4bv);
	Gura_AssignFunction(__glVertexAttrib4d);
	Gura_AssignFunction(__glVertexAttrib4dv);
	Gura_AssignFunction(__glVertexAttrib4f);
	Gura_AssignFunction(__glVertexAttrib4fv);
	Gura_AssignFunction(__glVertexAttrib4iv);
	Gura_AssignFunction(__glVertexAttrib4s);
	Gura_AssignFunction(__glVertexAttrib4sv);
	Gura_AssignFunction(__glVertexAttrib4ubv);
	Gura_AssignFunction(__glVertexAttrib4uiv);
	Gura_AssignFunction(__glVertexAttrib4usv);
	Gura_AssignFunction(__glVertexAttribPointer);
	Gura_AssignFunction(__glEnableVertexAttribArray);
	Gura_AssignFunction(__glDisableVertexAttribArray);
	Gura_AssignFunction(__glGetVertexAttribdv);
	Gura_AssignFunction(__glGetVertexAttribfv);
	Gura_AssignFunction(__glGetVertexAttribiv);
	Gura_AssignFunction(__glDeleteShader);
	Gura_AssignFunction(__glDetachShader);
	Gura_AssignFunction(__glCreateShader);
	Gura_AssignFunction(__glShaderSource);
	Gura_AssignFunction(__glCompileShader);
	Gura_AssignFunction(__glCreateProgram);
	Gura_AssignFunction(__glAttachShader);
	Gura_AssignFunction(__glLinkProgram);
	Gura_AssignFunction(__glUseProgram);
	Gura_AssignFunction(__glDeleteProgram);
	Gura_AssignFunction(__glValidateProgram);
	Gura_AssignFunction(__glUniform1f);
	Gura_AssignFunction(__glUniform2f);
	Gura_AssignFunction(__glUniform3f);
	Gura_AssignFunction(__glUniform4f);
	Gura_AssignFunction(__glUniform1i);
	Gura_AssignFunction(__glUniform2i);
	Gura_AssignFunction(__glUniform3i);
	Gura_AssignFunction(__glUniform4i);
	Gura_AssignFunction(__glUniform1fv);
	Gura_AssignFunction(__glUniform2fv);
	Gura_AssignFunction(__glUniform3fv);
	Gura_AssignFunction(__glUniform4fv);
	Gura_AssignFunction(__glUniform1iv);
	Gura_AssignFunction(__glUniform2iv);
	Gura_AssignFunction(__glUniform3iv);
	Gura_AssignFunction(__glUniform4iv);
	Gura_AssignFunction(__glUniformMatrix2fv);
	Gura_AssignFunction(__glUniformMatrix3fv);
	Gura_AssignFunction(__glUniformMatrix4fv);
	Gura_AssignFunction(__glIsShader);
	Gura_AssignFunction(__glIsProgram);
	Gura_AssignFunction(__glGetShaderiv);
	Gura_AssignFunction(__glGetProgramiv);
	Gura_AssignFunction(__glGetAttachedShaders);
	Gura_AssignFunction(__glGetShaderInfoLog);
	Gura_AssignFunction(__glGetProgramInfoLog);
	Gura_AssignFunction(__glGetUniformLocation);
	Gura_AssignFunction(__glGetActiveUniform);
	Gura_AssignFunction(__glGetUniformfv);
	Gura_AssignFunction(__glGetUniformiv);
	Gura_AssignFunction(__glGetShaderSource);
	Gura_AssignFunction(__glBindAttribLocation);
	Gura_AssignFunction(__glGetActiveAttrib);
	Gura_AssignFunction(__glGetAttribLocation);
	Gura_AssignFunction(__glStencilFuncSeparate);
	Gura_AssignFunction(__glStencilOpSeparate);
	Gura_AssignFunction(__glStencilMaskSeparate);
	Gura_AssignFunction(__glUniformMatrix2x3fv);
	Gura_AssignFunction(__glUniformMatrix3x2fv);
	Gura_AssignFunction(__glUniformMatrix2x4fv);
	Gura_AssignFunction(__glUniformMatrix4x2fv);
	Gura_AssignFunction(__glUniformMatrix3x4fv);
	Gura_AssignFunction(__glUniformMatrix4x3fv);
}

Gura_EndModuleScope(opengl)
