// Don't edit this file. This has been generated by Functions.cpp.gura.
#include "stdafx.h"

#if defined(GURA_ON_MSWIN)
typedef char GLchar;
#endif

Gura_BeginModuleScope(opengl)

// opengl.glAccum
Gura_DeclareFunctionAlias(__glAccum, "glAccum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "op", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"operate on the accumulation buffer\n");
}

Gura_ImplementFunction(__glAccum)
{
	GLenum op = static_cast<GLenum>(args.GetInt(0));
	GLfloat value = args.GetFloat(1);
	glAccum(op, value);
	return Value::Null;
}

// opengl.glAlphaFunc
Gura_DeclareFunctionAlias(__glAlphaFunc, "glAlphaFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ref", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"specify the alpha test function\n");
}

Gura_ImplementFunction(__glAlphaFunc)
{
	GLenum func = static_cast<GLenum>(args.GetInt(0));
	GLclampf ref = args.GetFloat(1);
	glAlphaFunc(func, ref);
	return Value::Null;
}

// opengl.glAreTexturesResident
Gura_DeclareFunctionAlias(__glAreTexturesResident, "glAreTexturesResident")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "textures", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"determine if textures are loaded in texture memory\n");
}

Gura_ImplementFunction(__glAreTexturesResident)
{
	Array<UInt> *_textures = Object_array<UInt>::GetObject(args, 0)->GetArray();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	GLsizei n = _textures->GetSize();
	AutoPtr<Array<GLboolean> > _residences(new Array<GLboolean>(n));
	GLboolean *residences = _residences->GetPointer();
	GLboolean _rtn = glAreTexturesResident(n, textures, residences);
	if (_rtn == 0) return Value::Null;
	Value _rtnVal;
	ValueList &valList = _rtnVal.InitAsList(env, n);
	for (GLsizei i = 0; i < n; i++) {
		valList.push_back(residences[i] != 0);
	}
	return ReturnValue(env, sig, args, _rtnVal);
}

// opengl.glArrayElement
Gura_DeclareFunctionAlias(__glArrayElement, "glArrayElement")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"render a vertex using the specified vertex array element\n");
}

Gura_ImplementFunction(__glArrayElement)
{
	GLint i = args.GetInt(0);
	glArrayElement(i);
	return Value::Null;
}

// opengl.glBegin
Gura_DeclareFunctionAlias(__glBegin, "glBegin")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"delimit the vertices of a primitive or a group of like primitives\n");
}

Gura_ImplementFunction(__glBegin)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glBegin(mode);
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glEnd();
	}
	return Value::Null;
}

// opengl.glBindTexture
Gura_DeclareFunctionAlias(__glBindTexture, "glBindTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glBindTexture)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLuint texture = args.GetUInt(1);
	glBindTexture(target, texture);
	return Value::Null;
}

// opengl.glBitmap
Gura_DeclareFunctionAlias(__glBitmap, "glBitmap")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xorig", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yorig", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xmove", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ymove", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bitmap", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glBitmap)
{
	GLsizei width = args.GetInt(0);
	GLsizei height = args.GetInt(1);
	GLfloat xorig = args.GetFloat(2);
	GLfloat yorig = args.GetFloat(3);
	GLfloat xmove = args.GetFloat(4);
	GLfloat ymove = args.GetFloat(5);
	Array<UChar> *_bitmap = args.IsValid(6)? Object_array<UChar>::GetObject(args, 6)->GetArray() : NULL;
	GLubyte *bitmap = (_bitmap == NULL)? NULL : reinterpret_cast<GLubyte *>(_bitmap->GetPointer());
	if (_bitmap != NULL) {
		size_t bytesReq = ((width + 7) / 8) * height;
		if (_bitmap->GetSize() < bytesReq) {
			sig.SetError(ERR_ValueError, "array doesn\'t contain enough data");
			return Value::Null;
		}
	}
	glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
	return Value::Null;
}

// opengl.glBlendFunc
Gura_DeclareFunctionAlias(__glBlendFunc, "glBlendFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "sfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "dfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glBlendFunc)
{
	GLenum sfactor = static_cast<GLenum>(args.GetInt(0));
	GLenum dfactor = static_cast<GLenum>(args.GetInt(1));
	glBlendFunc(sfactor, dfactor);
	return Value::Null;
}

// opengl.glCallList
Gura_DeclareFunctionAlias(__glCallList, "glCallList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCallList)
{
	GLuint list = args.GetUInt(0);
	glCallList(list);
	return Value::Null;
}

// opengl.glCallLists
Gura_DeclareFunctionAlias(__glCallLists, "glCallLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "lists", VTYPE_number, OCCUR_Once, FLAG_List);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCallLists)
{
	GLenum type = static_cast<GLenum>(args.GetInt(0));
	const ValueList & lists = args.GetList(1);
	const ValueList &lists_in = args.GetList(1);
	GLsizei n = static_cast<GLsizei>(lists.size());
	AutoPtr<Memory> pListsBuff;
	if (type == GL_BYTE) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLbyte) * n));
		GLbyte *p = reinterpret_cast<GLbyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetChar(); }
	} else if (type == GL_UNSIGNED_BYTE) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUChar(); }
	} else if (type == GL_SHORT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLshort) * n));
		GLshort *p = reinterpret_cast<GLshort *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetShort(); }
	} else if (type == GL_UNSIGNED_SHORT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLushort) * n));
		GLushort *p = reinterpret_cast<GLushort *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUShort(); }
	} else if (type == GL_INT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLint) * n));
		GLint *p = reinterpret_cast<GLint *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetInt(); }
	} else if (type == GL_UNSIGNED_INT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLuint) * n));
		GLuint *p = reinterpret_cast<GLuint *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUInt(); }
	} else if (type == GL_FLOAT) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLfloat) * n));
		GLfloat *p = reinterpret_cast<GLfloat *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetFloat(); }
	} else if (type == GL_2_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 2 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			UShort num = pValue->GetUShort();
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_3_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 3 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			ULong num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_4_BYTES) {
		pListsBuff.reset(new MemoryHeap(sizeof(GLubyte) * 4 * n));
		GLubyte *p = reinterpret_cast<GLubyte *>(pListsBuff->GetPointer());
		foreach_const (ValueList, pValue, lists_in) {
			ULong num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 24);
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else {
		sig.SetError(ERR_ValueError, "invalid type specification");
		return Value::Null;
	}
	// GLsizei n, GLenum type, const GLvoid *lists
	glCallLists(n, type, pListsBuff->GetPointer());
	return Value::Null;
}

// opengl.glClear
Gura_DeclareFunctionAlias(__glClear, "glClear")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClear)
{
	GLbitfield mask = args.GetUInt(0);
	glClear(mask);
	return Value::Null;
}

// opengl.glClearAccum
Gura_DeclareFunctionAlias(__glClearAccum, "glClearAccum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClearAccum)
{
	GLfloat red = args.GetFloat(0);
	GLfloat green = args.GetFloat(1);
	GLfloat blue = args.GetFloat(2);
	GLfloat alpha = args.GetFloat(3);
	glClearAccum(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glClearColor
Gura_DeclareFunctionAlias(__glClearColor, "glClearColor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClearColor)
{
	GLclampf red = args.GetFloat(0);
	GLclampf green = args.GetFloat(1);
	GLclampf blue = args.GetFloat(2);
	GLclampf alpha = args.GetFloat(3);
	glClearColor(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glClearDepth
Gura_DeclareFunctionAlias(__glClearDepth, "glClearDepth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "depth", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClearDepth)
{
	GLclampd depth = args.GetDouble(0);
	glClearDepth(depth);
	return Value::Null;
}

// opengl.glClearIndex
Gura_DeclareFunctionAlias(__glClearIndex, "glClearIndex")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClearIndex)
{
	GLfloat c = args.GetFloat(0);
	glClearIndex(c);
	return Value::Null;
}

// opengl.glClearStencil
Gura_DeclareFunctionAlias(__glClearStencil, "glClearStencil")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClearStencil)
{
	GLint s = args.GetInt(0);
	glClearStencil(s);
	return Value::Null;
}

// opengl.glClipPlane
Gura_DeclareFunctionAlias(__glClipPlane, "glClipPlane")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "plane", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "equation", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glClipPlane)
{
	GLenum plane = static_cast<GLenum>(args.GetInt(0));
	Array<double> *_equation = Object_array<double>::GetObject(args, 1)->GetArray();
	GLdouble *equation = reinterpret_cast<GLdouble *>(_equation->GetPointer());
	if (_equation->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glClipPlane(plane, equation);
	return Value::Null;
}

// opengl.glColor3b
Gura_DeclareFunctionAlias(__glColor3b, "glColor3b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3b)
{
	GLbyte red = args.GetChar(0);
	GLbyte green = args.GetChar(1);
	GLbyte blue = args.GetChar(2);
	glColor3b(red, green, blue);
	return Value::Null;
}

// opengl.glColor3bv
Gura_DeclareFunctionAlias(__glColor3bv, "glColor3bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3bv)
{
	Array<char> *_v = Object_array<char>::GetObject(args, 0)->GetArray();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3bv(v);
	return Value::Null;
}

// opengl.glColor3d
Gura_DeclareFunctionAlias(__glColor3d, "glColor3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3d)
{
	GLdouble red = args.GetDouble(0);
	GLdouble green = args.GetDouble(1);
	GLdouble blue = args.GetDouble(2);
	glColor3d(red, green, blue);
	return Value::Null;
}

// opengl.glColor3dv
Gura_DeclareFunctionAlias(__glColor3dv, "glColor3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3dv(v);
	return Value::Null;
}

// opengl.glColor3f
Gura_DeclareFunctionAlias(__glColor3f, "glColor3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3f)
{
	GLfloat red = args.GetFloat(0);
	GLfloat green = args.GetFloat(1);
	GLfloat blue = args.GetFloat(2);
	glColor3f(red, green, blue);
	return Value::Null;
}

// opengl.glColor3fv
Gura_DeclareFunctionAlias(__glColor3fv, "glColor3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3fv(v);
	return Value::Null;
}

// opengl.glColor3i
Gura_DeclareFunctionAlias(__glColor3i, "glColor3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3i)
{
	GLint red = args.GetInt(0);
	GLint green = args.GetInt(1);
	GLint blue = args.GetInt(2);
	glColor3i(red, green, blue);
	return Value::Null;
}

// opengl.glColor3iv
Gura_DeclareFunctionAlias(__glColor3iv, "glColor3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3iv(v);
	return Value::Null;
}

// opengl.glColor3s
Gura_DeclareFunctionAlias(__glColor3s, "glColor3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3s)
{
	GLshort red = args.GetShort(0);
	GLshort green = args.GetShort(1);
	GLshort blue = args.GetShort(2);
	glColor3s(red, green, blue);
	return Value::Null;
}

// opengl.glColor3sv
Gura_DeclareFunctionAlias(__glColor3sv, "glColor3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3sv(v);
	return Value::Null;
}

// opengl.glColor3ub
Gura_DeclareFunctionAlias(__glColor3ub, "glColor3ub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3ub)
{
	GLubyte red = args.GetUChar(0);
	GLubyte green = args.GetUChar(1);
	GLubyte blue = args.GetUChar(2);
	glColor3ub(red, green, blue);
	return Value::Null;
}

// opengl.glColor3ubv
Gura_DeclareFunctionAlias(__glColor3ubv, "glColor3ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3ubv)
{
	Array<UChar> *_v = Object_array<UChar>::GetObject(args, 0)->GetArray();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3ubv(v);
	return Value::Null;
}

// opengl.glColor3ui
Gura_DeclareFunctionAlias(__glColor3ui, "glColor3ui")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3ui)
{
	GLuint red = args.GetUInt(0);
	GLuint green = args.GetUInt(1);
	GLuint blue = args.GetUInt(2);
	glColor3ui(red, green, blue);
	return Value::Null;
}

// opengl.glColor3uiv
Gura_DeclareFunctionAlias(__glColor3uiv, "glColor3uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3uiv)
{
	Array<UInt> *_v = Object_array<UInt>::GetObject(args, 0)->GetArray();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3uiv(v);
	return Value::Null;
}

// opengl.glColor3us
Gura_DeclareFunctionAlias(__glColor3us, "glColor3us")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3us)
{
	GLushort red = args.GetUShort(0);
	GLushort green = args.GetUShort(1);
	GLushort blue = args.GetUShort(2);
	glColor3us(red, green, blue);
	return Value::Null;
}

// opengl.glColor3usv
Gura_DeclareFunctionAlias(__glColor3usv, "glColor3usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_ushort, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor3usv)
{
	Array<UShort> *_v = Object_array<UShort>::GetObject(args, 0)->GetArray();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor3usv(v);
	return Value::Null;
}

// opengl.glColor4b
Gura_DeclareFunctionAlias(__glColor4b, "glColor4b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4b)
{
	GLbyte red = args.GetChar(0);
	GLbyte green = args.GetChar(1);
	GLbyte blue = args.GetChar(2);
	GLbyte alpha = args.GetChar(3);
	glColor4b(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4bv
Gura_DeclareFunctionAlias(__glColor4bv, "glColor4bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4bv)
{
	Array<char> *_v = Object_array<char>::GetObject(args, 0)->GetArray();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4bv(v);
	return Value::Null;
}

// opengl.glColor4d
Gura_DeclareFunctionAlias(__glColor4d, "glColor4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4d)
{
	GLdouble red = args.GetDouble(0);
	GLdouble green = args.GetDouble(1);
	GLdouble blue = args.GetDouble(2);
	GLdouble alpha = args.GetDouble(3);
	glColor4d(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4dv
Gura_DeclareFunctionAlias(__glColor4dv, "glColor4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glColor4dv(v);
	return Value::Null;
}

// opengl.glColor4f
Gura_DeclareFunctionAlias(__glColor4f, "glColor4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4f)
{
	GLfloat red = args.GetFloat(0);
	GLfloat green = args.GetFloat(1);
	GLfloat blue = args.GetFloat(2);
	GLfloat alpha = args.GetFloat(3);
	glColor4f(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4fv
Gura_DeclareFunctionAlias(__glColor4fv, "glColor4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glColor4fv(v);
	return Value::Null;
}

// opengl.glColor4i
Gura_DeclareFunctionAlias(__glColor4i, "glColor4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4i)
{
	GLint red = args.GetInt(0);
	GLint green = args.GetInt(1);
	GLint blue = args.GetInt(2);
	GLint alpha = args.GetInt(3);
	glColor4i(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4iv
Gura_DeclareFunctionAlias(__glColor4iv, "glColor4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4iv(v);
	return Value::Null;
}

// opengl.glColor4s
Gura_DeclareFunctionAlias(__glColor4s, "glColor4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4s)
{
	GLshort red = args.GetShort(0);
	GLshort green = args.GetShort(1);
	GLshort blue = args.GetShort(2);
	GLshort alpha = args.GetShort(3);
	glColor4s(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4sv
Gura_DeclareFunctionAlias(__glColor4sv, "glColor4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4sv(v);
	return Value::Null;
}

// opengl.glColor4ub
Gura_DeclareFunctionAlias(__glColor4ub, "glColor4ub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4ub)
{
	GLubyte red = args.GetUChar(0);
	GLubyte green = args.GetUChar(1);
	GLubyte blue = args.GetUChar(2);
	GLubyte alpha = args.GetUChar(3);
	glColor4ub(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4ubv
Gura_DeclareFunctionAlias(__glColor4ubv, "glColor4ubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4ubv)
{
	Array<UChar> *_v = Object_array<UChar>::GetObject(args, 0)->GetArray();
	GLubyte *v = reinterpret_cast<GLubyte *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4ubv(v);
	return Value::Null;
}

// opengl.glColor4ui
Gura_DeclareFunctionAlias(__glColor4ui, "glColor4ui")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4ui)
{
	GLuint red = args.GetUInt(0);
	GLuint green = args.GetUInt(1);
	GLuint blue = args.GetUInt(2);
	GLuint alpha = args.GetUInt(3);
	glColor4ui(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4uiv
Gura_DeclareFunctionAlias(__glColor4uiv, "glColor4uiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4uiv)
{
	Array<UInt> *_v = Object_array<UInt>::GetObject(args, 0)->GetArray();
	GLuint *v = reinterpret_cast<GLuint *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4uiv(v);
	return Value::Null;
}

// opengl.glColor4us
Gura_DeclareFunctionAlias(__glColor4us, "glColor4us")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4us)
{
	GLushort red = args.GetUShort(0);
	GLushort green = args.GetUShort(1);
	GLushort blue = args.GetUShort(2);
	GLushort alpha = args.GetUShort(3);
	glColor4us(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColor4usv
Gura_DeclareFunctionAlias(__glColor4usv, "glColor4usv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_ushort, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColor4usv)
{
	Array<UShort> *_v = Object_array<UShort>::GetObject(args, 0)->GetArray();
	GLushort *v = reinterpret_cast<GLushort *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glColor4usv(v);
	return Value::Null;
}

// opengl.glColorMask
Gura_DeclareFunctionAlias(__glColorMask, "glColorMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "red", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "green", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "blue", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "alpha", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColorMask)
{
	GLboolean red = (args.GetBoolean(0)? GL_TRUE : GL_FALSE);
	GLboolean green = (args.GetBoolean(1)? GL_TRUE : GL_FALSE);
	GLboolean blue = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	GLboolean alpha = (args.GetBoolean(3)? GL_TRUE : GL_FALSE);
	glColorMask(red, green, blue, alpha);
	return Value::Null;
}

// opengl.glColorMaterial
Gura_DeclareFunctionAlias(__glColorMaterial, "glColorMaterial")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glColorMaterial)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum mode = static_cast<GLenum>(args.GetInt(1));
	glColorMaterial(face, mode);
	return Value::Null;
}

// opengl.glCopyPixels
Gura_DeclareFunctionAlias(__glCopyPixels, "glCopyPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCopyPixels)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLsizei width = args.GetInt(2);
	GLsizei height = args.GetInt(3);
	GLenum type = static_cast<GLenum>(args.GetInt(4));
	glCopyPixels(x, y, width, height, type);
	return Value::Null;
}

// opengl.glCopyTexImage1D
Gura_DeclareFunctionAlias(__glCopyTexImage1D, "glCopyTexImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCopyTexImage1D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLenum internalformat = static_cast<GLenum>(args.GetInt(2));
	GLint x = args.GetInt(3);
	GLint y = args.GetInt(4);
	GLsizei width = args.GetInt(5);
	GLint border = args.GetInt(6);
	glCopyTexImage1D(target, level, internalformat, x, y, width, border);
	return Value::Null;
}

// opengl.glCopyTexImage2D
Gura_DeclareFunctionAlias(__glCopyTexImage2D, "glCopyTexImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCopyTexImage2D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLenum internalformat = static_cast<GLenum>(args.GetInt(2));
	GLint x = args.GetInt(3);
	GLint y = args.GetInt(4);
	GLsizei width = args.GetInt(5);
	GLsizei height = args.GetInt(6);
	GLint border = args.GetInt(7);
	glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
	return Value::Null;
}

// opengl.glCopyTexSubImage1D
Gura_DeclareFunctionAlias(__glCopyTexSubImage1D, "glCopyTexSubImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCopyTexSubImage1D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	GLint x = args.GetInt(3);
	GLint y = args.GetInt(4);
	GLsizei width = args.GetInt(5);
	glCopyTexSubImage1D(target, level, xoffset, x, y, width);
	return Value::Null;
}

// opengl.glCopyTexSubImage2D
Gura_DeclareFunctionAlias(__glCopyTexSubImage2D, "glCopyTexSubImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCopyTexSubImage2D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	GLint yoffset = args.GetInt(3);
	GLint x = args.GetInt(4);
	GLint y = args.GetInt(5);
	GLsizei width = args.GetInt(6);
	GLsizei height = args.GetInt(7);
	glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
	return Value::Null;
}

// opengl.glCullFace
Gura_DeclareFunctionAlias(__glCullFace, "glCullFace")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glCullFace)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glCullFace(mode);
	return Value::Null;
}

// opengl.glDeleteLists
Gura_DeclareFunctionAlias(__glDeleteLists, "glDeleteLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "range", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDeleteLists)
{
	GLuint list = args.GetUInt(0);
	GLsizei range = args.GetInt(1);
	glDeleteLists(list, range);
	return Value::Null;
}

// opengl.glDeleteTextures
Gura_DeclareFunctionAlias(__glDeleteTextures, "glDeleteTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "textures", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDeleteTextures)
{
	Array<UInt> *_textures = Object_array<UInt>::GetObject(args, 0)->GetArray();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	GLsizei n = _textures->GetSize();
	glDeleteTextures(n, textures);
	return Value::Null;
}

// opengl.glDepthFunc
Gura_DeclareFunctionAlias(__glDepthFunc, "glDepthFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDepthFunc)
{
	GLenum func = static_cast<GLenum>(args.GetInt(0));
	glDepthFunc(func);
	return Value::Null;
}

// opengl.glDepthMask
Gura_DeclareFunctionAlias(__glDepthMask, "glDepthMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDepthMask)
{
	GLboolean flag = (args.GetBoolean(0)? GL_TRUE : GL_FALSE);
	glDepthMask(flag);
	return Value::Null;
}

// opengl.glDepthRange
Gura_DeclareFunctionAlias(__glDepthRange, "glDepthRange")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDepthRange)
{
	GLclampd zNear = args.GetDouble(0);
	GLclampd zFar = args.GetDouble(1);
	glDepthRange(zNear, zFar);
	return Value::Null;
}

// opengl.glDisable
Gura_DeclareFunctionAlias(__glDisable, "glDisable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDisable)
{
	GLenum cap = static_cast<GLenum>(args.GetInt(0));
	glDisable(cap);
	return Value::Null;
}

// opengl.glDisableClientState
Gura_DeclareFunctionAlias(__glDisableClientState, "glDisableClientState")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "array", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDisableClientState)
{
	GLenum array = static_cast<GLenum>(args.GetInt(0));
	glDisableClientState(array);
	return Value::Null;
}

// opengl.glDrawArrays
Gura_DeclareFunctionAlias(__glDrawArrays, "glDrawArrays")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "first", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDrawArrays)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	GLint first = args.GetInt(1);
	GLsizei count = args.GetInt(2);
	glDrawArrays(mode, first, count);
	return Value::Null;
}

// opengl.glDrawBuffer
Gura_DeclareFunctionAlias(__glDrawBuffer, "glDrawBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDrawBuffer)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glDrawBuffer(mode);
	return Value::Null;
}

// opengl.glDrawPixels
Gura_DeclareFunctionAlias(__glDrawPixels, "glDrawPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDrawPixels)
{
	GLsizei width = args.GetInt(0);
	GLsizei height = args.GetInt(1);
	GLenum format = static_cast<GLenum>(args.GetInt(2));
	GLenum type = static_cast<GLenum>(args.GetInt(3));
	Value pixels = args.GetValue(4);
	
	const void *p = GetArrayPointer(sig, type, pixels);
	if (p == NULL) return Value::Null;
	glDrawPixels(width, height, format, type, p);
	return Value::Null;
}

// opengl.glDrawPixelsFromImage
Gura_DeclareFunctionAlias(__glDrawPixelsFromImage, "glDrawPixelsFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glDrawPixelsFromImage)
{
	Image *image = Object_image::GetObject(args, 0)->GetImage();
	
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLsizei height = static_cast<GLsizei>(image->GetHeight());
	GLenum format = GetImageFormat(sig, image);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = image->GetBuffer();
	// GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels
	glDrawPixels(width, height, format, type, pixels);
	return Value::Null;
}

// opengl.glEdgeFlag
Gura_DeclareFunctionAlias(__glEdgeFlag, "glEdgeFlag")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEdgeFlag)
{
	GLboolean flag = (args.GetBoolean(0)? GL_TRUE : GL_FALSE);
	glEdgeFlag(flag);
	return Value::Null;
}

// opengl.glEdgeFlagv
Gura_DeclareFunctionAlias(__glEdgeFlagv, "glEdgeFlagv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "flag", VTYPE_boolean, OCCUR_Once, FLAG_List);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEdgeFlagv)
{
	AutoPtr<Array<GLboolean> > _flag(CreateArrayFromList<GLboolean>(args.GetList(0)));
	GLboolean *flag = _flag->GetPointer();
	if (_flag->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glEdgeFlagv(flag);
	return Value::Null;
}

// opengl.glEnable
Gura_DeclareFunctionAlias(__glEnable, "glEnable")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEnable)
{
	GLenum cap = static_cast<GLenum>(args.GetInt(0));
	glEnable(cap);
	return Value::Null;
}

// opengl.glEnableClientState
Gura_DeclareFunctionAlias(__glEnableClientState, "glEnableClientState")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "array", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEnableClientState)
{
	GLenum array = static_cast<GLenum>(args.GetInt(0));
	glEnableClientState(array);
	return Value::Null;
}

// opengl.glEnd
Gura_DeclareFunctionAlias(__glEnd, "glEnd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEnd)
{
	glEnd();
	return Value::Null;
}

// opengl.glEndList
Gura_DeclareFunctionAlias(__glEndList, "glEndList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEndList)
{
	glEndList();
	return Value::Null;
}

// opengl.glEvalCoord1d
Gura_DeclareFunctionAlias(__glEvalCoord1d, "glEvalCoord1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord1d)
{
	GLdouble u = args.GetDouble(0);
	glEvalCoord1d(u);
	return Value::Null;
}

// opengl.glEvalCoord1dv
Gura_DeclareFunctionAlias(__glEvalCoord1dv, "glEvalCoord1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord1dv)
{
	Array<double> *_u = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *u = reinterpret_cast<GLdouble *>(_u->GetPointer());
	if (_u->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glEvalCoord1dv(u);
	return Value::Null;
}

// opengl.glEvalCoord1f
Gura_DeclareFunctionAlias(__glEvalCoord1f, "glEvalCoord1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord1f)
{
	GLfloat u = args.GetFloat(0);
	glEvalCoord1f(u);
	return Value::Null;
}

// opengl.glEvalCoord1fv
Gura_DeclareFunctionAlias(__glEvalCoord1fv, "glEvalCoord1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord1fv)
{
	Array<float> *_u = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *u = reinterpret_cast<GLfloat *>(_u->GetPointer());
	if (_u->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glEvalCoord1fv(u);
	return Value::Null;
}

// opengl.glEvalCoord2d
Gura_DeclareFunctionAlias(__glEvalCoord2d, "glEvalCoord2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord2d)
{
	GLdouble u = args.GetDouble(0);
	GLdouble v = args.GetDouble(1);
	glEvalCoord2d(u, v);
	return Value::Null;
}

// opengl.glEvalCoord2dv
Gura_DeclareFunctionAlias(__glEvalCoord2dv, "glEvalCoord2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord2dv)
{
	Array<double> *_u = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *u = reinterpret_cast<GLdouble *>(_u->GetPointer());
	if (_u->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glEvalCoord2dv(u);
	return Value::Null;
}

// opengl.glEvalCoord2f
Gura_DeclareFunctionAlias(__glEvalCoord2f, "glEvalCoord2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord2f)
{
	GLfloat u = args.GetFloat(0);
	GLfloat v = args.GetFloat(1);
	glEvalCoord2f(u, v);
	return Value::Null;
}

// opengl.glEvalCoord2fv
Gura_DeclareFunctionAlias(__glEvalCoord2fv, "glEvalCoord2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "u", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalCoord2fv)
{
	Array<float> *_u = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *u = reinterpret_cast<GLfloat *>(_u->GetPointer());
	if (_u->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glEvalCoord2fv(u);
	return Value::Null;
}

// opengl.glEvalMesh1
Gura_DeclareFunctionAlias(__glEvalMesh1, "glEvalMesh1")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalMesh1)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	GLint i1 = args.GetInt(1);
	GLint i2 = args.GetInt(2);
	glEvalMesh1(mode, i1, i2);
	return Value::Null;
}

// opengl.glEvalMesh2
Gura_DeclareFunctionAlias(__glEvalMesh2, "glEvalMesh2")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "i2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalMesh2)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	GLint i1 = args.GetInt(1);
	GLint i2 = args.GetInt(2);
	GLint j1 = args.GetInt(3);
	GLint j2 = args.GetInt(4);
	glEvalMesh2(mode, i1, i2, j1, j2);
	return Value::Null;
}

// opengl.glEvalPoint1
Gura_DeclareFunctionAlias(__glEvalPoint1, "glEvalPoint1")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalPoint1)
{
	GLint i = args.GetInt(0);
	glEvalPoint1(i);
	return Value::Null;
}

// opengl.glEvalPoint2
Gura_DeclareFunctionAlias(__glEvalPoint2, "glEvalPoint2")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "i", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "j", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glEvalPoint2)
{
	GLint i = args.GetInt(0);
	GLint j = args.GetInt(1);
	glEvalPoint2(i, j);
	return Value::Null;
}

// opengl.glFeedbackBuffer
Gura_DeclareFunctionAlias(__glFeedbackBuffer, "glFeedbackBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "buffer", VTYPE_array_float, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFeedbackBuffer)
{
	GLenum type = static_cast<GLenum>(args.GetInt(0));
	Array<float> *buffer = args.IsValid(1)? Object_array<float>::GetObject(args, 1)->GetArray() : NULL;
	if (buffer == NULL) {
		glFeedbackBuffer(0, type, NULL);
	} else {
		glFeedbackBuffer(buffer->GetSize(), type, buffer->GetPointer());
	}
	return Value::Null;
}

// opengl.glFinish
Gura_DeclareFunctionAlias(__glFinish, "glFinish")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFinish)
{
	glFinish();
	return Value::Null;
}

// opengl.glFlush
Gura_DeclareFunctionAlias(__glFlush, "glFlush")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFlush)
{
	glFlush();
	return Value::Null;
}

// opengl.glFogf
Gura_DeclareFunctionAlias(__glFogf, "glFogf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFogf)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLfloat param = args.GetFloat(1);
	glFogf(pname, param);
	return Value::Null;
}

// opengl.glFogfv
Gura_DeclareFunctionAlias(__glFogfv, "glFogfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFogfv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	Array<float> *_params = Object_array<float>::GetObject(args, 1)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glFogfv(pname, params);
	return Value::Null;
}

// opengl.glFogi
Gura_DeclareFunctionAlias(__glFogi, "glFogi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFogi)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLint param = args.GetInt(1);
	glFogi(pname, param);
	return Value::Null;
}

// opengl.glFogiv
Gura_DeclareFunctionAlias(__glFogiv, "glFogiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFogiv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	Array<int> *_params = Object_array<int>::GetObject(args, 1)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glFogiv(pname, params);
	return Value::Null;
}

// opengl.glFrontFace
Gura_DeclareFunctionAlias(__glFrontFace, "glFrontFace")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFrontFace)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glFrontFace(mode);
	return Value::Null;
}

// opengl.glFrustum
Gura_DeclareFunctionAlias(__glFrustum, "glFrustum")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "left", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "right", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bottom", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "top", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glFrustum)
{
	GLdouble left = args.GetDouble(0);
	GLdouble right = args.GetDouble(1);
	GLdouble bottom = args.GetDouble(2);
	GLdouble top = args.GetDouble(3);
	GLdouble zNear = args.GetDouble(4);
	GLdouble zFar = args.GetDouble(5);
	glFrustum(left, right, bottom, top, zNear, zFar);
	return Value::Null;
}

// opengl.glGenLists
Gura_DeclareFunctionAlias(__glGenLists, "glGenLists")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "range", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGenLists)
{
	GLsizei range = args.GetInt(0);
	GLuint _rtn = glGenLists(range);
	return ReturnValue(env, sig, args, Value(_rtn));
}

// opengl.glGenTextures
Gura_DeclareFunctionAlias(__glGenTextures, "glGenTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "n", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGenTextures)
{
	GLsizei n = args.GetInt(0);
	AutoPtr<Array<GLuint> > _textures(new Array<GLuint>(n));
	GLuint *textures = _textures->GetPointer();
	glGenTextures(n, textures);
	return Value::CreateList(env, textures, n);
}

// opengl.glGetBooleanv
Gura_DeclareFunctionAlias(__glGetBooleanv, "glGetBooleanv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetBooleanv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLboolean> > _params(new Array<GLboolean>(n));
	GLboolean *params = _params->GetPointer();
	glGetBooleanv(pname, params);
	Value _rtnVal;
	ValueList &valList = _rtnVal.InitAsList(env, n);
	for (GLsizei i = 0; i < n; i++) {
		valList.push_back(params[i] != 0);
	}
	return ReturnValue(env, sig, args, _rtnVal);
}

// opengl.glGetClipPlane
Gura_DeclareFunctionAlias(__glGetClipPlane, "glGetClipPlane")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareArg(env, "plane", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetClipPlane)
{
	GLenum plane = static_cast<GLenum>(args.GetInt(0));
	GLdouble equation[4];
	glGetClipPlane(plane, equation);
	return ReturnValue(env, sig, args, Value::CreateList(env, equation, ArraySizeOf(equation)));
}

// opengl.glGetDoublev
Gura_DeclareFunctionAlias(__glGetDoublev, "glGetDoublev")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetDoublev)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLdouble> > _params(new Array<GLdouble>(n));
	GLdouble *params = _params->GetPointer();
	glGetDoublev(pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetError
Gura_DeclareFunctionAlias(__glGetError, "glGetError")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetError)
{
	GLenum _rtn = glGetError();
	return ReturnValue(env, sig, args, Value(_rtn));
}

// opengl.glGetFloatv
Gura_DeclareFunctionAlias(__glGetFloatv, "glGetFloatv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetFloatv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetFloatv(pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetIntegerv
Gura_DeclareFunctionAlias(__glGetIntegerv, "glGetIntegerv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetIntegerv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetIntegerv(pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetLightfv
Gura_DeclareFunctionAlias(__glGetLightfv, "glGetLightfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetLightfv)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetLightfv(light, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetLightiv
Gura_DeclareFunctionAlias(__glGetLightiv, "glGetLightiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetLightiv)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetLightiv(light, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetMapdv
Gura_DeclareFunctionAlias(__glGetMapdv, "glGetMapdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetMapdv)
{
#if 0
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum query = static_cast<GLenum>(args.GetInt(1));
	Array<double> *_v = Object_array<double>::GetObject(args, 2)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	glGetMapdv(target, query, v);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetMapdv");
	return Value::Null;
}

// opengl.glGetMapfv
Gura_DeclareFunctionAlias(__glGetMapfv, "glGetMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetMapfv)
{
#if 0
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum query = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_v = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	glGetMapfv(target, query, v);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetMapfv");
	return Value::Null;
}

// opengl.glGetMapiv
Gura_DeclareFunctionAlias(__glGetMapiv, "glGetMapiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "query", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetMapiv)
{
#if 0
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum query = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_v = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	glGetMapiv(target, query, v);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetMapiv");
	return Value::Null;
}

// opengl.glGetMaterialfv
Gura_DeclareFunctionAlias(__glGetMaterialfv, "glGetMaterialfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetMaterialfv)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetMaterialfv(face, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetMaterialiv
Gura_DeclareFunctionAlias(__glGetMaterialiv, "glGetMaterialiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetMaterialiv)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetMaterialiv(face, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetPixelMapfv
Gura_DeclareFunctionAlias(__glGetPixelMapfv, "glGetPixelMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetPixelMapfv)
{
#if 0
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	Array<float> *_values = Object_array<float>::GetObject(args, 1)->GetArray();
	GLfloat *values = reinterpret_cast<GLfloat *>(_values->GetPointer());
	glGetPixelMapfv(map, values);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetPixelMapfv");
	return Value::Null;
}

// opengl.glGetPixelMapuiv
Gura_DeclareFunctionAlias(__glGetPixelMapuiv, "glGetPixelMapuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetPixelMapuiv)
{
#if 0
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	Array<UInt> *_values = Object_array<UInt>::GetObject(args, 1)->GetArray();
	GLuint *values = reinterpret_cast<GLuint *>(_values->GetPointer());
	glGetPixelMapuiv(map, values);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetPixelMapuiv");
	return Value::Null;
}

// opengl.glGetPixelMapusv
Gura_DeclareFunctionAlias(__glGetPixelMapusv, "glGetPixelMapusv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_ushort, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetPixelMapusv)
{
#if 0
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	Array<UShort> *_values = Object_array<UShort>::GetObject(args, 1)->GetArray();
	GLushort *values = reinterpret_cast<GLushort *>(_values->GetPointer());
	glGetPixelMapusv(map, values);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetPixelMapusv");
	return Value::Null;
}

// opengl.glGetPolygonStipple
Gura_DeclareFunctionAlias(__glGetPolygonStipple, "glGetPolygonStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetPolygonStipple)
{
#if 0
	Array<UChar> *_mask = Object_array<UChar>::GetObject(args, 0)->GetArray();
	GLubyte *mask = reinterpret_cast<GLubyte *>(_mask->GetPointer());
	glGetPolygonStipple(mask);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetPolygonStipple");
	return Value::Null;
}

// opengl.glGetString
Gura_DeclareFunctionAlias(__glGetString, "glGetString")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetString)
{
	GLenum name = static_cast<GLenum>(args.GetInt(0));
	const GLubyte *_rtn = glGetString(name);
	if (_rtn == NULL) {
		sig.SetError(ERR_ValueError, "invalid name");
		return Value::Null;
	}
	return ReturnValue(env, sig, args, Value(reinterpret_cast<const char *>(_rtn)));
}

// opengl.glGetTexEnvfv
Gura_DeclareFunctionAlias(__glGetTexEnvfv, "glGetTexEnvfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexEnvfv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexEnvfv(target, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexEnviv
Gura_DeclareFunctionAlias(__glGetTexEnviv, "glGetTexEnviv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexEnviv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexEnviv(target, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexGendv
Gura_DeclareFunctionAlias(__glGetTexGendv, "glGetTexGendv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexGendv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLdouble> > _params(new Array<GLdouble>(n));
	GLdouble *params = _params->GetPointer();
	glGetTexGendv(coord, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexGenfv
Gura_DeclareFunctionAlias(__glGetTexGenfv, "glGetTexGenfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexGenfv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexGenfv(coord, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexGeniv
Gura_DeclareFunctionAlias(__glGetTexGeniv, "glGetTexGeniv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexGeniv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexGeniv(coord, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexLevelParameterfv
Gura_DeclareFunctionAlias(__glGetTexLevelParameterfv, "glGetTexLevelParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexLevelParameterfv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLenum pname = static_cast<GLenum>(args.GetInt(2));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexLevelParameterfv(target, level, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexLevelParameteriv
Gura_DeclareFunctionAlias(__glGetTexLevelParameteriv, "glGetTexLevelParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexLevelParameteriv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLenum pname = static_cast<GLenum>(args.GetInt(2));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexLevelParameteriv(target, level, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexParameterfv
Gura_DeclareFunctionAlias(__glGetTexParameterfv, "glGetTexParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexParameterfv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLfloat> > _params(new Array<GLfloat>(n));
	GLfloat *params = _params->GetPointer();
	glGetTexParameterfv(target, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glGetTexParameteriv
Gura_DeclareFunctionAlias(__glGetTexParameteriv, "glGetTexParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetTexParameteriv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	size_t n = GetParamCount(pname);
	AutoPtr<Array<GLint> > _params(new Array<GLint>(n));
	GLint *params = _params->GetPointer();
	glGetTexParameteriv(target, pname, params);
	return ReturnValue(env, sig, args, Value::CreateList(env, params, n));
}

// opengl.glHint
Gura_DeclareFunctionAlias(__glHint, "glHint")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glHint)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum mode = static_cast<GLenum>(args.GetInt(1));
	glHint(target, mode);
	return Value::Null;
}

// opengl.glIndexMask
Gura_DeclareFunctionAlias(__glIndexMask, "glIndexMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexMask)
{
	GLuint mask = args.GetUInt(0);
	glIndexMask(mask);
	return Value::Null;
}

// opengl.glIndexd
Gura_DeclareFunctionAlias(__glIndexd, "glIndexd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexd)
{
	GLdouble c = args.GetDouble(0);
	glIndexd(c);
	return Value::Null;
}

// opengl.glIndexdv
Gura_DeclareFunctionAlias(__glIndexdv, "glIndexdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexdv)
{
	Array<double> *_c = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *c = reinterpret_cast<GLdouble *>(_c->GetPointer());
	glIndexdv(c);
	return Value::Null;
}

// opengl.glIndexf
Gura_DeclareFunctionAlias(__glIndexf, "glIndexf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexf)
{
	GLfloat c = args.GetFloat(0);
	glIndexf(c);
	return Value::Null;
}

// opengl.glIndexfv
Gura_DeclareFunctionAlias(__glIndexfv, "glIndexfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexfv)
{
	Array<float> *_c = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *c = reinterpret_cast<GLfloat *>(_c->GetPointer());
	glIndexfv(c);
	return Value::Null;
}

// opengl.glIndexi
Gura_DeclareFunctionAlias(__glIndexi, "glIndexi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexi)
{
	GLint c = args.GetInt(0);
	glIndexi(c);
	return Value::Null;
}

// opengl.glIndexiv
Gura_DeclareFunctionAlias(__glIndexiv, "glIndexiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexiv)
{
	Array<int> *_c = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *c = reinterpret_cast<GLint *>(_c->GetPointer());
	glIndexiv(c);
	return Value::Null;
}

// opengl.glIndexs
Gura_DeclareFunctionAlias(__glIndexs, "glIndexs")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexs)
{
	GLshort c = args.GetShort(0);
	glIndexs(c);
	return Value::Null;
}

// opengl.glIndexsv
Gura_DeclareFunctionAlias(__glIndexsv, "glIndexsv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexsv)
{
	Array<short> *_c = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *c = reinterpret_cast<GLshort *>(_c->GetPointer());
	glIndexsv(c);
	return Value::Null;
}

// opengl.glIndexub
Gura_DeclareFunctionAlias(__glIndexub, "glIndexub")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexub)
{
	GLubyte c = args.GetUChar(0);
	glIndexub(c);
	return Value::Null;
}

// opengl.glIndexubv
Gura_DeclareFunctionAlias(__glIndexubv, "glIndexubv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "c", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIndexubv)
{
	Array<UChar> *_c = Object_array<UChar>::GetObject(args, 0)->GetArray();
	GLubyte *c = reinterpret_cast<GLubyte *>(_c->GetPointer());
	glIndexubv(c);
	return Value::Null;
}

// opengl.glInitNames
Gura_DeclareFunctionAlias(__glInitNames, "glInitNames")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glInitNames)
{
	glInitNames();
	return Value::Null;
}

// opengl.glIsEnabled
Gura_DeclareFunctionAlias(__glIsEnabled, "glIsEnabled")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "cap", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIsEnabled)
{
	GLenum cap = static_cast<GLenum>(args.GetInt(0));
	GLboolean _rtn = glIsEnabled(cap);
	return ReturnValue(env, sig, args, Value(_rtn != GL_FALSE));
}

// opengl.glIsList
Gura_DeclareFunctionAlias(__glIsList, "glIsList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIsList)
{
	GLuint list = args.GetUInt(0);
	GLboolean _rtn = glIsList(list);
	return ReturnValue(env, sig, args, Value(_rtn != GL_FALSE));
}

// opengl.glIsTexture
Gura_DeclareFunctionAlias(__glIsTexture, "glIsTexture")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "texture", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glIsTexture)
{
	GLuint texture = args.GetUInt(0);
	GLboolean _rtn = glIsTexture(texture);
	return ReturnValue(env, sig, args, Value(_rtn != GL_FALSE));
}

// opengl.glLightModelf
Gura_DeclareFunctionAlias(__glLightModelf, "glLightModelf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightModelf)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLfloat param = args.GetFloat(1);
	glLightModelf(pname, param);
	return Value::Null;
}

// opengl.glLightModelfv
Gura_DeclareFunctionAlias(__glLightModelfv, "glLightModelfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightModelfv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	Array<float> *_params = Object_array<float>::GetObject(args, 1)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glLightModelfv(pname, params);
	return Value::Null;
}

// opengl.glLightModeli
Gura_DeclareFunctionAlias(__glLightModeli, "glLightModeli")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightModeli)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLint param = args.GetInt(1);
	glLightModeli(pname, param);
	return Value::Null;
}

// opengl.glLightModeliv
Gura_DeclareFunctionAlias(__glLightModeliv, "glLightModeliv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightModeliv)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	Array<int> *_params = Object_array<int>::GetObject(args, 1)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glLightModeliv(pname, params);
	return Value::Null;
}

// opengl.glLightf
Gura_DeclareFunctionAlias(__glLightf, "glLightf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightf)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLfloat param = args.GetFloat(2);
	glLightf(light, pname, param);
	return Value::Null;
}

// opengl.glLightfv
Gura_DeclareFunctionAlias(__glLightfv, "glLightfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightfv)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glLightfv(light, pname, params);
	return Value::Null;
}

// opengl.glLighti
Gura_DeclareFunctionAlias(__glLighti, "glLighti")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLighti)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLint param = args.GetInt(2);
	glLighti(light, pname, param);
	return Value::Null;
}

// opengl.glLightiv
Gura_DeclareFunctionAlias(__glLightiv, "glLightiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "light", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLightiv)
{
	GLenum light = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glLightiv(light, pname, params);
	return Value::Null;
}

// opengl.glLineStipple
Gura_DeclareFunctionAlias(__glLineStipple, "glLineStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "factor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pattern", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLineStipple)
{
	GLint factor = args.GetInt(0);
	GLushort pattern = args.GetUShort(1);
	glLineStipple(factor, pattern);
	return Value::Null;
}

// opengl.glLineWidth
Gura_DeclareFunctionAlias(__glLineWidth, "glLineWidth")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLineWidth)
{
	GLfloat width = args.GetFloat(0);
	glLineWidth(width);
	return Value::Null;
}

// opengl.glListBase
Gura_DeclareFunctionAlias(__glListBase, "glListBase")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "base", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glListBase)
{
	GLuint base = args.GetUInt(0);
	glListBase(base);
	return Value::Null;
}

// opengl.glLoadIdentity
Gura_DeclareFunctionAlias(__glLoadIdentity, "glLoadIdentity")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLoadIdentity)
{
	glLoadIdentity();
	return Value::Null;
}

// opengl.glLoadMatrixd
Gura_DeclareFunctionAlias(__glLoadMatrixd, "glLoadMatrixd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLoadMatrixd)
{
	AutoPtr<Array<GLdouble> > _m(MakeMatrix<GLdouble>(sig, args.GetValue(0)));
	if (sig.IsSignalled()) return Value::Null;
	GLdouble *m = _m->GetPointer();
	glLoadMatrixd(m);
	return Value::Null;
}

// opengl.glLoadMatrixf
Gura_DeclareFunctionAlias(__glLoadMatrixf, "glLoadMatrixf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLoadMatrixf)
{
	AutoPtr<Array<GLfloat> > _m(MakeMatrix<GLfloat>(sig, args.GetValue(0)));
	if (sig.IsSignalled()) return Value::Null;
	GLfloat *m = _m->GetPointer();
	glLoadMatrixf(m);
	return Value::Null;
}

// opengl.glLoadName
Gura_DeclareFunctionAlias(__glLoadName, "glLoadName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLoadName)
{
	GLuint name = args.GetUInt(0);
	glLoadName(name);
	return Value::Null;
}

// opengl.glLogicOp
Gura_DeclareFunctionAlias(__glLogicOp, "glLogicOp")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "opcode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glLogicOp)
{
	GLenum opcode = static_cast<GLenum>(args.GetInt(0));
	glLogicOp(opcode);
	return Value::Null;
}

// opengl.glMap1d
Gura_DeclareFunctionAlias(__glMap1d, "glMap1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "order", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMap1d)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLdouble u1 = args.GetDouble(1);
	GLdouble u2 = args.GetDouble(2);
	GLint stride = args.GetInt(3);
	GLint order = args.GetInt(4);
	Array<double> *points = Object_array<double>::GetObject(args, 5)->GetArray();
	glMap1d(target, u1, u2, stride, order, points->GetPointer());
	return Value::Null;
}

// opengl.glMap1f
Gura_DeclareFunctionAlias(__glMap1f, "glMap1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "stride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "order", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMap1f)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLfloat u1 = args.GetFloat(1);
	GLfloat u2 = args.GetFloat(2);
	GLint stride = args.GetInt(3);
	GLint order = args.GetInt(4);
	Array<float> *points = Object_array<float>::GetObject(args, 5)->GetArray();
	glMap1f(target, u1, u2, stride, order, points->GetPointer());
	return Value::Null;
}

// opengl.glMap2d
Gura_DeclareFunctionAlias(__glMap2d, "glMap2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ustride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "uorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vstride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMap2d)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLdouble u1 = args.GetDouble(1);
	GLdouble u2 = args.GetDouble(2);
	GLint ustride = args.GetInt(3);
	GLint uorder = args.GetInt(4);
	GLdouble v1 = args.GetDouble(5);
	GLdouble v2 = args.GetDouble(6);
	GLint vstride = args.GetInt(7);
	GLint vorder = args.GetInt(8);
	Array<double> *points = Object_array<double>::GetObject(args, 9)->GetArray();
	glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points->GetPointer());
	return Value::Null;
}

// opengl.glMap2f
Gura_DeclareFunctionAlias(__glMap2f, "glMap2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ustride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "uorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vstride", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vorder", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "points", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMap2f)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLfloat u1 = args.GetFloat(1);
	GLfloat u2 = args.GetFloat(2);
	GLint ustride = args.GetInt(3);
	GLint uorder = args.GetInt(4);
	GLfloat v1 = args.GetFloat(5);
	GLfloat v2 = args.GetFloat(6);
	GLint vstride = args.GetInt(7);
	GLint vorder = args.GetInt(8);
	Array<float> *points = Object_array<float>::GetObject(args, 9)->GetArray();
	glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points->GetPointer());
	return Value::Null;
}

// opengl.glMapGrid1d
Gura_DeclareFunctionAlias(__glMapGrid1d, "glMapGrid1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMapGrid1d)
{
	GLint un = args.GetInt(0);
	GLdouble u1 = args.GetDouble(1);
	GLdouble u2 = args.GetDouble(2);
	glMapGrid1d(un, u1, u2);
	return Value::Null;
}

// opengl.glMapGrid1f
Gura_DeclareFunctionAlias(__glMapGrid1f, "glMapGrid1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMapGrid1f)
{
	GLint un = args.GetInt(0);
	GLfloat u1 = args.GetFloat(1);
	GLfloat u2 = args.GetFloat(2);
	glMapGrid1f(un, u1, u2);
	return Value::Null;
}

// opengl.glMapGrid2d
Gura_DeclareFunctionAlias(__glMapGrid2d, "glMapGrid2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vn", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMapGrid2d)
{
	GLint un = args.GetInt(0);
	GLdouble u1 = args.GetDouble(1);
	GLdouble u2 = args.GetDouble(2);
	GLint vn = args.GetInt(3);
	GLdouble v1 = args.GetDouble(4);
	GLdouble v2 = args.GetDouble(5);
	glMapGrid2d(un, u1, u2, vn, v1, v2);
	return Value::Null;
}

// opengl.glMapGrid2f
Gura_DeclareFunctionAlias(__glMapGrid2f, "glMapGrid2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "un", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "u2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "vn", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "v2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMapGrid2f)
{
	GLint un = args.GetInt(0);
	GLfloat u1 = args.GetFloat(1);
	GLfloat u2 = args.GetFloat(2);
	GLint vn = args.GetInt(3);
	GLfloat v1 = args.GetFloat(4);
	GLfloat v2 = args.GetFloat(5);
	glMapGrid2f(un, u1, u2, vn, v1, v2);
	return Value::Null;
}

// opengl.glMaterialf
Gura_DeclareFunctionAlias(__glMaterialf, "glMaterialf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMaterialf)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLfloat param = args.GetFloat(2);
	glMaterialf(face, pname, param);
	return Value::Null;
}

// opengl.glMaterialfv
Gura_DeclareFunctionAlias(__glMaterialfv, "glMaterialfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMaterialfv)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glMaterialfv(face, pname, params);
	return Value::Null;
}

// opengl.glMateriali
Gura_DeclareFunctionAlias(__glMateriali, "glMateriali")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMateriali)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLint param = args.GetInt(2);
	glMateriali(face, pname, param);
	return Value::Null;
}

// opengl.glMaterialiv
Gura_DeclareFunctionAlias(__glMaterialiv, "glMaterialiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMaterialiv)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glMaterialiv(face, pname, params);
	return Value::Null;
}

// opengl.glMatrixMode
Gura_DeclareFunctionAlias(__glMatrixMode, "glMatrixMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMatrixMode)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glMatrixMode(mode);
	return Value::Null;
}

// opengl.glMultMatrixd
Gura_DeclareFunctionAlias(__glMultMatrixd, "glMultMatrixd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMultMatrixd)
{
	AutoPtr<Array<GLdouble> > _m(MakeMatrix<GLdouble>(sig, args.GetValue(0)));
	if (sig.IsSignalled()) return Value::Null;
	GLdouble *m = _m->GetPointer();
	glMultMatrixd(m);
	return Value::Null;
}

// opengl.glMultMatrixf
Gura_DeclareFunctionAlias(__glMultMatrixf, "glMultMatrixf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "m", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glMultMatrixf)
{
	AutoPtr<Array<GLfloat> > _m(MakeMatrix<GLfloat>(sig, args.GetValue(0)));
	if (sig.IsSignalled()) return Value::Null;
	GLfloat *m = _m->GetPointer();
	glMultMatrixf(m);
	return Value::Null;
}

// opengl.glNewList
Gura_DeclareFunctionAlias(__glNewList, "glNewList")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "list", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNewList)
{
	GLuint list = args.GetUInt(0);
	GLenum mode = static_cast<GLenum>(args.GetInt(1));
	glNewList(list, mode);
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glEndList();
	}
	return Value::Null;
}

// opengl.glNormal3b
Gura_DeclareFunctionAlias(__glNormal3b, "glNormal3b")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3b)
{
	GLbyte nx = args.GetChar(0);
	GLbyte ny = args.GetChar(1);
	GLbyte nz = args.GetChar(2);
	glNormal3b(nx, ny, nz);
	return Value::Null;
}

// opengl.glNormal3bv
Gura_DeclareFunctionAlias(__glNormal3bv, "glNormal3bv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3bv)
{
	Array<char> *_v = Object_array<char>::GetObject(args, 0)->GetArray();
	GLbyte *v = reinterpret_cast<GLbyte *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glNormal3bv(v);
	return Value::Null;
}

// opengl.glNormal3d
Gura_DeclareFunctionAlias(__glNormal3d, "glNormal3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3d)
{
	GLdouble nx = args.GetDouble(0);
	GLdouble ny = args.GetDouble(1);
	GLdouble nz = args.GetDouble(2);
	glNormal3d(nx, ny, nz);
	return Value::Null;
}

// opengl.glNormal3dv
Gura_DeclareFunctionAlias(__glNormal3dv, "glNormal3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glNormal3dv(v);
	return Value::Null;
}

// opengl.glNormal3f
Gura_DeclareFunctionAlias(__glNormal3f, "glNormal3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3f)
{
	GLfloat nx = args.GetFloat(0);
	GLfloat ny = args.GetFloat(1);
	GLfloat nz = args.GetFloat(2);
	glNormal3f(nx, ny, nz);
	return Value::Null;
}

// opengl.glNormal3fv
Gura_DeclareFunctionAlias(__glNormal3fv, "glNormal3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glNormal3fv(v);
	return Value::Null;
}

// opengl.glNormal3i
Gura_DeclareFunctionAlias(__glNormal3i, "glNormal3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3i)
{
	GLint nx = args.GetInt(0);
	GLint ny = args.GetInt(1);
	GLint nz = args.GetInt(2);
	glNormal3i(nx, ny, nz);
	return Value::Null;
}

// opengl.glNormal3iv
Gura_DeclareFunctionAlias(__glNormal3iv, "glNormal3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glNormal3iv(v);
	return Value::Null;
}

// opengl.glNormal3s
Gura_DeclareFunctionAlias(__glNormal3s, "glNormal3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "nx", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ny", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "nz", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3s)
{
	GLshort nx = args.GetShort(0);
	GLshort ny = args.GetShort(1);
	GLshort nz = args.GetShort(2);
	glNormal3s(nx, ny, nz);
	return Value::Null;
}

// opengl.glNormal3sv
Gura_DeclareFunctionAlias(__glNormal3sv, "glNormal3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glNormal3sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glNormal3sv(v);
	return Value::Null;
}

// opengl.glOrtho
Gura_DeclareFunctionAlias(__glOrtho, "glOrtho")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "left", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "right", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bottom", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "top", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zNear", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zFar", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glOrtho)
{
	GLdouble left = args.GetDouble(0);
	GLdouble right = args.GetDouble(1);
	GLdouble bottom = args.GetDouble(2);
	GLdouble top = args.GetDouble(3);
	GLdouble zNear = args.GetDouble(4);
	GLdouble zFar = args.GetDouble(5);
	glOrtho(left, right, bottom, top, zNear, zFar);
	return Value::Null;
}

// opengl.glPassThrough
Gura_DeclareFunctionAlias(__glPassThrough, "glPassThrough")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "token", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPassThrough)
{
	GLfloat token = args.GetFloat(0);
	glPassThrough(token);
	return Value::Null;
}

// opengl.glPixelMapfv
Gura_DeclareFunctionAlias(__glPixelMapfv, "glPixelMapfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelMapfv)
{
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	GLint mapsize = args.GetInt(1);
	Array<float> *_values = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *values = reinterpret_cast<GLfloat *>(_values->GetPointer());
	glPixelMapfv(map, mapsize, values);
	return Value::Null;
}

// opengl.glPixelMapuiv
Gura_DeclareFunctionAlias(__glPixelMapuiv, "glPixelMapuiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelMapuiv)
{
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	GLint mapsize = args.GetInt(1);
	Array<UInt> *_values = Object_array<UInt>::GetObject(args, 2)->GetArray();
	GLuint *values = reinterpret_cast<GLuint *>(_values->GetPointer());
	glPixelMapuiv(map, mapsize, values);
	return Value::Null;
}

// opengl.glPixelMapusv
Gura_DeclareFunctionAlias(__glPixelMapusv, "glPixelMapusv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "map", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mapsize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "values", VTYPE_array_ushort, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelMapusv)
{
	GLenum map = static_cast<GLenum>(args.GetInt(0));
	GLint mapsize = args.GetInt(1);
	Array<UShort> *_values = Object_array<UShort>::GetObject(args, 2)->GetArray();
	GLushort *values = reinterpret_cast<GLushort *>(_values->GetPointer());
	glPixelMapusv(map, mapsize, values);
	return Value::Null;
}

// opengl.glPixelStoref
Gura_DeclareFunctionAlias(__glPixelStoref, "glPixelStoref")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelStoref)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLfloat param = args.GetFloat(1);
	glPixelStoref(pname, param);
	return Value::Null;
}

// opengl.glPixelStorei
Gura_DeclareFunctionAlias(__glPixelStorei, "glPixelStorei")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelStorei)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLint param = args.GetInt(1);
	glPixelStorei(pname, param);
	return Value::Null;
}

// opengl.glPixelTransferf
Gura_DeclareFunctionAlias(__glPixelTransferf, "glPixelTransferf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelTransferf)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLfloat param = args.GetFloat(1);
	glPixelTransferf(pname, param);
	return Value::Null;
}

// opengl.glPixelTransferi
Gura_DeclareFunctionAlias(__glPixelTransferi, "glPixelTransferi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelTransferi)
{
	GLenum pname = static_cast<GLenum>(args.GetInt(0));
	GLint param = args.GetInt(1);
	glPixelTransferi(pname, param);
	return Value::Null;
}

// opengl.glPixelZoom
Gura_DeclareFunctionAlias(__glPixelZoom, "glPixelZoom")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "xfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yfactor", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPixelZoom)
{
	GLfloat xfactor = args.GetFloat(0);
	GLfloat yfactor = args.GetFloat(1);
	glPixelZoom(xfactor, yfactor);
	return Value::Null;
}

// opengl.glPointSize
Gura_DeclareFunctionAlias(__glPointSize, "glPointSize")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "size", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPointSize)
{
	GLfloat size = args.GetFloat(0);
	glPointSize(size);
	return Value::Null;
}

// opengl.glPolygonMode
Gura_DeclareFunctionAlias(__glPolygonMode, "glPolygonMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "face", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPolygonMode)
{
	GLenum face = static_cast<GLenum>(args.GetInt(0));
	GLenum mode = static_cast<GLenum>(args.GetInt(1));
	glPolygonMode(face, mode);
	return Value::Null;
}

// opengl.glPolygonOffset
Gura_DeclareFunctionAlias(__glPolygonOffset, "glPolygonOffset")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "factor", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "units", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPolygonOffset)
{
	GLfloat factor = args.GetFloat(0);
	GLfloat units = args.GetFloat(1);
	glPolygonOffset(factor, units);
	return Value::Null;
}

// opengl.glPolygonStipple
Gura_DeclareFunctionAlias(__glPolygonStipple, "glPolygonStipple")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_array_uchar, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPolygonStipple)
{
	Array<UChar> *_mask = Object_array<UChar>::GetObject(args, 0)->GetArray();
	GLubyte *mask = reinterpret_cast<GLubyte *>(_mask->GetPointer());
	if (_mask->GetSize() != 32 * 4) {
		sig.SetError(ERR_ValueError, "mask must contain 32 * 4 elements");
		return Value::Null;
	}
	glPolygonStipple(mask);
	return Value::Null;
}

// opengl.glPopAttrib
Gura_DeclareFunctionAlias(__glPopAttrib, "glPopAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPopAttrib)
{
	glPopAttrib();
	return Value::Null;
}

// opengl.glPopClientAttrib
Gura_DeclareFunctionAlias(__glPopClientAttrib, "glPopClientAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPopClientAttrib)
{
	glPopClientAttrib();
	return Value::Null;
}

// opengl.glPopMatrix
Gura_DeclareFunctionAlias(__glPopMatrix, "glPopMatrix")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPopMatrix)
{
	glPopMatrix();
	return Value::Null;
}

// opengl.glPopName
Gura_DeclareFunctionAlias(__glPopName, "glPopName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPopName)
{
	glPopName();
	return Value::Null;
}

// opengl.glPrioritizeTextures
Gura_DeclareFunctionAlias(__glPrioritizeTextures, "glPrioritizeTextures")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "textures", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "priorities", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPrioritizeTextures)
{
	Array<UInt> *_textures = Object_array<UInt>::GetObject(args, 0)->GetArray();
	GLuint *textures = reinterpret_cast<GLuint *>(_textures->GetPointer());
	Array<float> *_priorities = Object_array<float>::GetObject(args, 1)->GetArray();
	GLclampf *priorities = reinterpret_cast<GLclampf *>(_priorities->GetPointer());
	GLsizei n = _textures->GetSize();
	if (n != _priorities->GetSize()) {
		sig.SetError(ERR_ValueError, "textures and priorities must have the same number of elements");
		return Value::Null;
	}
	glPrioritizeTextures(n, textures, priorities);
	return Value::Null;
}

// opengl.glPushAttrib
Gura_DeclareFunctionAlias(__glPushAttrib, "glPushAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPushAttrib)
{
	GLbitfield mask = args.GetUInt(0);
	glPushAttrib(mask);
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glPopAttrib();
	}
	return Value::Null;
}

// opengl.glPushClientAttrib
Gura_DeclareFunctionAlias(__glPushClientAttrib, "glPushClientAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPushClientAttrib)
{
	GLbitfield mask = args.GetUInt(0);
	glPushClientAttrib(mask);
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glPopClientAttrib();
	}
	return Value::Null;
}

// opengl.glPushMatrix
Gura_DeclareFunctionAlias(__glPushMatrix, "glPushMatrix")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareBlock(OCCUR_ZeroOrOnce);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPushMatrix)
{
	glPushMatrix();
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glPopMatrix();
	}
	return Value::Null;
}

// opengl.glPushName
Gura_DeclareFunctionAlias(__glPushName, "glPushName")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "name", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glPushName)
{
	GLuint name = args.GetUInt(0);
	glPushName(name);
	if (args.IsBlockSpecified()) {
		SeqPostHandler *pSeqPostHandler = NULL;
		const Expr_Block *pExprBlock = args.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec2(env, sig, pSeqPostHandler);
		glPopName();
	}
	return Value::Null;
}

// opengl.glRasterPos2d
Gura_DeclareFunctionAlias(__glRasterPos2d, "glRasterPos2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	glRasterPos2d(x, y);
	return Value::Null;
}

// opengl.glRasterPos2dv
Gura_DeclareFunctionAlias(__glRasterPos2dv, "glRasterPos2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRasterPos2dv(v);
	return Value::Null;
}

// opengl.glRasterPos2f
Gura_DeclareFunctionAlias(__glRasterPos2f, "glRasterPos2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	glRasterPos2f(x, y);
	return Value::Null;
}

// opengl.glRasterPos2fv
Gura_DeclareFunctionAlias(__glRasterPos2fv, "glRasterPos2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRasterPos2fv(v);
	return Value::Null;
}

// opengl.glRasterPos2i
Gura_DeclareFunctionAlias(__glRasterPos2i, "glRasterPos2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	glRasterPos2i(x, y);
	return Value::Null;
}

// opengl.glRasterPos2iv
Gura_DeclareFunctionAlias(__glRasterPos2iv, "glRasterPos2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRasterPos2iv(v);
	return Value::Null;
}

// opengl.glRasterPos2s
Gura_DeclareFunctionAlias(__glRasterPos2s, "glRasterPos2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	glRasterPos2s(x, y);
	return Value::Null;
}

// opengl.glRasterPos2sv
Gura_DeclareFunctionAlias(__glRasterPos2sv, "glRasterPos2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos2sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRasterPos2sv(v);
	return Value::Null;
}

// opengl.glRasterPos3d
Gura_DeclareFunctionAlias(__glRasterPos3d, "glRasterPos3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	glRasterPos3d(x, y, z);
	return Value::Null;
}

// opengl.glRasterPos3dv
Gura_DeclareFunctionAlias(__glRasterPos3dv, "glRasterPos3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos3dv(v);
	return Value::Null;
}

// opengl.glRasterPos3f
Gura_DeclareFunctionAlias(__glRasterPos3f, "glRasterPos3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	glRasterPos3f(x, y, z);
	return Value::Null;
}

// opengl.glRasterPos3fv
Gura_DeclareFunctionAlias(__glRasterPos3fv, "glRasterPos3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos3fv(v);
	return Value::Null;
}

// opengl.glRasterPos3i
Gura_DeclareFunctionAlias(__glRasterPos3i, "glRasterPos3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLint z = args.GetInt(2);
	glRasterPos3i(x, y, z);
	return Value::Null;
}

// opengl.glRasterPos3iv
Gura_DeclareFunctionAlias(__glRasterPos3iv, "glRasterPos3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos3iv(v);
	return Value::Null;
}

// opengl.glRasterPos3s
Gura_DeclareFunctionAlias(__glRasterPos3s, "glRasterPos3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	GLshort z = args.GetShort(2);
	glRasterPos3s(x, y, z);
	return Value::Null;
}

// opengl.glRasterPos3sv
Gura_DeclareFunctionAlias(__glRasterPos3sv, "glRasterPos3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos3sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos3sv(v);
	return Value::Null;
}

// opengl.glRasterPos4d
Gura_DeclareFunctionAlias(__glRasterPos4d, "glRasterPos4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	GLdouble w = args.GetDouble(3);
	glRasterPos4d(x, y, z, w);
	return Value::Null;
}

// opengl.glRasterPos4dv
Gura_DeclareFunctionAlias(__glRasterPos4dv, "glRasterPos4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glRasterPos4dv(v);
	return Value::Null;
}

// opengl.glRasterPos4f
Gura_DeclareFunctionAlias(__glRasterPos4f, "glRasterPos4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	GLfloat w = args.GetFloat(3);
	glRasterPos4f(x, y, z, w);
	return Value::Null;
}

// opengl.glRasterPos4fv
Gura_DeclareFunctionAlias(__glRasterPos4fv, "glRasterPos4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glRasterPos4fv(v);
	return Value::Null;
}

// opengl.glRasterPos4i
Gura_DeclareFunctionAlias(__glRasterPos4i, "glRasterPos4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLint z = args.GetInt(2);
	GLint w = args.GetInt(3);
	glRasterPos4i(x, y, z, w);
	return Value::Null;
}

// opengl.glRasterPos4iv
Gura_DeclareFunctionAlias(__glRasterPos4iv, "glRasterPos4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos4iv(v);
	return Value::Null;
}

// opengl.glRasterPos4s
Gura_DeclareFunctionAlias(__glRasterPos4s, "glRasterPos4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	GLshort z = args.GetShort(2);
	GLshort w = args.GetShort(3);
	glRasterPos4s(x, y, z, w);
	return Value::Null;
}

// opengl.glRasterPos4sv
Gura_DeclareFunctionAlias(__glRasterPos4sv, "glRasterPos4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRasterPos4sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glRasterPos4sv(v);
	return Value::Null;
}

// opengl.glReadBuffer
Gura_DeclareFunctionAlias(__glReadBuffer, "glReadBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glReadBuffer)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glReadBuffer(mode);
	return Value::Null;
}

// opengl.glReadPixels
Gura_DeclareFunctionAlias(__glReadPixels, "glReadPixels")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_symbol, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glReadPixels)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLsizei width = args.GetInt(2);
	GLsizei height = args.GetInt(3);
	const Symbol *format = args.GetSymbol(4);
	Image::Format fmt = Image::SymbolToFormat(sig, format);
	if (sig.IsSignalled()) return Value::Null;
	AutoPtr<Image> pImage(new Image(fmt));
	GLenum _format = GetImageFormat(sig, pImage.get());
	if (sig.IsSignalled()) return Value::Null;
	if (!pImage->AllocBuffer(sig, width, height, 0xff)) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	glReadPixels(x, y, width, height, _format, type, pImage->GetBuffer());
	return ReturnValue(env, sig, args, Value(new Object_image(env, pImage.release())));
}

// opengl.glRectd
Gura_DeclareFunctionAlias(__glRectd, "glRectd")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectd)
{
	GLdouble x1 = args.GetDouble(0);
	GLdouble y1 = args.GetDouble(1);
	GLdouble x2 = args.GetDouble(2);
	GLdouble y2 = args.GetDouble(3);
	glRectd(x1, y1, x2, y2);
	return Value::Null;
}

// opengl.glRectdv
Gura_DeclareFunctionAlias(__glRectdv, "glRectdv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectdv)
{
	Array<double> *_v1 = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v1 = reinterpret_cast<GLdouble *>(_v1->GetPointer());
	if (_v1->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	Array<double> *_v2 = Object_array<double>::GetObject(args, 1)->GetArray();
	GLdouble *v2 = reinterpret_cast<GLdouble *>(_v2->GetPointer());
	if (_v2->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRectdv(v1, v2);
	return Value::Null;
}

// opengl.glRectf
Gura_DeclareFunctionAlias(__glRectf, "glRectf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectf)
{
	GLfloat x1 = args.GetFloat(0);
	GLfloat y1 = args.GetFloat(1);
	GLfloat x2 = args.GetFloat(2);
	GLfloat y2 = args.GetFloat(3);
	glRectf(x1, y1, x2, y2);
	return Value::Null;
}

// opengl.glRectfv
Gura_DeclareFunctionAlias(__glRectfv, "glRectfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectfv)
{
	Array<float> *_v1 = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v1 = reinterpret_cast<GLfloat *>(_v1->GetPointer());
	if (_v1->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	Array<float> *_v2 = Object_array<float>::GetObject(args, 1)->GetArray();
	GLfloat *v2 = reinterpret_cast<GLfloat *>(_v2->GetPointer());
	if (_v2->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRectfv(v1, v2);
	return Value::Null;
}

// opengl.glRecti
Gura_DeclareFunctionAlias(__glRecti, "glRecti")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRecti)
{
	GLint x1 = args.GetInt(0);
	GLint y1 = args.GetInt(1);
	GLint x2 = args.GetInt(2);
	GLint y2 = args.GetInt(3);
	glRecti(x1, y1, x2, y2);
	return Value::Null;
}

// opengl.glRectiv
Gura_DeclareFunctionAlias(__glRectiv, "glRectiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectiv)
{
	Array<int> *_v1 = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v1 = reinterpret_cast<GLint *>(_v1->GetPointer());
	if (_v1->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	Array<int> *_v2 = Object_array<int>::GetObject(args, 1)->GetArray();
	GLint *v2 = reinterpret_cast<GLint *>(_v2->GetPointer());
	if (_v2->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRectiv(v1, v2);
	return Value::Null;
}

// opengl.glRects
Gura_DeclareFunctionAlias(__glRects, "glRects")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y1", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x2", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y2", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRects)
{
	GLshort x1 = args.GetShort(0);
	GLshort y1 = args.GetShort(1);
	GLshort x2 = args.GetShort(2);
	GLshort y2 = args.GetShort(3);
	glRects(x1, y1, x2, y2);
	return Value::Null;
}

// opengl.glRectsv
Gura_DeclareFunctionAlias(__glRectsv, "glRectsv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v1", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "v2", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRectsv)
{
	Array<short> *_v1 = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v1 = reinterpret_cast<GLshort *>(_v1->GetPointer());
	if (_v1->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	Array<short> *_v2 = Object_array<short>::GetObject(args, 1)->GetArray();
	GLshort *v2 = reinterpret_cast<GLshort *>(_v2->GetPointer());
	if (_v2->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glRectsv(v1, v2);
	return Value::Null;
}

// opengl.glRenderMode
Gura_DeclareFunctionAlias(__glRenderMode, "glRenderMode")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRenderMode)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	GLint _rtn = glRenderMode(mode);
	return ReturnValue(env, sig, args, Value(_rtn));
}

// opengl.glRotated
Gura_DeclareFunctionAlias(__glRotated, "glRotated")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "angle", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRotated)
{
	GLdouble angle = args.GetDouble(0);
	GLdouble x = args.GetDouble(1);
	GLdouble y = args.GetDouble(2);
	GLdouble z = args.GetDouble(3);
	glRotated(angle, x, y, z);
	return Value::Null;
}

// opengl.glRotatef
Gura_DeclareFunctionAlias(__glRotatef, "glRotatef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "angle", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glRotatef)
{
	GLfloat angle = args.GetFloat(0);
	GLfloat x = args.GetFloat(1);
	GLfloat y = args.GetFloat(2);
	GLfloat z = args.GetFloat(3);
	glRotatef(angle, x, y, z);
	return Value::Null;
}

// opengl.glScaled
Gura_DeclareFunctionAlias(__glScaled, "glScaled")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glScaled)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	glScaled(x, y, z);
	return Value::Null;
}

// opengl.glScalef
Gura_DeclareFunctionAlias(__glScalef, "glScalef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glScalef)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	glScalef(x, y, z);
	return Value::Null;
}

// opengl.glScissor
Gura_DeclareFunctionAlias(__glScissor, "glScissor")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glScissor)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLsizei width = args.GetInt(2);
	GLsizei height = args.GetInt(3);
	glScissor(x, y, width, height);
	return Value::Null;
}

// opengl.glSelectBuffer
Gura_DeclareFunctionAlias(__glSelectBuffer, "glSelectBuffer")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_None);
	DeclareArg(env, "buffer", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap | FLAG_Nil);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glSelectBuffer)
{
	Array<UInt> *buffer = args.IsValid(0)? Object_array<UInt>::GetObject(args, 0)->GetArray() : NULL;
	if (buffer == NULL) {
		glSelectBuffer(0, NULL);
	} else {
		glSelectBuffer(buffer->GetSize(), buffer->GetPointer());
	}
	return Value::Null;
}

// opengl.glShadeModel
Gura_DeclareFunctionAlias(__glShadeModel, "glShadeModel")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mode", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glShadeModel)
{
	GLenum mode = static_cast<GLenum>(args.GetInt(0));
	glShadeModel(mode);
	return Value::Null;
}

// opengl.glStencilFunc
Gura_DeclareFunctionAlias(__glStencilFunc, "glStencilFunc")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "func", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "ref", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glStencilFunc)
{
	GLenum func = static_cast<GLenum>(args.GetInt(0));
	GLint ref = args.GetInt(1);
	GLuint mask = args.GetUInt(2);
	glStencilFunc(func, ref, mask);
	return Value::Null;
}

// opengl.glStencilMask
Gura_DeclareFunctionAlias(__glStencilMask, "glStencilMask")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "mask", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glStencilMask)
{
	GLuint mask = args.GetUInt(0);
	glStencilMask(mask);
	return Value::Null;
}

// opengl.glStencilOp
Gura_DeclareFunctionAlias(__glStencilOp, "glStencilOp")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "fail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zfail", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "zpass", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glStencilOp)
{
	GLenum fail = static_cast<GLenum>(args.GetInt(0));
	GLenum zfail = static_cast<GLenum>(args.GetInt(1));
	GLenum zpass = static_cast<GLenum>(args.GetInt(2));
	glStencilOp(fail, zfail, zpass);
	return Value::Null;
}

// opengl.glTexCoord1d
Gura_DeclareFunctionAlias(__glTexCoord1d, "glTexCoord1d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1d)
{
	GLdouble s = args.GetDouble(0);
	glTexCoord1d(s);
	return Value::Null;
}

// opengl.glTexCoord1dv
Gura_DeclareFunctionAlias(__glTexCoord1dv, "glTexCoord1dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glTexCoord1dv(v);
	return Value::Null;
}

// opengl.glTexCoord1f
Gura_DeclareFunctionAlias(__glTexCoord1f, "glTexCoord1f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1f)
{
	GLfloat s = args.GetFloat(0);
	glTexCoord1f(s);
	return Value::Null;
}

// opengl.glTexCoord1fv
Gura_DeclareFunctionAlias(__glTexCoord1fv, "glTexCoord1fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glTexCoord1fv(v);
	return Value::Null;
}

// opengl.glTexCoord1i
Gura_DeclareFunctionAlias(__glTexCoord1i, "glTexCoord1i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1i)
{
	GLint s = args.GetInt(0);
	glTexCoord1i(s);
	return Value::Null;
}

// opengl.glTexCoord1iv
Gura_DeclareFunctionAlias(__glTexCoord1iv, "glTexCoord1iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glTexCoord1iv(v);
	return Value::Null;
}

// opengl.glTexCoord1s
Gura_DeclareFunctionAlias(__glTexCoord1s, "glTexCoord1s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1s)
{
	GLshort s = args.GetShort(0);
	glTexCoord1s(s);
	return Value::Null;
}

// opengl.glTexCoord1sv
Gura_DeclareFunctionAlias(__glTexCoord1sv, "glTexCoord1sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord1sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 1) {
		sig.SetError(ERR_ValueError, "the list must have one element");
		return Value::Null;
	}
	glTexCoord1sv(v);
	return Value::Null;
}

// opengl.glTexCoord2d
Gura_DeclareFunctionAlias(__glTexCoord2d, "glTexCoord2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2d)
{
	GLdouble s = args.GetDouble(0);
	GLdouble t = args.GetDouble(1);
	glTexCoord2d(s, t);
	return Value::Null;
}

// opengl.glTexCoord2dv
Gura_DeclareFunctionAlias(__glTexCoord2dv, "glTexCoord2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glTexCoord2dv(v);
	return Value::Null;
}

// opengl.glTexCoord2f
Gura_DeclareFunctionAlias(__glTexCoord2f, "glTexCoord2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2f)
{
	GLfloat s = args.GetFloat(0);
	GLfloat t = args.GetFloat(1);
	glTexCoord2f(s, t);
	return Value::Null;
}

// opengl.glTexCoord2fv
Gura_DeclareFunctionAlias(__glTexCoord2fv, "glTexCoord2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glTexCoord2fv(v);
	return Value::Null;
}

// opengl.glTexCoord2i
Gura_DeclareFunctionAlias(__glTexCoord2i, "glTexCoord2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2i)
{
	GLint s = args.GetInt(0);
	GLint t = args.GetInt(1);
	glTexCoord2i(s, t);
	return Value::Null;
}

// opengl.glTexCoord2iv
Gura_DeclareFunctionAlias(__glTexCoord2iv, "glTexCoord2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glTexCoord2iv(v);
	return Value::Null;
}

// opengl.glTexCoord2s
Gura_DeclareFunctionAlias(__glTexCoord2s, "glTexCoord2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2s)
{
	GLshort s = args.GetShort(0);
	GLshort t = args.GetShort(1);
	glTexCoord2s(s, t);
	return Value::Null;
}

// opengl.glTexCoord2sv
Gura_DeclareFunctionAlias(__glTexCoord2sv, "glTexCoord2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord2sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glTexCoord2sv(v);
	return Value::Null;
}

// opengl.glTexCoord3d
Gura_DeclareFunctionAlias(__glTexCoord3d, "glTexCoord3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3d)
{
	GLdouble s = args.GetDouble(0);
	GLdouble t = args.GetDouble(1);
	GLdouble r = args.GetDouble(2);
	glTexCoord3d(s, t, r);
	return Value::Null;
}

// opengl.glTexCoord3dv
Gura_DeclareFunctionAlias(__glTexCoord3dv, "glTexCoord3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord3dv(v);
	return Value::Null;
}

// opengl.glTexCoord3f
Gura_DeclareFunctionAlias(__glTexCoord3f, "glTexCoord3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3f)
{
	GLfloat s = args.GetFloat(0);
	GLfloat t = args.GetFloat(1);
	GLfloat r = args.GetFloat(2);
	glTexCoord3f(s, t, r);
	return Value::Null;
}

// opengl.glTexCoord3fv
Gura_DeclareFunctionAlias(__glTexCoord3fv, "glTexCoord3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord3fv(v);
	return Value::Null;
}

// opengl.glTexCoord3i
Gura_DeclareFunctionAlias(__glTexCoord3i, "glTexCoord3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3i)
{
	GLint s = args.GetInt(0);
	GLint t = args.GetInt(1);
	GLint r = args.GetInt(2);
	glTexCoord3i(s, t, r);
	return Value::Null;
}

// opengl.glTexCoord3iv
Gura_DeclareFunctionAlias(__glTexCoord3iv, "glTexCoord3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord3iv(v);
	return Value::Null;
}

// opengl.glTexCoord3s
Gura_DeclareFunctionAlias(__glTexCoord3s, "glTexCoord3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3s)
{
	GLshort s = args.GetShort(0);
	GLshort t = args.GetShort(1);
	GLshort r = args.GetShort(2);
	glTexCoord3s(s, t, r);
	return Value::Null;
}

// opengl.glTexCoord3sv
Gura_DeclareFunctionAlias(__glTexCoord3sv, "glTexCoord3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord3sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord3sv(v);
	return Value::Null;
}

// opengl.glTexCoord4d
Gura_DeclareFunctionAlias(__glTexCoord4d, "glTexCoord4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4d)
{
	GLdouble s = args.GetDouble(0);
	GLdouble t = args.GetDouble(1);
	GLdouble r = args.GetDouble(2);
	GLdouble q = args.GetDouble(3);
	glTexCoord4d(s, t, r, q);
	return Value::Null;
}

// opengl.glTexCoord4dv
Gura_DeclareFunctionAlias(__glTexCoord4dv, "glTexCoord4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glTexCoord4dv(v);
	return Value::Null;
}

// opengl.glTexCoord4f
Gura_DeclareFunctionAlias(__glTexCoord4f, "glTexCoord4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4f)
{
	GLfloat s = args.GetFloat(0);
	GLfloat t = args.GetFloat(1);
	GLfloat r = args.GetFloat(2);
	GLfloat q = args.GetFloat(3);
	glTexCoord4f(s, t, r, q);
	return Value::Null;
}

// opengl.glTexCoord4fv
Gura_DeclareFunctionAlias(__glTexCoord4fv, "glTexCoord4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glTexCoord4fv(v);
	return Value::Null;
}

// opengl.glTexCoord4i
Gura_DeclareFunctionAlias(__glTexCoord4i, "glTexCoord4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4i)
{
	GLint s = args.GetInt(0);
	GLint t = args.GetInt(1);
	GLint r = args.GetInt(2);
	GLint q = args.GetInt(3);
	glTexCoord4i(s, t, r, q);
	return Value::Null;
}

// opengl.glTexCoord4iv
Gura_DeclareFunctionAlias(__glTexCoord4iv, "glTexCoord4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord4iv(v);
	return Value::Null;
}

// opengl.glTexCoord4s
Gura_DeclareFunctionAlias(__glTexCoord4s, "glTexCoord4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "s", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "t", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "r", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "q", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4s)
{
	GLshort s = args.GetShort(0);
	GLshort t = args.GetShort(1);
	GLshort r = args.GetShort(2);
	GLshort q = args.GetShort(3);
	glTexCoord4s(s, t, r, q);
	return Value::Null;
}

// opengl.glTexCoord4sv
Gura_DeclareFunctionAlias(__glTexCoord4sv, "glTexCoord4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexCoord4sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glTexCoord4sv(v);
	return Value::Null;
}

// opengl.glTexEnvf
Gura_DeclareFunctionAlias(__glTexEnvf, "glTexEnvf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexEnvf)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLfloat param = args.GetFloat(2);
	glTexEnvf(target, pname, param);
	return Value::Null;
}

// opengl.glTexEnvfv
Gura_DeclareFunctionAlias(__glTexEnvfv, "glTexEnvfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexEnvfv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexEnvfv(target, pname, params);
	return Value::Null;
}

// opengl.glTexEnvi
Gura_DeclareFunctionAlias(__glTexEnvi, "glTexEnvi")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexEnvi)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLint param = args.GetInt(2);
	glTexEnvi(target, pname, param);
	return Value::Null;
}

// opengl.glTexEnviv
Gura_DeclareFunctionAlias(__glTexEnviv, "glTexEnviv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexEnviv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexEnviv(target, pname, params);
	return Value::Null;
}

// opengl.glTexGend
Gura_DeclareFunctionAlias(__glTexGend, "glTexGend")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGend)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLdouble param = args.GetDouble(2);
	glTexGend(coord, pname, param);
	return Value::Null;
}

// opengl.glTexGendv
Gura_DeclareFunctionAlias(__glTexGendv, "glTexGendv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGendv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<double> *_params = Object_array<double>::GetObject(args, 2)->GetArray();
	GLdouble *params = reinterpret_cast<GLdouble *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexGendv(coord, pname, params);
	return Value::Null;
}

// opengl.glTexGenf
Gura_DeclareFunctionAlias(__glTexGenf, "glTexGenf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGenf)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLfloat param = args.GetFloat(2);
	glTexGenf(coord, pname, param);
	return Value::Null;
}

// opengl.glTexGenfv
Gura_DeclareFunctionAlias(__glTexGenfv, "glTexGenfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGenfv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexGenfv(coord, pname, params);
	return Value::Null;
}

// opengl.glTexGeni
Gura_DeclareFunctionAlias(__glTexGeni, "glTexGeni")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGeni)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLint param = args.GetInt(2);
	glTexGeni(coord, pname, param);
	return Value::Null;
}

// opengl.glTexGeniv
Gura_DeclareFunctionAlias(__glTexGeniv, "glTexGeniv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "coord", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexGeniv)
{
	GLenum coord = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexGeniv(coord, pname, params);
	return Value::Null;
}

// opengl.glTexImage1D
Gura_DeclareFunctionAlias(__glTexImage1D, "glTexImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexImage1D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint internalformat = args.GetInt(2);
	GLsizei width = args.GetInt(3);
	GLint border = args.GetInt(4);
	GLenum format = static_cast<GLenum>(args.GetInt(5));
	GLenum type = static_cast<GLenum>(args.GetInt(6));
	Value pixels = args.GetValue(7);
	// check pixels->size()
	const void *p = GetArrayPointer(sig, type, pixels);
	if (p == NULL) return Value::Null;
	glTexImage1D(target, level, internalformat, width, border, format, type, p);
	return Value::Null;
}

// opengl.glTexImage1DFromImage
Gura_DeclareFunctionAlias(__glTexImage1DFromImage, "glTexImage1DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexImage1DFromImage)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint internalformat = args.GetInt(2);
	GLint border = args.GetInt(3);
	Image *image = Object_image::GetObject(args, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth()) + border * 2;
	GLenum format = GetImageFormat(sig, image);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
	return Value::Null;
}

// opengl.glTexImage2D
Gura_DeclareFunctionAlias(__glTexImage2D, "glTexImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexImage2D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint internalformat = args.GetInt(2);
	GLsizei width = args.GetInt(3);
	GLsizei height = args.GetInt(4);
	GLint border = args.GetInt(5);
	GLenum format = static_cast<GLenum>(args.GetInt(6));
	GLenum type = static_cast<GLenum>(args.GetInt(7));
	Value pixels = args.GetValue(8);
	// check pixels->size()
	const void *p = GetArrayPointer(sig, type, pixels);
	if (p == NULL) return Value::Null;
	glTexImage2D(target, level, internalformat, width, height, border, format, type, p);
	return Value::Null;
}

// opengl.glTexImage2DFromImage
Gura_DeclareFunctionAlias(__glTexImage2DFromImage, "glTexImage2DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "internalformat", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "border", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexImage2DFromImage)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint internalformat = args.GetInt(2);
	GLint border = args.GetInt(3);
	Image *image = Object_image::GetObject(args, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth()) + border * 2;
	GLsizei height = static_cast<GLsizei>(image->GetHeight()) + border * 2;
	GLenum format = GetImageFormat(sig, image);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
	return Value::Null;
}

// opengl.glTexParameterf
Gura_DeclareFunctionAlias(__glTexParameterf, "glTexParameterf")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexParameterf)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLfloat param = args.GetFloat(2);
	glTexParameterf(target, pname, param);
	return Value::Null;
}

// opengl.glTexParameterfv
Gura_DeclareFunctionAlias(__glTexParameterfv, "glTexParameterfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexParameterfv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexParameterfv(target, pname, params);
	return Value::Null;
}

// opengl.glTexParameteri
Gura_DeclareFunctionAlias(__glTexParameteri, "glTexParameteri")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "param", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexParameteri)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	GLint param = args.GetInt(2);
	glTexParameteri(target, pname, param);
	return Value::Null;
}

// opengl.glTexParameteriv
Gura_DeclareFunctionAlias(__glTexParameteriv, "glTexParameteriv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pname", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexParameteriv)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLenum pname = static_cast<GLenum>(args.GetInt(1));
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	if (!CheckParamCount(pname, _params->GetSize())) {
		sig.SetError(ERR_ValueError,
				"the list must have %d elements", GetParamCount(pname));
		return Value::Null;
	}
	glTexParameteriv(target, pname, params);
	return Value::Null;
}

// opengl.glTexSubImage1D
Gura_DeclareFunctionAlias(__glTexSubImage1D, "glTexSubImage1D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexSubImage1D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	GLsizei width = args.GetInt(3);
	GLenum format = static_cast<GLenum>(args.GetInt(4));
	GLenum type = static_cast<GLenum>(args.GetInt(5));
	Value pixels = args.GetValue(6);
	// check pixels->size()
	const void *p = GetArrayPointer(sig, type, pixels);
	if (p == NULL) return Value::Null;
	glTexSubImage1D(target, level, xoffset, width, format, type, p);
	return Value::Null;
}

// opengl.glTexSubImage1DFromImage
Gura_DeclareFunctionAlias(__glTexSubImage1DFromImage, "glTexSubImage1DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexSubImage1DFromImage)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	Image *image = Object_image::GetObject(args, 3)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLenum format = GetImageFormat(sig, image);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
	return Value::Null;
}

// opengl.glTexSubImage2D
Gura_DeclareFunctionAlias(__glTexSubImage2D, "glTexSubImage2D")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "format", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "pixels", VTYPE_any, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexSubImage2D)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	GLint yoffset = args.GetInt(3);
	GLsizei width = args.GetInt(4);
	GLsizei height = args.GetInt(5);
	GLenum format = static_cast<GLenum>(args.GetInt(6));
	GLenum type = static_cast<GLenum>(args.GetInt(7));
	Value pixels = args.GetValue(8);
	// check pixels->size()
	const void *p = GetArrayPointer(sig, type, pixels);
	if (p == NULL) return Value::Null;
	glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, p);
	return Value::Null;
}

// opengl.glTexSubImage2DFromImage
Gura_DeclareFunctionAlias(__glTexSubImage2DFromImage, "glTexSubImage2DFromImage")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "target", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "level", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "xoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "yoffset", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "image", VTYPE_image, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTexSubImage2DFromImage)
{
	GLenum target = static_cast<GLenum>(args.GetInt(0));
	GLint level = args.GetInt(1);
	GLint xoffset = args.GetInt(2);
	GLint yoffset = args.GetInt(3);
	Image *image = Object_image::GetObject(args, 4)->GetImage();
	GLsizei width = static_cast<GLsizei>(image->GetWidth());
	GLsizei height = static_cast<GLsizei>(image->GetHeight());
	GLenum format = GetImageFormat(sig, image);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = reinterpret_cast<const GLvoid *>(image->GetBuffer());
	glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
	return Value::Null;
}

// opengl.glTranslated
Gura_DeclareFunctionAlias(__glTranslated, "glTranslated")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTranslated)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	glTranslated(x, y, z);
	return Value::Null;
}

// opengl.glTranslatef
Gura_DeclareFunctionAlias(__glTranslatef, "glTranslatef")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glTranslatef)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	glTranslatef(x, y, z);
	return Value::Null;
}

// opengl.glVertex2d
Gura_DeclareFunctionAlias(__glVertex2d, "glVertex2d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	glVertex2d(x, y);
	return Value::Null;
}

// opengl.glVertex2dv
Gura_DeclareFunctionAlias(__glVertex2dv, "glVertex2dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glVertex2dv(v);
	return Value::Null;
}

// opengl.glVertex2f
Gura_DeclareFunctionAlias(__glVertex2f, "glVertex2f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	glVertex2f(x, y);
	return Value::Null;
}

// opengl.glVertex2fv
Gura_DeclareFunctionAlias(__glVertex2fv, "glVertex2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glVertex2fv(v);
	return Value::Null;
}

// opengl.glVertex2i
Gura_DeclareFunctionAlias(__glVertex2i, "glVertex2i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	glVertex2i(x, y);
	return Value::Null;
}

// opengl.glVertex2iv
Gura_DeclareFunctionAlias(__glVertex2iv, "glVertex2iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glVertex2iv(v);
	return Value::Null;
}

// opengl.glVertex2s
Gura_DeclareFunctionAlias(__glVertex2s, "glVertex2s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	glVertex2s(x, y);
	return Value::Null;
}

// opengl.glVertex2sv
Gura_DeclareFunctionAlias(__glVertex2sv, "glVertex2sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex2sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 2) {
		sig.SetError(ERR_ValueError, "the list must have two elements");
		return Value::Null;
	}
	glVertex2sv(v);
	return Value::Null;
}

// opengl.glVertex3d
Gura_DeclareFunctionAlias(__glVertex3d, "glVertex3d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	glVertex3d(x, y, z);
	return Value::Null;
}

// opengl.glVertex3dv
Gura_DeclareFunctionAlias(__glVertex3dv, "glVertex3dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex3dv(v);
	return Value::Null;
}

// opengl.glVertex3f
Gura_DeclareFunctionAlias(__glVertex3f, "glVertex3f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	glVertex3f(x, y, z);
	return Value::Null;
}

// opengl.glVertex3fv
Gura_DeclareFunctionAlias(__glVertex3fv, "glVertex3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex3fv(v);
	return Value::Null;
}

// opengl.glVertex3i
Gura_DeclareFunctionAlias(__glVertex3i, "glVertex3i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLint z = args.GetInt(2);
	glVertex3i(x, y, z);
	return Value::Null;
}

// opengl.glVertex3iv
Gura_DeclareFunctionAlias(__glVertex3iv, "glVertex3iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex3iv(v);
	return Value::Null;
}

// opengl.glVertex3s
Gura_DeclareFunctionAlias(__glVertex3s, "glVertex3s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	GLshort z = args.GetShort(2);
	glVertex3s(x, y, z);
	return Value::Null;
}

// opengl.glVertex3sv
Gura_DeclareFunctionAlias(__glVertex3sv, "glVertex3sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex3sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 3) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex3sv(v);
	return Value::Null;
}

// opengl.glVertex4d
Gura_DeclareFunctionAlias(__glVertex4d, "glVertex4d")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4d)
{
	GLdouble x = args.GetDouble(0);
	GLdouble y = args.GetDouble(1);
	GLdouble z = args.GetDouble(2);
	GLdouble w = args.GetDouble(3);
	glVertex4d(x, y, z, w);
	return Value::Null;
}

// opengl.glVertex4dv
Gura_DeclareFunctionAlias(__glVertex4dv, "glVertex4dv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_double, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4dv)
{
	Array<double> *_v = Object_array<double>::GetObject(args, 0)->GetArray();
	GLdouble *v = reinterpret_cast<GLdouble *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glVertex4dv(v);
	return Value::Null;
}

// opengl.glVertex4f
Gura_DeclareFunctionAlias(__glVertex4f, "glVertex4f")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4f)
{
	GLfloat x = args.GetFloat(0);
	GLfloat y = args.GetFloat(1);
	GLfloat z = args.GetFloat(2);
	GLfloat w = args.GetFloat(3);
	glVertex4f(x, y, z, w);
	return Value::Null;
}

// opengl.glVertex4fv
Gura_DeclareFunctionAlias(__glVertex4fv, "glVertex4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4fv)
{
	Array<float> *_v = Object_array<float>::GetObject(args, 0)->GetArray();
	GLfloat *v = reinterpret_cast<GLfloat *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have four elements");
		return Value::Null;
	}
	glVertex4fv(v);
	return Value::Null;
}

// opengl.glVertex4i
Gura_DeclareFunctionAlias(__glVertex4i, "glVertex4i")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4i)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLint z = args.GetInt(2);
	GLint w = args.GetInt(3);
	glVertex4i(x, y, z, w);
	return Value::Null;
}

// opengl.glVertex4iv
Gura_DeclareFunctionAlias(__glVertex4iv, "glVertex4iv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4iv)
{
	Array<int> *_v = Object_array<int>::GetObject(args, 0)->GetArray();
	GLint *v = reinterpret_cast<GLint *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex4iv(v);
	return Value::Null;
}

// opengl.glVertex4s
Gura_DeclareFunctionAlias(__glVertex4s, "glVertex4s")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "z", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "w", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4s)
{
	GLshort x = args.GetShort(0);
	GLshort y = args.GetShort(1);
	GLshort z = args.GetShort(2);
	GLshort w = args.GetShort(3);
	glVertex4s(x, y, z, w);
	return Value::Null;
}

// opengl.glVertex4sv
Gura_DeclareFunctionAlias(__glVertex4sv, "glVertex4sv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "v", VTYPE_array_short, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glVertex4sv)
{
	Array<short> *_v = Object_array<short>::GetObject(args, 0)->GetArray();
	GLshort *v = reinterpret_cast<GLshort *>(_v->GetPointer());
	if (_v->GetSize() != 4) {
		sig.SetError(ERR_ValueError, "the list must have three elements");
		return Value::Null;
	}
	glVertex4sv(v);
	return Value::Null;
}

// opengl.glViewport
Gura_DeclareFunctionAlias(__glViewport, "glViewport")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "x", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "y", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "width", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "height", VTYPE_number, OCCUR_Once, FLAG_None);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glViewport)
{
	GLint x = args.GetInt(0);
	GLint y = args.GetInt(1);
	GLsizei width = args.GetInt(2);
	GLsizei height = args.GetInt(3);
	glViewport(x, y, width, height);
	return Value::Null;
}

// opengl.glGetAttachedShaders
Gura_DeclareFunctionAlias(__glGetAttachedShaders, "glGetAttachedShaders")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "maxCount", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "shaders", VTYPE_array_uint, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetAttachedShaders)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLsizei maxCount = args.GetInt(1);
	AutoPtr<Array<GLsizei> > _count(CreateArrayFromList<GLsizei>(args.GetList(2)));
	GLsizei *count = _count->GetPointer();
	Array<UInt> *_shaders = Object_array<UInt>::GetObject(args, 3)->GetArray();
	GLuint *shaders = reinterpret_cast<GLuint *>(_shaders->GetPointer());
	glGetAttachedShaders(program, maxCount, count, shaders);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetAttachedShaders");
	return Value::Null;
}

// opengl.glGetShaderInfoLog
Gura_DeclareFunctionAlias(__glGetShaderInfoLog, "glGetShaderInfoLog")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bufSize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "length", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "infoLog", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetShaderInfoLog)
{
#if 0
	GLuint shader = args.GetUInt(0);
	GLsizei bufSize = args.GetInt(1);
	AutoPtr<Array<GLsizei> > _length(CreateArrayFromList<GLsizei>(args.GetList(2)));
	GLsizei *length = _length->GetPointer();
	Array<char> *_infoLog = Object_array<char>::GetObject(args, 3)->GetArray();
	GLchar *infoLog = reinterpret_cast<GLchar *>(_infoLog->GetPointer());
	glGetShaderInfoLog(shader, bufSize, length, infoLog);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetShaderInfoLog");
	return Value::Null;
}

// opengl.glGetProgramInfoLog
Gura_DeclareFunctionAlias(__glGetProgramInfoLog, "glGetProgramInfoLog")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bufSize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "length", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "infoLog", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetProgramInfoLog)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLsizei bufSize = args.GetInt(1);
	AutoPtr<Array<GLsizei> > _length(CreateArrayFromList<GLsizei>(args.GetList(2)));
	GLsizei *length = _length->GetPointer();
	Array<char> *_infoLog = Object_array<char>::GetObject(args, 3)->GetArray();
	GLchar *infoLog = reinterpret_cast<GLchar *>(_infoLog->GetPointer());
	glGetProgramInfoLog(program, bufSize, length, infoLog);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetProgramInfoLog");
	return Value::Null;
}

// opengl.glGetUniformLocation
Gura_DeclareFunctionAlias(__glGetUniformLocation, "glGetUniformLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetUniformLocation)
{
#if 0
	GLuint program = args.GetUInt(0);
	Array<char> *_name = Object_array<char>::GetObject(args, 1)->GetArray();
	GLchar *name = reinterpret_cast<GLchar *>(_name->GetPointer());
	GLint _rtn = glGetUniformLocation(program, name);
	return ReturnValue(env, sig, args, Value(_rtn));
#endif
	SetError_NotImpFunction(sig, "glGetUniformLocation");
	return Value::Null;
}

// opengl.glGetActiveUniform
Gura_DeclareFunctionAlias(__glGetActiveUniform, "glGetActiveUniform")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bufSize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "length", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "size", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "name", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetActiveUniform)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLuint index = args.GetUInt(1);
	GLsizei bufSize = args.GetInt(2);
	AutoPtr<Array<GLsizei> > _length(CreateArrayFromList<GLsizei>(args.GetList(3)));
	GLsizei *length = _length->GetPointer();
	Array<int> *_size = Object_array<int>::GetObject(args, 4)->GetArray();
	GLint *size = reinterpret_cast<GLint *>(_size->GetPointer());
	AutoPtr<Array<GLenum> > _type(CreateArrayFromList<GLenum>(args.GetList(5)));
	GLenum *type = _type->GetPointer();
	Array<char> *_name = Object_array<char>::GetObject(args, 6)->GetArray();
	GLchar *name = reinterpret_cast<GLchar *>(_name->GetPointer());
	glGetActiveUniform(program, index, bufSize, length, size, type, name);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetActiveUniform");
	return Value::Null;
}

// opengl.glGetUniformfv
Gura_DeclareFunctionAlias(__glGetUniformfv, "glGetUniformfv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetUniformfv)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLint location = args.GetInt(1);
	Array<float> *_params = Object_array<float>::GetObject(args, 2)->GetArray();
	GLfloat *params = reinterpret_cast<GLfloat *>(_params->GetPointer());
	glGetUniformfv(program, location, params);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetUniformfv");
	return Value::Null;
}

// opengl.glGetUniformiv
Gura_DeclareFunctionAlias(__glGetUniformiv, "glGetUniformiv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "params", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetUniformiv)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLint location = args.GetInt(1);
	Array<int> *_params = Object_array<int>::GetObject(args, 2)->GetArray();
	GLint *params = reinterpret_cast<GLint *>(_params->GetPointer());
	glGetUniformiv(program, location, params);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetUniformiv");
	return Value::Null;
}

// opengl.glGetShaderSource
Gura_DeclareFunctionAlias(__glGetShaderSource, "glGetShaderSource")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "shader", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bufSize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "length", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "source", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetShaderSource)
{
#if 0
	GLuint shader = args.GetUInt(0);
	GLsizei bufSize = args.GetInt(1);
	AutoPtr<Array<GLsizei> > _length(CreateArrayFromList<GLsizei>(args.GetList(2)));
	GLsizei *length = _length->GetPointer();
	Array<char> *_source = Object_array<char>::GetObject(args, 3)->GetArray();
	GLchar *source = reinterpret_cast<GLchar *>(_source->GetPointer());
	glGetShaderSource(shader, bufSize, length, source);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetShaderSource");
	return Value::Null;
}

// opengl.glBindAttribLocation
Gura_DeclareFunctionAlias(__glBindAttribLocation, "glBindAttribLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glBindAttribLocation)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLuint index = args.GetUInt(1);
	Array<char> *_name = Object_array<char>::GetObject(args, 2)->GetArray();
	GLchar *name = reinterpret_cast<GLchar *>(_name->GetPointer());
	glBindAttribLocation(program, index, name);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glBindAttribLocation");
	return Value::Null;
}

// opengl.glGetActiveAttrib
Gura_DeclareFunctionAlias(__glGetActiveAttrib, "glGetActiveAttrib")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "index", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "bufSize", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "length", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "size", VTYPE_array_int, OCCUR_Once, FLAG_NoMap);
	DeclareArg(env, "type", VTYPE_number, OCCUR_Once, FLAG_List);
	DeclareArg(env, "name", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetActiveAttrib)
{
#if 0
	GLuint program = args.GetUInt(0);
	GLuint index = args.GetUInt(1);
	GLsizei bufSize = args.GetInt(2);
	AutoPtr<Array<GLsizei> > _length(CreateArrayFromList<GLsizei>(args.GetList(3)));
	GLsizei *length = _length->GetPointer();
	Array<int> *_size = Object_array<int>::GetObject(args, 4)->GetArray();
	GLint *size = reinterpret_cast<GLint *>(_size->GetPointer());
	AutoPtr<Array<GLenum> > _type(CreateArrayFromList<GLenum>(args.GetList(5)));
	GLenum *type = _type->GetPointer();
	Array<char> *_name = Object_array<char>::GetObject(args, 6)->GetArray();
	GLchar *name = reinterpret_cast<GLchar *>(_name->GetPointer());
	glGetActiveAttrib(program, index, bufSize, length, size, type, name);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glGetActiveAttrib");
	return Value::Null;
}

// opengl.glGetAttribLocation
Gura_DeclareFunctionAlias(__glGetAttribLocation, "glGetAttribLocation")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Normal, FLAG_Map);
	DeclareBlock(OCCUR_ZeroOrOnce);
	DeclareArg(env, "program", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "name", VTYPE_array_char, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glGetAttribLocation)
{
#if 0
	GLuint program = args.GetUInt(0);
	Array<char> *_name = Object_array<char>::GetObject(args, 1)->GetArray();
	GLchar *name = reinterpret_cast<GLchar *>(_name->GetPointer());
	GLint _rtn = glGetAttribLocation(program, name);
	return ReturnValue(env, sig, args, Value(_rtn));
#endif
	SetError_NotImpFunction(sig, "glGetAttribLocation");
	return Value::Null;
}

// opengl.glUniformMatrix2x3fv
Gura_DeclareFunctionAlias(__glUniformMatrix2x3fv, "glUniformMatrix2x3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix2x3fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix2x3fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix2x3fv");
	return Value::Null;
}

// opengl.glUniformMatrix3x2fv
Gura_DeclareFunctionAlias(__glUniformMatrix3x2fv, "glUniformMatrix3x2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix3x2fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix3x2fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix3x2fv");
	return Value::Null;
}

// opengl.glUniformMatrix2x4fv
Gura_DeclareFunctionAlias(__glUniformMatrix2x4fv, "glUniformMatrix2x4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix2x4fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix2x4fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix2x4fv");
	return Value::Null;
}

// opengl.glUniformMatrix4x2fv
Gura_DeclareFunctionAlias(__glUniformMatrix4x2fv, "glUniformMatrix4x2fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix4x2fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix4x2fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix4x2fv");
	return Value::Null;
}

// opengl.glUniformMatrix3x4fv
Gura_DeclareFunctionAlias(__glUniformMatrix3x4fv, "glUniformMatrix3x4fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix3x4fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix3x4fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix3x4fv");
	return Value::Null;
}

// opengl.glUniformMatrix4x3fv
Gura_DeclareFunctionAlias(__glUniformMatrix4x3fv, "glUniformMatrix4x3fv")
{
	SetFuncAttr(VTYPE_any, RSLTMODE_Void, FLAG_Map);
	DeclareArg(env, "location", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "count", VTYPE_number, OCCUR_Once, FLAG_None);
	DeclareArg(env, "transpose", VTYPE_boolean, OCCUR_Once, FLAG_None);
	DeclareArg(env, "value", VTYPE_array_float, OCCUR_Once, FLAG_NoMap);
	AddHelp(
		Gura_Symbol(en), Help::FMT_markdown,
		"");
}

Gura_ImplementFunction(__glUniformMatrix4x3fv)
{
#if 0
	GLint location = args.GetInt(0);
	GLsizei count = args.GetInt(1);
	GLboolean transpose = (args.GetBoolean(2)? GL_TRUE : GL_FALSE);
	Array<float> *_value = Object_array<float>::GetObject(args, 3)->GetArray();
	GLfloat *value = reinterpret_cast<GLfloat *>(_value->GetPointer());
	glUniformMatrix4x3fv(location, count, transpose, value);
	return Value::Null;
#endif
	SetError_NotImpFunction(sig, "glUniformMatrix4x3fv");
	return Value::Null;
}


void AssignFunctions(Environment &env)
{
	Gura_AssignFunction(__glAccum);
	Gura_AssignFunction(__glAlphaFunc);
	Gura_AssignFunction(__glAreTexturesResident);
	Gura_AssignFunction(__glArrayElement);
	Gura_AssignFunction(__glBegin);
	Gura_AssignFunction(__glBindTexture);
	Gura_AssignFunction(__glBitmap);
	Gura_AssignFunction(__glBlendFunc);
	Gura_AssignFunction(__glCallList);
	Gura_AssignFunction(__glCallLists);
	Gura_AssignFunction(__glClear);
	Gura_AssignFunction(__glClearAccum);
	Gura_AssignFunction(__glClearColor);
	Gura_AssignFunction(__glClearDepth);
	Gura_AssignFunction(__glClearIndex);
	Gura_AssignFunction(__glClearStencil);
	Gura_AssignFunction(__glClipPlane);
	Gura_AssignFunction(__glColor3b);
	Gura_AssignFunction(__glColor3bv);
	Gura_AssignFunction(__glColor3d);
	Gura_AssignFunction(__glColor3dv);
	Gura_AssignFunction(__glColor3f);
	Gura_AssignFunction(__glColor3fv);
	Gura_AssignFunction(__glColor3i);
	Gura_AssignFunction(__glColor3iv);
	Gura_AssignFunction(__glColor3s);
	Gura_AssignFunction(__glColor3sv);
	Gura_AssignFunction(__glColor3ub);
	Gura_AssignFunction(__glColor3ubv);
	Gura_AssignFunction(__glColor3ui);
	Gura_AssignFunction(__glColor3uiv);
	Gura_AssignFunction(__glColor3us);
	Gura_AssignFunction(__glColor3usv);
	Gura_AssignFunction(__glColor4b);
	Gura_AssignFunction(__glColor4bv);
	Gura_AssignFunction(__glColor4d);
	Gura_AssignFunction(__glColor4dv);
	Gura_AssignFunction(__glColor4f);
	Gura_AssignFunction(__glColor4fv);
	Gura_AssignFunction(__glColor4i);
	Gura_AssignFunction(__glColor4iv);
	Gura_AssignFunction(__glColor4s);
	Gura_AssignFunction(__glColor4sv);
	Gura_AssignFunction(__glColor4ub);
	Gura_AssignFunction(__glColor4ubv);
	Gura_AssignFunction(__glColor4ui);
	Gura_AssignFunction(__glColor4uiv);
	Gura_AssignFunction(__glColor4us);
	Gura_AssignFunction(__glColor4usv);
	Gura_AssignFunction(__glColorMask);
	Gura_AssignFunction(__glColorMaterial);
	Gura_AssignFunction(__glCopyPixels);
	Gura_AssignFunction(__glCopyTexImage1D);
	Gura_AssignFunction(__glCopyTexImage2D);
	Gura_AssignFunction(__glCopyTexSubImage1D);
	Gura_AssignFunction(__glCopyTexSubImage2D);
	Gura_AssignFunction(__glCullFace);
	Gura_AssignFunction(__glDeleteLists);
	Gura_AssignFunction(__glDeleteTextures);
	Gura_AssignFunction(__glDepthFunc);
	Gura_AssignFunction(__glDepthMask);
	Gura_AssignFunction(__glDepthRange);
	Gura_AssignFunction(__glDisable);
	Gura_AssignFunction(__glDisableClientState);
	Gura_AssignFunction(__glDrawArrays);
	Gura_AssignFunction(__glDrawBuffer);
	Gura_AssignFunction(__glDrawPixels);
	Gura_AssignFunction(__glDrawPixelsFromImage);
	Gura_AssignFunction(__glEdgeFlag);
	Gura_AssignFunction(__glEdgeFlagv);
	Gura_AssignFunction(__glEnable);
	Gura_AssignFunction(__glEnableClientState);
	Gura_AssignFunction(__glEnd);
	Gura_AssignFunction(__glEndList);
	Gura_AssignFunction(__glEvalCoord1d);
	Gura_AssignFunction(__glEvalCoord1dv);
	Gura_AssignFunction(__glEvalCoord1f);
	Gura_AssignFunction(__glEvalCoord1fv);
	Gura_AssignFunction(__glEvalCoord2d);
	Gura_AssignFunction(__glEvalCoord2dv);
	Gura_AssignFunction(__glEvalCoord2f);
	Gura_AssignFunction(__glEvalCoord2fv);
	Gura_AssignFunction(__glEvalMesh1);
	Gura_AssignFunction(__glEvalMesh2);
	Gura_AssignFunction(__glEvalPoint1);
	Gura_AssignFunction(__glEvalPoint2);
	Gura_AssignFunction(__glFeedbackBuffer);
	Gura_AssignFunction(__glFinish);
	Gura_AssignFunction(__glFlush);
	Gura_AssignFunction(__glFogf);
	Gura_AssignFunction(__glFogfv);
	Gura_AssignFunction(__glFogi);
	Gura_AssignFunction(__glFogiv);
	Gura_AssignFunction(__glFrontFace);
	Gura_AssignFunction(__glFrustum);
	Gura_AssignFunction(__glGenLists);
	Gura_AssignFunction(__glGenTextures);
	Gura_AssignFunction(__glGetBooleanv);
	Gura_AssignFunction(__glGetClipPlane);
	Gura_AssignFunction(__glGetDoublev);
	Gura_AssignFunction(__glGetError);
	Gura_AssignFunction(__glGetFloatv);
	Gura_AssignFunction(__glGetIntegerv);
	Gura_AssignFunction(__glGetLightfv);
	Gura_AssignFunction(__glGetLightiv);
	Gura_AssignFunction(__glGetMapdv);
	Gura_AssignFunction(__glGetMapfv);
	Gura_AssignFunction(__glGetMapiv);
	Gura_AssignFunction(__glGetMaterialfv);
	Gura_AssignFunction(__glGetMaterialiv);
	Gura_AssignFunction(__glGetPixelMapfv);
	Gura_AssignFunction(__glGetPixelMapuiv);
	Gura_AssignFunction(__glGetPixelMapusv);
	Gura_AssignFunction(__glGetPolygonStipple);
	Gura_AssignFunction(__glGetString);
	Gura_AssignFunction(__glGetTexEnvfv);
	Gura_AssignFunction(__glGetTexEnviv);
	Gura_AssignFunction(__glGetTexGendv);
	Gura_AssignFunction(__glGetTexGenfv);
	Gura_AssignFunction(__glGetTexGeniv);
	Gura_AssignFunction(__glGetTexLevelParameterfv);
	Gura_AssignFunction(__glGetTexLevelParameteriv);
	Gura_AssignFunction(__glGetTexParameterfv);
	Gura_AssignFunction(__glGetTexParameteriv);
	Gura_AssignFunction(__glHint);
	Gura_AssignFunction(__glIndexMask);
	Gura_AssignFunction(__glIndexd);
	Gura_AssignFunction(__glIndexdv);
	Gura_AssignFunction(__glIndexf);
	Gura_AssignFunction(__glIndexfv);
	Gura_AssignFunction(__glIndexi);
	Gura_AssignFunction(__glIndexiv);
	Gura_AssignFunction(__glIndexs);
	Gura_AssignFunction(__glIndexsv);
	Gura_AssignFunction(__glIndexub);
	Gura_AssignFunction(__glIndexubv);
	Gura_AssignFunction(__glInitNames);
	Gura_AssignFunction(__glIsEnabled);
	Gura_AssignFunction(__glIsList);
	Gura_AssignFunction(__glIsTexture);
	Gura_AssignFunction(__glLightModelf);
	Gura_AssignFunction(__glLightModelfv);
	Gura_AssignFunction(__glLightModeli);
	Gura_AssignFunction(__glLightModeliv);
	Gura_AssignFunction(__glLightf);
	Gura_AssignFunction(__glLightfv);
	Gura_AssignFunction(__glLighti);
	Gura_AssignFunction(__glLightiv);
	Gura_AssignFunction(__glLineStipple);
	Gura_AssignFunction(__glLineWidth);
	Gura_AssignFunction(__glListBase);
	Gura_AssignFunction(__glLoadIdentity);
	Gura_AssignFunction(__glLoadMatrixd);
	Gura_AssignFunction(__glLoadMatrixf);
	Gura_AssignFunction(__glLoadName);
	Gura_AssignFunction(__glLogicOp);
	Gura_AssignFunction(__glMap1d);
	Gura_AssignFunction(__glMap1f);
	Gura_AssignFunction(__glMap2d);
	Gura_AssignFunction(__glMap2f);
	Gura_AssignFunction(__glMapGrid1d);
	Gura_AssignFunction(__glMapGrid1f);
	Gura_AssignFunction(__glMapGrid2d);
	Gura_AssignFunction(__glMapGrid2f);
	Gura_AssignFunction(__glMaterialf);
	Gura_AssignFunction(__glMaterialfv);
	Gura_AssignFunction(__glMateriali);
	Gura_AssignFunction(__glMaterialiv);
	Gura_AssignFunction(__glMatrixMode);
	Gura_AssignFunction(__glMultMatrixd);
	Gura_AssignFunction(__glMultMatrixf);
	Gura_AssignFunction(__glNewList);
	Gura_AssignFunction(__glNormal3b);
	Gura_AssignFunction(__glNormal3bv);
	Gura_AssignFunction(__glNormal3d);
	Gura_AssignFunction(__glNormal3dv);
	Gura_AssignFunction(__glNormal3f);
	Gura_AssignFunction(__glNormal3fv);
	Gura_AssignFunction(__glNormal3i);
	Gura_AssignFunction(__glNormal3iv);
	Gura_AssignFunction(__glNormal3s);
	Gura_AssignFunction(__glNormal3sv);
	Gura_AssignFunction(__glOrtho);
	Gura_AssignFunction(__glPassThrough);
	Gura_AssignFunction(__glPixelMapfv);
	Gura_AssignFunction(__glPixelMapuiv);
	Gura_AssignFunction(__glPixelMapusv);
	Gura_AssignFunction(__glPixelStoref);
	Gura_AssignFunction(__glPixelStorei);
	Gura_AssignFunction(__glPixelTransferf);
	Gura_AssignFunction(__glPixelTransferi);
	Gura_AssignFunction(__glPixelZoom);
	Gura_AssignFunction(__glPointSize);
	Gura_AssignFunction(__glPolygonMode);
	Gura_AssignFunction(__glPolygonOffset);
	Gura_AssignFunction(__glPolygonStipple);
	Gura_AssignFunction(__glPopAttrib);
	Gura_AssignFunction(__glPopClientAttrib);
	Gura_AssignFunction(__glPopMatrix);
	Gura_AssignFunction(__glPopName);
	Gura_AssignFunction(__glPrioritizeTextures);
	Gura_AssignFunction(__glPushAttrib);
	Gura_AssignFunction(__glPushClientAttrib);
	Gura_AssignFunction(__glPushMatrix);
	Gura_AssignFunction(__glPushName);
	Gura_AssignFunction(__glRasterPos2d);
	Gura_AssignFunction(__glRasterPos2dv);
	Gura_AssignFunction(__glRasterPos2f);
	Gura_AssignFunction(__glRasterPos2fv);
	Gura_AssignFunction(__glRasterPos2i);
	Gura_AssignFunction(__glRasterPos2iv);
	Gura_AssignFunction(__glRasterPos2s);
	Gura_AssignFunction(__glRasterPos2sv);
	Gura_AssignFunction(__glRasterPos3d);
	Gura_AssignFunction(__glRasterPos3dv);
	Gura_AssignFunction(__glRasterPos3f);
	Gura_AssignFunction(__glRasterPos3fv);
	Gura_AssignFunction(__glRasterPos3i);
	Gura_AssignFunction(__glRasterPos3iv);
	Gura_AssignFunction(__glRasterPos3s);
	Gura_AssignFunction(__glRasterPos3sv);
	Gura_AssignFunction(__glRasterPos4d);
	Gura_AssignFunction(__glRasterPos4dv);
	Gura_AssignFunction(__glRasterPos4f);
	Gura_AssignFunction(__glRasterPos4fv);
	Gura_AssignFunction(__glRasterPos4i);
	Gura_AssignFunction(__glRasterPos4iv);
	Gura_AssignFunction(__glRasterPos4s);
	Gura_AssignFunction(__glRasterPos4sv);
	Gura_AssignFunction(__glReadBuffer);
	Gura_AssignFunction(__glReadPixels);
	Gura_AssignFunction(__glRectd);
	Gura_AssignFunction(__glRectdv);
	Gura_AssignFunction(__glRectf);
	Gura_AssignFunction(__glRectfv);
	Gura_AssignFunction(__glRecti);
	Gura_AssignFunction(__glRectiv);
	Gura_AssignFunction(__glRects);
	Gura_AssignFunction(__glRectsv);
	Gura_AssignFunction(__glRenderMode);
	Gura_AssignFunction(__glRotated);
	Gura_AssignFunction(__glRotatef);
	Gura_AssignFunction(__glScaled);
	Gura_AssignFunction(__glScalef);
	Gura_AssignFunction(__glScissor);
	Gura_AssignFunction(__glSelectBuffer);
	Gura_AssignFunction(__glShadeModel);
	Gura_AssignFunction(__glStencilFunc);
	Gura_AssignFunction(__glStencilMask);
	Gura_AssignFunction(__glStencilOp);
	Gura_AssignFunction(__glTexCoord1d);
	Gura_AssignFunction(__glTexCoord1dv);
	Gura_AssignFunction(__glTexCoord1f);
	Gura_AssignFunction(__glTexCoord1fv);
	Gura_AssignFunction(__glTexCoord1i);
	Gura_AssignFunction(__glTexCoord1iv);
	Gura_AssignFunction(__glTexCoord1s);
	Gura_AssignFunction(__glTexCoord1sv);
	Gura_AssignFunction(__glTexCoord2d);
	Gura_AssignFunction(__glTexCoord2dv);
	Gura_AssignFunction(__glTexCoord2f);
	Gura_AssignFunction(__glTexCoord2fv);
	Gura_AssignFunction(__glTexCoord2i);
	Gura_AssignFunction(__glTexCoord2iv);
	Gura_AssignFunction(__glTexCoord2s);
	Gura_AssignFunction(__glTexCoord2sv);
	Gura_AssignFunction(__glTexCoord3d);
	Gura_AssignFunction(__glTexCoord3dv);
	Gura_AssignFunction(__glTexCoord3f);
	Gura_AssignFunction(__glTexCoord3fv);
	Gura_AssignFunction(__glTexCoord3i);
	Gura_AssignFunction(__glTexCoord3iv);
	Gura_AssignFunction(__glTexCoord3s);
	Gura_AssignFunction(__glTexCoord3sv);
	Gura_AssignFunction(__glTexCoord4d);
	Gura_AssignFunction(__glTexCoord4dv);
	Gura_AssignFunction(__glTexCoord4f);
	Gura_AssignFunction(__glTexCoord4fv);
	Gura_AssignFunction(__glTexCoord4i);
	Gura_AssignFunction(__glTexCoord4iv);
	Gura_AssignFunction(__glTexCoord4s);
	Gura_AssignFunction(__glTexCoord4sv);
	Gura_AssignFunction(__glTexEnvf);
	Gura_AssignFunction(__glTexEnvfv);
	Gura_AssignFunction(__glTexEnvi);
	Gura_AssignFunction(__glTexEnviv);
	Gura_AssignFunction(__glTexGend);
	Gura_AssignFunction(__glTexGendv);
	Gura_AssignFunction(__glTexGenf);
	Gura_AssignFunction(__glTexGenfv);
	Gura_AssignFunction(__glTexGeni);
	Gura_AssignFunction(__glTexGeniv);
	Gura_AssignFunction(__glTexImage1D);
	Gura_AssignFunction(__glTexImage1DFromImage);
	Gura_AssignFunction(__glTexImage2D);
	Gura_AssignFunction(__glTexImage2DFromImage);
	Gura_AssignFunction(__glTexParameterf);
	Gura_AssignFunction(__glTexParameterfv);
	Gura_AssignFunction(__glTexParameteri);
	Gura_AssignFunction(__glTexParameteriv);
	Gura_AssignFunction(__glTexSubImage1D);
	Gura_AssignFunction(__glTexSubImage1DFromImage);
	Gura_AssignFunction(__glTexSubImage2D);
	Gura_AssignFunction(__glTexSubImage2DFromImage);
	Gura_AssignFunction(__glTranslated);
	Gura_AssignFunction(__glTranslatef);
	Gura_AssignFunction(__glVertex2d);
	Gura_AssignFunction(__glVertex2dv);
	Gura_AssignFunction(__glVertex2f);
	Gura_AssignFunction(__glVertex2fv);
	Gura_AssignFunction(__glVertex2i);
	Gura_AssignFunction(__glVertex2iv);
	Gura_AssignFunction(__glVertex2s);
	Gura_AssignFunction(__glVertex2sv);
	Gura_AssignFunction(__glVertex3d);
	Gura_AssignFunction(__glVertex3dv);
	Gura_AssignFunction(__glVertex3f);
	Gura_AssignFunction(__glVertex3fv);
	Gura_AssignFunction(__glVertex3i);
	Gura_AssignFunction(__glVertex3iv);
	Gura_AssignFunction(__glVertex3s);
	Gura_AssignFunction(__glVertex3sv);
	Gura_AssignFunction(__glVertex4d);
	Gura_AssignFunction(__glVertex4dv);
	Gura_AssignFunction(__glVertex4f);
	Gura_AssignFunction(__glVertex4fv);
	Gura_AssignFunction(__glVertex4i);
	Gura_AssignFunction(__glVertex4iv);
	Gura_AssignFunction(__glVertex4s);
	Gura_AssignFunction(__glVertex4sv);
	Gura_AssignFunction(__glViewport);
	Gura_AssignFunction(__glGetAttachedShaders);
	Gura_AssignFunction(__glGetShaderInfoLog);
	Gura_AssignFunction(__glGetProgramInfoLog);
	Gura_AssignFunction(__glGetUniformLocation);
	Gura_AssignFunction(__glGetActiveUniform);
	Gura_AssignFunction(__glGetUniformfv);
	Gura_AssignFunction(__glGetUniformiv);
	Gura_AssignFunction(__glGetShaderSource);
	Gura_AssignFunction(__glBindAttribLocation);
	Gura_AssignFunction(__glGetActiveAttrib);
	Gura_AssignFunction(__glGetAttribLocation);
	Gura_AssignFunction(__glUniformMatrix2x3fv);
	Gura_AssignFunction(__glUniformMatrix3x2fv);
	Gura_AssignFunction(__glUniformMatrix2x4fv);
	Gura_AssignFunction(__glUniformMatrix4x2fv);
	Gura_AssignFunction(__glUniformMatrix3x4fv);
	Gura_AssignFunction(__glUniformMatrix4x3fv);
}

Gura_EndModuleScope(opengl)
