/*
    tlhlp
    copyright (c) 2000-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <windows.h>
#include <shlwapi.h>
#include <tchar.h>
#include <tlhelp32.h>
#include "wcommon/wcommon.h"
#include "snap.h"


/*  ヘルプ表示
    nStdHandle,デバイス
      lpszFile,ファイル名                                                   */
static VOID WINAPI
PrintHelp (DWORD   nStdHandle,
           LPCTSTR lpszFile)
{
  LPTSTR lpszInternalName = NULL;
  LPTSTR lpszProductVersion = NULL;
  LPTSTR lpszLegalCopyright = NULL;
  TCHAR szFile[MAX_PATH];

  if (GetModuleFileName (NULL, szFile, MAX_PATH) > 0)
    {
      DWORD dwData, dwHandle;

      dwData = GetFileVersionInfoSize (szFile, &dwHandle);
      if(dwData > 0)
        {
          LPVOID lpData;

          lpData = MemoryAlloc (dwData);
          if (GetFileVersionInfo (szFile, dwHandle, dwData, lpData))
            {
              LPVOID lpVer;
              UINT uVer;

              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\InternalName"),
                                                                &lpVer, &uVer))
                lpszInternalName = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\ProductVersion"),
                                                                &lpVer, &uVer))
                lpszProductVersion = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\LegalCopyright"),
                                                                &lpVer, &uVer))
                lpszLegalCopyright = StringDuplicateEx (lpVer, uVer);
            }
          MemoryFree (lpData);
        }
    }
  PrintConsole (nStdHandle,
_T("%s %s ("BUILD_ENVIRONMENT")\n")
_T("%s\n")
_T("\n")
_T("Usage: %s pid | name [address] [length] [option...]\n")
_T("\n")
_T("  -o, --outfile=FILE     output file\n")
_T("\n"), lpszInternalName, lpszProductVersion, lpszLegalCopyright, lpszFile);
  MemoryFree (lpszInternalName);
  MemoryFree (lpszProductVersion);
  MemoryFree (lpszLegalCopyright);
}


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int i = 1;
  BOOL fFolder;
  DWORD dwBytes = 0, dwProcessId = (DWORD)-1;
  TCHAR szPath[MAX_PATH];
  LPCTSTR lpszProcess = NULL, lpszPath = NULL;
  LPCVOID lpBaseAddress = NULL;
  HANDLE hSnap;

  while (i < argc)
    if (StrCmpI (argv[i], _T("/?")) == 0 || StrCmpI (argv[i], _T("-?")) == 0
     || StrCmpI (argv[i], _T("/h")) == 0 || StrCmpI (argv[i], _T("-h")) == 0
     || StrCmpI (argv[i], _T("--help")) == 0)
      {
        PrintHelp (STD_OUTPUT_HANDLE, argv[0]);
        return 0;
      }
    else if (i + 1 < argc && (StrCmpI (argv[i], _T("/o")) == 0
                           || StrCmpI (argv[i], _T("-o")) == 0))
      {
        lpszPath = argv[i + 1];
        i += 2;
      }
    else if (StrCmpNI (argv[i], _T("/outfile="), 9) == 0)
      {
        lpszPath = argv[i] + 9;
        i++;
      }
    else if (StrCmpNI (argv[i], _T("--outfile="), 10) == 0)
      {
        lpszPath = argv[i] + 10;
        i++;
      }
    else if (!lpszProcess)
      {
        lpszProcess = argv[i];
        dwProcessId = Dec (argv[i]);
        i++;
      }
    else if (i + 1 < argc && dwBytes <= 0)
      {
        lpBaseAddress = (LPCVOID)Hex (argv[i]);
        dwBytes = Hex (argv[i + 1]);
        i += 2;
      }
    else
      {
        break;
      }
  if (i < argc || !lpszProcess)
    {
      PrintHelp (STD_ERROR_HANDLE, argv[0]);
      return -1;
    }

  if (lpszPath)
    lstrcpy (szPath, lpszPath);
  else
    GetCurrentDirectory (MAX_PATH, szPath);
  PathRemoveBackslash (szPath);
  fFolder = PathIsDirectory (szPath);

  hSnap = CreateToolhelp32Snapshot (TH32CS_SNAPPROCESS, 0);
  if (hSnap != INVALID_HANDLE_VALUE)
    {
      BOOL fResult;
      PROCESSENTRY32 pe;

      pe.dwSize = sizeof (PROCESSENTRY32);
      for (fResult = Process32First (hSnap, &pe); fResult;
                                        fResult = Process32Next (hSnap, &pe))
        {
          if (lstrcmpi (pe.szExeFile, lpszProcess) == 0
                                            || pe.th32ProcessID == dwProcessId)
            {
              TCHAR szFile[MAX_PATH];

              PrintConsole (STD_OUTPUT_HANDLE,
                                    _T("%d %s\n"), dwProcessId, pe.szExeFile);
              lstrcpy (szFile, szPath);
              if (fFolder)
                {
                  PathAppend (szFile, pe.szExeFile);
                  PathRemoveExtension (szFile);
                }
              SnapShot (pe.th32ProcessID, szFile,
                                        pe.szExeFile, lpBaseAddress, dwBytes);
            }
        }
      CloseHandle (hSnap);
    }
  else
    {
      PrintConsole (STD_ERROR_HANDLE,
                                    _T("Error : CreateToolhelp32Snapshot\n"));
    }
  return 0;
}
