/*
    loaderex
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <windows.h>
#include <shlwapi.h>
#include <tchar.h>
#include <stdio.h>
#include "wcommon/wcommon.h"


/*  ヘルプ表示
    nStdHandle,デバイス
      lpszFile,ファイル名                                                   */
static VOID WINAPI
PrintHelp (DWORD   nStdHandle,
           LPCTSTR lpszFile)
{
  LPTSTR lpszInternalName = NULL;
  LPTSTR lpszProductVersion = NULL;
  LPTSTR lpszLegalCopyright = NULL;
  TCHAR szFile[MAX_PATH];

  if (GetModuleFileName (NULL, szFile, MAX_PATH) > 0)
    {
      DWORD dwData, dwHandle;

      dwData = GetFileVersionInfoSize (szFile, &dwHandle);
      if(dwData > 0)
        {
          LPVOID lpData;

          lpData = MemoryAlloc (dwData);
          if (GetFileVersionInfo (szFile, dwHandle, dwData, lpData))
            {
              LPVOID lpVer;
              UINT uVer;

              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\InternalName"),
                                                                &lpVer, &uVer))
                lpszInternalName = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\ProductVersion"),
                                                                &lpVer, &uVer))
                lpszProductVersion = StringDuplicateEx (lpVer, uVer);
              if (VerQueryValue (lpData,
                            _T("\\StringFileInfo\\040904e4\\LegalCopyright"),
                                                                &lpVer, &uVer))
                lpszLegalCopyright = StringDuplicateEx (lpVer, uVer);
            }
          MemoryFree (lpData);
        }
    }
  PrintConsole (nStdHandle,
_T("%s %s ("BUILD_ENVIRONMENT")\n")
_T("%s\n")
_T("\n")
_T("Usage: %s [option...] file\n")
_T("\n")
_T("  -a, --address=HEX      address\n")
_T("  -e, --entry=HEX        entry point\n")
_T("  -f, --file=FILE        open file\n")
_T("\n"), lpszInternalName, lpszProductVersion, lpszLegalCopyright, lpszFile);
  MemoryFree (lpszInternalName);
  MemoryFree (lpszProductVersion);
  MemoryFree (lpszLegalCopyright);
}


int
_tmain (int     argc,
        _TCHAR *argv[])
{
  int i = 1, ret = -1;
  LPVOID lpAddress = NULL, lpCode = NULL, lpEntry;
  DWORD dwAddress = 0, dwEntry = 0, dwCode = 0, dwPadding = 0, dwSize;
  HANDLE hFile = INVALID_HANDLE_VALUE;
  LPCTSTR lpszFile = NULL;

  while (i < argc)
    {
      if (StrCmpI (argv[i], _T("/?")) == 0 || StrCmpI (argv[i], _T("-?")) == 0
       || StrCmpI (argv[i], _T("/h")) == 0 || StrCmpI (argv[i], _T("-h")) == 0
       || StrCmpI (argv[i], _T("--help")) == 0)
        {
          PrintHelp (STD_OUTPUT_HANDLE, argv[0]);
          ret = 0;
          goto final;
        }
      else if (StrCmpI (argv[i], _T("-a")) == 0)
        {
          dwAddress = Hex (argv[i + 1]);
          i += 2;
        }
      else if (StrCmpNI (argv[i], _T("--address="), 10) == 0)
        {
          dwAddress = Hex (argv[i++] + 10);
        }
      else if (StrCmpI (argv[i], _T("-e")) == 0)
        {
          dwEntry = Hex (argv[i + 1]);
          i += 2;
        }
      else if (StrCmpNI (argv[i], _T("--entry="), 8) == 0)
        {
          dwEntry = Hex (argv[i++] + 8);
        }
      else if (StrCmpI (argv[i], _T("-f")) == 0)
        {
          lpszFile = argv[i + 1];
          i += 2;
        }
      else if (StrCmpNI (argv[i], _T("--file="), 7) == 0)
        {
          lpszFile = argv[i++] + 7;
        }
      else if (!lpCode)
        {
          lpCode = LoadFile (argv[i], &dwCode);
          if (!lpCode)
            {
              PrintConsole (STD_ERROR_HANDLE,
                                    _T("Error : LoadFile(\"%s\")\n"), argv[i]);
              goto final;
            }
          i++;
        }
      else
        {
          PrintHelp (STD_ERROR_HANDLE, argv[0]);
          goto final;
        }
    }
  if (!lpCode || dwAddress == (DWORD)-1 || dwEntry == (DWORD)-1)
    {
      PrintHelp (STD_ERROR_HANDLE, argv[0]);
      goto final;
    }

  if (dwAddress != 0)
    {
      SYSTEM_INFO SystemInfo;

      GetSystemInfo (&SystemInfo);
      dwPadding = dwAddress
                - dwAddress / SystemInfo.dwPageSize * SystemInfo.dwPageSize;
      dwEntry += dwPadding;
    }
  dwSize = dwCode + dwPadding;
  lpAddress = VirtualAlloc ((LPVOID)(dwAddress - dwPadding), dwSize,
                                        MEM_RESERVE, PAGE_EXECUTE_READWRITE);
  if (lpAddress)
    lpAddress = VirtualAlloc (lpAddress, dwSize,
                                        MEM_COMMIT, PAGE_EXECUTE_READWRITE);
  if (!lpAddress)
    {
      PrintConsole (STD_ERROR_HANDLE,
                _T("Error : VirtualAlloc (%08X, %08X)\n"), dwAddress, dwSize);
      goto final;
    }
  MemoryCopy ((LPBYTE)lpAddress + dwPadding, lpCode, dwCode);
  if (lpszFile)
    {
      hFile = CreateFile (lpszFile, GENERIC_READ, FILE_SHARE_READ, NULL,
                                OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
      if (hFile == INVALID_HANDLE_VALUE)
        {
          PrintConsole (STD_ERROR_HANDLE,
                                _T("Error : CreateFile (\"%s\")\n"), lpszFile);
          goto final;
        }
    }
  lpEntry = (LPBYTE)lpAddress + dwEntry;
  PrintConsole (STD_OUTPUT_HANDLE, _T("%08X %08X\n"), (DWORD)lpAddress);
  __asm int 3
  ((VOID (WINAPI *)(VOID))(lpEntry)) ();
  if (hFile != INVALID_HANDLE_VALUE)
    CloseHandle (hFile);
  ret = 0;
  final:
  if (lpAddress)
    VirtualFree (lpAddress, 0, MEM_RELEASE);
  MemoryFree (lpCode);
  return ret;
}
