/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCSTRINGV_H__
#define __WCSTRINGV_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  文字列を結合する
    lpszSeparator,区切り文字列
              RET,文字列                                                    */
LPWSTR WINAPI
StringJoinW (LPCWSTR lpszSeparator, ...);


/*  文字列を結合する
    lpszSeparator,区切り文字列
              RET,文字列                                                    */
LPSTR WINAPI
StringJoinA (LPCSTR lpszSeparator, ...);


/*  文字列を結合する
    lpszSeparator,区切り文字列
       plpszArray,分割された文字列
              RET,文字列                                                    */
LPWSTR WINAPI
StringJoinVW (LPCWSTR  lpszSeparator,
              LPCWSTR *plpszArray);


/*  文字列を結合する
    lpszSeparator,区切り文字列
       plpszArray,分割された文字列
              RET,文字列                                                    */
LPSTR WINAPI
StringJoinVA (LPCSTR  lpszSeparator,
              LPCSTR *plpszArray);


/*  分割された文字列の数を求める
    plpszArray,分割された文字列
           RET,分割された文字列の数                                         */
int WINAPI
StringLengthVW (LPCWSTR *plpszArray);


/*  分割された文字列の数を求める
    plpszArray,分割された文字列
           RET,分割された文字列の数                                         */
int WINAPI
StringLengthVA (LPCSTR *plpszArray);


/*  分割された文字列をコピーする
    plpszArray,分割された文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI
StringCopyVW (LPCWSTR *plpszArray);


/*  分割された文字列をコピーする
    plpszArray,分割された文字列
           RET,分割された文字列                                             */
LPSTR * WINAPI
StringCopyVA (LPCSTR *plpszArray);


/*  分割された文字列のNULL文字列を削除する
    plpszArray,分割された文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI
StringShrinkVW (LPCWSTR *plpszArray);


/*  分割された文字列のNULL文字列を削除する
    plpszArray,分割された文字列
           RET,分割された文字列                                             */
LPSTR * WINAPI
StringShrinkVA (LPCSTR *plpszArray);


#ifdef UNICODE
# define StringJoin StringJoinW
# define StringJoinV StringJoinVW
# define StringLengthV StringLengthVW
# define StringCopyV StringCopyVW
# define StringShrinkV StringShrinkVW
#else /* not UNICODE */
# define StringJoin StringJoinA
# define StringJoinV StringJoinVA
# define StringLengthV StringLengthVA
# define StringCopyV StringCopyVA
# define StringShrinkV StringShrinkVA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
typedef int (CALLBACK *StringSplitProcW_t) (LPCWSTR lpszString,
                                            LPVOID  lpData);
typedef int (CALLBACK *StringSplitProcA_t) (LPCSTR lpszString,
                                            LPVOID lpData);


/*  文字列を分割する
         lpszString,文字列
    StringSplitProc,コールバック関数
             lpData,ユーザデータ
                RET,分割された文字列                                        */
LPWSTR * WINAPI
StringSplitW (LPCWSTR            lpszString,
              StringSplitProcW_t StringSplitProc,
              LPVOID             lpData);


/*  文字列を分割する
         lpszString,文字列
    StringSplitProc,コールバック関数
             lpData,ユーザデータ
                RET,分割された文字列                                        */
LPSTR * WINAPI
StringSplitA (LPCSTR             lpszString,
              StringSplitProcA_t StringSplitProc,
              LPVOID             lpData);


/*  文字列を分割文字列の中の1文字で分割する
    lpszString,文字列
      lpszData,分割文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitDelimiterW   (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitDelimiterA   (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列の中の1文字で分割する
    lpszString,文字列
      lpszData,分割文字列(大文字小文字を区別しない)
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitDelimiterIW  (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitDelimiterIA  (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列の中の1文字に一致する文字列で分割する
    lpszString,文字列
      lpszData,分割文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitDelimitersW  (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitDelimitersA  (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列の中の1文字に一致する文字列で分割する
    lpszString,文字列
      lpszData,分割文字列(大文字小文字を区別しない)
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitDelimitersIW (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitDelimitersIA (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列で分割する
    lpszString,文字列
      lpszData,分割文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitSeparatorW   (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitSeparatorA   (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列で分割する
    lpszString,文字列
      lpszData,分割文字列(大文字小文字を区別しない)
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitSeparatorIW  (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitSeparatorIA  (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列の中のどの文字にも一致しない文字列で分割する
    lpszString,文字列
      lpszData,分割文字列
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitComplementW  (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitComplementA  (LPCSTR  lpszString, LPCSTR  lpszData);


/*  文字列を分割文字列の中のどの文字にも一致しない文字列で分割する
    lpszString,文字列
      lpszData,分割文字列(大文字小文字を区別しない)
           RET,分割された文字列                                             */
LPWSTR * WINAPI StringSplitComplementIW (LPCWSTR lpszString, LPCWSTR lpszData);
LPSTR  * WINAPI StringSplitComplementIA (LPCSTR  lpszString, LPCSTR  lpszData);


#ifdef UNICODE
# define StringSplit            StringSplitW
# define StringSplitDelimiter   StringSplitDelimiterW
# define StringSplitDelimiterI  StringSplitDelimiterIW
# define StringSplitDelimiters  StringSplitDelimitersW
# define StringSplitDelimitersI StringSplitDelimitersIW
# define StringSplitSeparator   StringSplitSeparatorW
# define StringSplitSeparatorI  StringSplitSeparatorIW
# define StringSplitComplement  StringSplitComplementW
# define StringSplitComplementI StringSplitComplementIW
#else /* not UNICODE */
# define StringSplit            StringSplitA
# define StringSplitDelimiter   StringSplitDelimiterA
# define StringSplitDelimiterI  StringSplitDelimiterIA
# define StringSplitDelimiters  StringSplitDelimitersA
# define StringSplitDelimitersI StringSplitDelimitersIA
# define StringSplitSeparator   StringSplitSeparatorA
# define StringSplitSeparatorI  StringSplitSeparatorIA
# define StringSplitComplement  StringSplitComplementA
# define StringSplitComplementI StringSplitComplementIA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCSTRINGV_H__ */
