/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCSTRING_H__
#define __WCSTRING_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  文字が数字であるかどうかを判断する
     ch,文字
    RET,TRUE:数字,FALSE:その他                                              */
BOOL WINAPI
IsCharNumericW (WCHAR ch);


/*  文字が数字であるかどうかを判断する
     ch,文字
    RET,TRUE:数字,FALSE:その他                                              */
BOOL WINAPI
IsCharNumericA (CHAR ch);


/*  文字がコントロールコードであるかどうかを判断する
     ch,文字
    RET,TRUE:コントロールコード,FALSE:その他                                */
BOOL WINAPI
IsCharControlW (WCHAR ch);


/*  文字がコントロールコードであるかどうかを判断する
     ch,文字
    RET,TRUE:コントロールコード,FALSE:その他                                */
BOOL WINAPI
IsCharControlA (CHAR ch);


#ifdef UNICODE
# define IsCharNumeric IsCharNumericW
# define IsCharControl IsCharControlW
#else /* not UNICODE */
# define IsCharNumeric IsCharNumericA
# define IsCharControl IsCharControlA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  8進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
OctW (LPCWSTR lpszText);


/*  8進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
OctA (LPCSTR lpszText);


/*  10進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
DecW (LPCWSTR lpszText);


/*  10進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
DecA (LPCSTR lpszText);


/*  16進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
HexW (LPCWSTR lpszText);


/*  16進数文字列を数値に変換する
    lpszText,文字列
         RET,数値                                                           */
DWORD WINAPI
HexA (LPCSTR lpszText);


/*  ja:数値→文字列
        nValue,数値
    lpszString,文字列
        nRadix,基数
         nWide,桁数(正:右詰め空白,負:右詰め0)
       fSigned,TRUE:符号あり,FALSE:符号なし                                 */
VOID WINAPI
ValStrW (int    nValue,
         LPWSTR lpszString,
         int    nRadix,
         int    nWide,
         BOOL   fSigned);


/*  ja:数値→文字列
        nValue,数値
    lpszString,文字列
        nRadix,基数
         nWide,桁数(正:右詰め空白,負:右詰め0)
       fSigned,TRUE:符号あり,FALSE:符号なし                                 */
VOID WINAPI
ValStrA (int   nValue,
         LPSTR lpszString,
         int   nRadix,
         int   nWide,
         BOOL  fSigned);


/*  ja:文字列→数値
        nValue,数値
    lpszString,文字列
        nRadix,基数
           RET,TRUE:正常終了,FALSE:エラー                                   */
BOOL WINAPI
StrValW (int     *nValue,
         LPCWSTR  lpszString,
         int      nRadix);


/*  ja:文字列→数値
        nValue,数値
    lpszString,文字列
        nRadix,基数
           RET,TRUE:正常終了,FALSE:エラー                                   */
BOOL WINAPI
StrValA (int    *nValue,
         LPCSTR  lpszString,
         int     nRadix);


#ifdef UNICODE
# define Oct OctW
# define Dec DecW
# define Hex HexW
# define ValStr ValStrW
# define StrVal StrValW
#else /* not UNICODE */
# define Oct OctA
# define Dec DecA
# define Hex HexA
# define ValStr ValStrA
# define StrVal StrValA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  文字列を書式化する
    ppszString,文字列
    lpszFormat,書式文字列
       arglist,引数
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wvasprintfW (LPWSTR  *ppszString,
             LPCWSTR  lpszFormat,
             va_list  arglist);


/*  文字列を書式化する
    ppszString,文字列
    lpszFormat,書式文字列
       arglist,引数
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wvasprintfA (LPSTR  *ppszString,
             LPCSTR  lpszFormat,
             va_list arglist);


/*  文字列を書式化する
    ppszString,文字列
      lpFormat,書式文字列
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wasprintfW (LPWSTR  *ppszString,
            LPCWSTR  lpszFormat, ...);


/*  文字列を書式化する
    ppszString,文字列
      lpFormat,書式文字列
           RET,文字数(終端のNULLを含まない)                                 */
SSIZE_T WINAPI
wasprintfA (LPSTR  *ppszString,
            LPCSTR  lpszFormat, ...);


/*  文字列を複製する
    lpszText,文字列
       nSize,文字数(負:NULL終端文字列)
         RET,複製したメモリ,NULL:エラー                                     */
LPWSTR WINAPI
StringDuplicateExW (LPCWSTR lpszText,
                    SSIZE_T nSize);


/*  文字列を複製する
    lpszText,文字列
       nSize,文字数(負:NULL終端文字列)
         RET,複製したメモリ,NULL:エラー                                     */
LPSTR WINAPI
StringDuplicateExA (LPCSTR  lpszText,
                    SSIZE_T nSize);


/*  文字列を複製する
    lpszText,文字列
         RET,複製したメモリ,NULL:エラー                                     */
LPWSTR WINAPI
StringDuplicateW (LPCWSTR lpszText);


/*  文字列を複製する
    lpszText,文字列
         RET,複製したメモリ,NULL:エラー                                     */
LPSTR WINAPI
StringDuplicateA (LPCSTR lpszText);


#ifdef UNICODE
# define wvasprintf wvasprintfW
# define wasprintf wasprintfW
# define StringDuplicateEx StringDuplicateExW
# define StringDuplicate StringDuplicateW
#else /* not UNICODE */
# define wvasprintf wvasprintfA
# define wasprintf wasprintfA
# define StringDuplicateEx StringDuplicateExA
# define StringDuplicate StringDuplicateA
#endif /* not UNICODE */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  文字列をエスケープする
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,エスケープされた文字列                                       */
LPWSTR WINAPI
StringEscapeExW (LPCWSTR lpszString,
                 SSIZE_T nSize);


/*  文字列をエスケープする
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,エスケープされた文字列                                       */
LPSTR WINAPI
StringEscapeExA (LPCSTR  lpszString,
                 SSIZE_T nSize);


/*  文字列をエスケープする
    lpszString,文字列
           RET,エスケープされた文字列                                       */
LPWSTR WINAPI
StringEscapeW (LPCWSTR lpszString);


/*  文字列をエスケープする
    lpszString,文字列
           RET,エスケープされた文字列                                       */
LPSTR WINAPI
StringEscapeA (LPCSTR lpszString);


/*  文字列をエスケープしない
    lpszString,エスケープされた文字列
         nSize,文字数(負:NULL終端文字列)
           RET,文字列                                                       */
LPWSTR WINAPI
StringUnescapeExW (LPCWSTR lpszString,
                   SSIZE_T nSize);


/*  文字列をエスケープしない
    lpszString,エスケープされた文字列
         nSize,文字数(負:NULL終端文字列)
           RET,文字列                                                       */
LPSTR WINAPI
StringUnescapeExA (LPCSTR  lpszString,
                   SSIZE_T nSize);


/*  文字列をエスケープしない
    lpszString,エスケープされた文字列
           RET,文字列                                                       */
LPWSTR WINAPI
StringUnescapeW (LPCWSTR lpszString);


/*  文字列をエスケープしない
    lpszString,エスケープされた文字列
           RET,文字列                                                       */
LPSTR WINAPI
StringUnescapeA (LPCSTR lpszString);


/*  文字列を正規化する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,正規化された文字列                                           */
LPWSTR WINAPI
StringCanonicalizeExW (LPCWSTR lpszString,
                       SSIZE_T nSize);


/*  文字列を正規化する
    lpszString,文字列
         nSize,文字数(負:NULL終端文字列)
           RET,正規化された文字列                                           */
LPSTR WINAPI
StringCanonicalizeExA (LPCSTR  lpszString,
                       SSIZE_T nSize);


/*  文字列を正規化する
    lpszString,文字列
           RET,正規化された文字列                                           */
LPWSTR WINAPI
StringCanonicalizeW (LPCWSTR lpszString);


/*  文字列を正規化する
    lpszString,文字列
           RET,正規化された文字列                                           */
LPSTR WINAPI
StringCanonicalizeA (LPCSTR lpszString);


#ifdef UNICODE
# define StringEscapeEx StringEscapeExW
# define StringEscape StringEscapeW
# define StringUnescapeEx StringUnescapeExW
# define StringUnescape StringUnescapeW
# define StringCanonicalizeEx StringCanonicalizeExW
# define StringCanonicalize StringCanonicalizeW
#else /* not UNICODE */
# define StringEscapeEx StringEscapeExA
# define StringEscape StringEscapeA
# define StringUnescapeEx StringUnescapeExA
# define StringUnescape StringUnescapeA
# define StringCanonicalizeEx StringCanonicalizeExA
# define StringCanonicalize StringCanonicalizeA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCSTRING_H__ */
