/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCHASH_H__
#define __WCHASH_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
typedef struct _HASH *LPHASH;
typedef BOOL (WINAPI *HashCompare_t )(LPVOID lpKey1,
                                      LPVOID lpKey2,
                                      LPVOID lpData);
typedef VOID (WINAPI *HashFree_t) (LPVOID lpObject,
                                   LPVOID lpData);
typedef BOOL (CALLBACK *HashEnumProc_t) (LPVOID lpKey,
                                         LPVOID lpValue,
                                         LPVOID lpData);


/*  鍵を直接比較する
    lpKey1,鍵1
    lpKey2,鍵2
    lpData,ユーザデータ
       RET,TRUE:等しい,FALSE:異なる                                         */
BOOL WINAPI
HashCompareDirect (LPVOID lpKey1,
                   LPVOID lpKey2,
                   LPVOID lpData);


/*  鍵を文字列として比較する
    lpKey1,鍵1
    lpKey2,鍵2
    lpData,ユーザデータ
       RET,TRUE:等しい,FALSE:異なる                                         */
BOOL WINAPI
HashCompareStringA (LPVOID lpKey1,
                    LPVOID lpKey2,
                    LPVOID lpData);


/*  鍵を文字列として比較する
    lpKey1,鍵1
    lpKey2,鍵2
    lpData,ユーザデータ
       RET,TRUE:等しい,FALSE:異なる                                         */
BOOL WINAPI
HashCompareStringW (LPVOID lpKey1,
                    LPVOID lpKey2,
                    LPVOID lpData);


/*  ハッシュの鍵または値を解放する
    lpObject,鍵または値
      lpData,ユーザデータ                                                   */
VOID WINAPI
HashFree (LPVOID lpObject,
          LPVOID lpData);


/*  ハッシュテーブルを作成する
      lpHashCompare,比較関数
      lpHashFreeKey,鍵解放関数
    lpHashFreeValue,値解放関数
             lpData,ユーザデータ
                RET,ハッシュテーブル                                        */
LPHASH WINAPI
HashCreate (HashCompare_t lpHashCompare,
            HashFree_t    lpHashFreeKey,
            HashFree_t    lpHashFreeValue,
            LPVOID        lpData);


/*  ハッシュテーブルを解放する
    lpHash,ハッシュテーブル                                                 */
VOID WINAPI
HashRelease (LPHASH lpHash);


/*  ハッシュテーブルに要素を挿入する
     lpHash,ハッシュテーブル
      lpKey,鍵
    lpValue,値
        RET,ハッシュテーブル                                                */
LPHASH WINAPI
HashInsert (LPHASH lpHash,
            LPVOID lpKey,
            LPVOID lpValue);


/*  ハッシュテーブルの値を求める
    lpHash,ハッシュテーブル
     lpKey,鍵
       RET,値(NULL:値なし)                                                  */
LPVOID WINAPI
HashLookup (LPHASH lpHash,
            LPVOID lpKey);


/*  ハッシュテーブルの要素を削除する
    lpHash,ハッシュテーブル
     lpKey,鍵
       RET,TRUE:削除できた,FALSE:削除できない                               */
BOOL WINAPI
HashRemove (LPHASH lpHash,
            LPVOID lpKey);


/*  ハッシュテーブルの要素を列挙する
    lpHash,ハッシュテーブル
    lpProc,列挙関数
    lpData,ユーザデータ
       RET,TRUE:すべて列挙,FALSE:中断                                       */
BOOL WINAPI
HashEnum (LPHASH         lpHash,
          HashEnumProc_t lpProc,
          LPVOID         lpData);


#ifdef UNICODE
# define HashCompareString HashCompareStringW
#else /* not UNICODE */
# define HashCompareString HashCompareStringA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCHASH_H__ */
