/*
    wcommon
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WCFILE_H__
#define __WCFILE_H__


#include "wcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ファイルをメモリに読み込む
    lpszFile,ファイル名
    lpdwSize,ファイルサイズ
         RET,メモリ                                                         */
LPVOID WINAPI
LoadFileW (LPCWSTR lpszFile,
           LPDWORD lpdwSize);


/*  ファイルをメモリに読み込む
    lpszFile,ファイル名
    lpdwSize,ファイルサイズ
         RET,メモリ                                                         */
LPVOID WINAPI
LoadFileA (LPCSTR  lpszFile,
           LPDWORD lpdwSize);


/*  メモリをファイルに書き込む
    lpszFile,ファイル名
    lpBuffer,メモリ
      nSize,バイト数(負:NULL終端文字列)
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
SaveFileW (LPCWSTR lpszFile,
           LPCVOID lpBuffer,
           SSIZE_T nSize);


/*  メモリをファイルに書き込む
    lpszFile,ファイル名
    lpBuffer,メモリ
      nSize,バイト数(負:NULL終端文字列)
         RET,TRUE:正常終了,FALSE:エラー                                     */
BOOL WINAPI
SaveFileA (LPCSTR  lpszFile,
           LPCVOID lpBuffer,
           SSIZE_T nSize);


#ifdef UNICODE
# define LoadFile LoadFileW
# define SaveFile SaveFileW
#else /* not UNICODE */
# define LoadFile LoadFileA
# define SaveFile SaveFileA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __WCFILE_H__ */
