/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "user32.h"
#include "ia32/message.h"


/* BlockInput ordinal = 1517, argument = 4 */
static gboolean user32_BlockInput (Ia32Thread *thread)
{
  thread->reg.eax = TRUE;
  ia32_message_record_api_with_argument (thread,
                                        "BlockInput", IA32_MESSAGE_DEC,
                                        "fBlock", IA32_MESSAGE_DEC,
                                        NULL);
  return TRUE;
}


/* FindWindowA ordinal = 1756, argument = 8 */
static gboolean user32_FindWindowA (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_message_record_api_with_argument (thread,
                                        "FindWindowA", IA32_MESSAGE_HEX,
                                        "lpClassName", IA32_MESSAGE_STRING,
                                        "lpWindowName", IA32_MESSAGE_STRING,
                                        NULL);
  return TRUE;
}


/* FindWindowW ordinal = 1759, argument = 8 */
static gboolean user32_FindWindowW (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_message_record_api_with_argument (thread,
                                        "FindWindowW", IA32_MESSAGE_HEX,
                                        "lpClassName", IA32_MESSAGE_STRINGW,
                                        "lpWindowName", IA32_MESSAGE_STRINGW,
                                        NULL);
  return TRUE;
}


/* GetForegroundWindow ordinal = 1810, argument = 0 */
static gboolean user32_GetForegroundWindow (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_message_record_api_with_argument (thread,
                                    "GetForegroundWindow", IA32_MESSAGE_HEX,
                                    NULL);
  return TRUE;
}


/* GetTopWindow ordinal = 1898, argument = 4 */
static gboolean user32_GetTopWindow (Ia32Thread *thread)
{
  thread->reg.eax = 0;
  ia32_message_record_api_with_argument (thread,
                                        "GetTopWindow", IA32_MESSAGE_HEX,
                                        "hWnd", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* MessageBoxA ordinal = 2039, argument = 16 */
static gboolean user32_MessageBoxA (Ia32Thread *thread)
{
  thread->reg.eax = 1;
  ia32_message_record_api_with_argument (thread,
                                        "MessageBoxA", IA32_MESSAGE_DEC,
                                        "hWnd", IA32_MESSAGE_HEX,
                                        "lpText", IA32_MESSAGE_STRING,
                                        "lpCaption", IA32_MESSAGE_STRING,
                                        "uType", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


/* MessageBoxW ordinal = 2046, argument = 16 */
static gboolean user32_MessageBoxW (Ia32Thread *thread)
{
  thread->reg.eax = 1;
  ia32_message_record_api_with_argument (thread,
                                        "MessageBoxW", IA32_MESSAGE_DEC,
                                        "hWnd", IA32_MESSAGE_HEX,
                                        "lpText", IA32_MESSAGE_STRINGW,
                                        "lpCaption", IA32_MESSAGE_STRINGW,
                                        "uType", IA32_MESSAGE_HEX,
                                        NULL);
  return TRUE;
}


Ia32Export ia32_user32_exports[] = {
{ 8, 1502, "ActivateKeyboardLayout",               NULL},
{ 0, 1503, "AddClipboardFormatListener",           NULL},
{12, 1504, "AdjustWindowRect",                     NULL},
{16, 1505, "AdjustWindowRectEx",                   NULL},
{ 0, 1506, "AlignRects",                           NULL},
{ 0, 1507, "AllowForegroundActivation",            NULL},
{ 4, 1508, "AllowSetForegroundWindow",             NULL},
{12, 1509, "AnimateWindow",                        NULL},
{ 0, 1510, "AnyPopup",                             NULL},
{16, 1511, "AppendMenuA",                          NULL},
{16, 1512, "AppendMenuW",                          NULL},
{ 4, 1513, "ArrangeIconicWindows",                 NULL},
{12, 1514, "AttachThreadInput",                    NULL},
{ 4, 1515, "BeginDeferWindowPos",                  NULL},
{ 8, 1516, "BeginPaint",                           NULL},
{ 4, 1517, "BlockInput",                           user32_BlockInput},
{ 4, 1518, "BringWindowToTop",                     NULL},
{20, 1519, "BroadcastSystemMessage",               NULL},
{20, 1520, "BroadcastSystemMessageA",              NULL},
{ 0, 1521, "BroadcastSystemMessageExA",            NULL},
{ 0, 1522, "BroadcastSystemMessageExW",            NULL},
{20, 1523, "BroadcastSystemMessageW",              NULL},
{ 0, 1524, "BuildReasonArray",                     NULL},
{ 0, 1525, "CalcMenuBar",                          NULL},
{ 0, 1526, "CalculatePopupWindowPosition",         NULL},
{ 8, 1527, "CallMsgFilter",                        NULL},
{ 8, 1528, "CallMsgFilterA",                       NULL},
{ 8, 1529, "CallMsgFilterW",                       NULL},
{16, 1530, "CallNextHookEx",                       NULL},
{20, 1531, "CallWindowProcA",                      NULL},
{20, 1532, "CallWindowProcW",                      NULL},
{ 0, 1533, "CancelShutdown",                       NULL},
{ 8, 1534, "CascadeChildWindows",                  NULL},
{20, 1535, "CascadeWindows",                       NULL},
{ 8, 1536, "ChangeClipboardChain",                 NULL},
{ 8, 1537, "ChangeDisplaySettingsA",               NULL},
{20, 1538, "ChangeDisplaySettingsExA",             NULL},
{20, 1539, "ChangeDisplaySettingsExW",             NULL},
{ 8, 1540, "ChangeDisplaySettingsW",               NULL},
{20, 1541, "ChangeMenuA",                          NULL},
{20, 1542, "ChangeMenuW",                          NULL},
{ 0, 1543, "ChangeWindowMessageFilter",            NULL},
{ 0, 1544, "ChangeWindowMessageFilterEx",          NULL},
{ 4, 1545, "CharLowerA",                           NULL},
{ 8, 1546, "CharLowerBuffA",                       NULL},
{ 8, 1547, "CharLowerBuffW",                       NULL},
{ 4, 1548, "CharLowerW",                           NULL},
{ 4, 1549, "CharNextA",                            NULL},
{12, 1557, "CharNextExA",                          NULL},
{ 4, 1558, "CharNextW",                            NULL},
{ 8, 1559, "CharPrevA",                            NULL},
{16, 1560, "CharPrevExA",                          NULL},
{ 8, 1561, "CharPrevW",                            NULL},
{ 8, 1562, "CharToOemA",                           NULL},
{12, 1563, "CharToOemBuffA",                       NULL},
{12, 1564, "CharToOemBuffW",                       NULL},
{ 8, 1565, "CharToOemW",                           NULL},
{ 4, 1566, "CharUpperA",                           NULL},
{ 8, 1567, "CharUpperBuffA",                       NULL},
{ 8, 1568, "CharUpperBuffW",                       NULL},
{ 4, 1569, "CharUpperW",                           NULL},
{ 0, 1570, "CheckDesktopByThreadId",               NULL},
{12, 1571, "CheckDlgButton",                       NULL},
{12, 1572, "CheckMenuItem",                        NULL},
{20, 1573, "CheckMenuRadioItem",                   NULL},
{16, 1574, "CheckRadioButton",                     NULL},
{ 0, 1575, "CheckWindowThreadDesktop",             NULL},
{12, 1576, "ChildWindowFromPoint",                 NULL},
{16, 1577, "ChildWindowFromPointEx",               NULL},
{ 0, 1578, "CliImmSetHotKey",                      NULL},
{ 0, 1579, "ClientThreadSetup",                    NULL},
{ 8, 1580, "ClientToScreen",                       NULL},
{ 4, 1581, "ClipCursor",                           NULL},
{ 0, 1582, "CloseClipboard",                       NULL},
{ 4, 1583, "CloseDesktop",                         NULL},
{ 0, 1584, "CloseGestureInfoHandle",               NULL},
{ 0, 1585, "CloseTouchInputHandle",                NULL},
{ 4, 1586, "CloseWindow",                          NULL},
{ 4, 1587, "CloseWindowStation",                   NULL},
{ 0, 1588, "ConsoleControl",                       NULL},
{ 0, 1589, "ControlMagnification",                 NULL},
{12, 1590, "CopyAcceleratorTableA",                NULL},
{12, 1591, "CopyAcceleratorTableW",                NULL},
{ 4, 1592, "CopyIcon",                             NULL},
{20, 1593, "CopyImage",                            NULL},
{ 8, 1594, "CopyRect",                             NULL},
{ 0, 1595, "CountClipboardFormats",                NULL},
{ 8, 1596, "CreateAcceleratorTableA",              NULL},
{ 8, 1597, "CreateAcceleratorTableW",              NULL},
{16, 1598, "CreateCaret",                          NULL},
{28, 1599, "CreateCursor",                         NULL},
{24, 1600, "CreateDesktopA",                       NULL},
{ 0, 1601, "CreateDesktopExA",                     NULL},
{ 0, 1602, "CreateDesktopExW",                     NULL},
{24, 1603, "CreateDesktopW",                       NULL},
{20, 1604, "CreateDialogIndirectParamA",           NULL},
{ 0, 1605, "CreateDialogIndirectParamAorW",        NULL},
{20, 1606, "CreateDialogIndirectParamW",           NULL},
{20, 1607, "CreateDialogParamA",                   NULL},
{20, 1608, "CreateDialogParamW",                   NULL},
{28, 1609, "CreateIcon",                           NULL},
{16, 1610, "CreateIconFromResource",               NULL},
{28, 1611, "CreateIconFromResourceEx",             NULL},
{ 4, 1612, "CreateIconIndirect",                   NULL},
{40, 1613, "CreateMDIWindowA",                     NULL},
{40, 1614, "CreateMDIWindowW",                     NULL},
{ 0, 1615, "CreateMenu",                           NULL},
{ 0, 1616, "CreatePopupMenu",                      NULL},
{ 0, 1617, "CreateSystemThreads",                  NULL},
{48, 1618, "CreateWindowExA",                      NULL},
{48, 1619, "CreateWindowExW",                      NULL},
{16, 1620, "CreateWindowStationA",                 NULL},
{16, 1621, "CreateWindowStationW",                 NULL},
{ 0, 1622, "CsrBroadcastSystemMessageExW",         NULL},
{ 0, 1623, "CtxInitUser32",                        NULL},
{12, 1624, "DdeAbandonTransaction",                NULL},
{ 8, 1625, "DdeAccessData",                        NULL},
{16, 1626, "DdeAddData",                           NULL},
{32, 1627, "DdeClientTransaction",                 NULL},
{ 8, 1628, "DdeCmpStringHandles",                  NULL},
{16, 1629, "DdeConnect",                           NULL},
{20, 1630, "DdeConnectList",                       NULL},
{28, 1631, "DdeCreateDataHandle",                  NULL},
{12, 1632, "DdeCreateStringHandleA",               NULL},
{12, 1633, "DdeCreateStringHandleW",               NULL},
{ 4, 1634, "DdeDisconnect",                        NULL},
{ 4, 1635, "DdeDisconnectList",                    NULL},
{12, 1636, "DdeEnableCallback",                    NULL},
{ 4, 1637, "DdeFreeDataHandle",                    NULL},
{ 8, 1638, "DdeFreeStringHandle",                  NULL},
{16, 1639, "DdeGetData",                           NULL},
{ 4, 1640, "DdeGetLastError",                      NULL},
{12, 1641, "DdeGetQualityOfService",               NULL},
{ 4, 1642, "DdeImpersonateClient",                 NULL},
{16, 1643, "DdeInitializeA",                       NULL},
{16, 1644, "DdeInitializeW",                       NULL},
{ 8, 1645, "DdeKeepStringHandle",                  NULL},
{16, 1646, "DdeNameService",                       NULL},
{12, 1647, "DdePostAdvise",                        NULL},
{12, 1648, "DdeQueryConvInfo",                     NULL},
{ 8, 1649, "DdeQueryNextServer",                   NULL},
{20, 1650, "DdeQueryStringA",                      NULL},
{20, 1651, "DdeQueryStringW",                      NULL},
{ 4, 1652, "DdeReconnect",                         NULL},
{12, 1653, "DdeSetQualityOfService",               NULL},
{12, 1654, "DdeSetUserHandle",                     NULL},
{ 4, 1655, "DdeUnaccessData",                      NULL},
{ 4, 1656, "DdeUninitialize",                      NULL},
{16, 1657, "DefDlgProcA",                          NULL},
{16, 1658, "DefDlgProcW",                          NULL},
{20, 1659, "DefFrameProcA",                        NULL},
{20, 1660, "DefFrameProcW",                        NULL},
{16, 1661, "DefMDIChildProcA",                     NULL},
{16, 1662, "DefMDIChildProcW",                     NULL},
{ 0, 1663, "DefRawInputProc",                      NULL},
{16, 1664, "DefWindowProcA",                       NULL},
{16, 1665, "DefWindowProcW",                       NULL},
{32, 1666, "DeferWindowPos",                       NULL},
{12, 1667, "DeleteMenu",                           NULL},
{ 0, 1668, "DeregisterShellHookWindow",            NULL},
{ 4, 1669, "DestroyAcceleratorTable",              NULL},
{ 0, 1670, "DestroyCaret",                         NULL},
{ 4, 1671, "DestroyCursor",                        NULL},
{ 4, 1672, "DestroyIcon",                          NULL},
{ 4, 1673, "DestroyMenu",                          NULL},
{ 0, 1674, "DestroyReasons",                       NULL},
{ 4, 1675, "DestroyWindow",                        NULL},
{ 0, 1676, "DeviceEventWorker",                    NULL},
{20, 1677, "DialogBoxIndirectParamA",              NULL},
{ 0, 1678, "DialogBoxIndirectParamAorW",           NULL},
{20, 1679, "DialogBoxIndirectParamW",              NULL},
{20, 1680, "DialogBoxParamA",                      NULL},
{20, 1681, "DialogBoxParamW",                      NULL},
{ 0, 1682, "DisableProcessWindowsGhosting",        NULL},
{ 4, 1683, "DispatchMessageA",                     NULL},
{ 4, 1684, "DispatchMessageW",                     NULL},
{ 0, 1685, "DisplayConfigGetDeviceInfo",           NULL},
{ 0, 1686, "DisplayConfigSetDeviceInfo",           NULL},
{ 0, 1687, "DisplayExitWindowsWarnings",           NULL},
{20, 1688, "DlgDirListA",                          NULL},
{20, 1689, "DlgDirListComboBoxA",                  NULL},
{20, 1690, "DlgDirListComboBoxW",                  NULL},
{20, 1691, "DlgDirListW",                          NULL},
{16, 1692, "DlgDirSelectComboBoxExA",              NULL},
{16, 1693, "DlgDirSelectComboBoxExW",              NULL},
{16, 1694, "DlgDirSelectExA",                      NULL},
{16, 1695, "DlgDirSelectExW",                      NULL},
{ 0, 1696, "DoSoundConnect",                       NULL},
{ 0, 1697, "DoSoundDisconnect",                    NULL},
{12, 1698, "DragDetect",                           NULL},
{20, 1699, "DragObject",                           NULL},
{16, 1700, "DrawAnimatedRects",                    NULL},
{16, 1701, "DrawCaption",                          NULL},
{ 0, 1702, "DrawCaptionTempA",                     NULL},
{ 0, 1703, "DrawCaptionTempW",                     NULL},
{16, 1704, "DrawEdge",                             NULL},
{ 8, 1705, "DrawFocusRect",                        NULL},
{16, 1706, "DrawFrame",                            NULL},
{16, 1707, "DrawFrameControl",                     NULL},
{16, 1708, "DrawIcon",                             NULL},
{36, 1709, "DrawIconEx",                           NULL},
{ 4, 1710, "DrawMenuBar",                          NULL},
{ 0, 1711, "DrawMenuBarTemp",                      NULL},
{40, 1712, "DrawStateA",                           NULL},
{40, 1713, "DrawStateW",                           NULL},
{20, 1714, "DrawTextA",                            NULL},
{24, 1715, "DrawTextExA",                          NULL},
{24, 1716, "DrawTextExW",                          NULL},
{20, 1717, "DrawTextW",                            NULL},
{ 0, 1718, "DwmGetDxSharedSurface",                NULL},
{ 0, 1719, "DwmStartRedirection",                  NULL},
{ 0, 1720, "DwmStopRedirection",                   NULL},
{16, 1721, "EditWndProc",                          NULL},
{ 0, 1722, "EmptyClipboard",                       NULL},
{12, 1723, "EnableMenuItem",                       NULL},
{12, 1724, "EnableScrollBar",                      NULL},
{ 8, 1725, "EnableWindow",                         NULL},
{ 4, 1726, "EndDeferWindowPos",                    NULL},
{ 8, 1727, "EndDialog",                            NULL},
{ 0, 1728, "EndMenu",                              NULL},
{ 8, 1729, "EndPaint",                             NULL},
{ 0, 1730, "EndTask",                              NULL},
{ 0, 1731, "EnterReaderModeHelper",                NULL},
{12, 1732, "EnumChildWindows",                     NULL},
{ 4, 1733, "EnumClipboardFormats",                 NULL},
{12, 1734, "EnumDesktopWindows",                   NULL},
{12, 1735, "EnumDesktopsA",                        NULL},
{12, 1736, "EnumDesktopsW",                        NULL},
{ 0, 1737, "EnumDisplayDevicesA",                  NULL},
{ 0, 1738, "EnumDisplayDevicesW",                  NULL},
{16, 1739, "EnumDisplayMonitors",                  NULL},
{12, 1740, "EnumDisplaySettingsA",                 NULL},
{16, 1741, "EnumDisplaySettingsExA",               NULL},
{16, 1742, "EnumDisplaySettingsExW",               NULL},
{12, 1743, "EnumDisplaySettingsW",                 NULL},
{ 8, 1744, "EnumPropsA",                           NULL},
{12, 1745, "EnumPropsExA",                         NULL},
{12, 1746, "EnumPropsExW",                         NULL},
{ 8, 1747, "EnumPropsW",                           NULL},
{12, 1748, "EnumThreadWindows",                    NULL},
{ 8, 1749, "EnumWindowStationsA",                  NULL},
{ 8, 1750, "EnumWindowStationsW",                  NULL},
{ 8, 1751, "EnumWindows",                          NULL},
{ 8, 1752, "EqualRect",                            NULL},
{ 8, 1753, "ExcludeUpdateRgn",                     NULL},
{ 8, 1754, "ExitWindowsEx",                        NULL},
{12, 1755, "FillRect",                             NULL},
{ 8, 1756, "FindWindowA",                          user32_FindWindowA},
{16, 1757, "FindWindowExA",                        NULL},
{16, 1758, "FindWindowExW",                        NULL},
{ 8, 1759, "FindWindowW",                          user32_FindWindowW},
{ 8, 1760, "FlashWindow",                          NULL},
{ 4, 1761, "FlashWindowEx",                        NULL},
{12, 1762, "FrameRect",                            NULL},
{ 8, 1763, "FreeDDElParam",                        NULL},
{ 0, 1764, "FrostCrashedWindow",                   NULL},
{ 0, 1765, "GetActiveWindow",                      NULL},
{20, 1766, "GetAltTabInfo",                        NULL},
{20, 1767, "GetAltTabInfoA",                       NULL},
{20, 1768, "GetAltTabInfoW",                       NULL},
{ 8, 1769, "GetAncestor",                          NULL},
{ 0, 1771, "GetAppCompatFlags",                    NULL},
{ 0, 1770, "GetAppCompatFlags2",                   NULL},
{ 4, 1772, "GetAsyncKeyState",                     NULL},
{ 0, 1773, "GetCapture",                           NULL},
{ 0, 1774, "GetCaretBlinkTime",                    NULL},
{ 4, 1775, "GetCaretPos",                          NULL},
{12, 1776, "GetClassInfoA",                        NULL},
{12, 1777, "GetClassInfoExA",                      NULL},
{12, 1778, "GetClassInfoExW",                      NULL},
{12, 1779, "GetClassInfoW",                        NULL},
{ 8, 1780, "GetClassLongA",                        NULL},
{ 8, 1781, "GetClassLongW",                        NULL},
{12, 1782, "GetClassNameA",                        NULL},
{12, 1783, "GetClassNameW",                        NULL},
{ 8, 1784, "GetClassWord",                         NULL},
{ 8, 1785, "GetClientRect",                        NULL},
{ 4, 1786, "GetClipCursor",                        NULL},
{ 4, 1787, "GetClipboardData",                     NULL},
{12, 1788, "GetClipboardFormatNameA",              NULL},
{12, 1789, "GetClipboardFormatNameW",              NULL},
{ 0, 1790, "GetClipboardOwner",                    NULL},
{ 0, 1791, "GetClipboardSequenceNumber",           NULL},
{ 0, 1792, "GetClipboardViewer",                   NULL},
{ 8, 1793, "GetComboBoxInfo",                      NULL},
{ 0, 1794, "GetCursor",                            NULL},
{ 0, 1795, "GetCursorFrameInfo",                   NULL},
{ 4, 1796, "GetCursorInfo",                        NULL},
{ 4, 1797, "GetCursorPos",                         NULL},
{ 4, 1798, "GetDC",                                NULL},
{12, 1799, "GetDCEx",                              NULL},
{ 0, 1800, "GetDesktopWindow",                     NULL},
{ 0, 1801, "GetDialogBaseUnits",                   NULL},
{ 0, 1802, "GetDisplayConfigBufferSizes",          NULL},
{ 4, 1803, "GetDlgCtrlID",                         NULL},
{ 8, 1804, "GetDlgItem",                           NULL},
{16, 1805, "GetDlgItemInt",                        NULL},
{16, 1806, "GetDlgItemTextA",                      NULL},
{16, 1807, "GetDlgItemTextW",                      NULL},
{ 0, 1808, "GetDoubleClickTime",                   NULL},
{ 0, 1809, "GetFocus",                             NULL},
{ 0, 1810, "GetForegroundWindow",                  user32_GetForegroundWindow},
{ 8, 1811, "GetGUIThreadInfo",                     NULL},
{ 0, 1812, "GetGestureConfig",                     NULL},
{ 0, 1813, "GetGestureExtraArgs",                  NULL},
{ 0, 1814, "GetGestureInfo",                       NULL},
{ 8, 1815, "GetGuiResources",                      NULL},
{ 8, 1816, "GetIconInfo",                          NULL},
{ 0, 1817, "GetIconInfoExA",                       NULL},
{ 0, 1818, "GetIconInfoExW",                       NULL},
{ 0, 1819, "GetInputDesktop",                      NULL},
{ 0, 1820, "GetInputLocaleInfo",                   NULL},
{ 0, 1821, "GetInputState",                        NULL},
{ 0, 1822, "GetInternalWindowPos",                 NULL},
{ 0, 1823, "GetKBCodePage",                        NULL},
{12, 1824, "GetKeyNameTextA",                      NULL},
{12, 1825, "GetKeyNameTextW",                      NULL},
{ 4, 1826, "GetKeyState",                          NULL},
{ 4, 1827, "GetKeyboardLayout",                    NULL},
{ 8, 1828, "GetKeyboardLayoutList",                NULL},
{ 4, 1829, "GetKeyboardLayoutNameA",               NULL},
{ 4, 1830, "GetKeyboardLayoutNameW",               NULL},
{ 4, 1831, "GetKeyboardState",                     NULL},
{ 4, 1832, "GetKeyboardType",                      NULL},
{ 4, 1833, "GetLastActivePopup",                   NULL},
{ 4, 1834, "GetLastInputInfo",                     NULL},
{ 0, 1835, "GetLayeredWindowAttributes",           NULL},
{ 4, 1836, "GetListBoxInfo",                       NULL},
{ 0, 1837, "GetMagnificationDesktopColorEffect",   NULL},
{ 0, 1838, "GetMagnificationDesktopMagnification", NULL},
{ 0, 1839, "GetMagnificationLensCtxInformation",   NULL},
{ 4, 1840, "GetMenu",                              NULL},
{16, 1841, "GetMenuBarInfo",                       NULL},
{ 0, 1842, "GetMenuCheckMarkDimensions",           NULL},
{ 4, 1843, "GetMenuContextHelpId",                 NULL},
{12, 1844, "GetMenuDefaultItem",                   NULL},
{ 8, 1845, "GetMenuInfo",                          NULL},
{ 4, 1846, "GetMenuItemCount",                     NULL},
{ 8, 1847, "GetMenuItemID",                        NULL},
{16, 1848, "GetMenuItemInfoA",                     NULL},
{16, 1849, "GetMenuItemInfoW",                     NULL},
{16, 1850, "GetMenuItemRect",                      NULL},
{12, 1851, "GetMenuState",                         NULL},
{20, 1852, "GetMenuStringA",                       NULL},
{20, 1853, "GetMenuStringW",                       NULL},
{16, 1854, "GetMessageA",                          NULL},
{ 0, 1855, "GetMessageExtraInfo",                  NULL},
{ 0, 1856, "GetMessagePos",                        NULL},
{ 0, 1857, "GetMessageTime",                       NULL},
{16, 1858, "GetMessageW",                          NULL},
{ 8, 1859, "GetMonitorInfoA",                      NULL},
{ 8, 1860, "GetMonitorInfoW",                      NULL},
{ 0, 1861, "GetMouseMovePointsEx",                 NULL},
{12, 1862, "GetNextDlgGroupItem",                  NULL},
{12, 1863, "GetNextDlgTabItem",                    NULL},
{ 0, 1864, "GetOpenClipboardWindow",               NULL},
{ 4, 1865, "GetParent",                            NULL},
{ 0, 1866, "GetPhysicalCursorPos",                 NULL},
{ 8, 1867, "GetPriorityClipboardFormat",           NULL},
{ 4, 1868, "GetProcessDefaultLayout",              NULL},
{ 0, 1869, "GetProcessWindowStation",              NULL},
{ 0, 1870, "GetProgmanWindow",                     NULL},
{ 8, 1871, "GetPropA",                             NULL},
{ 8, 1872, "GetPropW",                             NULL},
{ 4, 1873, "GetQueueStatus",                       NULL},
{ 0, 1874, "GetRawInputBuffer",                    NULL},
{ 0, 1875, "GetRawInputData",                      NULL},
{ 0, 1876, "GetRawInputDeviceInfoA",               NULL},
{ 0, 1877, "GetRawInputDeviceInfoW",               NULL},
{ 0, 1878, "GetRawInputDeviceList",                NULL},
{ 0, 1879, "GetReasonTitleFromReasonCode",         NULL},
{ 0, 1880, "GetRegisteredRawInputDevices",         NULL},
{12, 1881, "GetScrollBarInfo",                     NULL},
{12, 1882, "GetScrollInfo",                        NULL},
{ 8, 1883, "GetScrollPos",                         NULL},
{16, 1884, "GetScrollRange",                       NULL},
{ 0, 1885, "GetSendMessageReceiver",               NULL},
{ 0, 1886, "GetShellWindow",                       NULL},
{ 8, 1887, "GetSubMenu",                           NULL},
{ 4, 1888, "GetSysColor",                          NULL},
{ 4, 1889, "GetSysColorBrush",                     NULL},
{ 8, 1890, "GetSystemMenu",                        NULL},
{ 4, 1891, "GetSystemMetrics",                     NULL},
{20, 1892, "GetTabbedTextExtentA",                 NULL},
{20, 1893, "GetTabbedTextExtentW",                 NULL},
{ 0, 1894, "GetTaskmanWindow",                     NULL},
{ 4, 1895, "GetThreadDesktop",                     NULL},
{ 8, 1896, "GetTitleBarInfo",                      NULL},
{ 0, 1897, "GetTopLevelWindow",                    NULL},
{ 4, 1898, "GetTopWindow",                         user32_GetTopWindow},
{ 0, 1899, "GetTouchInputInfo",                    NULL},
{12, 1900, "GetUpdateRect",                        NULL},
{12, 1901, "GetUpdateRgn",                         NULL},
{ 0, 1902, "GetUpdatedClipboardFormats",           NULL},
{20, 1903, "GetUserObjectInformationA",            NULL},
{20, 1904, "GetUserObjectInformationW",            NULL},
{20, 1905, "GetUserObjectSecurity",                NULL},
{ 0, 1906, "GetWinStationInfo",                    NULL},
{ 8, 1907, "GetWindow",                            NULL},
{ 0, 1908, "GetWindowCompositionAttribute",        NULL},
{ 0, 1909, "GetWindowCompositionInfo",             NULL},
{ 4, 1910, "GetWindowContextHelpId",               NULL},
{ 4, 1911, "GetWindowDC",                          NULL},
{ 0, 1912, "GetWindowDisplayAffinity",             NULL},
{ 8, 1913, "GetWindowInfo",                        NULL},
{ 8, 1914, "GetWindowLongA",                       NULL},
{ 8, 1915, "GetWindowLongW",                       NULL},
{ 0, 1916, "GetWindowMinimizeRect",                NULL},
{12, 1917, "GetWindowModuleFileName",              NULL},
{12, 1918, "GetWindowModuleFileNameA",             NULL},
{12, 1919, "GetWindowModuleFileNameW",             NULL},
{ 8, 1920, "GetWindowPlacement",                   NULL},
{ 8, 1921, "GetWindowRect",                        NULL},
{ 8, 1922, "GetWindowRgn",                         NULL},
{ 0, 1923, "GetWindowRgnBox",                      NULL},
{ 0, 1924, "GetWindowRgnEx",                       NULL},
{12, 1925, "GetWindowTextA",                       NULL},
{ 4, 1926, "GetWindowTextLengthA",                 NULL},
{ 4, 1927, "GetWindowTextLengthW",                 NULL},
{12, 1928, "GetWindowTextW",                       NULL},
{ 8, 1929, "GetWindowThreadProcessId",             NULL},
{ 8, 1930, "GetWindowWord",                        NULL},
{ 0, 1931, "GhostWindowFromHungWindow",            NULL},
{36, 1932, "GrayStringA",                          NULL},
{36, 1933, "GrayStringW",                          NULL},
{ 4, 1934, "HideCaret",                            NULL},
{16, 1935, "HiliteMenuItem",                       NULL},
{ 0, 1936, "HungWindowFromGhostWindow",            NULL},
{ 8, 1937, "IMPGetIMEA",                           NULL},
{ 8, 1938, "IMPGetIMEW",                           NULL},
{ 4, 1939, "IMPQueryIMEA",                         NULL},
{ 4, 1940, "IMPQueryIMEW",                         NULL},
{ 8, 1941, "IMPSetIMEA",                           NULL},
{ 8, 1942, "IMPSetIMEW",                           NULL},
{ 8, 1943, "ImpersonateDdeClientWindow",           NULL},
{ 0, 1944, "InSendMessage",                        NULL},
{ 4, 1945, "InSendMessageEx",                      NULL},
{12, 1946, "InflateRect",                          NULL},
{ 0, 1947, "InitializeLpkHooks",                   NULL},
{20, 1948, "InsertMenuA",                          NULL},
{16, 1949, "InsertMenuItemA",                      NULL},
{16, 1950, "InsertMenuItemW",                      NULL},
{20, 1951, "InsertMenuW",                          NULL},
{ 0, 1952, "InternalGetWindowIcon",                NULL},
{ 0, 1953, "InternalGetWindowText",                NULL},
{12, 1954, "IntersectRect",                        NULL},
{12, 1955, "InvalidateRect",                       NULL},
{12, 1956, "InvalidateRgn",                        NULL},
{ 8, 1957, "InvertRect",                           NULL},
{ 4, 1958, "IsCharAlphaA",                         NULL},
{ 4, 1959, "IsCharAlphaNumericA",                  NULL},
{ 4, 1960, "IsCharAlphaNumericW",                  NULL},
{ 4, 1961, "IsCharAlphaW",                         NULL},
{ 4, 1962, "IsCharLowerA",                         NULL},
{ 4, 1963, "IsCharLowerW",                         NULL},
{ 4, 1964, "IsCharUpperA",                         NULL},
{ 4, 1965, "IsCharUpperW",                         NULL},
{ 8, 1966, "IsChild",                              NULL},
{ 4, 1967, "IsClipboardFormatAvailable",           NULL},
{ 8, 1968, "IsDialogMessage",                      NULL},
{ 8, 1969, "IsDialogMessageA",                     NULL},
{ 8, 1970, "IsDialogMessageW",                     NULL},
{ 8, 1971, "IsDlgButtonChecked",                   NULL},
{ 0, 1972, "IsGUIThread",                          NULL},
{ 0, 1973, "IsHungAppWindow",                      NULL},
{ 4, 1974, "IsIconic",                             NULL},
{ 4, 1975, "IsMenu",                               NULL},
{ 0, 1976, "IsProcessDPIAware",                    NULL},
{ 4, 1977, "IsRectEmpty",                          NULL},
{ 0, 1978, "IsSETEnabled",                         NULL},
{ 0, 1979, "IsServerSideWindow",                   NULL},
{ 0, 1980, "IsThreadDesktopComposited",            NULL},
{ 0, 1981, "IsTopLevelWindow",                     NULL},
{ 0, 1982, "IsTouchWindow",                        NULL},
{ 0, 1983, "IsWinEventHookInstalled",              NULL},
{ 4, 1984, "IsWindow",                             NULL},
{ 4, 1985, "IsWindowEnabled",                      NULL},
{ 0, 1986, "IsWindowInDestroy",                    NULL},
{ 0, 1987, "IsWindowRedirectedForPrint",           NULL},
{ 4, 1988, "IsWindowUnicode",                      NULL},
{ 4, 1989, "IsWindowVisible",                      NULL},
{ 0, 1990, "IsWow64Message",                       NULL},
{ 4, 1991, "IsZoomed",                             NULL},
{ 8, 1992, "KillTimer",                            NULL},
{ 8, 1993, "LoadAcceleratorsA",                    NULL},
{ 8, 1994, "LoadAcceleratorsW",                    NULL},
{ 8, 1995, "LoadBitmapA",                          NULL},
{ 8, 1996, "LoadBitmapW",                          NULL},
{ 8, 1997, "LoadCursorA",                          NULL},
{ 4, 1998, "LoadCursorFromFileA",                  NULL},
{ 4, 1999, "LoadCursorFromFileW",                  NULL},
{ 8, 2003, "LoadCursorW",                          NULL},
{ 8, 2004, "LoadIconA",                            NULL},
{ 8, 2006, "LoadIconW",                            NULL},
{24, 2007, "LoadImageA",                           NULL},
{24, 2008, "LoadImageW",                           NULL},
{ 8, 2009, "LoadKeyboardLayoutA",                  NULL},
{ 0, 2010, "LoadKeyboardLayoutEx",                 NULL},
{ 8, 2011, "LoadKeyboardLayoutW",                  NULL},
{ 0, 2012, "LoadLocalFonts",                       NULL},
{ 8, 2013, "LoadMenuA",                            NULL},
{ 4, 2014, "LoadMenuIndirectA",                    NULL},
{ 4, 2015, "LoadMenuIndirectW",                    NULL},
{ 8, 2016, "LoadMenuW",                            NULL},
{ 0, 2017, "LoadRemoteFonts",                      NULL},
{16, 2018, "LoadStringA",                          NULL},
{16, 2019, "LoadStringW",                          NULL},
{ 0, 2020, "LockSetForegroundWindow",              NULL},
{ 0, 2021, "LockWindowStation",                    NULL},
{ 4, 2022, "LockWindowUpdate",                     NULL},
{ 0, 2023, "LockWorkStation",                      NULL},
{ 0, 2024, "LogicalToPhysicalPoint",               NULL},
{ 8, 2025, "LookupIconIdFromDirectory",            NULL},
{20, 2026, "LookupIconIdFromDirectoryEx",          NULL},
{ 0, 2027, "MBToWCSEx",                            NULL},
{ 0, 2028, "MB_GetString",                         NULL},
{ 8, 2029, "MapDialogRect",                        NULL},
{ 8, 2030, "MapVirtualKeyA",                       NULL},
{12, 2031, "MapVirtualKeyExA",                     NULL},
{12, 2032, "MapVirtualKeyExW",                     NULL},
{ 8, 2033, "MapVirtualKeyW",                       NULL},
{16, 2034, "MapWindowPoints",                      NULL},
{16, 2035, "MenuItemFromPoint",                    NULL},
{ 0, 2036, "MenuWindowProcA",                      NULL},
{ 0, 2037, "MenuWindowProcW",                      NULL},
{ 4, 2038, "MessageBeep",                          NULL},
{16, 2039, "MessageBoxA",                          user32_MessageBoxA},
{20, 2040, "MessageBoxExA",                        NULL},
{20, 2041, "MessageBoxExW",                        NULL},
{ 4, 2042, "MessageBoxIndirectA",                  NULL},
{ 4, 2043, "MessageBoxIndirectW",                  NULL},
{ 0, 2044, "MessageBoxTimeoutA",                   NULL},
{ 0, 2045, "MessageBoxTimeoutW",                   NULL},
{16, 2046, "MessageBoxW",                          user32_MessageBoxW},
{20, 2047, "ModifyMenuA",                          NULL},
{20, 2048, "ModifyMenuW",                          NULL},
{12, 2049, "MonitorFromPoint",                     NULL},
{ 8, 2050, "MonitorFromRect",                      NULL},
{ 8, 2051, "MonitorFromWindow",                    NULL},
{24, 2052, "MoveWindow",                           NULL},
{20, 2053, "MsgWaitForMultipleObjects",            NULL},
{20, 2054, "MsgWaitForMultipleObjectsEx",          NULL},
{ 0, 2055, "NotifyOverlayWindow",                  NULL},
{16, 2056, "NotifyWinEvent",                       NULL},
{ 4, 2057, "OemKeyScan",                           NULL},
{ 8, 2058, "OemToCharA",                           NULL},
{12, 2059, "OemToCharBuffA",                       NULL},
{12, 2060, "OemToCharBuffW",                       NULL},
{ 8, 2061, "OemToCharW",                           NULL},
{12, 2062, "OffsetRect",                           NULL},
{ 4, 2063, "OpenClipboard",                        NULL},
{16, 2064, "OpenDesktopA",                         NULL},
{16, 2065, "OpenDesktopW",                         NULL},
{ 4, 2066, "OpenIcon",                             NULL},
{12, 2067, "OpenInputDesktop",                     NULL},
{ 0, 2068, "OpenThreadDesktop",                    NULL},
{12, 2069, "OpenWindowStationA",                   NULL},
{12, 2070, "OpenWindowStationW",                   NULL},
{12, 2071, "PackDDElParam",                        NULL},
{ 4, 2072, "PaintDesktop",                         NULL},
{ 0, 2073, "PaintMenuBar",                         NULL},
{ 0, 2074, "PaintMonitor",                         NULL},
{20, 2075, "PeekMessageA",                         NULL},
{20, 2076, "PeekMessageW",                         NULL},
{ 0, 2077, "PhysicalToLogicalPoint",               NULL},
{16, 2078, "PostMessageA",                         NULL},
{16, 2079, "PostMessageW",                         NULL},
{ 4, 2080, "PostQuitMessage",                      NULL},
{16, 2081, "PostThreadMessageA",                   NULL},
{16, 2082, "PostThreadMessageW",                   NULL},
{ 0, 2083, "PrintWindow",                          NULL},
{ 0, 2084, "PrivateExtractIconExA",                NULL},
{ 0, 2085, "PrivateExtractIconExW",                NULL},
{ 0, 2086, "PrivateExtractIconsA",                 NULL},
{ 0, 2087, "PrivateExtractIconsW",                 NULL},
{ 0, 2088, "PrivateRegisterICSProc",               NULL},
{12, 2089, "PtInRect",                             NULL},
{ 0, 2090, "QueryDisplayConfig",                   NULL},
{ 0, 2091, "QuerySendMessage",                     NULL},
{12, 2092, "RealChildWindowFromPoint",             NULL},
{12, 2093, "RealGetWindowClass",                   NULL},
{12, 2094, "RealGetWindowClassA",                  NULL},
{12, 2095, "RealGetWindowClassW",                  NULL},
{ 0, 2096, "ReasonCodeNeedsBugID",                 NULL},
{ 0, 2097, "ReasonCodeNeedsComment",               NULL},
{ 0, 2098, "RecordShutdownReason",                 NULL},
{16, 2099, "RedrawWindow",                         NULL},
{ 4, 2100, "RegisterClassA",                       NULL},
{ 4, 2101, "RegisterClassExA",                     NULL},
{ 4, 2102, "RegisterClassExW",                     NULL},
{ 4, 2103, "RegisterClassW",                       NULL},
{ 4, 2104, "RegisterClipboardFormatA",             NULL},
{ 4, 2105, "RegisterClipboardFormatW",             NULL},
{12, 2106, "RegisterDeviceNotificationA",          NULL},
{12, 2107, "RegisterDeviceNotificationW",          NULL},
{ 0, 2108, "RegisterErrorReportingDialog",         NULL},
{ 0, 2109, "RegisterFrostWindow",                  NULL},
{ 0, 2110, "RegisterGhostWindow",                  NULL},
{16, 2111, "RegisterHotKey",                       NULL},
{ 0, 2112, "RegisterLogonProcess",                 NULL},
{ 0, 2113, "RegisterMessagePumpHook",              NULL},
{ 0, 2114, "RegisterPowerSettingNotification",     NULL},
{ 0, 2115, "RegisterRawInputDevices",              NULL},
{ 0, 2116, "RegisterServicesProcess",              NULL},
{ 0, 2117, "RegisterSessionPort",                  NULL},
{ 0, 2118, "RegisterShellHookWindow",              NULL},
{ 0, 2119, "RegisterSystemThread",                 NULL},
{ 0, 2120, "RegisterTasklist",                     NULL},
{ 0, 2121, "RegisterTouchWindow",                  NULL},
{ 0, 2122, "RegisterUserApiHook",                  NULL},
{ 4, 2123, "RegisterWindowMessageA",               NULL},
{ 4, 2124, "RegisterWindowMessageW",               NULL},
{ 0, 2125, "ReleaseCapture",                       NULL},
{ 8, 2126, "ReleaseDC",                            NULL},
{ 0, 2127, "RemoveClipboardFormatListener",        NULL},
{12, 2128, "RemoveMenu",                           NULL},
{ 8, 2129, "RemovePropA",                          NULL},
{ 8, 2130, "RemovePropW",                          NULL},
{ 4, 2131, "ReplyMessage",                         NULL},
{ 0, 2132, "ResolveDesktopForWOW",                 NULL},
{20, 2133, "ReuseDDElParam",                       NULL},
{ 8, 2134, "ScreenToClient",                       NULL},
{12, 2135, "ScrollChildren",                       NULL},
{28, 2136, "ScrollDC",                             NULL},
{20, 2137, "ScrollWindow",                         NULL},
{32, 2138, "ScrollWindowEx",                       NULL},
{20, 2139, "SendDlgItemMessageA",                  NULL},
{20, 2140, "SendDlgItemMessageW",                  NULL},
{ 8, 2141, "SendIMEMessageExA",                    NULL},
{ 8, 2142, "SendIMEMessageExW",                    NULL},
{12, 2143, "SendInput",                            NULL},
{16, 2144, "SendMessageA",                         NULL},
{24, 2145, "SendMessageCallbackA",                 NULL},
{24, 2146, "SendMessageCallbackW",                 NULL},
{28, 2147, "SendMessageTimeoutA",                  NULL},
{28, 2148, "SendMessageTimeoutW",                  NULL},
{16, 2149, "SendMessageW",                         NULL},
{16, 2150, "SendNotifyMessageA",                   NULL},
{16, 2151, "SendNotifyMessageW",                   NULL},
{ 4, 2152, "SetActiveWindow",                      NULL},
{ 4, 2153, "SetCapture",                           NULL},
{ 4, 2154, "SetCaretBlinkTime",                    NULL},
{ 8, 2155, "SetCaretPos",                          NULL},
{12, 2156, "SetClassLongA",                        NULL},
{12, 2157, "SetClassLongW",                        NULL},
{12, 2158, "SetClassWord",                         NULL},
{ 8, 2159, "SetClipboardData",                     NULL},
{ 4, 2160, "SetClipboardViewer",                   NULL},
{ 4, 2161, "SetCursor",                            NULL},
{ 0, 2162, "SetCursorContents",                    NULL},
{ 8, 2163, "SetCursorPos",                         NULL},
{ 4, 2164, "SetDebugErrorLevel",                   NULL},
{ 4, 2165, "SetDeskWallpaper",                     NULL},
{ 0, 2166, "SetDisplayConfig",                     NULL},
{16, 2167, "SetDlgItemInt",                        NULL},
{12, 2168, "SetDlgItemTextA",                      NULL},
{12, 2169, "SetDlgItemTextW",                      NULL},
{ 4, 2170, "SetDoubleClickTime",                   NULL},
{ 4, 2171, "SetFocus",                             NULL},
{ 4, 2172, "SetForegroundWindow",                  NULL},
{ 0, 2173, "SetGestureConfig",                     NULL},
{ 0, 2174, "SetInternalWindowPos",                 NULL},
{ 4, 2175, "SetKeyboardState",                     NULL},
{ 8, 2176, "SetLastErrorEx",                       NULL},
{ 0, 2177, "SetLayeredWindowAttributes",           NULL},
{ 0, 2178, "SetMagnificationDesktopColorEffect",   NULL},
{ 0, 2179, "SetMagnificationDesktopMagnification", NULL},
{ 0, 2180, "SetMagnificationLensCtxInformation",   NULL},
{ 8, 2181, "SetMenu",                              NULL},
{ 8, 2182, "SetMenuContextHelpId",                 NULL},
{12, 2183, "SetMenuDefaultItem",                   NULL},
{ 8, 2184, "SetMenuInfo",                          NULL},
{20, 2185, "SetMenuItemBitmaps",                   NULL},
{16, 2186, "SetMenuItemInfoA",                     NULL},
{16, 2187, "SetMenuItemInfoW",                     NULL},
{ 4, 2188, "SetMessageExtraInfo",                  NULL},
{ 4, 2189, "SetMessageQueue",                      NULL},
{ 0, 2190, "SetMirrorRendering",                   NULL},
{ 8, 2191, "SetParent",                            NULL},
{ 0, 2192, "SetPhysicalCursorPos",                 NULL},
{ 0, 2193, "SetProcessDPIAware",                   NULL},
{ 4, 2194, "SetProcessDefaultLayout",              NULL},
{ 4, 2195, "SetProcessWindowStation",              NULL},
{ 0, 2196, "SetProgmanWindow",                     NULL},
{12, 2197, "SetPropA",                             NULL},
{12, 2198, "SetPropW",                             NULL},
{20, 2199, "SetRect",                              NULL},
{ 4, 2200, "SetRectEmpty",                         NULL},
{16, 2201, "SetScrollInfo",                        NULL},
{16, 2202, "SetScrollPos",                         NULL},
{20, 2203, "SetScrollRange",                       NULL},
{ 4, 2204, "SetShellWindow",                       NULL},
{ 0, 2205, "SetShellWindowEx",                     NULL},
{12, 2206, "SetSysColors",                         NULL},
{ 0, 2207, "SetSysColorsTemp",                     NULL},
{ 8, 2208, "SetSystemCursor",                      NULL},
{ 8, 2209, "SetSystemMenu",                        NULL},
{ 0, 2210, "SetTaskmanWindow",                     NULL},
{ 4, 2211, "SetThreadDesktop",                     NULL},
{16, 2212, "SetTimer",                             NULL},
{16, 2213, "SetUserObjectInformationA",            NULL},
{16, 2214, "SetUserObjectInformationW",            NULL},
{12, 2215, "SetUserObjectSecurity",                NULL},
{28, 2216, "SetWinEventHook",                      NULL},
{ 0, 2217, "SetWindowCompositionAttribute",        NULL},
{ 8, 2218, "SetWindowContextHelpId",               NULL},
{ 0, 2219, "SetWindowDisplayAffinity",             NULL},
{12, 2220, "SetWindowLongA",                       NULL},
{12, 2221, "SetWindowLongW",                       NULL},
{ 8, 2222, "SetWindowPlacement",                   NULL},
{28, 2223, "SetWindowPos",                         NULL},
{12, 2224, "SetWindowRgn",                         NULL},
{ 0, 2225, "SetWindowRgnEx",                       NULL},
{ 0, 2226, "SetWindowStationUser",                 NULL},
{ 8, 2227, "SetWindowTextA",                       NULL},
{ 8, 2228, "SetWindowTextW",                       NULL},
{12, 2229, "SetWindowWord",                        NULL},
{ 8, 2230, "SetWindowsHookA",                      NULL},
{16, 2231, "SetWindowsHookExA",                    NULL},
{16, 2232, "SetWindowsHookExW",                    NULL},
{ 8, 2233, "SetWindowsHookW",                      NULL},
{ 0, 2234, "SfmDxBindSwapChain",                   NULL},
{ 0, 2235, "SfmDxGetSwapChainStats",               NULL},
{ 0, 2236, "SfmDxOpenSwapChain",                   NULL},
{ 0, 2237, "SfmDxQuerySwapChainBindingStatus",     NULL},
{ 0, 2238, "SfmDxReleaseSwapChain",                NULL},
{ 0, 2239, "SfmDxReportPendingBindingsToDwm",      NULL},
{ 0, 2240, "SfmDxSetSwapChainBindingStatus",       NULL},
{ 0, 2241, "SfmDxSetSwapChainStats",               NULL},
{ 4, 2242, "ShowCaret",                            NULL},
{ 4, 2243, "ShowCursor",                           NULL},
{ 8, 2244, "ShowOwnedPopups",                      NULL},
{12, 2245, "ShowScrollBar",                        NULL},
{ 0, 2246, "ShowStartGlass",                       NULL},
{ 0, 2247, "ShowSystemCursor",                     NULL},
{ 8, 2248, "ShowWindow",                           NULL},
{ 8, 2249, "ShowWindowAsync",                      NULL},
{ 0, 2250, "ShutdownBlockReasonCreate",            NULL},
{ 0, 2251, "ShutdownBlockReasonDestroy",           NULL},
{ 0, 2252, "ShutdownBlockReasonQuery",             NULL},
{ 0, 2253, "SoftModalMessageBox",                  NULL},
{ 0, 2254, "SoundSentry",                          NULL},
{12, 2255, "SubtractRect",                         NULL},
{ 4, 2256, "SwapMouseButton",                      NULL},
{ 4, 2257, "SwitchDesktop",                        NULL},
{ 0, 2258, "SwitchDesktopWithFade",                NULL},
{ 0, 2259, "SwitchToThisWindow",                   NULL},
{16, 2260, "SystemParametersInfoA",                NULL},
{16, 2261, "SystemParametersInfoW",                NULL},
{32, 2262, "TabbedTextOutA",                       NULL},
{32, 2263, "TabbedTextOutW",                       NULL},
{ 8, 2264, "TileChildWindows",                     NULL},
{20, 2265, "TileWindows",                          NULL},
{20, 2266, "ToAscii",                              NULL},
{24, 2267, "ToAsciiEx",                            NULL},
{24, 2268, "ToUnicode",                            NULL},
{28, 2269, "ToUnicodeEx",                          NULL},
{ 4, 2270, "TrackMouseEvent",                      NULL},
{28, 2271, "TrackPopupMenu",                       NULL},
{24, 2272, "TrackPopupMenuEx",                     NULL},
{12, 2273, "TranslateAccelerator",                 NULL},
{12, 2274, "TranslateAcceleratorA",                NULL},
{12, 2275, "TranslateAcceleratorW",                NULL},
{ 8, 2276, "TranslateMDISysAccel",                 NULL},
{ 4, 2277, "TranslateMessage",                     NULL},
{ 0, 2278, "TranslateMessageEx",                   NULL},
{ 4, 2279, "UnhookWinEvent",                       NULL},
{ 8, 2280, "UnhookWindowsHook",                    NULL},
{ 4, 2281, "UnhookWindowsHookEx",                  NULL},
{12, 2282, "UnionRect",                            NULL},
{ 4, 2283, "UnloadKeyboardLayout",                 NULL},
{ 0, 2284, "UnlockWindowStation",                  NULL},
{16, 2285, "UnpackDDElParam",                      NULL},
{ 8, 2286, "UnregisterClassA",                     NULL},
{ 8, 2287, "UnregisterClassW",                     NULL},
{ 4, 2288, "UnregisterDeviceNotification",         NULL},
{ 8, 2289, "UnregisterHotKey",                     NULL},
{ 0, 2290, "UnregisterMessagePumpHook",            NULL},
{ 0, 2291, "UnregisterPowerSettingNotification",   NULL},
{ 0, 2292, "UnregisterSessionPort",                NULL},
{ 0, 2293, "UnregisterTouchWindow",                NULL},
{ 0, 2294, "UnregisterUserApiHook",                NULL},
{36, 2295, "UpdateLayeredWindow",                  NULL},
{ 0, 2296, "UpdateLayeredWindowIndirect",          NULL},
{ 0, 2297, "UpdatePerUserSystemParameters",        NULL},
{ 4, 2298, "UpdateWindow",                         NULL},
{ 0, 2299, "UpdateWindowTransform",                NULL},
{ 0, 2300, "User32InitializeImmEntryTable",        NULL},
{ 0, 2301, "UserClientDllInitialize",              NULL},
{12, 2302, "UserHandleGrantAccess",                NULL},
{ 0, 2303, "UserLpkPSMTextOut",                    NULL},
{ 0, 2304, "UserLpkTabbedTextOut",                 NULL},
{ 0, 2305, "UserRealizePalette",                   NULL},
{ 0, 2306, "UserRegisterWowHandlers",              NULL},
{ 0, 2307, "VRipOutput",                           NULL},
{ 0, 2308, "VTagOutput",                           NULL},
{ 8, 2309, "ValidateRect",                         NULL},
{ 8, 2310, "ValidateRgn",                          NULL},
{ 4, 2311, "VkKeyScanA",                           NULL},
{ 8, 2312, "VkKeyScanExA",                         NULL},
{ 8, 2313, "VkKeyScanExW",                         NULL},
{ 4, 2314, "VkKeyScanW",                           NULL},
{ 0, 2315, "WCSToMBEx",                            NULL},
{ 8, 2316, "WINNLSEnableIME",                      NULL},
{ 4, 2317, "WINNLSGetEnableStatus",                NULL},
{ 4, 2318, "WINNLSGetIMEHotkey",                   NULL},
{ 8, 2319, "WaitForInputIdle",                     NULL},
{ 0, 2320, "WaitMessage",                          NULL},
{16, 2321, "WinHelpA",                             NULL},
{16, 2322, "WinHelpW",                             NULL},
{ 4, 2323, "WindowFromDC",                         NULL},
{ 0, 2324, "WindowFromPhysicalPoint",              NULL},
{ 8, 2325, "WindowFromPoint",                      NULL},
{ 0, 2326, "_UserTestTokenForInteractive",         NULL},
{ 0, 2327, "gSharedInfo",                          NULL},
{ 0, 2328, "gapfnScSendMessage",                   NULL},
{16, 2329, "keybd_event",                          NULL},
{20, 2330, "mouse_event",                          NULL},
{ 0, 2331, "wsprintfA",                            NULL},
{ 0, 2332, "wsprintfW",                            NULL},
{12, 2333, "wvsprintfA",                           NULL},
{12, 2334, "wvsprintfW",                           NULL},
{G_MAXINT, 0, NULL, NULL}};
