/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MESSAGE_H__
#define __MESSAGE_H__


#include "ia32.h"


G_BEGIN_DECLS


#define IA32_MESSAGE_MNEMONIC 0x00000001
#define IA32_MESSAGE_REGISTER 0x00000002
#define IA32_MESSAGE_HEX     0
#define IA32_MESSAGE_DEC     1
#define IA32_MESSAGE_STRING  2
#define IA32_MESSAGE_STRINGW 3


/******************************************************************************
*                                                                             *
* ja:メッセージ記録関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:エラーメッセージを記録する
    thread,スレッド構造体
       str,メッセージ                                                       */
void
ia32_message_record_error (Ia32Thread  *thread,
                           const gchar *str);


/*  ja:例外エラーを記録する
    thread,スレッド構造体
    vector,割り込みベクタ                                                   */
void
ia32_message_record_exception (Ia32Thread *thread,
                               const gint  vector);


/*  ja:API呼び出しを記録する
    thread,スレッド構造体
       str,API呼び出し                                                      */
void
ia32_message_record_api (Ia32Thread  *thread,
                         const gchar *str);


/*  ja:API呼び出しを記録する
    thread,スレッド構造体
      name,APIの名前                                                        */
void
ia32_message_record_api_with_argument (Ia32Thread  *thread,
                                       const gchar *name,
                                       ...);


/*  ja:レジスタの内容を記録/表示する
    thread,スレッド構造体
      tail,記録するステップ数(0:随時出力)
     flags,フラグ                                                           */
void
ia32_message_record_trace (Ia32Thread  *thread,
                           const gint   tail,
                           const guint  flags);


/******************************************************************************
*                                                                             *
* ja:メッセージ表示関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:レジスタの内容を表示する
        fp,ファイルポインタ
    thread,スレッド構造体                                                   */
void
ia32_message_disp_trace (FILE        *fp,
                         Ia32Thread *thread);


/*  ja:情報を表示する
         fp,ファイルポインタ
    process,プロセス構造体
    verbose,TRUE:詳細表示,FALSE:簡易表示
    appname,アプリケーション名                                              */
void
ia32_message_disp_info (FILE           *fp,
                        Ia32Process    *process,
                        const gboolean  verbose,
                        const gchar    *appname);


/*  ja:情報をHTMLで表示する
         fp,ファイルポインタ
    process,プロセス構造体
    appname,アプリケーション名                                              */
void
ia32_message_disp_html (FILE        *fp,
                        Ia32Process *process,
                        const gchar *appname);


G_END_DECLS


#endif /* __MESSAGE_H__ */
