/*
    IA32
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __IA32_H__
#define __IA32_H__


#include "gcommon/gcommon.h"


G_BEGIN_DECLS


#define IA32_MEMORY_NULL ((guint32)-1)

#define IA32_SYSTEM_PAGESIZE 0x1000
#define IA32_SYSTEM_MEMORY   ((gulonglong)G_MAXUINT32+1)

#define IA32_ERR_DE  0  /* Divide Error */
#define IA32_ERR_DB  1  /* Debug */
                        /* NMI Interrupt */
#define IA32_ERR_BP  3  /* Breakpoint */
#define IA32_ERR_OF  4  /* Overflow */
#define IA32_ERR_BR  5  /* Bound Range Exceeded */
#define IA32_ERR_UD  6  /* Invalid Opcode */
#define IA32_ERR_NM  7  /* Device Not Available */
#define IA32_ERR_DF  8  /* Double Fault */
                        /* CoProcessor Segment Overrun */
#define IA32_ERR_TS 10  /* Invalid TSS */
#define IA32_ERR_NP 11  /* Segment Not Present */
#define IA32_ERR_SS 12  /* Stack Segment Fault */
#define IA32_ERR_GP 13  /* General Protection */
#define IA32_ERR_PF 14  /* Page Fault */
                        /* Reserved */
#define IA32_ERR_MF 16  /* Floating-Point Error */
#define IA32_ERR_AC 17  /* Alignment Check */
#define IA32_ERR_MC 18  /* Machine Check */
#define IA32_ERR_XM 19  /* SIMD Floating-Point Exception */
#define IA32_ERR_NULL (-1)


typedef struct _Ia32Register
{
  guint32 eax, ecx, edx, ebx, esp, ebp, esi, edi, eip;
  guint32 eflags;
  guint16 cs, ds, es, fs, gs, ss;
  struct _Ia32RegisterDesc
  {
    guint16 limit;
    guint32 base;
  } gdtr;
} Ia32Register;
typedef struct _Ia32Thread
{
  guint id;
  gboolean terminate;
  guint32 exitcode;
  GList *api, *err, *trace;
  Ia32Register reg;
  struct _Ia32Process *process;
} Ia32Thread;
typedef struct _Ia32Process
{
  guint id;
  gint8 level;
  guint8 *image;
  guint8 map[IA32_SYSTEM_MEMORY / IA32_SYSTEM_PAGESIZE];
  guint32 address;
  guint32 winmain;
  guint32 exitcode;
  gchar **argv;
  GList *thread;
  GList *memory;
  GList *module;
  GHashTable *export, *system;
  struct _Ia32Thread *current;
  struct _Ia32NameTable *table;
} Ia32Process;
typedef gboolean (*Ia32SystemFunction) (Ia32Thread *);
typedef struct _Ia32Export
{
  gint argument;
  guint16 ordinal;
  gchar *name;
  Ia32SystemFunction func;
} Ia32Export;
typedef struct _Ia32Api
{
  const gchar *file;
  const gchar *name;
  guint16 ordinal;
  Ia32SystemFunction func;
} Ia32Api;
typedef struct _Ia32NameTable
{
  guint32 address;
  const gchar *file;
  const gchar *name;
  guint16 ordinal;
} Ia32NameTable;
typedef struct _Ia32BreakPoint
{
  guint32 start;
  guint32 end;
} Ia32BreakPoint;


G_END_DECLS


#endif /* __IA32_H__ */
