/*
    gcommon
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __GLIBMEMORY_H__
#define __GLIBMEMORY_H__


#include "gcommon.h"


G_BEGIN_DECLS


/******************************************************************************
* Memory Allocation                                                           *
******************************************************************************/
#ifdef USE_GTK_EMULATE
gpointer g_malloc (gsize n_bytes);
gpointer g_malloc0 (gsize n_bytes);
gpointer g_realloc (gpointer mem, gsize n_bytes);
gpointer g_try_malloc (gsize n_bytes);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,8,0)
gpointer g_try_malloc0 (gsize n_bytes);
#endif /* not GLIB_CHECK_VERSION(2,8,0) */
#ifdef USE_GTK_EMULATE
gpointer g_try_realloc (gpointer mem, gsize n_bytes);
#endif /* USE_GTK_EMULATE */
#if ! GLIB_CHECK_VERSION(2,24,0)
gpointer g_malloc_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_malloc0_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_realloc_n (gpointer mem, gsize n_blocks, gsize n_block_bytes);
gpointer g_try_malloc_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_try_malloc0_n (gsize n_blocks, gsize n_block_bytes);
gpointer g_try_realloc_n (gpointer mem, gsize n_blocks, gsize n_block_bytes);
#endif /* not GLIB_CHECK_VERSION(2,24,0) */
#ifdef USE_GTK_EMULATE
void g_free (gpointer mem);
gpointer g_memmove (gpointer dest, gconstpointer src, gsize len);
gpointer g_memdup (gconstpointer mem, guint byte_size);
#endif /* USE_GTK_EMULATE */


G_END_DECLS


#endif /* __GLIBMEMORY_H__ */
