/*
    IA32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __MODULE_H__
#define __MODULE_H__


#include "ia32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:モジュール関数群                                                         *
*                                                                             *
******************************************************************************/
/*  ja:既にロードされているイメージを取得する
    process,プロセス
       file,イメージ名
        RET,イメージ,IA32_MEMORY_NULL:ロードされていない                    */
guint32
ia32_module_get_library (Ia32Process *process,
                         const gchar *file);


/*  ja:イメージをロードする
    process,プロセス
       file,イメージ名
        RET,イメージ,IA32_MEMORY_NULL:エラー                                */
guint32
ia32_module_load_library (Ia32Process *process,
                          const gchar *file);


/*  ja:イメージを解放する
    process,プロセス
    address,イメージ
        RET,TRUE:正常終了,FALSE:エラー                                      */
gboolean
ia32_module_free_library (Ia32Process   *process,
                          const guint32  address);


/*  ja:イメージの名前を取得する
    process,プロセス
    address,イメージ
        RET,名前,NULL:エラー                                                */
const gchar *
ia32_module_get_filename (Ia32Process   *process,
                          const guint32  address);


/*  ja:プロセスのイメージ一覧を取得する
    process,プロセス
        RET,リスト,NULL:エラー                                              */
GList *
ia32_module_get_list (Ia32Process *process);


G_END_DECLS


#endif /* __MODULE_H__ */
