/*
    disw32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ordinal.h"


/******************************************************************************
*                                                                             *
* ja:オーディナル関数                                                         *
*                                                                             *
******************************************************************************/
typedef struct _Dw32Ordinal
{
  const gint ordinal;
  const gchar *name;
} Dw32Ordinal;


static Dw32Ordinal aclui[] = {
    {1, "CreateSecurityPage"},
    {2, "EditSecurity"},
    {3, "EditSecurityAdvanced"},
    {16, "IID_ISecurityInformation"},
    {0, NULL}};
static Dw32Ordinal activeds[] = {
    {4, "ADsBuildEnumerator"},
    {8, "ADsBuildVarArrayInt"},
    {7, "ADsBuildVarArrayStr"},
    {24, "ADsDecodeBinaryData"},
    {20, "ADsEncodeBinaryData"},
    {6, "ADsEnumerateNext"},
    {5, "ADsFreeEnumerator"},
    {13, "ADsGetLastError"},
    {3, "ADsGetObject"},
    {9, "ADsOpenObject"},
    {12, "ADsSetLastError"},
    {23, "AdsFreeAdsValues"},
    {22, "AdsTypeToPropVariant"},
    {25, "AdsTypeToPropVariant2"},
    {14, "AllocADsMem"},
    {17, "AllocADsStr"},
    {29, "BinarySDToSecurityDescriptor"},
    {27, "ConvertSecDescriptorToVariant"},
    {28, "ConvertSecurityDescriptorToSecDes"},
    {31, "ConvertTrusteeToSid"},
    {10, "DllCanUnloadNow"},
    {11, "DllGetClassObject"},
    {15, "FreeADsMem"},
    {18, "FreeADsStr"},
    {21, "PropVariantToAdsType"},
    {26, "PropVariantToAdsType2"},
    {16, "ReallocADsMem"},
    {19, "ReallocADsStr"},
    {30, "SecurityDescriptorToBinarySD"},
    {0, NULL}};
static Dw32Ordinal advapi32[] = {
    {1002, "A_SHAFinal"},
    {1003, "A_SHAInit"},
    {1004, "A_SHAUpdate"},
    {1005, "AbortSystemShutdownA"},
    {1006, "AbortSystemShutdownW"},
    {1007, "AccessCheck"},
    {1008, "AccessCheckAndAuditAlarmA"},
    {1009, "AccessCheckAndAuditAlarmW"},
    {1010, "AccessCheckByType"},
    {1011, "AccessCheckByTypeAndAuditAlarmA"},
    {1012, "AccessCheckByTypeAndAuditAlarmW"},
    {1013, "AccessCheckByTypeResultList"},
    {1014, "AccessCheckByTypeResultListAndAuditAlarmA"},
    {1015, "AccessCheckByTypeResultListAndAuditAlarmByHandleA"},
    {1016, "AccessCheckByTypeResultListAndAuditAlarmByHandleW"},
    {1017, "AccessCheckByTypeResultListAndAuditAlarmW"},
    {1018, "AddAccessAllowedAce"},
    {1019, "AddAccessAllowedAceEx"},
    {1020, "AddAccessAllowedObjectAce"},
    {1021, "AddAccessDeniedAce"},
    {1022, "AddAccessDeniedAceEx"},
    {1023, "AddAccessDeniedObjectAce"},
    {1024, "AddAce"},
    {1025, "AddAuditAccessAce"},
    {1026, "AddAuditAccessAceEx"},
    {1027, "AddAuditAccessObjectAce"},
    {1028, "AddConditionalAce"},
    {1029, "AddMandatoryAce"},
    {1030, "AddUsersToEncryptedFile"},
    {1031, "AddUsersToEncryptedFileEx"},
    {1032, "AdjustTokenGroups"},
    {1033, "AdjustTokenPrivileges"},
    {1034, "AllocateAndInitializeSid"},
    {1035, "AllocateLocallyUniqueId"},
    {1036, "AreAllAccessesGranted"},
    {1037, "AreAnyAccessesGranted"},
    {1038, "AuditComputeEffectivePolicyBySid"},
    {1039, "AuditComputeEffectivePolicyByToken"},
    {1040, "AuditEnumerateCategories"},
    {1041, "AuditEnumeratePerUserPolicy"},
    {1042, "AuditEnumerateSubCategories"},
    {1043, "AuditFree"},
    {1044, "AuditLookupCategoryGuidFromCategoryId"},
    {1045, "AuditLookupCategoryIdFromCategoryGuid"},
    {1046, "AuditLookupCategoryNameA"},
    {1047, "AuditLookupCategoryNameW"},
    {1048, "AuditLookupSubCategoryNameA"},
    {1049, "AuditLookupSubCategoryNameW"},
    {1050, "AuditQueryGlobalSaclA"},
    {1051, "AuditQueryGlobalSaclW"},
    {1052, "AuditQueryPerUserPolicy"},
    {1053, "AuditQuerySecurity"},
    {1054, "AuditQuerySystemPolicy"},
    {1055, "AuditSetGlobalSaclA"},
    {1056, "AuditSetGlobalSaclW"},
    {1057, "AuditSetPerUserPolicy"},
    {1058, "AuditSetSecurity"},
    {1059, "AuditSetSystemPolicy"},
    {1060, "BackupEventLogA"},
    {1061, "BackupEventLogW"},
    {1062, "BuildExplicitAccessWithNameA"},
    {1063, "BuildExplicitAccessWithNameW"},
    {1064, "BuildImpersonateExplicitAccessWithNameA"},
    {1065, "BuildImpersonateExplicitAccessWithNameW"},
    {1066, "BuildImpersonateTrusteeA"},
    {1067, "BuildImpersonateTrusteeW"},
    {1068, "BuildSecurityDescriptorA"},
    {1069, "BuildSecurityDescriptorW"},
    {1070, "BuildTrusteeWithNameA"},
    {1071, "BuildTrusteeWithNameW"},
    {1072, "BuildTrusteeWithObjectsAndNameA"},
    {1073, "BuildTrusteeWithObjectsAndNameW"},
    {1074, "BuildTrusteeWithObjectsAndSidA"},
    {1075, "BuildTrusteeWithObjectsAndSidW"},
    {1076, "BuildTrusteeWithSidA"},
    {1077, "BuildTrusteeWithSidW"},
    {1078, "CancelOverlappedAccess"},
    {1079, "ChangeServiceConfig2A"},
    {1080, "ChangeServiceConfig2W"},
    {1081, "ChangeServiceConfigA"},
    {1082, "ChangeServiceConfigW"},
    {1083, "CheckTokenMembership"},
    {1084, "ClearEventLogA"},
    {1085, "ClearEventLogW"},
    {1086, "CloseCodeAuthzLevel"},
    {1087, "CloseEncryptedFileRaw"},
    {1088, "CloseEventLog"},
    {1089, "CloseServiceHandle"},
    {1090, "CloseThreadWaitChainSession"},
    {1091, "CloseTrace"},
    {1092, "CommandLineFromMsiDescriptor"},
    {1093, "ComputeAccessTokenFromCodeAuthzLevel"},
    {1094, "ControlService"},
    {1095, "ControlServiceExA"},
    {1096, "ControlServiceExW"},
    {1097, "ControlTraceA"},
    {1098, "ControlTraceW"},
    {1099, "ConvertAccessToSecurityDescriptorA"},
    {1100, "ConvertAccessToSecurityDescriptorW"},
    {1101, "ConvertSDToStringSDRootDomainA"},
    {1102, "ConvertSDToStringSDRootDomainW"},
    {1103, "ConvertSecurityDescriptorToAccessA"},
    {1104, "ConvertSecurityDescriptorToAccessNamedA"},
    {1105, "ConvertSecurityDescriptorToAccessNamedW"},
    {1106, "ConvertSecurityDescriptorToAccessW"},
    {1107, "ConvertSecurityDescriptorToStringSecurityDescriptorA"},
    {1108, "ConvertSecurityDescriptorToStringSecurityDescriptorW"},
    {1109, "ConvertSidToStringSidA"},
    {1110, "ConvertSidToStringSidW"},
    {1111, "ConvertStringSDToSDDomainA"},
    {1112, "ConvertStringSDToSDDomainW"},
    {1113, "ConvertStringSDToSDRootDomainA"},
    {1114, "ConvertStringSDToSDRootDomainW"},
    {1115, "ConvertStringSecurityDescriptorToSecurityDescriptorA"},
    {1116, "ConvertStringSecurityDescriptorToSecurityDescriptorW"},
    {1117, "ConvertStringSidToSidA"},
    {1118, "ConvertStringSidToSidW"},
    {1119, "ConvertToAutoInheritPrivateObjectSecurity"},
    {1120, "CopySid"},
    {1121, "CreateCodeAuthzLevel"},
    {1122, "CreatePrivateObjectSecurity"},
    {1123, "CreatePrivateObjectSecurityEx"},
    {1124, "CreatePrivateObjectSecurityWithMultipleInheritance"},
    {1125, "CreateProcessAsUserA"},
    {1126, "CreateProcessAsUserW"},
    {1127, "CreateProcessWithLogonW"},
    {1128, "CreateProcessWithTokenW"},
    {1129, "CreateRestrictedToken"},
    {1130, "CreateServiceA"},
    {1131, "CreateServiceW"},
    {1132, "CreateTraceInstanceId"},
    {1133, "CreateWellKnownSid"},
    {1134, "CredBackupCredentials"},
    {1135, "CredDeleteA"},
    {1136, "CredDeleteW"},
    {1137, "CredEncryptAndMarshalBinaryBlob"},
    {1138, "CredEnumerateA"},
    {1139, "CredEnumerateW"},
    {1140, "CredFindBestCredentialA"},
    {1141, "CredFindBestCredentialW"},
    {1142, "CredFree"},
    {1143, "CredGetSessionTypes"},
    {1144, "CredGetTargetInfoA"},
    {1145, "CredGetTargetInfoW"},
    {1146, "CredIsMarshaledCredentialA"},
    {1147, "CredIsMarshaledCredentialW"},
    {1148, "CredIsProtectedA"},
    {1149, "CredIsProtectedW"},
    {1150, "CredMarshalCredentialA"},
    {1151, "CredMarshalCredentialW"},
    {1152, "CredProfileLoaded"},
    {1153, "CredProfileUnloaded"},
    {1154, "CredProtectA"},
    {1155, "CredProtectW"},
    {1156, "CredReadA"},
    {1157, "CredReadByTokenHandle"},
    {1158, "CredReadDomainCredentialsA"},
    {1159, "CredReadDomainCredentialsW"},
    {1160, "CredReadW"},
    {1161, "CredRenameA"},
    {1162, "CredRenameW"},
    {1163, "CredRestoreCredentials"},
    {1164, "CredUnmarshalCredentialA"},
    {1165, "CredUnmarshalCredentialW"},
    {1166, "CredUnprotectA"},
    {1167, "CredUnprotectW"},
    {1168, "CredWriteA"},
    {1169, "CredWriteDomainCredentialsA"},
    {1170, "CredWriteDomainCredentialsW"},
    {1171, "CredWriteW"},
    {1172, "CredpConvertCredential"},
    {1173, "CredpConvertOneCredentialSize"},
    {1174, "CredpConvertTargetInfo"},
    {1175, "CredpDecodeCredential"},
    {1176, "CredpEncodeCredential"},
    {1177, "CredpEncodeSecret"},
    {1178, "CryptAcquireContextA"},
    {1179, "CryptAcquireContextW"},
    {1180, "CryptContextAddRef"},
    {1181, "CryptCreateHash"},
    {1182, "CryptDecrypt"},
    {1183, "CryptDeriveKey"},
    {1184, "CryptDestroyHash"},
    {1185, "CryptDestroyKey"},
    {1186, "CryptDuplicateHash"},
    {1187, "CryptDuplicateKey"},
    {1188, "CryptEncrypt"},
    {1189, "CryptEnumProviderTypesA"},
    {1190, "CryptEnumProviderTypesW"},
    {1191, "CryptEnumProvidersA"},
    {1192, "CryptEnumProvidersW"},
    {1193, "CryptExportKey"},
    {1194, "CryptGenKey"},
    {1195, "CryptGenRandom"},
    {1196, "CryptGetDefaultProviderA"},
    {1197, "CryptGetDefaultProviderW"},
    {1198, "CryptGetHashParam"},
    {1199, "CryptGetKeyParam"},
    {1200, "CryptGetProvParam"},
    {1201, "CryptGetUserKey"},
    {1202, "CryptHashData"},
    {1203, "CryptHashSessionKey"},
    {1204, "CryptImportKey"},
    {1205, "CryptReleaseContext"},
    {1206, "CryptSetHashParam"},
    {1207, "CryptSetKeyParam"},
    {1208, "CryptSetProvParam"},
    {1209, "CryptSetProviderA"},
    {1210, "CryptSetProviderExA"},
    {1211, "CryptSetProviderExW"},
    {1212, "CryptSetProviderW"},
    {1213, "CryptSignHashA"},
    {1214, "CryptSignHashW"},
    {1215, "CryptVerifySignatureA"},
    {1216, "CryptVerifySignatureW"},
    {1217, "DecryptFileA"},
    {1218, "DecryptFileW"},
    {1219, "DeleteAce"},
    {1220, "DeleteService"},
    {1221, "DeregisterEventSource"},
    {1222, "DestroyPrivateObjectSecurity"},
    {1223, "DuplicateEncryptionInfoFile"},
    {1224, "DuplicateToken"},
    {1225, "DuplicateTokenEx"},
    {1226, "ElfBackupEventLogFileA"},
    {1227, "ElfBackupEventLogFileW"},
    {1228, "ElfChangeNotify"},
    {1229, "ElfClearEventLogFileA"},
    {1230, "ElfClearEventLogFileW"},
    {1231, "ElfCloseEventLog"},
    {1232, "ElfDeregisterEventSource"},
    {1233, "ElfFlushEventLog"},
    {1234, "ElfNumberOfRecords"},
    {1235, "ElfOldestRecord"},
    {1236, "ElfOpenBackupEventLogA"},
    {1237, "ElfOpenBackupEventLogW"},
    {1238, "ElfOpenEventLogA"},
    {1239, "ElfOpenEventLogW"},
    {1240, "ElfReadEventLogA"},
    {1241, "ElfReadEventLogW"},
    {1242, "ElfRegisterEventSourceA"},
    {1243, "ElfRegisterEventSourceW"},
    {1244, "ElfReportEventA"},
    {1245, "ElfReportEventAndSourceW"},
    {1246, "ElfReportEventW"},
    {1247, "EnableTrace"},
    {1249, "EnableTraceEx"},
    {1248, "EnableTraceEx2"},
    {1250, "EncryptFileA"},
    {1251, "EncryptFileW"},
    {1252, "EncryptedFileKeyInfo"},
    {1253, "EncryptionDisable"},
    {1254, "EnumDependentServicesA"},
    {1255, "EnumDependentServicesW"},
    {1256, "EnumServiceGroupW"},
    {1257, "EnumServicesStatusA"},
    {1258, "EnumServicesStatusExA"},
    {1259, "EnumServicesStatusExW"},
    {1260, "EnumServicesStatusW"},
    {1261, "EnumerateTraceGuids"},
    {1262, "EnumerateTraceGuidsEx"},
    {1263, "EqualDomainSid"},
    {1264, "EqualPrefixSid"},
    {1265, "EqualSid"},
    {1266, "EventAccessControl"},
    {1267, "EventAccessQuery"},
    {1268, "EventAccessRemove"},
    {1269, "EventActivityIdControl"},
    {1270, "EventEnabled"},
    {1271, "EventProviderEnabled"},
    {1272, "EventRegister"},
    {1273, "EventUnregister"},
    {1274, "EventWrite"},
    {1275, "EventWriteEndScenario"},
    {1276, "EventWriteEx"},
    {1277, "EventWriteStartScenario"},
    {1278, "EventWriteString"},
    {1279, "EventWriteTransfer"},
    {1280, "FileEncryptionStatusA"},
    {1281, "FileEncryptionStatusW"},
    {1282, "FindFirstFreeAce"},
    {1283, "FlushEfsCache"},
    {1284, "FlushTraceA"},
    {1285, "FlushTraceW"},
    {1286, "FreeEncryptedFileKeyInfo"},
    {1287, "FreeEncryptedFileMetadata"},
    {1288, "FreeEncryptionCertificateHashList"},
    {1289, "FreeInheritedFromArray"},
    {1290, "FreeSid"},
    {1291, "GetAccessPermissionsForObjectA"},
    {1292, "GetAccessPermissionsForObjectW"},
    {1293, "GetAce"},
    {1294, "GetAclInformation"},
    {1295, "GetAuditedPermissionsFromAclA"},
    {1296, "GetAuditedPermissionsFromAclW"},
    {1297, "GetCurrentHwProfileA"},
    {1298, "GetCurrentHwProfileW"},
    {1299, "GetEffectiveRightsFromAclA"},
    {1300, "GetEffectiveRightsFromAclW"},
    {1301, "GetEncryptedFileMetadata"},
    {1302, "GetEventLogInformation"},
    {1303, "GetExplicitEntriesFromAclA"},
    {1304, "GetExplicitEntriesFromAclW"},
    {1305, "GetFileSecurityA"},
    {1306, "GetFileSecurityW"},
    {1307, "GetInformationCodeAuthzLevelW"},
    {1308, "GetInformationCodeAuthzPolicyW"},
    {1309, "GetInheritanceSourceA"},
    {1310, "GetInheritanceSourceW"},
    {1311, "GetKernelObjectSecurity"},
    {1312, "GetLengthSid"},
    {1313, "GetLocalManagedApplicationData"},
    {1314, "GetLocalManagedApplications"},
    {1315, "GetManagedApplicationCategories"},
    {1316, "GetManagedApplications"},
    {1317, "GetMultipleTrusteeA"},
    {1318, "GetMultipleTrusteeOperationA"},
    {1319, "GetMultipleTrusteeOperationW"},
    {1320, "GetMultipleTrusteeW"},
    {1321, "GetNamedSecurityInfoA"},
    {1322, "GetNamedSecurityInfoExA"},
    {1323, "GetNamedSecurityInfoExW"},
    {1324, "GetNamedSecurityInfoW"},
    {1325, "GetNumberOfEventLogRecords"},
    {1326, "GetOldestEventLogRecord"},
    {1327, "GetOverlappedAccessResults"},
    {1328, "GetPrivateObjectSecurity"},
    {1329, "GetSecurityDescriptorControl"},
    {1330, "GetSecurityDescriptorDacl"},
    {1331, "GetSecurityDescriptorGroup"},
    {1332, "GetSecurityDescriptorLength"},
    {1333, "GetSecurityDescriptorOwner"},
    {1334, "GetSecurityDescriptorRMControl"},
    {1335, "GetSecurityDescriptorSacl"},
    {1336, "GetSecurityInfo"},
    {1337, "GetSecurityInfoExA"},
    {1338, "GetSecurityInfoExW"},
    {1339, "GetServiceDisplayNameA"},
    {1340, "GetServiceDisplayNameW"},
    {1341, "GetServiceKeyNameA"},
    {1342, "GetServiceKeyNameW"},
    {1343, "GetSidIdentifierAuthority"},
    {1344, "GetSidLengthRequired"},
    {1345, "GetSidSubAuthority"},
    {1346, "GetSidSubAuthorityCount"},
    {1347, "GetThreadWaitChain"},
    {1348, "GetTokenInformation"},
    {1349, "GetTraceEnableFlags"},
    {1350, "GetTraceEnableLevel"},
    {1351, "GetTraceLoggerHandle"},
    {1352, "GetTrusteeFormA"},
    {1353, "GetTrusteeFormW"},
    {1354, "GetTrusteeNameA"},
    {1355, "GetTrusteeNameW"},
    {1356, "GetTrusteeTypeA"},
    {1357, "GetTrusteeTypeW"},
    {1358, "GetUserNameA"},
    {1359, "GetUserNameW"},
    {1360, "GetWindowsAccountDomainSid"},
    {1361, "I_QueryTagInformation"},
    {1001, "I_ScGetCurrentGroupStateW"},
    {1362, "I_ScIsSecurityProcess"},
    {1363, "I_ScPnPGetServiceName"},
    {1364, "I_ScQueryServiceConfig"},
    {1365, "I_ScSendPnPMessage"},
    {1366, "I_ScSendTSMessage"},
    {1367, "I_ScSetServiceBitsA"},
    {1368, "I_ScSetServiceBitsW"},
    {1369, "I_ScValidatePnPService"},
    {1370, "IdentifyCodeAuthzLevelW"},
    {1371, "ImpersonateAnonymousToken"},
    {1372, "ImpersonateLoggedOnUser"},
    {1373, "ImpersonateNamedPipeClient"},
    {1374, "ImpersonateSelf"},
    {1375, "InitializeAcl"},
    {1376, "InitializeSecurityDescriptor"},
    {1377, "InitializeSid"},
    {1378, "InitiateShutdownA"},
    {1379, "InitiateShutdownW"},
    {1380, "InitiateSystemShutdownA"},
    {1381, "InitiateSystemShutdownExA"},
    {1382, "InitiateSystemShutdownExW"},
    {1383, "InitiateSystemShutdownW"},
    {1384, "InstallApplication"},
    {1385, "IsTextUnicode"},
    {1386, "IsTokenRestricted"},
    {1387, "IsTokenUntrusted"},
    {1388, "IsValidAcl"},
    {1389, "IsValidRelativeSecurityDescriptor"},
    {1390, "IsValidSecurityDescriptor"},
    {1391, "IsValidSid"},
    {1392, "IsWellKnownSid"},
    {1393, "LockServiceDatabase"},
    {1394, "LogonUserA"},
    {1395, "LogonUserExA"},
    {1396, "LogonUserExExW"},
    {1397, "LogonUserExW"},
    {1398, "LogonUserW"},
    {1399, "LookupAccountNameA"},
    {1400, "LookupAccountNameW"},
    {1401, "LookupAccountSidA"},
    {1402, "LookupAccountSidW"},
    {1403, "LookupPrivilegeDisplayNameA"},
    {1404, "LookupPrivilegeDisplayNameW"},
    {1405, "LookupPrivilegeNameA"},
    {1406, "LookupPrivilegeNameW"},
    {1407, "LookupPrivilegeValueA"},
    {1408, "LookupPrivilegeValueW"},
    {1409, "LookupSecurityDescriptorPartsA"},
    {1410, "LookupSecurityDescriptorPartsW"},
    {1411, "LsaAddAccountRights"},
    {1412, "LsaAddPrivilegesToAccount"},
    {1413, "LsaClearAuditLog"},
    {1414, "LsaClose"},
    {1415, "LsaCreateAccount"},
    {1416, "LsaCreateSecret"},
    {1417, "LsaCreateTrustedDomain"},
    {1418, "LsaCreateTrustedDomainEx"},
    {1419, "LsaDelete"},
    {1420, "LsaDeleteTrustedDomain"},
    {1421, "LsaEnumerateAccountRights"},
    {1422, "LsaEnumerateAccounts"},
    {1423, "LsaEnumerateAccountsWithUserRight"},
    {1424, "LsaEnumeratePrivileges"},
    {1425, "LsaEnumeratePrivilegesOfAccount"},
    {1426, "LsaEnumerateTrustedDomains"},
    {1427, "LsaEnumerateTrustedDomainsEx"},
    {1428, "LsaFreeMemory"},
    {1429, "LsaGetQuotasForAccount"},
    {1430, "LsaGetRemoteUserName"},
    {1431, "LsaGetSystemAccessAccount"},
    {1432, "LsaGetUserName"},
    {1433, "LsaICLookupNames"},
    {1434, "LsaICLookupNamesWithCreds"},
    {1435, "LsaICLookupSids"},
    {1436, "LsaICLookupSidsWithCreds"},
    {1438, "LsaLookupNames"},
    {1437, "LsaLookupNames2"},
    {1439, "LsaLookupPrivilegeDisplayName"},
    {1440, "LsaLookupPrivilegeName"},
    {1441, "LsaLookupPrivilegeValue"},
    {1442, "LsaLookupSids"},
    {1443, "LsaManageSidNameMapping"},
    {1444, "LsaNtStatusToWinError"},
    {1445, "LsaOpenAccount"},
    {1446, "LsaOpenPolicy"},
    {1447, "LsaOpenPolicySce"},
    {1448, "LsaOpenSecret"},
    {1449, "LsaOpenTrustedDomain"},
    {1450, "LsaOpenTrustedDomainByName"},
    {1451, "LsaQueryDomainInformationPolicy"},
    {1452, "LsaQueryForestTrustInformation"},
    {1453, "LsaQueryInfoTrustedDomain"},
    {1454, "LsaQueryInformationPolicy"},
    {1455, "LsaQuerySecret"},
    {1456, "LsaQuerySecurityObject"},
    {1457, "LsaQueryTrustedDomainInfo"},
    {1458, "LsaQueryTrustedDomainInfoByName"},
    {1459, "LsaRemoveAccountRights"},
    {1460, "LsaRemovePrivilegesFromAccount"},
    {1461, "LsaRetrievePrivateData"},
    {1462, "LsaSetDomainInformationPolicy"},
    {1463, "LsaSetForestTrustInformation"},
    {1464, "LsaSetInformationPolicy"},
    {1465, "LsaSetInformationTrustedDomain"},
    {1466, "LsaSetQuotasForAccount"},
    {1467, "LsaSetSecret"},
    {1468, "LsaSetSecurityObject"},
    {1469, "LsaSetSystemAccessAccount"},
    {1470, "LsaSetTrustedDomainInfoByName"},
    {1471, "LsaSetTrustedDomainInformation"},
    {1472, "LsaStorePrivateData"},
    {1473, "MD4Final"},
    {1474, "MD4Init"},
    {1475, "MD4Update"},
    {1476, "MD5Final"},
    {1477, "MD5Init"},
    {1478, "MD5Update"},
    {1480, "MSChapSrvChangePassword"},
    {1479, "MSChapSrvChangePassword2"},
    {1482, "MakeAbsoluteSD"},
    {1481, "MakeAbsoluteSD2"},
    {1483, "MakeSelfRelativeSD"},
    {1484, "MapGenericMask"},
    {1485, "NotifyBootConfigStatus"},
    {1486, "NotifyChangeEventLog"},
    {1487, "NotifyServiceStatusChange"},
    {1488, "NotifyServiceStatusChangeA"},
    {1489, "NotifyServiceStatusChangeW"},
    {1490, "ObjectCloseAuditAlarmA"},
    {1491, "ObjectCloseAuditAlarmW"},
    {1492, "ObjectDeleteAuditAlarmA"},
    {1493, "ObjectDeleteAuditAlarmW"},
    {1494, "ObjectOpenAuditAlarmA"},
    {1495, "ObjectOpenAuditAlarmW"},
    {1496, "ObjectPrivilegeAuditAlarmA"},
    {1497, "ObjectPrivilegeAuditAlarmW"},
    {1498, "OpenBackupEventLogA"},
    {1499, "OpenBackupEventLogW"},
    {1500, "OpenEncryptedFileRawA"},
    {1501, "OpenEncryptedFileRawW"},
    {1502, "OpenEventLogA"},
    {1503, "OpenEventLogW"},
    {1504, "OpenProcessToken"},
    {1505, "OpenSCManagerA"},
    {1506, "OpenSCManagerW"},
    {1507, "OpenServiceA"},
    {1508, "OpenServiceW"},
    {1509, "OpenThreadToken"},
    {1510, "OpenThreadWaitChainSession"},
    {1511, "OpenTraceA"},
    {1512, "OpenTraceW"},
    {1513, "PerfAddCounters"},
    {1514, "PerfCloseQueryHandle"},
    {1515, "PerfCreateInstance"},
    {1516, "PerfDecrementULongCounterValue"},
    {1517, "PerfDecrementULongLongCounterValue"},
    {1518, "PerfDeleteCounters"},
    {1519, "PerfDeleteInstance"},
    {1520, "PerfEnumerateCounterSet"},
    {1521, "PerfEnumerateCounterSetInstances"},
    {1522, "PerfIncrementULongCounterValue"},
    {1523, "PerfIncrementULongLongCounterValue"},
    {1524, "PerfOpenQueryHandle"},
    {1525, "PerfQueryCounterData"},
    {1526, "PerfQueryCounterInfo"},
    {1527, "PerfQueryCounterSetRegistrationInfo"},
    {1528, "PerfQueryInstance"},
    {1529, "PerfSetCounterRefValue"},
    {1530, "PerfSetCounterSetInfo"},
    {1531, "PerfSetULongCounterValue"},
    {1532, "PerfSetULongLongCounterValue"},
    {1533, "PerfStartProvider"},
    {1534, "PerfStartProviderEx"},
    {1535, "PerfStopProvider"},
    {1536, "PrivilegeCheck"},
    {1537, "PrivilegedServiceAuditAlarmA"},
    {1538, "PrivilegedServiceAuditAlarmW"},
    {1539, "ProcessIdleTasks"},
    {1540, "ProcessIdleTasksW"},
    {1541, "ProcessTrace"},
    {1542, "QueryAllTracesA"},
    {1543, "QueryAllTracesW"},
    {1544, "QueryRecoveryAgentsOnEncryptedFile"},
    {1545, "QuerySecurityAccessMask"},
    {1546, "QueryServiceConfig2A"},
    {1547, "QueryServiceConfig2W"},
    {1548, "QueryServiceConfigA"},
    {1549, "QueryServiceConfigW"},
    {1550, "QueryServiceLockStatusA"},
    {1551, "QueryServiceLockStatusW"},
    {1552, "QueryServiceObjectSecurity"},
    {1553, "QueryServiceStatus"},
    {1554, "QueryServiceStatusEx"},
    {1555, "QueryTraceA"},
    {1556, "QueryTraceW"},
    {1557, "QueryUsersOnEncryptedFile"},
    {1558, "ReadEncryptedFileRaw"},
    {1559, "ReadEventLogA"},
    {1560, "ReadEventLogW"},
    {1561, "RegCloseKey"},
    {1562, "RegConnectRegistryA"},
    {1563, "RegConnectRegistryExA"},
    {1564, "RegConnectRegistryExW"},
    {1565, "RegConnectRegistryW"},
    {1566, "RegCopyTreeA"},
    {1567, "RegCopyTreeW"},
    {1568, "RegCreateKeyA"},
    {1569, "RegCreateKeyExA"},
    {1570, "RegCreateKeyExW"},
    {1571, "RegCreateKeyTransactedA"},
    {1572, "RegCreateKeyTransactedW"},
    {1573, "RegCreateKeyW"},
    {1574, "RegDeleteKeyA"},
    {1575, "RegDeleteKeyExA"},
    {1576, "RegDeleteKeyExW"},
    {1577, "RegDeleteKeyTransactedA"},
    {1578, "RegDeleteKeyTransactedW"},
    {1579, "RegDeleteKeyValueA"},
    {1580, "RegDeleteKeyValueW"},
    {1581, "RegDeleteKeyW"},
    {1582, "RegDeleteTreeA"},
    {1583, "RegDeleteTreeW"},
    {1584, "RegDeleteValueA"},
    {1585, "RegDeleteValueW"},
    {1586, "RegDisablePredefinedCache"},
    {1587, "RegDisablePredefinedCacheEx"},
    {1588, "RegDisableReflectionKey"},
    {1589, "RegEnableReflectionKey"},
    {1590, "RegEnumKeyA"},
    {1591, "RegEnumKeyExA"},
    {1592, "RegEnumKeyExW"},
    {1593, "RegEnumKeyW"},
    {1594, "RegEnumValueA"},
    {1595, "RegEnumValueW"},
    {1596, "RegFlushKey"},
    {1597, "RegGetKeySecurity"},
    {1598, "RegGetValueA"},
    {1599, "RegGetValueW"},
    {1600, "RegLoadAppKeyA"},
    {1601, "RegLoadAppKeyW"},
    {1602, "RegLoadKeyA"},
    {1603, "RegLoadKeyW"},
    {1604, "RegLoadMUIStringA"},
    {1605, "RegLoadMUIStringW"},
    {1606, "RegNotifyChangeKeyValue"},
    {1607, "RegOpenCurrentUser"},
    {1608, "RegOpenKeyA"},
    {1609, "RegOpenKeyExA"},
    {1610, "RegOpenKeyExW"},
    {1611, "RegOpenKeyTransactedA"},
    {1612, "RegOpenKeyTransactedW"},
    {1613, "RegOpenKeyW"},
    {1614, "RegOpenUserClassesRoot"},
    {1615, "RegOverridePredefKey"},
    {1616, "RegQueryInfoKeyA"},
    {1617, "RegQueryInfoKeyW"},
    {1618, "RegQueryMultipleValuesA"},
    {1619, "RegQueryMultipleValuesW"},
    {1620, "RegQueryReflectionKey"},
    {1621, "RegQueryValueA"},
    {1622, "RegQueryValueExA"},
    {1623, "RegQueryValueExW"},
    {1624, "RegQueryValueW"},
    {1625, "RegRenameKey"},
    {1626, "RegReplaceKeyA"},
    {1627, "RegReplaceKeyW"},
    {1628, "RegRestoreKeyA"},
    {1629, "RegRestoreKeyW"},
    {1630, "RegSaveKeyA"},
    {1631, "RegSaveKeyExA"},
    {1632, "RegSaveKeyExW"},
    {1633, "RegSaveKeyW"},
    {1634, "RegSetKeySecurity"},
    {1635, "RegSetKeyValueA"},
    {1636, "RegSetKeyValueW"},
    {1637, "RegSetValueA"},
    {1638, "RegSetValueExA"},
    {1639, "RegSetValueExW"},
    {1640, "RegSetValueW"},
    {1641, "RegUnLoadKeyA"},
    {1642, "RegUnLoadKeyW"},
    {1643, "RegisterEventSourceA"},
    {1644, "RegisterEventSourceW"},
    {1645, "RegisterIdleTask"},
    {1646, "RegisterServiceCtrlHandlerA"},
    {1647, "RegisterServiceCtrlHandlerExA"},
    {1648, "RegisterServiceCtrlHandlerExW"},
    {1649, "RegisterServiceCtrlHandlerW"},
    {1650, "RegisterTraceGuidsA"},
    {1651, "RegisterTraceGuidsW"},
    {1652, "RegisterWaitChainCOMCallback"},
    {1653, "RemoveTraceCallback"},
    {1654, "RemoveUsersFromEncryptedFile"},
    {1655, "ReportEventA"},
    {1656, "ReportEventW"},
    {1657, "RevertToSelf"},
    {1658, "SaferCloseLevel"},
    {1659, "SaferComputeTokenFromLevel"},
    {1660, "SaferCreateLevel"},
    {1661, "SaferGetLevelInformation"},
    {1662, "SaferGetPolicyInformation"},
    {1663, "SaferIdentifyLevel"},
    {1664, "SaferRecordEventLogEntry"},
    {1665, "SaferSetLevelInformation"},
    {1666, "SaferSetPolicyInformation"},
    {1667, "SaferiChangeRegistryScope"},
    {1668, "SaferiCompareTokenLevels"},
    {1669, "SaferiIsDllAllowed"},
    {1670, "SaferiIsExecutableFileType"},
    {1671, "SaferiPopulateDefaultsInRegistry"},
    {1672, "SaferiRecordEventLogEntry"},
    {1673, "SaferiSearchMatchingHashRules"},
    {1674, "SetAclInformation"},
    {1675, "SetEncryptedFileMetadata"},
    {1676, "SetEntriesInAccessListA"},
    {1677, "SetEntriesInAccessListW"},
    {1678, "SetEntriesInAclA"},
    {1679, "SetEntriesInAclW"},
    {1680, "SetEntriesInAuditListA"},
    {1681, "SetEntriesInAuditListW"},
    {1682, "SetFileSecurityA"},
    {1683, "SetFileSecurityW"},
    {1684, "SetInformationCodeAuthzLevelW"},
    {1685, "SetInformationCodeAuthzPolicyW"},
    {1686, "SetKernelObjectSecurity"},
    {1687, "SetNamedSecurityInfoA"},
    {1688, "SetNamedSecurityInfoExA"},
    {1689, "SetNamedSecurityInfoExW"},
    {1690, "SetNamedSecurityInfoW"},
    {1691, "SetPrivateObjectSecurity"},
    {1692, "SetPrivateObjectSecurityEx"},
    {1693, "SetSecurityAccessMask"},
    {1694, "SetSecurityDescriptorControl"},
    {1695, "SetSecurityDescriptorDacl"},
    {1696, "SetSecurityDescriptorGroup"},
    {1697, "SetSecurityDescriptorOwner"},
    {1698, "SetSecurityDescriptorRMControl"},
    {1699, "SetSecurityDescriptorSacl"},
    {1700, "SetSecurityInfo"},
    {1701, "SetSecurityInfoExA"},
    {1702, "SetSecurityInfoExW"},
    {1703, "SetServiceBits"},
    {1704, "SetServiceObjectSecurity"},
    {1705, "SetServiceStatus"},
    {1706, "SetThreadToken"},
    {1707, "SetTokenInformation"},
    {1708, "SetTraceCallback"},
    {1709, "SetUserFileEncryptionKey"},
    {1710, "SetUserFileEncryptionKeyEx"},
    {1711, "StartServiceA"},
    {1712, "StartServiceCtrlDispatcherA"},
    {1713, "StartServiceCtrlDispatcherW"},
    {1714, "StartServiceW"},
    {1715, "StartTraceA"},
    {1716, "StartTraceW"},
    {1717, "StopTraceA"},
    {1718, "StopTraceW"},
    {1719, "SystemFunction001"},
    {1720, "SystemFunction002"},
    {1721, "SystemFunction003"},
    {1722, "SystemFunction004"},
    {1723, "SystemFunction005"},
    {1724, "SystemFunction006"},
    {1725, "SystemFunction007"},
    {1726, "SystemFunction008"},
    {1727, "SystemFunction009"},
    {1728, "SystemFunction010"},
    {1729, "SystemFunction011"},
    {1730, "SystemFunction012"},
    {1731, "SystemFunction013"},
    {1732, "SystemFunction014"},
    {1733, "SystemFunction015"},
    {1734, "SystemFunction016"},
    {1735, "SystemFunction017"},
    {1736, "SystemFunction018"},
    {1737, "SystemFunction019"},
    {1738, "SystemFunction020"},
    {1739, "SystemFunction021"},
    {1740, "SystemFunction022"},
    {1741, "SystemFunction023"},
    {1742, "SystemFunction024"},
    {1743, "SystemFunction025"},
    {1744, "SystemFunction026"},
    {1745, "SystemFunction027"},
    {1746, "SystemFunction028"},
    {1747, "SystemFunction029"},
    {1748, "SystemFunction030"},
    {1749, "SystemFunction031"},
    {1750, "SystemFunction032"},
    {1751, "SystemFunction033"},
    {1752, "SystemFunction034"},
    {1753, "SystemFunction035"},
    {1754, "SystemFunction036"},
    {1755, "SystemFunction040"},
    {1756, "SystemFunction041"},
    {1757, "TraceEvent"},
    {1758, "TraceEventInstance"},
    {1759, "TraceMessage"},
    {1760, "TraceMessageVa"},
    {1761, "TraceSetInformation"},
    {1762, "TreeResetNamedSecurityInfoA"},
    {1763, "TreeResetNamedSecurityInfoW"},
    {1764, "TreeSetNamedSecurityInfoA"},
    {1765, "TreeSetNamedSecurityInfoW"},
    {1766, "TrusteeAccessToObjectA"},
    {1767, "TrusteeAccessToObjectW"},
    {1768, "UninstallApplication"},
    {1769, "UnlockServiceDatabase"},
    {1770, "UnregisterIdleTask"},
    {1771, "UnregisterTraceGuids"},
    {1772, "UpdateTraceA"},
    {1773, "UpdateTraceW"},
    {1774, "UsePinForEncryptedFilesA"},
    {1775, "UsePinForEncryptedFilesW"},
    {1776, "WmiCloseBlock"},
    {1777, "WmiDevInstToInstanceNameA"},
    {1778, "WmiDevInstToInstanceNameW"},
    {1779, "WmiEnumerateGuids"},
    {1780, "WmiExecuteMethodA"},
    {1781, "WmiExecuteMethodW"},
    {1782, "WmiFileHandleToInstanceNameA"},
    {1783, "WmiFileHandleToInstanceNameW"},
    {1784, "WmiFreeBuffer"},
    {1785, "WmiMofEnumerateResourcesA"},
    {1786, "WmiMofEnumerateResourcesW"},
    {1787, "WmiNotificationRegistrationA"},
    {1788, "WmiNotificationRegistrationW"},
    {1789, "WmiOpenBlock"},
    {1790, "WmiQueryAllDataA"},
    {1791, "WmiQueryAllDataMultipleA"},
    {1792, "WmiQueryAllDataMultipleW"},
    {1793, "WmiQueryAllDataW"},
    {1794, "WmiQueryGuidInformation"},
    {1795, "WmiQuerySingleInstanceA"},
    {1796, "WmiQuerySingleInstanceMultipleA"},
    {1797, "WmiQuerySingleInstanceMultipleW"},
    {1798, "WmiQuerySingleInstanceW"},
    {1799, "WmiReceiveNotificationsA"},
    {1800, "WmiReceiveNotificationsW"},
    {1801, "WmiSetSingleInstanceA"},
    {1802, "WmiSetSingleInstanceW"},
    {1803, "WmiSetSingleItemA"},
    {1804, "WmiSetSingleItemW"},
    {1805, "WriteEncryptedFileRaw"},
    {0, NULL}};
static Dw32Ordinal asycfilt[] = {
    {1, "DllCanUnloadNow"},
    {2, "FilterCreateInstance"},
    {0, NULL}};
static Dw32Ordinal atl[] = {
    {10, "AtlAdvise"},
    {41, "AtlAxAttachControl"},
    {39, "AtlAxCreateControl"},
    {40, "AtlAxCreateControlEx"},
    {38, "AtlAxCreateDialogA"},
    {37, "AtlAxCreateDialogW"},
    {36, "AtlAxDialogBoxA"},
    {35, "AtlAxDialogBoxW"},
    {47, "AtlAxGetControl"},
    {48, "AtlAxGetHost"},
    {42, "AtlAxWinInit"},
    {30, "AtlComPtrAssign"},
    {31, "AtlComQIPtrAssign"},
    {26, "AtlCreateTargetDC"},
    {29, "AtlDevModeW2A"},
    {12, "AtlFreeMarshalStream"},
    {54, "AtlGetObjectSourceInterface"},
    {34, "AtlGetVersion"},
    {27, "AtlHiMetricToPixel"},
    {52, "AtlIPersistPropertyBag_Load"},
    {53, "AtlIPersistPropertyBag_Save"},
    {60, "AtlIPersistStreamInit_GetSizeMax"},
    {50, "AtlIPersistStreamInit_Load"},
    {51, "AtlIPersistStreamInit_Save"},
    {32, "AtlInternalQueryInterface"},
    {13, "AtlMarshalPtrInProc"},
    {43, "AtlModuleAddCreateWndData"},
    {58, "AtlModuleAddTermFunc"},
    {44, "AtlModuleExtractCreateWndData"},
    {15, "AtlModuleGetClassObject"},
    {16, "AtlModuleInit"},
    {56, "AtlModuleLoadTypeLib"},
    {17, "AtlModuleRegisterClassObjects"},
    {18, "AtlModuleRegisterServer"},
    {19, "AtlModuleRegisterTypeLib"},
    {46, "AtlModuleRegisterWndClassInfoA"},
    {45, "AtlModuleRegisterWndClassInfoW"},
    {20, "AtlModuleRevokeClassObjects"},
    {21, "AtlModuleTerm"},
    {55, "AtlModuleUnRegisterTypeLib"},
    {22, "AtlModuleUnregisterServer"},
    {57, "AtlModuleUnregisterServerEx"},
    {23, "AtlModuleUpdateRegistryFromResourceD"},
    {28, "AtlPixelToHiMetric"},
    {49, "AtlRegisterClassCategoriesHelper"},
    {25, "AtlSetErrorInfo"},
    {59, "AtlSetErrorInfo2"},
    {11, "AtlUnadvise"},
    {14, "AtlUnmarshalPtr"},
    {24, "AtlWaitWithMessageLoop"},
    {33, "DllCanUnloadNow"},
    {61, "DllGetClassObject"},
    {62, "DllRegisterServer"},
    {63, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal authz[] = {
    {1, "AuthzAccessCheck"},
    {2, "AuthzAddSidsToContext"},
    {3, "AuthzCachedAccessCheck"},
    {4, "AuthzEnumerateSecurityEventSources"},
    {5, "AuthzEvaluateSacl"},
    {6, "AuthzFreeAuditEvent"},
    {7, "AuthzFreeContext"},
    {8, "AuthzFreeHandle"},
    {9, "AuthzFreeResourceManager"},
    {10, "AuthzGetInformationFromContext"},
    {11, "AuthzInitializeContextFromAuthzContext"},
    {12, "AuthzInitializeContextFromSid"},
    {13, "AuthzInitializeContextFromToken"},
    {14, "AuthzInitializeObjectAccessAuditEvent"},
    {15, "AuthzInitializeObjectAccessAuditEvent2"},
    {16, "AuthzInitializeResourceManager"},
    {17, "AuthzInstallSecurityEventSource"},
    {18, "AuthzModifySecurityAttributes"},
    {19, "AuthzOpenObjectAudit"},
    {20, "AuthzRegisterSecurityEventSource"},
    {21, "AuthzReportSecurityEvent"},
    {22, "AuthzReportSecurityEventFromParams"},
    {23, "AuthzUninstallSecurityEventSource"},
    {24, "AuthzUnregisterSecurityEventSource"},
    {25, "AuthziAccessCheckEx"},
    {26, "AuthziAllocateAuditParams"},
    {27, "AuthziCheckContextMembership"},
    {28, "AuthziFreeAuditEventType"},
    {29, "AuthziFreeAuditParams"},
    {30, "AuthziFreeAuditQueue"},
    {31, "AuthziGenerateAdminAlertAuditW"},
    {32, "AuthziInitializeAuditEvent"},
    {33, "AuthziInitializeAuditEventType"},
    {34, "AuthziInitializeAuditParams"},
    {35, "AuthziInitializeAuditParamsFromArray"},
    {36, "AuthziInitializeAuditParamsWithRM"},
    {37, "AuthziInitializeAuditQueue"},
    {38, "AuthziInitializeContextFromSid"},
    {39, "AuthziLogAuditEvent"},
    {41, "AuthziModifyAuditEvent"},
    {40, "AuthziModifyAuditEvent2"},
    {42, "AuthziModifyAuditEventType"},
    {43, "AuthziModifyAuditQueue"},
    {44, "AuthziModifySecurityAttributes"},
    {45, "AuthziQuerySecurityAttributes"},
    {46, "AuthziSourceAudit"},
    {0, NULL}};
static Dw32Ordinal avrt[] = {
    {1, "AvQuerySystemResponsiveness"},
    {2, "AvRevertMmThreadCharacteristics"},
    {3, "AvRtCreateThreadOrderingGroup"},
    {4, "AvRtCreateThreadOrderingGroupExA"},
    {5, "AvRtCreateThreadOrderingGroupExW"},
    {6, "AvRtDeleteThreadOrderingGroup"},
    {7, "AvRtJoinThreadOrderingGroup"},
    {8, "AvRtLeaveThreadOrderingGroup"},
    {9, "AvRtWaitOnThreadOrderingGroup"},
    {10, "AvSetMmMaxThreadCharacteristicsA"},
    {11, "AvSetMmMaxThreadCharacteristicsW"},
    {12, "AvSetMmThreadCharacteristicsA"},
    {13, "AvSetMmThreadCharacteristicsW"},
    {14, "AvSetMmThreadPriority"},
    {0, NULL}};
static Dw32Ordinal bcrypt[] = {
    {1, "BCryptAddContextFunction"},
    {2, "BCryptAddContextFunctionProvider"},
    {3, "BCryptCloseAlgorithmProvider"},
    {4, "BCryptConfigureContext"},
    {5, "BCryptConfigureContextFunction"},
    {6, "BCryptCreateContext"},
    {7, "BCryptCreateHash"},
    {8, "BCryptDecrypt"},
    {9, "BCryptDeleteContext"},
    {10, "BCryptDeriveKey"},
    {11, "BCryptDeriveKeyCapi"},
    {12, "BCryptDeriveKeyPBKDF2"},
    {13, "BCryptDestroyHash"},
    {14, "BCryptDestroyKey"},
    {15, "BCryptDestroySecret"},
    {16, "BCryptDuplicateHash"},
    {17, "BCryptDuplicateKey"},
    {18, "BCryptEncrypt"},
    {19, "BCryptEnumAlgorithms"},
    {20, "BCryptEnumContextFunctionProviders"},
    {21, "BCryptEnumContextFunctions"},
    {22, "BCryptEnumContexts"},
    {23, "BCryptEnumProviders"},
    {24, "BCryptEnumRegisteredProviders"},
    {25, "BCryptExportKey"},
    {26, "BCryptFinalizeKeyPair"},
    {27, "BCryptFinishHash"},
    {28, "BCryptFreeBuffer"},
    {29, "BCryptGenRandom"},
    {30, "BCryptGenerateKeyPair"},
    {31, "BCryptGenerateSymmetricKey"},
    {32, "BCryptGetFipsAlgorithmMode"},
    {33, "BCryptGetProperty"},
    {34, "BCryptHashData"},
    {35, "BCryptImportKey"},
    {36, "BCryptImportKeyPair"},
    {37, "BCryptOpenAlgorithmProvider"},
    {38, "BCryptQueryContextConfiguration"},
    {39, "BCryptQueryContextFunctionConfiguration"},
    {40, "BCryptQueryContextFunctionProperty"},
    {41, "BCryptQueryProviderRegistration"},
    {42, "BCryptRegisterConfigChangeNotify"},
    {43, "BCryptRegisterProvider"},
    {44, "BCryptRemoveContextFunction"},
    {45, "BCryptRemoveContextFunctionProvider"},
    {46, "BCryptResolveProviders"},
    {47, "BCryptSecretAgreement"},
    {48, "BCryptSetAuditingInterface"},
    {49, "BCryptSetContextFunctionProperty"},
    {50, "BCryptSetProperty"},
    {51, "BCryptSignHash"},
    {52, "BCryptUnregisterConfigChangeNotify"},
    {53, "BCryptUnregisterProvider"},
    {54, "BCryptVerifySignature"},
    {0, NULL}};
static Dw32Ordinal cabinet[] = {
    {4, "DeleteExtractedFiles"},
    {2, "DllGetVersion"},
    {3, "Extract"},
    {11, "FCIAddFile"},
    {10, "FCICreate"},
    {14, "FCIDestroy"},
    {13, "FCIFlushCabinet"},
    {12, "FCIFlushFolder"},
    {22, "FDICopy"},
    {20, "FDICreate"},
    {23, "FDIDestroy"},
    {21, "FDIIsCabinet"},
    {24, "FDITruncateCabinet"},
    {1, "GetDllVersion"},
    {0, NULL}};
static Dw32Ordinal clfsw32[] = {
    {2, "AddLogContainer"},
    {3, "AddLogContainerSet"},
    {4, "AdvanceLogBase"},
    {5, "AlignReservedLog"},
    {6, "AllocReservedLog"},
    {7, "CLFS_LSN_INVALID"},
    {8, "CLFS_LSN_NULL"},
    {9, "CloseAndResetLogFile"},
    {10, "CreateLogContainerScanContext"},
    {11, "CreateLogFile"},
    {12, "CreateLogMarshallingArea"},
    {13, "DeleteLogByHandle"},
    {14, "DeleteLogFile"},
    {15, "DeleteLogMarshallingArea"},
    {16, "DeregisterManageableLogClient"},
    {17, "DumpLogRecords"},
    {18, "FlushLogBuffers"},
    {19, "FlushLogToLsn"},
    {20, "FreeReservedLog"},
    {21, "GetLogContainerName"},
    {22, "GetLogFileInformation"},
    {23, "GetLogIoStatistics"},
    {24, "GetLogReservationInfo"},
    {25, "GetNextLogArchiveExtent"},
    {26, "HandleLogFull"},
    {27, "InstallLogPolicy"},
    {28, "LogTailAdvanceFailure"},
    {29, "LsnBlockOffset"},
    {30, "LsnContainer"},
    {31, "LsnCreate"},
    {1, "LsnDecrement"},
    {32, "LsnEqual"},
    {33, "LsnGreater"},
    {34, "LsnIncrement"},
    {35, "LsnInvalid"},
    {36, "LsnLess"},
    {37, "LsnNull"},
    {38, "LsnRecordSequence"},
    {39, "PrepareLogArchive"},
    {40, "QueryLogPolicy"},
    {41, "ReadLogArchiveMetadata"},
    {42, "ReadLogNotification"},
    {43, "ReadLogRecord"},
    {44, "ReadLogRestartArea"},
    {45, "ReadNextLogRecord"},
    {46, "ReadPreviousLogRestartArea"},
    {47, "RegisterForLogWriteNotification"},
    {48, "RegisterManageableLogClient"},
    {49, "RemoveLogContainer"},
    {50, "RemoveLogContainerSet"},
    {51, "RemoveLogPolicy"},
    {52, "ReserveAndAppendLog"},
    {53, "ReserveAndAppendLogAligned"},
    {54, "ScanLogContainers"},
    {55, "SetEndOfLog"},
    {56, "SetLogArchiveMode"},
    {57, "SetLogArchiveTail"},
    {58, "SetLogFileSizeWithPolicy"},
    {59, "TerminateLogArchive"},
    {60, "TerminateReadLog"},
    {61, "TruncateLog"},
    {62, "ValidateLog"},
    {63, "WriteLogRestartArea"},
    {0, NULL}};
static Dw32Ordinal clusapi[] = {
    {1, "AddClusterNode"},
    {2, "AddClusterResourceDependency"},
    {3, "AddClusterResourceNode"},
    {4, "AddResourceToClusterSharedVolumes"},
    {5, "BackupClusterDatabase"},
    {6, "CanResourceBeDependent"},
    {7, "ChangeClusterResourceGroup"},
    {8, "CloseCluster"},
    {9, "CloseClusterGroup"},
    {10, "CloseClusterNetInterface"},
    {11, "CloseClusterNetwork"},
    {12, "CloseClusterNode"},
    {13, "CloseClusterNotifyPort"},
    {14, "CloseClusterResource"},
    {15, "ClusterCloseEnum"},
    {16, "ClusterCloseEnumEx"},
    {17, "ClusterControl"},
    {18, "ClusterEnum"},
    {19, "ClusterEnumEx"},
    {20, "ClusterGetEnumCount"},
    {21, "ClusterGetEnumCountEx"},
    {22, "ClusterGroupCloseEnum"},
    {23, "ClusterGroupControl"},
    {24, "ClusterGroupEnum"},
    {25, "ClusterGroupGetEnumCount"},
    {26, "ClusterGroupOpenEnum"},
    {27, "ClusterNetInterfaceControl"},
    {28, "ClusterNetworkCloseEnum"},
    {29, "ClusterNetworkControl"},
    {30, "ClusterNetworkEnum"},
    {31, "ClusterNetworkGetEnumCount"},
    {32, "ClusterNetworkOpenEnum"},
    {33, "ClusterNodeCloseEnum"},
    {34, "ClusterNodeCloseEnumEx"},
    {35, "ClusterNodeControl"},
    {36, "ClusterNodeEnum"},
    {37, "ClusterNodeEnumEx"},
    {38, "ClusterNodeGetEnumCount"},
    {39, "ClusterNodeGetEnumCountEx"},
    {40, "ClusterNodeOpenEnum"},
    {41, "ClusterNodeOpenEnumEx"},
    {42, "ClusterOpenEnum"},
    {43, "ClusterOpenEnumEx"},
    {44, "ClusterRegBatchAddCommand"},
    {45, "ClusterRegBatchCloseNotification"},
    {46, "ClusterRegBatchReadCommand"},
    {47, "ClusterRegCloseBatch"},
    {48, "ClusterRegCloseBatchNotifyPort"},
    {49, "ClusterRegCloseKey"},
    {50, "ClusterRegCreateBatch"},
    {51, "ClusterRegCreateBatchNotifyPort"},
    {52, "ClusterRegCreateKey"},
    {53, "ClusterRegDeleteKey"},
    {54, "ClusterRegDeleteValue"},
    {55, "ClusterRegEnumKey"},
    {56, "ClusterRegEnumValue"},
    {57, "ClusterRegGetBatchNotification"},
    {58, "ClusterRegGetKeySecurity"},
    {59, "ClusterRegOpenKey"},
    {60, "ClusterRegQueryInfoKey"},
    {61, "ClusterRegQueryValue"},
    {62, "ClusterRegSetKeySecurity"},
    {63, "ClusterRegSetValue"},
    {64, "ClusterResourceCloseEnum"},
    {65, "ClusterResourceControl"},
    {66, "ClusterResourceEnum"},
    {67, "ClusterResourceGetEnumCount"},
    {68, "ClusterResourceOpenEnum"},
    {69, "ClusterResourceTypeCloseEnum"},
    {70, "ClusterResourceTypeControl"},
    {71, "ClusterResourceTypeEnum"},
    {72, "ClusterResourceTypeGetEnumCount"},
    {73, "ClusterResourceTypeOpenEnum"},
    {74, "ClusterSharedVolumeClearBackupState"},
    {75, "CreateCluster"},
    {76, "CreateClusterGroup"},
    {77, "CreateClusterNotifyPort"},
    {78, "CreateClusterResource"},
    {79, "CreateClusterResourceType"},
    {80, "DeleteClusterGroup"},
    {81, "DeleteClusterResource"},
    {82, "DeleteClusterResourceType"},
    {83, "DestroyCluster"},
    {84, "DestroyClusterGroup"},
    {85, "EvictClusterNode"},
    {86, "EvictClusterNodeEx"},
    {87, "FailClusterResource"},
    {88, "GetClusterFromGroup"},
    {89, "GetClusterFromNetInterface"},
    {90, "GetClusterFromNetwork"},
    {91, "GetClusterFromNode"},
    {92, "GetClusterFromResource"},
    {93, "GetClusterGroupKey"},
    {94, "GetClusterGroupState"},
    {95, "GetClusterInformation"},
    {96, "GetClusterKey"},
    {97, "GetClusterNetInterface"},
    {98, "GetClusterNetInterfaceKey"},
    {99, "GetClusterNetInterfaceState"},
    {100, "GetClusterNetworkId"},
    {101, "GetClusterNetworkKey"},
    {102, "GetClusterNetworkState"},
    {103, "GetClusterNodeId"},
    {104, "GetClusterNodeKey"},
    {105, "GetClusterNodeState"},
    {106, "GetClusterNotify"},
    {107, "GetClusterQuorumResource"},
    {108, "GetClusterResourceDependencyExpression"},
    {109, "GetClusterResourceKey"},
    {110, "GetClusterResourceNetworkName"},
    {111, "GetClusterResourceState"},
    {112, "GetClusterResourceTypeKey"},
    {113, "GetClusterSharedVolumeNameForFile"},
    {114, "GetNodeClusterState"},
    {115, "IsFileOnClusterSharedVolume"},
    {116, "MoveClusterGroup"},
    {117, "OfflineClusterGroup"},
    {118, "OfflineClusterResource"},
    {119, "OnlineClusterGroup"},
    {120, "OnlineClusterResource"},
    {121, "OpenCluster"},
    {122, "OpenClusterEx"},
    {123, "OpenClusterGroup"},
    {124, "OpenClusterGroupEx"},
    {125, "OpenClusterNetInterface"},
    {126, "OpenClusterNetInterfaceEx"},
    {127, "OpenClusterNetwork"},
    {128, "OpenClusterNetworkEx"},
    {129, "OpenClusterNode"},
    {130, "OpenClusterNodeEx"},
    {131, "OpenClusterResource"},
    {132, "OpenClusterResourceEx"},
    {133, "PauseClusterNode"},
    {134, "RegisterClusterNotify"},
    {135, "RemoveClusterResourceDependency"},
    {136, "RemoveClusterResourceNode"},
    {137, "RemoveResourceFromClusterSharedVolumes"},
    {138, "RestoreClusterDatabase"},
    {139, "ResumeClusterNode"},
    {140, "SetClusterGroupName"},
    {141, "SetClusterGroupNodeList"},
    {142, "SetClusterName"},
    {143, "SetClusterNetworkName"},
    {144, "SetClusterNetworkPriorityOrder"},
    {145, "SetClusterQuorumResource"},
    {146, "SetClusterResourceDependencyExpression"},
    {147, "SetClusterResourceName"},
    {148, "SetClusterServiceAccountPassword"},
    {0, NULL}};
static Dw32Ordinal comctl32[] = {
    {401, "AddMRUStringW"},
    {400, "CreateMRUListW"},
    {8, "CreateMappedBitmap"},
    {12, "CreatePropertySheetPage"},
    {18, "CreatePropertySheetPageA"},
    {19, "CreatePropertySheetPageW"},
    {20, "CreateStatusWindow"},
    {6, "CreateStatusWindowA"},
    {21, "CreateStatusWindowW"},
    {7, "CreateToolbar"},
    {22, "CreateToolbarEx"},
    {16, "CreateUpDownControl"},
    {331, "DPA_Clone"},
    {328, "DPA_Create"},
    {340, "DPA_CreateEx"},
    {337, "DPA_DeleteAllPtrs"},
    {336, "DPA_DeletePtr"},
    {329, "DPA_Destroy"},
    {386, "DPA_DestroyCallback"},
    {385, "DPA_EnumCallback"},
    {332, "DPA_GetPtr"},
    {333, "DPA_GetPtrIndex"},
    {330, "DPA_Grow"},
    {334, "DPA_InsertPtr"},
    {9, "DPA_LoadStream"},
    {11, "DPA_Merge"},
    {10, "DPA_SaveStream"},
    {339, "DPA_Search"},
    {335, "DPA_SetPtr"},
    {338, "DPA_Sort"},
    {320, "DSA_Create"},
    {327, "DSA_DeleteAllItems"},
    {326, "DSA_DeleteItem"},
    {321, "DSA_Destroy"},
    {388, "DSA_DestroyCallback"},
    {387, "DSA_EnumCallback"},
    {322, "DSA_GetItem"},
    {323, "DSA_GetItemPtr"},
    {324, "DSA_InsertItem"},
    {325, "DSA_SetItem"},
    {413, "DefSubclassProc"},
    {23, "DestroyPropertySheetPage"},
    {24, "DllGetVersion"},
    {15, "DrawInsert"},
    {25, "DrawStatusText"},
    {5, "DrawStatusTextA"},
    {26, "DrawStatusTextW"},
    {403, "EnumMRUListW"},
    {27, "FlatSB_EnableScrollBar"},
    {28, "FlatSB_GetScrollInfo"},
    {29, "FlatSB_GetScrollPos"},
    {30, "FlatSB_GetScrollProp"},
    {31, "FlatSB_GetScrollRange"},
    {32, "FlatSB_SetScrollInfo"},
    {33, "FlatSB_SetScrollPos"},
    {34, "FlatSB_SetScrollProp"},
    {35, "FlatSB_SetScrollRange"},
    {36, "FlatSB_ShowScrollBar"},
    {152, "FreeMRUList"},
    {4, "GetEffectiveClientRect"},
    {37, "GetMUILanguage"},
    {38, "ImageList_Add"},
    {39, "ImageList_AddIcon"},
    {40, "ImageList_AddMasked"},
    {41, "ImageList_BeginDrag"},
    {42, "ImageList_Copy"},
    {43, "ImageList_Create"},
    {44, "ImageList_Destroy"},
    {45, "ImageList_DragEnter"},
    {46, "ImageList_DragLeave"},
    {47, "ImageList_DragMove"},
    {48, "ImageList_DragShowNolock"},
    {49, "ImageList_Draw"},
    {50, "ImageList_DrawEx"},
    {51, "ImageList_DrawIndirect"},
    {52, "ImageList_Duplicate"},
    {53, "ImageList_EndDrag"},
    {54, "ImageList_GetBkColor"},
    {55, "ImageList_GetDragImage"},
    {56, "ImageList_GetFlags"},
    {57, "ImageList_GetIcon"},
    {58, "ImageList_GetIconSize"},
    {59, "ImageList_GetImageCount"},
    {60, "ImageList_GetImageInfo"},
    {61, "ImageList_GetImageRect"},
    {62, "ImageList_LoadImage"},
    {63, "ImageList_LoadImageA"},
    {64, "ImageList_LoadImageW"},
    {65, "ImageList_Merge"},
    {66, "ImageList_Read"},
    {67, "ImageList_Remove"},
    {68, "ImageList_Replace"},
    {69, "ImageList_ReplaceIcon"},
    {70, "ImageList_SetBkColor"},
    {75, "ImageList_SetDragCursorImage"},
    {76, "ImageList_SetFilter"},
    {77, "ImageList_SetFlags"},
    {78, "ImageList_SetIconSize"},
    {79, "ImageList_SetImageCount"},
    {80, "ImageList_SetOverlayImage"},
    {81, "ImageList_Write"},
    {17, "InitCommonControls"},
    {82, "InitCommonControlsEx"},
    {83, "InitMUILanguage"},
    {84, "InitializeFlatSB"},
    {14, "LBItemFromPt"},
    {13, "MakeDragList"},
    {2, "MenuHelp"},
    {85, "PropertySheet"},
    {86, "PropertySheetA"},
    {87, "PropertySheetW"},
    {88, "RegisterClassNameW"},
    {412, "RemoveWindowSubclass"},
    {410, "SetWindowSubclass"},
    {3, "ShowHideMenuCtl"},
    {236, "Str_SetPtrW"},
    {89, "UninitializeFlatSB"},
    {90, "_TrackMouseEvent"},
    {0, NULL}};
static Dw32Ordinal comdlg32[] = {
    {102, "ChooseColorA"},
    {103, "ChooseColorW"},
    {104, "ChooseFontA"},
    {105, "ChooseFontW"},
    {106, "CommDlgExtendedError"},
    {107, "DllCanUnloadNow"},
    {108, "DllGetClassObject"},
    {109, "FindTextA"},
    {110, "FindTextW"},
    {111, "GetFileTitleA"},
    {112, "GetFileTitleW"},
    {113, "GetOpenFileNameA"},
    {114, "GetOpenFileNameW"},
    {115, "GetSaveFileNameA"},
    {116, "GetSaveFileNameW"},
    {117, "LoadAlterBitmap"},
    {118, "PageSetupDlgA"},
    {119, "PageSetupDlgW"},
    {120, "PrintDlgA"},
    {121, "PrintDlgExA"},
    {122, "PrintDlgExW"},
    {123, "PrintDlgW"},
    {124, "ReplaceTextA"},
    {125, "ReplaceTextW"},
    {126, "Ssync_ANSI_UNICODE_Struct_For_WOW"},
    {127, "WantArrows"},
    {128, "dwLBSubclass"},
    {129, "dwOKSubclass"},
    {0, NULL}};
static Dw32Ordinal comsvcs[] = {
    {8, "CoCreateActivity"},
    {9, "CoEnterServiceDomain"},
    {10, "CoLeaveServiceDomain"},
    {11, "CoLoadServices"},
    {12, "ComSvcsExceptionFilter"},
    {13, "ComSvcsLogError"},
    {5, "CosGetCallContext"},
    {14, "DispManGetContext"},
    {15, "DllCanUnloadNow"},
    {16, "DllGetClassObject"},
    {17, "DllRegisterServer"},
    {18, "DllUnregisterServer"},
    {19, "GetMTAThreadPoolMetrics"},
    {20, "GetManagedExtensions"},
    {21, "GetObjectContext"},
    {22, "GetTrkSvrObject"},
    {23, "MTSCreateActivity"},
    {24, "MiniDumpW"},
    {25, "RecycleSurrogate"},
    {26, "SafeRef"},
    {0, NULL}};
static Dw32Ordinal credui[] = {
    {1, "CredPackAuthenticationBufferA"},
    {2, "CredPackAuthenticationBufferW"},
    {3, "CredUICmdLinePromptForCredentialsA"},
    {4, "CredUICmdLinePromptForCredentialsW"},
    {5, "CredUIConfirmCredentialsA"},
    {6, "CredUIConfirmCredentialsW"},
    {7, "CredUIInitControls"},
    {8, "CredUIParseUserNameA"},
    {9, "CredUIParseUserNameW"},
    {10, "CredUIPromptForCredentialsA"},
    {11, "CredUIPromptForCredentialsW"},
    {12, "CredUIPromptForWindowsCredentialsA"},
    {13, "CredUIPromptForWindowsCredentialsW"},
    {14, "CredUIPromptForWindowsCredentialsWorker"},
    {15, "CredUIReadSSOCredA"},
    {16, "CredUIReadSSOCredW"},
    {17, "CredUIStoreSSOCredA"},
    {18, "CredUIStoreSSOCredW"},
    {19, "CredUnPackAuthenticationBufferA"},
    {20, "CredUnPackAuthenticationBufferW"},
    {21, "DllCanUnloadNow"},
    {22, "DllGetClassObject"},
    {23, "DllRegisterServer"},
    {24, "DllUnregisterServer"},
    {25, "SspiGetCredUIContext"},
    {26, "SspiIsPromptingNeeded"},
    {27, "SspiPromptForCredentialsA"},
    {28, "SspiPromptForCredentialsW"},
    {29, "SspiUnmarshalCredUIContext"},
    {30, "SspiUpdateCredentials"},
    {0, NULL}};
static Dw32Ordinal crypt32[] = {
    {1024, "CertAddCRLContextToStore"},
    {1025, "CertAddCRLLinkToStore"},
    {1026, "CertAddCTLContextToStore"},
    {1027, "CertAddCTLLinkToStore"},
    {1028, "CertAddCertificateContextToStore"},
    {1029, "CertAddCertificateLinkToStore"},
    {1030, "CertAddEncodedCRLToStore"},
    {1031, "CertAddEncodedCTLToStore"},
    {1032, "CertAddEncodedCertificateToStore"},
    {1033, "CertAddEncodedCertificateToSystemStoreA"},
    {1034, "CertAddEncodedCertificateToSystemStoreW"},
    {1035, "CertAddEnhancedKeyUsageIdentifier"},
    {1036, "CertAddRefServerOcspResponse"},
    {1037, "CertAddRefServerOcspResponseContext"},
    {1038, "CertAddSerializedElementToStore"},
    {1039, "CertAddStoreToCollection"},
    {1040, "CertAlgIdToOID"},
    {1041, "CertCloseServerOcspResponse"},
    {1042, "CertCloseStore"},
    {1043, "CertCompareCertificate"},
    {1044, "CertCompareCertificateName"},
    {1045, "CertCompareIntegerBlob"},
    {1046, "CertComparePublicKeyInfo"},
    {1047, "CertControlStore"},
    {1048, "CertCreateCRLContext"},
    {1049, "CertCreateCTLContext"},
    {1050, "CertCreateCTLEntryFromCertificateContextProperties"},
    {1051, "CertCreateCertificateChainEngine"},
    {1052, "CertCreateCertificateContext"},
    {1053, "CertCreateContext"},
    {1054, "CertCreateSelfSignCertificate"},
    {1055, "CertDeleteCRLFromStore"},
    {1056, "CertDeleteCTLFromStore"},
    {1057, "CertDeleteCertificateFromStore"},
    {1058, "CertDuplicateCRLContext"},
    {1059, "CertDuplicateCTLContext"},
    {1060, "CertDuplicateCertificateChain"},
    {1061, "CertDuplicateCertificateContext"},
    {1062, "CertDuplicateStore"},
    {1063, "CertEnumCRLContextProperties"},
    {1064, "CertEnumCRLsInStore"},
    {1065, "CertEnumCTLContextProperties"},
    {1066, "CertEnumCTLsInStore"},
    {1067, "CertEnumCertificateContextProperties"},
    {1068, "CertEnumCertificatesInStore"},
    {1069, "CertEnumPhysicalStore"},
    {1070, "CertEnumSubjectInSortedCTL"},
    {1071, "CertEnumSystemStore"},
    {1072, "CertEnumSystemStoreLocation"},
    {1073, "CertFindAttribute"},
    {1074, "CertFindCRLInStore"},
    {1075, "CertFindCTLInStore"},
    {1076, "CertFindCertificateInCRL"},
    {1077, "CertFindCertificateInStore"},
    {1078, "CertFindChainInStore"},
    {1079, "CertFindExtension"},
    {1080, "CertFindRDNAttr"},
    {1081, "CertFindSubjectInCTL"},
    {1082, "CertFindSubjectInSortedCTL"},
    {1083, "CertFreeCRLContext"},
    {1084, "CertFreeCTLContext"},
    {1085, "CertFreeCertificateChain"},
    {1086, "CertFreeCertificateChainEngine"},
    {1087, "CertFreeCertificateChainList"},
    {1088, "CertFreeCertificateContext"},
    {1089, "CertFreeServerOcspResponseContext"},
    {1090, "CertGetCRLContextProperty"},
    {1091, "CertGetCRLFromStore"},
    {1092, "CertGetCTLContextProperty"},
    {1093, "CertGetCertificateChain"},
    {1094, "CertGetCertificateContextProperty"},
    {1095, "CertGetEnhancedKeyUsage"},
    {1096, "CertGetIntendedKeyUsage"},
    {1097, "CertGetIssuerCertificateFromStore"},
    {1098, "CertGetNameStringA"},
    {1099, "CertGetNameStringW"},
    {1100, "CertGetPublicKeyLength"},
    {1101, "CertGetServerOcspResponseContext"},
    {1102, "CertGetStoreProperty"},
    {1103, "CertGetSubjectCertificateFromStore"},
    {1104, "CertGetValidUsages"},
    {1105, "CertIsRDNAttrsInCertificateName"},
    {1106, "CertIsValidCRLForCertificate"},
    {1107, "CertNameToStrA"},
    {1108, "CertNameToStrW"},
    {1109, "CertOIDToAlgId"},
    {1110, "CertOpenServerOcspResponse"},
    {1111, "CertOpenStore"},
    {1112, "CertOpenSystemStoreA"},
    {1113, "CertOpenSystemStoreW"},
    {1114, "CertRDNValueToStrA"},
    {1115, "CertRDNValueToStrW"},
    {1116, "CertRegisterPhysicalStore"},
    {1117, "CertRegisterSystemStore"},
    {1118, "CertRemoveEnhancedKeyUsageIdentifier"},
    {1119, "CertRemoveStoreFromCollection"},
    {1120, "CertResyncCertificateChainEngine"},
    {1121, "CertRetrieveLogoOrBiometricInfo"},
    {1122, "CertSaveStore"},
    {1123, "CertSelectCertificateChains"},
    {1124, "CertSerializeCRLStoreElement"},
    {1125, "CertSerializeCTLStoreElement"},
    {1126, "CertSerializeCertificateStoreElement"},
    {1127, "CertSetCRLContextProperty"},
    {1128, "CertSetCTLContextProperty"},
    {1129, "CertSetCertificateContextPropertiesFromCTLEntry"},
    {1130, "CertSetCertificateContextProperty"},
    {1131, "CertSetEnhancedKeyUsage"},
    {1132, "CertSetStoreProperty"},
    {1133, "CertStrToNameA"},
    {1134, "CertStrToNameW"},
    {1135, "CertUnregisterPhysicalStore"},
    {1136, "CertUnregisterSystemStore"},
    {1137, "CertVerifyCRLRevocation"},
    {1138, "CertVerifyCRLTimeValidity"},
    {1139, "CertVerifyCTLUsage"},
    {1140, "CertVerifyCertificateChainPolicy"},
    {1141, "CertVerifyRevocation"},
    {1142, "CertVerifySubjectCertificateContext"},
    {1143, "CertVerifyTimeValidity"},
    {1144, "CertVerifyValidityNesting"},
    {1145, "CreateFileU"},
    {1146, "CryptAcquireCertificatePrivateKey"},
    {1012, "CryptAcquireContextU"},
    {1147, "CryptBinaryToStringA"},
    {1148, "CryptBinaryToStringW"},
    {1149, "CryptCloseAsyncHandle"},
    {1150, "CryptCreateAsyncHandle"},
    {1151, "CryptCreateKeyIdentifierFromCSP"},
    {1152, "CryptDecodeMessage"},
    {1153, "CryptDecodeObject"},
    {1154, "CryptDecodeObjectEx"},
    {1155, "CryptDecryptAndVerifyMessageSignature"},
    {1156, "CryptDecryptMessage"},
    {1157, "CryptEncodeObject"},
    {1158, "CryptEncodeObjectEx"},
    {1159, "CryptEncryptMessage"},
    {1160, "CryptEnumKeyIdentifierProperties"},
    {1161, "CryptEnumOIDFunction"},
    {1162, "CryptEnumOIDInfo"},
    {1013, "CryptEnumProvidersU"},
    {1163, "CryptExportPKCS8"},
    {1164, "CryptExportPublicKeyInfo"},
    {1165, "CryptExportPublicKeyInfoEx"},
    {1166, "CryptExportPublicKeyInfoFromBCryptKeyHandle"},
    {1167, "CryptFindCertificateKeyProvInfo"},
    {1168, "CryptFindLocalizedName"},
    {1169, "CryptFindOIDInfo"},
    {1170, "CryptFormatObject"},
    {1171, "CryptFreeOIDFunctionAddress"},
    {1172, "CryptGetAsyncParam"},
    {1173, "CryptGetDefaultOIDDllList"},
    {1174, "CryptGetDefaultOIDFunctionAddress"},
    {1175, "CryptGetKeyIdentifierProperty"},
    {1176, "CryptGetMessageCertificates"},
    {1177, "CryptGetMessageSignerCount"},
    {1178, "CryptGetOIDFunctionAddress"},
    {1179, "CryptGetOIDFunctionValue"},
    {1181, "CryptHashCertificate"},
    {1180, "CryptHashCertificate2"},
    {1182, "CryptHashMessage"},
    {1183, "CryptHashPublicKeyInfo"},
    {1184, "CryptHashToBeSigned"},
    {1185, "CryptImportPKCS8"},
    {1186, "CryptImportPublicKeyInfo"},
    {1188, "CryptImportPublicKeyInfoEx"},
    {1187, "CryptImportPublicKeyInfoEx2"},
    {1189, "CryptInitOIDFunctionSet"},
    {1190, "CryptInstallDefaultContext"},
    {1191, "CryptInstallOIDFunctionAddress"},
    {1192, "CryptLoadSip"},
    {1193, "CryptMemAlloc"},
    {1194, "CryptMemFree"},
    {1195, "CryptMemRealloc"},
    {1196, "CryptMsgCalculateEncodedLength"},
    {1197, "CryptMsgClose"},
    {1198, "CryptMsgControl"},
    {1199, "CryptMsgCountersign"},
    {1200, "CryptMsgCountersignEncoded"},
    {1201, "CryptMsgDuplicate"},
    {1202, "CryptMsgEncodeAndSignCTL"},
    {1203, "CryptMsgGetAndVerifySigner"},
    {1204, "CryptMsgGetParam"},
    {1205, "CryptMsgOpenToDecode"},
    {1206, "CryptMsgOpenToEncode"},
    {1207, "CryptMsgSignCTL"},
    {1208, "CryptMsgUpdate"},
    {1209, "CryptMsgVerifyCountersignatureEncoded"},
    {1210, "CryptMsgVerifyCountersignatureEncodedEx"},
    {1211, "CryptProtectData"},
    {1212, "CryptProtectMemory"},
    {1213, "CryptQueryObject"},
    {1214, "CryptRegisterDefaultOIDFunction"},
    {1215, "CryptRegisterOIDFunction"},
    {1216, "CryptRegisterOIDInfo"},
    {1217, "CryptRetrieveTimeStamp"},
    {1218, "CryptSIPAddProvider"},
    {1219, "CryptSIPCreateIndirectData"},
    {1220, "CryptSIPGetSignedDataMsg"},
    {1221, "CryptSIPLoad"},
    {1222, "CryptSIPPutSignedDataMsg"},
    {1223, "CryptSIPRemoveProvider"},
    {1224, "CryptSIPRemoveSignedDataMsg"},
    {1225, "CryptSIPRetrieveSubjectGuid"},
    {1226, "CryptSIPRetrieveSubjectGuidForCatalogFile"},
    {1227, "CryptSIPVerifyIndirectData"},
    {1228, "CryptSetAsyncParam"},
    {1229, "CryptSetKeyIdentifierProperty"},
    {1230, "CryptSetOIDFunctionValue"},
    {1014, "CryptSetProviderU"},
    {1231, "CryptSignAndEncodeCertificate"},
    {1232, "CryptSignAndEncryptMessage"},
    {1233, "CryptSignCertificate"},
    {1015, "CryptSignHashU"},
    {1234, "CryptSignMessage"},
    {1235, "CryptSignMessageWithKey"},
    {1236, "CryptStringToBinaryA"},
    {1237, "CryptStringToBinaryW"},
    {1238, "CryptUninstallDefaultContext"},
    {1239, "CryptUnprotectData"},
    {1240, "CryptUnprotectMemory"},
    {1241, "CryptUnregisterDefaultOIDFunction"},
    {1242, "CryptUnregisterOIDFunction"},
    {1243, "CryptUnregisterOIDInfo"},
    {1244, "CryptUpdateProtectedState"},
    {1245, "CryptVerifyCertificateSignature"},
    {1246, "CryptVerifyCertificateSignatureEx"},
    {1247, "CryptVerifyDetachedMessageHash"},
    {1248, "CryptVerifyDetachedMessageSignature"},
    {1249, "CryptVerifyMessageHash"},
    {1250, "CryptVerifyMessageSignature"},
    {1251, "CryptVerifyMessageSignatureWithKey"},
    {1016, "CryptVerifySignatureU"},
    {1252, "CryptVerifyTimeStampSignature"},
    {1253, "I_CertDiagControl"},
    {1254, "I_CertProtectFunction"},
    {1255, "I_CertSrvProtectFunction"},
    {1256, "I_CertSyncStore"},
    {1257, "I_CertUpdateStore"},
    {1258, "I_CryptAddRefLruEntry"},
    {1259, "I_CryptAddSmartCardCertToStore"},
    {1260, "I_CryptAllocTls"},
    {1261, "I_CryptCreateLruCache"},
    {1262, "I_CryptCreateLruEntry"},
    {1263, "I_CryptDetachTls"},
    {1264, "I_CryptDisableLruOfEntries"},
    {1265, "I_CryptEnableLruOfEntries"},
    {1266, "I_CryptEnumMatchingLruEntries"},
    {1267, "I_CryptFindLruEntry"},
    {1268, "I_CryptFindLruEntryData"},
    {1269, "I_CryptFindSmartCardCertInStore"},
    {1270, "I_CryptFlushLruCache"},
    {1271, "I_CryptFreeLruCache"},
    {1272, "I_CryptFreeTls"},
    {1273, "I_CryptGetAsn1Decoder"},
    {1274, "I_CryptGetAsn1Encoder"},
    {1275, "I_CryptGetDefaultCryptProv"},
    {1276, "I_CryptGetDefaultCryptProvForEncrypt"},
    {1277, "I_CryptGetFileVersion"},
    {1278, "I_CryptGetLruEntryData"},
    {1279, "I_CryptGetLruEntryIdentifier"},
    {1280, "I_CryptGetOssGlobal"},
    {1281, "I_CryptGetTls"},
    {1282, "I_CryptInsertLruEntry"},
    {1283, "I_CryptInstallAsn1Module"},
    {1284, "I_CryptInstallOssGlobal"},
    {1285, "I_CryptReadTrustedPublisherDWORDValueFromRegistry"},
    {1286, "I_CryptRegisterSmartCardStore"},
    {1287, "I_CryptReleaseLruEntry"},
    {1288, "I_CryptRemoveLruEntry"},
    {1289, "I_CryptSetTls"},
    {1290, "I_CryptTouchLruEntry"},
    {1291, "I_CryptUninstallAsn1Module"},
    {1292, "I_CryptUninstallOssGlobal"},
    {1293, "I_CryptUnregisterSmartCardStore"},
    {1294, "I_CryptWalkAllLruCacheEntries"},
    {1296, "PFXExportCertStore"},
    {1295, "PFXExportCertStore2"},
    {1297, "PFXExportCertStoreEx"},
    {1298, "PFXImportCertStore"},
    {1299, "PFXIsPFXBlob"},
    {1300, "PFXVerifyPassword"},
    {1301, "RegCreateHKCUKeyExU"},
    {1017, "RegCreateKeyExU"},
    {1018, "RegDeleteValueU"},
    {1019, "RegEnumValueU"},
    {1302, "RegOpenHKCUKeyExU"},
    {1020, "RegOpenKeyExU"},
    {1021, "RegQueryInfoKeyU"},
    {1022, "RegQueryValueExU"},
    {1023, "RegSetValueExU"},
    {0, NULL}};
static Dw32Ordinal cryptnet[] = {
    {1, "CertDllVerifyCTLUsage"},
    {2, "CertDllVerifyRevocation"},
    {5, "CryptCancelAsyncRetrieval"},
    {6, "CryptFlushTimeValidObject"},
    {7, "CryptGetObjectUrl"},
    {8, "CryptGetTimeValidObject"},
    {9, "CryptInstallCancelRetrieval"},
    {10, "CryptRetrieveObjectByUrlA"},
    {11, "CryptRetrieveObjectByUrlW"},
    {12, "CryptUninstallCancelRetrieval"},
    {13, "DllRegisterServer"},
    {14, "DllUnregisterServer"},
    {3, "I_CryptConvertIriToAsciiOrUnicode"},
    {15, "I_CryptNetEnumUrlCacheEntry"},
    {16, "I_CryptNetGetConnectivity"},
    {17, "I_CryptNetGetHostNameFromUrl"},
    {18, "I_CryptNetGetUserDsStoreUrl"},
    {19, "I_CryptNetSetUrlCacheFlushInfo"},
    {20, "I_CryptNetSetUrlCachePreFetchInfo"},
    {4, "LdapProvOpenStore"},
    {0, NULL}};
static Dw32Ordinal cryptui[] = {
    {3, "ACUIProviderInvokeUI"},
    {4, "CertSelectionGetSerializedBlob"},
    {5, "CryptUIDlgAddPolicyServer"},
    {6, "CryptUIDlgCertMgr"},
    {7, "CryptUIDlgFreeCAContext"},
    {8, "CryptUIDlgFreePolicyServerContext"},
    {9, "CryptUIDlgPropertyPolicy"},
    {10, "CryptUIDlgSelectCA"},
    {11, "CryptUIDlgSelectCertificateA"},
    {12, "CryptUIDlgSelectCertificateFromStore"},
    {13, "CryptUIDlgSelectCertificateW"},
    {14, "CryptUIDlgSelectPolicyServer"},
    {15, "CryptUIDlgSelectStoreA"},
    {16, "CryptUIDlgSelectStoreW"},
    {17, "CryptUIDlgViewCRLA"},
    {18, "CryptUIDlgViewCRLW"},
    {19, "CryptUIDlgViewCTLA"},
    {20, "CryptUIDlgViewCTLW"},
    {21, "CryptUIDlgViewCertificateA"},
    {22, "CryptUIDlgViewCertificatePropertiesA"},
    {23, "CryptUIDlgViewCertificatePropertiesW"},
    {24, "CryptUIDlgViewCertificateW"},
    {25, "CryptUIDlgViewContext"},
    {26, "CryptUIDlgViewSignerInfoA"},
    {27, "CryptUIDlgViewSignerInfoW"},
    {28, "CryptUIFreeCertificatePropertiesPagesA"},
    {29, "CryptUIFreeCertificatePropertiesPagesW"},
    {30, "CryptUIFreeViewSignaturesPagesA"},
    {31, "CryptUIFreeViewSignaturesPagesW"},
    {32, "CryptUIGetCertificatePropertiesPagesA"},
    {33, "CryptUIGetCertificatePropertiesPagesW"},
    {34, "CryptUIGetViewSignaturesPagesA"},
    {35, "CryptUIGetViewSignaturesPagesW"},
    {36, "CryptUIStartCertMgr"},
    {37, "CryptUIViewExpiringCerts"},
    {38, "CryptUIWizBuildCTL"},
    {39, "CryptUIWizCertRequest"},
    {40, "CryptUIWizCreateCertRequestNoDS"},
    {41, "CryptUIWizDigitalSign"},
    {42, "CryptUIWizExport"},
    {43, "CryptUIWizFreeCertRequestNoDS"},
    {44, "CryptUIWizFreeDigitalSignContext"},
    {45, "CryptUIWizImport"},
    {46, "CryptUIWizQueryCertRequestNoDS"},
    {47, "CryptUIWizSubmitCertRequestNoDS"},
    {48, "DllRegisterServer"},
    {49, "DllUnregisterServer"},
    {50, "EnrollmentCOMObjectFactory_getInstance"},
    {51, "I_CryptUIProtect"},
    {52, "I_CryptUIProtectFailure"},
    {1, "LocalEnroll"},
    {2, "LocalEnrollNoDS"},
    {53, "RetrievePKCS7FromCA"},
    {54, "WizardFree"},
    {0, NULL}};
static Dw32Ordinal ctl3d32[] = {
    {7, "BtnWndProc3d"},
    {10, "ComboWndProc3d"},
    {16, "Ctl3dAutoSubclass"},
    {27, "Ctl3dAutoSubclassEx"},
    {6, "Ctl3dColorChange"},
    {4, "Ctl3dCtlColor"},
    {18, "Ctl3dCtlColorEx"},
    {20, "Ctl3dDlgFramePaint"},
    {17, "Ctl3dDlgProc"},
    {5, "Ctl3dEnabled"},
    {1, "Ctl3dGetVer"},
    {23, "Ctl3dIsAutoSubclass"},
    {12, "Ctl3dRegister"},
    {19, "Ctl3dSetStyle"},
    {3, "Ctl3dSubclassCtl"},
    {25, "Ctl3dSubclassCtlEx"},
    {2, "Ctl3dSubclassDlg"},
    {21, "Ctl3dSubclassDlgEx"},
    {24, "Ctl3dUnAutoSubclass"},
    {13, "Ctl3dUnregister"},
    {26, "Ctl3dUnsubclassCtl"},
    {22, "Ctl3dWinIniChange"},
    {8, "EditWndProc3d"},
    {9, "ListWndProc3d"},
    {11, "StaticWndProc3d"},
    {0, NULL}};
static Dw32Ordinal d3d10[] = {
    {1, "D3D10CompileEffectFromMemory"},
    {2, "D3D10CompileShader"},
    {3, "D3D10CreateBlob"},
    {4, "D3D10CreateDevice"},
    {5, "D3D10CreateDeviceAndSwapChain"},
    {6, "D3D10CreateEffectFromMemory"},
    {7, "D3D10CreateEffectPoolFromMemory"},
    {8, "D3D10CreateStateBlock"},
    {9, "D3D10DisassembleEffect"},
    {10, "D3D10DisassembleShader"},
    {11, "D3D10GetGeometryShaderProfile"},
    {12, "D3D10GetInputAndOutputSignatureBlob"},
    {13, "D3D10GetInputSignatureBlob"},
    {14, "D3D10GetOutputSignatureBlob"},
    {15, "D3D10GetPixelShaderProfile"},
    {16, "D3D10GetShaderDebugInfo"},
    {17, "D3D10GetVersion"},
    {18, "D3D10GetVertexShaderProfile"},
    {19, "D3D10PreprocessShader"},
    {20, "D3D10ReflectShader"},
    {21, "D3D10RegisterLayers"},
    {22, "D3D10StateBlockMaskDifference"},
    {23, "D3D10StateBlockMaskDisableAll"},
    {24, "D3D10StateBlockMaskDisableCapture"},
    {25, "D3D10StateBlockMaskEnableAll"},
    {26, "D3D10StateBlockMaskEnableCapture"},
    {27, "D3D10StateBlockMaskGetSetting"},
    {28, "D3D10StateBlockMaskIntersect"},
    {29, "D3D10StateBlockMaskUnion"},
    {0, NULL}};
static Dw32Ordinal d3d8thk[] = {
    {1, "OsThunkD3dContextCreate"},
    {2, "OsThunkD3dContextDestroy"},
    {3, "OsThunkD3dContextDestroyAll"},
    {4, "OsThunkD3dDrawPrimitives2"},
    {5, "OsThunkD3dValidateTextureStageState"},
    {6, "OsThunkDdAddAttachedSurface"},
    {7, "OsThunkDdAlphaBlt"},
    {8, "OsThunkDdAttachSurface"},
    {9, "OsThunkDdBeginMoCompFrame"},
    {10, "OsThunkDdBlt"},
    {11, "OsThunkDdCanCreateD3DBuffer"},
    {12, "OsThunkDdCanCreateSurface"},
    {13, "OsThunkDdColorControl"},
    {14, "OsThunkDdCreateD3DBuffer"},
    {15, "OsThunkDdCreateDirectDrawObject"},
    {16, "OsThunkDdCreateMoComp"},
    {17, "OsThunkDdCreateSurface"},
    {18, "OsThunkDdCreateSurfaceEx"},
    {19, "OsThunkDdCreateSurfaceObject"},
    {20, "OsThunkDdDeleteDirectDrawObject"},
    {21, "OsThunkDdDeleteSurfaceObject"},
    {22, "OsThunkDdDestroyD3DBuffer"},
    {23, "OsThunkDdDestroyMoComp"},
    {24, "OsThunkDdDestroySurface"},
    {25, "OsThunkDdEndMoCompFrame"},
    {26, "OsThunkDdFlip"},
    {27, "OsThunkDdFlipToGDISurface"},
    {28, "OsThunkDdGetAvailDriverMemory"},
    {29, "OsThunkDdGetBltStatus"},
    {30, "OsThunkDdGetDC"},
    {31, "OsThunkDdGetDriverInfo"},
    {32, "OsThunkDdGetDriverState"},
    {33, "OsThunkDdGetDxHandle"},
    {34, "OsThunkDdGetFlipStatus"},
    {35, "OsThunkDdGetInternalMoCompInfo"},
    {36, "OsThunkDdGetMoCompBuffInfo"},
    {37, "OsThunkDdGetMoCompFormats"},
    {38, "OsThunkDdGetMoCompGuids"},
    {39, "OsThunkDdGetScanLine"},
    {40, "OsThunkDdLock"},
    {41, "OsThunkDdLockD3D"},
    {42, "OsThunkDdQueryDirectDrawObject"},
    {43, "OsThunkDdQueryMoCompStatus"},
    {44, "OsThunkDdReenableDirectDrawObject"},
    {45, "OsThunkDdReleaseDC"},
    {46, "OsThunkDdRenderMoComp"},
    {47, "OsThunkDdResetVisrgn"},
    {48, "OsThunkDdSetColorKey"},
    {49, "OsThunkDdSetExclusiveMode"},
    {50, "OsThunkDdSetGammaRamp"},
    {51, "OsThunkDdSetOverlayPosition"},
    {52, "OsThunkDdUnattachSurface"},
    {53, "OsThunkDdUnlock"},
    {54, "OsThunkDdUnlockD3D"},
    {55, "OsThunkDdUpdateOverlay"},
    {56, "OsThunkDdWaitForVerticalBlank"},
    {0, NULL}};
static Dw32Ordinal d3d9[] = {
    {4, "D3DPERF_BeginEvent"},
    {5, "D3DPERF_EndEvent"},
    {6, "D3DPERF_GetStatus"},
    {7, "D3DPERF_QueryRepeatFrame"},
    {8, "D3DPERF_SetMarker"},
    {9, "D3DPERF_SetOptions"},
    {10, "D3DPERF_SetRegion"},
    {11, "DebugSetLevel"},
    {12, "DebugSetMute"},
    {13, "Direct3DCreate9"},
    {14, "Direct3DCreate9Ex"},
    {1, "Direct3DShaderValidatorCreate9"},
    {2, "PSGPError"},
    {3, "PSGPSampleTexture"},
    {0, NULL}};
static Dw32Ordinal dbgeng[] = {
    {1, "DebugConnect"},
    {2, "DebugConnectWide"},
    {3, "DebugCreate"},
    {0, NULL}};
static Dw32Ordinal dbghelp[] = {
    {2, "DbgHelpCreateUserDump"},
    {3, "DbgHelpCreateUserDumpW"},
    {4, "EnumDirTree"},
    {5, "EnumDirTreeW"},
    {7, "EnumerateLoadedModules"},
    {6, "EnumerateLoadedModules64"},
    {8, "EnumerateLoadedModulesEx"},
    {9, "EnumerateLoadedModulesExW"},
    {10, "EnumerateLoadedModulesW64"},
    {11, "ExtensionApiVersion"},
    {12, "FindDebugInfoFile"},
    {13, "FindDebugInfoFileEx"},
    {14, "FindDebugInfoFileExW"},
    {15, "FindExecutableImage"},
    {16, "FindExecutableImageEx"},
    {17, "FindExecutableImageExW"},
    {18, "FindFileInPath"},
    {19, "FindFileInSearchPath"},
    {20, "GetTimestampForLoadedLibrary"},
    {21, "ImageDirectoryEntryToData"},
    {22, "ImageDirectoryEntryToDataEx"},
    {23, "ImageNtHeader"},
    {24, "ImageRvaToSection"},
    {25, "ImageRvaToVa"},
    {26, "ImagehlpApiVersion"},
    {27, "ImagehlpApiVersionEx"},
    {28, "MakeSureDirectoryPathExists"},
    {29, "MapDebugInformation"},
    {30, "MiniDumpReadDumpStream"},
    {31, "MiniDumpWriteDump"},
    {32, "SearchTreeForFile"},
    {33, "SearchTreeForFileW"},
    {35, "StackWalk"},
    {34, "StackWalk64"},
    {36, "SymAddSourceStream"},
    {37, "SymAddSourceStreamA"},
    {38, "SymAddSourceStreamW"},
    {39, "SymAddSymbol"},
    {40, "SymAddSymbolW"},
    {41, "SymCleanup"},
    {42, "SymDeleteSymbol"},
    {43, "SymDeleteSymbolW"},
    {44, "SymEnumLines"},
    {45, "SymEnumLinesW"},
    {46, "SymEnumProcesses"},
    {47, "SymEnumSourceFileTokens"},
    {48, "SymEnumSourceFiles"},
    {49, "SymEnumSourceFilesW"},
    {50, "SymEnumSourceLines"},
    {51, "SymEnumSourceLinesW"},
    {52, "SymEnumSym"},
    {53, "SymEnumSymbols"},
    {54, "SymEnumSymbolsForAddr"},
    {55, "SymEnumSymbolsForAddrW"},
    {56, "SymEnumSymbolsW"},
    {57, "SymEnumTypes"},
    {58, "SymEnumTypesByName"},
    {59, "SymEnumTypesByNameW"},
    {60, "SymEnumTypesW"},
    {62, "SymEnumerateModules"},
    {61, "SymEnumerateModules64"},
    {63, "SymEnumerateModulesW64"},
    {65, "SymEnumerateSymbols"},
    {64, "SymEnumerateSymbols64"},
    {67, "SymEnumerateSymbolsW"},
    {66, "SymEnumerateSymbolsW64"},
    {68, "SymFindDebugInfoFile"},
    {69, "SymFindDebugInfoFileW"},
    {70, "SymFindExecutableImage"},
    {71, "SymFindExecutableImageW"},
    {72, "SymFindFileInPath"},
    {73, "SymFindFileInPathW"},
    {74, "SymFromAddr"},
    {75, "SymFromAddrW"},
    {76, "SymFromIndex"},
    {77, "SymFromIndexW"},
    {78, "SymFromName"},
    {79, "SymFromNameW"},
    {80, "SymFromToken"},
    {81, "SymFromTokenW"},
    {83, "SymFunctionTableAccess"},
    {82, "SymFunctionTableAccess64"},
    {84, "SymGetFileLineOffsets64"},
    {85, "SymGetHomeDirectory"},
    {86, "SymGetHomeDirectoryW"},
    {88, "SymGetLineFromAddr"},
    {87, "SymGetLineFromAddr64"},
    {89, "SymGetLineFromAddrW64"},
    {91, "SymGetLineFromName"},
    {90, "SymGetLineFromName64"},
    {92, "SymGetLineFromNameW64"},
    {94, "SymGetLineNext"},
    {93, "SymGetLineNext64"},
    {95, "SymGetLineNextW64"},
    {97, "SymGetLinePrev"},
    {96, "SymGetLinePrev64"},
    {98, "SymGetLinePrevW64"},
    {100, "SymGetModuleBase"},
    {99, "SymGetModuleBase64"},
    {102, "SymGetModuleInfo"},
    {101, "SymGetModuleInfo64"},
    {104, "SymGetModuleInfoW"},
    {103, "SymGetModuleInfoW64"},
    {1, "SymGetOmapBlockBase"},
    {105, "SymGetOmaps"},
    {106, "SymGetOptions"},
    {107, "SymGetScope"},
    {108, "SymGetScopeW"},
    {109, "SymGetSearchPath"},
    {110, "SymGetSearchPathW"},
    {111, "SymGetSourceFile"},
    {112, "SymGetSourceFileFromToken"},
    {113, "SymGetSourceFileFromTokenW"},
    {114, "SymGetSourceFileToken"},
    {115, "SymGetSourceFileTokenW"},
    {116, "SymGetSourceFileW"},
    {117, "SymGetSourceVarFromToken"},
    {118, "SymGetSourceVarFromTokenW"},
    {120, "SymGetSymFromAddr"},
    {119, "SymGetSymFromAddr64"},
    {122, "SymGetSymFromName"},
    {121, "SymGetSymFromName64"},
    {124, "SymGetSymNext"},
    {123, "SymGetSymNext64"},
    {126, "SymGetSymPrev"},
    {125, "SymGetSymPrev64"},
    {127, "SymGetSymbolFile"},
    {128, "SymGetSymbolFileW"},
    {129, "SymGetTypeFromName"},
    {130, "SymGetTypeFromNameW"},
    {131, "SymGetTypeInfo"},
    {132, "SymGetTypeInfoEx"},
    {133, "SymGetUnwindInfo"},
    {134, "SymInitialize"},
    {135, "SymInitializeW"},
    {137, "SymLoadModule"},
    {136, "SymLoadModule64"},
    {138, "SymLoadModuleEx"},
    {139, "SymLoadModuleExW"},
    {140, "SymMatchFileName"},
    {141, "SymMatchFileNameW"},
    {142, "SymMatchString"},
    {143, "SymMatchStringA"},
    {144, "SymMatchStringW"},
    {145, "SymNext"},
    {146, "SymNextW"},
    {147, "SymPrev"},
    {148, "SymPrevW"},
    {149, "SymRefreshModuleList"},
    {151, "SymRegisterCallback"},
    {150, "SymRegisterCallback64"},
    {152, "SymRegisterCallbackW64"},
    {154, "SymRegisterFunctionEntryCallback"},
    {153, "SymRegisterFunctionEntryCallback64"},
    {155, "SymSearch"},
    {156, "SymSearchW"},
    {157, "SymSetContext"},
    {158, "SymSetHomeDirectory"},
    {159, "SymSetHomeDirectoryW"},
    {160, "SymSetOptions"},
    {161, "SymSetParentWindow"},
    {162, "SymSetScopeFromAddr"},
    {163, "SymSetScopeFromIndex"},
    {164, "SymSetSearchPath"},
    {165, "SymSetSearchPathW"},
    {166, "SymSrvDeltaName"},
    {167, "SymSrvDeltaNameW"},
    {168, "SymSrvGetFileIndexInfo"},
    {169, "SymSrvGetFileIndexInfoW"},
    {170, "SymSrvGetFileIndexString"},
    {171, "SymSrvGetFileIndexStringW"},
    {172, "SymSrvGetFileIndexes"},
    {173, "SymSrvGetFileIndexesW"},
    {174, "SymSrvGetSupplement"},
    {175, "SymSrvGetSupplementW"},
    {176, "SymSrvIsStore"},
    {177, "SymSrvIsStoreW"},
    {178, "SymSrvStoreFile"},
    {179, "SymSrvStoreFileW"},
    {180, "SymSrvStoreSupplement"},
    {181, "SymSrvStoreSupplementW"},
    {183, "SymUnDName"},
    {182, "SymUnDName64"},
    {185, "SymUnloadModule"},
    {184, "SymUnloadModule64"},
    {186, "UnDecorateSymbolName"},
    {187, "UnDecorateSymbolNameW"},
    {188, "UnmapDebugInformation"},
    {189, "WinDbgExtensionDllInit"},
    {190, "block"},
    {191, "chksym"},
    {192, "dbghelp"},
    {193, "dh"},
    {194, "fptr"},
    {195, "homedir"},
    {196, "itoldyouso"},
    {197, "lmi"},
    {198, "lminfo"},
    {199, "omap"},
    {200, "srcfiles"},
    {201, "stack_force_ebp"},
    {202, "stackdbg"},
    {203, "sym"},
    {204, "symsrv"},
    {205, "vc7fpo"},
    {0, NULL}};
static Dw32Ordinal dciman32[] = {
    {1, "DCIBeginAccess"},
    {2, "DCICloseProvider"},
    {3, "DCICreateOffscreen"},
    {4, "DCICreateOverlay"},
    {5, "DCICreatePrimary"},
    {6, "DCIDestroy"},
    {7, "DCIDraw"},
    {8, "DCIEndAccess"},
    {9, "DCIEnum"},
    {10, "DCIOpenProvider"},
    {11, "DCISetClipList"},
    {12, "DCISetDestination"},
    {13, "DCISetSrcDestClip"},
    {14, "GetDCRegionData"},
    {15, "GetWindowRegionData"},
    {16, "WinWatchClose"},
    {17, "WinWatchDidStatusChange"},
    {18, "WinWatchGetClipList"},
    {19, "WinWatchNotify"},
    {20, "WinWatchOpen"},
    {0, NULL}};
static Dw32Ordinal ddraw[] = {
    {1, "AcquireDDThreadLock"},
    {2, "CompleteCreateSysmemSurface"},
    {3, "D3DParseUnknownCommand"},
    {4, "DDGetAttachedSurfaceLcl"},
    {5, "DDInternalLock"},
    {6, "DDInternalUnlock"},
    {7, "DSoundHelp"},
    {8, "DirectDrawCreate"},
    {9, "DirectDrawCreateClipper"},
    {10, "DirectDrawCreateEx"},
    {11, "DirectDrawEnumerateA"},
    {12, "DirectDrawEnumerateExA"},
    {13, "DirectDrawEnumerateExW"},
    {14, "DirectDrawEnumerateW"},
    {15, "DllCanUnloadNow"},
    {16, "DllGetClassObject"},
    {17, "GetDDSurfaceLocal"},
    {18, "GetOLEThunkData"},
    {19, "GetSurfaceFromDC"},
    {20, "RegisterSpecialCase"},
    {21, "ReleaseDDThreadLock"},
    {22, "SetAppCompatData"},
    {0, NULL}};
static Dw32Ordinal dhcpcsvc[] = {
    {1, "DhcpAcquireParameters"},
    {2, "DhcpAcquireParametersByBroadcast"},
    {3, "DhcpCApiCleanup"},
    {4, "DhcpCApiInitialize"},
    {5, "DhcpClient_Generalize"},
    {6, "DhcpDeRegisterConnectionStateNotification"},
    {7, "DhcpDeRegisterOptions"},
    {8, "DhcpDeRegisterParamChange"},
    {9, "DhcpDelPersistentRequestParams"},
    {10, "DhcpEnableDhcp"},
    {11, "DhcpEnableTracing"},
    {12, "DhcpEnumClasses"},
    {13, "DhcpEnumInterfaces"},
    {14, "DhcpFallbackRefreshParams"},
    {15, "DhcpFreeEnumeratedInterfaces"},
    {16, "DhcpFreeLeaseInfo"},
    {17, "DhcpFreeMem"},
    {18, "DhcpGetClassId"},
    {19, "DhcpGetClientId"},
    {20, "DhcpGetDhcpServicedConnections"},
    {21, "DhcpGetFallbackParams"},
    {22, "DhcpGetNotificationStatus"},
    {23, "DhcpGetOriginalSubnetMask"},
    {24, "DhcpGetTraceArray"},
    {25, "DhcpGlobalIsShuttingDown"},
    {26, "DhcpGlobalServiceSyncEvent"},
    {27, "DhcpGlobalTerminateEvent"},
    {28, "DhcpHandlePnPEvent"},
    {29, "DhcpIsEnabled"},
    {30, "DhcpLeaseIpAddress"},
    {31, "DhcpLeaseIpAddressEx"},
    {32, "DhcpNotifyConfigChange"},
    {33, "DhcpNotifyConfigChangeEx"},
    {34, "DhcpNotifyMediaReconnected"},
    {35, "DhcpOpenGlobalEvent"},
    {36, "DhcpPersistentRequestParams"},
    {37, "DhcpQueryLeaseInfo"},
    {38, "DhcpQueryLeaseInfoEx"},
    {39, "DhcpRegisterConnectionStateNotification"},
    {40, "DhcpRegisterOptions"},
    {41, "DhcpRegisterParamChange"},
    {42, "DhcpReleaseIpAddressLease"},
    {43, "DhcpReleaseIpAddressLeaseEx"},
    {44, "DhcpReleaseParameters"},
    {45, "DhcpRemoveDNSRegistrations"},
    {46, "DhcpRenewIpAddressLease"},
    {47, "DhcpRenewIpAddressLeaseEx"},
    {48, "DhcpRequestCachedParams"},
    {49, "DhcpRequestOptions"},
    {50, "DhcpRequestParams"},
    {51, "DhcpSetClassId"},
    {52, "DhcpSetClientId"},
    {53, "DhcpSetFallbackParams"},
    {54, "DhcpSetMSFTVendorSpecificOptions"},
    {55, "DhcpStaticRefreshParams"},
    {56, "DhcpUndoRequestParams"},
    {57, "Dhcpv4CheckServerAvailability"},
    {58, "Dhcpv4EnableDhcpEx"},
    {59, "McastApiCleanup"},
    {60, "McastApiStartup"},
    {61, "McastEnumerateScopes"},
    {62, "McastGenUID"},
    {63, "McastReleaseAddress"},
    {64, "McastRenewAddress"},
    {65, "McastRequestAddress"},
    {0, NULL}};
static Dw32Ordinal dhcpcsvc6[] = {
    {1, "Dhcpv6AcquireParameters"},
    {2, "Dhcpv6CancelOperation"},
    {3, "Dhcpv6EnableTracing"},
    {4, "Dhcpv6FreeLeaseInfo"},
    {5, "Dhcpv6GetTraceArray"},
    {6, "Dhcpv6GetUserClasses"},
    {7, "Dhcpv6IsEnabled"},
    {8, "Dhcpv6QueryLeaseInfo"},
    {9, "Dhcpv6ReleaseParameters"},
    {10, "Dhcpv6ReleasePrefix"},
    {11, "Dhcpv6ReleasePrefixEx"},
    {12, "Dhcpv6RenewPrefix"},
    {13, "Dhcpv6RenewPrefixEx"},
    {14, "Dhcpv6RequestParams"},
    {15, "Dhcpv6RequestPrefix"},
    {16, "Dhcpv6RequestPrefixEx"},
    {17, "Dhcpv6SetUserClass"},
    {0, NULL}};
static Dw32Ordinal dhcpsapi[] = {
    {1, "DhcpAddFilterV4"},
    {2, "DhcpAddMScopeElement"},
    {3, "DhcpAddSecurityGroup"},
    {4, "DhcpAddServer"},
    {5, "DhcpAddSubnetElement"},
    {6, "DhcpAddSubnetElementV4"},
    {7, "DhcpAddSubnetElementV5"},
    {8, "DhcpAddSubnetElementV6"},
    {9, "DhcpAuditLogGetParams"},
    {10, "DhcpAuditLogSetParams"},
    {11, "DhcpCreateClass"},
    {12, "DhcpCreateClassV6"},
    {13, "DhcpCreateClientInfo"},
    {14, "DhcpCreateClientInfoV4"},
    {15, "DhcpCreateClientInfoVQ"},
    {16, "DhcpCreateOption"},
    {17, "DhcpCreateOptionV5"},
    {18, "DhcpCreateOptionV6"},
    {19, "DhcpCreateSubnet"},
    {20, "DhcpCreateSubnetV6"},
    {21, "DhcpCreateSubnetVQ"},
    {22, "DhcpDeleteClass"},
    {23, "DhcpDeleteClassV6"},
    {24, "DhcpDeleteClientInfo"},
    {25, "DhcpDeleteClientInfoV6"},
    {26, "DhcpDeleteFilterV4"},
    {27, "DhcpDeleteMClientInfo"},
    {28, "DhcpDeleteMScope"},
    {29, "DhcpDeleteServer"},
    {30, "DhcpDeleteSubnet"},
    {31, "DhcpDeleteSubnetV6"},
    {32, "DhcpDeleteSuperScopeV4"},
    {33, "DhcpDsCleanup"},
    {34, "DhcpDsClearHostServerEntries"},
    {35, "DhcpDsInit"},
    {36, "DhcpEnumClasses"},
    {37, "DhcpEnumClassesV6"},
    {38, "DhcpEnumFilterV4"},
    {39, "DhcpEnumMScopeClients"},
    {40, "DhcpEnumMScopeElements"},
    {41, "DhcpEnumMScopes"},
    {42, "DhcpEnumOptionValues"},
    {43, "DhcpEnumOptionValuesV5"},
    {44, "DhcpEnumOptionValuesV6"},
    {45, "DhcpEnumOptions"},
    {46, "DhcpEnumOptionsV5"},
    {47, "DhcpEnumOptionsV6"},
    {48, "DhcpEnumServers"},
    {49, "DhcpEnumSubnetClients"},
    {50, "DhcpEnumSubnetClientsFilterStatusInfo"},
    {51, "DhcpEnumSubnetClientsV4"},
    {52, "DhcpEnumSubnetClientsV5"},
    {53, "DhcpEnumSubnetClientsV6"},
    {54, "DhcpEnumSubnetClientsVQ"},
    {55, "DhcpEnumSubnetElements"},
    {56, "DhcpEnumSubnetElementsV4"},
    {57, "DhcpEnumSubnetElementsV5"},
    {58, "DhcpEnumSubnetElementsV6"},
    {59, "DhcpEnumSubnets"},
    {60, "DhcpEnumSubnetsV6"},
    {61, "DhcpGetAllOptionValues"},
    {62, "DhcpGetAllOptionValuesV6"},
    {63, "DhcpGetAllOptions"},
    {64, "DhcpGetAllOptionsV6"},
    {65, "DhcpGetClassInfo"},
    {66, "DhcpGetClientInfo"},
    {67, "DhcpGetClientInfoV4"},
    {68, "DhcpGetClientInfoV6"},
    {69, "DhcpGetClientInfoVQ"},
    {70, "DhcpGetClientOptions"},
    {71, "DhcpGetFilterV4"},
    {72, "DhcpGetMCastMibInfo"},
    {73, "DhcpGetMScopeInfo"},
    {74, "DhcpGetMibInfo"},
    {75, "DhcpGetMibInfoV5"},
    {76, "DhcpGetMibInfoV6"},
    {77, "DhcpGetMibInfoVQ"},
    {78, "DhcpGetOptionInfo"},
    {79, "DhcpGetOptionInfoV5"},
    {80, "DhcpGetOptionInfoV6"},
    {81, "DhcpGetOptionValue"},
    {82, "DhcpGetOptionValueV5"},
    {83, "DhcpGetOptionValueV6"},
    {84, "DhcpGetServerBindingInfo"},
    {85, "DhcpGetServerBindingInfoV6"},
    {86, "DhcpGetServerSpecificStrings"},
    {87, "DhcpGetSubnetDelayOffer"},
    {88, "DhcpGetSubnetInfo"},
    {89, "DhcpGetSubnetInfoV6"},
    {90, "DhcpGetSubnetInfoVQ"},
    {91, "DhcpGetSuperScopeInfoV4"},
    {92, "DhcpGetThreadOptions"},
    {93, "DhcpGetVersion"},
    {94, "DhcpModifyClass"},
    {95, "DhcpModifyClassV6"},
    {96, "DhcpRemoveMScopeElement"},
    {97, "DhcpRemoveOption"},
    {98, "DhcpRemoveOptionV5"},
    {99, "DhcpRemoveOptionV6"},
    {100, "DhcpRemoveOptionValue"},
    {101, "DhcpRemoveOptionValueV5"},
    {102, "DhcpRemoveOptionValueV6"},
    {103, "DhcpRemoveSubnetElement"},
    {104, "DhcpRemoveSubnetElementV4"},
    {105, "DhcpRemoveSubnetElementV5"},
    {106, "DhcpRemoveSubnetElementV6"},
    {107, "DhcpRpcFreeMemory"},
    {108, "DhcpScanDatabase"},
    {109, "DhcpScanMDatabase"},
    {110, "DhcpServerAuditlogParamsFree"},
    {111, "DhcpServerBackupDatabase"},
    {112, "DhcpServerGetConfig"},
    {113, "DhcpServerGetConfigV4"},
    {114, "DhcpServerGetConfigV6"},
    {115, "DhcpServerGetConfigVQ"},
    {116, "DhcpServerQueryAttribute"},
    {117, "DhcpServerQueryAttributes"},
    {118, "DhcpServerQueryDnsRegCredentials"},
    {119, "DhcpServerRedoAuthorization"},
    {120, "DhcpServerRestoreDatabase"},
    {121, "DhcpServerSetConfig"},
    {122, "DhcpServerSetConfigV4"},
    {123, "DhcpServerSetConfigV6"},
    {124, "DhcpServerSetConfigVQ"},
    {125, "DhcpServerSetDnsRegCredentials"},
    {126, "DhcpServerSetDnsRegCredentialsV5"},
    {127, "DhcpSetClientInfo"},
    {128, "DhcpSetClientInfoV4"},
    {129, "DhcpSetClientInfoV6"},
    {130, "DhcpSetClientInfoVQ"},
    {131, "DhcpSetFilterV4"},
    {132, "DhcpSetMScopeInfo"},
    {133, "DhcpSetOptionInfo"},
    {134, "DhcpSetOptionInfoV5"},
    {135, "DhcpSetOptionInfoV6"},
    {136, "DhcpSetOptionValue"},
    {137, "DhcpSetOptionValueV5"},
    {138, "DhcpSetOptionValueV6"},
    {139, "DhcpSetOptionValues"},
    {140, "DhcpSetOptionValuesV5"},
    {141, "DhcpSetServerBindingInfo"},
    {142, "DhcpSetServerBindingInfoV6"},
    {143, "DhcpSetSubnetDelayOffer"},
    {144, "DhcpSetSubnetInfo"},
    {145, "DhcpSetSubnetInfoV6"},
    {146, "DhcpSetSubnetInfoVQ"},
    {147, "DhcpSetSuperScopeV4"},
    {148, "DhcpSetThreadOptions"},
    {0, NULL}};
static Dw32Ordinal dinput[] = {
    {1, "DirectInputCreateA"},
    {2, "DirectInputCreateEx"},
    {3, "DirectInputCreateW"},
    {4, "DllCanUnloadNow"},
    {5, "DllGetClassObject"},
    {6, "DllRegisterServer"},
    {7, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal dnsapi[] = {
    {12, "BreakRecordsIntoBlob"},
    {13, "CombineRecordsInBlob"},
    {14, "DnsAcquireContextHandle_A"},
    {15, "DnsAcquireContextHandle_W"},
    {16, "DnsAllocateRecord"},
    {17, "DnsApiAlloc"},
    {18, "DnsApiAllocZero"},
    {19, "DnsApiFree"},
    {20, "DnsApiHeapReset"},
    {21, "DnsApiRealloc"},
    {22, "DnsApiSetDebugGlobals"},
    {23, "DnsAsyncRegisterHostAddrs"},
    {24, "DnsAsyncRegisterInit"},
    {25, "DnsAsyncRegisterTerm"},
    {26, "DnsCopyStringEx"},
    {27, "DnsCreateReverseNameStringForIpAddress"},
    {28, "DnsCreateStandardDnsNameCopy"},
    {29, "DnsCreateStringCopy"},
    {30, "DnsDhcpRegisterAddrs"},
    {31, "DnsDhcpRegisterHostAddrs"},
    {32, "DnsDhcpRegisterInit"},
    {33, "DnsDhcpRegisterTerm"},
    {34, "DnsDhcpRemoveRegistrations"},
    {35, "DnsDhcpSrvRegisterHostAddr"},
    {36, "DnsDhcpSrvRegisterHostAddrEx"},
    {37, "DnsDhcpSrvRegisterHostName"},
    {38, "DnsDhcpSrvRegisterHostNameEx"},
    {39, "DnsDhcpSrvRegisterInit"},
    {40, "DnsDhcpSrvRegisterInitialize"},
    {41, "DnsDhcpSrvRegisterTerm"},
    {42, "DnsDowncaseDnsNameLabel"},
    {43, "DnsExtractRecordsFromMessage_UTF8"},
    {44, "DnsExtractRecordsFromMessage_W"},
    {45, "DnsFindAuthoritativeZone"},
    {46, "DnsFlushResolverCache"},
    {47, "DnsFlushResolverCacheEntry_A"},
    {48, "DnsFlushResolverCacheEntry_UTF8"},
    {49, "DnsFlushResolverCacheEntry_W"},
    {50, "DnsFree"},
    {51, "DnsFreeConfigStructure"},
    {52, "DnsFreePolicyConfig"},
    {53, "DnsFreeProxyName"},
    {54, "DnsGetBufferLengthForStringCopy"},
    {55, "DnsGetCacheDataTable"},
    {56, "DnsGetDnsServerList"},
    {1, "DnsGetDomainName"},
    {57, "DnsGetLastFailedUpdateInfo"},
    {58, "DnsGetPolicyTableInfo"},
    {59, "DnsGetPolicyTableInfoPrivate"},
    {60, "DnsGetPrimaryDomainName_A"},
    {61, "DnsGetProxyInfoPrivate"},
    {62, "DnsGetProxyInformation"},
    {63, "DnsGlobals"},
    {64, "DnsIpv6AddressToString"},
    {65, "DnsIpv6StringToAddress"},
    {2, "DnsIsAMailboxType"},
    {3, "DnsIsStatusRcode"},
    {66, "DnsIsStringCountValidForTextType"},
    {67, "DnsLogEvent"},
    {68, "DnsLogIn"},
    {69, "DnsLogInit"},
    {70, "DnsLogIt"},
    {71, "DnsLogOut"},
    {72, "DnsLogTime"},
    {4, "DnsMapRcodeToStatus"},
    {73, "DnsModifyRecordsInSet_A"},
    {74, "DnsModifyRecordsInSet_UTF8"},
    {75, "DnsModifyRecordsInSet_W"},
    {76, "DnsNameCompareEx_A"},
    {77, "DnsNameCompareEx_UTF8"},
    {78, "DnsNameCompareEx_W"},
    {79, "DnsNameCompare_A"},
    {80, "DnsNameCompare_UTF8"},
    {81, "DnsNameCompare_W"},
    {82, "DnsNameCopy"},
    {83, "DnsNameCopyAllocate"},
    {84, "DnsNetworkInfo_CreateFromFAZ"},
    {85, "DnsNetworkInformation_CreateFromFAZ"},
    {86, "DnsNotifyResolver"},
    {87, "DnsNotifyResolverClusterIp"},
    {88, "DnsNotifyResolverEx"},
    {89, "DnsQueryConfig"},
    {90, "DnsQueryConfigAllocEx"},
    {91, "DnsQueryConfigDword"},
    {92, "DnsQueryExA"},
    {93, "DnsQueryExUTF8"},
    {94, "DnsQueryExW"},
    {95, "DnsQuery_A"},
    {96, "DnsQuery_UTF8"},
    {97, "DnsQuery_W"},
    {98, "DnsRecordBuild_UTF8"},
    {99, "DnsRecordBuild_W"},
    {100, "DnsRecordCompare"},
    {101, "DnsRecordCopyEx"},
    {102, "DnsRecordListFree"},
    {103, "DnsRecordSetCompare"},
    {104, "DnsRecordSetCopyEx"},
    {105, "DnsRecordSetDetach"},
    {106, "DnsRecordStringForType"},
    {107, "DnsRecordStringForWritableType"},
    {108, "DnsRecordTypeForName"},
    {109, "DnsRegisterClusterAddress"},
    {110, "DnsReleaseContextHandle"},
    {111, "DnsRemoveRegistrations"},
    {112, "DnsReplaceRecordSetA"},
    {113, "DnsReplaceRecordSetUTF8"},
    {114, "DnsReplaceRecordSetW"},
    {115, "DnsResolverOp"},
    {116, "DnsScreenLocalAddrsForRegistration"},
    {117, "DnsSetConfigDword"},
    {5, "DnsStatusString"},
    {118, "DnsStringCopyAllocateEx"},
    {119, "DnsTraceServerConfig"},
    {6, "DnsUnicodeToUtf8"},
    {120, "DnsUpdate"},
    {121, "DnsUpdateMachinePresence"},
    {122, "DnsUpdateTest_A"},
    {123, "DnsUpdateTest_UTF8"},
    {124, "DnsUpdateTest_W"},
    {7, "DnsUtf8ToUnicode"},
    {125, "DnsValidateNameOrIp_TempW"},
    {126, "DnsValidateName_A"},
    {127, "DnsValidateName_UTF8"},
    {128, "DnsValidateName_W"},
    {129, "DnsValidateServerArray_A"},
    {130, "DnsValidateServerArray_W"},
    {131, "DnsValidateServerStatus"},
    {132, "DnsValidateServer_A"},
    {133, "DnsValidateServer_W"},
    {134, "DnsValidateUtf8Byte"},
    {135, "DnsWriteQuestionToBuffer_UTF8"},
    {136, "DnsWriteQuestionToBuffer_W"},
    {137, "DnsWriteReverseNameStringForIpAddress"},
    {138, "Dns_AddRecordsToMessage"},
    {139, "Dns_AllocateMsgBuf"},
    {140, "Dns_BuildPacket"},
    {141, "Dns_CleanupWinsock"},
    {142, "Dns_CloseConnection"},
    {143, "Dns_CloseSocket"},
    {144, "Dns_CreateMulticastSocket"},
    {145, "Dns_CreateSocket"},
    {146, "Dns_CreateSocketEx"},
    {147, "Dns_ExtractRecordsFromMessage"},
    {148, "Dns_FindAuthoritativeZoneLib"},
    {149, "Dns_FreeMsgBuf"},
    {150, "Dns_GetRandomXid"},
    {151, "Dns_InitializeMsgBuf"},
    {152, "Dns_InitializeMsgRemoteSockaddr"},
    {153, "Dns_InitializeWinsock"},
    {154, "Dns_OpenTcpConnectionAndSend"},
    {155, "Dns_ParseMessage"},
    {156, "Dns_ParsePacketRecord"},
    {157, "Dns_PingAdapterServers"},
    {8, "Dns_ReadPacketName"},
    {9, "Dns_ReadPacketNameAllocate"},
    {158, "Dns_ReadRecordStructureFromPacket"},
    {159, "Dns_RecvTcp"},
    {160, "Dns_ResetNetworkInfo"},
    {161, "Dns_SendAndRecvUdp"},
    {162, "Dns_SendEx"},
    {163, "Dns_SetRecordDatalength"},
    {164, "Dns_SetRecordsSection"},
    {165, "Dns_SetRecordsTtl"},
    {10, "Dns_SkipPacketName"},
    {166, "Dns_SkipToRecord"},
    {167, "Dns_UpdateLib"},
    {168, "Dns_UpdateLibEx"},
    {11, "Dns_WriteDottedNameToPacket"},
    {169, "Dns_WriteQuestionToMessage"},
    {170, "Dns_WriteRecordStructureToPacketEx"},
    {171, "ExtraInfo_Init"},
    {172, "Faz_AreServerListsInSameNameSpace"},
    {173, "FlushDnsPolicyUnreachableStatus"},
    {174, "GetCurrentTimeInSeconds"},
    {175, "HostsFile_Close"},
    {176, "HostsFile_Open"},
    {177, "HostsFile_ReadLine"},
    {178, "IpHelp_IsAddrOnLink"},
    {179, "Local_GetRecordsForLocalName"},
    {180, "Local_GetRecordsForLocalNameEx"},
    {181, "NetInfo_Build"},
    {182, "NetInfo_Clean"},
    {183, "NetInfo_Copy"},
    {184, "NetInfo_Free"},
    {185, "NetInfo_GetAdapterByAddress"},
    {186, "NetInfo_GetAdapterByInterfaceIndex"},
    {187, "NetInfo_GetAdapterByName"},
    {188, "NetInfo_IsAddrConfig"},
    {189, "NetInfo_IsForUpdate"},
    {190, "NetInfo_ResetServerPriorities"},
    {191, "NetInfo_UpdateServerReachability"},
    {192, "QueryDirectEx"},
    {193, "Query_Main"},
    {194, "Reg_FreeUpdateInfo"},
    {195, "Reg_GetValueEx"},
    {196, "Reg_ReadGlobalsEx"},
    {197, "Reg_ReadUpdateInfo"},
    {198, "Security_ContextListTimeout"},
    {199, "Send_AndRecvUdpWithParam"},
    {200, "Send_MessagePrivate"},
    {201, "Send_OpenTcpConnectionAndSend"},
    {202, "Socket_CacheCleanup"},
    {203, "Socket_CacheInit"},
    {204, "Socket_CleanupWinsock"},
    {205, "Socket_ClearMessageSockets"},
    {206, "Socket_CloseEx"},
    {207, "Socket_CloseMessageSockets"},
    {208, "Socket_Create"},
    {209, "Socket_CreateMulticast"},
    {210, "Socket_InitWinsock"},
    {211, "Socket_JoinMulticast"},
    {212, "Socket_RecvFrom"},
    {213, "Socket_SetMulticastInterface"},
    {214, "Socket_SetMulticastLoopBack"},
    {215, "Socket_SetTtl"},
    {216, "Socket_TcpListen"},
    {217, "Trace_Reset"},
    {218, "Update_ReplaceAddressRecordsW"},
    {219, "Util_IsIp6Running"},
    {0, NULL}};
static Dw32Ordinal dplayx[] = {
    {1, "DirectPlayCreate"},
    {9, "DirectPlayEnumerate"},
    {2, "DirectPlayEnumerateA"},
    {3, "DirectPlayEnumerateW"},
    {4, "DirectPlayLobbyCreateA"},
    {5, "DirectPlayLobbyCreateW"},
    {6, "DllCanUnloadNow"},
    {7, "DllGetClassObject"},
    {8, "DllRegisterServer"},
    {10, "DllUnregisterServer"},
    {11, "gdwDPlaySPRefCount"},
    {0, NULL}};
static Dw32Ordinal dpx[] = {
    {1, "DpxFreeMemory"},
    {2, "DpxNewJob"},
    {3, "DpxRestoreJob"},
    {0, NULL}};
static Dw32Ordinal dsound[] = {
    {6, "DirectSoundCaptureCreate"},
    {12, "DirectSoundCaptureCreate8"},
    {7, "DirectSoundCaptureEnumerateA"},
    {8, "DirectSoundCaptureEnumerateW"},
    {1, "DirectSoundCreate"},
    {11, "DirectSoundCreate8"},
    {2, "DirectSoundEnumerateA"},
    {3, "DirectSoundEnumerateW"},
    {10, "DirectSoundFullDuplexCreate"},
    {4, "DllCanUnloadNow"},
    {5, "DllGetClassObject"},
    {9, "GetDeviceID"},
    {0, NULL}};
static Dw32Ordinal dsprop[] = {
    {10, "ADsPropCheckIfWritable"},
    {11, "ADsPropCreateNotifyObj"},
    {12, "ADsPropGetInitInfo"},
    {13, "ADsPropSendErrorMessage"},
    {14, "ADsPropSetHwnd"},
    {15, "ADsPropSetHwndWithTitle"},
    {16, "ADsPropShowErrorDialog"},
    {17, "BringSheetToForeground"},
    {1, "CheckADsError"},
    {2, "CrackName"},
    {3, "DSPROP_GetGCSearchOnDomain"},
    {18, "DllCanUnloadNow"},
    {19, "DllGetClassObject"},
    {20, "DllRegisterServer"},
    {21, "DllUnregisterServer"},
    {4, "ErrMsg"},
    {5, "ErrMsgParam"},
    {6, "FindSheet"},
    {22, "IsSheetAlreadyUp"},
    {7, "MsgBox"},
    {23, "PostADsPropSheet"},
    {8, "ReportError"},
    {9, "Smart_PADS_ATTR_INFO__Empty"},
    {0, NULL}};
static Dw32Ordinal dsuiext[] = {
    {11, "DllCanUnloadNow"},
    {12, "DllGetClassObject"},
    {13, "DllInstall"},
    {14, "DllRegisterServer"},
    {15, "DllUnregisterServer"},
    {9, "DsBrowseForContainerA"},
    {10, "DsBrowseForContainerW"},
    {259, "DsGetFriendlyClassName"},
    {257, "DsGetIcon"},
    {0, NULL}};
static Dw32Ordinal dwmapi[] = {
    {111, "DwmAttachMilContent"},
    {116, "DwmDefWindowProc"},
    {117, "DwmDetachMilContent"},
    {122, "DwmEnableBlurBehindWindow"},
    {102, "DwmEnableComposition"},
    {123, "DwmEnableMMCSS"},
    {135, "DwmExtendFrameIntoClientArea"},
    {136, "DwmFlush"},
    {137, "DwmGetColorizationColor"},
    {138, "DwmGetCompositionTimingInfo"},
    {139, "DwmGetGraphicsStreamClient"},
    {140, "DwmGetGraphicsStreamTransformHint"},
    {141, "DwmGetTransportAttributes"},
    {142, "DwmGetWindowAttribute"},
    {143, "DwmInvalidateIconicBitmaps"},
    {144, "DwmIsCompositionEnabled"},
    {145, "DwmModifyPreviousDxFrameDuration"},
    {146, "DwmQueryThumbnailSourceSize"},
    {147, "DwmRegisterThumbnail"},
    {148, "DwmSetDxFrameDuration"},
    {149, "DwmSetIconicLivePreviewBitmap"},
    {150, "DwmSetIconicThumbnail"},
    {151, "DwmSetPresentParameters"},
    {152, "DwmSetWindowAttribute"},
    {153, "DwmUnregisterThumbnail"},
    {154, "DwmUpdateThumbnailProperties"},
    {0, NULL}};
static Dw32Ordinal dxgi[] = {
    {15, "CreateDXGIFactory"},
    {14, "CreateDXGIFactory1"},
    {1, "D3DKMTCloseAdapter"},
    {16, "D3DKMTCreateAllocation"},
    {17, "D3DKMTCreateContext"},
    {18, "D3DKMTCreateDevice"},
    {19, "D3DKMTCreateSynchronizationObject"},
    {2, "D3DKMTDestroyAllocation"},
    {3, "D3DKMTDestroyContext"},
    {4, "D3DKMTDestroyDevice"},
    {5, "D3DKMTDestroySynchronizationObject"},
    {20, "D3DKMTEscape"},
    {21, "D3DKMTGetContextSchedulingPriority"},
    {22, "D3DKMTGetDeviceState"},
    {23, "D3DKMTGetDisplayModeList"},
    {24, "D3DKMTGetMultisampleMethodList"},
    {25, "D3DKMTGetRuntimeData"},
    {26, "D3DKMTGetSharedPrimaryHandle"},
    {27, "D3DKMTLock"},
    {28, "D3DKMTOpenAdapterFromHdc"},
    {29, "D3DKMTOpenResource"},
    {30, "D3DKMTPresent"},
    {6, "D3DKMTQueryAdapterInfo"},
    {31, "D3DKMTQueryAllocationResidency"},
    {32, "D3DKMTQueryResourceInfo"},
    {33, "D3DKMTRender"},
    {34, "D3DKMTSetAllocationPriority"},
    {35, "D3DKMTSetContextSchedulingPriority"},
    {36, "D3DKMTSetDisplayMode"},
    {7, "D3DKMTSetDisplayPrivateDriverFormat"},
    {37, "D3DKMTSetGammaRamp"},
    {38, "D3DKMTSetVidPnSourceOwner"},
    {8, "D3DKMTSignalSynchronizationObject"},
    {9, "D3DKMTUnlock"},
    {10, "D3DKMTWaitForSynchronizationObject"},
    {39, "D3DKMTWaitForVerticalBlankEvent"},
    {40, "DXGID3D10CreateDevice"},
    {41, "DXGID3D10CreateLayeredDevice"},
    {42, "DXGID3D10GetLayeredDeviceSize"},
    {43, "DXGID3D10RegisterLayers"},
    {11, "DXGIDumpJournal"},
    {44, "DXGIReportAdapterConfiguration"},
    {12, "OpenAdapter10"},
    {13, "OpenAdapter10_2"},
    {0, NULL}};
static Dw32Ordinal dxva2[] = {
    {1, "CapabilitiesRequestAndCapabilitiesReply"},
    {2, "DXVA2CreateDirect3DDeviceManager9"},
    {3, "DXVA2CreateVideoService"},
    {4, "DXVAHD_CreateDevice"},
    {5, "DegaussMonitor"},
    {6, "DestroyPhysicalMonitor"},
    {7, "DestroyPhysicalMonitors"},
    {8, "GetCapabilitiesStringLength"},
    {9, "GetMonitorBrightness"},
    {10, "GetMonitorCapabilities"},
    {11, "GetMonitorColorTemperature"},
    {12, "GetMonitorContrast"},
    {13, "GetMonitorDisplayAreaPosition"},
    {14, "GetMonitorDisplayAreaSize"},
    {15, "GetMonitorRedGreenOrBlueDrive"},
    {16, "GetMonitorRedGreenOrBlueGain"},
    {17, "GetMonitorTechnologyType"},
    {18, "GetNumberOfPhysicalMonitorsFromHMONITOR"},
    {19, "GetNumberOfPhysicalMonitorsFromIDirect3DDevice9"},
    {20, "GetPhysicalMonitorsFromHMONITOR"},
    {21, "GetPhysicalMonitorsFromIDirect3DDevice9"},
    {22, "GetTimingReport"},
    {23, "GetVCPFeatureAndVCPFeatureReply"},
    {24, "OPMGetVideoOutputsFromHMONITOR"},
    {25, "OPMGetVideoOutputsFromIDirect3DDevice9Object"},
    {26, "RestoreMonitorFactoryColorDefaults"},
    {27, "RestoreMonitorFactoryDefaults"},
    {28, "SaveCurrentMonitorSettings"},
    {29, "SaveCurrentSettings"},
    {30, "SetMonitorBrightness"},
    {31, "SetMonitorColorTemperature"},
    {32, "SetMonitorContrast"},
    {33, "SetMonitorDisplayAreaPosition"},
    {34, "SetMonitorDisplayAreaSize"},
    {35, "SetMonitorRedGreenOrBlueDrive"},
    {36, "SetMonitorRedGreenOrBlueGain"},
    {37, "SetVCPFeature"},
    {0, NULL}};
static Dw32Ordinal eappcfg[] = {
    {1, "EapHostPeerConfigBlob2Xml"},
    {2, "EapHostPeerConfigXml2Blob"},
    {3, "EapHostPeerCredentialsXml2Blob"},
    {4, "EapHostPeerFreeErrorMemory"},
    {5, "EapHostPeerFreeMemory"},
    {6, "EapHostPeerGetMethodProperties"},
    {7, "EapHostPeerGetMethods"},
    {8, "EapHostPeerInvokeConfigUI"},
    {9, "EapHostPeerInvokeIdentityUI"},
    {10, "EapHostPeerInvokeInteractiveUI"},
    {11, "EapHostPeerQueryCredentialInputFields"},
    {12, "EapHostPeerQueryInteractiveUIInputFields"},
    {13, "EapHostPeerQueryUIBlobFromInteractiveUIInputFields"},
    {14, "EapHostPeerQueryUserBlobFromCredentialInputFields"},
    {0, NULL}};
static Dw32Ordinal eappprxy[] = {
    {1, "EapHostPeerBeginSession"},
    {2, "EapHostPeerClearConnection"},
    {3, "EapHostPeerEndSession"},
    {4, "EapHostPeerFreeEapError"},
    {5, "EapHostPeerFreeRuntimeMemory"},
    {6, "EapHostPeerGetAuthStatus"},
    {7, "EapHostPeerGetIdentity"},
    {8, "EapHostPeerGetResponseAttributes"},
    {9, "EapHostPeerGetResult"},
    {10, "EapHostPeerGetSendPacket"},
    {11, "EapHostPeerGetUIContext"},
    {12, "EapHostPeerInitialize"},
    {13, "EapHostPeerProcessReceivedPacket"},
    {14, "EapHostPeerSetResponseAttributes"},
    {15, "EapHostPeerSetUIContext"},
    {16, "EapHostPeerUninitialize"},
    {0, NULL}};
static Dw32Ordinal encapi[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal esent[] = {
    {260, "DebugExtensionInitialize"},
    {1, "DebugExtensionInitialize@8"},
    {261, "DebugExtensionNotify"},
    {2, "DebugExtensionNotify@12"},
    {262, "DebugExtensionUninitialize"},
    {3, "DebugExtensionUninitialize@0"},
    {263, "JetAddColumn"},
    {264, "JetAddColumnA"},
    {4, "JetAddColumnA@28"},
    {265, "JetAddColumnW"},
    {5, "JetAddColumnW@28"},
    {269, "JetAttachDatabase"},
    {266, "JetAttachDatabase2"},
    {267, "JetAttachDatabase2A"},
    {6, "JetAttachDatabase2A@16"},
    {268, "JetAttachDatabase2W"},
    {7, "JetAttachDatabase2W@16"},
    {270, "JetAttachDatabaseA"},
    {8, "JetAttachDatabaseA@12"},
    {271, "JetAttachDatabaseW"},
    {9, "JetAttachDatabaseW@12"},
    {272, "JetAttachDatabaseWithStreaming"},
    {273, "JetAttachDatabaseWithStreamingA"},
    {10, "JetAttachDatabaseWithStreamingA@24"},
    {274, "JetAttachDatabaseWithStreamingW"},
    {11, "JetAttachDatabaseWithStreamingW@24"},
    {275, "JetBackup"},
    {276, "JetBackupA"},
    {12, "JetBackupA@12"},
    {277, "JetBackupInstance"},
    {278, "JetBackupInstanceA"},
    {13, "JetBackupInstanceA@16"},
    {279, "JetBackupInstanceW"},
    {14, "JetBackupInstanceW@16"},
    {280, "JetBackupW"},
    {15, "JetBackupW@12"},
    {281, "JetBeginDatabaseIncrementalReseed"},
    {282, "JetBeginDatabaseIncrementalReseedA"},
    {16, "JetBeginDatabaseIncrementalReseedA@12"},
    {283, "JetBeginDatabaseIncrementalReseedW"},
    {17, "JetBeginDatabaseIncrementalReseedW@12"},
    {284, "JetBeginExternalBackup"},
    {18, "JetBeginExternalBackup@4"},
    {285, "JetBeginExternalBackupInstance"},
    {19, "JetBeginExternalBackupInstance@8"},
    {286, "JetBeginSession"},
    {287, "JetBeginSessionA"},
    {20, "JetBeginSessionA@16"},
    {288, "JetBeginSessionW"},
    {21, "JetBeginSessionW@16"},
    {289, "JetBeginSurrogateBackup"},
    {22, "JetBeginSurrogateBackup@16"},
    {291, "JetBeginTransaction"},
    {290, "JetBeginTransaction2"},
    {23, "JetBeginTransaction2@8"},
    {24, "JetBeginTransaction@4"},
    {292, "JetCloseDatabase"},
    {25, "JetCloseDatabase@12"},
    {293, "JetCloseFile"},
    {26, "JetCloseFile@4"},
    {294, "JetCloseFileInstance"},
    {27, "JetCloseFileInstance@8"},
    {295, "JetCloseTable"},
    {28, "JetCloseTable@8"},
    {296, "JetCommitTransaction"},
    {29, "JetCommitTransaction@8"},
    {297, "JetCompact"},
    {298, "JetCompactA"},
    {30, "JetCompactA@24"},
    {299, "JetCompactW"},
    {31, "JetCompactW@24"},
    {300, "JetComputeStats"},
    {32, "JetComputeStats@8"},
    {301, "JetConfigureProcessForCrashDump"},
    {33, "JetConfigureProcessForCrashDump@4"},
    {302, "JetConvertDDL"},
    {303, "JetConvertDDLA"},
    {34, "JetConvertDDLA@20"},
    {304, "JetConvertDDLW"},
    {35, "JetConvertDDLW@20"},
    {308, "JetCreateDatabase"},
    {305, "JetCreateDatabase2"},
    {306, "JetCreateDatabase2A"},
    {36, "JetCreateDatabase2A@20"},
    {307, "JetCreateDatabase2W"},
    {37, "JetCreateDatabase2W@20"},
    {309, "JetCreateDatabaseA"},
    {38, "JetCreateDatabaseA@20"},
    {310, "JetCreateDatabaseW"},
    {39, "JetCreateDatabaseW@20"},
    {311, "JetCreateDatabaseWithStreaming"},
    {312, "JetCreateDatabaseWithStreamingA"},
    {40, "JetCreateDatabaseWithStreamingA@28"},
    {313, "JetCreateDatabaseWithStreamingW"},
    {41, "JetCreateDatabaseWithStreamingW@28"},
    {319, "JetCreateIndex"},
    {314, "JetCreateIndex2"},
    {315, "JetCreateIndex2A"},
    {42, "JetCreateIndex2A@16"},
    {316, "JetCreateIndex2W"},
    {43, "JetCreateIndex2W@16"},
    {317, "JetCreateIndex3A"},
    {318, "JetCreateIndex3W"},
    {320, "JetCreateIndexA"},
    {44, "JetCreateIndexA@28"},
    {321, "JetCreateIndexW"},
    {45, "JetCreateIndexW@28"},
    {325, "JetCreateInstance"},
    {322, "JetCreateInstance2"},
    {323, "JetCreateInstance2A"},
    {46, "JetCreateInstance2A@16"},
    {324, "JetCreateInstance2W"},
    {47, "JetCreateInstance2W@16"},
    {326, "JetCreateInstanceA"},
    {48, "JetCreateInstanceA@8"},
    {327, "JetCreateInstanceW"},
    {49, "JetCreateInstanceW@8"},
    {328, "JetCreateTable"},
    {329, "JetCreateTableA"},
    {50, "JetCreateTableA@24"},
    {335, "JetCreateTableColumnIndex"},
    {330, "JetCreateTableColumnIndex2"},
    {331, "JetCreateTableColumnIndex2A"},
    {51, "JetCreateTableColumnIndex2A@12"},
    {332, "JetCreateTableColumnIndex2W"},
    {52, "JetCreateTableColumnIndex2W@12"},
    {333, "JetCreateTableColumnIndex3A"},
    {53, "JetCreateTableColumnIndex3A@12"},
    {334, "JetCreateTableColumnIndex3W"},
    {54, "JetCreateTableColumnIndex3W@12"},
    {336, "JetCreateTableColumnIndexA"},
    {55, "JetCreateTableColumnIndexA@12"},
    {337, "JetCreateTableColumnIndexW"},
    {56, "JetCreateTableColumnIndexW@12"},
    {338, "JetCreateTableW"},
    {57, "JetCreateTableW@24"},
    {339, "JetDBUtilities"},
    {340, "JetDBUtilitiesA"},
    {58, "JetDBUtilitiesA@4"},
    {341, "JetDBUtilitiesW"},
    {59, "JetDBUtilitiesW@4"},
    {342, "JetDatabaseScan"},
    {60, "JetDatabaseScan@24"},
    {349, "JetDefragment"},
    {343, "JetDefragment2"},
    {344, "JetDefragment2A"},
    {61, "JetDefragment2A@28"},
    {345, "JetDefragment2W"},
    {62, "JetDefragment2W@28"},
    {346, "JetDefragment3"},
    {347, "JetDefragment3A"},
    {63, "JetDefragment3A@32"},
    {348, "JetDefragment3W"},
    {64, "JetDefragment3W@32"},
    {350, "JetDefragmentA"},
    {65, "JetDefragmentA@24"},
    {351, "JetDefragmentW"},
    {66, "JetDefragmentW@24"},
    {352, "JetDelete"},
    {67, "JetDelete@8"},
    {356, "JetDeleteColumn"},
    {353, "JetDeleteColumn2"},
    {354, "JetDeleteColumn2A"},
    {68, "JetDeleteColumn2A@16"},
    {355, "JetDeleteColumn2W"},
    {69, "JetDeleteColumn2W@16"},
    {357, "JetDeleteColumnA"},
    {70, "JetDeleteColumnA@12"},
    {358, "JetDeleteColumnW"},
    {71, "JetDeleteColumnW@12"},
    {359, "JetDeleteIndex"},
    {360, "JetDeleteIndexA"},
    {72, "JetDeleteIndexA@12"},
    {361, "JetDeleteIndexW"},
    {73, "JetDeleteIndexW@12"},
    {362, "JetDeleteTable"},
    {363, "JetDeleteTableA"},
    {74, "JetDeleteTableA@12"},
    {364, "JetDeleteTableW"},
    {75, "JetDeleteTableW@12"},
    {368, "JetDetachDatabase"},
    {365, "JetDetachDatabase2"},
    {366, "JetDetachDatabase2A"},
    {76, "JetDetachDatabase2A@12"},
    {367, "JetDetachDatabase2W"},
    {77, "JetDetachDatabase2W@12"},
    {369, "JetDetachDatabaseA"},
    {78, "JetDetachDatabaseA@8"},
    {370, "JetDetachDatabaseW"},
    {79, "JetDetachDatabaseW@8"},
    {371, "JetDupCursor"},
    {80, "JetDupCursor@16"},
    {372, "JetDupSession"},
    {81, "JetDupSession@8"},
    {373, "JetEnableFaultInjection"},
    {82, "JetEnableFaultInjection@16"},
    {374, "JetEnableMultiInstance"},
    {375, "JetEnableMultiInstanceA"},
    {83, "JetEnableMultiInstanceA@12"},
    {376, "JetEnableMultiInstanceW"},
    {84, "JetEnableMultiInstanceW@12"},
    {377, "JetEndDatabaseIncrementalReseed"},
    {378, "JetEndDatabaseIncrementalReseedA"},
    {85, "JetEndDatabaseIncrementalReseedA@20"},
    {379, "JetEndDatabaseIncrementalReseedW"},
    {86, "JetEndDatabaseIncrementalReseedW@20"},
    {380, "JetEndExternalBackup"},
    {87, "JetEndExternalBackup@0"},
    {382, "JetEndExternalBackupInstance"},
    {381, "JetEndExternalBackupInstance2"},
    {88, "JetEndExternalBackupInstance2@8"},
    {89, "JetEndExternalBackupInstance@4"},
    {383, "JetEndSession"},
    {90, "JetEndSession@8"},
    {384, "JetEndSurrogateBackup"},
    {91, "JetEndSurrogateBackup@8"},
    {385, "JetEnumerateColumns"},
    {92, "JetEnumerateColumns@40"},
    {386, "JetEscrowUpdate"},
    {93, "JetEscrowUpdate@36"},
    {390, "JetExternalRestore"},
    {387, "JetExternalRestore2"},
    {388, "JetExternalRestore2A"},
    {94, "JetExternalRestore2A@40"},
    {389, "JetExternalRestore2W"},
    {95, "JetExternalRestore2W@40"},
    {391, "JetExternalRestoreA"},
    {96, "JetExternalRestoreA@32"},
    {392, "JetExternalRestoreW"},
    {97, "JetExternalRestoreW@32"},
    {393, "JetFreeBuffer"},
    {98, "JetFreeBuffer@4"},
    {394, "JetGetAttachInfo"},
    {395, "JetGetAttachInfoA"},
    {99, "JetGetAttachInfoA@12"},
    {396, "JetGetAttachInfoInstance"},
    {397, "JetGetAttachInfoInstanceA"},
    {100, "JetGetAttachInfoInstanceA@16"},
    {398, "JetGetAttachInfoInstanceW"},
    {101, "JetGetAttachInfoInstanceW@16"},
    {399, "JetGetAttachInfoW"},
    {102, "JetGetAttachInfoW@12"},
    {400, "JetGetBookmark"},
    {103, "JetGetBookmark@20"},
    {401, "JetGetColumnInfo"},
    {402, "JetGetColumnInfoA"},
    {104, "JetGetColumnInfoA@28"},
    {403, "JetGetColumnInfoW"},
    {105, "JetGetColumnInfoW@28"},
    {404, "JetGetCounter"},
    {106, "JetGetCounter@12"},
    {405, "JetGetCurrentIndex"},
    {406, "JetGetCurrentIndexA"},
    {107, "JetGetCurrentIndexA@16"},
    {407, "JetGetCurrentIndexW"},
    {108, "JetGetCurrentIndexW@16"},
    {408, "JetGetCursorInfo"},
    {109, "JetGetCursorInfo@20"},
    {409, "JetGetDatabaseFileInfo"},
    {410, "JetGetDatabaseFileInfoA"},
    {110, "JetGetDatabaseFileInfoA@16"},
    {411, "JetGetDatabaseFileInfoW"},
    {111, "JetGetDatabaseFileInfoW@16"},
    {412, "JetGetDatabaseInfo"},
    {413, "JetGetDatabaseInfoA"},
    {112, "JetGetDatabaseInfoA@20"},
    {414, "JetGetDatabaseInfoW"},
    {113, "JetGetDatabaseInfoW@20"},
    {415, "JetGetDatabasePages"},
    {114, "JetGetDatabasePages@32"},
    {416, "JetGetIndexInfo"},
    {417, "JetGetIndexInfoA"},
    {115, "JetGetIndexInfoA@28"},
    {418, "JetGetIndexInfoW"},
    {116, "JetGetIndexInfoW@28"},
    {419, "JetGetInstanceInfo"},
    {420, "JetGetInstanceInfoA"},
    {117, "JetGetInstanceInfoA@8"},
    {421, "JetGetInstanceInfoW"},
    {118, "JetGetInstanceInfoW@8"},
    {422, "JetGetInstanceMiscInfo"},
    {119, "JetGetInstanceMiscInfo@16"},
    {423, "JetGetLS"},
    {120, "JetGetLS@16"},
    {424, "JetGetLock"},
    {121, "JetGetLock@12"},
    {425, "JetGetLogFileInfo"},
    {426, "JetGetLogFileInfoA"},
    {122, "JetGetLogFileInfoA@16"},
    {427, "JetGetLogFileInfoW"},
    {123, "JetGetLogFileInfoW@16"},
    {428, "JetGetLogInfo"},
    {429, "JetGetLogInfoA"},
    {124, "JetGetLogInfoA@12"},
    {433, "JetGetLogInfoInstance"},
    {430, "JetGetLogInfoInstance2"},
    {431, "JetGetLogInfoInstance2A"},
    {125, "JetGetLogInfoInstance2A@20"},
    {432, "JetGetLogInfoInstance2W"},
    {126, "JetGetLogInfoInstance2W@20"},
    {434, "JetGetLogInfoInstanceA"},
    {127, "JetGetLogInfoInstanceA@16"},
    {435, "JetGetLogInfoInstanceW"},
    {128, "JetGetLogInfoInstanceW@16"},
    {436, "JetGetLogInfoW"},
    {129, "JetGetLogInfoW@12"},
    {437, "JetGetMaxDatabaseSize"},
    {130, "JetGetMaxDatabaseSize@16"},
    {438, "JetGetObjectInfo"},
    {439, "JetGetObjectInfoA"},
    {131, "JetGetObjectInfoA@32"},
    {440, "JetGetObjectInfoW"},
    {132, "JetGetObjectInfoW@32"},
    {442, "JetGetPageInfo"},
    {441, "JetGetPageInfo2"},
    {133, "JetGetPageInfo2@24"},
    {134, "JetGetPageInfo@24"},
    {443, "JetGetRecordPosition"},
    {135, "JetGetRecordPosition@16"},
    {445, "JetGetRecordSize"},
    {444, "JetGetRecordSize2"},
    {136, "JetGetRecordSize2@16"},
    {137, "JetGetRecordSize@16"},
    {446, "JetGetResourceParam"},
    {138, "JetGetResourceParam@16"},
    {447, "JetGetSecondaryIndexBookmark"},
    {139, "JetGetSecondaryIndexBookmark@36"},
    {448, "JetGetSessionInfo"},
    {140, "JetGetSessionInfo@16"},
    {449, "JetGetSystemParameter"},
    {450, "JetGetSystemParameterA"},
    {141, "JetGetSystemParameterA@24"},
    {451, "JetGetSystemParameterW"},
    {142, "JetGetSystemParameterW@24"},
    {452, "JetGetTableColumnInfo"},
    {453, "JetGetTableColumnInfoA"},
    {143, "JetGetTableColumnInfoA@24"},
    {454, "JetGetTableColumnInfoW"},
    {144, "JetGetTableColumnInfoW@24"},
    {455, "JetGetTableIndexInfo"},
    {456, "JetGetTableIndexInfoA"},
    {145, "JetGetTableIndexInfoA@24"},
    {457, "JetGetTableIndexInfoW"},
    {146, "JetGetTableIndexInfoW@24"},
    {458, "JetGetTableInfo"},
    {459, "JetGetTableInfoA"},
    {147, "JetGetTableInfoA@20"},
    {460, "JetGetTableInfoW"},
    {148, "JetGetTableInfoW@20"},
    {461, "JetGetThreadStats"},
    {149, "JetGetThreadStats@8"},
    {462, "JetGetTruncateLogInfoInstance"},
    {463, "JetGetTruncateLogInfoInstanceA"},
    {150, "JetGetTruncateLogInfoInstanceA@16"},
    {464, "JetGetTruncateLogInfoInstanceW"},
    {151, "JetGetTruncateLogInfoInstanceW@16"},
    {465, "JetGetVersion"},
    {152, "JetGetVersion@8"},
    {466, "JetGotoBookmark"},
    {153, "JetGotoBookmark@16"},
    {467, "JetGotoPosition"},
    {154, "JetGotoPosition@12"},
    {468, "JetGotoSecondaryIndexBookmark"},
    {155, "JetGotoSecondaryIndexBookmark@28"},
    {469, "JetGrowDatabase"},
    {156, "JetGrowDatabase@16"},
    {470, "JetIdle"},
    {157, "JetIdle@8"},
    {471, "JetIndexRecordCount"},
    {158, "JetIndexRecordCount@16"},
    {476, "JetInit"},
    {472, "JetInit2"},
    {159, "JetInit2@8"},
    {473, "JetInit3"},
    {474, "JetInit3A"},
    {160, "JetInit3A@12"},
    {475, "JetInit3W"},
    {161, "JetInit3W@12"},
    {162, "JetInit@4"},
    {477, "JetIntersectIndexes"},
    {163, "JetIntersectIndexes@20"},
    {478, "JetMakeKey"},
    {164, "JetMakeKey@20"},
    {479, "JetMove"},
    {165, "JetMove@16"},
    {480, "JetOSSnapshotAbort"},
    {166, "JetOSSnapshotAbort@8"},
    {481, "JetOSSnapshotEnd"},
    {167, "JetOSSnapshotEnd@8"},
    {482, "JetOSSnapshotFreeze"},
    {483, "JetOSSnapshotFreezeA"},
    {168, "JetOSSnapshotFreezeA@16"},
    {484, "JetOSSnapshotFreezeW"},
    {169, "JetOSSnapshotFreezeW@16"},
    {485, "JetOSSnapshotGetFreezeInfo"},
    {486, "JetOSSnapshotGetFreezeInfoA"},
    {170, "JetOSSnapshotGetFreezeInfoA@16"},
    {487, "JetOSSnapshotGetFreezeInfoW"},
    {171, "JetOSSnapshotGetFreezeInfoW@16"},
    {488, "JetOSSnapshotPrepare"},
    {172, "JetOSSnapshotPrepare@8"},
    {489, "JetOSSnapshotPrepareInstance"},
    {173, "JetOSSnapshotPrepareInstance@12"},
    {490, "JetOSSnapshotThaw"},
    {174, "JetOSSnapshotThaw@8"},
    {491, "JetOSSnapshotTruncateLog"},
    {175, "JetOSSnapshotTruncateLog@8"},
    {492, "JetOSSnapshotTruncateLogInstance"},
    {176, "JetOSSnapshotTruncateLogInstance@12"},
    {493, "JetOpenDatabase"},
    {494, "JetOpenDatabaseA"},
    {177, "JetOpenDatabaseA@20"},
    {495, "JetOpenDatabaseW"},
    {178, "JetOpenDatabaseW@20"},
    {496, "JetOpenFile"},
    {497, "JetOpenFileA"},
    {179, "JetOpenFileA@16"},
    {498, "JetOpenFileInstance"},
    {499, "JetOpenFileInstanceA"},
    {180, "JetOpenFileInstanceA@20"},
    {500, "JetOpenFileInstanceW"},
    {181, "JetOpenFileInstanceW@20"},
    {501, "JetOpenFileSectionInstance"},
    {502, "JetOpenFileSectionInstanceA"},
    {182, "JetOpenFileSectionInstanceA@28"},
    {503, "JetOpenFileSectionInstanceW"},
    {183, "JetOpenFileSectionInstanceW@28"},
    {504, "JetOpenFileW"},
    {184, "JetOpenFileW@16"},
    {505, "JetOpenTable"},
    {506, "JetOpenTableA"},
    {185, "JetOpenTableA@28"},
    {507, "JetOpenTableW"},
    {186, "JetOpenTableW@28"},
    {510, "JetOpenTempTable"},
    {508, "JetOpenTempTable2"},
    {187, "JetOpenTempTable2@28"},
    {509, "JetOpenTempTable3"},
    {188, "JetOpenTempTable3@28"},
    {189, "JetOpenTempTable@24"},
    {511, "JetOpenTemporaryTable"},
    {190, "JetOpenTemporaryTable@8"},
    {512, "JetPatchDatabasePages"},
    {513, "JetPatchDatabasePagesA"},
    {191, "JetPatchDatabasePagesA@28"},
    {514, "JetPatchDatabasePagesW"},
    {192, "JetPatchDatabasePagesW@28"},
    {515, "JetPrepareToCommitTransaction"},
    {193, "JetPrepareToCommitTransaction@16"},
    {516, "JetPrepareUpdate"},
    {194, "JetPrepareUpdate@12"},
    {517, "JetPrereadKeys"},
    {195, "JetPrereadKeys@28"},
    {518, "JetReadFile"},
    {196, "JetReadFile@16"},
    {519, "JetReadFileInstance"},
    {197, "JetReadFileInstance@20"},
    {520, "JetRegisterCallback"},
    {198, "JetRegisterCallback@24"},
    {521, "JetRemoveLogfileA"},
    {199, "JetRemoveLogfileA@12"},
    {522, "JetRemoveLogfileW"},
    {200, "JetRemoveLogfileW@12"},
    {523, "JetRenameColumn"},
    {524, "JetRenameColumnA"},
    {201, "JetRenameColumnA@20"},
    {525, "JetRenameColumnW"},
    {202, "JetRenameColumnW@20"},
    {526, "JetRenameTable"},
    {527, "JetRenameTableA"},
    {203, "JetRenameTableA@16"},
    {528, "JetRenameTableW"},
    {204, "JetRenameTableW@16"},
    {529, "JetResetCounter"},
    {205, "JetResetCounter@8"},
    {530, "JetResetSessionContext"},
    {206, "JetResetSessionContext@4"},
    {531, "JetResetTableSequential"},
    {207, "JetResetTableSequential@12"},
    {535, "JetRestore"},
    {532, "JetRestore2"},
    {533, "JetRestore2A"},
    {208, "JetRestore2A@12"},
    {534, "JetRestore2W"},
    {209, "JetRestore2W@12"},
    {536, "JetRestoreA"},
    {210, "JetRestoreA@8"},
    {537, "JetRestoreInstance"},
    {538, "JetRestoreInstanceA"},
    {211, "JetRestoreInstanceA@16"},
    {539, "JetRestoreInstanceW"},
    {212, "JetRestoreInstanceW@16"},
    {540, "JetRestoreW"},
    {213, "JetRestoreW@8"},
    {541, "JetRetrieveColumn"},
    {214, "JetRetrieveColumn@32"},
    {542, "JetRetrieveColumns"},
    {215, "JetRetrieveColumns@16"},
    {543, "JetRetrieveKey"},
    {216, "JetRetrieveKey@24"},
    {544, "JetRetrieveTaggedColumnList"},
    {217, "JetRetrieveTaggedColumnList@28"},
    {545, "JetRollback"},
    {218, "JetRollback@8"},
    {546, "JetSeek"},
    {219, "JetSeek@12"},
    {547, "JetSetColumn"},
    {220, "JetSetColumn@28"},
    {548, "JetSetColumnDefaultValue"},
    {549, "JetSetColumnDefaultValueA"},
    {221, "JetSetColumnDefaultValueA@28"},
    {550, "JetSetColumnDefaultValueW"},
    {222, "JetSetColumnDefaultValueW@28"},
    {551, "JetSetColumns"},
    {223, "JetSetColumns@16"},
    {561, "JetSetCurrentIndex"},
    {552, "JetSetCurrentIndex2"},
    {553, "JetSetCurrentIndex2A"},
    {224, "JetSetCurrentIndex2A@16"},
    {554, "JetSetCurrentIndex2W"},
    {225, "JetSetCurrentIndex2W@16"},
    {555, "JetSetCurrentIndex3"},
    {556, "JetSetCurrentIndex3A"},
    {226, "JetSetCurrentIndex3A@20"},
    {557, "JetSetCurrentIndex3W"},
    {227, "JetSetCurrentIndex3W@20"},
    {558, "JetSetCurrentIndex4"},
    {559, "JetSetCurrentIndex4A"},
    {228, "JetSetCurrentIndex4A@24"},
    {560, "JetSetCurrentIndex4W"},
    {229, "JetSetCurrentIndex4W@24"},
    {562, "JetSetCurrentIndexA"},
    {230, "JetSetCurrentIndexA@12"},
    {563, "JetSetCurrentIndexW"},
    {231, "JetSetCurrentIndexW@12"},
    {564, "JetSetDatabaseSize"},
    {565, "JetSetDatabaseSizeA"},
    {232, "JetSetDatabaseSizeA@16"},
    {566, "JetSetDatabaseSizeW"},
    {233, "JetSetDatabaseSizeW@16"},
    {567, "JetSetIndexRange"},
    {234, "JetSetIndexRange@12"},
    {568, "JetSetLS"},
    {235, "JetSetLS@16"},
    {569, "JetSetMaxDatabaseSize"},
    {236, "JetSetMaxDatabaseSize@16"},
    {570, "JetSetResourceParam"},
    {237, "JetSetResourceParam@16"},
    {571, "JetSetSessionContext"},
    {238, "JetSetSessionContext@8"},
    {572, "JetSetSystemParameter"},
    {573, "JetSetSystemParameterA"},
    {239, "JetSetSystemParameterA@20"},
    {574, "JetSetSystemParameterW"},
    {240, "JetSetSystemParameterW@20"},
    {575, "JetSetTableSequential"},
    {241, "JetSetTableSequential@12"},
    {576, "JetSnapshotStart"},
    {577, "JetSnapshotStartA"},
    {242, "JetSnapshotStartA@12"},
    {578, "JetSnapshotStartW"},
    {243, "JetSnapshotStartW@12"},
    {579, "JetSnapshotStop"},
    {244, "JetSnapshotStop@8"},
    {580, "JetStopBackup"},
    {245, "JetStopBackup@0"},
    {581, "JetStopBackupInstance"},
    {246, "JetStopBackupInstance@4"},
    {582, "JetStopService"},
    {247, "JetStopService@0"},
    {583, "JetStopServiceInstance"},
    {248, "JetStopServiceInstance@4"},
    {585, "JetTerm"},
    {584, "JetTerm2"},
    {249, "JetTerm2@8"},
    {250, "JetTerm@4"},
    {586, "JetTest"},
    {251, "JetTest@4"},
    {587, "JetTracing"},
    {252, "JetTracing@12"},
    {588, "JetTruncateLog"},
    {253, "JetTruncateLog@0"},
    {589, "JetTruncateLogInstance"},
    {254, "JetTruncateLogInstance@4"},
    {590, "JetUnregisterCallback"},
    {255, "JetUnregisterCallback@16"},
    {592, "JetUpdate"},
    {591, "JetUpdate2"},
    {256, "JetUpdate2@24"},
    {257, "JetUpdate@20"},
    {593, "JetUpgradeDatabase"},
    {594, "JetUpgradeDatabaseA"},
    {258, "JetUpgradeDatabaseA@16"},
    {595, "JetUpgradeDatabaseW"},
    {259, "JetUpgradeDatabaseW@16"},
    {596, "ese"},
    {597, "ese@8"},
    {0, NULL}};
static Dw32Ordinal evr[] = {
    {2, "DllCanUnloadNow"},
    {3, "DllGetClassObject"},
    {4, "DllRegisterServer"},
    {5, "DllUnregisterServer"},
    {6, "MFConvertColorInfoFromDXVA"},
    {7, "MFConvertColorInfoToDXVA"},
    {8, "MFConvertFromFP16Array"},
    {9, "MFConvertToFP16Array"},
    {10, "MFCopyImage"},
    {11, "MFCreateDXSurfaceBuffer"},
    {12, "MFCreateVideoMediaType"},
    {13, "MFCreateVideoMediaTypeFromBitMapInfoHeader"},
    {14, "MFCreateVideoMediaTypeFromSubtype"},
    {16, "MFCreateVideoMediaTypeFromVideoInfoHeader"},
    {15, "MFCreateVideoMediaTypeFromVideoInfoHeader2"},
    {17, "MFCreateVideoMixer"},
    {18, "MFCreateVideoMixerAndPresenter"},
    {19, "MFCreateVideoOTA"},
    {21, "MFCreateVideoPresenter"},
    {20, "MFCreateVideoPresenter2"},
    {22, "MFCreateVideoSampleAllocator"},
    {23, "MFCreateVideoSampleFromSurface"},
    {24, "MFGetPlaneSize"},
    {25, "MFGetStrideForBitmapInfoHeader"},
    {1, "MFGetUncompressedVideoFormat"},
    {26, "MFInitVideoFormat"},
    {27, "MFInitVideoFormat_RGB"},
    {28, "MFIsFormatYUV"},
    {0, NULL}};
static Dw32Ordinal faultrep[] = {
    {1, "AddERExcludedApplicationA"},
    {2, "AddERExcludedApplicationW"},
    {7, "CancelHangReporting"},
    {3, "CheckPerUserCrossProcessThrottle"},
    {8, "DllCanUnloadNow"},
    {9, "DllGetClassObject"},
    {4, "ReportFault"},
    {10, "ReportHang"},
    {5, "UpdatePerUserLastCrossProcessCollectionTime"},
    {6, "WerReportHang"},
    {11, "WerpInitiateCrashReporting"},
    {0, NULL}};
static Dw32Ordinal framedyn[] = {
    {1, "??0CAutoEvent@@QAE@XZ"},
    {2, "??0CFrameworkQuery@@QAE@ABV0@@Z"},
    {3, "??0CFrameworkQuery@@QAE@XZ"},
    {4, "??0CFrameworkQueryEx@@QAE@ABV0@@Z"},
    {5, "??0CFrameworkQueryEx@@QAE@XZ"},
    {6, "??0CHPtrArray@@QAE@XZ"},
    {7, "??0CHString@@QAE@ABV0@@Z"},
    {8, "??0CHString@@QAE@GH@Z"},
    {9, "??0CHString@@QAE@PBD@Z"},
    {10, "??0CHString@@QAE@PBE@Z"},
    {11, "??0CHString@@QAE@PBG@Z"},
    {12, "??0CHString@@QAE@PBGH@Z"},
    {13, "??0CHString@@QAE@XZ"},
    {14, "??0CHStringArray@@QAE@XZ"},
    {15, "??0CInstance@@QAE@ABV0@@Z"},
    {16, "??0CInstance@@QAE@PAUIWbemClassObject@@PAVMethodContext@@@Z"},
    {17, "??0CObjectPathParser@@QAE@W4ObjectParserFlags@@@Z"},
    {18, "??0CRegistry@@QAE@ABV0@@Z"},
    {19, "??0CRegistry@@QAE@XZ"},
    {20, "??0CRegistrySearch@@QAE@ABV0@@Z"},
    {21, "??0CRegistrySearch@@QAE@XZ"},
    {22, "??0CThreadBase@@QAE@ABV0@@Z"},
    {23, "??0CThreadBase@@QAE@W4THREAD_SAFETY_MECHANISM@0@@Z"},
    {24, "??0CWbemGlueFactory@@QAE@ABV0@@Z"},
    {25, "??0CWbemGlueFactory@@QAE@PAJ@Z"},
    {26, "??0CWbemGlueFactory@@QAE@XZ"},
    {27, "??0CWbemProviderGlue@@QAE@ABV0@@Z"},
    {28, "??0CWbemProviderGlue@@QAE@PAJ@Z"},
    {29, "??0CWbemProviderGlue@@QAE@XZ"},
    {30, "??0CWinMsgEvent@@QAE@ABV0@@Z"},
    {31, "??0CWinMsgEvent@@QAE@XZ"},
    {32, "??0CreateMutexAsProcess@@QAE@PBG@Z"},
    {33, "??0KeyRef@@QAE@PBGPBUtagVARIANT@@@Z"},
    {34, "??0KeyRef@@QAE@XZ"},
    {35, "??0MethodContext@@QAE@ABV0@@Z"},
    {36, "??0MethodContext@@QAE@PAUIWbemContext@@PAVCWbemProviderGlue@@@Z"},
    {37, "??0ParsedObjectPath@@QAE@XZ"},
    {38, "??0Provider@@QAE@ABV0@@Z"},
    {39, "??0Provider@@QAE@PBG0@Z"},
    {40, "??0ProviderLog@@QAE@ABV0@@Z"},
    {41, "??0ProviderLog@@QAE@XZ"},
    {42, "??0WBEMTime@@QAE@ABJ@Z"},
    {43, "??0WBEMTime@@QAE@ABU_FILETIME@@@Z"},
    {44, "??0WBEMTime@@QAE@ABU_SYSTEMTIME@@@Z"},
    {45, "??0WBEMTime@@QAE@ABUtm@@@Z"},
    {46, "??0WBEMTime@@QAE@QAG@Z"},
    {47, "??0WBEMTime@@QAE@XZ"},
    {48, "??0WBEMTimeSpan@@QAE@ABJ@Z"},
    {49, "??0WBEMTimeSpan@@QAE@ABU_FILETIME@@@Z"},
    {50, "??0WBEMTimeSpan@@QAE@HHHHHHH@Z"},
    {51, "??0WBEMTimeSpan@@QAE@QAG@Z"},
    {52, "??0WBEMTimeSpan@@QAE@XZ"},
    {53, "??0_Lockit@std@@QAE@XZ"},
    {54, "??1CAutoEvent@@QAE@XZ"},
    {55, "??1CFrameworkQuery@@QAE@XZ"},
    {56, "??1CFrameworkQueryEx@@QAE@XZ"},
    {57, "??1CHPtrArray@@QAE@XZ"},
    {58, "??1CHString@@QAE@XZ"},
    {59, "??1CHStringArray@@QAE@XZ"},
    {60, "??1CInstance@@UAE@XZ"},
    {61, "??1CObjectPathParser@@QAE@XZ"},
    {62, "??1CRegistry@@QAE@XZ"},
    {63, "??1CRegistrySearch@@QAE@XZ"},
    {64, "??1CThreadBase@@UAE@XZ"},
    {65, "??1CWbemGlueFactory@@QAE@XZ"},
    {66, "??1CWbemProviderGlue@@QAE@XZ"},
    {67, "??1CWinMsgEvent@@QAE@XZ"},
    {68, "??1CreateMutexAsProcess@@QAE@XZ"},
    {69, "??1KeyRef@@QAE@XZ"},
    {70, "??1MethodContext@@UAE@XZ"},
    {71, "??1ParsedObjectPath@@QAE@XZ"},
    {72, "??1Provider@@UAE@XZ"},
    {73, "??1ProviderLog@@UAE@XZ"},
    {74, "??1_Lockit@std@@QAE@XZ"},
    {75, "??4CAutoEvent@@QAEAAV0@ABV0@@Z"},
    {76, "??4CFrameworkQuery@@QAEAAV0@ABV0@@Z"},
    {77, "??4CFrameworkQueryEx@@QAEAAV0@ABV0@@Z"},
    {78, "??4CHPtrArray@@QAEAAV0@ABV0@@Z"},
    {79, "??4CHString@@QAEABV0@ABV0@@Z"},
    {80, "??4CHString@@QAEABV0@D@Z"},
    {81, "??4CHString@@QAEABV0@G@Z"},
    {82, "??4CHString@@QAEABV0@PAV0@@Z"},
    {83, "??4CHString@@QAEABV0@PBD@Z"},
    {84, "??4CHString@@QAEABV0@PBE@Z"},
    {85, "??4CHString@@QAEABV0@PBG@Z"},
    {86, "??4CHStringArray@@QAEAAV0@ABV0@@Z"},
    {87, "??4CInstance@@QAEAAV0@ABV0@@Z"},
    {88, "??4CObjectPathParser@@QAEAAV0@ABV0@@Z"},
    {89, "??4CRegistry@@QAEAAV0@ABV0@@Z"},
    {90, "??4CRegistrySearch@@QAEAAV0@ABV0@@Z"},
    {91, "??4CThreadBase@@QAEAAV0@ABV0@@Z"},
    {92, "??4CWbemGlueFactory@@QAEAAV0@ABV0@@Z"},
    {93, "??4CWbemProviderGlue@@QAEAAV0@ABV0@@Z"},
    {94, "??4CWinMsgEvent@@QAEAAV0@ABV0@@Z"},
    {95, "??4CreateMutexAsProcess@@QAEAAV0@ABV0@@Z"},
    {96, "??4KeyRef@@QAEAAU0@ABU0@@Z"},
    {97, "??4MethodContext@@QAEAAV0@ABV0@@Z"},
    {98, "??4ParsedObjectPath@@QAEAAU0@ABU0@@Z"},
    {99, "??4Provider@@QAEAAV0@ABV0@@Z"},
    {100, "??4ProviderLog@@QAEAAV0@ABV0@@Z"},
    {101, "??4WBEMTime@@QAEAAV0@ABV0@@Z"},
    {102, "??4WBEMTime@@QAEABV0@ABJ@Z"},
    {103, "??4WBEMTime@@QAEABV0@ABU_FILETIME@@@Z"},
    {104, "??4WBEMTime@@QAEABV0@ABU_SYSTEMTIME@@@Z"},
    {105, "??4WBEMTime@@QAEABV0@ABUtm@@@Z"},
    {106, "??4WBEMTime@@QAEABV0@QAG@Z"},
    {107, "??4WBEMTimeSpan@@QAEAAV0@ABV0@@Z"},
    {108, "??4WBEMTimeSpan@@QAEABV0@ABJ@Z"},
    {109, "??4WBEMTimeSpan@@QAEABV0@ABU_FILETIME@@@Z"},
    {110, "??4WBEMTimeSpan@@QAEABV0@QAG@Z"},
    {111, "??8WBEMTime@@QBEHABV0@@Z"},
    {112, "??8WBEMTimeSpan@@QBEHABV0@@Z"},
    {113, "??9WBEMTime@@QBEHABV0@@Z"},
    {114, "??9WBEMTimeSpan@@QBEHABV0@@Z"},
    {115, "??ACHPtrArray@@QAEAAPAXH@Z"},
    {116, "??ACHPtrArray@@QBEPAXH@Z"},
    {117, "??ACHString@@QBEGH@Z"},
    {118, "??ACHStringArray@@QAEAAVCHString@@H@Z"},
    {119, "??ACHStringArray@@QBE?AVCHString@@H@Z"},
    {120, "??BCHString@@QBEPBGXZ"},
    {121, "??GWBEMTime@@QAE?AVWBEMTimeSpan@@ABV0@@Z"},
    {122, "??GWBEMTime@@QBE?AV0@ABVWBEMTimeSpan@@@Z"},
    {123, "??GWBEMTimeSpan@@QBE?AV0@ABV0@@Z"},
    {124, "??H@YG?AVCHString@@ABV0@0@Z"},
    {125, "??H@YG?AVCHString@@ABV0@G@Z"},
    {126, "??H@YG?AVCHString@@ABV0@PBG@Z"},
    {127, "??H@YG?AVCHString@@GABV0@@Z"},
    {128, "??H@YG?AVCHString@@PBGABV0@@Z"},
    {129, "??HWBEMTime@@QBE?AV0@ABVWBEMTimeSpan@@@Z"},
    {130, "??HWBEMTimeSpan@@QBE?AV0@ABV0@@Z"},
    {131, "??MWBEMTime@@QBEHABV0@@Z"},
    {132, "??MWBEMTimeSpan@@QBEHABV0@@Z"},
    {133, "??NWBEMTime@@QBEHABV0@@Z"},
    {134, "??NWBEMTimeSpan@@QBEHABV0@@Z"},
    {135, "??OWBEMTime@@QBEHABV0@@Z"},
    {136, "??OWBEMTimeSpan@@QBEHABV0@@Z"},
    {137, "??PWBEMTime@@QBEHABV0@@Z"},
    {138, "??PWBEMTimeSpan@@QBEHABV0@@Z"},
    {139, "??YCHString@@QAEABV0@ABV0@@Z"},
    {140, "??YCHString@@QAEABV0@D@Z"},
    {141, "??YCHString@@QAEABV0@G@Z"},
    {142, "??YCHString@@QAEABV0@PBG@Z"},
    {143, "??YWBEMTime@@QAEABV0@ABVWBEMTimeSpan@@@Z"},
    {144, "??YWBEMTimeSpan@@QAEABV0@ABV0@@Z"},
    {145, "??ZWBEMTime@@QAEABV0@ABVWBEMTimeSpan@@@Z"},
    {146, "??ZWBEMTimeSpan@@QAEABV0@ABV0@@Z"},
    {147, "??_7CFrameworkQueryEx@@6B@"},
    {148, "??_7CInstance@@6B@"},
    {149, "??_7CThreadBase@@6B@"},
    {150, "??_7CWbemGlueFactory@@6B@"},
    {151, "??_7CWbemProviderGlue@@6BIWbemProviderInit@@@"},
    {152, "??_7CWbemProviderGlue@@6BIWbemServices@@@"},
    {153, "??_7CWinMsgEvent@@6B@"},
    {154, "??_7MethodContext@@6B@"},
    {155, "??_7Provider@@6B@"},
    {156, "??_7ProviderLog@@6B@"},
    {157, "??_FCObjectPathParser@@QAEXXZ"},
    {158, "??_FCThreadBase@@QAEXXZ"},
    {159, "?Add@CHPtrArray@@QAEHPAX@Z"},
    {160, "?Add@CHStringArray@@QAEHPBG@Z"},
    {161, "?AddFlushPtr@CWbemProviderGlue@@AAEXPAX@Z"},
    {162, "?AddKeyRef@ParsedObjectPath@@QAEHPAUKeyRef@@@Z"},
    {163, "?AddKeyRef@ParsedObjectPath@@QAEHPBGPBUtagVARIANT@@@Z"},
    {164, "?AddKeyRefEx@ParsedObjectPath@@QAEHPBGPBUtagVARIANT@@@Z"},
    {165, "?AddNamespace@ParsedObjectPath@@QAEHPBG@Z"},
    {166, "?AddProviderToMap@CWbemProviderGlue@@CGPAVProvider@@PBG0PAV2@@Z"},
    {167, "?AddRef@CInstance@@QAEJXZ"},
    {168, "?AddRef@CThreadBase@@QAEJXZ"},
    {169, "?AddRef@CWbemGlueFactory@@UAGKXZ"},
    {170, "?AddRef@CWbemProviderGlue@@UAGKXZ"},
    {171, "?AddRef@MethodContext@@QAEJXZ"},
    {172, "?AddToFactoryMap@CWbemProviderGlue@@KGXPBVCWbemGlueFactory@@PAJ@Z"},
    {173, "?AllPropertiesAreRequired@CFrameworkQuery@@QAE_NXZ"},
    {174, "?AllocBeforeWrite@CHString@@IAEXH@Z"},
    {175, "?AllocBuffer@CHString@@IAEXH@Z"},
    {176, "?AllocCopy@CHString@@IBEXAAV1@HHH@Z"},
    {177, "?AllocSysString@CHString@@QBEPAGXZ"},
    {178, "?Append@CHPtrArray@@QAEHABV1@@Z"},
    {179, "?Append@CHStringArray@@QAEHABV1@@Z"},
    {180, "?AssignCopy@CHString@@IAEXHPBG@Z"},
    {181, "?BeginRead@CThreadBase@@QAEHK@Z"},
    {182, "?BeginWrite@CThreadBase@@QAEHK@Z"},
    {183, "?CancelAsyncCall@CWbemProviderGlue@@UAGJPAUIWbemObjectSink@@@Z"},
    {184, "?CancelAsyncRequest@CWbemProviderGlue@@UAGJJ@Z"},
    {185, "?CheckAndAddToList@CRegistrySearch@@AAEXPAVCRegistry@@VCHString@@1AAVCHPtrArray@@11H@Z"},
    {186, "?CheckFileSize@ProviderLog@@AAEXAAT_LARGE_INTEGER@@ABVCHString@@@Z"},
    {187, "?CheckImpersonationLevel@CWbemProviderGlue@@CGJXZ"},
    {188, "?Clear@WBEMTime@@QAEXXZ"},
    {189, "?Clear@WBEMTimeSpan@@QAEXXZ"},
    {190, "?ClearKeys@ParsedObjectPath@@QAEXXZ"},
    {191, "?Close@CRegistry@@QAEXXZ"},
    {192, "?CloseSubKey@CRegistry@@AAEXXZ"},
    {193, "?Collate@CHString@@QBEHPBG@Z"},
    {194, "?Commit@CInstance@@QAEJXZ"},
    {195, "?Commit@Provider@@IAEJPAVCInstance@@_N@Z"},
    {196, "?Compare@CHString@@QBEHPBG@Z"},
    {197, "?CompareNoCase@CHString@@QBEHPBG@Z"},
    {198, "?ConcatCopy@CHString@@IAEXHPBGH0@Z"},
    {199, "?ConcatInPlace@CHString@@IAEXHPBG@Z"},
    {200, "?Copy@CHPtrArray@@QAEXABV1@@Z"},
    {201, "?Copy@CHStringArray@@QAEXABV1@@Z"},
    {202, "?CopyBeforeWrite@CHString@@IAEXXZ"},
    {203, "?Create@CWbemGlueFactory@@SGPAV1@PAJ@Z"},
    {204, "?Create@CWbemGlueFactory@@SGPAV1@XZ"},
    {205, "?CreateClassEnum@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIEnumWbemClassObject@@@Z"},
    {206, "?CreateClassEnumAsync@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {207, "?CreateInstance@CWbemGlueFactory@@UAGJPAUIUnknown@@ABU_GUID@@PAPAX@Z"},
    {208, "?CreateInstanceEnum@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIEnumWbemClassObject@@@Z"},
    {209, "?CreateInstanceEnum@Provider@@AAEJPAVMethodContext@@J@Z"},
    {210, "?CreateInstanceEnumAsync@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {211, "?CreateMsgProvider@CWinMsgEvent@@CGXXZ"},
    {212, "?CreateMsgWindow@CWinMsgEvent@@CGPAUHWND__@@XZ"},
    {213, "?CreateNewInstance@Provider@@IAEPAVCInstance@@PAVMethodContext@@@Z"},
    {214, "?CreateOpen@CRegistry@@QAEJPAUHKEY__@@PBGPAGKKPAU_SECURITY_ATTRIBUTES@@PAK@Z"},
    {215, "?CtrlHandlerRoutine@CWinMsgEvent@@CGHK@Z"},
    {216, "?DecrementMapCount@CWbemProviderGlue@@KGJPAJ@Z"},
    {217, "?DecrementMapCount@CWbemProviderGlue@@KGJPBVCWbemGlueFactory@@@Z"},
    {218, "?DecrementObjectCount@CWbemProviderGlue@@SGJXZ"},
    {219, "?DeleteClass@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIWbemCallResult@@@Z"},
    {220, "?DeleteClassAsync@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {221, "?DeleteCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBG@Z"},
    {222, "?DeleteCurrentKeyValue@CRegistry@@QAEKPBG@Z"},
    {223, "?DeleteInstance@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIWbemCallResult@@@Z"},
    {224, "?DeleteInstance@Provider@@AAEJPAUParsedObjectPath@@JPAVMethodContext@@@Z"},
    {225, "?DeleteInstance@Provider@@MAEJABVCInstance@@J@Z"},
    {226, "?DeleteInstanceAsync@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {227, "?DeleteKey@CRegistry@@QAEJPAVCHString@@@Z"},
    {228, "?DeleteValue@CRegistry@@QAEJPBG@Z"},
    {229, "?Destroy@CWbemGlueFactory@@QAEXXZ"},
    {230, "?DestroyMsgWindow@CWinMsgEvent@@CGXXZ"},
    {231, "?ElementAt@CHPtrArray@@QAEAAPAXH@Z"},
    {232, "?ElementAt@CHStringArray@@QAEAAVCHString@@H@Z"},
    {233, "?Empty@CHString@@QAEXXZ"},
    {234, "?Empty@CObjectPathParser@@AAEXXZ"},
    {235, "?EndRead@CThreadBase@@QAEXXZ"},
    {236, "?EndWrite@CThreadBase@@QAEXXZ"},
    {237, "?EnumerateAndGetValues@CRegistry@@QAEJAAKAAPAGAAPAE@Z"},
    {238, "?EnumerateInstances@Provider@@MAEJPAVMethodContext@@J@Z"},
    {239, "?ExecMethod@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAUIWbemClassObject@@PAPAU3@PAPAUIWbemCallResult@@@Z"},
    {240, "?ExecMethod@Provider@@AAEJPAUParsedObjectPath@@PAGJPAVCInstance@@2PAVMethodContext@@@Z"},
    {241, "?ExecMethod@Provider@@MAEJABVCInstance@@QAGPAV2@2J@Z"},
    {242, "?ExecMethodAsync@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAUIWbemClassObject@@PAUIWbemObjectSink@@@Z"},
    {243, "?ExecNotificationQuery@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAPAUIEnumWbemClassObject@@@Z"},
    {244, "?ExecNotificationQueryAsync@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {245, "?ExecQuery@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAPAUIEnumWbemClassObject@@@Z"},
    {246, "?ExecQuery@Provider@@MAEJPAVMethodContext@@AAVCFrameworkQuery@@J@Z"},
    {247, "?ExecQueryAsync@CWbemProviderGlue@@UAGJQAG0JPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {248, "?ExecuteQuery@Provider@@AAEJPAVMethodContext@@AAVCFrameworkQuery@@J@Z"},
    {249, "?FillInstance@CWbemProviderGlue@@SGJPAVCInstance@@PBG@Z"},
    {250, "?FillInstance@CWbemProviderGlue@@SGJPAVMethodContext@@PAVCInstance@@@Z"},
    {251, "?Find@CHString@@QBEHG@Z"},
    {252, "?Find@CHString@@QBEHPBG@Z"},
    {253, "?FindOneOf@CHString@@QBEHPBG@Z"},
    {254, "?Flush@Provider@@MAEXXZ"},
    {255, "?FlushAll@CWbemProviderGlue@@AAEXXZ"},
    {256, "?Format@CHString@@QAAXIZZ"},
    {257, "?Format@CHString@@QAAXPBGZZ"},
    {258, "?FormatMessageW@CHString@@QAAXIZZ"},
    {259, "?FormatMessageW@CHString@@QAAXPBGZZ"},
    {260, "?FormatV@CHString@@QAEXPBGPAD@Z"},
    {261, "?FrameworkLogin@CWbemProviderGlue@@SGXPBGPAVProvider@@0@Z"},
    {262, "?FrameworkLoginDLL@CWbemProviderGlue@@SGHPBG@Z"},
    {263, "?FrameworkLoginDLL@CWbemProviderGlue@@SGHPBGPAJ@Z"},
    {264, "?FrameworkLogoff@CWbemProviderGlue@@SGXPBG0@Z"},
    {265, "?FrameworkLogoffDLL@CWbemProviderGlue@@SGHPBG@Z"},
    {266, "?FrameworkLogoffDLL@CWbemProviderGlue@@SGHPBGPAJ@Z"},
    {267, "?Free@CObjectPathParser@@QAEXPAUParsedObjectPath@@@Z"},
    {268, "?FreeExtra@CHPtrArray@@QAEXXZ"},
    {269, "?FreeExtra@CHString@@QAEXXZ"},
    {270, "?FreeExtra@CHStringArray@@QAEXXZ"},
    {271, "?FreeSearchList@CRegistrySearch@@QAEHHAAVCHPtrArray@@@Z"},
    {272, "?GetAllDerivedInstances@CWbemProviderGlue@@SGJPBGPAV?$TRefPointerCollection@VCInstance@@@@PAVMethodContext@@0@Z"},
    {273, "?GetAllDerivedInstancesAsynch@CWbemProviderGlue@@SGJPBGPAVProvider@@P6GJ1PAVCInstance@@PAVMethodContext@@PAX@Z034@Z"},
    {274, "?GetAllInstances@CWbemProviderGlue@@SGJPBGPAV?$TRefPointerCollection@VCInstance@@@@0PAVMethodContext@@@Z"},
    {275, "?GetAllInstancesAsynch@CWbemProviderGlue@@SGJPBGPAVProvider@@P6GJ1PAVCInstance@@PAVMethodContext@@PAX@Z034@Z"},
    {276, "?GetAllocLength@CHString@@QBEHXZ"},
    {277, "?GetAt@CHPtrArray@@QBEPAXH@Z"},
    {278, "?GetAt@CHString@@QBEGH@Z"},
    {279, "?GetAt@CHStringArray@@QBE?AVCHString@@H@Z"},
    {280, "?GetBSTR@WBEMTime@@QBEPAGXZ"},
    {281, "?GetBSTR@WBEMTimeSpan@@QBEPAGXZ"},
    {282, "?GetBuffer@CHString@@QAEPAGH@Z"},
    {283, "?GetBufferSetLength@CHString@@QAEPAGH@Z"},
    {284, "?GetByte@CInstance@@QBE_NPBGAAE@Z"},
    {285, "?GetCHString@CInstance@@QBE_NPBGAAVCHString@@@Z"},
    {286, "?GetCSDVersion@CWbemProviderGlue@@SGPBGXZ"},
    {287, "?GetClassNameW@CRegistry@@QAEPAGXZ"},
    {288, "?GetClassObjectInterface@CInstance@@QAEPAUIWbemClassObject@@XZ"},
    {289, "?GetClassObjectInterface@Provider@@AAEPAUIWbemClassObject@@PAVMethodContext@@@Z"},
    {290, "?GetComputerNameW@CWbemProviderGlue@@CGXAAVCHString@@@Z"},
    {291, "?GetCurrentBinaryKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGPAEPAK@Z"},
    {292, "?GetCurrentBinaryKeyValue@CRegistry@@QAEKPBGAAVCHString@@@Z"},
    {293, "?GetCurrentBinaryKeyValue@CRegistry@@QAEKPBGPAEPAK@Z"},
    {294, "?GetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAK@Z"},
    {295, "?GetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAVCHString@@@Z"},
    {296, "?GetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAVCHStringArray@@@Z"},
    {297, "?GetCurrentKeyValue@CRegistry@@QAEKPBGAAK@Z"},
    {298, "?GetCurrentKeyValue@CRegistry@@QAEKPBGAAVCHString@@@Z"},
    {299, "?GetCurrentKeyValue@CRegistry@@QAEKPBGAAVCHStringArray@@@Z"},
    {300, "?GetCurrentRawKeyValue@CRegistry@@AAEKPAUHKEY__@@PBGPAXPAK3@Z"},
    {301, "?GetCurrentRawSubKeyValue@CRegistry@@AAEKPBGPAXPAK2@Z"},
    {302, "?GetCurrentSubKeyCount@CRegistry@@QAEKXZ"},
    {303, "?GetCurrentSubKeyName@CRegistry@@QAEKAAVCHString@@@Z"},
    {304, "?GetCurrentSubKeyPath@CRegistry@@QAEKAAVCHString@@@Z"},
    {305, "?GetCurrentSubKeyValue@CRegistry@@QAEKPBGAAK@Z"},
    {306, "?GetCurrentSubKeyValue@CRegistry@@QAEKPBGAAVCHString@@@Z"},
    {307, "?GetCurrentSubKeyValue@CRegistry@@QAEKPBGPAXPAK@Z"},
    {308, "?GetDMTF@WBEMTime@@QBEPAGH@Z"},
    {309, "?GetDMTFNonNtfs@WBEMTime@@QBEPAGXZ"},
    {310, "?GetDOUBLE@CInstance@@QBE_NPBGAAN@Z"},
    {311, "?GetDWORD@CInstance@@QBE_NPBGAAK@Z"},
    {312, "?GetData@CHPtrArray@@QAEPAPAXXZ"},
    {313, "?GetData@CHPtrArray@@QBEPAPBXXZ"},
    {314, "?GetData@CHString@@IBEPAUCHStringData@@XZ"},
    {315, "?GetData@CHStringArray@@QAEPAVCHString@@XZ"},
    {316, "?GetData@CHStringArray@@QBEPBVCHString@@XZ"},
    {317, "?GetDateTime@CInstance@@QBE_NPBGAAVWBEMTime@@@Z"},
    {318, "?GetEmbeddedObject@CInstance@@QBE_NPBGPAPAV1@PAVMethodContext@@@Z"},
    {319, "?GetEmptyInstance@CWbemProviderGlue@@SGJPAVMethodContext@@PBGPAPAVCInstance@@1@Z"},
    {320, "?GetEmptyInstance@CWbemProviderGlue@@SGJPBGPAPAVCInstance@@0@Z"},
    {321, "?GetFILETIME@WBEMTime@@QBEHPAU_FILETIME@@@Z"},
    {322, "?GetFILETIME@WBEMTimeSpan@@QBEHPAU_FILETIME@@@Z"},
    {323, "?GetIWBEMContext@MethodContext@@UAEPAUIWbemContext@@XZ"},
    {324, "?GetInstanceByPath@CWbemProviderGlue@@SGJPBGPAPAVCInstance@@PAVMethodContext@@@Z"},
    {325, "?GetInstanceFromCIMOM@CWbemProviderGlue@@CGJPBG0PAVMethodContext@@PAPAVCInstance@@@Z"},
    {326, "?GetInstanceKeysByPath@CWbemProviderGlue@@SGJPBGPAPAVCInstance@@PAVMethodContext@@@Z"},
    {327, "?GetInstancePropertiesByPath@CWbemProviderGlue@@SGJPBGPAPAVCInstance@@PAVMethodContext@@AAVCHStringArray@@@Z"},
    {328, "?GetInstancesByQuery@CWbemProviderGlue@@SGJPBGPAV?$TRefPointerCollection@VCInstance@@@@PAVMethodContext@@0@Z"},
    {329, "?GetInstancesByQueryAsynch@CWbemProviderGlue@@SGJPBGPAVProvider@@P6GJ1PAVCInstance@@PAVMethodContext@@PAX@Z034@Z"},
    {330, "?GetKeyString@ParsedObjectPath@@QAEPAGXZ"},
    {331, "?GetLength@CHString@@QBEHXZ"},
    {332, "?GetLocalComputerName@Provider@@IAEABVCHString@@XZ"},
    {333, "?GetLocalInstancePath@Provider@@IAE_NPBVCInstance@@AAVCHString@@@Z"},
    {334, "?GetLocalOffsetForDate@WBEMTime@@SGJABJ@Z"},
    {335, "?GetLocalOffsetForDate@WBEMTime@@SGJPBU_FILETIME@@@Z"},
    {336, "?GetLocalOffsetForDate@WBEMTime@@SGJPBU_SYSTEMTIME@@@Z"},
    {337, "?GetLocalOffsetForDate@WBEMTime@@SGJPBUtm@@@Z"},
    {338, "?GetLongestClassStringSize@CRegistry@@QAEKXZ"},
    {339, "?GetLongestSubKeySize@CRegistry@@QAEKXZ"},
    {340, "?GetLongestValueData@CRegistry@@QAEKXZ"},
    {341, "?GetLongestValueName@CRegistry@@QAEKXZ"},
    {342, "?GetMapCountPtr@CWbemProviderGlue@@KGPAJPBVCWbemGlueFactory@@@Z"},
    {343, "?GetMethodContext@CInstance@@QBEPAVMethodContext@@XZ"},
    {344, "?GetNamespace@CFrameworkQuery@@IAEABVCHString@@XZ"},
    {345, "?GetNamespace@Provider@@IAEABVCHString@@XZ"},
    {346, "?GetNamespaceConnection@CWbemProviderGlue@@SGPAUIWbemServices@@PBG@Z"},
    {347, "?GetNamespaceConnection@CWbemProviderGlue@@SGPAUIWbemServices@@PBGPAVMethodContext@@@Z"},
    {348, "?GetNamespacePart@ParsedObjectPath@@QAEPAGXZ"},
    {349, "?GetOSMajorVersion@CWbemProviderGlue@@SGKXZ"},
    {350, "?GetObject@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIWbemClassObject@@PAPAUIWbemCallResult@@@Z"},
    {351, "?GetObject@Provider@@AAEJPAUParsedObjectPath@@PAVMethodContext@@J@Z"},
    {352, "?GetObject@Provider@@MAEJPAVCInstance@@J@Z"},
    {353, "?GetObject@Provider@@MAEJPAVCInstance@@JAAVCFrameworkQuery@@@Z"},
    {354, "?GetObjectAsync@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {355, "?GetParentNamespacePart@ParsedObjectPath@@QAEPAGXZ"},
    {356, "?GetPlatform@CWbemProviderGlue@@SGKXZ"},
    {357, "?GetPropertyBitMask@CFrameworkQueryEx@@QAEXABVCHPtrArray@@PAX@Z"},
    {358, "?GetProviderGlue@MethodContext@@AAEPAVCWbemProviderGlue@@XZ"},
    {359, "?GetProviderName@Provider@@IAEABVCHString@@XZ"},
    {360, "?GetQuery@CFrameworkQuery@@QAEABVCHString@@XZ"},
    {361, "?GetQueryClassName@CFrameworkQuery@@QAEPAGXZ"},
    {362, "?GetRelativePath@CObjectPathParser@@SGPAGPAG@Z"},
    {363, "?GetRequiredProperties@CFrameworkQuery@@QAEXAAVCHStringArray@@@Z"},
    {364, "?GetSYSTEMTIME@WBEMTime@@QBEHPAU_SYSTEMTIME@@@Z"},
    {365, "?GetSize@CHPtrArray@@QBEHXZ"},
    {366, "?GetSize@CHStringArray@@QBEHXZ"},
    {367, "?GetStatus@CInstance@@QBE_NPBGAA_NAAG@Z"},
    {368, "?GetStatusObject@CWbemProviderGlue@@CGPAUIWbemClassObject@@PAVMethodContext@@PBG@Z"},
    {369, "?GetStatusObject@MethodContext@@QAEPAUIWbemClassObject@@XZ"},
    {370, "?GetStringArray@CInstance@@QBE_NPBGAAPAUtagSAFEARRAY@@@Z"},
    {371, "?GetStructtm@WBEMTime@@QBEHPAUtm@@@Z"},
    {372, "?GetTime@WBEMTime@@QBE_KXZ"},
    {373, "?GetTime@WBEMTimeSpan@@QBE_KXZ"},
    {374, "?GetTimeSpan@CInstance@@QBE_NPBGAAVWBEMTimeSpan@@@Z"},
    {375, "?GetUpperBound@CHPtrArray@@QBEHXZ"},
    {376, "?GetUpperBound@CHStringArray@@QBEHXZ"},
    {377, "?GetValueCount@CRegistry@@QAEKXZ"},
    {378, "?GetValuesForProp@CFrameworkQuery@@QAEJPBGAAV?$vector@V_bstr_t@@V?$allocator@V_bstr_t@@@std@@@std@@@Z"},
    {379, "?GetValuesForProp@CFrameworkQuery@@QAEJPBGAAVCHStringArray@@@Z"},
    {380, "?GetValuesForProp@CFrameworkQueryEx@@QAEJPBGAAV?$vector@HV?$allocator@H@std@@@std@@@Z"},
    {381, "?GetValuesForProp@CFrameworkQueryEx@@QAEJPBGAAV?$vector@V_variant_t@@V?$allocator@V_variant_t@@@std@@@std@@@Z"},
    {382, "?GetVariant@CInstance@@QBE_NPBGAAUtagVARIANT@@@Z"},
    {383, "?GetWBEMINT16@CInstance@@QBE_NPBGAAF@Z"},
    {384, "?GetWBEMINT64@CInstance@@QBE_NPBGAAVCHString@@@Z"},
    {385, "?GetWBEMINT64@CInstance@@QBE_NPBGAA_J@Z"},
    {386, "?GetWBEMINT64@CInstance@@QBE_NPBGAA_K@Z"},
    {387, "?GetWCHAR@CInstance@@QBE_NPBGPAPAG@Z"},
    {388, "?GetWORD@CInstance@@QBE_NPBGAAG@Z"},
    {389, "?Getbool@CInstance@@QBE_NPBGAA_N@Z"},
    {390, "?GethKey@CRegistry@@QAEPAUHKEY__@@XZ"},
    {391, "?Gettime_t@WBEMTime@@QBEHPAJ@Z"},
    {392, "?Gettime_t@WBEMTimeSpan@@QBEHPAJ@Z"},
    {393, "?IncrementMapCount@CWbemProviderGlue@@KGJPAJ@Z"},
    {394, "?IncrementMapCount@CWbemProviderGlue@@KGJPBVCWbemGlueFactory@@@Z"},
    {395, "?IncrementObjectCount@CWbemProviderGlue@@SGXXZ"},
    {396, "?Init2@CFrameworkQuery@@QAEXPAUIWbemClassObject@@@Z"},
    {397, "?Init@CFrameworkQuery@@QAEJPAUParsedObjectPath@@PAUIWbemContext@@PBGAAVCHString@@@Z"},
    {398, "?Init@CFrameworkQuery@@QAEJQAG0JAAVCHString@@@Z"},
    {399, "?Init@CHString@@IAEXXZ"},
    {400, "?Init@CWbemProviderGlue@@CGXXZ"},
    {401, "?InitComputerName@Provider@@CGXXZ"},
    {402, "?InitEx@CFrameworkQueryEx@@UAEJQAG0JAAVCHString@@@Z"},
    {403, "?Initialize@CWbemProviderGlue@@UAGJPAGJ00PAUIWbemServices@@PAUIWbemContext@@PAUIWbemProviderInitSink@@@Z"},
    {404, "?InsertAt@CHPtrArray@@QAEXHPAV1@@Z"},
    {405, "?InsertAt@CHPtrArray@@QAEXHPAXH@Z"},
    {406, "?InsertAt@CHStringArray@@QAEXHPAV1@@Z"},
    {407, "?InsertAt@CHStringArray@@QAEXHPBGH@Z"},
    {408, "?InternalGetNamespaceConnection@CWbemProviderGlue@@AAGPAUIWbemServices@@PBG@Z"},
    {409, "?Is3TokenOR@CFrameworkQueryEx@@QAEHPBG0AAUtagVARIANT@@1@Z"},
    {410, "?IsClass@ParsedObjectPath@@QAEHXZ"},
    {411, "?IsDerivedFrom@CWbemProviderGlue@@SG_NPBG0PAVMethodContext@@0@Z"},
    {412, "?IsEmpty@CHString@@QBEHXZ"},
    {413, "?IsExtended@CFrameworkQueryEx@@UAE_NXZ"},
    {414, "?IsInList@CFrameworkQuery@@IAEKABVCHStringArray@@PBG@Z"},
    {415, "?IsInstance@ParsedObjectPath@@QAEHXZ"},
    {416, "?IsLocal@ParsedObjectPath@@QAEHPBG@Z"},
    {417, "?IsLoggingOn@ProviderLog@@QAE?AW4LogLevel@1@PAVCHString@@@Z"},
    {418, "?IsNTokenAnd@CFrameworkQueryEx@@QAEHAAVCHStringArray@@AAVCHPtrArray@@@Z"},
    {419, "?IsNull@CInstance@@QBE_NPBG@Z"},
    {420, "?IsObject@ParsedObjectPath@@QAEHXZ"},
    {421, "?IsOk@WBEMTime@@QBE_NXZ"},
    {422, "?IsOk@WBEMTimeSpan@@QBE_NXZ"},
    {423, "?IsPropertyRequired@CFrameworkQuery@@QAE_NPBG@Z"},
    {424, "?IsReference@CFrameworkQuery@@IAEHPBG@Z"},
    {425, "?IsRelative@ParsedObjectPath@@QAEHPBG0@Z"},
    {426, "?KeysOnly@CFrameworkQuery@@QAE_NXZ"},
    {427, "?Left@CHString@@QBE?AV1@H@Z"},
    {428, "?LoadStringW@CHString@@IAEHIPAGI@Z"},
    {429, "?LoadStringW@CHString@@QAEHI@Z"},
    {430, "?LocalLogMessage@ProviderLog@@QAAXPBGHW4LogLevel@1@0ZZ"},
    {431, "?LocalLogMessage@ProviderLog@@QAEXPBG0HW4LogLevel@1@@Z"},
    {432, "?LocateKeyByNameOrValueName@CRegistrySearch@@QAEHPAUHKEY__@@PBG1PAPBGKAAVCHString@@3@Z"},
    {433, "?Lock@CThreadBase@@AAEXXZ"},
    {434, "?LockBuffer@CHString@@QAEPAGXZ"},
    {435, "?LockFactoryMap@CWbemProviderGlue@@CGXXZ"},
    {436, "?LockProviderMap@CWbemProviderGlue@@CGXXZ"},
    {437, "?LockServer@CWbemGlueFactory@@UAGJH@Z"},
    {438, "?LogError@CInstance@@IBEXPBG00J@Z"},
    {439, "?MakeLocalPath@Provider@@IAE?AVCHString@@ABV2@@Z"},
    {440, "?MakeLower@CHString@@QAEXXZ"},
    {441, "?MakeReverse@CHString@@QAEXXZ"},
    {442, "?MakeUpper@CHString@@QAEXXZ"},
    {443, "?Mid@CHString@@QBE?AV1@H@Z"},
    {444, "?Mid@CHString@@QBE?AV1@HH@Z"},
    {445, "?MsgWndProc@CWinMsgEvent@@CGJPAUHWND__@@IIJ@Z"},
    {446, "?NextSubKey@CRegistry@@QAEKXZ"},
    {447, "?NextToken@CObjectPathParser@@AAEHXZ"},
    {448, "?NormalizePath@@YGKPBG00KAAVCHString@@@Z"},
    {449, "?NullOutUnsetProperties@CWbemProviderGlue@@AAEJPAUIWbemClassObject@@PAPAU2@ABUtagVARIANT@@@Z"},
    {450, "?OnFinalRelease@CThreadBase@@MAEXXZ"},
    {451, "?Open@CRegistry@@QAEJPAUHKEY__@@PBGK@Z"},
    {452, "?OpenAndEnumerateSubKeys@CRegistry@@QAEJPAUHKEY__@@PBGK@Z"},
    {453, "?OpenCurrentUser@CRegistry@@QAEKPBGK@Z"},
    {454, "?OpenLocalMachineKeyAndReadValue@CRegistry@@QAEJPBG0AAVCHString@@@Z"},
    {455, "?OpenNamespace@CWbemProviderGlue@@UAGJQAGJPAUIWbemContext@@PAPAUIWbemServices@@PAPAUIWbemCallResult@@@Z"},
    {456, "?OpenSubKey@CRegistry@@AAEKXZ"},
    {457, "?Parse@CObjectPathParser@@QAEHPBGPAPAUParsedObjectPath@@@Z"},
    {458, "?PreProcessPutInstanceParms@CWbemProviderGlue@@AAEJPAUIWbemClassObject@@PAPAU2@PAUIWbemContext@@@Z"},
    {459, "?PrepareToReOpen@CRegistry@@AAEXXZ"},
    {460, "?PutClass@CWbemProviderGlue@@UAGJPAUIWbemClassObject@@JPAUIWbemContext@@PAPAUIWbemCallResult@@@Z"},
    {461, "?PutClassAsync@CWbemProviderGlue@@UAGJPAUIWbemClassObject@@JPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {462, "?PutInstance@CWbemProviderGlue@@UAGJPAUIWbemClassObject@@JPAUIWbemContext@@PAPAUIWbemCallResult@@@Z"},
    {463, "?PutInstance@Provider@@AAEJPAUIWbemClassObject@@JPAVMethodContext@@@Z"},
    {464, "?PutInstance@Provider@@MAEJABVCInstance@@J@Z"},
    {465, "?PutInstanceAsync@CWbemProviderGlue@@UAGJPAUIWbemClassObject@@JPAUIWbemContext@@PAUIWbemObjectSink@@@Z"},
    {466, "?QueryInterface@CWbemGlueFactory@@UAGJABU_GUID@@PAPAX@Z"},
    {467, "?QueryInterface@CWbemProviderGlue@@UAGJABU_GUID@@PAPAX@Z"},
    {468, "?QueryObjectSink@CWbemProviderGlue@@UAGJJPAPAUIWbemObjectSink@@@Z"},
    {469, "?QueryPostProcess@MethodContext@@UAEXXZ"},
    {470, "?RegisterForMessage@CWinMsgEvent@@IAEXIH@Z"},
    {471, "?Release@CHString@@QAEXXZ"},
    {472, "?Release@CHString@@SGXPAUCHStringData@@@Z"},
    {473, "?Release@CInstance@@QAEJXZ"},
    {474, "?Release@CThreadBase@@QAEJXZ"},
    {475, "?Release@CWbemGlueFactory@@UAGKXZ"},
    {476, "?Release@CWbemProviderGlue@@UAGKXZ"},
    {477, "?Release@MethodContext@@QAEJXZ"},
    {478, "?ReleaseBuffer@CHString@@QAEXH@Z"},
    {479, "?RemoveAll@CHPtrArray@@QAEXXZ"},
    {480, "?RemoveAll@CHStringArray@@QAEXXZ"},
    {481, "?RemoveAt@CHPtrArray@@QAEXHH@Z"},
    {482, "?RemoveAt@CHStringArray@@QAEXHH@Z"},
    {483, "?RemoveFromFactoryMap@CWbemProviderGlue@@KGXPBVCWbemGlueFactory@@@Z"},
    {484, "?Reset@CFrameworkQuery@@AAEXXZ"},
    {485, "?ReverseFind@CHString@@QBEHG@Z"},
    {486, "?RewindSubKeys@CRegistry@@QAEXXZ"},
    {487, "?Right@CHString@@QBE?AV1@H@Z"},
    {488, "?SafeStrlen@CHString@@KGHPBG@Z"},
    {489, "?SearchAndBuildList@CRegistrySearch@@QAEHVCHString@@AAVCHPtrArray@@00HPAUHKEY__@@@Z"},
    {490, "?SearchMapForProvider@CWbemProviderGlue@@CGPAVProvider@@PBG0@Z"},
    {491, "?SetAt@CHPtrArray@@QAEXHPAX@Z"},
    {492, "?SetAt@CHString@@QAEXHG@Z"},
    {493, "?SetAt@CHStringArray@@QAEXHPBG@Z"},
    {494, "?SetAtGrow@CHPtrArray@@QAEXHPAX@Z"},
    {495, "?SetAtGrow@CHStringArray@@QAEXHPBG@Z"},
    {496, "?SetByte@CInstance@@QAE_NPBGE@Z"},
    {497, "?SetCHString@CInstance@@QAE_NPBG0@Z"},
    {498, "?SetCHString@CInstance@@QAE_NPBGABVCHString@@@Z"},
    {499, "?SetCHString@CInstance@@QAE_NPBGPBD@Z"},
    {500, "?SetCHStringResourceHandle@@YGXPAUHINSTANCE__@@@Z"},
    {501, "?SetCharSplat@CInstance@@QAE_NPBG0@Z"},
    {502, "?SetCharSplat@CInstance@@QAE_NPBGK@Z"},
    {503, "?SetCharSplat@CInstance@@QAE_NPBGPBD@Z"},
    {504, "?SetClassName@ParsedObjectPath@@QAEHPBG@Z"},
    {505, "?SetCreationClassName@Provider@@IAE_NPAVCInstance@@@Z"},
    {506, "?SetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAK@Z"},
    {507, "?SetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAVCHString@@@Z"},
    {508, "?SetCurrentKeyValue@CRegistry@@QAEKPAUHKEY__@@PBGAAVCHStringArray@@@Z"},
    {509, "?SetCurrentKeyValue@CRegistry@@QAEKPBGAAK@Z"},
    {510, "?SetCurrentKeyValue@CRegistry@@QAEKPBGAAVCHString@@@Z"},
    {511, "?SetCurrentKeyValue@CRegistry@@QAEKPBGAAVCHStringArray@@@Z"},
    {512, "?SetCurrentKeyValueExpand@CRegistry@@QAEKPAUHKEY__@@PBGAAVCHString@@@Z"},
    {513, "?SetDMTF@WBEMTime@@QAEHQAG@Z"},
    {514, "?SetDOUBLE@CInstance@@QAE_NPBGN@Z"},
    {515, "?SetDWORD@CInstance@@QAE_NPBGK@Z"},
    {516, "?SetDateTime@CInstance@@QAE_NPBGABVWBEMTime@@@Z"},
    {517, "?SetDefaultValues@CRegistry@@AAEXXZ"},
    {518, "?SetEmbeddedObject@CInstance@@QAE_NPBGAAV1@@Z"},
    {519, "?SetKeyFromParsedObjectPath@Provider@@AAEHPAVCInstance@@PAUParsedObjectPath@@@Z"},
    {520, "?SetNull@CInstance@@QAE_NPBG@Z"},
    {521, "?SetPlatformID@CRegistry@@CGHXZ"},
    {522, "?SetSize@CHPtrArray@@QAEXHH@Z"},
    {523, "?SetSize@CHStringArray@@QAEXHH@Z"},
    {524, "?SetStatusObject@CWbemProviderGlue@@SG_NPAVMethodContext@@PBG1JPBUtagSAFEARRAY@@2@Z"},
    {525, "?SetStatusObject@MethodContext@@QAE_NPAUIWbemClassObject@@@Z"},
    {526, "?SetStringArray@CInstance@@QAE_NPBGABUtagSAFEARRAY@@@Z"},
    {527, "?SetTimeSpan@CInstance@@QAE_NPBGABVWBEMTimeSpan@@@Z"},
    {528, "?SetVariant@CInstance@@QAE_NPBGABUtagVARIANT@@@Z"},
    {529, "?SetWBEMINT16@CInstance@@QAE_NPBGABF@Z"},
    {530, "?SetWBEMINT64@CInstance@@QAE_NPBGABVCHString@@@Z"},
    {531, "?SetWBEMINT64@CInstance@@QAE_NPBG_J@Z"},
    {532, "?SetWBEMINT64@CInstance@@QAE_NPBG_K@Z"},
    {533, "?SetWCHARSplat@CInstance@@QAE_NPBG0@Z"},
    {534, "?SetWORD@CInstance@@QAE_NPBGG@Z"},
    {535, "?Setbool@CInstance@@QAE_NPBG_N@Z"},
    {536, "?Signal@CAutoEvent@@QAEHXZ"},
    {537, "?SpanExcluding@CHString@@QBE?AV1@PBG@Z"},
    {538, "?SpanIncluding@CHString@@QBE?AV1@PBG@Z"},
    {539, "?TrimLeft@CHString@@QAEXXZ"},
    {540, "?TrimRight@CHString@@QAEXXZ"},
    {541, "?UnInit@CWbemProviderGlue@@CGXXZ"},
    {542, "?UnRegisterAllMessages@CWinMsgEvent@@IAEXXZ"},
    {543, "?UnRegisterMessage@CWinMsgEvent@@IAE_NIH@Z"},
    {544, "?Unlock@CThreadBase@@AAEXXZ"},
    {545, "?UnlockBuffer@CHString@@QAEXXZ"},
    {546, "?UnlockFactoryMap@CWbemProviderGlue@@CGXXZ"},
    {547, "?UnlockProviderMap@CWbemProviderGlue@@CGXXZ"},
    {548, "?Unparse@CObjectPathParser@@SGHPAUParsedObjectPath@@PAPAG@Z"},
    {549, "?ValidateDeletionFlags@Provider@@MAEJJ@Z"},
    {550, "?ValidateEnumerationFlags@Provider@@MAEJJ@Z"},
    {551, "?ValidateFlags@Provider@@IAEJJW4FlagDefs@1@@Z"},
    {552, "?ValidateGetObjFlags@Provider@@MAEJJ@Z"},
    {553, "?ValidateIMOSPointer@Provider@@AAEHXZ"},
    {554, "?ValidateMethodFlags@Provider@@MAEJJ@Z"},
    {555, "?ValidatePutInstanceFlags@Provider@@MAEJJ@Z"},
    {556, "?ValidateQueryFlags@Provider@@MAEJJ@Z"},
    {557, "?Wait@CAutoEvent@@QAEKK@Z"},
    {558, "?WindowsDispatch@CWinMsgEvent@@CGXXZ"},
    {559, "?Zero@CObjectPathParser@@AAEXXZ"},
    {560, "?begin_parse@CObjectPathParser@@AAEHXZ"},
    {561, "?captainsLog@@3VProviderLog@@A"},
    {562, "?dwThreadProc@CWinMsgEvent@@CGKPAX@Z"},
    {563, "?g_cs@@3VCCritSec@@A"},
    {564, "?ident_becomes_class@CObjectPathParser@@AAEHXZ"},
    {565, "?ident_becomes_ns@CObjectPathParser@@AAEHXZ"},
    {566, "?initFailed@Provider@@SGHXZ"},
    {567, "?initFailed_@Provider@@0HA"},
    {568, "?key_const@CObjectPathParser@@AAEHXZ"},
    {569, "?keyref@CObjectPathParser@@AAEHXZ"},
    {570, "?keyref_list@CObjectPathParser@@AAEHXZ"},
    {571, "?keyref_term@CObjectPathParser@@AAEHXZ"},
    {572, "?m_FlushPtrs@CWbemProviderGlue@@0V?$set@PAXU?$less@PAX@std@@V?$allocator@PAX@2@@std@@A"},
    {573, "?m_csFlushPtrs@CWbemProviderGlue@@0VCCritSec@@A"},
    {574, "?m_csStatusObject@CWbemProviderGlue@@0VCCritSec@@A"},
    {575, "?m_pStatusObject@CWbemProviderGlue@@0PAUIWbemClassObject@@A"},
    {576, "?mg_aeCreateWindow@CWinMsgEvent@@0VCAutoEvent@@A"},
    {577, "?mg_csMapLock@CWinMsgEvent@@0VCCritSec@@A"},
    {578, "?mg_csWindowLock@CWinMsgEvent@@0VCCritSec@@A"},
    {579, "?mg_hDevNotify@CWinMsgEvent@@0PAXA"},
    {580, "?mg_hThreadPumpHandle@CWinMsgEvent@@0PAXA"},
    {581, "?mg_hWnd@CWinMsgEvent@@0PAUHWND__@@A"},
    {582, "?mg_oSinkMap@CWinMsgEvent@@0V?$multimap@IPAVCWinMsgEvent@@U?$less@I@std@@V?$allocator@PAVCWinMsgEvent@@@3@@std@@A"},
    {583, "?myRegCreateKeyEx@CRegistry@@AAEJPAUHKEY__@@PBGKPAGKKQAU_SECURITY_ATTRIBUTES@@PAPAU2@PAK@Z"},
    {584, "?myRegDeleteKey@CRegistry@@AAEJPAUHKEY__@@PBG@Z"},
    {585, "?myRegDeleteValue@CRegistry@@AAEJPAUHKEY__@@PBG@Z"},
    {586, "?myRegEnumKey@CRegistry@@AAEJPAUHKEY__@@KPAGK@Z"},
    {587, "?myRegEnumValue@CRegistry@@AAEJPAUHKEY__@@KPAGPAK22PAE2@Z"},
    {588, "?myRegOpenKeyEx@CRegistry@@AAEJPAUHKEY__@@PBGKKPAPAU2@@Z"},
    {589, "?myRegQueryInfoKey@CRegistry@@AAEJPAUHKEY__@@PAGPAK22222222PAU_FILETIME@@@Z"},
    {590, "?myRegQueryValueEx@CRegistry@@AAEJPAUHKEY__@@PBGPAK2PAE2@Z"},
    {591, "?myRegSetValueEx@CRegistry@@AAEJPAUHKEY__@@PBGKKPBEK@Z"},
    {592, "?ns_list@CObjectPathParser@@AAEHXZ"},
    {593, "?ns_list_rest@CObjectPathParser@@AAEHXZ"},
    {594, "?ns_or_class@CObjectPathParser@@AAEHXZ"},
    {595, "?ns_or_server@CObjectPathParser@@AAEHXZ"},
    {596, "?objref@CObjectPathParser@@AAEHXZ"},
    {597, "?objref_rest@CObjectPathParser@@AAEHXZ"},
    {598, "?optional_objref@CObjectPathParser@@AAEHXZ"},
    {599, "?propname@CObjectPathParser@@AAEHXZ"},
    {600, "?s_bInitted@CWbemProviderGlue@@0HA"},
    {601, "?s_csFactoryMap@CWbemProviderGlue@@0VCCritSec@@A"},
    {602, "?s_csProviderMap@CWbemProviderGlue@@0VCCritSec@@A"},
    {603, "?s_dwMajorVersion@CWbemProviderGlue@@0KA"},
    {604, "?s_dwPlatform@CRegistry@@0KA"},
    {605, "?s_dwPlatform@CWbemProviderGlue@@0KA"},
    {606, "?s_fPlatformSet@CRegistry@@0HA"},
    {607, "?s_factorymap@CWbemProviderGlue@@0V?$map@PBXPAJU?$less@PBX@std@@V?$allocator@PAJ@2@@std@@A"},
    {608, "?s_lObjects@CWbemProviderGlue@@0JA"},
    {609, "?s_providersmap@CWbemProviderGlue@@0V?$map@VCHString@@PAXU?$less@VCHString@@@std@@V?$allocator@PAX@3@@std@@A"},
    {610, "?s_strComputerName@Provider@@0VCHString@@A"},
    {611, "?s_wstrCSDVersion@CWbemProviderGlue@@0PAGA"},
    {612, "_DoCmd@16"},
    {0, NULL}};
static Dw32Ordinal fwpuclnt[] = {
    {1, "FwpmCalloutAdd0"},
    {2, "FwpmCalloutCreateEnumHandle0"},
    {3, "FwpmCalloutDeleteById0"},
    {4, "FwpmCalloutDeleteByKey0"},
    {5, "FwpmCalloutDestroyEnumHandle0"},
    {6, "FwpmCalloutEnum0"},
    {7, "FwpmCalloutGetById0"},
    {8, "FwpmCalloutGetByKey0"},
    {9, "FwpmCalloutGetSecurityInfoByKey0"},
    {10, "FwpmCalloutSetSecurityInfoByKey0"},
    {11, "FwpmCalloutSubscribeChanges0"},
    {12, "FwpmCalloutSubscriptionsGet0"},
    {13, "FwpmCalloutUnsubscribeChanges0"},
    {14, "FwpmDiagnoseNetFailure0"},
    {15, "FwpmEngineClose0"},
    {16, "FwpmEngineGetOption0"},
    {17, "FwpmEngineGetSecurityInfo0"},
    {18, "FwpmEngineOpen0"},
    {19, "FwpmEngineSetOption0"},
    {20, "FwpmEngineSetSecurityInfo0"},
    {21, "FwpmEventProviderCreate0"},
    {22, "FwpmEventProviderDestroy0"},
    {23, "FwpmEventProviderFireNetEvent0"},
    {24, "FwpmEventProviderIsNetEventTypeEnabled0"},
    {25, "FwpmFilterAdd0"},
    {26, "FwpmFilterCreateEnumHandle0"},
    {27, "FwpmFilterDeleteById0"},
    {28, "FwpmFilterDeleteByKey0"},
    {29, "FwpmFilterDestroyEnumHandle0"},
    {30, "FwpmFilterEnum0"},
    {31, "FwpmFilterGetById0"},
    {32, "FwpmFilterGetByKey0"},
    {33, "FwpmFilterGetSecurityInfoByKey0"},
    {34, "FwpmFilterSetSecurityInfoByKey0"},
    {35, "FwpmFilterSubscribeChanges0"},
    {36, "FwpmFilterSubscriptionsGet0"},
    {37, "FwpmFilterUnsubscribeChanges0"},
    {38, "FwpmFreeMemory0"},
    {39, "FwpmGetAppIdFromFileName0"},
    {40, "FwpmIPsecTunnelAdd0"},
    {41, "FwpmIPsecTunnelAdd1"},
    {42, "FwpmIPsecTunnelAddConditions0"},
    {43, "FwpmIPsecTunnelDeleteByKey0"},
    {44, "FwpmLayerCreateEnumHandle0"},
    {45, "FwpmLayerDestroyEnumHandle0"},
    {46, "FwpmLayerEnum0"},
    {47, "FwpmLayerGetById0"},
    {48, "FwpmLayerGetByKey0"},
    {49, "FwpmLayerGetSecurityInfoByKey0"},
    {50, "FwpmLayerSetSecurityInfoByKey0"},
    {51, "FwpmNetEventCreateEnumHandle0"},
    {52, "FwpmNetEventDestroyEnumHandle0"},
    {53, "FwpmNetEventEnum0"},
    {54, "FwpmNetEventEnum1"},
    {55, "FwpmNetEventSubscribe0"},
    {56, "FwpmNetEventSubscriptionsGet0"},
    {57, "FwpmNetEventUnsubscribe0"},
    {58, "FwpmNetEventsGetSecurityInfo0"},
    {59, "FwpmNetEventsLost0"},
    {60, "FwpmNetEventsSetSecurityInfo0"},
    {61, "FwpmProcessNameResolutionEvent0"},
    {62, "FwpmProviderAdd0"},
    {63, "FwpmProviderContextAdd0"},
    {64, "FwpmProviderContextAdd1"},
    {65, "FwpmProviderContextCreateEnumHandle0"},
    {66, "FwpmProviderContextDeleteById0"},
    {67, "FwpmProviderContextDeleteByKey0"},
    {68, "FwpmProviderContextDestroyEnumHandle0"},
    {69, "FwpmProviderContextEnum0"},
    {70, "FwpmProviderContextEnum1"},
    {71, "FwpmProviderContextGetById0"},
    {72, "FwpmProviderContextGetById1"},
    {73, "FwpmProviderContextGetByKey0"},
    {74, "FwpmProviderContextGetByKey1"},
    {75, "FwpmProviderContextGetSecurityInfoByKey0"},
    {76, "FwpmProviderContextSetSecurityInfoByKey0"},
    {77, "FwpmProviderContextSubscribeChanges0"},
    {78, "FwpmProviderContextSubscriptionsGet0"},
    {79, "FwpmProviderContextUnsubscribeChanges0"},
    {80, "FwpmProviderCreateEnumHandle0"},
    {81, "FwpmProviderDeleteByKey0"},
    {82, "FwpmProviderDestroyEnumHandle0"},
    {83, "FwpmProviderEnum0"},
    {84, "FwpmProviderGetByKey0"},
    {85, "FwpmProviderGetSecurityInfoByKey0"},
    {86, "FwpmProviderSetSecurityInfoByKey0"},
    {87, "FwpmProviderSubscribeChanges0"},
    {88, "FwpmProviderSubscriptionsGet0"},
    {89, "FwpmProviderUnsubscribeChanges0"},
    {90, "FwpmSessionCreateEnumHandle0"},
    {91, "FwpmSessionDestroyEnumHandle0"},
    {92, "FwpmSessionEnum0"},
    {93, "FwpmSubLayerAdd0"},
    {94, "FwpmSubLayerCreateEnumHandle0"},
    {95, "FwpmSubLayerDeleteByKey0"},
    {96, "FwpmSubLayerDestroyEnumHandle0"},
    {97, "FwpmSubLayerEnum0"},
    {98, "FwpmSubLayerGetByKey0"},
    {99, "FwpmSubLayerGetSecurityInfoByKey0"},
    {100, "FwpmSubLayerSetSecurityInfoByKey0"},
    {101, "FwpmSubLayerSubscribeChanges0"},
    {102, "FwpmSubLayerSubscriptionsGet0"},
    {103, "FwpmSubLayerUnsubscribeChanges0"},
    {104, "FwpmSystemPortsGet0"},
    {105, "FwpmSystemPortsSubscribe0"},
    {106, "FwpmSystemPortsUnsubscribe0"},
    {107, "FwpmTraceRestoreDefaults0"},
    {108, "FwpmTransactionAbort0"},
    {109, "FwpmTransactionBegin0"},
    {110, "FwpmTransactionCommit0"},
    {111, "FwpsAleEndpointCreateEnumHandle0"},
    {112, "FwpsAleEndpointDestroyEnumHandle0"},
    {113, "FwpsAleEndpointEnum0"},
    {114, "FwpsAleEndpointGetById0"},
    {115, "FwpsAleEndpointGetSecurityInfo0"},
    {116, "FwpsAleEndpointSetSecurityInfo0"},
    {117, "FwpsAleExplicitCredentialsQuery0"},
    {118, "FwpsAleGetPortStatus0"},
    {119, "FwpsClassifyUser0"},
    {120, "FwpsFreeMemory0"},
    {121, "FwpsGetInProcReplicaOffset0"},
    {122, "FwpsLayerCreateInProcReplica0"},
    {123, "FwpsLayerReleaseInProcReplica0"},
    {124, "FwpsOpenToken0"},
    {125, "FwpsQueryIPsecDosFWUsed0"},
    {126, "FwpsQueryIPsecOffloadDone0"},
    {127, "GetUnifiedTraceHandle"},
    {128, "IPsecDospGetSecurityInfo0"},
    {129, "IPsecDospGetStatistics0"},
    {130, "IPsecDospSetSecurityInfo0"},
    {131, "IPsecDospStateCreateEnumHandle0"},
    {132, "IPsecDospStateDestroyEnumHandle0"},
    {133, "IPsecDospStateEnum0"},
    {134, "IPsecGetStatistics0"},
    {135, "IPsecGetStatistics1"},
    {136, "IPsecKeyModuleAdd0"},
    {137, "IPsecKeyModuleDelete0"},
    {138, "IPsecKeyModuleUpdateAcquire0"},
    {139, "IPsecSaContextAddInbound0"},
    {140, "IPsecSaContextAddInbound1"},
    {141, "IPsecSaContextAddOutbound0"},
    {142, "IPsecSaContextAddOutbound1"},
    {143, "IPsecSaContextCreate0"},
    {144, "IPsecSaContextCreate1"},
    {145, "IPsecSaContextCreateEnumHandle0"},
    {146, "IPsecSaContextDeleteById0"},
    {147, "IPsecSaContextDestroyEnumHandle0"},
    {148, "IPsecSaContextEnum0"},
    {149, "IPsecSaContextEnum1"},
    {150, "IPsecSaContextExpire0"},
    {151, "IPsecSaContextGetById0"},
    {152, "IPsecSaContextGetById1"},
    {153, "IPsecSaContextGetSpi0"},
    {154, "IPsecSaContextGetSpi1"},
    {155, "IPsecSaContextSetSpi0"},
    {156, "IPsecSaContextUpdate0"},
    {157, "IPsecSaCreateEnumHandle0"},
    {158, "IPsecSaDbGetSecurityInfo0"},
    {159, "IPsecSaDbSetSecurityInfo0"},
    {160, "IPsecSaDestroyEnumHandle0"},
    {161, "IPsecSaEnum0"},
    {162, "IPsecSaEnum1"},
    {163, "IPsecSaInitiateAsync0"},
    {164, "IkeextGetConfigParameters0"},
    {165, "IkeextGetStatistics0"},
    {166, "IkeextGetStatistics1"},
    {167, "IkeextSaCreateEnumHandle0"},
    {168, "IkeextSaDbGetSecurityInfo0"},
    {169, "IkeextSaDbSetSecurityInfo0"},
    {170, "IkeextSaDeleteById0"},
    {171, "IkeextSaDestroyEnumHandle0"},
    {172, "IkeextSaEnum0"},
    {173, "IkeextSaEnum1"},
    {174, "IkeextSaGetById0"},
    {175, "IkeextSaGetById1"},
    {176, "IkeextSaUpdateAdditionalAddressesByTunnelId0"},
    {177, "IkeextSaUpdatePreferredAddressesByTunnelId0"},
    {178, "IkeextSetConfigParameters0"},
    {179, "NamespaceCallout"},
    {180, "WSADeleteSocketPeerTargetName"},
    {181, "WSAImpersonateSocketPeer"},
    {182, "WSAQuerySocketSecurity"},
    {183, "WSARevertImpersonation"},
    {184, "WSASetSocketPeerTargetName"},
    {185, "WSASetSocketSecurity"},
    {0, NULL}};
static Dw32Ordinal fxsutility[] = {
    {1, "CanSendToFaxRecipient"},
    {2, "DllCanUnloadNow"},
    {3, "DllGetClassObject"},
    {4, "DllRegisterServer"},
    {5, "DllUnregisterServer"},
    {6, "GetProxyDllInfo"},
    {7, "SendToFaxRecipient"},
    {0, NULL}};
static Dw32Ordinal gdi32[] = {
    {1012, "AbortDoc"},
    {1013, "AbortPath"},
    {1014, "AddFontMemResourceEx"},
    {1015, "AddFontResourceA"},
    {1016, "AddFontResourceExA"},
    {1017, "AddFontResourceExW"},
    {1018, "AddFontResourceTracking"},
    {1019, "AddFontResourceW"},
    {1020, "AngleArc"},
    {1021, "AnimatePalette"},
    {1022, "AnyLinkedFonts"},
    {1023, "Arc"},
    {1024, "ArcTo"},
    {1025, "BRUSHOBJ_hGetColorTransform"},
    {1026, "BRUSHOBJ_pvAllocRbrush"},
    {1027, "BRUSHOBJ_pvGetRbrush"},
    {1028, "BRUSHOBJ_ulGetBrushColor"},
    {1029, "BeginGdiRendering"},
    {1030, "BeginPath"},
    {1031, "BitBlt"},
    {1032, "CLIPOBJ_bEnum"},
    {1033, "CLIPOBJ_cEnumStart"},
    {1034, "CLIPOBJ_ppoGetPath"},
    {1035, "CancelDC"},
    {1036, "CheckColorsInGamut"},
    {1037, "ChoosePixelFormat"},
    {1038, "Chord"},
    {1039, "ClearBitmapAttributes"},
    {1040, "ClearBrushAttributes"},
    {1041, "CloseEnhMetaFile"},
    {1042, "CloseFigure"},
    {1043, "CloseMetaFile"},
    {1044, "ColorCorrectPalette"},
    {1045, "ColorMatchToTarget"},
    {1046, "CombineRgn"},
    {1047, "CombineTransform"},
    {1048, "ConfigureOPMProtectedOutput"},
    {1049, "CopyEnhMetaFileA"},
    {1050, "CopyEnhMetaFileW"},
    {1051, "CopyMetaFileA"},
    {1052, "CopyMetaFileW"},
    {1053, "CreateBitmap"},
    {1054, "CreateBitmapFromDxSurface"},
    {1055, "CreateBitmapIndirect"},
    {1056, "CreateBrushIndirect"},
    {1057, "CreateColorSpaceA"},
    {1058, "CreateColorSpaceW"},
    {1059, "CreateCompatibleBitmap"},
    {1060, "CreateCompatibleDC"},
    {1061, "CreateDCA"},
    {1062, "CreateDCW"},
    {1063, "CreateDIBPatternBrush"},
    {1064, "CreateDIBPatternBrushPt"},
    {1065, "CreateDIBSection"},
    {1066, "CreateDIBitmap"},
    {1067, "CreateDiscardableBitmap"},
    {1068, "CreateEllipticRgn"},
    {1069, "CreateEllipticRgnIndirect"},
    {1070, "CreateEnhMetaFileA"},
    {1071, "CreateEnhMetaFileW"},
    {1072, "CreateFontA"},
    {1073, "CreateFontIndirectA"},
    {1074, "CreateFontIndirectExA"},
    {1075, "CreateFontIndirectExW"},
    {1076, "CreateFontIndirectW"},
    {1077, "CreateFontW"},
    {1078, "CreateHalftonePalette"},
    {1079, "CreateHatchBrush"},
    {1080, "CreateICA"},
    {1081, "CreateICW"},
    {1082, "CreateMetaFileA"},
    {1083, "CreateMetaFileW"},
    {1084, "CreateOPMProtectedOutputs"},
    {1085, "CreatePalette"},
    {1086, "CreatePatternBrush"},
    {1087, "CreatePen"},
    {1088, "CreatePenIndirect"},
    {1089, "CreatePolyPolygonRgn"},
    {1090, "CreatePolygonRgn"},
    {1091, "CreateRectRgn"},
    {1092, "CreateRectRgnIndirect"},
    {1093, "CreateRoundRectRgn"},
    {1094, "CreateScalableFontResourceA"},
    {1095, "CreateScalableFontResourceW"},
    {1096, "CreateSolidBrush"},
    {1097, "D3DKMTAcquireKeyedMutex"},
    {1098, "D3DKMTCheckExclusiveOwnership"},
    {1099, "D3DKMTCheckMonitorPowerState"},
    {1100, "D3DKMTCheckOcclusion"},
    {1101, "D3DKMTCheckSharedResourceAccess"},
    {1102, "D3DKMTCheckVidPnExclusiveOwnership"},
    {1103, "D3DKMTCloseAdapter"},
    {1104, "D3DKMTConfigureSharedResource"},
    {1106, "D3DKMTCreateAllocation"},
    {1105, "D3DKMTCreateAllocation2"},
    {1107, "D3DKMTCreateContext"},
    {1108, "D3DKMTCreateDCFromMemory"},
    {1109, "D3DKMTCreateDevice"},
    {1110, "D3DKMTCreateKeyedMutex"},
    {1111, "D3DKMTCreateOverlay"},
    {1113, "D3DKMTCreateSynchronizationObject"},
    {1112, "D3DKMTCreateSynchronizationObject2"},
    {1114, "D3DKMTDestroyAllocation"},
    {1115, "D3DKMTDestroyContext"},
    {1116, "D3DKMTDestroyDCFromMemory"},
    {1117, "D3DKMTDestroyDevice"},
    {1118, "D3DKMTDestroyKeyedMutex"},
    {1119, "D3DKMTDestroyOverlay"},
    {1120, "D3DKMTDestroySynchronizationObject"},
    {1121, "D3DKMTEscape"},
    {1122, "D3DKMTFlipOverlay"},
    {1123, "D3DKMTGetContextSchedulingPriority"},
    {1124, "D3DKMTGetDeviceState"},
    {1125, "D3DKMTGetDisplayModeList"},
    {1126, "D3DKMTGetMultisampleMethodList"},
    {1127, "D3DKMTGetOverlayState"},
    {1128, "D3DKMTGetPresentHistory"},
    {1129, "D3DKMTGetPresentQueueEvent"},
    {1130, "D3DKMTGetProcessSchedulingPriorityClass"},
    {1131, "D3DKMTGetRuntimeData"},
    {1132, "D3DKMTGetScanLine"},
    {1133, "D3DKMTGetSharedPrimaryHandle"},
    {1134, "D3DKMTInvalidateActiveVidPn"},
    {1135, "D3DKMTLock"},
    {1136, "D3DKMTOpenAdapterFromDeviceName"},
    {1137, "D3DKMTOpenAdapterFromGdiDisplayName"},
    {1138, "D3DKMTOpenAdapterFromHdc"},
    {1139, "D3DKMTOpenKeyedMutex"},
    {1141, "D3DKMTOpenResource"},
    {1140, "D3DKMTOpenResource2"},
    {1142, "D3DKMTOpenSynchronizationObject"},
    {1143, "D3DKMTPollDisplayChildren"},
    {1144, "D3DKMTPresent"},
    {1145, "D3DKMTQueryAdapterInfo"},
    {1146, "D3DKMTQueryAllocationResidency"},
    {1147, "D3DKMTQueryResourceInfo"},
    {1148, "D3DKMTQueryStatistics"},
    {1149, "D3DKMTReleaseKeyedMutex"},
    {1150, "D3DKMTReleaseProcessVidPnSourceOwners"},
    {1151, "D3DKMTRender"},
    {1152, "D3DKMTSetAllocationPriority"},
    {1153, "D3DKMTSetContextSchedulingPriority"},
    {1154, "D3DKMTSetDisplayMode"},
    {1155, "D3DKMTSetDisplayPrivateDriverFormat"},
    {1156, "D3DKMTSetGammaRamp"},
    {1157, "D3DKMTSetProcessSchedulingPriorityClass"},
    {1158, "D3DKMTSetQueuedLimit"},
    {1159, "D3DKMTSetVidPnSourceOwner"},
    {1160, "D3DKMTSharedPrimaryLockNotification"},
    {1161, "D3DKMTSharedPrimaryUnLockNotification"},
    {1163, "D3DKMTSignalSynchronizationObject"},
    {1162, "D3DKMTSignalSynchronizationObject2"},
    {1164, "D3DKMTUnlock"},
    {1165, "D3DKMTUpdateOverlay"},
    {1166, "D3DKMTWaitForIdle"},
    {1168, "D3DKMTWaitForSynchronizationObject"},
    {1167, "D3DKMTWaitForSynchronizationObject2"},
    {1169, "D3DKMTWaitForVerticalBlankEvent"},
    {1170, "DDCCIGetCapabilitiesString"},
    {1171, "DDCCIGetCapabilitiesStringLength"},
    {1172, "DDCCIGetTimingReport"},
    {1173, "DDCCIGetVCPFeature"},
    {1174, "DDCCISaveCurrentSettings"},
    {1175, "DDCCISetVCPFeature"},
    {1176, "DPtoLP"},
    {1177, "DdCreateFullscreenSprite"},
    {1178, "DdDestroyFullscreenSprite"},
    {1179, "DdEntry0"},
    {1190, "DdEntry1"},
    {1180, "DdEntry10"},
    {1181, "DdEntry11"},
    {1182, "DdEntry12"},
    {1183, "DdEntry13"},
    {1184, "DdEntry14"},
    {1185, "DdEntry15"},
    {1186, "DdEntry16"},
    {1187, "DdEntry17"},
    {1188, "DdEntry18"},
    {1189, "DdEntry19"},
    {1201, "DdEntry2"},
    {1191, "DdEntry20"},
    {1192, "DdEntry21"},
    {1193, "DdEntry22"},
    {1194, "DdEntry23"},
    {1195, "DdEntry24"},
    {1196, "DdEntry25"},
    {1197, "DdEntry26"},
    {1198, "DdEntry27"},
    {1199, "DdEntry28"},
    {1200, "DdEntry29"},
    {1212, "DdEntry3"},
    {1202, "DdEntry30"},
    {1203, "DdEntry31"},
    {1204, "DdEntry32"},
    {1205, "DdEntry33"},
    {1206, "DdEntry34"},
    {1207, "DdEntry35"},
    {1208, "DdEntry36"},
    {1209, "DdEntry37"},
    {1210, "DdEntry38"},
    {1211, "DdEntry39"},
    {1223, "DdEntry4"},
    {1213, "DdEntry40"},
    {1214, "DdEntry41"},
    {1215, "DdEntry42"},
    {1216, "DdEntry43"},
    {1217, "DdEntry44"},
    {1218, "DdEntry45"},
    {1219, "DdEntry46"},
    {1220, "DdEntry47"},
    {1221, "DdEntry48"},
    {1222, "DdEntry49"},
    {1231, "DdEntry5"},
    {1224, "DdEntry50"},
    {1225, "DdEntry51"},
    {1226, "DdEntry52"},
    {1227, "DdEntry53"},
    {1228, "DdEntry54"},
    {1229, "DdEntry55"},
    {1230, "DdEntry56"},
    {1232, "DdEntry6"},
    {1233, "DdEntry7"},
    {1234, "DdEntry8"},
    {1235, "DdEntry9"},
    {1236, "DdNotifyFullscreenSpriteUpdate"},
    {1237, "DdQueryVisRgnUniqueness"},
    {1238, "DeleteColorSpace"},
    {1239, "DeleteDC"},
    {1240, "DeleteEnhMetaFile"},
    {1241, "DeleteMetaFile"},
    {1242, "DeleteObject"},
    {1243, "DescribePixelFormat"},
    {1244, "DestroyOPMProtectedOutput"},
    {1245, "DestroyPhysicalMonitorInternal"},
    {1246, "DeviceCapabilitiesExA"},
    {1247, "DeviceCapabilitiesExW"},
    {1248, "DrawEscape"},
    {1249, "Ellipse"},
    {1250, "EnableEUDC"},
    {1251, "EndDoc"},
    {1252, "EndFormPage"},
    {1253, "EndGdiRendering"},
    {1254, "EndPage"},
    {1255, "EndPath"},
    {1256, "EngAcquireSemaphore"},
    {1257, "EngAlphaBlend"},
    {1258, "EngAssociateSurface"},
    {1259, "EngBitBlt"},
    {1260, "EngCheckAbort"},
    {1261, "EngComputeGlyphSet"},
    {1262, "EngCopyBits"},
    {1263, "EngCreateBitmap"},
    {1264, "EngCreateClip"},
    {1265, "EngCreateDeviceBitmap"},
    {1266, "EngCreateDeviceSurface"},
    {1267, "EngCreatePalette"},
    {1268, "EngCreateSemaphore"},
    {1269, "EngDeleteClip"},
    {1270, "EngDeletePalette"},
    {1271, "EngDeletePath"},
    {1272, "EngDeleteSemaphore"},
    {1273, "EngDeleteSurface"},
    {1274, "EngEraseSurface"},
    {1275, "EngFillPath"},
    {1276, "EngFindResource"},
    {1277, "EngFreeModule"},
    {1278, "EngGetCurrentCodePage"},
    {1279, "EngGetDriverName"},
    {1280, "EngGetPrinterDataFileName"},
    {1281, "EngGradientFill"},
    {1282, "EngLineTo"},
    {1283, "EngLoadModule"},
    {1284, "EngLockSurface"},
    {1285, "EngMarkBandingSurface"},
    {1286, "EngMultiByteToUnicodeN"},
    {1287, "EngMultiByteToWideChar"},
    {1288, "EngPaint"},
    {1289, "EngPlgBlt"},
    {1290, "EngQueryEMFInfo"},
    {1291, "EngQueryLocalTime"},
    {1292, "EngReleaseSemaphore"},
    {1293, "EngStretchBlt"},
    {1294, "EngStretchBltROP"},
    {1295, "EngStrokeAndFillPath"},
    {1296, "EngStrokePath"},
    {1297, "EngTextOut"},
    {1298, "EngTransparentBlt"},
    {1299, "EngUnicodeToMultiByteN"},
    {1300, "EngUnlockSurface"},
    {1301, "EngWideCharToMultiByte"},
    {1302, "EnumEnhMetaFile"},
    {1303, "EnumFontFamiliesA"},
    {1304, "EnumFontFamiliesExA"},
    {1305, "EnumFontFamiliesExW"},
    {1306, "EnumFontFamiliesW"},
    {1307, "EnumFontsA"},
    {1308, "EnumFontsW"},
    {1309, "EnumICMProfilesA"},
    {1310, "EnumICMProfilesW"},
    {1311, "EnumMetaFile"},
    {1312, "EnumObjects"},
    {1313, "EqualRgn"},
    {1314, "Escape"},
    {1315, "EudcLoadLinkW"},
    {1316, "EudcUnloadLinkW"},
    {1317, "ExcludeClipRect"},
    {1318, "ExtCreatePen"},
    {1319, "ExtCreateRegion"},
    {1320, "ExtEscape"},
    {1321, "ExtFloodFill"},
    {1322, "ExtSelectClipRgn"},
    {1323, "ExtTextOutA"},
    {1324, "ExtTextOutW"},
    {1325, "FONTOBJ_cGetAllGlyphHandles"},
    {1326, "FONTOBJ_cGetGlyphs"},
    {1327, "FONTOBJ_pQueryGlyphAttrs"},
    {1328, "FONTOBJ_pfdg"},
    {1329, "FONTOBJ_pifi"},
    {1330, "FONTOBJ_pvTrueTypeFontFile"},
    {1331, "FONTOBJ_pxoGetXform"},
    {1332, "FONTOBJ_vGetInfo"},
    {1333, "FillPath"},
    {1334, "FillRgn"},
    {1335, "FixBrushOrgEx"},
    {1336, "FlattenPath"},
    {1337, "FloodFill"},
    {1338, "FontIsLinked"},
    {1339, "FrameRgn"},
    {1340, "GdiAddFontResourceW"},
    {1341, "GdiAddGlsBounds"},
    {1342, "GdiAddGlsRecord"},
    {1343, "GdiAlphaBlend"},
    {1344, "GdiArtificialDecrementDriver"},
    {1345, "GdiCleanCacheDC"},
    {1346, "GdiComment"},
    {1347, "GdiConsoleTextOut"},
    {1348, "GdiConvertAndCheckDC"},
    {1349, "GdiConvertBitmap"},
    {1350, "GdiConvertBitmapV5"},
    {1351, "GdiConvertBrush"},
    {1352, "GdiConvertDC"},
    {1353, "GdiConvertEnhMetaFile"},
    {1354, "GdiConvertFont"},
    {1355, "GdiConvertMetaFilePict"},
    {1356, "GdiConvertPalette"},
    {1357, "GdiConvertRegion"},
    {1358, "GdiConvertToDevmodeW"},
    {1359, "GdiCreateLocalEnhMetaFile"},
    {1360, "GdiCreateLocalMetaFilePict"},
    {1361, "GdiDeleteLocalDC"},
    {1362, "GdiDeleteSpoolFileHandle"},
    {1363, "GdiDescribePixelFormat"},
    {1364, "GdiDllInitialize"},
    {1365, "GdiDrawStream"},
    {1366, "GdiEndDocEMF"},
    {1367, "GdiEndPageEMF"},
    {1375, "GdiEntry1"},
    {1368, "GdiEntry10"},
    {1369, "GdiEntry11"},
    {1370, "GdiEntry12"},
    {1371, "GdiEntry13"},
    {1372, "GdiEntry14"},
    {1373, "GdiEntry15"},
    {1374, "GdiEntry16"},
    {1376, "GdiEntry2"},
    {1377, "GdiEntry3"},
    {1378, "GdiEntry4"},
    {1379, "GdiEntry5"},
    {1380, "GdiEntry6"},
    {1381, "GdiEntry7"},
    {1382, "GdiEntry8"},
    {1383, "GdiEntry9"},
    {1384, "GdiFixUpHandle"},
    {1385, "GdiFlush"},
    {1386, "GdiFullscreenControl"},
    {1387, "GdiGetBatchLimit"},
    {1388, "GdiGetBitmapBitsSize"},
    {1389, "GdiGetCharDimensions"},
    {1390, "GdiGetCodePage"},
    {1391, "GdiGetDC"},
    {1392, "GdiGetDevmodeForPage"},
    {1393, "GdiGetLocalBrush"},
    {1394, "GdiGetLocalDC"},
    {1395, "GdiGetLocalFont"},
    {1396, "GdiGetPageCount"},
    {1397, "GdiGetPageHandle"},
    {1398, "GdiGetSpoolFileHandle"},
    {1399, "GdiGetSpoolMessage"},
    {1400, "GdiGradientFill"},
    {1401, "GdiInitSpool"},
    {1402, "GdiInitializeLanguagePack"},
    {1403, "GdiIsMetaFileDC"},
    {1404, "GdiIsMetaPrintDC"},
    {1405, "GdiIsPlayMetafileDC"},
    {1406, "GdiIsScreenDC"},
    {1407, "GdiLoadType1Fonts"},
    {1408, "GdiPlayDCScript"},
    {1409, "GdiPlayEMF"},
    {1410, "GdiPlayJournal"},
    {1411, "GdiPlayPageEMF"},
    {1412, "GdiPlayPrivatePageEMF"},
    {1413, "GdiPlayScript"},
    {1414, "GdiPrinterThunk"},
    {1415, "GdiProcessSetup"},
    {1416, "GdiQueryFonts"},
    {1417, "GdiQueryTable"},
    {1418, "GdiRealizationInfo"},
    {1419, "GdiReleaseDC"},
    {1420, "GdiReleaseLocalDC"},
    {1421, "GdiResetDCEMF"},
    {1422, "GdiSetAttrs"},
    {1423, "GdiSetBatchLimit"},
    {1424, "GdiSetLastError"},
    {1425, "GdiSetPixelFormat"},
    {1426, "GdiSetServerAttr"},
    {1427, "GdiStartDocEMF"},
    {1428, "GdiStartPageEMF"},
    {1429, "GdiSwapBuffers"},
    {1430, "GdiTransparentBlt"},
    {1431, "GdiValidateHandle"},
    {1432, "GetArcDirection"},
    {1433, "GetAspectRatioFilterEx"},
    {1434, "GetBitmapAttributes"},
    {1435, "GetBitmapBits"},
    {1436, "GetBitmapDimensionEx"},
    {1437, "GetBkColor"},
    {1438, "GetBkMode"},
    {1439, "GetBoundsRect"},
    {1440, "GetBrushAttributes"},
    {1441, "GetBrushOrgEx"},
    {1442, "GetCOPPCompatibleOPMInformation"},
    {1443, "GetCertificate"},
    {1444, "GetCertificateSize"},
    {1445, "GetCharABCWidthsA"},
    {1446, "GetCharABCWidthsFloatA"},
    {1447, "GetCharABCWidthsFloatW"},
    {1448, "GetCharABCWidthsI"},
    {1449, "GetCharABCWidthsW"},
    {1450, "GetCharWidth32A"},
    {1451, "GetCharWidth32W"},
    {1452, "GetCharWidthA"},
    {1453, "GetCharWidthFloatA"},
    {1454, "GetCharWidthFloatW"},
    {1455, "GetCharWidthI"},
    {1456, "GetCharWidthInfo"},
    {1457, "GetCharWidthW"},
    {1458, "GetCharacterPlacementA"},
    {1459, "GetCharacterPlacementW"},
    {1460, "GetClipBox"},
    {1461, "GetClipRgn"},
    {1462, "GetColorAdjustment"},
    {1463, "GetColorSpace"},
    {1464, "GetCurrentObject"},
    {1465, "GetCurrentPositionEx"},
    {1466, "GetDCBrushColor"},
    {1467, "GetDCOrgEx"},
    {1468, "GetDCPenColor"},
    {1469, "GetDIBColorTable"},
    {1470, "GetDIBits"},
    {1471, "GetDeviceCaps"},
    {1472, "GetDeviceGammaRamp"},
    {1473, "GetETM"},
    {1474, "GetEUDCTimeStamp"},
    {1475, "GetEUDCTimeStampExW"},
    {1476, "GetEnhMetaFileA"},
    {1477, "GetEnhMetaFileBits"},
    {1478, "GetEnhMetaFileDescriptionA"},
    {1479, "GetEnhMetaFileDescriptionW"},
    {1480, "GetEnhMetaFileHeader"},
    {1481, "GetEnhMetaFilePaletteEntries"},
    {1482, "GetEnhMetaFilePixelFormat"},
    {1483, "GetEnhMetaFileW"},
    {1484, "GetFontAssocStatus"},
    {1485, "GetFontData"},
    {1486, "GetFontFileData"},
    {1487, "GetFontFileInfo"},
    {1488, "GetFontLanguageInfo"},
    {1489, "GetFontRealizationInfo"},
    {1490, "GetFontResourceInfoW"},
    {1491, "GetFontUnicodeRanges"},
    {1492, "GetGlyphIndicesA"},
    {1493, "GetGlyphIndicesW"},
    {1494, "GetGlyphOutline"},
    {1495, "GetGlyphOutlineA"},
    {1496, "GetGlyphOutlineW"},
    {1497, "GetGlyphOutlineWow"},
    {1498, "GetGraphicsMode"},
    {1499, "GetHFONT"},
    {1500, "GetICMProfileA"},
    {1501, "GetICMProfileW"},
    {1502, "GetKerningPairs"},
    {1503, "GetKerningPairsA"},
    {1504, "GetKerningPairsW"},
    {1505, "GetLayout"},
    {1506, "GetLogColorSpaceA"},
    {1507, "GetLogColorSpaceW"},
    {1508, "GetMapMode"},
    {1509, "GetMetaFileA"},
    {1510, "GetMetaFileBitsEx"},
    {1511, "GetMetaFileW"},
    {1512, "GetMetaRgn"},
    {1513, "GetMiterLimit"},
    {1514, "GetNearestColor"},
    {1515, "GetNearestPaletteIndex"},
    {1516, "GetNumberOfPhysicalMonitors"},
    {1517, "GetOPMInformation"},
    {1518, "GetOPMRandomNumber"},
    {1519, "GetObjectA"},
    {1520, "GetObjectType"},
    {1521, "GetObjectW"},
    {1522, "GetOutlineTextMetricsA"},
    {1523, "GetOutlineTextMetricsW"},
    {1524, "GetPaletteEntries"},
    {1525, "GetPath"},
    {1526, "GetPhysicalMonitorDescription"},
    {1527, "GetPhysicalMonitors"},
    {1528, "GetPixel"},
    {1529, "GetPixelFormat"},
    {1530, "GetPolyFillMode"},
    {1531, "GetROP2"},
    {1532, "GetRandomRgn"},
    {1533, "GetRasterizerCaps"},
    {1534, "GetRegionData"},
    {1535, "GetRelAbs"},
    {1536, "GetRgnBox"},
    {1537, "GetStockObject"},
    {1538, "GetStretchBltMode"},
    {1539, "GetStringBitmapA"},
    {1540, "GetStringBitmapW"},
    {1541, "GetSuggestedOPMProtectedOutputArraySize"},
    {1542, "GetSystemPaletteEntries"},
    {1543, "GetSystemPaletteUse"},
    {1544, "GetTextAlign"},
    {1545, "GetTextCharacterExtra"},
    {1546, "GetTextCharset"},
    {1547, "GetTextCharsetInfo"},
    {1548, "GetTextColor"},
    {1549, "GetTextExtentExPointA"},
    {1550, "GetTextExtentExPointI"},
    {1551, "GetTextExtentExPointW"},
    {1552, "GetTextExtentExPointWPri"},
    {1553, "GetTextExtentPoint32A"},
    {1554, "GetTextExtentPoint32W"},
    {1555, "GetTextExtentPointA"},
    {1556, "GetTextExtentPointI"},
    {1557, "GetTextExtentPointW"},
    {1558, "GetTextFaceA"},
    {1559, "GetTextFaceAliasW"},
    {1560, "GetTextFaceW"},
    {1561, "GetTextMetricsA"},
    {1562, "GetTextMetricsW"},
    {1563, "GetTransform"},
    {1564, "GetViewportExtEx"},
    {1565, "GetViewportOrgEx"},
    {1566, "GetWinMetaFileBits"},
    {1567, "GetWindowExtEx"},
    {1568, "GetWindowOrgEx"},
    {1569, "GetWorldTransform"},
    {1570, "HT_Get8BPPFormatPalette"},
    {1571, "HT_Get8BPPMaskPalette"},
    {1572, "IntersectClipRect"},
    {1573, "InvertRgn"},
    {1574, "IsValidEnhMetaRecord"},
    {1575, "IsValidEnhMetaRecordOffExt"},
    {1576, "LPtoDP"},
    {1577, "LineDDA"},
    {1578, "LineTo"},
    {1579, "MaskBlt"},
    {1580, "MirrorRgn"},
    {1581, "ModifyWorldTransform"},
    {1582, "MoveToEx"},
    {1583, "NamedEscape"},
    {1584, "OffsetClipRgn"},
    {1585, "OffsetRgn"},
    {1586, "OffsetViewportOrgEx"},
    {1587, "OffsetWindowOrgEx"},
    {1588, "PATHOBJ_bEnum"},
    {1589, "PATHOBJ_bEnumClipLines"},
    {1590, "PATHOBJ_vEnumStart"},
    {1591, "PATHOBJ_vEnumStartClipLines"},
    {1592, "PATHOBJ_vGetBounds"},
    {1593, "PaintRgn"},
    {1594, "PatBlt"},
    {1595, "PathToRegion"},
    {1596, "Pie"},
    {1597, "PlayEnhMetaFile"},
    {1598, "PlayEnhMetaFileRecord"},
    {1599, "PlayMetaFile"},
    {1600, "PlayMetaFileRecord"},
    {1601, "PlgBlt"},
    {1602, "PolyBezier"},
    {1603, "PolyBezierTo"},
    {1604, "PolyDraw"},
    {1605, "PolyPatBlt"},
    {1606, "PolyPolygon"},
    {1607, "PolyPolyline"},
    {1608, "PolyTextOutA"},
    {1609, "PolyTextOutW"},
    {1610, "Polygon"},
    {1611, "Polyline"},
    {1612, "PolylineTo"},
    {1613, "PtInRegion"},
    {1614, "PtVisible"},
    {1615, "QueryFontAssocStatus"},
    {1616, "RealizePalette"},
    {1617, "RectInRegion"},
    {1618, "RectVisible"},
    {1619, "Rectangle"},
    {1620, "RemoveFontMemResourceEx"},
    {1621, "RemoveFontResourceA"},
    {1622, "RemoveFontResourceExA"},
    {1623, "RemoveFontResourceExW"},
    {1624, "RemoveFontResourceTracking"},
    {1625, "RemoveFontResourceW"},
    {1626, "ResetDCA"},
    {1627, "ResetDCW"},
    {1628, "ResizePalette"},
    {1629, "RestoreDC"},
    {1630, "RoundRect"},
    {1631, "STROBJ_bEnum"},
    {1632, "STROBJ_bEnumPositionsOnly"},
    {1633, "STROBJ_bGetAdvanceWidths"},
    {1634, "STROBJ_dwGetCodePage"},
    {1635, "STROBJ_vEnumStart"},
    {1636, "SaveDC"},
    {1637, "ScaleViewportExtEx"},
    {1638, "ScaleWindowExtEx"},
    {1639, "SelectBrushLocal"},
    {1640, "SelectClipPath"},
    {1641, "SelectClipRgn"},
    {1642, "SelectFontLocal"},
    {1643, "SelectObject"},
    {1644, "SelectPalette"},
    {1645, "SetAbortProc"},
    {1646, "SetArcDirection"},
    {1647, "SetBitmapAttributes"},
    {1648, "SetBitmapBits"},
    {1649, "SetBitmapDimensionEx"},
    {1650, "SetBkColor"},
    {1651, "SetBkMode"},
    {1652, "SetBoundsRect"},
    {1653, "SetBrushAttributes"},
    {1654, "SetBrushOrgEx"},
    {1655, "SetColorAdjustment"},
    {1656, "SetColorSpace"},
    {1657, "SetDCBrushColor"},
    {1658, "SetDCPenColor"},
    {1659, "SetDIBColorTable"},
    {1660, "SetDIBits"},
    {1661, "SetDIBitsToDevice"},
    {1662, "SetDeviceGammaRamp"},
    {1663, "SetEnhMetaFileBits"},
    {1664, "SetFontEnumeration"},
    {1665, "SetGraphicsMode"},
    {1666, "SetICMMode"},
    {1667, "SetICMProfileA"},
    {1668, "SetICMProfileW"},
    {1669, "SetLayout"},
    {1670, "SetLayoutWidth"},
    {1671, "SetMagicColors"},
    {1672, "SetMapMode"},
    {1673, "SetMapperFlags"},
    {1674, "SetMetaFileBitsEx"},
    {1675, "SetMetaRgn"},
    {1676, "SetMiterLimit"},
    {1677, "SetOPMSigningKeyAndSequenceNumbers"},
    {1678, "SetPaletteEntries"},
    {1679, "SetPixel"},
    {1680, "SetPixelFormat"},
    {1681, "SetPixelV"},
    {1682, "SetPolyFillMode"},
    {1683, "SetROP2"},
    {1684, "SetRectRgn"},
    {1685, "SetRelAbs"},
    {1686, "SetStretchBltMode"},
    {1687, "SetSystemPaletteUse"},
    {1688, "SetTextAlign"},
    {1689, "SetTextCharacterExtra"},
    {1690, "SetTextColor"},
    {1691, "SetTextJustification"},
    {1692, "SetViewportExtEx"},
    {1693, "SetViewportOrgEx"},
    {1694, "SetVirtualResolution"},
    {1695, "SetWinMetaFileBits"},
    {1696, "SetWindowExtEx"},
    {1697, "SetWindowOrgEx"},
    {1698, "SetWorldTransform"},
    {1699, "StartDocA"},
    {1700, "StartDocW"},
    {1701, "StartFormPage"},
    {1702, "StartPage"},
    {1703, "StretchBlt"},
    {1704, "StretchDIBits"},
    {1705, "StrokeAndFillPath"},
    {1706, "StrokePath"},
    {1707, "SwapBuffers"},
    {1708, "TextOutA"},
    {1709, "TextOutW"},
    {1710, "TranslateCharsetInfo"},
    {1711, "UnloadNetworkFonts"},
    {1712, "UnrealizeObject"},
    {1713, "UpdateColors"},
    {1714, "UpdateICMRegKeyA"},
    {1715, "UpdateICMRegKeyW"},
    {1716, "WidenPath"},
    {1717, "XFORMOBJ_bApplyXform"},
    {1718, "XFORMOBJ_iGetXform"},
    {1719, "XLATEOBJ_cGetPalette"},
    {1720, "XLATEOBJ_hGetColorTransform"},
    {1721, "XLATEOBJ_iXlate"},
    {1722, "XLATEOBJ_piVector"},
    {1723, "bInitSystemAndFontsDirectoriesW"},
    {1724, "bMakePathNameW"},
    {1725, "cGetTTFFromFOT"},
    {1726, "gdiPlaySpoolStream"},
    {0, NULL}};
static Dw32Ordinal glu32[] = {
    {1, "gluBeginCurve"},
    {2, "gluBeginPolygon"},
    {3, "gluBeginSurface"},
    {4, "gluBeginTrim"},
    {5, "gluBuild1DMipmaps"},
    {6, "gluBuild2DMipmaps"},
    {7, "gluCylinder"},
    {8, "gluDeleteNurbsRenderer"},
    {9, "gluDeleteQuadric"},
    {10, "gluDeleteTess"},
    {11, "gluDisk"},
    {12, "gluEndCurve"},
    {13, "gluEndPolygon"},
    {14, "gluEndSurface"},
    {15, "gluEndTrim"},
    {16, "gluErrorString"},
    {17, "gluErrorUnicodeStringEXT"},
    {18, "gluGetNurbsProperty"},
    {19, "gluGetString"},
    {20, "gluGetTessProperty"},
    {21, "gluLoadSamplingMatrices"},
    {22, "gluLookAt"},
    {23, "gluNewNurbsRenderer"},
    {24, "gluNewQuadric"},
    {25, "gluNewTess"},
    {26, "gluNextContour"},
    {27, "gluNurbsCallback"},
    {28, "gluNurbsCurve"},
    {29, "gluNurbsProperty"},
    {30, "gluNurbsSurface"},
    {31, "gluOrtho2D"},
    {32, "gluPartialDisk"},
    {33, "gluPerspective"},
    {34, "gluPickMatrix"},
    {35, "gluProject"},
    {36, "gluPwlCurve"},
    {37, "gluQuadricCallback"},
    {38, "gluQuadricDrawStyle"},
    {39, "gluQuadricNormals"},
    {40, "gluQuadricOrientation"},
    {41, "gluQuadricTexture"},
    {42, "gluScaleImage"},
    {43, "gluSphere"},
    {44, "gluTessBeginContour"},
    {45, "gluTessBeginPolygon"},
    {46, "gluTessCallback"},
    {47, "gluTessEndContour"},
    {48, "gluTessEndPolygon"},
    {49, "gluTessNormal"},
    {50, "gluTessProperty"},
    {51, "gluTessVertex"},
    {52, "gluUnProject"},
    {0, NULL}};
static Dw32Ordinal gpedit[] = {
    {105, "BrowseForGPO"},
    {106, "CreateGPOLink"},
    {107, "DeleteAllGPOLinks"},
    {108, "DeleteGPOLink"},
    {109, "DllCanUnloadNow"},
    {110, "DllGetClassObject"},
    {111, "ExportRSoPData"},
    {112, "ImportRSoPData"},
    {0, NULL}};
static Dw32Ordinal hlink[] = {
    {13, "DllCanUnloadNow"},
    {17, "DllGetClassObject"},
    {19, "DllRegisterServer"},
    {34, "DllUnregisterServer"},
    {7, "HlinkClone"},
    {6, "HlinkCreateBrowseContext"},
    {32, "HlinkCreateExtensionServices"},
    {5, "HlinkCreateFromData"},
    {3, "HlinkCreateFromMoniker"},
    {4, "HlinkCreateFromString"},
    {23, "HlinkCreateShortcut"},
    {29, "HlinkCreateShortcutFromMoniker"},
    {27, "HlinkCreateShortcutFromString"},
    {22, "HlinkGetSpecialReference"},
    {28, "HlinkGetValueFromParams"},
    {25, "HlinkIsShortcut"},
    {10, "HlinkNavigate"},
    {8, "HlinkNavigateToStringReference"},
    {9, "HlinkOnNavigate"},
    {12, "HlinkOnRenameDocument"},
    {18, "HlinkParseDisplayName"},
    {33, "HlinkPreprocessMoniker"},
    {20, "HlinkQueryCreateFromData"},
    {14, "HlinkResolveMonikerForData"},
    {24, "HlinkResolveShortcut"},
    {30, "HlinkResolveShortcutToMoniker"},
    {26, "HlinkResolveShortcutToString"},
    {15, "HlinkResolveStringForData"},
    {21, "HlinkSetSpecialReference"},
    {31, "HlinkTranslateURL"},
    {11, "HlinkUpdateStackItem"},
    {16, "OleSaveToStreamEx"},
    {0, NULL}};
static Dw32Ordinal httpapi[] = {
    {1, "HttpAddFragmentToCache"},
    {2, "HttpAddUrl"},
    {3, "HttpAddUrlToUrlGroup"},
    {4, "HttpCancelHttpRequest"},
    {5, "HttpCloseRequestQueue"},
    {6, "HttpCloseServerSession"},
    {7, "HttpCloseUrlGroup"},
    {8, "HttpControlService"},
    {9, "HttpCreateHttpHandle"},
    {10, "HttpCreateRequestQueue"},
    {11, "HttpCreateServerSession"},
    {12, "HttpCreateUrlGroup"},
    {13, "HttpDeleteServiceConfiguration"},
    {14, "HttpFlushResponseCache"},
    {15, "HttpGetCounters"},
    {16, "HttpInitialize"},
    {17, "HttpQueryRequestQueueProperty"},
    {18, "HttpQueryServerSessionProperty"},
    {19, "HttpQueryServiceConfiguration"},
    {20, "HttpQueryUrlGroupProperty"},
    {21, "HttpReadFragmentFromCache"},
    {22, "HttpReceiveClientCertificate"},
    {23, "HttpReceiveHttpRequest"},
    {24, "HttpReceiveRequestEntityBody"},
    {25, "HttpRemoveUrl"},
    {26, "HttpRemoveUrlFromUrlGroup"},
    {27, "HttpSendHttpResponse"},
    {28, "HttpSendResponseEntityBody"},
    {29, "HttpSetRequestQueueProperty"},
    {30, "HttpSetServerSessionProperty"},
    {31, "HttpSetServiceConfiguration"},
    {32, "HttpSetUrlGroupProperty"},
    {33, "HttpShutdownRequestQueue"},
    {34, "HttpTerminate"},
    {35, "HttpWaitForDemandStart"},
    {36, "HttpWaitForDisconnect"},
    {37, "HttpWaitForDisconnectEx"},
    {0, NULL}};
static Dw32Ordinal icm32[] = {
    {1, "CMCheckColors"},
    {2, "CMCheckColorsInGamut"},
    {3, "CMCheckRGBs"},
    {19, "CMConvertColorNameToIndex"},
    {20, "CMConvertIndexToColorName"},
    {4, "CMCreateDeviceLinkProfile"},
    {5, "CMCreateMultiProfileTransform"},
    {6, "CMCreateProfile"},
    {7, "CMCreateProfileW"},
    {8, "CMCreateTransform"},
    {9, "CMCreateTransformExt"},
    {10, "CMCreateTransformExtW"},
    {11, "CMCreateTransformW"},
    {12, "CMDeleteTransform"},
    {13, "CMGetInfo"},
    {21, "CMGetNamedProfileInfo"},
    {14, "CMIsProfileValid"},
    {15, "CMTranslateColors"},
    {16, "CMTranslateRGB"},
    {17, "CMTranslateRGBs"},
    {18, "CMTranslateRGBsExt"},
    {0, NULL}};
static Dw32Ordinal icmui[] = {
    {1, "SetupColorMatchingA"},
    {2, "SetupColorMatchingW"},
    {0, NULL}};
static Dw32Ordinal iconv[] = {
    {1, "_libiconv_version"},
    {2, "iconv_canonicalize"},
    {3, "libiconv"},
    {4, "libiconv_close"},
    {5, "libiconv_open"},
    {6, "libiconv_set_relocation_prefix"},
    {7, "libiconvctl"},
    {8, "libiconvlist"},
    {0, NULL}};
static Dw32Ordinal imagehlp[] = {
    {2, "BindImage"},
    {3, "BindImageEx"},
    {4, "CheckSumMappedFile"},
    {6, "EnumerateLoadedModules"},
    {5, "EnumerateLoadedModules64"},
    {7, "EnumerateLoadedModulesEx"},
    {8, "EnumerateLoadedModulesExW"},
    {9, "EnumerateLoadedModulesW64"},
    {10, "FindDebugInfoFile"},
    {11, "FindDebugInfoFileEx"},
    {12, "FindExecutableImage"},
    {13, "FindExecutableImageEx"},
    {14, "FindFileInPath"},
    {15, "FindFileInSearchPath"},
    {16, "GetImageConfigInformation"},
    {17, "GetImageUnusedHeaderBytes"},
    {18, "GetTimestampForLoadedLibrary"},
    {19, "ImageAddCertificate"},
    {20, "ImageDirectoryEntryToData"},
    {21, "ImageDirectoryEntryToDataEx"},
    {22, "ImageEnumerateCertificates"},
    {23, "ImageGetCertificateData"},
    {24, "ImageGetCertificateHeader"},
    {25, "ImageGetDigestStream"},
    {26, "ImageLoad"},
    {27, "ImageNtHeader"},
    {28, "ImageRemoveCertificate"},
    {29, "ImageRvaToSection"},
    {30, "ImageRvaToVa"},
    {31, "ImageUnload"},
    {32, "ImagehlpApiVersion"},
    {33, "ImagehlpApiVersionEx"},
    {34, "MakeSureDirectoryPathExists"},
    {35, "MapAndLoad"},
    {36, "MapDebugInformation"},
    {37, "MapFileAndCheckSumA"},
    {38, "MapFileAndCheckSumW"},
    {40, "ReBaseImage"},
    {39, "ReBaseImage64"},
    {41, "RemovePrivateCvSymbolic"},
    {42, "RemovePrivateCvSymbolicEx"},
    {1, "RemoveRelocations"},
    {43, "SearchTreeForFile"},
    {44, "SetImageConfigInformation"},
    {45, "SplitSymbols"},
    {47, "StackWalk"},
    {46, "StackWalk64"},
    {48, "SymCleanup"},
    {49, "SymEnumSym"},
    {50, "SymEnumSymbols"},
    {51, "SymEnumSymbolsForAddr"},
    {52, "SymEnumTypes"},
    {53, "SymEnumTypesByName"},
    {54, "SymEnumTypesByNameW"},
    {55, "SymEnumTypesW"},
    {57, "SymEnumerateModules"},
    {56, "SymEnumerateModules64"},
    {59, "SymEnumerateSymbols"},
    {58, "SymEnumerateSymbols64"},
    {61, "SymEnumerateSymbolsW"},
    {60, "SymEnumerateSymbolsW64"},
    {62, "SymFindFileInPath"},
    {63, "SymFindFileInPathW"},
    {64, "SymFromAddr"},
    {65, "SymFromName"},
    {67, "SymFunctionTableAccess"},
    {66, "SymFunctionTableAccess64"},
    {69, "SymGetLineFromAddr"},
    {68, "SymGetLineFromAddr64"},
    {71, "SymGetLineFromName"},
    {70, "SymGetLineFromName64"},
    {73, "SymGetLineNext"},
    {72, "SymGetLineNext64"},
    {75, "SymGetLinePrev"},
    {74, "SymGetLinePrev64"},
    {77, "SymGetModuleBase"},
    {76, "SymGetModuleBase64"},
    {79, "SymGetModuleInfo"},
    {78, "SymGetModuleInfo64"},
    {81, "SymGetModuleInfoW"},
    {80, "SymGetModuleInfoW64"},
    {82, "SymGetOptions"},
    {83, "SymGetSearchPath"},
    {84, "SymGetSourceFileFromTokenW"},
    {85, "SymGetSourceFileTokenW"},
    {86, "SymGetSourceVarFromTokenW"},
    {88, "SymGetSymFromAddr"},
    {87, "SymGetSymFromAddr64"},
    {90, "SymGetSymFromName"},
    {89, "SymGetSymFromName64"},
    {92, "SymGetSymNext"},
    {91, "SymGetSymNext64"},
    {94, "SymGetSymPrev"},
    {93, "SymGetSymPrev64"},
    {95, "SymGetSymbolFile"},
    {96, "SymGetSymbolFileW"},
    {97, "SymGetTypeFromName"},
    {98, "SymGetTypeFromNameW"},
    {99, "SymGetTypeInfo"},
    {100, "SymGetTypeInfoEx"},
    {101, "SymInitialize"},
    {103, "SymLoadModule"},
    {102, "SymLoadModule64"},
    {104, "SymMatchFileName"},
    {105, "SymMatchFileNameW"},
    {106, "SymMatchString"},
    {107, "SymMatchStringA"},
    {108, "SymMatchStringW"},
    {110, "SymRegisterCallback"},
    {109, "SymRegisterCallback64"},
    {112, "SymRegisterFunctionEntryCallback"},
    {111, "SymRegisterFunctionEntryCallback64"},
    {113, "SymSetContext"},
    {114, "SymSetOptions"},
    {115, "SymSetScopeFromAddr"},
    {116, "SymSetScopeFromIndex"},
    {117, "SymSetSearchPath"},
    {118, "SymSrvGetFileIndexString"},
    {119, "SymSrvGetFileIndexStringW"},
    {120, "SymSrvGetFileIndexes"},
    {121, "SymSrvGetFileIndexesW"},
    {123, "SymUnDName"},
    {122, "SymUnDName64"},
    {125, "SymUnloadModule"},
    {124, "SymUnloadModule64"},
    {126, "TouchFileTimes"},
    {127, "UnDecorateSymbolName"},
    {128, "UnMapAndLoad"},
    {129, "UnmapDebugInformation"},
    {130, "UpdateDebugInfoFile"},
    {131, "UpdateDebugInfoFileEx"},
    {0, NULL}};
static Dw32Ordinal imm32[] = {
    {1, "CtfImmAppCompatEnableIMEonProtectedCode"},
    {2, "CtfImmCoUninitialize"},
    {3, "CtfImmDispatchDefImeMessage"},
    {4, "CtfImmEnterCoInitCountSkipMode"},
    {5, "CtfImmGenerateMessage"},
    {6, "CtfImmGetCompatibleKeyboardLayout"},
    {7, "CtfImmGetGuidAtom"},
    {8, "CtfImmGetIMEFileName"},
    {9, "CtfImmGetTMAEFlags"},
    {10, "CtfImmHideToolbarWnd"},
    {11, "CtfImmIsCiceroEnabled"},
    {12, "CtfImmIsCiceroStartedInThread"},
    {13, "CtfImmIsGuidMapEnable"},
    {14, "CtfImmIsTextFrameServiceDisabled"},
    {15, "CtfImmLastEnabledWndDestroy"},
    {16, "CtfImmLeaveCoInitCountSkipMode"},
    {17, "CtfImmNotify"},
    {18, "CtfImmRestoreToolbarWnd"},
    {19, "CtfImmSetAppCompatFlags"},
    {20, "CtfImmSetCiceroStartInThread"},
    {21, "CtfImmSetDefaultRemoteKeyboardLayout"},
    {22, "CtfImmTIMActivate"},
    {23, "GetKeyboardLayoutCP"},
    {24, "ImmActivateLayout"},
    {25, "ImmAssociateContext"},
    {26, "ImmAssociateContextEx"},
    {27, "ImmCallImeConsoleIME"},
    {28, "ImmConfigureIMEA"},
    {29, "ImmConfigureIMEW"},
    {30, "ImmCreateContext"},
    {31, "ImmCreateIMCC"},
    {32, "ImmCreateSoftKeyboard"},
    {33, "ImmDestroyContext"},
    {34, "ImmDestroyIMCC"},
    {35, "ImmDestroySoftKeyboard"},
    {36, "ImmDisableIME"},
    {37, "ImmDisableIme"},
    {38, "ImmDisableTextFrameService"},
    {39, "ImmEnumInputContext"},
    {40, "ImmEnumRegisterWordA"},
    {41, "ImmEnumRegisterWordW"},
    {42, "ImmEscapeA"},
    {43, "ImmEscapeW"},
    {44, "ImmFreeLayout"},
    {45, "ImmGenerateMessage"},
    {46, "ImmGetAppCompatFlags"},
    {47, "ImmGetCandidateListA"},
    {48, "ImmGetCandidateListCountA"},
    {49, "ImmGetCandidateListCountW"},
    {50, "ImmGetCandidateListW"},
    {51, "ImmGetCandidateWindow"},
    {52, "ImmGetCompositionFontA"},
    {53, "ImmGetCompositionFontW"},
    {54, "ImmGetCompositionStringA"},
    {55, "ImmGetCompositionStringW"},
    {56, "ImmGetCompositionWindow"},
    {57, "ImmGetContext"},
    {58, "ImmGetConversionListA"},
    {59, "ImmGetConversionListW"},
    {60, "ImmGetConversionStatus"},
    {61, "ImmGetDefaultIMEWnd"},
    {62, "ImmGetDescriptionA"},
    {63, "ImmGetDescriptionW"},
    {64, "ImmGetGuideLineA"},
    {65, "ImmGetGuideLineW"},
    {66, "ImmGetHotKey"},
    {67, "ImmGetIMCCLockCount"},
    {68, "ImmGetIMCCSize"},
    {69, "ImmGetIMCLockCount"},
    {70, "ImmGetIMEFileNameA"},
    {71, "ImmGetIMEFileNameW"},
    {72, "ImmGetImeInfoEx"},
    {73, "ImmGetImeMenuItemsA"},
    {74, "ImmGetImeMenuItemsW"},
    {75, "ImmGetOpenStatus"},
    {76, "ImmGetProperty"},
    {77, "ImmGetRegisterWordStyleA"},
    {78, "ImmGetRegisterWordStyleW"},
    {79, "ImmGetStatusWindowPos"},
    {80, "ImmGetVirtualKey"},
    {81, "ImmIMPGetIMEA"},
    {82, "ImmIMPGetIMEW"},
    {83, "ImmIMPQueryIMEA"},
    {84, "ImmIMPQueryIMEW"},
    {85, "ImmIMPSetIMEA"},
    {86, "ImmIMPSetIMEW"},
    {87, "ImmInstallIMEA"},
    {88, "ImmInstallIMEW"},
    {89, "ImmIsIME"},
    {90, "ImmIsUIMessageA"},
    {91, "ImmIsUIMessageW"},
    {92, "ImmLoadIME"},
    {93, "ImmLoadLayout"},
    {94, "ImmLockClientImc"},
    {95, "ImmLockIMC"},
    {96, "ImmLockIMCC"},
    {97, "ImmLockImeDpi"},
    {98, "ImmNotifyIME"},
    {99, "ImmProcessKey"},
    {100, "ImmPutImeMenuItemsIntoMappedFile"},
    {101, "ImmReSizeIMCC"},
    {102, "ImmRegisterClient"},
    {103, "ImmRegisterWordA"},
    {104, "ImmRegisterWordW"},
    {105, "ImmReleaseContext"},
    {106, "ImmRequestMessageA"},
    {107, "ImmRequestMessageW"},
    {108, "ImmSendIMEMessageExA"},
    {109, "ImmSendIMEMessageExW"},
    {110, "ImmSetActiveContext"},
    {111, "ImmSetActiveContextConsoleIME"},
    {112, "ImmSetCandidateWindow"},
    {113, "ImmSetCompositionFontA"},
    {114, "ImmSetCompositionFontW"},
    {115, "ImmSetCompositionStringA"},
    {116, "ImmSetCompositionStringW"},
    {117, "ImmSetCompositionWindow"},
    {118, "ImmSetConversionStatus"},
    {119, "ImmSetHotKey"},
    {120, "ImmSetOpenStatus"},
    {121, "ImmSetStatusWindowPos"},
    {122, "ImmShowSoftKeyboard"},
    {123, "ImmSimulateHotKey"},
    {124, "ImmSystemHandler"},
    {125, "ImmTranslateMessage"},
    {126, "ImmUnlockClientImc"},
    {127, "ImmUnlockIMC"},
    {128, "ImmUnlockIMCC"},
    {129, "ImmUnlockImeDpi"},
    {130, "ImmUnregisterWordA"},
    {131, "ImmUnregisterWordW"},
    {132, "ImmWINNLSEnableIME"},
    {133, "ImmWINNLSGetEnableStatus"},
    {134, "ImmWINNLSGetIMEHotkey"},
    {0, NULL}};
static Dw32Ordinal infocardapi[] = {
    {2, "CloseCryptoHandle"},
    {3, "Decrypt"},
    {4, "DllCanUnloadNow"},
    {5, "DllGetClassObject"},
    {6, "DllRegisterServer"},
    {7, "DllUnregisterServer"},
    {8, "Encrypt"},
    {1, "EnsureServiceRunning"},
    {9, "FreeToken"},
    {10, "GenerateDerivedKey"},
    {11, "GetBrowserToken"},
    {12, "GetCryptoTransform"},
    {13, "GetKeyedHash"},
    {14, "GetToken"},
    {15, "HashCore"},
    {16, "HashFinal"},
    {17, "ImportInformationCard"},
    {18, "ManageCardSpace"},
    {19, "SignHash"},
    {20, "TransformBlock"},
    {21, "TransformFinalBlock"},
    {22, "VerifyHash"},
    {0, NULL}};
static Dw32Ordinal intl[] = {
    {3, "bind_textdomain_codeset"},
    {4, "bindtextdomain"},
    {5, "dcgettext"},
    {6, "dcngettext"},
    {7, "dgettext"},
    {8, "dngettext"},
    {9, "gettext"},
    {10, "libintl_bind_textdomain_codeset"},
    {11, "libintl_bindtextdomain"},
    {12, "libintl_dcgettext"},
    {13, "libintl_dcngettext"},
    {14, "libintl_dgettext"},
    {15, "libintl_dngettext"},
    {16, "libintl_fprintf"},
    {17, "libintl_gettext"},
    {18, "libintl_ngettext"},
    {19, "libintl_printf"},
    {20, "libintl_set_relocation_prefix"},
    {21, "libintl_sprintf"},
    {22, "libintl_textdomain"},
    {23, "libintl_version"},
    {24, "libintl_vfprintf"},
    {25, "libintl_vprintf"},
    {26, "libintl_vsprintf"},
    {27, "ngettext"},
    {28, "textdomain"},
    {0, NULL}};
static Dw32Ordinal iphlpapi[] = {
    {1, "AddIPAddress"},
    {2, "AllocateAndGetInterfaceInfoFromStack"},
    {3, "AllocateAndGetIpAddrTableFromStack"},
    {4, "CPNatfwtCreateProviderInstance"},
    {5, "CPNatfwtDeregisterProviderInstance"},
    {6, "CPNatfwtDestroyProviderInstance"},
    {7, "CPNatfwtIndicateReceivedBuffers"},
    {8, "CPNatfwtRegisterProviderInstance"},
    {9, "CancelIPChangeNotify"},
    {10, "CancelMibChangeNotify2"},
    {11, "ConvertGuidToStringA"},
    {12, "ConvertGuidToStringW"},
    {13, "ConvertInterfaceAliasToLuid"},
    {14, "ConvertInterfaceGuidToLuid"},
    {15, "ConvertInterfaceIndexToLuid"},
    {16, "ConvertInterfaceLuidToAlias"},
    {17, "ConvertInterfaceLuidToGuid"},
    {18, "ConvertInterfaceLuidToIndex"},
    {19, "ConvertInterfaceLuidToNameA"},
    {20, "ConvertInterfaceLuidToNameW"},
    {21, "ConvertInterfaceNameToLuidA"},
    {22, "ConvertInterfaceNameToLuidW"},
    {23, "ConvertInterfacePhysicalAddressToLuid"},
    {24, "ConvertIpv4MaskToLength"},
    {25, "ConvertLengthToIpv4Mask"},
    {26, "ConvertRemoteInterfaceAliasToLuid"},
    {27, "ConvertRemoteInterfaceGuidToLuid"},
    {28, "ConvertRemoteInterfaceIndexToLuid"},
    {29, "ConvertRemoteInterfaceLuidToAlias"},
    {30, "ConvertRemoteInterfaceLuidToGuid"},
    {31, "ConvertRemoteInterfaceLuidToIndex"},
    {32, "ConvertStringToGuidA"},
    {33, "ConvertStringToGuidW"},
    {34, "ConvertStringToInterfacePhysicalAddress"},
    {35, "CreateAnycastIpAddressEntry"},
    {37, "CreateIpForwardEntry"},
    {36, "CreateIpForwardEntry2"},
    {39, "CreateIpNetEntry"},
    {38, "CreateIpNetEntry2"},
    {40, "CreatePersistentTcpPortReservation"},
    {41, "CreatePersistentUdpPortReservation"},
    {42, "CreateProxyArpEntry"},
    {43, "CreateSortedAddressPairs"},
    {44, "CreateUnicastIpAddressEntry"},
    {45, "DeleteAnycastIpAddressEntry"},
    {46, "DeleteIPAddress"},
    {48, "DeleteIpForwardEntry"},
    {47, "DeleteIpForwardEntry2"},
    {50, "DeleteIpNetEntry"},
    {49, "DeleteIpNetEntry2"},
    {51, "DeletePersistentTcpPortReservation"},
    {52, "DeletePersistentUdpPortReservation"},
    {53, "DeleteProxyArpEntry"},
    {54, "DeleteUnicastIpAddressEntry"},
    {55, "DisableMediaSense"},
    {56, "EnableRouter"},
    {58, "FlushIpNetTable"},
    {57, "FlushIpNetTable2"},
    {59, "FlushIpPathTable"},
    {60, "FreeMibTable"},
    {61, "GetAdapterIndex"},
    {62, "GetAdapterOrderMap"},
    {63, "GetAdaptersAddresses"},
    {64, "GetAdaptersInfo"},
    {65, "GetAnycastIpAddressEntry"},
    {66, "GetAnycastIpAddressTable"},
    {67, "GetBestInterface"},
    {68, "GetBestInterfaceEx"},
    {70, "GetBestRoute"},
    {69, "GetBestRoute2"},
    {71, "GetCurrentThreadCompartmentId"},
    {72, "GetExtendedTcpTable"},
    {73, "GetExtendedUdpTable"},
    {74, "GetFriendlyIfIndex"},
    {75, "GetIcmpStatistics"},
    {76, "GetIcmpStatisticsEx"},
    {78, "GetIfEntry"},
    {77, "GetIfEntry2"},
    {79, "GetIfStackTable"},
    {82, "GetIfTable"},
    {80, "GetIfTable2"},
    {81, "GetIfTable2Ex"},
    {83, "GetInterfaceInfo"},
    {84, "GetInvertedIfStackTable"},
    {85, "GetIpAddrTable"},
    {86, "GetIpErrorString"},
    {87, "GetIpForwardEntry2"},
    {89, "GetIpForwardTable"},
    {88, "GetIpForwardTable2"},
    {90, "GetIpInterfaceEntry"},
    {91, "GetIpInterfaceTable"},
    {92, "GetIpNetEntry2"},
    {94, "GetIpNetTable"},
    {93, "GetIpNetTable2"},
    {95, "GetIpPathEntry"},
    {96, "GetIpPathTable"},
    {97, "GetIpStatistics"},
    {98, "GetIpStatisticsEx"},
    {99, "GetMulticastIpAddressEntry"},
    {100, "GetMulticastIpAddressTable"},
    {101, "GetNetworkInformation"},
    {102, "GetNetworkParams"},
    {103, "GetNumberOfInterfaces"},
    {104, "GetOwnerModuleFromPidAndInfo"},
    {105, "GetOwnerModuleFromTcp6Entry"},
    {106, "GetOwnerModuleFromTcpEntry"},
    {107, "GetOwnerModuleFromUdp6Entry"},
    {108, "GetOwnerModuleFromUdpEntry"},
    {109, "GetPerAdapterInfo"},
    {110, "GetPerTcp6ConnectionEStats"},
    {111, "GetPerTcp6ConnectionStats"},
    {112, "GetPerTcpConnectionEStats"},
    {113, "GetPerTcpConnectionStats"},
    {114, "GetRTTAndHopCount"},
    {115, "GetSessionCompartmentId"},
    {117, "GetTcp6Table"},
    {116, "GetTcp6Table2"},
    {118, "GetTcpStatistics"},
    {119, "GetTcpStatisticsEx"},
    {121, "GetTcpTable"},
    {120, "GetTcpTable2"},
    {122, "GetTeredoPort"},
    {123, "GetUdp6Table"},
    {124, "GetUdpStatistics"},
    {125, "GetUdpStatisticsEx"},
    {126, "GetUdpTable"},
    {127, "GetUniDirectionalAdapterInfo"},
    {128, "GetUnicastIpAddressEntry"},
    {129, "GetUnicastIpAddressTable"},
    {130, "Icmp6CreateFile"},
    {131, "Icmp6ParseReplies"},
    {132, "Icmp6SendEcho2"},
    {133, "IcmpCloseHandle"},
    {134, "IcmpCreateFile"},
    {135, "IcmpParseReplies"},
    {138, "IcmpSendEcho"},
    {136, "IcmpSendEcho2"},
    {137, "IcmpSendEcho2Ex"},
    {139, "InitializeIpForwardEntry"},
    {140, "InitializeIpInterfaceEntry"},
    {141, "InitializeUnicastIpAddressEntry"},
    {142, "InternalCleanupPersistentStore"},
    {143, "InternalCreateAnycastIpAddressEntry"},
    {145, "InternalCreateIpForwardEntry"},
    {144, "InternalCreateIpForwardEntry2"},
    {147, "InternalCreateIpNetEntry"},
    {146, "InternalCreateIpNetEntry2"},
    {148, "InternalCreateUnicastIpAddressEntry"},
    {149, "InternalDeleteAnycastIpAddressEntry"},
    {151, "InternalDeleteIpForwardEntry"},
    {150, "InternalDeleteIpForwardEntry2"},
    {153, "InternalDeleteIpNetEntry"},
    {152, "InternalDeleteIpNetEntry2"},
    {154, "InternalDeleteUnicastIpAddressEntry"},
    {155, "InternalFindInterfaceByAddress"},
    {156, "InternalGetAnycastIpAddressEntry"},
    {157, "InternalGetAnycastIpAddressTable"},
    {158, "InternalGetForwardIpTable2"},
    {159, "InternalGetIfEntry2"},
    {161, "InternalGetIfTable"},
    {160, "InternalGetIfTable2"},
    {162, "InternalGetIpAddrTable"},
    {163, "InternalGetIpForwardEntry2"},
    {164, "InternalGetIpForwardTable"},
    {165, "InternalGetIpInterfaceEntry"},
    {166, "InternalGetIpInterfaceTable"},
    {167, "InternalGetIpNetEntry2"},
    {169, "InternalGetIpNetTable"},
    {168, "InternalGetIpNetTable2"},
    {170, "InternalGetMulticastIpAddressEntry"},
    {171, "InternalGetMulticastIpAddressTable"},
    {172, "InternalGetTcp6Table2"},
    {173, "InternalGetTcp6TableWithOwnerModule"},
    {174, "InternalGetTcp6TableWithOwnerPid"},
    {176, "InternalGetTcpTable"},
    {175, "InternalGetTcpTable2"},
    {177, "InternalGetTcpTableEx"},
    {178, "InternalGetTcpTableWithOwnerModule"},
    {179, "InternalGetTcpTableWithOwnerPid"},
    {180, "InternalGetTunnelPhysicalAdapter"},
    {181, "InternalGetUdp6TableWithOwnerModule"},
    {182, "InternalGetUdp6TableWithOwnerPid"},
    {183, "InternalGetUdpTable"},
    {184, "InternalGetUdpTableEx"},
    {185, "InternalGetUdpTableWithOwnerModule"},
    {186, "InternalGetUdpTableWithOwnerPid"},
    {187, "InternalGetUnicastIpAddressEntry"},
    {188, "InternalGetUnicastIpAddressTable"},
    {189, "InternalSetIfEntry"},
    {191, "InternalSetIpForwardEntry"},
    {190, "InternalSetIpForwardEntry2"},
    {192, "InternalSetIpInterfaceEntry"},
    {194, "InternalSetIpNetEntry"},
    {193, "InternalSetIpNetEntry2"},
    {195, "InternalSetIpStats"},
    {196, "InternalSetTcpEntry"},
    {197, "InternalSetTeredoPort"},
    {198, "InternalSetUnicastIpAddressEntry"},
    {199, "IpReleaseAddress"},
    {200, "IpRenewAddress"},
    {201, "LookupPersistentTcpPortReservation"},
    {202, "LookupPersistentUdpPortReservation"},
    {203, "NTPTimeToNTFileTime"},
    {204, "NTTimeToNTPTime"},
    {205, "NhGetGuidFromInterfaceName"},
    {206, "NhGetInterfaceDescriptionFromGuid"},
    {207, "NhGetInterfaceNameFromDeviceGuid"},
    {208, "NhGetInterfaceNameFromGuid"},
    {209, "NhpAllocateAndGetInterfaceInfoFromStack"},
    {210, "NotifyAddrChange"},
    {211, "NotifyIpInterfaceChange"},
    {213, "NotifyRouteChange"},
    {212, "NotifyRouteChange2"},
    {214, "NotifyStableUnicastIpAddressTable"},
    {215, "NotifyTeredoPortChange"},
    {216, "NotifyUnicastIpAddressChange"},
    {217, "ParseNetworkString"},
    {234, "ResolveIpNetEntry2"},
    {235, "ResolveNeighbor"},
    {236, "RestoreMediaSense"},
    {237, "SendARP"},
    {238, "SetAdapterIpAddress"},
    {239, "SetCurrentThreadCompartmentId"},
    {240, "SetIfEntry"},
    {242, "SetIpForwardEntry"},
    {241, "SetIpForwardEntry2"},
    {243, "SetIpInterfaceEntry"},
    {245, "SetIpNetEntry"},
    {244, "SetIpNetEntry2"},
    {246, "SetIpStatistics"},
    {247, "SetIpStatisticsEx"},
    {248, "SetIpTTL"},
    {249, "SetNetworkInformation"},
    {250, "SetPerTcp6ConnectionEStats"},
    {251, "SetPerTcp6ConnectionStats"},
    {252, "SetPerTcpConnectionEStats"},
    {253, "SetPerTcpConnectionStats"},
    {254, "SetSessionCompartmentId"},
    {255, "SetTcpEntry"},
    {256, "SetUnicastIpAddressEntry"},
    {257, "UnenableRouter"},
    {218, "_PfAddFiltersToInterface@24"},
    {219, "_PfAddGlobalFilterToInterface@8"},
    {220, "_PfBindInterfaceToIPAddress@12"},
    {221, "_PfBindInterfaceToIndex@16"},
    {222, "_PfCreateInterface@24"},
    {223, "_PfDeleteInterface@4"},
    {224, "_PfDeleteLog@0"},
    {225, "_PfGetInterfaceStatistics@16"},
    {226, "_PfMakeLog@4"},
    {227, "_PfRebindFilters@8"},
    {228, "_PfRemoveFilterHandles@12"},
    {229, "_PfRemoveFiltersFromInterface@20"},
    {230, "_PfRemoveGlobalFilterFromInterface@8"},
    {231, "_PfSetLogBuffer@28"},
    {232, "_PfTestPacket@20"},
    {233, "_PfUnBindInterface@4"},
    {258, "do_echo_rep"},
    {259, "do_echo_req"},
    {260, "if_indextoname"},
    {261, "if_nametoindex"},
    {262, "register_icmp"},
    {0, NULL}};
static Dw32Ordinal iprop[] = {
    {1, "FmtIdToPropStgName"},
    {2, "FreePropVariantArray"},
    {3, "PropStgNameToFmtId"},
    {4, "PropVariantClear"},
    {5, "PropVariantCopy"},
    {6, "StgCreatePropSetStg"},
    {7, "StgCreatePropStg"},
    {8, "StgOpenPropStg"},
    {0, NULL}};
static Dw32Ordinal iscsidsc[] = {
    {1, "AddISNSServerA"},
    {2, "AddISNSServerW"},
    {3, "AddIScsiConnectionA"},
    {4, "AddIScsiConnectionW"},
    {5, "AddIScsiSendTargetPortalA"},
    {6, "AddIScsiSendTargetPortalW"},
    {7, "AddIScsiStaticTargetA"},
    {8, "AddIScsiStaticTargetW"},
    {9, "AddPersistentIScsiDeviceA"},
    {10, "AddPersistentIScsiDeviceW"},
    {11, "AddRadiusServerA"},
    {12, "AddRadiusServerW"},
    {13, "ClearPersistentIScsiDevices"},
    {14, "DllMain"},
    {15, "GetDevicesForIScsiSessionA"},
    {16, "GetDevicesForIScsiSessionW"},
    {17, "GetIScsiIKEInfoA"},
    {18, "GetIScsiIKEInfoW"},
    {19, "GetIScsiInitiatorNodeNameA"},
    {20, "GetIScsiInitiatorNodeNameW"},
    {21, "GetIScsiSessionListA"},
    {22, "GetIScsiSessionListEx"},
    {23, "GetIScsiSessionListW"},
    {24, "GetIScsiTargetInformationA"},
    {25, "GetIScsiTargetInformationW"},
    {26, "GetIScsiVersionInformation"},
    {27, "LoginIScsiTargetA"},
    {28, "LoginIScsiTargetW"},
    {29, "LogoutIScsiTarget"},
    {30, "RefreshISNSServerA"},
    {31, "RefreshISNSServerW"},
    {32, "RefreshIScsiSendTargetPortalA"},
    {33, "RefreshIScsiSendTargetPortalW"},
    {34, "RemoveISNSServerA"},
    {35, "RemoveISNSServerW"},
    {36, "RemoveIScsiConnection"},
    {37, "RemoveIScsiPersistentTargetA"},
    {38, "RemoveIScsiPersistentTargetW"},
    {39, "RemoveIScsiSendTargetPortalA"},
    {40, "RemoveIScsiSendTargetPortalW"},
    {41, "RemoveIScsiStaticTargetA"},
    {42, "RemoveIScsiStaticTargetW"},
    {43, "RemovePersistentIScsiDeviceA"},
    {44, "RemovePersistentIScsiDeviceW"},
    {45, "RemoveRadiusServerA"},
    {46, "RemoveRadiusServerW"},
    {47, "ReportActiveIScsiTargetMappingsA"},
    {48, "ReportActiveIScsiTargetMappingsW"},
    {49, "ReportISNSServerListA"},
    {50, "ReportISNSServerListW"},
    {51, "ReportIScsiInitiatorListA"},
    {52, "ReportIScsiInitiatorListW"},
    {53, "ReportIScsiPersistentLoginsA"},
    {54, "ReportIScsiPersistentLoginsW"},
    {55, "ReportIScsiSendTargetPortalsA"},
    {56, "ReportIScsiSendTargetPortalsExA"},
    {57, "ReportIScsiSendTargetPortalsExW"},
    {58, "ReportIScsiSendTargetPortalsW"},
    {59, "ReportIScsiTargetPortalsA"},
    {60, "ReportIScsiTargetPortalsW"},
    {61, "ReportIScsiTargetsA"},
    {62, "ReportIScsiTargetsW"},
    {63, "ReportPersistentIScsiDevicesA"},
    {64, "ReportPersistentIScsiDevicesW"},
    {65, "ReportRadiusServerListA"},
    {66, "ReportRadiusServerListW"},
    {67, "SendScsiInquiry"},
    {68, "SendScsiReadCapacity"},
    {69, "SendScsiReportLuns"},
    {70, "SetIScsiGroupPresharedKey"},
    {71, "SetIScsiIKEInfoA"},
    {72, "SetIScsiIKEInfoW"},
    {73, "SetIScsiInitiatorCHAPSharedSecret"},
    {74, "SetIScsiInitiatorNodeNameA"},
    {75, "SetIScsiInitiatorNodeNameW"},
    {76, "SetIScsiInitiatorRADIUSSharedSecret"},
    {77, "SetIScsiTunnelModeOuterAddressA"},
    {78, "SetIScsiTunnelModeOuterAddressW"},
    {79, "SetupPersistentIScsiDevices"},
    {80, "SetupPersistentIScsiVolumes"},
    {0, NULL}};
static Dw32Ordinal kernel32[] = {
    {3, "AcquireSRWLockExclusive"},
    {4, "AcquireSRWLockShared"},
    {5, "ActivateActCtx"},
    {6, "AddAtomA"},
    {7, "AddAtomW"},
    {8, "AddConsoleAliasA"},
    {9, "AddConsoleAliasW"},
    {10, "AddIntegrityLabelToBoundaryDescriptor"},
    {11, "AddLocalAlternateComputerNameA"},
    {12, "AddLocalAlternateComputerNameW"},
    {13, "AddRefActCtx"},
    {14, "AddSIDToBoundaryDescriptor"},
    {15, "AddSecureMemoryCacheCallback"},
    {16, "AddVectoredContinueHandler"},
    {17, "AddVectoredExceptionHandler"},
    {18, "AdjustCalendarDate"},
    {19, "AllocConsole"},
    {20, "AllocateUserPhysicalPages"},
    {21, "AllocateUserPhysicalPagesNuma"},
    {22, "ApplicationRecoveryFinished"},
    {23, "ApplicationRecoveryInProgress"},
    {24, "AreFileApisANSI"},
    {25, "AssignProcessToJobObject"},
    {26, "AttachConsole"},
    {27, "BackupRead"},
    {28, "BackupSeek"},
    {29, "BackupWrite"},
    {30, "BaseCheckAppcompatCache"},
    {31, "BaseCheckAppcompatCacheEx"},
    {32, "BaseCheckRunApp"},
    {33, "BaseCleanupAppcompatCacheSupport"},
    {34, "BaseDllReadWriteIniFile"},
    {35, "BaseDumpAppcompatCache"},
    {36, "BaseFlushAppcompatCache"},
    {37, "BaseFormatObjectAttributes"},
    {38, "BaseFormatTimeOut"},
    {39, "BaseGenerateAppCompatData"},
    {40, "BaseGetNamedObjectDirectory"},
    {41, "BaseInitAppcompatCacheSupport"},
    {42, "BaseIsAppcompatInfrastructureDisabled"},
    {43, "BaseQueryModuleData"},
    {44, "BaseSetLastNTError"},
    {1, "BaseThreadInitThunk"},
    {45, "BaseUpdateAppcompatCache"},
    {46, "BaseVerifyUnicodeString"},
    {47, "Basep8BitStringToDynamicUnicodeString"},
    {48, "BasepAllocateActivationContextActivationBlock"},
    {49, "BasepAnsiStringToDynamicUnicodeString"},
    {50, "BasepCheckAppCompat"},
    {51, "BasepCheckBadapp"},
    {52, "BasepCheckWinSaferRestrictions"},
    {53, "BasepFreeActivationContextActivationBlock"},
    {54, "BasepFreeAppCompatData"},
    {55, "BasepMapModuleHandle"},
    {56, "Beep"},
    {57, "BeginUpdateResourceA"},
    {58, "BeginUpdateResourceW"},
    {59, "BindIoCompletionCallback"},
    {60, "BuildCommDCBA"},
    {61, "BuildCommDCBAndTimeoutsA"},
    {62, "BuildCommDCBAndTimeoutsW"},
    {63, "BuildCommDCBW"},
    {64, "CallNamedPipeA"},
    {65, "CallNamedPipeW"},
    {66, "CallbackMayRunLong"},
    {67, "CancelDeviceWakeupRequest"},
    {68, "CancelIo"},
    {69, "CancelIoEx"},
    {70, "CancelSynchronousIo"},
    {71, "CancelThreadpoolIo"},
    {72, "CancelTimerQueueTimer"},
    {73, "CancelWaitableTimer"},
    {74, "ChangeTimerQueueTimer"},
    {75, "CheckElevation"},
    {76, "CheckElevationEnabled"},
    {77, "CheckForReadOnlyResource"},
    {78, "CheckNameLegalDOS8Dot3A"},
    {79, "CheckNameLegalDOS8Dot3W"},
    {80, "CheckRemoteDebuggerPresent"},
    {81, "ClearCommBreak"},
    {82, "ClearCommError"},
    {83, "CloseConsoleHandle"},
    {84, "CloseHandle"},
    {85, "ClosePrivateNamespace"},
    {86, "CloseProfileUserMapping"},
    {87, "CloseThreadpool"},
    {88, "CloseThreadpoolCleanupGroup"},
    {89, "CloseThreadpoolCleanupGroupMembers"},
    {90, "CloseThreadpoolIo"},
    {91, "CloseThreadpoolTimer"},
    {92, "CloseThreadpoolWait"},
    {93, "CloseThreadpoolWork"},
    {94, "CmdBatNotification"},
    {95, "CommConfigDialogA"},
    {96, "CommConfigDialogW"},
    {97, "CompareCalendarDates"},
    {98, "CompareFileTime"},
    {99, "CompareStringA"},
    {100, "CompareStringEx"},
    {101, "CompareStringDw32Ordinal"},
    {102, "CompareStringW"},
    {103, "ConnectNamedPipe"},
    {104, "ConsoleMenuControl"},
    {105, "ContinueDebugEvent"},
    {106, "ConvertCalDateTimeToSystemTime"},
    {107, "ConvertDefaultLocale"},
    {108, "ConvertFiberToThread"},
    {109, "ConvertNLSDayOfWeekToWin32DayOfWeek"},
    {110, "ConvertSystemTimeToCalDateTime"},
    {111, "ConvertThreadToFiber"},
    {112, "ConvertThreadToFiberEx"},
    {113, "CopyExtendedContext"},
    {114, "CopyFileA"},
    {115, "CopyFileExA"},
    {116, "CopyFileExW"},
    {117, "CopyFileTransactedA"},
    {118, "CopyFileTransactedW"},
    {119, "CopyFileW"},
    {120, "CopyLZFile"},
    {121, "CreateActCtxA"},
    {122, "CreateActCtxW"},
    {123, "CreateBoundaryDescriptorA"},
    {124, "CreateBoundaryDescriptorW"},
    {125, "CreateConsoleScreenBuffer"},
    {126, "CreateDirectoryA"},
    {127, "CreateDirectoryExA"},
    {128, "CreateDirectoryExW"},
    {129, "CreateDirectoryTransactedA"},
    {130, "CreateDirectoryTransactedW"},
    {131, "CreateDirectoryW"},
    {132, "CreateEventA"},
    {133, "CreateEventExA"},
    {134, "CreateEventExW"},
    {135, "CreateEventW"},
    {136, "CreateFiber"},
    {137, "CreateFiberEx"},
    {138, "CreateFileA"},
    {139, "CreateFileMappingA"},
    {140, "CreateFileMappingNumaA"},
    {141, "CreateFileMappingNumaW"},
    {142, "CreateFileMappingW"},
    {143, "CreateFileTransactedA"},
    {144, "CreateFileTransactedW"},
    {145, "CreateFileW"},
    {146, "CreateHardLinkA"},
    {147, "CreateHardLinkTransactedA"},
    {148, "CreateHardLinkTransactedW"},
    {149, "CreateHardLinkW"},
    {150, "CreateIoCompletionPort"},
    {151, "CreateJobObjectA"},
    {152, "CreateJobObjectW"},
    {153, "CreateJobSet"},
    {154, "CreateMailslotA"},
    {155, "CreateMailslotW"},
    {156, "CreateMemoryResourceNotification"},
    {157, "CreateMutexA"},
    {158, "CreateMutexExA"},
    {159, "CreateMutexExW"},
    {160, "CreateMutexW"},
    {161, "CreateNamedPipeA"},
    {162, "CreateNamedPipeW"},
    {163, "CreatePipe"},
    {164, "CreatePrivateNamespaceA"},
    {165, "CreatePrivateNamespaceW"},
    {166, "CreateProcessA"},
    {167, "CreateProcessAsUserW"},
    {168, "CreateProcessInternalA"},
    {169, "CreateProcessInternalW"},
    {170, "CreateProcessW"},
    {171, "CreateRemoteThread"},
    {172, "CreateRemoteThreadEx"},
    {173, "CreateSemaphoreA"},
    {174, "CreateSemaphoreExA"},
    {175, "CreateSemaphoreExW"},
    {176, "CreateSemaphoreW"},
    {177, "CreateSocketHandle"},
    {178, "CreateSymbolicLinkA"},
    {179, "CreateSymbolicLinkTransactedA"},
    {180, "CreateSymbolicLinkTransactedW"},
    {181, "CreateSymbolicLinkW"},
    {182, "CreateTapePartition"},
    {183, "CreateThread"},
    {184, "CreateThreadpool"},
    {185, "CreateThreadpoolCleanupGroup"},
    {186, "CreateThreadpoolIo"},
    {187, "CreateThreadpoolTimer"},
    {188, "CreateThreadpoolWait"},
    {189, "CreateThreadpoolWork"},
    {190, "CreateTimerQueue"},
    {191, "CreateTimerQueueTimer"},
    {192, "CreateToolhelp32Snapshot"},
    {193, "CreateWaitableTimerA"},
    {194, "CreateWaitableTimerExA"},
    {195, "CreateWaitableTimerExW"},
    {196, "CreateWaitableTimerW"},
    {197, "CtrlRoutine"},
    {198, "DeactivateActCtx"},
    {199, "DebugActiveProcess"},
    {200, "DebugActiveProcessStop"},
    {201, "DebugBreak"},
    {202, "DebugBreakProcess"},
    {203, "DebugSetProcessKillOnExit"},
    {204, "DecodePointer"},
    {205, "DecodeSystemPointer"},
    {206, "DefineDosDeviceA"},
    {207, "DefineDosDeviceW"},
    {208, "DelayLoadFailureHook"},
    {209, "DeleteAtom"},
    {210, "DeleteBoundaryDescriptor"},
    {211, "DeleteCriticalSection"},
    {212, "DeleteFiber"},
    {213, "DeleteFileA"},
    {214, "DeleteFileTransactedA"},
    {215, "DeleteFileTransactedW"},
    {216, "DeleteFileW"},
    {217, "DeleteProcThreadAttributeList"},
    {218, "DeleteTimerQueue"},
    {219, "DeleteTimerQueueEx"},
    {220, "DeleteTimerQueueTimer"},
    {221, "DeleteVolumeMountPointA"},
    {222, "DeleteVolumeMountPointW"},
    {223, "DeviceIoControl"},
    {224, "DisableThreadLibraryCalls"},
    {225, "DisableThreadProfiling"},
    {226, "DisassociateCurrentThreadFromCallback"},
    {227, "DisconnectNamedPipe"},
    {228, "DnsHostnameToComputerNameA"},
    {229, "DnsHostnameToComputerNameW"},
    {230, "DosDateTimeToFileTime"},
    {231, "DosPathToSessionPathA"},
    {232, "DosPathToSessionPathW"},
    {233, "DuplicateConsoleHandle"},
    {234, "DuplicateHandle"},
    {235, "EnableThreadProfiling"},
    {236, "EncodePointer"},
    {237, "EncodeSystemPointer"},
    {238, "EndUpdateResourceA"},
    {239, "EndUpdateResourceW"},
    {240, "EnterCriticalSection"},
    {241, "EnumCalendarInfoA"},
    {242, "EnumCalendarInfoExA"},
    {243, "EnumCalendarInfoExEx"},
    {244, "EnumCalendarInfoExW"},
    {245, "EnumCalendarInfoW"},
    {246, "EnumDateFormatsA"},
    {247, "EnumDateFormatsExA"},
    {248, "EnumDateFormatsExEx"},
    {249, "EnumDateFormatsExW"},
    {250, "EnumDateFormatsW"},
    {251, "EnumLanguageGroupLocalesA"},
    {252, "EnumLanguageGroupLocalesW"},
    {253, "EnumResourceLanguagesA"},
    {254, "EnumResourceLanguagesExA"},
    {255, "EnumResourceLanguagesExW"},
    {256, "EnumResourceLanguagesW"},
    {257, "EnumResourceNamesA"},
    {258, "EnumResourceNamesExA"},
    {259, "EnumResourceNamesExW"},
    {260, "EnumResourceNamesW"},
    {261, "EnumResourceTypesA"},
    {262, "EnumResourceTypesExA"},
    {263, "EnumResourceTypesExW"},
    {264, "EnumResourceTypesW"},
    {265, "EnumSystemCodePagesA"},
    {266, "EnumSystemCodePagesW"},
    {267, "EnumSystemFirmwareTables"},
    {268, "EnumSystemGeoID"},
    {269, "EnumSystemLanguageGroupsA"},
    {270, "EnumSystemLanguageGroupsW"},
    {271, "EnumSystemLocalesA"},
    {272, "EnumSystemLocalesEx"},
    {273, "EnumSystemLocalesW"},
    {274, "EnumTimeFormatsA"},
    {275, "EnumTimeFormatsEx"},
    {276, "EnumTimeFormatsW"},
    {277, "EnumUILanguagesA"},
    {278, "EnumUILanguagesW"},
    {279, "EnumerateLocalComputerNamesA"},
    {280, "EnumerateLocalComputerNamesW"},
    {281, "EraseTape"},
    {282, "EscapeCommFunction"},
    {283, "ExitProcess"},
    {284, "ExitThread"},
    {285, "ExitVDM"},
    {286, "ExpandEnvironmentStringsA"},
    {287, "ExpandEnvironmentStringsW"},
    {288, "ExpungeConsoleCommandHistoryA"},
    {289, "ExpungeConsoleCommandHistoryW"},
    {290, "FatalAppExitA"},
    {291, "FatalAppExitW"},
    {292, "FatalExit"},
    {293, "FileTimeToDosDateTime"},
    {294, "FileTimeToLocalFileTime"},
    {295, "FileTimeToSystemTime"},
    {296, "FillConsoleOutputAttribute"},
    {297, "FillConsoleOutputCharacterA"},
    {298, "FillConsoleOutputCharacterW"},
    {299, "FindActCtxSectionGuid"},
    {300, "FindActCtxSectionStringA"},
    {301, "FindActCtxSectionStringW"},
    {302, "FindAtomA"},
    {303, "FindAtomW"},
    {304, "FindClose"},
    {305, "FindCloseChangeNotification"},
    {306, "FindFirstChangeNotificationA"},
    {307, "FindFirstChangeNotificationW"},
    {308, "FindFirstFileA"},
    {309, "FindFirstFileExA"},
    {310, "FindFirstFileExW"},
    {311, "FindFirstFileNameTransactedW"},
    {312, "FindFirstFileNameW"},
    {313, "FindFirstFileTransactedA"},
    {314, "FindFirstFileTransactedW"},
    {315, "FindFirstFileW"},
    {316, "FindFirstStreamTransactedW"},
    {317, "FindFirstStreamW"},
    {318, "FindFirstVolumeA"},
    {319, "FindFirstVolumeMountPointA"},
    {320, "FindFirstVolumeMountPointW"},
    {321, "FindFirstVolumeW"},
    {322, "FindNLSString"},
    {323, "FindNLSStringEx"},
    {324, "FindNextChangeNotification"},
    {325, "FindNextFileA"},
    {326, "FindNextFileNameW"},
    {327, "FindNextFileW"},
    {328, "FindNextStreamW"},
    {329, "FindNextVolumeA"},
    {330, "FindNextVolumeMountPointA"},
    {331, "FindNextVolumeMountPointW"},
    {332, "FindNextVolumeW"},
    {333, "FindResourceA"},
    {334, "FindResourceExA"},
    {335, "FindResourceExW"},
    {336, "FindResourceW"},
    {337, "FindStringDw32Ordinal"},
    {338, "FindVolumeClose"},
    {339, "FindVolumeMountPointClose"},
    {340, "FlsAlloc"},
    {341, "FlsFree"},
    {342, "FlsGetValue"},
    {343, "FlsSetValue"},
    {344, "FlushConsoleInputBuffer"},
    {345, "FlushFileBuffers"},
    {346, "FlushInstructionCache"},
    {347, "FlushProcessWriteBuffers"},
    {348, "FlushViewOfFile"},
    {349, "FoldStringA"},
    {350, "FoldStringW"},
    {351, "FormatMessageA"},
    {352, "FormatMessageW"},
    {353, "FreeConsole"},
    {354, "FreeEnvironmentStringsA"},
    {355, "FreeEnvironmentStringsW"},
    {356, "FreeLibrary"},
    {357, "FreeLibraryAndExitThread"},
    {358, "FreeLibraryWhenCallbackReturns"},
    {359, "FreeResource"},
    {360, "FreeUserPhysicalPages"},
    {361, "GenerateConsoleCtrlEvent"},
    {362, "GetACP"},
    {363, "GetActiveProcessorCount"},
    {364, "GetActiveProcessorGroupCount"},
    {365, "GetApplicationRecoveryCallback"},
    {366, "GetApplicationRestartSettings"},
    {367, "GetAtomNameA"},
    {368, "GetAtomNameW"},
    {369, "GetBinaryType"},
    {370, "GetBinaryTypeA"},
    {371, "GetBinaryTypeW"},
    {372, "GetCPInfo"},
    {373, "GetCPInfoExA"},
    {374, "GetCPInfoExW"},
    {375, "GetCalendarDateFormat"},
    {376, "GetCalendarDateFormatEx"},
    {377, "GetCalendarDaysInMonth"},
    {378, "GetCalendarDifferenceInDays"},
    {379, "GetCalendarInfoA"},
    {380, "GetCalendarInfoEx"},
    {381, "GetCalendarInfoW"},
    {382, "GetCalendarMonthsInYear"},
    {383, "GetCalendarSupportedDateRange"},
    {384, "GetCalendarWeekNumber"},
    {385, "GetComPlusPackageInstallStatus"},
    {386, "GetCommConfig"},
    {387, "GetCommMask"},
    {388, "GetCommModemStatus"},
    {389, "GetCommProperties"},
    {390, "GetCommState"},
    {391, "GetCommTimeouts"},
    {392, "GetCommandLineA"},
    {393, "GetCommandLineW"},
    {394, "GetCompressedFileSizeA"},
    {395, "GetCompressedFileSizeTransactedA"},
    {396, "GetCompressedFileSizeTransactedW"},
    {397, "GetCompressedFileSizeW"},
    {398, "GetComputerNameA"},
    {399, "GetComputerNameExA"},
    {400, "GetComputerNameExW"},
    {401, "GetComputerNameW"},
    {402, "GetConsoleAliasA"},
    {403, "GetConsoleAliasExesA"},
    {404, "GetConsoleAliasExesLengthA"},
    {405, "GetConsoleAliasExesLengthW"},
    {406, "GetConsoleAliasExesW"},
    {407, "GetConsoleAliasW"},
    {408, "GetConsoleAliasesA"},
    {409, "GetConsoleAliasesLengthA"},
    {410, "GetConsoleAliasesLengthW"},
    {411, "GetConsoleAliasesW"},
    {412, "GetConsoleCP"},
    {413, "GetConsoleCharType"},
    {414, "GetConsoleCommandHistoryA"},
    {415, "GetConsoleCommandHistoryLengthA"},
    {416, "GetConsoleCommandHistoryLengthW"},
    {417, "GetConsoleCommandHistoryW"},
    {418, "GetConsoleCursorInfo"},
    {419, "GetConsoleCursorMode"},
    {420, "GetConsoleDisplayMode"},
    {421, "GetConsoleFontInfo"},
    {422, "GetConsoleFontSize"},
    {423, "GetConsoleHardwareState"},
    {424, "GetConsoleHistoryInfo"},
    {425, "GetConsoleInputExeNameA"},
    {426, "GetConsoleInputExeNameW"},
    {427, "GetConsoleInputWaitHandle"},
    {428, "GetConsoleKeyboardLayoutNameA"},
    {429, "GetConsoleKeyboardLayoutNameW"},
    {430, "GetConsoleMode"},
    {431, "GetConsoleNlsMode"},
    {432, "GetConsoleOriginalTitleA"},
    {433, "GetConsoleOriginalTitleW"},
    {434, "GetConsoleOutputCP"},
    {435, "GetConsoleProcessList"},
    {436, "GetConsoleScreenBufferInfo"},
    {437, "GetConsoleScreenBufferInfoEx"},
    {438, "GetConsoleSelectionInfo"},
    {439, "GetConsoleTitleA"},
    {440, "GetConsoleTitleW"},
    {441, "GetConsoleWindow"},
    {442, "GetCurrencyFormatA"},
    {443, "GetCurrencyFormatEx"},
    {444, "GetCurrencyFormatW"},
    {445, "GetCurrentActCtx"},
    {446, "GetCurrentConsoleFont"},
    {447, "GetCurrentConsoleFontEx"},
    {448, "GetCurrentDirectoryA"},
    {449, "GetCurrentDirectoryW"},
    {450, "GetCurrentProcess"},
    {451, "GetCurrentProcessId"},
    {452, "GetCurrentProcessorNumber"},
    {453, "GetCurrentProcessorNumberEx"},
    {454, "GetCurrentThread"},
    {455, "GetCurrentThreadId"},
    {456, "GetDateFormatA"},
    {457, "GetDateFormatEx"},
    {458, "GetDateFormatW"},
    {459, "GetDefaultCommConfigA"},
    {460, "GetDefaultCommConfigW"},
    {461, "GetDevicePowerState"},
    {462, "GetDiskFreeSpaceA"},
    {463, "GetDiskFreeSpaceExA"},
    {464, "GetDiskFreeSpaceExW"},
    {465, "GetDiskFreeSpaceW"},
    {466, "GetDllDirectoryA"},
    {467, "GetDllDirectoryW"},
    {468, "GetDriveTypeA"},
    {469, "GetDriveTypeW"},
    {470, "GetDurationFormat"},
    {471, "GetDurationFormatEx"},
    {472, "GetDynamicTimeZoneInformation"},
    {473, "GetEnabledExtendedFeatures"},
    {474, "GetEnvironmentStrings"},
    {475, "GetEnvironmentStringsA"},
    {476, "GetEnvironmentStringsW"},
    {477, "GetEnvironmentVariableA"},
    {478, "GetEnvironmentVariableW"},
    {479, "GetEraNameCountedString"},
    {480, "GetErrorMode"},
    {481, "GetExitCodeProcess"},
    {482, "GetExitCodeThread"},
    {483, "GetExpandedNameA"},
    {484, "GetExpandedNameW"},
    {485, "GetExtendedContextLength"},
    {486, "GetExtendedFeaturesMask"},
    {487, "GetFileAttributesA"},
    {488, "GetFileAttributesExA"},
    {489, "GetFileAttributesExW"},
    {490, "GetFileAttributesTransactedA"},
    {491, "GetFileAttributesTransactedW"},
    {492, "GetFileAttributesW"},
    {493, "GetFileBandwidthReservation"},
    {494, "GetFileInformationByHandle"},
    {495, "GetFileInformationByHandleEx"},
    {496, "GetFileMUIInfo"},
    {497, "GetFileMUIPath"},
    {498, "GetFileSize"},
    {499, "GetFileSizeEx"},
    {500, "GetFileTime"},
    {501, "GetFileType"},
    {502, "GetFinalPathNameByHandleA"},
    {503, "GetFinalPathNameByHandleW"},
    {504, "GetFirmwareEnvironmentVariableA"},
    {505, "GetFirmwareEnvironmentVariableW"},
    {506, "GetFullPathNameA"},
    {507, "GetFullPathNameTransactedA"},
    {508, "GetFullPathNameTransactedW"},
    {509, "GetFullPathNameW"},
    {510, "GetGeoInfoA"},
    {511, "GetGeoInfoW"},
    {512, "GetHandleContext"},
    {513, "GetHandleInformation"},
    {514, "GetLargePageMinimum"},
    {515, "GetLargestConsoleWindowSize"},
    {516, "GetLastError"},
    {517, "GetLocalTime"},
    {518, "GetLocaleInfoA"},
    {519, "GetLocaleInfoEx"},
    {520, "GetLocaleInfoW"},
    {521, "GetLogicalDriveStringsA"},
    {522, "GetLogicalDriveStringsW"},
    {523, "GetLogicalDrives"},
    {524, "GetLogicalProcessorInformation"},
    {525, "GetLogicalProcessorInformationEx"},
    {526, "GetLongPathNameA"},
    {527, "GetLongPathNameTransactedA"},
    {528, "GetLongPathNameTransactedW"},
    {529, "GetLongPathNameW"},
    {530, "GetMailslotInfo"},
    {531, "GetMaximumProcessorCount"},
    {532, "GetMaximumProcessorGroupCount"},
    {533, "GetModuleFileNameA"},
    {534, "GetModuleFileNameW"},
    {535, "GetModuleHandleA"},
    {536, "GetModuleHandleExA"},
    {537, "GetModuleHandleExW"},
    {538, "GetModuleHandleW"},
    {539, "GetNLSVersion"},
    {540, "GetNLSVersionEx"},
    {541, "GetNamedPipeAttribute"},
    {542, "GetNamedPipeClientComputerNameA"},
    {543, "GetNamedPipeClientComputerNameW"},
    {544, "GetNamedPipeClientProcessId"},
    {545, "GetNamedPipeClientSessionId"},
    {546, "GetNamedPipeHandleStateA"},
    {547, "GetNamedPipeHandleStateW"},
    {548, "GetNamedPipeInfo"},
    {549, "GetNamedPipeServerProcessId"},
    {550, "GetNamedPipeServerSessionId"},
    {551, "GetNativeSystemInfo"},
    {552, "GetNextVDMCommand"},
    {553, "GetNumaAvailableMemoryNode"},
    {554, "GetNumaAvailableMemoryNodeEx"},
    {555, "GetNumaHighestNodeNumber"},
    {556, "GetNumaNodeNumberFromHandle"},
    {557, "GetNumaNodeProcessorMask"},
    {558, "GetNumaNodeProcessorMaskEx"},
    {559, "GetNumaProcessorNode"},
    {560, "GetNumaProcessorNodeEx"},
    {561, "GetNumaProximityNode"},
    {562, "GetNumaProximityNodeEx"},
    {563, "GetNumberFormatA"},
    {564, "GetNumberFormatEx"},
    {565, "GetNumberFormatW"},
    {566, "GetNumberOfConsoleFonts"},
    {567, "GetNumberOfConsoleInputEvents"},
    {568, "GetNumberOfConsoleMouseButtons"},
    {569, "GetOEMCP"},
    {570, "GetOverlappedResult"},
    {571, "GetPhysicallyInstalledSystemMemory"},
    {572, "GetPriorityClass"},
    {573, "GetPrivateProfileIntA"},
    {574, "GetPrivateProfileIntW"},
    {575, "GetPrivateProfileSectionA"},
    {576, "GetPrivateProfileSectionNamesA"},
    {577, "GetPrivateProfileSectionNamesW"},
    {578, "GetPrivateProfileSectionW"},
    {579, "GetPrivateProfileStringA"},
    {580, "GetPrivateProfileStringW"},
    {581, "GetPrivateProfileStructA"},
    {582, "GetPrivateProfileStructW"},
    {583, "GetProcAddress"},
    {584, "GetProcessAffinityMask"},
    {585, "GetProcessDEPPolicy"},
    {586, "GetProcessGroupAffinity"},
    {587, "GetProcessHandleCount"},
    {588, "GetProcessHeap"},
    {589, "GetProcessHeaps"},
    {590, "GetProcessId"},
    {591, "GetProcessIdOfThread"},
    {592, "GetProcessIoCounters"},
    {593, "GetProcessPreferredUILanguages"},
    {594, "GetProcessPriorityBoost"},
    {595, "GetProcessShutdownParameters"},
    {596, "GetProcessTimes"},
    {597, "GetProcessVersion"},
    {598, "GetProcessWorkingSetSize"},
    {599, "GetProcessWorkingSetSizeEx"},
    {600, "GetProcessorSystemCycleTime"},
    {601, "GetProductInfo"},
    {602, "GetProfileIntA"},
    {603, "GetProfileIntW"},
    {604, "GetProfileSectionA"},
    {605, "GetProfileSectionW"},
    {606, "GetProfileStringA"},
    {607, "GetProfileStringW"},
    {608, "GetQueuedCompletionStatus"},
    {609, "GetQueuedCompletionStatusEx"},
    {610, "GetShortPathNameA"},
    {611, "GetShortPathNameW"},
    {612, "GetStartupInfoA"},
    {613, "GetStartupInfoW"},
    {614, "GetStdHandle"},
    {615, "GetStringScripts"},
    {616, "GetStringTypeA"},
    {617, "GetStringTypeExA"},
    {618, "GetStringTypeExW"},
    {619, "GetStringTypeW"},
    {620, "GetSystemDEPPolicy"},
    {621, "GetSystemDefaultLCID"},
    {622, "GetSystemDefaultLangID"},
    {623, "GetSystemDefaultLocaleName"},
    {624, "GetSystemDefaultUILanguage"},
    {625, "GetSystemDirectoryA"},
    {626, "GetSystemDirectoryW"},
    {627, "GetSystemFileCacheSize"},
    {628, "GetSystemFirmwareTable"},
    {629, "GetSystemInfo"},
    {630, "GetSystemPowerStatus"},
    {631, "GetSystemPreferredUILanguages"},
    {632, "GetSystemRegistryQuota"},
    {633, "GetSystemTime"},
    {634, "GetSystemTimeAdjustment"},
    {635, "GetSystemTimeAsFileTime"},
    {636, "GetSystemTimes"},
    {637, "GetSystemWindowsDirectoryA"},
    {638, "GetSystemWindowsDirectoryW"},
    {639, "GetSystemWow64DirectoryA"},
    {640, "GetSystemWow64DirectoryW"},
    {641, "GetTapeParameters"},
    {642, "GetTapePosition"},
    {643, "GetTapeStatus"},
    {644, "GetTempFileNameA"},
    {645, "GetTempFileNameW"},
    {646, "GetTempPathA"},
    {647, "GetTempPathW"},
    {648, "GetThreadContext"},
    {649, "GetThreadErrorMode"},
    {650, "GetThreadGroupAffinity"},
    {651, "GetThreadIOPendingFlag"},
    {652, "GetThreadId"},
    {653, "GetThreadIdealProcessorEx"},
    {654, "GetThreadLocale"},
    {655, "GetThreadPreferredUILanguages"},
    {656, "GetThreadPriority"},
    {657, "GetThreadPriorityBoost"},
    {658, "GetThreadSelectorEntry"},
    {659, "GetThreadTimes"},
    {660, "GetThreadUILanguage"},
    {662, "GetTickCount"},
    {661, "GetTickCount64"},
    {663, "GetTimeFormatA"},
    {664, "GetTimeFormatEx"},
    {665, "GetTimeFormatW"},
    {666, "GetTimeZoneInformation"},
    {667, "GetTimeZoneInformationForYear"},
    {668, "GetUILanguageInfo"},
    {669, "GetUserDefaultLCID"},
    {670, "GetUserDefaultLangID"},
    {671, "GetUserDefaultLocaleName"},
    {672, "GetUserDefaultUILanguage"},
    {673, "GetUserGeoID"},
    {674, "GetUserPreferredUILanguages"},
    {675, "GetVDMCurrentDirectories"},
    {676, "GetVersion"},
    {677, "GetVersionExA"},
    {678, "GetVersionExW"},
    {679, "GetVolumeInformationA"},
    {680, "GetVolumeInformationByHandleW"},
    {681, "GetVolumeInformationW"},
    {682, "GetVolumeNameForVolumeMountPointA"},
    {683, "GetVolumeNameForVolumeMountPointW"},
    {684, "GetVolumePathNameA"},
    {685, "GetVolumePathNameW"},
    {686, "GetVolumePathNamesForVolumeNameA"},
    {687, "GetVolumePathNamesForVolumeNameW"},
    {688, "GetWindowsDirectoryA"},
    {689, "GetWindowsDirectoryW"},
    {690, "GetWriteWatch"},
    {691, "GlobalAddAtomA"},
    {692, "GlobalAddAtomW"},
    {693, "GlobalAlloc"},
    {694, "GlobalCompact"},
    {695, "GlobalDeleteAtom"},
    {696, "GlobalFindAtomA"},
    {697, "GlobalFindAtomW"},
    {698, "GlobalFix"},
    {699, "GlobalFlags"},
    {700, "GlobalFree"},
    {701, "GlobalGetAtomNameA"},
    {702, "GlobalGetAtomNameW"},
    {703, "GlobalHandle"},
    {704, "GlobalLock"},
    {705, "GlobalMemoryStatus"},
    {706, "GlobalMemoryStatusEx"},
    {707, "GlobalReAlloc"},
    {708, "GlobalSize"},
    {709, "GlobalUnWire"},
    {710, "GlobalUnfix"},
    {711, "GlobalUnlock"},
    {712, "GlobalWire"},
    {713, "Heap32First"},
    {714, "Heap32ListFirst"},
    {715, "Heap32ListNext"},
    {716, "Heap32Next"},
    {717, "HeapAlloc"},
    {718, "HeapCompact"},
    {719, "HeapCreate"},
    {720, "HeapDestroy"},
    {721, "HeapFree"},
    {722, "HeapLock"},
    {723, "HeapQueryInformation"},
    {724, "HeapReAlloc"},
    {725, "HeapSetInformation"},
    {726, "HeapSize"},
    {727, "HeapSummary"},
    {728, "HeapUnlock"},
    {729, "HeapValidate"},
    {730, "HeapWalk"},
    {731, "IdnToAscii"},
    {732, "IdnToNameprepUnicode"},
    {733, "IdnToUnicode"},
    {734, "InitAtomTable"},
    {735, "InitOnceBeginInitialize"},
    {736, "InitOnceComplete"},
    {737, "InitOnceExecuteOnce"},
    {738, "InitOnceInitialize"},
    {739, "InitializeConditionVariable"},
    {740, "InitializeCriticalSection"},
    {741, "InitializeCriticalSectionAndSpinCount"},
    {742, "InitializeCriticalSectionEx"},
    {743, "InitializeExtendedContext"},
    {744, "InitializeProcThreadAttributeList"},
    {745, "InitializeSListHead"},
    {746, "InitializeSRWLock"},
    {748, "InterlockedCompareExchange"},
    {747, "InterlockedCompareExchange64"},
    {749, "InterlockedDecrement"},
    {750, "InterlockedExchange"},
    {751, "InterlockedExchangeAdd"},
    {752, "InterlockedFlushSList"},
    {753, "InterlockedIncrement"},
    {754, "InterlockedPopEntrySList"},
    {755, "InterlockedPushEntrySList"},
    {2, "InterlockedPushListSList"},
    {756, "InvalidateConsoleDIBits"},
    {757, "IsBadCodePtr"},
    {758, "IsBadHugeReadPtr"},
    {759, "IsBadHugeWritePtr"},
    {760, "IsBadReadPtr"},
    {761, "IsBadStringPtrA"},
    {762, "IsBadStringPtrW"},
    {763, "IsBadWritePtr"},
    {764, "IsCalendarLeapDay"},
    {765, "IsCalendarLeapMonth"},
    {766, "IsCalendarLeapYear"},
    {767, "IsDBCSLeadByte"},
    {768, "IsDBCSLeadByteEx"},
    {769, "IsDebuggerPresent"},
    {770, "IsNLSDefinedString"},
    {771, "IsNormalizedString"},
    {772, "IsProcessInJob"},
    {773, "IsProcessorFeaturePresent"},
    {774, "IsSystemResumeAutomatic"},
    {775, "IsThreadAFiber"},
    {776, "IsThreadpoolTimerSet"},
    {777, "IsTimeZoneRedirectionEnabled"},
    {778, "IsValidCalDateTime"},
    {779, "IsValidCodePage"},
    {780, "IsValidLanguageGroup"},
    {781, "IsValidLocale"},
    {782, "IsValidLocaleName"},
    {783, "IsWow64Process"},
    {784, "K32EmptyWorkingSet"},
    {785, "K32EnumDeviceDrivers"},
    {786, "K32EnumPageFilesA"},
    {787, "K32EnumPageFilesW"},
    {788, "K32EnumProcessModules"},
    {789, "K32EnumProcessModulesEx"},
    {790, "K32EnumProcesses"},
    {791, "K32GetDeviceDriverBaseNameA"},
    {792, "K32GetDeviceDriverBaseNameW"},
    {793, "K32GetDeviceDriverFileNameA"},
    {794, "K32GetDeviceDriverFileNameW"},
    {795, "K32GetMappedFileNameA"},
    {796, "K32GetMappedFileNameW"},
    {797, "K32GetModuleBaseNameA"},
    {798, "K32GetModuleBaseNameW"},
    {799, "K32GetModuleFileNameExA"},
    {800, "K32GetModuleFileNameExW"},
    {801, "K32GetModuleInformation"},
    {802, "K32GetPerformanceInfo"},
    {803, "K32GetProcessImageFileNameA"},
    {804, "K32GetProcessImageFileNameW"},
    {805, "K32GetProcessMemoryInfo"},
    {806, "K32GetWsChanges"},
    {807, "K32GetWsChangesEx"},
    {808, "K32InitializeProcessForWsWatch"},
    {809, "K32QueryWorkingSet"},
    {810, "K32QueryWorkingSetEx"},
    {811, "LCIDToLocaleName"},
    {812, "LCMapStringA"},
    {813, "LCMapStringEx"},
    {814, "LCMapStringW"},
    {815, "LZClose"},
    {816, "LZCloseFile"},
    {817, "LZCopy"},
    {818, "LZCreateFileW"},
    {819, "LZDone"},
    {820, "LZInit"},
    {821, "LZOpenFileA"},
    {822, "LZOpenFileW"},
    {823, "LZRead"},
    {824, "LZSeek"},
    {825, "LZStart"},
    {826, "LeaveCriticalSection"},
    {827, "LeaveCriticalSectionWhenCallbackReturns"},
    {828, "LoadAppInitDlls"},
    {829, "LoadLibraryA"},
    {830, "LoadLibraryExA"},
    {831, "LoadLibraryExW"},
    {832, "LoadLibraryW"},
    {833, "LoadModule"},
    {834, "LoadResource"},
    {835, "LoadStringBaseExW"},
    {836, "LoadStringBaseW"},
    {837, "LocalAlloc"},
    {838, "LocalCompact"},
    {839, "LocalFileTimeToFileTime"},
    {840, "LocalFlags"},
    {841, "LocalFree"},
    {842, "LocalHandle"},
    {843, "LocalLock"},
    {844, "LocalReAlloc"},
    {845, "LocalShrink"},
    {846, "LocalSize"},
    {847, "LocalUnlock"},
    {848, "LocaleNameToLCID"},
    {849, "LocateExtendedFeature"},
    {850, "LocateLegacyContext"},
    {851, "LockFile"},
    {852, "LockFileEx"},
    {853, "LockResource"},
    {854, "MapUserPhysicalPages"},
    {855, "MapUserPhysicalPagesScatter"},
    {856, "MapViewOfFile"},
    {857, "MapViewOfFileEx"},
    {858, "MapViewOfFileExNuma"},
    {859, "Module32First"},
    {860, "Module32FirstW"},
    {861, "Module32Next"},
    {862, "Module32NextW"},
    {863, "MoveFileA"},
    {864, "MoveFileExA"},
    {865, "MoveFileExW"},
    {866, "MoveFileTransactedA"},
    {867, "MoveFileTransactedW"},
    {868, "MoveFileW"},
    {869, "MoveFileWithProgressA"},
    {870, "MoveFileWithProgressW"},
    {871, "MulDiv"},
    {872, "MultiByteToWideChar"},
    {873, "NeedCurrentDirectoryForExePathA"},
    {874, "NeedCurrentDirectoryForExePathW"},
    {875, "NlsCheckPolicy"},
    {876, "NlsEventDataDescCreate"},
    {877, "NlsGetCacheUpdateCount"},
    {878, "NlsUpdateLocale"},
    {879, "NlsUpdateSystemLocale"},
    {880, "NlsWriteEtwEvent"},
    {881, "NormalizeString"},
    {882, "NotifyMountMgr"},
    {883, "NotifyUILanguageChange"},
    {884, "OpenConsoleW"},
    {885, "OpenEventA"},
    {886, "OpenEventW"},
    {887, "OpenFile"},
    {888, "OpenFileById"},
    {889, "OpenFileMappingA"},
    {890, "OpenFileMappingW"},
    {891, "OpenJobObjectA"},
    {892, "OpenJobObjectW"},
    {893, "OpenMutexA"},
    {894, "OpenMutexW"},
    {895, "OpenPrivateNamespaceA"},
    {896, "OpenPrivateNamespaceW"},
    {897, "OpenProcess"},
    {898, "OpenProcessToken"},
    {899, "OpenProfileUserMapping"},
    {900, "OpenSemaphoreA"},
    {901, "OpenSemaphoreW"},
    {902, "OpenThread"},
    {903, "OpenThreadToken"},
    {904, "OpenWaitableTimerA"},
    {905, "OpenWaitableTimerW"},
    {906, "OutputDebugStringA"},
    {907, "OutputDebugStringW"},
    {908, "PeekConsoleInputA"},
    {909, "PeekConsoleInputW"},
    {910, "PeekNamedPipe"},
    {911, "PostQueuedCompletionStatus"},
    {912, "PowerClearRequest"},
    {913, "PowerCreateRequest"},
    {914, "PowerSetRequest"},
    {915, "PrepareTape"},
    {916, "PrivCopyFileExW"},
    {917, "PrivMoveFileIdentityW"},
    {918, "Process32First"},
    {919, "Process32FirstW"},
    {920, "Process32Next"},
    {921, "Process32NextW"},
    {922, "ProcessIdToSessionId"},
    {923, "PulseEvent"},
    {924, "PurgeComm"},
    {925, "QueryActCtxSettingsW"},
    {926, "QueryActCtxW"},
    {927, "QueryDepthSList"},
    {928, "QueryDosDeviceA"},
    {929, "QueryDosDeviceW"},
    {930, "QueryFullProcessImageNameA"},
    {931, "QueryFullProcessImageNameW"},
    {932, "QueryIdleProcessorCycleTime"},
    {933, "QueryIdleProcessorCycleTimeEx"},
    {934, "QueryInformationJobObject"},
    {935, "QueryMemoryResourceNotification"},
    {936, "QueryPerformanceCounter"},
    {937, "QueryPerformanceFrequency"},
    {938, "QueryProcessAffinityUpdateMode"},
    {939, "QueryProcessCycleTime"},
    {940, "QueryThreadCycleTime"},
    {941, "QueryThreadProfiling"},
    {942, "QueryThreadpoolStackInformation"},
    {943, "QueryUnbiasedInterruptTime"},
    {944, "QueueUserAPC"},
    {945, "QueueUserWorkItem"},
    {946, "RaiseException"},
    {947, "RaiseFailFastException"},
    {948, "ReOpenFile"},
    {949, "ReadConsoleA"},
    {950, "ReadConsoleInputA"},
    {951, "ReadConsoleInputExA"},
    {952, "ReadConsoleInputExW"},
    {953, "ReadConsoleInputW"},
    {954, "ReadConsoleOutputA"},
    {955, "ReadConsoleOutputAttribute"},
    {956, "ReadConsoleOutputCharacterA"},
    {957, "ReadConsoleOutputCharacterW"},
    {958, "ReadConsoleOutputW"},
    {959, "ReadConsoleW"},
    {960, "ReadDirectoryChangesW"},
    {961, "ReadFile"},
    {962, "ReadFileEx"},
    {963, "ReadFileScatter"},
    {964, "ReadProcessMemory"},
    {965, "ReadThreadProfilingData"},
    {966, "RegCloseKey"},
    {967, "RegCreateKeyExA"},
    {968, "RegCreateKeyExW"},
    {969, "RegDeleteKeyExA"},
    {970, "RegDeleteKeyExW"},
    {971, "RegDeleteTreeA"},
    {972, "RegDeleteTreeW"},
    {973, "RegDeleteValueA"},
    {974, "RegDeleteValueW"},
    {975, "RegDisablePredefinedCacheEx"},
    {976, "RegEnumKeyExA"},
    {977, "RegEnumKeyExW"},
    {978, "RegEnumValueA"},
    {979, "RegEnumValueW"},
    {980, "RegFlushKey"},
    {981, "RegGetKeySecurity"},
    {982, "RegGetValueA"},
    {983, "RegGetValueW"},
    {984, "RegKrnGetGlobalState"},
    {985, "RegKrnInitialize"},
    {986, "RegLoadKeyA"},
    {987, "RegLoadKeyW"},
    {988, "RegLoadMUIStringA"},
    {989, "RegLoadMUIStringW"},
    {990, "RegNotifyChangeKeyValue"},
    {991, "RegOpenCurrentUser"},
    {992, "RegOpenKeyExA"},
    {993, "RegOpenKeyExW"},
    {994, "RegOpenUserClassesRoot"},
    {995, "RegQueryInfoKeyA"},
    {996, "RegQueryInfoKeyW"},
    {997, "RegQueryValueExA"},
    {998, "RegQueryValueExW"},
    {999, "RegRestoreKeyA"},
    {1000, "RegRestoreKeyW"},
    {1001, "RegSaveKeyExA"},
    {1002, "RegSaveKeyExW"},
    {1003, "RegSetKeySecurity"},
    {1004, "RegSetValueExA"},
    {1005, "RegSetValueExW"},
    {1006, "RegUnLoadKeyA"},
    {1007, "RegUnLoadKeyW"},
    {1008, "RegisterApplicationRecoveryCallback"},
    {1009, "RegisterApplicationRestart"},
    {1010, "RegisterConsoleIME"},
    {1011, "RegisterConsoleOS2"},
    {1012, "RegisterConsoleVDM"},
    {1013, "RegisterWaitForInputIdle"},
    {1014, "RegisterWaitForSingleObject"},
    {1015, "RegisterWaitForSingleObjectEx"},
    {1016, "RegisterWowBaseHandlers"},
    {1017, "RegisterWowExec"},
    {1018, "ReleaseActCtx"},
    {1019, "ReleaseMutex"},
    {1020, "ReleaseMutexWhenCallbackReturns"},
    {1021, "ReleaseSRWLockExclusive"},
    {1022, "ReleaseSRWLockShared"},
    {1023, "ReleaseSemaphore"},
    {1024, "ReleaseSemaphoreWhenCallbackReturns"},
    {1025, "RemoveDirectoryA"},
    {1026, "RemoveDirectoryTransactedA"},
    {1027, "RemoveDirectoryTransactedW"},
    {1028, "RemoveDirectoryW"},
    {1029, "RemoveLocalAlternateComputerNameA"},
    {1030, "RemoveLocalAlternateComputerNameW"},
    {1031, "RemoveSecureMemoryCacheCallback"},
    {1032, "RemoveVectoredContinueHandler"},
    {1033, "RemoveVectoredExceptionHandler"},
    {1034, "ReplaceFile"},
    {1035, "ReplaceFileA"},
    {1036, "ReplaceFileW"},
    {1037, "ReplacePartitionUnit"},
    {1038, "RequestDeviceWakeup"},
    {1039, "RequestWakeupLatency"},
    {1040, "ResetEvent"},
    {1041, "ResetWriteWatch"},
    {1042, "ResolveLocaleName"},
    {1043, "RestoreLastError"},
    {1044, "ResumeThread"},
    {1045, "RtlCaptureContext"},
    {1046, "RtlCaptureStackBackTrace"},
    {1047, "RtlFillMemory"},
    {1048, "RtlMoveMemory"},
    {1049, "RtlUnwind"},
    {1050, "RtlZeroMemory"},
    {1051, "ScrollConsoleScreenBufferA"},
    {1052, "ScrollConsoleScreenBufferW"},
    {1053, "SearchPathA"},
    {1054, "SearchPathW"},
    {1055, "SetCalendarInfoA"},
    {1056, "SetCalendarInfoW"},
    {1057, "SetClientTimeZoneInformation"},
    {1058, "SetComPlusPackageInstallStatus"},
    {1059, "SetCommBreak"},
    {1060, "SetCommConfig"},
    {1061, "SetCommMask"},
    {1062, "SetCommState"},
    {1063, "SetCommTimeouts"},
    {1064, "SetComputerNameA"},
    {1065, "SetComputerNameExA"},
    {1066, "SetComputerNameExW"},
    {1067, "SetComputerNameW"},
    {1068, "SetConsoleActiveScreenBuffer"},
    {1069, "SetConsoleCP"},
    {1070, "SetConsoleCtrlHandler"},
    {1071, "SetConsoleCursor"},
    {1072, "SetConsoleCursorInfo"},
    {1073, "SetConsoleCursorMode"},
    {1074, "SetConsoleCursorPosition"},
    {1075, "SetConsoleDisplayMode"},
    {1076, "SetConsoleFont"},
    {1077, "SetConsoleHardwareState"},
    {1078, "SetConsoleHistoryInfo"},
    {1079, "SetConsoleIcon"},
    {1080, "SetConsoleInputExeNameA"},
    {1081, "SetConsoleInputExeNameW"},
    {1082, "SetConsoleKeyShortcuts"},
    {1083, "SetConsoleLocalEUDC"},
    {1084, "SetConsoleMaximumWindowSize"},
    {1085, "SetConsoleMenuClose"},
    {1086, "SetConsoleMode"},
    {1087, "SetConsoleNlsMode"},
    {1088, "SetConsoleNumberOfCommandsA"},
    {1089, "SetConsoleNumberOfCommandsW"},
    {1090, "SetConsoleOS2OemFormat"},
    {1091, "SetConsoleOutputCP"},
    {1092, "SetConsolePalette"},
    {1093, "SetConsoleScreenBufferInfoEx"},
    {1094, "SetConsoleScreenBufferSize"},
    {1095, "SetConsoleTextAttribute"},
    {1096, "SetConsoleTitleA"},
    {1097, "SetConsoleTitleW"},
    {1098, "SetConsoleWindowInfo"},
    {1099, "SetCriticalSectionSpinCount"},
    {1100, "SetCurrentConsoleFontEx"},
    {1101, "SetCurrentDirectoryA"},
    {1102, "SetCurrentDirectoryW"},
    {1103, "SetDefaultCommConfigA"},
    {1104, "SetDefaultCommConfigW"},
    {1105, "SetDllDirectoryA"},
    {1106, "SetDllDirectoryW"},
    {1107, "SetDynamicTimeZoneInformation"},
    {1108, "SetEndOfFile"},
    {1109, "SetEnvironmentStringsA"},
    {1110, "SetEnvironmentStringsW"},
    {1111, "SetEnvironmentVariableA"},
    {1112, "SetEnvironmentVariableW"},
    {1113, "SetErrorMode"},
    {1114, "SetEvent"},
    {1115, "SetEventWhenCallbackReturns"},
    {1116, "SetExtendedFeaturesMask"},
    {1117, "SetFileApisToANSI"},
    {1118, "SetFileApisToOEM"},
    {1119, "SetFileAttributesA"},
    {1120, "SetFileAttributesTransactedA"},
    {1121, "SetFileAttributesTransactedW"},
    {1122, "SetFileAttributesW"},
    {1123, "SetFileBandwidthReservation"},
    {1124, "SetFileCompletionNotificationModes"},
    {1125, "SetFileInformationByHandle"},
    {1126, "SetFileIoOverlappedRange"},
    {1127, "SetFilePointer"},
    {1128, "SetFilePointerEx"},
    {1129, "SetFileShortNameA"},
    {1130, "SetFileShortNameW"},
    {1131, "SetFileTime"},
    {1132, "SetFileValidData"},
    {1133, "SetFirmwareEnvironmentVariableA"},
    {1134, "SetFirmwareEnvironmentVariableW"},
    {1135, "SetHandleContext"},
    {1136, "SetHandleCount"},
    {1137, "SetHandleInformation"},
    {1138, "SetInformationJobObject"},
    {1139, "SetLastConsoleEventActive"},
    {1140, "SetLastError"},
    {1141, "SetLocalPrimaryComputerNameA"},
    {1142, "SetLocalPrimaryComputerNameW"},
    {1143, "SetLocalTime"},
    {1144, "SetLocaleInfoA"},
    {1145, "SetLocaleInfoW"},
    {1146, "SetMailslotInfo"},
    {1147, "SetMessageWaitingIndicator"},
    {1148, "SetNamedPipeAttribute"},
    {1149, "SetNamedPipeHandleState"},
    {1150, "SetPriorityClass"},
    {1151, "SetProcessAffinityMask"},
    {1152, "SetProcessAffinityUpdateMode"},
    {1153, "SetProcessDEPPolicy"},
    {1154, "SetProcessPreferredUILanguages"},
    {1155, "SetProcessPriorityBoost"},
    {1156, "SetProcessShutdownParameters"},
    {1157, "SetProcessWorkingSetSize"},
    {1158, "SetProcessWorkingSetSizeEx"},
    {1159, "SetSearchPathMode"},
    {1160, "SetStdHandle"},
    {1161, "SetStdHandleEx"},
    {1162, "SetSystemFileCacheSize"},
    {1163, "SetSystemPowerState"},
    {1164, "SetSystemTime"},
    {1165, "SetSystemTimeAdjustment"},
    {1166, "SetTapeParameters"},
    {1167, "SetTapePosition"},
    {1168, "SetTermsrvAppInstallMode"},
    {1169, "SetThreadAffinityMask"},
    {1170, "SetThreadContext"},
    {1171, "SetThreadErrorMode"},
    {1172, "SetThreadExecutionState"},
    {1173, "SetThreadGroupAffinity"},
    {1174, "SetThreadIdealProcessor"},
    {1175, "SetThreadIdealProcessorEx"},
    {1176, "SetThreadLocale"},
    {1177, "SetThreadPreferredUILanguages"},
    {1178, "SetThreadPriority"},
    {1179, "SetThreadPriorityBoost"},
    {1180, "SetThreadStackGuarantee"},
    {1181, "SetThreadToken"},
    {1182, "SetThreadUILanguage"},
    {1183, "SetThreadpoolStackInformation"},
    {1184, "SetThreadpoolThreadMaximum"},
    {1185, "SetThreadpoolThreadMinimum"},
    {1186, "SetThreadpoolTimer"},
    {1187, "SetThreadpoolWait"},
    {1188, "SetTimeZoneInformation"},
    {1189, "SetTimerQueueTimer"},
    {1190, "SetUnhandledExceptionFilter"},
    {1191, "SetUserGeoID"},
    {1192, "SetVDMCurrentDirectories"},
    {1193, "SetVolumeLabelA"},
    {1194, "SetVolumeLabelW"},
    {1195, "SetVolumeMountPointA"},
    {1196, "SetVolumeMountPointW"},
    {1197, "SetWaitableTimer"},
    {1198, "SetWaitableTimerEx"},
    {1199, "SetupComm"},
    {1200, "ShowConsoleCursor"},
    {1201, "SignalObjectAndWait"},
    {1202, "SizeofResource"},
    {1203, "Sleep"},
    {1204, "SleepConditionVariableCS"},
    {1205, "SleepConditionVariableSRW"},
    {1206, "SleepEx"},
    {1207, "SortCloseHandle"},
    {1208, "SortGetHandle"},
    {1209, "StartThreadpoolIo"},
    {1210, "SubmitThreadpoolWork"},
    {1211, "SuspendThread"},
    {1212, "SwitchToFiber"},
    {1213, "SwitchToThread"},
    {1214, "SystemTimeToFileTime"},
    {1215, "SystemTimeToTzSpecificLocalTime"},
    {1216, "TerminateJobObject"},
    {1217, "TerminateProcess"},
    {1218, "TerminateThread"},
    {1219, "TermsrvAppInstallMode"},
    {1220, "Thread32First"},
    {1221, "Thread32Next"},
    {1222, "TlsAlloc"},
    {1223, "TlsFree"},
    {1224, "TlsGetValue"},
    {1225, "TlsSetValue"},
    {1226, "Toolhelp32ReadProcessMemory"},
    {1227, "TransactNamedPipe"},
    {1228, "TransmitCommChar"},
    {1229, "TryAcquireSRWLockExclusive"},
    {1230, "TryAcquireSRWLockShared"},
    {1231, "TryEnterCriticalSection"},
    {1232, "TrySubmitThreadpoolCallback"},
    {1233, "TzSpecificLocalTimeToSystemTime"},
    {1234, "UTRegister"},
    {1235, "UTUnRegister"},
    {1236, "UnhandledExceptionFilter"},
    {1237, "UnlockFile"},
    {1238, "UnlockFileEx"},
    {1239, "UnmapViewOfFile"},
    {1240, "UnregisterApplicationRecoveryCallback"},
    {1241, "UnregisterApplicationRestart"},
    {1242, "UnregisterConsoleIME"},
    {1243, "UnregisterWait"},
    {1244, "UnregisterWaitEx"},
    {1245, "UpdateCalendarDayOfWeek"},
    {1246, "UpdateProcThreadAttribute"},
    {1247, "UpdateResourceA"},
    {1248, "UpdateResourceW"},
    {1249, "VDMConsoleOperation"},
    {1250, "VDMOperationStarted"},
    {1251, "VerLanguageNameA"},
    {1252, "VerLanguageNameW"},
    {1253, "VerSetConditionMask"},
    {1254, "VerifyConsoleIoHandle"},
    {1255, "VerifyScripts"},
    {1256, "VerifyVersionInfoA"},
    {1257, "VerifyVersionInfoW"},
    {1258, "VirtualAlloc"},
    {1259, "VirtualAllocEx"},
    {1260, "VirtualAllocExNuma"},
    {1261, "VirtualFree"},
    {1262, "VirtualFreeEx"},
    {1263, "VirtualLock"},
    {1264, "VirtualProtect"},
    {1265, "VirtualProtectEx"},
    {1266, "VirtualQuery"},
    {1267, "VirtualQueryEx"},
    {1268, "VirtualUnlock"},
    {1269, "WTSGetActiveConsoleSessionId"},
    {1270, "WaitCommEvent"},
    {1271, "WaitForDebugEvent"},
    {1272, "WaitForMultipleObjects"},
    {1273, "WaitForMultipleObjectsEx"},
    {1274, "WaitForSingleObject"},
    {1275, "WaitForSingleObjectEx"},
    {1276, "WaitForThreadpoolIoCallbacks"},
    {1277, "WaitForThreadpoolTimerCallbacks"},
    {1278, "WaitForThreadpoolWaitCallbacks"},
    {1279, "WaitForThreadpoolWorkCallbacks"},
    {1280, "WaitNamedPipeA"},
    {1281, "WaitNamedPipeW"},
    {1282, "WakeAllConditionVariable"},
    {1283, "WakeConditionVariable"},
    {1284, "WerGetFlags"},
    {1285, "WerRegisterFile"},
    {1286, "WerRegisterMemoryBlock"},
    {1287, "WerRegisterRuntimeExceptionModule"},
    {1288, "WerSetFlags"},
    {1289, "WerUnregisterFile"},
    {1290, "WerUnregisterMemoryBlock"},
    {1291, "WerUnregisterRuntimeExceptionModule"},
    {1292, "WerpCleanupMessageMapping"},
    {1293, "WerpInitiateRemoteRecovery"},
    {1294, "WerpNotifyLoadStringResource"},
    {1295, "WerpNotifyLoadStringResourceEx"},
    {1296, "WerpNotifyUseStringResource"},
    {1297, "WerpStringLookup"},
    {1298, "WideCharToMultiByte"},
    {1299, "WinExec"},
    {1300, "Wow64DisableWow64FsRedirection"},
    {1301, "Wow64EnableWow64FsRedirection"},
    {1302, "Wow64GetThreadContext"},
    {1303, "Wow64GetThreadSelectorEntry"},
    {1304, "Wow64RevertWow64FsRedirection"},
    {1305, "Wow64SetThreadContext"},
    {1306, "Wow64SuspendThread"},
    {1307, "WriteConsoleA"},
    {1308, "WriteConsoleInputA"},
    {1309, "WriteConsoleInputVDMA"},
    {1310, "WriteConsoleInputVDMW"},
    {1311, "WriteConsoleInputW"},
    {1312, "WriteConsoleOutputA"},
    {1313, "WriteConsoleOutputAttribute"},
    {1314, "WriteConsoleOutputCharacterA"},
    {1315, "WriteConsoleOutputCharacterW"},
    {1316, "WriteConsoleOutputW"},
    {1317, "WriteConsoleW"},
    {1318, "WriteFile"},
    {1319, "WriteFileEx"},
    {1320, "WriteFileGather"},
    {1321, "WritePrivateProfileSectionA"},
    {1322, "WritePrivateProfileSectionW"},
    {1323, "WritePrivateProfileStringA"},
    {1324, "WritePrivateProfileStringW"},
    {1325, "WritePrivateProfileStructA"},
    {1326, "WritePrivateProfileStructW"},
    {1327, "WriteProcessMemory"},
    {1328, "WriteProfileSectionA"},
    {1329, "WriteProfileSectionW"},
    {1330, "WriteProfileStringA"},
    {1331, "WriteProfileStringW"},
    {1332, "WriteTapemark"},
    {1333, "ZombifyActCtx"},
    {1334, "_hread"},
    {1335, "_hwrite"},
    {1336, "_lclose"},
    {1337, "_lcreat"},
    {1338, "_llseek"},
    {1339, "_lopen"},
    {1340, "_lread"},
    {1341, "_lwrite"},
    {1342, "lstrcat"},
    {1343, "lstrcatA"},
    {1344, "lstrcatW"},
    {1345, "lstrcmp"},
    {1346, "lstrcmpA"},
    {1347, "lstrcmpW"},
    {1348, "lstrcmpi"},
    {1349, "lstrcmpiA"},
    {1350, "lstrcmpiW"},
    {1351, "lstrcpy"},
    {1352, "lstrcpyA"},
    {1353, "lstrcpyW"},
    {1354, "lstrcpyn"},
    {1355, "lstrcpynA"},
    {1356, "lstrcpynW"},
    {1357, "lstrlen"},
    {1358, "lstrlenA"},
    {1359, "lstrlenW"},
    {0, NULL}};
static Dw32Ordinal ksuser[] = {
    {1, "KsCreateAllocator"},
    {2, "KsCreateClock"},
    {3, "KsCreatePin"},
    {4, "KsCreateTopologyNode"},
    {0, NULL}};
static Dw32Ordinal ktmw32[] = {
    {1, "CommitComplete"},
    {2, "CommitEnlistment"},
    {3, "CommitTransaction"},
    {4, "CommitTransactionAsync"},
    {5, "CreateEnlistment"},
    {6, "CreateResourceManager"},
    {7, "CreateTransaction"},
    {8, "CreateTransactionManager"},
    {9, "GetCurrentClockTransactionManager"},
    {10, "GetEnlistmentId"},
    {11, "GetEnlistmentRecoveryInformation"},
    {12, "GetNotificationResourceManager"},
    {13, "GetNotificationResourceManagerAsync"},
    {14, "GetTransactionId"},
    {15, "GetTransactionInformation"},
    {16, "GetTransactionManagerId"},
    {17, "OpenEnlistment"},
    {18, "OpenResourceManager"},
    {19, "OpenTransaction"},
    {20, "OpenTransactionManager"},
    {21, "OpenTransactionManagerById"},
    {22, "PrePrepareComplete"},
    {23, "PrePrepareEnlistment"},
    {24, "PrepareComplete"},
    {25, "PrepareEnlistment"},
    {26, "PrivCreateTransaction"},
    {27, "PrivIsLogWritableTransactionManager"},
    {28, "PrivPropagationComplete"},
    {29, "PrivPropagationFailed"},
    {30, "PrivRegisterProtocolAddressInformation"},
    {31, "ReadOnlyEnlistment"},
    {32, "RecoverEnlistment"},
    {33, "RecoverResourceManager"},
    {34, "RecoverTransactionManager"},
    {35, "RenameTransactionManager"},
    {36, "RollbackComplete"},
    {37, "RollbackEnlistment"},
    {38, "RollbackTransaction"},
    {39, "RollbackTransactionAsync"},
    {40, "RollforwardTransactionManager"},
    {41, "SetEnlistmentRecoveryInformation"},
    {42, "SetResourceManagerCompletionPort"},
    {43, "SetTransactionInformation"},
    {44, "SinglePhaseReject"},
    {0, NULL}};
static Dw32Ordinal libexpat[] = {
    {1, "XML_DefaultCurrent"},
    {2, "XML_ErrorString"},
    {3, "XML_ExpatVersion"},
    {4, "XML_ExpatVersionInfo"},
    {5, "XML_ExternalEntityParserCreate"},
    {59, "XML_FreeContentModel"},
    {6, "XML_GetBase"},
    {7, "XML_GetBuffer"},
    {8, "XML_GetCurrentByteCount"},
    {9, "XML_GetCurrentByteIndex"},
    {10, "XML_GetCurrentColumnNumber"},
    {11, "XML_GetCurrentLineNumber"},
    {12, "XML_GetErrorCode"},
    {57, "XML_GetFeatureList"},
    {13, "XML_GetIdAttributeIndex"},
    {14, "XML_GetInputContext"},
    {65, "XML_GetParsingStatus"},
    {15, "XML_GetSpecifiedAttributeCount"},
    {62, "XML_MemFree"},
    {60, "XML_MemMalloc"},
    {61, "XML_MemRealloc"},
    {16, "XML_Parse"},
    {17, "XML_ParseBuffer"},
    {18, "XML_ParserCreate"},
    {19, "XML_ParserCreateNS"},
    {20, "XML_ParserCreate_MM"},
    {21, "XML_ParserFree"},
    {55, "XML_ParserReset"},
    {64, "XML_ResumeParser"},
    {22, "XML_SetAttlistDeclHandler"},
    {23, "XML_SetBase"},
    {24, "XML_SetCdataSectionHandler"},
    {25, "XML_SetCharacterDataHandler"},
    {26, "XML_SetCommentHandler"},
    {27, "XML_SetDefaultHandler"},
    {28, "XML_SetDefaultHandlerExpand"},
    {29, "XML_SetDoctypeDeclHandler"},
    {30, "XML_SetElementDeclHandler"},
    {31, "XML_SetElementHandler"},
    {32, "XML_SetEncoding"},
    {33, "XML_SetEndCdataSectionHandler"},
    {34, "XML_SetEndDoctypeDeclHandler"},
    {35, "XML_SetEndElementHandler"},
    {36, "XML_SetEndNamespaceDeclHandler"},
    {37, "XML_SetEntityDeclHandler"},
    {38, "XML_SetExternalEntityRefHandler"},
    {39, "XML_SetExternalEntityRefHandlerArg"},
    {40, "XML_SetNamespaceDeclHandler"},
    {41, "XML_SetNotStandaloneHandler"},
    {42, "XML_SetNotationDeclHandler"},
    {43, "XML_SetParamEntityParsing"},
    {44, "XML_SetProcessingInstructionHandler"},
    {45, "XML_SetReturnNSTriplet"},
    {56, "XML_SetSkippedEntityHandler"},
    {46, "XML_SetStartCdataSectionHandler"},
    {47, "XML_SetStartDoctypeDeclHandler"},
    {48, "XML_SetStartElementHandler"},
    {49, "XML_SetStartNamespaceDeclHandler"},
    {50, "XML_SetUnknownEncodingHandler"},
    {51, "XML_SetUnparsedEntityDeclHandler"},
    {52, "XML_SetUserData"},
    {53, "XML_SetXmlDeclHandler"},
    {63, "XML_StopParser"},
    {58, "XML_UseForeignDTD"},
    {54, "XML_UseParserAsHandlerArg"},
    {0, NULL}};
static Dw32Ordinal libpng13[] = {
    {168, "png_access_version_number"},
    {1, "png_build_grayscale_palette"},
    {217, "png_check_cHRM_fixed"},
    {2, "png_check_sig"},
    {3, "png_chunk_error"},
    {4, "png_chunk_warning"},
    {5, "png_convert_from_struct_tm"},
    {6, "png_convert_from_time_t"},
    {172, "png_convert_to_rfc1123"},
    {7, "png_create_info_struct"},
    {8, "png_create_read_struct"},
    {180, "png_create_read_struct_2"},
    {9, "png_create_write_struct"},
    {181, "png_create_write_struct_2"},
    {10, "png_data_freer"},
    {11, "png_destroy_info_struct"},
    {12, "png_destroy_read_struct"},
    {178, "png_destroy_struct"},
    {179, "png_destroy_struct_2"},
    {13, "png_destroy_write_struct"},
    {14, "png_error"},
    {15, "png_free"},
    {16, "png_free_data"},
    {183, "png_free_default"},
    {17, "png_get_IHDR"},
    {18, "png_get_PLTE"},
    {187, "png_get_asm_flagmask"},
    {188, "png_get_asm_flags"},
    {19, "png_get_bKGD"},
    {20, "png_get_bit_depth"},
    {21, "png_get_cHRM"},
    {22, "png_get_cHRM_fixed"},
    {23, "png_get_channels"},
    {24, "png_get_color_type"},
    {25, "png_get_compression_buffer_size"},
    {26, "png_get_compression_type"},
    {27, "png_get_copyright"},
    {28, "png_get_error_ptr"},
    {29, "png_get_filter_type"},
    {30, "png_get_gAMA"},
    {31, "png_get_gAMA_fixed"},
    {32, "png_get_hIST"},
    {33, "png_get_header_ver"},
    {34, "png_get_header_version"},
    {35, "png_get_iCCP"},
    {36, "png_get_image_height"},
    {37, "png_get_image_width"},
    {204, "png_get_int_32"},
    {38, "png_get_interlace_type"},
    {39, "png_get_io_ptr"},
    {41, "png_get_oFFs"},
    {42, "png_get_pCAL"},
    {43, "png_get_pHYs"},
    {44, "png_get_pixel_aspect_ratio"},
    {45, "png_get_pixels_per_meter"},
    {46, "png_get_progressive_ptr"},
    {47, "png_get_rgb_to_gray_status"},
    {48, "png_get_rowbytes"},
    {49, "png_get_rows"},
    {50, "png_get_sBIT"},
    {51, "png_get_sCAL"},
    {52, "png_get_sPLT"},
    {53, "png_get_sRGB"},
    {54, "png_get_signature"},
    {55, "png_get_tIME"},
    {56, "png_get_tRNS"},
    {57, "png_get_text"},
    {202, "png_get_uint_16"},
    {206, "png_get_uint_31"},
    {200, "png_get_uint_32"},
    {58, "png_get_unknown_chunks"},
    {59, "png_get_user_chunk_ptr"},
    {196, "png_get_user_height_max"},
    {60, "png_get_user_transform_ptr"},
    {197, "png_get_user_width_max"},
    {61, "png_get_valid"},
    {62, "png_get_x_offset_microns"},
    {63, "png_get_x_offset_pixels"},
    {64, "png_get_x_pixels_per_meter"},
    {65, "png_get_y_offset_microns"},
    {66, "png_get_y_offset_pixels"},
    {67, "png_get_y_pixels_per_meter"},
    {194, "png_handle_as_unknown"},
    {177, "png_info_init_3"},
    {171, "png_init_io"},
    {68, "png_malloc"},
    {182, "png_malloc_default"},
    {195, "png_malloc_warn"},
    {69, "png_memcpy_check"},
    {70, "png_memset_check"},
    {185, "png_mmx_support"},
    {71, "png_permit_empty_plte"},
    {184, "png_permit_mng_features"},
    {72, "png_process_data"},
    {73, "png_progressive_combine_row"},
    {74, "png_read_end"},
    {75, "png_read_image"},
    {76, "png_read_info"},
    {77, "png_read_init"},
    {166, "png_read_init_2"},
    {175, "png_read_init_3"},
    {78, "png_read_png"},
    {79, "png_read_row"},
    {80, "png_read_rows"},
    {81, "png_read_update_info"},
    {82, "png_reset_zstream"},
    {205, "png_save_int_32"},
    {203, "png_save_uint_16"},
    {201, "png_save_uint_32"},
    {83, "png_set_IHDR"},
    {84, "png_set_PLTE"},
    {199, "png_set_add_alpha"},
    {191, "png_set_asm_flags"},
    {85, "png_set_bKGD"},
    {86, "png_set_background"},
    {87, "png_set_bgr"},
    {88, "png_set_cHRM"},
    {89, "png_set_cHRM_fixed"},
    {90, "png_set_compression_buffer_size"},
    {91, "png_set_compression_level"},
    {92, "png_set_compression_mem_level"},
    {93, "png_set_compression_method"},
    {94, "png_set_compression_strategy"},
    {95, "png_set_compression_window_bits"},
    {96, "png_set_crc_action"},
    {97, "png_set_dither"},
    {98, "png_set_error_fn"},
    {99, "png_set_expand"},
    {207, "png_set_expand_gray_1_2_4_to_8"},
    {100, "png_set_filler"},
    {101, "png_set_filter"},
    {102, "png_set_filter_heuristics"},
    {103, "png_set_flush"},
    {104, "png_set_gAMA"},
    {105, "png_set_gAMA_fixed"},
    {106, "png_set_gamma"},
    {107, "png_set_gray_1_2_4_to_8"},
    {108, "png_set_gray_to_rgb"},
    {109, "png_set_hIST"},
    {110, "png_set_iCCP"},
    {111, "png_set_interlace_handling"},
    {173, "png_set_invalid"},
    {112, "png_set_invert_alpha"},
    {113, "png_set_invert_mono"},
    {114, "png_set_keep_unknown_chunks"},
    {115, "png_set_oFFs"},
    {116, "png_set_pCAL"},
    {117, "png_set_pHYs"},
    {118, "png_set_packing"},
    {119, "png_set_packswap"},
    {120, "png_set_palette_to_rgb"},
    {121, "png_set_progressive_read_fn"},
    {122, "png_set_read_fn"},
    {123, "png_set_read_status_fn"},
    {124, "png_set_read_user_chunk_fn"},
    {125, "png_set_read_user_transform_fn"},
    {126, "png_set_rgb_to_gray"},
    {127, "png_set_rgb_to_gray_fixed"},
    {128, "png_set_rows"},
    {129, "png_set_sBIT"},
    {130, "png_set_sCAL"},
    {131, "png_set_sPLT"},
    {132, "png_set_sRGB"},
    {133, "png_set_sRGB_gAMA_and_cHRM"},
    {134, "png_set_shift"},
    {135, "png_set_sig_bytes"},
    {136, "png_set_strip_16"},
    {137, "png_set_strip_alpha"},
    {193, "png_set_strip_error_numbers"},
    {138, "png_set_swap"},
    {139, "png_set_swap_alpha"},
    {140, "png_set_tIME"},
    {141, "png_set_tRNS"},
    {142, "png_set_tRNS_to_alpha"},
    {143, "png_set_text"},
    {144, "png_set_unknown_chunk_location"},
    {145, "png_set_unknown_chunks"},
    {198, "png_set_user_limits"},
    {146, "png_set_user_transform_info"},
    {147, "png_set_write_fn"},
    {148, "png_set_write_status_fn"},
    {149, "png_set_write_user_transform_fn"},
    {150, "png_sig_cmp"},
    {151, "png_start_read_image"},
    {152, "png_warning"},
    {153, "png_write_chunk"},
    {154, "png_write_chunk_data"},
    {155, "png_write_chunk_end"},
    {156, "png_write_chunk_start"},
    {157, "png_write_end"},
    {158, "png_write_flush"},
    {159, "png_write_image"},
    {160, "png_write_info"},
    {161, "png_write_info_before_PLTE"},
    {162, "png_write_init"},
    {167, "png_write_init_2"},
    {176, "png_write_init_3"},
    {163, "png_write_png"},
    {164, "png_write_row"},
    {165, "png_write_rows"},
    {208, "png_write_sig"},
    {0, NULL}};
static Dw32Ordinal libtiff[] = {
    {1, "TIFFAccessTagMethods"},
    {2, "TIFFCIELabToRGBInit"},
    {3, "TIFFCIELabToXYZ"},
    {4, "TIFFCheckTile"},
    {5, "TIFFCheckpointDirectory"},
    {6, "TIFFCleanup"},
    {7, "TIFFClientOpen"},
    {8, "TIFFClientdata"},
    {9, "TIFFClose"},
    {10, "TIFFComputeStrip"},
    {11, "TIFFComputeTile"},
    {12, "TIFFCreateDirectory"},
    {13, "TIFFCurrentDirOffset"},
    {14, "TIFFCurrentDirectory"},
    {15, "TIFFCurrentRow"},
    {16, "TIFFCurrentStrip"},
    {17, "TIFFCurrentTile"},
    {18, "TIFFDataWidth"},
    {19, "TIFFDefaultStripSize"},
    {20, "TIFFDefaultTileSize"},
    {21, "TIFFError"},
    {22, "TIFFErrorExt"},
    {23, "TIFFFdOpen"},
    {24, "TIFFFieldWithName"},
    {25, "TIFFFieldWithTag"},
    {26, "TIFFFileName"},
    {27, "TIFFFileno"},
    {28, "TIFFFindCODEC"},
    {29, "TIFFFindFieldInfo"},
    {30, "TIFFFindFieldInfoByName"},
    {31, "TIFFFlush"},
    {32, "TIFFFlushData"},
    {33, "TIFFFreeDirectory"},
    {34, "TIFFGetBitRevTable"},
    {35, "TIFFGetClientInfo"},
    {36, "TIFFGetCloseProc"},
    {37, "TIFFGetConfiguredCODECs"},
    {38, "TIFFGetField"},
    {39, "TIFFGetFieldDefaulted"},
    {40, "TIFFGetMapFileProc"},
    {41, "TIFFGetMode"},
    {42, "TIFFGetReadProc"},
    {43, "TIFFGetSeekProc"},
    {44, "TIFFGetSizeProc"},
    {45, "TIFFGetTagListCount"},
    {46, "TIFFGetTagListEntry"},
    {47, "TIFFGetUnmapFileProc"},
    {48, "TIFFGetVersion"},
    {49, "TIFFGetWriteProc"},
    {50, "TIFFIsBigEndian"},
    {51, "TIFFIsByteSwapped"},
    {52, "TIFFIsCODECConfigured"},
    {53, "TIFFIsMSB2LSB"},
    {54, "TIFFIsTiled"},
    {55, "TIFFIsUpSampled"},
    {56, "TIFFLastDirectory"},
    {57, "TIFFMergeFieldInfo"},
    {58, "TIFFNumberOfDirectories"},
    {59, "TIFFNumberOfStrips"},
    {60, "TIFFNumberOfTiles"},
    {61, "TIFFOpen"},
    {62, "TIFFOpenW"},
    {63, "TIFFPrintDirectory"},
    {64, "TIFFRGBAImageBegin"},
    {65, "TIFFRGBAImageEnd"},
    {66, "TIFFRGBAImageGet"},
    {67, "TIFFRGBAImageOK"},
    {68, "TIFFRasterScanlineSize"},
    {69, "TIFFRawStripSize"},
    {70, "TIFFReadBufferSetup"},
    {71, "TIFFReadCustomDirectory"},
    {72, "TIFFReadDirectory"},
    {73, "TIFFReadEXIFDirectory"},
    {74, "TIFFReadEncodedStrip"},
    {75, "TIFFReadEncodedTile"},
    {76, "TIFFReadRGBAImage"},
    {77, "TIFFReadRGBAImageOriented"},
    {78, "TIFFReadRGBAStrip"},
    {79, "TIFFReadRGBATile"},
    {80, "TIFFReadRawStrip"},
    {81, "TIFFReadRawTile"},
    {82, "TIFFReadScanline"},
    {83, "TIFFReadTile"},
    {84, "TIFFReassignTagToIgnore"},
    {85, "TIFFRegisterCODEC"},
    {86, "TIFFReverseBits"},
    {87, "TIFFRewriteDirectory"},
    {88, "TIFFScanlineSize"},
    {89, "TIFFSetClientInfo"},
    {90, "TIFFSetClientdata"},
    {91, "TIFFSetDirectory"},
    {92, "TIFFSetErrorHandler"},
    {93, "TIFFSetErrorHandlerExt"},
    {94, "TIFFSetField"},
    {95, "TIFFSetFileName"},
    {96, "TIFFSetFileno"},
    {97, "TIFFSetMode"},
    {98, "TIFFSetSubDirectory"},
    {99, "TIFFSetTagExtender"},
    {100, "TIFFSetWarningHandler"},
    {101, "TIFFSetWarningHandlerExt"},
    {102, "TIFFSetWriteOffset"},
    {103, "TIFFSetupStrips"},
    {104, "TIFFStripSize"},
    {105, "TIFFSwabArrayOfDouble"},
    {106, "TIFFSwabArrayOfLong"},
    {107, "TIFFSwabArrayOfShort"},
    {108, "TIFFSwabArrayOfTriples"},
    {109, "TIFFSwabDouble"},
    {110, "TIFFSwabLong"},
    {111, "TIFFSwabShort"},
    {112, "TIFFTileRowSize"},
    {113, "TIFFTileSize"},
    {114, "TIFFUnRegisterCODEC"},
    {115, "TIFFUnlinkDirectory"},
    {116, "TIFFVGetField"},
    {117, "TIFFVGetFieldDefaulted"},
    {118, "TIFFVSetField"},
    {119, "TIFFVStripSize"},
    {120, "TIFFVTileSize"},
    {121, "TIFFWarning"},
    {122, "TIFFWarningExt"},
    {123, "TIFFWriteBufferSetup"},
    {124, "TIFFWriteCheck"},
    {125, "TIFFWriteDirectory"},
    {126, "TIFFWriteEncodedStrip"},
    {127, "TIFFWriteEncodedTile"},
    {128, "TIFFWriteRawStrip"},
    {129, "TIFFWriteRawTile"},
    {130, "TIFFWriteScanline"},
    {131, "TIFFWriteTile"},
    {132, "TIFFXYZToRGB"},
    {133, "TIFFYCbCrToRGBInit"},
    {134, "TIFFYCbCrtoRGB"},
    {135, "_TIFFfree"},
    {136, "_TIFFmalloc"},
    {137, "_TIFFmemcmp"},
    {138, "_TIFFmemcpy"},
    {139, "_TIFFmemset"},
    {140, "_TIFFrealloc"},
    {0, NULL}};
static Dw32Ordinal loadperf[] = {
    {1, "BackupPerfRegistryToFileW"},
    {2, "InstallPerfDllA"},
    {3, "InstallPerfDllW"},
    {4, "LoadPerfCounterTextStringsA"},
    {5, "LoadPerfCounterTextStringsW"},
    {6, "LpAcquireInstallationMutex"},
    {7, "LpReleaseInstallationMutex"},
    {8, "RestorePerfRegistryFromFileW"},
    {9, "SetServiceAsTrustedA"},
    {10, "SetServiceAsTrustedW"},
    {11, "UnloadPerfCounterTextStringsA"},
    {12, "UnloadPerfCounterTextStringsW"},
    {13, "UpdatePerfNameFilesA"},
    {14, "UpdatePerfNameFilesW"},
    {0, NULL}};
static Dw32Ordinal lz32[] = {
    {1, "CopyLZFile"},
    {2, "GetExpandedNameA"},
    {3, "GetExpandedNameW"},
    {4, "LZClose"},
    {5, "LZCloseFile"},
    {6, "LZCopy"},
    {7, "LZCreateFileW"},
    {8, "LZDone"},
    {9, "LZInit"},
    {10, "LZOpenFileA"},
    {11, "LZOpenFileW"},
    {12, "LZRead"},
    {13, "LZSeek"},
    {14, "LZStart"},
    {0, NULL}};
static Dw32Ordinal magnification[] = {
    {1, "MagGetColorEffect"},
    {2, "MagGetImageScalingCallback"},
    {3, "MagGetWindowFilterList"},
    {4, "MagGetWindowSource"},
    {5, "MagGetWindowTransform"},
    {6, "MagInitialize"},
    {7, "MagSetColorEffect"},
    {8, "MagSetImageScalingCallback"},
    {9, "MagSetWindowFilterList"},
    {10, "MagSetWindowSource"},
    {11, "MagSetWindowTransform"},
    {12, "MagUninitialize"},
    {0, NULL}};
static Dw32Ordinal mapi32[] = {
    {225, "BMAPIAddress"},
    {227, "BMAPIDetails"},
    {224, "BMAPIFindNext"},
    {226, "BMAPIGetAddress"},
    {223, "BMAPIGetReadMail"},
    {222, "BMAPIReadMail"},
    {228, "BMAPIResolveName"},
    {221, "BMAPISaveMail"},
    {220, "BMAPISendMail"},
    {46, "BuildDisplayTable@40"},
    {207, "CbOfEncoded@4"},
    {206, "CchOfEncoding@4"},
    {55, "ChangeIdleRoutine@28"},
    {197, "CloseIMsgSession@4"},
    {60, "CreateIProp@24"},
    {61, "CreateTable@36"},
    {34, "DeinitMapiUtil@0"},
    {54, "DeregisterIdleRoutine@4"},
    {28, "DllCanUnloadNow"},
    {27, "DllGetClassObject"},
    {53, "EnableIdleRoutine@8"},
    {204, "EncodeID@12"},
    {182, "FBadColumnSet@4"},
    {190, "FBadEntryList@4"},
    {181, "FBadProp@4"},
    {179, "FBadPropTag@4"},
    {191, "FBadRestriction@4"},
    {178, "FBadRglpNameID@8"},
    {175, "FBadRglpszA@8"},
    {176, "FBadRglpszW@8"},
    {180, "FBadRow@4"},
    {177, "FBadRowSet@4"},
    {189, "FBadSortOrderSet@4"},
    {44, "FBinFromHex@8"},
    {205, "FDecodeID@12"},
    {72, "FEqualNames@8"},
    {254, "FGetComponentPath"},
    {255, "FGetComponentPath@20"},
    {79, "FPropCompareProp@12"},
    {78, "FPropContainsProp@12"},
    {137, "FPropExists@8"},
    {252, "FixMAPI"},
    {253, "FixMAPI@0"},
    {139, "FreePadrlist@4"},
    {140, "FreeProws@4"},
    {122, "FtAdcFt@20"},
    {121, "FtAddFt@16"},
    {127, "FtDivFtBogus@20"},
    {124, "FtMulDw@12"},
    {125, "FtMulDwDw@8"},
    {126, "FtNegFt@8"},
    {123, "FtSubFt@16"},
    {52, "FtgRegisterIdleRoutine@20"},
    {200, "GetAttribIMsgOnIStg@12"},
    {250, "GetOutlookVersion"},
    {251, "GetOutlookVersion@0"},
    {154, "GetTnefStreamCodepage"},
    {153, "GetTnefStreamCodepage@12"},
    {45, "HexFromBin@12"},
    {81, "HrAddColumns@16"},
    {82, "HrAddColumnsEx@20"},
    {36, "HrAllocAdviseSink@12"},
    {143, "HrComposeEID@28"},
    {145, "HrComposeMsgID@24"},
    {144, "HrDecomposeEID@28"},
    {146, "HrDecomposeMsgID@24"},
    {239, "HrDispatchNotifications@4"},
    {142, "HrEntryIDFromSz@12"},
    {246, "HrGetOmiProvidersFlags"},
    {247, "HrGetOmiProvidersFlags@8"},
    {135, "HrGetOneProp@12"},
    {194, "HrIStorageFromStream@16"},
    {75, "HrQueryAllRows@24"},
    {248, "HrSetOmiProvidersFlagsInvalid"},
    {249, "HrSetOmiProvidersFlagsInvalid@4"},
    {136, "HrSetOneProp@8"},
    {141, "HrSzFromEntryID@12"},
    {42, "HrThisThreadAdviseSink@8"},
    {195, "HrValidateIPMSubtree@20"},
    {241, "HrValidateParameters@8"},
    {51, "InstallFilterHook@4"},
    {74, "IsBadBoundedStringPtr@8"},
    {25, "LAUNCHWIZARD"},
    {80, "LPropCompareProp@8"},
    {26, "LaunchWizard@20"},
    {173, "LpValFindProp@12"},
    {217, "MAPIAddress"},
    {18, "MAPIAdminProfiles"},
    {19, "MAPIAdminProfiles@8"},
    {12, "MAPIAllocateBuffer"},
    {13, "MAPIAllocateBuffer@8"},
    {14, "MAPIAllocateMore"},
    {15, "MAPIAllocateMore@12"},
    {50, "MAPIDeinitIdle@0"},
    {215, "MAPIDeleteMail"},
    {218, "MAPIDetails"},
    {214, "MAPIFindNext"},
    {16, "MAPIFreeBuffer"},
    {17, "MAPIFreeBuffer@4"},
    {59, "MAPIGetDefaultMalloc@0"},
    {49, "MAPIInitIdle@4"},
    {20, "MAPIInitialize"},
    {21, "MAPIInitialize@4"},
    {210, "MAPILogoff"},
    {209, "MAPILogon"},
    {10, "MAPILogonEx"},
    {11, "MAPILogonEx@20"},
    {29, "MAPIOpenFormMgr"},
    {30, "MAPIOpenFormMgr@8"},
    {31, "MAPIOpenLocalFormContainer"},
    {32, "MAPIOpenLocalFormContainer@4"},
    {213, "MAPIReadMail"},
    {219, "MAPIResolveName"},
    {212, "MAPISaveMail"},
    {208, "MAPISendDocuments"},
    {211, "MAPISendMail"},
    {22, "MAPIUninitialize"},
    {23, "MAPIUninitialize@0"},
    {65, "MNLS_CompareStringW@24"},
    {68, "MNLS_IsBadStringPtrW@8"},
    {66, "MNLS_MultiByteToWideChar@24"},
    {67, "MNLS_WideCharToMultiByte@32"},
    {63, "MNLS_lstrcmpW@8"},
    {64, "MNLS_lstrcpyW@8"},
    {62, "MNLS_lstrlenW@4"},
    {201, "MapStorageSCode@4"},
    {198, "OpenIMsgOnIStg@44"},
    {196, "OpenIMsgSession@12"},
    {148, "OpenStreamOnFile"},
    {147, "OpenStreamOnFile@24"},
    {150, "OpenTnefStream"},
    {149, "OpenTnefStream@28"},
    {152, "OpenTnefStreamEx"},
    {151, "OpenTnefStreamEx@32"},
    {24, "PRProviderInit"},
    {138, "PpropFindProp@12"},
    {76, "PropCopyMore@16"},
    {184, "RTFSync"},
    {183, "RTFSync@12"},
    {43, "ScBinFromHexBounded@12"},
    {165, "ScCopyNotifications@16"},
    {171, "ScCopyProps@16"},
    {164, "ScCountNotifications@12"},
    {170, "ScCountProps@12"},
    {244, "ScCreateConversationIndex@16"},
    {174, "ScDupPropset@16"},
    {35, "ScGenerateMuid@4"},
    {33, "ScInitMapiUtil@4"},
    {193, "ScLocalPathFromUNC@12"},
    {202, "ScMAPIXFromCMC"},
    {203, "ScMAPIXFromSMAPI"},
    {166, "ScRelocNotifications@20"},
    {172, "ScRelocProps@20"},
    {192, "ScUNCFromLocalPath@12"},
    {199, "SetAttribIMsgOnIStg@16"},
    {47, "SwapPlong@8"},
    {48, "SwapPword@8"},
    {130, "SzFindCh@8"},
    {131, "SzFindLastCh@8"},
    {132, "SzFindSz@8"},
    {133, "UFromSz@4"},
    {162, "UNKOBJ_COFree@8"},
    {158, "UNKOBJ_Free@8"},
    {159, "UNKOBJ_FreeRows@8"},
    {156, "UNKOBJ_ScAllocate@12"},
    {157, "UNKOBJ_ScAllocateMore@16"},
    {160, "UNKOBJ_ScCOAllocate@12"},
    {161, "UNKOBJ_ScCOReallocate@12"},
    {163, "UNKOBJ_ScSzFromIdsAlloc@20"},
    {128, "UlAddRef@4"},
    {155, "UlFromSzHex@4"},
    {77, "UlPropSize@4"},
    {129, "UlRelease@4"},
    {186, "WrapCompressedRTFStream"},
    {185, "WrapCompressedRTFStream@12"},
    {41, "WrapProgress@20"},
    {73, "WrapStoreEntryID@24"},
    {188, "__CPPValidateParameters@8"},
    {187, "__ValidateParameters@8"},
    {229, "cmc_act_on"},
    {230, "cmc_free"},
    {231, "cmc_list"},
    {232, "cmc_logoff"},
    {233, "cmc_logon"},
    {234, "cmc_look_up"},
    {235, "cmc_query_configuration"},
    {236, "cmc_read"},
    {237, "cmc_send"},
    {238, "cmc_send_documents"},
    {0, NULL}};
static Dw32Ordinal mf[] = {
    {1, "AppendPropVariant"},
    {2, "ConvertPropVariant"},
    {3, "CopyPropertyStore"},
    {4, "CreateNamedPropertyStore"},
    {5, "DllCanUnloadNow"},
    {6, "DllGetClassObject"},
    {7, "DllRegisterServer"},
    {8, "DllUnregisterServer"},
    {9, "ExtractPropVariant"},
    {10, "MFCreate3GPMediaSink"},
    {11, "MFCreateASFByteStreamPlugin"},
    {12, "MFCreateASFContentInfo"},
    {13, "MFCreateASFIndexer"},
    {14, "MFCreateASFIndexerByteStream"},
    {15, "MFCreateASFMediaSink"},
    {16, "MFCreateASFMediaSinkActivate"},
    {17, "MFCreateASFMultiplexer"},
    {18, "MFCreateASFProfile"},
    {19, "MFCreateASFProfileFromPresentationDescriptor"},
    {20, "MFCreateASFSplitter"},
    {21, "MFCreateASFStreamSelector"},
    {22, "MFCreateASFStreamingMediaSink"},
    {23, "MFCreateASFStreamingMediaSinkActivate"},
    {24, "MFCreateAggregateSource"},
    {25, "MFCreateAppSourceProxy"},
    {26, "MFCreateAudioRenderer"},
    {27, "MFCreateAudioRendererActivate"},
    {28, "MFCreateByteCacheFile"},
    {29, "MFCreateCacheManager"},
    {30, "MFCreateCredentialCache"},
    {31, "MFCreateDeviceSource"},
    {32, "MFCreateDeviceSourceActivate"},
    {33, "MFCreateDrmNetNDSchemePlugin"},
    {34, "MFCreateFileBlockMap"},
    {35, "MFCreateFileSchemePlugin"},
    {36, "MFCreateHttpSchemePlugin"},
    {37, "MFCreateLPCMByteStreamPlugin"},
    {38, "MFCreateMP3ByteStreamPlugin"},
    {39, "MFCreateMP3MediaSink"},
    {40, "MFCreateMPEG4MediaSink"},
    {41, "MFCreateMediaProcessor"},
    {42, "MFCreateMediaSession"},
    {43, "MFCreateNSCByteStreamPlugin"},
    {44, "MFCreateNetSchemePlugin"},
    {45, "MFCreatePMPHost"},
    {46, "MFCreatePMPMediaSession"},
    {47, "MFCreatePMPServer"},
    {48, "MFCreatePresentationClock"},
    {49, "MFCreatePresentationDescriptorFromASFProfile"},
    {50, "MFCreateProxyLocator"},
    {51, "MFCreateRemoteDesktopPlugin"},
    {52, "MFCreateSAMIByteStreamPlugin"},
    {53, "MFCreateSampleCopierMFT"},
    {54, "MFCreateSampleGrabberSinkActivate"},
    {55, "MFCreateSecureHttpSchemePlugin"},
    {56, "MFCreateSequencerSegmentOffset"},
    {57, "MFCreateSequencerSource"},
    {58, "MFCreateSequencerSourceRemoteStream"},
    {59, "MFCreateSimpleTypeHandler"},
    {60, "MFCreateSourceResolver"},
    {61, "MFCreateStandardQualityManager"},
    {62, "MFCreateTopoLoader"},
    {63, "MFCreateTopology"},
    {64, "MFCreateTopologyNode"},
    {65, "MFCreateTranscodeProfile"},
    {66, "MFCreateTranscodeSinkActivate"},
    {67, "MFCreateTranscodeTopology"},
    {68, "MFCreateUrlmonSchemePlugin"},
    {69, "MFCreateVideoRenderer"},
    {70, "MFCreateVideoRendererActivate"},
    {71, "MFCreateWMAEncoderActivate"},
    {72, "MFCreateWMVEncoderActivate"},
    {73, "MFEnumDeviceSources"},
    {74, "MFGetMultipleServiceProviders"},
    {75, "MFGetService"},
    {76, "MFGetSupportedMimeTypes"},
    {77, "MFGetSupportedSchemes"},
    {78, "MFGetTopoNodeCurrentType"},
    {79, "MFReadSequencerSegmentOffset"},
    {80, "MFRequireProtectedEnvironment"},
    {81, "MFShutdownObject"},
    {82, "MFTranscodeGetAudioOutputAvailableTypes"},
    {83, "MergePropertyStore"},
    {0, NULL}};
static Dw32Ordinal mfc42[] = {
    {5, "?classCCachedDataPathProperty@CCachedDataPathProperty@@2UCRuntimeClass@@B"},
    {6, "?classCDataPathProperty@CDataPathProperty@@2UCRuntimeClass@@B"},
    {7, "DllCanUnloadNow"},
    {8, "DllGetClassObject"},
    {9, "DllRegisterServer"},
    {10, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal mfc42d[] = {
    {0, NULL}};
static Dw32Ordinal mfc42u[] = {
    {5, "?classCCachedDataPathProperty@CCachedDataPathProperty@@2UCRuntimeClass@@B"},
    {6, "?classCDataPathProperty@CDataPathProperty@@2UCRuntimeClass@@B"},
    {7, "DllCanUnloadNow"},
    {8, "DllGetClassObject"},
    {9, "DllRegisterServer"},
    {10, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal mfc42ud[] = {
    {0, NULL}};
static Dw32Ordinal mfcclwz[] = {
    {1, "??0CClsWizClass@@QAE@ABV0@@Z"},
    {2, "??0CClsWizClass@@QAE@XZ"},
    {3, "??0CClsWizVerbList@@QAE@XZ"},
    {4, "??1CClsWizClass@@UAE@XZ"},
    {5, "??1CClsWizVerbList@@UAE@XZ"},
    {6, "??4CClsWizClass@@QAEAAV0@ABV0@@Z"},
    {7, "??_7CClsWizClass@@6B@"},
    {8, "??_7CClsWizVerbList@@6B@"},
    {9, "?AddHandler@CClsWizClass@@UAEHPAVCClsWizVerb@@H@Z"},
    {10, "?AddToListFromMemory@CClsWizVerbList@@UAEHPBD0GH@Z"},
    {11, "?AddToListFromResource@CClsWizVerbList@@UAEHPBD0DGH@Z"},
    {12, "?AddToListFromTypeinfo@CClsWizVerbList@@UAEHPAUITypeInfo@@@Z"},
    {13, "?AddVirtualFunctionsToList@CClsWizVerbList@@UAEHABVCString@@@Z"},
    {14, "?BuildNounList@CClsWizClass@@UAEPAV?$CTypedPtrList@VCObList@@PAVCClsWizNoun@@@@XZ"},
    {15, "?BuildVerbList@CClsWizClass@@UAEPAVCClsWizVerbList@@XZ"},
    {16, "?EmptyBldDatabaseMap@@YAXH@Z"},
    {17, "?FinishChanges@CClsWizClass@@UAEHH@Z"},
    {18, "?GetClassFilterType@CClsWizClass@@UAEHPAD@Z"},
    {19, "?GetClassNameA@CClsWizClass@@UAEPBDXZ"},
    {20, "?GetClsWizIFace@@YAPAVCClsWizIFace@@XZ"},
    {21, "?GetDisplayString@CClsWizClass@@UAEPBDXZ"},
    {22, "?GetFunctionName@CClsWizClass@@UAEPBDPAVCClsWizVerb@@@Z"},
    {23, "?GetHeaderFile@CClsWizClass@@UAEXPAVCPath@@@Z"},
    {24, "?GetSourceFile@CClsWizClass@@UAEXPAVCPath@@@Z"},
    {25, "?InitBldDatabaseMap@@YAHXZ"},
    {26, "?IsVerbHandled@CClsWizClass@@UAEHPAVCClsWizVerb@@@Z"},
    {27, "?RemoveHandler@CClsWizClass@@UAEHPAVCClsWizVerb@@@Z"},
    {28, "?SetClass@CClsWizClass@@UAEHPAVCBldDatabase@@PBD@Z"},
    {29, "?SetClass@CClsWizClass@@UAEHPBD0@Z"},
    {30, "?SetClassFilterType@CClsWizClass@@UAEHDH@Z"},
    {31, "?SetNoun@CClsWizClass@@UAEXPAVCClsWizNoun@@@Z"},
    {0, NULL}};
static Dw32Ordinal mfcd42d[] = {
    {0, NULL}};
static Dw32Ordinal mfcd42ud[] = {
    {0, NULL}};
static Dw32Ordinal mfcn42d[] = {
    {0, NULL}};
static Dw32Ordinal mfcn42ud[] = {
    {0, NULL}};
static Dw32Ordinal mfco42d[] = {
    {5, "?classCCachedDataPathProperty@CCachedDataPathProperty@@2UCRuntimeClass@@B"},
    {6, "?classCDataPathProperty@CDataPathProperty@@2UCRuntimeClass@@B"},
    {2, "DllCanUnloadNow"},
    {1, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal mfco42ud[] = {
    {5, "?classCCachedDataPathProperty@CCachedDataPathProperty@@2UCRuntimeClass@@B"},
    {6, "?classCDataPathProperty@CDataPathProperty@@2UCRuntimeClass@@B"},
    {2, "DllCanUnloadNow"},
    {1, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal mfplat[] = {
    {11, "CopyPropVariant"},
    {12, "CreatePropVariant"},
    {13, "CreatePropertyStore"},
    {14, "DestroyPropVariant"},
    {1, "FormatTagFromWfx"},
    {15, "GetAMSubtypeFromD3DFormat"},
    {16, "GetD3DFormatFromMFSubtype"},
    {17, "LFGetGlobalPool"},
    {18, "MFAddPeriodicCallback"},
    {19, "MFAllocateWorkQueue"},
    {20, "MFAllocateWorkQueueEx"},
    {21, "MFAppendCollection"},
    {22, "MFAverageTimePerFrameToFrameRate"},
    {23, "MFBeginCreateFile"},
    {24, "MFBeginGetHostByName"},
    {25, "MFBeginRegisterWorkQueueWithMMCSS"},
    {26, "MFBeginUnregisterWorkQueueWithMMCSS"},
    {27, "MFBlockThread"},
    {28, "MFCalculateBitmapImageSize"},
    {29, "MFCalculateImageSize"},
    {30, "MFCancelCreateFile"},
    {31, "MFCancelWorkItem"},
    {32, "MFCompareFullToPartialMediaType"},
    {33, "MFCompareSockaddrAddresses"},
    {34, "MFConvertColorInfoFromDXVA"},
    {35, "MFConvertColorInfoToDXVA"},
    {36, "MFConvertFromFP16Array"},
    {37, "MFConvertToFP16Array"},
    {38, "MFCopyImage"},
    {39, "MFCreateAMMediaTypeFromMFMediaType"},
    {40, "MFCreateAlignedMemoryBuffer"},
    {41, "MFCreateAsyncResult"},
    {42, "MFCreateAttributes"},
    {43, "MFCreateAudioMediaType"},
    {44, "MFCreateCollection"},
    {45, "MFCreateEventQueue"},
    {46, "MFCreateFile"},
    {2, "MFCreateGuid"},
    {47, "MFCreateLegacyMediaBufferOnMFMediaBuffer"},
    {48, "MFCreateMFByteStreamOnStream"},
    {49, "MFCreateMFVideoFormatFromMFMediaType"},
    {50, "MFCreateMediaBufferWrapper"},
    {51, "MFCreateMediaEvent"},
    {52, "MFCreateMediaType"},
    {53, "MFCreateMediaTypeFromRepresentation"},
    {54, "MFCreateMemoryBuffer"},
    {55, "MFCreateMemoryStream"},
    {56, "MFCreatePathFromURL"},
    {57, "MFCreatePresentationDescriptor"},
    {58, "MFCreateSample"},
    {59, "MFCreateSocket"},
    {60, "MFCreateSocketListener"},
    {61, "MFCreateSourceResolver"},
    {62, "MFCreateStreamDescriptor"},
    {63, "MFCreateSystemTimeSource"},
    {64, "MFCreateSystemUnderlyingClock"},
    {65, "MFCreateTempFile"},
    {66, "MFCreateTransformActivate"},
    {67, "MFCreateURLFromPath"},
    {68, "MFCreateUdpSockets"},
    {69, "MFCreateVideoMediaType"},
    {70, "MFCreateVideoMediaTypeFromBitMapInfoHeader"},
    {71, "MFCreateVideoMediaTypeFromBitMapInfoHeaderEx"},
    {72, "MFCreateVideoMediaTypeFromSubtype"},
    {74, "MFCreateVideoMediaTypeFromVideoInfoHeader"},
    {73, "MFCreateVideoMediaTypeFromVideoInfoHeader2"},
    {75, "MFCreateWaveFormatExFromMFMediaType"},
    {76, "MFDeserializeAttributesFromStream"},
    {77, "MFDeserializeEvent"},
    {78, "MFDeserializeMediaTypeFromStream"},
    {79, "MFDeserializePresentationDescriptor"},
    {80, "MFEndCreateFile"},
    {81, "MFEndGetHostByName"},
    {82, "MFEndRegisterWorkQueueWithMMCSS"},
    {83, "MFEndUnregisterWorkQueueWithMMCSS"},
    {84, "MFFrameRateToAverageTimePerFrame"},
    {85, "MFFreeAdaptersAddresses"},
    {86, "MFGetAdaptersAddresses"},
    {87, "MFGetAttributesAsBlob"},
    {88, "MFGetAttributesAsBlobSize"},
    {89, "MFGetConfigurationDWORD"},
    {90, "MFGetConfigurationPolicy"},
    {91, "MFGetConfigurationStore"},
    {92, "MFGetConfigurationString"},
    {3, "MFGetIoPortHandle"},
    {93, "MFGetMFTMerit"},
    {94, "MFGetNumericNameFromSockaddr"},
    {95, "MFGetPlaneSize"},
    {96, "MFGetPlatform"},
    {4, "MFGetPlatformVersion"},
    {97, "MFGetPluginControl"},
    {98, "MFGetPrivateWorkqueues"},
    {5, "MFGetRandomNumber"},
    {99, "MFGetSockaddrFromNumericName"},
    {100, "MFGetStrideForBitmapInfoHeader"},
    {101, "MFGetSystemTime"},
    {102, "MFGetTimerPeriodicity"},
    {103, "MFGetUncompressedVideoFormat"},
    {104, "MFGetWorkQueueMMCSSClass"},
    {105, "MFGetWorkQueueMMCSSTaskId"},
    {106, "MFHeapAlloc"},
    {107, "MFHeapFree"},
    {108, "MFInitAMMediaTypeFromMFMediaType"},
    {109, "MFInitAttributesFromBlob"},
    {110, "MFInitMediaTypeFromAMMediaType"},
    {111, "MFInitMediaTypeFromMFVideoFormat"},
    {112, "MFInitMediaTypeFromMPEG1VideoInfo"},
    {113, "MFInitMediaTypeFromMPEG2VideoInfo"},
    {115, "MFInitMediaTypeFromVideoInfoHeader"},
    {114, "MFInitMediaTypeFromVideoInfoHeader2"},
    {116, "MFInitMediaTypeFromWaveFormatEx"},
    {117, "MFInitVideoFormat"},
    {118, "MFInitVideoFormat_RGB"},
    {119, "MFInvokeCallback"},
    {6, "MFIsFeatureEnabled"},
    {7, "MFIsQueueThread"},
    {120, "MFJoinIoPort"},
    {121, "MFLockPlatform"},
    {122, "MFLockWorkQueue"},
    {8, "MFPlatformBigEndian"},
    {9, "MFPlatformLittleEndian"},
    {123, "MFPutWorkItem"},
    {124, "MFPutWorkItemEx"},
    {125, "MFRecordError"},
    {126, "MFRemovePeriodicCallback"},
    {127, "MFScheduleWorkItem"},
    {128, "MFScheduleWorkItemEx"},
    {129, "MFSerializeAttributesToStream"},
    {130, "MFSerializeEvent"},
    {131, "MFSerializeMediaTypeToStream"},
    {132, "MFSerializePresentationDescriptor"},
    {133, "MFSetSockaddrAny"},
    {134, "MFShutdown"},
    {135, "MFStartup"},
    {136, "MFStreamDescriptorProtectMediaType"},
    {137, "MFTEnum"},
    {138, "MFTEnumEx"},
    {139, "MFTGetInfo"},
    {140, "MFTRegister"},
    {141, "MFTRegisterLocal"},
    {142, "MFTRegisterLocalByCLSID"},
    {143, "MFTUnregister"},
    {144, "MFTUnregisterLocal"},
    {145, "MFTUnregisterLocalByCLSID"},
    {146, "MFTraceError"},
    {147, "MFTraceFuncEnter"},
    {148, "MFUnblockThread"},
    {149, "MFUnlockPlatform"},
    {150, "MFUnlockWorkQueue"},
    {151, "MFUnwrapMediaType"},
    {152, "MFValidateMediaTypeSize"},
    {153, "MFWrapMediaType"},
    {154, "MFllMulDiv"},
    {155, "PropVariantFromStream"},
    {156, "PropVariantToStream"},
    {10, "ValidateWaveFormat"},
    {0, NULL}};
static Dw32Ordinal mgmtapi[] = {
    {1, "SnmpMgrClose"},
    {2, "SnmpMgrCtl"},
    {3, "SnmpMgrGetTrap"},
    {4, "SnmpMgrGetTrapEx"},
    {5, "SnmpMgrOidToStr"},
    {6, "SnmpMgrOpen"},
    {7, "SnmpMgrRequest"},
    {8, "SnmpMgrStrToOid"},
    {9, "SnmpMgrTrapListen"},
    {0, NULL}};
static Dw32Ordinal mpr[] = {
    {3, "I_MprSaveConn"},
    {4, "MultinetGetConnectionPerformanceA"},
    {5, "MultinetGetConnectionPerformanceW"},
    {6, "MultinetGetErrorTextA"},
    {7, "MultinetGetErrorTextW"},
    {8, "WNetAddConnection2A"},
    {9, "WNetAddConnection2W"},
    {10, "WNetAddConnection3A"},
    {11, "WNetAddConnection3W"},
    {12, "WNetAddConnectionA"},
    {13, "WNetAddConnectionW"},
    {14, "WNetCancelConnection2A"},
    {15, "WNetCancelConnection2W"},
    {16, "WNetCancelConnectionA"},
    {17, "WNetCancelConnectionW"},
    {18, "WNetClearConnections"},
    {19, "WNetCloseEnum"},
    {22, "WNetConnectionDialog"},
    {20, "WNetConnectionDialog1A"},
    {21, "WNetConnectionDialog1W"},
    {1, "WNetConnectionDialog2"},
    {23, "WNetDirectoryNotifyA"},
    {24, "WNetDirectoryNotifyW"},
    {27, "WNetDisconnectDialog"},
    {25, "WNetDisconnectDialog1A"},
    {26, "WNetDisconnectDialog1W"},
    {2, "WNetDisconnectDialog2"},
    {28, "WNetEnumResourceA"},
    {29, "WNetEnumResourceW"},
    {30, "WNetFormatNetworkNameA"},
    {31, "WNetFormatNetworkNameW"},
    {32, "WNetGetConnection2A"},
    {33, "WNetGetConnection2W"},
    {34, "WNetGetConnection3A"},
    {35, "WNetGetConnection3W"},
    {36, "WNetGetConnectionA"},
    {37, "WNetGetConnectionW"},
    {38, "WNetGetDirectoryTypeA"},
    {39, "WNetGetDirectoryTypeW"},
    {40, "WNetGetHomeDirectoryW"},
    {41, "WNetGetLastErrorA"},
    {42, "WNetGetLastErrorW"},
    {43, "WNetGetNetworkInformationA"},
    {44, "WNetGetNetworkInformationW"},
    {45, "WNetGetPropertyTextA"},
    {46, "WNetGetPropertyTextW"},
    {47, "WNetGetProviderNameA"},
    {48, "WNetGetProviderNameW"},
    {49, "WNetGetProviderTypeA"},
    {50, "WNetGetProviderTypeW"},
    {51, "WNetGetResourceInformationA"},
    {52, "WNetGetResourceInformationW"},
    {53, "WNetGetResourceParentA"},
    {54, "WNetGetResourceParentW"},
    {55, "WNetGetSearchDialog"},
    {56, "WNetGetUniversalNameA"},
    {57, "WNetGetUniversalNameW"},
    {58, "WNetGetUserA"},
    {59, "WNetGetUserW"},
    {60, "WNetLogonNotify"},
    {61, "WNetOpenEnumA"},
    {62, "WNetOpenEnumW"},
    {63, "WNetPasswordChangeNotify"},
    {64, "WNetPropertyDialogA"},
    {65, "WNetPropertyDialogW"},
    {66, "WNetRestoreAllConnectionsW"},
    {67, "WNetRestoreSingleConnectionW"},
    {68, "WNetSetConnectionA"},
    {69, "WNetSetConnectionW"},
    {70, "WNetSetLastErrorA"},
    {71, "WNetSetLastErrorW"},
    {72, "WNetSupportGlobalEnum"},
    {73, "WNetUseConnectionA"},
    {74, "WNetUseConnectionW"},
    {0, NULL}};
static Dw32Ordinal mprapi[] = {
    {1, "CompressPhoneNumber"},
    {2, "MprAdminBufferFree"},
    {3, "MprAdminConnectionClearStats"},
    {4, "MprAdminConnectionEnum"},
    {5, "MprAdminConnectionEnumEx"},
    {6, "MprAdminConnectionGetInfo"},
    {7, "MprAdminConnectionGetInfoEx"},
    {8, "MprAdminConnectionRemoveQuarantine"},
    {9, "MprAdminDeregisterConnectionNotification"},
    {10, "MprAdminDeviceEnum"},
    {11, "MprAdminEstablishDomainRasServer"},
    {12, "MprAdminGetErrorString"},
    {13, "MprAdminGetPDCServer"},
    {14, "MprAdminInterfaceConnect"},
    {15, "MprAdminInterfaceCreate"},
    {16, "MprAdminInterfaceDelete"},
    {17, "MprAdminInterfaceDeviceGetInfo"},
    {18, "MprAdminInterfaceDeviceSetInfo"},
    {19, "MprAdminInterfaceDisconnect"},
    {20, "MprAdminInterfaceEnum"},
    {21, "MprAdminInterfaceGetCredentials"},
    {22, "MprAdminInterfaceGetCredentialsEx"},
    {23, "MprAdminInterfaceGetHandle"},
    {24, "MprAdminInterfaceGetInfo"},
    {25, "MprAdminInterfaceQueryUpdateResult"},
    {26, "MprAdminInterfaceSetCredentials"},
    {27, "MprAdminInterfaceSetCredentialsEx"},
    {28, "MprAdminInterfaceSetInfo"},
    {29, "MprAdminInterfaceTransportAdd"},
    {30, "MprAdminInterfaceTransportGetInfo"},
    {31, "MprAdminInterfaceTransportRemove"},
    {32, "MprAdminInterfaceTransportSetInfo"},
    {33, "MprAdminInterfaceUpdatePhonebookInfo"},
    {34, "MprAdminInterfaceUpdateRoutes"},
    {35, "MprAdminIsDomainRasServer"},
    {36, "MprAdminIsServiceInitialized"},
    {37, "MprAdminIsServiceRunning"},
    {38, "MprAdminMIBBufferFree"},
    {39, "MprAdminMIBEntryCreate"},
    {40, "MprAdminMIBEntryDelete"},
    {41, "MprAdminMIBEntryGet"},
    {42, "MprAdminMIBEntryGetFirst"},
    {43, "MprAdminMIBEntryGetNext"},
    {44, "MprAdminMIBEntrySet"},
    {45, "MprAdminMIBServerConnect"},
    {46, "MprAdminMIBServerDisconnect"},
    {47, "MprAdminPortClearStats"},
    {48, "MprAdminPortDisconnect"},
    {49, "MprAdminPortEnum"},
    {50, "MprAdminPortGetInfo"},
    {51, "MprAdminPortReset"},
    {52, "MprAdminRegisterConnectionNotification"},
    {53, "MprAdminSendUserMessage"},
    {54, "MprAdminServerConnect"},
    {55, "MprAdminServerDisconnect"},
    {56, "MprAdminServerGetCredentials"},
    {57, "MprAdminServerGetInfo"},
    {58, "MprAdminServerGetInfoEx"},
    {59, "MprAdminServerSetCredentials"},
    {60, "MprAdminServerSetInfo"},
    {61, "MprAdminServerSetInfoEx"},
    {62, "MprAdminTransportCreate"},
    {63, "MprAdminTransportGetInfo"},
    {64, "MprAdminTransportSetInfo"},
    {65, "MprAdminUpdateConnection"},
    {66, "MprAdminUpgradeUsers"},
    {67, "MprAdminUserClose"},
    {68, "MprAdminUserGetInfo"},
    {69, "MprAdminUserOpen"},
    {70, "MprAdminUserRead"},
    {71, "MprAdminUserReadProfFlags"},
    {72, "MprAdminUserServerConnect"},
    {73, "MprAdminUserServerDisconnect"},
    {74, "MprAdminUserSetInfo"},
    {75, "MprAdminUserWrite"},
    {76, "MprAdminUserWriteProfFlags"},
    {77, "MprConfigBufferFree"},
    {78, "MprConfigFilterGetInfo"},
    {79, "MprConfigFilterSetInfo"},
    {80, "MprConfigGetFriendlyName"},
    {81, "MprConfigGetGuidName"},
    {82, "MprConfigInterfaceCreate"},
    {83, "MprConfigInterfaceDelete"},
    {84, "MprConfigInterfaceEnum"},
    {85, "MprConfigInterfaceGetHandle"},
    {86, "MprConfigInterfaceGetInfo"},
    {87, "MprConfigInterfaceSetInfo"},
    {88, "MprConfigInterfaceTransportAdd"},
    {89, "MprConfigInterfaceTransportEnum"},
    {90, "MprConfigInterfaceTransportGetHandle"},
    {91, "MprConfigInterfaceTransportGetInfo"},
    {92, "MprConfigInterfaceTransportRemove"},
    {93, "MprConfigInterfaceTransportSetInfo"},
    {94, "MprConfigServerBackup"},
    {95, "MprConfigServerConnect"},
    {96, "MprConfigServerDisconnect"},
    {97, "MprConfigServerGetInfo"},
    {98, "MprConfigServerGetInfoEx"},
    {99, "MprConfigServerInstall"},
    {100, "MprConfigServerRefresh"},
    {101, "MprConfigServerRestore"},
    {102, "MprConfigServerSetInfo"},
    {103, "MprConfigServerSetInfoEx"},
    {104, "MprConfigTransportCreate"},
    {105, "MprConfigTransportDelete"},
    {106, "MprConfigTransportEnum"},
    {107, "MprConfigTransportGetHandle"},
    {108, "MprConfigTransportGetInfo"},
    {109, "MprConfigTransportSetInfo"},
    {110, "MprDomainQueryRasServer"},
    {111, "MprDomainRegisterRasServer"},
    {112, "MprGetUsrParams"},
    {113, "MprInfoBlockAdd"},
    {114, "MprInfoBlockFind"},
    {115, "MprInfoBlockQuerySize"},
    {116, "MprInfoBlockRemove"},
    {117, "MprInfoBlockSet"},
    {118, "MprInfoCreate"},
    {119, "MprInfoDelete"},
    {120, "MprInfoDuplicate"},
    {121, "MprInfoRemoveAll"},
    {122, "MprPortSetUsage"},
    {123, "RasPrivilegeAndCallBackNumber"},
    {0, NULL}};
static Dw32Ordinal msacm32[] = {
    {1, "XRegThunkEntry"},
    {2, "acmDriverAddA"},
    {3, "acmDriverAddW"},
    {4, "acmDriverClose"},
    {5, "acmDriverDetailsA"},
    {6, "acmDriverDetailsW"},
    {7, "acmDriverEnum"},
    {8, "acmDriverID"},
    {9, "acmDriverMessage"},
    {10, "acmDriverOpen"},
    {11, "acmDriverPriority"},
    {12, "acmDriverRemove"},
    {13, "acmFilterChooseA"},
    {14, "acmFilterChooseW"},
    {15, "acmFilterDetailsA"},
    {16, "acmFilterDetailsW"},
    {17, "acmFilterEnumA"},
    {18, "acmFilterEnumW"},
    {19, "acmFilterTagDetailsA"},
    {20, "acmFilterTagDetailsW"},
    {21, "acmFilterTagEnumA"},
    {22, "acmFilterTagEnumW"},
    {23, "acmFormatChooseA"},
    {24, "acmFormatChooseW"},
    {25, "acmFormatDetailsA"},
    {26, "acmFormatDetailsW"},
    {27, "acmFormatEnumA"},
    {28, "acmFormatEnumW"},
    {29, "acmFormatSuggest"},
    {30, "acmFormatTagDetailsA"},
    {31, "acmFormatTagDetailsW"},
    {32, "acmFormatTagEnumA"},
    {33, "acmFormatTagEnumW"},
    {34, "acmGetVersion"},
    {35, "acmMessage32"},
    {36, "acmMetrics"},
    {37, "acmStreamClose"},
    {38, "acmStreamConvert"},
    {39, "acmStreamMessage"},
    {40, "acmStreamOpen"},
    {41, "acmStreamPrepareHeader"},
    {42, "acmStreamReset"},
    {43, "acmStreamSize"},
    {44, "acmStreamUnprepareHeader"},
    {0, NULL}};
static Dw32Ordinal mscms[] = {
    {1, "AssociateColorProfileWithDeviceA"},
    {2, "AssociateColorProfileWithDeviceW"},
    {3, "CheckBitmapBits"},
    {4, "CheckColors"},
    {5, "CloseColorProfile"},
    {6, "CloseDisplay"},
    {7, "ColorCplGetDefaultProfileScope"},
    {8, "ColorCplGetDefaultRenderingIntentScope"},
    {9, "ColorCplGetProfileProperties"},
    {10, "ColorCplHasSystemWideAssociationListChanged"},
    {11, "ColorCplInitialize"},
    {12, "ColorCplLoadAssociationList"},
    {13, "ColorCplMergeAssociationLists"},
    {14, "ColorCplOverwritePerUserAssociationList"},
    {15, "ColorCplReleaseProfileProperties"},
    {16, "ColorCplResetSystemWideAssociationListChangedWarning"},
    {17, "ColorCplSaveAssociationList"},
    {18, "ColorCplSetUsePerUserProfiles"},
    {19, "ColorCplUninitialize"},
    {20, "ConvertColorNameToIndex"},
    {21, "ConvertIndexToColorName"},
    {22, "CreateColorTransformA"},
    {23, "CreateColorTransformW"},
    {24, "CreateDeviceLinkProfile"},
    {25, "CreateMultiProfileTransform"},
    {26, "CreateProfileFromLogColorSpaceA"},
    {27, "CreateProfileFromLogColorSpaceW"},
    {28, "DccwCreateDisplayProfileAssociationList"},
    {29, "DccwGetDisplayProfileAssociationList"},
    {30, "DccwGetGamutSize"},
    {31, "DccwReleaseDisplayProfileAssociationList"},
    {32, "DccwSetDisplayProfileAssociationList"},
    {33, "DeleteColorTransform"},
    {34, "DeviceRenameEvent"},
    {35, "DisassociateColorProfileFromDeviceA"},
    {36, "DisassociateColorProfileFromDeviceW"},
    {37, "DllCanUnloadNow"},
    {38, "DllGetClassObject"},
    {39, "EnumColorProfilesA"},
    {40, "EnumColorProfilesW"},
    {41, "GenerateCopyFilePaths"},
    {42, "GetCMMInfo"},
    {43, "GetColorDirectoryA"},
    {44, "GetColorDirectoryW"},
    {45, "GetColorProfileElement"},
    {46, "GetColorProfileElementTag"},
    {47, "GetColorProfileFromHandle"},
    {48, "GetColorProfileHeader"},
    {49, "GetCountColorProfileElements"},
    {50, "GetNamedProfileInfo"},
    {51, "GetPS2ColorRenderingDictionary"},
    {52, "GetPS2ColorRenderingIntent"},
    {53, "GetPS2ColorSpaceArray"},
    {54, "GetStandardColorSpaceProfileA"},
    {55, "GetStandardColorSpaceProfileW"},
    {56, "InstallColorProfileA"},
    {57, "InstallColorProfileW"},
    {58, "InternalGetDeviceConfig"},
    {59, "InternalGetPS2CSAFromLCS"},
    {60, "InternalGetPS2ColorRenderingDictionary"},
    {61, "InternalGetPS2ColorSpaceArray"},
    {62, "InternalGetPS2PreviewCRD"},
    {63, "InternalRefreshCalibration"},
    {64, "InternalSetDeviceConfig"},
    {65, "InternalWcsAssociateColorProfileWithDevice"},
    {66, "IsColorProfileTagPresent"},
    {67, "IsColorProfileValid"},
    {68, "OpenColorProfileA"},
    {69, "OpenColorProfileW"},
    {70, "OpenDisplay"},
    {71, "RegisterCMMA"},
    {72, "RegisterCMMW"},
    {73, "SelectCMM"},
    {74, "SetColorProfileElement"},
    {75, "SetColorProfileElementReference"},
    {76, "SetColorProfileElementSize"},
    {77, "SetColorProfileHeader"},
    {78, "SetStandardColorSpaceProfileA"},
    {79, "SetStandardColorSpaceProfileW"},
    {80, "SpoolerCopyFileEvent"},
    {81, "TranslateBitmapBits"},
    {82, "TranslateColors"},
    {83, "UninstallColorProfileA"},
    {84, "UninstallColorProfileW"},
    {85, "UnregisterCMMA"},
    {86, "UnregisterCMMW"},
    {87, "WcsAssociateColorProfileWithDevice"},
    {88, "WcsCheckColors"},
    {89, "WcsCreateIccProfile"},
    {90, "WcsDisassociateColorProfileFromDevice"},
    {91, "WcsEnumColorProfiles"},
    {92, "WcsEnumColorProfilesSize"},
    {93, "WcsGetCalibrationManagementState"},
    {94, "WcsGetDefaultColorProfile"},
    {95, "WcsGetDefaultColorProfileSize"},
    {96, "WcsGetDefaultRenderingIntent"},
    {97, "WcsGetUsePerUserProfiles"},
    {98, "WcsGpCanInstallOrUninstallProfiles"},
    {99, "WcsOpenColorProfileA"},
    {100, "WcsOpenColorProfileW"},
    {101, "WcsSetCalibrationManagementState"},
    {102, "WcsSetDefaultColorProfile"},
    {103, "WcsSetDefaultRenderingIntent"},
    {104, "WcsSetUsePerUserProfiles"},
    {105, "WcsTranslateColors"},
    {0, NULL}};
static Dw32Ordinal mscoree[] = {
    {37, "CallFunctionShim"},
    {21, "CloseCtrs"},
    {38, "ClrCreateManagedInstance"},
    {39, "CoEEShutDownCOM"},
    {40, "CoInitializeCor"},
    {41, "CoInitializeEE"},
    {42, "CoUninitializeCor"},
    {43, "CoUninitializeEE"},
    {24, "CollectCtrs"},
    {44, "CorBindToCurrentRuntime"},
    {45, "CorBindToRuntime"},
    {46, "CorBindToRuntimeByCfg"},
    {47, "CorBindToRuntimeByPath"},
    {48, "CorBindToRuntimeByPathEx"},
    {49, "CorBindToRuntimeEx"},
    {50, "CorBindToRuntimeHost"},
    {25, "CorDllMainWorker"},
    {51, "CorExitProcess"},
    {52, "CorGetSvc"},
    {53, "CorIsLatestSvc"},
    {54, "CorMarkThreadInThreadPool"},
    {55, "CorTickleSvc"},
    {56, "CreateConfigStream"},
    {57, "CreateDebuggingInterfaceFromVersion"},
    {58, "DllCanUnloadNow"},
    {59, "DllGetClassObject"},
    {60, "DllRegisterServer"},
    {61, "DllUnregisterServer"},
    {26, "EEDllGetClassObjectFromClass"},
    {62, "EEDllRegisterServer"},
    {63, "EEDllUnregisterServer"},
    {64, "GetAssemblyMDImport"},
    {65, "GetCORRequiredVersion"},
    {66, "GetCORRootDirectory"},
    {67, "GetCORSystemDirectory"},
    {68, "GetCORVersion"},
    {69, "GetCompileInfo"},
    {70, "GetFileVersion"},
    {71, "GetHashFromAssemblyFile"},
    {72, "GetHashFromAssemblyFileW"},
    {73, "GetHashFromBlob"},
    {74, "GetHashFromFile"},
    {75, "GetHashFromFileW"},
    {76, "GetHashFromHandle"},
    {77, "GetHostConfigurationFile"},
    {78, "GetMetaDataInternalInterface"},
    {79, "GetMetaDataInternalInterfaceFromPublic"},
    {80, "GetMetaDataPublicInterfaceFromInternal"},
    {81, "GetPermissionRequests"},
    {27, "GetPrivateContextsPerfCounters"},
    {28, "GetProcessExecutableHeap"},
    {82, "GetRealProcAddress"},
    {83, "GetRequestedRuntimeInfo"},
    {84, "GetRequestedRuntimeVersion"},
    {85, "GetRequestedRuntimeVersionForCLSID"},
    {29, "GetStartupFlags"},
    {30, "GetTargetForVTableEntry"},
    {31, "GetTokenForVTableEntry"},
    {86, "GetVersionFromProcess"},
    {87, "GetXMLElement"},
    {88, "GetXMLElementAttribute"},
    {89, "GetXMLObject"},
    {90, "IEE"},
    {17, "InitErrors"},
    {19, "InitSSAutoEnterThread"},
    {91, "LoadLibraryShim"},
    {92, "LoadLibraryWithPolicyShim"},
    {22, "LoadStringRC"},
    {93, "LoadStringRCEx"},
    {94, "LockClrVersion"},
    {32, "LogHelp_LogAssert"},
    {33, "LogHelp_NoGuiOnAssert"},
    {34, "LogHelp_TerminateOnAssert"},
    {95, "MetaDataGetDispenser"},
    {96, "ND_CopyObjDst"},
    {97, "ND_CopyObjSrc"},
    {98, "ND_RI2"},
    {99, "ND_RI4"},
    {100, "ND_RI8"},
    {101, "ND_RU1"},
    {102, "ND_WI2"},
    {103, "ND_WI4"},
    {104, "ND_WI8"},
    {105, "ND_WU1"},
    {35, "OpenCtrs"},
    {18, "PostError"},
    {23, "ReOpenMetaDataWithMemory"},
    {106, "ReOpenMetaDataWithMemoryEx"},
    {107, "RunDll32ShimW"},
    {108, "RuntimeOSHandle"},
    {109, "RuntimeOpenImage"},
    {110, "RuntimeReleaseHandle"},
    {36, "SetTargetForVTableEntry"},
    {111, "StrongNameCompareAssemblies"},
    {112, "StrongNameErrorInfo"},
    {113, "StrongNameFreeBuffer"},
    {114, "StrongNameGetBlob"},
    {115, "StrongNameGetBlobFromImage"},
    {116, "StrongNameGetPublicKey"},
    {117, "StrongNameHashSize"},
    {118, "StrongNameKeyDelete"},
    {119, "StrongNameKeyGen"},
    {120, "StrongNameKeyGenEx"},
    {121, "StrongNameKeyInstall"},
    {122, "StrongNameSignatureGeneration"},
    {123, "StrongNameSignatureGenerationEx"},
    {124, "StrongNameSignatureSize"},
    {125, "StrongNameSignatureVerification"},
    {126, "StrongNameSignatureVerificationEx"},
    {127, "StrongNameSignatureVerificationFromImage"},
    {128, "StrongNameTokenFromAssembly"},
    {129, "StrongNameTokenFromAssemblyEx"},
    {130, "StrongNameTokenFromPublicKey"},
    {131, "TranslateSecurityAttributes"},
    {20, "UpdateError"},
    {132, "_CorDllMain"},
    {134, "_CorExeMain"},
    {133, "_CorExeMain2"},
    {135, "_CorImageUnloading"},
    {136, "_CorValidateImage"},
    {0, NULL}};
static Dw32Ordinal msctfmonitor[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {5, "DoMsCtfMonitor"},
    {6, "InitLocalMsCtfMonitor"},
    {7, "UninitLocalMsCtfMonitor"},
    {0, NULL}};
static Dw32Ordinal msdelta[] = {
    {1, "ApplyDeltaA"},
    {2, "ApplyDeltaB"},
    {3, "ApplyDeltaProvidedB"},
    {4, "ApplyDeltaW"},
    {5, "CreateDeltaA"},
    {6, "CreateDeltaB"},
    {7, "CreateDeltaW"},
    {8, "DeltaFree"},
    {9, "DeltaNormalizeProvidedB"},
    {10, "GetDeltaInfoA"},
    {11, "GetDeltaInfoB"},
    {12, "GetDeltaInfoW"},
    {13, "GetDeltaSignatureA"},
    {14, "GetDeltaSignatureB"},
    {15, "GetDeltaSignatureW"},
    {0, NULL}};
static Dw32Ordinal msdmo[] = {
    {1, "DMOEnum"},
    {2, "DMOGetName"},
    {3, "DMOGetTypes"},
    {4, "DMOGuidToStrA"},
    {5, "DMOGuidToStrW"},
    {6, "DMORegister"},
    {7, "DMOStrToGuidA"},
    {8, "DMOStrToGuidW"},
    {9, "DMOUnregister"},
    {10, "MoCopyMediaType"},
    {11, "MoCreateMediaType"},
    {12, "MoDeleteMediaType"},
    {13, "MoDuplicateMediaType"},
    {14, "MoFreeMediaType"},
    {15, "MoInitMediaType"},
    {0, NULL}};
static Dw32Ordinal msdrm[] = {
    {1, "DRMAcquireAdvisories"},
    {2, "DRMAcquireIssuanceLicenseTemplate"},
    {3, "DRMAcquireLicense"},
    {4, "DRMActivate"},
    {5, "DRMAddLicense"},
    {6, "DRMAddRightWithUser"},
    {7, "DRMAttest"},
    {8, "DRMCheckSecurity"},
    {9, "DRMClearAllRights"},
    {10, "DRMCloseEnvironmentHandle"},
    {11, "DRMCloseHandle"},
    {12, "DRMClosePubHandle"},
    {13, "DRMCloseQueryHandle"},
    {14, "DRMCloseSession"},
    {15, "DRMConstructCertificateChain"},
    {16, "DRMCreateBoundLicense"},
    {17, "DRMCreateClientSession"},
    {18, "DRMCreateEnablingBitsDecryptor"},
    {19, "DRMCreateEnablingBitsEncryptor"},
    {20, "DRMCreateEnablingPrincipal"},
    {21, "DRMCreateIssuanceLicense"},
    {22, "DRMCreateLicenseStorageSession"},
    {23, "DRMCreateRight"},
    {24, "DRMCreateUser"},
    {25, "DRMDecode"},
    {26, "DRMDeconstructCertificateChain"},
    {27, "DRMDecrypt"},
    {28, "DRMDeleteLicense"},
    {29, "DRMDuplicateEnvironmentHandle"},
    {30, "DRMDuplicateHandle"},
    {31, "DRMDuplicatePubHandle"},
    {32, "DRMDuplicateSession"},
    {33, "DRMEncode"},
    {34, "DRMEncrypt"},
    {35, "DRMEnumerateLicense"},
    {36, "DRMGetApplicationSpecificData"},
    {37, "DRMGetBoundLicenseAttribute"},
    {38, "DRMGetBoundLicenseAttributeCount"},
    {39, "DRMGetBoundLicenseObject"},
    {40, "DRMGetBoundLicenseObjectCount"},
    {41, "DRMGetCertificateChainCount"},
    {42, "DRMGetClientVersion"},
    {43, "DRMGetEnvironmentInfo"},
    {44, "DRMGetInfo"},
    {45, "DRMGetIntervalTime"},
    {46, "DRMGetIssuanceLicenseInfo"},
    {47, "DRMGetIssuanceLicenseTemplate"},
    {48, "DRMGetMetaData"},
    {49, "DRMGetNameAndDescription"},
    {50, "DRMGetOwnerLicense"},
    {51, "DRMGetProcAddress"},
    {52, "DRMGetRevocationPoint"},
    {53, "DRMGetRightExtendedInfo"},
    {54, "DRMGetRightInfo"},
    {55, "DRMGetSecurityProvider"},
    {56, "DRMGetServiceLocation"},
    {57, "DRMGetSignedIssuanceLicense"},
    {58, "DRMGetSignedIssuanceLicenseEx"},
    {59, "DRMGetTime"},
    {60, "DRMGetUnboundLicenseAttribute"},
    {61, "DRMGetUnboundLicenseAttributeCount"},
    {62, "DRMGetUnboundLicenseObject"},
    {63, "DRMGetUnboundLicenseObjectCount"},
    {64, "DRMGetUsagePolicy"},
    {65, "DRMGetUserInfo"},
    {66, "DRMGetUserRights"},
    {67, "DRMGetUsers"},
    {68, "DRMInitEnvironment"},
    {69, "DRMIsActivated"},
    {70, "DRMIsWindowProtected"},
    {71, "DRMLoadLibrary"},
    {72, "DRMParseUnboundLicense"},
    {73, "DRMRegisterContent"},
    {74, "DRMRegisterProtectedWindow"},
    {75, "DRMRegisterRevocationList"},
    {76, "DRMRepair"},
    {77, "DRMSetApplicationSpecificData"},
    {78, "DRMSetGlobalOptions"},
    {79, "DRMSetIntervalTime"},
    {80, "DRMSetMetaData"},
    {81, "DRMSetNameAndDescription"},
    {82, "DRMSetRevocationPoint"},
    {83, "DRMSetUsagePolicy"},
    {84, "DRMVerify"},
    {85, "DllCanUnloadNow"},
    {86, "DllGetClassObject"},
    {87, "DllRegisterServer"},
    {88, "DllUnregisterServer"},
    {89, "__AddMachineCertToLicenseStore"},
    {0, NULL}};
static Dw32Ordinal msdtcprx[] = {
    {5, "?Create@CNameService@@SGJPAPAV1@@Z"},
    {6, "?CreateInstance@CTmProxyCore@@SGJPAPAV1@PAUIUnknown@@@Z"},
    {7, "?DeployDtc@@YGJXZ"},
    {8, "?GetDtcLogPath@@YGHKPAG@Z"},
    {9, "?InstallContacts@@YGJPAUITmInstance@@@Z"},
    {20, "?InstallDtc@@YGJPAUITmInstance@@PAG111KK1H@Z"},
    {21, "?InstallDtcClient@@YGJPAGKK@Z"},
    {22, "?RemoveDtc@@YGJPAG00@Z"},
    {27, "ContactToNameObject"},
    {31, "CreateLegacyTmInstance"},
    {32, "CreateLocalTmInstance"},
    {33, "CreateRemoteProxyTmInstance"},
    {34, "CreateTmInstanceForRemoteAdmin"},
    {19, "DTC_XaClose"},
    {14, "DTC_XaCommit"},
    {18, "DTC_XaComplete"},
    {12, "DTC_XaEnd"},
    {17, "DTC_XaForget"},
    {10, "DTC_XaOpen"},
    {13, "DTC_XaPrepare"},
    {16, "DTC_XaRecover"},
    {15, "DTC_XaRollback"},
    {11, "DTC_XaStart"},
    {35, "DllGetClassObject"},
    {25, "DllGetDTCConnectionManager"},
    {4, "DllGetDTCProxy"},
    {26, "DllGetDTCUtilObject"},
    {36, "DllGetTransactionManagerCore"},
    {37, "DllRegisterServer"},
    {38, "DllUnregisterServer"},
    {39, "GetTmInstance"},
    {24, "ShutDownCM"},
    {28, "SysPrepDtcCleanup"},
    {29, "SysPrepDtcGeneralize"},
    {30, "SysPrepDtcSpecialize"},
    {23, "UpgradeApplySuccess"},
    {0, NULL}};
static Dw32Ordinal msdtctm[] = {
    {9, "?CreateInstance@CTm@@SGJPAPAV1@PAUIUnknown@@@Z"},
    {7, "ASCDefer"},
    {6, "ASCDeliverDeferred"},
    {8, "ASCGetSafeReference"},
    {10, "ASCWrapClassFactory"},
    {5, "ASCWrapObject"},
    {11, "DllGetClassObject"},
    {4, "DtcMainExt"},
    {12, "_GetTipFunctionalityWorking@0"},
    {13, "_SetTipFunctionalityWorking@4"},
    {0, NULL}};
static Dw32Ordinal msi[] = {
    {296, "DllCanUnloadNow"},
    {297, "DllGetClassObject"},
    {182, "DllGetVersion"},
    {298, "DllRegisterServer"},
    {299, "DllUnregisterServer"},
    {235, "Migrate10CachedPackagesA"},
    {236, "Migrate10CachedPackagesW"},
    {5, "MsiAdvertiseProductA"},
    {227, "MsiAdvertiseProductExA"},
    {228, "MsiAdvertiseProductExW"},
    {6, "MsiAdvertiseProductW"},
    {176, "MsiAdvertiseScriptA"},
    {177, "MsiAdvertiseScriptW"},
    {239, "MsiApplyMultiplePatchesA"},
    {240, "MsiApplyMultiplePatchesW"},
    {174, "MsiApplyPatchA"},
    {175, "MsiApplyPatchW"},
    {284, "MsiBeginTransactionA"},
    {285, "MsiBeginTransactionW"},
    {7, "MsiCloseAllHandles"},
    {8, "MsiCloseHandle"},
    {9, "MsiCollectUserInfoA"},
    {10, "MsiCollectUserInfoW"},
    {11, "MsiConfigureFeatureA"},
    {12, "MsiConfigureFeatureFromDescriptorA"},
    {13, "MsiConfigureFeatureFromDescriptorW"},
    {14, "MsiConfigureFeatureW"},
    {15, "MsiConfigureProductA"},
    {189, "MsiConfigureProductExA"},
    {190, "MsiConfigureProductExW"},
    {16, "MsiConfigureProductW"},
    {222, "MsiCreateAndVerifyInstallerDirectory"},
    {17, "MsiCreateRecord"},
    {185, "MsiCreateTransformSummaryInfoA"},
    {186, "MsiCreateTransformSummaryInfoW"},
    {18, "MsiDatabaseApplyTransformA"},
    {19, "MsiDatabaseApplyTransformW"},
    {20, "MsiDatabaseCommit"},
    {21, "MsiDatabaseExportA"},
    {22, "MsiDatabaseExportW"},
    {23, "MsiDatabaseGenerateTransformA"},
    {24, "MsiDatabaseGenerateTransformW"},
    {25, "MsiDatabaseGetPrimaryKeysA"},
    {26, "MsiDatabaseGetPrimaryKeysW"},
    {27, "MsiDatabaseImportA"},
    {28, "MsiDatabaseImportW"},
    {164, "MsiDatabaseIsTablePersistentA"},
    {165, "MsiDatabaseIsTablePersistentW"},
    {29, "MsiDatabaseMergeA"},
    {30, "MsiDatabaseMergeW"},
    {31, "MsiDatabaseOpenViewA"},
    {32, "MsiDatabaseOpenViewW"},
    {200, "MsiDecomposeDescriptorA"},
    {201, "MsiDecomposeDescriptorW"},
    {233, "MsiDeleteUserDataA"},
    {234, "MsiDeleteUserDataW"},
    {277, "MsiDetermineApplicablePatchesA"},
    {278, "MsiDetermineApplicablePatchesW"},
    {253, "MsiDeterminePatchSequenceA"},
    {254, "MsiDeterminePatchSequenceW"},
    {33, "MsiDoActionA"},
    {34, "MsiDoActionW"},
    {168, "MsiEnableLogA"},
    {169, "MsiEnableLogW"},
    {35, "MsiEnableUIPreview"},
    {286, "MsiEndTransaction"},
    {36, "MsiEnumClientsA"},
    {291, "MsiEnumClientsExA"},
    {292, "MsiEnumClientsExW"},
    {37, "MsiEnumClientsW"},
    {220, "MsiEnumComponentCostsA"},
    {221, "MsiEnumComponentCostsW"},
    {38, "MsiEnumComponentQualifiersA"},
    {39, "MsiEnumComponentQualifiersW"},
    {40, "MsiEnumComponentsA"},
    {289, "MsiEnumComponentsExA"},
    {290, "MsiEnumComponentsExW"},
    {41, "MsiEnumComponentsW"},
    {42, "MsiEnumFeaturesA"},
    {43, "MsiEnumFeaturesW"},
    {180, "MsiEnumPatchesA"},
    {269, "MsiEnumPatchesExA"},
    {270, "MsiEnumPatchesExW"},
    {181, "MsiEnumPatchesW"},
    {44, "MsiEnumProductsA"},
    {245, "MsiEnumProductsExA"},
    {246, "MsiEnumProductsExW"},
    {45, "MsiEnumProductsW"},
    {204, "MsiEnumRelatedProductsA"},
    {205, "MsiEnumRelatedProductsW"},
    {46, "MsiEvaluateConditionA"},
    {47, "MsiEvaluateConditionW"},
    {241, "MsiExtractPatchXMLDataA"},
    {242, "MsiExtractPatchXMLDataW"},
    {170, "MsiFormatRecordA"},
    {171, "MsiFormatRecordW"},
    {49, "MsiGetActiveDatabase"},
    {172, "MsiGetComponentPathA"},
    {293, "MsiGetComponentPathExA"},
    {294, "MsiGetComponentPathExW"},
    {173, "MsiGetComponentPathW"},
    {50, "MsiGetComponentStateA"},
    {51, "MsiGetComponentStateW"},
    {52, "MsiGetDatabaseState"},
    {53, "MsiGetFeatureCostA"},
    {54, "MsiGetFeatureCostW"},
    {55, "MsiGetFeatureInfoA"},
    {56, "MsiGetFeatureInfoW"},
    {57, "MsiGetFeatureStateA"},
    {58, "MsiGetFeatureStateW"},
    {59, "MsiGetFeatureUsageA"},
    {60, "MsiGetFeatureUsageW"},
    {61, "MsiGetFeatureValidStatesA"},
    {62, "MsiGetFeatureValidStatesW"},
    {218, "MsiGetFileHashA"},
    {219, "MsiGetFileHashW"},
    {223, "MsiGetFileSignatureInformationA"},
    {224, "MsiGetFileSignatureInformationW"},
    {194, "MsiGetFileVersionA"},
    {195, "MsiGetFileVersionW"},
    {63, "MsiGetLanguage"},
    {48, "MsiGetLastErrorRecord"},
    {64, "MsiGetMode"},
    {282, "MsiGetPatchFileListA"},
    {283, "MsiGetPatchFileListW"},
    {178, "MsiGetPatchInfoA"},
    {243, "MsiGetPatchInfoExA"},
    {244, "MsiGetPatchInfoExW"},
    {179, "MsiGetPatchInfoW"},
    {65, "MsiGetProductCodeA"},
    {183, "MsiGetProductCodeFromPackageCodeA"},
    {184, "MsiGetProductCodeFromPackageCodeW"},
    {66, "MsiGetProductCodeW"},
    {67, "MsiGetProductInfoA"},
    {247, "MsiGetProductInfoExA"},
    {248, "MsiGetProductInfoExW"},
    {68, "MsiGetProductInfoFromScriptA"},
    {69, "MsiGetProductInfoFromScriptW"},
    {70, "MsiGetProductInfoW"},
    {71, "MsiGetProductPropertyA"},
    {72, "MsiGetProductPropertyW"},
    {73, "MsiGetPropertyA"},
    {74, "MsiGetPropertyW"},
    {216, "MsiGetShortcutTargetA"},
    {217, "MsiGetShortcutTargetW"},
    {75, "MsiGetSourcePathA"},
    {76, "MsiGetSourcePathW"},
    {77, "MsiGetSummaryInformationA"},
    {78, "MsiGetSummaryInformationW"},
    {79, "MsiGetTargetPathA"},
    {80, "MsiGetTargetPathW"},
    {81, "MsiGetUserInfoA"},
    {82, "MsiGetUserInfoW"},
    {83, "MsiInstallMissingComponentA"},
    {84, "MsiInstallMissingComponentW"},
    {85, "MsiInstallMissingFileA"},
    {86, "MsiInstallMissingFileW"},
    {87, "MsiInstallProductA"},
    {88, "MsiInstallProductW"},
    {191, "MsiInvalidateFeatureCache"},
    {214, "MsiIsProductElevatedA"},
    {215, "MsiIsProductElevatedW"},
    {287, "MsiJoinTransaction"},
    {196, "MsiLoadStringA"},
    {197, "MsiLoadStringW"},
    {89, "MsiLocateComponentA"},
    {90, "MsiLocateComponentW"},
    {198, "MsiMessageBoxA"},
    {279, "MsiMessageBoxExA"},
    {280, "MsiMessageBoxExW"},
    {199, "MsiMessageBoxW"},
    {229, "MsiNotifySidChangeA"},
    {230, "MsiNotifySidChangeW"},
    {91, "MsiOpenDatabaseA"},
    {92, "MsiOpenDatabaseW"},
    {93, "MsiOpenPackageA"},
    {231, "MsiOpenPackageExA"},
    {232, "MsiOpenPackageExW"},
    {94, "MsiOpenPackageW"},
    {95, "MsiOpenProductA"},
    {96, "MsiOpenProductW"},
    {97, "MsiPreviewBillboardA"},
    {98, "MsiPreviewBillboardW"},
    {99, "MsiPreviewDialogA"},
    {100, "MsiPreviewDialogW"},
    {101, "MsiProcessAdvertiseScriptA"},
    {102, "MsiProcessAdvertiseScriptW"},
    {103, "MsiProcessMessage"},
    {225, "MsiProvideAssemblyA"},
    {226, "MsiProvideAssemblyW"},
    {104, "MsiProvideComponentA"},
    {105, "MsiProvideComponentFromDescriptorA"},
    {106, "MsiProvideComponentFromDescriptorW"},
    {107, "MsiProvideComponentW"},
    {108, "MsiProvideQualifiedComponentA"},
    {202, "MsiProvideQualifiedComponentExA"},
    {203, "MsiProvideQualifiedComponentExW"},
    {109, "MsiProvideQualifiedComponentW"},
    {249, "MsiQueryComponentStateA"},
    {250, "MsiQueryComponentStateW"},
    {110, "MsiQueryFeatureStateA"},
    {251, "MsiQueryFeatureStateExA"},
    {252, "MsiQueryFeatureStateExW"},
    {187, "MsiQueryFeatureStateFromDescriptorA"},
    {188, "MsiQueryFeatureStateFromDescriptorW"},
    {111, "MsiQueryFeatureStateW"},
    {112, "MsiQueryProductStateA"},
    {113, "MsiQueryProductStateW"},
    {167, "MsiRecordClearData"},
    {114, "MsiRecordDataSize"},
    {115, "MsiRecordGetFieldCount"},
    {116, "MsiRecordGetInteger"},
    {117, "MsiRecordGetStringA"},
    {118, "MsiRecordGetStringW"},
    {119, "MsiRecordIsNull"},
    {120, "MsiRecordReadStream"},
    {121, "MsiRecordSetInteger"},
    {122, "MsiRecordSetStreamA"},
    {123, "MsiRecordSetStreamW"},
    {124, "MsiRecordSetStringA"},
    {125, "MsiRecordSetStringW"},
    {126, "MsiReinstallFeatureA"},
    {127, "MsiReinstallFeatureFromDescriptorA"},
    {128, "MsiReinstallFeatureFromDescriptorW"},
    {129, "MsiReinstallFeatureW"},
    {130, "MsiReinstallProductA"},
    {131, "MsiReinstallProductW"},
    {237, "MsiRemovePatchesA"},
    {238, "MsiRemovePatchesW"},
    {132, "MsiSequenceA"},
    {133, "MsiSequenceW"},
    {134, "MsiSetComponentStateA"},
    {135, "MsiSetComponentStateW"},
    {136, "MsiSetExternalUIA"},
    {281, "MsiSetExternalUIRecord"},
    {137, "MsiSetExternalUIW"},
    {206, "MsiSetFeatureAttributesA"},
    {207, "MsiSetFeatureAttributesW"},
    {138, "MsiSetFeatureStateA"},
    {139, "MsiSetFeatureStateW"},
    {140, "MsiSetInstallLevel"},
    {141, "MsiSetInternalUI"},
    {143, "MsiSetMode"},
    {288, "MsiSetOfflineContextW"},
    {144, "MsiSetPropertyA"},
    {145, "MsiSetPropertyW"},
    {146, "MsiSetTargetPathA"},
    {147, "MsiSetTargetPathW"},
    {273, "MsiSourceListAddMediaDiskA"},
    {274, "MsiSourceListAddMediaDiskW"},
    {210, "MsiSourceListAddSourceA"},
    {255, "MsiSourceListAddSourceExA"},
    {256, "MsiSourceListAddSourceExW"},
    {211, "MsiSourceListAddSourceW"},
    {208, "MsiSourceListClearAllA"},
    {259, "MsiSourceListClearAllExA"},
    {260, "MsiSourceListClearAllExW"},
    {209, "MsiSourceListClearAllW"},
    {275, "MsiSourceListClearMediaDiskA"},
    {276, "MsiSourceListClearMediaDiskW"},
    {257, "MsiSourceListClearSourceA"},
    {258, "MsiSourceListClearSourceW"},
    {271, "MsiSourceListEnumMediaDisksA"},
    {272, "MsiSourceListEnumMediaDisksW"},
    {263, "MsiSourceListEnumSourcesA"},
    {264, "MsiSourceListEnumSourcesW"},
    {212, "MsiSourceListForceResolutionA"},
    {261, "MsiSourceListForceResolutionExA"},
    {262, "MsiSourceListForceResolutionExW"},
    {213, "MsiSourceListForceResolutionW"},
    {265, "MsiSourceListGetInfoA"},
    {266, "MsiSourceListGetInfoW"},
    {267, "MsiSourceListSetInfoA"},
    {268, "MsiSourceListSetInfoW"},
    {148, "MsiSummaryInfoGetPropertyA"},
    {149, "MsiSummaryInfoGetPropertyCount"},
    {150, "MsiSummaryInfoGetPropertyW"},
    {151, "MsiSummaryInfoPersist"},
    {152, "MsiSummaryInfoSetPropertyA"},
    {153, "MsiSummaryInfoSetPropertyW"},
    {154, "MsiUseFeatureA"},
    {192, "MsiUseFeatureExA"},
    {193, "MsiUseFeatureExW"},
    {155, "MsiUseFeatureW"},
    {142, "MsiVerifyDiskSpace"},
    {156, "MsiVerifyPackageA"},
    {157, "MsiVerifyPackageW"},
    {158, "MsiViewClose"},
    {159, "MsiViewExecute"},
    {160, "MsiViewFetch"},
    {166, "MsiViewGetColumnInfo"},
    {161, "MsiViewGetErrorA"},
    {162, "MsiViewGetErrorW"},
    {163, "MsiViewModify"},
    {295, "QueryInstanceCount"},
    {0, NULL}};
static Dw32Ordinal msimg32[] = {
    {2, "AlphaBlend"},
    {3, "DllInitialize"},
    {4, "GradientFill"},
    {5, "TransparentBlt"},
    {1, "vSetDdrawflag"},
    {0, NULL}};
static Dw32Ordinal msrating[] = {
    {1, "ChangeSupervisorPassword"},
    {2, "ClickedOnPRF"},
    {3, "ClickedOnRAT"},
    {4, "DllCanUnloadNow"},
    {5, "DllGetClassObject"},
    {8, "RatingAccessDeniedDialog"},
    {6, "RatingAccessDeniedDialog2"},
    {7, "RatingAccessDeniedDialog2W"},
    {9, "RatingAccessDeniedDialogW"},
    {10, "RatingAddPropertyPages"},
    {11, "RatingAddToApprovedSites"},
    {12, "RatingCheckUserAccess"},
    {13, "RatingCheckUserAccessW"},
    {14, "RatingClickedOnPRFInternal"},
    {15, "RatingClickedOnRATInternal"},
    {16, "RatingCustomAddRatingHelper"},
    {17, "RatingCustomAddRatingSystem"},
    {18, "RatingCustomCrackData"},
    {19, "RatingCustomDeleteCrackedData"},
    {20, "RatingCustomInit"},
    {21, "RatingCustomRemoveRatingHelper"},
    {22, "RatingCustomSetDefaultBureau"},
    {23, "RatingCustomSetUserOptions"},
    {24, "RatingEnable"},
    {25, "RatingEnableW"},
    {26, "RatingEnabledQuery"},
    {27, "RatingFreeDetails"},
    {28, "RatingInit"},
    {29, "RatingObtainCancel"},
    {30, "RatingObtainQuery"},
    {31, "RatingObtainQueryW"},
    {32, "RatingSetupUI"},
    {33, "RatingSetupUIW"},
    {34, "VerifySupervisorPassword"},
    {0, NULL}};
static Dw32Ordinal mstask[] = {
    {1, "ConvertAtJobsToTasks"},
    {2, "DllCanUnloadNow"},
    {3, "DllGetClassObject"},
    {4, "GetNetScheduleAccountInformation"},
    {5, "NetrJobAdd"},
    {6, "NetrJobDel"},
    {7, "NetrJobEnum"},
    {8, "NetrJobGetInfo"},
    {9, "SAGetAccountInformation"},
    {10, "SAGetNSAccountInformation"},
    {11, "SASetAccountInformation"},
    {12, "SASetNSAccountInformation"},
    {13, "SetNetScheduleAccountInformation"},
    {14, "_ConvertAtJobsToTasks@0"},
    {15, "_DllCanUnloadNow@0"},
    {16, "_DllGetClassObject@12"},
    {17, "_GetNetScheduleAccountInformation@12"},
    {18, "_NetrJobAdd@12"},
    {19, "_NetrJobDel@12"},
    {20, "_NetrJobEnum@20"},
    {21, "_NetrJobGetInfo@12"},
    {22, "_SAGetAccountInformation@16"},
    {23, "_SAGetNSAccountInformation@12"},
    {24, "_SASetAccountInformation@20"},
    {25, "_SASetNSAccountInformation@12"},
    {26, "_SetNetScheduleAccountInformation@12"},
    {0, NULL}};
static Dw32Ordinal msvcirt[] = {
    {1, "??0Iostream_init@@QAE@AAVios@@H@Z"},
    {2, "??0Iostream_init@@QAE@XZ"},
    {3, "??0exception@@QAE@ABQBD@Z"},
    {4, "??0exception@@QAE@ABV0@@Z"},
    {5, "??0exception@@QAE@XZ"},
    {6, "??0filebuf@@QAE@ABV0@@Z"},
    {7, "??0filebuf@@QAE@H@Z"},
    {8, "??0filebuf@@QAE@HPADH@Z"},
    {9, "??0filebuf@@QAE@XZ"},
    {10, "??0fstream@@QAE@ABV0@@Z"},
    {11, "??0fstream@@QAE@H@Z"},
    {12, "??0fstream@@QAE@HPADH@Z"},
    {13, "??0fstream@@QAE@PBDHH@Z"},
    {14, "??0fstream@@QAE@XZ"},
    {15, "??0ifstream@@QAE@ABV0@@Z"},
    {16, "??0ifstream@@QAE@H@Z"},
    {17, "??0ifstream@@QAE@HPADH@Z"},
    {18, "??0ifstream@@QAE@PBDHH@Z"},
    {19, "??0ifstream@@QAE@XZ"},
    {20, "??0ios@@IAE@ABV0@@Z"},
    {21, "??0ios@@IAE@XZ"},
    {22, "??0ios@@QAE@PAVstreambuf@@@Z"},
    {23, "??0iostream@@IAE@ABV0@@Z"},
    {24, "??0iostream@@IAE@XZ"},
    {25, "??0iostream@@QAE@PAVstreambuf@@@Z"},
    {26, "??0istream@@IAE@ABV0@@Z"},
    {27, "??0istream@@IAE@XZ"},
    {28, "??0istream@@QAE@PAVstreambuf@@@Z"},
    {29, "??0istream_withassign@@QAE@ABV0@@Z"},
    {30, "??0istream_withassign@@QAE@PAVstreambuf@@@Z"},
    {31, "??0istream_withassign@@QAE@XZ"},
    {32, "??0istrstream@@QAE@ABV0@@Z"},
    {33, "??0istrstream@@QAE@PAD@Z"},
    {34, "??0istrstream@@QAE@PADH@Z"},
    {35, "??0logic_error@@QAE@ABQBD@Z"},
    {36, "??0logic_error@@QAE@ABV0@@Z"},
    {37, "??0ofstream@@QAE@ABV0@@Z"},
    {38, "??0ofstream@@QAE@H@Z"},
    {39, "??0ofstream@@QAE@HPADH@Z"},
    {40, "??0ofstream@@QAE@PBDHH@Z"},
    {41, "??0ofstream@@QAE@XZ"},
    {42, "??0ostream@@IAE@ABV0@@Z"},
    {43, "??0ostream@@IAE@XZ"},
    {44, "??0ostream@@QAE@PAVstreambuf@@@Z"},
    {45, "??0ostream_withassign@@QAE@ABV0@@Z"},
    {46, "??0ostream_withassign@@QAE@PAVstreambuf@@@Z"},
    {47, "??0ostream_withassign@@QAE@XZ"},
    {48, "??0ostrstream@@QAE@ABV0@@Z"},
    {49, "??0ostrstream@@QAE@PADHH@Z"},
    {50, "??0ostrstream@@QAE@XZ"},
    {51, "??0stdiobuf@@QAE@ABV0@@Z"},
    {52, "??0stdiobuf@@QAE@PAU_iobuf@@@Z"},
    {53, "??0stdiostream@@QAE@ABV0@@Z"},
    {54, "??0stdiostream@@QAE@PAU_iobuf@@@Z"},
    {55, "??0streambuf@@IAE@PADH@Z"},
    {56, "??0streambuf@@IAE@XZ"},
    {57, "??0streambuf@@QAE@ABV0@@Z"},
    {58, "??0strstream@@QAE@ABV0@@Z"},
    {59, "??0strstream@@QAE@PADHH@Z"},
    {60, "??0strstream@@QAE@XZ"},
    {61, "??0strstreambuf@@QAE@ABV0@@Z"},
    {62, "??0strstreambuf@@QAE@H@Z"},
    {63, "??0strstreambuf@@QAE@P6APAXJ@ZP6AXPAX@Z@Z"},
    {64, "??0strstreambuf@@QAE@PADH0@Z"},
    {65, "??0strstreambuf@@QAE@PAEH0@Z"},
    {66, "??0strstreambuf@@QAE@XZ"},
    {67, "??1Iostream_init@@QAE@XZ"},
    {68, "??1exception@@UAE@XZ"},
    {69, "??1filebuf@@UAE@XZ"},
    {70, "??1fstream@@UAE@XZ"},
    {71, "??1ifstream@@UAE@XZ"},
    {72, "??1ios@@UAE@XZ"},
    {73, "??1iostream@@UAE@XZ"},
    {74, "??1istream@@UAE@XZ"},
    {75, "??1istream_withassign@@UAE@XZ"},
    {76, "??1istrstream@@UAE@XZ"},
    {77, "??1logic_error@@UAE@XZ"},
    {78, "??1ofstream@@UAE@XZ"},
    {79, "??1ostream@@UAE@XZ"},
    {80, "??1ostream_withassign@@UAE@XZ"},
    {81, "??1ostrstream@@UAE@XZ"},
    {82, "??1stdiobuf@@UAE@XZ"},
    {83, "??1stdiostream@@UAE@XZ"},
    {84, "??1streambuf@@UAE@XZ"},
    {85, "??1strstream@@UAE@XZ"},
    {86, "??1strstreambuf@@UAE@XZ"},
    {87, "??4Iostream_init@@QAEAAV0@ABV0@@Z"},
    {88, "??4exception@@QAEAAV0@ABV0@@Z"},
    {89, "??4filebuf@@QAEAAV0@ABV0@@Z"},
    {90, "??4fstream@@QAEAAV0@AAV0@@Z"},
    {91, "??4ifstream@@QAEAAV0@ABV0@@Z"},
    {92, "??4ios@@IAEAAV0@ABV0@@Z"},
    {93, "??4iostream@@IAEAAV0@AAV0@@Z"},
    {94, "??4iostream@@IAEAAV0@PAVstreambuf@@@Z"},
    {95, "??4istream@@IAEAAV0@ABV0@@Z"},
    {96, "??4istream@@IAEAAV0@PAVstreambuf@@@Z"},
    {97, "??4istream_withassign@@QAEAAV0@ABV0@@Z"},
    {98, "??4istream_withassign@@QAEAAVistream@@ABV1@@Z"},
    {99, "??4istream_withassign@@QAEAAVistream@@PAVstreambuf@@@Z"},
    {100, "??4istrstream@@QAEAAV0@ABV0@@Z"},
    {101, "??4logic_error@@QAEAAV0@ABV0@@Z"},
    {102, "??4ofstream@@QAEAAV0@ABV0@@Z"},
    {103, "??4ostream@@IAEAAV0@ABV0@@Z"},
    {104, "??4ostream@@IAEAAV0@PAVstreambuf@@@Z"},
    {105, "??4ostream_withassign@@QAEAAV0@ABV0@@Z"},
    {106, "??4ostream_withassign@@QAEAAVostream@@ABV1@@Z"},
    {107, "??4ostream_withassign@@QAEAAVostream@@PAVstreambuf@@@Z"},
    {108, "??4ostrstream@@QAEAAV0@ABV0@@Z"},
    {109, "??4stdiobuf@@QAEAAV0@ABV0@@Z"},
    {110, "??4stdiostream@@QAEAAV0@AAV0@@Z"},
    {111, "??4streambuf@@QAEAAV0@ABV0@@Z"},
    {112, "??4strstream@@QAEAAV0@AAV0@@Z"},
    {113, "??4strstreambuf@@QAEAAV0@ABV0@@Z"},
    {114, "??5istream@@QAEAAV0@AAC@Z"},
    {115, "??5istream@@QAEAAV0@AAD@Z"},
    {116, "??5istream@@QAEAAV0@AAE@Z"},
    {117, "??5istream@@QAEAAV0@AAF@Z"},
    {118, "??5istream@@QAEAAV0@AAG@Z"},
    {119, "??5istream@@QAEAAV0@AAH@Z"},
    {120, "??5istream@@QAEAAV0@AAI@Z"},
    {121, "??5istream@@QAEAAV0@AAJ@Z"},
    {122, "??5istream@@QAEAAV0@AAK@Z"},
    {123, "??5istream@@QAEAAV0@AAM@Z"},
    {124, "??5istream@@QAEAAV0@AAN@Z"},
    {125, "??5istream@@QAEAAV0@AAO@Z"},
    {126, "??5istream@@QAEAAV0@P6AAAV0@AAV0@@Z@Z"},
    {127, "??5istream@@QAEAAV0@P6AAAVios@@AAV1@@Z@Z"},
    {128, "??5istream@@QAEAAV0@PAC@Z"},
    {129, "??5istream@@QAEAAV0@PAD@Z"},
    {130, "??5istream@@QAEAAV0@PAE@Z"},
    {131, "??5istream@@QAEAAV0@PAVstreambuf@@@Z"},
    {132, "??6ostream@@QAEAAV0@C@Z"},
    {133, "??6ostream@@QAEAAV0@D@Z"},
    {134, "??6ostream@@QAEAAV0@E@Z"},
    {135, "??6ostream@@QAEAAV0@F@Z"},
    {136, "??6ostream@@QAEAAV0@G@Z"},
    {137, "??6ostream@@QAEAAV0@H@Z"},
    {138, "??6ostream@@QAEAAV0@I@Z"},
    {139, "??6ostream@@QAEAAV0@J@Z"},
    {140, "??6ostream@@QAEAAV0@K@Z"},
    {141, "??6ostream@@QAEAAV0@M@Z"},
    {142, "??6ostream@@QAEAAV0@N@Z"},
    {143, "??6ostream@@QAEAAV0@O@Z"},
    {144, "??6ostream@@QAEAAV0@P6AAAV0@AAV0@@Z@Z"},
    {145, "??6ostream@@QAEAAV0@P6AAAVios@@AAV1@@Z@Z"},
    {146, "??6ostream@@QAEAAV0@PAVstreambuf@@@Z"},
    {147, "??6ostream@@QAEAAV0@PBC@Z"},
    {148, "??6ostream@@QAEAAV0@PBD@Z"},
    {149, "??6ostream@@QAEAAV0@PBE@Z"},
    {150, "??6ostream@@QAEAAV0@PBX@Z"},
    {151, "??7ios@@QBEHXZ"},
    {152, "??Bios@@QBEPAXXZ"},
    {153, "??_7exception@@6B@"},
    {154, "??_7filebuf@@6B@"},
    {155, "??_7fstream@@6B@"},
    {156, "??_7ifstream@@6B@"},
    {157, "??_7ios@@6B@"},
    {158, "??_7iostream@@6B@"},
    {159, "??_7istream@@6B@"},
    {160, "??_7istream_withassign@@6B@"},
    {161, "??_7istrstream@@6B@"},
    {162, "??_7logic_error@@6B@"},
    {163, "??_7ofstream@@6B@"},
    {164, "??_7ostream@@6B@"},
    {165, "??_7ostream_withassign@@6B@"},
    {166, "??_7ostrstream@@6B@"},
    {167, "??_7stdiobuf@@6B@"},
    {168, "??_7stdiostream@@6B@"},
    {169, "??_7streambuf@@6B@"},
    {170, "??_7strstream@@6B@"},
    {171, "??_7strstreambuf@@6B@"},
    {172, "??_8fstream@@7Bistream@@@"},
    {173, "??_8fstream@@7Bostream@@@"},
    {174, "??_8ifstream@@7B@"},
    {175, "??_8iostream@@7Bistream@@@"},
    {176, "??_8iostream@@7Bostream@@@"},
    {177, "??_8istream@@7B@"},
    {178, "??_8istream_withassign@@7B@"},
    {179, "??_8istrstream@@7B@"},
    {180, "??_8ofstream@@7B@"},
    {181, "??_8ostream@@7B@"},
    {182, "??_8ostream_withassign@@7B@"},
    {183, "??_8ostrstream@@7B@"},
    {184, "??_8stdiostream@@7Bistream@@@"},
    {185, "??_8stdiostream@@7Bostream@@@"},
    {186, "??_8strstream@@7Bistream@@@"},
    {187, "??_8strstream@@7Bostream@@@"},
    {188, "??_Dfstream@@QAEXXZ"},
    {189, "??_Difstream@@QAEXXZ"},
    {190, "??_Diostream@@QAEXXZ"},
    {191, "??_Distream@@QAEXXZ"},
    {192, "??_Distream_withassign@@QAEXXZ"},
    {193, "??_Distrstream@@QAEXXZ"},
    {194, "??_Dofstream@@QAEXXZ"},
    {195, "??_Dostream@@QAEXXZ"},
    {196, "??_Dostream_withassign@@QAEXXZ"},
    {197, "??_Dostrstream@@QAEXXZ"},
    {198, "??_Dstdiostream@@QAEXXZ"},
    {199, "??_Dstrstream@@QAEXXZ"},
    {200, "??_Eexception@@UAEPAXI@Z"},
    {201, "??_Efilebuf@@UAEPAXI@Z"},
    {202, "??_Efstream@@UAEPAXI@Z"},
    {203, "??_Eifstream@@UAEPAXI@Z"},
    {204, "??_Eios@@UAEPAXI@Z"},
    {205, "??_Eiostream@@UAEPAXI@Z"},
    {206, "??_Eistream@@UAEPAXI@Z"},
    {207, "??_Eistream_withassign@@UAEPAXI@Z"},
    {208, "??_Eistrstream@@UAEPAXI@Z"},
    {209, "??_Elogic_error@@UAEPAXI@Z"},
    {210, "??_Eofstream@@UAEPAXI@Z"},
    {211, "??_Eostream@@UAEPAXI@Z"},
    {212, "??_Eostream_withassign@@UAEPAXI@Z"},
    {213, "??_Eostrstream@@UAEPAXI@Z"},
    {214, "??_Estdiobuf@@UAEPAXI@Z"},
    {215, "??_Estdiostream@@UAEPAXI@Z"},
    {216, "??_Estreambuf@@UAEPAXI@Z"},
    {217, "??_Estrstream@@UAEPAXI@Z"},
    {218, "??_Estrstreambuf@@UAEPAXI@Z"},
    {219, "??_Gexception@@UAEPAXI@Z"},
    {220, "??_Gfilebuf@@UAEPAXI@Z"},
    {221, "??_Gfstream@@UAEPAXI@Z"},
    {222, "??_Gifstream@@UAEPAXI@Z"},
    {223, "??_Gios@@UAEPAXI@Z"},
    {224, "??_Giostream@@UAEPAXI@Z"},
    {225, "??_Gistream@@UAEPAXI@Z"},
    {226, "??_Gistream_withassign@@UAEPAXI@Z"},
    {227, "??_Gistrstream@@UAEPAXI@Z"},
    {228, "??_Glogic_error@@UAEPAXI@Z"},
    {229, "??_Gofstream@@UAEPAXI@Z"},
    {230, "??_Gostream@@UAEPAXI@Z"},
    {231, "??_Gostream_withassign@@UAEPAXI@Z"},
    {232, "??_Gostrstream@@UAEPAXI@Z"},
    {233, "??_Gstdiobuf@@UAEPAXI@Z"},
    {234, "??_Gstdiostream@@UAEPAXI@Z"},
    {235, "??_Gstreambuf@@UAEPAXI@Z"},
    {236, "??_Gstrstream@@UAEPAXI@Z"},
    {237, "??_Gstrstreambuf@@UAEPAXI@Z"},
    {238, "?adjustfield@ios@@2JB"},
    {239, "?allocate@streambuf@@IAEHXZ"},
    {240, "?attach@filebuf@@QAEPAV1@H@Z"},
    {241, "?attach@fstream@@QAEXH@Z"},
    {242, "?attach@ifstream@@QAEXH@Z"},
    {243, "?attach@ofstream@@QAEXH@Z"},
    {244, "?bad@ios@@QBEHXZ"},
    {245, "?base@streambuf@@IBEPADXZ"},
    {246, "?basefield@ios@@2JB"},
    {247, "?binary@filebuf@@2HB"},
    {248, "?bitalloc@ios@@SAJXZ"},
    {249, "?blen@streambuf@@IBEHXZ"},
    {250, "?cerr@@3Vostream_withassign@@A"},
    {251, "?cin@@3Vistream_withassign@@A"},
    {252, "?clear@ios@@QAEXH@Z"},
    {253, "?clog@@3Vostream_withassign@@A"},
    {254, "?close@filebuf@@QAEPAV1@XZ"},
    {255, "?close@fstream@@QAEXXZ"},
    {256, "?close@ifstream@@QAEXXZ"},
    {257, "?close@ofstream@@QAEXXZ"},
    {258, "?clrlock@ios@@QAAXXZ"},
    {259, "?clrlock@streambuf@@QAEXXZ"},
    {260, "?cout@@3Vostream_withassign@@A"},
    {261, "?dbp@streambuf@@QAEXXZ"},
    {262, "?dec@@YAAAVios@@AAV1@@Z"},
    {263, "?delbuf@ios@@QAEXH@Z"},
    {264, "?delbuf@ios@@QBEHXZ"},
    {265, "?doallocate@streambuf@@MAEHXZ"},
    {266, "?doallocate@strstreambuf@@MAEHXZ"},
    {267, "?eatwhite@istream@@QAEXXZ"},
    {268, "?eback@streambuf@@IBEPADXZ"},
    {269, "?ebuf@streambuf@@IBEPADXZ"},
    {270, "?egptr@streambuf@@IBEPADXZ"},
    {271, "?endl@@YAAAVostream@@AAV1@@Z"},
    {272, "?ends@@YAAAVostream@@AAV1@@Z"},
    {273, "?eof@ios@@QBEHXZ"},
    {274, "?epptr@streambuf@@IBEPADXZ"},
    {275, "?fLockcInit@ios@@0HA"},
    {276, "?fail@ios@@QBEHXZ"},
    {277, "?fd@filebuf@@QBEHXZ"},
    {278, "?fd@fstream@@QBEHXZ"},
    {279, "?fd@ifstream@@QBEHXZ"},
    {280, "?fd@ofstream@@QBEHXZ"},
    {281, "?fill@ios@@QAEDD@Z"},
    {282, "?fill@ios@@QBEDXZ"},
    {283, "?flags@ios@@QAEJJ@Z"},
    {284, "?flags@ios@@QBEJXZ"},
    {285, "?floatfield@ios@@2JB"},
    {286, "?flush@@YAAAVostream@@AAV1@@Z"},
    {287, "?flush@ostream@@QAEAAV1@XZ"},
    {288, "?freeze@strstreambuf@@QAEXH@Z"},
    {289, "?gbump@streambuf@@IAEXH@Z"},
    {290, "?gcount@istream@@QBEHXZ"},
    {291, "?get@istream@@IAEAAV1@PADHH@Z"},
    {292, "?get@istream@@QAEAAV1@AAC@Z"},
    {293, "?get@istream@@QAEAAV1@AAD@Z"},
    {294, "?get@istream@@QAEAAV1@AAE@Z"},
    {295, "?get@istream@@QAEAAV1@AAVstreambuf@@D@Z"},
    {296, "?get@istream@@QAEAAV1@PACHD@Z"},
    {297, "?get@istream@@QAEAAV1@PADHD@Z"},
    {298, "?get@istream@@QAEAAV1@PAEHD@Z"},
    {299, "?get@istream@@QAEHXZ"},
    {300, "?getdouble@istream@@AAEHPADH@Z"},
    {301, "?getint@istream@@AAEHPAD@Z"},
    {302, "?getline@istream@@QAEAAV1@PACHD@Z"},
    {303, "?getline@istream@@QAEAAV1@PADHD@Z"},
    {304, "?getline@istream@@QAEAAV1@PAEHD@Z"},
    {305, "?good@ios@@QBEHXZ"},
    {306, "?gptr@streambuf@@IBEPADXZ"},
    {307, "?hex@@YAAAVios@@AAV1@@Z"},
    {308, "?ignore@istream@@QAEAAV1@HH@Z"},
    {309, "?in_avail@streambuf@@QBEHXZ"},
    {310, "?init@ios@@IAEXPAVstreambuf@@@Z"},
    {311, "?ipfx@istream@@QAEHH@Z"},
    {312, "?is_open@filebuf@@QBEHXZ"},
    {313, "?is_open@fstream@@QBEHXZ"},
    {314, "?is_open@ifstream@@QBEHXZ"},
    {315, "?is_open@ofstream@@QBEHXZ"},
    {316, "?isfx@istream@@QAEXXZ"},
    {317, "?iword@ios@@QBEAAJH@Z"},
    {318, "?lock@ios@@QAAXXZ"},
    {319, "?lock@streambuf@@QAEXXZ"},
    {320, "?lockbuf@ios@@QAAXXZ"},
    {321, "?lockc@ios@@KAXXZ"},
    {322, "?lockptr@ios@@IAEPAU_CRT_CRITICAL_SECTION@@XZ"},
    {323, "?lockptr@streambuf@@IAEPAU_CRT_CRITICAL_SECTION@@XZ"},
    {324, "?oct@@YAAAVios@@AAV1@@Z"},
    {325, "?open@filebuf@@QAEPAV1@PBDHH@Z"},
    {326, "?open@fstream@@QAEXPBDHH@Z"},
    {327, "?open@ifstream@@QAEXPBDHH@Z"},
    {328, "?open@ofstream@@QAEXPBDHH@Z"},
    {329, "?openprot@filebuf@@2HB"},
    {330, "?opfx@ostream@@QAEHXZ"},
    {331, "?osfx@ostream@@QAEXXZ"},
    {332, "?out_waiting@streambuf@@QBEHXZ"},
    {333, "?overflow@filebuf@@UAEHH@Z"},
    {334, "?overflow@stdiobuf@@UAEHH@Z"},
    {335, "?overflow@strstreambuf@@UAEHH@Z"},
    {336, "?pbackfail@stdiobuf@@UAEHH@Z"},
    {337, "?pbackfail@streambuf@@UAEHH@Z"},
    {338, "?pbase@streambuf@@IBEPADXZ"},
    {339, "?pbump@streambuf@@IAEXH@Z"},
    {340, "?pcount@ostrstream@@QBEHXZ"},
    {341, "?pcount@strstream@@QBEHXZ"},
    {342, "?peek@istream@@QAEHXZ"},
    {343, "?pptr@streambuf@@IBEPADXZ"},
    {344, "?precision@ios@@QAEHH@Z"},
    {345, "?precision@ios@@QBEHXZ"},
    {346, "?put@ostream@@QAEAAV1@C@Z"},
    {347, "?put@ostream@@QAEAAV1@D@Z"},
    {348, "?put@ostream@@QAEAAV1@E@Z"},
    {349, "?putback@istream@@QAEAAV1@D@Z"},
    {350, "?pword@ios@@QBEAAPAXH@Z"},
    {351, "?rdbuf@fstream@@QBEPAVfilebuf@@XZ"},
    {352, "?rdbuf@ifstream@@QBEPAVfilebuf@@XZ"},
    {353, "?rdbuf@ios@@QBEPAVstreambuf@@XZ"},
    {354, "?rdbuf@istrstream@@QBEPAVstrstreambuf@@XZ"},
    {355, "?rdbuf@ofstream@@QBEPAVfilebuf@@XZ"},
    {356, "?rdbuf@ostrstream@@QBEPAVstrstreambuf@@XZ"},
    {357, "?rdbuf@stdiostream@@QBEPAVstdiobuf@@XZ"},
    {358, "?rdbuf@strstream@@QBEPAVstrstreambuf@@XZ"},
    {359, "?rdstate@ios@@QBEHXZ"},
    {360, "?read@istream@@QAEAAV1@PACH@Z"},
    {361, "?read@istream@@QAEAAV1@PADH@Z"},
    {362, "?read@istream@@QAEAAV1@PAEH@Z"},
    {363, "?sbumpc@streambuf@@QAEHXZ"},
    {364, "?seekg@istream@@QAEAAV1@J@Z"},
    {365, "?seekg@istream@@QAEAAV1@JW4seek_dir@ios@@@Z"},
    {366, "?seekoff@filebuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {367, "?seekoff@stdiobuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {368, "?seekoff@streambuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {369, "?seekoff@strstreambuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {370, "?seekp@ostream@@QAEAAV1@J@Z"},
    {371, "?seekp@ostream@@QAEAAV1@JW4seek_dir@ios@@@Z"},
    {372, "?seekpos@streambuf@@UAEJJH@Z"},
    {373, "?setb@streambuf@@IAEXPAD0H@Z"},
    {374, "?setbuf@filebuf@@UAEPAVstreambuf@@PADH@Z"},
    {375, "?setbuf@fstream@@QAEPAVstreambuf@@PADH@Z"},
    {376, "?setbuf@ifstream@@QAEPAVstreambuf@@PADH@Z"},
    {377, "?setbuf@ofstream@@QAEPAVstreambuf@@PADH@Z"},
    {378, "?setbuf@streambuf@@UAEPAV1@PADH@Z"},
    {379, "?setbuf@strstreambuf@@UAEPAVstreambuf@@PADH@Z"},
    {380, "?setf@ios@@QAEJJ@Z"},
    {381, "?setf@ios@@QAEJJJ@Z"},
    {382, "?setg@streambuf@@IAEXPAD00@Z"},
    {383, "?setlock@ios@@QAAXXZ"},
    {384, "?setlock@streambuf@@QAEXXZ"},
    {385, "?setmode@filebuf@@QAEHH@Z"},
    {386, "?setmode@fstream@@QAEHH@Z"},
    {387, "?setmode@ifstream@@QAEHH@Z"},
    {388, "?setmode@ofstream@@QAEHH@Z"},
    {389, "?setp@streambuf@@IAEXPAD0@Z"},
    {390, "?setrwbuf@stdiobuf@@QAEHHH@Z"},
    {391, "?sgetc@streambuf@@QAEHXZ"},
    {392, "?sgetn@streambuf@@QAEHPADH@Z"},
    {393, "?sh_none@filebuf@@2HB"},
    {394, "?sh_read@filebuf@@2HB"},
    {395, "?sh_write@filebuf@@2HB"},
    {396, "?snextc@streambuf@@QAEHXZ"},
    {397, "?sputbackc@streambuf@@QAEHD@Z"},
    {398, "?sputc@streambuf@@QAEHH@Z"},
    {399, "?sputn@streambuf@@QAEHPBDH@Z"},
    {400, "?stdiofile@stdiobuf@@QAEPAU_iobuf@@XZ"},
    {401, "?stossc@streambuf@@QAEXXZ"},
    {402, "?str@istrstream@@QAEPADXZ"},
    {403, "?str@ostrstream@@QAEPADXZ"},
    {404, "?str@strstream@@QAEPADXZ"},
    {405, "?str@strstreambuf@@QAEPADXZ"},
    {406, "?sunk_with_stdio@ios@@0HA"},
    {407, "?sync@filebuf@@UAEHXZ"},
    {408, "?sync@istream@@QAEHXZ"},
    {409, "?sync@stdiobuf@@UAEHXZ"},
    {410, "?sync@streambuf@@UAEHXZ"},
    {411, "?sync@strstreambuf@@UAEHXZ"},
    {412, "?sync_with_stdio@ios@@SAXXZ"},
    {413, "?tellg@istream@@QAEJXZ"},
    {414, "?tellp@ostream@@QAEJXZ"},
    {415, "?text@filebuf@@2HB"},
    {416, "?tie@ios@@QAEPAVostream@@PAV2@@Z"},
    {417, "?tie@ios@@QBEPAVostream@@XZ"},
    {418, "?unbuffered@streambuf@@IAEXH@Z"},
    {419, "?unbuffered@streambuf@@IBEHXZ"},
    {420, "?underflow@filebuf@@UAEHXZ"},
    {421, "?underflow@stdiobuf@@UAEHXZ"},
    {422, "?underflow@strstreambuf@@UAEHXZ"},
    {423, "?unlock@ios@@QAAXXZ"},
    {424, "?unlock@streambuf@@QAEXXZ"},
    {425, "?unlockbuf@ios@@QAAXXZ"},
    {426, "?unlockc@ios@@KAXXZ"},
    {427, "?unsetf@ios@@QAEJJ@Z"},
    {428, "?what@exception@@UBEPBDXZ"},
    {429, "?width@ios@@QAEHH@Z"},
    {430, "?width@ios@@QBEHXZ"},
    {431, "?write@ostream@@QAEAAV1@PBCH@Z"},
    {432, "?write@ostream@@QAEAAV1@PBDH@Z"},
    {433, "?write@ostream@@QAEAAV1@PBEH@Z"},
    {434, "?writepad@ostream@@AAEAAV1@PBD0@Z"},
    {435, "?ws@@YAAAVistream@@AAV1@@Z"},
    {436, "?x_curindex@ios@@0HA"},
    {437, "?x_lockc@ios@@0U_CRT_CRITICAL_SECTION@@A"},
    {438, "?x_maxbit@ios@@0JA"},
    {439, "?x_statebuf@ios@@0PAJA"},
    {440, "?xalloc@ios@@SAHXZ"},
    {441, "?xsgetn@streambuf@@UAEHPADH@Z"},
    {442, "?xsputn@streambuf@@UAEHPBDH@Z"},
    {443, "__dummy_export"},
    {444, "_mtlock"},
    {445, "_mtunlock"},
    {0, NULL}};
static Dw32Ordinal msvcirtd[] = {
    {1, "??0Iostream_init@@QAE@AAVios@@H@Z"},
    {2, "??0Iostream_init@@QAE@XZ"},
    {3, "??0exception@@QAE@ABQBD@Z"},
    {4, "??0exception@@QAE@ABV0@@Z"},
    {5, "??0exception@@QAE@XZ"},
    {6, "??0filebuf@@QAE@ABV0@@Z"},
    {7, "??0filebuf@@QAE@H@Z"},
    {8, "??0filebuf@@QAE@HPADH@Z"},
    {9, "??0filebuf@@QAE@XZ"},
    {10, "??0fstream@@QAE@ABV0@@Z"},
    {11, "??0fstream@@QAE@H@Z"},
    {12, "??0fstream@@QAE@HPADH@Z"},
    {13, "??0fstream@@QAE@PBDHH@Z"},
    {14, "??0fstream@@QAE@XZ"},
    {15, "??0ifstream@@QAE@ABV0@@Z"},
    {16, "??0ifstream@@QAE@H@Z"},
    {17, "??0ifstream@@QAE@HPADH@Z"},
    {18, "??0ifstream@@QAE@PBDHH@Z"},
    {19, "??0ifstream@@QAE@XZ"},
    {20, "??0ios@@IAE@ABV0@@Z"},
    {21, "??0ios@@IAE@XZ"},
    {22, "??0ios@@QAE@PAVstreambuf@@@Z"},
    {23, "??0iostream@@IAE@ABV0@@Z"},
    {24, "??0iostream@@IAE@XZ"},
    {25, "??0iostream@@QAE@PAVstreambuf@@@Z"},
    {26, "??0istream@@IAE@ABV0@@Z"},
    {27, "??0istream@@IAE@XZ"},
    {28, "??0istream@@QAE@PAVstreambuf@@@Z"},
    {29, "??0istream_withassign@@QAE@ABV0@@Z"},
    {30, "??0istream_withassign@@QAE@PAVstreambuf@@@Z"},
    {31, "??0istream_withassign@@QAE@XZ"},
    {32, "??0istrstream@@QAE@ABV0@@Z"},
    {33, "??0istrstream@@QAE@PAD@Z"},
    {34, "??0istrstream@@QAE@PADH@Z"},
    {35, "??0logic_error@@QAE@ABQBD@Z"},
    {36, "??0logic_error@@QAE@ABV0@@Z"},
    {37, "??0ofstream@@QAE@ABV0@@Z"},
    {38, "??0ofstream@@QAE@H@Z"},
    {39, "??0ofstream@@QAE@HPADH@Z"},
    {40, "??0ofstream@@QAE@PBDHH@Z"},
    {41, "??0ofstream@@QAE@XZ"},
    {42, "??0ostream@@IAE@ABV0@@Z"},
    {43, "??0ostream@@IAE@XZ"},
    {44, "??0ostream@@QAE@PAVstreambuf@@@Z"},
    {45, "??0ostream_withassign@@QAE@ABV0@@Z"},
    {46, "??0ostream_withassign@@QAE@PAVstreambuf@@@Z"},
    {47, "??0ostream_withassign@@QAE@XZ"},
    {48, "??0ostrstream@@QAE@ABV0@@Z"},
    {49, "??0ostrstream@@QAE@PADHH@Z"},
    {50, "??0ostrstream@@QAE@XZ"},
    {51, "??0stdiobuf@@QAE@ABV0@@Z"},
    {52, "??0stdiobuf@@QAE@PAU_iobuf@@@Z"},
    {53, "??0stdiostream@@QAE@ABV0@@Z"},
    {54, "??0stdiostream@@QAE@PAU_iobuf@@@Z"},
    {55, "??0streambuf@@IAE@PADH@Z"},
    {56, "??0streambuf@@IAE@XZ"},
    {57, "??0streambuf@@QAE@ABV0@@Z"},
    {58, "??0strstream@@QAE@ABV0@@Z"},
    {59, "??0strstream@@QAE@PADHH@Z"},
    {60, "??0strstream@@QAE@XZ"},
    {61, "??0strstreambuf@@QAE@ABV0@@Z"},
    {62, "??0strstreambuf@@QAE@H@Z"},
    {63, "??0strstreambuf@@QAE@P6APAXJ@ZP6AXPAX@Z@Z"},
    {64, "??0strstreambuf@@QAE@PADH0@Z"},
    {65, "??0strstreambuf@@QAE@PAEH0@Z"},
    {66, "??0strstreambuf@@QAE@XZ"},
    {67, "??1Iostream_init@@QAE@XZ"},
    {68, "??1exception@@UAE@XZ"},
    {69, "??1filebuf@@UAE@XZ"},
    {70, "??1fstream@@UAE@XZ"},
    {71, "??1ifstream@@UAE@XZ"},
    {72, "??1ios@@UAE@XZ"},
    {73, "??1iostream@@UAE@XZ"},
    {74, "??1istream@@UAE@XZ"},
    {75, "??1istream_withassign@@UAE@XZ"},
    {76, "??1istrstream@@UAE@XZ"},
    {77, "??1logic_error@@UAE@XZ"},
    {78, "??1ofstream@@UAE@XZ"},
    {79, "??1ostream@@UAE@XZ"},
    {80, "??1ostream_withassign@@UAE@XZ"},
    {81, "??1ostrstream@@UAE@XZ"},
    {82, "??1stdiobuf@@UAE@XZ"},
    {83, "??1stdiostream@@UAE@XZ"},
    {84, "??1streambuf@@UAE@XZ"},
    {85, "??1strstream@@UAE@XZ"},
    {86, "??1strstreambuf@@UAE@XZ"},
    {87, "??4Iostream_init@@QAEAAV0@ABV0@@Z"},
    {88, "??4exception@@QAEAAV0@ABV0@@Z"},
    {89, "??4filebuf@@QAEAAV0@ABV0@@Z"},
    {90, "??4fstream@@QAEAAV0@AAV0@@Z"},
    {91, "??4ifstream@@QAEAAV0@ABV0@@Z"},
    {92, "??4ios@@IAEAAV0@ABV0@@Z"},
    {93, "??4iostream@@IAEAAV0@AAV0@@Z"},
    {94, "??4iostream@@IAEAAV0@PAVstreambuf@@@Z"},
    {95, "??4istream@@IAEAAV0@ABV0@@Z"},
    {96, "??4istream@@IAEAAV0@PAVstreambuf@@@Z"},
    {97, "??4istream_withassign@@QAEAAV0@ABV0@@Z"},
    {98, "??4istream_withassign@@QAEAAVistream@@ABV1@@Z"},
    {99, "??4istream_withassign@@QAEAAVistream@@PAVstreambuf@@@Z"},
    {100, "??4istrstream@@QAEAAV0@ABV0@@Z"},
    {101, "??4logic_error@@QAEAAV0@ABV0@@Z"},
    {102, "??4ofstream@@QAEAAV0@ABV0@@Z"},
    {103, "??4ostream@@IAEAAV0@ABV0@@Z"},
    {104, "??4ostream@@IAEAAV0@PAVstreambuf@@@Z"},
    {105, "??4ostream_withassign@@QAEAAV0@ABV0@@Z"},
    {106, "??4ostream_withassign@@QAEAAVostream@@ABV1@@Z"},
    {107, "??4ostream_withassign@@QAEAAVostream@@PAVstreambuf@@@Z"},
    {108, "??4ostrstream@@QAEAAV0@ABV0@@Z"},
    {109, "??4stdiobuf@@QAEAAV0@ABV0@@Z"},
    {110, "??4stdiostream@@QAEAAV0@AAV0@@Z"},
    {111, "??4streambuf@@QAEAAV0@ABV0@@Z"},
    {112, "??4strstream@@QAEAAV0@AAV0@@Z"},
    {113, "??4strstreambuf@@QAEAAV0@ABV0@@Z"},
    {114, "??5istream@@QAEAAV0@AAC@Z"},
    {115, "??5istream@@QAEAAV0@AAD@Z"},
    {116, "??5istream@@QAEAAV0@AAE@Z"},
    {117, "??5istream@@QAEAAV0@AAF@Z"},
    {118, "??5istream@@QAEAAV0@AAG@Z"},
    {119, "??5istream@@QAEAAV0@AAH@Z"},
    {120, "??5istream@@QAEAAV0@AAI@Z"},
    {121, "??5istream@@QAEAAV0@AAJ@Z"},
    {122, "??5istream@@QAEAAV0@AAK@Z"},
    {123, "??5istream@@QAEAAV0@AAM@Z"},
    {124, "??5istream@@QAEAAV0@AAN@Z"},
    {125, "??5istream@@QAEAAV0@AAO@Z"},
    {126, "??5istream@@QAEAAV0@P6AAAV0@AAV0@@Z@Z"},
    {127, "??5istream@@QAEAAV0@P6AAAVios@@AAV1@@Z@Z"},
    {128, "??5istream@@QAEAAV0@PAC@Z"},
    {129, "??5istream@@QAEAAV0@PAD@Z"},
    {130, "??5istream@@QAEAAV0@PAE@Z"},
    {131, "??5istream@@QAEAAV0@PAVstreambuf@@@Z"},
    {132, "??6ostream@@QAEAAV0@C@Z"},
    {133, "??6ostream@@QAEAAV0@D@Z"},
    {134, "??6ostream@@QAEAAV0@E@Z"},
    {135, "??6ostream@@QAEAAV0@F@Z"},
    {136, "??6ostream@@QAEAAV0@G@Z"},
    {137, "??6ostream@@QAEAAV0@H@Z"},
    {138, "??6ostream@@QAEAAV0@I@Z"},
    {139, "??6ostream@@QAEAAV0@J@Z"},
    {140, "??6ostream@@QAEAAV0@K@Z"},
    {141, "??6ostream@@QAEAAV0@M@Z"},
    {142, "??6ostream@@QAEAAV0@N@Z"},
    {143, "??6ostream@@QAEAAV0@O@Z"},
    {144, "??6ostream@@QAEAAV0@P6AAAV0@AAV0@@Z@Z"},
    {145, "??6ostream@@QAEAAV0@P6AAAVios@@AAV1@@Z@Z"},
    {146, "??6ostream@@QAEAAV0@PAVstreambuf@@@Z"},
    {147, "??6ostream@@QAEAAV0@PBC@Z"},
    {148, "??6ostream@@QAEAAV0@PBD@Z"},
    {149, "??6ostream@@QAEAAV0@PBE@Z"},
    {150, "??6ostream@@QAEAAV0@PBX@Z"},
    {151, "??7ios@@QBEHXZ"},
    {152, "??Bios@@QBEPAXXZ"},
    {153, "??_7exception@@6B@"},
    {154, "??_7filebuf@@6B@"},
    {155, "??_7fstream@@6B@"},
    {156, "??_7ifstream@@6B@"},
    {157, "??_7ios@@6B@"},
    {158, "??_7iostream@@6B@"},
    {159, "??_7istream@@6B@"},
    {160, "??_7istream_withassign@@6B@"},
    {161, "??_7istrstream@@6B@"},
    {162, "??_7logic_error@@6B@"},
    {163, "??_7ofstream@@6B@"},
    {164, "??_7ostream@@6B@"},
    {165, "??_7ostream_withassign@@6B@"},
    {166, "??_7ostrstream@@6B@"},
    {167, "??_7stdiobuf@@6B@"},
    {168, "??_7stdiostream@@6B@"},
    {169, "??_7streambuf@@6B@"},
    {170, "??_7strstream@@6B@"},
    {171, "??_7strstreambuf@@6B@"},
    {172, "??_8fstream@@7Bistream@@@"},
    {173, "??_8fstream@@7Bostream@@@"},
    {174, "??_8ifstream@@7B@"},
    {175, "??_8iostream@@7Bistream@@@"},
    {176, "??_8iostream@@7Bostream@@@"},
    {177, "??_8istream@@7B@"},
    {178, "??_8istream_withassign@@7B@"},
    {179, "??_8istrstream@@7B@"},
    {180, "??_8ofstream@@7B@"},
    {181, "??_8ostream@@7B@"},
    {182, "??_8ostream_withassign@@7B@"},
    {183, "??_8ostrstream@@7B@"},
    {184, "??_8stdiostream@@7Bistream@@@"},
    {185, "??_8stdiostream@@7Bostream@@@"},
    {186, "??_8strstream@@7Bistream@@@"},
    {187, "??_8strstream@@7Bostream@@@"},
    {188, "??_Dfstream@@QAEXXZ"},
    {189, "??_Difstream@@QAEXXZ"},
    {190, "??_Diostream@@QAEXXZ"},
    {191, "??_Distream@@QAEXXZ"},
    {192, "??_Distream_withassign@@QAEXXZ"},
    {193, "??_Distrstream@@QAEXXZ"},
    {194, "??_Dofstream@@QAEXXZ"},
    {195, "??_Dostream@@QAEXXZ"},
    {196, "??_Dostream_withassign@@QAEXXZ"},
    {197, "??_Dostrstream@@QAEXXZ"},
    {198, "??_Dstdiostream@@QAEXXZ"},
    {199, "??_Dstrstream@@QAEXXZ"},
    {200, "??_Eexception@@UAEPAXI@Z"},
    {201, "??_Efilebuf@@UAEPAXI@Z"},
    {202, "??_Efstream@@UAEPAXI@Z"},
    {203, "??_Eifstream@@UAEPAXI@Z"},
    {204, "??_Eios@@UAEPAXI@Z"},
    {205, "??_Eiostream@@UAEPAXI@Z"},
    {206, "??_Eistream@@UAEPAXI@Z"},
    {207, "??_Eistream_withassign@@UAEPAXI@Z"},
    {208, "??_Eistrstream@@UAEPAXI@Z"},
    {209, "??_Elogic_error@@UAEPAXI@Z"},
    {210, "??_Eofstream@@UAEPAXI@Z"},
    {211, "??_Eostream@@UAEPAXI@Z"},
    {212, "??_Eostream_withassign@@UAEPAXI@Z"},
    {213, "??_Eostrstream@@UAEPAXI@Z"},
    {214, "??_Estdiobuf@@UAEPAXI@Z"},
    {215, "??_Estdiostream@@UAEPAXI@Z"},
    {216, "??_Estreambuf@@UAEPAXI@Z"},
    {217, "??_Estrstream@@UAEPAXI@Z"},
    {218, "??_Estrstreambuf@@UAEPAXI@Z"},
    {219, "??_Gexception@@UAEPAXI@Z"},
    {220, "??_Gfilebuf@@UAEPAXI@Z"},
    {221, "??_Gfstream@@UAEPAXI@Z"},
    {222, "??_Gifstream@@UAEPAXI@Z"},
    {223, "??_Gios@@UAEPAXI@Z"},
    {224, "??_Giostream@@UAEPAXI@Z"},
    {225, "??_Gistream@@UAEPAXI@Z"},
    {226, "??_Gistream_withassign@@UAEPAXI@Z"},
    {227, "??_Gistrstream@@UAEPAXI@Z"},
    {228, "??_Glogic_error@@UAEPAXI@Z"},
    {229, "??_Gofstream@@UAEPAXI@Z"},
    {230, "??_Gostream@@UAEPAXI@Z"},
    {231, "??_Gostream_withassign@@UAEPAXI@Z"},
    {232, "??_Gostrstream@@UAEPAXI@Z"},
    {233, "??_Gstdiobuf@@UAEPAXI@Z"},
    {234, "??_Gstdiostream@@UAEPAXI@Z"},
    {235, "??_Gstreambuf@@UAEPAXI@Z"},
    {236, "??_Gstrstream@@UAEPAXI@Z"},
    {237, "??_Gstrstreambuf@@UAEPAXI@Z"},
    {238, "?adjustfield@ios@@2JB"},
    {239, "?allocate@streambuf@@IAEHXZ"},
    {240, "?attach@filebuf@@QAEPAV1@H@Z"},
    {241, "?attach@fstream@@QAEXH@Z"},
    {242, "?attach@ifstream@@QAEXH@Z"},
    {243, "?attach@ofstream@@QAEXH@Z"},
    {244, "?bad@ios@@QBEHXZ"},
    {245, "?base@streambuf@@IBEPADXZ"},
    {246, "?basefield@ios@@2JB"},
    {247, "?binary@filebuf@@2HB"},
    {248, "?bitalloc@ios@@SAJXZ"},
    {249, "?blen@streambuf@@IBEHXZ"},
    {250, "?cerr@@3Vostream_withassign@@A"},
    {251, "?cin@@3Vistream_withassign@@A"},
    {252, "?clear@ios@@QAEXH@Z"},
    {253, "?clog@@3Vostream_withassign@@A"},
    {254, "?close@filebuf@@QAEPAV1@XZ"},
    {255, "?close@fstream@@QAEXXZ"},
    {256, "?close@ifstream@@QAEXXZ"},
    {257, "?close@ofstream@@QAEXXZ"},
    {258, "?clrlock@ios@@QAAXXZ"},
    {259, "?clrlock@streambuf@@QAEXXZ"},
    {260, "?cout@@3Vostream_withassign@@A"},
    {261, "?dbp@streambuf@@QAEXXZ"},
    {262, "?dec@@YAAAVios@@AAV1@@Z"},
    {263, "?delbuf@ios@@QAEXH@Z"},
    {264, "?delbuf@ios@@QBEHXZ"},
    {265, "?doallocate@streambuf@@MAEHXZ"},
    {266, "?doallocate@strstreambuf@@MAEHXZ"},
    {267, "?eatwhite@istream@@QAEXXZ"},
    {268, "?eback@streambuf@@IBEPADXZ"},
    {269, "?ebuf@streambuf@@IBEPADXZ"},
    {270, "?egptr@streambuf@@IBEPADXZ"},
    {271, "?endl@@YAAAVostream@@AAV1@@Z"},
    {272, "?ends@@YAAAVostream@@AAV1@@Z"},
    {273, "?eof@ios@@QBEHXZ"},
    {274, "?epptr@streambuf@@IBEPADXZ"},
    {275, "?fLockcInit@ios@@0HA"},
    {276, "?fail@ios@@QBEHXZ"},
    {277, "?fd@filebuf@@QBEHXZ"},
    {278, "?fd@fstream@@QBEHXZ"},
    {279, "?fd@ifstream@@QBEHXZ"},
    {280, "?fd@ofstream@@QBEHXZ"},
    {281, "?fill@ios@@QAEDD@Z"},
    {282, "?fill@ios@@QBEDXZ"},
    {283, "?flags@ios@@QAEJJ@Z"},
    {284, "?flags@ios@@QBEJXZ"},
    {285, "?floatfield@ios@@2JB"},
    {286, "?flush@@YAAAVostream@@AAV1@@Z"},
    {287, "?flush@ostream@@QAEAAV1@XZ"},
    {288, "?freeze@strstreambuf@@QAEXH@Z"},
    {289, "?gbump@streambuf@@IAEXH@Z"},
    {290, "?gcount@istream@@QBEHXZ"},
    {291, "?get@istream@@IAEAAV1@PADHH@Z"},
    {292, "?get@istream@@QAEAAV1@AAC@Z"},
    {293, "?get@istream@@QAEAAV1@AAD@Z"},
    {294, "?get@istream@@QAEAAV1@AAE@Z"},
    {295, "?get@istream@@QAEAAV1@AAVstreambuf@@D@Z"},
    {296, "?get@istream@@QAEAAV1@PACHD@Z"},
    {297, "?get@istream@@QAEAAV1@PADHD@Z"},
    {298, "?get@istream@@QAEAAV1@PAEHD@Z"},
    {299, "?get@istream@@QAEHXZ"},
    {300, "?getdouble@istream@@AAEHPADH@Z"},
    {301, "?getint@istream@@AAEHPAD@Z"},
    {302, "?getline@istream@@QAEAAV1@PACHD@Z"},
    {303, "?getline@istream@@QAEAAV1@PADHD@Z"},
    {304, "?getline@istream@@QAEAAV1@PAEHD@Z"},
    {305, "?good@ios@@QBEHXZ"},
    {306, "?gptr@streambuf@@IBEPADXZ"},
    {307, "?hex@@YAAAVios@@AAV1@@Z"},
    {308, "?ignore@istream@@QAEAAV1@HH@Z"},
    {309, "?in_avail@streambuf@@QBEHXZ"},
    {310, "?init@ios@@IAEXPAVstreambuf@@@Z"},
    {311, "?ipfx@istream@@QAEHH@Z"},
    {312, "?is_open@filebuf@@QBEHXZ"},
    {313, "?is_open@fstream@@QBEHXZ"},
    {314, "?is_open@ifstream@@QBEHXZ"},
    {315, "?is_open@ofstream@@QBEHXZ"},
    {316, "?isfx@istream@@QAEXXZ"},
    {317, "?iword@ios@@QBEAAJH@Z"},
    {318, "?lock@ios@@QAAXXZ"},
    {319, "?lock@streambuf@@QAEXXZ"},
    {320, "?lockbuf@ios@@QAAXXZ"},
    {321, "?lockc@ios@@KAXXZ"},
    {322, "?lockptr@ios@@IAEPAU_CRT_CRITICAL_SECTION@@XZ"},
    {323, "?lockptr@streambuf@@IAEPAU_CRT_CRITICAL_SECTION@@XZ"},
    {324, "?oct@@YAAAVios@@AAV1@@Z"},
    {325, "?open@filebuf@@QAEPAV1@PBDHH@Z"},
    {326, "?open@fstream@@QAEXPBDHH@Z"},
    {327, "?open@ifstream@@QAEXPBDHH@Z"},
    {328, "?open@ofstream@@QAEXPBDHH@Z"},
    {329, "?openprot@filebuf@@2HB"},
    {330, "?opfx@ostream@@QAEHXZ"},
    {331, "?osfx@ostream@@QAEXXZ"},
    {332, "?out_waiting@streambuf@@QBEHXZ"},
    {333, "?overflow@filebuf@@UAEHH@Z"},
    {334, "?overflow@stdiobuf@@UAEHH@Z"},
    {335, "?overflow@strstreambuf@@UAEHH@Z"},
    {336, "?pbackfail@stdiobuf@@UAEHH@Z"},
    {337, "?pbackfail@streambuf@@UAEHH@Z"},
    {338, "?pbase@streambuf@@IBEPADXZ"},
    {339, "?pbump@streambuf@@IAEXH@Z"},
    {340, "?pcount@ostrstream@@QBEHXZ"},
    {341, "?pcount@strstream@@QBEHXZ"},
    {342, "?peek@istream@@QAEHXZ"},
    {343, "?pptr@streambuf@@IBEPADXZ"},
    {344, "?precision@ios@@QAEHH@Z"},
    {345, "?precision@ios@@QBEHXZ"},
    {346, "?put@ostream@@QAEAAV1@C@Z"},
    {347, "?put@ostream@@QAEAAV1@D@Z"},
    {348, "?put@ostream@@QAEAAV1@E@Z"},
    {349, "?putback@istream@@QAEAAV1@D@Z"},
    {350, "?pword@ios@@QBEAAPAXH@Z"},
    {351, "?rdbuf@fstream@@QBEPAVfilebuf@@XZ"},
    {352, "?rdbuf@ifstream@@QBEPAVfilebuf@@XZ"},
    {353, "?rdbuf@ios@@QBEPAVstreambuf@@XZ"},
    {354, "?rdbuf@istrstream@@QBEPAVstrstreambuf@@XZ"},
    {355, "?rdbuf@ofstream@@QBEPAVfilebuf@@XZ"},
    {356, "?rdbuf@ostrstream@@QBEPAVstrstreambuf@@XZ"},
    {357, "?rdbuf@stdiostream@@QBEPAVstdiobuf@@XZ"},
    {358, "?rdbuf@strstream@@QBEPAVstrstreambuf@@XZ"},
    {359, "?rdstate@ios@@QBEHXZ"},
    {360, "?read@istream@@QAEAAV1@PACH@Z"},
    {361, "?read@istream@@QAEAAV1@PADH@Z"},
    {362, "?read@istream@@QAEAAV1@PAEH@Z"},
    {363, "?sbumpc@streambuf@@QAEHXZ"},
    {364, "?seekg@istream@@QAEAAV1@J@Z"},
    {365, "?seekg@istream@@QAEAAV1@JW4seek_dir@ios@@@Z"},
    {366, "?seekoff@filebuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {367, "?seekoff@stdiobuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {368, "?seekoff@streambuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {369, "?seekoff@strstreambuf@@UAEJJW4seek_dir@ios@@H@Z"},
    {370, "?seekp@ostream@@QAEAAV1@J@Z"},
    {371, "?seekp@ostream@@QAEAAV1@JW4seek_dir@ios@@@Z"},
    {372, "?seekpos@streambuf@@UAEJJH@Z"},
    {373, "?setb@streambuf@@IAEXPAD0H@Z"},
    {374, "?setbuf@filebuf@@UAEPAVstreambuf@@PADH@Z"},
    {375, "?setbuf@fstream@@QAEPAVstreambuf@@PADH@Z"},
    {376, "?setbuf@ifstream@@QAEPAVstreambuf@@PADH@Z"},
    {377, "?setbuf@ofstream@@QAEPAVstreambuf@@PADH@Z"},
    {378, "?setbuf@streambuf@@UAEPAV1@PADH@Z"},
    {379, "?setbuf@strstreambuf@@UAEPAVstreambuf@@PADH@Z"},
    {380, "?setf@ios@@QAEJJ@Z"},
    {381, "?setf@ios@@QAEJJJ@Z"},
    {382, "?setg@streambuf@@IAEXPAD00@Z"},
    {383, "?setlock@ios@@QAAXXZ"},
    {384, "?setlock@streambuf@@QAEXXZ"},
    {385, "?setmode@filebuf@@QAEHH@Z"},
    {386, "?setmode@fstream@@QAEHH@Z"},
    {387, "?setmode@ifstream@@QAEHH@Z"},
    {388, "?setmode@ofstream@@QAEHH@Z"},
    {389, "?setp@streambuf@@IAEXPAD0@Z"},
    {390, "?setrwbuf@stdiobuf@@QAEHHH@Z"},
    {391, "?sgetc@streambuf@@QAEHXZ"},
    {392, "?sgetn@streambuf@@QAEHPADH@Z"},
    {393, "?sh_none@filebuf@@2HB"},
    {394, "?sh_read@filebuf@@2HB"},
    {395, "?sh_write@filebuf@@2HB"},
    {396, "?snextc@streambuf@@QAEHXZ"},
    {397, "?sputbackc@streambuf@@QAEHD@Z"},
    {398, "?sputc@streambuf@@QAEHH@Z"},
    {399, "?sputn@streambuf@@QAEHPBDH@Z"},
    {400, "?stdiofile@stdiobuf@@QAEPAU_iobuf@@XZ"},
    {401, "?stossc@streambuf@@QAEXXZ"},
    {402, "?str@istrstream@@QAEPADXZ"},
    {403, "?str@ostrstream@@QAEPADXZ"},
    {404, "?str@strstream@@QAEPADXZ"},
    {405, "?str@strstreambuf@@QAEPADXZ"},
    {406, "?sunk_with_stdio@ios@@0HA"},
    {407, "?sync@filebuf@@UAEHXZ"},
    {408, "?sync@istream@@QAEHXZ"},
    {409, "?sync@stdiobuf@@UAEHXZ"},
    {410, "?sync@streambuf@@UAEHXZ"},
    {411, "?sync@strstreambuf@@UAEHXZ"},
    {412, "?sync_with_stdio@ios@@SAXXZ"},
    {413, "?tellg@istream@@QAEJXZ"},
    {414, "?tellp@ostream@@QAEJXZ"},
    {415, "?text@filebuf@@2HB"},
    {416, "?tie@ios@@QAEPAVostream@@PAV2@@Z"},
    {417, "?tie@ios@@QBEPAVostream@@XZ"},
    {418, "?unbuffered@streambuf@@IAEXH@Z"},
    {419, "?unbuffered@streambuf@@IBEHXZ"},
    {420, "?underflow@filebuf@@UAEHXZ"},
    {421, "?underflow@stdiobuf@@UAEHXZ"},
    {422, "?underflow@strstreambuf@@UAEHXZ"},
    {423, "?unlock@ios@@QAAXXZ"},
    {424, "?unlock@streambuf@@QAEXXZ"},
    {425, "?unlockbuf@ios@@QAAXXZ"},
    {426, "?unlockc@ios@@KAXXZ"},
    {427, "?unsetf@ios@@QAEJJ@Z"},
    {428, "?what@exception@@UBEPBDXZ"},
    {429, "?width@ios@@QAEHH@Z"},
    {430, "?width@ios@@QBEHXZ"},
    {431, "?write@ostream@@QAEAAV1@PBCH@Z"},
    {432, "?write@ostream@@QAEAAV1@PBDH@Z"},
    {433, "?write@ostream@@QAEAAV1@PBEH@Z"},
    {434, "?writepad@ostream@@AAEAAV1@PBD0@Z"},
    {435, "?ws@@YAAAVistream@@AAV1@@Z"},
    {436, "?x_curindex@ios@@0HA"},
    {437, "?x_lockc@ios@@0U_CRT_CRITICAL_SECTION@@A"},
    {438, "?x_maxbit@ios@@0JA"},
    {439, "?x_statebuf@ios@@0PAJA"},
    {440, "?xalloc@ios@@SAHXZ"},
    {441, "?xsgetn@streambuf@@UAEHPADH@Z"},
    {442, "?xsputn@streambuf@@UAEHPBDH@Z"},
    {443, "__dummy_export"},
    {444, "_mtlock"},
    {445, "_mtunlock"},
    {0, NULL}};
static Dw32Ordinal msvcrt[] = {
    {59, "$I10_OUTPUT"},
    {1, "??0__non_rtti_object@@QAE@ABV0@@Z"},
    {2, "??0__non_rtti_object@@QAE@PBD@Z"},
    {3, "??0bad_cast@@AAE@PBQBD@Z"},
    {4, "??0bad_cast@@QAE@ABQBD@Z"},
    {5, "??0bad_cast@@QAE@ABV0@@Z"},
    {6, "??0bad_cast@@QAE@PBD@Z"},
    {7, "??0bad_typeid@@QAE@ABV0@@Z"},
    {8, "??0bad_typeid@@QAE@PBD@Z"},
    {9, "??0exception@@QAE@ABQBD@Z"},
    {10, "??0exception@@QAE@ABQBDH@Z"},
    {11, "??0exception@@QAE@ABV0@@Z"},
    {12, "??0exception@@QAE@XZ"},
    {13, "??1__non_rtti_object@@UAE@XZ"},
    {14, "??1bad_cast@@UAE@XZ"},
    {15, "??1bad_typeid@@UAE@XZ"},
    {16, "??1exception@@UAE@XZ"},
    {17, "??1type_info@@UAE@XZ"},
    {18, "??2@YAPAXI@Z"},
    {19, "??2@YAPAXIHPBDH@Z"},
    {20, "??3@YAXPAX@Z"},
    {21, "??4__non_rtti_object@@QAEAAV0@ABV0@@Z"},
    {22, "??4bad_cast@@QAEAAV0@ABV0@@Z"},
    {23, "??4bad_typeid@@QAEAAV0@ABV0@@Z"},
    {24, "??4exception@@QAEAAV0@ABV0@@Z"},
    {25, "??8type_info@@QBEHABV0@@Z"},
    {26, "??9type_info@@QBEHABV0@@Z"},
    {27, "??_7__non_rtti_object@@6B@"},
    {28, "??_7bad_cast@@6B@"},
    {29, "??_7bad_typeid@@6B@"},
    {30, "??_7exception@@6B@"},
    {31, "??_E__non_rtti_object@@UAEPAXI@Z"},
    {32, "??_Ebad_cast@@UAEPAXI@Z"},
    {33, "??_Ebad_typeid@@UAEPAXI@Z"},
    {34, "??_Eexception@@UAEPAXI@Z"},
    {35, "??_Fbad_cast@@QAEXXZ"},
    {36, "??_Fbad_typeid@@QAEXXZ"},
    {37, "??_G__non_rtti_object@@UAEPAXI@Z"},
    {38, "??_Gbad_cast@@UAEPAXI@Z"},
    {39, "??_Gbad_typeid@@UAEPAXI@Z"},
    {40, "??_Gexception@@UAEPAXI@Z"},
    {41, "??_U@YAPAXI@Z"},
    {42, "??_U@YAPAXIHPBDH@Z"},
    {43, "??_V@YAXPAX@Z"},
    {45, "?_query_new_handler@@YAP6AHI@ZXZ"},
    {46, "?_query_new_mode@@YAHXZ"},
    {47, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"},
    {48, "?_set_new_mode@@YAHH@Z"},
    {49, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"},
    {50, "?before@type_info@@QBEHABV1@@Z"},
    {51, "?name@type_info@@QBEPBDXZ"},
    {52, "?raw_name@type_info@@QBEPBDXZ"},
    {53, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"},
    {54, "?set_terminate@@YAP6AXXZP6AXXZ@Z"},
    {55, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"},
    {56, "?terminate@@YAXXZ"},
    {57, "?unexpected@@YAXXZ"},
    {58, "?what@exception@@UBEPBDXZ"},
    {60, "_CIacos"},
    {61, "_CIasin"},
    {62, "_CIatan"},
    {63, "_CIatan2"},
    {64, "_CIcos"},
    {65, "_CIcosh"},
    {66, "_CIexp"},
    {67, "_CIfmod"},
    {68, "_CIlog"},
    {69, "_CIlog10"},
    {70, "_CIpow"},
    {71, "_CIsin"},
    {72, "_CIsinh"},
    {73, "_CIsqrt"},
    {74, "_CItan"},
    {75, "_CItanh"},
    {76, "_CrtCheckMemory"},
    {77, "_CrtDbgBreak"},
    {78, "_CrtDbgReport"},
    {79, "_CrtDbgReportV"},
    {80, "_CrtDbgReportW"},
    {81, "_CrtDbgReportWV"},
    {82, "_CrtDoForAllClientObjects"},
    {83, "_CrtDumpMemoryLeaks"},
    {84, "_CrtIsMemoryBlock"},
    {85, "_CrtIsValidHeapPointer"},
    {86, "_CrtIsValidPointer"},
    {87, "_CrtMemCheckpoint"},
    {88, "_CrtMemDifference"},
    {89, "_CrtMemDumpAllObjectsSince"},
    {90, "_CrtMemDumpStatistics"},
    {91, "_CrtReportBlockType"},
    {92, "_CrtSetAllocHook"},
    {93, "_CrtSetBreakAlloc"},
    {94, "_CrtSetDbgBlockType"},
    {95, "_CrtSetDbgFlag"},
    {96, "_CrtSetDumpClient"},
    {97, "_CrtSetReportFile"},
    {98, "_CrtSetReportHook"},
    {99, "_CrtSetReportHook2"},
    {100, "_CrtSetReportMode"},
    {101, "_CxxThrowException"},
    {102, "_EH_prolog"},
    {103, "_Getdays"},
    {104, "_Getmonths"},
    {105, "_Gettnames"},
    {106, "_HUGE"},
    {107, "_Strftime"},
    {108, "_XcptFilter"},
    {109, "__CppXcptFilter"},
    {110, "__CxxCallUnwindDelDtor"},
    {111, "__CxxCallUnwindDtor"},
    {112, "__CxxCallUnwindVecDtor"},
    {113, "__CxxDetectRethrow"},
    {114, "__CxxExceptionFilter"},
    {115, "__CxxFrameHandler"},
    {116, "__CxxFrameHandler2"},
    {117, "__CxxFrameHandler3"},
    {118, "__CxxLongjmpUnwind"},
    {119, "__CxxQueryExceptionSize"},
    {120, "__CxxRegisterExceptionObject"},
    {121, "__CxxUnregisterExceptionObject"},
    {122, "__DestructExceptionObject"},
    {123, "__RTCastToVoid"},
    {124, "__RTDynamicCast"},
    {125, "__RTtypeid"},
    {126, "__STRINGTOLD"},
    {127, "___lc_codepage_func"},
    {128, "___lc_collate_cp_func"},
    {129, "___lc_handle_func"},
    {130, "___mb_cur_max_func"},
    {131, "___setlc_active_func"},
    {132, "___unguarded_readlc_active_add_func"},
    {133, "__argc"},
    {134, "__argv"},
    {135, "__badioinfo"},
    {136, "__crtCompareStringA"},
    {137, "__crtCompareStringW"},
    {138, "__crtGetLocaleInfoW"},
    {139, "__crtGetStringTypeW"},
    {140, "__crtLCMapStringA"},
    {141, "__crtLCMapStringW"},
    {142, "__daylight"},
    {143, "__dllonexit"},
    {144, "__doserrno"},
    {145, "__dstbias"},
    {146, "__fpecode"},
    {147, "__getmainargs"},
    {148, "__initenv"},
    {149, "__iob_func"},
    {150, "__isascii"},
    {151, "__iscsym"},
    {152, "__iscsymf"},
    {153, "__lc_codepage"},
    {154, "__lc_collate_cp"},
    {155, "__lc_handle"},
    {156, "__lconv_init"},
    {157, "__libm_sse2_acos"},
    {158, "__libm_sse2_acosf"},
    {159, "__libm_sse2_asin"},
    {160, "__libm_sse2_asinf"},
    {161, "__libm_sse2_atan"},
    {162, "__libm_sse2_atan2"},
    {163, "__libm_sse2_atanf"},
    {164, "__libm_sse2_cos"},
    {165, "__libm_sse2_cosf"},
    {166, "__libm_sse2_exp"},
    {167, "__libm_sse2_expf"},
    {168, "__libm_sse2_log"},
    {169, "__libm_sse2_log10"},
    {170, "__libm_sse2_log10f"},
    {171, "__libm_sse2_logf"},
    {172, "__libm_sse2_pow"},
    {173, "__libm_sse2_powf"},
    {174, "__libm_sse2_sin"},
    {175, "__libm_sse2_sinf"},
    {176, "__libm_sse2_tan"},
    {177, "__libm_sse2_tanf"},
    {178, "__mb_cur_max"},
    {179, "__p___argc"},
    {180, "__p___argv"},
    {181, "__p___initenv"},
    {182, "__p___mb_cur_max"},
    {183, "__p___wargv"},
    {184, "__p___winitenv"},
    {185, "__p__acmdln"},
    {186, "__p__amblksiz"},
    {187, "__p__commode"},
    {188, "__p__daylight"},
    {189, "__p__dstbias"},
    {190, "__p__environ"},
    {191, "__p__fileinfo"},
    {192, "__p__fmode"},
    {193, "__p__iob"},
    {194, "__p__mbcasemap"},
    {195, "__p__mbctype"},
    {196, "__p__osver"},
    {197, "__p__pctype"},
    {198, "__p__pgmptr"},
    {199, "__p__pwctype"},
    {200, "__p__timezone"},
    {201, "__p__tzname"},
    {202, "__p__wcmdln"},
    {203, "__p__wenviron"},
    {204, "__p__winmajor"},
    {205, "__p__winminor"},
    {206, "__p__winver"},
    {207, "__p__wpgmptr"},
    {208, "__pctype_func"},
    {209, "__pioinfo"},
    {210, "__pwctype_func"},
    {211, "__pxcptinfoptrs"},
    {212, "__set_app_type"},
    {213, "__setlc_active"},
    {214, "__setusermatherr"},
    {215, "__strncnt"},
    {216, "__threadhandle"},
    {217, "__threadid"},
    {218, "__toascii"},
    {219, "__unDName"},
    {220, "__unDNameEx"},
    {44, "__uncaught_exception"},
    {221, "__unguarded_readlc_active"},
    {222, "__wargv"},
    {223, "__wcserror"},
    {224, "__wcserror_s"},
    {225, "__wcsncnt"},
    {226, "__wgetmainargs"},
    {227, "__winitenv"},
    {228, "_abnormal_termination"},
    {229, "_abs64"},
    {230, "_access"},
    {231, "_access_s"},
    {232, "_acmdln"},
    {233, "_adj_fdiv_m16i"},
    {234, "_adj_fdiv_m32"},
    {235, "_adj_fdiv_m32i"},
    {236, "_adj_fdiv_m64"},
    {237, "_adj_fdiv_r"},
    {238, "_adj_fdivr_m16i"},
    {239, "_adj_fdivr_m32"},
    {240, "_adj_fdivr_m32i"},
    {241, "_adj_fdivr_m64"},
    {242, "_adj_fpatan"},
    {243, "_adj_fprem"},
    {244, "_adj_fprem1"},
    {245, "_adj_fptan"},
    {246, "_adjust_fdiv"},
    {247, "_aexit_rtn"},
    {248, "_aligned_free"},
    {249, "_aligned_free_dbg"},
    {250, "_aligned_malloc"},
    {251, "_aligned_malloc_dbg"},
    {252, "_aligned_offset_malloc"},
    {253, "_aligned_offset_malloc_dbg"},
    {254, "_aligned_offset_realloc"},
    {255, "_aligned_offset_realloc_dbg"},
    {256, "_aligned_realloc"},
    {257, "_aligned_realloc_dbg"},
    {258, "_amsg_exit"},
    {259, "_assert"},
    {260, "_atodbl"},
    {261, "_atodbl_l"},
    {262, "_atof_l"},
    {263, "_atoflt_l"},
    {264, "_atoi64"},
    {265, "_atoi64_l"},
    {266, "_atoi_l"},
    {267, "_atol_l"},
    {268, "_atoldbl"},
    {269, "_atoldbl_l"},
    {270, "_beep"},
    {271, "_beginthread"},
    {272, "_beginthreadex"},
    {273, "_c_exit"},
    {274, "_cabs"},
    {275, "_callnewh"},
    {276, "_calloc_dbg"},
    {277, "_cexit"},
    {278, "_cgets"},
    {279, "_cgets_s"},
    {280, "_cgetws"},
    {281, "_cgetws_s"},
    {282, "_chdir"},
    {283, "_chdrive"},
    {284, "_chgsign"},
    {285, "_chkesp"},
    {286, "_chmod"},
    {287, "_chsize"},
    {288, "_chsize_s"},
    {289, "_chvalidator"},
    {290, "_chvalidator_l"},
    {291, "_clearfp"},
    {292, "_close"},
    {293, "_commit"},
    {294, "_commode"},
    {295, "_control87"},
    {296, "_controlfp"},
    {297, "_controlfp_s"},
    {298, "_copysign"},
    {299, "_cprintf"},
    {300, "_cprintf_l"},
    {301, "_cprintf_p"},
    {302, "_cprintf_p_l"},
    {303, "_cprintf_s"},
    {304, "_cprintf_s_l"},
    {305, "_cputs"},
    {306, "_cputws"},
    {307, "_creat"},
    {308, "_crtAssertBusy"},
    {309, "_crtBreakAlloc"},
    {310, "_crtDbgFlag"},
    {311, "_cscanf"},
    {312, "_cscanf_l"},
    {313, "_cscanf_s"},
    {314, "_cscanf_s_l"},
    {315, "_ctime32"},
    {316, "_ctime32_s"},
    {317, "_ctime64"},
    {318, "_ctime64_s"},
    {319, "_ctype"},
    {320, "_cwait"},
    {321, "_cwprintf"},
    {322, "_cwprintf_l"},
    {323, "_cwprintf_p"},
    {324, "_cwprintf_p_l"},
    {325, "_cwprintf_s"},
    {326, "_cwprintf_s_l"},
    {327, "_cwscanf"},
    {328, "_cwscanf_l"},
    {329, "_cwscanf_s"},
    {330, "_cwscanf_s_l"},
    {331, "_daylight"},
    {332, "_difftime32"},
    {333, "_difftime64"},
    {334, "_dstbias"},
    {335, "_dup"},
    {336, "_dup2"},
    {337, "_ecvt"},
    {338, "_ecvt_s"},
    {339, "_endthread"},
    {340, "_endthreadex"},
    {341, "_environ"},
    {342, "_eof"},
    {343, "_errno"},
    {344, "_except_handler2"},
    {345, "_except_handler3"},
    {346, "_except_handler4_common"},
    {347, "_execl"},
    {348, "_execle"},
    {349, "_execlp"},
    {350, "_execlpe"},
    {351, "_execv"},
    {352, "_execve"},
    {353, "_execvp"},
    {354, "_execvpe"},
    {355, "_exit"},
    {356, "_expand"},
    {357, "_expand_dbg"},
    {358, "_fcloseall"},
    {359, "_fcvt"},
    {360, "_fcvt_s"},
    {361, "_fdopen"},
    {362, "_fgetchar"},
    {363, "_fgetwchar"},
    {364, "_filbuf"},
    {365, "_fileinfo"},
    {366, "_filelength"},
    {367, "_filelengthi64"},
    {368, "_fileno"},
    {369, "_findclose"},
    {370, "_findfirst"},
    {371, "_findfirst64"},
    {372, "_findfirsti64"},
    {373, "_findnext"},
    {374, "_findnext64"},
    {375, "_findnexti64"},
    {376, "_finite"},
    {377, "_flsbuf"},
    {378, "_flushall"},
    {379, "_fmode"},
    {380, "_fpclass"},
    {381, "_fpieee_flt"},
    {382, "_fpreset"},
    {383, "_fprintf_l"},
    {384, "_fprintf_p"},
    {385, "_fprintf_p_l"},
    {386, "_fprintf_s_l"},
    {387, "_fputchar"},
    {388, "_fputwchar"},
    {389, "_free_dbg"},
    {390, "_freea"},
    {391, "_freea_s"},
    {392, "_fscanf_l"},
    {393, "_fscanf_s_l"},
    {394, "_fseeki64"},
    {395, "_fsopen"},
    {396, "_fstat"},
    {397, "_fstat64"},
    {398, "_fstati64"},
    {399, "_ftime"},
    {400, "_ftime32"},
    {401, "_ftime32_s"},
    {402, "_ftime64"},
    {403, "_ftime64_s"},
    {404, "_ftol"},
    {405, "_ftol2"},
    {406, "_ftol2_sse"},
    {407, "_ftol2_sse_excpt"},
    {408, "_fullpath"},
    {409, "_fullpath_dbg"},
    {410, "_futime"},
    {411, "_futime32"},
    {412, "_futime64"},
    {413, "_fwprintf_l"},
    {414, "_fwprintf_p"},
    {415, "_fwprintf_p_l"},
    {416, "_fwprintf_s_l"},
    {417, "_fwscanf_l"},
    {418, "_fwscanf_s_l"},
    {419, "_gcvt"},
    {420, "_gcvt_s"},
    {421, "_get_doserrno"},
    {422, "_get_environ"},
    {423, "_get_errno"},
    {424, "_get_fileinfo"},
    {425, "_get_fmode"},
    {426, "_get_heap_handle"},
    {427, "_get_osfhandle"},
    {428, "_get_osplatform"},
    {429, "_get_osver"},
    {430, "_get_output_format"},
    {431, "_get_pgmptr"},
    {432, "_get_sbh_threshold"},
    {433, "_get_wenviron"},
    {434, "_get_winmajor"},
    {435, "_get_winminor"},
    {436, "_get_winver"},
    {437, "_get_wpgmptr"},
    {438, "_getch"},
    {439, "_getche"},
    {440, "_getcwd"},
    {441, "_getdcwd"},
    {442, "_getdiskfree"},
    {443, "_getdllprocaddr"},
    {444, "_getdrive"},
    {445, "_getdrives"},
    {446, "_getmaxstdio"},
    {447, "_getmbcp"},
    {448, "_getpid"},
    {449, "_getsystime"},
    {450, "_getw"},
    {451, "_getwch"},
    {452, "_getwche"},
    {453, "_getws"},
    {454, "_global_unwind2"},
    {455, "_gmtime32"},
    {456, "_gmtime32_s"},
    {457, "_gmtime64"},
    {458, "_gmtime64_s"},
    {459, "_heapadd"},
    {460, "_heapchk"},
    {461, "_heapmin"},
    {462, "_heapset"},
    {463, "_heapused"},
    {464, "_heapwalk"},
    {465, "_hypot"},
    {466, "_i64toa"},
    {467, "_i64toa_s"},
    {468, "_i64tow"},
    {469, "_i64tow_s"},
    {470, "_initterm"},
    {471, "_initterm_e"},
    {472, "_inp"},
    {473, "_inpd"},
    {474, "_inpw"},
    {475, "_invalid_parameter"},
    {476, "_iob"},
    {477, "_isalnum_l"},
    {478, "_isalpha_l"},
    {479, "_isatty"},
    {480, "_iscntrl_l"},
    {481, "_isctype"},
    {482, "_isctype_l"},
    {483, "_isdigit_l"},
    {484, "_isgraph_l"},
    {485, "_isleadbyte_l"},
    {486, "_islower_l"},
    {487, "_ismbbalnum"},
    {488, "_ismbbalnum_l"},
    {489, "_ismbbalpha"},
    {490, "_ismbbalpha_l"},
    {491, "_ismbbgraph"},
    {492, "_ismbbgraph_l"},
    {493, "_ismbbkalnum"},
    {494, "_ismbbkalnum_l"},
    {495, "_ismbbkana"},
    {496, "_ismbbkana_l"},
    {497, "_ismbbkprint"},
    {498, "_ismbbkprint_l"},
    {499, "_ismbbkpunct"},
    {500, "_ismbbkpunct_l"},
    {501, "_ismbblead"},
    {502, "_ismbblead_l"},
    {503, "_ismbbprint"},
    {504, "_ismbbprint_l"},
    {505, "_ismbbpunct"},
    {506, "_ismbbpunct_l"},
    {507, "_ismbbtrail"},
    {508, "_ismbbtrail_l"},
    {509, "_ismbcalnum"},
    {510, "_ismbcalnum_l"},
    {511, "_ismbcalpha"},
    {512, "_ismbcalpha_l"},
    {513, "_ismbcdigit"},
    {514, "_ismbcdigit_l"},
    {515, "_ismbcgraph"},
    {516, "_ismbcgraph_l"},
    {517, "_ismbchira"},
    {518, "_ismbchira_l"},
    {519, "_ismbckata"},
    {520, "_ismbckata_l"},
    {521, "_ismbcl0"},
    {522, "_ismbcl0_l"},
    {523, "_ismbcl1"},
    {524, "_ismbcl1_l"},
    {525, "_ismbcl2"},
    {526, "_ismbcl2_l"},
    {527, "_ismbclegal"},
    {528, "_ismbclegal_l"},
    {529, "_ismbclower"},
    {530, "_ismbclower_l"},
    {531, "_ismbcprint"},
    {532, "_ismbcprint_l"},
    {533, "_ismbcpunct"},
    {534, "_ismbcpunct_l"},
    {535, "_ismbcspace"},
    {536, "_ismbcspace_l"},
    {537, "_ismbcsymbol"},
    {538, "_ismbcsymbol_l"},
    {539, "_ismbcupper"},
    {540, "_ismbcupper_l"},
    {541, "_ismbslead"},
    {542, "_ismbslead_l"},
    {543, "_ismbstrail"},
    {544, "_ismbstrail_l"},
    {545, "_isnan"},
    {546, "_isprint_l"},
    {547, "_isspace_l"},
    {548, "_isupper_l"},
    {549, "_iswalnum_l"},
    {550, "_iswalpha_l"},
    {551, "_iswcntrl_l"},
    {552, "_iswctype_l"},
    {553, "_iswdigit_l"},
    {554, "_iswgraph_l"},
    {555, "_iswlower_l"},
    {556, "_iswprint_l"},
    {557, "_iswpunct_l"},
    {558, "_iswspace_l"},
    {559, "_iswupper_l"},
    {560, "_iswxdigit_l"},
    {561, "_isxdigit_l"},
    {562, "_itoa"},
    {563, "_itoa_s"},
    {564, "_itow"},
    {565, "_itow_s"},
    {566, "_j0"},
    {567, "_j1"},
    {568, "_jn"},
    {569, "_kbhit"},
    {570, "_lfind"},
    {571, "_lfind_s"},
    {572, "_loaddll"},
    {573, "_local_unwind2"},
    {574, "_local_unwind4"},
    {575, "_localtime32"},
    {576, "_localtime32_s"},
    {577, "_localtime64"},
    {578, "_localtime64_s"},
    {579, "_lock"},
    {580, "_locking"},
    {581, "_logb"},
    {582, "_longjmpex"},
    {583, "_lrotl"},
    {584, "_lrotr"},
    {585, "_lsearch"},
    {586, "_lsearch_s"},
    {587, "_lseek"},
    {588, "_lseeki64"},
    {589, "_ltoa"},
    {590, "_ltoa_s"},
    {591, "_ltow"},
    {592, "_ltow_s"},
    {593, "_makepath"},
    {594, "_makepath_s"},
    {595, "_malloc_dbg"},
    {596, "_mbbtombc"},
    {597, "_mbbtombc_l"},
    {598, "_mbbtype"},
    {599, "_mbcasemap"},
    {600, "_mbccpy"},
    {601, "_mbccpy_l"},
    {602, "_mbccpy_s"},
    {603, "_mbccpy_s_l"},
    {604, "_mbcjistojms"},
    {605, "_mbcjistojms_l"},
    {606, "_mbcjmstojis"},
    {607, "_mbcjmstojis_l"},
    {608, "_mbclen"},
    {609, "_mbclen_l"},
    {610, "_mbctohira"},
    {611, "_mbctohira_l"},
    {612, "_mbctokata"},
    {613, "_mbctokata_l"},
    {614, "_mbctolower"},
    {615, "_mbctolower_l"},
    {616, "_mbctombb"},
    {617, "_mbctombb_l"},
    {618, "_mbctoupper"},
    {619, "_mbctoupper_l"},
    {620, "_mbctype"},
    {621, "_mblen_l"},
    {622, "_mbsbtype"},
    {623, "_mbsbtype_l"},
    {624, "_mbscat"},
    {625, "_mbscat_s"},
    {626, "_mbscat_s_l"},
    {627, "_mbschr"},
    {628, "_mbschr_l"},
    {629, "_mbscmp"},
    {630, "_mbscmp_l"},
    {631, "_mbscoll"},
    {632, "_mbscoll_l"},
    {633, "_mbscpy"},
    {634, "_mbscpy_s"},
    {635, "_mbscpy_s_l"},
    {636, "_mbscspn"},
    {637, "_mbscspn_l"},
    {638, "_mbsdec"},
    {639, "_mbsdec_l"},
    {640, "_mbsdup"},
    {641, "_mbsicmp"},
    {642, "_mbsicmp_l"},
    {643, "_mbsicoll"},
    {644, "_mbsicoll_l"},
    {645, "_mbsinc"},
    {646, "_mbsinc_l"},
    {647, "_mbslen"},
    {648, "_mbslen_l"},
    {649, "_mbslwr"},
    {650, "_mbslwr_l"},
    {651, "_mbslwr_s"},
    {652, "_mbslwr_s_l"},
    {653, "_mbsnbcat"},
    {654, "_mbsnbcat_l"},
    {655, "_mbsnbcat_s"},
    {656, "_mbsnbcat_s_l"},
    {657, "_mbsnbcmp"},
    {658, "_mbsnbcmp_l"},
    {659, "_mbsnbcnt"},
    {660, "_mbsnbcnt_l"},
    {661, "_mbsnbcoll"},
    {662, "_mbsnbcoll_l"},
    {663, "_mbsnbcpy"},
    {664, "_mbsnbcpy_l"},
    {665, "_mbsnbcpy_s"},
    {666, "_mbsnbcpy_s_l"},
    {667, "_mbsnbicmp"},
    {668, "_mbsnbicmp_l"},
    {669, "_mbsnbicoll"},
    {670, "_mbsnbicoll_l"},
    {671, "_mbsnbset"},
    {672, "_mbsnbset_l"},
    {673, "_mbsnbset_s"},
    {674, "_mbsnbset_s_l"},
    {675, "_mbsncat"},
    {676, "_mbsncat_l"},
    {677, "_mbsncat_s"},
    {678, "_mbsncat_s_l"},
    {679, "_mbsnccnt"},
    {680, "_mbsnccnt_l"},
    {681, "_mbsncmp"},
    {682, "_mbsncmp_l"},
    {683, "_mbsncoll"},
    {684, "_mbsncoll_l"},
    {685, "_mbsncpy"},
    {686, "_mbsncpy_l"},
    {687, "_mbsncpy_s"},
    {688, "_mbsncpy_s_l"},
    {689, "_mbsnextc"},
    {690, "_mbsnextc_l"},
    {691, "_mbsnicmp"},
    {692, "_mbsnicmp_l"},
    {693, "_mbsnicoll"},
    {694, "_mbsnicoll_l"},
    {695, "_mbsninc"},
    {696, "_mbsninc_l"},
    {697, "_mbsnlen"},
    {698, "_mbsnlen_l"},
    {699, "_mbsnset"},
    {700, "_mbsnset_l"},
    {701, "_mbsnset_s"},
    {702, "_mbsnset_s_l"},
    {703, "_mbspbrk"},
    {704, "_mbspbrk_l"},
    {705, "_mbsrchr"},
    {706, "_mbsrchr_l"},
    {707, "_mbsrev"},
    {708, "_mbsrev_l"},
    {709, "_mbsset"},
    {710, "_mbsset_l"},
    {711, "_mbsset_s"},
    {712, "_mbsset_s_l"},
    {713, "_mbsspn"},
    {714, "_mbsspn_l"},
    {715, "_mbsspnp"},
    {716, "_mbsspnp_l"},
    {717, "_mbsstr"},
    {718, "_mbsstr_l"},
    {719, "_mbstok"},
    {720, "_mbstok_l"},
    {721, "_mbstok_s"},
    {722, "_mbstok_s_l"},
    {723, "_mbstowcs_l"},
    {724, "_mbstowcs_s_l"},
    {725, "_mbstrlen"},
    {726, "_mbstrlen_l"},
    {727, "_mbstrnlen"},
    {728, "_mbstrnlen_l"},
    {729, "_mbsupr"},
    {730, "_mbsupr_l"},
    {731, "_mbsupr_s"},
    {732, "_mbsupr_s_l"},
    {733, "_mbtowc_l"},
    {734, "_memccpy"},
    {735, "_memicmp"},
    {736, "_memicmp_l"},
    {737, "_mkdir"},
    {738, "_mkgmtime"},
    {739, "_mkgmtime32"},
    {740, "_mkgmtime64"},
    {741, "_mktemp"},
    {742, "_mktemp_s"},
    {743, "_mktime32"},
    {744, "_mktime64"},
    {745, "_msize"},
    {746, "_msize_debug"},
    {747, "_nextafter"},
    {748, "_onexit"},
    {749, "_open"},
    {750, "_open_osfhandle"},
    {751, "_osplatform"},
    {752, "_osver"},
    {753, "_outp"},
    {754, "_outpd"},
    {755, "_outpw"},
    {756, "_pclose"},
    {757, "_pctype"},
    {758, "_pgmptr"},
    {759, "_pipe"},
    {760, "_popen"},
    {761, "_printf_l"},
    {762, "_printf_p"},
    {763, "_printf_p_l"},
    {764, "_printf_s_l"},
    {765, "_purecall"},
    {766, "_putch"},
    {767, "_putenv"},
    {768, "_putenv_s"},
    {769, "_putw"},
    {770, "_putwch"},
    {771, "_putws"},
    {772, "_pwctype"},
    {773, "_read"},
    {774, "_realloc_dbg"},
    {775, "_resetstkoflw"},
    {776, "_rmdir"},
    {777, "_rmtmp"},
    {778, "_rotl"},
    {779, "_rotl64"},
    {780, "_rotr"},
    {781, "_rotr64"},
    {782, "_safe_fdiv"},
    {783, "_safe_fdivr"},
    {784, "_safe_fprem"},
    {785, "_safe_fprem1"},
    {786, "_scalb"},
    {787, "_scanf_l"},
    {788, "_scanf_s_l"},
    {789, "_scprintf"},
    {790, "_scprintf_l"},
    {791, "_scprintf_p_l"},
    {792, "_scwprintf"},
    {793, "_scwprintf_l"},
    {794, "_scwprintf_p_l"},
    {795, "_searchenv"},
    {796, "_searchenv_s"},
    {798, "_seh_longjmp_unwind"},
    {797, "_seh_longjmp_unwind4"},
    {799, "_set_SSE2_enable"},
    {800, "_set_controlfp"},
    {801, "_set_doserrno"},
    {802, "_set_errno"},
    {803, "_set_error_mode"},
    {804, "_set_fileinfo"},
    {805, "_set_fmode"},
    {806, "_set_output_format"},
    {807, "_set_sbh_threshold"},
    {808, "_seterrormode"},
    {809, "_setjmp"},
    {810, "_setjmp3"},
    {811, "_setmaxstdio"},
    {812, "_setmbcp"},
    {813, "_setmode"},
    {814, "_setsystime"},
    {815, "_sleep"},
    {816, "_snprintf"},
    {817, "_snprintf_c"},
    {818, "_snprintf_c_l"},
    {819, "_snprintf_l"},
    {820, "_snprintf_s"},
    {821, "_snprintf_s_l"},
    {822, "_snscanf"},
    {823, "_snscanf_l"},
    {824, "_snscanf_s"},
    {825, "_snscanf_s_l"},
    {826, "_snwprintf"},
    {827, "_snwprintf_l"},
    {828, "_snwprintf_s"},
    {829, "_snwprintf_s_l"},
    {830, "_snwscanf"},
    {831, "_snwscanf_l"},
    {832, "_snwscanf_s"},
    {833, "_snwscanf_s_l"},
    {834, "_sopen"},
    {835, "_sopen_s"},
    {836, "_spawnl"},
    {837, "_spawnle"},
    {838, "_spawnlp"},
    {839, "_spawnlpe"},
    {840, "_spawnv"},
    {841, "_spawnve"},
    {842, "_spawnvp"},
    {843, "_spawnvpe"},
    {844, "_splitpath"},
    {845, "_splitpath_s"},
    {846, "_sprintf_l"},
    {847, "_sprintf_p_l"},
    {848, "_sprintf_s_l"},
    {849, "_sscanf_l"},
    {850, "_sscanf_s_l"},
    {851, "_stat"},
    {852, "_stat64"},
    {853, "_stati64"},
    {854, "_statusfp"},
    {855, "_strcmpi"},
    {856, "_strcoll_l"},
    {857, "_strdate"},
    {858, "_strdate_s"},
    {859, "_strdup"},
    {860, "_strdup_dbg"},
    {861, "_strerror"},
    {862, "_strerror_s"},
    {863, "_stricmp"},
    {864, "_stricmp_l"},
    {865, "_stricoll"},
    {866, "_stricoll_l"},
    {867, "_strlwr"},
    {868, "_strlwr_l"},
    {869, "_strlwr_s"},
    {870, "_strlwr_s_l"},
    {871, "_strncoll"},
    {872, "_strncoll_l"},
    {873, "_strnicmp"},
    {874, "_strnicmp_l"},
    {875, "_strnicoll"},
    {876, "_strnicoll_l"},
    {877, "_strnset"},
    {878, "_strnset_s"},
    {879, "_strrev"},
    {880, "_strset"},
    {881, "_strset_s"},
    {882, "_strtime"},
    {883, "_strtime_s"},
    {884, "_strtod_l"},
    {885, "_strtoi64"},
    {886, "_strtoi64_l"},
    {887, "_strtol_l"},
    {888, "_strtoui64"},
    {889, "_strtoui64_l"},
    {890, "_strtoul_l"},
    {891, "_strupr"},
    {892, "_strupr_l"},
    {893, "_strupr_s"},
    {894, "_strupr_s_l"},
    {895, "_strxfrm_l"},
    {896, "_swab"},
    {897, "_swprintf"},
    {898, "_swprintf_c"},
    {899, "_swprintf_c_l"},
    {900, "_swprintf_p_l"},
    {901, "_swprintf_s_l"},
    {902, "_swscanf_l"},
    {903, "_swscanf_s_l"},
    {904, "_sys_errlist"},
    {905, "_sys_nerr"},
    {906, "_tell"},
    {907, "_telli64"},
    {908, "_tempnam"},
    {909, "_tempnam_dbg"},
    {910, "_time32"},
    {911, "_time64"},
    {912, "_timezone"},
    {913, "_tolower"},
    {914, "_tolower_l"},
    {915, "_toupper"},
    {916, "_toupper_l"},
    {917, "_towlower_l"},
    {918, "_towupper_l"},
    {919, "_tzname"},
    {920, "_tzset"},
    {921, "_ui64toa"},
    {922, "_ui64toa_s"},
    {923, "_ui64tow"},
    {924, "_ui64tow_s"},
    {925, "_ultoa"},
    {926, "_ultoa_s"},
    {927, "_ultow"},
    {928, "_ultow_s"},
    {929, "_umask"},
    {930, "_umask_s"},
    {931, "_ungetch"},
    {932, "_ungetwch"},
    {933, "_unlink"},
    {934, "_unloaddll"},
    {935, "_unlock"},
    {936, "_utime"},
    {937, "_utime32"},
    {938, "_utime64"},
    {939, "_vcprintf"},
    {940, "_vcprintf_l"},
    {941, "_vcprintf_p"},
    {942, "_vcprintf_p_l"},
    {943, "_vcprintf_s"},
    {944, "_vcprintf_s_l"},
    {945, "_vcwprintf"},
    {946, "_vcwprintf_l"},
    {947, "_vcwprintf_p"},
    {948, "_vcwprintf_p_l"},
    {949, "_vcwprintf_s"},
    {950, "_vcwprintf_s_l"},
    {951, "_vfprintf_l"},
    {952, "_vfprintf_p"},
    {953, "_vfprintf_p_l"},
    {954, "_vfprintf_s_l"},
    {955, "_vfwprintf_l"},
    {956, "_vfwprintf_p"},
    {957, "_vfwprintf_p_l"},
    {958, "_vfwprintf_s_l"},
    {959, "_vprintf_l"},
    {960, "_vprintf_p"},
    {961, "_vprintf_p_l"},
    {962, "_vprintf_s_l"},
    {963, "_vscprintf"},
    {964, "_vscprintf_l"},
    {965, "_vscprintf_p_l"},
    {966, "_vscwprintf"},
    {967, "_vscwprintf_l"},
    {968, "_vscwprintf_p_l"},
    {969, "_vsnprintf"},
    {970, "_vsnprintf_c"},
    {971, "_vsnprintf_c_l"},
    {972, "_vsnprintf_l"},
    {973, "_vsnprintf_s"},
    {974, "_vsnprintf_s_l"},
    {975, "_vsnwprintf"},
    {976, "_vsnwprintf_l"},
    {977, "_vsnwprintf_s"},
    {978, "_vsnwprintf_s_l"},
    {979, "_vsprintf_l"},
    {980, "_vsprintf_p"},
    {981, "_vsprintf_p_l"},
    {982, "_vsprintf_s_l"},
    {983, "_vswprintf"},
    {984, "_vswprintf_c"},
    {985, "_vswprintf_c_l"},
    {986, "_vswprintf_l"},
    {987, "_vswprintf_p_l"},
    {988, "_vswprintf_s_l"},
    {989, "_vwprintf_l"},
    {990, "_vwprintf_p"},
    {991, "_vwprintf_p_l"},
    {992, "_vwprintf_s_l"},
    {993, "_waccess"},
    {994, "_waccess_s"},
    {995, "_wasctime"},
    {996, "_wasctime_s"},
    {997, "_wassert"},
    {998, "_wchdir"},
    {999, "_wchmod"},
    {1000, "_wcmdln"},
    {1001, "_wcreat"},
    {1002, "_wcscoll_l"},
    {1003, "_wcsdup"},
    {1004, "_wcsdup_dbg"},
    {1005, "_wcserror"},
    {1006, "_wcserror_s"},
    {1007, "_wcsftime_l"},
    {1008, "_wcsicmp"},
    {1009, "_wcsicmp_l"},
    {1010, "_wcsicoll"},
    {1011, "_wcsicoll_l"},
    {1012, "_wcslwr"},
    {1013, "_wcslwr_l"},
    {1014, "_wcslwr_s"},
    {1015, "_wcslwr_s_l"},
    {1016, "_wcsncoll"},
    {1017, "_wcsncoll_l"},
    {1018, "_wcsnicmp"},
    {1019, "_wcsnicmp_l"},
    {1020, "_wcsnicoll"},
    {1021, "_wcsnicoll_l"},
    {1022, "_wcsnset"},
    {1023, "_wcsnset_s"},
    {1024, "_wcsrev"},
    {1025, "_wcsset"},
    {1026, "_wcsset_s"},
    {1027, "_wcstoi64"},
    {1028, "_wcstoi64_l"},
    {1029, "_wcstol_l"},
    {1030, "_wcstombs_l"},
    {1031, "_wcstombs_s_l"},
    {1032, "_wcstoui64"},
    {1033, "_wcstoui64_l"},
    {1034, "_wcstoul_l"},
    {1035, "_wcsupr"},
    {1036, "_wcsupr_l"},
    {1037, "_wcsupr_s"},
    {1038, "_wcsupr_s_l"},
    {1039, "_wcsxfrm_l"},
    {1040, "_wctime"},
    {1041, "_wctime32"},
    {1042, "_wctime32_s"},
    {1043, "_wctime64"},
    {1044, "_wctime64_s"},
    {1045, "_wctomb_l"},
    {1046, "_wctomb_s_l"},
    {1047, "_wctype"},
    {1048, "_wenviron"},
    {1049, "_wexecl"},
    {1050, "_wexecle"},
    {1051, "_wexeclp"},
    {1052, "_wexeclpe"},
    {1053, "_wexecv"},
    {1054, "_wexecve"},
    {1055, "_wexecvp"},
    {1056, "_wexecvpe"},
    {1057, "_wfdopen"},
    {1058, "_wfindfirst"},
    {1059, "_wfindfirst64"},
    {1060, "_wfindfirsti64"},
    {1061, "_wfindnext"},
    {1062, "_wfindnext64"},
    {1063, "_wfindnexti64"},
    {1064, "_wfopen"},
    {1065, "_wfopen_s"},
    {1066, "_wfreopen"},
    {1067, "_wfreopen_s"},
    {1068, "_wfsopen"},
    {1069, "_wfullpath"},
    {1070, "_wfullpath_dbg"},
    {1071, "_wgetcwd"},
    {1072, "_wgetdcwd"},
    {1073, "_wgetenv"},
    {1074, "_wgetenv_s"},
    {1075, "_winmajor"},
    {1076, "_winminor"},
    {1077, "_winput_s"},
    {1078, "_winver"},
    {1079, "_wmakepath"},
    {1080, "_wmakepath_s"},
    {1081, "_wmkdir"},
    {1082, "_wmktemp"},
    {1083, "_wmktemp_s"},
    {1084, "_wopen"},
    {1085, "_woutput_s"},
    {1086, "_wperror"},
    {1087, "_wpgmptr"},
    {1088, "_wpopen"},
    {1089, "_wprintf_l"},
    {1090, "_wprintf_p"},
    {1091, "_wprintf_p_l"},
    {1092, "_wprintf_s_l"},
    {1093, "_wputenv"},
    {1094, "_wputenv_s"},
    {1095, "_wremove"},
    {1096, "_wrename"},
    {1097, "_write"},
    {1098, "_wrmdir"},
    {1099, "_wscanf_l"},
    {1100, "_wscanf_s_l"},
    {1101, "_wsearchenv"},
    {1102, "_wsearchenv_s"},
    {1103, "_wsetlocale"},
    {1104, "_wsopen"},
    {1105, "_wsopen_s"},
    {1106, "_wspawnl"},
    {1107, "_wspawnle"},
    {1108, "_wspawnlp"},
    {1109, "_wspawnlpe"},
    {1110, "_wspawnv"},
    {1111, "_wspawnve"},
    {1112, "_wspawnvp"},
    {1113, "_wspawnvpe"},
    {1114, "_wsplitpath"},
    {1115, "_wsplitpath_s"},
    {1116, "_wstat"},
    {1117, "_wstat64"},
    {1118, "_wstati64"},
    {1119, "_wstrdate"},
    {1120, "_wstrdate_s"},
    {1121, "_wstrtime"},
    {1122, "_wstrtime_s"},
    {1123, "_wsystem"},
    {1124, "_wtempnam"},
    {1125, "_wtempnam_dbg"},
    {1126, "_wtmpnam"},
    {1127, "_wtmpnam_s"},
    {1128, "_wtof"},
    {1129, "_wtof_l"},
    {1130, "_wtoi"},
    {1131, "_wtoi64"},
    {1132, "_wtoi64_l"},
    {1133, "_wtoi_l"},
    {1134, "_wtol"},
    {1135, "_wtol_l"},
    {1136, "_wunlink"},
    {1137, "_wutime"},
    {1138, "_wutime32"},
    {1139, "_wutime64"},
    {1140, "_y0"},
    {1141, "_y1"},
    {1142, "_yn"},
    {1143, "abort"},
    {1144, "abs"},
    {1145, "acos"},
    {1146, "asctime"},
    {1147, "asctime_s"},
    {1148, "asin"},
    {1149, "atan"},
    {1150, "atan2"},
    {1151, "atexit"},
    {1152, "atof"},
    {1153, "atoi"},
    {1154, "atol"},
    {1155, "bsearch"},
    {1156, "bsearch_s"},
    {1157, "btowc"},
    {1158, "calloc"},
    {1159, "ceil"},
    {1160, "clearerr"},
    {1161, "clearerr_s"},
    {1162, "clock"},
    {1163, "cos"},
    {1164, "cosh"},
    {1165, "ctime"},
    {1166, "difftime"},
    {1167, "div"},
    {1168, "exit"},
    {1169, "exp"},
    {1170, "fabs"},
    {1171, "fclose"},
    {1172, "feof"},
    {1173, "ferror"},
    {1174, "fflush"},
    {1175, "fgetc"},
    {1176, "fgetpos"},
    {1177, "fgets"},
    {1178, "fgetwc"},
    {1179, "fgetws"},
    {1180, "floor"},
    {1181, "fmod"},
    {1182, "fopen"},
    {1183, "fopen_s"},
    {1184, "fprintf"},
    {1185, "fprintf_s"},
    {1186, "fputc"},
    {1187, "fputs"},
    {1188, "fputwc"},
    {1189, "fputws"},
    {1190, "fread"},
    {1191, "free"},
    {1192, "freopen"},
    {1193, "freopen_s"},
    {1194, "frexp"},
    {1195, "fscanf"},
    {1196, "fscanf_s"},
    {1197, "fseek"},
    {1198, "fsetpos"},
    {1199, "ftell"},
    {1200, "fwprintf"},
    {1201, "fwprintf_s"},
    {1202, "fwrite"},
    {1203, "fwscanf"},
    {1204, "fwscanf_s"},
    {1205, "getc"},
    {1206, "getchar"},
    {1207, "getenv"},
    {1208, "getenv_s"},
    {1209, "gets"},
    {1210, "getwc"},
    {1211, "getwchar"},
    {1212, "gmtime"},
    {1213, "is_wctype"},
    {1214, "isalnum"},
    {1215, "isalpha"},
    {1216, "iscntrl"},
    {1217, "isdigit"},
    {1218, "isgraph"},
    {1219, "isleadbyte"},
    {1220, "islower"},
    {1221, "isprint"},
    {1222, "ispunct"},
    {1223, "isspace"},
    {1224, "isupper"},
    {1225, "iswalnum"},
    {1226, "iswalpha"},
    {1227, "iswascii"},
    {1228, "iswcntrl"},
    {1229, "iswctype"},
    {1230, "iswdigit"},
    {1231, "iswgraph"},
    {1232, "iswlower"},
    {1233, "iswprint"},
    {1234, "iswpunct"},
    {1235, "iswspace"},
    {1236, "iswupper"},
    {1237, "iswxdigit"},
    {1238, "isxdigit"},
    {1239, "labs"},
    {1240, "ldexp"},
    {1241, "ldiv"},
    {1242, "localeconv"},
    {1243, "localtime"},
    {1244, "log"},
    {1245, "log10"},
    {1246, "longjmp"},
    {1247, "malloc"},
    {1248, "mblen"},
    {1249, "mbrlen"},
    {1250, "mbrtowc"},
    {1251, "mbsdup_dbg"},
    {1252, "mbsrtowcs"},
    {1253, "mbsrtowcs_s"},
    {1254, "mbstowcs"},
    {1255, "mbstowcs_s"},
    {1256, "mbtowc"},
    {1257, "memchr"},
    {1258, "memcmp"},
    {1259, "memcpy"},
    {1260, "memcpy_s"},
    {1261, "memmove"},
    {1262, "memmove_s"},
    {1263, "memset"},
    {1264, "mktime"},
    {1265, "modf"},
    {1266, "perror"},
    {1267, "pow"},
    {1268, "printf"},
    {1269, "printf_s"},
    {1270, "putc"},
    {1271, "putchar"},
    {1272, "puts"},
    {1273, "putwc"},
    {1274, "putwchar"},
    {1275, "qsort"},
    {1276, "qsort_s"},
    {1277, "raise"},
    {1278, "rand"},
    {1279, "rand_s"},
    {1280, "realloc"},
    {1281, "remove"},
    {1282, "rename"},
    {1283, "rewind"},
    {1284, "scanf"},
    {1285, "scanf_s"},
    {1286, "setbuf"},
    {1287, "setlocale"},
    {1288, "setvbuf"},
    {1289, "signal"},
    {1290, "sin"},
    {1291, "sinh"},
    {1292, "sprintf"},
    {1293, "sprintf_s"},
    {1294, "sqrt"},
    {1295, "srand"},
    {1296, "sscanf"},
    {1297, "sscanf_s"},
    {1298, "strcat"},
    {1299, "strcat_s"},
    {1300, "strchr"},
    {1301, "strcmp"},
    {1302, "strcoll"},
    {1303, "strcpy"},
    {1304, "strcpy_s"},
    {1305, "strcspn"},
    {1306, "strerror"},
    {1307, "strerror_s"},
    {1308, "strftime"},
    {1309, "strlen"},
    {1310, "strncat"},
    {1311, "strncat_s"},
    {1312, "strncmp"},
    {1313, "strncpy"},
    {1314, "strncpy_s"},
    {1315, "strnlen"},
    {1316, "strpbrk"},
    {1317, "strrchr"},
    {1318, "strspn"},
    {1319, "strstr"},
    {1320, "strtod"},
    {1321, "strtok"},
    {1322, "strtok_s"},
    {1323, "strtol"},
    {1324, "strtoul"},
    {1325, "strxfrm"},
    {1326, "swprintf"},
    {1327, "swprintf_s"},
    {1328, "swscanf"},
    {1329, "swscanf_s"},
    {1330, "system"},
    {1331, "tan"},
    {1332, "tanh"},
    {1333, "time"},
    {1334, "tmpfile"},
    {1335, "tmpfile_s"},
    {1336, "tmpnam"},
    {1337, "tmpnam_s"},
    {1338, "tolower"},
    {1339, "toupper"},
    {1340, "towlower"},
    {1341, "towupper"},
    {1342, "ungetc"},
    {1343, "ungetwc"},
    {1344, "utime"},
    {1345, "vfprintf"},
    {1346, "vfprintf_s"},
    {1347, "vfwprintf"},
    {1348, "vfwprintf_s"},
    {1349, "vprintf"},
    {1350, "vprintf_s"},
    {1351, "vsnprintf"},
    {1352, "vsprintf"},
    {1353, "vsprintf_s"},
    {1354, "vswprintf"},
    {1355, "vswprintf_s"},
    {1356, "vwprintf"},
    {1357, "vwprintf_s"},
    {1358, "wcrtomb"},
    {1359, "wcrtomb_s"},
    {1360, "wcscat"},
    {1361, "wcscat_s"},
    {1362, "wcschr"},
    {1363, "wcscmp"},
    {1364, "wcscoll"},
    {1365, "wcscpy"},
    {1366, "wcscpy_s"},
    {1367, "wcscspn"},
    {1368, "wcsftime"},
    {1369, "wcslen"},
    {1370, "wcsncat"},
    {1371, "wcsncat_s"},
    {1372, "wcsncmp"},
    {1373, "wcsncpy"},
    {1374, "wcsncpy_s"},
    {1375, "wcsnlen"},
    {1376, "wcspbrk"},
    {1377, "wcsrchr"},
    {1378, "wcsrtombs"},
    {1379, "wcsrtombs_s"},
    {1380, "wcsspn"},
    {1381, "wcsstr"},
    {1382, "wcstod"},
    {1383, "wcstok"},
    {1384, "wcstok_s"},
    {1385, "wcstol"},
    {1386, "wcstombs"},
    {1387, "wcstombs_s"},
    {1388, "wcstoul"},
    {1389, "wcsxfrm"},
    {1390, "wctob"},
    {1391, "wctomb"},
    {1392, "wctomb_s"},
    {1393, "wprintf"},
    {1394, "wprintf_s"},
    {1395, "wscanf"},
    {1396, "wscanf_s"},
    {0, NULL}};
static Dw32Ordinal msvcrtd[] = {
    {50, "$I10_OUTPUT"},
    {1, "??0__non_rtti_object@@QAE@ABV0@@Z"},
    {2, "??0__non_rtti_object@@QAE@PBD@Z"},
    {3, "??0bad_cast@@QAE@ABQBD@Z"},
    {4, "??0bad_cast@@QAE@ABV0@@Z"},
    {5, "??0bad_typeid@@QAE@ABV0@@Z"},
    {6, "??0bad_typeid@@QAE@PBD@Z"},
    {7, "??0exception@@QAE@ABQBD@Z"},
    {8, "??0exception@@QAE@ABV0@@Z"},
    {9, "??0exception@@QAE@XZ"},
    {10, "??1__non_rtti_object@@UAE@XZ"},
    {11, "??1bad_cast@@UAE@XZ"},
    {12, "??1bad_typeid@@UAE@XZ"},
    {13, "??1exception@@UAE@XZ"},
    {14, "??1type_info@@UAE@XZ"},
    {15, "??2@YAPAXI@Z"},
    {16, "??2@YAPAXIHPBDH@Z"},
    {17, "??3@YAXPAX@Z"},
    {18, "??4__non_rtti_object@@QAEAAV0@ABV0@@Z"},
    {19, "??4bad_cast@@QAEAAV0@ABV0@@Z"},
    {20, "??4bad_typeid@@QAEAAV0@ABV0@@Z"},
    {21, "??4exception@@QAEAAV0@ABV0@@Z"},
    {22, "??8type_info@@QBEHABV0@@Z"},
    {23, "??9type_info@@QBEHABV0@@Z"},
    {24, "??_7__non_rtti_object@@6B@"},
    {25, "??_7bad_cast@@6B@"},
    {26, "??_7bad_typeid@@6B@"},
    {27, "??_7exception@@6B@"},
    {28, "??_E__non_rtti_object@@UAEPAXI@Z"},
    {29, "??_Ebad_cast@@UAEPAXI@Z"},
    {30, "??_Ebad_typeid@@UAEPAXI@Z"},
    {31, "??_Eexception@@UAEPAXI@Z"},
    {32, "??_G__non_rtti_object@@UAEPAXI@Z"},
    {33, "??_Gbad_cast@@UAEPAXI@Z"},
    {34, "??_Gbad_typeid@@UAEPAXI@Z"},
    {35, "??_Gexception@@UAEPAXI@Z"},
    {36, "?_query_new_handler@@YAP6AHI@ZXZ"},
    {37, "?_query_new_mode@@YAHXZ"},
    {38, "?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"},
    {39, "?_set_new_mode@@YAHH@Z"},
    {40, "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"},
    {41, "?before@type_info@@QBEHABV1@@Z"},
    {42, "?name@type_info@@QBEPBDXZ"},
    {43, "?raw_name@type_info@@QBEPBDXZ"},
    {44, "?set_new_handler@@YAP6AXXZP6AXXZ@Z"},
    {45, "?set_terminate@@YAP6AXXZP6AXXZ@Z"},
    {46, "?set_unexpected@@YAP6AXXZP6AXXZ@Z"},
    {47, "?terminate@@YAXXZ"},
    {48, "?unexpected@@YAXXZ"},
    {49, "?what@exception@@UBEPBDXZ"},
    {51, "_CIacos"},
    {52, "_CIasin"},
    {53, "_CIatan"},
    {54, "_CIatan2"},
    {55, "_CIcos"},
    {56, "_CIcosh"},
    {57, "_CIexp"},
    {58, "_CIfmod"},
    {59, "_CIlog"},
    {60, "_CIlog10"},
    {61, "_CIpow"},
    {62, "_CIsin"},
    {63, "_CIsinh"},
    {64, "_CIsqrt"},
    {65, "_CItan"},
    {66, "_CItanh"},
    {67, "_CrtCheckMemory"},
    {68, "_CrtDbgBreak"},
    {69, "_CrtDbgReport"},
    {70, "_CrtDoForAllClientObjects"},
    {71, "_CrtDumpMemoryLeaks"},
    {72, "_CrtIsMemoryBlock"},
    {73, "_CrtIsValidHeapPointer"},
    {74, "_CrtIsValidPointer"},
    {75, "_CrtMemCheckpoint"},
    {76, "_CrtMemDifference"},
    {77, "_CrtMemDumpAllObjectsSince"},
    {78, "_CrtMemDumpStatistics"},
    {79, "_CrtSetAllocHook"},
    {80, "_CrtSetBreakAlloc"},
    {81, "_CrtSetDbgBlockType"},
    {82, "_CrtSetDbgFlag"},
    {83, "_CrtSetDumpClient"},
    {84, "_CrtSetReportFile"},
    {85, "_CrtSetReportHook"},
    {86, "_CrtSetReportMode"},
    {87, "_CxxThrowException"},
    {88, "_EH_prolog"},
    {89, "_Getdays"},
    {90, "_Getmonths"},
    {91, "_Gettnames"},
    {92, "_HUGE"},
    {93, "_Strftime"},
    {94, "_XcptFilter"},
    {95, "__CxxFrameHandler"},
    {96, "__CxxLongjmpUnwind"},
    {97, "__RTCastToVoid"},
    {98, "__RTDynamicCast"},
    {99, "__RTtypeid"},
    {100, "__STRINGTOLD"},
    {101, "__argc"},
    {102, "__argv"},
    {103, "__badioinfo"},
    {104, "__crtCompareStringA"},
    {105, "__crtGetLocaleInfoW"},
    {106, "__crtLCMapStringA"},
    {107, "__dllonexit"},
    {108, "__doserrno"},
    {109, "__fpecode"},
    {110, "__getmainargs"},
    {111, "__initenv"},
    {112, "__isascii"},
    {113, "__iscsym"},
    {114, "__iscsymf"},
    {115, "__lc_codepage"},
    {116, "__lc_collate_cp"},
    {117, "__lc_handle"},
    {118, "__lconv_init"},
    {119, "__mb_cur_max"},
    {120, "__p___argc"},
    {121, "__p___argv"},
    {122, "__p___initenv"},
    {123, "__p___mb_cur_max"},
    {124, "__p___wargv"},
    {125, "__p___winitenv"},
    {126, "__p__acmdln"},
    {127, "__p__amblksiz"},
    {128, "__p__commode"},
    {129, "__p__crtAssertBusy"},
    {130, "__p__crtBreakAlloc"},
    {131, "__p__crtDbgFlag"},
    {132, "__p__daylight"},
    {133, "__p__dstbias"},
    {134, "__p__environ"},
    {135, "__p__fileinfo"},
    {136, "__p__fmode"},
    {137, "__p__iob"},
    {138, "__p__mbcasemap"},
    {139, "__p__mbctype"},
    {140, "__p__osver"},
    {141, "__p__pctype"},
    {142, "__p__pgmptr"},
    {143, "__p__pwctype"},
    {144, "__p__timezone"},
    {145, "__p__tzname"},
    {146, "__p__wcmdln"},
    {147, "__p__wenviron"},
    {148, "__p__winmajor"},
    {149, "__p__winminor"},
    {150, "__p__winver"},
    {151, "__p__wpgmptr"},
    {152, "__pioinfo"},
    {153, "__pxcptinfoptrs"},
    {154, "__set_app_type"},
    {155, "__setlc_active"},
    {156, "__setusermatherr"},
    {157, "__threadhandle"},
    {158, "__threadid"},
    {159, "__toascii"},
    {160, "__unDName"},
    {161, "__unDNameEx"},
    {162, "__unguarded_readlc_active"},
    {163, "__wargv"},
    {164, "__wgetmainargs"},
    {165, "__winitenv"},
    {166, "_abnormal_termination"},
    {167, "_access"},
    {168, "_acmdln"},
    {169, "_adj_fdiv_m16i"},
    {170, "_adj_fdiv_m32"},
    {171, "_adj_fdiv_m32i"},
    {172, "_adj_fdiv_m64"},
    {173, "_adj_fdiv_r"},
    {174, "_adj_fdivr_m16i"},
    {175, "_adj_fdivr_m32"},
    {176, "_adj_fdivr_m32i"},
    {177, "_adj_fdivr_m64"},
    {178, "_adj_fpatan"},
    {179, "_adj_fprem"},
    {180, "_adj_fprem1"},
    {181, "_adj_fptan"},
    {182, "_adjust_fdiv"},
    {183, "_aexit_rtn"},
    {184, "_amsg_exit"},
    {185, "_assert"},
    {186, "_atodbl"},
    {187, "_atoi64"},
    {188, "_atoldbl"},
    {189, "_beep"},
    {190, "_beginthread"},
    {191, "_beginthreadex"},
    {192, "_c_exit"},
    {193, "_cabs"},
    {194, "_callnewh"},
    {195, "_calloc_dbg"},
    {196, "_cexit"},
    {197, "_cgets"},
    {198, "_chdir"},
    {199, "_chdrive"},
    {200, "_chgsign"},
    {201, "_chkesp"},
    {202, "_chmod"},
    {203, "_chsize"},
    {204, "_clearfp"},
    {205, "_close"},
    {206, "_commit"},
    {207, "_commode"},
    {208, "_control87"},
    {209, "_controlfp"},
    {210, "_copysign"},
    {211, "_cprintf"},
    {212, "_cputs"},
    {213, "_creat"},
    {214, "_crtAssertBusy"},
    {215, "_crtBreakAlloc"},
    {216, "_crtDbgFlag"},
    {217, "_cscanf"},
    {218, "_ctype"},
    {219, "_cwait"},
    {220, "_daylight"},
    {221, "_dstbias"},
    {222, "_dup"},
    {223, "_dup2"},
    {224, "_ecvt"},
    {225, "_endthread"},
    {226, "_endthreadex"},
    {227, "_environ"},
    {228, "_eof"},
    {229, "_errno"},
    {230, "_except_handler2"},
    {231, "_except_handler3"},
    {232, "_execl"},
    {233, "_execle"},
    {234, "_execlp"},
    {235, "_execlpe"},
    {236, "_execv"},
    {237, "_execve"},
    {238, "_execvp"},
    {239, "_execvpe"},
    {240, "_exit"},
    {241, "_expand"},
    {242, "_expand_dbg"},
    {243, "_fcloseall"},
    {244, "_fcvt"},
    {245, "_fdopen"},
    {246, "_fgetchar"},
    {247, "_fgetwchar"},
    {248, "_filbuf"},
    {249, "_fileinfo"},
    {250, "_filelength"},
    {251, "_filelengthi64"},
    {252, "_fileno"},
    {253, "_findclose"},
    {254, "_findfirst"},
    {255, "_findfirsti64"},
    {256, "_findnext"},
    {257, "_findnexti64"},
    {258, "_finite"},
    {259, "_flsbuf"},
    {260, "_flushall"},
    {261, "_fmode"},
    {262, "_fpclass"},
    {263, "_fpieee_flt"},
    {264, "_fpreset"},
    {265, "_fputchar"},
    {266, "_fputwchar"},
    {267, "_free_dbg"},
    {268, "_fsopen"},
    {269, "_fstat"},
    {270, "_fstati64"},
    {271, "_ftime"},
    {272, "_ftol"},
    {273, "_fullpath"},
    {274, "_futime"},
    {275, "_gcvt"},
    {276, "_get_osfhandle"},
    {277, "_get_sbh_threshold"},
    {278, "_getch"},
    {279, "_getche"},
    {280, "_getcwd"},
    {281, "_getdcwd"},
    {282, "_getdiskfree"},
    {283, "_getdllprocaddr"},
    {284, "_getdrive"},
    {285, "_getdrives"},
    {286, "_getmaxstdio"},
    {287, "_getmbcp"},
    {288, "_getpid"},
    {289, "_getsystime"},
    {290, "_getw"},
    {291, "_getws"},
    {292, "_global_unwind2"},
    {293, "_heapadd"},
    {294, "_heapchk"},
    {295, "_heapmin"},
    {296, "_heapset"},
    {297, "_heapused"},
    {298, "_heapwalk"},
    {299, "_hypot"},
    {300, "_i64toa"},
    {301, "_i64tow"},
    {302, "_initterm"},
    {303, "_inp"},
    {304, "_inpd"},
    {305, "_inpw"},
    {306, "_iob"},
    {307, "_isatty"},
    {308, "_isctype"},
    {309, "_ismbbalnum"},
    {310, "_ismbbalpha"},
    {311, "_ismbbgraph"},
    {312, "_ismbbkalnum"},
    {313, "_ismbbkana"},
    {314, "_ismbbkprint"},
    {315, "_ismbbkpunct"},
    {316, "_ismbblead"},
    {317, "_ismbbprint"},
    {318, "_ismbbpunct"},
    {319, "_ismbbtrail"},
    {320, "_ismbcalnum"},
    {321, "_ismbcalpha"},
    {322, "_ismbcdigit"},
    {323, "_ismbcgraph"},
    {324, "_ismbchira"},
    {325, "_ismbckata"},
    {326, "_ismbcl0"},
    {327, "_ismbcl1"},
    {328, "_ismbcl2"},
    {329, "_ismbclegal"},
    {330, "_ismbclower"},
    {331, "_ismbcprint"},
    {332, "_ismbcpunct"},
    {333, "_ismbcspace"},
    {334, "_ismbcsymbol"},
    {335, "_ismbcupper"},
    {336, "_ismbslead"},
    {337, "_ismbstrail"},
    {338, "_isnan"},
    {339, "_itoa"},
    {340, "_itow"},
    {341, "_j0"},
    {342, "_j1"},
    {343, "_jn"},
    {344, "_kbhit"},
    {345, "_lfind"},
    {346, "_loaddll"},
    {347, "_local_unwind2"},
    {348, "_lock"},
    {349, "_locking"},
    {350, "_logb"},
    {351, "_longjmpex"},
    {352, "_lrotl"},
    {353, "_lrotr"},
    {354, "_lsearch"},
    {355, "_lseek"},
    {356, "_lseeki64"},
    {357, "_ltoa"},
    {358, "_ltow"},
    {359, "_makepath"},
    {360, "_malloc_dbg"},
    {361, "_mbbtombc"},
    {362, "_mbbtype"},
    {363, "_mbcasemap"},
    {364, "_mbccpy"},
    {365, "_mbcjistojms"},
    {366, "_mbcjmstojis"},
    {367, "_mbclen"},
    {368, "_mbctohira"},
    {369, "_mbctokata"},
    {370, "_mbctolower"},
    {371, "_mbctombb"},
    {372, "_mbctoupper"},
    {373, "_mbctype"},
    {374, "_mbsbtype"},
    {375, "_mbscat"},
    {376, "_mbschr"},
    {377, "_mbscmp"},
    {378, "_mbscoll"},
    {379, "_mbscpy"},
    {380, "_mbscspn"},
    {381, "_mbsdec"},
    {382, "_mbsdup"},
    {383, "_mbsicmp"},
    {384, "_mbsicoll"},
    {385, "_mbsinc"},
    {386, "_mbslen"},
    {387, "_mbslwr"},
    {388, "_mbsnbcat"},
    {389, "_mbsnbcmp"},
    {390, "_mbsnbcnt"},
    {391, "_mbsnbcoll"},
    {392, "_mbsnbcpy"},
    {393, "_mbsnbicmp"},
    {394, "_mbsnbicoll"},
    {395, "_mbsnbset"},
    {396, "_mbsncat"},
    {397, "_mbsnccnt"},
    {398, "_mbsncmp"},
    {399, "_mbsncoll"},
    {400, "_mbsncpy"},
    {401, "_mbsnextc"},
    {402, "_mbsnicmp"},
    {403, "_mbsnicoll"},
    {404, "_mbsninc"},
    {405, "_mbsnset"},
    {406, "_mbspbrk"},
    {407, "_mbsrchr"},
    {408, "_mbsrev"},
    {409, "_mbsset"},
    {410, "_mbsspn"},
    {411, "_mbsspnp"},
    {412, "_mbsstr"},
    {413, "_mbstok"},
    {414, "_mbstrlen"},
    {415, "_mbsupr"},
    {416, "_memccpy"},
    {417, "_memicmp"},
    {418, "_mkdir"},
    {419, "_mktemp"},
    {420, "_msize"},
    {421, "_msize_dbg"},
    {422, "_nextafter"},
    {423, "_onexit"},
    {424, "_open"},
    {425, "_open_osfhandle"},
    {426, "_osver"},
    {427, "_outp"},
    {428, "_outpd"},
    {429, "_outpw"},
    {430, "_pclose"},
    {431, "_pctype"},
    {432, "_pgmptr"},
    {433, "_pipe"},
    {434, "_popen"},
    {435, "_purecall"},
    {436, "_putch"},
    {437, "_putenv"},
    {438, "_putw"},
    {439, "_putws"},
    {440, "_pwctype"},
    {441, "_read"},
    {442, "_realloc_dbg"},
    {443, "_rmdir"},
    {444, "_rmtmp"},
    {445, "_rotl"},
    {446, "_rotr"},
    {447, "_safe_fdiv"},
    {448, "_safe_fdivr"},
    {449, "_safe_fprem"},
    {450, "_safe_fprem1"},
    {451, "_scalb"},
    {452, "_searchenv"},
    {453, "_seh_longjmp_unwind"},
    {454, "_set_error_mode"},
    {455, "_set_sbh_threshold"},
    {456, "_seterrormode"},
    {457, "_setjmp"},
    {458, "_setjmp3"},
    {459, "_setmaxstdio"},
    {460, "_setmbcp"},
    {461, "_setmode"},
    {462, "_setsystime"},
    {463, "_sleep"},
    {464, "_snprintf"},
    {465, "_snwprintf"},
    {466, "_sopen"},
    {467, "_spawnl"},
    {468, "_spawnle"},
    {469, "_spawnlp"},
    {470, "_spawnlpe"},
    {471, "_spawnv"},
    {472, "_spawnve"},
    {473, "_spawnvp"},
    {474, "_spawnvpe"},
    {475, "_splitpath"},
    {476, "_stat"},
    {477, "_stati64"},
    {478, "_statusfp"},
    {479, "_strcmpi"},
    {480, "_strdate"},
    {481, "_strdup"},
    {482, "_strerror"},
    {483, "_stricmp"},
    {484, "_stricoll"},
    {485, "_strlwr"},
    {486, "_strncoll"},
    {487, "_strnicmp"},
    {488, "_strnicoll"},
    {489, "_strnset"},
    {490, "_strrev"},
    {491, "_strset"},
    {492, "_strtime"},
    {493, "_strupr"},
    {494, "_swab"},
    {495, "_sys_errlist"},
    {496, "_sys_nerr"},
    {497, "_tell"},
    {498, "_telli64"},
    {499, "_tempnam"},
    {500, "_timezone"},
    {501, "_tolower"},
    {502, "_toupper"},
    {503, "_tzname"},
    {504, "_tzset"},
    {505, "_ui64toa"},
    {506, "_ui64tow"},
    {507, "_ultoa"},
    {508, "_ultow"},
    {509, "_umask"},
    {510, "_ungetch"},
    {511, "_unlink"},
    {512, "_unloaddll"},
    {513, "_unlock"},
    {514, "_utime"},
    {515, "_vsnprintf"},
    {516, "_vsnwprintf"},
    {517, "_waccess"},
    {518, "_wasctime"},
    {519, "_wchdir"},
    {520, "_wchmod"},
    {521, "_wcmdln"},
    {522, "_wcreat"},
    {523, "_wcsdup"},
    {524, "_wcsicmp"},
    {525, "_wcsicoll"},
    {526, "_wcslwr"},
    {527, "_wcsncoll"},
    {528, "_wcsnicmp"},
    {529, "_wcsnicoll"},
    {530, "_wcsnset"},
    {531, "_wcsrev"},
    {532, "_wcsset"},
    {533, "_wcsupr"},
    {534, "_wctime"},
    {535, "_wenviron"},
    {536, "_wexecl"},
    {537, "_wexecle"},
    {538, "_wexeclp"},
    {539, "_wexeclpe"},
    {540, "_wexecv"},
    {541, "_wexecve"},
    {542, "_wexecvp"},
    {543, "_wexecvpe"},
    {544, "_wfdopen"},
    {545, "_wfindfirst"},
    {546, "_wfindfirsti64"},
    {547, "_wfindnext"},
    {548, "_wfindnexti64"},
    {549, "_wfopen"},
    {550, "_wfreopen"},
    {551, "_wfsopen"},
    {552, "_wfullpath"},
    {553, "_wgetcwd"},
    {554, "_wgetdcwd"},
    {555, "_wgetenv"},
    {556, "_winmajor"},
    {557, "_winminor"},
    {558, "_winver"},
    {559, "_wmakepath"},
    {560, "_wmkdir"},
    {561, "_wmktemp"},
    {562, "_wopen"},
    {563, "_wperror"},
    {564, "_wpgmptr"},
    {565, "_wpopen"},
    {566, "_wputenv"},
    {567, "_wremove"},
    {568, "_wrename"},
    {569, "_write"},
    {570, "_wrmdir"},
    {571, "_wsearchenv"},
    {572, "_wsetlocale"},
    {573, "_wsopen"},
    {574, "_wspawnl"},
    {575, "_wspawnle"},
    {576, "_wspawnlp"},
    {577, "_wspawnlpe"},
    {578, "_wspawnv"},
    {579, "_wspawnve"},
    {580, "_wspawnvp"},
    {581, "_wspawnvpe"},
    {582, "_wsplitpath"},
    {583, "_wstat"},
    {584, "_wstati64"},
    {585, "_wstrdate"},
    {586, "_wstrtime"},
    {587, "_wsystem"},
    {588, "_wtempnam"},
    {589, "_wtmpnam"},
    {590, "_wtoi"},
    {591, "_wtoi64"},
    {592, "_wtol"},
    {593, "_wunlink"},
    {594, "_wutime"},
    {595, "_y0"},
    {596, "_y1"},
    {597, "_yn"},
    {598, "abort"},
    {599, "abs"},
    {600, "acos"},
    {601, "asctime"},
    {602, "asin"},
    {603, "atan"},
    {604, "atan2"},
    {605, "atexit"},
    {606, "atof"},
    {607, "atoi"},
    {608, "atol"},
    {609, "bsearch"},
    {610, "calloc"},
    {611, "ceil"},
    {612, "clearerr"},
    {613, "clock"},
    {614, "cos"},
    {615, "cosh"},
    {616, "ctime"},
    {617, "difftime"},
    {618, "div"},
    {619, "exit"},
    {620, "exp"},
    {621, "fabs"},
    {622, "fclose"},
    {623, "feof"},
    {624, "ferror"},
    {625, "fflush"},
    {626, "fgetc"},
    {627, "fgetpos"},
    {628, "fgets"},
    {629, "fgetwc"},
    {630, "fgetws"},
    {631, "floor"},
    {632, "fmod"},
    {633, "fopen"},
    {634, "fprintf"},
    {635, "fputc"},
    {636, "fputs"},
    {637, "fputwc"},
    {638, "fputws"},
    {639, "fread"},
    {640, "free"},
    {641, "freopen"},
    {642, "frexp"},
    {643, "fscanf"},
    {644, "fseek"},
    {645, "fsetpos"},
    {646, "ftell"},
    {647, "fwprintf"},
    {648, "fwrite"},
    {649, "fwscanf"},
    {650, "getc"},
    {651, "getchar"},
    {652, "getenv"},
    {653, "gets"},
    {654, "getwc"},
    {655, "getwchar"},
    {656, "gmtime"},
    {657, "is_wctype"},
    {658, "isalnum"},
    {659, "isalpha"},
    {660, "iscntrl"},
    {661, "isdigit"},
    {662, "isgraph"},
    {663, "isleadbyte"},
    {664, "islower"},
    {665, "isprint"},
    {666, "ispunct"},
    {667, "isspace"},
    {668, "isupper"},
    {669, "iswalnum"},
    {670, "iswalpha"},
    {671, "iswascii"},
    {672, "iswcntrl"},
    {673, "iswctype"},
    {674, "iswdigit"},
    {675, "iswgraph"},
    {676, "iswlower"},
    {677, "iswprint"},
    {678, "iswpunct"},
    {679, "iswspace"},
    {680, "iswupper"},
    {681, "iswxdigit"},
    {682, "isxdigit"},
    {683, "labs"},
    {684, "ldexp"},
    {685, "ldiv"},
    {686, "localeconv"},
    {687, "localtime"},
    {688, "log"},
    {689, "log10"},
    {690, "longjmp"},
    {691, "malloc"},
    {692, "mblen"},
    {693, "mbstowcs"},
    {694, "mbtowc"},
    {695, "memchr"},
    {696, "memcmp"},
    {697, "memcpy"},
    {698, "memmove"},
    {699, "memset"},
    {700, "mktime"},
    {701, "modf"},
    {702, "perror"},
    {703, "pow"},
    {704, "printf"},
    {705, "putc"},
    {706, "putchar"},
    {707, "puts"},
    {708, "putwc"},
    {709, "putwchar"},
    {710, "qsort"},
    {711, "raise"},
    {712, "rand"},
    {713, "realloc"},
    {714, "remove"},
    {715, "rename"},
    {716, "rewind"},
    {717, "scanf"},
    {718, "setbuf"},
    {719, "setlocale"},
    {720, "setvbuf"},
    {721, "signal"},
    {722, "sin"},
    {723, "sinh"},
    {724, "sprintf"},
    {725, "sqrt"},
    {726, "srand"},
    {727, "sscanf"},
    {728, "strcat"},
    {729, "strchr"},
    {730, "strcmp"},
    {731, "strcoll"},
    {732, "strcpy"},
    {733, "strcspn"},
    {734, "strerror"},
    {735, "strftime"},
    {736, "strlen"},
    {737, "strncat"},
    {738, "strncmp"},
    {739, "strncpy"},
    {740, "strpbrk"},
    {741, "strrchr"},
    {742, "strspn"},
    {743, "strstr"},
    {744, "strtod"},
    {745, "strtok"},
    {746, "strtol"},
    {747, "strtoul"},
    {748, "strxfrm"},
    {749, "swprintf"},
    {750, "swscanf"},
    {751, "system"},
    {752, "tan"},
    {753, "tanh"},
    {754, "time"},
    {755, "tmpfile"},
    {756, "tmpnam"},
    {757, "tolower"},
    {758, "toupper"},
    {759, "towlower"},
    {760, "towupper"},
    {761, "ungetc"},
    {762, "ungetwc"},
    {763, "vfprintf"},
    {764, "vfwprintf"},
    {765, "vprintf"},
    {766, "vsprintf"},
    {767, "vswprintf"},
    {768, "vwprintf"},
    {769, "wcscat"},
    {770, "wcschr"},
    {771, "wcscmp"},
    {772, "wcscoll"},
    {773, "wcscpy"},
    {774, "wcscspn"},
    {775, "wcsftime"},
    {776, "wcslen"},
    {777, "wcsncat"},
    {778, "wcsncmp"},
    {779, "wcsncpy"},
    {780, "wcspbrk"},
    {781, "wcsrchr"},
    {782, "wcsspn"},
    {783, "wcsstr"},
    {784, "wcstod"},
    {785, "wcstok"},
    {786, "wcstol"},
    {787, "wcstombs"},
    {788, "wcstoul"},
    {789, "wcsxfrm"},
    {790, "wctomb"},
    {791, "wprintf"},
    {792, "wscanf"},
    {0, NULL}};
static Dw32Ordinal mswsock[] = {
    {1, "AcceptEx"},
    {2, "EnumProtocolsA"},
    {3, "EnumProtocolsW"},
    {4, "GetAcceptExSockaddrs"},
    {5, "GetAddressByNameA"},
    {6, "GetAddressByNameW"},
    {7, "GetNameByTypeA"},
    {8, "GetNameByTypeW"},
    {9, "GetServiceA"},
    {10, "GetServiceW"},
    {11, "GetTypeByNameA"},
    {12, "GetTypeByNameW"},
    {13, "MigrateWinsockConfiguration"},
    {14, "NPLoadNameSpaces"},
    {15, "NSPStartup"},
    {16, "SetServiceA"},
    {17, "SetServiceW"},
    {18, "StartWsdpService"},
    {19, "StopWsdpService"},
    {20, "TransmitFile"},
    {21, "WSARecvEx"},
    {22, "WSPStartup"},
    {23, "dn_expand"},
    {24, "getnetbyname"},
    {25, "inet_network"},
    {26, "rcmd"},
    {27, "rexec"},
    {28, "rresvport"},
    {29, "s_perror"},
    {30, "sethostname"},
    {0, NULL}};
static Dw32Ordinal msxml6[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllSetProperty"},
    {5, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal mtxdm[] = {
    {1, "GetDispenserManager"},
    {0, NULL}};
static Dw32Ordinal mtxoci[] = {
    {23, "DllRegisterServer"},
    {24, "DllUnregisterServer"},
    {1001, "Enlist"},
    {1002, "GetXaSwitch"},
    {1005, "MTxOciGetVersion"},
    {1003, "MTxOciInit"},
    {1006, "MTxOciRegisterCursor"},
    {1004, "MTxolog"},
    {37, "obindps"},
    {1, "obndra"},
    {2, "obndrn"},
    {3, "obndrv"},
    {4, "obreak"},
    {5, "ocan"},
    {6, "oclose"},
    {7, "ocof"},
    {8, "ocom"},
    {9, "ocon"},
    {10, "odefin"},
    {38, "odefinps"},
    {11, "odescr"},
    {12, "odessp"},
    {13, "oerhms"},
    {14, "oermsg"},
    {15, "oexec"},
    {16, "oexfet"},
    {17, "oexn"},
    {18, "ofen"},
    {19, "ofetch"},
    {20, "oflng"},
    {39, "ogetpi"},
    {21, "olog"},
    {1000, "ologTransacted"},
    {22, "ologof"},
    {26, "oopen"},
    {27, "oopt"},
    {28, "oparse"},
    {41, "opinit"},
    {29, "orol"},
    {40, "osetpi"},
    {0, NULL}};
static Dw32Ordinal ncrypt[] = {
    {1, "BCryptAddContextFunction"},
    {2, "BCryptAddContextFunctionProvider"},
    {3, "BCryptCloseAlgorithmProvider"},
    {4, "BCryptConfigureContext"},
    {5, "BCryptConfigureContextFunction"},
    {6, "BCryptCreateContext"},
    {7, "BCryptCreateHash"},
    {8, "BCryptDecrypt"},
    {9, "BCryptDeleteContext"},
    {10, "BCryptDeriveKey"},
    {11, "BCryptDeriveKeyCapi"},
    {12, "BCryptDeriveKeyPBKDF2"},
    {13, "BCryptDestroyHash"},
    {14, "BCryptDestroyKey"},
    {15, "BCryptDestroySecret"},
    {16, "BCryptDuplicateHash"},
    {17, "BCryptDuplicateKey"},
    {18, "BCryptEncrypt"},
    {19, "BCryptEnumAlgorithms"},
    {20, "BCryptEnumContextFunctionProviders"},
    {21, "BCryptEnumContextFunctions"},
    {22, "BCryptEnumContexts"},
    {23, "BCryptEnumProviders"},
    {24, "BCryptEnumRegisteredProviders"},
    {25, "BCryptExportKey"},
    {26, "BCryptFinalizeKeyPair"},
    {27, "BCryptFinishHash"},
    {28, "BCryptFreeBuffer"},
    {29, "BCryptGenRandom"},
    {30, "BCryptGenerateKeyPair"},
    {31, "BCryptGenerateSymmetricKey"},
    {32, "BCryptGetFipsAlgorithmMode"},
    {33, "BCryptGetProperty"},
    {34, "BCryptHashData"},
    {35, "BCryptImportKey"},
    {36, "BCryptImportKeyPair"},
    {37, "BCryptOpenAlgorithmProvider"},
    {38, "BCryptQueryContextConfiguration"},
    {39, "BCryptQueryContextFunctionConfiguration"},
    {40, "BCryptQueryContextFunctionProperty"},
    {41, "BCryptQueryProviderRegistration"},
    {42, "BCryptRegisterConfigChangeNotify"},
    {43, "BCryptRegisterProvider"},
    {44, "BCryptRemoveContextFunction"},
    {45, "BCryptRemoveContextFunctionProvider"},
    {46, "BCryptResolveProviders"},
    {47, "BCryptSecretAgreement"},
    {48, "BCryptSetAuditingInterface"},
    {49, "BCryptSetContextFunctionProperty"},
    {50, "BCryptSetProperty"},
    {51, "BCryptSignHash"},
    {52, "BCryptUnregisterConfigChangeNotify"},
    {53, "BCryptUnregisterProvider"},
    {54, "BCryptVerifySignature"},
    {55, "GetIsolationServerInterface"},
    {56, "GetKeyStorageInterface"},
    {57, "GetSChannelInterface"},
    {58, "NCryptCreatePersistedKey"},
    {59, "NCryptDecrypt"},
    {60, "NCryptDeleteKey"},
    {61, "NCryptDeriveKey"},
    {62, "NCryptEncrypt"},
    {63, "NCryptEnumAlgorithms"},
    {64, "NCryptEnumKeys"},
    {65, "NCryptEnumStorageProviders"},
    {66, "NCryptExportKey"},
    {67, "NCryptFinalizeKey"},
    {68, "NCryptFreeBuffer"},
    {69, "NCryptFreeObject"},
    {70, "NCryptGetProperty"},
    {71, "NCryptImportKey"},
    {72, "NCryptIsAlgSupported"},
    {73, "NCryptIsKeyHandle"},
    {74, "NCryptNotifyChangeKey"},
    {75, "NCryptOpenKey"},
    {76, "NCryptOpenStorageProvider"},
    {77, "NCryptSecretAgreement"},
    {78, "NCryptSetAuditingInterface"},
    {79, "NCryptSetProperty"},
    {80, "NCryptSignHash"},
    {81, "NCryptTranslateHandle"},
    {82, "NCryptVerifySignature"},
    {83, "SslChangeNotify"},
    {84, "SslComputeClientAuthHash"},
    {85, "SslComputeEapKeyBlock"},
    {86, "SslComputeFinishedHash"},
    {87, "SslCreateClientAuthHash"},
    {88, "SslCreateEphemeralKey"},
    {89, "SslCreateHandshakeHash"},
    {90, "SslDecrementProviderReferenceCount"},
    {91, "SslDecryptPacket"},
    {92, "SslEncryptPacket"},
    {93, "SslEnumCipherSuites"},
    {94, "SslEnumProtocolProviders"},
    {95, "SslExportKey"},
    {96, "SslFreeBuffer"},
    {97, "SslFreeObject"},
    {98, "SslGenerateMasterKey"},
    {99, "SslGenerateSessionKeys"},
    {100, "SslGetCipherSuitePRFHashAlgorithm"},
    {101, "SslGetKeyProperty"},
    {102, "SslGetProviderProperty"},
    {103, "SslHashHandshake"},
    {104, "SslImportKey"},
    {105, "SslImportMasterKey"},
    {106, "SslIncrementProviderReferenceCount"},
    {107, "SslLookupCipherLengths"},
    {108, "SslLookupCipherSuiteInfo"},
    {109, "SslOpenPrivateKey"},
    {110, "SslOpenProvider"},
    {111, "SslSignHash"},
    {112, "SslVerifySignature"},
    {0, NULL}};
static Dw32Ordinal nddeapi[] = {
    {505, "NDdeGetErrorStringA"},
    {605, "NDdeGetErrorStringW"},
    {509, "NDdeGetShareSecurityA"},
    {609, "NDdeGetShareSecurityW"},
    {511, "NDdeGetTrustedShareA"},
    {611, "NDdeGetTrustedShareW"},
    {507, "NDdeIsValidAppTopicListA"},
    {607, "NDdeIsValidAppTopicListW"},
    {506, "NDdeIsValidShareNameA"},
    {606, "NDdeIsValidShareNameW"},
    {510, "NDdeSetShareSecurityA"},
    {610, "NDdeSetShareSecurityW"},
    {512, "NDdeSetTrustedShareA"},
    {612, "NDdeSetTrustedShareW"},
    {500, "NDdeShareAddA"},
    {600, "NDdeShareAddW"},
    {501, "NDdeShareDelA"},
    {601, "NDdeShareDelW"},
    {502, "NDdeShareEnumA"},
    {602, "NDdeShareEnumW"},
    {503, "NDdeShareGetInfoA"},
    {603, "NDdeShareGetInfoW"},
    {504, "NDdeShareSetInfoA"},
    {604, "NDdeShareSetInfoW"},
    {508, "NDdeSpecialCommandA"},
    {608, "NDdeSpecialCommandW"},
    {513, "NDdeTrustedShareEnumA"},
    {613, "NDdeTrustedShareEnumW"},
    {0, NULL}};
static Dw32Ordinal ndfapi[] = {
    {7, "DllCanUnloadNow"},
    {8, "DllGetClassObject"},
    {9, "DllRegisterServer"},
    {10, "DllUnregisterServer"},
    {11, "NdfCancelIncident"},
    {12, "NdfCloseIncident"},
    {13, "NdfCreateConnectivityIncident"},
    {14, "NdfCreateDNSIncident"},
    {15, "NdfCreateGroupingIncident"},
    {16, "NdfCreateInboundIncident"},
    {17, "NdfCreateIncident"},
    {18, "NdfCreatePnrpIncident"},
    {19, "NdfCreateSharingIncident"},
    {20, "NdfCreateWebIncident"},
    {21, "NdfCreateWebIncidentEx"},
    {22, "NdfCreateWinSockIncident"},
    {23, "NdfDiagnoseIncident"},
    {24, "NdfExecuteDiagnosis"},
    {25, "NdfGetTraceFile"},
    {26, "NdfRepairIncident"},
    {1, "NdfRunDllDiagnoseIncident"},
    {2, "NdfRunDllDiagnoseNetConnectionIncident"},
    {3, "NdfRunDllDiagnoseWithAnswerFile"},
    {4, "NdfRunDllDuplicateIPDefendingSystem"},
    {5, "NdfRunDllDuplicateIPOffendingSystem"},
    {6, "NdfRunDllHelpTopic"},
    {0, NULL}};
static Dw32Ordinal ndproxystub[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {5, "GetProxyDllInfo"},
    {0, NULL}};
static Dw32Ordinal netapi32[] = {
    {1, "DavAddConnection"},
    {2, "DavDeleteConnection"},
    {3, "DavFlushFile"},
    {4, "DavGetExtendedError"},
    {5, "DavGetHTTPFromUNCPath"},
    {6, "DavGetUNCFromHTTPPath"},
    {7, "DsAddressToSiteNamesA"},
    {8, "DsAddressToSiteNamesExA"},
    {9, "DsAddressToSiteNamesExW"},
    {10, "DsAddressToSiteNamesW"},
    {11, "DsDeregisterDnsHostRecordsA"},
    {12, "DsDeregisterDnsHostRecordsW"},
    {13, "DsEnumerateDomainTrustsA"},
    {14, "DsEnumerateDomainTrustsW"},
    {15, "DsGetDcCloseW"},
    {16, "DsGetDcNameA"},
    {17, "DsGetDcNameW"},
    {18, "DsGetDcNameWithAccountA"},
    {19, "DsGetDcNameWithAccountW"},
    {20, "DsGetDcNextA"},
    {21, "DsGetDcNextW"},
    {22, "DsGetDcOpenA"},
    {23, "DsGetDcOpenW"},
    {24, "DsGetDcSiteCoverageA"},
    {25, "DsGetDcSiteCoverageW"},
    {26, "DsGetForestTrustInformationW"},
    {27, "DsGetSiteNameA"},
    {28, "DsGetSiteNameW"},
    {29, "DsMergeForestTrustInformationW"},
    {30, "DsRoleAbortDownlevelServerUpgrade"},
    {31, "DsRoleCancel"},
    {32, "DsRoleDcAsDc"},
    {33, "DsRoleDcAsReplica"},
    {34, "DsRoleDemoteDc"},
    {35, "DsRoleDnsNameToFlatName"},
    {36, "DsRoleFreeMemory"},
    {37, "DsRoleGetDatabaseFacts"},
    {38, "DsRoleGetDcOperationProgress"},
    {39, "DsRoleGetDcOperationResults"},
    {40, "DsRoleGetPrimaryDomainInformation"},
    {41, "DsRoleIfmHandleFree"},
    {42, "DsRoleServerSaveStateForUpgrade"},
    {43, "DsRoleUpgradeDownlevelServer"},
    {44, "DsValidateSubnetNameA"},
    {45, "DsValidateSubnetNameW"},
    {46, "I_BrowserDebugCall"},
    {47, "I_BrowserDebugTrace"},
    {48, "I_BrowserQueryEmulatedDomains"},
    {49, "I_BrowserQueryOtherDomains"},
    {50, "I_BrowserQueryStatistics"},
    {51, "I_BrowserResetNetlogonState"},
    {52, "I_BrowserResetStatistics"},
    {53, "I_BrowserServerEnum"},
    {54, "I_BrowserSetNetlogonState"},
    {55, "I_DsUpdateReadOnlyServerDnsRecords"},
    {56, "I_NetAccountDeltas"},
    {57, "I_NetAccountSync"},
    {59, "I_NetChainSetClientAttributes"},
    {58, "I_NetChainSetClientAttributes2"},
    {60, "I_NetDatabaseDeltas"},
    {61, "I_NetDatabaseRedo"},
    {63, "I_NetDatabaseSync"},
    {62, "I_NetDatabaseSync2"},
    {64, "I_NetDfsGetVersion"},
    {65, "I_NetDfsIsThisADomainName"},
    {66, "I_NetGetDCList"},
    {67, "I_NetGetForestTrustInformation"},
    {69, "I_NetLogonControl"},
    {68, "I_NetLogonControl2"},
    {70, "I_NetLogonGetDomainInfo"},
    {71, "I_NetLogonSamLogoff"},
    {72, "I_NetLogonSamLogon"},
    {73, "I_NetLogonSamLogonEx"},
    {74, "I_NetLogonSamLogonWithFlags"},
    {75, "I_NetLogonSendToSam"},
    {76, "I_NetLogonUasLogoff"},
    {77, "I_NetLogonUasLogon"},
    {80, "I_NetServerAuthenticate"},
    {78, "I_NetServerAuthenticate2"},
    {79, "I_NetServerAuthenticate3"},
    {81, "I_NetServerGetTrustInfo"},
    {82, "I_NetServerPasswordGet"},
    {84, "I_NetServerPasswordSet"},
    {83, "I_NetServerPasswordSet2"},
    {85, "I_NetServerReqChallenge"},
    {86, "I_NetServerSetServiceBits"},
    {87, "I_NetServerSetServiceBitsEx"},
    {88, "I_NetServerTrustPasswordsGet"},
    {89, "I_NetlogonComputeClientDigest"},
    {90, "I_NetlogonComputeServerDigest"},
    {91, "NetAccessAdd"},
    {92, "NetAccessDel"},
    {93, "NetAccessEnum"},
    {94, "NetAccessGetInfo"},
    {95, "NetAccessGetUserPerms"},
    {96, "NetAccessSetInfo"},
    {97, "NetAddAlternateComputerName"},
    {98, "NetAddServiceAccount"},
    {99, "NetAlertRaise"},
    {100, "NetAlertRaiseEx"},
    {101, "NetApiBufferAllocate"},
    {102, "NetApiBufferFree"},
    {103, "NetApiBufferReallocate"},
    {104, "NetApiBufferSize"},
    {105, "NetAuditClear"},
    {106, "NetAuditRead"},
    {107, "NetAuditWrite"},
    {108, "NetBrowserStatisticsGet"},
    {109, "NetConfigGet"},
    {110, "NetConfigGetAll"},
    {111, "NetConfigSet"},
    {112, "NetConnectionEnum"},
    {113, "NetDfsAdd"},
    {114, "NetDfsAddFtRoot"},
    {115, "NetDfsAddRootTarget"},
    {116, "NetDfsAddStdRoot"},
    {117, "NetDfsAddStdRootForced"},
    {118, "NetDfsEnum"},
    {119, "NetDfsGetClientInfo"},
    {120, "NetDfsGetDcAddress"},
    {121, "NetDfsGetFtContainerSecurity"},
    {122, "NetDfsGetInfo"},
    {123, "NetDfsGetSecurity"},
    {124, "NetDfsGetStdContainerSecurity"},
    {125, "NetDfsGetSupportedNamespaceVersion"},
    {126, "NetDfsManagerGetConfigInfo"},
    {127, "NetDfsManagerInitialize"},
    {128, "NetDfsManagerSendSiteInfo"},
    {129, "NetDfsMove"},
    {130, "NetDfsRemove"},
    {131, "NetDfsRemoveFtRoot"},
    {132, "NetDfsRemoveFtRootForced"},
    {133, "NetDfsRemoveRootTarget"},
    {134, "NetDfsRemoveStdRoot"},
    {135, "NetDfsRename"},
    {136, "NetDfsSetClientInfo"},
    {137, "NetDfsSetFtContainerSecurity"},
    {138, "NetDfsSetInfo"},
    {139, "NetDfsSetSecurity"},
    {140, "NetDfsSetStdContainerSecurity"},
    {141, "NetEnumerateComputerNames"},
    {142, "NetEnumerateServiceAccounts"},
    {143, "NetEnumerateTrustedDomains"},
    {144, "NetErrorLogClear"},
    {145, "NetErrorLogRead"},
    {146, "NetErrorLogWrite"},
    {147, "NetFileClose"},
    {148, "NetFileEnum"},
    {149, "NetFileGetInfo"},
    {150, "NetGetAnyDCName"},
    {151, "NetGetDCName"},
    {152, "NetGetDisplayInformationIndex"},
    {153, "NetGetJoinInformation"},
    {154, "NetGetJoinableOUs"},
    {155, "NetGroupAdd"},
    {156, "NetGroupAddUser"},
    {157, "NetGroupDel"},
    {158, "NetGroupDelUser"},
    {159, "NetGroupEnum"},
    {160, "NetGroupGetInfo"},
    {161, "NetGroupGetUsers"},
    {162, "NetGroupSetInfo"},
    {163, "NetGroupSetUsers"},
    {164, "NetIsServiceAccount"},
    {165, "NetJoinDomain"},
    {166, "NetLocalGroupAdd"},
    {167, "NetLocalGroupAddMember"},
    {168, "NetLocalGroupAddMembers"},
    {169, "NetLocalGroupDel"},
    {170, "NetLocalGroupDelMember"},
    {171, "NetLocalGroupDelMembers"},
    {172, "NetLocalGroupEnum"},
    {173, "NetLocalGroupGetInfo"},
    {174, "NetLocalGroupGetMembers"},
    {175, "NetLocalGroupSetInfo"},
    {176, "NetLocalGroupSetMembers"},
    {177, "NetLogonGetTimeServiceParentDomain"},
    {178, "NetLogonSetServiceBits"},
    {179, "NetMessageBufferSend"},
    {180, "NetMessageNameAdd"},
    {181, "NetMessageNameDel"},
    {182, "NetMessageNameEnum"},
    {183, "NetMessageNameGetInfo"},
    {184, "NetProvisionComputerAccount"},
    {185, "NetQueryDisplayInformation"},
    {186, "NetQueryServiceAccount"},
    {187, "NetRegisterDomainNameChangeNotification"},
    {188, "NetRemoteComputerSupports"},
    {189, "NetRemoteTOD"},
    {190, "NetRemoveAlternateComputerName"},
    {191, "NetRemoveServiceAccount"},
    {192, "NetRenameMachineInDomain"},
    {193, "NetReplExportDirAdd"},
    {194, "NetReplExportDirDel"},
    {195, "NetReplExportDirEnum"},
    {196, "NetReplExportDirGetInfo"},
    {197, "NetReplExportDirLock"},
    {198, "NetReplExportDirSetInfo"},
    {199, "NetReplExportDirUnlock"},
    {200, "NetReplGetInfo"},
    {201, "NetReplImportDirAdd"},
    {202, "NetReplImportDirDel"},
    {203, "NetReplImportDirEnum"},
    {204, "NetReplImportDirGetInfo"},
    {205, "NetReplImportDirLock"},
    {206, "NetReplImportDirUnlock"},
    {207, "NetReplSetInfo"},
    {208, "NetRequestOfflineDomainJoin"},
    {209, "NetScheduleJobAdd"},
    {210, "NetScheduleJobDel"},
    {211, "NetScheduleJobEnum"},
    {212, "NetScheduleJobGetInfo"},
    {213, "NetServerAliasAdd"},
    {214, "NetServerAliasDel"},
    {215, "NetServerAliasEnum"},
    {216, "NetServerComputerNameAdd"},
    {217, "NetServerComputerNameDel"},
    {218, "NetServerDiskEnum"},
    {219, "NetServerEnum"},
    {220, "NetServerEnumEx"},
    {221, "NetServerGetInfo"},
    {222, "NetServerSetInfo"},
    {223, "NetServerTransportAdd"},
    {224, "NetServerTransportAddEx"},
    {225, "NetServerTransportDel"},
    {226, "NetServerTransportEnum"},
    {227, "NetServiceControl"},
    {228, "NetServiceEnum"},
    {229, "NetServiceGetInfo"},
    {230, "NetServiceInstall"},
    {231, "NetSessionDel"},
    {232, "NetSessionEnum"},
    {233, "NetSessionGetInfo"},
    {234, "NetSetPrimaryComputerName"},
    {235, "NetShareAdd"},
    {236, "NetShareCheck"},
    {237, "NetShareDel"},
    {238, "NetShareDelEx"},
    {239, "NetShareDelSticky"},
    {240, "NetShareEnum"},
    {241, "NetShareEnumSticky"},
    {242, "NetShareGetInfo"},
    {243, "NetShareSetInfo"},
    {244, "NetStatisticsGet"},
    {245, "NetUnjoinDomain"},
    {246, "NetUnregisterDomainNameChangeNotification"},
    {247, "NetUseAdd"},
    {248, "NetUseDel"},
    {249, "NetUseEnum"},
    {250, "NetUseGetInfo"},
    {251, "NetUserAdd"},
    {252, "NetUserChangePassword"},
    {253, "NetUserDel"},
    {254, "NetUserEnum"},
    {255, "NetUserGetGroups"},
    {256, "NetUserGetInfo"},
    {257, "NetUserGetLocalGroups"},
    {258, "NetUserModalsGet"},
    {259, "NetUserModalsSet"},
    {260, "NetUserSetGroups"},
    {261, "NetUserSetInfo"},
    {262, "NetValidateName"},
    {263, "NetValidatePasswordPolicy"},
    {264, "NetValidatePasswordPolicyFree"},
    {265, "NetWkstaGetInfo"},
    {266, "NetWkstaSetInfo"},
    {267, "NetWkstaTransportAdd"},
    {268, "NetWkstaTransportDel"},
    {269, "NetWkstaTransportEnum"},
    {270, "NetWkstaUserEnum"},
    {271, "NetWkstaUserGetInfo"},
    {272, "NetWkstaUserSetInfo"},
    {273, "NetapipBufferAllocate"},
    {274, "Netbios"},
    {275, "NetpAddTlnFtinfoEntry"},
    {276, "NetpAllocFtinfoEntry"},
    {277, "NetpAssertFailed"},
    {278, "NetpCleanFtinfoContext"},
    {279, "NetpCloseConfigData"},
    {280, "NetpCopyFtinfoContext"},
    {281, "NetpDbgPrint"},
    {282, "NetpGetConfigBool"},
    {283, "NetpGetConfigDword"},
    {284, "NetpGetConfigTStrArray"},
    {285, "NetpGetConfigValue"},
    {286, "NetpGetFileSecurity"},
    {287, "NetpHexDump"},
    {288, "NetpInitFtinfoContext"},
    {289, "NetpIsRemote"},
    {290, "NetpIsUncComputerNameValid"},
    {291, "NetpMergeFtinfo"},
    {292, "NetpNetBiosReset"},
    {293, "NetpNetBiosStatusToApiStatus"},
    {294, "NetpOpenConfigData"},
    {295, "NetpSetFileSecurity"},
    {296, "NetpwNameCanonicalize"},
    {297, "NetpwNameCompare"},
    {298, "NetpwNameValidate"},
    {299, "NetpwPathCanonicalize"},
    {300, "NetpwPathCompare"},
    {301, "NetpwPathType"},
    {302, "NlBindingAddServerToCache"},
    {303, "NlBindingRemoveServerFromCache"},
    {304, "NlBindingSetAuthInfo"},
    {305, "RxNetAccessAdd"},
    {306, "RxNetAccessDel"},
    {307, "RxNetAccessEnum"},
    {308, "RxNetAccessGetInfo"},
    {309, "RxNetAccessGetUserPerms"},
    {310, "RxNetAccessSetInfo"},
    {311, "RxNetServerEnum"},
    {312, "RxNetUserPasswordSet"},
    {313, "RxRemoteApi"},
    {0, NULL}};
static Dw32Ordinal newdev[] = {
    {1, "DeviceInternetSettingUiW"},
    {2, "DiInstallDevice"},
    {3, "DiInstallDriverA"},
    {4, "DiInstallDriverW"},
    {5, "DiRollbackDriver"},
    {6, "DiShowUpdateDevice"},
    {7, "DiUninstallDevice"},
    {8, "InstallNewDevice"},
    {9, "InstallSelectedDriver"},
    {10, "InstallWindowsUpdateDriver"},
    {11, "SetInternetPolicies"},
    {12, "UpdateDriverForPlugAndPlayDevicesA"},
    {13, "UpdateDriverForPlugAndPlayDevicesW"},
    {14, "pDiDeviceInstallActionW"},
    {15, "pDiDeviceInstallNotificationW"},
    {16, "pDiDoDeviceInstallAsAdmin"},
    {17, "pDiDoFinishInstallAsAdmin"},
    {18, "pDiDoNullDriverInstall"},
    {0, NULL}};
static Dw32Ordinal normaliz[] = {
    {1, "IdnToAscii"},
    {2, "IdnToNameprepUnicode"},
    {3, "IdnToUnicode"},
    {4, "IsNormalizedString"},
    {5, "NormalizeString"},
    {0, NULL}};
static Dw32Ordinal ntdsapi[] = {
    {1, "DsAddSidHistoryA"},
    {2, "DsAddSidHistoryW"},
    {3, "DsBindA"},
    {4, "DsBindByInstanceA"},
    {5, "DsBindByInstanceW"},
    {6, "DsBindToISTGA"},
    {7, "DsBindToISTGW"},
    {8, "DsBindW"},
    {9, "DsBindWithCredA"},
    {10, "DsBindWithCredW"},
    {11, "DsBindWithSpnA"},
    {12, "DsBindWithSpnExA"},
    {13, "DsBindWithSpnExW"},
    {14, "DsBindWithSpnW"},
    {15, "DsBindingSetTimeout"},
    {16, "DsClientMakeSpnForTargetServerA"},
    {17, "DsClientMakeSpnForTargetServerW"},
    {18, "DsCrackNamesA"},
    {19, "DsCrackNamesW"},
    {20, "DsCrackSpn2A"},
    {21, "DsCrackSpn2W"},
    {22, "DsCrackSpn3W"},
    {23, "DsCrackSpn4W"},
    {24, "DsCrackSpnA"},
    {25, "DsCrackSpnW"},
    {26, "DsCrackUnquotedMangledRdnA"},
    {27, "DsCrackUnquotedMangledRdnW"},
    {28, "DsFinishDemotionW"},
    {29, "DsFreeDomainControllerInfoA"},
    {30, "DsFreeDomainControllerInfoW"},
    {31, "DsFreeNameResultA"},
    {32, "DsFreeNameResultW"},
    {33, "DsFreePasswordCredentials"},
    {34, "DsFreeSchemaGuidMapA"},
    {35, "DsFreeSchemaGuidMapW"},
    {36, "DsFreeSpnArrayA"},
    {37, "DsFreeSpnArrayW"},
    {38, "DsGetBindAddrW"},
    {39, "DsGetBindAnnotW"},
    {40, "DsGetBindInstGuid"},
    {41, "DsGetDomainControllerInfoA"},
    {42, "DsGetDomainControllerInfoW"},
    {43, "DsGetRdnW"},
    {44, "DsGetSpnA"},
    {45, "DsGetSpnW"},
    {46, "DsInheritSecurityIdentityA"},
    {47, "DsInheritSecurityIdentityW"},
    {48, "DsInitDemotionW"},
    {49, "DsIsMangledDnA"},
    {50, "DsIsMangledDnW"},
    {51, "DsIsMangledRdnValueA"},
    {52, "DsIsMangledRdnValueW"},
    {53, "DsListDomainsInSiteA"},
    {54, "DsListDomainsInSiteW"},
    {55, "DsListInfoForServerA"},
    {56, "DsListInfoForServerW"},
    {57, "DsListRolesA"},
    {58, "DsListRolesW"},
    {59, "DsListServersForDomainInSiteA"},
    {60, "DsListServersForDomainInSiteW"},
    {61, "DsListServersInSiteA"},
    {62, "DsListServersInSiteW"},
    {63, "DsListSitesA"},
    {64, "DsListSitesW"},
    {65, "DsLogEntry"},
    {66, "DsMakePasswordCredentialsA"},
    {67, "DsMakePasswordCredentialsW"},
    {68, "DsMakeSpnA"},
    {69, "DsMakeSpnW"},
    {70, "DsMapSchemaGuidsA"},
    {71, "DsMapSchemaGuidsW"},
    {72, "DsQuerySitesByCostA"},
    {73, "DsQuerySitesByCostW"},
    {74, "DsQuerySitesFree"},
    {75, "DsQuoteRdnValueA"},
    {76, "DsQuoteRdnValueW"},
    {77, "DsRemoveDsDomainA"},
    {78, "DsRemoveDsDomainW"},
    {79, "DsRemoveDsServerA"},
    {80, "DsRemoveDsServerW"},
    {81, "DsReplicaAddA"},
    {82, "DsReplicaAddW"},
    {83, "DsReplicaConsistencyCheck"},
    {84, "DsReplicaDelA"},
    {85, "DsReplicaDelW"},
    {86, "DsReplicaDemotionW"},
    {87, "DsReplicaFreeInfo"},
    {88, "DsReplicaGetInfo2W"},
    {89, "DsReplicaGetInfoW"},
    {90, "DsReplicaModifyA"},
    {91, "DsReplicaModifyW"},
    {92, "DsReplicaSyncA"},
    {93, "DsReplicaSyncAllA"},
    {94, "DsReplicaSyncAllW"},
    {95, "DsReplicaSyncW"},
    {96, "DsReplicaUpdateRefsA"},
    {97, "DsReplicaUpdateRefsW"},
    {98, "DsReplicaVerifyObjectsA"},
    {99, "DsReplicaVerifyObjectsW"},
    {100, "DsServerRegisterSpnA"},
    {101, "DsServerRegisterSpnW"},
    {102, "DsUnBindA"},
    {103, "DsUnBindW"},
    {104, "DsUnquoteRdnValueA"},
    {105, "DsUnquoteRdnValueW"},
    {106, "DsWriteAccountSpnA"},
    {107, "DsWriteAccountSpnW"},
    {108, "DsaopBind"},
    {109, "DsaopBindWithCred"},
    {110, "DsaopBindWithSpn"},
    {111, "DsaopExecuteScript"},
    {112, "DsaopPrepareScript"},
    {113, "DsaopUnBind"},
    {0, NULL}};
static Dw32Ordinal odbc32[] = {
    {79, "CloseODBCPerfData"},
    {80, "CollectODBCPerfData"},
    {81, "CursorLibLockDbc"},
    {82, "CursorLibLockDesc"},
    {83, "CursorLibLockStmt"},
    {85, "CursorLibTransact"},
    {87, "DllBidEntryPoint"},
    {88, "GetODBCSharedData"},
    {89, "LockHandle"},
    {84, "ODBCGetTryWaitValue"},
    {90, "ODBCInternalConnectW"},
    {301, "ODBCQualifyFileDSNW"},
    {86, "ODBCSetTryWaitValue"},
    {91, "OpenODBCPerfData"},
    {92, "PostComponentError"},
    {93, "PostODBCComponentError"},
    {94, "PostODBCError"},
    {1, "SQLAllocConnect"},
    {2, "SQLAllocEnv"},
    {24, "SQLAllocHandle"},
    {77, "SQLAllocHandleStd"},
    {3, "SQLAllocStmt"},
    {4, "SQLBindCol"},
    {25, "SQLBindParam"},
    {72, "SQLBindParameter"},
    {55, "SQLBrowseConnect"},
    {255, "SQLBrowseConnectA"},
    {155, "SQLBrowseConnectW"},
    {78, "SQLBulkOperations"},
    {5, "SQLCancel"},
    {95, "SQLCancelHandle"},
    {26, "SQLCloseCursor"},
    {27, "SQLColAttribute"},
    {227, "SQLColAttributeA"},
    {127, "SQLColAttributeW"},
    {6, "SQLColAttributes"},
    {206, "SQLColAttributesA"},
    {106, "SQLColAttributesW"},
    {56, "SQLColumnPrivileges"},
    {256, "SQLColumnPrivilegesA"},
    {156, "SQLColumnPrivilegesW"},
    {40, "SQLColumns"},
    {240, "SQLColumnsA"},
    {140, "SQLColumnsW"},
    {7, "SQLConnect"},
    {207, "SQLConnectA"},
    {107, "SQLConnectW"},
    {28, "SQLCopyDesc"},
    {57, "SQLDataSources"},
    {257, "SQLDataSourcesA"},
    {157, "SQLDataSourcesW"},
    {8, "SQLDescribeCol"},
    {208, "SQLDescribeColA"},
    {108, "SQLDescribeColW"},
    {58, "SQLDescribeParam"},
    {9, "SQLDisconnect"},
    {41, "SQLDriverConnect"},
    {241, "SQLDriverConnectA"},
    {141, "SQLDriverConnectW"},
    {71, "SQLDrivers"},
    {271, "SQLDriversA"},
    {171, "SQLDriversW"},
    {29, "SQLEndTran"},
    {10, "SQLError"},
    {210, "SQLErrorA"},
    {110, "SQLErrorW"},
    {11, "SQLExecDirect"},
    {211, "SQLExecDirectA"},
    {111, "SQLExecDirectW"},
    {12, "SQLExecute"},
    {59, "SQLExtendedFetch"},
    {13, "SQLFetch"},
    {30, "SQLFetchScroll"},
    {60, "SQLForeignKeys"},
    {260, "SQLForeignKeysA"},
    {160, "SQLForeignKeysW"},
    {14, "SQLFreeConnect"},
    {15, "SQLFreeEnv"},
    {31, "SQLFreeHandle"},
    {16, "SQLFreeStmt"},
    {32, "SQLGetConnectAttr"},
    {232, "SQLGetConnectAttrA"},
    {132, "SQLGetConnectAttrW"},
    {42, "SQLGetConnectOption"},
    {242, "SQLGetConnectOptionA"},
    {142, "SQLGetConnectOptionW"},
    {17, "SQLGetCursorName"},
    {217, "SQLGetCursorNameA"},
    {117, "SQLGetCursorNameW"},
    {43, "SQLGetData"},
    {33, "SQLGetDescField"},
    {233, "SQLGetDescFieldA"},
    {133, "SQLGetDescFieldW"},
    {34, "SQLGetDescRec"},
    {234, "SQLGetDescRecA"},
    {134, "SQLGetDescRecW"},
    {35, "SQLGetDiagField"},
    {235, "SQLGetDiagFieldA"},
    {135, "SQLGetDiagFieldW"},
    {36, "SQLGetDiagRec"},
    {236, "SQLGetDiagRecA"},
    {136, "SQLGetDiagRecW"},
    {37, "SQLGetEnvAttr"},
    {44, "SQLGetFunctions"},
    {45, "SQLGetInfo"},
    {245, "SQLGetInfoA"},
    {145, "SQLGetInfoW"},
    {38, "SQLGetStmtAttr"},
    {238, "SQLGetStmtAttrA"},
    {138, "SQLGetStmtAttrW"},
    {46, "SQLGetStmtOption"},
    {47, "SQLGetTypeInfo"},
    {247, "SQLGetTypeInfoA"},
    {147, "SQLGetTypeInfoW"},
    {61, "SQLMoreResults"},
    {62, "SQLNativeSql"},
    {262, "SQLNativeSqlA"},
    {162, "SQLNativeSqlW"},
    {63, "SQLNumParams"},
    {18, "SQLNumResultCols"},
    {48, "SQLParamData"},
    {64, "SQLParamOptions"},
    {19, "SQLPrepare"},
    {219, "SQLPrepareA"},
    {119, "SQLPrepareW"},
    {65, "SQLPrimaryKeys"},
    {265, "SQLPrimaryKeysA"},
    {165, "SQLPrimaryKeysW"},
    {66, "SQLProcedureColumns"},
    {266, "SQLProcedureColumnsA"},
    {166, "SQLProcedureColumnsW"},
    {67, "SQLProcedures"},
    {267, "SQLProceduresA"},
    {167, "SQLProceduresW"},
    {49, "SQLPutData"},
    {20, "SQLRowCount"},
    {39, "SQLSetConnectAttr"},
    {239, "SQLSetConnectAttrA"},
    {139, "SQLSetConnectAttrW"},
    {50, "SQLSetConnectOption"},
    {250, "SQLSetConnectOptionA"},
    {150, "SQLSetConnectOptionW"},
    {21, "SQLSetCursorName"},
    {221, "SQLSetCursorNameA"},
    {121, "SQLSetCursorNameW"},
    {73, "SQLSetDescField"},
    {273, "SQLSetDescFieldA"},
    {173, "SQLSetDescFieldW"},
    {74, "SQLSetDescRec"},
    {75, "SQLSetEnvAttr"},
    {22, "SQLSetParam"},
    {68, "SQLSetPos"},
    {69, "SQLSetScrollOptions"},
    {76, "SQLSetStmtAttr"},
    {276, "SQLSetStmtAttrA"},
    {176, "SQLSetStmtAttrW"},
    {51, "SQLSetStmtOption"},
    {52, "SQLSpecialColumns"},
    {252, "SQLSpecialColumnsA"},
    {152, "SQLSpecialColumnsW"},
    {53, "SQLStatistics"},
    {253, "SQLStatisticsA"},
    {153, "SQLStatisticsW"},
    {70, "SQLTablePrivileges"},
    {270, "SQLTablePrivilegesA"},
    {170, "SQLTablePrivilegesW"},
    {54, "SQLTables"},
    {254, "SQLTablesA"},
    {154, "SQLTablesW"},
    {23, "SQLTransact"},
    {96, "SearchStatusCode"},
    {97, "VFreeErrors"},
    {98, "VRetrieveDriverErrorsRowCol"},
    {99, "ValidateErrorQueue"},
    {100, "g_hHeapMalloc"},
    {0, NULL}};
static Dw32Ordinal odbcbcp[] = {
    {24, "LibMain"},
    {27, "SQLCloseEnumServers"},
    {26, "SQLGetNextEnumeration"},
    {25, "SQLInitEnumServers"},
    {23, "SQLLinkedCatalogsA"},
    {22, "SQLLinkedCatalogsW"},
    {21, "SQLLinkedServers"},
    {2, "bcp_batch"},
    {3, "bcp_bind"},
    {4, "bcp_colfmt"},
    {5, "bcp_collen"},
    {6, "bcp_colptr"},
    {8, "bcp_columns"},
    {9, "bcp_control"},
    {10, "bcp_done"},
    {12, "bcp_exec"},
    {28, "bcp_getcolfmt"},
    {11, "bcp_initA"},
    {18, "bcp_initW"},
    {13, "bcp_moretext"},
    {15, "bcp_readfmtA"},
    {19, "bcp_readfmtW"},
    {14, "bcp_sendrow"},
    {29, "bcp_setcolfmt"},
    {16, "bcp_writefmtA"},
    {20, "bcp_writefmtW"},
    {1, "dbprtypeA"},
    {17, "dbprtypeW"},
    {0, NULL}};
static Dw32Ordinal odbccp32[] = {
    {101, "ODBCCPlApplet"},
    {6, "SQLConfigDataSource"},
    {206, "SQLConfigDataSourceW"},
    {21, "SQLConfigDriver"},
    {221, "SQLConfigDriverW"},
    {12, "SQLCreateDataSource"},
    {30, "SQLCreateDataSourceEx"},
    {230, "SQLCreateDataSourceExW"},
    {212, "SQLCreateDataSourceW"},
    {5, "SQLGetAvailableDrivers"},
    {205, "SQLGetAvailableDriversW"},
    {27, "SQLGetConfigMode"},
    {4, "SQLGetInstalledDrivers"},
    {204, "SQLGetInstalledDriversW"},
    {15, "SQLGetPrivateProfileString"},
    {215, "SQLGetPrivateProfileStringW"},
    {13, "SQLGetTranslator"},
    {213, "SQLGetTranslatorW"},
    {2, "SQLInstallDriver"},
    {26, "SQLInstallDriverEx"},
    {226, "SQLInstallDriverExW"},
    {3, "SQLInstallDriverManager"},
    {203, "SQLInstallDriverManagerW"},
    {202, "SQLInstallDriverW"},
    {10, "SQLInstallODBC"},
    {210, "SQLInstallODBCW"},
    {18, "SQLInstallTranslator"},
    {29, "SQLInstallTranslatorEx"},
    {229, "SQLInstallTranslatorExW"},
    {218, "SQLInstallTranslatorW"},
    {22, "SQLInstallerError"},
    {222, "SQLInstallerErrorW"},
    {232, "SQLLoadDataSourcesListBox"},
    {231, "SQLLoadDriverListBox"},
    {11, "SQLManageDataSources"},
    {23, "SQLPostInstallerError"},
    {223, "SQLPostInstallerErrorW"},
    {24, "SQLReadFileDSN"},
    {224, "SQLReadFileDSNW"},
    {9, "SQLRemoveDSNFromIni"},
    {209, "SQLRemoveDSNFromIniW"},
    {7, "SQLRemoveDefaultDataSource"},
    {20, "SQLRemoveDriver"},
    {17, "SQLRemoveDriverManager"},
    {220, "SQLRemoveDriverW"},
    {19, "SQLRemoveTranslator"},
    {219, "SQLRemoveTranslatorW"},
    {28, "SQLSetConfigMode"},
    {16, "SQLValidDSN"},
    {216, "SQLValidDSNW"},
    {8, "SQLWriteDSNToIni"},
    {208, "SQLWriteDSNToIniW"},
    {25, "SQLWriteFileDSN"},
    {225, "SQLWriteFileDSNW"},
    {14, "SQLWritePrivateProfileString"},
    {214, "SQLWritePrivateProfileStringW"},
    {112, "SelectTransDlg"},
    {0, NULL}};
static Dw32Ordinal ole32[] = {
    {10, "BindMoniker"},
    {11, "CLIPFORMAT_UserFree"},
    {12, "CLIPFORMAT_UserMarshal"},
    {13, "CLIPFORMAT_UserSize"},
    {14, "CLIPFORMAT_UserUnmarshal"},
    {15, "CLSIDFromOle1Class"},
    {16, "CLSIDFromProgID"},
    {17, "CLSIDFromProgIDEx"},
    {18, "CLSIDFromString"},
    {19, "CoAddRefServerProcess"},
    {20, "CoAllowSetForegroundWindow"},
    {21, "CoBuildVersion"},
    {22, "CoCancelCall"},
    {23, "CoCopyProxy"},
    {24, "CoCreateFreeThreadedMarshaler"},
    {25, "CoCreateGuid"},
    {26, "CoCreateInstance"},
    {27, "CoCreateInstanceEx"},
    {28, "CoCreateObjectInContext"},
    {29, "CoDeactivateObject"},
    {30, "CoDisableCallCancellation"},
    {31, "CoDisconnectContext"},
    {32, "CoDisconnectObject"},
    {33, "CoDosDateTimeToFileTime"},
    {34, "CoEnableCallCancellation"},
    {35, "CoFileTimeNow"},
    {36, "CoFileTimeToDosDateTime"},
    {37, "CoFreeAllLibraries"},
    {38, "CoFreeLibrary"},
    {39, "CoFreeUnusedLibraries"},
    {40, "CoFreeUnusedLibrariesEx"},
    {41, "CoGetActivationState"},
    {42, "CoGetApartmentID"},
    {43, "CoGetApartmentType"},
    {44, "CoGetCallContext"},
    {45, "CoGetCallState"},
    {46, "CoGetCallerTID"},
    {47, "CoGetCancelObject"},
    {48, "CoGetClassObject"},
    {49, "CoGetClassVersion"},
    {50, "CoGetComCatalog"},
    {51, "CoGetContextToken"},
    {52, "CoGetCurrentLogicalThreadId"},
    {53, "CoGetCurrentProcess"},
    {54, "CoGetDefaultContext"},
    {55, "CoGetInstanceFromFile"},
    {56, "CoGetInstanceFromIStorage"},
    {57, "CoGetInterceptor"},
    {58, "CoGetInterceptorFromTypeInfo"},
    {59, "CoGetInterfaceAndReleaseStream"},
    {60, "CoGetMalloc"},
    {61, "CoGetMarshalSizeMax"},
    {62, "CoGetModuleType"},
    {63, "CoGetObject"},
    {64, "CoGetObjectContext"},
    {65, "CoGetPSClsid"},
    {66, "CoGetProcessIdentifier"},
    {67, "CoGetStandardMarshal"},
    {68, "CoGetStdMarshalEx"},
    {69, "CoGetSystemSecurityPermissions"},
    {70, "CoGetTreatAsClass"},
    {71, "CoImpersonateClient"},
    {72, "CoInitialize"},
    {73, "CoInitializeEx"},
    {74, "CoInitializeSecurity"},
    {75, "CoInitializeWOW"},
    {76, "CoInstall"},
    {77, "CoInvalidateRemoteMachineBindings"},
    {78, "CoIsHandlerConnected"},
    {79, "CoIsOle1Class"},
    {80, "CoLoadLibrary"},
    {81, "CoLockObjectExternal"},
    {82, "CoMarshalHresult"},
    {83, "CoMarshalInterThreadInterfaceInStream"},
    {84, "CoMarshalInterface"},
    {85, "CoPopServiceDomain"},
    {86, "CoPushServiceDomain"},
    {87, "CoQueryAuthenticationServices"},
    {88, "CoQueryClientBlanket"},
    {89, "CoQueryProxyBlanket"},
    {90, "CoQueryReleaseObject"},
    {91, "CoReactivateObject"},
    {92, "CoRegisterChannelHook"},
    {93, "CoRegisterClassObject"},
    {94, "CoRegisterInitializeSpy"},
    {95, "CoRegisterMallocSpy"},
    {96, "CoRegisterMessageFilter"},
    {97, "CoRegisterPSClsid"},
    {98, "CoRegisterSurrogate"},
    {99, "CoRegisterSurrogateEx"},
    {100, "CoReleaseMarshalData"},
    {101, "CoReleaseServerProcess"},
    {102, "CoResumeClassObjects"},
    {103, "CoRetireServer"},
    {104, "CoRevertToSelf"},
    {105, "CoRevokeClassObject"},
    {106, "CoRevokeInitializeSpy"},
    {107, "CoRevokeMallocSpy"},
    {108, "CoSetCancelObject"},
    {109, "CoSetProxyBlanket"},
    {110, "CoSetState"},
    {111, "CoSuspendClassObjects"},
    {112, "CoSwitchCallContext"},
    {113, "CoTaskMemAlloc"},
    {114, "CoTaskMemFree"},
    {115, "CoTaskMemRealloc"},
    {116, "CoTestCancel"},
    {117, "CoTreatAsClass"},
    {118, "CoUninitialize"},
    {119, "CoUnloadingWOW"},
    {120, "CoUnmarshalHresult"},
    {121, "CoUnmarshalInterface"},
    {1, "CoVrfCheckThreadState"},
    {2, "CoVrfGetThreadState"},
    {3, "CoVrfReleaseThreadState"},
    {122, "CoWaitForMultipleHandles"},
    {123, "ComPs_NdrDllCanUnloadNow"},
    {124, "ComPs_NdrDllGetClassObject"},
    {125, "ComPs_NdrDllRegisterProxy"},
    {126, "ComPs_NdrDllUnregisterProxy"},
    {127, "CreateAntiMoniker"},
    {128, "CreateBindCtx"},
    {129, "CreateClassMoniker"},
    {130, "CreateDataAdviseHolder"},
    {131, "CreateDataCache"},
    {132, "CreateErrorInfo"},
    {133, "CreateFileMoniker"},
    {134, "CreateGenericComposite"},
    {135, "CreateILockBytesOnHGlobal"},
    {136, "CreateItemMoniker"},
    {137, "CreateObjrefMoniker"},
    {138, "CreateOleAdviseHolder"},
    {139, "CreatePointerMoniker"},
    {140, "CreateStdProgressIndicator"},
    {141, "CreateStreamOnHGlobal"},
    {142, "DcomChannelSetHResult"},
    {143, "DllDebugObjectRPCHook"},
    {144, "DllGetClassObject"},
    {145, "DllGetClassObjectWOW"},
    {146, "DllRegisterServer"},
    {147, "DoDragDrop"},
    {148, "EnableHookObject"},
    {149, "FmtIdToPropStgName"},
    {150, "FreePropVariantArray"},
    {151, "GetClassFile"},
    {152, "GetConvertStg"},
    {153, "GetDocumentBitStg"},
    {154, "GetErrorInfo"},
    {155, "GetHGlobalFromILockBytes"},
    {156, "GetHGlobalFromStream"},
    {157, "GetHookInterface"},
    {158, "GetRunningObjectTable"},
    {159, "HACCEL_UserFree"},
    {160, "HACCEL_UserMarshal"},
    {161, "HACCEL_UserSize"},
    {162, "HACCEL_UserUnmarshal"},
    {163, "HBITMAP_UserFree"},
    {164, "HBITMAP_UserMarshal"},
    {165, "HBITMAP_UserSize"},
    {166, "HBITMAP_UserUnmarshal"},
    {167, "HBRUSH_UserFree"},
    {168, "HBRUSH_UserMarshal"},
    {169, "HBRUSH_UserSize"},
    {170, "HBRUSH_UserUnmarshal"},
    {171, "HDC_UserFree"},
    {172, "HDC_UserMarshal"},
    {173, "HDC_UserSize"},
    {174, "HDC_UserUnmarshal"},
    {175, "HENHMETAFILE_UserFree"},
    {176, "HENHMETAFILE_UserMarshal"},
    {177, "HENHMETAFILE_UserSize"},
    {178, "HENHMETAFILE_UserUnmarshal"},
    {179, "HGLOBAL_UserFree"},
    {180, "HGLOBAL_UserMarshal"},
    {181, "HGLOBAL_UserSize"},
    {182, "HGLOBAL_UserUnmarshal"},
    {183, "HICON_UserFree"},
    {184, "HICON_UserMarshal"},
    {185, "HICON_UserSize"},
    {186, "HICON_UserUnmarshal"},
    {187, "HMENU_UserFree"},
    {188, "HMENU_UserMarshal"},
    {189, "HMENU_UserSize"},
    {190, "HMENU_UserUnmarshal"},
    {191, "HMETAFILEPICT_UserFree"},
    {192, "HMETAFILEPICT_UserMarshal"},
    {193, "HMETAFILEPICT_UserSize"},
    {194, "HMETAFILEPICT_UserUnmarshal"},
    {195, "HMETAFILE_UserFree"},
    {196, "HMETAFILE_UserMarshal"},
    {197, "HMETAFILE_UserSize"},
    {198, "HMETAFILE_UserUnmarshal"},
    {199, "HPALETTE_UserFree"},
    {200, "HPALETTE_UserMarshal"},
    {201, "HPALETTE_UserSize"},
    {202, "HPALETTE_UserUnmarshal"},
    {4, "HRGN_UserFree"},
    {5, "HRGN_UserMarshal"},
    {6, "HRGN_UserSize"},
    {7, "HRGN_UserUnmarshal"},
    {203, "HWND_UserFree"},
    {204, "HWND_UserMarshal"},
    {205, "HWND_UserSize"},
    {206, "HWND_UserUnmarshal"},
    {207, "HkOleRegisterObject"},
    {208, "IIDFromString"},
    {209, "IsAccelerator"},
    {210, "IsEqualGUID"},
    {211, "IsValidIid"},
    {212, "IsValidInterface"},
    {213, "IsValidPtrIn"},
    {214, "IsValidPtrOut"},
    {215, "MkParseDisplayName"},
    {216, "MonikerCommonPrefixWith"},
    {217, "MonikerRelativePathTo"},
    {8, "NdrOleInitializeExtension"},
    {218, "NdrProxyForwardingFunction10"},
    {219, "NdrProxyForwardingFunction11"},
    {220, "NdrProxyForwardingFunction12"},
    {221, "NdrProxyForwardingFunction13"},
    {222, "NdrProxyForwardingFunction14"},
    {223, "NdrProxyForwardingFunction15"},
    {224, "NdrProxyForwardingFunction16"},
    {225, "NdrProxyForwardingFunction17"},
    {226, "NdrProxyForwardingFunction18"},
    {227, "NdrProxyForwardingFunction19"},
    {228, "NdrProxyForwardingFunction20"},
    {229, "NdrProxyForwardingFunction21"},
    {230, "NdrProxyForwardingFunction22"},
    {231, "NdrProxyForwardingFunction23"},
    {232, "NdrProxyForwardingFunction24"},
    {233, "NdrProxyForwardingFunction25"},
    {234, "NdrProxyForwardingFunction26"},
    {235, "NdrProxyForwardingFunction27"},
    {236, "NdrProxyForwardingFunction28"},
    {237, "NdrProxyForwardingFunction29"},
    {241, "NdrProxyForwardingFunction3"},
    {238, "NdrProxyForwardingFunction30"},
    {239, "NdrProxyForwardingFunction31"},
    {240, "NdrProxyForwardingFunction32"},
    {242, "NdrProxyForwardingFunction4"},
    {243, "NdrProxyForwardingFunction5"},
    {244, "NdrProxyForwardingFunction6"},
    {245, "NdrProxyForwardingFunction7"},
    {246, "NdrProxyForwardingFunction8"},
    {247, "NdrProxyForwardingFunction9"},
    {248, "ObjectStublessClient10"},
    {249, "ObjectStublessClient11"},
    {250, "ObjectStublessClient12"},
    {251, "ObjectStublessClient13"},
    {252, "ObjectStublessClient14"},
    {253, "ObjectStublessClient15"},
    {254, "ObjectStublessClient16"},
    {255, "ObjectStublessClient17"},
    {256, "ObjectStublessClient18"},
    {257, "ObjectStublessClient19"},
    {258, "ObjectStublessClient20"},
    {259, "ObjectStublessClient21"},
    {260, "ObjectStublessClient22"},
    {261, "ObjectStublessClient23"},
    {262, "ObjectStublessClient24"},
    {263, "ObjectStublessClient25"},
    {264, "ObjectStublessClient26"},
    {265, "ObjectStublessClient27"},
    {266, "ObjectStublessClient28"},
    {267, "ObjectStublessClient29"},
    {271, "ObjectStublessClient3"},
    {268, "ObjectStublessClient30"},
    {269, "ObjectStublessClient31"},
    {270, "ObjectStublessClient32"},
    {272, "ObjectStublessClient4"},
    {273, "ObjectStublessClient5"},
    {274, "ObjectStublessClient6"},
    {275, "ObjectStublessClient7"},
    {276, "ObjectStublessClient8"},
    {277, "ObjectStublessClient9"},
    {278, "OleBuildVersion"},
    {279, "OleConvertIStorageToOLESTREAM"},
    {280, "OleConvertIStorageToOLESTREAMEx"},
    {281, "OleConvertOLESTREAMToIStorage"},
    {282, "OleConvertOLESTREAMToIStorageEx"},
    {283, "OleCreate"},
    {284, "OleCreateDefaultHandler"},
    {285, "OleCreateEmbeddingHelper"},
    {286, "OleCreateEx"},
    {287, "OleCreateFromData"},
    {288, "OleCreateFromDataEx"},
    {289, "OleCreateFromFile"},
    {290, "OleCreateFromFileEx"},
    {291, "OleCreateLink"},
    {292, "OleCreateLinkEx"},
    {293, "OleCreateLinkFromData"},
    {294, "OleCreateLinkFromDataEx"},
    {295, "OleCreateLinkToFile"},
    {296, "OleCreateLinkToFileEx"},
    {297, "OleCreateMenuDescriptor"},
    {298, "OleCreateStaticFromData"},
    {299, "OleDestroyMenuDescriptor"},
    {300, "OleDoAutoConvert"},
    {301, "OleDraw"},
    {302, "OleDuplicateData"},
    {303, "OleFlushClipboard"},
    {304, "OleGetAutoConvert"},
    {305, "OleGetClipboard"},
    {306, "OleGetIconOfClass"},
    {307, "OleGetIconOfFile"},
    {308, "OleInitialize"},
    {309, "OleInitializeWOW"},
    {310, "OleIsCurrentClipboard"},
    {311, "OleIsRunning"},
    {312, "OleLoad"},
    {313, "OleLoadFromStream"},
    {314, "OleLockRunning"},
    {315, "OleMetafilePictFromIconAndLabel"},
    {316, "OleNoteObjectVisible"},
    {317, "OleQueryCreateFromData"},
    {318, "OleQueryLinkFromData"},
    {319, "OleRegEnumFormatEtc"},
    {320, "OleRegEnumVerbs"},
    {321, "OleRegGetMiscStatus"},
    {322, "OleRegGetUserType"},
    {323, "OleRun"},
    {324, "OleSave"},
    {325, "OleSaveToStream"},
    {326, "OleSetAutoConvert"},
    {327, "OleSetClipboard"},
    {328, "OleSetContainedObject"},
    {329, "OleSetMenuDescriptor"},
    {330, "OleTranslateAccelerator"},
    {331, "OleUninitialize"},
    {332, "OpenOrCreateStream"},
    {333, "ProgIDFromCLSID"},
    {334, "PropStgNameToFmtId"},
    {335, "PropSysAllocString"},
    {336, "PropSysFreeString"},
    {9, "PropVariantChangeType"},
    {337, "PropVariantClear"},
    {338, "PropVariantCopy"},
    {339, "ReadClassStg"},
    {340, "ReadClassStm"},
    {341, "ReadFmtUserTypeStg"},
    {342, "ReadOleStg"},
    {343, "ReadStringStream"},
    {344, "RegisterDragDrop"},
    {345, "ReleaseStgMedium"},
    {346, "RevokeDragDrop"},
    {347, "SNB_UserFree"},
    {348, "SNB_UserMarshal"},
    {349, "SNB_UserSize"},
    {350, "SNB_UserUnmarshal"},
    {351, "STGMEDIUM_UserFree"},
    {352, "STGMEDIUM_UserMarshal"},
    {353, "STGMEDIUM_UserSize"},
    {354, "STGMEDIUM_UserUnmarshal"},
    {355, "SetConvertStg"},
    {356, "SetDocumentBitStg"},
    {357, "SetErrorInfo"},
    {358, "StgConvertPropertyToVariant"},
    {359, "StgConvertVariantToProperty"},
    {360, "StgCreateDocfile"},
    {361, "StgCreateDocfileOnILockBytes"},
    {362, "StgCreatePropSetStg"},
    {363, "StgCreatePropStg"},
    {364, "StgCreateStorageEx"},
    {365, "StgGetIFillLockBytesOnFile"},
    {366, "StgGetIFillLockBytesOnILockBytes"},
    {367, "StgIsStorageFile"},
    {368, "StgIsStorageILockBytes"},
    {369, "StgOpenAsyncDocfileOnIFillLockBytes"},
    {370, "StgOpenPropStg"},
    {371, "StgOpenStorage"},
    {372, "StgOpenStorageEx"},
    {373, "StgOpenStorageOnHandle"},
    {374, "StgOpenStorageOnILockBytes"},
    {375, "StgPropertyLengthAsVariant"},
    {376, "StgSetTimes"},
    {377, "StringFromCLSID"},
    {378, "StringFromGUID2"},
    {379, "StringFromIID"},
    {380, "UpdateDCOMSettings"},
    {381, "UpdateProcessTracing"},
    {382, "UtConvertDvtd16toDvtd32"},
    {383, "UtConvertDvtd32toDvtd16"},
    {384, "UtGetDvtd16Info"},
    {385, "UtGetDvtd32Info"},
    {386, "WdtpInterfacePointer_UserFree"},
    {387, "WdtpInterfacePointer_UserMarshal"},
    {388, "WdtpInterfacePointer_UserSize"},
    {389, "WdtpInterfacePointer_UserUnmarshal"},
    {390, "WriteClassStg"},
    {391, "WriteClassStm"},
    {392, "WriteFmtUserTypeStg"},
    {393, "WriteOleStg"},
    {394, "WriteStringStream"},
    {0, NULL}};
static Dw32Ordinal oleacc[] = {
    {3, "AccessibleChildren"},
    {4, "AccessibleObjectFromEvent"},
    {5, "AccessibleObjectFromPoint"},
    {6, "AccessibleObjectFromWindow"},
    {7, "CreateStdAccessibleObject"},
    {8, "CreateStdAccessibleProxyA"},
    {9, "CreateStdAccessibleProxyW"},
    {10, "DllCanUnloadNow"},
    {11, "DllGetClassObject"},
    {1, "DllRegisterServer"},
    {2, "DllUnregisterServer"},
    {12, "GetOleaccVersionInfo"},
    {13, "GetProcessHandleFromHwnd"},
    {14, "GetRoleTextA"},
    {15, "GetRoleTextW"},
    {16, "GetStateTextA"},
    {17, "GetStateTextW"},
    {18, "IID_IAccessible"},
    {19, "IID_IAccessibleHandler"},
    {20, "LIBID_Accessibility"},
    {21, "LresultFromObject"},
    {22, "ObjectFromLresult"},
    {23, "PropMgrClient_LookupProp"},
    {24, "WindowFromAccessibleObject"},
    {0, NULL}};
static Dw32Ordinal oleaut32[] = {
    {286, "BSTR_UserFree"},
    {284, "BSTR_UserMarshal"},
    {283, "BSTR_UserSize"},
    {285, "BSTR_UserUnmarshal"},
    {414, "BstrFromVector"},
    {171, "ClearCustData"},
    {31, "CreateDispTypeInfo"},
    {202, "CreateErrorInfo"},
    {32, "CreateStdDispatch"},
    {160, "CreateTypeLib"},
    {180, "CreateTypeLib2"},
    {146, "DispCallFunc"},
    {29, "DispGetIDsOfNames"},
    {28, "DispGetParam"},
    {30, "DispInvoke"},
    {144, "DllCanUnloadNow"},
    {145, "DllGetClassObject"},
    {151, "DllRegisterServer"},
    {300, "DllUnregisterServer"},
    {14, "DosDateTimeToVariantTime"},
    {35, "GetActiveObject"},
    {332, "GetAltMonthNames"},
    {200, "GetErrorInfo"},
    {322, "GetRecordInfoFromGuids"},
    {323, "GetRecordInfoFromTypeInfo"},
    {326, "GetVarConversionLocaleSetting"},
    {165, "LHashValOfNameSys"},
    {166, "LHashValOfNameSysA"},
    {296, "LPSAFEARRAY_Marshal"},
    {295, "LPSAFEARRAY_Size"},
    {297, "LPSAFEARRAY_Unmarshal"},
    {294, "LPSAFEARRAY_UserFree"},
    {292, "LPSAFEARRAY_UserMarshal"},
    {291, "LPSAFEARRAY_UserSize"},
    {293, "LPSAFEARRAY_UserUnmarshal"},
    {162, "LoadRegTypeLib"},
    {161, "LoadTypeLib"},
    {183, "LoadTypeLibEx"},
    {500, "OACleanup"},
    {301, "OACreateTypeLib2"},
    {170, "OaBuildVersion"},
    {444, "OaEnablePerUserTLibRegistration"},
    {420, "OleCreateFontIndirect"},
    {419, "OleCreatePictureIndirect"},
    {417, "OleCreatePropertyFrame"},
    {416, "OleCreatePropertyFrameIndirect"},
    {415, "OleIconToCursor"},
    {418, "OleLoadPicture"},
    {401, "OleLoadPictureEx"},
    {422, "OleLoadPictureFile"},
    {402, "OleLoadPictureFileEx"},
    {424, "OleLoadPicturePath"},
    {423, "OleSavePictureFile"},
    {421, "OleTranslateColor"},
    {164, "QueryPathOfRegTypeLib"},
    {33, "RegisterActiveObject"},
    {163, "RegisterTypeLib"},
    {442, "RegisterTypeLibForUser"},
    {34, "RevokeActiveObject"},
    {23, "SafeArrayAccessData"},
    {37, "SafeArrayAllocData"},
    {36, "SafeArrayAllocDescriptor"},
    {41, "SafeArrayAllocDescriptorEx"},
    {27, "SafeArrayCopy"},
    {412, "SafeArrayCopyData"},
    {15, "SafeArrayCreate"},
    {42, "SafeArrayCreateEx"},
    {411, "SafeArrayCreateVector"},
    {43, "SafeArrayCreateVectorEx"},
    {16, "SafeArrayDestroy"},
    {39, "SafeArrayDestroyData"},
    {38, "SafeArrayDestroyDescriptor"},
    {17, "SafeArrayGetDim"},
    {25, "SafeArrayGetElement"},
    {18, "SafeArrayGetElemsize"},
    {67, "SafeArrayGetIID"},
    {20, "SafeArrayGetLBound"},
    {45, "SafeArrayGetRecordInfo"},
    {19, "SafeArrayGetUBound"},
    {77, "SafeArrayGetVartype"},
    {21, "SafeArrayLock"},
    {148, "SafeArrayPtrOfIndex"},
    {26, "SafeArrayPutElement"},
    {40, "SafeArrayRedim"},
    {57, "SafeArraySetIID"},
    {44, "SafeArraySetRecordInfo"},
    {24, "SafeArrayUnaccessData"},
    {22, "SafeArrayUnlock"},
    {201, "SetErrorInfo"},
    {327, "SetOaNoCache"},
    {325, "SetVarConversionLocaleSetting"},
    {2, "SysAllocString"},
    {150, "SysAllocStringByteLen"},
    {4, "SysAllocStringLen"},
    {6, "SysFreeString"},
    {3, "SysReAllocString"},
    {5, "SysReAllocStringLen"},
    {149, "SysStringByteLen"},
    {7, "SysStringLen"},
    {184, "SystemTimeToVariantTime"},
    {186, "UnRegisterTypeLib"},
    {443, "UnRegisterTypeLibForUser"},
    {290, "VARIANT_UserFree"},
    {288, "VARIANT_UserMarshal"},
    {287, "VARIANT_UserSize"},
    {289, "VARIANT_UserUnmarshal"},
    {168, "VarAbs"},
    {141, "VarAdd"},
    {142, "VarAnd"},
    {124, "VarBoolFromCy"},
    {123, "VarBoolFromDate"},
    {236, "VarBoolFromDec"},
    {126, "VarBoolFromDisp"},
    {233, "VarBoolFromI1"},
    {119, "VarBoolFromI2"},
    {120, "VarBoolFromI4"},
    {370, "VarBoolFromI8"},
    {121, "VarBoolFromR4"},
    {122, "VarBoolFromR8"},
    {125, "VarBoolFromStr"},
    {118, "VarBoolFromUI1"},
    {234, "VarBoolFromUI2"},
    {235, "VarBoolFromUI4"},
    {371, "VarBoolFromUI8"},
    {313, "VarBstrCat"},
    {314, "VarBstrCmp"},
    {116, "VarBstrFromBool"},
    {113, "VarBstrFromCy"},
    {114, "VarBstrFromDate"},
    {232, "VarBstrFromDec"},
    {115, "VarBstrFromDisp"},
    {229, "VarBstrFromI1"},
    {109, "VarBstrFromI2"},
    {110, "VarBstrFromI4"},
    {368, "VarBstrFromI8"},
    {111, "VarBstrFromR4"},
    {112, "VarBstrFromR8"},
    {108, "VarBstrFromUI1"},
    {230, "VarBstrFromUI2"},
    {231, "VarBstrFromUI4"},
    {369, "VarBstrFromUI8"},
    {318, "VarCat"},
    {176, "VarCmp"},
    {306, "VarCyAbs"},
    {299, "VarCyAdd"},
    {311, "VarCyCmp"},
    {312, "VarCyCmpR8"},
    {307, "VarCyFix"},
    {106, "VarCyFromBool"},
    {103, "VarCyFromDate"},
    {228, "VarCyFromDec"},
    {105, "VarCyFromDisp"},
    {225, "VarCyFromI1"},
    {99, "VarCyFromI2"},
    {100, "VarCyFromI4"},
    {366, "VarCyFromI8"},
    {101, "VarCyFromR4"},
    {102, "VarCyFromR8"},
    {104, "VarCyFromStr"},
    {98, "VarCyFromUI1"},
    {226, "VarCyFromUI2"},
    {227, "VarCyFromUI4"},
    {367, "VarCyFromUI8"},
    {308, "VarCyInt"},
    {303, "VarCyMul"},
    {304, "VarCyMulI4"},
    {329, "VarCyMulI8"},
    {309, "VarCyNeg"},
    {310, "VarCyRound"},
    {305, "VarCySub"},
    {96, "VarDateFromBool"},
    {93, "VarDateFromCy"},
    {224, "VarDateFromDec"},
    {95, "VarDateFromDisp"},
    {221, "VarDateFromI1"},
    {89, "VarDateFromI2"},
    {90, "VarDateFromI4"},
    {364, "VarDateFromI8"},
    {91, "VarDateFromR4"},
    {92, "VarDateFromR8"},
    {94, "VarDateFromStr"},
    {88, "VarDateFromUI1"},
    {222, "VarDateFromUI2"},
    {223, "VarDateFromUI4"},
    {365, "VarDateFromUI8"},
    {330, "VarDateFromUdate"},
    {319, "VarDateFromUdateEx"},
    {182, "VarDecAbs"},
    {177, "VarDecAdd"},
    {204, "VarDecCmp"},
    {298, "VarDecCmpR8"},
    {178, "VarDecDiv"},
    {187, "VarDecFix"},
    {199, "VarDecFromBool"},
    {196, "VarDecFromCy"},
    {195, "VarDecFromDate"},
    {198, "VarDecFromDisp"},
    {241, "VarDecFromI1"},
    {191, "VarDecFromI2"},
    {192, "VarDecFromI4"},
    {374, "VarDecFromI8"},
    {193, "VarDecFromR4"},
    {194, "VarDecFromR8"},
    {197, "VarDecFromStr"},
    {190, "VarDecFromUI1"},
    {242, "VarDecFromUI2"},
    {243, "VarDecFromUI4"},
    {375, "VarDecFromUI8"},
    {188, "VarDecInt"},
    {179, "VarDecMul"},
    {189, "VarDecNeg"},
    {203, "VarDecRound"},
    {181, "VarDecSub"},
    {143, "VarDiv"},
    {152, "VarEqv"},
    {169, "VarFix"},
    {87, "VarFormat"},
    {127, "VarFormatCurrency"},
    {97, "VarFormatDateTime"},
    {139, "VarFormatFromTokens"},
    {107, "VarFormatNumber"},
    {117, "VarFormatPercent"},
    {253, "VarI1FromBool"},
    {250, "VarI1FromCy"},
    {249, "VarI1FromDate"},
    {256, "VarI1FromDec"},
    {252, "VarI1FromDisp"},
    {245, "VarI1FromI2"},
    {246, "VarI1FromI4"},
    {376, "VarI1FromI8"},
    {247, "VarI1FromR4"},
    {248, "VarI1FromR8"},
    {251, "VarI1FromStr"},
    {244, "VarI1FromUI1"},
    {254, "VarI1FromUI2"},
    {255, "VarI1FromUI4"},
    {377, "VarI1FromUI8"},
    {56, "VarI2FromBool"},
    {52, "VarI2FromCy"},
    {53, "VarI2FromDate"},
    {208, "VarI2FromDec"},
    {55, "VarI2FromDisp"},
    {205, "VarI2FromI1"},
    {49, "VarI2FromI4"},
    {346, "VarI2FromI8"},
    {50, "VarI2FromR4"},
    {51, "VarI2FromR8"},
    {54, "VarI2FromStr"},
    {48, "VarI2FromUI1"},
    {206, "VarI2FromUI2"},
    {207, "VarI2FromUI4"},
    {347, "VarI2FromUI8"},
    {66, "VarI4FromBool"},
    {62, "VarI4FromCy"},
    {63, "VarI4FromDate"},
    {212, "VarI4FromDec"},
    {65, "VarI4FromDisp"},
    {209, "VarI4FromI1"},
    {59, "VarI4FromI2"},
    {348, "VarI4FromI8"},
    {60, "VarI4FromR4"},
    {61, "VarI4FromR8"},
    {64, "VarI4FromStr"},
    {58, "VarI4FromUI1"},
    {210, "VarI4FromUI2"},
    {211, "VarI4FromUI4"},
    {349, "VarI4FromUI8"},
    {341, "VarI8FromBool"},
    {337, "VarI8FromCy"},
    {338, "VarI8FromDate"},
    {345, "VarI8FromDec"},
    {340, "VarI8FromDisp"},
    {342, "VarI8FromI1"},
    {334, "VarI8FromI2"},
    {335, "VarI8FromR4"},
    {336, "VarI8FromR8"},
    {339, "VarI8FromStr"},
    {333, "VarI8FromUI1"},
    {343, "VarI8FromUI2"},
    {344, "VarI8FromUI4"},
    {427, "VarI8FromUI8"},
    {153, "VarIdiv"},
    {154, "VarImp"},
    {172, "VarInt"},
    {155, "VarMod"},
    {129, "VarMonthName"},
    {156, "VarMul"},
    {173, "VarNeg"},
    {174, "VarNot"},
    {47, "VarNumFromParseNum"},
    {157, "VarOr"},
    {46, "VarParseNumFromStr"},
    {158, "VarPow"},
    {316, "VarR4CmpR8"},
    {76, "VarR4FromBool"},
    {72, "VarR4FromCy"},
    {73, "VarR4FromDate"},
    {216, "VarR4FromDec"},
    {75, "VarR4FromDisp"},
    {213, "VarR4FromI1"},
    {69, "VarR4FromI2"},
    {70, "VarR4FromI4"},
    {360, "VarR4FromI8"},
    {71, "VarR4FromR8"},
    {74, "VarR4FromStr"},
    {68, "VarR4FromUI1"},
    {214, "VarR4FromUI2"},
    {215, "VarR4FromUI4"},
    {361, "VarR4FromUI8"},
    {86, "VarR8FromBool"},
    {82, "VarR8FromCy"},
    {83, "VarR8FromDate"},
    {220, "VarR8FromDec"},
    {85, "VarR8FromDisp"},
    {217, "VarR8FromI1"},
    {79, "VarR8FromI2"},
    {80, "VarR8FromI4"},
    {362, "VarR8FromI8"},
    {81, "VarR8FromR4"},
    {84, "VarR8FromStr"},
    {78, "VarR8FromUI1"},
    {218, "VarR8FromUI2"},
    {219, "VarR8FromUI4"},
    {363, "VarR8FromUI8"},
    {315, "VarR8Pow"},
    {317, "VarR8Round"},
    {175, "VarRound"},
    {159, "VarSub"},
    {140, "VarTokenizeFormatString"},
    {138, "VarUI1FromBool"},
    {134, "VarUI1FromCy"},
    {135, "VarUI1FromDate"},
    {240, "VarUI1FromDec"},
    {137, "VarUI1FromDisp"},
    {237, "VarUI1FromI1"},
    {130, "VarUI1FromI2"},
    {131, "VarUI1FromI4"},
    {372, "VarUI1FromI8"},
    {132, "VarUI1FromR4"},
    {133, "VarUI1FromR8"},
    {136, "VarUI1FromStr"},
    {238, "VarUI1FromUI2"},
    {239, "VarUI1FromUI4"},
    {373, "VarUI1FromUI8"},
    {266, "VarUI2FromBool"},
    {263, "VarUI2FromCy"},
    {262, "VarUI2FromDate"},
    {269, "VarUI2FromDec"},
    {265, "VarUI2FromDisp"},
    {267, "VarUI2FromI1"},
    {258, "VarUI2FromI2"},
    {259, "VarUI2FromI4"},
    {378, "VarUI2FromI8"},
    {260, "VarUI2FromR4"},
    {261, "VarUI2FromR8"},
    {264, "VarUI2FromStr"},
    {257, "VarUI2FromUI1"},
    {268, "VarUI2FromUI4"},
    {379, "VarUI2FromUI8"},
    {279, "VarUI4FromBool"},
    {276, "VarUI4FromCy"},
    {275, "VarUI4FromDate"},
    {282, "VarUI4FromDec"},
    {278, "VarUI4FromDisp"},
    {280, "VarUI4FromI1"},
    {271, "VarUI4FromI2"},
    {272, "VarUI4FromI4"},
    {425, "VarUI4FromI8"},
    {273, "VarUI4FromR4"},
    {274, "VarUI4FromR8"},
    {277, "VarUI4FromStr"},
    {270, "VarUI4FromUI1"},
    {281, "VarUI4FromUI2"},
    {426, "VarUI4FromUI8"},
    {437, "VarUI8FromBool"},
    {433, "VarUI8FromCy"},
    {434, "VarUI8FromDate"},
    {441, "VarUI8FromDec"},
    {436, "VarUI8FromDisp"},
    {438, "VarUI8FromI1"},
    {430, "VarUI8FromI2"},
    {428, "VarUI8FromI8"},
    {431, "VarUI8FromR4"},
    {432, "VarUI8FromR8"},
    {435, "VarUI8FromStr"},
    {429, "VarUI8FromUI1"},
    {439, "VarUI8FromUI2"},
    {440, "VarUI8FromUI4"},
    {331, "VarUdateFromDate"},
    {128, "VarWeekdayName"},
    {167, "VarXor"},
    {12, "VariantChangeType"},
    {147, "VariantChangeTypeEx"},
    {9, "VariantClear"},
    {10, "VariantCopy"},
    {11, "VariantCopyInd"},
    {8, "VariantInit"},
    {13, "VariantTimeToDosDateTime"},
    {185, "VariantTimeToSystemTime"},
    {413, "VectorFromBstr"},
    {0, NULL}};
static Dw32Ordinal oledlg[] = {
    {1, "OleUIAddVerbMenuA"},
    {13, "OleUIAddVerbMenuW"},
    {8, "OleUIBusyA"},
    {14, "OleUIBusyW"},
    {2, "OleUICanConvertOrActivateAs"},
    {6, "OleUIChangeIconA"},
    {15, "OleUIChangeIconW"},
    {12, "OleUIChangeSourceA"},
    {16, "OleUIChangeSourceW"},
    {7, "OleUIConvertA"},
    {17, "OleUIConvertW"},
    {5, "OleUIEditLinksA"},
    {18, "OleUIEditLinksW"},
    {3, "OleUIInsertObjectA"},
    {19, "OleUIInsertObjectW"},
    {11, "OleUIObjectPropertiesA"},
    {20, "OleUIObjectPropertiesW"},
    {4, "OleUIPasteSpecialA"},
    {21, "OleUIPasteSpecialW"},
    {10, "OleUIPromptUserA"},
    {22, "OleUIPromptUserW"},
    {9, "OleUIUpdateLinksA"},
    {23, "OleUIUpdateLinksW"},
    {0, NULL}};
static Dw32Ordinal olepro32[] = {
    {255, "DllCanUnloadNow"},
    {256, "DllGetClassObject"},
    {257, "DllRegisterServer"},
    {258, "DllUnregisterServer"},
    {253, "OleCreateFontIndirect"},
    {252, "OleCreatePictureIndirect"},
    {250, "OleCreatePropertyFrame"},
    {249, "OleCreatePropertyFrameIndirect"},
    {248, "OleIconToCursor"},
    {251, "OleLoadPicture"},
    {254, "OleTranslateColor"},
    {0, NULL}};
static Dw32Ordinal opengl32[] = {
    {1, "GlmfBeginGlsBlock"},
    {2, "GlmfCloseMetaFile"},
    {3, "GlmfEndGlsBlock"},
    {4, "GlmfEndPlayback"},
    {5, "GlmfInitPlayback"},
    {6, "GlmfPlayGlsRecord"},
    {7, "glAccum"},
    {8, "glAlphaFunc"},
    {9, "glAreTexturesResident"},
    {10, "glArrayElement"},
    {11, "glBegin"},
    {12, "glBindTexture"},
    {13, "glBitmap"},
    {14, "glBlendFunc"},
    {15, "glCallList"},
    {16, "glCallLists"},
    {17, "glClear"},
    {18, "glClearAccum"},
    {19, "glClearColor"},
    {20, "glClearDepth"},
    {21, "glClearIndex"},
    {22, "glClearStencil"},
    {23, "glClipPlane"},
    {24, "glColor3b"},
    {25, "glColor3bv"},
    {26, "glColor3d"},
    {27, "glColor3dv"},
    {28, "glColor3f"},
    {29, "glColor3fv"},
    {30, "glColor3i"},
    {31, "glColor3iv"},
    {32, "glColor3s"},
    {33, "glColor3sv"},
    {34, "glColor3ub"},
    {35, "glColor3ubv"},
    {36, "glColor3ui"},
    {37, "glColor3uiv"},
    {38, "glColor3us"},
    {39, "glColor3usv"},
    {40, "glColor4b"},
    {41, "glColor4bv"},
    {42, "glColor4d"},
    {43, "glColor4dv"},
    {44, "glColor4f"},
    {45, "glColor4fv"},
    {46, "glColor4i"},
    {47, "glColor4iv"},
    {48, "glColor4s"},
    {49, "glColor4sv"},
    {50, "glColor4ub"},
    {51, "glColor4ubv"},
    {52, "glColor4ui"},
    {53, "glColor4uiv"},
    {54, "glColor4us"},
    {55, "glColor4usv"},
    {56, "glColorMask"},
    {57, "glColorMaterial"},
    {58, "glColorPointer"},
    {59, "glCopyPixels"},
    {60, "glCopyTexImage1D"},
    {61, "glCopyTexImage2D"},
    {62, "glCopyTexSubImage1D"},
    {63, "glCopyTexSubImage2D"},
    {64, "glCullFace"},
    {65, "glDebugEntry"},
    {66, "glDeleteLists"},
    {67, "glDeleteTextures"},
    {68, "glDepthFunc"},
    {69, "glDepthMask"},
    {70, "glDepthRange"},
    {71, "glDisable"},
    {72, "glDisableClientState"},
    {73, "glDrawArrays"},
    {74, "glDrawBuffer"},
    {75, "glDrawElements"},
    {76, "glDrawPixels"},
    {77, "glEdgeFlag"},
    {78, "glEdgeFlagPointer"},
    {79, "glEdgeFlagv"},
    {80, "glEnable"},
    {81, "glEnableClientState"},
    {82, "glEnd"},
    {83, "glEndList"},
    {84, "glEvalCoord1d"},
    {85, "glEvalCoord1dv"},
    {86, "glEvalCoord1f"},
    {87, "glEvalCoord1fv"},
    {88, "glEvalCoord2d"},
    {89, "glEvalCoord2dv"},
    {90, "glEvalCoord2f"},
    {91, "glEvalCoord2fv"},
    {92, "glEvalMesh1"},
    {93, "glEvalMesh2"},
    {94, "glEvalPoint1"},
    {95, "glEvalPoint2"},
    {96, "glFeedbackBuffer"},
    {97, "glFinish"},
    {98, "glFlush"},
    {99, "glFogf"},
    {100, "glFogfv"},
    {101, "glFogi"},
    {102, "glFogiv"},
    {103, "glFrontFace"},
    {104, "glFrustum"},
    {105, "glGenLists"},
    {106, "glGenTextures"},
    {107, "glGetBooleanv"},
    {108, "glGetClipPlane"},
    {109, "glGetDoublev"},
    {110, "glGetError"},
    {111, "glGetFloatv"},
    {112, "glGetIntegerv"},
    {113, "glGetLightfv"},
    {114, "glGetLightiv"},
    {115, "glGetMapdv"},
    {116, "glGetMapfv"},
    {117, "glGetMapiv"},
    {118, "glGetMaterialfv"},
    {119, "glGetMaterialiv"},
    {120, "glGetPixelMapfv"},
    {121, "glGetPixelMapuiv"},
    {122, "glGetPixelMapusv"},
    {123, "glGetPointerv"},
    {124, "glGetPolygonStipple"},
    {125, "glGetString"},
    {126, "glGetTexEnvfv"},
    {127, "glGetTexEnviv"},
    {128, "glGetTexGendv"},
    {129, "glGetTexGenfv"},
    {130, "glGetTexGeniv"},
    {131, "glGetTexImage"},
    {132, "glGetTexLevelParameterfv"},
    {133, "glGetTexLevelParameteriv"},
    {134, "glGetTexParameterfv"},
    {135, "glGetTexParameteriv"},
    {136, "glHint"},
    {137, "glIndexMask"},
    {138, "glIndexPointer"},
    {139, "glIndexd"},
    {140, "glIndexdv"},
    {141, "glIndexf"},
    {142, "glIndexfv"},
    {143, "glIndexi"},
    {144, "glIndexiv"},
    {145, "glIndexs"},
    {146, "glIndexsv"},
    {147, "glIndexub"},
    {148, "glIndexubv"},
    {149, "glInitNames"},
    {150, "glInterleavedArrays"},
    {151, "glIsEnabled"},
    {152, "glIsList"},
    {153, "glIsTexture"},
    {154, "glLightModelf"},
    {155, "glLightModelfv"},
    {156, "glLightModeli"},
    {157, "glLightModeliv"},
    {158, "glLightf"},
    {159, "glLightfv"},
    {160, "glLighti"},
    {161, "glLightiv"},
    {162, "glLineStipple"},
    {163, "glLineWidth"},
    {164, "glListBase"},
    {165, "glLoadIdentity"},
    {166, "glLoadMatrixd"},
    {167, "glLoadMatrixf"},
    {168, "glLoadName"},
    {169, "glLogicOp"},
    {170, "glMap1d"},
    {171, "glMap1f"},
    {172, "glMap2d"},
    {173, "glMap2f"},
    {174, "glMapGrid1d"},
    {175, "glMapGrid1f"},
    {176, "glMapGrid2d"},
    {177, "glMapGrid2f"},
    {178, "glMaterialf"},
    {179, "glMaterialfv"},
    {180, "glMateriali"},
    {181, "glMaterialiv"},
    {182, "glMatrixMode"},
    {183, "glMultMatrixd"},
    {184, "glMultMatrixf"},
    {185, "glNewList"},
    {186, "glNormal3b"},
    {187, "glNormal3bv"},
    {188, "glNormal3d"},
    {189, "glNormal3dv"},
    {190, "glNormal3f"},
    {191, "glNormal3fv"},
    {192, "glNormal3i"},
    {193, "glNormal3iv"},
    {194, "glNormal3s"},
    {195, "glNormal3sv"},
    {196, "glNormalPointer"},
    {197, "glOrtho"},
    {198, "glPassThrough"},
    {199, "glPixelMapfv"},
    {200, "glPixelMapuiv"},
    {201, "glPixelMapusv"},
    {202, "glPixelStoref"},
    {203, "glPixelStorei"},
    {204, "glPixelTransferf"},
    {205, "glPixelTransferi"},
    {206, "glPixelZoom"},
    {207, "glPointSize"},
    {208, "glPolygonMode"},
    {209, "glPolygonOffset"},
    {210, "glPolygonStipple"},
    {211, "glPopAttrib"},
    {212, "glPopClientAttrib"},
    {213, "glPopMatrix"},
    {214, "glPopName"},
    {215, "glPrioritizeTextures"},
    {216, "glPushAttrib"},
    {217, "glPushClientAttrib"},
    {218, "glPushMatrix"},
    {219, "glPushName"},
    {220, "glRasterPos2d"},
    {221, "glRasterPos2dv"},
    {222, "glRasterPos2f"},
    {223, "glRasterPos2fv"},
    {224, "glRasterPos2i"},
    {225, "glRasterPos2iv"},
    {226, "glRasterPos2s"},
    {227, "glRasterPos2sv"},
    {228, "glRasterPos3d"},
    {229, "glRasterPos3dv"},
    {230, "glRasterPos3f"},
    {231, "glRasterPos3fv"},
    {232, "glRasterPos3i"},
    {233, "glRasterPos3iv"},
    {234, "glRasterPos3s"},
    {235, "glRasterPos3sv"},
    {236, "glRasterPos4d"},
    {237, "glRasterPos4dv"},
    {238, "glRasterPos4f"},
    {239, "glRasterPos4fv"},
    {240, "glRasterPos4i"},
    {241, "glRasterPos4iv"},
    {242, "glRasterPos4s"},
    {243, "glRasterPos4sv"},
    {244, "glReadBuffer"},
    {245, "glReadPixels"},
    {246, "glRectd"},
    {247, "glRectdv"},
    {248, "glRectf"},
    {249, "glRectfv"},
    {250, "glRecti"},
    {251, "glRectiv"},
    {252, "glRects"},
    {253, "glRectsv"},
    {254, "glRenderMode"},
    {255, "glRotated"},
    {256, "glRotatef"},
    {257, "glScaled"},
    {258, "glScalef"},
    {259, "glScissor"},
    {260, "glSelectBuffer"},
    {261, "glShadeModel"},
    {262, "glStencilFunc"},
    {263, "glStencilMask"},
    {264, "glStencilOp"},
    {265, "glTexCoord1d"},
    {266, "glTexCoord1dv"},
    {267, "glTexCoord1f"},
    {268, "glTexCoord1fv"},
    {269, "glTexCoord1i"},
    {270, "glTexCoord1iv"},
    {271, "glTexCoord1s"},
    {272, "glTexCoord1sv"},
    {273, "glTexCoord2d"},
    {274, "glTexCoord2dv"},
    {275, "glTexCoord2f"},
    {276, "glTexCoord2fv"},
    {277, "glTexCoord2i"},
    {278, "glTexCoord2iv"},
    {279, "glTexCoord2s"},
    {280, "glTexCoord2sv"},
    {281, "glTexCoord3d"},
    {282, "glTexCoord3dv"},
    {283, "glTexCoord3f"},
    {284, "glTexCoord3fv"},
    {285, "glTexCoord3i"},
    {286, "glTexCoord3iv"},
    {287, "glTexCoord3s"},
    {288, "glTexCoord3sv"},
    {289, "glTexCoord4d"},
    {290, "glTexCoord4dv"},
    {291, "glTexCoord4f"},
    {292, "glTexCoord4fv"},
    {293, "glTexCoord4i"},
    {294, "glTexCoord4iv"},
    {295, "glTexCoord4s"},
    {296, "glTexCoord4sv"},
    {297, "glTexCoordPointer"},
    {298, "glTexEnvf"},
    {299, "glTexEnvfv"},
    {300, "glTexEnvi"},
    {301, "glTexEnviv"},
    {302, "glTexGend"},
    {303, "glTexGendv"},
    {304, "glTexGenf"},
    {305, "glTexGenfv"},
    {306, "glTexGeni"},
    {307, "glTexGeniv"},
    {308, "glTexImage1D"},
    {309, "glTexImage2D"},
    {310, "glTexParameterf"},
    {311, "glTexParameterfv"},
    {312, "glTexParameteri"},
    {313, "glTexParameteriv"},
    {314, "glTexSubImage1D"},
    {315, "glTexSubImage2D"},
    {316, "glTranslated"},
    {317, "glTranslatef"},
    {318, "glVertex2d"},
    {319, "glVertex2dv"},
    {320, "glVertex2f"},
    {321, "glVertex2fv"},
    {322, "glVertex2i"},
    {323, "glVertex2iv"},
    {324, "glVertex2s"},
    {325, "glVertex2sv"},
    {326, "glVertex3d"},
    {327, "glVertex3dv"},
    {328, "glVertex3f"},
    {329, "glVertex3fv"},
    {330, "glVertex3i"},
    {331, "glVertex3iv"},
    {332, "glVertex3s"},
    {333, "glVertex3sv"},
    {334, "glVertex4d"},
    {335, "glVertex4dv"},
    {336, "glVertex4f"},
    {337, "glVertex4fv"},
    {338, "glVertex4i"},
    {339, "glVertex4iv"},
    {340, "glVertex4s"},
    {341, "glVertex4sv"},
    {342, "glVertexPointer"},
    {343, "glViewport"},
    {344, "wglChoosePixelFormat"},
    {345, "wglCopyContext"},
    {346, "wglCreateContext"},
    {347, "wglCreateLayerContext"},
    {348, "wglDeleteContext"},
    {349, "wglDescribeLayerPlane"},
    {350, "wglDescribePixelFormat"},
    {351, "wglGetCurrentContext"},
    {352, "wglGetCurrentDC"},
    {353, "wglGetDefaultProcAddress"},
    {354, "wglGetLayerPaletteEntries"},
    {355, "wglGetPixelFormat"},
    {356, "wglGetProcAddress"},
    {357, "wglMakeCurrent"},
    {358, "wglRealizeLayerPalette"},
    {359, "wglSetLayerPaletteEntries"},
    {360, "wglSetPixelFormat"},
    {361, "wglShareLists"},
    {362, "wglSwapBuffers"},
    {363, "wglSwapLayerBuffers"},
    {364, "wglSwapMultipleBuffers"},
    {365, "wglUseFontBitmapsA"},
    {366, "wglUseFontBitmapsW"},
    {367, "wglUseFontOutlinesA"},
    {368, "wglUseFontOutlinesW"},
    {0, NULL}};
static Dw32Ordinal p2p[] = {
    {1, "DllMain"},
    {2, "PeerCollabAddContact"},
    {3, "PeerCollabAsyncInviteContact"},
    {4, "PeerCollabAsyncInviteEndpoint"},
    {5, "PeerCollabCancelInvitation"},
    {6, "PeerCollabCloseHandle"},
    {7, "PeerCollabDeleteContact"},
    {8, "PeerCollabDeleteEndpointData"},
    {9, "PeerCollabDeleteObject"},
    {10, "PeerCollabEnumApplicationRegistrationInfo"},
    {11, "PeerCollabEnumApplications"},
    {12, "PeerCollabEnumContacts"},
    {13, "PeerCollabEnumEndpoints"},
    {14, "PeerCollabEnumObjects"},
    {15, "PeerCollabEnumPeopleNearMe"},
    {16, "PeerCollabExportContact"},
    {17, "PeerCollabGetAppLaunchInfo"},
    {18, "PeerCollabGetApplicationRegistrationInfo"},
    {19, "PeerCollabGetContact"},
    {20, "PeerCollabGetEndpointName"},
    {21, "PeerCollabGetEventData"},
    {22, "PeerCollabGetInvitationResponse"},
    {23, "PeerCollabGetPresenceInfo"},
    {24, "PeerCollabGetSigninOptions"},
    {25, "PeerCollabInviteContact"},
    {26, "PeerCollabInviteEndpoint"},
    {27, "PeerCollabParseContact"},
    {28, "PeerCollabQueryContactData"},
    {29, "PeerCollabRefreshEndpointData"},
    {30, "PeerCollabRegisterApplication"},
    {31, "PeerCollabRegisterEvent"},
    {32, "PeerCollabSetEndpointName"},
    {33, "PeerCollabSetObject"},
    {34, "PeerCollabSetPresenceInfo"},
    {35, "PeerCollabShutdown"},
    {36, "PeerCollabSignin"},
    {37, "PeerCollabSignout"},
    {38, "PeerCollabStartup"},
    {39, "PeerCollabSubscribeEndpointData"},
    {40, "PeerCollabUnregisterApplication"},
    {41, "PeerCollabUnregisterEvent"},
    {42, "PeerCollabUnsubscribeEndpointData"},
    {43, "PeerCollabUpdateContact"},
    {44, "PeerCreatePeerName"},
    {45, "PeerEndEnumeration"},
    {46, "PeerEnumGroups"},
    {47, "PeerEnumIdentities"},
    {48, "PeerFreeData"},
    {49, "PeerGetItemCount"},
    {50, "PeerGetNextItem"},
    {51, "PeerGroupAddRecord"},
    {52, "PeerGroupClose"},
    {53, "PeerGroupCloseDirectConnection"},
    {54, "PeerGroupConnect"},
    {55, "PeerGroupConnectByAddress"},
    {56, "PeerGroupCreate"},
    {57, "PeerGroupCreateInvitation"},
    {58, "PeerGroupCreatePasswordInvitation"},
    {59, "PeerGroupDelete"},
    {60, "PeerGroupDeleteRecord"},
    {61, "PeerGroupEnumConnections"},
    {62, "PeerGroupEnumMembers"},
    {63, "PeerGroupEnumRecords"},
    {64, "PeerGroupExportConfig"},
    {65, "PeerGroupExportDatabase"},
    {66, "PeerGroupGetEventData"},
    {67, "PeerGroupGetProperties"},
    {68, "PeerGroupGetRecord"},
    {69, "PeerGroupGetStatus"},
    {70, "PeerGroupImportConfig"},
    {71, "PeerGroupImportDatabase"},
    {72, "PeerGroupIssueCredentials"},
    {73, "PeerGroupJoin"},
    {74, "PeerGroupOpen"},
    {75, "PeerGroupOpenDirectConnection"},
    {76, "PeerGroupParseInvitation"},
    {77, "PeerGroupPasswordJoin"},
    {78, "PeerGroupPeerTimeToUniversalTime"},
    {79, "PeerGroupRegisterEvent"},
    {80, "PeerGroupResumePasswordAuthentication"},
    {81, "PeerGroupSearchRecords"},
    {82, "PeerGroupSendData"},
    {83, "PeerGroupSetProperties"},
    {84, "PeerGroupShutdown"},
    {85, "PeerGroupStartup"},
    {86, "PeerGroupUniversalTimeToPeerTime"},
    {87, "PeerGroupUnregisterEvent"},
    {88, "PeerGroupUpdateRecord"},
    {89, "PeerHostNameToPeerName"},
    {90, "PeerIdentityCreate"},
    {91, "PeerIdentityDelete"},
    {92, "PeerIdentityExport"},
    {93, "PeerIdentityGetCert"},
    {94, "PeerIdentityGetCryptKey"},
    {95, "PeerIdentityGetDefault"},
    {96, "PeerIdentityGetFriendlyName"},
    {97, "PeerIdentityGetXML"},
    {98, "PeerIdentityImport"},
    {99, "PeerIdentitySetFriendlyName"},
    {100, "PeerNameToPeerHostName"},
    {101, "PeerPnrpEndResolve"},
    {102, "PeerPnrpGetCloudInfo"},
    {103, "PeerPnrpGetEndpoint"},
    {104, "PeerPnrpRegister"},
    {105, "PeerPnrpResolve"},
    {106, "PeerPnrpShutdown"},
    {107, "PeerPnrpStartResolve"},
    {108, "PeerPnrpStartup"},
    {109, "PeerPnrpUnregister"},
    {110, "PeerPnrpUpdateRegistration"},
    {111, "PeerSSPAddCredentials"},
    {112, "PeerSSPRemoveCredentials"},
    {0, NULL}};
static Dw32Ordinal p2pgraph[] = {
    {2, "PeerGraphAddRecord"},
    {3, "PeerGraphClose"},
    {4, "PeerGraphCloseDirectConnection"},
    {5, "PeerGraphConnect"},
    {6, "PeerGraphCreate"},
    {7, "PeerGraphDelete"},
    {8, "PeerGraphDeleteRecord"},
    {9, "PeerGraphEndEnumeration"},
    {10, "PeerGraphEnumConnections"},
    {11, "PeerGraphEnumNodes"},
    {12, "PeerGraphEnumRecords"},
    {13, "PeerGraphExportDatabase"},
    {14, "PeerGraphFreeData"},
    {15, "PeerGraphGetEventData"},
    {16, "PeerGraphGetItemCount"},
    {17, "PeerGraphGetNextItem"},
    {18, "PeerGraphGetNodeInfo"},
    {19, "PeerGraphGetProperties"},
    {20, "PeerGraphGetRecord"},
    {21, "PeerGraphGetStatus"},
    {22, "PeerGraphImportDatabase"},
    {23, "PeerGraphListen"},
    {24, "PeerGraphOpen"},
    {25, "PeerGraphOpenDirectConnection"},
    {26, "PeerGraphPeerTimeToUniversalTime"},
    {27, "PeerGraphRegisterEvent"},
    {28, "PeerGraphSearchRecords"},
    {29, "PeerGraphSendData"},
    {30, "PeerGraphSetNodeAttributes"},
    {31, "PeerGraphSetPresence"},
    {32, "PeerGraphSetProperties"},
    {33, "PeerGraphShutdown"},
    {34, "PeerGraphStartup"},
    {35, "PeerGraphUniversalTimeToPeerTime"},
    {36, "PeerGraphUnregisterEvent"},
    {37, "PeerGraphUpdateRecord"},
    {38, "PeerGraphValidateDeferredRecords"},
    {1, "pMemoryHelper"},
    {0, NULL}};
static Dw32Ordinal pdh[] = {
    {1, "PdhAdd009CounterA"},
    {2, "PdhAdd009CounterW"},
    {3, "PdhAddCounterA"},
    {4, "PdhAddCounterW"},
    {5, "PdhAddEnglishCounterA"},
    {6, "PdhAddEnglishCounterW"},
    {7, "PdhAddRelogCounter"},
    {8, "PdhBindInputDataSourceA"},
    {9, "PdhBindInputDataSourceW"},
    {10, "PdhBrowseCountersA"},
    {11, "PdhBrowseCountersHA"},
    {12, "PdhBrowseCountersHW"},
    {13, "PdhBrowseCountersW"},
    {14, "PdhCalculateCounterFromRawValue"},
    {15, "PdhCloseLog"},
    {16, "PdhCloseQuery"},
    {17, "PdhCollectQueryData"},
    {18, "PdhCollectQueryDataEx"},
    {19, "PdhCollectQueryDataWithTime"},
    {20, "PdhComputeCounterStatistics"},
    {21, "PdhConnectMachineA"},
    {22, "PdhConnectMachineW"},
    {23, "PdhCreateSQLTablesA"},
    {24, "PdhCreateSQLTablesW"},
    {25, "PdhEnumLogSetNamesA"},
    {26, "PdhEnumLogSetNamesW"},
    {27, "PdhEnumMachinesA"},
    {28, "PdhEnumMachinesHA"},
    {29, "PdhEnumMachinesHW"},
    {30, "PdhEnumMachinesW"},
    {31, "PdhEnumObjectItemsA"},
    {32, "PdhEnumObjectItemsHA"},
    {33, "PdhEnumObjectItemsHW"},
    {34, "PdhEnumObjectItemsW"},
    {35, "PdhEnumObjectsA"},
    {36, "PdhEnumObjectsHA"},
    {37, "PdhEnumObjectsHW"},
    {38, "PdhEnumObjectsW"},
    {39, "PdhExpandCounterPathA"},
    {40, "PdhExpandCounterPathW"},
    {41, "PdhExpandWildCardPathA"},
    {42, "PdhExpandWildCardPathHA"},
    {43, "PdhExpandWildCardPathHW"},
    {44, "PdhExpandWildCardPathW"},
    {45, "PdhFormatFromRawValue"},
    {46, "PdhGetCounterInfoA"},
    {47, "PdhGetCounterInfoW"},
    {48, "PdhGetCounterTimeBase"},
    {49, "PdhGetDataSourceTimeRangeA"},
    {50, "PdhGetDataSourceTimeRangeH"},
    {51, "PdhGetDataSourceTimeRangeW"},
    {52, "PdhGetDefaultPerfCounterA"},
    {53, "PdhGetDefaultPerfCounterHA"},
    {54, "PdhGetDefaultPerfCounterHW"},
    {55, "PdhGetDefaultPerfCounterW"},
    {56, "PdhGetDefaultPerfObjectA"},
    {57, "PdhGetDefaultPerfObjectHA"},
    {58, "PdhGetDefaultPerfObjectHW"},
    {59, "PdhGetDefaultPerfObjectW"},
    {60, "PdhGetDllVersion"},
    {61, "PdhGetExplainText"},
    {62, "PdhGetFormattedCounterArrayA"},
    {63, "PdhGetFormattedCounterArrayW"},
    {64, "PdhGetFormattedCounterValue"},
    {65, "PdhGetLogFileSize"},
    {66, "PdhGetLogFileTypeA"},
    {67, "PdhGetLogFileTypeW"},
    {68, "PdhGetLogSetGUID"},
    {69, "PdhGetRawCounterArrayA"},
    {70, "PdhGetRawCounterArrayW"},
    {71, "PdhGetRawCounterValue"},
    {72, "PdhIsRealTimeQuery"},
    {73, "PdhListLogFileHeaderA"},
    {74, "PdhListLogFileHeaderW"},
    {75, "PdhLookupPerfIndexByNameA"},
    {76, "PdhLookupPerfIndexByNameW"},
    {77, "PdhLookupPerfNameByIndexA"},
    {78, "PdhLookupPerfNameByIndexW"},
    {79, "PdhMakeCounterPathA"},
    {80, "PdhMakeCounterPathW"},
    {81, "PdhOpenLogA"},
    {82, "PdhOpenLogW"},
    {83, "PdhOpenQuery"},
    {84, "PdhOpenQueryA"},
    {85, "PdhOpenQueryH"},
    {86, "PdhOpenQueryW"},
    {87, "PdhParseCounterPathA"},
    {88, "PdhParseCounterPathW"},
    {89, "PdhParseInstanceNameA"},
    {90, "PdhParseInstanceNameW"},
    {91, "PdhReadRawLogRecord"},
    {92, "PdhRelogA"},
    {93, "PdhRelogW"},
    {94, "PdhRemoveCounter"},
    {95, "PdhResetRelogCounterValues"},
    {96, "PdhSelectDataSourceA"},
    {97, "PdhSelectDataSourceW"},
    {98, "PdhSetCounterScaleFactor"},
    {99, "PdhSetCounterValue"},
    {100, "PdhSetDefaultRealTimeDataSource"},
    {101, "PdhSetLogSetRunID"},
    {102, "PdhSetQueryTimeRange"},
    {103, "PdhTranslate009CounterA"},
    {104, "PdhTranslate009CounterW"},
    {105, "PdhTranslateLocaleCounterA"},
    {106, "PdhTranslateLocaleCounterW"},
    {107, "PdhUpdateLogA"},
    {108, "PdhUpdateLogFileCatalog"},
    {109, "PdhUpdateLogW"},
    {110, "PdhValidatePathA"},
    {111, "PdhValidatePathExA"},
    {112, "PdhValidatePathExW"},
    {113, "PdhValidatePathW"},
    {114, "PdhVbAddCounter"},
    {115, "PdhVbCreateCounterPathList"},
    {116, "PdhVbGetCounterPathElements"},
    {117, "PdhVbGetCounterPathFromList"},
    {118, "PdhVbGetDoubleCounterValue"},
    {119, "PdhVbGetLogFileSize"},
    {120, "PdhVbGetOneCounterPath"},
    {121, "PdhVbIsGoodStatus"},
    {122, "PdhVbOpenLog"},
    {123, "PdhVbOpenQuery"},
    {124, "PdhVbUpdateLog"},
    {125, "PdhVerifySQLDBA"},
    {126, "PdhVerifySQLDBW"},
    {127, "PdhWriteRelogSample"},
    {0, NULL}};
static Dw32Ordinal powrprof[] = {
    {1, "CallNtPowerInformation"},
    {2, "CanUserWritePwrScheme"},
    {3, "DeletePwrScheme"},
    {4, "DevicePowerClose"},
    {5, "DevicePowerEnumDevices"},
    {6, "DevicePowerOpen"},
    {7, "DevicePowerSetDeviceState"},
    {8, "EnumPwrSchemes"},
    {9, "GUIDFormatToGlobalPowerPolicy"},
    {10, "GUIDFormatToPowerPolicy"},
    {11, "GetActivePwrScheme"},
    {12, "GetCurrentPowerPolicies"},
    {13, "GetPwrCapabilities"},
    {14, "GetPwrDiskSpindownRange"},
    {15, "IsAdminOverrideActive"},
    {16, "IsPwrHibernateAllowed"},
    {17, "IsPwrShutdownAllowed"},
    {18, "IsPwrSuspendAllowed"},
    {19, "LoadCurrentPwrScheme"},
    {20, "MergeLegacyPwrScheme"},
    {21, "PowerApplyPowerRequestOverride"},
    {22, "PowerCanRestoreIndividualDefaultPowerScheme"},
    {23, "PowerCreatePossibleSetting"},
    {24, "PowerCreateSetting"},
    {25, "PowerCustomizePlatformPowerSettings"},
    {26, "PowerDebugDifPowerPolicies"},
    {27, "PowerDebugDifSystemPowerPolicies"},
    {28, "PowerDebugDumpPowerPolicy"},
    {29, "PowerDebugDumpPowerScheme"},
    {30, "PowerDebugDumpSystemPowerCapabilities"},
    {31, "PowerDebugDumpSystemPowerPolicy"},
    {32, "PowerDeleteScheme"},
    {33, "PowerDeterminePlatformRole"},
    {34, "PowerDuplicateScheme"},
    {35, "PowerEnumerate"},
    {36, "PowerGetActiveScheme"},
    {37, "PowerImportPowerScheme"},
    {38, "PowerOpenSystemPowerKey"},
    {39, "PowerOpenUserPowerKey"},
    {40, "PowerPolicyToGUIDFormat"},
    {41, "PowerReadACDefaultIndex"},
    {42, "PowerReadACValue"},
    {43, "PowerReadACValueIndex"},
    {44, "PowerReadDCDefaultIndex"},
    {45, "PowerReadDCValue"},
    {46, "PowerReadDCValueIndex"},
    {47, "PowerReadDescription"},
    {48, "PowerReadFriendlyName"},
    {49, "PowerReadIconResourceSpecifier"},
    {50, "PowerReadPossibleDescription"},
    {51, "PowerReadPossibleFriendlyName"},
    {52, "PowerReadPossibleValue"},
    {53, "PowerReadSecurityDescriptor"},
    {54, "PowerReadSettingAttributes"},
    {55, "PowerReadValueIncrement"},
    {56, "PowerReadValueMax"},
    {57, "PowerReadValueMin"},
    {58, "PowerReadValueUnitsSpecifier"},
    {59, "PowerRemovePowerSetting"},
    {60, "PowerReplaceDefaultPowerSchemes"},
    {61, "PowerRestoreDefaultPowerSchemes"},
    {62, "PowerRestoreIndividualDefaultPowerScheme"},
    {63, "PowerSetActiveScheme"},
    {64, "PowerSetAlsBrightnessOffset"},
    {65, "PowerSettingAccessCheck"},
    {66, "PowerSettingRegisterNotification"},
    {67, "PowerSettingUnregisterNotification"},
    {68, "PowerWriteACDefaultIndex"},
    {69, "PowerWriteACValueIndex"},
    {70, "PowerWriteDCDefaultIndex"},
    {71, "PowerWriteDCValueIndex"},
    {72, "PowerWriteDescription"},
    {73, "PowerWriteFriendlyName"},
    {74, "PowerWriteIconResourceSpecifier"},
    {75, "PowerWritePossibleDescription"},
    {76, "PowerWritePossibleFriendlyName"},
    {77, "PowerWritePossibleValue"},
    {78, "PowerWriteSecurityDescriptor"},
    {79, "PowerWriteSettingAttributes"},
    {80, "PowerWriteValueIncrement"},
    {81, "PowerWriteValueMax"},
    {82, "PowerWriteValueMin"},
    {83, "PowerWriteValueUnitsSpecifier"},
    {84, "ReadGlobalPwrPolicy"},
    {85, "ReadProcessorPwrScheme"},
    {86, "ReadPwrScheme"},
    {87, "SetActivePwrScheme"},
    {88, "SetSuspendState"},
    {89, "ValidatePowerPolicies"},
    {90, "WriteGlobalPwrPolicy"},
    {91, "WriteProcessorPwrScheme"},
    {92, "WritePwrScheme"},
    {0, NULL}};
static Dw32Ordinal prntvpt[] = {
    {5, "BindPTProviderThunk"},
    {12, "ConvertDevModeToPrintTicketThunk"},
    {11, "ConvertDevModeToPrintTicketThunk2"},
    {14, "ConvertPrintTicketToDevModeThunk"},
    {13, "ConvertPrintTicketToDevModeThunk2"},
    {15, "DllCanUnloadNow"},
    {16, "DllGetClassObject"},
    {17, "DllMain"},
    {18, "DllRegisterServer"},
    {19, "DllUnregisterServer"},
    {20, "GetDeviceDefaultPrintTicketThunk"},
    {21, "GetDeviceNamespacesThunk"},
    {23, "GetPrintCapabilitiesThunk"},
    {22, "GetPrintCapabilitiesThunk2"},
    {24, "GetSchemaVersionThunk"},
    {26, "MergeAndValidatePrintTicketThunk"},
    {25, "MergeAndValidatePrintTicketThunk2"},
    {4, "PTCloseProvider"},
    {9, "PTConvertDevModeToPrintTicket"},
    {8, "PTConvertPrintTicketToDevMode"},
    {6, "PTGetPrintCapabilities"},
    {7, "PTMergeAndValidatePrintTicket"},
    {2, "PTOpenProvider"},
    {3, "PTOpenProviderEx"},
    {1, "PTQuerySchemaVersionSupport"},
    {10, "PTReleaseMemory"},
    {27, "UnbindPTProviderThunk"},
    {0, NULL}};
static Dw32Ordinal propsys[] = {
    {4, "ClearPropVariantArray"},
    {5, "ClearVariantArray"},
    {6, "DllCanUnloadNow"},
    {7, "DllGetClassObject"},
    {8, "DllRegisterServer"},
    {9, "DllUnregisterServer"},
    {3, "GetProxyDllInfo"},
    {10, "InitPropVariantFromBooleanVector"},
    {11, "InitPropVariantFromBuffer"},
    {12, "InitPropVariantFromCLSID"},
    {13, "InitPropVariantFromDoubleVector"},
    {14, "InitPropVariantFromFileTime"},
    {15, "InitPropVariantFromFileTimeVector"},
    {16, "InitPropVariantFromGUIDAsString"},
    {17, "InitPropVariantFromInt16Vector"},
    {18, "InitPropVariantFromInt32Vector"},
    {19, "InitPropVariantFromInt64Vector"},
    {20, "InitPropVariantFromPropVariantVectorElem"},
    {21, "InitPropVariantFromResource"},
    {22, "InitPropVariantFromStrRet"},
    {23, "InitPropVariantFromStringAsVector"},
    {24, "InitPropVariantFromStringVector"},
    {25, "InitPropVariantFromUInt16Vector"},
    {26, "InitPropVariantFromUInt32Vector"},
    {27, "InitPropVariantFromUInt64Vector"},
    {28, "InitPropVariantVectorFromPropVariant"},
    {29, "InitVariantFromBooleanArray"},
    {30, "InitVariantFromBuffer"},
    {31, "InitVariantFromDoubleArray"},
    {32, "InitVariantFromFileTime"},
    {33, "InitVariantFromFileTimeArray"},
    {34, "InitVariantFromGUIDAsString"},
    {35, "InitVariantFromInt16Array"},
    {36, "InitVariantFromInt32Array"},
    {37, "InitVariantFromInt64Array"},
    {38, "InitVariantFromResource"},
    {39, "InitVariantFromStrRet"},
    {40, "InitVariantFromStringArray"},
    {41, "InitVariantFromUInt16Array"},
    {42, "InitVariantFromUInt32Array"},
    {43, "InitVariantFromUInt64Array"},
    {44, "InitVariantFromVariantArrayElem"},
    {45, "PSCoerceToCanonicalValue"},
    {46, "PSCreateAdapterFromPropertyStore"},
    {47, "PSCreateDelayedMultiplexPropertyStore"},
    {48, "PSCreateMemoryPropertyStore"},
    {49, "PSCreateMultiplexPropertyStore"},
    {50, "PSCreatePropertyChangeArray"},
    {51, "PSCreatePropertyStoreFromObject"},
    {52, "PSCreatePropertyStoreFromPropertySetStorage"},
    {53, "PSCreateSimplePropertyChange"},
    {54, "PSEnumeratePropertyDescriptions"},
    {55, "PSFormatForDisplay"},
    {56, "PSFormatForDisplayAlloc"},
    {57, "PSFormatPropertyValue"},
    {58, "PSGetImageReferenceForValue"},
    {59, "PSGetItemPropertyHandler"},
    {60, "PSGetItemPropertyHandlerWithCreateObject"},
    {61, "PSGetNameFromPropertyKey"},
    {62, "PSGetNamedPropertyFromPropertyStorage"},
    {63, "PSGetPropertyDescription"},
    {64, "PSGetPropertyDescriptionByName"},
    {65, "PSGetPropertyDescriptionListFromString"},
    {66, "PSGetPropertyFromPropertyStorage"},
    {67, "PSGetPropertyKeyFromName"},
    {68, "PSGetPropertySystem"},
    {69, "PSGetPropertyValue"},
    {70, "PSLookupPropertyHandlerCLSID"},
    {71, "PSPropertyBag_Delete"},
    {72, "PSPropertyBag_ReadBOOL"},
    {73, "PSPropertyBag_ReadBSTR"},
    {74, "PSPropertyBag_ReadDWORD"},
    {75, "PSPropertyBag_ReadGUID"},
    {76, "PSPropertyBag_ReadInt"},
    {77, "PSPropertyBag_ReadLONG"},
    {78, "PSPropertyBag_ReadPOINTL"},
    {79, "PSPropertyBag_ReadPOINTS"},
    {80, "PSPropertyBag_ReadPropertyKey"},
    {81, "PSPropertyBag_ReadRECTL"},
    {82, "PSPropertyBag_ReadSHORT"},
    {83, "PSPropertyBag_ReadStr"},
    {84, "PSPropertyBag_ReadStrAlloc"},
    {85, "PSPropertyBag_ReadStream"},
    {86, "PSPropertyBag_ReadType"},
    {87, "PSPropertyBag_ReadULONGLONG"},
    {88, "PSPropertyBag_ReadUnknown"},
    {89, "PSPropertyBag_WriteBOOL"},
    {90, "PSPropertyBag_WriteBSTR"},
    {91, "PSPropertyBag_WriteDWORD"},
    {92, "PSPropertyBag_WriteGUID"},
    {93, "PSPropertyBag_WriteInt"},
    {94, "PSPropertyBag_WriteLONG"},
    {95, "PSPropertyBag_WritePOINTL"},
    {96, "PSPropertyBag_WritePOINTS"},
    {97, "PSPropertyBag_WritePropertyKey"},
    {98, "PSPropertyBag_WriteRECTL"},
    {99, "PSPropertyBag_WriteSHORT"},
    {100, "PSPropertyBag_WriteStr"},
    {101, "PSPropertyBag_WriteStream"},
    {102, "PSPropertyBag_WriteULONGLONG"},
    {103, "PSPropertyBag_WriteUnknown"},
    {104, "PSPropertyKeyFromString"},
    {105, "PSRefreshPropertySchema"},
    {106, "PSRegisterPropertySchema"},
    {107, "PSSetPropertyValue"},
    {108, "PSStringFromPropertyKey"},
    {109, "PSUnregisterPropertySchema"},
    {110, "PropVariantChangeType"},
    {111, "PropVariantCompareEx"},
    {112, "PropVariantGetBooleanElem"},
    {113, "PropVariantGetDoubleElem"},
    {114, "PropVariantGetElementCount"},
    {115, "PropVariantGetFileTimeElem"},
    {116, "PropVariantGetInt16Elem"},
    {117, "PropVariantGetInt32Elem"},
    {118, "PropVariantGetInt64Elem"},
    {119, "PropVariantGetStringElem"},
    {120, "PropVariantGetUInt16Elem"},
    {121, "PropVariantGetUInt32Elem"},
    {122, "PropVariantGetUInt64Elem"},
    {123, "PropVariantToBSTR"},
    {124, "PropVariantToBoolean"},
    {125, "PropVariantToBooleanVector"},
    {126, "PropVariantToBooleanVectorAlloc"},
    {127, "PropVariantToBooleanWithDefault"},
    {128, "PropVariantToBuffer"},
    {129, "PropVariantToDouble"},
    {130, "PropVariantToDoubleVector"},
    {131, "PropVariantToDoubleVectorAlloc"},
    {132, "PropVariantToDoubleWithDefault"},
    {133, "PropVariantToFileTime"},
    {134, "PropVariantToFileTimeVector"},
    {135, "PropVariantToFileTimeVectorAlloc"},
    {136, "PropVariantToGUID"},
    {137, "PropVariantToInt16"},
    {138, "PropVariantToInt16Vector"},
    {139, "PropVariantToInt16VectorAlloc"},
    {140, "PropVariantToInt16WithDefault"},
    {141, "PropVariantToInt32"},
    {142, "PropVariantToInt32Vector"},
    {143, "PropVariantToInt32VectorAlloc"},
    {144, "PropVariantToInt32WithDefault"},
    {145, "PropVariantToInt64"},
    {146, "PropVariantToInt64Vector"},
    {147, "PropVariantToInt64VectorAlloc"},
    {148, "PropVariantToInt64WithDefault"},
    {149, "PropVariantToStrRet"},
    {150, "PropVariantToString"},
    {151, "PropVariantToStringAlloc"},
    {152, "PropVariantToStringVector"},
    {153, "PropVariantToStringVectorAlloc"},
    {154, "PropVariantToStringWithDefault"},
    {155, "PropVariantToUInt16"},
    {156, "PropVariantToUInt16Vector"},
    {157, "PropVariantToUInt16VectorAlloc"},
    {158, "PropVariantToUInt16WithDefault"},
    {159, "PropVariantToUInt32"},
    {160, "PropVariantToUInt32Vector"},
    {161, "PropVariantToUInt32VectorAlloc"},
    {162, "PropVariantToUInt32WithDefault"},
    {163, "PropVariantToUInt64"},
    {164, "PropVariantToUInt64Vector"},
    {165, "PropVariantToUInt64VectorAlloc"},
    {166, "PropVariantToUInt64WithDefault"},
    {167, "PropVariantToVariant"},
    {168, "StgDeserializePropVariant"},
    {169, "StgSerializePropVariant"},
    {170, "VariantCompare"},
    {171, "VariantGetBooleanElem"},
    {172, "VariantGetDoubleElem"},
    {173, "VariantGetElementCount"},
    {174, "VariantGetInt16Elem"},
    {175, "VariantGetInt32Elem"},
    {176, "VariantGetInt64Elem"},
    {177, "VariantGetStringElem"},
    {178, "VariantGetUInt16Elem"},
    {179, "VariantGetUInt32Elem"},
    {180, "VariantGetUInt64Elem"},
    {181, "VariantToBoolean"},
    {182, "VariantToBooleanArray"},
    {183, "VariantToBooleanArrayAlloc"},
    {184, "VariantToBooleanWithDefault"},
    {185, "VariantToBuffer"},
    {186, "VariantToDosDateTime"},
    {187, "VariantToDouble"},
    {188, "VariantToDoubleArray"},
    {189, "VariantToDoubleArrayAlloc"},
    {190, "VariantToDoubleWithDefault"},
    {191, "VariantToFileTime"},
    {192, "VariantToGUID"},
    {193, "VariantToInt16"},
    {194, "VariantToInt16Array"},
    {195, "VariantToInt16ArrayAlloc"},
    {196, "VariantToInt16WithDefault"},
    {197, "VariantToInt32"},
    {198, "VariantToInt32Array"},
    {199, "VariantToInt32ArrayAlloc"},
    {200, "VariantToInt32WithDefault"},
    {201, "VariantToInt64"},
    {202, "VariantToInt64Array"},
    {203, "VariantToInt64ArrayAlloc"},
    {204, "VariantToInt64WithDefault"},
    {205, "VariantToPropVariant"},
    {206, "VariantToStrRet"},
    {207, "VariantToString"},
    {208, "VariantToStringAlloc"},
    {209, "VariantToStringArray"},
    {210, "VariantToStringArrayAlloc"},
    {211, "VariantToStringWithDefault"},
    {212, "VariantToUInt16"},
    {213, "VariantToUInt16Array"},
    {214, "VariantToUInt16ArrayAlloc"},
    {215, "VariantToUInt16WithDefault"},
    {216, "VariantToUInt32"},
    {217, "VariantToUInt32Array"},
    {218, "VariantToUInt32ArrayAlloc"},
    {219, "VariantToUInt32WithDefault"},
    {220, "VariantToUInt64"},
    {221, "VariantToUInt64Array"},
    {222, "VariantToUInt64ArrayAlloc"},
    {223, "VariantToUInt64WithDefault"},
    {0, NULL}};
static Dw32Ordinal psapi[] = {
    {1, "EmptyWorkingSet"},
    {2, "EnumDeviceDrivers"},
    {3, "EnumPageFilesA"},
    {4, "EnumPageFilesW"},
    {5, "EnumProcessModules"},
    {6, "EnumProcessModulesEx"},
    {7, "EnumProcesses"},
    {8, "GetDeviceDriverBaseNameA"},
    {9, "GetDeviceDriverBaseNameW"},
    {10, "GetDeviceDriverFileNameA"},
    {11, "GetDeviceDriverFileNameW"},
    {12, "GetMappedFileNameA"},
    {13, "GetMappedFileNameW"},
    {14, "GetModuleBaseNameA"},
    {15, "GetModuleBaseNameW"},
    {16, "GetModuleFileNameExA"},
    {17, "GetModuleFileNameExW"},
    {18, "GetModuleInformation"},
    {19, "GetPerformanceInfo"},
    {20, "GetProcessImageFileNameA"},
    {21, "GetProcessImageFileNameW"},
    {22, "GetProcessMemoryInfo"},
    {23, "GetWsChanges"},
    {24, "GetWsChangesEx"},
    {25, "InitializeProcessForWsWatch"},
    {26, "QueryWorkingSet"},
    {27, "QueryWorkingSetEx"},
    {0, NULL}};
static Dw32Ordinal quartz[] = {
    {1, "AMGetErrorTextA"},
    {2, "AMGetErrorTextW"},
    {3, "AmpFactorToDB"},
    {4, "DBToAmpFactor"},
    {5, "DllCanUnloadNow"},
    {6, "DllGetClassObject"},
    {7, "DllRegisterServer"},
    {8, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal qutil[] = {
    {1, "AllocConnections"},
    {2, "AllocCountedString"},
    {3, "AllocFixupInfo"},
    {4, "DllCanUnloadNow"},
    {5, "DllGetClassObject"},
    {6, "DllRegisterServer"},
    {7, "DllUnregisterServer"},
    {8, "FreeConnections"},
    {9, "FreeCountedString"},
    {10, "FreeFixupInfo"},
    {11, "FreeIsolationInfo"},
    {12, "FreeIsolationInfoEx"},
    {13, "FreeNapComponentRegistrationInfoArray"},
    {14, "FreeNetworkSoH"},
    {15, "FreePrivateData"},
    {16, "FreeSoH"},
    {17, "FreeSoHAttributeValue"},
    {18, "FreeSystemHealthAgentState"},
    {19, "InitializeNapAgentNotifier"},
    {20, "UninitializeNapAgentNotifier"},
    {0, NULL}};
static Dw32Ordinal qwave[] = {
    {1, "QDLHPathDiagnostics"},
    {2, "QDLHStartDiagnosingPath"},
    {3, "QOSAddSocketToFlow"},
    {4, "QOSCancel"},
    {5, "QOSCloseHandle"},
    {6, "QOSCreateHandle"},
    {7, "QOSEnumerateFlows"},
    {8, "QOSNotifyFlow"},
    {9, "QOSQueryFlow"},
    {10, "QOSRemoveSocketFromFlow"},
    {11, "QOSSetFlow"},
    {12, "QOSStartTrackingClient"},
    {13, "QOSStopTrackingClient"},
    {14, "ServiceMain"},
    {0, NULL}};
static Dw32Ordinal rasapi32[] = {
    {1, "DDMFreePhonebookContext"},
    {2, "DDMGetPhonebookInfo"},
    {3, "DwCloneEntry"},
    {4, "DwEnumEntryDetails"},
    {5, "DwRasUninitialize"},
    {6, "RasAutoDialSharedConnection"},
    {7, "RasAutodialAddressToNetwork"},
    {8, "RasAutodialEntryToNetwork"},
    {9, "RasClearConnectionStatistics"},
    {10, "RasClearLinkStatistics"},
    {11, "RasConnectionNotificationA"},
    {12, "RasConnectionNotificationW"},
    {13, "RasCreatePhonebookEntryA"},
    {14, "RasCreatePhonebookEntryW"},
    {15, "RasDeleteEntryA"},
    {16, "RasDeleteEntryW"},
    {17, "RasDeleteSubEntryA"},
    {18, "RasDeleteSubEntryW"},
    {19, "RasDialA"},
    {20, "RasDialW"},
    {21, "RasEditPhonebookEntryA"},
    {22, "RasEditPhonebookEntryW"},
    {23, "RasEnumAutodialAddressesA"},
    {24, "RasEnumAutodialAddressesW"},
    {25, "RasEnumConnectionsA"},
    {26, "RasEnumConnectionsW"},
    {27, "RasEnumDevicesA"},
    {28, "RasEnumDevicesW"},
    {29, "RasEnumEntriesA"},
    {30, "RasEnumEntriesW"},
    {31, "RasFreeEapUserIdentityA"},
    {32, "RasFreeEapUserIdentityW"},
    {33, "RasGetAutodialAddressA"},
    {34, "RasGetAutodialAddressW"},
    {35, "RasGetAutodialEnableA"},
    {36, "RasGetAutodialEnableW"},
    {37, "RasGetAutodialParamA"},
    {38, "RasGetAutodialParamW"},
    {39, "RasGetConnectStatusA"},
    {40, "RasGetConnectStatusW"},
    {41, "RasGetConnectionStatistics"},
    {42, "RasGetCountryInfoA"},
    {43, "RasGetCountryInfoW"},
    {44, "RasGetCredentialsA"},
    {45, "RasGetCredentialsW"},
    {46, "RasGetCustomAuthDataA"},
    {47, "RasGetCustomAuthDataW"},
    {48, "RasGetEapUserDataA"},
    {49, "RasGetEapUserDataW"},
    {50, "RasGetEapUserIdentityA"},
    {51, "RasGetEapUserIdentityW"},
    {52, "RasGetEntryDialParamsA"},
    {53, "RasGetEntryDialParamsW"},
    {54, "RasGetEntryHrasconnW"},
    {55, "RasGetEntryPropertiesA"},
    {56, "RasGetEntryPropertiesW"},
    {57, "RasGetErrorStringA"},
    {58, "RasGetErrorStringW"},
    {59, "RasGetHport"},
    {60, "RasGetLinkStatistics"},
    {61, "RasGetNapStatus"},
    {62, "RasGetProjectionInfoA"},
    {63, "RasGetProjectionInfoEx"},
    {64, "RasGetProjectionInfoW"},
    {65, "RasGetSubEntryHandleA"},
    {66, "RasGetSubEntryHandleW"},
    {67, "RasGetSubEntryPropertiesA"},
    {68, "RasGetSubEntryPropertiesW"},
    {69, "RasHangUpA"},
    {70, "RasHangUpW"},
    {71, "RasInvokeEapUI"},
    {72, "RasIsPublicPhonebook"},
    {73, "RasIsSharedConnection"},
    {74, "RasQueryRedialOnLinkFailure"},
    {75, "RasQuerySharedAutoDial"},
    {76, "RasQuerySharedConnection"},
    {77, "RasRenameEntryA"},
    {78, "RasRenameEntryW"},
    {79, "RasScriptGetIpAddress"},
    {80, "RasScriptInit"},
    {81, "RasScriptReceive"},
    {82, "RasScriptSend"},
    {83, "RasScriptTerm"},
    {84, "RasSetAutodialAddressA"},
    {85, "RasSetAutodialAddressW"},
    {86, "RasSetAutodialEnableA"},
    {87, "RasSetAutodialEnableW"},
    {88, "RasSetAutodialParamA"},
    {89, "RasSetAutodialParamW"},
    {90, "RasSetCredentialsA"},
    {91, "RasSetCredentialsW"},
    {92, "RasSetCustomAuthDataA"},
    {93, "RasSetCustomAuthDataW"},
    {94, "RasSetEapUserDataA"},
    {95, "RasSetEapUserDataW"},
    {96, "RasSetEntryDialParamsA"},
    {97, "RasSetEntryDialParamsW"},
    {98, "RasSetEntryPropertiesA"},
    {99, "RasSetEntryPropertiesW"},
    {100, "RasSetOldPassword"},
    {101, "RasSetSharedAutoDial"},
    {102, "RasSetSubEntryPropertiesA"},
    {103, "RasSetSubEntryPropertiesW"},
    {104, "RasUpdateConnection"},
    {105, "RasValidateEntryNameA"},
    {106, "RasValidateEntryNameW"},
    {107, "RasWriteSharedPbkOptions"},
    {108, "UnInitializeRAS"},
    {0, NULL}};
static Dw32Ordinal rasdlg[] = {
    {2, "DllCanUnloadNow"},
    {3, "DllGetClassObject"},
    {4, "DwTerminalDlg"},
    {5, "GetRasDialOutProtocols"},
    {6, "RasAutodialQueryDlgA"},
    {7, "RasAutodialQueryDlgW"},
    {8, "RasDialDlgA"},
    {9, "RasDialDlgW"},
    {10, "RasEntryDlgA"},
    {11, "RasEntryDlgW"},
    {1, "RasHandleDiagnostics"},
    {12, "RasPhonebookDlgA"},
    {13, "RasPhonebookDlgW"},
    {14, "RasSrvAddPropPages"},
    {15, "RasSrvAllowConnectionsConfig"},
    {16, "RasSrvCleanupService"},
    {17, "RasSrvEnumConnections"},
    {18, "RasSrvHangupConnection"},
    {19, "RasSrvInitializeService"},
    {20, "RasSrvIsConnectionConnected"},
    {21, "RasSrvIsICConfigured"},
    {22, "RasSrvIsServiceRunning"},
    {23, "RasUserEnableManualDial"},
    {24, "RasUserGetManualDial"},
    {25, "RasUserPrefsDlg"},
    {26, "RouterEntryDlgA"},
    {27, "RouterEntryDlgW"},
    {0, NULL}};
static Dw32Ordinal resutils[] = {
    {1, "ClusWorkerCheckTerminate"},
    {2, "ClusWorkerCreate"},
    {3, "ClusWorkerStart"},
    {4, "ClusWorkerTerminate"},
    {5, "ClusterClearBackupStateForSharedVolume"},
    {6, "ClusterGetVolumeNameForVolumeMountPoint"},
    {7, "ClusterGetVolumePathName"},
    {8, "ClusterIsPathOnSharedVolume"},
    {9, "ClusterPrepareSharedVolumeForBackup"},
    {10, "ResUtilAddUnknownProperties"},
    {11, "ResUtilCreateDirectoryTree"},
    {12, "ResUtilDupParameterBlock"},
    {13, "ResUtilDupString"},
    {14, "ResUtilEnumPrivateProperties"},
    {15, "ResUtilEnumProperties"},
    {16, "ResUtilEnumResources"},
    {17, "ResUtilEnumResourcesEx"},
    {18, "ResUtilExpandEnvironmentStrings"},
    {19, "ResUtilFindBinaryProperty"},
    {20, "ResUtilFindDependentDiskResourceDriveLetter"},
    {21, "ResUtilFindDwordProperty"},
    {22, "ResUtilFindExpandSzProperty"},
    {23, "ResUtilFindExpandedSzProperty"},
    {24, "ResUtilFindFileTimeProperty"},
    {25, "ResUtilFindLongProperty"},
    {26, "ResUtilFindMultiSzProperty"},
    {27, "ResUtilFindSzProperty"},
    {28, "ResUtilFreeEnvironment"},
    {29, "ResUtilFreeParameterBlock"},
    {30, "ResUtilGetAllProperties"},
    {31, "ResUtilGetBinaryProperty"},
    {32, "ResUtilGetBinaryValue"},
    {33, "ResUtilGetClusterRoleState"},
    {34, "ResUtilGetCoreClusterResources"},
    {35, "ResUtilGetDwordProperty"},
    {36, "ResUtilGetDwordValue"},
    {37, "ResUtilGetEnvironmentWithNetName"},
    {38, "ResUtilGetFileTimeProperty"},
    {39, "ResUtilGetLongProperty"},
    {40, "ResUtilGetMultiSzProperty"},
    {41, "ResUtilGetPrivateProperties"},
    {42, "ResUtilGetProperties"},
    {43, "ResUtilGetPropertiesToParameterBlock"},
    {44, "ResUtilGetProperty"},
    {45, "ResUtilGetPropertyFormats"},
    {46, "ResUtilGetPropertySize"},
    {47, "ResUtilGetQwordValue"},
    {48, "ResUtilGetResourceDependency"},
    {49, "ResUtilGetResourceDependencyByClass"},
    {50, "ResUtilGetResourceDependencyByName"},
    {51, "ResUtilGetResourceDependentIPAddressProps"},
    {52, "ResUtilGetResourceName"},
    {53, "ResUtilGetResourceNameDependency"},
    {54, "ResUtilGetSzProperty"},
    {55, "ResUtilGetSzValue"},
    {56, "ResUtilIsPathValid"},
    {57, "ResUtilIsResourceClassEqual"},
    {58, "ResUtilPropertyListFromParameterBlock"},
    {59, "ResUtilRemoveResourceServiceEnvironment"},
    {60, "ResUtilResourceTypesEqual"},
    {61, "ResUtilResourcesEqual"},
    {62, "ResUtilSetBinaryValue"},
    {63, "ResUtilSetDwordValue"},
    {64, "ResUtilSetExpandSzValue"},
    {65, "ResUtilSetMultiSzValue"},
    {66, "ResUtilSetPrivatePropertyList"},
    {67, "ResUtilSetPropertyParameterBlock"},
    {68, "ResUtilSetPropertyParameterBlockEx"},
    {69, "ResUtilSetPropertyTable"},
    {70, "ResUtilSetPropertyTableEx"},
    {71, "ResUtilSetQwordValue"},
    {72, "ResUtilSetResourceServiceEnvironment"},
    {73, "ResUtilSetResourceServiceStartParameters"},
    {74, "ResUtilSetSzValue"},
    {75, "ResUtilSetUnknownProperties"},
    {76, "ResUtilStartResourceService"},
    {77, "ResUtilStopResourceService"},
    {78, "ResUtilStopService"},
    {79, "ResUtilTerminateServiceProcessFromResDll"},
    {80, "ResUtilVerifyPrivatePropertyList"},
    {81, "ResUtilVerifyPropertyTable"},
    {82, "ResUtilVerifyResourceService"},
    {83, "ResUtilVerifyService"},
    {0, NULL}};
static Dw32Ordinal riched20[] = {
    {4, "CreateTextServices"},
    {2, "IID_IRichEditOle"},
    {3, "IID_IRichEditOleCallback"},
    {6, "IID_ITextHost"},
    {7, "IID_ITextHost2"},
    {5, "IID_ITextServices"},
    {8, "REExtendedRegisterClass"},
    {9, "RichEdit10ANSIWndProc"},
    {10, "RichEditANSIWndProc"},
    {0, NULL}};
static Dw32Ordinal rpcns4[] = {
    {1, "I_RpcNsGetBuffer"},
    {2, "I_RpcNsNegotiateTransferSyntax"},
    {3, "I_RpcNsRaiseException"},
    {4, "I_RpcNsSendReceive"},
    {5, "I_RpcReBindBuffer"},
    {6, "RpcIfIdVectorFree"},
    {7, "RpcNsBindingExportA"},
    {8, "RpcNsBindingExportPnPA"},
    {9, "RpcNsBindingExportPnPW"},
    {10, "RpcNsBindingExportW"},
    {11, "RpcNsBindingImportBeginA"},
    {12, "RpcNsBindingImportBeginW"},
    {13, "RpcNsBindingImportDone"},
    {14, "RpcNsBindingImportNext"},
    {15, "RpcNsBindingLookupBeginA"},
    {16, "RpcNsBindingLookupBeginW"},
    {17, "RpcNsBindingLookupDone"},
    {18, "RpcNsBindingLookupNext"},
    {19, "RpcNsBindingSelect"},
    {20, "RpcNsBindingUnexportA"},
    {21, "RpcNsBindingUnexportPnPA"},
    {22, "RpcNsBindingUnexportPnPW"},
    {23, "RpcNsBindingUnexportW"},
    {24, "RpcNsEntryExpandNameA"},
    {25, "RpcNsEntryExpandNameW"},
    {26, "RpcNsEntryObjectInqBeginA"},
    {27, "RpcNsEntryObjectInqBeginW"},
    {28, "RpcNsEntryObjectInqDone"},
    {29, "RpcNsEntryObjectInqNext"},
    {30, "RpcNsGroupDeleteA"},
    {31, "RpcNsGroupDeleteW"},
    {32, "RpcNsGroupMbrAddA"},
    {33, "RpcNsGroupMbrAddW"},
    {34, "RpcNsGroupMbrInqBeginA"},
    {35, "RpcNsGroupMbrInqBeginW"},
    {36, "RpcNsGroupMbrInqDone"},
    {37, "RpcNsGroupMbrInqNextA"},
    {38, "RpcNsGroupMbrInqNextW"},
    {39, "RpcNsGroupMbrRemoveA"},
    {40, "RpcNsGroupMbrRemoveW"},
    {41, "RpcNsMgmtBindingUnexportA"},
    {42, "RpcNsMgmtBindingUnexportW"},
    {43, "RpcNsMgmtEntryCreateA"},
    {44, "RpcNsMgmtEntryCreateW"},
    {45, "RpcNsMgmtEntryDeleteA"},
    {46, "RpcNsMgmtEntryDeleteW"},
    {47, "RpcNsMgmtEntryInqIfIdsA"},
    {48, "RpcNsMgmtEntryInqIfIdsW"},
    {49, "RpcNsMgmtHandleSetExpAge"},
    {50, "RpcNsMgmtInqExpAge"},
    {51, "RpcNsMgmtSetExpAge"},
    {52, "RpcNsProfileDeleteA"},
    {53, "RpcNsProfileDeleteW"},
    {54, "RpcNsProfileEltAddA"},
    {55, "RpcNsProfileEltAddW"},
    {56, "RpcNsProfileEltInqBeginA"},
    {57, "RpcNsProfileEltInqBeginW"},
    {58, "RpcNsProfileEltInqDone"},
    {59, "RpcNsProfileEltInqNextA"},
    {60, "RpcNsProfileEltInqNextW"},
    {61, "RpcNsProfileEltRemoveA"},
    {62, "RpcNsProfileEltRemoveW"},
    {0, NULL}};
static Dw32Ordinal rpcrt4[] = {
    {21, "CStdStubBuffer_AddRef"},
    {22, "CStdStubBuffer_Connect"},
    {23, "CStdStubBuffer_CountRefs"},
    {24, "CStdStubBuffer_DebugServerQueryInterface"},
    {25, "CStdStubBuffer_DebugServerRelease"},
    {26, "CStdStubBuffer_Disconnect"},
    {27, "CStdStubBuffer_Invoke"},
    {28, "CStdStubBuffer_IsIIDSupported"},
    {29, "CStdStubBuffer_QueryInterface"},
    {30, "CreateProxyFromTypeInfo"},
    {31, "CreateStubFromTypeInfo"},
    {32, "DceErrorInqTextA"},
    {33, "DceErrorInqTextW"},
    {34, "DllGetClassObject"},
    {35, "DllRegisterServer"},
    {36, "IUnknown_AddRef_Proxy"},
    {37, "IUnknown_QueryInterface_Proxy"},
    {38, "IUnknown_Release_Proxy"},
    {39, "I_RpcAllocate"},
    {40, "I_RpcAsyncAbortCall"},
    {41, "I_RpcAsyncSetHandle"},
    {42, "I_RpcBCacheAllocate"},
    {43, "I_RpcBCacheFree"},
    {44, "I_RpcBindingCopy"},
    {45, "I_RpcBindingCreateNP"},
    {46, "I_RpcBindingHandleToAsyncHandle"},
    {1, "I_RpcBindingInqCurrentModifiedId"},
    {47, "I_RpcBindingInqDynamicEndpoint"},
    {48, "I_RpcBindingInqDynamicEndpointA"},
    {49, "I_RpcBindingInqDynamicEndpointW"},
    {50, "I_RpcBindingInqLocalClientPID"},
    {51, "I_RpcBindingInqMarshalledTargetInfo"},
    {52, "I_RpcBindingInqSecurityContext"},
    {53, "I_RpcBindingInqSecurityContextKeyInfo"},
    {54, "I_RpcBindingInqTransportType"},
    {55, "I_RpcBindingInqWireIdForSnego"},
    {56, "I_RpcBindingIsClientLocal"},
    {57, "I_RpcBindingToStaticStringBindingW"},
    {58, "I_RpcCertProcessAndProvision"},
    {59, "I_RpcClearMutex"},
    {60, "I_RpcCompleteAndFree"},
    {61, "I_RpcConnectionInqSockBuffSize"},
    {62, "I_RpcConnectionSetSockBuffSize"},
    {63, "I_RpcDeleteMutex"},
    {64, "I_RpcEnableWmiTrace"},
    {65, "I_RpcExceptionFilter"},
    {66, "I_RpcFilterDCOMActivation"},
    {67, "I_RpcFree"},
    {68, "I_RpcFreeBuffer"},
    {69, "I_RpcFreePipeBuffer"},
    {2, "I_RpcFwThisIsTheManager"},
    {70, "I_RpcGetBuffer"},
    {71, "I_RpcGetBufferWithObject"},
    {72, "I_RpcGetCurrentCallHandle"},
    {73, "I_RpcGetExtendedError"},
    {74, "I_RpcGetPortAllocationData"},
    {75, "I_RpcIfInqTransferSyntaxes"},
    {3, "I_RpcInitFwImports"},
    {4, "I_RpcInitHttpImports"},
    {5, "I_RpcInitImports"},
    {6, "I_RpcInitNdrImports"},
    {76, "I_RpcLogEvent"},
    {77, "I_RpcMapWin32Status"},
    {78, "I_RpcMarshalBindingHandleAndInterfaceForNDF"},
    {79, "I_RpcMgmtEnableDedicatedThreadPool"},
    {7, "I_RpcMgmtQueryDedicatedThreadPool"},
    {80, "I_RpcNDRCGetWireRepresentation"},
    {81, "I_RpcNDRSContextEmergencyCleanup"},
    {82, "I_RpcNegotiateTransferSyntax"},
    {83, "I_RpcNsBindingSetEntryName"},
    {84, "I_RpcNsBindingSetEntryNameA"},
    {85, "I_RpcNsBindingSetEntryNameW"},
    {86, "I_RpcNsInterfaceExported"},
    {87, "I_RpcNsInterfaceUnexported"},
    {8, "I_RpcOpenClientProcess"},
    {9, "I_RpcOpenClientThread"},
    {88, "I_RpcParseSecurity"},
    {89, "I_RpcPauseExecution"},
    {90, "I_RpcReallocPipeBuffer"},
    {91, "I_RpcReceive"},
    {92, "I_RpcRecordCalloutFailure"},
    {93, "I_RpcRequestMutex"},
    {94, "I_RpcSNCHOption"},
    {95, "I_RpcSend"},
    {96, "I_RpcSendReceive"},
    {97, "I_RpcServerAllocateIpPort"},
    {98, "I_RpcServerCheckClientRestriction"},
    {99, "I_RpcServerInqAddressChangeFn"},
    {100, "I_RpcServerInqLocalConnAddress"},
    {101, "I_RpcServerInqRemoteConnAddress"},
    {102, "I_RpcServerInqTransportType"},
    {103, "I_RpcServerIsClientDisconnected"},
    {104, "I_RpcServerRegisterForwardFunction"},
    {105, "I_RpcServerSetAddressChangeFn"},
    {106, "I_RpcServerStartService"},
    {10, "I_RpcServerTurnOnOffKeepalives"},
    {107, "I_RpcServerUseProtseq2A"},
    {108, "I_RpcServerUseProtseq2W"},
    {109, "I_RpcServerUseProtseqEp2A"},
    {110, "I_RpcServerUseProtseqEp2W"},
    {111, "I_RpcSessionStrictContextHandle"},
    {112, "I_RpcSetDCOMAppId"},
    {113, "I_RpcSsDontSerializeContext"},
    {114, "I_RpcSystemFunction001"},
    {115, "I_RpcTransConnectionAllocatePacket"},
    {116, "I_RpcTransConnectionFreePacket"},
    {117, "I_RpcTransConnectionReallocPacket"},
    {119, "I_RpcTransDatagramAllocate"},
    {118, "I_RpcTransDatagramAllocate2"},
    {120, "I_RpcTransDatagramFree"},
    {121, "I_RpcTransGetThreadEvent"},
    {122, "I_RpcTransGetThreadEventThreadOptional"},
    {123, "I_RpcTransIoCancelled"},
    {124, "I_RpcTransServerNewConnection"},
    {125, "I_RpcTurnOnEEInfoPropagation"},
    {11, "I_RpcVerifierCorruptionExpected"},
    {126, "I_UuidCreate"},
    {127, "MIDL_wchar_strcpy"},
    {128, "MIDL_wchar_strlen"},
    {129, "MesBufferHandleReset"},
    {130, "MesDecodeBufferHandleCreate"},
    {131, "MesDecodeIncrementalHandleCreate"},
    {132, "MesEncodeDynBufferHandleCreate"},
    {133, "MesEncodeFixedBufferHandleCreate"},
    {134, "MesEncodeIncrementalHandleCreate"},
    {135, "MesHandleFree"},
    {136, "MesIncrementalHandleReset"},
    {137, "MesInqProcEncodingId"},
    {138, "NDRCContextBinding"},
    {139, "NDRCContextMarshall"},
    {140, "NDRCContextUnmarshall"},
    {142, "NDRSContextMarshall"},
    {141, "NDRSContextMarshall2"},
    {143, "NDRSContextMarshallEx"},
    {145, "NDRSContextUnmarshall"},
    {144, "NDRSContextUnmarshall2"},
    {146, "NDRSContextUnmarshallEx"},
    {147, "NDRcopy"},
    {148, "NdrAllocate"},
    {149, "NdrAsyncClientCall"},
    {150, "NdrAsyncServerCall"},
    {151, "NdrByteCountPointerBufferSize"},
    {152, "NdrByteCountPointerFree"},
    {153, "NdrByteCountPointerMarshall"},
    {154, "NdrByteCountPointerUnmarshall"},
    {155, "NdrCStdStubBuffer2_Release"},
    {156, "NdrCStdStubBuffer_Release"},
    {157, "NdrClearOutParameters"},
    {158, "NdrClientCall"},
    {159, "NdrClientCall2"},
    {160, "NdrClientContextMarshall"},
    {161, "NdrClientContextUnmarshall"},
    {162, "NdrClientInitialize"},
    {163, "NdrClientInitializeNew"},
    {164, "NdrComplexArrayBufferSize"},
    {165, "NdrComplexArrayFree"},
    {166, "NdrComplexArrayMarshall"},
    {167, "NdrComplexArrayMemorySize"},
    {168, "NdrComplexArrayUnmarshall"},
    {169, "NdrComplexStructBufferSize"},
    {170, "NdrComplexStructFree"},
    {171, "NdrComplexStructMarshall"},
    {172, "NdrComplexStructMemorySize"},
    {173, "NdrComplexStructUnmarshall"},
    {174, "NdrConformantArrayBufferSize"},
    {175, "NdrConformantArrayFree"},
    {176, "NdrConformantArrayMarshall"},
    {177, "NdrConformantArrayMemorySize"},
    {178, "NdrConformantArrayUnmarshall"},
    {179, "NdrConformantStringBufferSize"},
    {180, "NdrConformantStringMarshall"},
    {181, "NdrConformantStringMemorySize"},
    {182, "NdrConformantStringUnmarshall"},
    {183, "NdrConformantStructBufferSize"},
    {184, "NdrConformantStructFree"},
    {185, "NdrConformantStructMarshall"},
    {186, "NdrConformantStructMemorySize"},
    {187, "NdrConformantStructUnmarshall"},
    {188, "NdrConformantVaryingArrayBufferSize"},
    {189, "NdrConformantVaryingArrayFree"},
    {190, "NdrConformantVaryingArrayMarshall"},
    {191, "NdrConformantVaryingArrayMemorySize"},
    {192, "NdrConformantVaryingArrayUnmarshall"},
    {193, "NdrConformantVaryingStructBufferSize"},
    {194, "NdrConformantVaryingStructFree"},
    {195, "NdrConformantVaryingStructMarshall"},
    {196, "NdrConformantVaryingStructMemorySize"},
    {197, "NdrConformantVaryingStructUnmarshall"},
    {198, "NdrContextHandleInitialize"},
    {199, "NdrContextHandleSize"},
    {201, "NdrConvert"},
    {200, "NdrConvert2"},
    {202, "NdrCorrelationFree"},
    {203, "NdrCorrelationInitialize"},
    {204, "NdrCorrelationPass"},
    {205, "NdrCreateServerInterfaceFromStub"},
    {206, "NdrDcomAsyncClientCall"},
    {207, "NdrDcomAsyncStubCall"},
    {208, "NdrDllCanUnloadNow"},
    {209, "NdrDllGetClassObject"},
    {210, "NdrDllRegisterProxy"},
    {211, "NdrDllUnregisterProxy"},
    {212, "NdrEncapsulatedUnionBufferSize"},
    {213, "NdrEncapsulatedUnionFree"},
    {214, "NdrEncapsulatedUnionMarshall"},
    {215, "NdrEncapsulatedUnionMemorySize"},
    {216, "NdrEncapsulatedUnionUnmarshall"},
    {217, "NdrFixedArrayBufferSize"},
    {218, "NdrFixedArrayFree"},
    {219, "NdrFixedArrayMarshall"},
    {220, "NdrFixedArrayMemorySize"},
    {221, "NdrFixedArrayUnmarshall"},
    {222, "NdrFreeBuffer"},
    {12, "NdrFullPointerFree"},
    {13, "NdrFullPointerInsertRefId"},
    {14, "NdrFullPointerQueryPointer"},
    {15, "NdrFullPointerQueryRefId"},
    {223, "NdrFullPointerXlatFree"},
    {224, "NdrFullPointerXlatInit"},
    {225, "NdrGetBaseInterfaceFromStub"},
    {226, "NdrGetBuffer"},
    {227, "NdrGetDcomProtocolVersion"},
    {228, "NdrGetSimpleTypeBufferAlignment"},
    {229, "NdrGetSimpleTypeBufferSize"},
    {230, "NdrGetSimpleTypeMemorySize"},
    {231, "NdrGetTypeFlags"},
    {232, "NdrGetUserMarshalInfo"},
    {233, "NdrInterfacePointerBufferSize"},
    {234, "NdrInterfacePointerFree"},
    {235, "NdrInterfacePointerMarshall"},
    {236, "NdrInterfacePointerMemorySize"},
    {237, "NdrInterfacePointerUnmarshall"},
    {238, "NdrMapCommAndFaultStatus"},
    {239, "NdrMesProcEncodeDecode"},
    {240, "NdrMesProcEncodeDecode2"},
    {241, "NdrMesSimpleTypeAlignSize"},
    {242, "NdrMesSimpleTypeDecode"},
    {243, "NdrMesSimpleTypeEncode"},
    {245, "NdrMesTypeAlignSize"},
    {244, "NdrMesTypeAlignSize2"},
    {247, "NdrMesTypeDecode"},
    {246, "NdrMesTypeDecode2"},
    {249, "NdrMesTypeEncode"},
    {248, "NdrMesTypeEncode2"},
    {250, "NdrMesTypeFree2"},
    {251, "NdrNonConformantStringBufferSize"},
    {252, "NdrNonConformantStringMarshall"},
    {253, "NdrNonConformantStringMemorySize"},
    {254, "NdrNonConformantStringUnmarshall"},
    {255, "NdrNonEncapsulatedUnionBufferSize"},
    {256, "NdrNonEncapsulatedUnionFree"},
    {257, "NdrNonEncapsulatedUnionMarshall"},
    {258, "NdrNonEncapsulatedUnionMemorySize"},
    {259, "NdrNonEncapsulatedUnionUnmarshall"},
    {260, "NdrNsGetBuffer"},
    {261, "NdrNsSendReceive"},
    {262, "NdrOleAllocate"},
    {263, "NdrOleFree"},
    {264, "NdrOutInit"},
    {265, "NdrPartialIgnoreClientBufferSize"},
    {266, "NdrPartialIgnoreClientMarshall"},
    {267, "NdrPartialIgnoreServerInitialize"},
    {268, "NdrPartialIgnoreServerUnmarshall"},
    {269, "NdrPointerBufferSize"},
    {270, "NdrPointerFree"},
    {271, "NdrPointerMarshall"},
    {272, "NdrPointerMemorySize"},
    {273, "NdrPointerUnmarshall"},
    {274, "NdrProxyErrorHandler"},
    {275, "NdrProxyFreeBuffer"},
    {276, "NdrProxyGetBuffer"},
    {277, "NdrProxyInitialize"},
    {278, "NdrProxySendReceive"},
    {279, "NdrRangeUnmarshall"},
    {280, "NdrRpcSmClientAllocate"},
    {281, "NdrRpcSmClientFree"},
    {282, "NdrRpcSmSetClientToOsf"},
    {283, "NdrRpcSsDefaultAllocate"},
    {284, "NdrRpcSsDefaultFree"},
    {285, "NdrRpcSsDisableAllocate"},
    {286, "NdrRpcSsEnableAllocate"},
    {287, "NdrSendReceive"},
    {289, "NdrServerCall"},
    {288, "NdrServerCall2"},
    {290, "NdrServerContextMarshall"},
    {291, "NdrServerContextNewMarshall"},
    {292, "NdrServerContextNewUnmarshall"},
    {293, "NdrServerContextUnmarshall"},
    {294, "NdrServerInitialize"},
    {295, "NdrServerInitializeMarshall"},
    {296, "NdrServerInitializeNew"},
    {297, "NdrServerInitializePartial"},
    {298, "NdrServerInitializeUnmarshall"},
    {299, "NdrServerMarshall"},
    {300, "NdrServerUnmarshall"},
    {301, "NdrSimpleStructBufferSize"},
    {302, "NdrSimpleStructFree"},
    {303, "NdrSimpleStructMarshall"},
    {304, "NdrSimpleStructMemorySize"},
    {305, "NdrSimpleStructUnmarshall"},
    {306, "NdrSimpleTypeMarshall"},
    {307, "NdrSimpleTypeUnmarshall"},
    {309, "NdrStubCall"},
    {308, "NdrStubCall2"},
    {310, "NdrStubForwardingFunction"},
    {311, "NdrStubGetBuffer"},
    {312, "NdrStubInitialize"},
    {313, "NdrStubInitializeMarshall"},
    {314, "NdrTypeFlags"},
    {315, "NdrTypeFree"},
    {316, "NdrTypeMarshall"},
    {317, "NdrTypeSize"},
    {318, "NdrTypeUnmarshall"},
    {319, "NdrUnmarshallBasetypeInline"},
    {320, "NdrUserMarshalBufferSize"},
    {321, "NdrUserMarshalFree"},
    {322, "NdrUserMarshalMarshall"},
    {323, "NdrUserMarshalMemorySize"},
    {324, "NdrUserMarshalSimpleTypeConvert"},
    {325, "NdrUserMarshalUnmarshall"},
    {326, "NdrVaryingArrayBufferSize"},
    {327, "NdrVaryingArrayFree"},
    {328, "NdrVaryingArrayMarshall"},
    {329, "NdrVaryingArrayMemorySize"},
    {330, "NdrVaryingArrayUnmarshall"},
    {331, "NdrXmitOrRepAsBufferSize"},
    {332, "NdrXmitOrRepAsFree"},
    {333, "NdrXmitOrRepAsMarshall"},
    {334, "NdrXmitOrRepAsMemorySize"},
    {335, "NdrXmitOrRepAsUnmarshall"},
    {336, "NdrpCreateProxy"},
    {337, "NdrpCreateStub"},
    {338, "NdrpGetProcFormatString"},
    {339, "NdrpGetTypeFormatString"},
    {340, "NdrpGetTypeGenCookie"},
    {341, "NdrpMemoryIncrement"},
    {342, "NdrpReleaseTypeFormatString"},
    {343, "NdrpReleaseTypeGenCookie"},
    {344, "NdrpVarVtOfTypeDesc"},
    {345, "RpcAsyncAbortCall"},
    {346, "RpcAsyncCancelCall"},
    {347, "RpcAsyncCompleteCall"},
    {348, "RpcAsyncGetCallStatus"},
    {349, "RpcAsyncInitializeHandle"},
    {350, "RpcAsyncRegisterInfo"},
    {351, "RpcBindingBind"},
    {352, "RpcBindingCopy"},
    {353, "RpcBindingCreateA"},
    {354, "RpcBindingCreateW"},
    {355, "RpcBindingFree"},
    {356, "RpcBindingFromStringBindingA"},
    {357, "RpcBindingFromStringBindingW"},
    {358, "RpcBindingInqAuthClientA"},
    {359, "RpcBindingInqAuthClientExA"},
    {360, "RpcBindingInqAuthClientExW"},
    {361, "RpcBindingInqAuthClientW"},
    {362, "RpcBindingInqAuthInfoA"},
    {363, "RpcBindingInqAuthInfoExA"},
    {364, "RpcBindingInqAuthInfoExW"},
    {365, "RpcBindingInqAuthInfoW"},
    {366, "RpcBindingInqObject"},
    {367, "RpcBindingInqOption"},
    {368, "RpcBindingReset"},
    {369, "RpcBindingServerFromClient"},
    {370, "RpcBindingSetAuthInfoA"},
    {371, "RpcBindingSetAuthInfoExA"},
    {372, "RpcBindingSetAuthInfoExW"},
    {373, "RpcBindingSetAuthInfoW"},
    {374, "RpcBindingSetObject"},
    {375, "RpcBindingSetOption"},
    {376, "RpcBindingToStringBindingA"},
    {377, "RpcBindingToStringBindingW"},
    {378, "RpcBindingUnbind"},
    {379, "RpcBindingVectorFree"},
    {380, "RpcCancelThread"},
    {381, "RpcCancelThreadEx"},
    {382, "RpcCertGeneratePrincipalNameA"},
    {383, "RpcCertGeneratePrincipalNameW"},
    {16, "RpcCertMatchPrincipalName"},
    {384, "RpcEpRegisterA"},
    {385, "RpcEpRegisterNoReplaceA"},
    {386, "RpcEpRegisterNoReplaceW"},
    {387, "RpcEpRegisterW"},
    {388, "RpcEpResolveBinding"},
    {389, "RpcEpUnregister"},
    {390, "RpcErrorAddRecord"},
    {391, "RpcErrorClearInformation"},
    {392, "RpcErrorEndEnumeration"},
    {393, "RpcErrorGetNextRecord"},
    {394, "RpcErrorGetNumberOfRecords"},
    {395, "RpcErrorLoadErrorInfo"},
    {396, "RpcErrorResetEnumeration"},
    {397, "RpcErrorSaveErrorInfo"},
    {398, "RpcErrorStartEnumeration"},
    {399, "RpcExceptionFilter"},
    {400, "RpcFreeAuthorizationContext"},
    {401, "RpcGetAuthorizationContextForClient"},
    {402, "RpcIfIdVectorFree"},
    {403, "RpcIfInqId"},
    {404, "RpcImpersonateClient"},
    {405, "RpcMgmtEnableIdleCleanup"},
    {406, "RpcMgmtEpEltInqBegin"},
    {407, "RpcMgmtEpEltInqDone"},
    {408, "RpcMgmtEpEltInqNextA"},
    {409, "RpcMgmtEpEltInqNextW"},
    {410, "RpcMgmtEpUnregister"},
    {411, "RpcMgmtInqComTimeout"},
    {412, "RpcMgmtInqDefaultProtectLevel"},
    {413, "RpcMgmtInqIfIds"},
    {414, "RpcMgmtInqServerPrincNameA"},
    {415, "RpcMgmtInqServerPrincNameW"},
    {416, "RpcMgmtInqStats"},
    {417, "RpcMgmtIsServerListening"},
    {418, "RpcMgmtSetAuthorizationFn"},
    {419, "RpcMgmtSetCancelTimeout"},
    {420, "RpcMgmtSetComTimeout"},
    {421, "RpcMgmtSetServerStackSize"},
    {422, "RpcMgmtStatsVectorFree"},
    {423, "RpcMgmtStopServerListening"},
    {424, "RpcMgmtWaitServerListen"},
    {425, "RpcNetworkInqProtseqsA"},
    {426, "RpcNetworkInqProtseqsW"},
    {427, "RpcNetworkIsProtseqValidA"},
    {428, "RpcNetworkIsProtseqValidW"},
    {429, "RpcNsBindingInqEntryNameA"},
    {430, "RpcNsBindingInqEntryNameW"},
    {431, "RpcObjectInqType"},
    {432, "RpcObjectSetInqFn"},
    {433, "RpcObjectSetType"},
    {434, "RpcProtseqVectorFreeA"},
    {435, "RpcProtseqVectorFreeW"},
    {436, "RpcRaiseException"},
    {437, "RpcRevertToSelf"},
    {438, "RpcRevertToSelfEx"},
    {439, "RpcServerCompleteSecurityCallback"},
    {440, "RpcServerInqBindingHandle"},
    {441, "RpcServerInqBindings"},
    {442, "RpcServerInqCallAttributesA"},
    {443, "RpcServerInqCallAttributesW"},
    {444, "RpcServerInqDefaultPrincNameA"},
    {445, "RpcServerInqDefaultPrincNameW"},
    {446, "RpcServerInqIf"},
    {447, "RpcServerListen"},
    {448, "RpcServerRegisterAuthInfoA"},
    {449, "RpcServerRegisterAuthInfoW"},
    {451, "RpcServerRegisterIf"},
    {450, "RpcServerRegisterIf2"},
    {452, "RpcServerRegisterIfEx"},
    {453, "RpcServerSubscribeForNotification"},
    {454, "RpcServerTestCancel"},
    {455, "RpcServerUnregisterIf"},
    {456, "RpcServerUnregisterIfEx"},
    {457, "RpcServerUnsubscribeForNotification"},
    {458, "RpcServerUseAllProtseqs"},
    {459, "RpcServerUseAllProtseqsEx"},
    {460, "RpcServerUseAllProtseqsIf"},
    {461, "RpcServerUseAllProtseqsIfEx"},
    {462, "RpcServerUseProtseqA"},
    {463, "RpcServerUseProtseqEpA"},
    {464, "RpcServerUseProtseqEpExA"},
    {465, "RpcServerUseProtseqEpExW"},
    {466, "RpcServerUseProtseqEpW"},
    {467, "RpcServerUseProtseqExA"},
    {468, "RpcServerUseProtseqExW"},
    {469, "RpcServerUseProtseqIfA"},
    {470, "RpcServerUseProtseqIfExA"},
    {471, "RpcServerUseProtseqIfExW"},
    {472, "RpcServerUseProtseqIfW"},
    {473, "RpcServerUseProtseqW"},
    {474, "RpcServerYield"},
    {475, "RpcSmAllocate"},
    {476, "RpcSmClientFree"},
    {477, "RpcSmDestroyClientContext"},
    {478, "RpcSmDisableAllocate"},
    {479, "RpcSmEnableAllocate"},
    {480, "RpcSmFree"},
    {481, "RpcSmGetThreadHandle"},
    {482, "RpcSmSetClientAllocFree"},
    {483, "RpcSmSetThreadHandle"},
    {484, "RpcSmSwapClientAllocFree"},
    {485, "RpcSsAllocate"},
    {486, "RpcSsContextLockExclusive"},
    {487, "RpcSsContextLockShared"},
    {488, "RpcSsDestroyClientContext"},
    {489, "RpcSsDisableAllocate"},
    {490, "RpcSsDontSerializeContext"},
    {491, "RpcSsEnableAllocate"},
    {492, "RpcSsFree"},
    {493, "RpcSsGetContextBinding"},
    {494, "RpcSsGetThreadHandle"},
    {495, "RpcSsSetClientAllocFree"},
    {496, "RpcSsSetThreadHandle"},
    {497, "RpcSsSwapClientAllocFree"},
    {498, "RpcStringBindingComposeA"},
    {499, "RpcStringBindingComposeW"},
    {500, "RpcStringBindingParseA"},
    {501, "RpcStringBindingParseW"},
    {502, "RpcStringFreeA"},
    {503, "RpcStringFreeW"},
    {504, "RpcTestCancel"},
    {505, "RpcUserFree"},
    {506, "SimpleTypeAlignment"},
    {507, "SimpleTypeBufferSize"},
    {508, "SimpleTypeMemorySize"},
    {509, "TowerConstruct"},
    {510, "TowerExplode"},
    {511, "UuidCompare"},
    {512, "UuidCreate"},
    {513, "UuidCreateNil"},
    {514, "UuidCreateSequential"},
    {515, "UuidEqual"},
    {516, "UuidFromStringA"},
    {517, "UuidFromStringW"},
    {518, "UuidHash"},
    {519, "UuidIsNil"},
    {520, "UuidToStringA"},
    {521, "UuidToStringW"},
    {522, "char_array_from_ndr"},
    {523, "char_from_ndr"},
    {524, "data_from_ndr"},
    {525, "data_into_ndr"},
    {526, "data_size_ndr"},
    {527, "double_array_from_ndr"},
    {528, "double_from_ndr"},
    {529, "enum_from_ndr"},
    {530, "float_array_from_ndr"},
    {531, "float_from_ndr"},
    {532, "long_array_from_ndr"},
    {533, "long_from_ndr"},
    {534, "long_from_ndr_temp"},
    {17, "pfnFreeRoutines"},
    {18, "pfnMarshallRoutines"},
    {19, "pfnSizeRoutines"},
    {20, "pfnUnmarshallRoutines"},
    {535, "short_array_from_ndr"},
    {536, "short_from_ndr"},
    {537, "short_from_ndr_temp"},
    {538, "tree_into_ndr"},
    {539, "tree_peek_ndr"},
    {540, "tree_size_ndr"},
    {0, NULL}};
static Dw32Ordinal rstrtmgr[] = {
    {1, "RmAddFilter"},
    {2, "RmCancelCurrentTask"},
    {3, "RmEndSession"},
    {4, "RmGetFilterList"},
    {5, "RmGetList"},
    {6, "RmJoinSession"},
    {7, "RmRegisterResources"},
    {8, "RmRemoveFilter"},
    {9, "RmReserveHeap"},
    {10, "RmRestart"},
    {11, "RmShutdown"},
    {12, "RmStartSession"},
    {0, NULL}};
static Dw32Ordinal rtm[] = {
    {1, "BestMatchInTable"},
    {2, "CheckTable"},
    {3, "CreateTable"},
    {4, "DeleteFromTable"},
    {5, "DestroyTable"},
    {6, "DumpTable"},
    {7, "EnumOverTable"},
    {8, "InsertIntoTable"},
    {9, "MgmAddGroupMembershipEntry"},
    {10, "MgmDeInitialize"},
    {11, "MgmDeRegisterMProtocol"},
    {12, "MgmDeleteGroupMembershipEntry"},
    {13, "MgmGetFirstMfe"},
    {14, "MgmGetFirstMfeStats"},
    {15, "MgmGetMfe"},
    {16, "MgmGetMfeStats"},
    {17, "MgmGetNextMfe"},
    {18, "MgmGetNextMfeStats"},
    {19, "MgmGetProtocolOnInterface"},
    {20, "MgmGroupEnumerationEnd"},
    {21, "MgmGroupEnumerationGetNext"},
    {22, "MgmGroupEnumerationStart"},
    {23, "MgmInitialize"},
    {24, "MgmRegisterMProtocol"},
    {25, "MgmReleaseInterfaceOwnership"},
    {26, "MgmTakeInterfaceOwnership"},
    {27, "NextMatchInTable"},
    {28, "RtmAddNextHop"},
    {29, "RtmAddRoute"},
    {30, "RtmAddRouteToDest"},
    {31, "RtmBlockConvertRoutesToStatic"},
    {32, "RtmBlockDeleteRoutes"},
    {33, "RtmBlockMethods"},
    {34, "RtmBlockSetRouteEnable"},
    {35, "RtmCloseEnumerationHandle"},
    {36, "RtmConvertIpv6AddressAndLengthToNetAddress"},
    {37, "RtmConvertNetAddressToIpv6AddressAndLength"},
    {38, "RtmCreateDestEnum"},
    {39, "RtmCreateEnumerationHandle"},
    {40, "RtmCreateNextHopEnum"},
    {41, "RtmCreateRouteEnum"},
    {42, "RtmCreateRouteList"},
    {43, "RtmCreateRouteListEnum"},
    {44, "RtmDeleteEnumHandle"},
    {45, "RtmDeleteNextHop"},
    {46, "RtmDeleteRoute"},
    {47, "RtmDeleteRouteList"},
    {48, "RtmDeleteRouteTable"},
    {49, "RtmDeleteRouteToDest"},
    {50, "RtmDequeueRouteChangeMessage"},
    {51, "RtmDereferenceHandles"},
    {52, "RtmDeregisterClient"},
    {53, "RtmDeregisterEntity"},
    {54, "RtmDeregisterFromChangeNotification"},
    {55, "RtmEnumerateGetNextRoute"},
    {56, "RtmFindNextHop"},
    {57, "RtmGetAddressFamilyInfo"},
    {58, "RtmGetChangeStatus"},
    {59, "RtmGetChangedDests"},
    {60, "RtmGetDestInfo"},
    {61, "RtmGetEntityInfo"},
    {62, "RtmGetEntityMethods"},
    {63, "RtmGetEnumDests"},
    {64, "RtmGetEnumNextHops"},
    {65, "RtmGetEnumRoutes"},
    {66, "RtmGetExactMatchDestination"},
    {67, "RtmGetExactMatchRoute"},
    {68, "RtmGetFirstRoute"},
    {69, "RtmGetInstanceInfo"},
    {70, "RtmGetInstances"},
    {71, "RtmGetLessSpecificDestination"},
    {72, "RtmGetListEnumRoutes"},
    {73, "RtmGetMostSpecificDestination"},
    {74, "RtmGetNetworkCount"},
    {75, "RtmGetNextHopInfo"},
    {76, "RtmGetNextHopPointer"},
    {77, "RtmGetNextRoute"},
    {78, "RtmGetOpaqueInformationPointer"},
    {79, "RtmGetRegisteredEntities"},
    {80, "RtmGetRouteAge"},
    {81, "RtmGetRouteInfo"},
    {82, "RtmGetRoutePointer"},
    {83, "RtmHoldDestination"},
    {84, "RtmIgnoreChangedDests"},
    {85, "RtmInsertInRouteList"},
    {86, "RtmInvokeMethod"},
    {87, "RtmIsBestRoute"},
    {88, "RtmIsMarkedForChangeNotification"},
    {89, "RtmIsRoute"},
    {90, "RtmLockDestination"},
    {91, "RtmLockNextHop"},
    {92, "RtmLockRoute"},
    {93, "RtmLookupIPDestination"},
    {94, "RtmMarkDestForChangeNotification"},
    {95, "RtmReadAddressFamilyConfig"},
    {96, "RtmReadInstanceConfig"},
    {97, "RtmReferenceHandles"},
    {98, "RtmRegisterClient"},
    {99, "RtmRegisterEntity"},
    {100, "RtmRegisterForChangeNotification"},
    {101, "RtmReleaseChangedDests"},
    {102, "RtmReleaseDestInfo"},
    {103, "RtmReleaseDests"},
    {104, "RtmReleaseEntities"},
    {105, "RtmReleaseEntityInfo"},
    {106, "RtmReleaseNextHopInfo"},
    {107, "RtmReleaseNextHops"},
    {108, "RtmReleaseRouteInfo"},
    {109, "RtmReleaseRoutes"},
    {110, "RtmUpdateAndUnlockRoute"},
    {111, "RtmWriteAddressFamilyConfig"},
    {112, "RtmWriteInstanceConfig"},
    {113, "SearchInTable"},
    {0, NULL}};
static Dw32Ordinal rtutils[] = {
    {1, "LogErrorA"},
    {2, "LogErrorW"},
    {3, "LogEventA"},
    {4, "LogEventW"},
    {5, "MprSetupProtocolEnum"},
    {6, "MprSetupProtocolFree"},
    {7, "RouterAssert"},
    {8, "RouterGetErrorStringA"},
    {9, "RouterGetErrorStringW"},
    {10, "RouterLogDeregisterA"},
    {11, "RouterLogDeregisterW"},
    {12, "RouterLogEventA"},
    {13, "RouterLogEventDataA"},
    {14, "RouterLogEventDataW"},
    {15, "RouterLogEventExA"},
    {16, "RouterLogEventExW"},
    {17, "RouterLogEventStringA"},
    {18, "RouterLogEventStringW"},
    {19, "RouterLogEventValistExA"},
    {20, "RouterLogEventValistExW"},
    {21, "RouterLogEventW"},
    {22, "RouterLogRegisterA"},
    {23, "RouterLogRegisterW"},
    {24, "TraceDeregisterA"},
    {25, "TraceDeregisterExA"},
    {26, "TraceDeregisterExW"},
    {27, "TraceDeregisterW"},
    {28, "TraceDumpExA"},
    {29, "TraceDumpExW"},
    {30, "TraceGetConsoleA"},
    {31, "TraceGetConsoleW"},
    {32, "TracePrintfA"},
    {33, "TracePrintfExA"},
    {34, "TracePrintfExW"},
    {35, "TracePrintfW"},
    {36, "TracePutsExA"},
    {37, "TracePutsExW"},
    {38, "TraceRegisterExA"},
    {39, "TraceRegisterExW"},
    {40, "TraceVprintfExA"},
    {41, "TraceVprintfExW"},
    {0, NULL}};
static Dw32Ordinal scarddlg[] = {
    {1, "GetOpenCardNameA"},
    {2, "GetOpenCardNameW"},
    {3, "SCardDlgExtendedError"},
    {4, "SCardUIDlgSelectCardA"},
    {5, "SCardUIDlgSelectCardW"},
    {0, NULL}};
static Dw32Ordinal secur32[] = {
    {4, "AcceptSecurityContext"},
    {5, "AcquireCredentialsHandleA"},
    {6, "AcquireCredentialsHandleW"},
    {7, "AddCredentialsA"},
    {8, "AddCredentialsW"},
    {9, "AddSecurityPackageA"},
    {10, "AddSecurityPackageW"},
    {11, "ApplyControlToken"},
    {12, "ChangeAccountPasswordA"},
    {13, "ChangeAccountPasswordW"},
    {1, "CloseLsaPerformanceData"},
    {2, "CollectLsaPerformanceData"},
    {14, "CompleteAuthToken"},
    {15, "CredMarshalTargetInfo"},
    {16, "CredParseUserNameWithType"},
    {17, "CredUnmarshalTargetInfo"},
    {18, "DecryptMessage"},
    {19, "DeleteSecurityContext"},
    {20, "DeleteSecurityPackageA"},
    {21, "DeleteSecurityPackageW"},
    {22, "EncryptMessage"},
    {23, "EnumerateSecurityPackagesA"},
    {24, "EnumerateSecurityPackagesW"},
    {25, "ExportSecurityContext"},
    {26, "FreeContextBuffer"},
    {27, "FreeCredentialsHandle"},
    {28, "GetComputerObjectNameA"},
    {29, "GetComputerObjectNameW"},
    {30, "GetSecurityUserInfo"},
    {31, "GetUserNameExA"},
    {32, "GetUserNameExW"},
    {33, "ImpersonateSecurityContext"},
    {34, "ImportSecurityContextA"},
    {35, "ImportSecurityContextW"},
    {36, "InitSecurityInterfaceA"},
    {37, "InitSecurityInterfaceW"},
    {38, "InitializeSecurityContextA"},
    {39, "InitializeSecurityContextW"},
    {40, "LsaCallAuthenticationPackage"},
    {41, "LsaConnectUntrusted"},
    {42, "LsaDeregisterLogonProcess"},
    {43, "LsaEnumerateLogonSessions"},
    {44, "LsaFreeReturnBuffer"},
    {45, "LsaGetLogonSessionData"},
    {46, "LsaLogonUser"},
    {47, "LsaLookupAuthenticationPackage"},
    {48, "LsaRegisterLogonProcess"},
    {49, "LsaRegisterPolicyChangeNotification"},
    {50, "LsaUnregisterPolicyChangeNotification"},
    {51, "MakeSignature"},
    {3, "OpenLsaPerformanceData"},
    {52, "QueryContextAttributesA"},
    {53, "QueryContextAttributesW"},
    {54, "QueryCredentialsAttributesA"},
    {55, "QueryCredentialsAttributesW"},
    {56, "QuerySecurityContextToken"},
    {57, "QuerySecurityPackageInfoA"},
    {58, "QuerySecurityPackageInfoW"},
    {59, "RevertSecurityContext"},
    {60, "SaslAcceptSecurityContext"},
    {61, "SaslEnumerateProfilesA"},
    {62, "SaslEnumerateProfilesW"},
    {63, "SaslGetContextOption"},
    {64, "SaslGetProfilePackageA"},
    {65, "SaslGetProfilePackageW"},
    {66, "SaslIdentifyPackageA"},
    {67, "SaslIdentifyPackageW"},
    {68, "SaslInitializeSecurityContextA"},
    {69, "SaslInitializeSecurityContextW"},
    {70, "SaslSetContextOption"},
    {71, "SealMessage"},
    {72, "SeciAllocateAndSetCallFlags"},
    {73, "SeciAllocateAndSetIPAddress"},
    {74, "SeciFreeCallContext"},
    {75, "SecpFreeMemory"},
    {76, "SecpTranslateName"},
    {77, "SecpTranslateNameEx"},
    {78, "SetContextAttributesA"},
    {79, "SetContextAttributesW"},
    {80, "SetCredentialsAttributesA"},
    {81, "SetCredentialsAttributesW"},
    {82, "SspiCompareAuthIdentities"},
    {83, "SspiCopyAuthIdentity"},
    {84, "SspiDecryptAuthIdentity"},
    {85, "SspiEncodeAuthIdentityAsStrings"},
    {86, "SspiEncodeStringsAsAuthIdentity"},
    {87, "SspiEncryptAuthIdentity"},
    {88, "SspiExcludePackage"},
    {89, "SspiFreeAuthIdentity"},
    {90, "SspiGetTargetHostName"},
    {91, "SspiIsAuthIdentityEncrypted"},
    {92, "SspiLocalFree"},
    {93, "SspiMarshalAuthIdentity"},
    {94, "SspiPrepareForCredRead"},
    {95, "SspiPrepareForCredWrite"},
    {96, "SspiUnmarshalAuthIdentity"},
    {97, "SspiValidateAuthIdentity"},
    {98, "SspiZeroAuthIdentity"},
    {99, "TranslateNameA"},
    {100, "TranslateNameW"},
    {101, "UnsealMessage"},
    {102, "VerifySignature"},
    {0, NULL}};
static Dw32Ordinal sensapi[] = {
    {1, "IsDestinationReachableA"},
    {2, "IsDestinationReachableW"},
    {3, "IsNetworkAlive"},
    {0, NULL}};
static Dw32Ordinal setupapi[] = {
    {1, "CMP_GetBlockedDriverInfo"},
    {2, "CMP_GetServerSideDeviceInstallFlags"},
    {3, "CMP_Init_Detection"},
    {4, "CMP_RegisterNotification"},
    {5, "CMP_Report_LogOn"},
    {6, "CMP_UnregisterNotification"},
    {7, "CMP_WaitNoPendingInstallEvents"},
    {8, "CMP_WaitServicesAvailable"},
    {9, "CM_Add_Driver_PackageW"},
    {10, "CM_Add_Empty_Log_Conf"},
    {11, "CM_Add_Empty_Log_Conf_Ex"},
    {12, "CM_Add_IDA"},
    {13, "CM_Add_IDW"},
    {14, "CM_Add_ID_ExA"},
    {15, "CM_Add_ID_ExW"},
    {16, "CM_Add_Range"},
    {17, "CM_Add_Res_Des"},
    {18, "CM_Add_Res_Des_Ex"},
    {19, "CM_Apply_PowerScheme"},
    {20, "CM_Connect_MachineA"},
    {21, "CM_Connect_MachineW"},
    {22, "CM_Create_DevNodeA"},
    {23, "CM_Create_DevNodeW"},
    {24, "CM_Create_DevNode_ExA"},
    {25, "CM_Create_DevNode_ExW"},
    {26, "CM_Create_Range_List"},
    {27, "CM_Delete_Class_Key"},
    {28, "CM_Delete_Class_Key_Ex"},
    {29, "CM_Delete_DevNode_Key"},
    {30, "CM_Delete_DevNode_Key_Ex"},
    {31, "CM_Delete_Device_Interface_KeyA"},
    {32, "CM_Delete_Device_Interface_KeyW"},
    {33, "CM_Delete_Device_Interface_Key_ExA"},
    {34, "CM_Delete_Device_Interface_Key_ExW"},
    {35, "CM_Delete_Driver_PackageW"},
    {36, "CM_Delete_PowerScheme"},
    {37, "CM_Delete_Range"},
    {38, "CM_Detect_Resource_Conflict"},
    {39, "CM_Detect_Resource_Conflict_Ex"},
    {40, "CM_Disable_DevNode"},
    {41, "CM_Disable_DevNode_Ex"},
    {42, "CM_Disconnect_Machine"},
    {43, "CM_Dup_Range_List"},
    {44, "CM_Duplicate_PowerScheme"},
    {45, "CM_Enable_DevNode"},
    {46, "CM_Enable_DevNode_Ex"},
    {47, "CM_Enumerate_Classes"},
    {48, "CM_Enumerate_Classes_Ex"},
    {49, "CM_Enumerate_EnumeratorsA"},
    {50, "CM_Enumerate_EnumeratorsW"},
    {51, "CM_Enumerate_Enumerators_ExA"},
    {52, "CM_Enumerate_Enumerators_ExW"},
    {53, "CM_Find_Range"},
    {54, "CM_First_Range"},
    {55, "CM_Free_Log_Conf"},
    {56, "CM_Free_Log_Conf_Ex"},
    {57, "CM_Free_Log_Conf_Handle"},
    {58, "CM_Free_Range_List"},
    {59, "CM_Free_Res_Des"},
    {60, "CM_Free_Res_Des_Ex"},
    {61, "CM_Free_Res_Des_Handle"},
    {62, "CM_Free_Resource_Conflict_Handle"},
    {63, "CM_Get_Child"},
    {64, "CM_Get_Child_Ex"},
    {65, "CM_Get_Class_Key_NameA"},
    {66, "CM_Get_Class_Key_NameW"},
    {67, "CM_Get_Class_Key_Name_ExA"},
    {68, "CM_Get_Class_Key_Name_ExW"},
    {69, "CM_Get_Class_NameA"},
    {70, "CM_Get_Class_NameW"},
    {71, "CM_Get_Class_Name_ExA"},
    {72, "CM_Get_Class_Name_ExW"},
    {73, "CM_Get_Class_Registry_PropertyA"},
    {74, "CM_Get_Class_Registry_PropertyW"},
    {75, "CM_Get_Depth"},
    {76, "CM_Get_Depth_Ex"},
    {77, "CM_Get_DevNode_Custom_PropertyA"},
    {78, "CM_Get_DevNode_Custom_PropertyW"},
    {79, "CM_Get_DevNode_Custom_Property_ExA"},
    {80, "CM_Get_DevNode_Custom_Property_ExW"},
    {81, "CM_Get_DevNode_Registry_PropertyA"},
    {82, "CM_Get_DevNode_Registry_PropertyW"},
    {83, "CM_Get_DevNode_Registry_Property_ExA"},
    {84, "CM_Get_DevNode_Registry_Property_ExW"},
    {85, "CM_Get_DevNode_Status"},
    {86, "CM_Get_DevNode_Status_Ex"},
    {87, "CM_Get_Device_IDA"},
    {88, "CM_Get_Device_IDW"},
    {89, "CM_Get_Device_ID_ExA"},
    {90, "CM_Get_Device_ID_ExW"},
    {91, "CM_Get_Device_ID_ListA"},
    {92, "CM_Get_Device_ID_ListW"},
    {93, "CM_Get_Device_ID_List_ExA"},
    {94, "CM_Get_Device_ID_List_ExW"},
    {95, "CM_Get_Device_ID_List_SizeA"},
    {96, "CM_Get_Device_ID_List_SizeW"},
    {97, "CM_Get_Device_ID_List_Size_ExA"},
    {98, "CM_Get_Device_ID_List_Size_ExW"},
    {99, "CM_Get_Device_ID_Size"},
    {100, "CM_Get_Device_ID_Size_Ex"},
    {101, "CM_Get_Device_Interface_AliasA"},
    {102, "CM_Get_Device_Interface_AliasW"},
    {103, "CM_Get_Device_Interface_Alias_ExA"},
    {104, "CM_Get_Device_Interface_Alias_ExW"},
    {105, "CM_Get_Device_Interface_ListA"},
    {106, "CM_Get_Device_Interface_ListW"},
    {107, "CM_Get_Device_Interface_List_ExA"},
    {108, "CM_Get_Device_Interface_List_ExW"},
    {109, "CM_Get_Device_Interface_List_SizeA"},
    {110, "CM_Get_Device_Interface_List_SizeW"},
    {111, "CM_Get_Device_Interface_List_Size_ExA"},
    {112, "CM_Get_Device_Interface_List_Size_ExW"},
    {113, "CM_Get_First_Log_Conf"},
    {114, "CM_Get_First_Log_Conf_Ex"},
    {115, "CM_Get_Global_State"},
    {116, "CM_Get_Global_State_Ex"},
    {117, "CM_Get_HW_Prof_FlagsA"},
    {118, "CM_Get_HW_Prof_FlagsW"},
    {119, "CM_Get_HW_Prof_Flags_ExA"},
    {120, "CM_Get_HW_Prof_Flags_ExW"},
    {121, "CM_Get_Hardware_Profile_InfoA"},
    {122, "CM_Get_Hardware_Profile_InfoW"},
    {123, "CM_Get_Hardware_Profile_Info_ExA"},
    {124, "CM_Get_Hardware_Profile_Info_ExW"},
    {125, "CM_Get_Log_Conf_Priority"},
    {126, "CM_Get_Log_Conf_Priority_Ex"},
    {127, "CM_Get_Next_Log_Conf"},
    {128, "CM_Get_Next_Log_Conf_Ex"},
    {129, "CM_Get_Next_Res_Des"},
    {130, "CM_Get_Next_Res_Des_Ex"},
    {131, "CM_Get_Parent"},
    {132, "CM_Get_Parent_Ex"},
    {133, "CM_Get_Res_Des_Data"},
    {134, "CM_Get_Res_Des_Data_Ex"},
    {135, "CM_Get_Res_Des_Data_Size"},
    {136, "CM_Get_Res_Des_Data_Size_Ex"},
    {137, "CM_Get_Resource_Conflict_Count"},
    {138, "CM_Get_Resource_Conflict_DetailsA"},
    {139, "CM_Get_Resource_Conflict_DetailsW"},
    {140, "CM_Get_Sibling"},
    {141, "CM_Get_Sibling_Ex"},
    {142, "CM_Get_Version"},
    {143, "CM_Get_Version_Ex"},
    {144, "CM_Import_PowerScheme"},
    {145, "CM_Install_DevNodeW"},
    {146, "CM_Install_DevNode_ExW"},
    {147, "CM_Intersect_Range_List"},
    {148, "CM_Invert_Range_List"},
    {149, "CM_Is_Dock_Station_Present"},
    {150, "CM_Is_Dock_Station_Present_Ex"},
    {151, "CM_Is_Version_Available"},
    {152, "CM_Is_Version_Available_Ex"},
    {153, "CM_Locate_DevNodeA"},
    {154, "CM_Locate_DevNodeW"},
    {155, "CM_Locate_DevNode_ExA"},
    {156, "CM_Locate_DevNode_ExW"},
    {157, "CM_Merge_Range_List"},
    {158, "CM_Modify_Res_Des"},
    {159, "CM_Modify_Res_Des_Ex"},
    {160, "CM_Move_DevNode"},
    {161, "CM_Move_DevNode_Ex"},
    {162, "CM_Next_Range"},
    {163, "CM_Open_Class_KeyA"},
    {164, "CM_Open_Class_KeyW"},
    {165, "CM_Open_Class_Key_ExA"},
    {166, "CM_Open_Class_Key_ExW"},
    {167, "CM_Open_DevNode_Key"},
    {168, "CM_Open_DevNode_Key_Ex"},
    {169, "CM_Open_Device_Interface_KeyA"},
    {170, "CM_Open_Device_Interface_KeyW"},
    {171, "CM_Open_Device_Interface_Key_ExA"},
    {172, "CM_Open_Device_Interface_Key_ExW"},
    {173, "CM_Query_And_Remove_SubTreeA"},
    {174, "CM_Query_And_Remove_SubTreeW"},
    {175, "CM_Query_And_Remove_SubTree_ExA"},
    {176, "CM_Query_And_Remove_SubTree_ExW"},
    {177, "CM_Query_Arbitrator_Free_Data"},
    {178, "CM_Query_Arbitrator_Free_Data_Ex"},
    {179, "CM_Query_Arbitrator_Free_Size"},
    {180, "CM_Query_Arbitrator_Free_Size_Ex"},
    {181, "CM_Query_Remove_SubTree"},
    {182, "CM_Query_Remove_SubTree_Ex"},
    {183, "CM_Query_Resource_Conflict_List"},
    {184, "CM_Reenumerate_DevNode"},
    {185, "CM_Reenumerate_DevNode_Ex"},
    {186, "CM_Register_Device_Driver"},
    {187, "CM_Register_Device_Driver_Ex"},
    {188, "CM_Register_Device_InterfaceA"},
    {189, "CM_Register_Device_InterfaceW"},
    {190, "CM_Register_Device_Interface_ExA"},
    {191, "CM_Register_Device_Interface_ExW"},
    {192, "CM_Remove_SubTree"},
    {193, "CM_Remove_SubTree_Ex"},
    {194, "CM_Request_Device_EjectA"},
    {195, "CM_Request_Device_EjectW"},
    {196, "CM_Request_Device_Eject_ExA"},
    {197, "CM_Request_Device_Eject_ExW"},
    {198, "CM_Request_Eject_PC"},
    {199, "CM_Request_Eject_PC_Ex"},
    {200, "CM_RestoreAll_DefaultPowerSchemes"},
    {201, "CM_Restore_DefaultPowerScheme"},
    {202, "CM_Run_Detection"},
    {203, "CM_Run_Detection_Ex"},
    {204, "CM_Set_ActiveScheme"},
    {205, "CM_Set_Class_Registry_PropertyA"},
    {206, "CM_Set_Class_Registry_PropertyW"},
    {207, "CM_Set_DevNode_Problem"},
    {208, "CM_Set_DevNode_Problem_Ex"},
    {209, "CM_Set_DevNode_Registry_PropertyA"},
    {210, "CM_Set_DevNode_Registry_PropertyW"},
    {211, "CM_Set_DevNode_Registry_Property_ExA"},
    {212, "CM_Set_DevNode_Registry_Property_ExW"},
    {213, "CM_Set_HW_Prof"},
    {214, "CM_Set_HW_Prof_Ex"},
    {215, "CM_Set_HW_Prof_FlagsA"},
    {216, "CM_Set_HW_Prof_FlagsW"},
    {217, "CM_Set_HW_Prof_Flags_ExA"},
    {218, "CM_Set_HW_Prof_Flags_ExW"},
    {219, "CM_Setup_DevNode"},
    {220, "CM_Setup_DevNode_Ex"},
    {221, "CM_Test_Range_Available"},
    {222, "CM_Uninstall_DevNode"},
    {223, "CM_Uninstall_DevNode_Ex"},
    {224, "CM_Unregister_Device_InterfaceA"},
    {225, "CM_Unregister_Device_InterfaceW"},
    {226, "CM_Unregister_Device_Interface_ExA"},
    {227, "CM_Unregister_Device_Interface_ExW"},
    {228, "CM_Write_UserPowerKey"},
    {229, "DoesUserHavePrivilege"},
    {230, "DriverStoreAddDriverPackageA"},
    {231, "DriverStoreAddDriverPackageW"},
    {232, "DriverStoreDeleteDriverPackageA"},
    {233, "DriverStoreDeleteDriverPackageW"},
    {234, "DriverStoreEnumDriverPackageA"},
    {235, "DriverStoreEnumDriverPackageW"},
    {236, "DriverStoreFindDriverPackageA"},
    {237, "DriverStoreFindDriverPackageW"},
    {238, "ExtensionPropSheetPageProc"},
    {239, "InstallCatalog"},
    {240, "InstallHinfSection"},
    {241, "InstallHinfSectionA"},
    {242, "InstallHinfSectionW"},
    {243, "IsUserAdmin"},
    {244, "MyFree"},
    {245, "MyMalloc"},
    {246, "MyRealloc"},
    {247, "PnpEnumDrpFile"},
    {248, "PnpIsFileAclIntact"},
    {249, "PnpIsFileContentIntact"},
    {250, "PnpIsFilePnpDriver"},
    {251, "PnpRepairWindowsProtectedDriver"},
    {252, "SetupAddInstallSectionToDiskSpaceListA"},
    {253, "SetupAddInstallSectionToDiskSpaceListW"},
    {254, "SetupAddSectionToDiskSpaceListA"},
    {255, "SetupAddSectionToDiskSpaceListW"},
    {256, "SetupAddToDiskSpaceListA"},
    {257, "SetupAddToDiskSpaceListW"},
    {258, "SetupAddToSourceListA"},
    {259, "SetupAddToSourceListW"},
    {260, "SetupAdjustDiskSpaceListA"},
    {261, "SetupAdjustDiskSpaceListW"},
    {262, "SetupBackupErrorA"},
    {263, "SetupBackupErrorW"},
    {264, "SetupCancelTemporarySourceList"},
    {265, "SetupCloseFileQueue"},
    {266, "SetupCloseInfFile"},
    {267, "SetupCloseLog"},
    {268, "SetupCommitFileQueue"},
    {269, "SetupCommitFileQueueA"},
    {270, "SetupCommitFileQueueW"},
    {271, "SetupConfigureWmiFromInfSectionA"},
    {272, "SetupConfigureWmiFromInfSectionW"},
    {273, "SetupCopyErrorA"},
    {274, "SetupCopyErrorW"},
    {275, "SetupCopyOEMInfA"},
    {276, "SetupCopyOEMInfW"},
    {277, "SetupCreateDiskSpaceListA"},
    {278, "SetupCreateDiskSpaceListW"},
    {279, "SetupDecompressOrCopyFileA"},
    {280, "SetupDecompressOrCopyFileW"},
    {281, "SetupDefaultQueueCallback"},
    {282, "SetupDefaultQueueCallbackA"},
    {283, "SetupDefaultQueueCallbackW"},
    {284, "SetupDeleteErrorA"},
    {285, "SetupDeleteErrorW"},
    {286, "SetupDestroyDiskSpaceList"},
    {287, "SetupDiApplyPowerScheme"},
    {288, "SetupDiAskForOEMDisk"},
    {289, "SetupDiBuildClassInfoList"},
    {290, "SetupDiBuildClassInfoListExA"},
    {291, "SetupDiBuildClassInfoListExW"},
    {292, "SetupDiBuildDriverInfoList"},
    {293, "SetupDiCallClassInstaller"},
    {294, "SetupDiCancelDriverInfoSearch"},
    {295, "SetupDiChangeState"},
    {296, "SetupDiClassGuidsFromNameA"},
    {297, "SetupDiClassGuidsFromNameExA"},
    {298, "SetupDiClassGuidsFromNameExW"},
    {299, "SetupDiClassGuidsFromNameW"},
    {300, "SetupDiClassNameFromGuidA"},
    {301, "SetupDiClassNameFromGuidExA"},
    {302, "SetupDiClassNameFromGuidExW"},
    {303, "SetupDiClassNameFromGuidW"},
    {304, "SetupDiCreateDevRegKeyA"},
    {305, "SetupDiCreateDevRegKeyW"},
    {306, "SetupDiCreateDeviceInfoA"},
    {307, "SetupDiCreateDeviceInfoList"},
    {308, "SetupDiCreateDeviceInfoListExA"},
    {309, "SetupDiCreateDeviceInfoListExW"},
    {310, "SetupDiCreateDeviceInfoW"},
    {311, "SetupDiCreateDeviceInterfaceA"},
    {312, "SetupDiCreateDeviceInterfaceRegKeyA"},
    {313, "SetupDiCreateDeviceInterfaceRegKeyW"},
    {314, "SetupDiCreateDeviceInterfaceW"},
    {315, "SetupDiDeleteDevRegKey"},
    {316, "SetupDiDeleteDeviceInfo"},
    {317, "SetupDiDeleteDeviceInterfaceData"},
    {318, "SetupDiDeleteDeviceInterfaceRegKey"},
    {319, "SetupDiDestroyClassImageList"},
    {320, "SetupDiDestroyDeviceInfoList"},
    {321, "SetupDiDestroyDriverInfoList"},
    {322, "SetupDiDrawMiniIcon"},
    {323, "SetupDiEnumDeviceInfo"},
    {324, "SetupDiEnumDeviceInterfaces"},
    {325, "SetupDiEnumDriverInfoA"},
    {326, "SetupDiEnumDriverInfoW"},
    {327, "SetupDiGetActualModelsSectionA"},
    {328, "SetupDiGetActualModelsSectionW"},
    {329, "SetupDiGetActualSectionToInstallA"},
    {330, "SetupDiGetActualSectionToInstallExA"},
    {331, "SetupDiGetActualSectionToInstallExW"},
    {332, "SetupDiGetActualSectionToInstallW"},
    {333, "SetupDiGetClassBitmapIndex"},
    {334, "SetupDiGetClassDescriptionA"},
    {335, "SetupDiGetClassDescriptionExA"},
    {336, "SetupDiGetClassDescriptionExW"},
    {337, "SetupDiGetClassDescriptionW"},
    {338, "SetupDiGetClassDevPropertySheetsA"},
    {339, "SetupDiGetClassDevPropertySheetsW"},
    {340, "SetupDiGetClassDevsA"},
    {341, "SetupDiGetClassDevsExA"},
    {342, "SetupDiGetClassDevsExW"},
    {343, "SetupDiGetClassDevsW"},
    {344, "SetupDiGetClassImageIndex"},
    {345, "SetupDiGetClassImageList"},
    {346, "SetupDiGetClassImageListExA"},
    {347, "SetupDiGetClassImageListExW"},
    {348, "SetupDiGetClassInstallParamsA"},
    {349, "SetupDiGetClassInstallParamsW"},
    {350, "SetupDiGetClassPropertyExW"},
    {351, "SetupDiGetClassPropertyKeys"},
    {352, "SetupDiGetClassPropertyKeysExW"},
    {353, "SetupDiGetClassPropertyW"},
    {354, "SetupDiGetClassRegistryPropertyA"},
    {355, "SetupDiGetClassRegistryPropertyW"},
    {356, "SetupDiGetCustomDevicePropertyA"},
    {357, "SetupDiGetCustomDevicePropertyW"},
    {358, "SetupDiGetDeviceInfoListClass"},
    {359, "SetupDiGetDeviceInfoListDetailA"},
    {360, "SetupDiGetDeviceInfoListDetailW"},
    {361, "SetupDiGetDeviceInstallParamsA"},
    {362, "SetupDiGetDeviceInstallParamsW"},
    {363, "SetupDiGetDeviceInstanceIdA"},
    {364, "SetupDiGetDeviceInstanceIdW"},
    {365, "SetupDiGetDeviceInterfaceAlias"},
    {366, "SetupDiGetDeviceInterfaceDetailA"},
    {367, "SetupDiGetDeviceInterfaceDetailW"},
    {368, "SetupDiGetDeviceInterfacePropertyKeys"},
    {369, "SetupDiGetDeviceInterfacePropertyW"},
    {370, "SetupDiGetDevicePropertyKeys"},
    {371, "SetupDiGetDevicePropertyW"},
    {372, "SetupDiGetDeviceRegistryPropertyA"},
    {373, "SetupDiGetDeviceRegistryPropertyW"},
    {374, "SetupDiGetDriverInfoDetailA"},
    {375, "SetupDiGetDriverInfoDetailW"},
    {376, "SetupDiGetDriverInstallParamsA"},
    {377, "SetupDiGetDriverInstallParamsW"},
    {378, "SetupDiGetHwProfileFriendlyNameA"},
    {379, "SetupDiGetHwProfileFriendlyNameExA"},
    {380, "SetupDiGetHwProfileFriendlyNameExW"},
    {381, "SetupDiGetHwProfileFriendlyNameW"},
    {382, "SetupDiGetHwProfileList"},
    {383, "SetupDiGetHwProfileListExA"},
    {384, "SetupDiGetHwProfileListExW"},
    {385, "SetupDiGetINFClassA"},
    {386, "SetupDiGetINFClassW"},
    {387, "SetupDiGetSelectedDevice"},
    {388, "SetupDiGetSelectedDriverA"},
    {389, "SetupDiGetSelectedDriverW"},
    {390, "SetupDiGetWizardPage"},
    {391, "SetupDiInstallClassA"},
    {392, "SetupDiInstallClassExA"},
    {393, "SetupDiInstallClassExW"},
    {394, "SetupDiInstallClassW"},
    {395, "SetupDiInstallDevice"},
    {396, "SetupDiInstallDeviceInterfaces"},
    {397, "SetupDiInstallDriverFiles"},
    {398, "SetupDiLoadClassIcon"},
    {399, "SetupDiLoadDeviceIcon"},
    {400, "SetupDiMoveDuplicateDevice"},
    {401, "SetupDiOpenClassRegKey"},
    {402, "SetupDiOpenClassRegKeyExA"},
    {403, "SetupDiOpenClassRegKeyExW"},
    {404, "SetupDiOpenDevRegKey"},
    {405, "SetupDiOpenDeviceInfoA"},
    {406, "SetupDiOpenDeviceInfoW"},
    {407, "SetupDiOpenDeviceInterfaceA"},
    {408, "SetupDiOpenDeviceInterfaceRegKey"},
    {409, "SetupDiOpenDeviceInterfaceW"},
    {410, "SetupDiRegisterCoDeviceInstallers"},
    {411, "SetupDiRegisterDeviceInfo"},
    {412, "SetupDiRemoveDevice"},
    {413, "SetupDiRemoveDeviceInterface"},
    {414, "SetupDiReportAdditionalSoftwareRequested"},
    {415, "SetupDiReportDeviceInstallError"},
    {416, "SetupDiReportDriverNotFoundError"},
    {417, "SetupDiReportDriverPackageImportationError"},
    {418, "SetupDiReportGenericDriverInstalled"},
    {419, "SetupDiReportPnPDeviceProblem"},
    {420, "SetupDiRestartDevices"},
    {421, "SetupDiSelectBestCompatDrv"},
    {422, "SetupDiSelectDevice"},
    {423, "SetupDiSelectOEMDrv"},
    {424, "SetupDiSetClassInstallParamsA"},
    {425, "SetupDiSetClassInstallParamsW"},
    {426, "SetupDiSetClassPropertyExW"},
    {427, "SetupDiSetClassPropertyW"},
    {428, "SetupDiSetClassRegistryPropertyA"},
    {429, "SetupDiSetClassRegistryPropertyW"},
    {430, "SetupDiSetDeviceInstallParamsA"},
    {431, "SetupDiSetDeviceInstallParamsW"},
    {432, "SetupDiSetDeviceInterfaceDefault"},
    {433, "SetupDiSetDeviceInterfacePropertyW"},
    {434, "SetupDiSetDevicePropertyW"},
    {435, "SetupDiSetDeviceRegistryPropertyA"},
    {436, "SetupDiSetDeviceRegistryPropertyW"},
    {437, "SetupDiSetDriverInstallParamsA"},
    {438, "SetupDiSetDriverInstallParamsW"},
    {439, "SetupDiSetSelectedDevice"},
    {440, "SetupDiSetSelectedDriverA"},
    {441, "SetupDiSetSelectedDriverW"},
    {442, "SetupDiUnremoveDevice"},
    {443, "SetupDuplicateDiskSpaceListA"},
    {444, "SetupDuplicateDiskSpaceListW"},
    {445, "SetupEnumInfSectionsA"},
    {446, "SetupEnumInfSectionsW"},
    {447, "SetupEnumPublishedInfA"},
    {448, "SetupEnumPublishedInfW"},
    {449, "SetupFindFirstLineA"},
    {450, "SetupFindFirstLineW"},
    {451, "SetupFindNextLine"},
    {452, "SetupFindNextMatchLineA"},
    {453, "SetupFindNextMatchLineW"},
    {454, "SetupFreeSourceListA"},
    {455, "SetupFreeSourceListW"},
    {456, "SetupGetBackupInformationA"},
    {457, "SetupGetBackupInformationW"},
    {458, "SetupGetBinaryField"},
    {459, "SetupGetFieldCount"},
    {460, "SetupGetFileCompressionInfoA"},
    {461, "SetupGetFileCompressionInfoExA"},
    {462, "SetupGetFileCompressionInfoExW"},
    {463, "SetupGetFileCompressionInfoW"},
    {464, "SetupGetFileQueueCount"},
    {465, "SetupGetFileQueueFlags"},
    {466, "SetupGetInfDriverStoreLocationA"},
    {467, "SetupGetInfDriverStoreLocationW"},
    {468, "SetupGetInfFileListA"},
    {469, "SetupGetInfFileListW"},
    {470, "SetupGetInfInformationA"},
    {471, "SetupGetInfInformationW"},
    {472, "SetupGetInfPublishedNameA"},
    {473, "SetupGetInfPublishedNameW"},
    {474, "SetupGetInfSections"},
    {475, "SetupGetIntField"},
    {476, "SetupGetLineByIndexA"},
    {477, "SetupGetLineByIndexW"},
    {478, "SetupGetLineCountA"},
    {479, "SetupGetLineCountW"},
    {480, "SetupGetLineTextA"},
    {481, "SetupGetLineTextW"},
    {482, "SetupGetMultiSzFieldA"},
    {483, "SetupGetMultiSzFieldW"},
    {484, "SetupGetNonInteractiveMode"},
    {485, "SetupGetSourceFileLocationA"},
    {486, "SetupGetSourceFileLocationW"},
    {487, "SetupGetSourceFileSizeA"},
    {488, "SetupGetSourceFileSizeW"},
    {489, "SetupGetSourceInfoA"},
    {490, "SetupGetSourceInfoW"},
    {491, "SetupGetStringFieldA"},
    {492, "SetupGetStringFieldW"},
    {493, "SetupGetTargetPathA"},
    {494, "SetupGetTargetPathW"},
    {495, "SetupGetThreadLogToken"},
    {496, "SetupInitDefaultQueueCallback"},
    {497, "SetupInitDefaultQueueCallbackEx"},
    {498, "SetupInitializeFileLogA"},
    {499, "SetupInitializeFileLogW"},
    {500, "SetupInstallFileA"},
    {501, "SetupInstallFileExA"},
    {502, "SetupInstallFileExW"},
    {503, "SetupInstallFileW"},
    {504, "SetupInstallFilesFromInfSectionA"},
    {505, "SetupInstallFilesFromInfSectionW"},
    {506, "SetupInstallFromInfSectionA"},
    {507, "SetupInstallFromInfSectionW"},
    {508, "SetupInstallLogCloseEventGroup"},
    {509, "SetupInstallLogCreateEventGroup"},
    {510, "SetupInstallServicesFromInfSectionA"},
    {511, "SetupInstallServicesFromInfSectionExA"},
    {512, "SetupInstallServicesFromInfSectionExW"},
    {513, "SetupInstallServicesFromInfSectionW"},
    {514, "SetupIterateCabinetA"},
    {515, "SetupIterateCabinetW"},
    {516, "SetupLogErrorA"},
    {517, "SetupLogErrorW"},
    {518, "SetupLogFileA"},
    {519, "SetupLogFileW"},
    {520, "SetupOpenAppendInfFileA"},
    {521, "SetupOpenAppendInfFileW"},
    {522, "SetupOpenFileQueue"},
    {523, "SetupOpenInfFileA"},
    {524, "SetupOpenInfFileW"},
    {525, "SetupOpenLog"},
    {526, "SetupOpenMasterInf"},
    {527, "SetupPrepareQueueForRestoreA"},
    {528, "SetupPrepareQueueForRestoreW"},
    {529, "SetupPromptForDiskA"},
    {530, "SetupPromptForDiskW"},
    {531, "SetupPromptReboot"},
    {532, "SetupQueryDrivesInDiskSpaceListA"},
    {533, "SetupQueryDrivesInDiskSpaceListW"},
    {534, "SetupQueryFileLogA"},
    {535, "SetupQueryFileLogW"},
    {536, "SetupQueryInfFileInformationA"},
    {537, "SetupQueryInfFileInformationW"},
    {538, "SetupQueryInfOriginalFileInformationA"},
    {539, "SetupQueryInfOriginalFileInformationW"},
    {540, "SetupQueryInfVersionInformationA"},
    {541, "SetupQueryInfVersionInformationW"},
    {542, "SetupQuerySourceListA"},
    {543, "SetupQuerySourceListW"},
    {544, "SetupQuerySpaceRequiredOnDriveA"},
    {545, "SetupQuerySpaceRequiredOnDriveW"},
    {546, "SetupQueueCopyA"},
    {547, "SetupQueueCopyIndirectA"},
    {548, "SetupQueueCopyIndirectW"},
    {549, "SetupQueueCopySectionA"},
    {550, "SetupQueueCopySectionW"},
    {551, "SetupQueueCopyW"},
    {552, "SetupQueueDefaultCopyA"},
    {553, "SetupQueueDefaultCopyW"},
    {554, "SetupQueueDeleteA"},
    {555, "SetupQueueDeleteSectionA"},
    {556, "SetupQueueDeleteSectionW"},
    {557, "SetupQueueDeleteW"},
    {558, "SetupQueueRenameA"},
    {559, "SetupQueueRenameSectionA"},
    {560, "SetupQueueRenameSectionW"},
    {561, "SetupQueueRenameW"},
    {562, "SetupRemoveFileLogEntryA"},
    {563, "SetupRemoveFileLogEntryW"},
    {564, "SetupRemoveFromDiskSpaceListA"},
    {565, "SetupRemoveFromDiskSpaceListW"},
    {566, "SetupRemoveFromSourceListA"},
    {567, "SetupRemoveFromSourceListW"},
    {568, "SetupRemoveInstallSectionFromDiskSpaceListA"},
    {569, "SetupRemoveInstallSectionFromDiskSpaceListW"},
    {570, "SetupRemoveSectionFromDiskSpaceListA"},
    {571, "SetupRemoveSectionFromDiskSpaceListW"},
    {572, "SetupRenameErrorA"},
    {573, "SetupRenameErrorW"},
    {574, "SetupScanFileQueue"},
    {575, "SetupScanFileQueueA"},
    {576, "SetupScanFileQueueW"},
    {577, "SetupSetDirectoryIdA"},
    {578, "SetupSetDirectoryIdExA"},
    {579, "SetupSetDirectoryIdExW"},
    {580, "SetupSetDirectoryIdW"},
    {581, "SetupSetFileQueueAlternatePlatformA"},
    {582, "SetupSetFileQueueAlternatePlatformW"},
    {583, "SetupSetFileQueueFlags"},
    {584, "SetupSetNonInteractiveMode"},
    {585, "SetupSetPlatformPathOverrideA"},
    {586, "SetupSetPlatformPathOverrideW"},
    {587, "SetupSetSourceListA"},
    {588, "SetupSetSourceListW"},
    {589, "SetupSetThreadLogToken"},
    {590, "SetupTermDefaultQueueCallback"},
    {591, "SetupTerminateFileLog"},
    {592, "SetupUninstallNewlyCopiedInfs"},
    {593, "SetupUninstallOEMInfA"},
    {594, "SetupUninstallOEMInfW"},
    {595, "SetupVerifyInfFileA"},
    {596, "SetupVerifyInfFileW"},
    {597, "SetupWriteTextLog"},
    {598, "SetupWriteTextLogError"},
    {599, "SetupWriteTextLogInfLine"},
    {600, "UnicodeToMultiByte"},
    {601, "VerifyCatalogFile"},
    {602, "pGetDriverPackageHash"},
    {603, "pSetupAccessRunOnceNodeList"},
    {604, "pSetupAddMiniIconToList"},
    {605, "pSetupAddTagToGroupOrderListEntry"},
    {606, "pSetupAppendPath"},
    {607, "pSetupCaptureAndConvertAnsiArg"},
    {608, "pSetupCenterWindowRelativeToParent"},
    {609, "pSetupCloseTextLogSection"},
    {610, "pSetupConcatenatePaths"},
    {611, "pSetupCreateTextLogSectionA"},
    {612, "pSetupCreateTextLogSectionW"},
    {613, "pSetupDestroyRunOnceNodeList"},
    {614, "pSetupDiBuildInfoDataFromStrongName"},
    {615, "pSetupDiCrimsonLogDeviceInstall"},
    {616, "pSetupDiGetStrongNameForDriverNode"},
    {617, "pSetupDiInvalidateHelperModules"},
    {618, "pSetupDoLastKnownGoodBackup"},
    {619, "pSetupDoesUserHavePrivilege"},
    {620, "pSetupDuplicateString"},
    {621, "pSetupEnablePrivilege"},
    {622, "pSetupFree"},
    {623, "pSetupGetCurrentDriverSigningPolicy"},
    {624, "pSetupGetDriverDate"},
    {625, "pSetupGetDriverVersion"},
    {626, "pSetupGetField"},
    {627, "pSetupGetFileTitle"},
    {628, "pSetupGetGlobalFlags"},
    {629, "pSetupGetIndirectStringsFromDriverInfo"},
    {630, "pSetupGetInfSections"},
    {631, "pSetupGetQueueFlags"},
    {632, "pSetupGetRealSystemTime"},
    {633, "pSetupGuidFromString"},
    {634, "pSetupHandleFailedVerification"},
    {635, "pSetupInfGetDigitalSignatureInfo"},
    {636, "pSetupInfIsInbox"},
    {637, "pSetupInfSetDigitalSignatureInfo"},
    {638, "pSetupInstallCatalog"},
    {639, "pSetupIsBiDiLocalizedSystemEx"},
    {640, "pSetupIsGuidNull"},
    {641, "pSetupIsLocalSystem"},
    {642, "pSetupIsUserAdmin"},
    {643, "pSetupIsUserTrustedInstaller"},
    {644, "pSetupLoadIndirectString"},
    {645, "pSetupMakeSurePathExists"},
    {646, "pSetupMalloc"},
    {647, "pSetupModifyGlobalFlags"},
    {648, "pSetupMultiByteToUnicode"},
    {649, "pSetupOpenAndMapFileForRead"},
    {650, "pSetupOutOfMemory"},
    {651, "pSetupQueryMultiSzValueToArray"},
    {652, "pSetupRealloc"},
    {653, "pSetupRegistryDelnode"},
    {654, "pSetupRetrieveServiceConfig"},
    {655, "pSetupSetArrayToMultiSzValue"},
    {656, "pSetupSetDriverPackageRestorePoint"},
    {657, "pSetupSetGlobalFlags"},
    {658, "pSetupSetQueueFlags"},
    {659, "pSetupShouldDeviceBeExcluded"},
    {660, "pSetupStringFromGuid"},
    {661, "pSetupStringTableAddString"},
    {662, "pSetupStringTableAddStringEx"},
    {663, "pSetupStringTableDestroy"},
    {664, "pSetupStringTableDuplicate"},
    {665, "pSetupStringTableEnum"},
    {666, "pSetupStringTableGetExtraData"},
    {667, "pSetupStringTableInitialize"},
    {668, "pSetupStringTableInitializeEx"},
    {669, "pSetupStringTableLookUpString"},
    {670, "pSetupStringTableLookUpStringEx"},
    {671, "pSetupStringTableSetExtraData"},
    {672, "pSetupStringTableStringFromId"},
    {673, "pSetupStringTableStringFromIdEx"},
    {674, "pSetupUnicodeToMultiByte"},
    {675, "pSetupUnmapAndCloseFile"},
    {676, "pSetupValidateDriverPackage"},
    {677, "pSetupVerifyCatalogFile"},
    {678, "pSetupVerifyQueuedCatalogs"},
    {679, "pSetupWriteLogEntry"},
    {680, "pSetupWriteLogError"},
    {0, NULL}};
static Dw32Ordinal sfc[] = {
    {10, "SRSetRestorePoint"},
    {11, "SRSetRestorePointA"},
    {12, "SRSetRestorePointW"},
    {13, "SfcGetNextProtectedFile"},
    {14, "SfcIsFileProtected"},
    {15, "SfcIsKeyProtected"},
    {16, "SfpVerifyFile"},
    {0, NULL}};
static Dw32Ordinal shell32[] = {
    {208, "AppCompat_RunDLLW"},
    {226, "AssocCreateForClasses"},
    {228, "AssocGetDetailsOfPropKey"},
    {701, "CDefFolderMenu_Create2"},
    {83, "CIDLData_CreateFromIDArray"},
    {229, "CheckEscapesW"},
    {238, "CommandLineToArgvW"},
    {255, "Control_RunDLL"},
    {263, "Control_RunDLLA"},
    {267, "Control_RunDLLAsUserW"},
    {268, "Control_RunDLLW"},
    {129, "DAD_AutoScroll"},
    {131, "DAD_DragEnterEx"},
    {22, "DAD_DragEnterEx2"},
    {132, "DAD_DragLeave"},
    {134, "DAD_DragMove"},
    {136, "DAD_SetDragImage"},
    {137, "DAD_ShowDragImage"},
    {269, "DllCanUnloadNow"},
    {271, "DllGetClassObject"},
    {272, "DllGetVersion"},
    {273, "DllInstall"},
    {274, "DllRegisterServer"},
    {275, "DllUnregisterServer"},
    {276, "DoEnvironmentSubstA"},
    {277, "DoEnvironmentSubstW"},
    {278, "DragAcceptFiles"},
    {279, "DragFinish"},
    {280, "DragQueryFile"},
    {281, "DragQueryFileA"},
    {282, "DragQueryFileAorW"},
    {283, "DragQueryFileW"},
    {284, "DragQueryPoint"},
    {64, "DriveType"},
    {285, "DuplicateIcon"},
    {286, "ExtractAssociatedIconA"},
    {287, "ExtractAssociatedIconExA"},
    {288, "ExtractAssociatedIconExW"},
    {289, "ExtractAssociatedIconW"},
    {290, "ExtractIconA"},
    {291, "ExtractIconEx"},
    {292, "ExtractIconExA"},
    {293, "ExtractIconExW"},
    {294, "ExtractIconW"},
    {295, "FindExecutableA"},
    {296, "FindExecutableW"},
    {297, "FreeIconList"},
    {298, "GetCurrentProcessExplicitAppUserModelID"},
    {63, "GetFileNameFromBrowse"},
    {154, "ILAppendID"},
    {18, "ILClone"},
    {19, "ILCloneFirst"},
    {25, "ILCombine"},
    {157, "ILCreateFromPath"},
    {189, "ILCreateFromPathA"},
    {190, "ILCreateFromPathW"},
    {24, "ILFindChild"},
    {16, "ILFindLastID"},
    {155, "ILFree"},
    {153, "ILGetNext"},
    {152, "ILGetSize"},
    {21, "ILIsEqual"},
    {23, "ILIsParent"},
    {846, "ILLoadFromStreamEx"},
    {17, "ILRemoveLastID"},
    {27, "ILSaveToStream"},
    {299, "InitNetworkAddressControl"},
    {300, "InternalExtractIconListA"},
    {301, "InternalExtractIconListW"},
    {119, "IsLFNDrive"},
    {41, "IsLFNDriveA"},
    {42, "IsLFNDriveW"},
    {66, "IsNetDrive"},
    {680, "IsUserAnAdmin"},
    {302, "LaunchMSHelp_RunDLLW"},
    {81, "OpenAs_RunDLL"},
    {125, "OpenAs_RunDLLA"},
    {133, "OpenAs_RunDLLW"},
    {85, "OpenRegStream"},
    {303, "Options_RunDLL"},
    {304, "Options_RunDLLA"},
    {305, "Options_RunDLLW"},
    {171, "PathCleanupSpec"},
    {92, "PathGetShortPath"},
    {43, "PathIsExe"},
    {240, "PathIsSlowA"},
    {239, "PathIsSlowW"},
    {47, "PathMakeUniqueName"},
    {49, "PathQualify"},
    {51, "PathResolve"},
    {75, "PathYetAnotherMakeUniqueName"},
    {62, "PickIconDlg"},
    {13, "PifMgr_CloseProperties"},
    {10, "PifMgr_GetProperties"},
    {9, "PifMgr_OpenProperties"},
    {11, "PifMgr_SetProperties"},
    {135, "PrepareDiscForBurnRunDllW"},
    {138, "PrintersGetCommand_RunDLL"},
    {139, "PrintersGetCommand_RunDLLA"},
    {150, "PrintersGetCommand_RunDLLW"},
    {654, "ReadCabinetState"},
    {524, "RealDriveType"},
    {306, "RealShellExecuteA"},
    {307, "RealShellExecuteExA"},
    {308, "RealShellExecuteExW"},
    {309, "RealShellExecuteW"},
    {310, "RegenerateUserEnvironment"},
    {59, "RestartDialog"},
    {730, "RestartDialogEx"},
    {311, "RunAsNewUser_RunDLLW"},
    {312, "SHAddDefaultPropertiesByExt"},
    {167, "SHAddFromPropSheetExtArray"},
    {313, "SHAddToRecentDocs"},
    {196, "SHAlloc"},
    {314, "SHAppBarMessage"},
    {315, "SHAssocEnumHandlers"},
    {316, "SHAssocEnumHandlersForProtocolByApplication"},
    {317, "SHBindToFolderIDListParent"},
    {318, "SHBindToFolderIDListParentEx"},
    {319, "SHBindToObject"},
    {320, "SHBindToParent"},
    {321, "SHBrowseForFolder"},
    {322, "SHBrowseForFolderA"},
    {323, "SHBrowseForFolderW"},
    {147, "SHCLSIDFromString"},
    {644, "SHChangeNotification_Lock"},
    {645, "SHChangeNotification_Unlock"},
    {324, "SHChangeNotify"},
    {4, "SHChangeNotifyDeregister"},
    {2, "SHChangeNotifyRegister"},
    {325, "SHChangeNotifyRegisterThread"},
    {326, "SHChangeNotifySuspendResume"},
    {89, "SHCloneSpecialIDList"},
    {102, "SHCoCreateInstance"},
    {327, "SHCreateAssociationRegistration"},
    {328, "SHCreateDataObject"},
    {329, "SHCreateDefaultContextMenu"},
    {330, "SHCreateDefaultExtractIcon"},
    {331, "SHCreateDefaultPropertiesOp"},
    {165, "SHCreateDirectory"},
    {332, "SHCreateDirectoryExA"},
    {333, "SHCreateDirectoryExW"},
    {743, "SHCreateFileExtractIconW"},
    {334, "SHCreateItemFromIDList"},
    {335, "SHCreateItemFromParsingName"},
    {336, "SHCreateItemFromRelativeName"},
    {337, "SHCreateItemInKnownFolder"},
    {338, "SHCreateItemWithParent"},
    {339, "SHCreateLocalServerRunDll"},
    {340, "SHCreateProcessAsUserW"},
    {168, "SHCreatePropSheetExtArray"},
    {341, "SHCreateQueryCancelAutoPlayMoniker"},
    {256, "SHCreateShellFolderView"},
    {174, "SHCreateShellFolderViewEx"},
    {342, "SHCreateShellItem"},
    {343, "SHCreateShellItemArray"},
    {344, "SHCreateShellItemArrayFromDataObject"},
    {345, "SHCreateShellItemArrayFromIDLists"},
    {346, "SHCreateShellItemArrayFromShellItem"},
    {74, "SHCreateStdEnumFmtEtc"},
    {3, "SHDefExtractIconA"},
    {6, "SHDefExtractIconW"},
    {169, "SHDestroyPropSheetExtArray"},
    {88, "SHDoDragDrop"},
    {347, "SHEmptyRecycleBinA"},
    {348, "SHEmptyRecycleBinW"},
    {349, "SHEnableServiceObject"},
    {350, "SHEnumerateUnreadMailAccountsW"},
    {351, "SHEvaluateSystemCommandTemplate"},
    {352, "SHExtractIconsW"},
    {353, "SHFileOperation"},
    {354, "SHFileOperationA"},
    {355, "SHFileOperationW"},
    {90, "SHFindFiles"},
    {149, "SHFind_InitMenuPopup"},
    {526, "SHFlushSFCache"},
    {356, "SHFormatDrive"},
    {195, "SHFree"},
    {357, "SHFreeNameMappings"},
    {750, "SHGetAttributesFromDataObject"},
    {358, "SHGetDataFromIDListA"},
    {359, "SHGetDataFromIDListW"},
    {360, "SHGetDesktopFolder"},
    {361, "SHGetDiskFreeSpaceA"},
    {362, "SHGetDiskFreeSpaceExA"},
    {363, "SHGetDiskFreeSpaceExW"},
    {364, "SHGetDriveMedia"},
    {365, "SHGetFileInfo"},
    {366, "SHGetFileInfoA"},
    {367, "SHGetFileInfoW"},
    {368, "SHGetFolderLocation"},
    {369, "SHGetFolderPathA"},
    {370, "SHGetFolderPathAndSubDirA"},
    {371, "SHGetFolderPathAndSubDirW"},
    {372, "SHGetFolderPathEx"},
    {373, "SHGetFolderPathW"},
    {374, "SHGetIDListFromObject"},
    {375, "SHGetIconOverlayIndexA"},
    {376, "SHGetIconOverlayIndexW"},
    {727, "SHGetImageList"},
    {377, "SHGetInstanceExplorer"},
    {378, "SHGetItemFromDataObject"},
    {379, "SHGetItemFromObject"},
    {380, "SHGetKnownFolderIDList"},
    {381, "SHGetKnownFolderItem"},
    {382, "SHGetKnownFolderPath"},
    {383, "SHGetLocalizedName"},
    {384, "SHGetMalloc"},
    {385, "SHGetNameFromIDList"},
    {386, "SHGetNewLinkInfo"},
    {179, "SHGetNewLinkInfoA"},
    {180, "SHGetNewLinkInfoW"},
    {387, "SHGetPathFromIDList"},
    {388, "SHGetPathFromIDListA"},
    {389, "SHGetPathFromIDListEx"},
    {390, "SHGetPathFromIDListW"},
    {391, "SHGetPropertyStoreForWindow"},
    {392, "SHGetPropertyStoreFromIDList"},
    {393, "SHGetPropertyStoreFromParsingName"},
    {98, "SHGetRealIDL"},
    {709, "SHGetSetFolderCustomSettings"},
    {68, "SHGetSetSettings"},
    {394, "SHGetSettings"},
    {395, "SHGetSpecialFolderLocation"},
    {396, "SHGetSpecialFolderPathA"},
    {397, "SHGetSpecialFolderPathW"},
    {398, "SHGetStockIconInfo"},
    {399, "SHGetTemporaryPropertyForItem"},
    {400, "SHGetUnreadMailCountW"},
    {193, "SHHandleUpdateImage"},
    {199, "SHHelpShortcuts_RunDLL"},
    {206, "SHHelpShortcuts_RunDLLA"},
    {207, "SHHelpShortcuts_RunDLLW"},
    {28, "SHILCreateFromPath"},
    {401, "SHInvokePrinterCommandA"},
    {402, "SHInvokePrinterCommandW"},
    {403, "SHIsFileAvailableOffline"},
    {747, "SHLimitInputEdit"},
    {404, "SHLoadInProc"},
    {405, "SHLoadNonloadedIconOverlayIdentifiers"},
    {77, "SHMapPIDLToSystemImageListIndex"},
    {716, "SHMultiFileProperties"},
    {178, "SHObjectProperties"},
    {406, "SHOpenFolderAndSelectItems"},
    {80, "SHOpenPropSheetW"},
    {407, "SHOpenWithDialog"},
    {408, "SHParseDisplayName"},
    {409, "SHPathPrepareForWriteA"},
    {410, "SHPathPrepareForWriteW"},
    {685, "SHPropStgCreate"},
    {688, "SHPropStgReadMultiple"},
    {689, "SHPropStgWriteMultiple"},
    {411, "SHQueryRecycleBinA"},
    {412, "SHQueryRecycleBinW"},
    {413, "SHQueryUserNotificationState"},
    {414, "SHRemoveLocalizedName"},
    {170, "SHReplaceFromPropSheetExtArray"},
    {415, "SHResolveLibrary"},
    {100, "SHRestricted"},
    {416, "SHSetDefaultProperties"},
    {231, "SHSetFolderPathA"},
    {232, "SHSetFolderPathW"},
    {176, "SHSetInstanceExplorer"},
    {417, "SHSetKnownFolderPath"},
    {418, "SHSetLocalizedName"},
    {419, "SHSetTemporaryPropertyForItem"},
    {420, "SHSetUnreadMailCountW"},
    {73, "SHShellFolderView_Message"},
    {421, "SHShowManageLibraryUI"},
    {162, "SHSimpleIDListFromPath"},
    {14, "SHStartNetConnectionDialogW"},
    {245, "SHTestTokenMembership"},
    {191, "SHUpdateImageA"},
    {192, "SHUpdateImageW"},
    {422, "SHUpdateRecycleBinIcon"},
    {173, "SHValidateUNC"},
    {423, "SetCurrentProcessExplicitAppUserModelID"},
    {424, "SheChangeDirA"},
    {425, "SheChangeDirExW"},
    {426, "SheGetDirA"},
    {427, "SheSetCurDrive"},
    {428, "ShellAboutA"},
    {429, "ShellAboutW"},
    {430, "ShellExec_RunDLL"},
    {431, "ShellExec_RunDLLA"},
    {432, "ShellExec_RunDLLW"},
    {433, "ShellExecuteA"},
    {434, "ShellExecuteEx"},
    {435, "ShellExecuteExA"},
    {436, "ShellExecuteExW"},
    {437, "ShellExecuteW"},
    {438, "ShellHookProc"},
    {183, "ShellMessageBoxA"},
    {182, "ShellMessageBoxW"},
    {72, "Shell_GetCachedImageIndex"},
    {439, "Shell_GetCachedImageIndexA"},
    {440, "Shell_GetCachedImageIndexW"},
    {71, "Shell_GetImageLists"},
    {67, "Shell_MergeMenus"},
    {441, "Shell_NotifyIcon"},
    {442, "Shell_NotifyIconA"},
    {443, "Shell_NotifyIconGetRect"},
    {444, "Shell_NotifyIconW"},
    {103, "SignalFileOpen"},
    {682, "StgMakeUniqueName"},
    {445, "StrChrA"},
    {446, "StrChrIA"},
    {447, "StrChrIW"},
    {448, "StrChrW"},
    {449, "StrCmpNA"},
    {450, "StrCmpNIA"},
    {451, "StrCmpNIW"},
    {452, "StrCmpNW"},
    {453, "StrNCmpA"},
    {454, "StrNCmpIA"},
    {455, "StrNCmpIW"},
    {456, "StrNCmpW"},
    {457, "StrRChrA"},
    {458, "StrRChrIA"},
    {459, "StrRChrIW"},
    {460, "StrRChrW"},
    {461, "StrRStrA"},
    {462, "StrRStrIA"},
    {463, "StrRStrIW"},
    {464, "StrRStrW"},
    {465, "StrStrA"},
    {466, "StrStrIA"},
    {467, "StrStrIW"},
    {468, "StrStrW"},
    {469, "WOWShellExecute"},
    {470, "WaitForExplorerRestartW"},
    {164, "Win32DeleteFile"},
    {652, "WriteCabinetState"},
    {0, NULL}};
static Dw32Ordinal shfolder[] = {
    {1, "SHGetFolderPathA"},
    {2, "SHGetFolderPathW"},
    {0, NULL}};
static Dw32Ordinal shlwapi[] = {
    {500, "AssocCreate"},
    {501, "AssocGetPerceivedType"},
    {502, "AssocIsDangerous"},
    {503, "AssocQueryKeyA"},
    {504, "AssocQueryKeyW"},
    {579, "AssocQueryStringA"},
    {584, "AssocQueryStringByKeyA"},
    {585, "AssocQueryStringByKeyW"},
    {586, "AssocQueryStringW"},
    {587, "ChrCmpIA"},
    {588, "ChrCmpIW"},
    {589, "ColorAdjustLuma"},
    {590, "ColorHLSToRGB"},
    {591, "ColorRGBToHLS"},
    {168, "ConnectToConnectionPoint"},
    {569, "DelayLoadFailureHook"},
    {592, "DllGetVersion"},
    {14, "GetAcceptLanguagesA"},
    {15, "GetAcceptLanguagesW"},
    {593, "GetMenuPosFromID"},
    {594, "HashData"},
    {568, "IStream_Copy"},
    {184, "IStream_Read"},
    {512, "IStream_ReadPidl"},
    {596, "IStream_ReadStr"},
    {213, "IStream_Reset"},
    {214, "IStream_Size"},
    {212, "IStream_Write"},
    {513, "IStream_WritePidl"},
    {597, "IStream_WriteStr"},
    {169, "IUnknown_AtomicRelease"},
    {256, "IUnknown_GetSite"},
    {172, "IUnknown_GetWindow"},
    {176, "IUnknown_QueryService"},
    {199, "IUnknown_Set"},
    {174, "IUnknown_SetSite"},
    {595, "IntlStrEqWorkerA"},
    {607, "IntlStrEqWorkerW"},
    {608, "IsCharSpaceA"},
    {29, "IsCharSpaceW"},
    {553, "IsInternetESCEnabled"},
    {437, "IsOS"},
    {418, "MLFreeLibrary"},
    {377, "MLLoadLibraryA"},
    {378, "MLLoadLibraryW"},
    {1, "ParseURLA"},
    {2, "ParseURLW"},
    {609, "PathAddBackslashA"},
    {610, "PathAddBackslashW"},
    {612, "PathAddExtensionA"},
    {619, "PathAddExtensionW"},
    {620, "PathAppendA"},
    {622, "PathAppendW"},
    {623, "PathBuildRootA"},
    {624, "PathBuildRootW"},
    {625, "PathCanonicalizeA"},
    {646, "PathCanonicalizeW"},
    {647, "PathCombineA"},
    {648, "PathCombineW"},
    {649, "PathCommonPrefixA"},
    {650, "PathCommonPrefixW"},
    {651, "PathCompactPathA"},
    {652, "PathCompactPathExA"},
    {653, "PathCompactPathExW"},
    {654, "PathCompactPathW"},
    {655, "PathCreateFromUrlA"},
    {656, "PathCreateFromUrlAlloc"},
    {657, "PathCreateFromUrlW"},
    {658, "PathFileExistsA"},
    {659, "PathFileExistsW"},
    {660, "PathFindExtensionA"},
    {661, "PathFindExtensionW"},
    {662, "PathFindFileNameA"},
    {663, "PathFindFileNameW"},
    {664, "PathFindNextComponentA"},
    {665, "PathFindNextComponentW"},
    {666, "PathFindOnPathA"},
    {667, "PathFindOnPathW"},
    {668, "PathFindSuffixArrayA"},
    {669, "PathFindSuffixArrayW"},
    {670, "PathGetArgsA"},
    {671, "PathGetArgsW"},
    {672, "PathGetCharTypeA"},
    {673, "PathGetCharTypeW"},
    {674, "PathGetDriveNumberA"},
    {675, "PathGetDriveNumberW"},
    {676, "PathIsContentTypeA"},
    {677, "PathIsContentTypeW"},
    {678, "PathIsDirectoryA"},
    {679, "PathIsDirectoryEmptyA"},
    {680, "PathIsDirectoryEmptyW"},
    {681, "PathIsDirectoryW"},
    {682, "PathIsFileSpecA"},
    {683, "PathIsFileSpecW"},
    {684, "PathIsLFNFileSpecA"},
    {685, "PathIsLFNFileSpecW"},
    {686, "PathIsNetworkPathA"},
    {687, "PathIsNetworkPathW"},
    {688, "PathIsPrefixA"},
    {689, "PathIsPrefixW"},
    {690, "PathIsRelativeA"},
    {691, "PathIsRelativeW"},
    {692, "PathIsRootA"},
    {693, "PathIsRootW"},
    {694, "PathIsSameRootA"},
    {695, "PathIsSameRootW"},
    {696, "PathIsSystemFolderA"},
    {697, "PathIsSystemFolderW"},
    {698, "PathIsUNCA"},
    {699, "PathIsUNCServerA"},
    {700, "PathIsUNCServerShareA"},
    {701, "PathIsUNCServerShareW"},
    {702, "PathIsUNCServerW"},
    {703, "PathIsUNCW"},
    {704, "PathIsURLA"},
    {705, "PathIsURLW"},
    {706, "PathMakePrettyA"},
    {707, "PathMakePrettyW"},
    {708, "PathMakeSystemFolderA"},
    {709, "PathMakeSystemFolderW"},
    {710, "PathMatchSpecA"},
    {711, "PathMatchSpecExA"},
    {712, "PathMatchSpecExW"},
    {713, "PathMatchSpecW"},
    {714, "PathParseIconLocationA"},
    {715, "PathParseIconLocationW"},
    {716, "PathQuoteSpacesA"},
    {717, "PathQuoteSpacesW"},
    {718, "PathRelativePathToA"},
    {719, "PathRelativePathToW"},
    {720, "PathRemoveArgsA"},
    {721, "PathRemoveArgsW"},
    {722, "PathRemoveBackslashA"},
    {723, "PathRemoveBackslashW"},
    {724, "PathRemoveBlanksA"},
    {725, "PathRemoveBlanksW"},
    {726, "PathRemoveExtensionA"},
    {727, "PathRemoveExtensionW"},
    {728, "PathRemoveFileSpecA"},
    {729, "PathRemoveFileSpecW"},
    {730, "PathRenameExtensionA"},
    {731, "PathRenameExtensionW"},
    {732, "PathSearchAndQualifyA"},
    {733, "PathSearchAndQualifyW"},
    {734, "PathSetDlgItemPathA"},
    {735, "PathSetDlgItemPathW"},
    {736, "PathSkipRootA"},
    {737, "PathSkipRootW"},
    {738, "PathStripPathA"},
    {739, "PathStripPathW"},
    {740, "PathStripToRootA"},
    {741, "PathStripToRootW"},
    {742, "PathUnExpandEnvStringsA"},
    {743, "PathUnExpandEnvStringsW"},
    {744, "PathUndecorateA"},
    {745, "PathUndecorateW"},
    {746, "PathUnmakeSystemFolderA"},
    {747, "PathUnmakeSystemFolderW"},
    {748, "PathUnquoteSpacesA"},
    {749, "PathUnquoteSpacesW"},
    {219, "QISearch"},
    {7, "SHAllocShared"},
    {345, "SHAnsiToAnsi"},
    {215, "SHAnsiToUnicode"},
    {750, "SHAutoComplete"},
    {751, "SHCopyKeyA"},
    {752, "SHCopyKeyW"},
    {12, "SHCreateMemStream"},
    {753, "SHCreateShellPalette"},
    {754, "SHCreateStreamOnFileA"},
    {755, "SHCreateStreamOnFileEx"},
    {756, "SHCreateStreamOnFileW"},
    {757, "SHCreateStreamWrapper"},
    {16, "SHCreateThread"},
    {758, "SHCreateThreadRef"},
    {615, "SHCreateThreadWithHandle"},
    {759, "SHDeleteEmptyKeyA"},
    {760, "SHDeleteEmptyKeyW"},
    {761, "SHDeleteKeyA"},
    {762, "SHDeleteKeyW"},
    {763, "SHDeleteOrphanKeyA"},
    {764, "SHDeleteOrphanKeyW"},
    {765, "SHDeleteValueA"},
    {766, "SHDeleteValueW"},
    {767, "SHEnumKeyExA"},
    {768, "SHEnumKeyExW"},
    {769, "SHEnumValueA"},
    {770, "SHEnumValueW"},
    {353, "SHFormatDateTimeA"},
    {354, "SHFormatDateTimeW"},
    {10, "SHFreeShared"},
    {771, "SHGetInverseCMAP"},
    {772, "SHGetThreadRef"},
    {773, "SHGetValueA"},
    {774, "SHGetValueW"},
    {515, "SHGetViewStatePropertyBag"},
    {204, "SHIsChildOrSelf"},
    {775, "SHIsLowMemoryMachine"},
    {487, "SHLoadIndirectString"},
    {8, "SHLockShared"},
    {185, "SHMessageBoxCheckA"},
    {191, "SHMessageBoxCheckW"},
    {776, "SHOpenRegStream2A"},
    {777, "SHOpenRegStream2W"},
    {778, "SHOpenRegStreamA"},
    {779, "SHOpenRegStreamW"},
    {567, "SHPropertyBag_ReadStrAlloc"},
    {570, "SHPropertyBag_WriteBSTR"},
    {780, "SHQueryInfoKeyA"},
    {781, "SHQueryInfoKeyW"},
    {782, "SHQueryValueExA"},
    {783, "SHQueryValueExW"},
    {784, "SHRegCloseUSKey"},
    {785, "SHRegCreateUSKeyA"},
    {786, "SHRegCreateUSKeyW"},
    {787, "SHRegDeleteEmptyUSKeyA"},
    {788, "SHRegDeleteEmptyUSKeyW"},
    {789, "SHRegDeleteUSValueA"},
    {790, "SHRegDeleteUSValueW"},
    {791, "SHRegDuplicateHKey"},
    {792, "SHRegEnumUSKeyA"},
    {793, "SHRegEnumUSKeyW"},
    {794, "SHRegEnumUSValueA"},
    {795, "SHRegEnumUSValueW"},
    {796, "SHRegGetBoolUSValueA"},
    {797, "SHRegGetBoolUSValueW"},
    {280, "SHRegGetIntW"},
    {798, "SHRegGetPathA"},
    {799, "SHRegGetPathW"},
    {800, "SHRegGetUSValueA"},
    {801, "SHRegGetUSValueW"},
    {802, "SHRegGetValueA"},
    {803, "SHRegGetValueW"},
    {804, "SHRegOpenUSKeyA"},
    {805, "SHRegOpenUSKeyW"},
    {806, "SHRegQueryInfoUSKeyA"},
    {807, "SHRegQueryInfoUSKeyW"},
    {808, "SHRegQueryUSValueA"},
    {809, "SHRegQueryUSValueW"},
    {810, "SHRegSetPathA"},
    {811, "SHRegSetPathW"},
    {812, "SHRegSetUSValueA"},
    {813, "SHRegSetUSValueW"},
    {814, "SHRegWriteUSValueA"},
    {815, "SHRegWriteUSValueW"},
    {816, "SHRegisterValidateTemplate"},
    {817, "SHReleaseThreadRef"},
    {467, "SHRunIndirectRegClientCommand"},
    {432, "SHSendMessageBroadcastA"},
    {433, "SHSendMessageBroadcastW"},
    {818, "SHSetThreadRef"},
    {819, "SHSetValueA"},
    {820, "SHSetValueW"},
    {821, "SHSkipJunction"},
    {822, "SHStrDupA"},
    {823, "SHStrDupW"},
    {203, "SHStripMneumonicA"},
    {225, "SHStripMneumonicW"},
    {217, "SHUnicodeToAnsi"},
    {346, "SHUnicodeToUnicode"},
    {9, "SHUnlockShared"},
    {824, "ShellMessageBoxA"},
    {388, "ShellMessageBoxW"},
    {825, "StrCSpnA"},
    {826, "StrCSpnIA"},
    {827, "StrCSpnIW"},
    {828, "StrCSpnW"},
    {829, "StrCatBuffA"},
    {830, "StrCatBuffW"},
    {831, "StrCatChainW"},
    {832, "StrCatW"},
    {833, "StrChrA"},
    {834, "StrChrIA"},
    {835, "StrChrIW"},
    {836, "StrChrNIW"},
    {837, "StrChrNW"},
    {838, "StrChrW"},
    {155, "StrCmpCA"},
    {156, "StrCmpCW"},
    {157, "StrCmpICA"},
    {158, "StrCmpICW"},
    {839, "StrCmpIW"},
    {840, "StrCmpLogicalW"},
    {841, "StrCmpNA"},
    {151, "StrCmpNCA"},
    {152, "StrCmpNCW"},
    {842, "StrCmpNIA"},
    {153, "StrCmpNICA"},
    {154, "StrCmpNICW"},
    {843, "StrCmpNIW"},
    {844, "StrCmpNW"},
    {845, "StrCmpW"},
    {846, "StrCpyNW"},
    {847, "StrCpyW"},
    {848, "StrDupA"},
    {849, "StrDupW"},
    {850, "StrFormatByteSize64A"},
    {851, "StrFormatByteSizeA"},
    {852, "StrFormatByteSizeEx"},
    {853, "StrFormatByteSizeW"},
    {854, "StrFormatKBSizeA"},
    {855, "StrFormatKBSizeW"},
    {856, "StrFromTimeIntervalA"},
    {857, "StrFromTimeIntervalW"},
    {858, "StrIsIntlEqualA"},
    {859, "StrIsIntlEqualW"},
    {860, "StrNCatA"},
    {861, "StrNCatW"},
    {862, "StrPBrkA"},
    {863, "StrPBrkW"},
    {864, "StrRChrA"},
    {865, "StrRChrIA"},
    {866, "StrRChrIW"},
    {867, "StrRChrW"},
    {868, "StrRStrIA"},
    {869, "StrRStrIW"},
    {870, "StrRetToBSTR"},
    {871, "StrRetToBufA"},
    {872, "StrRetToBufW"},
    {873, "StrRetToStrA"},
    {874, "StrRetToStrW"},
    {875, "StrSpnA"},
    {876, "StrSpnW"},
    {877, "StrStrA"},
    {878, "StrStrIA"},
    {879, "StrStrIW"},
    {880, "StrStrNIW"},
    {881, "StrStrNW"},
    {882, "StrStrW"},
    {883, "StrToInt64ExA"},
    {884, "StrToInt64ExW"},
    {885, "StrToIntA"},
    {886, "StrToIntExA"},
    {887, "StrToIntExW"},
    {888, "StrToIntW"},
    {889, "StrTrimA"},
    {890, "StrTrimW"},
    {891, "UrlApplySchemeA"},
    {892, "UrlApplySchemeW"},
    {893, "UrlCanonicalizeA"},
    {894, "UrlCanonicalizeW"},
    {895, "UrlCombineA"},
    {896, "UrlCombineW"},
    {897, "UrlCompareA"},
    {898, "UrlCompareW"},
    {899, "UrlCreateFromPathA"},
    {900, "UrlCreateFromPathW"},
    {901, "UrlEscapeA"},
    {902, "UrlEscapeW"},
    {462, "UrlFixupW"},
    {903, "UrlGetLocationA"},
    {904, "UrlGetLocationW"},
    {905, "UrlGetPartA"},
    {906, "UrlGetPartW"},
    {907, "UrlHashA"},
    {908, "UrlHashW"},
    {909, "UrlIsA"},
    {910, "UrlIsNoHistoryA"},
    {911, "UrlIsNoHistoryW"},
    {912, "UrlIsOpaqueA"},
    {913, "UrlIsOpaqueW"},
    {914, "UrlIsW"},
    {915, "UrlUnescapeA"},
    {916, "UrlUnescapeW"},
    {276, "WhichPlatform"},
    {917, "wnsprintfA"},
    {918, "wnsprintfW"},
    {919, "wvnsprintfA"},
    {920, "wvnsprintfW"},
    {0, NULL}};
static Dw32Ordinal sisbkup[] = {
    {1, "SisCSFilesToBackupForLink"},
    {2, "SisCreateBackupStructure"},
    {3, "SisCreateRestoreStructure"},
    {4, "SisFreeAllocatedMemory"},
    {5, "SisFreeBackupStructure"},
    {6, "SisFreeRestoreStructure"},
    {7, "SisRestoredCommonStoreFile"},
    {8, "SisRestoredLink"},
    {0, NULL}};
static Dw32Ordinal slc[] = {
    {8, "SLClose"},
    {9, "SLConsumeRight"},
    {10, "SLConsumeWindowsRight"},
    {11, "SLDepositOfflineConfirmationId"},
    {12, "SLFireEvent"},
    {13, "SLGenerateOfflineInstallationId"},
    {14, "SLGetApplicationInformation"},
    {15, "SLGetGenuineInformation"},
    {16, "SLGetInstalledProductKeyIds"},
    {1, "SLGetInstalledSAMLicenseApplications"},
    {17, "SLGetLicense"},
    {18, "SLGetLicenseFileId"},
    {19, "SLGetLicenseInformation"},
    {20, "SLGetLicensingStatusInformation"},
    {21, "SLGetPKeyId"},
    {22, "SLGetPKeyInformation"},
    {23, "SLGetPolicyInformation"},
    {24, "SLGetPolicyInformationDWORD"},
    {25, "SLGetProductSkuInformation"},
    {2, "SLGetSAMLicense"},
    {26, "SLGetSLIDList"},
    {27, "SLGetServiceInformation"},
    {28, "SLGetWindowsInformation"},
    {29, "SLGetWindowsInformationDWORD"},
    {30, "SLInstallLicense"},
    {31, "SLInstallProofOfPurchase"},
    {3, "SLInstallSAMLicense"},
    {32, "SLIsWindowsGenuineLocal"},
    {33, "SLOpen"},
    {34, "SLReArmWindows"},
    {35, "SLRegisterEvent"},
    {36, "SLRegisterWindowsEvent"},
    {37, "SLSetCurrentProductKey"},
    {38, "SLSetGenuineInformation"},
    {39, "SLUninstallLicense"},
    {40, "SLUninstallProofOfPurchase"},
    {4, "SLUninstallSAMLicense"},
    {41, "SLUnregisterEvent"},
    {42, "SLUnregisterWindowsEvent"},
    {5, "SLpCheckProductKey"},
    {6, "SLpGetGenuineLocal"},
    {7, "SLpUpdateComponentTokens"},
    {0, NULL}};
static Dw32Ordinal slcext[] = {
    {1, "SLAcquireGenuineTicket"},
    {2, "SLActivateProduct"},
    {3, "SLGetPackageProductKey"},
    {4, "SLGetPackageProperties"},
    {5, "SLGetPackageToken"},
    {6, "SLGetReferralInformation"},
    {7, "SLGetServerStatus"},
    {8, "SLInstallPackage"},
    {9, "SLUninstallPackage"},
    {0, NULL}};
static Dw32Ordinal slwga[] = {
    {228, "SLIsGenuineLocal"},
    {0, NULL}};
static Dw32Ordinal snmpapi[] = {
    {1, "SnmpSvcAddrIsIpx"},
    {2, "SnmpSvcAddrToSocket"},
    {3, "SnmpSvcGetEnterpriseOID"},
    {4, "SnmpSvcGetUptime"},
    {5, "SnmpSvcGetUptimeFromTime"},
    {6, "SnmpSvcInitUptime"},
    {7, "SnmpSvcSetLogLevel"},
    {8, "SnmpSvcSetLogType"},
    {9, "SnmpTfxClose"},
    {10, "SnmpTfxOpen"},
    {11, "SnmpTfxQuery"},
    {12, "SnmpUtilAnsiToUnicode"},
    {13, "SnmpUtilAsnAnyCpy"},
    {14, "SnmpUtilAsnAnyFree"},
    {15, "SnmpUtilDbgPrint"},
    {16, "SnmpUtilIdsToA"},
    {17, "SnmpUtilMemAlloc"},
    {18, "SnmpUtilMemFree"},
    {19, "SnmpUtilMemReAlloc"},
    {20, "SnmpUtilOctetsCmp"},
    {21, "SnmpUtilOctetsCpy"},
    {22, "SnmpUtilOctetsFree"},
    {23, "SnmpUtilOctetsNCmp"},
    {24, "SnmpUtilOidAppend"},
    {25, "SnmpUtilOidCmp"},
    {26, "SnmpUtilOidCpy"},
    {27, "SnmpUtilOidFree"},
    {28, "SnmpUtilOidNCmp"},
    {29, "SnmpUtilOidToA"},
    {30, "SnmpUtilPrintAsnAny"},
    {31, "SnmpUtilPrintOid"},
    {32, "SnmpUtilUTF8ToUnicode"},
    {33, "SnmpUtilUnicodeToAnsi"},
    {34, "SnmpUtilUnicodeToUTF8"},
    {35, "SnmpUtilVarBindCpy"},
    {36, "SnmpUtilVarBindFree"},
    {37, "SnmpUtilVarBindListCpy"},
    {38, "SnmpUtilVarBindListFree"},
    {0, NULL}};
static Dw32Ordinal srclient[] = {
    {1, "DisableSR"},
    {2, "DisableSRInternal"},
    {3, "EnableSR"},
    {4, "EnableSREx"},
    {5, "EnableSRInternal"},
    {6, "SRNewSystemId"},
    {7, "SRRemoveRestorePoint"},
    {8, "SRSetRestorePointA"},
    {9, "SRSetRestorePointInternal"},
    {10, "SRSetRestorePointW"},
    {11, "SetSRStateAfterSetup"},
    {0, NULL}};
static Dw32Ordinal sti[] = {
    {1, "??0BUFFER@@QAE@I@Z"},
    {2, "??0BUFFER_CHAIN@@QAE@XZ"},
    {3, "??0BUFFER_CHAIN_ITEM@@QAE@I@Z"},
    {4, "??1BUFFER@@QAE@XZ"},
    {5, "??1BUFFER_CHAIN@@QAE@XZ"},
    {6, "??1BUFFER_CHAIN_ITEM@@QAE@XZ"},
    {7, "??_FBUFFER@@QAEXXZ"},
    {8, "??_FBUFFER_CHAIN_ITEM@@QAEXXZ"},
    {9, "?QueryPtr@BUFFER@@QBEPAXXZ"},
    {10, "?QuerySize@BUFFER@@QBEIXZ"},
    {11, "?QueryUsed@BUFFER_CHAIN_ITEM@@QBEKXZ"},
    {12, "?SetUsed@BUFFER_CHAIN_ITEM@@QAEXK@Z"},
    {13, "DllCanUnloadNow"},
    {14, "DllGetClassObject"},
    {15, "DllRegisterServer"},
    {16, "DllUnregisterServer"},
    {17, "GetProxyDllInfo"},
    {18, "MigrateRegisteredSTIAppsForWIAEvents"},
    {19, "SelectDeviceDialog2"},
    {20, "StiCreateInstance"},
    {21, "StiCreateInstanceW"},
    {0, NULL}};
static Dw32Ordinal structuredquery[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal tapi32[] = {
    {1, "GetTapi16CallbackMsg"},
    {2, "LAddrParamsInited"},
    {3, "LOpenDialAsst"},
    {4, "LocWizardDlgProc"},
    {5, "MMCAddProvider"},
    {6, "MMCConfigProvider"},
    {7, "MMCGetAvailableProviders"},
    {8, "MMCGetDeviceFlags"},
    {9, "MMCGetLineInfo"},
    {10, "MMCGetLineStatus"},
    {11, "MMCGetPhoneInfo"},
    {12, "MMCGetPhoneStatus"},
    {13, "MMCGetProviderList"},
    {14, "MMCGetServerConfig"},
    {15, "MMCInitialize"},
    {16, "MMCRemoveProvider"},
    {17, "MMCSetLineInfo"},
    {18, "MMCSetPhoneInfo"},
    {19, "MMCSetServerConfig"},
    {20, "MMCShutdown"},
    {21, "NonAsyncEventThread"},
    {22, "TAPIWndProc"},
    {23, "TUISPIDLLCallback"},
    {24, "internalConfig"},
    {25, "internalCreateDefLocation"},
    {26, "internalNewLocationW"},
    {27, "internalPerformance"},
    {28, "internalRemoveLocation"},
    {29, "internalRenameLocationW"},
    {30, "lineAccept"},
    {31, "lineAddProvider"},
    {32, "lineAddProviderA"},
    {33, "lineAddProviderW"},
    {34, "lineAddToConference"},
    {35, "lineAgentSpecific"},
    {36, "lineAnswer"},
    {37, "lineBlindTransfer"},
    {38, "lineBlindTransferA"},
    {39, "lineBlindTransferW"},
    {40, "lineClose"},
    {41, "lineCompleteCall"},
    {42, "lineCompleteTransfer"},
    {43, "lineConfigDialog"},
    {44, "lineConfigDialogA"},
    {45, "lineConfigDialogEdit"},
    {46, "lineConfigDialogEditA"},
    {47, "lineConfigDialogEditW"},
    {48, "lineConfigDialogW"},
    {49, "lineConfigProvider"},
    {50, "lineCreateAgentA"},
    {51, "lineCreateAgentSessionA"},
    {52, "lineCreateAgentSessionW"},
    {53, "lineCreateAgentW"},
    {54, "lineDeallocateCall"},
    {55, "lineDevSpecific"},
    {56, "lineDevSpecificFeature"},
    {57, "lineDial"},
    {58, "lineDialA"},
    {59, "lineDialW"},
    {60, "lineDrop"},
    {61, "lineForward"},
    {62, "lineForwardA"},
    {63, "lineForwardW"},
    {64, "lineGatherDigits"},
    {65, "lineGatherDigitsA"},
    {66, "lineGatherDigitsW"},
    {67, "lineGenerateDigits"},
    {68, "lineGenerateDigitsA"},
    {69, "lineGenerateDigitsW"},
    {70, "lineGenerateTone"},
    {71, "lineGetAddressCaps"},
    {72, "lineGetAddressCapsA"},
    {73, "lineGetAddressCapsW"},
    {74, "lineGetAddressID"},
    {75, "lineGetAddressIDA"},
    {76, "lineGetAddressIDW"},
    {77, "lineGetAddressStatus"},
    {78, "lineGetAddressStatusA"},
    {79, "lineGetAddressStatusW"},
    {80, "lineGetAgentActivityListA"},
    {81, "lineGetAgentActivityListW"},
    {82, "lineGetAgentCapsA"},
    {83, "lineGetAgentCapsW"},
    {84, "lineGetAgentGroupListA"},
    {85, "lineGetAgentGroupListW"},
    {86, "lineGetAgentInfo"},
    {87, "lineGetAgentSessionInfo"},
    {88, "lineGetAgentSessionList"},
    {89, "lineGetAgentStatusA"},
    {90, "lineGetAgentStatusW"},
    {91, "lineGetAppPriority"},
    {92, "lineGetAppPriorityA"},
    {93, "lineGetAppPriorityW"},
    {94, "lineGetCallInfo"},
    {95, "lineGetCallInfoA"},
    {96, "lineGetCallInfoW"},
    {97, "lineGetCallStatus"},
    {98, "lineGetConfRelatedCalls"},
    {99, "lineGetCountry"},
    {100, "lineGetCountryA"},
    {101, "lineGetCountryW"},
    {102, "lineGetDevCaps"},
    {103, "lineGetDevCapsA"},
    {104, "lineGetDevCapsW"},
    {105, "lineGetDevConfig"},
    {106, "lineGetDevConfigA"},
    {107, "lineGetDevConfigW"},
    {108, "lineGetGroupListA"},
    {109, "lineGetGroupListW"},
    {110, "lineGetID"},
    {111, "lineGetIDA"},
    {112, "lineGetIDW"},
    {113, "lineGetIcon"},
    {114, "lineGetIconA"},
    {115, "lineGetIconW"},
    {116, "lineGetLineDevStatus"},
    {117, "lineGetLineDevStatusA"},
    {118, "lineGetLineDevStatusW"},
    {119, "lineGetMessage"},
    {120, "lineGetNewCalls"},
    {121, "lineGetNumRings"},
    {122, "lineGetProviderList"},
    {123, "lineGetProviderListA"},
    {124, "lineGetProviderListW"},
    {125, "lineGetProxyStatus"},
    {126, "lineGetQueueInfo"},
    {127, "lineGetQueueListA"},
    {128, "lineGetQueueListW"},
    {129, "lineGetRequest"},
    {130, "lineGetRequestA"},
    {131, "lineGetRequestW"},
    {132, "lineGetStatusMessages"},
    {133, "lineGetTranslateCaps"},
    {134, "lineGetTranslateCapsA"},
    {135, "lineGetTranslateCapsW"},
    {136, "lineHandoff"},
    {137, "lineHandoffA"},
    {138, "lineHandoffW"},
    {139, "lineHold"},
    {140, "lineInitialize"},
    {141, "lineInitializeExA"},
    {142, "lineInitializeExW"},
    {143, "lineMakeCall"},
    {144, "lineMakeCallA"},
    {145, "lineMakeCallW"},
    {146, "lineMonitorDigits"},
    {147, "lineMonitorMedia"},
    {148, "lineMonitorTones"},
    {149, "lineNegotiateAPIVersion"},
    {150, "lineNegotiateExtVersion"},
    {151, "lineOpen"},
    {152, "lineOpenA"},
    {153, "lineOpenW"},
    {154, "linePark"},
    {155, "lineParkA"},
    {156, "lineParkW"},
    {157, "linePickup"},
    {158, "linePickupA"},
    {159, "linePickupW"},
    {160, "linePrepareAddToConference"},
    {161, "linePrepareAddToConferenceA"},
    {162, "linePrepareAddToConferenceW"},
    {163, "lineProxyMessage"},
    {164, "lineProxyResponse"},
    {165, "lineRedirect"},
    {166, "lineRedirectA"},
    {167, "lineRedirectW"},
    {168, "lineRegisterRequestRecipient"},
    {169, "lineReleaseUserUserInfo"},
    {170, "lineRemoveFromConference"},
    {171, "lineRemoveProvider"},
    {172, "lineSecureCall"},
    {173, "lineSendUserUserInfo"},
    {174, "lineSetAgentActivity"},
    {175, "lineSetAgentGroup"},
    {176, "lineSetAgentMeasurementPeriod"},
    {177, "lineSetAgentSessionState"},
    {178, "lineSetAgentState"},
    {179, "lineSetAgentStateEx"},
    {180, "lineSetAppPriority"},
    {181, "lineSetAppPriorityA"},
    {182, "lineSetAppPriorityW"},
    {183, "lineSetAppSpecific"},
    {184, "lineSetCallData"},
    {185, "lineSetCallParams"},
    {186, "lineSetCallPrivilege"},
    {187, "lineSetCallQualityOfService"},
    {188, "lineSetCallTreatment"},
    {189, "lineSetCurrentLocation"},
    {190, "lineSetDevConfig"},
    {191, "lineSetDevConfigA"},
    {192, "lineSetDevConfigW"},
    {193, "lineSetLineDevStatus"},
    {194, "lineSetMediaControl"},
    {195, "lineSetMediaMode"},
    {196, "lineSetNumRings"},
    {197, "lineSetQueueMeasurementPeriod"},
    {198, "lineSetStatusMessages"},
    {199, "lineSetTerminal"},
    {200, "lineSetTollList"},
    {201, "lineSetTollListA"},
    {202, "lineSetTollListW"},
    {203, "lineSetupConference"},
    {204, "lineSetupConferenceA"},
    {205, "lineSetupConferenceW"},
    {206, "lineSetupTransfer"},
    {207, "lineSetupTransferA"},
    {208, "lineSetupTransferW"},
    {209, "lineShutdown"},
    {210, "lineSwapHold"},
    {211, "lineTranslateAddress"},
    {212, "lineTranslateAddressA"},
    {213, "lineTranslateAddressW"},
    {214, "lineTranslateDialog"},
    {215, "lineTranslateDialogA"},
    {216, "lineTranslateDialogW"},
    {217, "lineUncompleteCall"},
    {218, "lineUnhold"},
    {219, "lineUnpark"},
    {220, "lineUnparkA"},
    {221, "lineUnparkW"},
    {222, "phoneClose"},
    {223, "phoneConfigDialog"},
    {224, "phoneConfigDialogA"},
    {225, "phoneConfigDialogW"},
    {226, "phoneDevSpecific"},
    {227, "phoneGetButtonInfo"},
    {228, "phoneGetButtonInfoA"},
    {229, "phoneGetButtonInfoW"},
    {230, "phoneGetData"},
    {231, "phoneGetDevCaps"},
    {232, "phoneGetDevCapsA"},
    {233, "phoneGetDevCapsW"},
    {234, "phoneGetDisplay"},
    {235, "phoneGetGain"},
    {236, "phoneGetHookSwitch"},
    {237, "phoneGetID"},
    {238, "phoneGetIDA"},
    {239, "phoneGetIDW"},
    {240, "phoneGetIcon"},
    {241, "phoneGetIconA"},
    {242, "phoneGetIconW"},
    {243, "phoneGetLamp"},
    {244, "phoneGetMessage"},
    {245, "phoneGetRing"},
    {246, "phoneGetStatus"},
    {247, "phoneGetStatusA"},
    {248, "phoneGetStatusMessages"},
    {249, "phoneGetStatusW"},
    {250, "phoneGetVolume"},
    {251, "phoneInitialize"},
    {252, "phoneInitializeExA"},
    {253, "phoneInitializeExW"},
    {254, "phoneNegotiateAPIVersion"},
    {255, "phoneNegotiateExtVersion"},
    {256, "phoneOpen"},
    {257, "phoneSetButtonInfo"},
    {258, "phoneSetButtonInfoA"},
    {259, "phoneSetButtonInfoW"},
    {260, "phoneSetData"},
    {261, "phoneSetDisplay"},
    {262, "phoneSetGain"},
    {263, "phoneSetHookSwitch"},
    {264, "phoneSetLamp"},
    {265, "phoneSetRing"},
    {266, "phoneSetStatusMessages"},
    {267, "phoneSetVolume"},
    {268, "phoneShutdown"},
    {269, "tapiGetLocationInfo"},
    {270, "tapiGetLocationInfoA"},
    {271, "tapiGetLocationInfoW"},
    {272, "tapiRequestDrop"},
    {273, "tapiRequestMakeCall"},
    {274, "tapiRequestMakeCallA"},
    {275, "tapiRequestMakeCallW"},
    {276, "tapiRequestMediaCall"},
    {277, "tapiRequestMediaCallA"},
    {278, "tapiRequestMediaCallW"},
    {0, NULL}};
static Dw32Ordinal taskschd[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal tbs[] = {
    {1, "Tbsi_Context_Create"},
    {2, "Tbsi_Get_TCG_Log"},
    {3, "Tbsi_Physical_Presence_Command"},
    {4, "Tbsip_Cancel_Commands"},
    {5, "Tbsip_Context_Close"},
    {6, "Tbsip_Submit_Command"},
    {0, NULL}};
static Dw32Ordinal tdh[] = {
    {1, "TdhEnumerateProviderFieldInformation"},
    {2, "TdhEnumerateProviderFilters"},
    {3, "TdhEnumerateProviders"},
    {4, "TdhEnumerateRemoteWBEMProviderFieldInformation"},
    {5, "TdhEnumerateRemoteWBEMProviders"},
    {6, "TdhFormatProperty"},
    {7, "TdhGetAllEventsInformation"},
    {8, "TdhGetEventInformation"},
    {9, "TdhGetEventMapInformation"},
    {10, "TdhGetProperty"},
    {11, "TdhGetPropertyOffsetAndSize"},
    {12, "TdhGetPropertySize"},
    {13, "TdhLoadManifest"},
    {14, "TdhQueryProviderFieldInformation"},
    {15, "TdhQueryRemoteWBEMProviderFieldInformation"},
    {16, "TdhUnloadManifest"},
    {0, NULL}};
static Dw32Ordinal traffic[] = {
    {1, "TcAddFilter"},
    {2, "TcAddFlow"},
    {3, "TcCloseInterface"},
    {4, "TcDeleteFilter"},
    {5, "TcDeleteFlow"},
    {6, "TcDeregisterClient"},
    {7, "TcEnumerateFlows"},
    {8, "TcEnumerateInterfaces"},
    {9, "TcGetFlowNameA"},
    {10, "TcGetFlowNameW"},
    {11, "TcGetInterfaceList"},
    {12, "TcModifyFlow"},
    {13, "TcOpenInterfaceA"},
    {14, "TcOpenInterfaceW"},
    {15, "TcQueryFlowA"},
    {16, "TcQueryFlowW"},
    {17, "TcQueryInterface"},
    {18, "TcRegisterClient"},
    {19, "TcSetFlowA"},
    {20, "TcSetFlowW"},
    {21, "TcSetInterface"},
    {22, "TcSetSocketFlow"},
    {0, NULL}};
static Dw32Ordinal uiautomationcore[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {5, "DockPattern_SetDockPosition"},
    {6, "ExpandCollapsePattern_Collapse"},
    {7, "ExpandCollapsePattern_Expand"},
    {8, "GridPattern_GetItem"},
    {9, "InvokePattern_Invoke"},
    {10, "ItemContainerPattern_FindItemByProperty"},
    {11, "LegacyIAccessiblePattern_DoDefaultAction"},
    {12, "LegacyIAccessiblePattern_GetIAccessible"},
    {13, "LegacyIAccessiblePattern_Select"},
    {14, "LegacyIAccessiblePattern_SetValue"},
    {15, "MultipleViewPattern_GetViewName"},
    {16, "MultipleViewPattern_SetCurrentView"},
    {17, "RangeValuePattern_SetValue"},
    {18, "ScrollItemPattern_ScrollIntoView"},
    {19, "ScrollPattern_Scroll"},
    {20, "ScrollPattern_SetScrollPercent"},
    {21, "SelectionItemPattern_AddToSelection"},
    {22, "SelectionItemPattern_RemoveFromSelection"},
    {23, "SelectionItemPattern_Select"},
    {24, "SynchronizedInputPattern_Cancel"},
    {25, "SynchronizedInputPattern_StartListening"},
    {26, "TextPattern_GetSelection"},
    {27, "TextPattern_GetVisibleRanges"},
    {28, "TextPattern_RangeFromChild"},
    {29, "TextPattern_RangeFromPoint"},
    {30, "TextPattern_get_DocumentRange"},
    {31, "TextPattern_get_SupportedTextSelection"},
    {32, "TextRange_AddToSelection"},
    {33, "TextRange_Clone"},
    {34, "TextRange_Compare"},
    {35, "TextRange_CompareEndpoints"},
    {36, "TextRange_ExpandToEnclosingUnit"},
    {37, "TextRange_FindAttribute"},
    {38, "TextRange_FindText"},
    {39, "TextRange_GetAttributeValue"},
    {40, "TextRange_GetBoundingRectangles"},
    {41, "TextRange_GetChildren"},
    {42, "TextRange_GetEnclosingElement"},
    {43, "TextRange_GetText"},
    {44, "TextRange_Move"},
    {45, "TextRange_MoveEndpointByRange"},
    {46, "TextRange_MoveEndpointByUnit"},
    {47, "TextRange_RemoveFromSelection"},
    {48, "TextRange_ScrollIntoView"},
    {49, "TextRange_Select"},
    {50, "TogglePattern_Toggle"},
    {51, "TransformPattern_Move"},
    {52, "TransformPattern_Resize"},
    {53, "TransformPattern_Rotate"},
    {54, "UiaAddEvent"},
    {55, "UiaClientsAreListening"},
    {56, "UiaEventAddWindow"},
    {57, "UiaEventRemoveWindow"},
    {58, "UiaFind"},
    {59, "UiaGetErrorDescription"},
    {60, "UiaGetPatternProvider"},
    {61, "UiaGetPropertyValue"},
    {62, "UiaGetReservedMixedAttributeValue"},
    {63, "UiaGetReservedNotSupportedValue"},
    {64, "UiaGetRootNode"},
    {65, "UiaGetRuntimeId"},
    {66, "UiaGetUpdatedCache"},
    {67, "UiaHPatternObjectFromVariant"},
    {68, "UiaHTextRangeFromVariant"},
    {69, "UiaHUiaNodeFromVariant"},
    {70, "UiaHasServerSideProvider"},
    {71, "UiaHostProviderFromHwnd"},
    {72, "UiaLookupId"},
    {73, "UiaNavigate"},
    {74, "UiaNodeFromFocus"},
    {75, "UiaNodeFromHandle"},
    {76, "UiaNodeFromPoint"},
    {77, "UiaNodeFromProvider"},
    {78, "UiaNodeRelease"},
    {79, "UiaPatternRelease"},
    {80, "UiaRaiseAsyncContentLoadedEvent"},
    {81, "UiaRaiseAutomationEvent"},
    {82, "UiaRaiseAutomationPropertyChangedEvent"},
    {83, "UiaRaiseStructureChangedEvent"},
    {84, "UiaRegisterProviderCallback"},
    {85, "UiaRemoveEvent"},
    {86, "UiaReturnRawElementProvider"},
    {87, "UiaSetFocus"},
    {88, "UiaTextRangeRelease"},
    {89, "ValuePattern_SetValue"},
    {90, "VirtualizedItemPattern_Realize"},
    {91, "WindowPattern_Close"},
    {92, "WindowPattern_SetWindowVisualState"},
    {93, "WindowPattern_WaitForInputIdle"},
    {0, NULL}};
static Dw32Ordinal url[] = {
    {102, "AddMIMEFileTypesPS"},
    {103, "AutodialHookCallback"},
    {104, "FileProtocolHandler"},
    {105, "FileProtocolHandlerA"},
    {106, "InetIsOffline"},
    {107, "MIMEAssociationDialogA"},
    {108, "MIMEAssociationDialogW"},
    {109, "MailToProtocolHandler"},
    {110, "MailToProtocolHandlerA"},
    {111, "OpenURL"},
    {112, "OpenURLA"},
    {113, "TelnetProtocolHandler"},
    {114, "TelnetProtocolHandlerA"},
    {115, "TranslateURLA"},
    {116, "TranslateURLW"},
    {117, "URLAssociationDialogA"},
    {118, "URLAssociationDialogW"},
    {0, NULL}};
static Dw32Ordinal urlmon[] = {
    {109, "AsyncGetClassBits"},
    {110, "AsyncInstallDistributionUnit"},
    {117, "BindAsyncMoniker"},
    {118, "CDLGetLongPathNameA"},
    {119, "CDLGetLongPathNameW"},
    {120, "CoGetClassObjectFromURL"},
    {121, "CoInstall"},
    {122, "CoInternetCanonicalizeIUri"},
    {123, "CoInternetCombineIUri"},
    {124, "CoInternetCombineUrl"},
    {125, "CoInternetCombineUrlEx"},
    {126, "CoInternetCompareUrl"},
    {127, "CoInternetCreateSecurityManager"},
    {128, "CoInternetCreateZoneManager"},
    {129, "CoInternetFeatureSettingsChanged"},
    {130, "CoInternetGetProtocolFlags"},
    {131, "CoInternetGetSecurityUrl"},
    {132, "CoInternetGetSecurityUrlEx"},
    {133, "CoInternetGetSession"},
    {134, "CoInternetIsFeatureEnabled"},
    {135, "CoInternetIsFeatureEnabledForIUri"},
    {136, "CoInternetIsFeatureEnabledForUrl"},
    {137, "CoInternetIsFeatureZoneElevationEnabled"},
    {138, "CoInternetParseIUri"},
    {139, "CoInternetParseUrl"},
    {140, "CoInternetQueryInfo"},
    {141, "CoInternetSetFeatureEnabled"},
    {142, "CompareSecurityIds"},
    {143, "CompatFlagsFromClsid"},
    {144, "CopyBindInfo"},
    {145, "CopyStgMedium"},
    {146, "CreateAsyncBindCtx"},
    {147, "CreateAsyncBindCtxEx"},
    {148, "CreateFormatEnumerator"},
    {149, "CreateIUriBuilder"},
    {150, "CreateURLMoniker"},
    {152, "CreateURLMonikerEx"},
    {151, "CreateURLMonikerEx2"},
    {153, "CreateUri"},
    {154, "CreateUriFromMultiByteString"},
    {155, "CreateUriPriv"},
    {156, "CreateUriWithFragment"},
    {157, "DllCanUnloadNow"},
    {158, "DllGetClassObject"},
    {159, "DllInstall"},
    {160, "DllRegisterServer"},
    {161, "DllRegisterServerEx"},
    {162, "DllUnregisterServer"},
    {163, "Extract"},
    {164, "FaultInIEFeature"},
    {165, "FindMediaType"},
    {166, "FindMediaTypeClass"},
    {167, "FindMimeFromData"},
    {168, "GetAddSitesFileUrl"},
    {169, "GetClassFileOrMime"},
    {170, "GetClassURL"},
    {171, "GetComponentIDFromCLSSPEC"},
    {172, "GetIDNFlagsForUri"},
    {173, "GetIUriPriv"},
    {174, "GetLabelsFromNamedHost"},
    {175, "GetMarkOfTheWeb"},
    {176, "GetPortFromUrlScheme"},
    {177, "GetPropertyFromName"},
    {178, "GetPropertyName"},
    {179, "GetSoftwareUpdateInfo"},
    {180, "GetUrlmonThreadNotificationHwnd"},
    {181, "HlinkGoBack"},
    {182, "HlinkGoForward"},
    {183, "HlinkNavigateMoniker"},
    {184, "HlinkNavigateString"},
    {185, "HlinkSimpleNavigateToMoniker"},
    {186, "HlinkSimpleNavigateToString"},
    {187, "IEInstallScope"},
    {188, "InstallFlash"},
    {189, "IntlPercentEncodeNormalize"},
    {190, "IsAsyncMoniker"},
    {191, "IsDWORDProperty"},
    {192, "IsIntranetAvailable"},
    {193, "IsJITInProgress"},
    {194, "IsLoggingEnabledA"},
    {195, "IsLoggingEnabledW"},
    {196, "IsStringProperty"},
    {197, "IsValidURL"},
    {198, "MkParseDisplayNameEx"},
    {199, "ObtainUserAgentString"},
    {200, "PrivateCoInstall"},
    {201, "QueryAssociations"},
    {202, "QueryClsidAssociation"},
    {203, "RegisterBindStatusCallback"},
    {204, "RegisterFormatEnumerator"},
    {205, "RegisterMediaTypeClass"},
    {206, "RegisterMediaTypes"},
    {207, "ReleaseBindInfo"},
    {208, "ResetUrlmonLanguageData"},
    {209, "RevokeBindStatusCallback"},
    {210, "RevokeFormatEnumerator"},
    {211, "SetSoftwareUpdateAdvertisementState"},
    {212, "ShouldDisplayPunycodeForUri"},
    {213, "ShouldShowIntranetWarningSecband"},
    {214, "ShowTrustAlertDialog"},
    {215, "URLDownloadA"},
    {216, "URLDownloadToCacheFileA"},
    {217, "URLDownloadToCacheFileW"},
    {218, "URLDownloadToFileA"},
    {219, "URLDownloadToFileW"},
    {220, "URLDownloadW"},
    {221, "URLOpenBlockingStreamA"},
    {222, "URLOpenBlockingStreamW"},
    {223, "URLOpenPullStreamA"},
    {224, "URLOpenPullStreamW"},
    {225, "URLOpenStreamA"},
    {226, "URLOpenStreamW"},
    {227, "UrlMkBuildVersion"},
    {228, "UrlMkGetSessionOption"},
    {229, "UrlMkSetSessionOption"},
    {230, "WriteHitLogging"},
    {231, "ZonesReInit"},
    {0, NULL}};
static Dw32Ordinal user32[] = {
    {1502, "ActivateKeyboardLayout"},
    {1503, "AddClipboardFormatListener"},
    {1504, "AdjustWindowRect"},
    {1505, "AdjustWindowRectEx"},
    {1506, "AlignRects"},
    {1507, "AllowForegroundActivation"},
    {1508, "AllowSetForegroundWindow"},
    {1509, "AnimateWindow"},
    {1510, "AnyPopup"},
    {1511, "AppendMenuA"},
    {1512, "AppendMenuW"},
    {1513, "ArrangeIconicWindows"},
    {1514, "AttachThreadInput"},
    {1515, "BeginDeferWindowPos"},
    {1516, "BeginPaint"},
    {1517, "BlockInput"},
    {1518, "BringWindowToTop"},
    {1519, "BroadcastSystemMessage"},
    {1520, "BroadcastSystemMessageA"},
    {1521, "BroadcastSystemMessageExA"},
    {1522, "BroadcastSystemMessageExW"},
    {1523, "BroadcastSystemMessageW"},
    {1524, "BuildReasonArray"},
    {1525, "CalcMenuBar"},
    {1526, "CalculatePopupWindowPosition"},
    {1527, "CallMsgFilter"},
    {1528, "CallMsgFilterA"},
    {1529, "CallMsgFilterW"},
    {1530, "CallNextHookEx"},
    {1531, "CallWindowProcA"},
    {1532, "CallWindowProcW"},
    {1533, "CancelShutdown"},
    {1534, "CascadeChildWindows"},
    {1535, "CascadeWindows"},
    {1536, "ChangeClipboardChain"},
    {1537, "ChangeDisplaySettingsA"},
    {1538, "ChangeDisplaySettingsExA"},
    {1539, "ChangeDisplaySettingsExW"},
    {1540, "ChangeDisplaySettingsW"},
    {1541, "ChangeMenuA"},
    {1542, "ChangeMenuW"},
    {1543, "ChangeWindowMessageFilter"},
    {1544, "ChangeWindowMessageFilterEx"},
    {1545, "CharLowerA"},
    {1546, "CharLowerBuffA"},
    {1547, "CharLowerBuffW"},
    {1548, "CharLowerW"},
    {1549, "CharNextA"},
    {1557, "CharNextExA"},
    {1558, "CharNextW"},
    {1559, "CharPrevA"},
    {1560, "CharPrevExA"},
    {1561, "CharPrevW"},
    {1562, "CharToOemA"},
    {1563, "CharToOemBuffA"},
    {1564, "CharToOemBuffW"},
    {1565, "CharToOemW"},
    {1566, "CharUpperA"},
    {1567, "CharUpperBuffA"},
    {1568, "CharUpperBuffW"},
    {1569, "CharUpperW"},
    {1570, "CheckDesktopByThreadId"},
    {1571, "CheckDlgButton"},
    {1572, "CheckMenuItem"},
    {1573, "CheckMenuRadioItem"},
    {1574, "CheckRadioButton"},
    {1575, "CheckWindowThreadDesktop"},
    {1576, "ChildWindowFromPoint"},
    {1577, "ChildWindowFromPointEx"},
    {1578, "CliImmSetHotKey"},
    {1579, "ClientThreadSetup"},
    {1580, "ClientToScreen"},
    {1581, "ClipCursor"},
    {1582, "CloseClipboard"},
    {1583, "CloseDesktop"},
    {1584, "CloseGestureInfoHandle"},
    {1585, "CloseTouchInputHandle"},
    {1586, "CloseWindow"},
    {1587, "CloseWindowStation"},
    {1588, "ConsoleControl"},
    {1589, "ControlMagnification"},
    {1590, "CopyAcceleratorTableA"},
    {1591, "CopyAcceleratorTableW"},
    {1592, "CopyIcon"},
    {1593, "CopyImage"},
    {1594, "CopyRect"},
    {1595, "CountClipboardFormats"},
    {1596, "CreateAcceleratorTableA"},
    {1597, "CreateAcceleratorTableW"},
    {1598, "CreateCaret"},
    {1599, "CreateCursor"},
    {1600, "CreateDesktopA"},
    {1601, "CreateDesktopExA"},
    {1602, "CreateDesktopExW"},
    {1603, "CreateDesktopW"},
    {1604, "CreateDialogIndirectParamA"},
    {1605, "CreateDialogIndirectParamAorW"},
    {1606, "CreateDialogIndirectParamW"},
    {1607, "CreateDialogParamA"},
    {1608, "CreateDialogParamW"},
    {1609, "CreateIcon"},
    {1610, "CreateIconFromResource"},
    {1611, "CreateIconFromResourceEx"},
    {1612, "CreateIconIndirect"},
    {1613, "CreateMDIWindowA"},
    {1614, "CreateMDIWindowW"},
    {1615, "CreateMenu"},
    {1616, "CreatePopupMenu"},
    {1617, "CreateSystemThreads"},
    {1618, "CreateWindowExA"},
    {1619, "CreateWindowExW"},
    {1620, "CreateWindowStationA"},
    {1621, "CreateWindowStationW"},
    {1622, "CsrBroadcastSystemMessageExW"},
    {1623, "CtxInitUser32"},
    {1624, "DdeAbandonTransaction"},
    {1625, "DdeAccessData"},
    {1626, "DdeAddData"},
    {1627, "DdeClientTransaction"},
    {1628, "DdeCmpStringHandles"},
    {1629, "DdeConnect"},
    {1630, "DdeConnectList"},
    {1631, "DdeCreateDataHandle"},
    {1632, "DdeCreateStringHandleA"},
    {1633, "DdeCreateStringHandleW"},
    {1634, "DdeDisconnect"},
    {1635, "DdeDisconnectList"},
    {1636, "DdeEnableCallback"},
    {1637, "DdeFreeDataHandle"},
    {1638, "DdeFreeStringHandle"},
    {1639, "DdeGetData"},
    {1640, "DdeGetLastError"},
    {1641, "DdeGetQualityOfService"},
    {1642, "DdeImpersonateClient"},
    {1643, "DdeInitializeA"},
    {1644, "DdeInitializeW"},
    {1645, "DdeKeepStringHandle"},
    {1646, "DdeNameService"},
    {1647, "DdePostAdvise"},
    {1648, "DdeQueryConvInfo"},
    {1649, "DdeQueryNextServer"},
    {1650, "DdeQueryStringA"},
    {1651, "DdeQueryStringW"},
    {1652, "DdeReconnect"},
    {1653, "DdeSetQualityOfService"},
    {1654, "DdeSetUserHandle"},
    {1655, "DdeUnaccessData"},
    {1656, "DdeUninitialize"},
    {1657, "DefDlgProcA"},
    {1658, "DefDlgProcW"},
    {1659, "DefFrameProcA"},
    {1660, "DefFrameProcW"},
    {1661, "DefMDIChildProcA"},
    {1662, "DefMDIChildProcW"},
    {1663, "DefRawInputProc"},
    {1664, "DefWindowProcA"},
    {1665, "DefWindowProcW"},
    {1666, "DeferWindowPos"},
    {1667, "DeleteMenu"},
    {1668, "DeregisterShellHookWindow"},
    {1669, "DestroyAcceleratorTable"},
    {1670, "DestroyCaret"},
    {1671, "DestroyCursor"},
    {1672, "DestroyIcon"},
    {1673, "DestroyMenu"},
    {1674, "DestroyReasons"},
    {1675, "DestroyWindow"},
    {1676, "DeviceEventWorker"},
    {1677, "DialogBoxIndirectParamA"},
    {1678, "DialogBoxIndirectParamAorW"},
    {1679, "DialogBoxIndirectParamW"},
    {1680, "DialogBoxParamA"},
    {1681, "DialogBoxParamW"},
    {1682, "DisableProcessWindowsGhosting"},
    {1683, "DispatchMessageA"},
    {1684, "DispatchMessageW"},
    {1685, "DisplayConfigGetDeviceInfo"},
    {1686, "DisplayConfigSetDeviceInfo"},
    {1687, "DisplayExitWindowsWarnings"},
    {1688, "DlgDirListA"},
    {1689, "DlgDirListComboBoxA"},
    {1690, "DlgDirListComboBoxW"},
    {1691, "DlgDirListW"},
    {1692, "DlgDirSelectComboBoxExA"},
    {1693, "DlgDirSelectComboBoxExW"},
    {1694, "DlgDirSelectExA"},
    {1695, "DlgDirSelectExW"},
    {1696, "DoSoundConnect"},
    {1697, "DoSoundDisconnect"},
    {1698, "DragDetect"},
    {1699, "DragObject"},
    {1700, "DrawAnimatedRects"},
    {1701, "DrawCaption"},
    {1702, "DrawCaptionTempA"},
    {1703, "DrawCaptionTempW"},
    {1704, "DrawEdge"},
    {1705, "DrawFocusRect"},
    {1706, "DrawFrame"},
    {1707, "DrawFrameControl"},
    {1708, "DrawIcon"},
    {1709, "DrawIconEx"},
    {1710, "DrawMenuBar"},
    {1711, "DrawMenuBarTemp"},
    {1712, "DrawStateA"},
    {1713, "DrawStateW"},
    {1714, "DrawTextA"},
    {1715, "DrawTextExA"},
    {1716, "DrawTextExW"},
    {1717, "DrawTextW"},
    {1718, "DwmGetDxSharedSurface"},
    {1719, "DwmStartRedirection"},
    {1720, "DwmStopRedirection"},
    {1721, "EditWndProc"},
    {1722, "EmptyClipboard"},
    {1723, "EnableMenuItem"},
    {1724, "EnableScrollBar"},
    {1725, "EnableWindow"},
    {1726, "EndDeferWindowPos"},
    {1727, "EndDialog"},
    {1728, "EndMenu"},
    {1729, "EndPaint"},
    {1730, "EndTask"},
    {1731, "EnterReaderModeHelper"},
    {1732, "EnumChildWindows"},
    {1733, "EnumClipboardFormats"},
    {1734, "EnumDesktopWindows"},
    {1735, "EnumDesktopsA"},
    {1736, "EnumDesktopsW"},
    {1737, "EnumDisplayDevicesA"},
    {1738, "EnumDisplayDevicesW"},
    {1739, "EnumDisplayMonitors"},
    {1740, "EnumDisplaySettingsA"},
    {1741, "EnumDisplaySettingsExA"},
    {1742, "EnumDisplaySettingsExW"},
    {1743, "EnumDisplaySettingsW"},
    {1744, "EnumPropsA"},
    {1745, "EnumPropsExA"},
    {1746, "EnumPropsExW"},
    {1747, "EnumPropsW"},
    {1748, "EnumThreadWindows"},
    {1749, "EnumWindowStationsA"},
    {1750, "EnumWindowStationsW"},
    {1751, "EnumWindows"},
    {1752, "EqualRect"},
    {1753, "ExcludeUpdateRgn"},
    {1754, "ExitWindowsEx"},
    {1755, "FillRect"},
    {1756, "FindWindowA"},
    {1757, "FindWindowExA"},
    {1758, "FindWindowExW"},
    {1759, "FindWindowW"},
    {1760, "FlashWindow"},
    {1761, "FlashWindowEx"},
    {1762, "FrameRect"},
    {1763, "FreeDDElParam"},
    {1764, "FrostCrashedWindow"},
    {1765, "GetActiveWindow"},
    {1766, "GetAltTabInfo"},
    {1767, "GetAltTabInfoA"},
    {1768, "GetAltTabInfoW"},
    {1769, "GetAncestor"},
    {1771, "GetAppCompatFlags"},
    {1770, "GetAppCompatFlags2"},
    {1772, "GetAsyncKeyState"},
    {1773, "GetCapture"},
    {1774, "GetCaretBlinkTime"},
    {1775, "GetCaretPos"},
    {1776, "GetClassInfoA"},
    {1777, "GetClassInfoExA"},
    {1778, "GetClassInfoExW"},
    {1779, "GetClassInfoW"},
    {1780, "GetClassLongA"},
    {1781, "GetClassLongW"},
    {1782, "GetClassNameA"},
    {1783, "GetClassNameW"},
    {1784, "GetClassWord"},
    {1785, "GetClientRect"},
    {1786, "GetClipCursor"},
    {1787, "GetClipboardData"},
    {1788, "GetClipboardFormatNameA"},
    {1789, "GetClipboardFormatNameW"},
    {1790, "GetClipboardOwner"},
    {1791, "GetClipboardSequenceNumber"},
    {1792, "GetClipboardViewer"},
    {1793, "GetComboBoxInfo"},
    {1794, "GetCursor"},
    {1795, "GetCursorFrameInfo"},
    {1796, "GetCursorInfo"},
    {1797, "GetCursorPos"},
    {1798, "GetDC"},
    {1799, "GetDCEx"},
    {1800, "GetDesktopWindow"},
    {1801, "GetDialogBaseUnits"},
    {1802, "GetDisplayConfigBufferSizes"},
    {1803, "GetDlgCtrlID"},
    {1804, "GetDlgItem"},
    {1805, "GetDlgItemInt"},
    {1806, "GetDlgItemTextA"},
    {1807, "GetDlgItemTextW"},
    {1808, "GetDoubleClickTime"},
    {1809, "GetFocus"},
    {1810, "GetForegroundWindow"},
    {1811, "GetGUIThreadInfo"},
    {1812, "GetGestureConfig"},
    {1813, "GetGestureExtraArgs"},
    {1814, "GetGestureInfo"},
    {1815, "GetGuiResources"},
    {1816, "GetIconInfo"},
    {1817, "GetIconInfoExA"},
    {1818, "GetIconInfoExW"},
    {1819, "GetInputDesktop"},
    {1820, "GetInputLocaleInfo"},
    {1821, "GetInputState"},
    {1822, "GetInternalWindowPos"},
    {1823, "GetKBCodePage"},
    {1824, "GetKeyNameTextA"},
    {1825, "GetKeyNameTextW"},
    {1826, "GetKeyState"},
    {1827, "GetKeyboardLayout"},
    {1828, "GetKeyboardLayoutList"},
    {1829, "GetKeyboardLayoutNameA"},
    {1830, "GetKeyboardLayoutNameW"},
    {1831, "GetKeyboardState"},
    {1832, "GetKeyboardType"},
    {1833, "GetLastActivePopup"},
    {1834, "GetLastInputInfo"},
    {1835, "GetLayeredWindowAttributes"},
    {1836, "GetListBoxInfo"},
    {1837, "GetMagnificationDesktopColorEffect"},
    {1838, "GetMagnificationDesktopMagnification"},
    {1839, "GetMagnificationLensCtxInformation"},
    {1840, "GetMenu"},
    {1841, "GetMenuBarInfo"},
    {1842, "GetMenuCheckMarkDimensions"},
    {1843, "GetMenuContextHelpId"},
    {1844, "GetMenuDefaultItem"},
    {1845, "GetMenuInfo"},
    {1846, "GetMenuItemCount"},
    {1847, "GetMenuItemID"},
    {1848, "GetMenuItemInfoA"},
    {1849, "GetMenuItemInfoW"},
    {1850, "GetMenuItemRect"},
    {1851, "GetMenuState"},
    {1852, "GetMenuStringA"},
    {1853, "GetMenuStringW"},
    {1854, "GetMessageA"},
    {1855, "GetMessageExtraInfo"},
    {1856, "GetMessagePos"},
    {1857, "GetMessageTime"},
    {1858, "GetMessageW"},
    {1859, "GetMonitorInfoA"},
    {1860, "GetMonitorInfoW"},
    {1861, "GetMouseMovePointsEx"},
    {1862, "GetNextDlgGroupItem"},
    {1863, "GetNextDlgTabItem"},
    {1864, "GetOpenClipboardWindow"},
    {1865, "GetParent"},
    {1866, "GetPhysicalCursorPos"},
    {1867, "GetPriorityClipboardFormat"},
    {1868, "GetProcessDefaultLayout"},
    {1869, "GetProcessWindowStation"},
    {1870, "GetProgmanWindow"},
    {1871, "GetPropA"},
    {1872, "GetPropW"},
    {1873, "GetQueueStatus"},
    {1874, "GetRawInputBuffer"},
    {1875, "GetRawInputData"},
    {1876, "GetRawInputDeviceInfoA"},
    {1877, "GetRawInputDeviceInfoW"},
    {1878, "GetRawInputDeviceList"},
    {1879, "GetReasonTitleFromReasonCode"},
    {1880, "GetRegisteredRawInputDevices"},
    {1881, "GetScrollBarInfo"},
    {1882, "GetScrollInfo"},
    {1883, "GetScrollPos"},
    {1884, "GetScrollRange"},
    {1885, "GetSendMessageReceiver"},
    {1886, "GetShellWindow"},
    {1887, "GetSubMenu"},
    {1888, "GetSysColor"},
    {1889, "GetSysColorBrush"},
    {1890, "GetSystemMenu"},
    {1891, "GetSystemMetrics"},
    {1892, "GetTabbedTextExtentA"},
    {1893, "GetTabbedTextExtentW"},
    {1894, "GetTaskmanWindow"},
    {1895, "GetThreadDesktop"},
    {1896, "GetTitleBarInfo"},
    {1897, "GetTopLevelWindow"},
    {1898, "GetTopWindow"},
    {1899, "GetTouchInputInfo"},
    {1900, "GetUpdateRect"},
    {1901, "GetUpdateRgn"},
    {1902, "GetUpdatedClipboardFormats"},
    {1903, "GetUserObjectInformationA"},
    {1904, "GetUserObjectInformationW"},
    {1905, "GetUserObjectSecurity"},
    {1906, "GetWinStationInfo"},
    {1907, "GetWindow"},
    {1908, "GetWindowCompositionAttribute"},
    {1909, "GetWindowCompositionInfo"},
    {1910, "GetWindowContextHelpId"},
    {1911, "GetWindowDC"},
    {1912, "GetWindowDisplayAffinity"},
    {1913, "GetWindowInfo"},
    {1914, "GetWindowLongA"},
    {1915, "GetWindowLongW"},
    {1916, "GetWindowMinimizeRect"},
    {1917, "GetWindowModuleFileName"},
    {1918, "GetWindowModuleFileNameA"},
    {1919, "GetWindowModuleFileNameW"},
    {1920, "GetWindowPlacement"},
    {1921, "GetWindowRect"},
    {1922, "GetWindowRgn"},
    {1923, "GetWindowRgnBox"},
    {1924, "GetWindowRgnEx"},
    {1925, "GetWindowTextA"},
    {1926, "GetWindowTextLengthA"},
    {1927, "GetWindowTextLengthW"},
    {1928, "GetWindowTextW"},
    {1929, "GetWindowThreadProcessId"},
    {1930, "GetWindowWord"},
    {1931, "GhostWindowFromHungWindow"},
    {1932, "GrayStringA"},
    {1933, "GrayStringW"},
    {1934, "HideCaret"},
    {1935, "HiliteMenuItem"},
    {1936, "HungWindowFromGhostWindow"},
    {1937, "IMPGetIMEA"},
    {1938, "IMPGetIMEW"},
    {1939, "IMPQueryIMEA"},
    {1940, "IMPQueryIMEW"},
    {1941, "IMPSetIMEA"},
    {1942, "IMPSetIMEW"},
    {1943, "ImpersonateDdeClientWindow"},
    {1944, "InSendMessage"},
    {1945, "InSendMessageEx"},
    {1946, "InflateRect"},
    {1947, "InitializeLpkHooks"},
    {1948, "InsertMenuA"},
    {1949, "InsertMenuItemA"},
    {1950, "InsertMenuItemW"},
    {1951, "InsertMenuW"},
    {1952, "InternalGetWindowIcon"},
    {1953, "InternalGetWindowText"},
    {1954, "IntersectRect"},
    {1955, "InvalidateRect"},
    {1956, "InvalidateRgn"},
    {1957, "InvertRect"},
    {1958, "IsCharAlphaA"},
    {1959, "IsCharAlphaNumericA"},
    {1960, "IsCharAlphaNumericW"},
    {1961, "IsCharAlphaW"},
    {1962, "IsCharLowerA"},
    {1963, "IsCharLowerW"},
    {1964, "IsCharUpperA"},
    {1965, "IsCharUpperW"},
    {1966, "IsChild"},
    {1967, "IsClipboardFormatAvailable"},
    {1968, "IsDialogMessage"},
    {1969, "IsDialogMessageA"},
    {1970, "IsDialogMessageW"},
    {1971, "IsDlgButtonChecked"},
    {1972, "IsGUIThread"},
    {1973, "IsHungAppWindow"},
    {1974, "IsIconic"},
    {1975, "IsMenu"},
    {1976, "IsProcessDPIAware"},
    {1977, "IsRectEmpty"},
    {1978, "IsSETEnabled"},
    {1979, "IsServerSideWindow"},
    {1980, "IsThreadDesktopComposited"},
    {1981, "IsTopLevelWindow"},
    {1982, "IsTouchWindow"},
    {1983, "IsWinEventHookInstalled"},
    {1984, "IsWindow"},
    {1985, "IsWindowEnabled"},
    {1986, "IsWindowInDestroy"},
    {1987, "IsWindowRedirectedForPrint"},
    {1988, "IsWindowUnicode"},
    {1989, "IsWindowVisible"},
    {1990, "IsWow64Message"},
    {1991, "IsZoomed"},
    {1992, "KillTimer"},
    {1993, "LoadAcceleratorsA"},
    {1994, "LoadAcceleratorsW"},
    {1995, "LoadBitmapA"},
    {1996, "LoadBitmapW"},
    {1997, "LoadCursorA"},
    {1998, "LoadCursorFromFileA"},
    {1999, "LoadCursorFromFileW"},
    {2003, "LoadCursorW"},
    {2004, "LoadIconA"},
    {2006, "LoadIconW"},
    {2007, "LoadImageA"},
    {2008, "LoadImageW"},
    {2009, "LoadKeyboardLayoutA"},
    {2010, "LoadKeyboardLayoutEx"},
    {2011, "LoadKeyboardLayoutW"},
    {2012, "LoadLocalFonts"},
    {2013, "LoadMenuA"},
    {2014, "LoadMenuIndirectA"},
    {2015, "LoadMenuIndirectW"},
    {2016, "LoadMenuW"},
    {2017, "LoadRemoteFonts"},
    {2018, "LoadStringA"},
    {2019, "LoadStringW"},
    {2020, "LockSetForegroundWindow"},
    {2021, "LockWindowStation"},
    {2022, "LockWindowUpdate"},
    {2023, "LockWorkStation"},
    {2024, "LogicalToPhysicalPoint"},
    {2025, "LookupIconIdFromDirectory"},
    {2026, "LookupIconIdFromDirectoryEx"},
    {2027, "MBToWCSEx"},
    {2028, "MB_GetString"},
    {2029, "MapDialogRect"},
    {2030, "MapVirtualKeyA"},
    {2031, "MapVirtualKeyExA"},
    {2032, "MapVirtualKeyExW"},
    {2033, "MapVirtualKeyW"},
    {2034, "MapWindowPoints"},
    {2035, "MenuItemFromPoint"},
    {2036, "MenuWindowProcA"},
    {2037, "MenuWindowProcW"},
    {2038, "MessageBeep"},
    {2039, "MessageBoxA"},
    {2040, "MessageBoxExA"},
    {2041, "MessageBoxExW"},
    {2042, "MessageBoxIndirectA"},
    {2043, "MessageBoxIndirectW"},
    {2044, "MessageBoxTimeoutA"},
    {2045, "MessageBoxTimeoutW"},
    {2046, "MessageBoxW"},
    {2047, "ModifyMenuA"},
    {2048, "ModifyMenuW"},
    {2049, "MonitorFromPoint"},
    {2050, "MonitorFromRect"},
    {2051, "MonitorFromWindow"},
    {2052, "MoveWindow"},
    {2053, "MsgWaitForMultipleObjects"},
    {2054, "MsgWaitForMultipleObjectsEx"},
    {2055, "NotifyOverlayWindow"},
    {2056, "NotifyWinEvent"},
    {2057, "OemKeyScan"},
    {2058, "OemToCharA"},
    {2059, "OemToCharBuffA"},
    {2060, "OemToCharBuffW"},
    {2061, "OemToCharW"},
    {2062, "OffsetRect"},
    {2063, "OpenClipboard"},
    {2064, "OpenDesktopA"},
    {2065, "OpenDesktopW"},
    {2066, "OpenIcon"},
    {2067, "OpenInputDesktop"},
    {2068, "OpenThreadDesktop"},
    {2069, "OpenWindowStationA"},
    {2070, "OpenWindowStationW"},
    {2071, "PackDDElParam"},
    {2072, "PaintDesktop"},
    {2073, "PaintMenuBar"},
    {2074, "PaintMonitor"},
    {2075, "PeekMessageA"},
    {2076, "PeekMessageW"},
    {2077, "PhysicalToLogicalPoint"},
    {2078, "PostMessageA"},
    {2079, "PostMessageW"},
    {2080, "PostQuitMessage"},
    {2081, "PostThreadMessageA"},
    {2082, "PostThreadMessageW"},
    {2083, "PrintWindow"},
    {2084, "PrivateExtractIconExA"},
    {2085, "PrivateExtractIconExW"},
    {2086, "PrivateExtractIconsA"},
    {2087, "PrivateExtractIconsW"},
    {2088, "PrivateRegisterICSProc"},
    {2089, "PtInRect"},
    {2090, "QueryDisplayConfig"},
    {2091, "QuerySendMessage"},
    {2092, "RealChildWindowFromPoint"},
    {2093, "RealGetWindowClass"},
    {2094, "RealGetWindowClassA"},
    {2095, "RealGetWindowClassW"},
    {2096, "ReasonCodeNeedsBugID"},
    {2097, "ReasonCodeNeedsComment"},
    {2098, "RecordShutdownReason"},
    {2099, "RedrawWindow"},
    {2100, "RegisterClassA"},
    {2101, "RegisterClassExA"},
    {2102, "RegisterClassExW"},
    {2103, "RegisterClassW"},
    {2104, "RegisterClipboardFormatA"},
    {2105, "RegisterClipboardFormatW"},
    {2106, "RegisterDeviceNotificationA"},
    {2107, "RegisterDeviceNotificationW"},
    {2108, "RegisterErrorReportingDialog"},
    {2109, "RegisterFrostWindow"},
    {2110, "RegisterGhostWindow"},
    {2111, "RegisterHotKey"},
    {2112, "RegisterLogonProcess"},
    {2113, "RegisterMessagePumpHook"},
    {2114, "RegisterPowerSettingNotification"},
    {2115, "RegisterRawInputDevices"},
    {2116, "RegisterServicesProcess"},
    {2117, "RegisterSessionPort"},
    {2118, "RegisterShellHookWindow"},
    {2119, "RegisterSystemThread"},
    {2120, "RegisterTasklist"},
    {2121, "RegisterTouchWindow"},
    {2122, "RegisterUserApiHook"},
    {2123, "RegisterWindowMessageA"},
    {2124, "RegisterWindowMessageW"},
    {2125, "ReleaseCapture"},
    {2126, "ReleaseDC"},
    {2127, "RemoveClipboardFormatListener"},
    {2128, "RemoveMenu"},
    {2129, "RemovePropA"},
    {2130, "RemovePropW"},
    {2131, "ReplyMessage"},
    {2132, "ResolveDesktopForWOW"},
    {2133, "ReuseDDElParam"},
    {2134, "ScreenToClient"},
    {2135, "ScrollChildren"},
    {2136, "ScrollDC"},
    {2137, "ScrollWindow"},
    {2138, "ScrollWindowEx"},
    {2139, "SendDlgItemMessageA"},
    {2140, "SendDlgItemMessageW"},
    {2141, "SendIMEMessageExA"},
    {2142, "SendIMEMessageExW"},
    {2143, "SendInput"},
    {2144, "SendMessageA"},
    {2145, "SendMessageCallbackA"},
    {2146, "SendMessageCallbackW"},
    {2147, "SendMessageTimeoutA"},
    {2148, "SendMessageTimeoutW"},
    {2149, "SendMessageW"},
    {2150, "SendNotifyMessageA"},
    {2151, "SendNotifyMessageW"},
    {2152, "SetActiveWindow"},
    {2153, "SetCapture"},
    {2154, "SetCaretBlinkTime"},
    {2155, "SetCaretPos"},
    {2156, "SetClassLongA"},
    {2157, "SetClassLongW"},
    {2158, "SetClassWord"},
    {2159, "SetClipboardData"},
    {2160, "SetClipboardViewer"},
    {2161, "SetCursor"},
    {2162, "SetCursorContents"},
    {2163, "SetCursorPos"},
    {2164, "SetDebugErrorLevel"},
    {2165, "SetDeskWallpaper"},
    {2166, "SetDisplayConfig"},
    {2167, "SetDlgItemInt"},
    {2168, "SetDlgItemTextA"},
    {2169, "SetDlgItemTextW"},
    {2170, "SetDoubleClickTime"},
    {2171, "SetFocus"},
    {2172, "SetForegroundWindow"},
    {2173, "SetGestureConfig"},
    {2174, "SetInternalWindowPos"},
    {2175, "SetKeyboardState"},
    {2176, "SetLastErrorEx"},
    {2177, "SetLayeredWindowAttributes"},
    {2178, "SetMagnificationDesktopColorEffect"},
    {2179, "SetMagnificationDesktopMagnification"},
    {2180, "SetMagnificationLensCtxInformation"},
    {2181, "SetMenu"},
    {2182, "SetMenuContextHelpId"},
    {2183, "SetMenuDefaultItem"},
    {2184, "SetMenuInfo"},
    {2185, "SetMenuItemBitmaps"},
    {2186, "SetMenuItemInfoA"},
    {2187, "SetMenuItemInfoW"},
    {2188, "SetMessageExtraInfo"},
    {2189, "SetMessageQueue"},
    {2190, "SetMirrorRendering"},
    {2191, "SetParent"},
    {2192, "SetPhysicalCursorPos"},
    {2193, "SetProcessDPIAware"},
    {2194, "SetProcessDefaultLayout"},
    {2195, "SetProcessWindowStation"},
    {2196, "SetProgmanWindow"},
    {2197, "SetPropA"},
    {2198, "SetPropW"},
    {2199, "SetRect"},
    {2200, "SetRectEmpty"},
    {2201, "SetScrollInfo"},
    {2202, "SetScrollPos"},
    {2203, "SetScrollRange"},
    {2204, "SetShellWindow"},
    {2205, "SetShellWindowEx"},
    {2206, "SetSysColors"},
    {2207, "SetSysColorsTemp"},
    {2208, "SetSystemCursor"},
    {2209, "SetSystemMenu"},
    {2210, "SetTaskmanWindow"},
    {2211, "SetThreadDesktop"},
    {2212, "SetTimer"},
    {2213, "SetUserObjectInformationA"},
    {2214, "SetUserObjectInformationW"},
    {2215, "SetUserObjectSecurity"},
    {2216, "SetWinEventHook"},
    {2217, "SetWindowCompositionAttribute"},
    {2218, "SetWindowContextHelpId"},
    {2219, "SetWindowDisplayAffinity"},
    {2220, "SetWindowLongA"},
    {2221, "SetWindowLongW"},
    {2222, "SetWindowPlacement"},
    {2223, "SetWindowPos"},
    {2224, "SetWindowRgn"},
    {2225, "SetWindowRgnEx"},
    {2226, "SetWindowStationUser"},
    {2227, "SetWindowTextA"},
    {2228, "SetWindowTextW"},
    {2229, "SetWindowWord"},
    {2230, "SetWindowsHookA"},
    {2231, "SetWindowsHookExA"},
    {2232, "SetWindowsHookExW"},
    {2233, "SetWindowsHookW"},
    {2234, "SfmDxBindSwapChain"},
    {2235, "SfmDxGetSwapChainStats"},
    {2236, "SfmDxOpenSwapChain"},
    {2237, "SfmDxQuerySwapChainBindingStatus"},
    {2238, "SfmDxReleaseSwapChain"},
    {2239, "SfmDxReportPendingBindingsToDwm"},
    {2240, "SfmDxSetSwapChainBindingStatus"},
    {2241, "SfmDxSetSwapChainStats"},
    {2242, "ShowCaret"},
    {2243, "ShowCursor"},
    {2244, "ShowOwnedPopups"},
    {2245, "ShowScrollBar"},
    {2246, "ShowStartGlass"},
    {2247, "ShowSystemCursor"},
    {2248, "ShowWindow"},
    {2249, "ShowWindowAsync"},
    {2250, "ShutdownBlockReasonCreate"},
    {2251, "ShutdownBlockReasonDestroy"},
    {2252, "ShutdownBlockReasonQuery"},
    {2253, "SoftModalMessageBox"},
    {2254, "SoundSentry"},
    {2255, "SubtractRect"},
    {2256, "SwapMouseButton"},
    {2257, "SwitchDesktop"},
    {2258, "SwitchDesktopWithFade"},
    {2259, "SwitchToThisWindow"},
    {2260, "SystemParametersInfoA"},
    {2261, "SystemParametersInfoW"},
    {2262, "TabbedTextOutA"},
    {2263, "TabbedTextOutW"},
    {2264, "TileChildWindows"},
    {2265, "TileWindows"},
    {2266, "ToAscii"},
    {2267, "ToAsciiEx"},
    {2268, "ToUnicode"},
    {2269, "ToUnicodeEx"},
    {2270, "TrackMouseEvent"},
    {2271, "TrackPopupMenu"},
    {2272, "TrackPopupMenuEx"},
    {2273, "TranslateAccelerator"},
    {2274, "TranslateAcceleratorA"},
    {2275, "TranslateAcceleratorW"},
    {2276, "TranslateMDISysAccel"},
    {2277, "TranslateMessage"},
    {2278, "TranslateMessageEx"},
    {2279, "UnhookWinEvent"},
    {2280, "UnhookWindowsHook"},
    {2281, "UnhookWindowsHookEx"},
    {2282, "UnionRect"},
    {2283, "UnloadKeyboardLayout"},
    {2284, "UnlockWindowStation"},
    {2285, "UnpackDDElParam"},
    {2286, "UnregisterClassA"},
    {2287, "UnregisterClassW"},
    {2288, "UnregisterDeviceNotification"},
    {2289, "UnregisterHotKey"},
    {2290, "UnregisterMessagePumpHook"},
    {2291, "UnregisterPowerSettingNotification"},
    {2292, "UnregisterSessionPort"},
    {2293, "UnregisterTouchWindow"},
    {2294, "UnregisterUserApiHook"},
    {2295, "UpdateLayeredWindow"},
    {2296, "UpdateLayeredWindowIndirect"},
    {2297, "UpdatePerUserSystemParameters"},
    {2298, "UpdateWindow"},
    {2299, "UpdateWindowTransform"},
    {2300, "User32InitializeImmEntryTable"},
    {2301, "UserClientDllInitialize"},
    {2302, "UserHandleGrantAccess"},
    {2303, "UserLpkPSMTextOut"},
    {2304, "UserLpkTabbedTextOut"},
    {2305, "UserRealizePalette"},
    {2306, "UserRegisterWowHandlers"},
    {2307, "VRipOutput"},
    {2308, "VTagOutput"},
    {2309, "ValidateRect"},
    {2310, "ValidateRgn"},
    {2311, "VkKeyScanA"},
    {2312, "VkKeyScanExA"},
    {2313, "VkKeyScanExW"},
    {2314, "VkKeyScanW"},
    {2315, "WCSToMBEx"},
    {2316, "WINNLSEnableIME"},
    {2317, "WINNLSGetEnableStatus"},
    {2318, "WINNLSGetIMEHotkey"},
    {2319, "WaitForInputIdle"},
    {2320, "WaitMessage"},
    {2321, "WinHelpA"},
    {2322, "WinHelpW"},
    {2323, "WindowFromDC"},
    {2324, "WindowFromPhysicalPoint"},
    {2325, "WindowFromPoint"},
    {2326, "_UserTestTokenForInteractive"},
    {2327, "gSharedInfo"},
    {2328, "gapfnScSendMessage"},
    {2329, "keybd_event"},
    {2330, "mouse_event"},
    {2331, "wsprintfA"},
    {2332, "wsprintfW"},
    {2333, "wvsprintfA"},
    {2334, "wvsprintfW"},
    {0, NULL}};
static Dw32Ordinal userenv[] = {
    {106, "CreateEnvironmentBlock"},
    {107, "CreateProfile"},
    {108, "DeleteProfileA"},
    {109, "DeleteProfileW"},
    {110, "DestroyEnvironmentBlock"},
    {111, "DllCanUnloadNow"},
    {112, "DllGetClassObject"},
    {113, "DllGetContractDescription"},
    {114, "DllRegisterServer"},
    {115, "DllUnregisterServer"},
    {116, "EnterCriticalPolicySection"},
    {117, "ExpandEnvironmentStringsForUserA"},
    {118, "ExpandEnvironmentStringsForUserW"},
    {119, "ForceSyncFgPolicy"},
    {120, "FreeGPOListA"},
    {121, "FreeGPOListW"},
    {123, "GetAllUsersProfileDirectoryA"},
    {124, "GetAllUsersProfileDirectoryW"},
    {125, "GetAppliedGPOListA"},
    {126, "GetAppliedGPOListW"},
    {127, "GetDefaultUserProfileDirectoryA"},
    {128, "GetDefaultUserProfileDirectoryW"},
    {129, "GetGPOListA"},
    {130, "GetGPOListW"},
    {131, "GetNextFgPolicyRefreshInfo"},
    {132, "GetPreviousFgPolicyRefreshInfo"},
    {133, "GetProfileType"},
    {134, "GetProfilesDirectoryA"},
    {136, "GetProfilesDirectoryW"},
    {138, "GetUserProfileDirectoryA"},
    {140, "GetUserProfileDirectoryW"},
    {141, "LeaveCriticalPolicySection"},
    {142, "LoadUserProfileA"},
    {143, "LoadUserProfileW"},
    {144, "ProcessGroupPolicyCompleted"},
    {145, "ProcessGroupPolicyCompletedEx"},
    {146, "RefreshPolicy"},
    {147, "RefreshPolicyEx"},
    {148, "RegisterGPNotification"},
    {149, "RsopAccessCheckByType"},
    {150, "RsopFileAccessCheck"},
    {105, "RsopLoggingEnabled"},
    {151, "RsopResetPolicySettingStatus"},
    {152, "RsopSetPolicySettingStatus"},
    {153, "UnloadUserProfile"},
    {154, "UnregisterGPNotification"},
    {155, "WaitForMachinePolicyForegroundProcessing"},
    {156, "WaitForUserPolicyForegroundProcessing"},
    {0, NULL}};
static Dw32Ordinal usp10[] = {
    {1, "LpkPresent"},
    {2, "ScriptApplyDigitSubstitution"},
    {3, "ScriptApplyLogicalWidth"},
    {4, "ScriptBreak"},
    {5, "ScriptCPtoX"},
    {6, "ScriptCacheGetHeight"},
    {7, "ScriptFreeCache"},
    {8, "ScriptGetCMap"},
    {9, "ScriptGetFontAlternateGlyphs"},
    {10, "ScriptGetFontFeatureTags"},
    {11, "ScriptGetFontLanguageTags"},
    {12, "ScriptGetFontProperties"},
    {13, "ScriptGetFontScriptTags"},
    {14, "ScriptGetGlyphABCWidth"},
    {15, "ScriptGetLogicalWidths"},
    {16, "ScriptGetProperties"},
    {17, "ScriptIsComplex"},
    {18, "ScriptItemize"},
    {19, "ScriptItemizeOpenType"},
    {20, "ScriptJustify"},
    {21, "ScriptLayout"},
    {22, "ScriptPlace"},
    {23, "ScriptPlaceOpenType"},
    {24, "ScriptPositionSingleGlyph"},
    {25, "ScriptRecordDigitSubstitution"},
    {26, "ScriptShape"},
    {27, "ScriptShapeOpenType"},
    {28, "ScriptStringAnalyse"},
    {29, "ScriptStringCPtoX"},
    {30, "ScriptStringFree"},
    {31, "ScriptStringGetLogicalWidths"},
    {32, "ScriptStringGetOrder"},
    {33, "ScriptStringOut"},
    {34, "ScriptStringValidate"},
    {35, "ScriptStringXtoCP"},
    {36, "ScriptString_pLogAttr"},
    {37, "ScriptString_pSize"},
    {38, "ScriptString_pcOutChars"},
    {39, "ScriptSubstituteSingleGlyph"},
    {40, "ScriptTextOut"},
    {41, "ScriptXtoCP"},
    {42, "UspAllocCache"},
    {43, "UspAllocTemp"},
    {44, "UspFreeMem"},
    {0, NULL}};
static Dw32Ordinal uxtheme[] = {
    {37, "BeginBufferedAnimation"},
    {38, "BeginBufferedPaint"},
    {5, "BeginPanningFeedback"},
    {39, "BufferedPaintClear"},
    {40, "BufferedPaintInit"},
    {41, "BufferedPaintRenderAnimation"},
    {42, "BufferedPaintSetAlpha"},
    {51, "BufferedPaintStopAllAnimations"},
    {52, "BufferedPaintUnInit"},
    {53, "CloseThemeData"},
    {54, "DrawThemeBackground"},
    {47, "DrawThemeBackgroundEx"},
    {55, "DrawThemeEdge"},
    {56, "DrawThemeIcon"},
    {57, "DrawThemeParentBackground"},
    {58, "DrawThemeParentBackgroundEx"},
    {59, "DrawThemeText"},
    {70, "DrawThemeTextEx"},
    {71, "EnableThemeDialogTexture"},
    {87, "EnableTheming"},
    {88, "EndBufferedAnimation"},
    {89, "EndBufferedPaint"},
    {6, "EndPanningFeedback"},
    {90, "GetBufferedPaintBits"},
    {91, "GetBufferedPaintDC"},
    {92, "GetBufferedPaintTargetDC"},
    {93, "GetBufferedPaintTargetRect"},
    {94, "GetCurrentThemeName"},
    {95, "GetThemeAppProperties"},
    {96, "GetThemeBackgroundContentRect"},
    {97, "GetThemeBackgroundExtent"},
    {98, "GetThemeBackgroundRegion"},
    {99, "GetThemeBitmap"},
    {100, "GetThemeBool"},
    {101, "GetThemeColor"},
    {102, "GetThemeDocumentationProperty"},
    {103, "GetThemeEnumValue"},
    {104, "GetThemeFilename"},
    {105, "GetThemeFont"},
    {106, "GetThemeInt"},
    {107, "GetThemeIntList"},
    {108, "GetThemeMargins"},
    {109, "GetThemeMetric"},
    {110, "GetThemePartSize"},
    {111, "GetThemePosition"},
    {112, "GetThemePropertyOrigin"},
    {113, "GetThemeRect"},
    {114, "GetThemeStream"},
    {115, "GetThemeString"},
    {116, "GetThemeSysBool"},
    {117, "GetThemeSysColor"},
    {118, "GetThemeSysColorBrush"},
    {119, "GetThemeSysFont"},
    {120, "GetThemeSysInt"},
    {121, "GetThemeSysSize"},
    {122, "GetThemeSysString"},
    {123, "GetThemeTextExtent"},
    {124, "GetThemeTextMetrics"},
    {125, "GetThemeTransitionDuration"},
    {126, "GetWindowTheme"},
    {127, "HitTestThemeBackground"},
    {128, "IsAppThemed"},
    {129, "IsCompositionActive"},
    {130, "IsThemeActive"},
    {131, "IsThemeBackgroundPartiallyTransparent"},
    {132, "IsThemeDialogTextureEnabled"},
    {133, "IsThemePartDefined"},
    {134, "OpenThemeData"},
    {61, "OpenThemeDataEx"},
    {135, "SetThemeAppProperties"},
    {136, "SetWindowTheme"},
    {137, "SetWindowThemeAttribute"},
    {138, "ThemeInitApiHook"},
    {12, "UpdatePanningFeedback"},
    {0, NULL}};
static Dw32Ordinal vdmdbg[] = {
    {1, "VDMBreakThread"},
    {2, "VDMDetectWOW"},
    {3, "VDMEnumProcessWOW"},
    {4, "VDMEnumTaskWOW"},
    {5, "VDMEnumTaskWOWEx"},
    {6, "VDMGetAddrExpression"},
    {7, "VDMGetContext"},
    {8, "VDMGetDbgFlags"},
    {9, "VDMGetModuleSelector"},
    {10, "VDMGetPointer"},
    {11, "VDMGetSegmentInfo"},
    {12, "VDMGetSegtablePointer"},
    {13, "VDMGetSelectorModule"},
    {14, "VDMGetSymbol"},
    {15, "VDMGetThreadContext"},
    {16, "VDMGetThreadSelectorEntry"},
    {17, "VDMGlobalFirst"},
    {18, "VDMGlobalNext"},
    {19, "VDMIsModuleLoaded"},
    {20, "VDMKillWOW"},
    {21, "VDMModuleFirst"},
    {22, "VDMModuleNext"},
    {23, "VDMProcessException"},
    {24, "VDMSetContext"},
    {25, "VDMSetDbgFlags"},
    {26, "VDMSetThreadContext"},
    {27, "VDMStartTaskInWOW"},
    {28, "VDMTerminateTaskWOW"},
    {0, NULL}};
static Dw32Ordinal version[] = {
    {1, "GetFileVersionInfoA"},
    {2, "GetFileVersionInfoByHandle"},
    {3, "GetFileVersionInfoExW"},
    {4, "GetFileVersionInfoSizeA"},
    {5, "GetFileVersionInfoSizeExW"},
    {6, "GetFileVersionInfoSizeW"},
    {7, "GetFileVersionInfoW"},
    {8, "VerFindFileA"},
    {9, "VerFindFileW"},
    {10, "VerInstallFileA"},
    {11, "VerInstallFileW"},
    {12, "VerLanguageNameA"},
    {13, "VerLanguageNameW"},
    {14, "VerQueryValueA"},
    {15, "VerQueryValueW"},
    {0, NULL}};
static Dw32Ordinal vssapi[] = {
    {8, "??0CVssJetWriter@@QAE@XZ"},
    {9, "??0CVssWriter@@QAE@XZ"},
    {10, "??1CVssJetWriter@@UAE@XZ"},
    {11, "??1CVssWriter@@UAE@XZ"},
    {12, "?AreComponentsSelected@CVssJetWriter@@IBG_NXZ"},
    {13, "?AreComponentsSelected@CVssWriter@@IBG_NXZ"},
    {14, "?CreateVssBackupComponents@@YGJPAPAVIVssBackupComponents@@@Z"},
    {15, "?CreateVssExamineWriterMetadata@@YGJPAGPAPAVIVssExamineWriterMetadata@@@Z"},
    {16, "?CreateVssSnapshotSetDescription@@YGJU_GUID@@JPAPAVIVssSnapshotSetDescription@@@Z"},
    {17, "?GetBackupType@CVssJetWriter@@IBG?AW4_VSS_BACKUP_TYPE@@XZ"},
    {18, "?GetBackupType@CVssWriter@@IBG?AW4_VSS_BACKUP_TYPE@@XZ"},
    {19, "?GetContext@CVssJetWriter@@IBGJXZ"},
    {20, "?GetContext@CVssWriter@@IBGJXZ"},
    {21, "?GetCurrentLevel@CVssJetWriter@@IBG?AW4_VSS_APPLICATION_LEVEL@@XZ"},
    {22, "?GetCurrentLevel@CVssWriter@@IBG?AW4_VSS_APPLICATION_LEVEL@@XZ"},
    {23, "?GetCurrentSnapshotSetId@CVssJetWriter@@IBG?AU_GUID@@XZ"},
    {24, "?GetCurrentSnapshotSetId@CVssWriter@@IBG?AU_GUID@@XZ"},
    {25, "?GetCurrentVolumeArray@CVssJetWriter@@IBGPAPBGXZ"},
    {26, "?GetCurrentVolumeArray@CVssWriter@@IBGPAPBGXZ"},
    {27, "?GetCurrentVolumeCount@CVssJetWriter@@IBGIXZ"},
    {28, "?GetCurrentVolumeCount@CVssWriter@@IBGIXZ"},
    {29, "?GetRestoreType@CVssJetWriter@@IBG?AW4_VSS_RESTORE_TYPE@@XZ"},
    {30, "?GetRestoreType@CVssWriter@@IBG?AW4_VSS_RESTORE_TYPE@@XZ"},
    {31, "?GetSnapshotDeviceName@CVssJetWriter@@IBGJPBGPAPBG@Z"},
    {32, "?GetSnapshotDeviceName@CVssWriter@@IBGJPBGPAPBG@Z"},
    {33, "?Initialize@CVssJetWriter@@QAGJU_GUID@@PBG_N211K@Z"},
    {34, "?Initialize@CVssWriter@@QAGJU_GUID@@PBGW4VSS_USAGE_TYPE@@W4VSS_SOURCE_TYPE@@W4_VSS_APPLICATION_LEVEL@@KW4VSS_ALTERNATE_WRITER_STATE@@_N1@Z"},
    {35, "?InstallAlternateWriter@CVssWriter@@QAGJU_GUID@@0@Z"},
    {36, "?IsBootableSystemStateBackedUp@CVssJetWriter@@IBG_NXZ"},
    {37, "?IsBootableSystemStateBackedUp@CVssWriter@@IBG_NXZ"},
    {38, "?IsPartialFileSupportEnabled@CVssJetWriter@@IBG_NXZ"},
    {39, "?IsPartialFileSupportEnabled@CVssWriter@@IBG_NXZ"},
    {40, "?IsPathAffected@CVssJetWriter@@IBG_NPBG@Z"},
    {41, "?IsPathAffected@CVssWriter@@IBG_NPBG@Z"},
    {42, "?LoadVssSnapshotSetDescription@@YGJPBGPAPAVIVssSnapshotSetDescription@@U_GUID@@@Z"},
    {43, "?OnAbortBegin@CVssJetWriter@@UAGXXZ"},
    {44, "?OnAbortEnd@CVssJetWriter@@UAGXXZ"},
    {45, "?OnBackOffIOOnVolume@CVssWriter@@UAG_NPAGU_GUID@@1@Z"},
    {46, "?OnBackupComplete@CVssWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {47, "?OnBackupCompleteBegin@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {48, "?OnBackupCompleteEnd@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@_N@Z"},
    {49, "?OnBackupShutdown@CVssWriter@@UAG_NU_GUID@@@Z"},
    {50, "?OnContinueIOOnVolume@CVssWriter@@UAG_NPAGU_GUID@@1@Z"},
    {51, "?OnFreezeBegin@CVssJetWriter@@UAG_NXZ"},
    {52, "?OnFreezeEnd@CVssJetWriter@@UAG_N_N@Z"},
    {53, "?OnIdentify@CVssJetWriter@@UAG_NPAVIVssCreateWriterMetadata@@@Z"},
    {54, "?OnIdentify@CVssWriter@@UAG_NPAVIVssCreateWriterMetadata@@@Z"},
    {55, "?OnPostRestore@CVssWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {56, "?OnPostRestoreBegin@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {57, "?OnPostRestoreEnd@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@_N@Z"},
    {58, "?OnPostSnapshot@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {59, "?OnPostSnapshot@CVssWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {60, "?OnPreRestore@CVssWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {61, "?OnPreRestoreBegin@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {62, "?OnPreRestoreEnd@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@_N@Z"},
    {63, "?OnPrepareBackup@CVssWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {64, "?OnPrepareBackupBegin@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@@Z"},
    {65, "?OnPrepareBackupEnd@CVssJetWriter@@UAG_NPAVIVssWriterComponents@@_N@Z"},
    {66, "?OnPrepareSnapshotBegin@CVssJetWriter@@UAG_NXZ"},
    {67, "?OnPrepareSnapshotEnd@CVssJetWriter@@UAG_N_N@Z"},
    {68, "?OnThawBegin@CVssJetWriter@@UAG_NXZ"},
    {69, "?OnThawEnd@CVssJetWriter@@UAG_N_N@Z"},
    {70, "?OnVSSApplicationStartup@CVssWriter@@UAG_NXZ"},
    {71, "?OnVSSShutdown@CVssWriter@@UAG_NXZ"},
    {72, "?SetWriterFailure@CVssJetWriter@@IAGJJ@Z"},
    {73, "?SetWriterFailure@CVssWriter@@IAGJJ@Z"},
    {74, "?Subscribe@CVssWriter@@QAGJK@Z"},
    {75, "?Uninitialize@CVssJetWriter@@QAGXXZ"},
    {76, "?Unsubscribe@CVssWriter@@QAGJXZ"},
    {77, "CreateVssBackupComponentsInternal"},
    {78, "CreateVssExamineWriterMetadataInternal"},
    {79, "CreateVssExpressWriterInternal"},
    {80, "CreateWriter"},
    {81, "CreateWriterEx"},
    {82, "DllCanUnloadNow"},
    {83, "DllGetClassObject"},
    {84, "GetProviderMgmtInterface"},
    {85, "GetProviderMgmtInterfaceInternal"},
    {5, "IsVolumeSnapshotted"},
    {86, "IsVolumeSnapshottedInternal"},
    {7, "ShouldBlockRevert"},
    {87, "ShouldBlockRevertInternal"},
    {6, "VssFreeSnapshotProperties"},
    {88, "VssFreeSnapshotPropertiesInternal"},
    {0, NULL}};
static Dw32Ordinal wecapi[] = {
    {3, "EcClose"},
    {4, "EcDeleteSubscription"},
    {5, "EcEnumNextSubscription"},
    {6, "EcGetObjectArrayProperty"},
    {7, "EcGetObjectArraySize"},
    {8, "EcGetSubscriptionProperty"},
    {9, "EcGetSubscriptionRunTimeStatus"},
    {10, "EcInsertObjectArrayElement"},
    {1, "EcIsConfigRequired"},
    {11, "EcOpenSubscription"},
    {12, "EcOpenSubscriptionEnum"},
    {2, "EcQuickConfig"},
    {13, "EcRemoveObjectArrayElement"},
    {14, "EcRetrySubscription"},
    {15, "EcSaveSubscription"},
    {16, "EcSetObjectArrayProperty"},
    {17, "EcSetSubscriptionProperty"},
    {0, NULL}};
static Dw32Ordinal wer[] = {
    {74, "WerAddExcludedApplication"},
    {75, "WerRemoveExcludedApplication"},
    {76, "WerReportAddDump"},
    {77, "WerReportAddFile"},
    {78, "WerReportCloseHandle"},
    {79, "WerReportCreate"},
    {80, "WerReportSetParameter"},
    {81, "WerReportSetUIOption"},
    {82, "WerReportSubmit"},
    {1, "WerSysprepCleanup"},
    {2, "WerSysprepGeneralize"},
    {3, "WerSysprepSpecialize"},
    {4, "WerUnattendedSetup"},
    {5, "WerpAddAppCompatData"},
    {6, "WerpAddFile"},
    {7, "WerpAddMemoryBlock"},
    {8, "WerpAddRegisteredDataToReport"},
    {9, "WerpAddSecondaryParameter"},
    {10, "WerpAddTextToReport"},
    {11, "WerpArchiveReport"},
    {12, "WerpCancelResponseDownload"},
    {13, "WerpCancelUpload"},
    {14, "WerpCloseStore"},
    {15, "WerpCreateIntegratorReportId"},
    {16, "WerpCreateMachineStore"},
    {17, "WerpDeleteReport"},
    {18, "WerpDestroyWerString"},
    {19, "WerpDownloadResponse"},
    {20, "WerpDownloadResponseTemplate"},
    {21, "WerpEnumerateStoreNext"},
    {22, "WerpEnumerateStoreStart"},
    {23, "WerpExtractReportFiles"},
    {24, "WerpFreeString"},
    {25, "WerpGetBucketId"},
    {26, "WerpGetBucketString"},
    {27, "WerpGetDynamicParameter"},
    {28, "WerpGetEventType"},
    {29, "WerpGetFileByIndex"},
    {30, "WerpGetFilePathByIndex"},
    {31, "WerpGetIntegratorReportId"},
    {32, "WerpGetLoadedModuleByIndex"},
    {33, "WerpGetNumFiles"},
    {34, "WerpGetNumLoadedModules"},
    {35, "WerpGetNumSecParams"},
    {36, "WerpGetNumSigParams"},
    {83, "WerpGetReportConsent"},
    {37, "WerpGetReportFinalConsent"},
    {38, "WerpGetReportFlags"},
    {39, "WerpGetReportInformation"},
    {40, "WerpGetReportSettings"},
    {41, "WerpGetReportTime"},
    {42, "WerpGetReportType"},
    {43, "WerpGetResponseId"},
    {44, "WerpGetResponseUrl"},
    {45, "WerpGetSecParamByIndex"},
    {46, "WerpGetSigParamByIndex"},
    {47, "WerpGetStoreLocation"},
    {48, "WerpGetStorePath"},
    {49, "WerpGetStoreType"},
    {50, "WerpGetTextFromReport"},
    {51, "WerpGetUIParamByIndex"},
    {52, "WerpGetUploadTime"},
    {53, "WerpGetWerStringData"},
    {54, "WerpGetWow64Process"},
    {84, "WerpIsDisabled"},
    {55, "WerpIsTransportAvailable"},
    {85, "WerpLaunchResponse"},
    {56, "WerpLoadReport"},
    {57, "WerpOpenMachineArchive"},
    {58, "WerpOpenMachineQueue"},
    {59, "WerpOpenUserArchive"},
    {86, "WerpOpenUserQueue"},
    {60, "WerpPromtUser"},
    {61, "WerpReportCancel"},
    {62, "WerpRestartApplication"},
    {87, "WerpSetCallBack"},
    {88, "WerpSetDefaultUserConsent"},
    {63, "WerpSetDynamicParameter"},
    {64, "WerpSetEventName"},
    {65, "WerpSetIntegratorReportId"},
    {66, "WerpSetReportFlags"},
    {67, "WerpSetReportInformation"},
    {68, "WerpSetReportTime"},
    {69, "WerpSetReportUploadContextToken"},
    {70, "WerpShowUpsellUI"},
    {71, "WerpSubmitReportFromStore"},
    {72, "WerpSvcReportFromMachineQueue"},
    {73, "WerpUpdateReportResponse"},
    {0, NULL}};
static Dw32Ordinal wevtapi[] = {
    {3, "EvtArchiveExportedLog"},
    {4, "EvtCancel"},
    {5, "EvtClearLog"},
    {6, "EvtClose"},
    {7, "EvtCreateBookmark"},
    {8, "EvtCreateRenderContext"},
    {9, "EvtExportLog"},
    {10, "EvtFormatMessage"},
    {11, "EvtGetChannelConfigProperty"},
    {12, "EvtGetEventInfo"},
    {13, "EvtGetEventMetadataProperty"},
    {14, "EvtGetExtendedStatus"},
    {15, "EvtGetLogInfo"},
    {16, "EvtGetObjectArrayProperty"},
    {17, "EvtGetObjectArraySize"},
    {18, "EvtGetPublisherMetadataProperty"},
    {19, "EvtGetQueryInfo"},
    {20, "EvtIntAssertConfig"},
    {21, "EvtIntCreateBinXMLFromCustomXML"},
    {22, "EvtIntCreateLocalLogfile"},
    {23, "EvtIntGetClassicLogDisplayName"},
    {24, "EvtIntRenderResourceEventTemplate"},
    {25, "EvtIntReportAuthzEventAndSourceAsync"},
    {26, "EvtIntReportEventAndSourceAsync"},
    {27, "EvtIntRetractConfig"},
    {1, "EvtIntSysprepCleanup"},
    {28, "EvtIntWriteXmlEventToLocalLogfile"},
    {29, "EvtNext"},
    {30, "EvtNextChannelPath"},
    {31, "EvtNextEventMetadata"},
    {32, "EvtNextPublisherId"},
    {33, "EvtOpenChannelConfig"},
    {34, "EvtOpenChannelEnum"},
    {35, "EvtOpenEventMetadataEnum"},
    {36, "EvtOpenLog"},
    {37, "EvtOpenPublisherEnum"},
    {38, "EvtOpenPublisherMetadata"},
    {39, "EvtOpenSession"},
    {40, "EvtQuery"},
    {41, "EvtRender"},
    {42, "EvtSaveChannelConfig"},
    {43, "EvtSeek"},
    {44, "EvtSetChannelConfigProperty"},
    {2, "EvtSetObjectArrayProperty"},
    {45, "EvtSubscribe"},
    {46, "EvtUpdateBookmark"},
    {0, NULL}};
static Dw32Ordinal win32spl[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllMain"},
    {4, "DllRegisterServer"},
    {5, "DllUnregisterServer"},
    {6, "InitializePrintMonitor2"},
    {7, "InitializePrintProvidor"},
    {8, "ProviderEntryW"},
    {0, NULL}};
static Dw32Ordinal windowscodecs[] = {
    {1, "DllGetClassObject"},
    {2, "IEnumString_Next_WIC_Proxy"},
    {3, "IEnumString_Reset_WIC_Proxy"},
    {4, "IPropertyBag2_Write_Proxy"},
    {5, "IWICBitmapClipper_Initialize_Proxy"},
    {6, "IWICBitmapCodecInfo_DoesSupportAnimation_Proxy"},
    {7, "IWICBitmapCodecInfo_DoesSupportLossless_Proxy"},
    {8, "IWICBitmapCodecInfo_DoesSupportMultiframe_Proxy"},
    {9, "IWICBitmapCodecInfo_GetContainerFormat_Proxy"},
    {10, "IWICBitmapCodecInfo_GetDeviceManufacturer_Proxy"},
    {11, "IWICBitmapCodecInfo_GetDeviceModels_Proxy"},
    {12, "IWICBitmapCodecInfo_GetFileExtensions_Proxy"},
    {13, "IWICBitmapCodecInfo_GetMimeTypes_Proxy"},
    {14, "IWICBitmapDecoder_CopyPalette_Proxy"},
    {15, "IWICBitmapDecoder_GetColorContexts_Proxy"},
    {16, "IWICBitmapDecoder_GetDecoderInfo_Proxy"},
    {17, "IWICBitmapDecoder_GetFrameCount_Proxy"},
    {18, "IWICBitmapDecoder_GetFrame_Proxy"},
    {19, "IWICBitmapDecoder_GetMetadataQueryReader_Proxy"},
    {20, "IWICBitmapDecoder_GetPreview_Proxy"},
    {21, "IWICBitmapDecoder_GetThumbnail_Proxy"},
    {22, "IWICBitmapEncoder_Commit_Proxy"},
    {23, "IWICBitmapEncoder_CreateNewFrame_Proxy"},
    {24, "IWICBitmapEncoder_GetEncoderInfo_Proxy"},
    {25, "IWICBitmapEncoder_GetMetadataQueryWriter_Proxy"},
    {26, "IWICBitmapEncoder_Initialize_Proxy"},
    {27, "IWICBitmapEncoder_SetPalette_Proxy"},
    {28, "IWICBitmapEncoder_SetThumbnail_Proxy"},
    {29, "IWICBitmapFlipRotator_Initialize_Proxy"},
    {30, "IWICBitmapFrameDecode_GetColorContexts_Proxy"},
    {31, "IWICBitmapFrameDecode_GetMetadataQueryReader_Proxy"},
    {32, "IWICBitmapFrameDecode_GetThumbnail_Proxy"},
    {33, "IWICBitmapFrameEncode_Commit_Proxy"},
    {34, "IWICBitmapFrameEncode_GetMetadataQueryWriter_Proxy"},
    {35, "IWICBitmapFrameEncode_Initialize_Proxy"},
    {36, "IWICBitmapFrameEncode_SetColorContexts_Proxy"},
    {37, "IWICBitmapFrameEncode_SetResolution_Proxy"},
    {38, "IWICBitmapFrameEncode_SetSize_Proxy"},
    {39, "IWICBitmapFrameEncode_SetThumbnail_Proxy"},
    {40, "IWICBitmapFrameEncode_WriteSource_Proxy"},
    {41, "IWICBitmapLock_GetDataPointer_STA_Proxy"},
    {42, "IWICBitmapLock_GetStride_Proxy"},
    {43, "IWICBitmapScaler_Initialize_Proxy"},
    {44, "IWICBitmapSource_CopyPalette_Proxy"},
    {45, "IWICBitmapSource_CopyPixels_Proxy"},
    {46, "IWICBitmapSource_GetPixelFormat_Proxy"},
    {47, "IWICBitmapSource_GetResolution_Proxy"},
    {48, "IWICBitmapSource_GetSize_Proxy"},
    {49, "IWICBitmap_Lock_Proxy"},
    {50, "IWICBitmap_SetPalette_Proxy"},
    {51, "IWICBitmap_SetResolution_Proxy"},
    {52, "IWICColorContext_InitializeFromMemory_Proxy"},
    {53, "IWICComponentFactory_CreateMetadataWriterFromReader_Proxy"},
    {54, "IWICComponentFactory_CreateQueryWriterFromBlockWriter_Proxy"},
    {55, "IWICComponentInfo_GetAuthor_Proxy"},
    {56, "IWICComponentInfo_GetCLSID_Proxy"},
    {57, "IWICComponentInfo_GetFriendlyName_Proxy"},
    {58, "IWICComponentInfo_GetSpecVersion_Proxy"},
    {59, "IWICComponentInfo_GetVersion_Proxy"},
    {60, "IWICFastMetadataEncoder_Commit_Proxy"},
    {61, "IWICFastMetadataEncoder_GetMetadataQueryWriter_Proxy"},
    {62, "IWICFormatConverter_Initialize_Proxy"},
    {63, "IWICImagingFactory_CreateBitmapClipper_Proxy"},
    {64, "IWICImagingFactory_CreateBitmapFlipRotator_Proxy"},
    {65, "IWICImagingFactory_CreateBitmapFromHBITMAP_Proxy"},
    {66, "IWICImagingFactory_CreateBitmapFromHICON_Proxy"},
    {67, "IWICImagingFactory_CreateBitmapFromMemory_Proxy"},
    {68, "IWICImagingFactory_CreateBitmapFromSource_Proxy"},
    {69, "IWICImagingFactory_CreateBitmapScaler_Proxy"},
    {70, "IWICImagingFactory_CreateBitmap_Proxy"},
    {71, "IWICImagingFactory_CreateComponentInfo_Proxy"},
    {72, "IWICImagingFactory_CreateDecoderFromFileHandle_Proxy"},
    {73, "IWICImagingFactory_CreateDecoderFromFilename_Proxy"},
    {74, "IWICImagingFactory_CreateDecoderFromStream_Proxy"},
    {75, "IWICImagingFactory_CreateEncoder_Proxy"},
    {76, "IWICImagingFactory_CreateFastMetadataEncoderFromDecoder_Proxy"},
    {77, "IWICImagingFactory_CreateFastMetadataEncoderFromFrameDecode_Proxy"},
    {78, "IWICImagingFactory_CreateFormatConverter_Proxy"},
    {79, "IWICImagingFactory_CreatePalette_Proxy"},
    {80, "IWICImagingFactory_CreateQueryWriterFromReader_Proxy"},
    {81, "IWICImagingFactory_CreateQueryWriter_Proxy"},
    {82, "IWICImagingFactory_CreateStream_Proxy"},
    {83, "IWICMetadataBlockReader_GetCount_Proxy"},
    {84, "IWICMetadataBlockReader_GetReaderByIndex_Proxy"},
    {85, "IWICMetadataQueryReader_GetContainerFormat_Proxy"},
    {86, "IWICMetadataQueryReader_GetEnumerator_Proxy"},
    {87, "IWICMetadataQueryReader_GetLocation_Proxy"},
    {88, "IWICMetadataQueryReader_GetMetadataByName_Proxy"},
    {89, "IWICMetadataQueryWriter_RemoveMetadataByName_Proxy"},
    {90, "IWICMetadataQueryWriter_SetMetadataByName_Proxy"},
    {91, "IWICPalette_GetColorCount_Proxy"},
    {92, "IWICPalette_GetColors_Proxy"},
    {93, "IWICPalette_GetType_Proxy"},
    {94, "IWICPalette_HasAlpha_Proxy"},
    {95, "IWICPalette_InitializeCustom_Proxy"},
    {96, "IWICPalette_InitializeFromBitmap_Proxy"},
    {97, "IWICPalette_InitializeFromPalette_Proxy"},
    {98, "IWICPalette_InitializePredefined_Proxy"},
    {99, "IWICPixelFormatInfo_GetBitsPerPixel_Proxy"},
    {100, "IWICPixelFormatInfo_GetChannelCount_Proxy"},
    {101, "IWICPixelFormatInfo_GetChannelMask_Proxy"},
    {102, "IWICStream_InitializeFromIStream_Proxy"},
    {103, "IWICStream_InitializeFromMemory_Proxy"},
    {104, "WICConvertBitmapSource"},
    {105, "WICCreateBitmapFromSection"},
    {106, "WICCreateBitmapFromSectionEx"},
    {107, "WICCreateColorContext_Proxy"},
    {108, "WICCreateImagingFactory_Proxy"},
    {109, "WICGetMetadataContentSize"},
    {110, "WICMapGuidToShortName"},
    {111, "WICMapSchemaToName"},
    {112, "WICMapShortNameToGuid"},
    {113, "WICMatchMetadataContent"},
    {114, "WICSerializeMetadataContent"},
    {115, "WICSetEncoderFormat_Proxy"},
    {0, NULL}};
static Dw32Ordinal winfax[] = {
    {1, "FaxAbort"},
    {2, "FaxAccessCheck"},
    {3, "FaxClose"},
    {4, "FaxCompleteJobParamsA"},
    {5, "FaxCompleteJobParamsW"},
    {6, "FaxConnectFaxServerA"},
    {7, "FaxConnectFaxServerW"},
    {8, "FaxEnableRoutingMethodA"},
    {9, "FaxEnableRoutingMethodW"},
    {10, "FaxEnumGlobalRoutingInfoA"},
    {11, "FaxEnumGlobalRoutingInfoW"},
    {12, "FaxEnumJobsA"},
    {13, "FaxEnumJobsW"},
    {14, "FaxEnumPortsA"},
    {15, "FaxEnumPortsW"},
    {16, "FaxEnumRoutingMethodsA"},
    {17, "FaxEnumRoutingMethodsW"},
    {18, "FaxFreeBuffer"},
    {19, "FaxGetConfigurationA"},
    {20, "FaxGetConfigurationW"},
    {21, "FaxGetDeviceStatusA"},
    {22, "FaxGetDeviceStatusW"},
    {23, "FaxGetJobA"},
    {24, "FaxGetJobW"},
    {25, "FaxGetLoggingCategoriesA"},
    {26, "FaxGetLoggingCategoriesW"},
    {27, "FaxGetPageData"},
    {28, "FaxGetPortA"},
    {29, "FaxGetPortW"},
    {30, "FaxGetRoutingInfoA"},
    {31, "FaxGetRoutingInfoW"},
    {32, "FaxInitializeEventQueue"},
    {33, "FaxOpenPort"},
    {34, "FaxPrintCoverPageA"},
    {35, "FaxPrintCoverPageW"},
    {36, "FaxRegisterRoutingExtensionW"},
    {37, "FaxRegisterServiceProviderW"},
    {38, "FaxSendDocumentA"},
    {39, "FaxSendDocumentForBroadcastA"},
    {40, "FaxSendDocumentForBroadcastW"},
    {41, "FaxSendDocumentW"},
    {42, "FaxSetConfigurationA"},
    {43, "FaxSetConfigurationW"},
    {44, "FaxSetGlobalRoutingInfoA"},
    {45, "FaxSetGlobalRoutingInfoW"},
    {46, "FaxSetJobA"},
    {47, "FaxSetJobW"},
    {48, "FaxSetLoggingCategoriesA"},
    {49, "FaxSetLoggingCategoriesW"},
    {50, "FaxSetPortA"},
    {51, "FaxSetPortW"},
    {52, "FaxSetRoutingInfoA"},
    {53, "FaxSetRoutingInfoW"},
    {54, "FaxStartPrintJobA"},
    {55, "FaxStartPrintJobW"},
    {56, "FaxUnregisterServiceProviderW"},
    {0, NULL}};
static Dw32Ordinal winhttp[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "Private1"},
    {4, "SvchostPushServiceGlobals"},
    {5, "WinHttpAddRequestHeaders"},
    {6, "WinHttpAutoProxySvcMain"},
    {7, "WinHttpCheckPlatform"},
    {8, "WinHttpCloseHandle"},
    {9, "WinHttpConnect"},
    {10, "WinHttpCrackUrl"},
    {11, "WinHttpCreateUrl"},
    {12, "WinHttpDetectAutoProxyConfigUrl"},
    {13, "WinHttpGetDefaultProxyConfiguration"},
    {14, "WinHttpGetIEProxyConfigForCurrentUser"},
    {15, "WinHttpGetProxyForUrl"},
    {16, "WinHttpOpen"},
    {17, "WinHttpOpenRequest"},
    {18, "WinHttpQueryAuthSchemes"},
    {19, "WinHttpQueryDataAvailable"},
    {20, "WinHttpQueryHeaders"},
    {21, "WinHttpQueryOption"},
    {22, "WinHttpReadData"},
    {23, "WinHttpReceiveResponse"},
    {24, "WinHttpSendRequest"},
    {25, "WinHttpSetCredentials"},
    {26, "WinHttpSetDefaultProxyConfiguration"},
    {27, "WinHttpSetOption"},
    {28, "WinHttpSetStatusCallback"},
    {29, "WinHttpSetTimeouts"},
    {30, "WinHttpTimeFromSystemTime"},
    {31, "WinHttpTimeToSystemTime"},
    {32, "WinHttpWriteData"},
    {0, NULL}};
static Dw32Ordinal wininet[] = {
    {107, "CommitUrlCacheEntryA"},
    {113, "CommitUrlCacheEntryW"},
    {114, "CreateMD5SSOHash"},
    {115, "CreateUrlCacheContainerA"},
    {119, "CreateUrlCacheContainerW"},
    {124, "CreateUrlCacheEntryA"},
    {125, "CreateUrlCacheEntryW"},
    {126, "CreateUrlCacheGroup"},
    {127, "DeleteIE3Cache"},
    {128, "DeleteUrlCacheContainerA"},
    {129, "DeleteUrlCacheContainerW"},
    {130, "DeleteUrlCacheEntry"},
    {131, "DeleteUrlCacheEntryA"},
    {132, "DeleteUrlCacheEntryW"},
    {133, "DeleteUrlCacheGroup"},
    {134, "DeleteWpadCacheForNetworks"},
    {135, "DetectAutoProxyUrl"},
    {106, "DispatchAPICall"},
    {136, "DllInstall"},
    {137, "FindCloseUrlCache"},
    {138, "FindFirstUrlCacheContainerA"},
    {139, "FindFirstUrlCacheContainerW"},
    {140, "FindFirstUrlCacheEntryA"},
    {141, "FindFirstUrlCacheEntryExA"},
    {142, "FindFirstUrlCacheEntryExW"},
    {143, "FindFirstUrlCacheEntryW"},
    {144, "FindFirstUrlCacheGroup"},
    {145, "FindNextUrlCacheContainerA"},
    {146, "FindNextUrlCacheContainerW"},
    {147, "FindNextUrlCacheEntryA"},
    {148, "FindNextUrlCacheEntryExA"},
    {149, "FindNextUrlCacheEntryExW"},
    {150, "FindNextUrlCacheEntryW"},
    {151, "FindNextUrlCacheGroup"},
    {152, "ForceNexusLookup"},
    {153, "ForceNexusLookupExW"},
    {154, "FreeUrlCacheSpaceA"},
    {155, "FreeUrlCacheSpaceW"},
    {156, "FtpCommandA"},
    {157, "FtpCommandW"},
    {158, "FtpCreateDirectoryA"},
    {159, "FtpCreateDirectoryW"},
    {160, "FtpDeleteFileA"},
    {161, "FtpDeleteFileW"},
    {162, "FtpFindFirstFileA"},
    {163, "FtpFindFirstFileW"},
    {164, "FtpGetCurrentDirectoryA"},
    {165, "FtpGetCurrentDirectoryW"},
    {166, "FtpGetFileA"},
    {167, "FtpGetFileEx"},
    {168, "FtpGetFileSize"},
    {169, "FtpGetFileW"},
    {170, "FtpOpenFileA"},
    {171, "FtpOpenFileW"},
    {172, "FtpPutFileA"},
    {173, "FtpPutFileEx"},
    {174, "FtpPutFileW"},
    {175, "FtpRemoveDirectoryA"},
    {176, "FtpRemoveDirectoryW"},
    {177, "FtpRenameFileA"},
    {178, "FtpRenameFileW"},
    {179, "FtpSetCurrentDirectoryA"},
    {180, "FtpSetCurrentDirectoryW"},
    {181, "GetUrlCacheConfigInfoA"},
    {182, "GetUrlCacheConfigInfoW"},
    {183, "GetUrlCacheEntryInfoA"},
    {184, "GetUrlCacheEntryInfoExA"},
    {185, "GetUrlCacheEntryInfoExW"},
    {186, "GetUrlCacheEntryInfoW"},
    {187, "GetUrlCacheGroupAttributeA"},
    {188, "GetUrlCacheGroupAttributeW"},
    {189, "GetUrlCacheHeaderData"},
    {190, "GopherCreateLocatorA"},
    {191, "GopherCreateLocatorW"},
    {192, "GopherFindFirstFileA"},
    {193, "GopherFindFirstFileW"},
    {194, "GopherGetAttributeA"},
    {195, "GopherGetAttributeW"},
    {196, "GopherGetLocatorTypeA"},
    {197, "GopherGetLocatorTypeW"},
    {198, "GopherOpenFileA"},
    {199, "GopherOpenFileW"},
    {200, "HttpAddRequestHeadersA"},
    {201, "HttpAddRequestHeadersW"},
    {202, "HttpCheckDavCompliance"},
    {203, "HttpEndRequestA"},
    {204, "HttpEndRequestW"},
    {205, "HttpOpenRequestA"},
    {206, "HttpOpenRequestW"},
    {207, "HttpQueryInfoA"},
    {208, "HttpQueryInfoW"},
    {209, "HttpSendRequestA"},
    {210, "HttpSendRequestExA"},
    {211, "HttpSendRequestExW"},
    {212, "HttpSendRequestW"},
    {213, "IncrementUrlCacheHeaderData"},
    {214, "InternetAlgIdToStringA"},
    {215, "InternetAlgIdToStringW"},
    {216, "InternetAttemptConnect"},
    {217, "InternetAutodial"},
    {218, "InternetAutodialCallback"},
    {219, "InternetAutodialHangup"},
    {220, "InternetCanonicalizeUrlA"},
    {221, "InternetCanonicalizeUrlW"},
    {222, "InternetCheckConnectionA"},
    {223, "InternetCheckConnectionW"},
    {224, "InternetClearAllPerSiteCookieDecisions"},
    {225, "InternetCloseHandle"},
    {226, "InternetCombineUrlA"},
    {227, "InternetCombineUrlW"},
    {228, "InternetConfirmZoneCrossing"},
    {229, "InternetConfirmZoneCrossingA"},
    {230, "InternetConfirmZoneCrossingW"},
    {231, "InternetConnectA"},
    {232, "InternetConnectW"},
    {233, "InternetCrackUrlA"},
    {234, "InternetCrackUrlW"},
    {235, "InternetCreateUrlA"},
    {236, "InternetCreateUrlW"},
    {237, "InternetDial"},
    {238, "InternetDialA"},
    {239, "InternetDialW"},
    {240, "InternetEnumPerSiteCookieDecisionA"},
    {241, "InternetEnumPerSiteCookieDecisionW"},
    {242, "InternetErrorDlg"},
    {243, "InternetFindNextFileA"},
    {244, "InternetFindNextFileW"},
    {245, "InternetFortezzaCommand"},
    {246, "InternetGetCertByURL"},
    {247, "InternetGetCertByURLA"},
    {248, "InternetGetConnectedState"},
    {249, "InternetGetConnectedStateEx"},
    {250, "InternetGetConnectedStateExA"},
    {251, "InternetGetConnectedStateExW"},
    {252, "InternetGetCookieA"},
    {253, "InternetGetCookieExA"},
    {254, "InternetGetCookieExW"},
    {255, "InternetGetCookieW"},
    {256, "InternetGetLastResponseInfoA"},
    {257, "InternetGetLastResponseInfoW"},
    {258, "InternetGetPerSiteCookieDecisionA"},
    {259, "InternetGetPerSiteCookieDecisionW"},
    {260, "InternetGetSecurityInfoByURL"},
    {261, "InternetGetSecurityInfoByURLA"},
    {262, "InternetGetSecurityInfoByURLW"},
    {263, "InternetGoOnline"},
    {264, "InternetGoOnlineA"},
    {265, "InternetGoOnlineW"},
    {266, "InternetHangUp"},
    {267, "InternetInitializeAutoProxyDll"},
    {268, "InternetLockRequestFile"},
    {269, "InternetOpenA"},
    {270, "InternetOpenUrlA"},
    {271, "InternetOpenUrlW"},
    {272, "InternetOpenW"},
    {273, "InternetQueryDataAvailable"},
    {274, "InternetQueryFortezzaStatus"},
    {275, "InternetQueryOptionA"},
    {276, "InternetQueryOptionW"},
    {277, "InternetReadFile"},
    {278, "InternetReadFileExA"},
    {279, "InternetReadFileExW"},
    {280, "InternetSecurityProtocolToStringA"},
    {281, "InternetSecurityProtocolToStringW"},
    {282, "InternetSetCookieA"},
    {283, "InternetSetCookieExA"},
    {284, "InternetSetCookieExW"},
    {285, "InternetSetCookieW"},
    {286, "InternetSetDialState"},
    {287, "InternetSetDialStateA"},
    {288, "InternetSetDialStateW"},
    {289, "InternetSetFilePointer"},
    {290, "InternetSetOptionA"},
    {291, "InternetSetOptionExA"},
    {292, "InternetSetOptionExW"},
    {293, "InternetSetOptionW"},
    {294, "InternetSetPerSiteCookieDecisionA"},
    {295, "InternetSetPerSiteCookieDecisionW"},
    {296, "InternetSetStatusCallback"},
    {297, "InternetSetStatusCallbackA"},
    {298, "InternetSetStatusCallbackW"},
    {299, "InternetShowSecurityInfoByURL"},
    {300, "InternetShowSecurityInfoByURLA"},
    {301, "InternetShowSecurityInfoByURLW"},
    {302, "InternetTimeFromSystemTime"},
    {303, "InternetTimeFromSystemTimeA"},
    {304, "InternetTimeFromSystemTimeW"},
    {305, "InternetTimeToSystemTime"},
    {306, "InternetTimeToSystemTimeA"},
    {307, "InternetTimeToSystemTimeW"},
    {308, "InternetUnlockRequestFile"},
    {309, "InternetWriteFile"},
    {310, "InternetWriteFileExA"},
    {311, "InternetWriteFileExW"},
    {312, "IsHostInProxyBypassList"},
    {313, "IsUrlCacheEntryExpiredA"},
    {314, "IsUrlCacheEntryExpiredW"},
    {315, "LoadUrlCacheContent"},
    {316, "ParseX509EncodedCertificateForListBoxEntry"},
    {317, "PrivacyGetZonePreferenceW"},
    {318, "PrivacySetZonePreferenceW"},
    {319, "ReadUrlCacheEntryStream"},
    {320, "ReadUrlCacheEntryStreamEx"},
    {321, "RegisterUrlCacheNotification"},
    {322, "ResumeSuspendedDownload"},
    {323, "RetrieveUrlCacheEntryFileA"},
    {324, "RetrieveUrlCacheEntryFileW"},
    {325, "RetrieveUrlCacheEntryStreamA"},
    {326, "RetrieveUrlCacheEntryStreamW"},
    {327, "RunOnceUrlCache"},
    {328, "SetUrlCacheConfigInfoA"},
    {329, "SetUrlCacheConfigInfoW"},
    {330, "SetUrlCacheEntryGroup"},
    {331, "SetUrlCacheEntryGroupA"},
    {332, "SetUrlCacheEntryGroupW"},
    {333, "SetUrlCacheEntryInfoA"},
    {334, "SetUrlCacheEntryInfoW"},
    {335, "SetUrlCacheGroupAttributeA"},
    {336, "SetUrlCacheGroupAttributeW"},
    {337, "SetUrlCacheHeaderData"},
    {338, "ShowCertificate"},
    {339, "ShowClientAuthCerts"},
    {340, "ShowSecurityInfo"},
    {341, "ShowX509EncodedCertificate"},
    {342, "UnlockUrlCacheEntryFile"},
    {343, "UnlockUrlCacheEntryFileA"},
    {344, "UnlockUrlCacheEntryFileW"},
    {345, "UnlockUrlCacheEntryStream"},
    {347, "UpdateUrlCacheContentPath"},
    {348, "UrlZonesDetach"},
    {349, "_GetFileExtensionFromUrl"},
    {0, NULL}};
static Dw32Ordinal winmm[] = {
    {3, "CloseDriver"},
    {4, "DefDriverProc"},
    {5, "DriverCallback"},
    {6, "DrvGetModuleHandle"},
    {7, "GetDriverModuleHandle"},
    {8, "NotifyCallbackData"},
    {9, "OpenDriver"},
    {10, "PlaySound"},
    {11, "PlaySoundA"},
    {12, "PlaySoundW"},
    {13, "SendDriverMessage"},
    {14, "WOW32DriverCallback"},
    {15, "WOW32ResolveMultiMediaHandle"},
    {16, "WOWAppExit"},
    {17, "aux32Message"},
    {18, "auxGetDevCapsA"},
    {19, "auxGetDevCapsW"},
    {20, "auxGetNumDevs"},
    {21, "auxGetVolume"},
    {22, "auxOutMessage"},
    {23, "auxSetVolume"},
    {24, "joy32Message"},
    {25, "joyConfigChanged"},
    {26, "joyGetDevCapsA"},
    {27, "joyGetDevCapsW"},
    {28, "joyGetNumDevs"},
    {29, "joyGetPos"},
    {30, "joyGetPosEx"},
    {31, "joyGetThreshold"},
    {32, "joyReleaseCapture"},
    {33, "joySetCapture"},
    {34, "joySetThreshold"},
    {35, "mci32Message"},
    {36, "mciDriverNotify"},
    {37, "mciDriverYield"},
    {38, "mciExecute"},
    {39, "mciFreeCommandResource"},
    {40, "mciGetCreatorTask"},
    {41, "mciGetDeviceIDA"},
    {42, "mciGetDeviceIDFromElementIDA"},
    {43, "mciGetDeviceIDFromElementIDW"},
    {44, "mciGetDeviceIDW"},
    {45, "mciGetDriverData"},
    {46, "mciGetErrorStringA"},
    {47, "mciGetErrorStringW"},
    {48, "mciGetYieldProc"},
    {49, "mciLoadCommandResource"},
    {50, "mciSendCommandA"},
    {51, "mciSendCommandW"},
    {52, "mciSendStringA"},
    {53, "mciSendStringW"},
    {54, "mciSetDriverData"},
    {55, "mciSetYieldProc"},
    {56, "mid32Message"},
    {57, "midiConnect"},
    {58, "midiDisconnect"},
    {59, "midiInAddBuffer"},
    {60, "midiInClose"},
    {61, "midiInGetDevCapsA"},
    {62, "midiInGetDevCapsW"},
    {63, "midiInGetErrorTextA"},
    {64, "midiInGetErrorTextW"},
    {65, "midiInGetID"},
    {66, "midiInGetNumDevs"},
    {67, "midiInMessage"},
    {68, "midiInOpen"},
    {69, "midiInPrepareHeader"},
    {70, "midiInReset"},
    {71, "midiInStart"},
    {72, "midiInStop"},
    {73, "midiInUnprepareHeader"},
    {74, "midiOutCacheDrumPatches"},
    {75, "midiOutCachePatches"},
    {76, "midiOutClose"},
    {77, "midiOutGetDevCapsA"},
    {78, "midiOutGetDevCapsW"},
    {79, "midiOutGetErrorTextA"},
    {80, "midiOutGetErrorTextW"},
    {81, "midiOutGetID"},
    {82, "midiOutGetNumDevs"},
    {83, "midiOutGetVolume"},
    {84, "midiOutLongMsg"},
    {85, "midiOutMessage"},
    {86, "midiOutOpen"},
    {87, "midiOutPrepareHeader"},
    {88, "midiOutReset"},
    {89, "midiOutSetVolume"},
    {90, "midiOutShortMsg"},
    {91, "midiOutUnprepareHeader"},
    {92, "midiStreamClose"},
    {93, "midiStreamOpen"},
    {94, "midiStreamOut"},
    {95, "midiStreamPause"},
    {96, "midiStreamPosition"},
    {97, "midiStreamProperty"},
    {98, "midiStreamRestart"},
    {99, "midiStreamStop"},
    {100, "mixerClose"},
    {101, "mixerGetControlDetailsA"},
    {102, "mixerGetControlDetailsW"},
    {103, "mixerGetDevCapsA"},
    {104, "mixerGetDevCapsW"},
    {105, "mixerGetID"},
    {106, "mixerGetLineControlsA"},
    {107, "mixerGetLineControlsW"},
    {108, "mixerGetLineInfoA"},
    {109, "mixerGetLineInfoW"},
    {110, "mixerGetNumDevs"},
    {111, "mixerMessage"},
    {112, "mixerOpen"},
    {113, "mixerSetControlDetails"},
    {114, "mmDrvInstall"},
    {115, "mmGetCurrentTask"},
    {116, "mmTaskBlock"},
    {117, "mmTaskCreate"},
    {118, "mmTaskSignal"},
    {119, "mmTaskYield"},
    {120, "mmioAdvance"},
    {121, "mmioAscend"},
    {122, "mmioClose"},
    {123, "mmioCreateChunk"},
    {124, "mmioDescend"},
    {125, "mmioFlush"},
    {126, "mmioGetInfo"},
    {127, "mmioInstallIOProcA"},
    {128, "mmioInstallIOProcW"},
    {129, "mmioOpenA"},
    {130, "mmioOpenW"},
    {131, "mmioRead"},
    {132, "mmioRenameA"},
    {133, "mmioRenameW"},
    {134, "mmioSeek"},
    {135, "mmioSendMessage"},
    {136, "mmioSetBuffer"},
    {137, "mmioSetInfo"},
    {138, "mmioStringToFOURCCA"},
    {139, "mmioStringToFOURCCW"},
    {140, "mmioWrite"},
    {141, "mmsystemGetVersion"},
    {142, "mod32Message"},
    {143, "mxd32Message"},
    {144, "sndPlaySoundA"},
    {145, "sndPlaySoundW"},
    {146, "tid32Message"},
    {147, "timeBeginPeriod"},
    {148, "timeEndPeriod"},
    {149, "timeGetDevCaps"},
    {150, "timeGetSystemTime"},
    {151, "timeGetTime"},
    {152, "timeKillEvent"},
    {153, "timeSetEvent"},
    {154, "waveInAddBuffer"},
    {155, "waveInClose"},
    {156, "waveInGetDevCapsA"},
    {157, "waveInGetDevCapsW"},
    {158, "waveInGetErrorTextA"},
    {159, "waveInGetErrorTextW"},
    {160, "waveInGetID"},
    {161, "waveInGetNumDevs"},
    {162, "waveInGetPosition"},
    {163, "waveInMessage"},
    {164, "waveInOpen"},
    {165, "waveInPrepareHeader"},
    {166, "waveInReset"},
    {167, "waveInStart"},
    {168, "waveInStop"},
    {169, "waveInUnprepareHeader"},
    {170, "waveOutBreakLoop"},
    {171, "waveOutClose"},
    {172, "waveOutGetDevCapsA"},
    {173, "waveOutGetDevCapsW"},
    {174, "waveOutGetErrorTextA"},
    {175, "waveOutGetErrorTextW"},
    {176, "waveOutGetID"},
    {177, "waveOutGetNumDevs"},
    {178, "waveOutGetPitch"},
    {179, "waveOutGetPlaybackRate"},
    {180, "waveOutGetPosition"},
    {181, "waveOutGetVolume"},
    {182, "waveOutMessage"},
    {183, "waveOutOpen"},
    {184, "waveOutPause"},
    {185, "waveOutPrepareHeader"},
    {186, "waveOutReset"},
    {187, "waveOutRestart"},
    {188, "waveOutSetPitch"},
    {189, "waveOutSetPlaybackRate"},
    {190, "waveOutSetVolume"},
    {191, "waveOutUnprepareHeader"},
    {192, "waveOutWrite"},
    {193, "wid32Message"},
    {194, "wod32Message"},
    {0, NULL}};
static Dw32Ordinal winsatapi[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal winscard[] = {
    {1, "ClassInstall32"},
    {2, "SCardAccessNewReaderEvent"},
    {5, "SCardAccessStartedEvent"},
    {6, "SCardAddReaderToGroupA"},
    {7, "SCardAddReaderToGroupW"},
    {8, "SCardBeginTransaction"},
    {9, "SCardCancel"},
    {10, "SCardConnectA"},
    {11, "SCardConnectW"},
    {12, "SCardControl"},
    {13, "SCardDisconnect"},
    {14, "SCardEndTransaction"},
    {15, "SCardEstablishContext"},
    {16, "SCardForgetCardTypeA"},
    {17, "SCardForgetCardTypeW"},
    {18, "SCardForgetReaderA"},
    {19, "SCardForgetReaderGroupA"},
    {20, "SCardForgetReaderGroupW"},
    {21, "SCardForgetReaderW"},
    {22, "SCardFreeMemory"},
    {23, "SCardGetAttrib"},
    {24, "SCardGetCardTypeProviderNameA"},
    {25, "SCardGetCardTypeProviderNameW"},
    {26, "SCardGetProviderIdA"},
    {27, "SCardGetProviderIdW"},
    {28, "SCardGetStatusChangeA"},
    {29, "SCardGetStatusChangeW"},
    {30, "SCardGetTransmitCount"},
    {31, "SCardIntroduceCardTypeA"},
    {32, "SCardIntroduceCardTypeW"},
    {33, "SCardIntroduceReaderA"},
    {34, "SCardIntroduceReaderGroupA"},
    {35, "SCardIntroduceReaderGroupW"},
    {36, "SCardIntroduceReaderW"},
    {37, "SCardIsValidContext"},
    {38, "SCardListCardsA"},
    {39, "SCardListCardsW"},
    {40, "SCardListInterfacesA"},
    {41, "SCardListInterfacesW"},
    {42, "SCardListReaderGroupsA"},
    {43, "SCardListReaderGroupsW"},
    {44, "SCardListReadersA"},
    {45, "SCardListReadersW"},
    {46, "SCardLocateCardsA"},
    {47, "SCardLocateCardsByATRA"},
    {48, "SCardLocateCardsByATRW"},
    {49, "SCardLocateCardsW"},
    {50, "SCardReadCacheA"},
    {51, "SCardReadCacheW"},
    {52, "SCardReconnect"},
    {3, "SCardReleaseAllEvents"},
    {53, "SCardReleaseContext"},
    {4, "SCardReleaseNewReaderEvent"},
    {54, "SCardReleaseStartedEvent"},
    {55, "SCardRemoveReaderFromGroupA"},
    {56, "SCardRemoveReaderFromGroupW"},
    {57, "SCardSetAttrib"},
    {58, "SCardSetCardTypeProviderNameA"},
    {59, "SCardSetCardTypeProviderNameW"},
    {60, "SCardState"},
    {61, "SCardStatusA"},
    {62, "SCardStatusW"},
    {63, "SCardTransmit"},
    {64, "SCardWriteCacheA"},
    {65, "SCardWriteCacheW"},
    {66, "g_rgSCardRawPci"},
    {67, "g_rgSCardT0Pci"},
    {68, "g_rgSCardT1Pci"},
    {0, NULL}};
static Dw32Ordinal wintrust[] = {
    {11, "AddPersonalTrustDBPages"},
    {12, "CatalogCompactHashDatabase"},
    {13, "CryptCATAdminAcquireContext"},
    {14, "CryptCATAdminAddCatalog"},
    {15, "CryptCATAdminCalcHashFromFileHandle"},
    {16, "CryptCATAdminEnumCatalogFromHash"},
    {17, "CryptCATAdminPauseServiceForBackup"},
    {18, "CryptCATAdminReleaseCatalogContext"},
    {19, "CryptCATAdminReleaseContext"},
    {20, "CryptCATAdminRemoveCatalog"},
    {21, "CryptCATAdminResolveCatalogPath"},
    {22, "CryptCATAllocSortedMemberInfo"},
    {23, "CryptCATCDFClose"},
    {24, "CryptCATCDFEnumAttributes"},
    {25, "CryptCATCDFEnumAttributesWithCDFTag"},
    {26, "CryptCATCDFEnumCatAttributes"},
    {27, "CryptCATCDFEnumMembers"},
    {28, "CryptCATCDFEnumMembersByCDFTag"},
    {29, "CryptCATCDFEnumMembersByCDFTagEx"},
    {30, "CryptCATCDFOpen"},
    {31, "CryptCATCatalogInfoFromContext"},
    {32, "CryptCATClose"},
    {33, "CryptCATEnumerateAttr"},
    {34, "CryptCATEnumerateCatAttr"},
    {35, "CryptCATEnumerateMember"},
    {36, "CryptCATFreeSortedMemberInfo"},
    {37, "CryptCATGetAttrInfo"},
    {38, "CryptCATGetCatAttrInfo"},
    {39, "CryptCATGetMemberInfo"},
    {40, "CryptCATHandleFromStore"},
    {41, "CryptCATOpen"},
    {42, "CryptCATPersistStore"},
    {43, "CryptCATPutAttrInfo"},
    {44, "CryptCATPutCatAttrInfo"},
    {45, "CryptCATPutMemberInfo"},
    {46, "CryptCATStoreFromHandle"},
    {1, "CryptCATVerifyMember"},
    {47, "CryptSIPCreateIndirectData"},
    {2, "CryptSIPGetInfo"},
    {3, "CryptSIPGetRegWorkingFlags"},
    {48, "CryptSIPGetSignedDataMsg"},
    {49, "CryptSIPPutSignedDataMsg"},
    {50, "CryptSIPRemoveSignedDataMsg"},
    {51, "CryptSIPVerifyIndirectData"},
    {52, "DllRegisterServer"},
    {53, "DllUnregisterServer"},
    {54, "DriverCleanupPolicy"},
    {55, "DriverFinalPolicy"},
    {56, "DriverInitializePolicy"},
    {57, "FindCertsByIssuer"},
    {4, "GenericChainCertificateTrust"},
    {5, "GenericChainFinalProv"},
    {6, "HTTPSCertificateTrust"},
    {58, "HTTPSFinalProv"},
    {59, "IsCatalogFile"},
    {60, "MsCatConstructHashTag"},
    {61, "MsCatFreeHashTag"},
    {62, "OfficeCleanupPolicy"},
    {63, "OfficeInitializePolicy"},
    {64, "OpenPersonalTrustDBDialog"},
    {65, "OpenPersonalTrustDBDialogEx"},
    {66, "SoftpubAuthenticode"},
    {67, "SoftpubCheckCert"},
    {68, "SoftpubCleanup"},
    {7, "SoftpubDefCertInit"},
    {69, "SoftpubDllRegisterServer"},
    {70, "SoftpubDllUnregisterServer"},
    {71, "SoftpubDumpStructure"},
    {8, "SoftpubFreeDefUsageCallData"},
    {72, "SoftpubInitialize"},
    {9, "SoftpubLoadDefUsageCallData"},
    {73, "SoftpubLoadMessage"},
    {74, "SoftpubLoadSignature"},
    {75, "TrustDecode"},
    {76, "TrustFindIssuerCertificate"},
    {77, "TrustFreeDecode"},
    {78, "TrustIsCertificateSelfSigned"},
    {79, "TrustOpenStores"},
    {80, "WTHelperCertCheckValidSignature"},
    {10, "WTHelperCertFindIssuerCertificate"},
    {81, "WTHelperCertIsSelfSigned"},
    {82, "WTHelperCheckCertUsage"},
    {83, "WTHelperGetAgencyInfo"},
    {84, "WTHelperGetFileHandle"},
    {85, "WTHelperGetFileHash"},
    {86, "WTHelperGetFileName"},
    {87, "WTHelperGetKnownUsages"},
    {88, "WTHelperGetProvCertFromChain"},
    {89, "WTHelperGetProvPrivateDataFromChain"},
    {90, "WTHelperGetProvSignerFromChain"},
    {91, "WTHelperIsInRootStore"},
    {92, "WTHelperOpenKnownStores"},
    {93, "WTHelperProvDataFromStateData"},
    {94, "WVTAsn1CatMemberInfoDecode"},
    {95, "WVTAsn1CatMemberInfoEncode"},
    {96, "WVTAsn1CatNameValueDecode"},
    {97, "WVTAsn1CatNameValueEncode"},
    {98, "WVTAsn1SpcFinancialCriteriaInfoDecode"},
    {99, "WVTAsn1SpcFinancialCriteriaInfoEncode"},
    {100, "WVTAsn1SpcIndirectDataContentDecode"},
    {101, "WVTAsn1SpcIndirectDataContentEncode"},
    {102, "WVTAsn1SpcLinkDecode"},
    {103, "WVTAsn1SpcLinkEncode"},
    {104, "WVTAsn1SpcMinimalCriteriaInfoDecode"},
    {105, "WVTAsn1SpcMinimalCriteriaInfoEncode"},
    {106, "WVTAsn1SpcPeImageDataDecode"},
    {107, "WVTAsn1SpcPeImageDataEncode"},
    {108, "WVTAsn1SpcSigInfoDecode"},
    {109, "WVTAsn1SpcSigInfoEncode"},
    {110, "WVTAsn1SpcSpAgencyInfoDecode"},
    {111, "WVTAsn1SpcSpAgencyInfoEncode"},
    {112, "WVTAsn1SpcSpOpusInfoDecode"},
    {113, "WVTAsn1SpcSpOpusInfoEncode"},
    {114, "WVTAsn1SpcStatementTypeDecode"},
    {115, "WVTAsn1SpcStatementTypeEncode"},
    {116, "WinVerifyTrust"},
    {117, "WinVerifyTrustEx"},
    {118, "WintrustAddActionID"},
    {119, "WintrustAddDefaultForUsage"},
    {120, "WintrustCertificateTrust"},
    {121, "WintrustGetDefaultForUsage"},
    {122, "WintrustGetRegPolicyFlags"},
    {123, "WintrustLoadFunctionPointers"},
    {124, "WintrustRemoveActionID"},
    {125, "WintrustSetDefaultIncludePEPageHashes"},
    {126, "WintrustSetRegPolicyFlags"},
    {127, "mscat32DllRegisterServer"},
    {128, "mscat32DllUnregisterServer"},
    {129, "mssip32DllRegisterServer"},
    {130, "mssip32DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal wlanapi[] = {
    {1, "WlanAllocateMemory"},
    {2, "WlanCloseHandle"},
    {3, "WlanConnect"},
    {4, "WlanDeleteProfile"},
    {5, "WlanDisconnect"},
    {6, "WlanEnumInterfaces"},
    {7, "WlanExtractPsdIEDataList"},
    {8, "WlanFreeMemory"},
    {9, "WlanGetAvailableNetworkList"},
    {10, "WlanGetFilterList"},
    {11, "WlanGetInterfaceCapability"},
    {12, "WlanGetNetworkBssList"},
    {13, "WlanGetProfile"},
    {14, "WlanGetProfileCustomUserData"},
    {15, "WlanGetProfileList"},
    {16, "WlanGetSecuritySettings"},
    {17, "WlanHostedNetworkForceStart"},
    {18, "WlanHostedNetworkForceStop"},
    {19, "WlanHostedNetworkInitSettings"},
    {20, "WlanHostedNetworkQueryProperty"},
    {21, "WlanHostedNetworkQuerySecondaryKey"},
    {22, "WlanHostedNetworkQueryStatus"},
    {23, "WlanHostedNetworkRefreshSecuritySettings"},
    {24, "WlanHostedNetworkSetProperty"},
    {25, "WlanHostedNetworkSetSecondaryKey"},
    {26, "WlanHostedNetworkStartUsing"},
    {27, "WlanHostedNetworkStopUsing"},
    {28, "WlanIhvControl"},
    {29, "WlanOpenHandle"},
    {30, "WlanQueryAutoConfigParameter"},
    {31, "WlanQueryInterface"},
    {32, "WlanReasonCodeToString"},
    {33, "WlanRegisterNotification"},
    {34, "WlanRegisterVirtualStationNotification"},
    {35, "WlanRenameProfile"},
    {36, "WlanSaveTemporaryProfile"},
    {37, "WlanScan"},
    {38, "WlanSetAutoConfigParameter"},
    {39, "WlanSetFilterList"},
    {40, "WlanSetInterface"},
    {41, "WlanSetProfile"},
    {42, "WlanSetProfileCustomUserData"},
    {43, "WlanSetProfileEapUserData"},
    {44, "WlanSetProfileEapXmlUserData"},
    {45, "WlanSetProfileList"},
    {46, "WlanSetProfilePosition"},
    {47, "WlanSetPsdIEDataList"},
    {48, "WlanSetSecuritySettings"},
    {0, NULL}};
static Dw32Ordinal wlanui[] = {
    {3, "DllGetClassObject"},
    {4, "WLFreeProfile"},
    {5, "WLFreeProfileXml"},
    {1, "WLInvokeProfileUI"},
    {2, "WLInvokeProfileUIFromXMLFile"},
    {6, "WlanUIEditProfile"},
    {0, NULL}};
static Dw32Ordinal wldap32[] = {
    {16, "LdapGetLastError"},
    {18, "LdapMapErrorToWin32"},
    {29, "LdapUTF8ToUnicode"},
    {53, "LdapUnicodeToUTF8"},
    {304, "ber_alloc_t"},
    {303, "ber_bvdup"},
    {302, "ber_bvecfree"},
    {54, "ber_bvfree"},
    {307, "ber_first_element"},
    {309, "ber_flatten"},
    {301, "ber_free"},
    {300, "ber_init"},
    {308, "ber_next_element"},
    {306, "ber_peek_tag"},
    {310, "ber_printf"},
    {311, "ber_scanf"},
    {305, "ber_skip_tag"},
    {17, "cldap_open"},
    {55, "cldap_openA"},
    {28, "cldap_openW"},
    {10, "ldap_abandon"},
    {11, "ldap_add"},
    {56, "ldap_addA"},
    {42, "ldap_addW"},
    {57, "ldap_add_ext"},
    {58, "ldap_add_extA"},
    {62, "ldap_add_extW"},
    {63, "ldap_add_ext_s"},
    {64, "ldap_add_ext_sA"},
    {65, "ldap_add_ext_sW"},
    {44, "ldap_add_s"},
    {66, "ldap_add_sA"},
    {69, "ldap_add_sW"},
    {61, "ldap_bind"},
    {70, "ldap_bindA"},
    {71, "ldap_bindW"},
    {45, "ldap_bind_s"},
    {72, "ldap_bind_sA"},
    {73, "ldap_bind_sW"},
    {230, "ldap_check_filterA"},
    {231, "ldap_check_filterW"},
    {202, "ldap_cleanup"},
    {74, "ldap_close_extended_op"},
    {19, "ldap_compare"},
    {75, "ldap_compareA"},
    {76, "ldap_compareW"},
    {78, "ldap_compare_ext"},
    {80, "ldap_compare_extA"},
    {81, "ldap_compare_extW"},
    {83, "ldap_compare_ext_s"},
    {84, "ldap_compare_ext_sA"},
    {85, "ldap_compare_ext_sW"},
    {52, "ldap_compare_s"},
    {86, "ldap_compare_sA"},
    {87, "ldap_compare_sW"},
    {312, "ldap_conn_from_msg"},
    {88, "ldap_connect"},
    {89, "ldap_control_free"},
    {90, "ldap_control_freeA"},
    {91, "ldap_control_freeW"},
    {92, "ldap_controls_free"},
    {93, "ldap_controls_freeA"},
    {94, "ldap_controls_freeW"},
    {36, "ldap_count_entries"},
    {95, "ldap_count_references"},
    {37, "ldap_count_values"},
    {96, "ldap_count_valuesA"},
    {97, "ldap_count_valuesW"},
    {77, "ldap_count_values_len"},
    {98, "ldap_create_page_control"},
    {99, "ldap_create_page_controlA"},
    {100, "ldap_create_page_controlW"},
    {101, "ldap_create_sort_control"},
    {102, "ldap_create_sort_controlA"},
    {103, "ldap_create_sort_controlW"},
    {320, "ldap_create_vlv_controlA"},
    {319, "ldap_create_vlv_controlW"},
    {20, "ldap_delete"},
    {104, "ldap_deleteA"},
    {105, "ldap_deleteW"},
    {106, "ldap_delete_ext"},
    {107, "ldap_delete_extA"},
    {108, "ldap_delete_extW"},
    {109, "ldap_delete_ext_s"},
    {110, "ldap_delete_ext_sA"},
    {111, "ldap_delete_ext_sW"},
    {47, "ldap_delete_s"},
    {112, "ldap_delete_sA"},
    {113, "ldap_delete_sW"},
    {31, "ldap_dn2ufn"},
    {232, "ldap_dn2ufnA"},
    {114, "ldap_dn2ufnW"},
    {115, "ldap_encode_sort_controlA"},
    {116, "ldap_encode_sort_controlW"},
    {22, "ldap_err2string"},
    {117, "ldap_err2stringA"},
    {118, "ldap_err2stringW"},
    {197, "ldap_escape_filter_element"},
    {119, "ldap_escape_filter_elementA"},
    {120, "ldap_escape_filter_elementW"},
    {39, "ldap_explode_dn"},
    {121, "ldap_explode_dnA"},
    {122, "ldap_explode_dnW"},
    {123, "ldap_extended_operation"},
    {124, "ldap_extended_operationA"},
    {125, "ldap_extended_operationW"},
    {333, "ldap_extended_operation_sA"},
    {332, "ldap_extended_operation_sW"},
    {32, "ldap_first_attribute"},
    {126, "ldap_first_attributeA"},
    {127, "ldap_first_attributeW"},
    {26, "ldap_first_entry"},
    {128, "ldap_first_reference"},
    {129, "ldap_free_controls"},
    {130, "ldap_free_controlsA"},
    {131, "ldap_free_controlsW"},
    {30, "ldap_get_dn"},
    {132, "ldap_get_dnA"},
    {133, "ldap_get_dnW"},
    {134, "ldap_get_next_page"},
    {135, "ldap_get_next_page_s"},
    {136, "ldap_get_option"},
    {137, "ldap_get_optionA"},
    {12, "ldap_get_optionW"},
    {138, "ldap_get_paged_count"},
    {34, "ldap_get_values"},
    {139, "ldap_get_valuesA"},
    {140, "ldap_get_valuesW"},
    {35, "ldap_get_values_len"},
    {141, "ldap_get_values_lenA"},
    {142, "ldap_get_values_lenW"},
    {143, "ldap_init"},
    {144, "ldap_initA"},
    {145, "ldap_initW"},
    {200, "ldap_memfree"},
    {146, "ldap_memfreeA"},
    {147, "ldap_memfreeW"},
    {23, "ldap_modify"},
    {148, "ldap_modifyA"},
    {149, "ldap_modifyW"},
    {150, "ldap_modify_ext"},
    {151, "ldap_modify_extA"},
    {152, "ldap_modify_extW"},
    {153, "ldap_modify_ext_s"},
    {154, "ldap_modify_ext_sA"},
    {155, "ldap_modify_ext_sW"},
    {48, "ldap_modify_s"},
    {156, "ldap_modify_sA"},
    {157, "ldap_modify_sW"},
    {24, "ldap_modrdn"},
    {67, "ldap_modrdn2"},
    {158, "ldap_modrdn2A"},
    {159, "ldap_modrdn2W"},
    {68, "ldap_modrdn2_s"},
    {160, "ldap_modrdn2_sA"},
    {161, "ldap_modrdn2_sW"},
    {162, "ldap_modrdnA"},
    {163, "ldap_modrdnW"},
    {49, "ldap_modrdn_s"},
    {164, "ldap_modrdn_sA"},
    {165, "ldap_modrdn_sW"},
    {41, "ldap_msgfree"},
    {33, "ldap_next_attribute"},
    {166, "ldap_next_attributeA"},
    {167, "ldap_next_attributeW"},
    {27, "ldap_next_entry"},
    {168, "ldap_next_reference"},
    {25, "ldap_open"},
    {169, "ldap_openA"},
    {170, "ldap_openW"},
    {318, "ldap_parse_extended_resultA"},
    {317, "ldap_parse_extended_resultW"},
    {171, "ldap_parse_page_control"},
    {172, "ldap_parse_page_controlA"},
    {173, "ldap_parse_page_controlW"},
    {174, "ldap_parse_reference"},
    {175, "ldap_parse_referenceA"},
    {176, "ldap_parse_referenceW"},
    {177, "ldap_parse_result"},
    {178, "ldap_parse_resultA"},
    {179, "ldap_parse_resultW"},
    {180, "ldap_parse_sort_control"},
    {181, "ldap_parse_sort_controlA"},
    {182, "ldap_parse_sort_controlW"},
    {322, "ldap_parse_vlv_controlA"},
    {321, "ldap_parse_vlv_controlW"},
    {82, "ldap_perror"},
    {183, "ldap_rename_ext"},
    {184, "ldap_rename_extA"},
    {185, "ldap_rename_extW"},
    {186, "ldap_rename_ext_s"},
    {187, "ldap_rename_ext_sA"},
    {188, "ldap_rename_ext_sW"},
    {40, "ldap_result"},
    {21, "ldap_result2error"},
    {315, "ldap_sasl_bindA"},
    {313, "ldap_sasl_bindW"},
    {316, "ldap_sasl_bind_sA"},
    {314, "ldap_sasl_bind_sW"},
    {43, "ldap_search"},
    {189, "ldap_searchA"},
    {190, "ldap_searchW"},
    {191, "ldap_search_abandon_page"},
    {192, "ldap_search_ext"},
    {193, "ldap_search_extA"},
    {194, "ldap_search_extW"},
    {195, "ldap_search_ext_s"},
    {196, "ldap_search_ext_sA"},
    {203, "ldap_search_ext_sW"},
    {204, "ldap_search_init_page"},
    {205, "ldap_search_init_pageA"},
    {206, "ldap_search_init_pageW"},
    {50, "ldap_search_s"},
    {207, "ldap_search_sA"},
    {208, "ldap_search_sW"},
    {51, "ldap_search_st"},
    {209, "ldap_search_stA"},
    {210, "ldap_search_stW"},
    {198, "ldap_set_dbg_flags"},
    {199, "ldap_set_dbg_routine"},
    {211, "ldap_set_option"},
    {212, "ldap_set_optionA"},
    {14, "ldap_set_optionW"},
    {59, "ldap_simple_bind"},
    {213, "ldap_simple_bindA"},
    {214, "ldap_simple_bindW"},
    {60, "ldap_simple_bind_s"},
    {215, "ldap_simple_bind_sA"},
    {216, "ldap_simple_bind_sW"},
    {217, "ldap_sslinit"},
    {218, "ldap_sslinitA"},
    {219, "ldap_sslinitW"},
    {330, "ldap_start_tls_sA"},
    {329, "ldap_start_tls_sW"},
    {201, "ldap_startup"},
    {331, "ldap_stop_tls_s"},
    {220, "ldap_ufn2dn"},
    {221, "ldap_ufn2dnA"},
    {222, "ldap_ufn2dnW"},
    {13, "ldap_unbind"},
    {46, "ldap_unbind_s"},
    {38, "ldap_value_free"},
    {223, "ldap_value_freeA"},
    {224, "ldap_value_freeW"},
    {79, "ldap_value_free_len"},
    {0, NULL}};
static Dw32Ordinal wmdrmsdk[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {5, "MFWMDRMOutputTrustAuthority_CreateInstance"},
    {6, "WMDRMCreateProvider"},
    {7, "WMDRMShutdown"},
    {8, "WMDRMStartup"},
    {9, "_WMDRMCreateProvider"},
    {0, NULL}};
static Dw32Ordinal wmiutils[] = {
    {1, "DllCanUnloadNow"},
    {2, "DllGetClassObject"},
    {3, "DllRegisterServer"},
    {4, "DllUnregisterServer"},
    {0, NULL}};
static Dw32Ordinal wmvcore[] = {
    {8, "DllRegisterServer"},
    {1, "WMCheckURLExtension"},
    {2, "WMCheckURLScheme"},
    {9, "WMCreateBackupRestorer"},
    {3, "WMCreateBackupRestorerPrivate"},
    {10, "WMCreateEditor"},
    {11, "WMCreateIndexer"},
    {4, "WMCreateLicenseRevocationAgentPrivate"},
    {12, "WMCreateProfileManager"},
    {13, "WMCreateReader"},
    {14, "WMCreateReaderPriv"},
    {15, "WMCreateSyncReader"},
    {5, "WMCreateSyncReaderPriv"},
    {16, "WMCreateWriter"},
    {17, "WMCreateWriterFileSink"},
    {18, "WMCreateWriterNetworkSink"},
    {19, "WMCreateWriterPriv"},
    {20, "WMCreateWriterPushSink"},
    {6, "WMIsAvailableOffline"},
    {21, "WMIsContentProtected"},
    {7, "WMValidateData"},
    {0, NULL}};
static Dw32Ordinal wow32[] = {
    {1, "CopyDropFilesFrom16"},
    {2, "CopyDropFilesFrom32"},
    {3, "GetCommHandle"},
    {4, "GetCommShadowMSR"},
    {5, "W32Dispatch"},
    {6, "W32HungAppNotifyThread"},
    {7, "W32Init"},
    {8, "WOW32DriverCallback"},
    {9, "WOW32ResolveHandle"},
    {10, "WOW32ResolveMemory"},
    {11, "WOWCallback16"},
    {12, "WOWCallback16Ex"},
    {13, "WOWDirectedYield16"},
    {14, "WOWFreeMetafile"},
    {15, "WOWGetVDMPointer"},
    {16, "WOWGetVDMPointerFix"},
    {17, "WOWGetVDMPointerUnfix"},
    {18, "WOWGlobalAlloc16"},
    {19, "WOWGlobalAllocLock16"},
    {20, "WOWGlobalFree16"},
    {21, "WOWGlobalLock16"},
    {22, "WOWGlobalLockSize16"},
    {23, "WOWGlobalUnlock16"},
    {24, "WOWGlobalUnlockFree16"},
    {25, "WOWHandle16"},
    {26, "WOWHandle32"},
    {27, "WOWUseMciavi16"},
    {28, "WOWYield16"},
    {0, NULL}};
static Dw32Ordinal ws2_32[] = {
    {25, "FreeAddrInfoEx"},
    {26, "FreeAddrInfoExW"},
    {27, "FreeAddrInfoW"},
    {28, "GetAddrInfoExA"},
    {29, "GetAddrInfoExW"},
    {30, "GetAddrInfoW"},
    {31, "GetNameInfoW"},
    {32, "InetNtopW"},
    {33, "InetPtonW"},
    {34, "SetAddrInfoExA"},
    {35, "SetAddrInfoExW"},
    {500, "WEP"},
    {36, "WPUCompleteOverlappedRequest"},
    {37, "WSAAccept"},
    {38, "WSAAddressToStringA"},
    {39, "WSAAddressToStringW"},
    {40, "WSAAdvertiseProvider"},
    {102, "WSAAsyncGetHostByAddr"},
    {103, "WSAAsyncGetHostByName"},
    {105, "WSAAsyncGetProtoByName"},
    {104, "WSAAsyncGetProtoByNumber"},
    {107, "WSAAsyncGetServByName"},
    {106, "WSAAsyncGetServByPort"},
    {101, "WSAAsyncSelect"},
    {108, "WSACancelAsyncRequest"},
    {113, "WSACancelBlockingCall"},
    {116, "WSACleanup"},
    {41, "WSACloseEvent"},
    {42, "WSAConnect"},
    {43, "WSAConnectByList"},
    {44, "WSAConnectByNameA"},
    {45, "WSAConnectByNameW"},
    {46, "WSACreateEvent"},
    {47, "WSADuplicateSocketA"},
    {48, "WSADuplicateSocketW"},
    {49, "WSAEnumNameSpaceProvidersA"},
    {50, "WSAEnumNameSpaceProvidersExA"},
    {58, "WSAEnumNameSpaceProvidersExW"},
    {59, "WSAEnumNameSpaceProvidersW"},
    {60, "WSAEnumNetworkEvents"},
    {61, "WSAEnumProtocolsA"},
    {62, "WSAEnumProtocolsW"},
    {63, "WSAEventSelect"},
    {111, "WSAGetLastError"},
    {64, "WSAGetOverlappedResult"},
    {65, "WSAGetQOSByName"},
    {66, "WSAGetServiceClassInfoA"},
    {67, "WSAGetServiceClassInfoW"},
    {68, "WSAGetServiceClassNameByClassIdA"},
    {69, "WSAGetServiceClassNameByClassIdW"},
    {70, "WSAHtonl"},
    {71, "WSAHtons"},
    {72, "WSAInstallServiceClassA"},
    {73, "WSAInstallServiceClassW"},
    {74, "WSAIoctl"},
    {114, "WSAIsBlocking"},
    {75, "WSAJoinLeaf"},
    {76, "WSALookupServiceBeginA"},
    {77, "WSALookupServiceBeginW"},
    {78, "WSALookupServiceEnd"},
    {79, "WSALookupServiceNextA"},
    {80, "WSALookupServiceNextW"},
    {81, "WSANSPIoctl"},
    {82, "WSANtohl"},
    {83, "WSANtohs"},
    {84, "WSAPoll"},
    {85, "WSAProviderCompleteAsyncCall"},
    {86, "WSAProviderConfigChange"},
    {87, "WSARecv"},
    {88, "WSARecvDisconnect"},
    {89, "WSARecvFrom"},
    {90, "WSARemoveServiceClass"},
    {91, "WSAResetEvent"},
    {92, "WSASend"},
    {93, "WSASendDisconnect"},
    {94, "WSASendMsg"},
    {95, "WSASendTo"},
    {109, "WSASetBlockingHook"},
    {96, "WSASetEvent"},
    {112, "WSASetLastError"},
    {97, "WSASetServiceA"},
    {98, "WSASetServiceW"},
    {99, "WSASocketA"},
    {100, "WSASocketW"},
    {115, "WSAStartup"},
    {117, "WSAStringToAddressA"},
    {118, "WSAStringToAddressW"},
    {119, "WSAUnadvertiseProvider"},
    {110, "WSAUnhookBlockingHook"},
    {120, "WSAWaitForMultipleEvents"},
    {24, "WSApSetPostRoutine"},
    {121, "WSCDeinstallProvider"},
    {122, "WSCEnableNSProvider"},
    {123, "WSCEnumProtocols"},
    {124, "WSCGetApplicationCategory"},
    {125, "WSCGetProviderInfo"},
    {126, "WSCGetProviderPath"},
    {127, "WSCInstallNameSpace"},
    {128, "WSCInstallNameSpaceEx"},
    {129, "WSCInstallProvider"},
    {130, "WSCInstallProviderAndChains"},
    {131, "WSCSetApplicationCategory"},
    {132, "WSCSetProviderInfo"},
    {133, "WSCUnInstallNameSpace"},
    {134, "WSCUpdateProvider"},
    {135, "WSCWriteNameSpaceOrder"},
    {136, "WSCWriteProviderOrder"},
    {137, "WahCloseApcHelper"},
    {138, "WahCloseHandleHelper"},
    {139, "WahCloseNotificationHandleHelper"},
    {140, "WahCloseSocketHandle"},
    {141, "WahCloseThread"},
    {142, "WahCompleteRequest"},
    {143, "WahCreateHandleContextTable"},
    {144, "WahCreateNotificationHandle"},
    {145, "WahCreateSocketHandle"},
    {146, "WahDestroyHandleContextTable"},
    {147, "WahDisableNonIFSHandleSupport"},
    {148, "WahEnableNonIFSHandleSupport"},
    {149, "WahEnumerateHandleContexts"},
    {150, "WahInsertHandleContext"},
    {152, "WahNotifyAllProcesses"},
    {153, "WahOpenApcHelper"},
    {154, "WahOpenCurrentThread"},
    {155, "WahOpenHandleHelper"},
    {156, "WahOpenNotificationHandleHelper"},
    {157, "WahQueueUserApc"},
    {158, "WahReferenceContextByHandle"},
    {159, "WahRemoveHandleContext"},
    {160, "WahWaitForNotification"},
    {161, "WahWriteLSPEvent"},
    {151, "__WSAFDIsSet"},
    {1, "accept"},
    {2, "bind"},
    {3, "closesocket"},
    {4, "connect"},
    {162, "freeaddrinfo"},
    {163, "getaddrinfo"},
    {51, "gethostbyaddr"},
    {52, "gethostbyname"},
    {57, "gethostname"},
    {164, "getnameinfo"},
    {5, "getpeername"},
    {53, "getprotobyname"},
    {54, "getprotobynumber"},
    {55, "getservbyname"},
    {56, "getservbyport"},
    {6, "getsockname"},
    {7, "getsockopt"},
    {8, "htonl"},
    {9, "htons"},
    {11, "inet_addr"},
    {12, "inet_ntoa"},
    {165, "inet_ntop"},
    {166, "inet_pton"},
    {10, "ioctlsocket"},
    {13, "listen"},
    {14, "ntohl"},
    {15, "ntohs"},
    {16, "recv"},
    {17, "recvfrom"},
    {18, "select"},
    {19, "send"},
    {20, "sendto"},
    {21, "setsockopt"},
    {22, "shutdown"},
    {23, "socket"},
    {0, NULL}};
static Dw32Ordinal wscapi[] = {
    {1, "WscGetSecurityProviderHealth"},
    {2, "WscRegisterForChanges"},
    {3, "WscUnRegisterChanges"},
    {4, "wscAntiSpywareGetStatus"},
    {5, "wscAntiVirusGetStatus"},
    {6, "wscAutoUpdatesEnableScheduledMode"},
    {7, "wscAutoUpdatesGetStatus"},
    {8, "wscFirewallGetStatus"},
    {9, "wscGeneralSecurityGetStatus"},
    {10, "wscGetAlertStatus"},
    {11, "wscIcfEnable"},
    {12, "wscIeSettingsFix"},
    {13, "wscLuaSettingsFix"},
    {14, "wscOverrideComponentStatus"},
    {15, "wscPing"},
    {16, "wscProductInfoFree"},
    {17, "wscRegisterChangeNotification"},
    {18, "wscRegisterSecurityProduct"},
    {19, "wscUnRegisterChangeNotification"},
    {20, "wscUnregisterSecurityProduct"},
    {21, "wscUpdateProductStatus"},
    {0, NULL}};
static Dw32Ordinal wsdapi[] = {
    {1, "WSDAddFirewallCheck"},
    {7, "WSDAllocateLinkedMemory"},
    {8, "WSDAttachLinkedMemory"},
    {2, "WSDCancelNetworkChangeNotify"},
    {9, "WSDCompareEndpoints"},
    {10, "WSDCopyEndpoint"},
    {3, "WSDCopyNameList"},
    {12, "WSDCreateDeviceHost"},
    {11, "WSDCreateDeviceHost2"},
    {13, "WSDCreateDeviceHostAdvanced"},
    {15, "WSDCreateDeviceProxy"},
    {14, "WSDCreateDeviceProxy2"},
    {16, "WSDCreateDeviceProxyAdvanced"},
    {18, "WSDCreateDiscoveryProvider"},
    {17, "WSDCreateDiscoveryProvider2"},
    {20, "WSDCreateDiscoveryPublisher"},
    {19, "WSDCreateDiscoveryPublisher2"},
    {21, "WSDCreateHttpAddress"},
    {22, "WSDCreateHttpMessageParameters"},
    {23, "WSDCreateHttpTransport"},
    {24, "WSDCreateMetadataAgent"},
    {25, "WSDCreateOutboundAttachment"},
    {26, "WSDCreateUdpAddress"},
    {27, "WSDCreateUdpMessageParameters"},
    {28, "WSDCreateUdpTransport"},
    {29, "WSDDetachLinkedMemory"},
    {30, "WSDFreeLinkedMemory"},
    {31, "WSDGenerateFault"},
    {32, "WSDGenerateFaultEx"},
    {33, "WSDGenerateRandomDelay"},
    {34, "WSDGetConfigurationOption"},
    {4, "WSDNotifyNetworkChange"},
    {35, "WSDProcessFault"},
    {5, "WSDRemoveFirewallCheck"},
    {36, "WSDSetConfigurationOption"},
    {37, "WSDUriDecode"},
    {38, "WSDUriEncode"},
    {39, "WSDXMLAddChild"},
    {40, "WSDXMLAddSibling"},
    {41, "WSDXMLBuildAnyForSingleElement"},
    {42, "WSDXMLCleanupElement"},
    {6, "WSDXMLCompareNames"},
    {43, "WSDXMLCreateContext"},
    {44, "WSDXMLGetNameFromBuiltinNamespace"},
    {45, "WSDXMLGetValueFromAny"},
    {0, NULL}};
static Dw32Ordinal wsnmp32[] = {
    {222, "SnmpCancelMsg"},
    {201, "SnmpCleanup"},
    {292, "SnmpCleanupEx"},
    {203, "SnmpClose"},
    {401, "SnmpContextToStr"},
    {603, "SnmpCountVbl"},
    {500, "SnmpCreatePdu"},
    {220, "SnmpCreateSession"},
    {600, "SnmpCreateVbl"},
    {902, "SnmpDecodeMsg"},
    {606, "SnmpDeleteVb"},
    {503, "SnmpDuplicatePdu"},
    {601, "SnmpDuplicateVbl"},
    {901, "SnmpEncodeMsg"},
    {301, "SnmpEntityToStr"},
    {402, "SnmpFreeContext"},
    {900, "SnmpFreeDescriptor"},
    {302, "SnmpFreeEntity"},
    {504, "SnmpFreePdu"},
    {602, "SnmpFreeVbl"},
    {999, "SnmpGetLastError"},
    {501, "SnmpGetPduData"},
    {102, "SnmpGetRetransmitMode"},
    {106, "SnmpGetRetry"},
    {104, "SnmpGetTimeout"},
    {100, "SnmpGetTranslateMode"},
    {604, "SnmpGetVb"},
    {120, "SnmpGetVendorInfo"},
    {221, "SnmpListen"},
    {293, "SnmpListenEx"},
    {906, "SnmpOidCompare"},
    {905, "SnmpOidCopy"},
    {904, "SnmpOidToStr"},
    {202, "SnmpOpen"},
    {205, "SnmpRecvMsg"},
    {206, "SnmpRegister"},
    {204, "SnmpSendMsg"},
    {502, "SnmpSetPduData"},
    {320, "SnmpSetPort"},
    {103, "SnmpSetRetransmitMode"},
    {107, "SnmpSetRetry"},
    {105, "SnmpSetTimeout"},
    {101, "SnmpSetTranslateMode"},
    {605, "SnmpSetVb"},
    {200, "SnmpStartup"},
    {291, "SnmpStartupEx"},
    {400, "SnmpStrToContext"},
    {300, "SnmpStrToEntity"},
    {903, "SnmpStrToOid"},
    {108, "_SnmpConveyAgentAddress@4"},
    {109, "_SnmpSetAgentAddress@4"},
    {0, NULL}};
static Dw32Ordinal wsock32[] = {
    {1141, "AcceptEx"},
    {1111, "EnumProtocolsA"},
    {1112, "EnumProtocolsW"},
    {1142, "GetAcceptExSockaddrs"},
    {1109, "GetAddressByNameA"},
    {1110, "GetAddressByNameW"},
    {1115, "GetNameByTypeA"},
    {1116, "GetNameByTypeW"},
    {1119, "GetServiceA"},
    {1120, "GetServiceW"},
    {1113, "GetTypeByNameA"},
    {1114, "GetTypeByNameW"},
    {24, "MigrateWinsockConfiguration"},
    {1130, "NPLoadNameSpaces"},
    {1117, "SetServiceA"},
    {1118, "SetServiceW"},
    {1140, "TransmitFile"},
    {500, "WEP"},
    {102, "WSAAsyncGetHostByAddr"},
    {103, "WSAAsyncGetHostByName"},
    {105, "WSAAsyncGetProtoByName"},
    {104, "WSAAsyncGetProtoByNumber"},
    {107, "WSAAsyncGetServByName"},
    {106, "WSAAsyncGetServByPort"},
    {101, "WSAAsyncSelect"},
    {108, "WSACancelAsyncRequest"},
    {113, "WSACancelBlockingCall"},
    {116, "WSACleanup"},
    {111, "WSAGetLastError"},
    {114, "WSAIsBlocking"},
    {1107, "WSARecvEx"},
    {109, "WSASetBlockingHook"},
    {112, "WSASetLastError"},
    {115, "WSAStartup"},
    {110, "WSAUnhookBlockingHook"},
    {1000, "WSApSetPostRoutine"},
    {151, "__WSAFDIsSet"},
    {1, "accept"},
    {2, "bind"},
    {3, "closesocket"},
    {4, "connect"},
    {1106, "dn_expand"},
    {51, "gethostbyaddr"},
    {52, "gethostbyname"},
    {57, "gethostname"},
    {1101, "getnetbyname"},
    {5, "getpeername"},
    {53, "getprotobyname"},
    {54, "getprotobynumber"},
    {55, "getservbyname"},
    {56, "getservbyport"},
    {6, "getsockname"},
    {7, "getsockopt"},
    {8, "htonl"},
    {9, "htons"},
    {10, "inet_addr"},
    {1100, "inet_network"},
    {11, "inet_ntoa"},
    {12, "ioctlsocket"},
    {13, "listen"},
    {14, "ntohl"},
    {15, "ntohs"},
    {1102, "rcmd"},
    {16, "recv"},
    {17, "recvfrom"},
    {1103, "rexec"},
    {1104, "rresvport"},
    {1108, "s_perror"},
    {18, "select"},
    {19, "send"},
    {20, "sendto"},
    {1105, "sethostname"},
    {21, "setsockopt"},
    {22, "shutdown"},
    {23, "socket"},
    {0, NULL}};
static Dw32Ordinal wtsapi32[] = {
    {1, "WTSCloseServer"},
    {2, "WTSConnectSessionA"},
    {3, "WTSConnectSessionW"},
    {4, "WTSCreateListenerA"},
    {5, "WTSCreateListenerW"},
    {6, "WTSDisconnectSession"},
    {7, "WTSEnumerateListenersA"},
    {8, "WTSEnumerateListenersW"},
    {9, "WTSEnumerateProcessesA"},
    {10, "WTSEnumerateProcessesExA"},
    {11, "WTSEnumerateProcessesExW"},
    {12, "WTSEnumerateProcessesW"},
    {13, "WTSEnumerateServersA"},
    {14, "WTSEnumerateServersW"},
    {15, "WTSEnumerateSessionsA"},
    {16, "WTSEnumerateSessionsExA"},
    {17, "WTSEnumerateSessionsExW"},
    {18, "WTSEnumerateSessionsW"},
    {19, "WTSFreeMemory"},
    {20, "WTSFreeMemoryExA"},
    {21, "WTSFreeMemoryExW"},
    {22, "WTSGetListenerSecurityA"},
    {23, "WTSGetListenerSecurityW"},
    {24, "WTSLogoffSession"},
    {25, "WTSOpenServerA"},
    {26, "WTSOpenServerExA"},
    {27, "WTSOpenServerExW"},
    {28, "WTSOpenServerW"},
    {29, "WTSQueryListenerConfigA"},
    {30, "WTSQueryListenerConfigW"},
    {31, "WTSQuerySessionInformationA"},
    {32, "WTSQuerySessionInformationW"},
    {33, "WTSQueryUserConfigA"},
    {34, "WTSQueryUserConfigW"},
    {35, "WTSQueryUserToken"},
    {36, "WTSRegisterSessionNotification"},
    {37, "WTSRegisterSessionNotificationEx"},
    {38, "WTSSendMessageA"},
    {39, "WTSSendMessageW"},
    {40, "WTSSetListenerSecurityA"},
    {41, "WTSSetListenerSecurityW"},
    {42, "WTSSetSessionInformationA"},
    {43, "WTSSetSessionInformationW"},
    {44, "WTSSetUserConfigA"},
    {45, "WTSSetUserConfigW"},
    {46, "WTSShutdownSystem"},
    {47, "WTSStartRemoteControlSessionA"},
    {48, "WTSStartRemoteControlSessionW"},
    {49, "WTSStopRemoteControlSession"},
    {50, "WTSTerminateProcess"},
    {51, "WTSUnRegisterSessionNotification"},
    {52, "WTSUnRegisterSessionNotificationEx"},
    {53, "WTSVirtualChannelClose"},
    {54, "WTSVirtualChannelOpen"},
    {55, "WTSVirtualChannelOpenEx"},
    {56, "WTSVirtualChannelPurgeInput"},
    {57, "WTSVirtualChannelPurgeOutput"},
    {58, "WTSVirtualChannelQuery"},
    {59, "WTSVirtualChannelRead"},
    {60, "WTSVirtualChannelWrite"},
    {61, "WTSWaitSystemEvent"},
    {0, NULL}};
static Dw32Ordinal xmllite[] = {
    {1, "CreateXmlReader"},
    {2, "CreateXmlReaderInputWithEncodingCodePage"},
    {3, "CreateXmlReaderInputWithEncodingName"},
    {4, "CreateXmlWriter"},
    {5, "CreateXmlWriterOutputWithEncodingCodePage"},
    {6, "CreateXmlWriterOutputWithEncodingName"},
    {0, NULL}};
static Dw32Ordinal xolehlp[] = {
    {5, "DtcGetTransactionManager"},
    {7, "DtcGetTransactionManagerC"},
    {6, "DtcGetTransactionManagerEx"},
    {10, "DtcGetTransactionManagerExA"},
    {11, "DtcGetTransactionManagerExW"},
    {8, "FreezeLocalTransactionManagers"},
    {4, "GetDtcLocaleResourceHandle"},
    {9, "ThawLocalTransactionManagers"},
    {0, NULL}};


static struct
{
  const gchar *file;
  const Dw32Ordinal *ordinal;
} dll[] = {
    {"aclui", aclui},
    {"activeds", activeds},
    {"advapi32", advapi32},
    {"asycfilt", asycfilt},
    {"atl", atl},
    {"authz", authz},
    {"avrt", avrt},
    {"bcrypt", bcrypt},
    {"cabinet", cabinet},
    {"clfsw32", clfsw32},
    {"clusapi", clusapi},
    {"comctl32", comctl32},
    {"comdlg32", comdlg32},
    {"comsvcs", comsvcs},
    {"credui", credui},
    {"crypt32", crypt32},
    {"cryptnet", cryptnet},
    {"cryptui", cryptui},
    {"ctl3d32", ctl3d32},
    {"d3d10", d3d10},
    {"d3d8thk", d3d8thk},
    {"d3d9", d3d9},
    {"dbgeng", dbgeng},
    {"dbghelp", dbghelp},
    {"dciman32", dciman32},
    {"ddraw", ddraw},
    {"dhcpcsvc", dhcpcsvc},
    {"dhcpcsvc6", dhcpcsvc6},
    {"dhcpsapi", dhcpsapi},
    {"dinput", dinput},
    {"dnsapi", dnsapi},
    {"dplayx", dplayx},
    {"dpx", dpx},
    {"dsound", dsound},
    {"dsprop", dsprop},
    {"dsuiext", dsuiext},
    {"dwmapi", dwmapi},
    {"dxgi", dxgi},
    {"dxva2", dxva2},
    {"eappcfg", eappcfg},
    {"eappprxy", eappprxy},
    {"encapi", encapi},
    {"esent", esent},
    {"evr", evr},
    {"faultrep", faultrep},
    {"framedyn", framedyn},
    {"fwpuclnt", fwpuclnt},
    {"fxsutility", fxsutility},
    {"gdi32", gdi32},
    {"glu32", glu32},
    {"gpedit", gpedit},
    {"hlink", hlink},
    {"httpapi", httpapi},
    {"icm32", icm32},
    {"icmui", icmui},
    {"iconv", iconv},
    {"imagehlp", imagehlp},
    {"imm32", imm32},
    {"infocardapi", infocardapi},
    {"intl", intl},
    {"iphlpapi", iphlpapi},
    {"iprop", iprop},
    {"iscsidsc", iscsidsc},
    {"kernel32", kernel32},
    {"ksuser", ksuser},
    {"ktmw32", ktmw32},
    {"libexpat", libexpat},
    {"libpng13", libpng13},
    {"libtiff", libtiff},
    {"loadperf", loadperf},
    {"lz32", lz32},
    {"magnification", magnification},
    {"mapi32", mapi32},
    {"mf", mf},
    {"mfc42", mfc42},
    {"mfc42d", mfc42d},
    {"mfc42u", mfc42u},
    {"mfc42ud", mfc42ud},
    {"mfcclwz", mfcclwz},
    {"mfcd42d", mfcd42d},
    {"mfcd42ud", mfcd42ud},
    {"mfcn42d", mfcn42d},
    {"mfcn42ud", mfcn42ud},
    {"mfco42d", mfco42d},
    {"mfco42ud", mfco42ud},
    {"mfplat", mfplat},
    {"mgmtapi", mgmtapi},
    {"mpr", mpr},
    {"mprapi", mprapi},
    {"msacm32", msacm32},
    {"mscms", mscms},
    {"mscoree", mscoree},
    {"msctfmonitor", msctfmonitor},
    {"msdelta", msdelta},
    {"msdmo", msdmo},
    {"msdrm", msdrm},
    {"msdtcprx", msdtcprx},
    {"msdtctm", msdtctm},
    {"msi", msi},
    {"msimg32", msimg32},
    {"msrating", msrating},
    {"mstask", mstask},
    {"msvcirt", msvcirt},
    {"msvcirtd", msvcirtd},
    {"msvcrt", msvcrt},
    {"msvcrtd", msvcrtd},
    {"mswsock", mswsock},
    {"msxml6", msxml6},
    {"mtxdm", mtxdm},
    {"mtxoci", mtxoci},
    {"ncrypt", ncrypt},
    {"nddeapi", nddeapi},
    {"ndfapi", ndfapi},
    {"ndproxystub", ndproxystub},
    {"netapi32", netapi32},
    {"newdev", newdev},
    {"normaliz", normaliz},
    {"ntdsapi", ntdsapi},
    {"odbc32", odbc32},
    {"odbcbcp", odbcbcp},
    {"odbccp32", odbccp32},
    {"ole32", ole32},
    {"oleacc", oleacc},
    {"oleaut32", oleaut32},
    {"oledlg", oledlg},
    {"olepro32", olepro32},
    {"opengl32", opengl32},
    {"p2p", p2p},
    {"p2pgraph", p2pgraph},
    {"pdh", pdh},
    {"powrprof", powrprof},
    {"prntvpt", prntvpt},
    {"propsys", propsys},
    {"psapi", psapi},
    {"quartz", quartz},
    {"qutil", qutil},
    {"qwave", qwave},
    {"rasapi32", rasapi32},
    {"rasdlg", rasdlg},
    {"resutils", resutils},
    {"riched20", riched20},
    {"rpcns4", rpcns4},
    {"rpcrt4", rpcrt4},
    {"rstrtmgr", rstrtmgr},
    {"rtm", rtm},
    {"rtutils", rtutils},
    {"scarddlg", scarddlg},
    {"secur32", secur32},
    {"sensapi", sensapi},
    {"setupapi", setupapi},
    {"sfc", sfc},
    {"shell32", shell32},
    {"shfolder", shfolder},
    {"shlwapi", shlwapi},
    {"sisbkup", sisbkup},
    {"slc", slc},
    {"slcext", slcext},
    {"slwga", slwga},
    {"snmpapi", snmpapi},
    {"srclient", srclient},
    {"sti", sti},
    {"structuredquery", structuredquery},
    {"tapi32", tapi32},
    {"taskschd", taskschd},
    {"tbs", tbs},
    {"tdh", tdh},
    {"traffic", traffic},
    {"uiautomationcore", uiautomationcore},
    {"url", url},
    {"urlmon", urlmon},
    {"user32", user32},
    {"userenv", userenv},
    {"usp10", usp10},
    {"uxtheme", uxtheme},
    {"vdmdbg", vdmdbg},
    {"version", version},
    {"vssapi", vssapi},
    {"wecapi", wecapi},
    {"wer", wer},
    {"wevtapi", wevtapi},
    {"win32spl", win32spl},
    {"windowscodecs", windowscodecs},
    {"winfax", winfax},
    {"winhttp", winhttp},
    {"wininet", wininet},
    {"winmm", winmm},
    {"winsatapi", winsatapi},
    {"winscard", winscard},
    {"wintrust", wintrust},
    {"wlanapi", wlanapi},
    {"wlanui", wlanui},
    {"wldap32", wldap32},
    {"wmdrmsdk", wmdrmsdk},
    {"wmiutils", wmiutils},
    {"wmvcore", wmvcore},
    {"wow32", wow32},
    {"ws2_32", ws2_32},
    {"wscapi", wscapi},
    {"wsdapi", wsdapi},
    {"wsnmp32", wsnmp32},
    {"wsock32", wsock32},
    {"wtsapi32", wtsapi32},
    {"xmllite", xmllite},
    {"xolehlp", xolehlp},
    {NULL, NULL}};


/*  ja:オーディナル値から名前を求める
       path,ファイル名
    ordinal,オーディナル値
        RET,名前                                                            */
const gchar *
ordinal_lookup_name (const gchar *path,
                     const gint   ordinal)
{
  const gchar *name = NULL;

  if (path)
    {
      gint i;
      gchar *p, *file;

      file = g_ascii_strdown (path, -1);
      p = g_strrchr (file, '.');
      if (p && g_strcmp (p, ".dll") == 0)
        *p = '\0';
      for (i = 0; dll[i].file; i++)
        if (g_strcmp (dll[i].file, file) == 0)
          {
            gint j;

            for (j = 0; dll[i].ordinal[j].name; j++)
              if (dll[i].ordinal[j].ordinal == ordinal)
                name = dll[i].ordinal[j].name;
          }
      g_free (file);
    }
  return name;
}
