/*
    disw32
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __DATA_H__
#define __DATA_H__


#include "disw32.h"


G_BEGIN_DECLS


/******************************************************************************
*                                                                             *
* ja:データ関数                                                               *
*                                                                             *
******************************************************************************/
typedef struct _Dw32Data
{
  const gsize size;
  const gchar *name;
} Dw32Data;


/*  ja:BYTE単位データを作る
      info,イメージ情報構造体
     index,インデックス
      size,サイズ(バイト単位)
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_byte (Dw32Info    *info,
                     const gint   index,
                     const gsize  size,
                     const gint   belong);


/*  ja:WORD単位データを作る
      info,イメージ情報構造体
     index,インデックス
      size,サイズ(バイト単位)
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_word (Dw32Info    *info,
                     const gint   index,
                     const gsize  size,
                     const gint   belong);


/*  ja:DWORD単位データを作る
      info,イメージ情報構造体
     index,インデックス
      size,サイズ(バイト単位)
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_dword (Dw32Info    *info,
                      const gint   index,
                      const gsize  size,
                      const gint   belong);


/*  ja:構造体データを作る
      info,イメージ情報構造体
     index,インデックス
      data,構造体定義
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_struct (Dw32Info       *info,
                       const gint      index,
                       const Dw32Data *data,
                       const gint      belong);


/*  ja:文字列データを作る
      info,イメージ情報構造体
     index,インデックス
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_string (Dw32Info   *info,
                       const gint  index,
                       const gint  belong);


/*  ja:ワイド文字列データを作る
      info,イメージ情報構造体
     index,インデックス
    belong,所属
       RET,作られたバイト数                                                 */
gsize
dw32_data_make_stringw (Dw32Info   *info,
                        const gint  index,
                        const gint  belong);


/*  ja:文字列を判定する
     info,イメージ情報構造体
    index,インデックス
      RET,バイト数,-1:文字列ではない                                        */
gint
dw32_data_is_string (Dw32Info   *info,
                     const gint  index);


/*  ja:ワイド文字列を判定する
     info,イメージ情報構造体
    index,インデックス
      RET,バイト数,-1:ワイド文字列ではない                                  */
gint
dw32_data_is_stringw (Dw32Info   *info,
                      const gint  index);


G_END_DECLS


#endif /* __DATA_H__ */
