/*
copyright (c) 2006-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef _LIBICONV_H
#define _LIBICONV_H


#include <errno.h>
#include <stddef.h>


#define _LIBICONV_VERSION 0x010c
#define iconv_open libiconv_open
#define iconv_close libiconv_close
#define iconv libiconv
#define iconvlist libiconvlist


typedef void *iconv_t;


extern int _libiconv_version;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


iconv_t
libiconv_open (const char *tocode,
               const char *fromcode);


int
libiconv_close (iconv_t cd);


size_t
libiconv (iconv_t   cd,
          char    **inbuf,
          size_t   *inbytesleft,
          char    **outbuf,
          size_t   *outbytesleft);


void
libiconvlist (int (*do_one) (unsigned int        namescount,
                             const char * const *names,
                             void               *data),
              void *data);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _LIBICONV_H */
