/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* $Id: test-stdwidget.c,v 1.1 2003/07/27 13:49:52 makeinu Exp $ */


#include <string.h>
#include <gtk/gtk.h>


static GtkWidget *window = NULL;
static GtkWidget *entry = NULL;
static GtkWidget *textview = NULL;
static GtkWidget *treeview = NULL;


static void
cb_use_preedit (GtkButton *button, gpointer data)
{
    gboolean use_preedit = GPOINTER_TO_INT (data);

    gtk_im_context_set_use_preedit (GTK_ENTRY (entry)->im_context,
                                    use_preedit);
    gtk_im_context_set_use_preedit (GTK_TEXT_VIEW (textview)->im_context,
                                    use_preedit);
}


static GtkWidget *
create_tree_view (void)
{
    GtkWidget *container;
	GtkListStore *store =
        gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	GtkTreeIter iter;
	GtkCellRenderer *cell;

	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter,
                        0, "Please edit me",
                        1, TRUE,
                        -1);

	container = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
	cell = gtk_cell_renderer_text_new ();
	gtk_tree_view_insert_column_with_attributes
        (GTK_TREE_VIEW (container),
         0, "column1", cell,
         "text", 0, "editable", 1, NULL);

    return container;
}


static GtkWidget *
create_window (void)
{
    GtkWidget *window, *vbox, *hbox, *button;
    GtkLabel *label;
    GtkAccelGroup *accel_group;
    guint keyval;

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size (GTK_WINDOW (window),
                                 400, 400);
    /*
    gtk_window_move (GTK_WINDOW (window), 10, 50);
    gtk_window_resize (GTK_WINDOW (window), 150, 150);
    */

    accel_group = gtk_accel_group_new ();
    gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);
    gtk_widget_show (vbox);

    entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 0);
    gtk_widget_show (entry);

    textview = gtk_text_view_new ();
    gtk_box_pack_start (GTK_BOX (vbox), textview, TRUE, TRUE, 0);
    gtk_widget_show (textview);

    treeview = create_tree_view ();
    gtk_box_pack_start (GTK_BOX (vbox), treeview, TRUE, TRUE, 0);
    gtk_widget_show (treeview);

    /*
     *  button area
     */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);

    button = gtk_button_new_with_label ("preedit=_TRUE");
    label = GTK_LABEL (GTK_BIN (button)->child);
    gtk_label_set_use_underline (label, TRUE);
    keyval = gtk_label_get_mnemonic_keyval (label);
    gtk_widget_add_accelerator (button, "clicked", accel_group,
                                keyval, GDK_MOD1_MASK,
                                GTK_ACCEL_VISIBLE);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (cb_use_preedit), GINT_TO_POINTER (1));
    gtk_widget_show (button);

    button = gtk_button_new_with_label ("preedit=_FALSE");
    label = GTK_LABEL (GTK_BIN (button)->child);
    gtk_label_set_use_underline (label, TRUE);
    keyval = gtk_label_get_mnemonic_keyval (label);
    gtk_widget_add_accelerator (button, "clicked", accel_group,
                                keyval, GDK_MOD1_MASK,
                                GTK_ACCEL_VISIBLE);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
                      G_CALLBACK (cb_use_preedit), GINT_TO_POINTER (0));
    gtk_widget_show (button);

    return window;
}


static void
destroy_window_cb (GtkWidget *widget, gpointer data)
{
    gtk_main_quit ();
}


int
main (int argc, char *argv[])
{
    gtk_set_locale ();
    gtk_init (&argc, &argv);

    window = create_window ();
    gtk_widget_show (window);
    g_signal_connect (G_OBJECT (window), "destroy",
                      G_CALLBACK (destroy_window_cb), window);

    gtk_main ();

    return 0;
}
