/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.project;

import java.awt.Frame;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.sourceforge.gtibuilder.io.ProjectReader;
import jp.sourceforge.gtibuilder.main.NewDialog;
import jp.sourceforge.gtibuilder.main.NewWindowListener;
import jp.sourceforge.gtibuilder.main.WindowManager;
import jp.sourceforge.gtibuilder.project.NameUpdataEvent;
import jp.sourceforge.gtibuilder.project.NameUpdataListener;
import jp.sourceforge.gtibuilder.project.Project;

public class ProjectManager
extends JPanel
implements NewWindowListener,
NameUpdataListener {
    JTabbedPane tp = null;
    JMenuBar bar = null;
    boolean barSet = false;
    WindowManager manager;

    public ProjectManager() {
        this.setLayout(new GridLayout(1, 1));
        this.manager = new WindowManager();
    }

    public void add(Project pro) {
        if (this.tp == null) {
            this.tp = new JTabbedPane();
            this.add(this.tp);
        }
        pro.addNameUpdataListener(this);
        this.tp.addTab(pro.getProjectName(), pro);
    }

    public Project getProject() {
        if (this.tp == null) {
            return null;
        }
        return (Project)this.tp.getSelectedComponent();
    }

    public void openProject() {
        JFileChooser chooser = new JFileChooser();
        int re = chooser.showOpenDialog(null);
        if (re == 0) {
            File file = chooser.getSelectedFile();
            Project project = ProjectReader.read(file, this);
            this.add(project);
        }
    }

    public void remove(Project pro) {
        if (this.tp == null) {
            return;
        }
        this.tp.remove(pro);
    }

    public void closeProject() {
        Project p = this.getProject();
        this.remove(p);
    }

    public void newFile() {
        NewDialog np = new NewDialog(this);
        np.show();
    }

    public boolean exit() {
        return true;
    }

    public void setJMenuBar(JMenuBar menu) {
        if (!this.barSet) {
            this.bar = menu;
            this.barSet = true;
        }
    }

    public void addWindow(Frame window) {
        this.manager.addWindow(window);
    }

    public void addWindow(JInternalFrame frame) {
        this.manager.addWindow(frame);
    }

    public void updataName(NameUpdataEvent event) {
        this.tp.setTitleAt(this.tp.indexOfComponent((Project)event.getSource()), event.getNewName());
        this.tp.setToolTipTextAt(this.tp.indexOfComponent((Project)event.getSource()), ((Project)event.getSource()).getComment());
    }

    public WindowManager getWindowManager() {
        return this.manager;
    }
}

