/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.sourceforge.gtibuilder.editor.Editor;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileDataBase;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.project.Project;
import jp.sourceforge.gtibuilder.project.ProjectManager;
import jp.sourceforge.gtibuilder.util.Debug;
import jp.sourceforge.gtibuilder.util.StringArray;

public class ProjectReader {
    private ProjectReader() {
    }

    public static Project read(File file, ProjectManager manager) {
        try {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            Project project = null;
            Vector<Editor> editors = new Vector<Editor>();
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.getName().equals("gtibuilder")) {
                    ByteArrayOutputStream str = new ByteArrayOutputStream();
                    int data = 0;
                    while ((data = ((InflaterInputStream)zip).read()) != -1) {
                        str.write(data);
                    }
                    byte[] arrayData = str.toByteArray();
                    project = new Project(arrayData, manager.getWindowManager());
                } else {
                    String extension = entry.getName().substring(entry.getName().lastIndexOf(46) + 1);
                    FileType type = FileDataBase.getWithExtension(extension);
                    EditorComponent comp = type.getEditor();
                    if (comp != null) {
                        StringArray array = new StringArray();
                        array.add("NAME", entry.getName().substring(entry.getName().lastIndexOf(47) + 1));
                        array.add("PACKAGE", entry.getName().substring(0, entry.getName().lastIndexOf(47)));
                        comp.init(array, type);
                        editors.addElement(new Editor(comp));
                    }
                }
                zip.closeEntry();
            }
            if (project != null) {
                Enumeration e = editors.elements();
                while (e.hasMoreElements()) {
                    project.addEditor((Editor)e.nextElement());
                }
                return project;
            }
            return null;
        }
        catch (IOException ioe) {
            Debug.print(ioe);
            return null;
        }
    }
}

