/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.gtibuilder.editor;

import java.awt.Component;
import java.awt.Dialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.sourceforge.gtibuilder.editor.EditorComponent;
import jp.sourceforge.gtibuilder.io.FileType;
import jp.sourceforge.gtibuilder.main.DefaultNewPanel;
import jp.sourceforge.gtibuilder.main.NewPanel;
import jp.sourceforge.gtibuilder.util.StringArray;

public class TextEditor
implements EditorComponent,
DocumentListener {
    private JTextPane jtp = new JTextPane();
    private JScrollPane sp = new JScrollPane(this.jtp);
    private boolean inited = false;
    private boolean autoCheck = false;
    private FileType ft = null;
    private boolean edited = false;
    private String name = null;
    private String pack = null;

    public void insertUpdate(DocumentEvent e) {
        this.edited = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.edited = true;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public boolean readData(byte[] data) {
        this.isInited();
        String text = new String(data);
        this.jtp.setText(text);
        return true;
    }

    public byte[] getData() {
        this.isInited();
        String text = this.jtp.getText();
        byte[] array = text.getBytes();
        return array;
    }

    public FileType getFileType() {
        this.isInited();
        return this.ft;
    }

    public boolean setFileType(FileType ft) {
        this.isInited();
        if (this.isSupportedType(ft)) {
            this.ft = ft;
            return true;
        }
        return false;
    }

    public boolean isAutoCheckProperty() {
        this.isInited();
        return this.autoCheck;
    }

    public String getFileName() {
        this.isInited();
        return this.name;
    }

    public boolean setFileName(String name) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.name = name;
        return true;
    }

    public String getPackage() {
        this.isInited();
        return this.pack;
    }

    public boolean setPackage(String pack) {
        this.isInited();
        if (this.isAutoCheckProperty()) {
            return false;
        }
        this.pack = pack;
        return true;
    }

    public boolean close() {
        int re;
        this.isInited();
        return !this.edited || (re = JOptionPane.showConfirmDialog(null, "Are you sure close this file?", "Close", 0)) != 1;
    }

    public JMenu[] usingMenu() {
        return null;
    }

    public boolean usingEditMenu() {
        return true;
    }

    public void copy() {
        this.isInited();
    }

    public void cut() {
        this.isInited();
    }

    public void delete() {
        this.isInited();
    }

    public void paste() {
        this.isInited();
    }

    public void undo() {
        this.isInited();
    }

    public void redo() {
        this.isInited();
    }

    public void saved() {
        this.edited = false;
    }

    public NewPanel getNewFilePropertyPane(Component owner) {
        return new DefaultNewPanel(owner);
    }

    public JPanel getFilePropertyPane() {
        this.isInited();
        return null;
    }

    public FileType[] getSupportedTypes() {
        this.isInited();
        return null;
    }

    public boolean isSupportedType(FileType ft) {
        this.isInited();
        return false;
    }

    public Component getComponent() {
        this.isInited();
        return this.sp;
    }

    public void init(NewPanel comp) {
        this.jtp.getDocument().addDocumentListener(this);
        StringArray map = comp.getProperties();
        this.name = (String)map.getContent("NAME");
        this.pack = (String)map.getContent("PACKAGE");
        this.ft = comp.getFileType();
        this.inited = true;
    }

    public void init(StringArray map, FileType type) {
        this.jtp.getDocument().addDocumentListener(this);
        this.name = (String)map.getContent("NAME");
        this.pack = (String)map.getContent("PACKAGE");
        this.ft = type;
        this.inited = true;
    }

    private void isInited() {
        if (!this.inited) {
            throw new IllegalStateException();
        }
    }

    public Dialog getFilePreference() {
        return null;
    }
}

