<?php
require_once($GO_LANGUAGE->get_language_file('todos'));

$td_settings = $todos->get_settings($GO_SECURITY->user_id);

if(isset($_REQUEST['new_todos_sort_order']) && $_REQUEST['new_todos_sort_order'] != $td_settings['sort_order'])
{
  $todos->set_sorting($GO_SECURITY->user_id, 
  $_REQUEST['new_todos_sort_field'], $_REQUEST['new_todos_sort_order']);
  $td_settings['sort_order'] = $_REQUEST['new_todos_sort_order'];
  $td_settings['sort_field'] = $_REQUEST['new_todos_sort_field'];  
}

if ($td_settings['sort_order'] == "DESC")
{
  $sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_down'].'" border="0" />';
  $new_todos_sort_order = "ASC";
}else
{
  $sort_arrow = '&nbsp;<img src="'.$GO_THEME->images['arrow_up'].'" border="0" />';
  $new_todos_sort_order = "DESC";
}


$projects_module = isset($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
if($projects_module)
{
	require_once($projects_module['class_path'].'projects.class.inc');
	$projects = new projects();
}

$fs_module = isset($GO_MODULES->modules['filesystem']) ? $GO_MODULES->modules['filesystem'] : false;
if($fs_module)
{
	require_once($GO_CONFIG->class_path.'filesystem.class.inc');
	$fs = new filesystem();
}


//define the items to show
$todos_max_rows = isset($_REQUEST['todos_max_rows']) ? $_REQUEST['todos_max_rows'] : $_SESSION['GO_SESSION']['max_rows_list'];
$todos_first = isset($_REQUEST['todos_first']) ? $_REQUEST['todos_first'] : 0;

//define load parameters
$user_id = isset($user_id) ? $user_id : 0;
$project_id = isset($project_id) ? $project_id : 0;
$contact_id = isset($contact_id) ? $contact_id : 0;
$company_id = isset($company_id) ? $company_id : 0;
$file_path = isset($file_path) ? addslashes($file_path) : '';



echo '<input type="hidden" name="todos_first" value="'.$todos_first.'" />';
echo '<input type="hidden" name="todos_max_rows" value="'.$todos_max_rows.'" />';
echo '<input type="hidden" name="new_todos_sort_field" value="'.$td_settings['sort_field'].'" />';
echo '<input type="hidden" name="new_todos_sort_order" value="'.$td_settings['sort_order'].'" />';

echo '<input type="hidden" name="completed_todo_id" />';
echo '<input type="hidden" name="delete_todo_id" />';

if (isset($_POST['delete_todo_id']) && $_POST['delete_todo_id'] > 0)
{
	$todos->delete_todo($_POST['delete_todo_id']);
}

if (isset($_POST['completed_todo_id']) && $_POST['completed_todo_id'] > 0)
{
	if ($todo = $todos->get_todo($_POST['completed_todo_id']))
	{
		if ($todos->f('completion_time') > 0)
		{
			$todos->set_uncompleted($_POST['completed_todo_id']);
		}else
		{
			$todos->set_completed($_POST['completed_todo_id']);
		}
	}
}

$count = $todos->get_todos($user_id, $project_id, $contact_id, $company_id, $file_path, false, false, $td_settings['sort_field'], $td_settings['sort_order'], $todos_first, $todos_max_rows);

$local_time = get_time();

$str_count = $count == 1 ? $td_count_single : $td_count_multiple;
echo '<div class="small" style="text-align:right;">'.$count.' '.$str_count.'</div>';
echo '<table class="go_table" width="100%">';
	echo '<tr>'.
				'<th colspan="2">&nbsp;</th>'.
				'<th width="100"><a'.
				'	href="javascript:todos_sort(\'name\',\''.$new_todos_sort_order.'\');">'.
				$strName.'</a>';
				if ($td_settings['sort_field'] == 'name')
				{
				  echo $sort_arrow;
				}
				echo '</th>'.
				'<th width="100"><a'.
				'	href="javascript:todos_sort(\'due_time\',\''.$new_todos_sort_order.'\');">'.
				$cal_due_at.'</a>';
				if ($td_settings['sort_field'] == 'due_time')
				{
				  echo $sort_arrow;
				}
				echo '</th>'.		
				'<th width="100" align="right"><a'.
				'	href="javascript:todos_sort(\'status\',\''.$new_todos_sort_order.'\');">'.
				$cal_status.'</a>';
				if ($td_settings['sort_field'] == 'status')
				{
				  echo $sort_arrow;
				}
				echo '</th>'.
				'<th>'.$cal_responsible.'</thd>'.
				'<th>'.$strRelatedTo.'</th>'.
				'<th>&nbsp;</h>'.
				'</tr>';
				
if ($count == 0)
{
	echo '<tr><td colspan="99" height="20">'.$cal_no_todos.'</td></tr>';
}else
{
	while($todos->next_record())
	{		
		$due_time = $todos->f('due_time')+(get_timezone_offset($todos->f('due_time'))*3600);
		$check = '';
		if ($todos->f('completion_time') > 0)
		{
			$class = 'todo_completed';
			$check = 'checked';
		}elseif($due_time < $local_time)
		{
			$class = 'todo_late';
		}else
		{
			$class= 'todo';
		}

		switch ($todos->f("priority"))
		{
		  case "0":
			$priority = '<img src="'.$GO_THEME->images['low_priority'].'" width="8" height="16" />';
		  break;

		  case "2":
			$priority = '<img src="'.$GO_THEME->images['high_priority'].'" width="8" height="16" />';
		  break;

		  default:
			$priority = '';
		  break;
		}
		
		$due_date = date($_SESSION['GO_SESSION']['date_format'].' '.
									$_SESSION['GO_SESSION']['time_format'], $due_time);


		echo 	'<tr style="background-color: #'.$todos->f('background').'"><td width="20" valign="top"><input type="checkbox" name="todo[]" value="'.
					$todos->f('id').'" onclick="javascript:'.
					'set_completed(this.value);" '.$check.'></td>'.
					'<td width="8" valign="top">'.$priority.'</td>'.
					'<td valign="top"><a class="'.$class.'" href="'.$GO_MODULES->modules['todos']['url'].'todo.php?todo_id='.$todos->f('id').
					'&return_to='.urlencode($link_back).'">'.$todos->f('name').'</a>';
					
		if($todos->f('description') != '')
		{
			echo '<div class="description">'.text_to_html($todos->f('description')).'</div>';
		}
		
		echo 	'</td>'.
					'<td>'.$due_date.'</td>'.
					'<td align="right">'.$todos->f('status').'%&nbsp;</td>'.
					'<td>'.show_profile($todos->f('res_user_id')).'</td><td>';
					
			if($todos->f('contact_id') > 0)
			{
				echo show_contact($todos->f('contact_id'));
			}elseif($todos->f('company_id') > 0)
			{
				echo show_company($todos->f('company_id'));
			}elseif($todos->f('project_id') > 0)
			{
				if($project = $projects->get_project($todos->f('project_id')))
			  {
			    $project_name = $project['description'] == '' ? $project['name'] : $project['name'].' ('.$project['description'].')';		
			
					if ($projects_module['read_permission'])
					{
						echo '<a href="'.$projects_module['url'].'project.php?project_id='.$todos->f('project_id').'&return_to='.urlencode($_SERVER['REQUEST_URI']).'" class="normal">'.htmlspecialchars($project_name).'</a>';
					}else
					{
						echo htmlspecialchars($project_name);
					}
				}
			}elseif($todos->f('file_path') != '' && isset($GO_MODULES->modules['filesystem']))
			{
				if (file_exists($todos->f('file_path')))
				{
					echo 	'<a class="normal" href="'.
					$GO_MODULES->modules['filesystem']['url'].'index.php?path='.urlencode(dirname($todos->f('file_path'))).
					'">'.stripslashes($todos->f('file_path')).'</a>';
				}
			}
					
		echo 	'</td>'.					
					"<td align=\"right\"><a href='javascript:confirm_action(\"javascript:delete_todo(".
					$todos->f('id').")\",\"".htmlspecialchars($strDeletePrefix."'".
					$todos->f('name')."'".$strDeleteSuffix, ENT_QUOTES).
					"\")' title=\"".$strDeleteItem." '".
					htmlspecialchars($todos->f('name'), ENT_QUOTES)."'\"><img src=\"".
					$GO_THEME->images['delete']."\" border=\"0\"></a></td>".
					'</tr>';
	}

	$links = '';
	$max_links=10;
	if ($todos_max_rows != 0)
	{
		if ($count > $todos_max_rows)
		{
			$links = '<table class="NavLinks"><tr><td>';
			$next_start = $todos_first+$todos_max_rows;
			$previous_start = $todos_first-$todos_max_rows;
			if ($todos_first != 0)
			{
				$links .= '<a href="javascript:todos_change_list(0, '.$todos_max_rows.');">&lt&lt</a>&nbsp;';
				$links .= '<a href="javascript:todos_change_list('.$previous_start.', '.$todos_max_rows.');">'.$cmdPrevious.'</a>&nbsp;';
			}else
			{
				$links .= '<font color="#cccccc">&lt&lt '.$cmdPrevious.'</font>&nbsp;';
			}
			$start = ($todos_first-(($max_links/2)*$todos_max_rows));
			$end = ($todos_first+(($max_links/2)*$todos_max_rows));
			if ($start < 0)
			{
				$end = $end - $start;
				$start=0;
			}
			if ($end > $count)
			{
				$end = $count;
			}
			if ($start > 0)
			{
				$links .= '...&nbsp;';
			}

			for ($i=$start;$i<$end;$i+=$todos_max_rows)
			{
				$page = ($i/$todos_max_rows)+1;
				if ($i==$todos_first)
				{
					$links .= '<b><i>'.$page.'</i></b>&nbsp;';
				}else
				{
					$links .= '<a href="javascript:todos_change_list('.$i.', '.$todos_max_rows.');">'.$page.'</a>&nbsp;';
				}
			}

			if ($end < $count)
			{
				$links .= '...&nbsp;';
			}

			$last_page = floor($count/$todos_max_rows)*$todos_max_rows;

			if ($count > $next_start)
			{
				$links .= '<a href="javascript:todos_change_list('.$next_start.', '.$todos_max_rows.');">'.$cmdNext.'</a>&nbsp;';
				$links .= '<a href="javascript:todos_change_list('.$last_page.', '.$todos_max_rows.');">&gt&gt</a>';
			}else
			{
				$links .= '<font color="#cccccc">'.$cmdNext.' &gt&gt</font>';
			}
			$links .= '</td><td align="right"><a class="normal" href="javascript:todos_change_list(0, 0);">'.$cmdShowAll.'</a></td></tr></table>';
			
			echo '<tr height="20"><td colspan="99">'.$links.'</td></tr>';
		}
	}
}
echo '</table>';
?>
<script type="text/javascript">
function todos_change_list(todos_first, todos_max_rows)
{
	document.forms[0].todos_first.value=todos_first;
	document.forms[0].todos_max_rows.value=todos_max_rows;
	document.forms[0].submit();
}

function todos_sort(field, direction)
{
  document.forms[0].new_todos_sort_field.value=field;
  document.forms[0].new_todos_sort_order.value=direction;
  document.forms[0].submit();
}


function set_completed(todo_id)
{
	document.forms[0].completed_todo_id.value=todo_id;
	document.forms[0].submit();
}

function delete_todo(id)
{
	document.forms[0].delete_todo_id.value=id;
	document.forms[0].submit();
}
</script>
