<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */
require_once("../../Group-Office.php");
$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('summary');
require_once($GO_LANGUAGE->get_language_file('summary'));
require_once($GO_MODULES->class_path."summary.class.inc");
$summary = new summary();

$ab_module = isset($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module && $ab_module['read_permission'])
{
  require_once($ab_module['class_path'].'addressbook.class.inc');
  $ab = new addressbook();
}

$projects_module = isset($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
if ($projects_module && $projects_module['read_permission'])
{
  require_once($projects_module['class_path'].'projects.class.inc');
  $projects = new projects();
}

$link_back = $GO_MODULES->url;

//get the local times
$local_time = get_time();
$year = date("Y", $local_time);
$month = date("m", $local_time);
$day = date("j", $local_time);
$hour = date("H", $local_time);
$min = date("i", $local_time);

$GO_HEADER['auto_refresh']['interval'] = '60';
$GO_HEADER['auto_refresh']['url'] = $_SERVER['PHP_SELF'];
$overlib = new overlib();
$GO_HEADER['head'] = $overlib->get_header();

require_once($GO_THEME->theme_path."header.inc");

echo 	'<form method="post" name="summary_form" action="'.$_SERVER['PHP_SELF'].'">'.
'<table border="0" width="100%" cellspacing="0" cellpadding="10"><tr><td width="50%">'.
'<h3>'.$sum_welcome_to.' '.$GO_CONFIG->title.' '.$_SESSION['GO_SESSION']['name'].'</h3></td><td width="50%" align="right"><h3>';
$date = date($_SESSION['GO_SESSION']['date_format']);
if($_SESSION['GO_SESSION']['date_format'] == 'd-m-Y')
{
//  echo $full_days[date('w', $local_time)].' '.$day.' '.$months[$month-1];
  echo $full_days[date('w', $local_time)].', '.$day.'. '.$months[$month-1] . ' ' . $year; 
}else
{
  echo $full_days[date('w', $local_time)].' '.$months[$month-1].' '.$day;
}
echo 	'</h3></td></tr>'.

'<tr><td colspan="99">';

$projects_module = isset($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
$notes_module = isset($GO_MODULES->modules['notes']) ? $GO_MODULES->modules['notes'] : false;
$calendar_module = isset($GO_MODULES->modules['calendar']) ? $GO_MODULES->modules['calendar'] : false;
$todos_module = isset($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;

echo '<table>';
if(isset($GO_MODULES->modules['email']) && $GO_MODULES->modules['email']['read_permission'])
{
	require_once($GO_MODULES->modules['email']['class_path'].'email.class.inc');
	$email = new email();
	if($email->get_accounts($GO_SECURITY->user_id))
	{
		echo '<td class="ModuleIcons" nowrap>';
		echo mail_to('', '<img src="'.$GO_THEME->images['compose'].'" border="0" height="32" width="32" /><br />'.$strNewEmail, 'small');
		echo '</td>';
	}
}
    
if ($projects_module && $projects_module['read_permission'])
{
	echo '<td  class="ModuleIcons" nowrap>';
echo '<a href="'.$projects_module['url'].'project.php?return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['pr_new_project'].'" border="0" height="32" width="32" /><br />'.$strNewProject.'</td>';
}

if ($notes_module && $notes_module['read_permission'])
{
echo '<td  class="ModuleIcons" nowrap>';
echo '<a href="'.$notes_module['url'].'note.php?return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['ab_notes'].'" border="0" height="32" width="32" /><br />'.$strNewNote.'</td>';
}  

if ($calendar_module && $calendar_module['read_permission'])
{
echo '<td class="ModuleIcons" nowrap>';
echo '<a href="'.$calendar_module['url'].'event.php?return_to='.
rawurlencode($link_back).'"><img src="'.$GO_THEME->images['cal_compose'].
'" border="0" height="32" width="32" /><br />'.$strNewEvent.'</td>';
echo '</td>';
}  

if ($todos_module && $notes_module['read_permission'])
{
echo '<td  class="ModuleIcons" nowrap>';
echo '<a href="'.$todos_module['url'].'todo.php?return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['todos_new'].'" border="0" height="32" width="32" /><br />'.$strNewTodo.'</td>';
}
echo '</tr></table>';  
	  
echo '</td></tr>'.
'<tr><td valign="top" style="border: 1px solid black;border-left:0;">';
require_once('sum_email.inc');
require_once('sum_calendar.inc');
require_once('sum_todos.inc');

echo 	'&nbsp;</td><td valign="top" style="border: 1px solid black; border-left:0;border-right:0;">';
if ($GO_MODULES->write_permission)
{
  echo '<div align="right"><a class="normal" href="announcements.php">'.$sum_manage_announcements.'</a></div>';
}

$summary->get_announcements();

while($summary->next_record())
{
  echo 	'<h1>'.htmlspecialchars($summary->f('title')).'</h1>'.
    '<p>'.$summary->f('content').'</p>';	
}

echo 	'&nbsp;</td></tr></table>'.
'</form>';

require_once($GO_THEME->theme_path."footer.inc");
?>
