<?php

/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once ("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('projects');
require_once ($GO_LANGUAGE->get_language_file('projects'));

//check for the addressbook module
$ab_module = isset ($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module && $ab_module['read_permission']) {
	require_once ($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
} else {
	$ab_module = false;
}

$page_title = $lang_modules['projects'];
require_once ($GO_MODULES->class_path."projects.class.inc");
$projects = new projects();

$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$project_id = isset ($_REQUEST['project_id']) ? $_REQUEST['project_id'] : 0;

$link_back = (isset ($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$return_to = isset ($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];

$project['parent_project_id'] = isset ($_REQUEST['parent_project_id']) ? $_REQUEST['parent_project_id'] : 0;
$project['company_id'] = isset ($_REQUEST['company_id']) ? $_REQUEST['company_id'] : 0;
$project['contact_id'] = isset ($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : 0;

if (isset ($_POST['id']['type'])) {
	switch ($_POST['id']['type']) {
		case 'project' :
			$project['parent_project_id'] = $_POST['id']['value'];
			break;
		case 'contact' :
			$project['contact_id'] = $_POST['id']['value'];
			break;
		case 'company' :
			$project['company_id'] = $_POST['id']['value'];
			break;
	}
}

switch ($task) {
	case 'save_project' :
		//translate the given date stamp to unix time
		$start_date = date_to_unixtime($_POST['start_date']);
		$end_date = date_to_unixtime($_POST['end_date']);

		$name = smart_addslashes(trim($_POST['name']));
		if ($project_id > 0) {
			if ($name == '') {
				$feedback = '<p class="Error">'.$error_missing_field.'</p>';
			} else {
				$existing_project = $projects->get_project_by_name($name);

				if ($existing_project && $existing_project['id'] != $project_id) {
					$feedback = '<p class="Error">'.$pm_project_exists.'</p>';
				}
				elseif (!$projects->update_project($_POST['project_id'], 
					$project['contact_id'], 
					$project['company_id'], 
					$project['parent_project_id'], 
					$name, 
					smart_addslashes($_POST['description']), 
					smart_addslashes($_POST['comments']), 
					$start_date, 
					$end_date, 
					$_POST['status'], 
					$_POST['responsible_user']['value'], 
					$_POST['probability'],  
					$_POST['budget'])) {
						
					$feedback = '<p class="Error">'.$strSaveError.'</p>';
				} else {
					if ($_POST['close'] == 'true') {
						header('Location: '.$return_to);
						exit ();
					}
				}
			}
		} else {
			if ($name == '') {
				$feedback = '<p class="Error">'.$error_missing_field.'</p>';
			}
			elseif ($projects->get_project_by_name($name)) {
				$feedback = '<p class="Error">'.$pm_project_exists.'</p>';
			} else {
				$acl_read = $GO_SECURITY->get_new_acl('Project read: '.$name);
				$acl_write = $GO_SECURITY->get_new_acl('Project write: '.$name);
				if ($acl_read > 0 && $acl_write > 0) {
					if ($GO_SECURITY->add_user_to_acl($GO_SECURITY->user_id, $acl_write)) {
						if (!$project_id = $projects->add_project($GO_SECURITY->user_id, 
								$project['contact_id'], 
								$project['company_id'], 
								$project['parent_project_id'], 
								$name, 
								smart_addslashes($_POST['description']), 
								smart_addslashes($_POST['comments']), 
								$start_date, 
								$end_date, 
								$_POST['status'], 
								$_POST['responsible_user']['value'], 
								$_POST['probability'], 
								$_POST['budget'], 
								$acl_read, 
								$acl_write)) {
									
							$GO_SECURITY->delete_acl($acl_read);
							$GO_SECURITY->delete_acl($acl_write);
							$feedback = '<p class="Error">'.$strSaveError.'</p>';
						} else {
							if ($_POST['close'] == 'true') {
								header('Location: '.$return_to);
								exit ();
							}
						}
					} else {
						$GO_SECURITY->delete_acl($acl_read);
						$GO_SECURITY->delete_acl($acl_write);
						$feedback = '<p class="Error">'.$strSaveError.'</p>';
					}
				} else {
					$feedback = '<p class="Error">'.$strAclError.'</p>';
				}
			}
		}
		break;
}

$pm_settings = $projects->get_settings($GO_SECURITY->user_id);

if ($project_id > 0) {
	$project = $projects->get_project($project_id);
	$project_name = ($project['description'] == '') ? $project['name'] : $project['name'].' ('.$project['description'].')';

	$tabtable = new tabtable('project_tab', $project_name, '100%', '400', '120', '&project_id='.$project_id.'&return_to='.urlencode($return_to));
	$tabtable->add_tab('properties', $strProperties);

	$write_permissions = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $project['acl_write']);
	$read_permissions = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $project['acl_read']);

	if (!$write_permissions && !$read_permissions) {
		header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
		exit ();
	}
	
	$tabtable->add_tab('load', $pm_load);
	$tabtable->add_tab('activities', $strActivities);
	$tabtable->add_tab('read_permissions', $strReadRights);
	$tabtable->add_tab('write_permissions', $strWriteRights);
	$project['parent_project_id'] = $project['project_id'];
	$project['start_date'] = date($_SESSION['GO_SESSION']['date_format'], $project['start_date']);
	$project['end_date'] = date($_SESSION['GO_SESSION']['date_format'], $project['end_date']);
	$project['responsible_user'] = $project['res_user_id'];

	if (isset ($active_tab)) {
		$tabtable->set_active_tab($active_tab);
	}
} else {
	$tabtable = new tabtable('project_tab', $pm_new_project, '100%', '400', '120');
}

if ($project_id == 0 || $task == 'save_project') {
	$write_permissions = true;
	$read_permissions = true;

	$project['name'] = isset ($_POST['name']) ? smart_stripslashes($_POST['name']) : '';
	$project['comments'] = isset ($_POST['comments']) ? smart_stripslashes($_POST['comments']) : '';
	$project['start_date'] = isset ($_POST['start_date']) ? $_POST['start_date'] : date($_SESSION['GO_SESSION']['date_format'], get_time());
	$project['end_date'] = isset ($_POST['end_date']) ? $_POST['end_date'] : date($_SESSION['GO_SESSION']['date_format'], get_time());
	$project['status'] = isset ($_POST['status']) ? $_POST['status'] : '-3';
	$project['responsible_user'] = isset ($_POST['responsible_user']['id']) ? $_POST['responsible_user']['id'] : $GO_SECURITY->user_id;
	$project['probability'] = isset ($_POST['probability']) ? $_POST['probability'] : 0;
	$project['budget'] = isset ($_POST['budget']) ? $_POST['budget'] : 0;
	$project['description'] = isset ($_POST['description']) ? smart_stripslashes($_POST['description']) : '';
	$project['ctime'] = $project['mtime'] = get_gmt_time();
	$project['user_id'] = $GO_SECURITY->user_id;

}

$datepicker = new date_picker();
$GO_HEADER['head'] = $datepicker->get_header();
$overlib = new overlib();
$GO_HEADER['head'] .= $overlib->get_header();

$page_title = $lang_modules['projects'];
require_once ($GO_THEME->theme_path."header.inc");
echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" name="projects_form">';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="project_id" value="'.$project_id.'" />';
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';

echo '<table border="0"><tr>';
if ($project_id > 0 && $write_permissions) {
	
	echo '<td  class="ModuleIcons" nowrap>';
	echo '<a href="'.$GO_MODULES->url.'book.php?project_id='.$project_id.'&return_to='.urlencode($link_back).'"><img src="'.$GO_THEME->images['enter_data_big'].'" border="0" height="32" width="32" /><br />'.$pm_enter_data.'</td>';
	
	echo '<td  class="ModuleIcons" nowrap>';
	echo '<a href="'.$GO_MODULES->url.'project.php?parent_project_id='.$project_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['pr_new_project'].'" border="0" height="32" width="32" /><br />'.$strNewProject.'</td>';

	$notes_module = isset ($GO_MODULES->modules['notes']) ? $GO_MODULES->modules['notes'] : false;
	if ($notes_module && $notes_module['read_permission']) {
		echo '<td  class="ModuleIcons" nowrap>';
		echo '<a href="'.$notes_module['url'].'note.php?project_id='.$project_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['ab_notes'].'" border="0" height="32" width="32" /><br />'.$strNewNote.'</td>';
	}

	$calendar_module = isset ($GO_MODULES->modules['calendar']) ? $GO_MODULES->modules['calendar'] : false;
	if ($calendar_module && $calendar_module['read_permission']) {
		echo '<td class="ModuleIcons" nowrap>';
		echo '<a href="'.$calendar_module['url'].'index.php?project_id='.$project_id.'&link_back='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['cal_compose'].'" border="0" height="32" width="32" /><br />'.$strNewEvent.'</td>';
		echo '</td>';
	}

	$todos_module = isset ($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;
	if ($todos_module && $notes_module['read_permission']) {
		echo '<td  class="ModuleIcons" nowrap>';
		echo '<a href="'.$todos_module['url'].'todo.php?project_id='.$project_id.'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['todos_new'].'" border="0" height="32" width="32" /><br />'.$strNewTodo.'</td>';
	}

}
echo '</tr></table>';

$tabtable->print_head($return_to);
switch ($tabtable->get_active_tab_id()) {
	case 'read_permissions' :
		print_acl($project['acl_read']);
		echo '<br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
		break;

	case 'write_permissions' :
		print_acl($project['acl_write']);
		echo '<br />';
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
		break;

	case 'load' :
		$fixed_project_id = $project_id;
		require_once ('load.inc');
		break;

	case 'activities' :
		require_once ('activities.inc');
		break;

	default :
		if (isset ($feedback))
			echo $feedback;
?>
      <table border="0" cellspacing="0" cellpadding="4">
      <tr>
      <td><?php echo $strName; ?>:</td>
      <td>
      <?php

		if ($write_permissions) {
			echo '<input type="text" class="textbox" style="width: 250px;" name="name" value="'.htmlspecialchars($project['name']).'" maxlength="50" />';
		} else {
			echo htmlspecialchars($project['name']);
		}
?>
	</td>
	</tr>
	<tr>
	<td><?php echo $pm_description; ?>:</td>
	<td>
	<?php

		if ($write_permissions) {
			echo '<input type="text" class="textbox" style="width: 250px;" name="description" value="'.htmlspecialchars($project['description']).'" maxlength="50" />';
		} else {
			echo htmlspecialchars($project['description']);
		}
?>
	  </td>
	  </tr>
	  <?php
		if ($write_permissions) {
			$type = '';
			$value = '';
			if ($project['parent_project_id'] > 0) {
				$type = 'project';
				$value = $project['parent_project_id'];
			}
			elseif ($project['contact_id'] > 0) {
				$type = 'contact';
				$value = $project['contact_id'];
			}
			elseif ($project['company_id'] > 0) {
				$type = 'company';
				$value = $project['company_id'];
			}
			$select = new select($type, 'projects_form', 'id', $value, array ('contact', 'company', 'project'), $link_back);

			echo '<tr><td>'.$select->get_link($strRelatedTo).':</td>'.'<td>'.$select->get_field().'</td></tr>';

			$select = new select('user', 'projects_form', 'responsible_user', $project['responsible_user']);
			echo '<tr><td>';
			$select->print_link($pm_employee);
			echo ':</td><td>';
			$select->print_field();
			echo '</td></tr>';

			echo '<tr><td>'.$pm_start_date.':</td><td>';
			//	    $datepicker->print_date_picker('start_date', $_SESSION['GO_SESSION']['date_format'], $project['start_date'], '', '', 'onchange="javascript:check_date(\'start_date\');"');
			$datepicker->print_date_picker('start_date', $_SESSION['GO_SESSION']['date_format'], $project['start_date']);
			echo '</td></tr>';
			echo '<tr><td>'.$pm_end_date.':</td><td>';
			//	    $datepicker->print_date_picker('end_date', $_SESSION['GO_SESSION']['date_format'], $project['end_date'], '', '', 'onchange="javascript:check_date(\'end_date\');"');
			$datepicker->print_date_picker('end_date', $_SESSION['GO_SESSION']['date_format'], $project['end_date']);
			echo '</td></tr>';
			echo '<tr><td>'.$pm_status.'</td><td>';

			$dropbox = new dropbox();
			$dropbox->add_value(STATUS_OFFER, $pm_status_values[STATUS_OFFER]);
			$dropbox->add_value(STATUS_ONGOING, $pm_status_values[STATUS_ONGOING]);
			$dropbox->add_value(STATUS_WAITING, $pm_status_values[STATUS_WAITING]);
			$dropbox->add_value(STATUS_DONE, $pm_status_values[STATUS_DONE]);
			$dropbox->add_value(STATUS_BILLED, $pm_status_values[STATUS_BILLED]);
			$dropbox->print_dropbox('status', $project['status']);

			echo '</td></tr>';
			echo '<tr><td>'.$pm_probability.'</td><td>';

			$dropbox = new dropbox();
			for ($i = 0; $i <= 100; $i = $i +10) {
				$dropbox->add_value($i, $i.'%');
			}
			$dropbox->print_dropbox('probability', $project['probability']);

			echo '</td></tr>';
			echo '<tr><td colspan="2">&nbsp;</td></tr>';

			echo '<tr><td>'.$pm_budget.'</td><td><input type="text" class="textbox" size="10" name="budget" value="'.$project['budget'].'" maxlength="50" /> '.$_SESSION['GO_SESSION']['currency'].'</td></tr>';
		} else {
			echo '<tr><td>'.$strRelatedTo.':</td><td>';

			if ($project['parent_project_id'] > 0) {
				echo show_project($project['parent_project_id']);
			}
			elseif ($project['contact_id'] > 0) {
				echo show_contact($project['contact_id']);

			}
			elseif ($project['company_id'] > 0) {
				echo show_company($project['company_id']);
			}
			echo '</td></tr>';

			echo '<tr><td>'.$pm_start_date.':</td><td>';
			echo $project['start_date'];
			echo '</td></tr>';
			echo '<tr><td>'.$pm_end_date.':</td><td>';
			echo $project['end_date'];
			echo '</td></tr>';
			echo '<tr><td>'.$pm_status.'</td><td>';

			$status = ($project['status'] > 9 && $project['status'] < 101) ? $project['status'].'%' : $pm_status_values[(int) $project['status']];
			echo $status.'</td></tr>';
			echo '<tr><td>'.$pm_probability.'</td><td>'.$project['probability'].'%</td></tr>';
			echo '<tr><td colspan="2">&nbsp;</td></tr>';
			echo '<tr><td>'.$pm_budget.'</td><td>'.$project['budget'].' '.$_SESSION['GO_SESSION']['currency'].'</td></tr>';
		}
		echo '<tr><td colspan="2">&nbsp;</td></tr>';
		if ($project_id > 0) {

			echo '<tr><td>'.$strOwner.':</td><td>'.show_profile($project['user_id']).'</td></tr>';
			echo '<tr><td>'.$strCreatedAt.':</td><td>'.date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], $project['ctime'] + (get_timezone_offset($project['ctime']) * 3600)).'</td><tr>';
			echo '<tr><td>'.$strModifiedAt.':</td><td>'.date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], $project['mtime'] + (get_timezone_offset($project['mtime']) * 3600)).'</td><tr>';
			echo '<tr><td colspan="2">&nbsp;</td></tr>';
		}
?>
		  <tr>
		  <td valign="top"><?php echo $strComments; ?>:</td>
		<td>
		<?php

		if ($write_permissions) {
			echo '<textarea name="comments" cols="50" rows="4" class="textbox">'.$project['comments'].'</textarea>';
		} else {
			echo text_to_html($project['comments']);
		}
?>
		  </td>
		  </tr>
		  <tr>
		  <td colspan="2">
		  <?php

		if ($write_permissions) {
			$button = new button($cmdOk, "javascript:_save('save_project', 'true');");
			echo '&nbsp;&nbsp;';
			$button = new button($cmdApply, "javascript:_save('save_project', 'false')");
			echo '&nbsp;&nbsp;';
		}
		$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
?>
		  </td>
		  </tr>
		  </table>
			<script type="text/javascript">
			document.forms[0].name.focus();
			</script>
		  <?php

		break;
}
$tabtable->print_foot();
echo '</form>';
?>
<script type="text/javascript">

function _save(task, close)
{
	document.projects_form.task.value = task;
	document.projects_form.close.value = close;
	document.projects_form.submit();
}
function remove_client()
{
	document.projects_form.contact_id.value = 0;
	document.projects_form.contact_name.value = '';
	document.projects_form.contact_name_text.value = '';
}

function remove_user()
{
	document.projects_form.responsible_user_id.value = 0;
	document.projects_form.user_name.value = '';
	document.projects_form.user_name_text.value = '';
}

</script>
<?php
require_once ($GO_THEME->theme_path."footer.inc");
?>