<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

require_once("../../Group-Office.php");


$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('projects');
require_once($GO_LANGUAGE->get_language_file('projects'));

$page_title=$menu_projects;
require_once($GO_MODULES->class_path."projects.class.inc");
$projects = new projects();

//check for the addressbook module
$ab_module = isset($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module && $ab_module['read_permission'])
{
  require_once($ab_module['class_path'].'addressbook.class.inc');
  $ab = new addressbook();
}else
{
	$ab_module = false;
}


$post_action = isset($_REQUEST['post_action']) ? $_REQUEST['post_action'] : '';
$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';
$link_back = (isset($_REQUEST['link_back']) && $_REQUEST['link_back'] != '') ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];
$return_to = (isset($_REQUEST['return_to']) && $_REQUEST['return_to'] != '') ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];

$time = get_time();
$day = date("j", $time);
$year = date("Y", $time);
$month = date("m", $time);

$date = date($_SESSION['GO_SESSION']['date_format'], $time);

if ($post_action == 'load')
{
	$datepicker = new date_picker();
	$GO_HEADER['head'] = $datepicker->get_header();
}

require_once($GO_THEME->theme_path."header.inc");

echo '<table border="0" cellpadding="0" cellspacing="0">'.
	'<tr>'.
	
	'<td class="ModuleIcons"><a href="index.php" class="small">'.
	'<img src="'.$GO_THEME->images['projects'].'" border="0" width="32" height="32" /><br />'.$pm_projects.'</a></td>'.
	
	'<td class="ModuleIcons"><a href="project.php" class="small">'.
	'<img src="'.$GO_THEME->images['pr_new_project'].'" border="0" width="32" height="32" /><br />'.$pm_new_project.'</a></td>'.	
	
	'<td class="ModuleIcons"><a href="index.php?post_action=load" class="small">'.
	'<img src="'.$GO_THEME->images['pr_load'].'" border="0" width="32" height="32" /><br />'.$pm_load.'</a></td>'.		
	
	'<td class="ModuleIcons"><a href="index.php?post_action=fees" class="small">'.
	'<img src="'.$GO_THEME->images['pr_fees'].'" border="0" width="32" height="32" /><br />'.$pm_fees.'</a></td>'.		
	
	'</tr></table>';
echo '<form name="projects_form" method="post" action="'.$_SERVER['PHP_SELF'].'">';
echo '<input type="hidden" name="task" />';
echo '<input type="hidden" name="post_action" value="'.$post_action.'" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';


if (isset($feedback)) echo $feedback;
switch($post_action)
{
	case 'load':
		$tabtable = new tabtable('project_tab', $pm_load, '100%', '');
		$tabtable->print_head();
		require_once('load.inc');
		$tabtable->print_foot();
	break;

	case 'fees':
		require_once('fees.inc');
	break;
	
	default:
		require_once('projects.inc');
	break;
}
echo '</form>';
require_once($GO_THEME->theme_path."footer.inc");
?>
