<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
 */

require_once("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('notes');
require_once($GO_LANGUAGE->get_language_file('notes'));

$page_title=$lang_modules['notes'];
require_once($GO_MODULES->class_path."notes.class.inc");
$notes = new notes();

//check for the addressbook module
$ab_module = isset($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if ($ab_module)
{
  require_once($ab_module['class_path'].'addressbook.class.inc');
  $ab = new addressbook();
}

$projects_module = isset($GO_MODULES->modules['projects']) ? $GO_MODULES->modules['projects'] : false;
if($projects_module)
{
	require_once($projects_module['class_path'].'projects.class.inc');
	$projects = new projects();
}

$fs_module = isset($GO_MODULES->modules['filesystem']) ? $GO_MODULES->modules['filesystem'] : false;
if($fs_module)
{
	require_once($GO_CONFIG->class_path.'filesystem.class.inc');
	$fs = new filesystem();
}

$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';
$note_id = isset($_REQUEST['note_id']) ? $_REQUEST['note_id'] : 0;

$return_to = isset($_REQUEST['return_to']) ? $_REQUEST['return_to'] : $_SERVER['HTTP_REFERER'];
$link_back = isset($_REQUEST['link_back']) ? $_REQUEST['link_back'] : $_SERVER['REQUEST_URI'];

$project_id=isset($_REQUEST['project_id']) ? $_REQUEST['project_id'] : 0;
$company_id=isset($_REQUEST['company_id']) ? $_REQUEST['company_id'] : 0;
$contact_id=isset($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : 0;
$file_path=isset($_REQUEST['file_path']) ? $_REQUEST['file_path'] : '';

if(isset($_POST['id']['type']))
{
	switch($_POST['id']['type'])
	{
		case 'project':
			$project_id=$_POST['id']['value'];
		break;
		case 'contact':
			$contact_id=$_POST['id']['value'];
		break;
		case 'company':
			$company_id=$_POST['id']['value'];
		break;
		case 'file':
			$file_path=smart_addslashes($_POST['id']['value']);
		break;
	}
}

if($task== 'save_note')
{
  $name = smart_addslashes(trim($_POST['name']));
  if ($note_id > 0)
  {
    if ($name == '')
    {
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
    }else
    {
			$existing_note = $notes->get_note_by_name($name);
			if($existing_note && $existing_note['id'] != $note_id)
			{
			  $feedback = '<p class="Error">'.$pm_note_exists.'</p>';
			}elseif(!$notes->update_note($_POST['note_id'],
						$name,
						$contact_id,
						$company_id,
						$project_id,
						$file_path,			      
			      smart_addslashes($_POST['content'])))
			{
			  $feedback = '<p class="Error">'.$strSaveError.'</p>';
			}else
			{
			  if ($_POST['close'] == 'true')
			  {
			    header('Location: '.$return_to);
			    exit();
			  }
		}
    }
  }else
  {
    if ($name == '')
    {
			$feedback = '<p class="Error">'.$error_missing_field.'</p>';
    }elseif($notes->get_note_by_name($name))
    {
			$feedback = '<p class="Error">'.$pm_note_exists.'</p>';
    }else
    {    	
		  if (!$note_id = $notes->add_note($_POST['user_id'],
			$contact_id,
			$company_id,
			$project_id,
			$file_path,
			$name,
			smart_addslashes($_POST['content'])
			))
		  {
		    $feedback = '<p class="Error">'.$strSaveError.'</p>';
		  }else
		  {
		    if ($_POST['close'] == 'true')
		    {
		      header('Location: '.$return_to);
		      exit();
		    }
		  }
		}
  }
}

if ($note_id > 0)
{
  $note = $notes->get_note($note_id); 
  $tabtable = new tabtable('note_tab', $note['name'], '100%', '400', '120', '', true);
}else
{	
	
  $tabtable = new tabtable('note_tab', $no_new_note, '', '100%', '120', '', true);
  $note = false;
}

if ($note && $task != 'save_note')
{
  $name = $note['name'];
  $contact_id = $note['contact_id'];
  $company_id = $note['company_id'];
  $project_id = $note['project_id'];
  $user_id = $note['user_id'];
  $file_path = $note['file_path'];
  $content = $note['content'];
  $ctime = date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], gmt_to_local_time($note['ctime']));
  $mtime = date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], gmt_to_local_time($note['mtime']));
}else
{
  $name = isset($_REQUEST['name']) ? smart_stripslashes($_REQUEST['name']) : '';
  $content = isset($_REQUEST['content']) ? smart_stripslashes($_REQUEST['content']) : '';
  $user_id = isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : $GO_SECURITY->user_id;
  $due_date = isset($_REQUEST['due_date']) ? $_REQUEST['due_date'] : '';
  $ctime = date($_SESSION['GO_SESSION']['date_format'], get_time());
  $mtime = date($_SESSION['GO_SESSION']['date_format'], get_time());
}

//check permissions of parent objects
$write_permission = false;
$read_permission = false;
if($user_id == $GO_SECURITY->user_id)
{
	$write_permission = true;
	$read_permission = true;
}elseif ($project_id > 0)
{
  $projects = new projects();

  if($project = $projects->get_project($project_id))
  {
    $write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $project['acl_write']);
    $read_permission = $write_permission ? true : $GO_SECURITY->has_permission($GO_SECURITY->user_id, $project['acl_read']);
	}
}elseif($contact_id > 0)
{
	if($contact = $ab->get_contact($contact_id))
	{
		$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $contact['acl_write']);
    $read_permission = $write_permission ? true : $GO_SECURITY->has_permission($GO_SECURITY->user_id, $contact['acl_read']);
  }
}elseif($company_id > 0)
{
	if($company = $ab->get_company($company_id))
	{
		$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_write']);
    $read_permission = $write_permission ? true : $GO_SECURITY->has_permission($GO_SECURITY->user_id, $company['acl_read']);
  }
}elseif($file_path != '' && isset($GO_MODULES->modules['filesystem']))
{
	if (file_exists($file_path))
	{
		if($fs->is_owner($GO_SECURITY->user_id, $file_path))
		{
			$write_permission = true;
			$read_permission = true;
		}elseif($share = $fs->find_share($file_path))
		{
			$write_permission = $GO_SECURITY->has_permission($GO_SECURITY->user_id, $share['acl_write']);
	    $read_permission = $write_permission ? true : $GO_SECURITY->has_permission($GO_SECURITY->user_id, $share['acl_read']);
	  }
	}
}

if((!$write_permission && $note_id == 0) || !$read_permission)
{
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit();
}

//create htmlarea
$htmlarea = new htmlarea();
$htmlarea->force_textmode();
$GO_HEADER['head'] = $htmlarea->get_header('content', -70, -240, 25);
$datepicker = new date_picker();
$GO_HEADER['head'] .= $datepicker->get_header();
$GO_HEADER['body_arguments'] = 'onload="initEditor()"';


$page_title = $lang_modules['notes'];
require_once($GO_THEME->theme_path."header.inc");
echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" name="notes_form">';
echo '<input type="hidden" name="close" value="false" />';
echo '<input type="hidden" name="note_id" value="'.$note_id.'" />';
echo '<input type="hidden" name="task" value="" />';
echo '<input type="hidden" name="return_to" value="'.$return_to.'" />';
echo '<input type="hidden" name="link_back" value="'.$link_back.'" />';
echo '<input type="hidden" name="user_id" value="'.$user_id.'" />';

$tabtable->print_head($return_to);

if (isset($feedback)) echo $feedback;
?>
<table border="0" cellspacing="0" cellpadding="4">
<tr>
  <td valign="top">
  <table border="0" cellspacing="0" cellpadding="4">
  <tr>
  <td><?php echo $strName; ?>:</td>
  <td>
  <?php
  if ($write_permission)
  {
		echo '<input type="text" class="textbox" style="width: 250px;" name="name" value="'.htmlspecialchars($name).'" maxlength="50" />';
  }else
  {
		echo htmlspecialchars($note['name']);
  }
  ?>
	</td>
	</tr>
	<?php
	echo '<tr><td>'.$strOwner.':</td><td>'.show_profile($user_id, '', 'normal', $link_back).'</td></tr>';
	$type = '';
	$value = '';
	if ($project_id > 0)
	{
	  $type = 'project';
	  $value = $project_id;
	}elseif($contact_id > 0)
	{
		 $type = 'contact';
	  $value = $contact_id;
	}elseif($company_id > 0)
	{
		$type = 'company';
	  $value = $company_id;
	}elseif($file_path != '' && isset($GO_MODULES->modules['filesystem']))
	{
		$type = 'file';
	  $value = $file_path;
	}
	$select = new select($type, 'notes_form', 'id', $value, array('contact', 'company', 'project', 'file'), $link_back);
	
	echo '<tr><td>'.$select->get_link($strRelatedTo).':</td>'.
				'<td>'.$select->get_field().'</td></tr>';
	?>
  </table>
</td>
<td valign="top">
<table border="0" cellspacing="0" cellpadding="4">
<?php  
echo '<tr><td>'.$strCreatedAt.':</td><td>'.$ctime.'</td><tr>';
echo '<tr><td>'.$strModifiedAt.':</td><td>'.$mtime.'</td><tr>';	
?>
  </table>
  </td>
  </tr>
  <tr>
  <td colspan="2">
  <?php
  $htmlarea->print_htmlarea(htmlspecialchars($content));
?>
  </td>
  </tr>
  <tr>
  <td colspan="2">
  <?php
  if ($write_permission)
  {
    $button = new button($cmdOk, "javascript:_save('save_note', 'true');");
    echo '&nbsp;&nbsp;';
    $button = new button($cmdApply, "javascript:_save('save_note', 'false')");
    echo '&nbsp;&nbsp;';
  }
$button = new button($cmdClose, "javascript:document.location='".$return_to."';");
?>
  </td>
  </tr>
  </table>

  <?php


$tabtable->print_foot();
echo '</form>';
?>
<script type="text/javascript">

function _save(task, close)
{
  document.notes_form.task.value = task;
  document.notes_form.close.value = close;
  <?php
    if (isset($htmlarea) && $htmlarea->browser_is_supported())
    {
      echo 'document.notes_form.onsubmit();';
    }
  ?>
    document.notes_form.submit();
}

function remove_user()
{
  document.notes_form.responsible_user_id.value = 0;
  document.notes_form.user_name.value = '';
  document.notes_form.user_name_text.value = '';
}
document.notes_form.name.focus();
</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
