<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

$return_to_path = is_dir($return_to_path) ? urlencode(smart_stripslashes($return_to_path)) : urlencode(smart_stripslashes(dirname($return_to_path)));
$filename = basename($path);
$extension = get_extension($filename);
$type = mime_content_type($path);
$location = dirname($path);
$share = $fs->get_share($path);
//do not let user share it's home folder or modify the name!
$write_perms = ($fs->has_write_permission($GO_SECURITY->user_id, $path) && !$fs->is_home_path($GO_SECURITY->user_id, $path));

$return_to = $_SERVER['PHP_SELF'].'?path='.$return_to_path;
$link_back = $_SERVER['REQUEST_URI'];

echo '<input type="hidden" name="task" value="properties" />';
echo '<input type="hidden" name="close" value="false" />';

$tabtable = new tabtable('properties_tab', $strProperties, '100%', '400', '120', '', true);
$tabtable->add_tab('properties', $fbGeneral);
if (isset($GO_MODULES->modules['notes']) || isset($GO_MODULES->modules['todos']))
{
  $tabtable->add_tab('activities', $strActivities);
}

if ($share)
{
  $tabtable->add_tab('read_permissions', $strReadRights);
  $tabtable->add_tab('write_permissions', $strWriteRights);
}

if(isset($_REQUEST['active_tab']))
{
	$tabtable->set_active_tab($_REQUEST['active_tab']);
}

$link_back .= '?task=properties&active_tab='.$tabtable->get_active_tab_id();

echo '<table border="0"><tr>';

 
$notes_module = isset($GO_MODULES->modules['notes']) ? $GO_MODULES->modules['notes'] : false;
if ($notes_module && $notes_module['read_permission'])
{
  echo '<td  class="ModuleIcons" nowrap>';
  echo '<a href="'.$notes_module['url'].'note.php?file_path='.urlencode($path).'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['ab_notes'].'" border="0" height="32" width="32" /><br />'.$strNewNote.'</td>';
}

$todos_module = isset($GO_MODULES->modules['todos']) ? $GO_MODULES->modules['todos'] : false;
if ($todos_module && $notes_module['read_permission'])
{
  echo '<td  class="ModuleIcons" nowrap>';
  echo '<a href="'.$todos_module['url'].'todo.php?file_path='.urlencode($path).'&return_to='.rawurlencode($link_back).'"><img src="'.$GO_THEME->images['todos_new'].'" border="0" height="32" width="32" /><br />'.$strNewTodo.'</td>';
}

echo '</tr></table>';


$tabtable->print_head($return_to);

switch($tabtable->get_active_tab_id())
{
  case 'read_permissions':
    print_acl($share['acl_read']);
    echo '<br /><br />';
    $button = new button($cmdClose, 'javascript:document.location=\''.$_SERVER['PHP_SELF'].'?path='.$return_to_path.'\';');
    break;

  case 'write_permissions':
    print_acl($share['acl_write']);
    echo '<br /><br />';
    $button = new button($cmdClose, 'javascript:document.location=\''.$_SERVER['PHP_SELF'].'?path='.$return_to_path.'\';');
    break;

  case 'activities':
   
    $file_path=$path;
    require_once('activities.inc');
    echo '<br />';
    $button = new button($cmdClose, "javascript:document.location='".$return_to."'");
    break;
    
	default:
    ?>
      <table border="0">
      <tr>
      	<td colspan="2"><?php if(isset($feedback)) echo $feedback; ?>&nbsp;</td>
      </tr>
      <tr>
      <td>
      <?php echo $strName; ?>:
      </td>
      <td>
      <?php
      if ($write_perms)
      {
	echo '<input type="text" class="textbox" name="name" value="'.strip_extension(basename($path)).'" maxlength="100" size="30" />';
	echo '<input type="hidden" name="extension" value ="'.get_extension(basename($path)).'" />';
      }else
      {
	echo basename($path);
      }
      ?>
	</td>
	</tr>
	<tr>
	<td>
	<?php echo $fbLocation; ?>:
	</td>
	<td>
	<?php
	if (dirname($GO_CONFIG->file_storage_path).$GO_CONFIG->slash.basename($GO_CONFIG->file_storage_path) == $location)
	{
	  echo $GO_CONFIG->slash;
	}else
	{
	  echo str_replace($GO_CONFIG->file_storage_path,$GO_CONFIG->slash,$location);
	}
	?>
	  </td>
	  </tr>
	  <tr>
	  <td colspan="2"><hr /></td>
	  </tr>
	  <tr>
	  <td valign="top">
	  <?php echo $strType; ?>:
	  </td>
	  <td>
	  <table border="0" cellpadding="0" cellspacing="0">
	  <tr>
	  <td valign="top">
	  <?php
	  if (is_dir($path))
	  {
	    echo '<img border="0" width="16" height="16" src="'.$GO_THEME->images['folder'].'" />';
	    echo '&nbsp;</td><td valign="top">';
	    echo $fbFolder;
	  }else
	  {
	    echo '<img border="0" width="16" height="16" src="'.get_filetype_image($extension).'" />';
	    echo '&nbsp;</td><td valign="top">';
	    echo get_filetype_description($extension);
      echo '&nbsp;('.mime_content_type($path).')';
		 }
		  ?>
		  </td>
		  </tr>
		  </table>
		  </td>
		  </tr>
		  <tr>
		  <td><?php echo $strSize; ?>:</td>
		  <td><?php
		  if (is_dir($path) && !isset($_REQUEST['calc_size']))
		  {
		  echo '<a href="'.$_SERVER['PHP_SELF'].'?task=properties&path='.$urlencoded_path.'&calc_size=true" class="normal">'.$fs_calculate_folder_size.'</a>';
		  }else
		  {
		  echo format_size($fs->size($path));
		  }
		  ?></td>
		  </tr>
		  <tr>
		<td colspan="2"><hr /></td>
		</tr>
		<tr>
		<td>
		<?php echo $strCreated; ?>:
		</td>
		<td>
		<?php echo date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], get_time(filectime($path))); ?>
		</td>
		</tr>
		<tr>
		<td>
		<?php echo $strAccessed; ?>:
		</td>
		<td>
		<?php echo date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], get_time(fileatime($path))); ?>
		</td>
		</tr>
		<tr>
		<td>
		<?php echo $strModified; ?>:
		</td>
		<td>
		<?php echo date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], get_time(filemtime($path))); ?>
		</td>
		</tr>
		<?php
		if (is_dir($path))
		{
		  echo '<tr><td colspan="2"><hr /></td></tr>';
		  $disabled = ($fs->is_owner($GO_SECURITY->user_id, $path) && $write_perms) ? false : true;

		  echo '<tr><td colspan="2">';
		  $checkbox = new checkbox('share_folder', $path, $fs_activate_sharing, $share, $disabled);
		  if ($disabled)
		  {
		    echo '<input type="hidden" name="share_folder" value="'.$path.'" />';
		  }
		  echo '</td></tr>';
		}
	      ?>
		<tr>
		<td colspan="2" align="center">
		<br />
		<?php
		if ($write_perms)
		{
		  $button = new button($cmdOk, 'javascript:save_close()');
		  echo '&nbsp;&nbsp;';
		  $button = new button($cmdApply, 'javascript:document.forms[0].submit()');
		  echo '&nbsp;&nbsp;';
		}
	      $button = new button($cmdClose, 'javascript:document.location=\''.$_SERVER['PHP_SELF'].'?path='.$return_to_path.'\';');
	      ?>
		</td>
		</tr>
		</table>
		<?php
		break;
}
$tabtable->print_foot();
?>
  <script type="text/javascript">
function save_close()
{
  document.forms[0].close.value='true';
javascript:document.forms[0].submit();
}
</script>

