<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once("../../Group-Office.php");

//authenticate the user
$GO_SECURITY->authenticate();

//see if the user has access to this module
//for this to work there must be a module named 'example'
$GO_MODULES->authenticate('filesystem');

/*require_once($GO_MODULES->class_path.'filesystem.class.inc');
$cms = new cms();*/

//get the language file
require_once($GO_LANGUAGE->get_language_file('filesystem'));


$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

if($task=='save')
{	
	$name = trim($_POST['name']);
	
	if($name == '')
	{
		$feedback = '<p class="Error">'.$error_missing_field.'</p>';
	}else
	{
		if(!eregi('htm', get_extension($name)))
		{
			$name .= '.html';
		}
		
		if(!isset($_POST['content']) && file_exists($_REQUEST['path'].'/'.$name))
		{
			$feedback = '<p class="Error">'.$fbNameExists.'</p>';
		}else
		{
			if(!isset($_POST['content']))
			{
				$_REQUEST['path'] .= '/'.$name;
			}			
		 	if($fd = fopen($_REQUEST['path'],'w+'))
		 	{
		 		if(isset($_POST['content']))
		 		{
		 			fwrite($fd, $_POST['content']);
		 		}
				fclose($fd);
			}
		}
	}
}

//create filesystem  object
require_once ($GO_CONFIG->class_path.'filesystem.class.inc');
$fs = new filesystem();

if(!is_dir($_REQUEST['path']))
{
	if(!$fs->has_write_permission($GO_SECURITY->user_id, dirname($_REQUEST['path'])))
	{
		header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
		exit();
	}
	
	$name = basename($_REQUEST['path']);
	
	$content = '';
	$fd = fopen($_REQUEST['path'],'r');
	while (!feof($fd)) {
		$content .= fread($fd, 32768);
	}
	fclose($fd);
}else
{
	if(!$fs->has_write_permission($GO_SECURITY->user_id, $_REQUEST['path']))
	{
		header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit();
	}
	
  require_once($GO_THEME->theme_path."header.inc");
  require_once("add_file.inc");
  require_once($GO_THEME->theme_path."footer.inc");
  exit();
}

//create htmlarea
$htmlarea = new htmlarea();

$GO_HEADER['head'] = $htmlarea->get_header('content', -25, -80, 25, '', "config.baseURL='';", true, false, true);
$GO_HEADER['body_arguments'] = 'onload="initEditor()"';

//require the header file. This will draw the logo's and the menu
require_once($GO_THEME->theme_path."header.inc");

//echo '<table border="0" cellpadding="10" cellspacing="0"><tr><td>';
if (isset($feedback)) echo $feedback;
echo '<form method="post" name="editor" action="'.$_SERVER['PHP_SELF'].'">';
echo '<input type="hidden" name="path" value="'.$_REQUEST['path'].'" />';
echo '<input type="hidden" name="task" />';
echo '<input type="hidden" name="name" value="'.htmlspecialchars($name).'" />';

echo '<table border="0">';
echo '<td class="ModuleIcons" nowrap>';
echo '<a href="javascript:document.editor.task.value=\'save\';document.editor.onsubmit();document.editor.submit();"><img src="'.$GO_THEME->images['save_big'].'" border="0" height="32" width="32" /><br />'.$cmdSave.'</a></td>';
if (!is_dir($_REQUEST['path']))
{
/*  echo '<td class="ModuleIcons"  nowrap>';
  echo '<a class="small" href="properties.php?task=file_properties&file_id='.$file_id.'&return_to='.urlencode($link_back).'&folder_id='.$folder_id.'"><img src="'.$GO_THEME->images['properties'].'" border="0" height="32" width="32" /><br />'.$fbProperties.'</a></td>';*/
}
echo '<td class="ModuleIcons"  nowrap>';
echo '<a class="small" href="javascript:confirm_close(\''.$GO_MODULES->url.'index.php\')"><img src="'.$GO_THEME->images['close'].'" border="0" height="32" width="32" /><br />'.$cmdClose.'</a></td>';

echo '<td class="ModuleIcons" nowrap>';
echo '<a class="small" href=\'javascript:clean_editor_html()\'><img src="'.$GO_THEME->images['filters'].'" border="0" height="32" width="32" /><br />'.$fs_cleanup.'</a></td>';
echo '</table>';



$htmlarea->print_htmlarea(htmlspecialchars($content));
echo '</form>';
?>
  <script type="text/javascript">
function clean_formatting()
{
  document.forms[0].task.value='clean_formatting';
  document.forms[0].onsubmit();
  document.forms[0].submit();
}

function confirm_close(URL)
{
  document.location=URL;
}

</script>
<?php
require_once($GO_THEME->theme_path."footer.inc");
?>
