<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */
 
require('../../Group-Office.php');

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');

require_once ($GO_CONFIG->class_path."mail/imap.class.inc");
require_once ($GO_MODULES->class_path."email.class.inc");
require_once ($GO_LANGUAGE->get_language_file('email'));
$mail = new imap();
$email = new email();

$overlib  = new overlib();
/*
   prints the folders in a tree
   $folders is an array of associative arrays containing an 'id' and 'name'
 */
function buildTree($rootNode, $parent_folder_id=0)
{	
	global $account, $mail, $GO_THEME, $ml_inbox, $ml_confirm_empty_trash;
	$email = new email();
	
	$email->get_subscribed($account['id'], $parent_folder_id);
	
	while($email->next_record())
	{			
		if ($pos = strrpos($email->f('name'), $email->f('delimiter')))
		{
			$folder_name = substr($email->f('name'),$pos+1);
		}else
		{
			$folder_name = $email->f('name');
		}

		//check for unread mail
		$status = $mail->status($email->f('name'));
		if ($status->unseen > 0)
		{
			$status = '<span class="count">&nbsp;('.$status->unseen.')</span>';
		}else
		{
			$status = '';
		}
		
		if($folder_name == 'INBOX') $folder_name = $ml_inbox;
		
		$short_name = cut_string($folder_name, 30);
	
		$folderLink = '<a href="messages.php?account_id='.$account['id'].
			'&folder_id='.$email->f('id').'&mailbox='.urlencode($email->f('name')).
			'" title="'.$email->f('name').'" target="messages">';
		
		$closedFolderNode = $folderLink.
			'<img src="'.$GO_THEME->images['folderclosed'].'" border="0" height="22" width="24" align="middle" />'.
		$short_name.'</a>'.$status;
		
		$openedFolderNode = $folderLink.
			'<img src="'.$GO_THEME->images['folderopen'].'" border="0" height="22" width="24" align="middle" />'.
		$short_name.'</a>'.$status;
		
		if($email->f('name') == $account['trash'])
		{
			$emptyTrashLink = "&nbsp;<a href='javascript:parent.messages.confirm_empty_trash(\"".htmlspecialchars($ml_confirm_empty_trash)."\");' title=\"".htmlspecialchars($ml_confirm_empty_trash)."\"><img src=\"".$GO_THEME->images['delete']."\" border=\"0\"></a>";
			$openedFolderNode .= $emptyTrashLink;
			$closedFolderNode .= $emptyTrashLink;
		}
		
		$subNode = new treenode($email->f('id'), $closedFolderNode, $openedFolderNode);
		$subNode = buildTree($subNode, $email->f('id'));			
		$rootNode->addNode($subNode);	
	}

	return $rootNode;
	
}

if($_SERVER['REQUEST_METHOD'] != 'POST')
{	
	$count = $email->get_accounts($GO_SECURITY->user_id);
	
	$rootNode = new treenode('root','Accounts', null, true);
	
	if(!isset($_SESSION['treeview']))
	{
		$_SESSION['treeview'] = new treeview();
	}else
	{	
		$_SESSION['treeview']->reset();
	}
	
	while($email->next_record())
	{		
		$account = $email->Record;
		if (!$mail->open($account['host'], $account['type'], $account['port'], $account['username'], $account['password'], '', 0, $account['use_ssl'], $account['novalidate_cert'])) {
			
			$error =  $ml_connect_failed.' \''.$account['host'].'\' '.$ml_at_port.': '.$account['port'].'<br /><br />'.
					imap_last_error();
			
			$short_name = cut_string($email->f('email'), 30);
			$accountNodeText = '<span class="Error"  '.$overlib->print_overlib(htmlspecialchars($error), '', 'ol_width=200').'><img src="'.$GO_THEME->images['inbox'].'" style="border:0px;margin-right:5px;" align="middle" />'.$short_name.'</span>';
					
			$accountNode = new treenode('account_'.$email->f('id'), $accountNodeText);
			
			$_SESSION['treeview']->addRootNode($accountNode);				
		}else
		{		
			$short_name = cut_string($email->f('email'), 30);
			
			$accountNodeText = '<a href="messages.php?account_id='.$account['id'].
				'&mailbox=INBOX'.
				'" title="'.$email->f('email').'" target="messages"><img src="'.$GO_THEME->images['inbox'].'" style="border:0px;margin-right:5px;" align="middle" />'.$short_name.'</a>';
			
					
			if($mail->is_imap())
			{			
				$accountNodeId = 'account_'.$email->f('id');
				if(!isset($_SESSION['treeview']->nodeState))
				{
						$_SESSION['treeview']->setOpen($accountNodeId);
				}elseif(!$_SESSION['treeview']->nodeIsOpen($accountNodeId))
				{
						//check for unread mail
					$status = $mail->status('INBOX');	
					if ($status->unseen > 0)
					{
						$accountNodeText .= '<span class="count">&nbsp;('.$status->unseen.')</span>';
					}			
				}
				$accountNode = new treenode($accountNodeId, $accountNodeText, $accountNodeText);
				$accountNode = buildTree($accountNode);
			}else
			{
				//check for unread mail
				$status = $mail->status('INBOX');
	
				if ($status->unseen > 0)
				{
					$accountNodeText .= '<span class="count">&nbsp;('.$status->unseen.')</span>';
				}
				$accountNode = new treenode('account_'.$email->f('id'), $accountNodeText, $accountNodeText);
			}
			
			$_SESSION['treeview']->addRootNode($accountNode);	
			$mail->close();
		}
	}
}

$GO_HEADER['head'] = $overlib->get_header();
require($GO_THEME->theme_path.'header.inc');

echo '<form name="treeview_form" method="post" action="'.$_SERVER['PHP_SELF'].'">';
echo '<input type="hidden" name="empty_trash" value="false" />';
echo $_SESSION['treeview']->getTreeview();

echo '</form>';

require($GO_THEME->theme_path.'footer.inc');
?>