<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once("../../Group-Office.php");
$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');
require_once($GO_LANGUAGE->get_language_file('email'));

require_once($GO_CONFIG->class_path."mail/phpmailer/class.phpmailer.php");
require_once($GO_CONFIG->class_path."mail/phpmailer/class.smtp.php");
require_once($GO_CONFIG->class_path."html2text.class.inc");
require_once($GO_MODULES->class_path."email.class.inc");
$email = new email();

require_once($GO_CONFIG->class_path.'mail/RFC822.class.inc');
$RFC822 = new RFC822();   

//load personal settings
$em_settings = $email->get_settings($GO_SECURITY->user_id);

//Check for templates plugin
$tp_plugin = $GO_MODULES->get_plugin('templates', 'addressbook');
if ($tp_plugin)
{
	require_once($tp_plugin['class_path'].'templates.class.inc');
	$tp = new templates();
}

//check for the addressbook module
$ab_module = isset($GO_MODULES->modules['addressbook']) ? $GO_MODULES->modules['addressbook'] : false;
if (!$ab_module || !$ab_module['read_permission'])
{
	$ab_module = false;
}else
{
	require_once($ab_module['class_path'].'addressbook.class.inc');
	$ab = new addressbook();

	$default_addressbook_id = $ab->get_default_addressbook($GO_SECURITY->user_id);
}


$mail_subject = isset($_REQUEST['mail_subject']) ? smart_stripslashes($_REQUEST['mail_subject']) : '';
$mail_body = isset($_REQUEST['mail_body']) ? smart_stripslashes($_REQUEST['mail_body']) : '';
$mail_from = isset($_REQUEST['mail_from']) ? $_REQUEST['mail_from'] : 0;
$mail_to = isset($_REQUEST['mail_to']) ? smart_stripslashes($_REQUEST['mail_to']) : '';
$mail_cc = isset($_REQUEST['mail_cc']) ? smart_stripslashes($_REQUEST['mail_cc']) : '';
$mail_bcc = isset($_REQUEST['mail_bcc']) ? smart_stripslashes($_REQUEST['mail_bcc']) : '';
$uid = isset($_REQUEST['uid']) ? $_REQUEST['uid'] : 0;
$show_cc = isset($_POST['show_cc']) ? $_POST['show_cc'] : 'false';
$show_bcc = isset($_POST['show_bcc']) ? $_POST['show_bcc'] : 'false';


$html_mail_head = '<html><head><meta http-equiv=Content-Type content="text/html;charset='.$charset.'"><meta content="Group-Office '.$GO_CONFIG->version.'" name="GENERATOR"></head><body>';
$html_mail_foot = '</body></html>';

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
	$notification_check = isset($_POST['notification']) ? true : false;
}else
{
	$notification_check = $em_settings['request_notification'];
}

$mailing_group_id = isset($_REQUEST['mailing_group_id']) ? $_REQUEST['mailing_group_id'] : 0;

//load htmlarea
$htmlarea = new htmlarea();
if ($htmlarea->browser_is_supported())
{
	$wysiwyg = true;

	$content_type = isset($_POST['content_type']) ? $_POST['content_type'] : $em_settings['send_format'];

	if ($content_type == 'text/PLAIN')
	{
		$htmlarea->force_textmode();
	}
}else
{
	$content_type = 'text/PLAIN';
	$wysiwyg = false;
}

$page_title = $ml_compose;
$sendaction = isset($_REQUEST['sendaction']) ? $_REQUEST['sendaction'] : '';
$attachments_size = 0;

function add_unknown_reciepent($email, $name, $addressbook_id)
{
	global $GO_SECURITY, $ab;

	$name_arr = split_name($name);

	if($name_arr['first'] == '' && $name_arr['last'] == '')
	{
		$name_arr['first'] = $email;
	}

	if ($ab->search_contacts($GO_SECURITY->user_id, addslashes($email), 'email') == 0)
	{
		$contact['addressbook_id'] = $addressbook_id;
		$contact['first_name'] = addslashes($name_arr['first']);
		$contact['middle_name'] = addslashes($name_arr['middle']);
		$contact['last_name'] = addslashes($name_arr['last']);
		$contact['email'] = addslashes($email);		
		$ab->add_contact($contact);
	}
}
if($sendaction == 'save_draft')
{
	$save_draft = true;
	$sendaction ='send';
}
switch ($sendaction)
{
	case 'send':
		if (!isset($_POST['mail_from']))
		{
			$profile = $GO_USERS->get_user($GO_SECURITY->user_id);
			$middle_name = $profile['middle_name'] == '' ? '' : $profile['middle_name'].' ';
			$name = $profile['first_name'].' '.$middle_name.$profile['last_name'];
		}else
		{
			$profile = $email->get_account($_POST['mail_from']);
			$name = $profile["name"];
		}

		$mail = new PHPMailer();
		$mail->CharSet=$charset;
		$mail->PluginDir = $GO_CONFIG->class_path.'mail/phpmailer/';
		$mail->SetLanguage($php_mailer_lang, $GO_CONFIG->class_path.'mail/phpmailer/language/');

		switch($GO_CONFIG->mailer)
		{
			case 'smtp':
				$mail->Host = $GO_CONFIG->smtp_server;
				$mail->Port = $GO_CONFIG->smtp_port;
				$mail->IsSMTP();			  
				break;			
			case 'qmail':
				$mail->IsQmail();
				break;			
			case 'sendmail':
				$mail->IsSendmail();
				break;
			case 'mail':
				$mail->IsMail();
				break;
		}
		$mail->Priority = $_POST['priority'];
		$mail->Sender     = $profile["email"];    
		$mail->From     = $profile["email"];
		$mail->FromName = $name;
		$mail->AddReplyTo($profile["email"],$name);
		$mail->WordWrap = 76;
		//$mail->Encoding = "quoted-printable";

		if (isset($_POST['notification']))
		{
			$mail->ConfirmReadingTo = $profile["email"];
		}
		$html_message = $content_type == 'text/HTML' ? true : false;
		$mail->IsHTML($html_message);
		$mail->Subject = smart_stripslashes(trim($mail_subject));

		if (isset($_SESSION['url_replacements']))
		{
			while($url_replacement = array_shift($_SESSION['url_replacements']))
			{
				$mail_body=str_replace($url_replacement['url'], "cid:".$url_replacement['id'], $mail_body);
			}
			unset($_SESSION['url_replacements']);
		}

		// Getting the attachments
		if (isset($_SESSION['attach_array']))
		{
			for ($i=0;$i<count($_SESSION['attach_array']);$i++)
			{
				// If the temporary file exists, attach it
				$tmp_file = stripslashes($_SESSION['attach_array'][$i]->tmp_file);
				if (file_exists($tmp_file))
				{
					if ($_SESSION['attach_array'][$i]->disposition == 'attachment' || strpos($mail_body, $_SESSION['attach_array'][$i]->content_id))
					{
						if ($_SESSION['attach_array'][$i]->disposition == 'attachment')
						{
							$mail->AddAttachment($tmp_file, $_SESSION['attach_array'][$i]->file_name, 'base64',  $_SESSION['attach_array'][$i]->file_mime) ;
						}else
						{
							$mail->AddEmbeddedImage($tmp_file, $_SESSION['attach_array'][$i]->content_id, imap_8bit($_SESSION['attach_array'][$i]->file_name), 'base64',  $_SESSION['attach_array'][$i]->file_mime);
						}
					}
				}
			}
		}
		$mail_to_array = $RFC822->parse_address_list($mail_to);
		foreach ($mail_to_array as $to_address)
		{     	
			$mail->AddAddress($to_address['email'], $to_address['personal']);

			if ($em_settings['add_recievers'] == '1' && $ab_module)
			{
				add_unknown_reciepent($to_address['email'], $to_address['personal'], $default_addressbook_id);
			}
		}
		$mail_cc_array = $RFC822->parse_address_list($mail_cc);
		foreach ($mail_cc_array as $cc_address)
		{
			$mail->AddCC($cc_address['email'], $cc_address['personal']);

			if ($em_settings['add_recievers'] == '1' && $ab_module)
			{
				add_unknown_reciepent($cc_address['email'], $cc_address['personal'], $default_addressbook_id);
			}
		}

		$mail_bcc_array = $RFC822->parse_address_list($mail_bcc);
		foreach ($mail_bcc_array as $bcc_address)
		{
			$mail->AddBCC($bcc_address['email'], $bcc_address['personal']);

			if ($em_settings['add_recievers'] == '1' && $ab_module)
			{
				add_unknown_reciepent($bcc_address['email'], $bcc_address['personal'], $default_addressbook_id);
			}
		}

		if ($html_message)
		{
			//MS:
			$mail->Body = $html_mail_head.$mail_body.$html_mail_foot;
			//$mail->Body = $mail_body;
			$htmlToText = new Html2Text ($mail_body);
			$mail->AltBody = $htmlToText->get_text();
		}else
		{
			$mail->Body = $mail_body;
		}

		if(isset($save_draft))
		{
			//set Line enidng to \r\n for Cyrus IMAP
			$mail->LE = "\r\n";
			$mime = $mail->GetMime();
			require_once($GO_CONFIG->class_path."mail/imap.class.inc");
			$imap_stream = new imap();

			$account = $email->get_account($_REQUEST['mail_from']);

			if ($imap_stream->open($account["host"], "imap", $account["port"], $account["username"], $account["password"], $account['drafts'], 0, $account['use_ssl'], $account['novalidate_cert']))
			{
				if ($imap_stream->append_message($account['drafts'], $mime,"\\Draft \\Seen"))
				{
					if (isset($_SESSION['attach_array']))
					{
						while($attachment = array_shift($_SESSION['attach_array']))
						{
							@unlink($attachment->tmp_file);
						}
					}
					// We need to unregister the attachments array
					unset($_SESSION['attach_array']);

					$imap_stream->close();
					require_once($GO_THEME->theme_path."header.inc");
					echo "<script type=\"text/javascript\">\r\nwindow.close();\r\n</script>\r\n";
					require_once($GO_THEME->theme_path."footer.inc");
					exit();
				}else
				{
					$feedback = '<p class="Error">'.$ml_save_draft_error.' '.$mail->ErrorInfo.'</p>';
				}
			}
		}else
		{
			if(!$mail->Send())
			{
				$feedback = '<p class="Error">'.$ml_send_error.' '.$mail->ErrorInfo.'</p>';
			}else
			{
				//set Line enidng to \r\n for Cyrus IMAP
				$mail->LE = "\r\n";
				$mime = $mail->GetMime();

				if (isset($_SESSION['attach_array']))
				{
					while($attachment = array_shift($_SESSION['attach_array']))
					{
						@unlink($attachment->tmp_file);
					}
				}
				// We need to unregister the attachments array
				unset($_SESSION['attach_array']);

				if ($profile["type"] == "imap")
				{
					$sent_folder = $profile['sent'];
					if ($sent_folder != '')
					{
						require_once($GO_CONFIG->class_path."mail/imap.class.inc");
						$imap_stream = new imap();
						if ($imap_stream->open($profile["host"], "imap", $profile["port"], $profile["username"], $profile["password"], $sent_folder, 0, $profile['use_ssl'], $profile['novalidate_cert']))
						{
							if ($imap_stream->append_message($sent_folder, $mime,"\\Seen"))
							{
								if (isset($_REQUEST['action']))
								{
									if($_REQUEST['action']== "reply" || $_REQUEST['action'] == "reply_all")
									{
										$uid_arr = array($_REQUEST['uid']);
										$imap_stream->set_message_flag($_POST['mailbox'], $uid_arr, "\\Answered");
									}
								}

								$imap_stream->close();
								require_once($GO_THEME->theme_path."header.inc");
								echo "<script type=\"text/javascript\">\r\nwindow.close();\r\n</script>\r\n";
								require_once($GO_THEME->theme_path."footer.inc");
								exit();
							}
						}
						require_once($GO_THEME->theme_path."header.inc");
						echo "<script type=\"text/javascript\">\r\nalert('".$ml_sent_items_fail."');\r\nwindow.close();\r\n</script>\r\n";
						require_once($GO_THEME->theme_path.'footer.inc');
						exit();
					}else
					{
						require_once($GO_THEME->theme_path."header.inc");
						echo "<script type=\"text/javascript\">\r\nwindow.close();\r\n</script>\r\n";
						require_once($GO_THEME->theme_path.'footer.inc');
						exit();
					}
				}else
				{
					require_once($GO_THEME->theme_path.'header.inc');
					echo "<script type=\"text/javascript\">\r\nwindow.close();\r\n</script>\r\n";
					require_once($GO_THEME->theme_path.'footer.inc');
					exit();
				}
			}
		}

		break;
}

//if a template id is given then process it
$template_id = isset($_REQUEST['template_id']) ? $_REQUEST['template_id'] : 0;
$contact_id = isset($_REQUEST['contact_id']) ? $_REQUEST['contact_id'] : 0;
$company_id = isset($_REQUEST['company_id']) ? $_REQUEST['company_id'] : 0;


if($mailing_group_id > 0 && $tp->get_contacts_from_mailing_group($mailing_group_id) == 0 && $tp->get_companies_from_mailing_group($mailing_group_id) == 0)
{
	require_once($GO_THEME->theme_path."header.inc");
	$tabtable = new tabtable('templates_tab', $ml_attention, '600', '120');
	$tabtable->print_head();
	echo '<p>'.$ml_no_contacts_in_mailing_group.'</p><br />';
	$button = new button($cmdClose, "javascript:window.close();");
	$tabtable->print_foot();
	require_once($GO_THEME->theme_path."footer.inc");
	exit();
}

if ($tp_plugin)
{
	$template_count = $tp->get_authorized_templates($GO_SECURITY->user_id, EMAIL_TEMPLATE);
}

$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';

if ($_SERVER['REQUEST_METHOD'] != "POST" && $tp_plugin && $template_id == 0 && 
		$template_count > 0 && $action != 'open')
{
	require_once($GO_THEME->theme_path."header.inc");
	echo '<form name="sendform" method="post" action="'.$_SERVER['PHP_SELF'].'">';
	if($uid > 0)
	{
		//echo '<input type="hidden" name="account_id" value="'.$_REQUEST['account_id'].'" />';
		echo '<input type="hidden" name="uid" value="'.$uid.'" />';
		echo '<input type="hidden" name="mailbox" value="'.$_REQUEST['mailbox'].'" />';
		echo '<input type="hidden" name="action" value="'.$_REQUEST['action'].'" />';
	}
	if(isset($_REQUEST['email_file']))
	{
		echo '<input type="hidden" name="email_file" value="true" />';
	}

	echo '<input type="hidden" name="mail_subject" value="'.$mail_subject.'" />';
	echo '<input type="hidden" name="mail_body" value="'.smart_stripslashes($mail_body, true).'" />';
	echo '<input type="hidden" name="mail_to" value="'.htmlspecialchars($mail_to,ENT_QUOTES).'" />';
	echo '<input type="hidden" name="mail_cc" value="'.$mail_cc.'" />';
	echo '<input type="hidden" name="mail_bcc" value="'.$mail_bcc.'" />';
	echo '<input type="hidden" name="mail_from" value="'.$mail_from.'" />';
	echo '<input type="hidden" name="contact_id" value="'.$contact_id.'" />';
	echo '<input type="hidden" name="company_id" value="'.$company_id.'" />';
	echo '<input type="hidden" name="template_id" />';
	echo '<input type="hidden" name="mailing_group_id" value="'.$mailing_group_id.'" />';
	echo '<input type="hidden" name="sendaction" value="load_template" />';
	if($notification_check)
	{
		echo '<input type="hidden" name="notification" value="true" />';
	}
	//get the addressbook language file
	echo '<table border="0" width="100%"><tr><td align="center">';
	require_once($GO_LANGUAGE->get_language_file('addressbook'));
	$tabtable = new tabtable('templates_tab', $ab_templates, '600', '400');
	$tabtable->print_head();

	echo '<table border="0" cellpadding="10" cellspacing="0"><tr><td>';
	echo $ab_select_template;
	echo '<table border="0" cellpadding="2">';

	echo '<tr><td><a class="normal" href="javascript:document.forms[0].template_id.value=\'0\';document.forms[0].submit();">'.$ab_no_template.'</a></td></tr>';

	while($tp->next_record())
	{
		echo '<tr><td><a class="normal" href="javascript:document.forms[0].template_id.value=\''.$tp->f('id').'\';document.forms[0].submit();">'.$tp->f('name').'</a></td></tr>';
	}

	echo '</table></td></tr></table>';
	echo '<br />';
	$button = new button($cmdClose, "javascript:window.close()");
	$tabtable->print_foot();
	echo '</td></tr></table>';
	echo '</form>';
}else
{
	if ($content_type=='text/HTML')
	{
		if ($fs_module = $GO_MODULES->get_module('filesystem'))
		{
			if ($GO_SECURITY->has_permission($GO_SECURITY->user_id, $fs_module['acl_read']) || $GO_SECURITY->has_permission($GO_SECURITY->user_id, $fs_module['acl_write']))
			{
				$htmlarea->add_button('go_image', '', $GO_CONFIG->control_url.'/htmlarea/images/ed_image.gif', 'false', "function insertGOimage()
						{
						popup('select_image.php','600','400');
						}");

			}
		}
	}

	//reset attachments array in case user aborted a message or changed format
	if ($_SERVER['REQUEST_METHOD'] != "POST" || $sendaction=='load_template')
	{
		if (!isset($_REQUEST['email_file']))
		{
			unset($_SESSION['attach_array']);
			unset($_SESSION['url_replacements']);
		}
	}

	//get users email accounts to determine from addresses
	$count = $email->get_accounts($GO_SECURITY->user_id);
	while ($email->next_record())
	{
		if ($mail_from == 0)
		{
			$mail_from = $email->f('id');
		}
		$addresses[] = $email->f("email");
		$names[] = $email->f("email")." (".$email->f("name").")";
		$ids[] = $email->f("id");
	}



	$signature = '';
	if ($mail_from > 0)
	{
		$account = $email->get_account($mail_from);

		if ($account['signature'] != '')
		{
			if ($content_type == 'text/HTML')
			{
				$signature = '<br />'.text_to_html($account['signature']).'<br /><br />';
			}else
			{
				$signature = "\r\n".$account['signature']."\r\n\r\n";
			}
		}
	} 

	//if a uid is given then the user is replying or forwarding
	if ($uid > 0 && ($_SERVER['REQUEST_METHOD']  != 'POST' || $sendaction == 'load_template' || $sendaction == 'change_format'))
	{
		//get the original message
		require_once($GO_CONFIG->class_path."mail/imap.class.inc");
		$mail = new imap();

		$account = $email->get_account($mail_from);

		if ($account && $mail->open($account['host'], $account['type'], $account['port'], $account['username'], $account['password'], $_REQUEST['mailbox'], 0, $account['use_ssl'], $account['novalidate_cert']))
		{
			$preferred_type = ($content_type=='text/HTML') ? 'html' : 'text';
			$content = $mail->get_message($uid, $preferred_type,"");
			$parts = array_reverse($mail->f("parts"));

			//fill in the header fields
			$subject = isset($content['subject']) ? $content['subject'] : $ml_no_subject;
			switch($_REQUEST['action'])
			{
				case 'open':
					$mail_subject = $subject;
					if (isset($content["to"]))
					{
						for ($i=0;$i<sizeof($content["to"]);$i++)
						{

							if ($content["to"][$i] != "" && !in_array(get_email_from_string($content["to"][$i]),$addresses))
							{
								if (!isset($first))
								{
									$first = true;
								}else
								{
									$mail_to .= ',';
								}
								$mail_to .= $content["to"][$i];
							}
						}
					}
					unset($first);
					if (isset($content["cc"]))
					{
						$show_cc = 'true';
						for ($i=0;$i<sizeof($content["cc"]);$i++)
						{				
							if ($content["cc"][$i] != "" && !in_array(get_email_from_string($content["cc"][$i]),$addresses))
							{
								if (!isset($first))
								{
									$first = true;
								}else
								{
									$mail_cc .= ',';
								}
								$mail_cc .= $content["cc"][$i];
							}
						}
					}
					if($sendaction != 'change_format')
					{
						for ($i=0;$i<count($parts);$i++)
						{
							if (eregi("attachment", $parts[$i]["disposition"]) ||
									($parts[$i]["id"] == '' && eregi("inline", $parts[$i]["disposition"]))
									&& !eregi("message/RFC822", $parts[$i]["mime"]))
							{
								$file = $mail->view_part($uid, $parts[$i]["number"], $parts[$i]["transfer"]);

								$name = $parts[$i]['name'] != '' ? $parts[$i]['name'] : 'attach_'.$i;

								$tmp_file = $GO_CONFIG->tmpdir.md5(uniqid(time()));
								$fp = fopen($tmp_file,"wb");
								fwrite ($fp,$file);
								fclose($fp);
								$email->register_attachment($tmp_file, $parts[$i]["name"], $parts[$i]["size"], $parts[$i]["mime"], 'attachment', $parts[$i]["id"]);
							}
						}
					}
				break;
				
				case "reply":
					$mail_to = $content["reply_to"];
					if(!eregi('Re:', $subject))
					{
						$mail_subject = 'Re: '.$subject;
					}else
					{
						$mail_subject = $subject;
					}
				break;

				case "reply_all":
					$mail_to = $content["reply_to"];
					if(!eregi('Re:', $subject))
					{
						$mail_subject = 'Re: '.$subject;
					}else
					{
						$mail_subject = $subject;
					}
	
					//add all recievers from this email
					if (isset($content["to"]))
					{						
						for ($i=0;$i<sizeof($content["to"]);$i++)
						{
							if ($content["to"][$i] != "" && !in_array(get_email_from_string($content["to"][$i]),$addresses))
							{
								$mail_to .= ",".$content["to"][$i];
							}
						}
					}
					if (isset($content["cc"]) && count($content["cc"]) > 0)
					{
						$show_cc = 'true';
						for ($i=0;$i<sizeof($content["cc"]);$i++)
						{
							if ($content["cc"][$i] != "" && !in_array(get_email_from_string($content["cc"][$i]),$addresses))
							{
								if (!isset($first))
								{
									$first = true;
								}else
								{
									$mail_cc .= ',';
								}
								$mail_cc .= $content["cc"][$i];
							}
						}
					}

				break;

				case "forward":
					//reattach attachments
					if(!eregi('Fwd:', $subject))
					{
						$mail_subject = 'Fwd: '.$subject;
					}else
					{
						$mail_subject = $subject;
					}

				if($sendaction != 'change_format')
				{
					for ($i=0;$i<count($parts);$i++)
					{
						if (eregi("attachment", $parts[$i]["disposition"]) ||
								($parts[$i]["id"] == '' && eregi("inline", $parts[$i]["disposition"]))
								&& !eregi("message/RFC822", $parts[$i]["mime"]))
						{
							$file = $mail->view_part($uid, $parts[$i]["number"], $parts[$i]["transfer"]);

							$name = $parts[$i]['name'] != '' ? $parts[$i]['name'] : 'attach_'.$i;

							$tmp_file = $GO_CONFIG->tmpdir.md5(uniqid(time()));
							$fp = fopen($tmp_file,"wb");
							fwrite ($fp,$file);
							fclose($fp);
							$email->register_attachment($tmp_file, $parts[$i]["name"], $parts[$i]["size"], $parts[$i]["mime"], 'attachment', $parts[$i]["id"]);
						}
					}
				}
				break;
			}

			//reatach inline attachements
			for ($i=0;$i<count($parts);$i++)
			{
				if ($parts[$i]["id"] != '')// && eregi("inline", $parts[$i]["disposition"]))
				{
					$file = $mail->view_part($uid, $parts[$i]["number"], $parts[$i]["transfer"]);

					$tmp_file = $GO_CONFIG->tmpdir.md5(uniqid(time()));

					$fp = fopen($tmp_file,"wb");
					fwrite ($fp,$file);
					fclose($fp);

					if (strpos($parts[$i]["id"],'>'))
					{
						$parts[$i]["id"] = substr($parts[$i]["id"], 1,strlen($parts[$i]["id"])-2);
					}
					$email->register_attachment($tmp_file, $parts[$i]["name"],
							$parts[$i]["size"], $parts[$i]["mime"], 'inline', $parts[$i]["id"]);
					//Content-ID's that need to be replaced with urls when message is send

					//replace inline images identified by a content id with the url to display the part by Group-Office
					$url_replacement['id'] = $parts[$i]["id"];
					$url_replacement['url'] = "attachment.php?account_id=".$mail_from."&mailbox=".$_REQUEST['mailbox']."&uid=".$uid."&part=".$parts[$i]["number"]."&transfer=".$parts[$i]["transfer"]."&mime=".$parts[$i]["mime"]."&filename=".urlencode($parts[$i]["name"]);
					$_SESSION['url_replacements'][] = $url_replacement;
				}
			}

			$html_message_count = 0;
			for ($i=0;$i<count($parts);$i++)
			{
				if($content_type=='text/HTML')
				{
					$mime = strtolower($parts[$i]["mime"]);

					if (!eregi("attachment", $parts[$i]["disposition"]))
					{
						switch ($mime)
						{
							case 'text/plain':
								$html_part = text_to_html($mail->view_part($uid,
											$parts[$i]["number"], $parts[$i]["transfer"], $parts[$i]['charset']));
								$mail_body .= addslashes($html_part);
								break;

							case 'text/html':
								$html_part = convert_html($mail->view_part($uid,
											$parts[$i]["number"], $parts[$i]["transfer"], $parts[$i]['charset']));
								$mail_body .= addslashes($html_part);
								break;

							case 'text/enriched':
								$html_part = enriched_to_html($mail->view_part($uid,
											$parts[$i]["number"], $parts[$i]["transfer"], $parts[$i]['charset']));
								$mail_body .= addslashes($html_part);
								break;
						}
					}
				}else
				{
					if (strtolower($parts[$i]["mime"]) == "text/plain" &&
							!eregi("ATTACHMENT", $parts[$i]["disposition"]))
					{
						$mail_body .= $mail->view_part($uid, $parts[$i]["number"], $parts[$i]["transfer"], $parts[$i]['charset']);						
					}

					//add html messages as an attachment since we don't have an html editor to display it coreect yet
					if (strtolower($parts[$i]["mime"]) == "text/html" &&
							!eregi("ATTACHMENT", $parts[$i]["disposition"]))
					{
						if ($parts[$i]["name"] == '' && $parts[$i]["mime"] == "text/HTML")
						{
							if ($html_message_count == 0)
								$parts[$i]["name"] = $content["sender"].".html";
							else
								$parts[$i]["name"] = $content["sender"]."(".$html_message_count.").html";

							$html_message_count++;
						}

//						$file = $mail->view_part($uid, $parts[$i]["number"],
//								$parts[$i]["transfer"], $parts[$i]["mime"], $parts[$i]['charset']);
						$file = $mail->view_part($uid, $parts[$i]["number"],
								$parts[$i]["transfer"], $parts[$i]['charset']);

						$tmp_file = $GO_CONFIG->tmpdir.md5(uniqid(time()));

						$fp = fopen($tmp_file,"w");
						fwrite ($fp,$file);
						fclose($fp);

						$email->register_attachment($tmp_file, $parts[$i]["name"],
								$parts[$i]["size"], $parts[$i]["mime"]);
					}
				}
			}

			if ($content_type=='text/HTML')
			{
				if ($mail_body != '')
				{
					//replace inline images with the url to display the part by Group-Office
					if (isset($_SESSION['url_replacements']))
					{
						for ($i=0;$i<count($_SESSION['url_replacements']);$i++)
						{
							$mail_body = str_replace('cid:'.$_SESSION['url_replacements'][$i]['id'], $_SESSION['url_replacements'][$i]['url'], $mail_body);
						}
					}
				}
				if($_REQUEST['action'] != 'open')
				{
					$header_om  = '<font face="verdana" size="2">'.$ml_original_follows."<br />";
					$om_to = '';
					if (isset($content))
					{
						$header_om .= "<b>".$ml_subject.":&nbsp;</b>".addslashes($subject)."<br />";
						$header_om .= '<b>'.$ml_from.": &nbsp;</b>".$content['from'].' &lt;'.$content["sender"]."&gt;<br />";
						if (isset($content['to']))
						{
							for ($i=0;$i<sizeof($content["to"]);$i++)
							{
								if ($i!=0)	$om_to .= ',';
								$om_to .= $content["to"][$i];	
							}
						}else
						{
							$om_to=$ml_no_reciepent;
						}
						$header_om .= "<b>".$ml_to.":&nbsp;</b>".addslashes(htmlspecialchars($om_to))."<br />";
						$om_cc = '';
						if (isset($content['cc']))
						{
							for ($i=0;$i<sizeof($content["cc"]);$i++)
							{
								if ($i!=0)	$om_cc .= ',';
								$om_cc .= $content["cc"][$i];	
							}
						}
						if($om_cc != '')
						{
							$header_om .= "<b>CC:&nbsp;</b>".addslashes(htmlspecialchars($om_cc))."<br />";
						}

						$header_om .= "<b>".$strDate.":&nbsp;</b>".date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'],$content["udate"])."<br />";
					}
					$header_om .= "</font><br /><br />";
					
					$mail_body = $signature.'<br /><blockquote style="border:0;border-left: 2px solid #22437f; padding:0px; margin:0px; padding-left:5px; margin-left: 5px; ">'.$header_om.$mail_body.'</blockquote>';
				}

			}else
			{
				if($_REQUEST['action'] != 'open')
				{
					$header_om  = $ml_original_follows."\r\n";
					if (isset($content))
					{
						$header_om .= $ml_subject.": ".$subject."\r\n";
						$header_om .= $ml_from.": ".$content['from'].' <'.$content["sender"].">\r\n";
						$om_to = '';
						if (isset($content['to']))
						{
							for ($i=0;$i<sizeof($content["to"]);$i++)
							{
								if ($i!=0)	$om_to .= ',';								
								$om_to .= $content["to"][$i];	
							}
							$header_om .= $ml_to.": ".$om_to."\r\n";
						}else
						{
							$om_to = $ml_no_reciepent;
						} 
						$om_cc = '';
						if (isset($content['cc']))
						{
							for ($i=0;$i<sizeof($content["cc"]);$i++)
							{
								if ($i!=0)	$om_cc .= ',';
								$om_cc .= $content["cc"][$i];	
							}
						}
						if($om_cc != '')
						{
							$header_om .= "CC: ".$om_cc."\r\n";
						}

						$header_om .= $strDate.": ".date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'],$content["udate"])."\r\n\r\n\r\n";
					}

					if ($html_message_count > 0)
					{
						$mail_body = $ml_html_message_attached."\r\n\r\n".$header_om.$mail_body;
					}else
					{
						$mail_body = $header_om.$mail_body;
					}
					
					$mail_body = $signature.quote($mail_body);
				}
			}
		}
		$mail->close();
	}else
	{
		if($mail_body == '')
		{
			$mail_body = $signature;
		}
	}
	
	$min_height = -195;
	if(count($ids) > 1)
	{
		$min_height -= 25;
	}
	if($show_cc == 'true') $min_height -= 52;
	if($show_bcc == 'true') $min_height -= 52;

	$GO_HEADER['head'] = $htmlarea->get_header('mail_body', -40, $min_height, 25, '');

	if($ab_module && $ab_module['read_permission'])
	{ 	
		$ab->search_contacts($GO_SECURITY->user_id, '%');
		while($ab->next_record())
		{
			if(validate_email($ab->f('email')))
			{
				$middle_name = $ab->f('middle_name') == '' ? ' ' : ' '.$ab->f('middle_name').' ';  		
				$autocomplete_contacts[] = $RFC822->write_address(addslashes($ab->f('first_name').$middle_name.$ab->f('last_name')),$ab->f('email'));
			}
		}
		$ab->search_companies($GO_SECURITY->user_id, '%');
		while($ab->next_record())
		{
			if(validate_email($ab->f('email')))
			{
				$autocomplete_contacts[] = $RFC822->write_address(addslashes($ab->f('name')),$ab->f('email'));
			}
		}
		if(isset($autocomplete_contacts) && count($autocomplete_contacts) > 0)
		{
			$GO_HEADER['head'] .= '<script language="javascript" type="text/javascript" src="'.$GO_CONFIG->host.'javascript/actb.js"></script>';
			$GO_HEADER['head'] .= '<script type="text/javascript">'.
				'var autocomplete_contacts = new Array(\''.implode("','", $autocomplete_contacts).'\');'.
				'</script>';
		}
	}

	$GO_HEADER['body_arguments'] = 'onload="initEditor();document.sendform.mail_to.focus();" onUnLoad="close_attachments();"';
	$overlib = new overlib();
	$GO_HEADER['head'] .= $overlib->get_header();
	require_once($GO_THEME->theme_path."header.inc");
	require_once("compose.inc");
}
require_once($GO_THEME->theme_path."footer.inc");
?>
