<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */
 
require('../../Group-Office.php');

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');

require_once ($GO_CONFIG->class_path."mail/imap.class.inc");
require_once ($GO_MODULES->class_path."email.class.inc");
require_once ($GO_LANGUAGE->get_language_file('email'));
$mail = new imap();
$email = new email();

$overlib  = new overlib();

$account_id = isset ($_REQUEST['account_id']) ? $_REQUEST['account_id'] : 0;
$mailbox = isset ($_REQUEST['mailbox']) ? smart_stripslashes($_REQUEST['mailbox']) : 'INBOX';
$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$uid = isset ($_REQUEST['uid']) ? $_REQUEST['uid'] : 0;
$max_rows = isset ($_REQUEST['max_rows']) ? $_REQUEST['max_rows'] : $_SESSION['GO_SESSION']['max_rows_list'];
$first_row = (isset ($_REQUEST['first_row'])) ? $_REQUEST['first_row'] : 0;
$table_tabindex = isset ($_REQUEST['table_tabindex']) ? $_REQUEST['table_tabindex'] : null;
$mailbox = isset ($_REQUEST['mailbox']) ? smart_stripslashes($_REQUEST['mailbox']) : 'INBOX';
$link_back = $GO_MODULES->url.'messages.php?account_id='.$account_id.'&mailbox='.urlencode($mailbox).'&first_row='.$first_row;

$em_settings = $email->get_settings($GO_SECURITY->user_id);

$refresh_treeview = false;
$first_uid = false;

//search query parameters
$from = isset ($_REQUEST['from']) ? smart_stripslashes(trim($_REQUEST['from'])) : '';
$to = isset ($_REQUEST['to']) ? smart_stripslashes(trim($_REQUEST['to'])) : '';
$subject = isset ($_REQUEST['subject']) ? smart_stripslashes(trim($_REQUEST['subject'])) : '';
$cc = isset ($_REQUEST['cc']) ? smart_stripslashes(trim($_REQUEST['cc'])) : '';
$body = isset ($_REQUEST['body']) ? smart_stripslashes(trim($_REQUEST['body'])) : '';
$before = isset ($_REQUEST['before']) ? smart_stripslashes(trim($_REQUEST['before'])) : '';
$since = isset ($_REQUEST['since']) ? smart_stripslashes(trim($_REQUEST['since'])) : '';
$before = isset ($_REQUEST['before']) ? $_REQUEST['before'] : '';
$since = isset ($_REQUEST['since']) ? $_REQUEST['since'] : '';
$flagged = isset ($_REQUEST['flagged']) ? $_REQUEST['flagged'] : '';
$answered = isset ($_REQUEST['answered']) ? $_REQUEST['answered'] : '';
$seen = isset($_REQUEST['seen']) ? $_REQUEST['seen'] : '';		
if ($task == 'set_search_query' || !isset ($_SESSION['email_search_query'])) {
	$_SESSION['email_search_query'] = $mail->build_search_query($subject, $from, $to, $cc, $body, $before, $since, $before, $since, $flagged, $answered, $seen);
}



if (!$account = $email->get_account($account_id)) {
	$account = $email->get_account(0);
}
if ($account) {
	if (!$mail->open($account['host'], $account['type'], $account['port'], $account['username'], $account['password'], $mailbox, 0, $account['use_ssl'], $account['novalidate_cert'])) {
		$GO_HEADER['body_arguments'] = 'onload="parent.treeview.location.href=\'treeview.php\';"';
		require($GO_THEME->theme_path.'header.inc');
		echo '<p class="Error">'.$ml_connect_failed.' \''.$account['host'].'\' '.$ml_at_port.': '.$account['port'].'</p>';
		echo '<p class="Error">'.imap_last_error().'</p>';
		require_once ($GO_THEME->theme_path.'footer.inc');
		exit ();
	}
} 

//check for the addressbook module
if (isset($GO_MODULES->modules['addressbook']) && $GO_MODULES->modules['addressbook']['read_permission'])
{
	require_once($GO_MODULES->modules['addressbook']['class_path'].'addressbook.class.inc');
	$ab = new addressbook();
}

$messages_display = '';

if(isset($_POST['form_action']) && $_POST['form_action'] == 'empty_trash')
{
		if($mailbox != '' && $mailbox==$account['trash'])
		{
			$mail->sort();
			if ($account['trash'] == '' || $mailbox == $account['trash'] || $account['type'] == 'pop3')
			{
				$mail->delete($mail->sort);
			}else
			{
				$messages = $mail->sort;
				$mail->set_message_flag($mailbox, $messages, "\\Seen");
				$mail->move($account['trash'], $messages);
			}
		}	
}
//when this is post request delete selected messages
if ($_SERVER['REQUEST_METHOD'] == "POST" && isset($_POST['messages']))
{
	switch ($_POST['form_action'])
	{	
		case 'delete':
			if ($mailbox == $account['trash'] || $account['type'] == 'pop3' || $account['trash'] == '')
			{			
				$mail->delete($_POST['messages']);					
			}else
			{
				$mail->set_message_flag($mailbox, $_POST['messages'], "\\Seen");
				$mail->move($account['trash'], $_POST['messages']);
			}
			if($account['type'] == 'pop3')	$mail->reopen($mailbox);
			
			$unseenStateChanged = true;
			break;

		case 'move':
			$mail->move(smart_stripslashes($_POST['folder']), $_POST['messages']);
			if($account['type'] == 'pop3')	$mail->reopen($mailbox);
			
			$unseenStateChanged = true;
			break;

		case 'set_flag':
			switch($_POST['flag'])
			{
				case 'read':
					$mail->set_message_flag($mailbox, $_POST['messages'], "\\Seen");
					$unseenStateChanged = true;
					break;

				case 'unread':
					$mail->set_message_flag($mailbox, $_POST['messages'], "\\Seen", "reset");
					$unseenStateChanged = true;
					break;

				case 'flag':
					$mail->set_message_flag($mailbox, $_POST['messages'], "\\Flagged");
					break;

				case 'clear_flag':
					$mail->set_message_flag($mailbox, $_POST['messages'], "\\Flagged", "reset");
					break;
			}
			break;
	}	
}

if (isset($_REQUEST['new_sort_order']) && $_REQUEST['new_sort_order'] != $em_settings['sort_order'])
{
	$email->set_sorting($GO_SECURITY->user_id, $_REQUEST['new_sort_field'], $_REQUEST['new_sort_order']);
	$em_settings['sort_field'] = $_REQUEST['new_sort_field'];
	$em_settings['sort_order'] = $_REQUEST['new_sort_order'];
}

if($mailbox == $account['sent'])
{
	$email_search_query = str_replace('FROM', 'TO', $_SESSION['email_search_query']);
}else
{
	$email_search_query = $_SESSION['email_search_query'];
}
$msg_count = $mail->sort($em_settings['sort_field'], $em_settings['sort_order'], $email_search_query);

if ($em_settings['sort_order'] == 1)
{
	$image_string = '<img src="'.$GO_THEME->images['arrow_down'].'" border="0" />';
	$new_sort_order=0;
}else
{
	$image_string = '<img src="'.$GO_THEME->images['arrow_up'].'" border="0" />';
	$new_sort_order=1;
}

/*
   show from address in normal mail folders and show to in sent items folders
 */
$show = "from";
$get_to_addresses = true;
if ($mail->is_imap() && $account['sent'] != '')
{
	if (strpos($mailbox, $account['sent']) === 0)
	{
		$show = "to";
	}
}

$unseen = 0;
if ($msg_count > 0)
{
	$mail->get_messages($first_row, $max_rows);

	$email_filter = array();
	$subject_filter = array();
	$filters = array();
	//if there are new messages get the filters

	$email->get_filters($account['id']);
	while ($email->next_record())
	{
		$filter["field"] = $email->f("field");
		$filter["folder"] = $email->f("folder");
		$filter["keyword"] = $email->f("keyword");
		$filters[] = $filter;
	}

	$mail->next_message_id = $first_row;
	$row_count = 0;
	while($mail->next_message($get_to_addresses))// && ($row_count < $max_rows || $max_rows == 0))
	{
		$row_count++;
		$continue = false;
		//check if message is new and apply users filters to new messages only in the inbox folder.
		if ($mail->f('new') == 1)
		{
			$unseen++;
			if (strtolower($mailbox) == "inbox")
			{
				for ($i=0;$i<sizeof($filters);$i++)
				{
					if ($filters[$i]["folder"])
					{
						$field = $mail->f($filters[$i]["field"]);
						if (!is_array($field))
						{
							if (stristr($field, $filters[$i]["keyword"]) !== false)
							{
								$messages[] = $mail->f("uid");
								if ($mail->move($filters[$i]["folder"], $messages))
								{
									$unseen--;
									$msg_count--;
									$continue = true;
									$refresh = true;
									break;
								}
							}
						}else
						{
							for ($x=0;$x<sizeof($field);$x++)
							{
								if (stristr($field[$x], $filters[$i]["keyword"]))
								{
									$messages[] = $mail->f("uid");
									if ($mail->move($filters[$i]["folder"], $messages))
									{
										$unseen--;
										$msg_count--;
										$continue = true;
										$refresh = true;
										break;
									}
								}
							}
						}
					}
				}
			}

			if ($continue)
			{
				continue;
			}

			$class = ' class="NewMail"';
			//$image = '<img src="'.$GO_THEME->images['newmail'].'" border="0" width="16" height="16" />';
			$image = '<img src="'.$GO_THEME->images['mail'].'" border="0" width="16" height="16" />';
		}else
		{
			if ($mail->f('answered'))
			{
				$image = '<img src="'.$GO_THEME->images['mail_repl'].'" border="0" width="16" height="16" />';
			}else
			{
				$image = '<img src="'.$GO_THEME->images['mail'].'" border="0" width="16" height="16" />';
			}
			$class='';
			/*if($mail->f('uid')==$uid)
			{
				$class = ' class="JustViewed"';
			}else
			{
				$class = '';
			}*/
		}

		/*
		   Disabled because of huge performance hit on large mailboxes

		   went from 3.5 sec to 0.8 sec to query a mailbox with 300 messages!

		   check if message has attachments
		   if ($mail->f("attachment"))
		   {
		   $attachment = '<img src="'.$GO_THEME->images['attach'].'" border="0" />';
		   }else
		   {
		   $attachment = '&nbsp;';
		   }

		   switch ($mail->f("priority"))
		   {
		   case "4":
		   $priority = '<img src="'.$GO_THEME->images['low_priority'].'" width="8" height="16" />';
		   break;

		   case "2":
		   $priority = '<img src="'.$GO_THEME->images['high_priority'].'" width="8" height="16" />';
		   break;

		   default:
		   $priority = '';
		   break;
		   }*/

		//display message
		$subject = $mail->f('subject') ? $mail->f('subject') : $ml_no_subject;
		$short_subject = cut_string($subject, 50);
		if ($show == "from")
		{
			$short_from = cut_string(enc_utf8($mail->f('from')), 40);
		}else
		{
			$to = '';
			$to_array = $mail->f("to");

			for ($i=0;$i<sizeof($to_array);$i++)
			{
				if ($i != 0)
				{
					$to .= ", ";
				}
				$to .= enc_utf8($to_array[$i]);
			}
			if ($to == "")
			{
				$to = $ml_no_reciepent;
			}
			$to = htmlspecialchars($to, ENT_QUOTES);
			$short_to = cut_string($to, 50);
		}
		if ($mail->f('flagged') == '1')
		{
			$flag = '<img src="'.$GO_THEME->images['flag'].'" border="0" width="16" height="16" />';
		}else
		{
			$flag = '&nbsp;';
		}

		if($account['drafts'] != '' && $mailbox == $account['drafts'])
		{
			$ondblClick = "javascript:popup('send.php?mail_from=".$account['id']."&uid=".$mail->f('uid')."&mailbox=".urlencode($mailbox)."&action=open','".$GO_CONFIG->composer_width."','".$GO_CONFIG->composer_height."');"; 		
		}else
		{
			$ondblClick = 'javascript:parent.toggle_navigation(false);';
		}
		
		$link = 'javascript:open_message(event, '.$mail->f('uid').');';
		
		$title = htmlspecialchars($mail->f('from')."&nbsp;&lt;".$mail->f("sender")."&gt;<br />".$subject);
		
		$messages_display .= '<tr'.$class.' id="row_'.$mail->f('uid').'" onclick="'.$link.'" '.$overlib->print_overlib($title, '', 'ol_width=300').' ondblclick="'.$ondblClick.'" style="cursor:default;">'.
			 //'<td nowrap><input id="checkbox_'.$mail->f('uid').'" type="checkbox" name="messages[]" value="'.$mail->f('uid').'" onclick="javascript:item_click(this);" /></td>'.
			 '<input style="display:none;" id="checkbox_'.$mail->f('uid').'" type="checkbox" name="messages[]" value="'.$mail->f('uid').'" />'.
		//'<td nowrap>'.$priority.'&nbsp;</td>'.
		
			 //'<td nowrap>'.$attachment.'&nbsp;</td>'.			 
			 '<td style="text-align:center">'.$image.'</td>';
		
		if ($show=="from")
		{
			if(isset($ab) && $contact = $ab->get_contact_by_email($mail->f("sender"), $GO_SECURITY->user_id))
			{
				$style=' style="color: #'.$contact['color'].';"';
			}else
			{
				$style = '';
			}
			$messages_display .= "<td".$style." nowrap>".$short_from."</td>";
		}else
		{
			$messages_display .= "<td nowrap>".$short_to."</td>";
		}
		
		$messages_display .= '<td width="10">'.$flag.'</td>';

		$messages_display .= "<td nowrap>".$short_subject."</td>".
			 '<td nowrap>'.format_size($mail->f('size')).'</td>'.
			 '<td nowrap>'.date($_SESSION['GO_SESSION']['date_format'].' '.$_SESSION['GO_SESSION']['time_format'], get_time($mail->f('udate'))).'</td>'.
			"</tr>\n";
		
		if(!$first_uid)
		{
			$first_uid = $mail->f('uid');
		}
	}
	$messages_display .= '<tr><td colspan="99" class="small" height="18">&nbsp;'.$msg_count.' '.$ml_messages.'&nbsp;&nbsp;&nbsp;';
	if ($mail->is_imap())
	{
		$messages_display .= '('.$unseen.' '.$ml_new.')';
	}

	$messages_display .= '</td></tr>';
}

if(isset($refresh))
{
	header('Location: '.$link_back);
	exit();
}
if ($msg_count == 0)
{
	$email_folder = $email->get_folder($account['id'], addslashes($mailbox));
	if ($email_folder['attributes']&LATT_NOSELECT)
	{
		$messages_display = '<tr><td colspan="99" height="18">'.$ml_no_mailbox.'</td></tr>';
	}else
	{
		$messages_display = '<tr><td colspan="99" height="18">'.$ml_no_messages.'</td></tr>';
	}	
}



$GO_HEADER['body_arguments'] = 'onload="initializeDocument();"';
$GO_HEADER['head'] = $overlib->get_header();
$GO_HEADER['head'] .= '<script type="text/javascript" src="'.$GO_MODULES->url.'email.js"></script>';
require($GO_THEME->theme_path.'header.inc');
?>
<form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" name="email_client">
<input type="hidden" name="empty_mailbox" />
<input type="hidden" name="link_back" value="<?php echo $link_back; ?>" />
<input type="hidden" name="account_id" value="<?php echo $account['id']; ?>" />


<input type="hidden" name="delete_message_uid" />

<input type="hidden" name="max_rows" value="<?php echo $max_rows; ?>" />
<input type="hidden" name="first_row" value="<?php echo $first_row; ?>" />
<input type="hidden" name="mailbox" value="<?php echo $mailbox; ?>" />
<input type="hidden" name="new_sort_field" value="<?php echo $em_settings['sort_field']; ?>" />
<input type="hidden" name="new_sort_order" value="<?php echo $em_settings['sort_order']; ?>" />
<input type="hidden" name="form_action" />
<?php
if ($_SESSION['email_search_query'] != '') {
	echo '<div class="headerTable" style="padding:2px;"><a href="'.$_SERVER['PHP_SELF'].'?account_id='.$account['id'].'&mailbox='.urlencode($mailbox).'&task=set_search_query"><img src="'.$GO_THEME->images['info'].'" border="0" align="middle" />&nbsp;'.$ml_search_active.'</a></div>';
}
?>
<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr>
	<td  nowrap>
	<h2>
	<?php
	if ($mailbox == $account['mbroot'] || $mailbox == 'INBOX') {
		echo $ml_inbox;
	}
	elseif ($account['mbroot'] != '') {
		echo str_replace($account['mbroot'], '', $mailbox);
	} else {
		echo $mailbox;
	}
	echo ' ('.$msg_count.' / '.$unseen.')';
	?>
	</h2>
	</td><td align="right">
	<?php	
	/*echo $msg_count." ".$ml_messages;
	if ($mail->is_imap())
	{
		echo "&nbsp;(".$unseen." ".$ml_new.")";
	}*/ 

	if ($account['type'] == "imap")
	{
		if ($email->get_subscribed($account['id']) > 0)
		{
			$dropbox = new dropbox();
			$dropbox->add_value('', $ml_move_mail);
			while ($email->next_record())
			{
				if (!($email->f('attributes')&LATT_NOSELECT) && $email->f('name') != $mailbox)
				{
					if($email->f('name') == 'INBOX')
					{
						$dropbox->add_value('INBOX',$ml_inbox);
					}else
					{					
						$dropbox->add_value($email->f('name'), str_replace('INBOX'.$email->f('delimiter'), '', $email->f('name')));
					}
				}
			}
			$dropbox->print_dropbox('folder','','onchange="javascript:move_mail()"');
		}

		$dropbox = new dropbox();
		$dropbox->add_value('', $ml_mark);
		$dropbox->add_value('read', $ml_markread);
		$dropbox->add_value('unread', $ml_markunread);
		$dropbox->add_value('flag', $ml_flag);
		$dropbox->add_value('clear_flag', $ml_clearflag);
		$dropbox->print_dropbox('flag', '', 'onchange="javascript:set_flag()"');
	}else
	{
		echo '&nbsp;';
	}

	?>
	</td>

</tr>
</table>

<table class="go_table" width="100%" style="-moz-user-select:none;">
<tr>

<th width="20" style="text-align:center"><input type="checkbox" name="dummy" onclick="javascript:select_all(this.checked);" /></th>
<?php
if ($show == "from")
{
	echo '<th><a href="javascript:sort('.SORTFROM.','.$new_sort_order.');">'.$ml_from;
	if ($em_settings['sort_field'] == SORTFROM)
	{
		echo '&nbsp;'.$image_string;
	}
	echo '</a></th>';
}else
{
	echo '<th><a href="javascript:sort('.SORTTO.','.$new_sort_order.');">'.$ml_to;
	if ($em_settings['sort_field'] == SORTTO)
	{
		echo '&nbsp;'.$image_string;
	}
	echo '</a></th>';
}
echo '<th width="16">&nbsp;</th>';
echo '<th><a href="javascript:sort('.SORTSUBJECT.','.$new_sort_order.');">'.$ml_subject;
if ($em_settings['sort_field'] == SORTSUBJECT)
{
	echo '&nbsp;'.$image_string;
}
echo '</a></th>';

echo '<th><a href="javascript:sort('.SORTSIZE.','.$new_sort_order.');">'.$ml_size;
if ($em_settings['sort_field'] == SORTSIZE)
{
	echo '&nbsp;'.$image_string;
}
echo '</a></th>';

echo '<th><a href="javascript:sort('.SORTDATE.','.$new_sort_order.');">'.$strDate;
if ($em_settings['sort_field'] == SORTDATE)
{
	echo '&nbsp;'.$image_string;
}
echo '</a></th></tr>';

echo $messages_display;

$links = '';
$max_links=10;
if ($max_rows != 0)
{
	if ($msg_count > $max_rows)
	{
		$links = '<table class="navLinks"><tr><td>';
		$next_start = $first_row+$max_rows;
		$previous_start = $first_row-$max_rows;
		if ($first_row != 0)
		{
			$links .= '<a href="javascript:change_page(0, '.$max_rows.');">&lt&lt</a>&nbsp;';
			$links .= '<a href="javascript:change_page('.$previous_start.', '.$max_rows.');">'.$cmdPrevious.'</a>&nbsp;';
		}else
		{
			$links .= '<font color="#cccccc">&lt&lt '.$cmdPrevious.'</font>&nbsp;';
		}

		$start = ($first_row-(($max_links/2)*$max_rows));

		$end = ($first_row+(($max_links/2)*$max_rows));

		if ($start < 0)
		{
			$end = $end - $start;
			$start=0;
		}
		if ($end > $msg_count)
		{
			$end = $msg_count;
		}

		if ($start > 0)
		{
			$links .= '...&nbsp;';
		}

		for ($i=$start;$i<$end;$i+=$max_rows)
		{
			$page = ($i/$max_rows)+1;
			if ($i==$first_row)
			{
				$links .= '<b><i>'.$page.'</i></b>&nbsp;';
			}else
			{
				$links .= '<a href="javascript:change_page('.$i.','.$max_rows.');">'.$page.'</a>&nbsp;';
			}
		}

		if ($end < $msg_count)
		{
			$links .= '...&nbsp;';
		}

		$last_page = floor($msg_count/$max_rows)*$max_rows;

		if ($msg_count > $next_start)
		{
			$links .= '<a href="javascript:change_page('.$next_start.', '.$max_rows.');">'.$cmdNext.'</a>&nbsp;';
			$links .= '<a href="javascript:change_page('.$last_page.', '.$max_rows.');">&gt&gt</a>';
		}else
		{
			$links .= '<font color="#cccccc">'.$cmdNext.' &gt&gt</font>';
		}
		$links .= '</td><td align="right"><a class="normal" href="javascript:change_page(0,0);">'.$cmdShowAll.'</a></td></tr></table>';
		echo '<tr><td colspan="99" height="20">'.$links.'</td></tr>';		
	}
}
echo '</table>';
?>

<script type="text/javascript">
	
	
function confirm_delete()
{
	var count = 0;

	for (var i=0;i<document.forms[0].elements.length;i++)
	{
		if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name != 'dummy')
		{
			if (document.forms[0].elements[i].checked == true)
			{
				count++;

			}
		}
	}
	switch (count)
	{
		case 0:
			alert("<?php echo $fbNoSelect; ?>");
			break;
			<?php
				$trash_folder = $account['trash'];
			if ($trash_folder == '' || $trash_folder == $mailbox)
			{
				echo '
				case 1:
					if (confirm("'.$strDeletePrefix.$ml_message.$strDeleteSuffix.'"))
					{
						parent.close_message_frame();

						document.forms[0].form_action.value=\'delete\';
						document.forms[0].submit();
					}
					break;

				default:
					if (confirm("'.$strDeletePrefix.$strThis.' "+count+" '.$ml_messages2.$strDeleteSuffix.'"))
					{
						parent.close_message_frame();
						document.forms[0].form_action.value=\'delete\';
						document.forms[0].submit();
					}
					break;
					';
			}else
			{
				echo '
				default:
					parent.close_message_frame();
					document.forms[0].form_action.value=\'delete\';
					document.forms[0].submit();
					break;
					';
			}
			?>
	}
}

function initializeDocument()
{

	//to capture shift keys in navigator 4.x
	if (window.Event) //if Navigator 4.X
	{
		document.captureEvents(Event.KEYPRESS)
	}
	
	//Firefox does this with CSS in the table
	//No text selection
	//With IE4+ the following works:
  if (document.all)
  {
    document.onselectstart = function () { return false; };
  }
  
  //Refresh treeview so that the mail checker doesn't alert about new mail the
	//user has already seen
	<?php 
	
	if($_SERVER['REQUEST_METHOD'] == 'GET')
	{
		$unseenStateChanged = true;
	}
	
	if(!isset($unseenStateChanged) ) echo 'if(parent.treeview.location == \'about:blank\'){'; 
	?>	
	parent.treeview.location.href='treeview.php';
	<?php 
	if(!isset($unseenStateChanged)) echo '}';	
	?>
	parent.update_toolbar(false);	
	parent.message.location.replace('blank.html');
	
}
var last_selected= 0;
var start_point = 0;

function open_message(evt, uid)
{		
	evt=evt||false;
	
	var ctrlPressed = (evt && evt.ctrlKey);
	var shiftPressed = (evt && evt.shiftKey);
	
	if(!ctrlPressed && !shiftPressed)
	{
		clear_selection();
	}
	
	var start_selection = false;	

	if(shiftPressed && last_selected > 0)
	{
		//undo last selection
		if(last_selected != start_point)
		{
			for (var i=0;i<document.forms[0].elements.length;i++)
			{
				if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name== 'messages[]')
				{
					if(start_selection)
					{			
						if(document.forms[0].elements[i].value != start_point)
						{
							document.forms[0].elements[i].checked = !document.forms[0].elements[i].checked;
							item_click(document.forms[0].elements[i]);
						}
						
						if(document.forms[0].elements[i].value == last_selected || document.forms[0].elements[i].value ==start_point)
						{
							start_selection = false;
							break;					
						}
					}else
					{
						if(document.forms[0].elements[i].value == last_selected || document.forms[0].elements[i].value ==start_point)
						{
							start_selection = true;
							if(document.forms[0].elements[i].value != start_point)
							{
								document.forms[0].elements[i].checked = !document.forms[0].elements[i].checked;
								item_click(document.forms[0].elements[i]);
							}
						}
					}	
				}
			}
		}
		for (var i=0;i<document.forms[0].elements.length;i++)
		{
			if(document.forms[0].elements[i].type == 'checkbox' && document.forms[0].elements[i].name== 'messages[]')
			{
				if(start_selection)
				{			
					if(document.forms[0].elements[i].value != start_point)
					{
						document.forms[0].elements[i].checked = !document.forms[0].elements[i].checked;
						item_click(document.forms[0].elements[i]);
					}
					
					if(document.forms[0].elements[i].value == uid || document.forms[0].elements[i].value ==start_point)
					{
						start_selection = false;
						break;					
					}
				}else
				{
					if(document.forms[0].elements[i].value == uid || document.forms[0].elements[i].value ==start_point)
					{
						start_selection = true;
						if(document.forms[0].elements[i].value != start_point)
						{
							document.forms[0].elements[i].checked = !document.forms[0].elements[i].checked;
							item_click(document.forms[0].elements[i]);
						}
					}
				}				
			}
		}
	}else
	{ 		
		var checkbox = get_object('checkbox_'+uid);
		checkbox.checked=!checkbox.checked;
		var row = get_object('row_'+uid);
		row.className='';
		item_click(checkbox);		
		start_point = uid;
	}	
	last_selected = uid;

	if(!ctrlPressed && !shiftPressed && (typeof(parent.message.document.forms[0]) == 'undefined' || parent.message.document.forms[0].uid.value!=uid))
	{			
		<?php 
		echo "parent.message.location.replace('message.php?account_id=".$account['id']."&uid='+uid+'&mailbox=".urlencode($mailbox)."&first_row=".$first_row."');";
		?>
	}	
}

function confirm_empty_trash(message)
{
	if(confirm(message))
	{
		document.forms[0].mailbox.value='<?php echo $account['trash']; ?>';
		document.forms[0].form_action.value='empty_trash';
		document.forms[0].submit();
	}
}
</script>
<?php
require($GO_THEME->theme_path.'footer.inc');
echo '</form>';
?>