<?php

/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once ("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');

require_once ($GO_CONFIG->class_path."mail/imap.class.inc");
require_once ($GO_MODULES->class_path."email.class.inc");
require_once ($GO_LANGUAGE->get_language_file('email'));
$mail = new imap();
$email = new email();

$em_settings = $email->get_settings($GO_SECURITY->user_id);

$account_id = isset ($_REQUEST['account_id']) ? $_REQUEST['account_id'] : 0;
$task = isset ($_REQUEST['task']) ? $_REQUEST['task'] : '';
$uid = isset ($_REQUEST['uid']) ? $_REQUEST['uid'] : 0;
$max_rows = isset ($_REQUEST['max_rows']) ? $_REQUEST['max_rows'] : $_SESSION['GO_SESSION']['max_rows_list'];
$first_row = (isset ($_REQUEST['first_row'])) ? $_REQUEST['first_row'] : 0;
//$table_tabindex = isset ($_REQUEST['table_tabindex']) ? $_REQUEST['table_tabindex'] : null;
$mailbox = isset ($_REQUEST['mailbox']) ? smart_stripslashes($_REQUEST['mailbox']) : 'INBOX';
$link_back = $GO_MODULES->url.'index.php?account_id='.$account_id.'&mailbox='.urlencode($mailbox).'&first_row='.$first_row;

if (!$account = $email->get_account($account_id)) {
	$account = $email->get_account(0);
}

if(!$account)
{
	header('Location: accounts.php?return_to='.urlencode($link_back));
	exit();
}elseif ($account['password'] == '') {
	//Password lost because of the removal of the insecure encryption
	//Redirect to enter password again.	
	header('Location: account.php?account_id='.$account['id'].'&return_to='.urlencode($link_back).'&feedback='.urlencode($ml_reenter_password));
	exit ();
}elseif ($account["user_id"] != $GO_SECURITY->user_id) {
	header('Location: '.$GO_CONFIG->host.'error_docs/403.php');
	exit ();
}


//search query parameters
$from = isset ($_REQUEST['from']) ? smart_stripslashes(trim($_REQUEST['from'])) : '';
$to = isset ($_REQUEST['to']) ? smart_stripslashes(trim($_REQUEST['to'])) : '';
$subject = isset ($_REQUEST['subject']) ? smart_stripslashes(trim($_REQUEST['subject'])) : '';
$cc = isset ($_REQUEST['cc']) ? smart_stripslashes(trim($_REQUEST['cc'])) : '';
$body = isset ($_REQUEST['body']) ? smart_stripslashes(trim($_REQUEST['body'])) : '';
$before = isset ($_REQUEST['before']) ? smart_stripslashes(trim($_REQUEST['before'])) : '';
$since = isset ($_REQUEST['since']) ? smart_stripslashes(trim($_REQUEST['since'])) : '';
$before = isset ($_REQUEST['before']) ? $_REQUEST['before'] : '';
$since = isset ($_REQUEST['since']) ? $_REQUEST['since'] : '';
$flagged = isset ($_REQUEST['flagged']) ? $_REQUEST['flagged'] : '';
$answered = isset ($_REQUEST['answered']) ? $_REQUEST['answered'] : '';
if ($task == 'set_search_query' || !isset ($_SESSION['email_search_query'])) {
	$_SESSION['email_search_query'] = $mail->build_search_query($subject, $from, $to, $cc, $body, $before, $since, $before, $since, $flagged, $answered);
}

$disable_accounts = ($GO_CONFIG->get_setting('em_disable_accounts') == 'true') ? true : false;

$page_title = $lang_modules['email'];

$GO_HEADER['head'] = '<script type="text/javascript" src="'.$GO_MODULES->url.'email.js"></script>';


require_once ($GO_THEME->theme_path."header.inc");
?>
<script type="text/javascript">
function search_messages()
{
	messages.location.href='search.php?account_id='+messages.document.forms[0].account_id.value+'&mailbox='+messages.document.forms[0].mailbox.value;	
}

function print_message()
{
	popup('message_body.php?account_id='+message.document.forms[0].account_id.value+'&uid='+message.document.forms[0].uid.value+'&mailbox='+message.document.forms[0].mailbox.value+'&print=true');
}

function composer(action)
{
	if(action != '')
	{
		popup('send.php?mail_from='+message.document.forms[0].account_id.value+'&uid='+message.document.forms[0].uid.value+'&mailbox='+message.document.forms[0].mailbox.value+'&action='+action,'<?php echo $GO_CONFIG->composer_width; ?>','<?php echo $GO_CONFIG->composer_height; ?>');
	}else
	{
		popup('send.php?mail_from='+messages.document.forms[0].account_id.value,'<?php echo $GO_CONFIG->composer_width; ?>','<?php echo $GO_CONFIG->composer_height; ?>');
	}
}
</script>

<table border="0" cellspacing="0" cellpadding="0" style="width:100%;height:100%;">
<tr>
		<td colspan="99" height="60">		
			<?php
			echo '<table border="0" cellspacing="0" cellpadding="0"><tr><td>';
			echo '<table border="0" cellspacing="0" cellpadding="0"><tr><td>';

			echo '<td class="ModuleIcons">';
			echo "<a href=\"javascript:composer('');\"><img src=\"".$GO_THEME->images['compose']."\" border=\"0\" height=\"32\" width=\"32\" /><br />".$ml_compose."</a></td>\n";		
			echo '<td class="ModuleIcons">';
			echo '<a href="javascript:search_messages();"><img src="'.$GO_THEME->images['ml_search'].'" border="0" height="32" width="32" /><br />'.$ml_search.'</a></td>';
			echo '<td class="ModuleIcons">';
			echo '<a href="'.$_SERVER['PHP_SELF'].'?account_id='.$account['id'].'&mailbox=INBOX"><img src="'.$GO_THEME->images['em_refresh'].'" border="0" height="32" width="32" /><br />'.$ml_refresh.'</a></td>';

						
			if (!$disable_accounts) {
				echo '<td class="ModuleIcons">';
				echo '<a href="accounts.php?return_to='.urlencode($link_back).'"><img src="'.$GO_THEME->images['accounts'].'" border="0" height="32" width="32" /><br />'.$ml_accounts.'</a></td>';
			} else {
				echo '<td class="ModuleIcons">';
				echo '<a href="account.php?account_id='.$account['id'].'&return_to='.urlencode($link_back).'"><img src="'.$GO_THEME->images['accounts'].'" border="0" height="32" width="32" /><br />'.$ml_edit_account.'</a></td>';
			}		
			if ($GO_MODULES->write_permission) {
				echo '<td class="ModuleIcons">';
				echo '<a href="configuration.php?return_to='.urlencode($link_back).'"><img src="'.$GO_THEME->images['em_settings_admin'].'" border="0" height="32" width="32" /><br />'.$menu_configuration.'</a></td>';
			}
			
			echo '<td class="ModuleIcons">';
			echo '<a href="javascript:window.messages.confirm_delete();"><img src="'.$GO_THEME->images['delete_big'].'" border="0" height="32" width="32" /><br />'.$ml_delete.'</a></td>';		
			
			echo '</td></tr></table>';	
			echo '</td><td id="messageButtons">';
			echo '<table border="0" cellspacing="0" cellpadding="0"><tr>';
			
			
			echo '<td class="ModuleIcons">';
			echo "<a href=\"javascript:composer('reply');\"><img src=\"".$GO_THEME->images['reply']."\" border=\"0\" height=\"32\" width=\"32\" /><br />".$ml_reply."</a></td>\n";
			echo '<td class="ModuleIcons">';
			echo "<a href=\"javascript:composer('reply_all');\"><img src=\"".$GO_THEME->images['reply_all']."\" border=\"0\" height=\"32\" width=\"32\" /><br />".$ml_reply_all."</a></td>\n";
			echo '<td class="ModuleIcons">';
			echo "<a href=\"javascript:composer('forward');\"><img src=\"".$GO_THEME->images['forward']."\" border=\"0\" height=\"32\" width=\"32\" /><br />".$ml_forward."</a></td>\n";
			echo '<td class="ModuleIcons">';
			echo "<a href=\"javascript:popup('properties.php?account_id='+message.document.forms[0].account_id.value+'&uid='+message.document.forms[0].uid.value+'&mailbox='+message.document.forms[0].mailbox.value,'450','500')\"><img src=\"".$GO_THEME->images['properties']."\" border=\"0\" height=\"32\" width=\"32\" /><br />".$fbProperties."</a></td>\n";
			
			echo '<td class="ModuleIcons">';
			echo '<a href="javascript:print_message();"><img src="'.$GO_THEME->images['print'].'" border="0" height="32" width="32" /><br />'.$ml_print.'</a></td>';
			
			echo '<td class="ModuleIcons" id="fsButton">';
			echo '<a href="javascript:close_message_frame();"><img src="'.$GO_THEME->images['close'].'" border="0" height="32" width="32" /><br />'.$cmdClose.'</a></td>';			
			
			echo '</tr></table>';
			echo '</td></tr></table>';			
			?>
	</td>
</tr>
<tr>
	<td id="treeview" style="width:230px;">
		<iframe id="treeviewFrame" marginheight="0" marginwidth="0" vspace="0" frameborder="0" style="width:230px;height:100%;" src="about:blank" name="treeview"></iframe>
	</td>
	<td style="width:100%;height:100%">
		<iframe marginheight="0" marginwidth="0" vspace="0" frameborder="0" height="50%" style="width:100%;height:50%;" src="messages.php?account_id=<?php echo $account['id']; ?>&mailbox=<?php echo urlencode($mailbox); ?>" name="messages" id="messages"></iframe>
		<br />
		<iframe marginheight="0" marginwidth="0" vspace="0" frameborder="0" height="50%" style="width:100%;height:50%;" src="blank.html" name="message" id="message"></iframe>
	</td>
</tr>
</table>
<?php
$mail->close();
require_once ($GO_THEME->theme_path."footer.inc");
?>