<?php
/*
Copyright Intermesh 2003
Author: Merijn Schering <mschering@intermesh.nl>
Version: 1.0 Release date: 08 July 2003

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.
*/

class email extends db
{
	var $last_error;
	var $mail;

	function get_accounts($user_id)
	{
		$sql = "SELECT * FROM emAccounts WHERE user_id='$user_id' ORDER BY standard DESC";
		$result = $this->query($sql);
		return $this->num_rows($result);
	}

	function set_sorting($user_id, $sort_field, $sort_order)
	{
		$sql = "UPDATE em_settings SET sort_field='$sort_field' , sort_order='$sort_order' WHERE user_id='$user_id'";
		return $this->query($sql);
	}

	function save_send_format($user_id, $send_format)
	{
		$sql = "UPDATE em_settings SET send_format='$send_format'  WHERE user_id='$user_id'";
		return $this->query($sql);
	}

	function update_settings($user_id, $send_format, $add_recievers, $add_senders, $request_notification)
	{
		$sql = "UPDATE em_settings SET add_recievers='$add_recievers', ".
		"add_senders='$add_senders', send_format='$send_format', ".
		"request_notification='$request_notification' WHERE user_id='$user_id'";
		return $this->query($sql);
	}

	function get_settings($user_id)
	{
		$this->query("SELECT * FROM em_settings WHERE user_id='$user_id'");
		if ($this->next_record())
		{
			return $this->Record;
		}else
		{
			$this->query("INSERT INTO em_settings (user_id, send_format, add_recievers, add_senders, request_notification) VALUES ('$user_id', 'text/HTML', '1', '1', '0')");
			return $this->get_settings($user_id);
		}
	}

	function add_account($user_id, $type, $host, $port, $use_ssl, $novalidate_cert, $mbroot, $username, $password, $name, $email, $signature, $sent, $trash, $drafts, $auto_check=0)
	{
		global $GO_CONFIG;

		require_once($GO_CONFIG->class_path."mail/imap.class.inc");

		$this->mail= new imap();
		if (!$this->mail->open($host, $type, $port, $username, $password, "INBOX", 0, $use_ssl, $novalidate_cert))
		{
			$this->last_error = "<p class=\"Error\">".imap_last_error()."</p>";
			return false;
		}else
		{
			if (!$mbroot = $this->mail->check_mbroot($mbroot))
			{
				$mbroot = '';
			}

			$account_id  = $this->nextid("emAccounts");
			if (!$account_id)
			{
				$this->last_error = "<p class=\"Error\">".$strSaveError."</p>";
				return false;
			}else
			{
				if ($this->get_accounts($user_id) == 0)
				{
					$default="1";
				}else
				{
					$default="0";
				}

				$sql  = "INSERT INTO emAccounts (id, user_id, type, host, port, use_ssl, novalidate_cert, mbroot, username, password, name, email, signature, standard, auto_check) ";
				$sql .= "VALUES ('$account_id', '$user_id', '$type', '$host', '$port', '$use_ssl', '$novalidate_cert', '$mbroot', '$username', '".$password."', '$name', '$email', '$signature','$default' , '$auto_check')";
				if(!$this->query($sql))
				{
					$this->last_error = "<p class=\"Error\">".$strSaveError."</p>";
					return false;
				}else
				{
					if ($type=='imap')
					{
						$mailboxes =  $this->mail->get_mailboxes($mbroot);
						$subscribed =  $this->mail->get_subscribed($mbroot);

						$this->synchronise($account_id, $subscribed, $mailboxes);

						$mailbox_names = array();
						while($mailbox = array_shift($mailboxes))
						{
							$mailbox_names[]=$mailbox['name'];
						}

						$sent = $sent == '' ? '' : $mbroot.$sent;
						$trash = $trash == '' ? '' : $mbroot.$trash;
						$drafts = $drafts == '' ? '' : $mbroot.$drafts;

						$subscribed_names = array();
						while($mailbox = array_shift($subscribed))
						{
							$subscribed_names[]=$mailbox['name'];
						}
						$trash_folder = '';
						if($this->_add_folder($trash, $mailbox_names, $subscribed_names))
						{
							$trash_folder = $trash;
						}
						$sent_folder = '';
						if($this->_add_folder($sent, $mailbox_names, $subscribed_names))
						{
							$sent_folder = $sent;
						}
						$drafts_folder = '';
						if($this->_add_folder($drafts, $mailbox_names, $subscribed_names))
						{
							$drafts_folder = $drafts;
						}

						//update the special folders
						$this->update_folders($account_id, $sent_folder,  $trash_folder, $drafts_folder);

						$mailboxes =  $this->mail->get_mailboxes($mbroot);
						$subscribed =  $this->mail->get_subscribed($mbroot);
						$this->synchronise($account_id, $mailboxes, $subscribed);
					}
					$this->mail->close();
					return $account_id;
				}
			}
		}
	}

	function disable_auto_check($account_id)
	{
		return $this->query("UPDATE emAccounts SET auto_check='0' WHERE id='$account_id'");
	}

	function update_account($account_id, $type, $host, $port, $use_ssl, $novalidate_cert, $mbroot, $username, $password, $name, $email, $signature, $sent, $trash, $drafts, $auto_check=0)
	{
		global $GO_CONFIG;

		require_once($GO_CONFIG->class_path."mail/imap.class.inc");
		$this->mail= new imap();

		if ($this->mail->open($host, $type, $port, $username, $password, "INBOX", 0, $use_ssl, $novalidate_cert))
		{
			if (!$mbroot = $this->mail->check_mbroot($mbroot))
			{
				$mbroot = '';
			}

			$sql  = "UPDATE emAccounts SET type='$type', host='$host', port='$port'".
			", use_ssl='$use_ssl', novalidate_cert='$novalidate_cert'".
			", mbroot='$mbroot', username='$username', password='".$password."',".
			" name='$name', email='$email'".
			", signature='$signature', auto_check='$auto_check' WHERE ".
			"id='$account_id'";

			if ($this->query($sql))
			{
				$mailboxes =  $this->mail->get_mailboxes($mbroot);
				$subscribed =  $this->mail->get_subscribed($mbroot);
				$this->synchronise($account_id, $subscribed, $mailboxes);

				$mailbox_names = array();
				while($mailbox = array_shift($mailboxes))
				{
					$mailbox_names[]=$mailbox['name'];
				}

				$subscribed_names = array();
				while($mailbox = array_shift($subscribed))
				{
					$subscribed_names[]=$mailbox['name'];
				}

				$sent = $sent == '' ? '' : $mbroot.$sent;
				$trash = $trash == '' ? '' : $mbroot.$trash;
				$drafts = $drafts == '' ? '' : $mbroot.$drafts;

				$trash_folder = '';
				if($this->_add_folder($trash, $mailbox_names, $subscribed_names))
				{
					$trash_folder = $trash;
				}
				$sent_folder = '';
				if($this->_add_folder($sent, $mailbox_names, $subscribed_names))
				{
					$sent_folder = $sent;
				}
				$drafts_folder = '';
				if($this->_add_folder($drafts, $mailbox_names, $subscribed_names))
				{
					$drafts_folder = $drafts;
				}

				//update the special folders
				$this->update_folders($account_id, $sent_folder, $trash_folder, $drafts_folder );

				$mailboxes =  $this->mail->get_mailboxes($mbroot);
				$subscribed =  $this->mail->get_subscribed($mbroot);
				$this->synchronise($account_id, $mailboxes, $subscribed);

				$this->mail->close();
			}
			return true;
		}
		return false;
	}

	function _add_folder($name, $mailbox_names, $subscribed_names)
	{
		if (!in_array($name, $mailbox_names))
		{
			return $this->mail->create_folder($name);
		}else
		{
			if (!in_array($name, $subscribed_names))
			{
				return $this->mail->subscribe($trash);
			}
			return true;
		}
		return false;
	}

	function update_password($host, $username, $password)
	{
		$sql = "UPDATE emAccounts SET password='".$password.
		"' WHERE username='$username' AND host='$host'";
		return $this->query($sql);
	}

	function update_folders($account_id, $sent, $trash, $drafts)
	{
		$sql = "UPDATE emAccounts SET sent='$sent', ".
		"trash='$trash',drafts='$drafts'  WHERE id='$account_id'";
		return $this->query($sql);
	}

	function get_account($id = 0)
	{
		if ($id == 0)
		{
			$sql = "SELECT * FROM emAccounts WHERE standard='1' AND user_id='".
			$_SESSION['GO_SESSION']['user_id']."'";
		}else
		{
			$sql = "SELECT * FROM emAccounts WHERE id='$id'";
		}

		$this->query($sql);
		if ($this->next_record())
		{
			return $this->Record;
		}else
		{
			return false;
		}
	}

	function is_default_account($id)
	{
		$sql = "SELECT * FROM emAccounts WHERE id='$id' AND standard='1'";
		$this->query($sql);
		if ($this->num_rows() == 1)
		{
			return true;
		}else
		{
			return false;
		}
	}

	function delete_account($user_id, $id)
	{
		$default = $this->is_default_account($id);

		$sql = "DELETE FROM emAccounts WHERE id='$id' AND user_id='$user_id'";
		if ($this->query($sql))
		{
			$sql = "DELETE FROM emFolders WHERE account_id='$id'";
			$this->query($sql);
			$sql = "DELETE FROM emFilters WHERE account_id='$id'";
			$this->query($sql);
		}
		if ($default)
		{
			$this->get_accounts($user_id);
			$this->next_record();
			$this->set_as_default($this->f("id"), $user_id);
		}
		return true;
	}

	function set_as_default($account_id, $user_id)
	{
		$sql = "UPDATE emAccounts SET standard='0' WHERE user_id='$user_id'".
		"AND standard='1'";
		$this->query($sql);
		$sql = "UPDATE emAccounts SET standard='1' WHERE id='$account_id'";
		$this->query($sql);
	}
	/*
	gets the subfolder of a folder id. Account id is only usefull for the root
	level where all folders have parent 0
	*/

	function get_subscribed($account_id, $folder_id=-1)
	{
		$sql = "SELECT * FROM emFolders WHERE account_id='$account_id'".
			  " AND (subscribed='1' OR name='INBOX')";

		if ($folder_id > -1)
		{
			$sql .= " AND parent_id='$folder_id'";
		}
		$sql .= " ORDER BY sort_order ASC, name ASC";

		$this->query($sql);
		return $this->num_rows();
	}
	
	function get_folders($account_id, $folder_id=-1)
	{
		$sql = "SELECT * FROM emFolders WHERE account_id='$account_id'";
		
		if ($folder_id > -1)
		{
			$sql .= " AND parent_id='$folder_id' ";
		}
		$sql .= "ORDER BY sort_order ASC, name ASC";

		$this->query($sql);
		return $this->num_rows();
	}
/*
	function get_all_folders($account_id, $subscribed_only=false)
	{
		if ($subscribed_only)
		{
			$sql = "SELECT * FROM emFolders WHERE account_id='$account_id' AND ".
			"subscribed='1' ORDER BY NAME ASC";
		}else
		{
			$sql = "SELECT * FROM emFolders WHERE account_id='$account_id' ORDER ".
			"BY NAME ASC";
		}
		$this->query($sql);
		return $this->num_rows();
	}

*/
	function add_folder($account_id, $name, $parent_id=0, $subscribed=1,
	$delimiter='/', $attributes=0, $sort_order=10)
	{
		$next_id = $this->nextid("emFolders");
		if ($next_id > 0)
		{
			$sql = "INSERT INTO emFolders (id, parent_id, account_id, subscribed, ".
			"name, attributes, delimiter, sort_order) VALUES ('$next_id', '$parent_id', ".
			"'$account_id', '$subscribed', '$name', ".
			"'$attributes', '$delimiter', '$sort_order')";
			if ($this->query($sql))
			{
				return $next_id;
			}
		}
		return false;
	}
	function rename_folder($account_id, $old_name, $new_name)
	{
		$sql = "UPDATE emFolders SET name='$new_name' WHERE".
		" name='".smart_addslashes($old_name)."' AND ".
		"account_id='$account_id'";

		$this->query($sql);
		$sql = "UPDATE emFilters SET folder='$new_name' ".
		"WHERE folder='$old_name' AND ".
		"account_id='$account_id'";
		$this->query($sql);

	}

	function update_folder($folder_id, $parent_id, $subscribed, $attributes, $sort_order=10)
	{
		$sql = "UPDATE emFolders SET subscribed='$subscribed', ".
		"parent_id='$parent_id', attributes='$attributes', sort_order='$sort_order' ".
		"WHERE id='$folder_id'";

		$this->query($sql);
	}

	function delete_folder($account_id, $name)
	{
		$sql = "DELETE FROM emFolders WHERE account_id='$account_id' ".
		"AND name='$name'";
		$this->query($sql);

		$sql = "DELETE FROM emFilters WHERE account_id='$account_id' ".
		"AND folder='$name'";
		$this->query($sql);
	}
	function folder_exists($account_id, $name)
	{
		$sql = "SELECT id FROM emFolders WHERE name='$name' AND ">
		"account_id='$account_id'";
		$this->query($sql);
		if ($this->next_record())
		{
			return $this->f("id");
		}else
		{
			return false;
		}
	}

	function get_folder($account_id, $name)
	{
		$sql = "SELECT * FROM emFolders WHERE name='$name' AND ".
		"account_id='$account_id'";
		$this->query($sql);
		if ($this->next_record())
		{
			return $this->Record;;
		}else
		{
			return false;
		}
	}

	function subscribe($account_id, $name)
	{
		return $this->query("UPDATE emFolders SET subscribed='1' ".
		"WHERE account_id='$account_id' AND name='$name'");
	}

	function unsubscribe($account_id, $name)
	{
		return $this->query("UPDATE emFolders SET subscribed='0' ".
		"WHERE account_id='$account_id' AND name='$name'");
	}

	/*
	Gets the parent_id from a folder path
	*/
	function get_parent_id($account_id, $path, $delimiter)
	{
		if ($pos = strrpos($path, $delimiter))
		{
			$parent_name = substr($path, 0, $pos);
			if ($parent_folder = $this->get_folder($account_id, $parent_name))
			{
				return $parent_folder['id'];
			}
		}else
		{
			return 0;
		}
		return false;

	}

	/*
	IMAP function to synchronise Group-Office folders with the IMAP server
	*/
	function synchronise($account_id,$mailboxes, $subscribed)
	{
		if($account = $this->get_account($account_id))
		{
			//add the subscribed folders into a searchable array
			$subscribed_names = array();
			$mailbox_names = array();
			while($mailbox = array_shift($subscribed))
			{
				$subscribed_names[]=$mailbox['name'];
			}
			//Add all missing folders to Group-Office
			while($mailbox = array_shift($mailboxes))
			{
				$mailbox_names[] = $mailbox['name'];
				$parent_id = $this->get_parent_id($account_id, addslashes($mailbox['name']),
				$mailbox['delimiter']);
	
				$used = in_array($mailbox['name'], $subscribed_names);
				$attributes = $mailbox['attributes'];				
				
				if($mailbox['name'] == 'INBOX')
				{
					$sort_order = 0;
				}elseif($mailbox['name'] == $account['sent'])
				{
					$sort_order = 1;
				}elseif($mailbox['name'] == $account['drafts'])
				{
					$sort_order = 2;
				}elseif($mailbox['name'] == $account['trash'])
				{
					$sort_order = 3;
				}else
				{
					$sort_order = 10;
				}				
				
				if ($this->get_folder($account_id,addslashes($mailbox['name'])))
				{
					/*if ($this->f('subscribed') != $used ||
					$this->f('parent_id') != $parent_id ||
					$this->f('attributes') != $attributes)
					{*/
						$this->update_folder($this->f('id'),$parent_id, $used, $attributes, $sort_order);
					//}
				}else
				{
					$this->add_folder($account_id, addslashes($mailbox['name']),$parent_id,
					$used, $mailbox['delimiter'], $mailbox['attributes'], $sort_order);
				}
			}
		}

		/*
		get all the Group-Office folders and delete the folders that no longer
		exist on the IMAP server
		*/

		$this->get_folders($account_id);
		$GO_mailboxes = array();
		$emailobj = new email();
		while ($this->next_record())
		{
			if (!in_array($this->f('name'), $mailbox_names))
			{
				$emailobj->delete_folder($account_id, addslashes($this->f('name')));
			}
		}
	}

	function get_filters($account_id)
	{
		$sql = "SELECT * FROM emFilters WHERE account_id='$account_id' ".
		"ORDER BY priority DESC";
		$this->query($sql);
		return $this->num_rows();
	}

	function add_filter($account_id, $field, $keyword, $folder)
	{
		$next_id = $this->nextid("emFilters");
		if ($next_id > 0)
		{
			$sql = "INSERT INTO emFilters (id, account_id, field, keyword, ".
			"folder, priority) VALUES ('$next_id','$account_id','$field',".
			"'$keyword','$folder','$next_id')";

			return $this->query($sql);
		}else
		{
			return false;
		}
	}

	function get_filter($filter_id)
	{
		$sql = "SELECT * FROM emFilters WHERE id='$filter_id'";
		$this->query($sql);
		if ($this->next_record())
		{
			return $this->Record;
		}else
		{
			return false;
		}
	}

	function update_filter($filter_id, $field, $keyword, $folder)
	{
		$sql = "UPDATE emFilters SET field='$field', keyword='$keyword', folder='$folder' WHERE id='$filter_id'";
		$this->query($sql);
	}

	function delete_filter($id)
	{
		$sql = "DELETE FROM emFilters WHERE id='$id'";
		$this->query($sql);
	}

	function move_up($move_up_id, $move_dn_id, $move_up_pr, $move_dn_pr)
	{
		if ($move_up_pr == $move_dn_pr)
		$move_up_pr++;

		$sql = "UPDATE emFilters SET priority='$move_up_pr' WHERE id='$move_up_id'";
		$this->query($sql);

		$sql = "UPDATE emFilters SET priority='$move_dn_pr' WHERE id='$move_dn_id'";
		$this->query($sql);
	}

	function delete_user($user_id)
	{
		$del = new email;
		$this->get_accounts($user_id);
		while ($this->next_record())
		{
			$del->delete_account($user_id,$this->f("id"));
		}
		$this->query("DELETE FROM em_settings WHERE user_id='$user_id'");
	}

	function register_attachment($tmp_file, $filename, $filesize, $filemime='',
	$disposition='attachment', $content_id='')
	{
		global $GO_CONFIG;

		$filename = smart_addslashes($filename);
		$tmp_file = smart_addslashes($tmp_file);

		$attachment->file_name = $filename;
		$attachment->tmp_file =  $tmp_file;
		$attachment->file_size = $filesize;
		$attachment->file_mime = $filemime;
		$attachment->disposition = $disposition;
		$attachment->content_id = $content_id;

		$_SESSION['attach_array'][] = $attachment;
	}
	
	function get_zip_of_attachments($account_id, $uid)
	{
		global $GO_CONFIG;
		
		$tmpdir = $GO_CONFIG->tmpdir.uniqid(time());
		if(!mkdir($tmpdir))
		{
			return false;
		}

		$account = $this->get_account($account_id);
		
		$imap = new imap();
		if(!$imap->open($account['host'], 
												$account['type'], 
												$account['port'], 
												$account['username'], 
												$account['password'], 
												'', 
												0, 
												$account['use_ssl'],
												$account['novalidate_cert']))
			{
				return false;
			}
			
			if(!$message = $imap->get_message($uid))
			{
				return false;
			}
			
			for ($i = 0; $i < count($message['parts']); $i ++) {
				if (eregi("ATTACHMENT", $message['parts'][$i]["disposition"])  || 
						eregi("INLINE", $message['parts'][$i]["disposition"]) || 
						$message['parts'][$i]["name"] != ''){
							
							$filename = $tmpdir.'/'.$message['parts'][$i]["name"];
							$x=0;
							while(file_exists($filename))
							{
								$x++;
								$filename .= strip_extenension($filename).' ('.$x.').'.get_extension($filename);
							}
							if(!$fp = fopen($tmpdir.'/'.$message['parts'][$i]["name"],'w+'))
							{
								return false;
							}
							if(!fwrite($fp, $imap->view_part($uid, $message['parts'][$i]["number"], $message['parts'][$i]["transfer"])))
							{
								return false;
							}
							fclose($fp);
				}					
			}
			chdir($tmpdir);
			exec($GO_CONFIG->cmd_zip.' -r "attachments.zip" *.*');
			$data = file_get_contents(	$tmpdir.'/attachments.zip');
			exec('rm -Rf '.$tmpdir);
			return $data;
	}
}
?>
