<?php
/*
   Copyright Intermesh 2003
   Author: Merijn Schering <mschering@intermesh.nl>
   Version: 1.0 Release date: 08 July 2003

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.
 */

require_once("../../Group-Office.php");

$GO_SECURITY->authenticate();
$GO_MODULES->authenticate('email');

require_once($GO_CONFIG->class_path."mail/imap.class.inc");
require_once($GO_MODULES->class_path."email.class.inc");
require_once($GO_LANGUAGE->get_language_file('email'));
$mail = new imap();
$email = new email();

$task = isset($_REQUEST['task']) ? $_REQUEST['task'] : '';

$em_settings = $email->get_settings($GO_SECURITY->user_id);

switch($task)
{
		case 'delete':
		// Rebuilding the attachments array with only the files the user wants to keep
		$tmp_array = array();
		for ($i=$j=0;$i<count($_SESSION['attach_array']);$i++)
		{
			if (empty($_POST['delete_attachment'][$i]))
			{
				$tmp_array[$j]->file_name = $_SESSION['attach_array'][$i]->file_name;
				$tmp_array[$j]->tmp_file = $_SESSION['attach_array'][$i]->tmp_file;
				$tmp_array[$j]->file_size = $_SESSION['attach_array'][$i]->file_size;
				$tmp_array[$j]->file_mime = $_SESSION['attach_array'][$i]->file_mime;
				$tmp_array[$j]->content_id = $_SESSION['attach_array'][$i]->content_id;
				$tmp_array[$j]->disposition = $_SESSION['attach_array'][$i]->disposition;
				$j++;
			}else
			{
				@unlink($_SESSION['attach_array'][$i]->tmp_file);
			}
		}

		// Removing the attachments array from the current session
		$_SESSION['attach_array'] = $tmp_array;
		break;
		
		case 'add':
		//Adding the new file to the array
		for ($n = 0; $n < count($_FILES['file']['tmp_name']); $n ++) 
		{
			if (is_uploaded_file($_FILES['file']['tmp_name'][$n]))
			{
				$attachments_size = 0;
				// Counting the attachments number in the array
				if (isset($_SESSION['attach_array']))
				{
					for($i=1;$i<count($_SESSION['attach_array']);$i++)
					{
						$attachments_size += $_SESSION['attach_array'][$i]->file_size;
					}
				}
				$attachments_size += $_FILES['file']['size'][$n];
				if ($attachments_size < $GO_CONFIG->max_attachment_size)
				{
					$tmp_file = $GO_CONFIG->tmpdir.md5(uniqid(time()));
					move_uploaded_file($_FILES['file']['tmp_name'][$n], $tmp_file);
					$email->register_attachment($tmp_file, $_FILES['file']['name'][$n], $_FILES['file']['size'][$n], $_FILES['file']['type'][$n]);
				}else
				{
					$feedback =  '<p class="Error">1'.$ml_file_too_big.
						format_size($GO_CONFIG->max_attachment_size).' ('.
						number_format($GO_CONFIG->max_attachment_size, 0, 
						$_SESSION['GO_SESSION']['decimal_seperator'], 
						$_SESSION['GO_SESSION']['thousands_seperator']).' bytes)</p>';
					$task = 'local_files';
				}
			}
		}
		break;
}


require_once($GO_THEME->theme_path."header.inc");
?>

<script type="text/javascript">
<!--
function delete_attachment()
{
	document.attachments_form.task.value='delete';
	document.attachments_form.submit();
}

function upload()
{
	var status = null;
	if (status = get_object("status"))
	{
		status.innerHTML = "<?php echo $ml_please_wait; ?>";
	}
	document.attachments_form.task.value='add';
	document.forms[0].submit();
}

function set_attachments_text(text)
{
	var attachTextDiv = opener.document.getElementById('attachments_text');
	attachTextDiv.innerHTML=text;
}
-->
</script>
<?php

if($task != 'local_files')
{
	?>
	<h1><?php echo $ml_attachments; ?></h1>
	<table border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td class="ModuleIcons">
		<a href="<?php echo $_SERVER['PHP_SELF']; ?>?task=local_files"><img src="<?php echo $GO_THEME->images['ml_local_files']; ?>" border="0" height="32" width="32" /><br /><?php echo $ml_local_files; ?></a></td>
		<?php
		if (isset($GO_MODULES->modules['filesystem']) && $GO_MODULES->modules['filesystem']['read_permission'])
		{
		?>
		<td class="ModuleIcons">
		<a href="javascript:popup('select_file.php','600','400');"><img src="<?php echo $GO_THEME->images['filesystem']; ?>" border="0" height="32" width="32" /><br /><?php echo $ml_online_files; ?></a></td>
		<?php
		}
		?>
	</tr>
	</table>
	<?php
	echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" name="attachments_form">';
	echo '<input type="hidden" name="task" value="viewing" />';

	$tooltip = '';
	$totalsize = 0;
	$count = 0;
	echo '<table class="go_table" width="100%">'.
			'<tr><th>'.$strName.'</th>'.
			'<th>'.$ml_type.'</th>'.
			'<th>'.$ml_size.'</th></tr>';
			
	if (isset($_SESSION['attach_array']) && count($_SESSION['attach_array']) > 0)
	{  
	  for ($i=0;$i<count($_SESSION['attach_array']);$i++)
	  {
	    if ($_SESSION['attach_array'][$i]->disposition == 'attachment')
	    {
	      $count++;
	      $totalsize += $_SESSION['attach_array'][$i]->file_size;
	      
	      $extension = get_extension($_SESSION['attach_array'][$i]->file_name);
	      echo '<tr><td><input type="checkbox" name="delete_attachment['.$i.']" />'.
	      		'<img border="0" width="16" height="16" src="'.get_filetype_image($extension).'" align="absmiddle" />'.
	      		'&nbsp;'.$_SESSION['attach_array'][$i]->file_name.'</td>'.
	      		'<td>'.get_filetype_description($extension).'</td>'.
	      		'<td>'.format_size($_SESSION['attach_array'][$i]->file_size).'</td></tr>';
	      
	      $tooltip .= '<div><img border="0" width="16" height="16" src="'.get_filetype_image($extension).'" align="middle" />'.
	      		'&nbsp;'.$_SESSION['attach_array'][$i]->file_name.'</div>';
	      		
	    }else
	    {
	    	echo '<input type="hidden" name="delete_attachment['.$i.']" />';
	    }
	  }
	}
	if ($count > 0)
	{
		echo '<tr><td>';
		$button = new button($cmdDelete, 'javascript:delete_attachment()');
		echo '</td><td colspan="2" align="right">'.$ml_total_size.' : '.format_size($totalsize).'</td></tr>';
	}else
	{
		echo '<tr><td colspan="3">'.$ml_no_attachments.'</td></tr>';
	}
	  
	echo '</table>';
	echo '</form>';
	
	$text = '';
	if($tooltip != '')
	{
		$overlib = new overlib();	
		$text = addslashes('<a href="javascript:open_attachments();" '.$overlib->print_overlib(htmlspecialchars($tooltip), $ml_attachments).'>');
	}
	
	if($count == 1)
	{
		$text .=  '1 '.$ml_attachment_added;
	}else
	{
		$text .=  $count.' '.$ml_attachments_added;
	}
	if($tooltip != '')
	{	
		$text .= '</a>';
	}
	
	echo '<script type="text/javascript">set_attachments_text("'.$text.'");</script>';
}else
{
	echo '<form method="post" action="'.$_SERVER['PHP_SELF'].'" name="attachments_form" enctype="multipart/form-data">';
	echo '<input type="hidden" name="task" />';
	?>
	<h1><?php echo $ml_local_files; ?></h1>
	<table border="0" cellpadding="4" cellspacing="0">
	<?php if(isset($feedback)) echo '<tr><td>'.$feedback.'</td></tr>';
	?>
	<tr>
		<td>
		<?php echo $ml_select; ?>:<br />
		<input type="file" name="file[]" class="textbox" size="50" /><?php 
		$button = new button($ml_multiple_files , 'javascript:openPopup(\'upload\',\''.
			$GO_CONFIG->control_url.'JUpload/jupload.php?post_url='.
			urlencode($GO_MODULES->full_url.'upload.php?sid='.session_id()).'\',\'640\',\'400\');', '120');
		?><br />
		<input type="file" name="file[]" class="textbox" size="50" /><br />
		<input type="file" name="file[]" class="textbox" size="50" /><br />
		<input type="file" name="file[]" class="textbox" size="50" /><br />
		<input type="file" name="file[]" class="textbox" size="50" />		
		
		</td>
	</tr>
	<tr>
		<td>
		<?php
		echo $ml_max_attachment_size.": ".format_size($GO_CONFIG->max_attachment_size).
			" (".number_format($GO_CONFIG->max_file_size, 0,
				 $_SESSION['GO_SESSION']['decimal_seperator'], 
				 $_SESSION['GO_SESSION']['thousands_seperator'])." bytes)";
		?>
		</td>
</tr>
<tr>
	<td id="status" class="Success">&nbsp;</td>
</tr>
<tr>
	<td>
		<br />
		<?php
		$button = new button($cmdOk, "javascript:upload()");
		echo '&nbsp;&nbsp;';
		$button = new button($cmdCancel, "javascript:document.location='".$_SERVER['PHP_SELF']."';");
		?>
		</td>
</tr>
</table>
<?php
	echo '</form>';
}

require_once($GO_THEME->theme_path."footer.inc");
?>
